# 三國演義：誰都幹了哪些事兒？

金庸先生的笑傲江湖裡有一段是這樣的…

```
林平之叫道：『我爹娘是給青城派余滄海與木高峰害死的，跟我師父有甚么相干？我是堂堂華山派門徒，豈能臨到危難，便貪生怕死？』

梁發叫道：『說得好！我華山派……』一個蒙面人喝道：『你華山派便怎樣？』橫揮一刀，將梁發的腦袋砍了下來，鮮血直噴。」
```  

這不禁讓人思考起「梁發」這個角色，除了「叫道」以外，究竟有沒有做過別的事呢？還是說…這個角色在故事裡就只做了「叫道」這件事呢？

類似的角色，梁發不是第一位。在三國演義裡，也有這麼一位「潘鳳」將軍。故事是這樣的…

```
太守韓馥曰：「吾有上將潘鳳，可斬華雄。」紹急令出戰。潘鳳手提大斧上馬。去不多時，飛馬來報：「潘鳳又被華雄斬了。」
```
是的，潘鳳只做了兩件事「提」和「上馬」，然後他就死掉了！

這下可引起我的興趣了！在三國演義裡，每個人究竟出場了幾次，出場的時候又都做了哪些事呢？

想瞭解這個問題，利用  Articut 就對了！

ArticutAPI 的回傳結果裡，有三種格式。  
#### 第一種是帶著詞性標記的 **`result_pos`**：
```
['<UserDefined>趙雲</UserDefined><VerbP>聽了</VerbP>', '，', '<FUNC_inner>連</FUNC_inner><ACTION_verb>忙</ACTION_verb><ACTION_verb>追尋</ACTION_verb>...
```
#### 第二種是單純用斜線把詞彙切開的 **`result_segmentation`**：
```
'趙雲/聽了/，/連/忙/追尋/...
```
#### 最後一種，就是今天的主角：把每個詞彙當成一個物件的 **`result_obj`** 了！
```
[{'text': '趙雲', 'pos': 'UserDefined'}, {'text': '聽了', 'pos': 'VerbP'}], [{'text': '，', 'pos': 'PUNCTUATION'}], [{'text': '連', 'pos': 'FUNC_inner'}, {'text': '忙', 'pos': 'ACTION_verb'}, {'text': '追尋', 'pos': 'ACTION_verb'}]
```
本次的 Demo 程式，就是利用 **`result_obj`** 配合在 [Public_UserDefinedDict](https://github.com/Droidtown/ArticutAPI/blob/master/Public_UserDefinedDict/KNOWLEDGE_%E4%B8%89%E5%9C%8B%E4%BA%BA%E7%89%A9.json) 裡釋出的「三國人物字典」來操作。

![Demo Text](https://64.media.tumblr.com/fc61f3ff32828d9e12883a8ae2482989/f488dd2c76f7c846-0f/s500x750/ca8f5b98619781663e05eeaf9401b18e6b66ccbb.png)

程式目標是把「趙雲」以及在「同一句裡出現趙雲以及他做的動作」擷取出來。

程式分成兩大區塊。第一個區塊先把三國演義中常常使用的「用名字的一個字，來指稱前面提過的某人」 ，利用三國人物字典將它還原成「全名」。例如以「雲」表示剛剛提過的「趙雲」，用「琮」代指前文裡的「劉琮」…等等的「雲」和「琮」就要被還原成「趙雲」和「劉琮」。

第二個區塊，則是計算「在這個人名出現後，下一個名詞出現前。他究竟做過哪些動作」。動作在 Articut 的標記系統裡只有三種，一是 ACTION_verb，一是 ACTION_quantifiedVerb 以及 VerbP。

兩個區塊都做完以後，就直接利用 append 加入一個字典中的列表裡做為輸出結果囉。
