<div align="center">
  <picture>
  <source media="(prefers-color-scheme: dark)" srcset="https://github.com/Drackass/Drackass/blob/main/icon-light.png">
  <source media="(prefers-color-scheme: light)" srcset="https://github.com/Drackass/Drackass/blob/main/icon-dark.png">
  <img alt="Main Banner" src="https://github.com/Drackass/Drackass/blob/main/icon-light.png" width="100px">
  </picture>
</div>

# 📊 DataBase Administration Software

> **Warning**
> This README.md file and this project are still under development.

<picture>
  <source media="(prefers-color-scheme: dark)" srcset="https://github.com/Drackass/Drackass/blob/main/banner-dark.png">
  <source media="(prefers-color-scheme: light)" srcset="https://github.com/Drackass/Drackass/blob/main/banner-light.png">
  <img alt="Main Banner" src="https://github.com/Drackass/Drackass/blob/main/banner-dark.png">
</picture>
</br>
</br>

[![Stars](https://img.shields.io/github/stars/Drackass/DB-Administration-Software?style=social)](https://github.com/Drackass/DB-Administration-Software/stargazers)
[![Fork](https://img.shields.io/github/forks/Drackass/DB-Administration-Software?style=social)](https://github.com/Drackass/DB-Administration-Software/network/members)
[![Watchers](https://img.shields.io/github/watchers/Drackass/DB-Administration-Software?style=social)](https://github.com/Drackass/DB-Administration-Software/watchers)
[![Licence](https://img.shields.io/github/license/Drackass/DB-Administration-Software?style=social)](https://github.com/Drackass/DB-Administration-Software/blob/main/LICENSE)
[![Taille du dépôt](https://img.shields.io/github/repo-size/Drackass/DB-Administration-Software?style=social)](https://github.com/Drackass/DB-Administration-Software)

📊 This repository is made to contain a Database administration software coded in C# with a modern and professional design. 

<div align="center">
  <img alt="Main Banner" src="https://github.com/Drackass/DB-Administration-Software/blob/main/ForGithub/home.png" width="400px">
  <img alt="Main Banner" src="https://github.com/Drackass/DB-Administration-Software/blob/main/ForGithub/admin-panel.png" width="400px">
</div>

# 📚 Table of contents
<details>
<summary><h2>📕 Introduction</h2></summary>
<br/>

> ### 🔎 Sub-summary
> 1. [Project presentation](#-project-presentation)
> 2. [Technologies](#-technologies)
> 3. [The project's aim](#-the-projects-aim)
>    
> <br/>
>
> ### 📌 Project presentation
>
> A database administration software coded in C#.net still in development adapted and improved from a school project coded in VB.Net. it includes an intuitive and ergonomic Navigation, whether on its design thought to be adaptable and customizable, the implementation of drop-down menus, a place reserved for the logo or even on its modern and professional color palette all this with a certain quality of the man-machine interface. It allows a simplified management of additions, modification, deletion and visualization of data according to the rights allowed by the connected user. Input controls are total and operational, an advanced search of tables and the complete database and also implement as well as the Generation of a pdf of an automatic data summary for each table The project respects a good number of good practices whether for naming, factorization, regions, comments, the use of store procedures and triggers, storage and the creation of a class library (dll) allowing exchange with database data.
> 
> ### 📌 Technologies
> 
>[![Windows](https://img.shields.io/badge/Windows-00afef?style=for-the-badge&logo=windows&logoColor=white&labelColor=00afef)](https://docs.microsoft.com/en-us/windows/)
>
>[![C#](https://img.shields.io/badge/C%23-058c0b?style=for-the-badge&logo=c-sharp&logoColor=white&labelColor=058c0b)](https://docs.microsoft.com/en-us/dotnet/csharp/)
>
>[![Wamp](https://img.shields.io/badge/Wamp-f70094?style=for-the-badge&logo=webflow&logoColor=white&labelColor=f70094)](https://www.wampserver.com/en/)
>
>[![HeidiSQL](https://img.shields.io/badge/HeidiSQL-328400?style=for-the-badge&labelColor=328400)](https://www.heidisql.com/help.php)
>
>[![Visual Studio](https://img.shields.io/badge/Visual%20Studio-662e93?style=for-the-badge&logo=visual%20studio&logoColor=white&labelColor=662e93)](https://docs.microsoft.com/en-us/visualstudio/)
>
>[![.NET Framework](https://img.shields.io/badge/.NET%20Framework-5027d5?style=for-the-badge&logo=.net&logoColor=white&labelColor=5027d5)](https://docs.microsoft.com/en-us/dotnet/framework/)
>
>[![SQL](https://img.shields.io/badge/SQL-3199da?style=for-the-badge&logoColor=white&labelColor=3199da)](https://www.w3schools.com/sql/)
>
> ### 📌 The project's aim
> 
> this software aims to have an operation and an autonomous interface according to the database connected to it while keeping a complete practice taking into account the different parameters and functions of a classic database administration software like the management of functions, stored procedure, trigger, etc . . .

</details>

<details>
<summary><h2>📗 Setup and Usage</h2></summary>
<br/>

> ### 🔎 Sub-summary
> 1. [Prerequisites](#-prerequisites)
> 2. [Installation](#-installation)
> 3. [Configuration](#-configuration)
>    
> <br/>
>
> ### 📌 Prerequisites
> 
>[![Windows](https://img.shields.io/badge/Windows-00afef?style=for-the-badge&logo=windows&logoColor=white&labelColor=00afef)](https://docs.microsoft.com/en-us/windows/)
>
>[![Wamp](https://img.shields.io/badge/Wamp-f70094?style=for-the-badge&logo=webflow&logoColor=white&labelColor=f70094)](https://www.wampserver.com/en/)
>
>[![HeidiSQL](https://img.shields.io/badge/HeidiSQL-328400?style=for-the-badge&labelColor=328400)](https://www.heidisql.com/help.php)
>
>[![Visual Studio](https://img.shields.io/badge/Visual%20Studio-662e93?style=for-the-badge&logo=visual%20studio&logoColor=white&labelColor=662e93)](https://docs.microsoft.com/en-us/visualstudio/)
>
> ### 📌 Installation
>
> 1. Start **WampServer** environment.
> 2. import the `DataBase.sql` database into your database administration software. (*HeidiSQL*)
> 3. Launch the software in **Visual Studio**.
>
> | Home Page |
> |:---:|
> | <img alt="home" src="https://github.com/Drackass/DB-Administration-Software/blob/main/ForGithub/home.png" width="1000px"> |

>  **Note**
> If you encounter the `Mark of the Web` error, which is a common error on **visual studio**, please follow these instructions :
> 1. Right-click on the FrmMain.resx file in Visual Studio's Solution Explorer.
> 2. Select Properties.
> 3. In the properties, look for the "Security" or "General" section.If you see an "Unblock" option or something similar, click on it to unblock the file.
> 4. Save the changes and try rebuilding your project to see if the error persists.

> ### 📌 Configuration
> 
> You can modify the file `FrmConnexion.cs` to automatically fill in the login information in the form.
> 
 ```csharp
        private void btnPreSet_Click(object sender, EventArgs e)
        {
            tbServeur.Text = "server";
            tbBase.Text = "DataBase";
            tbId.Text = "id";
            tbMDP.Text = "password";
        }

```
>
> | Login Page |
> |:---:|
> | <img alt="log" src="https://github.com/Drackass/DB-Administration-Software/blob/main/ForGithub/log.png" width="1000px"> |
> 

</details>

<details>
<summary><h2>📘 Scope of functionalities</h2></summary>
<br/>

> | functionalities | State | Description | 
> |:---| :---:|:---|
> | Intuitive navigation / Menus / Design / Consistency, HMI quality, professional appearance   | ✅ | - |
> | Add/Modify/Delete form(s) for a selected table   | ✅ | - |
> | Operational total input controls (regular expressions, errorProvider, etc.)   | ✅ | - |
> | Advanced tuple search (e.g. customer or product)   | ✅ | - |
> | Operational and ergonomic order management   | ✅ | - |
> | Generate pdf order summary   | ✅ | - |
> | Best naming and storage practices   | ✅ | - |
> | Code factoring (getLesTuples, executerRequeteSelect, etc.)   | ✅ | - |
> | Input control code (use of regexes, etc.)   | ✅ | - |
> | calling up a STORED PROCEDURE set up for CONSULTATION   | ✅ | - |
> | call (application side) and code of parameterized procedure   | ✅ | - |
> | call a STORED PROCEDURE set to ACTION   | ✅ | - |
> | call a parameterized STORED FUNCTION   | ✅ | - |
> | automatic TRIGGER call   | ✅ | - |
> | Multi-connection mode with multiple users and associated MySql rights   | ✅ | - |
> | Visualization Database Views, procedures, functions, triggers, events on the software  | ❎ | - |
> | automatic software adaptability to database structure and data   | ❎ | - |

</details>

<details>
<summary><h2>📙 Screenshots</h2></summary>
<br/>

> | Home Page |
> |:---:|
> | <img alt="home" src="https://github.com/Drackass/DB-Administration-Software/blob/main/ForGithub/home.png" width="1000px"> |
>
> | Login Page |
> |:---:|
> | <img alt="log" src="https://github.com/Drackass/DB-Administration-Software/blob/main/ForGithub/log.png" width="1000px"> |
>
> | Admin Panel Page |
> |:---:|
> | <img alt="admin-panel" src="https://github.com/Drackass/DB-Administration-Software/blob/main/ForGithub/admin-panel.png" width="1000px"> |
>
> | Table Page |
> |:---:|
> | <img alt="table" src="https://github.com/Drackass/DB-Administration-Software/blob/main/ForGithub/table.png" width="1000px"> |
>
> | Edit Table Page |
> |:---:|
> | <img alt="edit" src="https://github.com/Drackass/DB-Administration-Software/blob/main/ForGithub/edit-table.png" width="1000px"> |
>
> | PDF File |
> |:---:|
> | <img alt="pdf" src="https://github.com/Drackass/DB-Administration-Software/blob/main/ForGithub/pdf.png" width="1000px"> |

</details>

<details>
<summary><h2>📓 Sources</h2></summary>
<br/>

> ### 🔎 Sub-summary
> 1. [External libraries](#-external-libraries)
> 2. [Data sources](#-data-sources)
> 3. [References](#-references)
>    
> <br/>
>
> ### 📌 External libraries
>
>  | libraries | Description |
> |-|-|
> |`MySql.Data.dll`| is a .NET data provider that enables communication between a .NET application and a MySQL database. It provides a set of classes and methods that allow developers to connect to, query, and manage data in a MySQL database from within their .NET applications. This DLL is widely used in .NET projects that need to interact with MySQL databases, enabling seamless data integration and manipulation.|
> |`itextsharp.dll`| is a popular open-source library for working with PDF documents in the .NET environment. It allows developers to create, manipulate, and extract content from PDF files programmatically. With iTextSharp.dll, you can generate PDF files from scratch, merge existing PDFs, add images, text, tables, and other elements to PDF documents, and even digitally sign them. This library is commonly used in various .NET applications that require PDF processing, such as generating reports, filling forms, or managing document workflows. Note that iTextSharp.dll is a port of the original Java iText library adapted for .NET development.|
>
> ### 📌 Data sources
>
> I used a data generation tool called [generatedata](https://generatedata.com/generator) to randomly generate data for my database.
>
> ### 📌 References
>
> This database administration software coded in C#.net is adapted and improved from a school project coded in VB.Net by **O.ALBERT** & **B.ROUCHON**.
>
</details>

---

<!-- You can get your avatar url on: https://api.github.com/users/YourPseudo -->
<a href="https://github.com/Drackass"><img src="https://avatars.githubusercontent.com/u/105803677?v=4" title="goingdust" width="70" height="70"></a>

</br>

<p align="center"><a href="#" align="center"><img alt="to the top" src="https://static.vecteezy.com/system/resources/previews/011/893/855/original/neumorphic-up-arrow-icon-neumorphism-ui-button-free-png.png" width="50px"></a></p>
