# [Blender Launcher v2 development](https://github.com/Victor-IX/Blender-Launcher-V2)

# [Discussions](https://github.com/DotBow/Blender-Launcher/discussions) │ [Documentation](https://dotbow.github.io/Blender-Launcher) │ [Latest Release](https://github.com/DotBow/Blender-Launcher/releases/latest)

![Blender Launcher Logo](docs/mkdocs/imgs/bl_logo.png)

<details>
<summary>Screenshots</summary>
<p></p>
<p align="center">
<img src="docs/mkdocs/imgs/library_stable.png">
</p>
<p align="center">
<img src="docs/mkdocs/imgs/downloads_daily.png">
</p>
<p align="center">
<img src="docs/mkdocs/imgs/user_favorites.png">
</p>
<p align="center">
<img src="docs/mkdocs/imgs/tray.png">
</p>
</details>

## What is it?

Blender Launcher is a standalone software client that provides management for stable, daily and experimental builds of [Blender 3D](https://www.blender.org/). It is a free open source project available for 64-bit Windows and Linux (GLIBC 2.31 and higher) operating systems.

## Why do I need it?

The goal of Blender Launcher is to make it easier to stay up to date with the latest features and improvements of Blender 3D together with the security of stable releases. Being a minimalistic portable application it is a nice tool for organizing the evolving free and open source 3D creation suite.

## What features does it have?

Compared to its [predecessor](https://github.com/DotBow/Blender-Version-Manager) Blender Launcher introduces a number of major improvements:

* Rewritten from the ground up for better stability and extensibility
* All official builds are available:
    * [Stable releases](https://download.blender.org/release/)
    * [Daily builds](https://builder.blender.org/download/)
    * [Experimental branches](https://builder.blender.org/download/branches/)
* Faster starting times by caching data
* Support for high DPI displays

Core features:

* Automatic checking of latest builds
* Fast access of favorite build via tray context menu or by middle click on tray icon
* Register .blend file extension for preferred build
* Startup arguments for launching Blender
* Template installation
* Indication of running builds and its number of instances

## How to start using it?

* :floppy_disk: Download [latest version](https://github.com/DotBow/Blender-Launcher/releases/latest) from [releases page](https://github.com/DotBow/Blender-Launcher/releases)
* :rocket: Follow [Installation](https://dotbow.github.io/Blender-Launcher/installation/#installing-blender-launcher) instructions on [Documentation](https://dotbow.github.io/Blender-Launcher) site
* :speech_balloon: Use Blender Artists Community [thread](https://blenderartists.org/t/blender-launcher-standalone-software-client) to ask questions and make proposals

## How to thank the developer?

* :blush: The best reward is feedback and a happy user face!

***

:sparkling_heart: Thanx for using Blender Launcher! Have a nice day!
