# Fuelish Backend

Welcome to Fuelish Backend, the Python program that retrieves daily fuel prices from ndtv.com at the ungodly hour of 6am so you don't have to. We built Fuelish Backend because we're tired of waking up early to check fuel prices, and we're sure you are too!

## Status
[![Generate csv](https://github.com/Doofenshmirtz-Evil-Incorp/FuelishCLI/actions/workflows/csv.yml/badge.svg)](https://github.com/Doofenshmirtz-Evil-Incorp/FuelishCLI/actions/workflows/csv.yml)

## Table of Contents

- [Fuelish Backend](#fuelish-backend)
  - [Table of Contents](#table-of-contents)
  - [Features](#features)
  - [Technologies Used](#technologies-used)
  - [Installation](#installation)
  - [Usage](#usage)
  - [Contributing](#contributing)
  - [Author](#author)
  - [Acknowledgements](#acknowledgements)
  - [License](#license)

## Features

- Fuelish Backend uses web scraping to fetch the daily diesel and petrol prices from ndtv.com, so you can stay up-to-date without having to refresh your browser every minute.
- The program parses the fetched data into a CSV file called state.csv, because we're fancy like that.
- Fuelish Backend is scheduled to run every day at 6am, so you can sleep soundly knowing that you'll wake up to the latest fuel prices.
- The program handles errors gracefully, because we know how unpredictable the internet can be.
- Fuelish Backend is efficient and lightweight, so it won't slow down your computer like a truck carrying a heavy load of fuel.

## Technologies Used

Fuelish Backend is built with the following technologies:

- Python, because it's the Swiss Army Knife of programming languages.
- Beautiful Soup, because we like our web scraping like we like our soup - beautiful.
- Requests, because we need to make HTTP requests like we need fuel to make our cars go.
- CSV, because we need a way to store the fetched data in a readable format.

## Installation

To install Fuelish Backend, follow these steps:

1. Clone the repository: `git clone https://github.com/yourusername/fuelish-backend.git`
2. Install the dependencies: `pip install -r requirements.txt`
3. And that's pretty much it.

## Usage

To use Fuelish Backend, follow these steps:

1. Wait until 6am, because we like to sleep in like lazy sloths.
2. Check the state.csv file to see the latest diesel and petrol prices for your state.
3. Do a happy dance if the fuel prices have gone down, or a sad dance if they have gone up.
4. Repeat this process every day, because we want you to be as addicted to fuel prices as we are.

## Contributing

We welcome contributions from the community, especially if you're willing to fuel our caffeine addiction. To contribute to Fuelish Backend, follow these steps:

1. Fork the repository (but don't fork over your fuel).
2. Create a new branch: `git checkout -b my-feature-branch`
3. Make your changes and commit them: `git commit -am 'Add some fuel-saving feature'`
4. Push to the branch: `git push origin my-feature-branch`
5. Submit a pull request, and we'll review it faster than a fuel truck on the highway.

## Author

Fuelish Backend was created by [Aryaman](https://github.com/actuallyarayaman) and [Asvin](https://github.com/Asvin1), two fuel-saving enthusiasts who believe that every drop of fuel counts. If you have any questions or feedback, you can reach out. We promise to respond faster than a fuel pump dispensing gas!

## Acknowledgements

 - [Sanchit](https://github.com/baked-potatoes)
 - Data courtsey to [NDTV](https://ndtv.com)

## License

Fuelish Backend is licensed under the [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) License, because we like to share our fuel-saving knowledge with the world. You are free to use, modify, and distribute this program, as long as you keep the original copyright and license notice intact.
