# Contributing

When contributing to this repository, please first discuss the changes you wish to make via issue, discussion, email, or any other method with the owners of this repository before making a change. 

Please note we have a code of conduct, please follow it in all your interactions with the project (author, contributors, users, ...).

## Process to add new features

1. Open a discussion to describe your feature
2. We will discuss about it and open an issue if it's ok
3. We put you as contributor for the features you want to work on
4. Fork the project or refresh/update your fork of the project
5. Do your changes on your copy
6. Commit the tested and working features (at least 1 COMMIT by feature is better than a global COMMIT for all to avoid merging problems)
7. Submit a pull request
8. We will check your pull request and merge it if all is ok

## Process to fix a bug

1. Open an issue or update an existing issue were you say you can do the job
2. If it's ok for us, we put you as contributor for the features you want to work on
3. Fork the project or refresh/update your fork of the project
4. Do your changes on your copy
5. Commit the tested and working features (at least 1 COMMIT by feature is better than a global COMMIT for all to avoid merging problems)
6. Submit a pull request
7. We will check your pull request and merge it if all is ok

## Process to fix a security issue

Please never discuss of security issues publicly before a patch have been released.

If you found a security issue, [contact the project owner in private](https://developpeur-pascal.fr/nous-contacter.php) and explain the problem.

## Comments

* If you need a version number, please follow [SemVer](http://semver.org/) versioning rules.

* In your commits comments, don't forget to specify issue number as "developpeurpascal/reponame#issuenumber" or "#issuenumber" if you have one

* Before doing a COMMIT, verify you don't have any password, token or private key in the files you commit !

* If needed add a screen capture in the "screen-captures" folder

* If you want to explain how to use a new feature or the impact of your changes, add a file named "YYYYMMDD-YourName.md" in a "CHANGELOG" directory (YYYYMMDD is the date of your change as "YearMonthDay")

* If you change something in a library or component, be sure to maintain compatibility with existing code. If you need to remove something, say it in a dedicated issue before removing anything !

* Dependencies of this project must be done by "git" submodules. If you want to use an other system, please discuss about it before.
