# DMG Data Science Awesome 
[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![Made With Love](https://img.shields.io/badge/Made%20With-Love-orange.svg)](https://github.com/chetanraj/awesome-github-badges) [![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT) [![GitHub pull-requests](https://img.shields.io/github/issues-pr/Developer-MultiGroup/DMG-Data-Science-Awesome.svg)](https://GitHub.com/Developer-MultiGroup/DMG-Data-Science-Awesome/pulls/)

[![GitHub stars](https://img.shields.io/github/stars/Developer-MultiGroup/DMG-Data-Science-Awesome.svg?style=social&label=Star)](https://GitHub.com/youssefHosni/Awesome-ML-GitHub-Repos/stargazers/) [![GitHub forks](https://img.shields.io/github/forks/Developer-MultiGroup/DMG-Data-Science-Awesome.svg?style=social&label=Fork)](https://GitHub.com/youssefHosni/Awesome-ML-GitHub-Repos/network/) [![GitHub watchers](https://img.shields.io/github/watchers/Developer-MultiGroup/DMG-Data-Science-Awesome.svg?style=social&label=Watch)](https://GitHub.com/youssefHosni/Awesome-ML-GitHub-Repos/watchers/)


![DevMultiGroupBanner](/images/awesome.gif)

*Ekibimizi ve üzerinde çalıştığımız işleri daha yakından inceleyin :point_right:* [MultiGroup.hq](https://github.com/Developer-MultiGroup/MultiGroup.hq)

![aiconf](/images/datacommit.png)

**Online serimiz olan "DataCommit" etkinliğimize katılın. Data expertler ile soru-cevap fırsatını yakalayın. Herkes davetlidir.  Ücretsiz biletler için :point_right: [DataCommit](https://kommunity.com/devmultigroup/events/datacommit-series-d244edf8)**

#### **📌 DataCommit Kaynaklar**
 **DataCommit'te önerilen kaynaklara erişmek için :point_right: [DataCommit](#datacommit)** 

> 👋 Kaynak arşivine katkı sağlamadan önce lütfen [Contribution Guide](./CONTRIBUTING.md)'a göz atınız.


[![LinkedIn](https://img.shields.io/badge/Follow@devmultigroup-%230077B5.svg?logo=linkedin&logoColor=white)](https://www.linkedin.com/company/devmultigroup) [![Twitter Follow](https://img.shields.io/twitter/follow/devmultigroup?style=social)](https://x.com/devmultigroup)


### 🌟 Alanlar ve Sorumlu Kişiler

| 🐍 Python & SQL | 📈 Machine Learning | 📝 Natural Language Processing|
|----------|----------|----------|
| 📊 Data Science | 🚀 MLOps & Cloud | 🤖 GenerativeAI|
| [Selin Çıldam](https://www.linkedin.com/in/selincildam/)| [Göker Güner](https://www.linkedin.com/in/gokerguner/) | [Enes Fehmi Manan](https://www.linkedin.com/in/enesfehmimanan/)|



# 📑Table of Contents
| 🗂️ **Structured**               |   🧠 **Unstructured**               |
| --------------------------------|   --------------------------------  |
| 🐍 [Python & SQL](#python-sql)       | 🤖 [GenerativeAI](#generative-ai)   | 
| 📊 [Data Science](#data-science) | 📝 [Natural Language Processing](#natural-language-processing) | 
| 📈 [Machine Learning](#machine-learning) | 🧬 [Deep Learning](#deep-learning) |
| 📚 [Data Books](#data-books)     | 👁️ [Computer Vision](#computer-vision) |
| 📰 [Data Papers](#data-papers)   | 🚀 [MLOps & Cloud](#mlops&cloud) |



<a name="python-sql"></a>
## 🐍Python & SQL
<details>
<summary>Click to expand!</summary>


**[`^        back to top        ^`](#dmg-data-science-awesome)**


### SQL 
+ **📹 Video Tutorials**
  
    - [Intro to SQL: Querying and managing data](https://www.khanacademy.org/computing/computer-programming/sql)- SQL dilini sıfırdan başlayarak öğrenin.

### Python

- [Yazbel Belgeleri](https://python-istihza.yazbel.com/index.html) - Python dilini Türkçe olarak detaylı bir şekilde öğrenin.
- [CS50 Python](https://cs50.harvard.edu/python/2022/) - Harvard'ın ünlü CS50 dersinin Python için özel versiyonu.

### 🔗 Useful Links

- [Learn SQL in stages](https://sqlzoo.net/wiki/SQL_Tutorial) - SQL bilginizi pratiklerle geliştirin.
- [Hackerrank Python](https://www.hackerrank.com/domains/python?filters%5Bstatus%5D%5B%5D=unsolved&badge_type=python) - Python'da algoritma pratiği yapın.
- [Hackerrank SQL](https://www.hackerrank.com/domains/sql?filters%5Bstatus%5D%5B%5D=unsolved&badge_type=sql) - SQL'de pratik yapın.

</details>


<a name="data-science"></a>
## 📊Data Science
<details>
<summary>Click to expand!</summary>

**[`^        back to top        ^`](#dmg-data-science-awesome)**

### 🔗 Useful Links

- [Veri Defteri](https://veridefteri.com/) - Veri Biliminin bir çok konusu hakkında hem blog hem video tutorialları olan websitesi.


### Introduction to Data Science

+ **📹 Video Tutorials**
    - [Virtualenv](https://calmcode.io/course/virtualenv/intro) - Virtual environment neden gereklidir ve neden kullanılır. Detaylı öğrenin.

+ **📖 Blog Tutorials**
    - [Difference of Data Science and Machine Learning](https://www.datasciencecentral.com/difference-of-data-science-machine-learning-and-data-mining/) - Veri Biliminin temel kavramlarına aşina olun.

    + **🛠️ Virtual Environment**
        - [Python Virtual Environment](https://www.geeksforgeeks.org/python-virtual-environment/) - Sanal ortamların nasıl kurulacağını ve neden kullanıldığını öğrenin.
     
### Exploratory Data Analysis 
+ **📹 Video Tutorials**
    - [Statistics for Data Science](https://www.youtube.com/watch?v=xxpc-HPKN28)- Veri Bilimi için gerekli istatistik altyapısını edinin.

###  Data Wrangling & Preprocessing
- [Handling Missing Values](https://www.analyticsvidhya.com/blog/2021/10/handling-missing-value/) - Eksik verilere nasıl yaklaşılacağını öğrenin. 
- [Discover Feature Engineering](https://machinelearningmastery.com/discover-feature-engineering-how-to-engineer-features-and-how-to-get-good-at-it/) - Feature engineering nedir, nasıl yapılır? Mantığını öğrenin.
- [Feature Engineering for Machine Learning](https://towardsdatascience.com/feature-engineering-for-machine-learning-eb2e0cff7a30) - Veri ön işleme adımının nasıl yapılacağını öğrenin.

</details>

<a name="machine-learning"></a>
## 📈Machine Learning
<details>
<summary>Click to expand!</summary>

**[`^        back to top        ^`](#dmg-data-science-awesome)**

### Courses

- [Makine Öğrenmesine Giriş](https://www.youtube.com/playlist?list=PLZcbvMjrj9DVU6g2A5e6voeigUtSMsAJH) - ML teorisini detaylı bir şekilde öğrenin. Ders kaynaklarına [buradan](https://github.com/sibirbil/IMO2020) erişebilirsiniz.
- [AI for Beginners](https://microsoft.github.io/AI-For-Beginners/) - Microsoft tarafından yayınlanan AI kursu.
- [Google ML Crash Course](https://developers.google.com/machine-learning/crash-course): Google'ın ML üzerine kapsamlı temel bir kursu, pek çok ML kavramına dair temel bilgi edinmek ve kariyerine sağlam başlangıç noktaları oluşturmak isteyenler için.
- [Coursera ML Specialization](https://www.coursera.org/specializations/machine-learning-introduction): Coursera'nın toplam 4 kurstan oluşan ML Uzmanlık serisi. Teorik bilginin yanı sıra notebook ödevleriyle birlikte ML kodlama pratiğine başlamak isteyenler için.
- [Kaggle Intro to ML](https://www.kaggle.com/learn/intro-to-machine-learning): Kaggle'ın temel seviye ML kursu. Basit seviyede konseptler, tanımlar içerir.
- [Kaggle Intermediate ML](https://www.kaggle.com/learn/intermediate-machine-learning): Kaggle'ın giriş seviye kursunun devamı niteliğinde, yine de seviyesi çok üst düzey değil. Başlangıç seviyesinde olanların da rahatlıkla takip edebilecekleri bir kurs.
- [DataTalksClub ML Zoomcamp](https://github.com/DataTalksClub/machine-learning-zoomcamp): DataTalksClub'ın ML Zoomcamp'i. İçerikleri kendi hızınızda tüketebilirsiniz ancak, yılın belli dönemlerinde Zoom üzerinden dersler, ödevler vb. şeklinde de takip edilen "Zoomcamp"leri mevcut.


### 📖 Blog Tutorials

- ☕[Supervised Learning](https://stanford.edu/~shervine/l/tr/teaching/cs-229/cheatsheet-supervised-learning): Stanford'un CS229: Machine Learning dersine ait Türkçeye çevrilmiş Gözetimli öğrenme notları.
- ☕[Unsupervised Learning](https://stanford.edu/~shervine/l/tr/teaching/cs-229/cheatsheet-unsupervised-learning/): Stanford'un CS229: Machine Learning dersine ait Türkçeye çevrilmiş Gözetimsiz öğrenme notları.
- [What is Overfitting?](https://www.freecodecamp.org/news/what-is-overfitting-machine-learning/): Overfitting kavramını ve kaçınmanın yollarını öğrenin. 
- [Scikit Learn Official Document](https://scikit-learn.org/stable/index.html): Temel algoritmalar, preprocess yöntemleri, model başarı ölçümlemeleri gibi Machine Learning'e ait neredeyse bütün konseptler için Python dilinde kullanabileceğiniz scikit-learn'ün resmi dokümantasyonu.

### 📹 Video Tutorials

- [Freecodecamp ML Course for Beginners](https://www.youtube.com/watch?v=NWONeJKn6kc): Freecodecamp'in yeni başlayanlar için 9 saat 52 dakikalık tek parça ML kursu.
- [Yapay Öğrenme için Matematik](https://www.youtube.com/playlist?list=PL-VAZnoQqQ4W3kxCI4At6flbG72k8mHVG) - Makine öğrenmesi için gereken matematiği öğrenin.

### 🗃️ Datasets
 
- [UCI ML Repository](https://archive.ics.uci.edu/datasets): UC Irvine üniversitesine ait veri setleri. Kendi kütüphanesi ile direkt olarak python projesinin içerisine import edebiliyorsunuz.
- [Kaggle Datasets](https://www.kaggle.com/datasets): Kaggle platformundaki veri setleri. Giriş seviyesi kurslardan sonra hangi alanda hangi veri türüyle çalışmak istediğine karar verme aşamasında mutlaka göz atılmalı.
- [Awesome Repo](https://github.com/awesomedata/awesome-public-datasets?tab=readme-ov-file#machinelearning): Başlangıç seviyesi küçük veri setlerinin ardından daha büyük projeler çıkarmak isteyenler için daha gelişmiş veri setlerinin olduğu bir repo. Bu repoda ilgi alanlarınıza göre ayrılmış başka alanlardaki veri setlerini de görebilirsiniz.

</details>


<a name="data-books"></a>
## 📚Data Books

**[`^        back to top        ^`](#dmg-data-science-awesome)**

Data alanında yazılmış yerli ve yabancı kitapların listesini görmek için [tıklayınız](books.md).

<a name="data-papers"></a>
## 📰Data Papers

**[`^        back to top        ^`](#dmg-data-science-awesome)**

Data alanında yazılmış yerli ve yabancı makalelerin listesini görmek için [tıklayınız](papers.md).



<a name="generative-ai"></a>
## 🤖Generative AI
<details>
<summary>Click to expand!</summary>

**[`^        back to top        ^`](#dmg-data-science-awesome)**

### 🔗 Useful Links
- [ Chatbot Arena Leaderboard](https://lmarena.ai/?leaderboard) - LLM'lerin değerlendirilmesi ve topluluk desteği ile sıralanması ile oluşan liderlik tablosu.

### 📹 Video Tutorials
-  [Gemini API by Google](https://www.udacity.com/course/gemini-API-by-google--cd13416) - Gemini API üzerinden GenAI temellerini öğrenin.

### 📖 Blog Tutorials
-  [How Large Language Models work](https://medium.com/data-science-at-microsoft/how-large-language-models-work-91c362f5b78f) - Teknik bilgiye boğulmadan LLM'lerin nasıl çalıştığını öğrenin.
- ☕ [A Tutorial on LLM](https://medium.com/@haifengl/a-tutorial-to-llm-f78dd4e82efc) - Transformer mimarisinin nasıl çalıştığını ve GenAI için önemli kavramları öğrenin.
- ☕ [MultiModal Uygulama Geliştirip Hugging Face Spaces’te Yayınlamak!](https://medium.com/@cakirduygu/multimodal-uygulama-geli%C5%9Ftirip-hugging-face-spaceste-yay%C4%B1nlamak-65ca98ec38af) - Açık Kayak LLM'ler ile yaptığınız çalışmaları nasıl yayınlayacağınızı öğrenin.
- [Anthropic's Prompt Engineering Interactive Tutorial](https://github.com/anthropics/courses/tree/master/prompt_engineering_interactive_tutorial) - Anthropics kendi modelleri üzerinden anlattığı Prompt Engineering notebookları.
- ☕☕ [Llama 3 from Scratch](https://github.com/naklecha/llama3-from-scratch/blob/main/llama3-from-scratch.ipynb) - Llama 3 modelini sıfırdan implemente eden eğlenceli bir notebook.
- ☕ [How to generate text: using different decoding methods for language generation with Transformers](https://huggingface.co/blog/how-to-generate) - Transformers modelleri nasıl metin üretiyor?

+ ### RAG

    + **📹 Video Tutorials**
        -  [Building Systems with the ChatGPT API](https://www.deeplearning.ai/short-courses/building-systems-with-chatgpt/) - ChatGPT API kullanarak LLM'ler ile karmaşık iş akışlarını nasıl otomatikleştireceğinizi öğrenin. 
        -  [LangChain for LLM Application Development](https://www.deeplearning.ai/short-courses/langchain-for-llm-application-development/) - LangChain kullanarak LLM'lerin kullanım alanlarını genişletmeyi ve güçlü LLM uygulamaları oluşturmayı öğrenin.

    + **📖 Blog Tutorials**
        - ☕ [Learn RAG with Langchain 🦜⛓️‍💥](https://www.sakunaharinda.xyz/ragatouille-book/intro.html) - Langchain ile RAG yapmayı öğrenin.
        -  [(Part 1) Build your own RAG with Mistral-7B and LangChain](https://medium.com/@thakermadhav/build-your-own-rag-with-mistral-7b-and-langchain-97d0c92fa146) - Mistral-7B üzerinde nasıl RAG yapılacağını adım adım giderek anlatan yazı serisi.
        - ☕ [The 4 Advanced RAG Algorithms You Must Know to Implement](https://medium.com/decodingml/the-4-advanced-rag-algorithms-you-must-know-to-implement-5d0c7f1199d2) - İleri RAG tekniklerini öğrenin ve uygulamasını görün.

+ ### Fine Tuning
    + **📹 Video Tutorials**
        - ☕ [Finetuning Large Language Models](https://www.deeplearning.ai/short-courses/finetuning-large-language-models/) - Lamini kullanarak LLM'lere nasıl ince ayar yapabileceğinizi öğrenin.

    + **📖 Blog Tutorials**
        - ☕ [Fine-Tuning Mistral 7b in Google Colab with QLoRA (complete guide)](https://medium.com/@codersama/fine-tuning-mistral-7b-in-google-colab-with-qlora-complete-guide-60e12d437cca) - Mistral-7b üzerinden nasıl fine tuning yapılacağını öğrenin.
        - [Fine-tune a pretrained model](https://huggingface.co/docs/transformers/en/training) - Hugging Face tarafında ince ayar nasıl yapılır.
        - ☕☕ [BERT Fine-Tuning Tutorial with PyTorch](https://mccormickml.com/2019/07/22/BERT-fine-tuning/) - Pytorch ile Bert'i fine tune ederek, konuya derinlemesine dalın.
        - [A Gentle Introduction to 8-bit Matrix Multiplication for transformers at scale using Hugging Face Transformers, Accelerate and bitsandbytes](https://huggingface.co/blog/hf-bitsandbytes-integration) - Quantization nedir ve neden yapılmalıdır?
        - [Code LoRA from Scratch](https://lightning.ai/lightning-ai/studios/code-lora-from-scratch?utm_source=tldrai) - LoRA metodunu sıfırdan öğrenin.


### 🔧 Framework
- [Transformers](https://huggingface.co/docs/transformers/index) - Hugging Face tarafından geliştirilen, NLP ve generative AI modellerini kolayca kullanmanızı sağlayan bir kütüphane.
- [LangChain](https://python.langchain.com/docs/introduction/) - Büyük dil modelleri (LLM) ile çalışma ve uygulama geliştirme sürecini kolaylaştıran bir framework.
- [Haystack](https://haystack.deepset.ai/) - NLP görevleri için güçlü bir arama altyapısı sunan ve metinden metne generative modelleri destekleyen bir framework.
- [co:here](https://cohere.ai/) - Cohere, gelişmiş Büyük Dil Modelleri ve NLP araçlarına erişim sağlar.
- [Ollama](https://github.com/ollama/ollama) - Büyük dil modellerini yerel olarak çalıştırmanızı sağlayan bir framework.
- [DeepSpeed](https://www.deepspeed.ai/) - Microsoft tarafından geliştirilen, büyük modellerin daha verimli bir şekilde eğitilmesi ve kullanılması için optimize edilmiş bir deep learning optimizasyon kütüphanesi.
- [Alpaca-LoRA](https://github.com/tloen/alpaca-lora) - LLaMA tabanlı modeller üzerinde düşük kaynakla hızlı ince ayar (fine-tuning) yapmayı sağlayan bir framework.
- [Fairseq](https://github.com/facebookresearch/fairseq) - Facebook AI tarafından geliştirilen, çeşitli NLP ve sıralı modelleme görevleri için kullanılan bir framework.



### Models
- [OpenAI](https://openai.com/api/) - OpenAI'nin API'si, çeşitli doğal dil görevlerini yerine getiren GPT-3 ve GPT-4 modellerine ve doğal dili koda çeviren Codex'e erişim sağlar.
- [LLaMA](https://ai.facebook.com/blog/large-language-model-llama-meta-ai/) - Meta tarafından geliştirilen, 65 milyar parametreli temel bir büyük dil modeli.
- [Claude](https://claude.ai/) - Anthropic tarafından geliştirilen bir yapay zeka asistanı olan Claude ile konuşun.
- [Mixtral](https://mistral.ai/news/mixtral-of-experts/) - Açık ağırlıklara sahip yüksek kaliteli, seyrek bir uzmanlar karışımı modeli. 
- [Grok](https://grok.x.ai/) - xAI tarafından geliştirilen ve [açık kaynak](https://github.com/xai-org/grok-1) ve açık ağırlıklara sahip bir büyük dil modeli. 

+ **🛠️ Coding Assistants**
    - [GitHub Copilot](https://github.com/features/copilot) - GitHub Copilot, OpenAI Codex desteğiyle editörünüzde gerçek zamanlı kod ve fonksiyon önerileri sunar.
    - [Amazon Q](https://aws.amazon.com/q/) - AWS’nin yapay zeka destekli asistanı; soruları yanıtlar, kod yazar ve görevleri otomatikleştirir.




</details>


<a name="natural-language-processing"></a>
## 📝Natural Language Processing
<details>
<summary>Click to expand!</summary>

**[`^        back to top        ^`](#dmg-data-science-awesome)**

### 🔗 Useful Links
- [Turkish NLP Resources](https://turkce.netlify.app/) - Türkçe NLP kaynaklarının derlendiği websitesi.
- [NLP Cheat Sheet Repo](https://github.com/janlukasschroeder/nlp-cheat-sheet-python) - Python NLP Cheat Sheet
- [High-Quality Resources for studying NLP](https://medium.com/nlplanet/awesome-nlp-18-high-quality-resources-for-studying-nlp-1b4f7fd87322) - Kaliteli NLP kaynakları

### 📹 Video Tutorials
- [Hugging Face NLP Course](https://huggingface.co/learn/nlp-course/chapter1/1) - Hugging Face üzerinden NLP temellerini öğrenin.
- [Natural Language Processing at UT Austin](https://www.youtube.com/playlist?list=PLofp2YXfp7TZZ5c7HEChs0_wfEfewLDs7) - Austin üniversitesi NLP dersleri.
- [Doğal Dil İşleme Yaz Okulu](https://www.youtube.com/playlist?list=PLMGWwuh6-mEe57iOtf1uo5DgZB288l0CQ) - Türkçe Doğal Dil İşleme yaz okulu.

### 📖 Blog Tutorials
- [What Is Natural Language Processing?](https://machinelearningmastery.com/natural-language-processing/) - Doğal Dil İşleme nedir?
- ☕ [Natural Language Processing is Fun!](https://medium.com/@ageitgey/natural-language-processing-is-fun-9a0bff37854e) - Adım adım NLP temellerini öğrenin. [[2]](https://medium.com/@ageitgey/text-classification-is-your-new-secret-weapon-7ca4fad15788),[[3]](https://medium.com/@ageitgey/natural-language-processing-is-fun-part-3-explaining-model-predictions-486d8616813c), [[4]](https://medium.com/@ageitgey/deepfaking-the-news-with-nlp-and-transformer-models-5e057ebd697d), [[5]](https://medium.com/@ageitgey/build-your-own-google-translate-quality-machine-translation-system-d7dc274bd476)
- [NLP Python Repo](https://github.com/milaan9/Python_Natural_Language_Processing) - Notebooklar üzerinden NLP temellerini öğrenin.
- [TR NLP 101](https://github.com/kolaydilisleme/NLP-101-Egitim) - Türkçe olarak NLP temellerini öğrenin.
- ☕☕ [Natural Language Processing Specialization on Coursera](https://aman.ai/coursera-nlp/) - Natural Language Processing Specialization detaylı kurs dokümanları.

</details> 

<a name="deep-learning"></a>
## 🧬Deep Learning
<details>
<summary>Click to expand!</summary>

**[`^        back to top        ^`](#dmg-data-science-awesome)**

- ☕☕ [PyTorch internals](http://blog.ezyang.com/2019/05/pytorch-internals/) - Pytorch'un nasıl çalıştığını öğrenin.

</details>


<a name="computer-vision"></a>
## 👁️Computer Vision
<details>
<summary>Click to expand!</summary>

**[`^        back to top        ^`](#dmg-data-science-awesome)**


### 📹 Video Tutorials
- [Community Computer Vision Course](https://huggingface.co/learn/computer-vision-course/unit0/welcome/welcome) - Hugging Face komünitesi tarafından oluşturulan görüntü işleme kursu.

</details>


<a name="mlops&cloud"></a>
## 🚀MLOps & Cloud
<details>
<summary>Click to expand!</summary>

**[`^        back to top        ^`](#dmg-data-science-awesome)**

### AWS

- [AWS Bedrock Samples](https://github.com/aws-samples/amazon-bedrock-samples) - AWS Bedrock örneklerini içeren repo.

</details>



<a name="datacommit"></a>
## ✨ DataCommit
<details>
<summary>Click to expand!</summary>

**[`^        back to top        ^`](#dmg-data-science-awesome)**

### [👻 Kaan Bıçakçı](https://www.youtube.com/watch?v=pu5tuQshGoU)

**Books:**
- ☕ **Probabilistic Machine Learning: An Introduction** - *Kevin Murphy* - Matematiği seviyorsanız ve ML'in temellerini öğrenmek istiyorsanız, güzel bir başlangıç. 

- ☕☕ **Probabilistic Machine Learning: Advanced Topics** - *Kevin Murphy* - Matematiği seviyorsanız ve ML temeliniz varsa, bunu daha ileriye taşımak istiyorsanız göz atabilirsiniz. 

**Reddit:**
- [Leetcode](https://www.reddit.com/r/leetcode/) - FAANG mülakatları ile ilgili deneyimleri okuyabilirsiniz.

- [Cscareerquestions](https://www.reddit.com/r/cscareerquestions/) - Genel CS ilgili soru-cevapların olduğu bir yer.

- [MachineLearning](https://www.reddit.com/r/MachineLearning/) - Genel olarak ML ile ilgili ilginç başlıklar bulabilirsiniz.

- [LocalLLaMa](https://www.reddit.com/r/LocalLLaMA/) - Yeni çıkan LLM'lerin yorumlarına ulaşabilirsiniz.

- [EngineeringResumes](https://www.reddit.com/r/EngineeringResumes/) - CV değerlendirmeleri bulabilirsiniz.

- [Programming](https://www.reddit.com/r/programming/) - Can sıkıntısında dolaşmak için :)

**YouTube:**

- ☕ [Ritvikmath](https://www.youtube.com/@ritvikmath) - Genel Data Science konseptlerini anlamak için güzel bir kanal. 

- [3blue1brown](https://www.youtube.com/@3blue1brown) - Animasyonlu ilginç konu anlatımları bulabilirsiniz.


### [Bilge Yücel](https://www.youtube.com/watch?v=UCpZJwb8UAY)


### [🤗 Alara Dirik](https://www.youtube.com/watch?v=fGEApsNKKw0)
- [Hype](https://hype.replicate.dev/) - Github, Hugging Face, Replicate ve Reddit'te trend olan ML projelerini günlük olarak sıralayan bir site :)
- ☕☕ [AlphaSignal](https://alphasignal.ai/) - ML ürün ve araştırmalarından son haberleri almak için güzel bir haber bülteni 
- [DataCamp](https://www.datacamp.com/) - Hem programlama hem veri bilimi, veri mühendisliği için kısa süreli kursları ve kendi online kod editörü olan bir site, ücretli ama uygun fiyatları var.
- ☕ [Devpost](https://devpost.com/) - Global çaptaki hackathonlara ulaşabileceğiniz ve katılım sağlayabileceğiniz bir site

### [Olgun Aydın](https://www.youtube.com/live/yhTxZr_bmDU)

</details>
----


<a href="https://discord.gg/gEfnhvcr" target="_blank" rel="noreferrer"><img src="https://raw.githubusercontent.com/danielcranney/readme-generator/main/public/icons/socials/discord.svg" width="32" height="32" /></a> <a href="https://github.com/Developer-MultiGroup" target="_blank" rel="noreferrer"><img src="https://raw.githubusercontent.com/danielcranney/readme-generator/main/public/icons/socials/github.svg" width="32" height="32" /></a> <a href="https://www.linkedin.com/company/devmultigroup/" target="_blank" rel="noreferrer"><img src="https://raw.githubusercontent.com/danielcranney/readme-generator/main/public/icons/socials/linkedin.svg" width="32" height="32" /></a> <a href="https://www.instagram.com/devmultigroup/" target="_blank" rel="noreferrer"><img src="https://raw.githubusercontent.com/danielcranney/readme-generator/main/public/icons/socials/instagram.svg" width="32" height="32" /></a> <a href="https://medium.com/developer-multicamp" target="_blank" rel="noreferrer"><img src="https://raw.githubusercontent.com/danielcranney/readme-generator/main/public/icons/socials/medium.svg" width="32" height="32" /></a> <a href="https://x.com/devmultigroup" target="_blank" rel="noreferrer"><img src="https://raw.githubusercontent.com/danielcranney/readme-generator/main/public/icons/socials/twitter.svg" width="32" height="32" /></a> <a href="https://www.youtube.com/@devmultigroup" target="_blank" rel="noreferrer"><img src="https://raw.githubusercontent.com/danielcranney/readme-generator/main/public/icons/socials/youtube.svg" width="32" height="32" /></a></p>



## 🌟 Contributors

[![awesome contributors](https://contrib.rocks/image?repo=Developer-MultiGroup/DMG-Data-Science-Awesome)](https://github.com/Developer-MultiGroup/DMG-Data-Science-Awesome)

[![Star History Chart](https://api.star-history.com/svg?repos=Developer-MultiGroup/DMG-Data-Science-Awesome&type=Timeline)](https://star-history.com/#Developer-MultiGroup/DMG-Data-Science-Awesome)
