# Buy More
## Team - HAX

### Conversational Fashion Outfit Generator using GenAI - Flipkart Grid 5.0
- *Revolutionizing Fashion Discovery*: Gen AI-powered outfit generator reshapes fashion search, offering personalized recommendations from past purchases, preferences, and social trends.
- *Personalized Trendy Outfits*: Utilizes past purchases, style preferences, and current trends to craft well-coordinated outfits, elevating user shopping on Flipkart.
- *Social Trend Integration*: Incorporates social media insights, aligning fashion choices with influencer trends for on-point outfit suggestions.
- *Interactive Shopping Experience*: Users interactively fine-tune outfits, ensuring a confident shopping journey tailored to individual needs and occasions.

### Project Structure
- [Recommendation System - Python, Vector DB, Falcon 7B LLM, Flask, PyMongo](https://github.com/Devang-Shah-49/flipchat-fabric/tree/rishabh/backend)
- [Social Media Trends Extraction - Selenium, Instagram, Twitter, PyTrends, Tweepy](https://github.com/Devang-Shah-49/flipchat-fabric/tree/rishabh/scrappers)
- [Frontend - React JS, Redux, Axios, Vite](https://github.com/Devang-Shah-49/flipchat-fabric/tree/rishabh/client)
- [Backend - Node JS, MongoDB, Express JS, PayTM payment gateway](https://github.com/Devang-Shah-49/flipchat-fabric/tree/rishabh/server)

### Challenges we ran into
- Adapting the outfit recommendations to accommodate diverse cultural and regional preferences like occasion, age, body_type, fit, size and regional nuances - Solved by incorporating [Rent-the-runway dataset](https://cseweb.ucsd.edu/~jmcauley/datasets.html#clothing_fit).
- Developing a conversational model that understands user data and accordingly generates outfit suggestions - Used [free and open-source Falcon 7B LLM](https://huggingface.co/TheBloke/WizardLM-Uncensored-Falcon-7B-GPTQ), unlike conventional APIs that often come with costs.
- GPU limitations - Tackled by setting up an ngrok server on Kaggle's cloud notebook, leveraging GPU-P100 for seamless and resource-efficient model training.

### Demo
https://github.com/Devang-Shah-49/flipchat-fabric/assets/80088008/652b66b3-e482-49e9-9d9f-318616a0e45f

### Solution Presentation
PPT: https://drive.google.com/file/d/1UzCW62VA7vt3GQTZjpfOOQrfnuvYys3c/view?usp=sharing

### Contributors
- [Devang Shah](https://github.com/Devang-Shah-49)
- [Rishabh Jain](https://github.com/rish-2912)
- [Ayush Deshmukh](https://github.com/Ayush_Deshmukh)


