/*!
* DevExtreme (dx.messages.pl.js)
* Version: 24.2.3-build-24326-1309
* Build date: Thu Nov 21 2024
*
* Copyright (c) 2012 - 2024 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        pl: {
            Yes: "Tak",
            No: "Nie",
            Cancel: "Anuluj",
            CheckState: "Check state",
            Close: "Zamknij",
            Clear: "Usu\u0144",
            Done: "Gotowe",
            Loading: "\u0141adowanie...",
            Select: "Wybierz...",
            Search: "Szukaj...",
            Back: "Wr\xf3\u0107...",
            OK: "OK",
            Today: "Dzisiaj",
            Yesterday: "Yesterday",
            "dxCollectionWidget-noDataText": "Brak dost\u0119pnych danych",
            "dxDropDownEditor-selectLabel": "Wybierz",
            "validation-required": "Pole obowi\u0105zkowe",
            "validation-required-formatted": "{0} jest polem obowi\u0105zkowym",
            "validation-numeric": "Warto\u015b\u0107 musi by\u0107 liczb\u0105",
            "validation-numeric-formatted": "{0} musi by\u0107 liczb\u0105",
            "validation-range": "Warto\u015b\u0107 nie mie\u015bci si\u0119 w prawid\u0142owym zakresie",
            "validation-range-formatted": "{0} nie mie\u015bci si\u0119 w prawid\u0142owym zakresie",
            "validation-stringLength": "D\u0142ugo\u015b\u0107 warto\u015bci nie jest poprawna",
            "validation-stringLength-formatted": "D\u0142ugo\u015b\u0107 {0} nie jest poprawna",
            "validation-custom": "Warto\u015b\u0107 jest nieprawid\u0142owa",
            "validation-custom-formatted": "{0} jest nieprawid\u0142owa",
            "validation-async": "Warto\u015b\u0107 jest nieprawid\u0142owa",
            "validation-async-formatted": "{0} jest nieprawid\u0142owa",
            "validation-compare": "Warto\u015b\u0107 jest nieodpowiednia",
            "validation-compare-formatted": "{0} jest nieodpowiednia",
            "validation-pattern": "Warto\u015b\u0107 nie pasuje do wzorca",
            "validation-pattern-formatted": "{0} nie pasuje do wzorca",
            "validation-email": "Adres e-mail jest nieprawid\u0142owy",
            "validation-email-formatted": "{0} jest nieprawid\u0142owa",
            "validation-mask": "Warto\u015b\u0107 jest nieprawid\u0142owa",
            "dxLookup-searchPlaceholder": "D\u0142ugo\u015b\u0107 minimalna {0} znak\xf3w",
            "dxList-pullingDownText": "Aby zaktualizowa\u0107, przeci\u0105gnij w d\xf3\u0142",
            "dxList-pulledDownText": "Aby zaktualizowa\u0107 pu\u015b\u0107",
            "dxList-refreshingText": "Zaktualiz...",
            "dxList-pageLoadingText": "\u0141adowanie...",
            "dxList-nextButtonText": "Wi\u0119cej",
            "dxList-selectAll": "Wybierz wszystko",
            "dxList-listAriaLabel": "Items",
            "dxList-listAriaLabel-deletable": "Deletable items",
            "dxListEditDecorator-delete": "Usu\u0144",
            "dxListEditDecorator-more": "Wi\u0119cej",
            "dxList-selectAll-indeterminate": "Half-checked",
            "dxList-selectAll-checked": "Checked",
            "dxList-selectAll-notChecked": "Not checked",
            "dxScrollView-pullingDownText": "Aby zaktualizowa\u0107, przeci\u0105gnij w d\xf3\u0142",
            "dxScrollView-pulledDownText": "Aby zaktualizowa\u0107 pu\u015b\u0107",
            "dxScrollView-refreshingText": "Zaktualiz...",
            "dxScrollView-reachBottomText": "\u0141adowanie...",
            "dxDateBox-simulatedDataPickerTitleTime": "Wybierz godzin\u0119",
            "dxDateBox-simulatedDataPickerTitleDate": "Wybierz dat\u0119",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Wybierz dat\u0119 i godzin\u0119",
            "dxDateBox-validation-datetime": "Warto\u015b\u0107 musi by\u0107 dat\u0105 lub godzin\u0105",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "Start Date",
            "dxDateRangeBox-endDateLabel": "End Date",
            "dxFileUploader-selectFile": "Wybierz plik",
            "dxFileUploader-dropFile": "lub przeci\u0105gnij tutaj",
            "dxFileUploader-bytes": "Bajty",
            "dxFileUploader-kb": "KB",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "Za\u0142aduj",
            "dxFileUploader-uploaded": "Za\u0142adowano",
            "dxFileUploader-readyToUpload": "Gotowy do za\u0142adowania",
            "dxFileUploader-uploadAbortedMessage": "\u0141adowanie anulowane",
            "dxFileUploader-uploadFailedMessage": "B\u0142\u0105d podczas \u0142adowania",
            "dxFileUploader-invalidFileExtension": "Niedozwolony typ pliku",
            "dxFileUploader-invalidMaxFileSize": "Plik jest zbyt du\u017cy",
            "dxFileUploader-invalidMinFileSize": "Plik jest zbyt ma\u0142y",
            "dxRangeSlider-ariaFrom": "Od",
            "dxRangeSlider-ariaTill": "Do",
            "dxSwitch-switchedOnText": "W\u0141",
            "dxSwitch-switchedOffText": "WY\u0141",
            "dxForm-optionalMark": "opcjonalnie",
            "dxForm-requiredMessage": "{0} jest polem obowi\u0105zkowym",
            "dxNumberBox-invalidValueMessage": "Warto\u015b\u0107 musi by\u0107 liczb\u0105",
            "dxNumberBox-noDataText": "Brak danych",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} to display columns",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Drag a column from the group panel here",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} or drag a column from the group panel",
            "dxDataGrid-emptyHeaderColumnChooserText": "column chooser",
            "dxDataGrid-columnChooserTitle": "Wyb\xf3r kolumny",
            "dxDataGrid-columnChooserEmptyText": "Przeci\u0105gnij kolumny tutaj, aby je ukry\u0107",
            "dxDataGrid-groupContinuesMessage": "Kontynuacja na nast\u0119pnej stronie",
            "dxDataGrid-groupContinuedMessage": "Kontynuacja z poprzedniej strony",
            "dxDataGrid-groupHeaderText": "Grupuj wed\u0142ug tej kolumny",
            "dxDataGrid-ungroupHeaderText": "Usu\u0144 grupowanie",
            "dxDataGrid-ungroupAllText": "Usu\u0144 wszystkie grupowania",
            "dxDataGrid-editingEditRow": "Edytuj",
            "dxDataGrid-editingSaveRowChanges": "Zapisz",
            "dxDataGrid-editingCancelRowChanges": "Anuluj",
            "dxDataGrid-editingDeleteRow": "Usu\u0144",
            "dxDataGrid-editingUndeleteRow": "Przywr\xf3\u0107",
            "dxDataGrid-editingConfirmDeleteMessage": "Czy na pewno chcesz usun\u0105\u0107 ten rekord?",
            "dxDataGrid-validationCancelChanges": "Anuluj zmiany",
            "dxDataGrid-groupPanelEmptyText": "Przeci\u0105gnij kolumn\u0119 tutaj, aby pogrupowa\u0107 wed\u0142ug niej",
            "dxDataGrid-noDataText": "Brak danych",
            "dxDataGrid-searchPanelPlaceholder": "Szukaj...",
            "dxDataGrid-filterRowShowAllText": "(Wszystkie)",
            "dxDataGrid-filterRowResetOperationText": "Resetuj",
            "dxDataGrid-filterRowOperationEquals": "Jest r\xf3wne",
            "dxDataGrid-filterRowOperationNotEquals": "Nie jest r\xf3wne",
            "dxDataGrid-filterRowOperationLess": "Mniejsze ni\u017c",
            "dxDataGrid-filterRowOperationLessOrEquals": "Mniejsze lub r\xf3wne",
            "dxDataGrid-filterRowOperationGreater": "Wi\u0119ksze ni\u017c",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "Wi\u0119ksze lub r\xf3wne",
            "dxDataGrid-filterRowOperationStartsWith": "Zaczyna si\u0119 od",
            "dxDataGrid-filterRowOperationContains": "Zawiera",
            "dxDataGrid-filterRowOperationNotContains": "Nie zawiera",
            "dxDataGrid-filterRowOperationEndsWith": "Ko\u0144czy si\u0119 z",
            "dxDataGrid-filterRowOperationBetween": "Pomi\u0119dzy",
            "dxDataGrid-filterRowOperationBetweenStartText": "Pocz\u0105tek",
            "dxDataGrid-filterRowOperationBetweenEndText": "Koniec",
            "dxDataGrid-ariaSearchBox": "Search box",
            "dxDataGrid-applyFilterText": "Stosuj filtry",
            "dxDataGrid-trueText": "prawda",
            "dxDataGrid-falseText": "fa\u0142sz",
            "dxDataGrid-sortingAscendingText": "Sortuj rosn\u0105co",
            "dxDataGrid-sortingDescendingText": "Sortuj malej\u0105co",
            "dxDataGrid-sortingClearText": "Resetuj sortowanie",
            "dxDataGrid-ariaNotSortedColumn": "Not sorted column",
            "dxDataGrid-ariaSortedAscendingColumn": "Column sorted in ascending order",
            "dxDataGrid-ariaSortedDescendingColumn": "Column sorted in descending order",
            "dxDataGrid-ariaSortIndex": "Sort index {0}",
            "dxDataGrid-editingSaveAllChanges": "Zapisz zmiany",
            "dxDataGrid-editingCancelAllChanges": "Anuluj zmiany",
            "dxDataGrid-editingAddRow": "Nowy wiersz",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Minimum {1} wynosi {0}",
            "dxDataGrid-summaryMax": "Maks: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "Maksimum {1} wynosi {0}",
            "dxDataGrid-summaryAvg": "\xd8: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "\u015arednia {1} wynosi {0}",
            "dxDataGrid-summarySum": "Suma: {0}",
            "dxDataGrid-summarySumOtherColumn": "Suma {1} wynosi {0}",
            "dxDataGrid-summaryCount": "Liczba: {0}",
            "dxDataGrid-columnFixingFix": "Set Fixed Position",
            "dxDataGrid-columnFixingUnfix": "Unfix",
            "dxDataGrid-columnFixingLeftPosition": "Left",
            "dxDataGrid-columnFixingRightPosition": "Right",
            "dxDataGrid-columnFixingStickyPosition": "Sticky",
            "dxDataGrid-exportTo": "Eksportuj",
            "dxDataGrid-exportToExcel": "Eksportuj jako plik excel",
            "dxDataGrid-exporting": "Eksport...",
            "dxDataGrid-excelFormat": "Plik excel",
            "dxDataGrid-selectedRows": "Wybrane wiersze",
            "dxDataGrid-exportSelectedRows": "Eksportuj wybrane wiersze do {0}",
            "dxDataGrid-exportAll": "Wszystkie dane eksportuj do {0}",
            "dxDataGrid-headerFilterLabel": "Opcje filtra",
            "dxDataGrid-headerFilterIndicatorLabel": "Wy\u015bwietl opcje filtra dla kolumny '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(Warto\u015bci puste)",
            "dxDataGrid-headerFilterOK": "OK",
            "dxDataGrid-headerFilterCancel": "Anuluj",
            "dxDataGrid-ariaAdaptiveCollapse": "Ukryj dodatkowe kolumny",
            "dxDataGrid-ariaAdaptiveExpand": "Wy\u015bwietl dodatkowe kolumny",
            "dxDataGrid-ariaColumn": "Kolumna",
            "dxDataGrid-ariaColumnHeader": "Column header",
            "dxDataGrid-ariaValue": "Warto\u015b\u0107",
            "dxDataGrid-ariaError": "Error",
            "dxDataGrid-ariaRevertButton": "Press Escape to discard the changes",
            "dxDataGrid-ariaFilterCell": "Kom\xf3rka filtra",
            "dxDataGrid-ariaCollapse": "Zwi\u0144",
            "dxDataGrid-ariaModifiedCell": "Modified",
            "dxDataGrid-ariaDeletedCell": "Deleted",
            "dxDataGrid-ariaEditableCell": "Editable",
            "dxDataGrid-ariaExpand": "Rozwi\u0144",
            "dxDataGrid-ariaCollapsedRow": "Collapsed row",
            "dxDataGrid-ariaExpandedRow": "Expanded row",
            "dxDataGrid-ariaDataGrid": "Tabela danych zawieraj\u0105ca {0} wiersze/-y i {1} kolumn/y",
            "dxDataGrid-ariaSearchInGrid": "Szukaj w tabeli danych",
            "dxDataGrid-ariaSelectAll": "Wybierz wszystkie",
            "dxDataGrid-ariaSelectRow": "Wybierz wiersz",
            "dxDataGrid-ariaToolbar": "Pasek narz\u0119dzi tabeli danych",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "Generator filtr\xf3w",
            "dxDataGrid-filterPanelCreateFilter": "Utw\xf3rz filtr",
            "dxDataGrid-filterPanelClearFilter": "Resetuj",
            "dxDataGrid-filterPanelFilterEnabledHint": "Aktywuj filtr",
            "dxDataGrid-masterDetail": "Cell with details",
            "dxTreeList-ariaTreeList": "Lista strukturalna",
            "dxTreeList-ariaExpandableInstruction": "Press Ctrl + right arrow to expand the focused node and Ctrl + left arrow to collapse it",
            "dxTreeList-ariaSearchInGrid": "Szukaj w li\u015bcie strukturalnej",
            "dxTreeList-ariaToolbar": "Pasek narz\u0119dzi listy strukturalnej",
            "dxTreeList-editingAddRowToNode": "Dodaj",
            "dxPager-infoText": "Strona {0} z {1} ({2} elementy)",
            "dxPager-pagesCountText": "od",
            "dxPager-pageSize": "Elementy na stronie: {0}",
            "dxPager-pageSizesAllText": "Wszystkie/wszyscy",
            "dxPager-page": "Strona {0}",
            "dxPager-prevPage": "Poprzednia strona",
            "dxPager-nextPage": "Nast\u0119pna strona",
            "dxPager-ariaLabel": "Nawigacja strony",
            "dxPager-ariaPageSize": "Page size",
            "dxPager-ariaPageNumber": "Page number",
            "dxPagination-infoText": "Strona {0} z {1} ({2} elementy)",
            "dxPagination-pagesCountText": "od",
            "dxPagination-pageSize": "Elementy na stronie: {0}",
            "dxPagination-pageSizesAllText": "Wszystkie/wszyscy",
            "dxPagination-page": "Strona {0}",
            "dxPagination-prevPage": "Poprzednia strona",
            "dxPagination-nextPage": "Nast\u0119pna strona",
            "dxPagination-ariaLabel": "Nawigacja strony",
            "dxPagination-ariaPageSize": "Page size",
            "dxPagination-ariaPageNumber": "Page number",
            "dxPivotGrid-grandTotal": "\u0141\u0105cznie",
            "dxPivotGrid-total": "{0} \u0141\u0105cznie",
            "dxPivotGrid-fieldChooserTitle": "Wyb\xf3r pola",
            "dxPivotGrid-showFieldChooser": "Wy\u015bwietl wyb\xf3r pola",
            "dxPivotGrid-expandAll": "Rozwi\u0144 wszystkie",
            "dxPivotGrid-collapseAll": "Zwi\u0144 wszystkie",
            "dxPivotGrid-sortColumnBySummary": '"{0}" sortuj wed\u0142ug tej kolumny',
            "dxPivotGrid-sortRowBySummary": '"{0}" sortuj wed\u0142ug tego wiersza',
            "dxPivotGrid-removeAllSorting": "Anuluj sortowanie",
            "dxPivotGrid-dataNotAvailable": "Usu\u0144",
            "dxPivotGrid-rowFields": "Pola wierszy",
            "dxPivotGrid-columnFields": "Pola kolumn",
            "dxPivotGrid-dataFields": "Pola danych",
            "dxPivotGrid-filterFields": "Pole filtra",
            "dxPivotGrid-allFields": "Wszystkie pola",
            "dxPivotGrid-columnFieldArea": "Przeci\u0105gnij pola kolumn/y tutaj",
            "dxPivotGrid-dataFieldArea": "Przeci\u0105gnij pola danych tutaj",
            "dxPivotGrid-rowFieldArea": "Przeci\u0105gnij pola wiersza/-y tutaj",
            "dxPivotGrid-filterFieldArea": "Przeci\u0105gnij pola filtra tutaj",
            "dxScheduler-ariaLabel": "Scheduler. {0} view",
            "dxScheduler-appointmentAriaLabel-group": "Group: {0}",
            "dxScheduler-appointmentAriaLabel-recurring": "Recurring appointment",
            "dxScheduler-editorLabelTitle": "Dotyczy",
            "dxScheduler-editorLabelStartDate": "Czas rozpocz\u0119cia",
            "dxScheduler-editorLabelEndDate": "Czas zako\u0144czenia",
            "dxScheduler-editorLabelDescription": "Opis",
            "dxScheduler-editorLabelRecurrence": "Powt\xf3rz",
            "dxScheduler-navigationPrevious": "Previous page",
            "dxScheduler-navigationNext": "Next page",
            "dxScheduler-openAppointment": "Otw\xf3rz termin",
            "dxScheduler-recurrenceNever": "Nigdy",
            "dxScheduler-recurrenceMinutely": "minutowy",
            "dxScheduler-recurrenceHourly": "godzinowy",
            "dxScheduler-recurrenceDaily": "dzienny",
            "dxScheduler-recurrenceWeekly": "tygodniowy",
            "dxScheduler-recurrenceMonthly": "miesi\u0119czny",
            "dxScheduler-recurrenceYearly": "roczny",
            "dxScheduler-recurrenceRepeatEvery": "Powt\xf3rz wszystkie",
            "dxScheduler-recurrenceRepeatOn": "Powt\xf3rzy\u0107 dn.",
            "dxScheduler-recurrenceEnd": "Koniec powt\xf3rzenia",
            "dxScheduler-recurrenceAfter": "Do",
            "dxScheduler-recurrenceOn": "Dnia",
            "dxScheduler-recurrenceRepeatMinutely": "Minuta(-y)",
            "dxScheduler-recurrenceRepeatHourly": "Godzina(-y)",
            "dxScheduler-recurrenceRepeatDaily": "Dzie\u0144 (dni)",
            "dxScheduler-recurrenceRepeatWeekly": "Tydzie\u0144 (tygodnie)",
            "dxScheduler-recurrenceRepeatMonthly": "Miesi\u0105c(-e)",
            "dxScheduler-recurrenceRepeatYearly": "Rok (lata)",
            "dxScheduler-switcherDay": "Dzie\u0144",
            "dxScheduler-switcherWeek": "Tydzie\u0144",
            "dxScheduler-switcherWorkWeek": "Tydzie\u0144 roboczy",
            "dxScheduler-switcherMonth": "Miesi\u0105c",
            "dxScheduler-switcherAgenda": "Agenda",
            "dxScheduler-switcherTimelineDay": "Dzie\u0144 na osi czasu",
            "dxScheduler-switcherTimelineWeek": "Tydzie\u0144 na osi czasu",
            "dxScheduler-switcherTimelineWorkWeek": "Tydzie\u0144 roboczy na osi czasu",
            "dxScheduler-switcherTimelineMonth": "Miesi\u0105c na osi czasu",
            "dxScheduler-recurrenceRepeatOnDate": "dnia",
            "dxScheduler-recurrenceRepeatCount": "Wydarzenia",
            "dxScheduler-allDay": "ca\u0142odniowe",
            "dxScheduler-ariaEditForm": "Edit form",
            "dxScheduler-confirmRecurrenceEditTitle": "Edit Recurring Appointment",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Delete Recurring Appointment",
            "dxScheduler-confirmRecurrenceEditMessage": "Czy chcesz edytowa\u0107 tylko ten termin, czy ca\u0142\u0105 seri\u0119?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Czy chcesz usun\u0105\u0107 tylko ten termin, czy ca\u0142\u0105 seri\u0119?",
            "dxScheduler-confirmRecurrenceEditSeries": "Edytuj seri\u0119",
            "dxScheduler-confirmRecurrenceDeleteSeries": "Usu\u0144 seri\u0119",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Edytuj termin",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "Usu\u0144 termin",
            "dxScheduler-noTimezoneTitle": "Brak strefy czasowej",
            "dxScheduler-moreAppointments": "{0} kolejne",
            "dxCalendar-currentDay": "Today",
            "dxCalendar-currentMonth": "Current month",
            "dxCalendar-currentYear": "Current year",
            "dxCalendar-currentYearRange": "Current year range",
            "dxCalendar-todayButtonText": "Dzisiaj",
            "dxCalendar-ariaWidgetName": "Kalendarz",
            "dxCalendar-previousMonthButtonLabel": "Previous month",
            "dxCalendar-previousYearButtonLabel": "Previous year",
            "dxCalendar-previousDecadeButtonLabel": "Previous decade",
            "dxCalendar-previousCenturyButtonLabel": "Previous century",
            "dxCalendar-nextMonthButtonLabel": "Next month",
            "dxCalendar-nextYearButtonLabel": "Next year",
            "dxCalendar-nextDecadeButtonLabel": "Next decade",
            "dxCalendar-nextCenturyButtonLabel": "Next century",
            "dxCalendar-captionMonthLabel": "Month selection",
            "dxCalendar-captionYearLabel": "Year selection",
            "dxCalendar-captionDecadeLabel": "Decade selection",
            "dxCalendar-captionCenturyLabel": "Century selection",
            "dxCalendar-selectedDate": "The selected date is {0}",
            "dxCalendar-selectedDates": "The selected dates",
            "dxCalendar-selectedDateRange": "The selected date range is from {0} to {1}",
            "dxCalendar-selectedMultipleDateRange": "from {0} to {1}",
            "dxCalendar-selectedDateRangeCount": "There are {0} selected date ranges",
            "dxCalendar-readOnlyLabel": "Read-only calendar",
            "dxAvatar-defaultImageAlt": "Avatar",
            "dxChat-elementAriaLabel": "Chat",
            "dxChat-textareaPlaceholder": "Type a message",
            "dxChat-sendButtonAriaLabel": "Send",
            "dxChat-defaultUserName": "Unknown User",
            "dxChat-messageListAriaLabel": "Message list",
            "dxChat-alertListAriaLabel": "Error list",
            "dxChat-emptyListMessage": "There are no messages in this chat",
            "dxChat-emptyListPrompt": "Write your first message",
            "dxChat-typingMessageSingleUser": "{0} is typing...",
            "dxChat-typingMessageTwoUsers": "{0} and {1} are typing...",
            "dxChat-typingMessageThreeUsers": "{0}, {1} and {2} are typing...",
            "dxChat-typingMessageMultipleUsers": "{0} and others are typing...",
            "dxColorView-ariaRed": "czerwony",
            "dxColorView-ariaGreen": "zielony",
            "dxColorView-ariaBlue": "niebieski",
            "dxColorView-ariaAlpha": "transparentny",
            "dxColorView-ariaHex": "Warto\u015b\u0107 koloru",
            "dxTagBox-selected": "{0} wybrano",
            "dxTagBox-allSelected": "Wybrano wszystkie ({0})",
            "dxTagBox-moreSelected": "{0} kolejne",
            "dxTagBox-tagRoleDescription": "Tag. Press the delete button to remove this tag",
            "vizExport-printingButtonText": "Drukuj",
            "vizExport-titleMenuText": "Eksport/druk",
            "vizExport-exportButtonText": "Plik {0}",
            "dxFilterBuilder-and": "i",
            "dxFilterBuilder-or": "lub",
            "dxFilterBuilder-notAnd": "Nie i",
            "dxFilterBuilder-notOr": "Nie lub",
            "dxFilterBuilder-addCondition": "Dodaj warunek",
            "dxFilterBuilder-addGroup": "Dodaj grup\u0119",
            "dxFilterBuilder-enterValueText": "<Podaj warto\u015b\u0107>",
            "dxFilterBuilder-filterOperationEquals": "Jest r\xf3wne",
            "dxFilterBuilder-filterOperationNotEquals": "Nie jest r\xf3wne",
            "dxFilterBuilder-filterOperationLess": "Mniejsze ni\u017c",
            "dxFilterBuilder-filterOperationLessOrEquals": "Mniejsze lub r\xf3wne",
            "dxFilterBuilder-filterOperationGreater": "Wi\u0119ksze ni\u017c",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "Wi\u0119ksze lub r\xf3wne",
            "dxFilterBuilder-filterOperationStartsWith": "Zaczyna si\u0119 od",
            "dxFilterBuilder-filterOperationContains": "Zawiera",
            "dxFilterBuilder-filterOperationNotContains": "Nie zawiera",
            "dxFilterBuilder-filterOperationEndsWith": "Ko\u0144czy si\u0119 z",
            "dxFilterBuilder-filterOperationIsBlank": "Jest pusty",
            "dxFilterBuilder-filterOperationIsNotBlank": "Nie jest pusty",
            "dxFilterBuilder-filterOperationBetween": "Pomi\u0119dzy",
            "dxFilterBuilder-filterOperationAnyOf": "Jest zawarty w",
            "dxFilterBuilder-filterOperationNoneOf": "Nie jest zawarty w",
            "dxFilterBuilder-filterAriaRootElement": "Filter builder",
            "dxFilterBuilder-filterAriaGroupLevel": "Level {0}",
            "dxFilterBuilder-filterAriaGroupItem": "Group item",
            "dxFilterBuilder-filterAriaOperationButton": "Operation",
            "dxFilterBuilder-filterAriaAddButton": "Add",
            "dxFilterBuilder-filterAriaRemoveButton": "Remove {0}",
            "dxFilterBuilder-filterAriaItemField": "Item field",
            "dxFilterBuilder-filterAriaItemOperation": "Item operation",
            "dxFilterBuilder-filterAriaItemValue": "Item value",
            "dxHtmlEditor-dialogColorCaption": "Zmie\u0144 kolor czcionki",
            "dxHtmlEditor-dialogBackgroundCaption": "Zmie\u0144 kolor t\u0142a",
            "dxHtmlEditor-dialogLinkCaption": "Dodaj link",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "Tekst",
            "dxHtmlEditor-dialogLinkTargetField": "Otw\xf3rz link w nowym oknie",
            "dxHtmlEditor-dialogImageCaption": "Dodaj obraz",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "Tekst alternatywny",
            "dxHtmlEditor-dialogImageWidthField": "Szeroko\u015b\u0107 (px)",
            "dxHtmlEditor-dialogImageHeightField": "Wysoko\u015b\u0107 obrazu (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "Wiersze",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Kolumny",
            "dxHtmlEditor-dialogInsertTableCaption": "Wstaw tabel\u0119",
            "dxHtmlEditor-dialogUpdateImageCaption": "Aktualizuj obraz",
            "dxHtmlEditor-dialogImageUpdateButton": "Aktualizuj",
            "dxHtmlEditor-dialogImageAddButton": "Dodaj",
            "dxHtmlEditor-dialogImageSpecifyUrl": "Z sieci",
            "dxHtmlEditor-dialogImageSelectFile": "Z tego urz\u0105dzenia",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Zachowaj proporcje stron",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Zakoduj jako Base64",
            "dxHtmlEditor-heading": "Nag\u0142\xf3wek",
            "dxHtmlEditor-normalText": "Zwyk\u0142y tekst",
            "dxHtmlEditor-background": "Kolor t\u0142a",
            "dxHtmlEditor-bold": "Wyt\u0142uszczenie",
            "dxHtmlEditor-color": "Kolor czcionki",
            "dxHtmlEditor-font": "Rodzaj czcionki",
            "dxHtmlEditor-italic": "Kurysywa",
            "dxHtmlEditor-link": "Dodaj link",
            "dxHtmlEditor-image": "Dodaj obraz",
            "dxHtmlEditor-size": "Rozmiar czcionki",
            "dxHtmlEditor-strike": "Przekre\u015blenie",
            "dxHtmlEditor-subscript": "Indeks dolny",
            "dxHtmlEditor-superscript": "Indeks g\xf3rny",
            "dxHtmlEditor-underline": "Podkre\u015blenie",
            "dxHtmlEditor-blockquote": "Cytat blokowy",
            "dxHtmlEditor-header": "Wiersz nag\u0142\xf3wka",
            "dxHtmlEditor-increaseIndent": "Zwi\u0119ksz wci\u0119cie",
            "dxHtmlEditor-decreaseIndent": "Zmniejsz wci\u0119cie",
            "dxHtmlEditor-orderedList": "Lista posortowana",
            "dxHtmlEditor-bulletList": "Numerowanie",
            "dxHtmlEditor-alignLeft": "Do lewej",
            "dxHtmlEditor-alignCenter": "Wy\u015brodkowanie",
            "dxHtmlEditor-alignRight": "Do prawej",
            "dxHtmlEditor-alignJustify": "Wyjustuj",
            "dxHtmlEditor-codeBlock": "Codeblock",
            "dxHtmlEditor-variable": "Dodaj zmienne",
            "dxHtmlEditor-undo": "Wstecz",
            "dxHtmlEditor-redo": "Powt\xf3rz",
            "dxHtmlEditor-clear": "Usu\u0144 formatowanie",
            "dxHtmlEditor-insertTable": "Wstaw tabel\u0119",
            "dxHtmlEditor-insertHeaderRow": "Dodaj nag\u0142\xf3wek",
            "dxHtmlEditor-insertRowAbove": "Wstaw kolumn\u0119 powy\u017cej",
            "dxHtmlEditor-insertRowBelow": "Wstaw kolumn\u0119 poni\u017cej",
            "dxHtmlEditor-insertColumnLeft": "Wstaw kolumn\u0119 po lewej",
            "dxHtmlEditor-insertColumnRight": "Wstaw kolumn\u0119 po prawej",
            "dxHtmlEditor-deleteColumn": "Usu\u0144 kolumn\u0119",
            "dxHtmlEditor-deleteRow": "Usu\u0144 wiersz",
            "dxHtmlEditor-deleteTable": "Usu\u0144 tabel\u0119",
            "dxHtmlEditor-cellProperties": "W\u0142a\u015bciwo\u015bci kom\xf3rki",
            "dxHtmlEditor-tableProperties": "W\u0142a\u015bciwo\u015bci tabeli",
            "dxHtmlEditor-insert": "Wstaw",
            "dxHtmlEditor-delete": "Usu\u0144",
            "dxHtmlEditor-border": "Ramka",
            "dxHtmlEditor-style": "Styl",
            "dxHtmlEditor-width": "Szeroko\u015b\u0107",
            "dxHtmlEditor-height": "wysoko\u015b\u0107",
            "dxHtmlEditor-borderColor": "kolor",
            "dxHtmlEditor-borderWidth": "Border Width",
            "dxHtmlEditor-tableBackground": "t\u0142o",
            "dxHtmlEditor-dimensions": "wymiary",
            "dxHtmlEditor-alignment": "Orientacja",
            "dxHtmlEditor-horizontal": "poziomo",
            "dxHtmlEditor-vertical": "pionowo",
            "dxHtmlEditor-paddingVertical": "Odst\u0119p w pionie",
            "dxHtmlEditor-paddingHorizontal": "Odst\u0119p w poziomie",
            "dxHtmlEditor-pixels": "Piksel",
            "dxHtmlEditor-list": "Lista",
            "dxHtmlEditor-ordered": "Posortowane",
            "dxHtmlEditor-bullet": "Numerowanie",
            "dxHtmlEditor-align": "Wyr\xf3wnaj",
            "dxHtmlEditor-center": "Wy\u015brodkuj",
            "dxHtmlEditor-left": "Po lewej",
            "dxHtmlEditor-right": "Po prawej",
            "dxHtmlEditor-indent": "Wci\u0119cie",
            "dxHtmlEditor-justify": "Wyjustuj",
            "dxHtmlEditor-borderStyleNone": "none",
            "dxHtmlEditor-borderStyleHidden": "hidden",
            "dxHtmlEditor-borderStyleDotted": "dotted",
            "dxHtmlEditor-borderStyleDashed": "dashed",
            "dxHtmlEditor-borderStyleSolid": "solid",
            "dxHtmlEditor-borderStyleDouble": "double",
            "dxHtmlEditor-borderStyleGroove": "groove",
            "dxHtmlEditor-borderStyleRidge": "ridge",
            "dxHtmlEditor-borderStyleInset": "inset",
            "dxHtmlEditor-borderStyleOutset": "outset",
            "dxFileManager-newDirectoryName": "Bez tytu\u0142u",
            "dxFileManager-rootDirectoryName": "Pliki",
            "dxFileManager-errorNoAccess": "Odmowa dost\u0119pu Nie mo\u017cna wykona\u0107 operacji.",
            "dxFileManager-errorDirectoryExistsFormat": "Folder {0} ju\u017c istnieje.",
            "dxFileManager-errorFileExistsFormat": "Plik {0} ju\u017c istnieje.",
            "dxFileManager-errorFileNotFoundFormat": "Nie znaleziono pliku {0}.",
            "dxFileManager-errorDirectoryNotFoundFormat": "Nie znaleziono spisu '{0}\u2019.",
            "dxFileManager-errorWrongFileExtension": "Rozszerzenie pliku jest niedozwolone.",
            "dxFileManager-errorMaxFileSizeExceeded": "Rozmiar pliku przekracza maksymalny dozwolony rozmiar.",
            "dxFileManager-errorInvalidSymbols": "Nazwa pliku zawiera niedozwolone znaki.",
            "dxFileManager-errorDefault": "Nieznany b\u0142\u0105d",
            "dxFileManager-errorDirectoryOpenFailed": "Nie mo\u017cna otworzy\u0107 spisu",
            "dxFileManager-commandCreate": "Nowy spis",
            "dxFileManager-commandRename": "Zmie\u0144 nazw\u0119",
            "dxFileManager-commandMove": "Przesu\u0144 do",
            "dxFileManager-commandCopy": "Kopiuj do",
            "dxFileManager-commandDelete": "Usu\u0144",
            "dxFileManager-commandDownload": "Pobierz",
            "dxFileManager-commandUpload": "Za\u0142aduj plik",
            "dxFileManager-commandRefresh": "Aktualizuj",
            "dxFileManager-commandThumbnails": "Miniatury",
            "dxFileManager-commandDetails": "Widok szczeg\xf3\u0142owy",
            "dxFileManager-commandClearSelection": "Anuluj wyb\xf3r",
            "dxFileManager-commandShowNavPane": "W\u0142\u0105cz/wy\u0142\u0105cz obszar nawigacji",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "Przesu\u0144 do",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "Przesu\u0144",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Kopiuj do",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Kopiuj",
            "dxFileManager-dialogRenameItemTitle": "Zmie\u0144 nazw\u0119",
            "dxFileManager-dialogRenameItemButtonText": "Zapisz",
            "dxFileManager-dialogCreateDirectoryTitle": "Nowy spis",
            "dxFileManager-dialogCreateDirectoryButtonText": "Utw\xf3rz",
            "dxFileManager-dialogDeleteItemTitle": "Usu\u0144",
            "dxFileManager-dialogDeleteItemButtonText": "Usu\u0144",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Czy na pewno chcesz usun\u0105\u0107 {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Czy na pewno chcesz usun\u0105\u0107 te {0} elementy?",
            "dxFileManager-dialogButtonCancel": "Anuluj",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Spis zostanie utworzony w {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Utworzono spis w {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "Nie utworzono spisu",
            "dxFileManager-editingCreateCommonErrorMessage": "Nie utworzono spisu",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Nazwa elementu w {0} zostaje zmieniona na",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Zmieniono nazw\u0119 elementu w {0} na",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Nazwa elementu nie zosta\u0142a zmieniona",
            "dxFileManager-editingRenameCommonErrorMessage": "Nazwa elementu nie zosta\u0142a zmieniona",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Element z {0} jest usuwany",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "{0} Elementy z {1} s\u0105 usuwane",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "Element z {0} zosta\u0142 usuni\u0119ty",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "{0} Elementy z {1} zosta\u0142y usuni\u0119te",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Element nie zosta\u0142 usuni\u0119ty",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} Elementy nie zosta\u0142y usuni\u0119te",
            "dxFileManager-editingDeleteCommonErrorMessage": "Niekt\xf3re elementy nie zosta\u0142y usuni\u0119te",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Element zostanie przesuni\u0119ty do {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "{0} Elementy zostan\u0105 przesuni\u0119te do {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Element zosta\u0142 przesuni\u0119ty do {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "{0} Elementy zosta\u0142y przesuni\u0119te do {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Element nie zosta\u0142 przesuni\u0119ty",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} Elementy nie zosta\u0142y przesuni\u0119te",
            "dxFileManager-editingMoveCommonErrorMessage": "Niekt\xf3re elementy nie zosta\u0142y przesuni\u0119te",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Element zostanie skopiowany do {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "{0} Elementy zostan\u0105 skopiowane do {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Element zosta\u0142 skopiowany do {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "{0} Elementy zosta\u0142y skopiowane do {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Element nie zosta\u0142 skopiowany",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} Elementy nie zosta\u0142y skopiowane",
            "dxFileManager-editingCopyCommonErrorMessage": "Niekt\xf3re elementy nie zosta\u0142y skopiowane",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "Element zostanie za\u0142adowany do {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "{0} Elementy zostan\u0105 za\u0142adowane do {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Element zosta\u0142 za\u0142adowany do {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "{0} Elementy zosta\u0142y za\u0142adowane do {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Element nie zosta\u0142 za\u0142adowany",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} Elementy nie zosta\u0142y za\u0142adowane",
            "dxFileManager-editingUploadCanceledMessage": "Anulowano",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Plik nie zosta\u0142 za\u0142adowany",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} Pliki nie zosta\u0142y za\u0142adowane",
            "dxFileManager-listDetailsColumnCaptionName": "Nazwisko",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Ostatnio zmieniono dnia",
            "dxFileManager-listDetailsColumnCaptionFileSize": "Rozmiar pliku",
            "dxFileManager-listThumbnailsTooltipTextSize": "Rozmiar",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Ostatnio zmieniono dnia",
            "dxFileManager-notificationProgressPanelTitle": "Post\u0119p",
            "dxFileManager-notificationProgressPanelEmptyListText": "Brak proces\xf3w",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Anulowano",
            "dxDiagram-categoryGeneral": "Og\xf3lne",
            "dxDiagram-categoryFlowchart": "Diagram przep\u0142ywu",
            "dxDiagram-categoryOrgChart": "Schemat organizacyjny",
            "dxDiagram-categoryContainers": "Kontener",
            "dxDiagram-categoryCustom": "Spersonalizowany",
            "dxDiagram-commandExportToSvg": "Eksport jako SVG",
            "dxDiagram-commandExportToPng": "Eksport jako PNG",
            "dxDiagram-commandExportToJpg": "Eksport jako JPEG",
            "dxDiagram-commandUndo": "Wstecz",
            "dxDiagram-commandRedo": "Przywr\xf3\u0107",
            "dxDiagram-commandFontName": "Nazwa czcionki",
            "dxDiagram-commandFontSize": "Rozmiar czcionki",
            "dxDiagram-commandBold": "Wyt\u0142uszczenie",
            "dxDiagram-commandItalic": "Kurysywa",
            "dxDiagram-commandUnderline": "Podkre\u015blenie",
            "dxDiagram-commandTextColor": "Kolor tekstu",
            "dxDiagram-commandLineColor": "Kolor linii",
            "dxDiagram-commandLineWidth": "Grubo\u015b\u0107 linii",
            "dxDiagram-commandLineStyle": "Rodzaj linii",
            "dxDiagram-commandLineStyleSolid": "Ci\u0105g\u0142a",
            "dxDiagram-commandLineStyleDotted": "Wykropkowana",
            "dxDiagram-commandLineStyleDashed": "Kreskowa",
            "dxDiagram-commandFillColor": "Kolor wype\u0142nienia",
            "dxDiagram-commandAlignLeft": "Do lewej",
            "dxDiagram-commandAlignCenter": "Wy\u015brodkowanie",
            "dxDiagram-commandAlignRight": "Do prawej",
            "dxDiagram-commandConnectorLineType": "\u0141\u0105cznik typu linii",
            "dxDiagram-commandConnectorLineStraight": "Prosty",
            "dxDiagram-commandConnectorLineOrthogonal": "Prostok\u0105tny",
            "dxDiagram-commandConnectorLineStart": "\u0141\u0105cznik pocz\u0105tku linii",
            "dxDiagram-commandConnectorLineEnd": "\u0141\u0105cznik ko\u0144ca linii",
            "dxDiagram-commandConnectorLineNone": "Brak",
            "dxDiagram-commandConnectorLineArrow": "Strza\u0142ka",
            "dxDiagram-commandFullscreen": "Pe\u0142ny ekran",
            "dxDiagram-commandUnits": "Jednostki",
            "dxDiagram-commandPageSize": "Rozmiar strony",
            "dxDiagram-commandPageOrientation": "Orientacja strony",
            "dxDiagram-commandPageOrientationLandscape": "Format poziomy",
            "dxDiagram-commandPageOrientationPortrait": "Format pionowy",
            "dxDiagram-commandPageColor": "Kolor strony",
            "dxDiagram-commandShowGrid": "Wy\u015bwietl raster",
            "dxDiagram-commandSnapToGrid": "Wyr\xf3wnaj wed\u0142ug rastra",
            "dxDiagram-commandGridSize": "Rozmiar rastra",
            "dxDiagram-commandZoomLevel": "Stopie\u0144 powi\u0119kszenia",
            "dxDiagram-commandAutoZoom": "Automatyczne powi\u0119kszenie",
            "dxDiagram-commandFitToContent": "Dostosuj do zawarto\u015bci",
            "dxDiagram-commandFitToWidth": "Dostosuj do szeroko\u015bci",
            "dxDiagram-commandAutoZoomByContent": "Automatycznie dostosuj do zawarto\u015bci",
            "dxDiagram-commandAutoZoomByWidth": "Automatycznie dostosuj do szeroko\u015bci",
            "dxDiagram-commandSimpleView": "Widok zwyk\u0142y",
            "dxDiagram-commandCut": "Wytnij",
            "dxDiagram-commandCopy": "Kopiuj",
            "dxDiagram-commandPaste": "Wstaw",
            "dxDiagram-commandSelectAll": "Wybierz wszystko",
            "dxDiagram-commandDelete": "Usu\u0144",
            "dxDiagram-commandBringToFront": "Do przodu",
            "dxDiagram-commandSendToBack": "Do ty\u0142u",
            "dxDiagram-commandLock": "Zablokuj",
            "dxDiagram-commandUnlock": "Odblokuj",
            "dxDiagram-commandInsertShapeImage": "Wstaw obraz...",
            "dxDiagram-commandEditShapeImage": "Edytuj obraz...",
            "dxDiagram-commandDeleteShapeImage": "Usu\u0144 obraz",
            "dxDiagram-commandLayoutLeftToRight": "Od lewej do prawej",
            "dxDiagram-commandLayoutRightToLeft": "Od prawej do lewej",
            "dxDiagram-commandLayoutTopToBottom": "Z g\xf3ry na d\xf3\u0142",
            "dxDiagram-commandLayoutBottomToTop": "Z do\u0142u do g\xf3ry",
            "dxDiagram-unitIn": "w/do",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "OK",
            "dxDiagram-dialogButtonCancel": "Anuluj",
            "dxDiagram-dialogInsertShapeImageTitle": "Wstaw obraz",
            "dxDiagram-dialogEditShapeImageTitle": "Edytuj obraz",
            "dxDiagram-dialogEditShapeImageSelectButton": "Wybierz obraz",
            "dxDiagram-dialogEditShapeImageLabelText": "lub umie\u015b\u0107 plik tutaj",
            "dxDiagram-uiExport": "Eksport",
            "dxDiagram-uiProperties": "W\u0142a\u015bciwo\u015bci",
            "dxDiagram-uiSettings": "Ustawienia",
            "dxDiagram-uiShowToolbox": "Poka\u017c przybornik",
            "dxDiagram-uiSearch": "Szukaj",
            "dxDiagram-uiStyle": "Styl",
            "dxDiagram-uiLayout": "Layout",
            "dxDiagram-uiLayoutTree": "Drzewo",
            "dxDiagram-uiLayoutLayered": "Wielowarstwowy",
            "dxDiagram-uiDiagram": "Diagram",
            "dxDiagram-uiText": "Tekst",
            "dxDiagram-uiObject": "Obiekt",
            "dxDiagram-uiConnector": "Powi\u0105zanie",
            "dxDiagram-uiPage": "Strona",
            "dxDiagram-shapeText": "Tekst",
            "dxDiagram-shapeRectangle": "Prostok\u0105t",
            "dxDiagram-shapeEllipse": "Elipsa",
            "dxDiagram-shapeCross": "Krzy\u017c",
            "dxDiagram-shapeTriangle": "Tr\xf3jk\u0105t",
            "dxDiagram-shapeDiamond": "Romb",
            "dxDiagram-shapeHeart": "Serce",
            "dxDiagram-shapePentagon": "Pi\u0119ciok\u0105t",
            "dxDiagram-shapeHexagon": "Sze\u015bciok\u0105t",
            "dxDiagram-shapeOctagon": "O\u015bmiok\u0105t",
            "dxDiagram-shapeStar": "Gwiazda",
            "dxDiagram-shapeArrowLeft": "Strza\u0142ka w lewo",
            "dxDiagram-shapeArrowUp": "Strza\u0142ka w g\xf3r\u0119",
            "dxDiagram-shapeArrowRight": "Strza\u0142ka w prawo",
            "dxDiagram-shapeArrowDown": "Strza\u0142ka w d\xf3\u0142",
            "dxDiagram-shapeArrowUpDown": "Strza\u0142ka w g\xf3r\u0119 i w d\xf3\u0142",
            "dxDiagram-shapeArrowLeftRight": "Strza\u0142ka w lewo i w prawo",
            "dxDiagram-shapeProcess": "Proces",
            "dxDiagram-shapeDecision": "Decyzja",
            "dxDiagram-shapeTerminator": "Zako\u0144czenie",
            "dxDiagram-shapePredefinedProcess": "Predefiniowany proces",
            "dxDiagram-shapeDocument": "Dokument",
            "dxDiagram-shapeMultipleDocuments": "Wiele dokument\xf3w",
            "dxDiagram-shapeManualInput": "Wprowadzanie r\u0119czne",
            "dxDiagram-shapePreparation": "Przygotowanie",
            "dxDiagram-shapeData": "Dane",
            "dxDiagram-shapeDatabase": "Baza danych",
            "dxDiagram-shapeHardDisk": "Dysk twardy",
            "dxDiagram-shapeInternalStorage": "Pami\u0119\u0107 lokalna",
            "dxDiagram-shapePaperTape": "Ta\u015bma dziurkowana",
            "dxDiagram-shapeManualOperation": "Przetwarzanie r\u0119czne",
            "dxDiagram-shapeDelay": "Zw\u0142oka",
            "dxDiagram-shapeStoredData": "Zapisane dane",
            "dxDiagram-shapeDisplay": "Wy\u015bwietlanie",
            "dxDiagram-shapeMerge": "Po\u0142\u0105cz",
            "dxDiagram-shapeConnector": "\u0141\u0105cznik",
            "dxDiagram-shapeOr": "lub",
            "dxDiagram-shapeSummingJunction": "W\u0119ze\u0142 sumowania",
            "dxDiagram-shapeContainerDefaultText": "Kontener",
            "dxDiagram-shapeVerticalContainer": "Kontener pionowy",
            "dxDiagram-shapeHorizontalContainer": "Kontener poziomy",
            "dxDiagram-shapeCardDefaultText": "Nazwisko osoby",
            "dxDiagram-shapeCardWithImageOnLeft": "Karta z obrazkiem po lewej stronie",
            "dxDiagram-shapeCardWithImageOnTop": "Karta z obrazkiem na g\xf3rze",
            "dxDiagram-shapeCardWithImageOnRight": "Karta z obrazkiem po prawej stronie",
            "dxGantt-dialogTitle": "Tytu\u0142",
            "dxGantt-dialogStartTitle": "Pocz\u0105tek",
            "dxGantt-dialogEndTitle": "Koniec",
            "dxGantt-dialogProgressTitle": "Post\u0119p",
            "dxGantt-dialogResourcesTitle": "Zasoby",
            "dxGantt-dialogResourceManagerTitle": "Mened\u017cer zasob\xf3w",
            "dxGantt-dialogTaskDetailsTitle": "Szczeg\xf3\u0142y zadania",
            "dxGantt-dialogEditResourceListHint": "Edytuj list\u0119 zasob\xf3w",
            "dxGantt-dialogEditNoResources": "Brak zasob\xf3w",
            "dxGantt-dialogButtonAdd": "Dodaj",
            "dxGantt-contextMenuNewTask": "Nowe zadanie",
            "dxGantt-contextMenuNewSubtask": "Nowe zadanie cz\u0105stkowe",
            "dxGantt-contextMenuDeleteTask": "Usu\u0144 zadanie",
            "dxGantt-contextMenuDeleteDependency": "Usu\u0144 zale\u017cno\u015bci",
            "dxGantt-dialogTaskDeleteConfirmation": "Zale\u017cno\u015bci i zadania cz\u0105stkowe zostan\u0105 usuni\u0119te razem z tym zadaniem. Czy chcesz usun\u0105\u0107 to zadanie?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Czy chcesz usun\u0105\u0107 zale\u017cno\u015b\u0107 z zadania?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Je\u015bli usuniesz ten zas\xf3b, zostanie on usuni\u0119ty ze wszystkich zada\u0144. Czy chcesz usun\u0105\u0107 zas\xf3b? Zas\xf3b: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "Zadanie, kt\xf3re chcesz przesun\u0105\u0107, jest po\u0142\u0105czone z innym zadaniem zale\u017cno\u015bci\u0105. Zmiana ta naruszy\u0142aby regu\u0142y zale\u017cno\u015bci. Jak chcesz post\u0105pi\u0107?",
            "dxGantt-dialogConstraintViolationMessage": "Zadanie, kt\xf3re chcesz przesun\u0105\u0107, jest po\u0142\u0105czone z innym zadaniem zale\u017cno\u015bci\u0105. Jak chcesz post\u0105pi\u0107?",
            "dxGantt-dialogCancelOperationMessage": "Anuluj dzia\u0142anie",
            "dxGantt-dialogDeleteDependencyMessage": "Usu\u0144 zale\u017cno\u015b\u0107",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Przenie\u015b zadanie i zachowaj zale\u017cno\u015b\u0107",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "Zadanie, kt\xf3re pr\xf3bujesz przesun\u0105\u0107, jest powi\u0105zane z innymi zadaniami poprzez relacje zale\u017cno\u015bci. Zmiana narusza zatem zasady zale\u017cno\u015bci. Jak chcesz post\u0105pi\u0107?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "Zadanie, kt\xf3re pr\xf3bujesz przesun\u0105\u0107, jest powi\u0105zane z innymi zadaniami poprzez relacje zale\u017cno\u015bci. Jak chcesz post\u0105pi\u0107?",
            "dxGantt-dialogDeleteDependenciesMessage": "Usu\u0144 relacje zale\u017cno\u015bci",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Przesu\u0144 zadanie i zachowaj relacje zale\u017cno\u015bci.",
            "dxGantt-undo": "Wstecz",
            "dxGantt-redo": "Przywr\xf3\u0107",
            "dxGantt-expandAll": "Rozwi\u0144 wszystko",
            "dxGantt-collapseAll": "Zwi\u0144 wszystko",
            "dxGantt-addNewTask": "Dodaj nowe zadanie",
            "dxGantt-deleteSelectedTask": "Usu\u0144 wybrane zadanie",
            "dxGantt-zoomIn": "Powi\u0119ksz",
            "dxGantt-zoomOut": "Zmniejsz",
            "dxGantt-fullScreen": "Tryb pe\u0142nego ekranu",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "Sortuj rosn\u0105co",
            "dxGantt-sortingDescendingText": "Sortuj malej\u0105co",
            "dxGantt-sortingClearText": "Resetuj sortowanie",
            "dxGantt-showResources": "Wy\u015bwietl zasoby",
            "dxGantt-showDependencies": "Wy\u015bwietl zale\u017cno\u015bci",
            "dxGantt-dialogStartDateValidation": "Data rozpocz\u0119cia musi by\u0107 p\xf3\u017aniejsza ni\u017c {0}",
            "dxGantt-dialogEndDateValidation": "Data zako\u0144czenia musi by\u0107 p\xf3\u017aniejsza ni\u017c {0}",
            "dxGallery-itemName": "Gallery item",
            "dxMultiView-elementAriaRoleDescription": "MultiView",
            "dxMultiView-elementAriaLabel": "Use the arrow keys or swipe to navigate between views",
            "dxMultiView-itemAriaRoleDescription": "View",
            "dxMultiView-itemAriaLabel": "{0} of {1}",
            "dxSplitter-resizeHandleAriaLabel": "Split bar"
        }
    })
}));
