/*!
 * DevExtreme (dx.web.debug.js)
 * Version: 24.2.3-build-24326-1309
 * Build date: Thu Nov 21 2024
 *
 * Copyright (c) 2012 - 2024 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
! function() {
    var __webpack_modules__ = {
        57329:
            /*!**************************************************************************************************************************!*\
              !*** ../../node_modules/.pnpm/@devextreme+runtime@3.0.13/node_modules/@devextreme/runtime/cjs/inferno/base_component.js ***!
              \**************************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                var __extends = this && this.__extends || (extendStatics = function(d, b) {
                    extendStatics = Object.setPrototypeOf || {
                        __proto__: []
                    }
                    instanceof Array && function(d, b) {
                        d.__proto__ = b
                    } || function(d, b) {
                        for (var p in b) {
                            if (Object.prototype.hasOwnProperty.call(b, p)) {
                                d[p] = b[p]
                            }
                        }
                    };
                    return extendStatics(d, b)
                }, function(d, b) {
                    if ("function" !== typeof b && null !== b) {
                        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null")
                    }
                    extendStatics(d, b);

                    function __() {
                        this.constructor = d
                    }
                    d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, new __)
                });
                var extendStatics;
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.InfernoWrapperComponent = exports.InfernoComponent = exports.BaseInfernoComponent = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 81167);
                var effect_host_1 = __webpack_require__( /*! ./effect_host */ 86734);
                var areObjectsEqual = function(firstObject, secondObject) {
                    var bothAreObjects = firstObject instanceof Object && secondObject instanceof Object;
                    if (!bothAreObjects) {
                        return firstObject === secondObject
                    }
                    var firstObjectKeys = Object.keys(firstObject);
                    var secondObjectKeys = Object.keys(secondObject);
                    if (firstObjectKeys.length !== secondObjectKeys.length) {
                        return false
                    }
                    var hasDifferentElement = firstObjectKeys.some((function(key) {
                        return firstObject[key] !== secondObject[key]
                    }));
                    return !hasDifferentElement
                };
                var BaseInfernoComponent = function(_super) {
                    __extends(BaseInfernoComponent, _super);

                    function BaseInfernoComponent() {
                        var _this = null !== _super && _super.apply(this, arguments) || this;
                        _this._pendingContext = _this.context;
                        return _this
                    }
                    BaseInfernoComponent.prototype.componentWillReceiveProps = function(_, context) {
                        this._pendingContext = null !== context && void 0 !== context ? context : {}
                    };
                    BaseInfernoComponent.prototype.shouldComponentUpdate = function(nextProps, nextState) {
                        return !areObjectsEqual(this.props, nextProps) || !areObjectsEqual(this.state, nextState) || !areObjectsEqual(this.context, this._pendingContext)
                    };
                    return BaseInfernoComponent
                }(inferno_1.Component);
                exports.BaseInfernoComponent = BaseInfernoComponent;
                var InfernoComponent = function(_super) {
                    __extends(InfernoComponent, _super);

                    function InfernoComponent() {
                        var _this = null !== _super && _super.apply(this, arguments) || this;
                        _this._effects = [];
                        return _this
                    }
                    InfernoComponent.prototype.createEffects = function() {
                        return []
                    };
                    InfernoComponent.prototype.updateEffects = function() {};
                    InfernoComponent.prototype.componentWillMount = function() {
                        effect_host_1.InfernoEffectHost.lock()
                    };
                    InfernoComponent.prototype.componentWillUpdate = function(_nextProps, _nextState, _context) {
                        effect_host_1.InfernoEffectHost.lock()
                    };
                    InfernoComponent.prototype.componentDidMount = function() {
                        var _this = this;
                        effect_host_1.InfernoEffectHost.callbacks.push((function() {
                            _this._effects = _this.createEffects()
                        }));
                        effect_host_1.InfernoEffectHost.callEffects()
                    };
                    InfernoComponent.prototype.componentDidUpdate = function() {
                        var _this = this;
                        effect_host_1.InfernoEffectHost.callbacks.push((function() {
                            return _this.updateEffects()
                        }));
                        effect_host_1.InfernoEffectHost.callEffects()
                    };
                    InfernoComponent.prototype.destroyEffects = function() {
                        this._effects.forEach((function(e) {
                            return e.dispose()
                        }))
                    };
                    InfernoComponent.prototype.componentWillUnmount = function() {
                        this.destroyEffects()
                    };
                    return InfernoComponent
                }(BaseInfernoComponent);
                exports.InfernoComponent = InfernoComponent;
                var InfernoWrapperComponent = function(_super) {
                    __extends(InfernoWrapperComponent, _super);

                    function InfernoWrapperComponent() {
                        var _this = null !== _super && _super.apply(this, arguments) || this;
                        _this.vDomElement = null;
                        return _this
                    }
                    InfernoWrapperComponent.prototype.vDomUpdateClasses = function() {
                        var el = this.vDomElement;
                        var currentClasses = el.className.length ? el.className.split(" ") : [];
                        var addedClasses = currentClasses.filter((function(className) {
                            return el.dxClasses.previous.indexOf(className) < 0
                        }));
                        var removedClasses = el.dxClasses.previous.filter((function(className) {
                            return currentClasses.indexOf(className) < 0
                        }));
                        addedClasses.forEach((function(value) {
                            var indexInRemoved = el.dxClasses.removed.indexOf(value);
                            if (indexInRemoved > -1) {
                                el.dxClasses.removed.splice(indexInRemoved, 1)
                            } else if (!el.dxClasses.added.includes(value)) {
                                el.dxClasses.added.push(value)
                            }
                        }));
                        removedClasses.forEach((function(value) {
                            var indexInAdded = el.dxClasses.added.indexOf(value);
                            if (indexInAdded > -1) {
                                el.dxClasses.added.splice(indexInAdded, 1)
                            } else if (!el.dxClasses.removed.includes(value)) {
                                el.dxClasses.removed.push(value)
                            }
                        }))
                    };
                    InfernoWrapperComponent.prototype.componentDidMount = function() {
                        var el = inferno_1.findDOMfromVNode(this.$LI, true);
                        this.vDomElement = el;
                        _super.prototype.componentDidMount.call(this);
                        el.dxClasses = el.dxClasses || {
                            removed: [],
                            added: [],
                            previous: []
                        };
                        el.dxClasses.previous = (null === el || void 0 === el ? void 0 : el.className.length) ? el.className.split(" ") : []
                    };
                    InfernoWrapperComponent.prototype.componentDidUpdate = function() {
                        _super.prototype.componentDidUpdate.call(this);
                        var el = this.vDomElement;
                        if (null !== el) {
                            el.dxClasses.added.forEach((function(className) {
                                return el.classList.add(className)
                            }));
                            el.dxClasses.removed.forEach((function(className) {
                                return el.classList.remove(className)
                            }));
                            el.dxClasses.previous = el.className.length ? el.className.split(" ") : []
                        }
                    };
                    InfernoWrapperComponent.prototype.shouldComponentUpdate = function(nextProps, nextState) {
                        var shouldUpdate = _super.prototype.shouldComponentUpdate.call(this, nextProps, nextState);
                        if (shouldUpdate) {
                            this.vDomUpdateClasses()
                        }
                        return shouldUpdate
                    };
                    return InfernoWrapperComponent
                }(InfernoComponent);
                exports.InfernoWrapperComponent = InfernoWrapperComponent
            },
        83804:
            /*!**************************************************************************************************************************!*\
              !*** ../../node_modules/.pnpm/@devextreme+runtime@3.0.13/node_modules/@devextreme/runtime/cjs/inferno/create_context.js ***!
              \**************************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                var __extends = this && this.__extends || (extendStatics = function(d, b) {
                    extendStatics = Object.setPrototypeOf || {
                        __proto__: []
                    }
                    instanceof Array && function(d, b) {
                        d.__proto__ = b
                    } || function(d, b) {
                        for (var p in b) {
                            if (Object.prototype.hasOwnProperty.call(b, p)) {
                                d[p] = b[p]
                            }
                        }
                    };
                    return extendStatics(d, b)
                }, function(d, b) {
                    if ("function" !== typeof b && null !== b) {
                        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null")
                    }
                    extendStatics(d, b);

                    function __() {
                        this.constructor = d
                    }
                    d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, new __)
                });
                var extendStatics;
                var __assign = this && this.__assign || function() {
                    __assign = Object.assign || function(t) {
                        for (var s, i = 1, n = arguments.length; i < n; i++) {
                            s = arguments[i];
                            for (var p in s) {
                                if (Object.prototype.hasOwnProperty.call(s, p)) {
                                    t[p] = s[p]
                                }
                            }
                        }
                        return t
                    };
                    return __assign.apply(this, arguments)
                };
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.createContext = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 81167);
                var contextId = 0;
                exports.createContext = function(defaultValue) {
                    var id = contextId++;
                    return {
                        id: id,
                        defaultValue: defaultValue,
                        Provider: function(_super) {
                            __extends(class_1, _super);

                            function class_1() {
                                return null !== _super && _super.apply(this, arguments) || this
                            }
                            class_1.prototype.getChildContext = function() {
                                var _a;
                                return __assign(__assign({}, this.context), (_a = {}, _a[id] = this.props.value || defaultValue, _a))
                            };
                            class_1.prototype.render = function() {
                                return this.props.children
                            };
                            return class_1
                        }(inferno_1.Component)
                    }
                }
            },
        43017:
            /*!******************************************************************************************************************!*\
              !*** ../../node_modules/.pnpm/@devextreme+runtime@3.0.13/node_modules/@devextreme/runtime/cjs/inferno/effect.js ***!
              \******************************************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.InfernoEffect = void 0;
                var InfernoEffect = function() {
                    function InfernoEffect(effect, dependency) {
                        this.dependency = dependency;
                        this.effect = effect;
                        this.destroy = effect()
                    }
                    InfernoEffect.prototype.update = function(dependency) {
                        var currentDependency = this.dependency;
                        if (dependency) {
                            this.dependency = dependency
                        }
                        if (!dependency || dependency.some((function(d, i) {
                                return currentDependency[i] !== d
                            }))) {
                            this.dispose();
                            this.destroy = this.effect()
                        }
                    };
                    InfernoEffect.prototype.dispose = function() {
                        if (this.destroy) {
                            this.destroy()
                        }
                    };
                    return InfernoEffect
                }();
                exports.InfernoEffect = InfernoEffect
            },
        86734:
            /*!***********************************************************************************************************************!*\
              !*** ../../node_modules/.pnpm/@devextreme+runtime@3.0.13/node_modules/@devextreme/runtime/cjs/inferno/effect_host.js ***!
              \***********************************************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.InfernoEffectHost = void 0;
                exports.InfernoEffectHost = {
                    lockCount: 0,
                    lock: function() {
                        this.lockCount++
                    },
                    callbacks: [],
                    callEffects: function() {
                        this.lockCount--;
                        if (this.lockCount < 0) {
                            throw new Error("Unexpected Effect Call")
                        }
                        if (0 === this.lockCount) {
                            var effects = this.callbacks;
                            this.callbacks = [];
                            effects.forEach((function(callback) {
                                return callback()
                            }))
                        }
                    }
                }
            },
        49714:
            /*!*****************************************************************************************************************!*\
              !*** ../../node_modules/.pnpm/@devextreme+runtime@3.0.13/node_modules/@devextreme/runtime/cjs/inferno/index.js ***!
              \*****************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                var __createBinding = this && this.__createBinding || (Object.create ? function(o, m, k, k2) {
                    if (void 0 === k2) {
                        k2 = k
                    }
                    Object.defineProperty(o, k2, {
                        enumerable: true,
                        get: function() {
                            return m[k]
                        }
                    })
                } : function(o, m, k, k2) {
                    if (void 0 === k2) {
                        k2 = k
                    }
                    o[k2] = m[k]
                });
                var __exportStar = this && this.__exportStar || function(m, exports) {
                    for (var p in m) {
                        if ("default" !== p && !Object.prototype.hasOwnProperty.call(exports, p)) {
                            __createBinding(exports, m, p)
                        }
                    }
                };
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                __exportStar(__webpack_require__( /*! ./base_component */ 57329), exports);
                __exportStar(__webpack_require__( /*! ./create_context */ 83804), exports);
                __exportStar(__webpack_require__( /*! ./effect */ 43017), exports);
                __exportStar(__webpack_require__( /*! ./effect_host */ 86734), exports);
                __exportStar(__webpack_require__( /*! ./portal */ 38034), exports);
                __exportStar(__webpack_require__( /*! ./ref_object */ 8865), exports);
                __exportStar(__webpack_require__( /*! ./re_render_effect */ 17526), exports);
                __exportStar(__webpack_require__( /*! ./mocked/hydrate */ 86059), exports);
                __exportStar(__webpack_require__( /*! ./render_template */ 74757), exports);
                __exportStar(__webpack_require__( /*! ./normalize_styles */ 43262), exports)
            },
        86059:
            /*!**************************************************************************************************************************!*\
              !*** ../../node_modules/.pnpm/@devextreme+runtime@3.0.13/node_modules/@devextreme/runtime/cjs/inferno/mocked/hydrate.js ***!
              \**************************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.hydrate = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 81167);
                var shared_1 = __webpack_require__( /*! ./shared */ 93055);

                function isSamePropsInnerHTML(dom, props) {
                    return Boolean(props && props.dangerouslySetInnerHTML && props.dangerouslySetInnerHTML.__html && function(dom, innerHTML) {
                        var tempdom = document.createElement("i");
                        tempdom.innerHTML = innerHTML;
                        return tempdom.innerHTML === dom.innerHTML
                    }(dom, props.dangerouslySetInnerHTML.__html))
                }

                function hydrateChildren(parentVNode, parentNode, currentNode, context, isSVG, lifecycle) {
                    var childFlags = parentVNode.childFlags;
                    var children = parentVNode.children;
                    var props = parentVNode.props;
                    var flags = parentVNode.flags;
                    if (1 !== childFlags) {
                        if (2 === childFlags) {
                            if (shared_1.isNull(currentNode)) {
                                inferno_1._M(children, parentNode, context, isSVG, null, lifecycle)
                            } else {
                                currentNode = hydrateVNode(children, parentNode, currentNode, context, isSVG, lifecycle);
                                currentNode = currentNode ? currentNode.nextSibling : null
                            }
                        } else if (16 === childFlags) {
                            if (shared_1.isNull(currentNode)) {
                                parentNode.appendChild(document.createTextNode(children))
                            } else if (1 !== parentNode.childNodes.length || 3 !== currentNode.nodeType) {
                                parentNode.textContent = children
                            } else if (currentNode.nodeValue !== children) {
                                currentNode.nodeValue = children
                            }
                            currentNode = null
                        } else if (12 & childFlags) {
                            var prevVNodeIsTextNode = false;
                            for (var i = 0, len = children.length; i < len; ++i) {
                                var child = children[i];
                                if (shared_1.isNull(currentNode) || prevVNodeIsTextNode && (16 & child.flags) > 0) {
                                    inferno_1._M(child, parentNode, context, isSVG, currentNode, lifecycle)
                                } else {
                                    currentNode = hydrateVNode(child, parentNode, currentNode, context, isSVG, lifecycle);
                                    currentNode = currentNode ? currentNode.nextSibling : null
                                }
                                prevVNodeIsTextNode = (16 & child.flags) > 0
                            }
                        }
                        if (0 === (8192 & flags)) {
                            var nextSibling = null;
                            while (currentNode) {
                                nextSibling = currentNode.nextSibling;
                                parentNode.removeChild(currentNode);
                                currentNode = nextSibling
                            }
                        }
                    } else if (!shared_1.isNull(parentNode.firstChild) && !isSamePropsInnerHTML(parentNode, props)) {
                        parentNode.textContent = "";
                        if (448 & flags) {
                            parentNode.defaultValue = ""
                        }
                    }
                }

                function hydrateText(vNode, parentDOM, dom) {
                    if (3 !== dom.nodeType) {
                        parentDOM.replaceChild(vNode.dom = document.createTextNode(vNode.children), dom)
                    } else {
                        var text = vNode.children;
                        if (dom.nodeValue !== text) {
                            dom.nodeValue = text
                        }
                        vNode.dom = dom
                    }
                    return vNode.dom
                }

                function hydrateVNode(vNode, parentDOM, currentDom, context, isSVG, lifecycle) {
                    var flags = vNode.flags |= 16384;
                    if (14 & flags) {
                        return function(vNode, parentDOM, dom, context, isSVG, isClass, lifecycle) {
                            var type = vNode.type;
                            var ref = vNode.ref;
                            var props = vNode.props || inferno_1.EMPTY_OBJ;
                            var currentNode;
                            if (isClass) {
                                var instance = inferno_1._CI(vNode, type, props, context, isSVG, lifecycle);
                                var input = instance.$LI;
                                currentNode = hydrateVNode(input, parentDOM, dom, instance.$CX, isSVG, lifecycle);
                                inferno_1._MCCC(ref, instance, lifecycle)
                            } else {
                                input = inferno_1._HI(inferno_1._RFC(vNode, context));
                                currentNode = hydrateVNode(input, parentDOM, dom, context, isSVG, lifecycle);
                                vNode.children = input;
                                inferno_1._MFCC(vNode, lifecycle)
                            }
                            return currentNode
                        }(vNode, parentDOM, currentDom, context, isSVG, (4 & flags) > 0, lifecycle)
                    }
                    if (481 & flags) {
                        return function(vNode, parentDOM, dom, context, isSVG, lifecycle) {
                            var props = vNode.props;
                            var className = vNode.className;
                            var flags = vNode.flags;
                            var ref = vNode.ref;
                            isSVG = isSVG || (32 & flags) > 0;
                            if (1 !== dom.nodeType) {
                                inferno_1._ME(vNode, null, context, isSVG, null, lifecycle);
                                parentDOM.replaceChild(vNode.dom, dom)
                            } else {
                                vNode.dom = dom;
                                hydrateChildren(vNode, dom, dom.firstChild, context, isSVG, lifecycle);
                                if (!shared_1.isNull(props)) {
                                    inferno_1._MP(vNode, flags, props, dom, isSVG)
                                }
                                if (shared_1.isNullOrUndef(className)) {
                                    if ("" !== dom.className) {
                                        dom.removeAttribute("class")
                                    }
                                } else if (isSVG) {
                                    dom.setAttribute("class", className)
                                } else {
                                    dom.className = className
                                }
                                inferno_1._MR(ref, dom, lifecycle)
                            }
                            return vNode.dom
                        }(vNode, parentDOM, currentDom, context, isSVG, lifecycle)
                    }
                    if (16 & flags) {
                        return hydrateText(vNode, parentDOM, currentDom)
                    }
                    if (512 & flags) {
                        return vNode.dom = currentDom
                    }
                    if (8192 & flags) {
                        return function(vNode, parentDOM, dom, context, isSVG, lifecycle) {
                            var children = vNode.children;
                            if (2 === vNode.childFlags) {
                                hydrateText(children, parentDOM, dom);
                                return children.dom
                            }
                            hydrateChildren(vNode, parentDOM, dom, context, isSVG, lifecycle);
                            return function(vNode) {
                                var flags;
                                var children;
                                while (vNode) {
                                    flags = vNode.flags;
                                    if (2033 & flags) {
                                        return vNode.dom
                                    }
                                    children = vNode.children;
                                    if (8192 & flags) {
                                        vNode = 2 === vNode.childFlags ? children : children[children.length - 1]
                                    } else if (4 & flags) {
                                        vNode = children.$LI
                                    } else {
                                        vNode = children
                                    }
                                }
                                return null
                            }(children[children.length - 1])
                        }(vNode, parentDOM, currentDom, context, isSVG, lifecycle)
                    }
                    shared_1.throwError();
                    return null
                }
                exports.hydrate = function(input, parentDOM, callback) {
                    var dom = parentDOM.firstChild;
                    if (shared_1.isNull(dom)) {
                        inferno_1.render(input, parentDOM, callback)
                    } else {
                        var lifecycle = [];
                        if (!shared_1.isInvalid(input)) {
                            dom = hydrateVNode(input, parentDOM, dom, {}, false, lifecycle)
                        }
                        while (dom && (dom = dom.nextSibling)) {
                            parentDOM.removeChild(dom)
                        }
                        if (lifecycle.length > 0) {
                            var listener = void 0;
                            while (void 0 !== (listener = lifecycle.shift())) {
                                listener()
                            }
                        }
                    }
                    parentDOM.$V = input;
                    if (shared_1.isFunction(callback)) {
                        callback()
                    }
                }
            },
        93055:
            /*!*************************************************************************************************************************!*\
              !*** ../../node_modules/.pnpm/@devextreme+runtime@3.0.13/node_modules/@devextreme/runtime/cjs/inferno/mocked/shared.js ***!
              \*************************************************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.throwError = exports.isNull = exports.isFunction = exports.isInvalid = exports.isNullOrUndef = exports.ERROR_MSG = void 0;
                exports.ERROR_MSG = "a runtime error occured! Use Inferno in development environment to find the error.";
                exports.isNullOrUndef = function(o) {
                    return void 0 === o || null === o
                };
                exports.isInvalid = function(o) {
                    return null === o || false === o || true === o || void 0 === o
                };
                exports.isFunction = function(o) {
                    return "function" === typeof o
                };
                exports.isNull = function(o) {
                    return null === o
                };
                exports.throwError = function(message) {
                    if (!message) {
                        message = exports.ERROR_MSG
                    }
                    throw new Error("Inferno Error: " + message)
                }
            },
        43262:
            /*!****************************************************************************************************************************!*\
              !*** ../../node_modules/.pnpm/@devextreme+runtime@3.0.13/node_modules/@devextreme/runtime/cjs/inferno/normalize_styles.js ***!
              \****************************************************************************************************************************/
            function(__unused_webpack_module, exports) {
                var __read = this && this.__read || function(o, n) {
                    var m = "function" === typeof Symbol && o[Symbol.iterator];
                    if (!m) {
                        return o
                    }
                    var r, e, i = m.call(o),
                        ar = [];
                    try {
                        while ((void 0 === n || n-- > 0) && !(r = i.next()).done) {
                            ar.push(r.value)
                        }
                    } catch (error) {
                        e = {
                            error: error
                        }
                    } finally {
                        try {
                            if (r && !r.done && (m = i.return)) {
                                m.call(i)
                            }
                        } finally {
                            if (e) {
                                throw e.error
                            }
                        }
                    }
                    return ar
                };
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.normalizeStyles = void 0;
                var NUMBER_STYLES = new Set(["animationIterationCount", "borderImageOutset", "borderImageSlice", "border-imageWidth", "boxFlex", "boxFlexGroup", "boxOrdinalGroup", "columnCount", "fillOpacity", "flex", "flexGrow", "flexNegative", "flexOrder", "flexPositive", "flexShrink", "floodOpacity", "fontWeight", "gridColumn", "gridRow", "lineClamp", "lineHeight", "opacity", "order", "orphans", "stopOpacity", "strokeDasharray", "strokeDashoffset", "strokeMiterlimit", "strokeOpacity", "strokeWidth", "tabSize", "widows", "zIndex", "zoom"]);
                var uppercasePattern = /[A-Z]/g;
                exports.normalizeStyles = function(styles) {
                    if (!(styles instanceof Object)) {
                        return
                    }
                    return Object.entries(styles).reduce((function(acc, _a) {
                        var _b = __read(_a, 2),
                            key = _b[0],
                            value = _b[1];
                        acc[(str = key, str.replace(uppercasePattern, "-$&").toLowerCase())] = function(value) {
                            if ("number" === typeof value) {
                                return true
                            }
                            return !Number.isNaN(Number(value))
                        }(value) ? function(style, value) {
                            return NUMBER_STYLES.has(style) ? value : value + "px"
                        }(key, value) : value;
                        var str;
                        return acc
                    }), {})
                }
            },
        38034:
            /*!******************************************************************************************************************!*\
              !*** ../../node_modules/.pnpm/@devextreme+runtime@3.0.13/node_modules/@devextreme/runtime/cjs/inferno/portal.js ***!
              \******************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Portal = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 81167);
                exports.Portal = function(_a) {
                    var container = _a.container,
                        children = _a.children;
                    if (container) {
                        return inferno_1.createPortal(children, container)
                    }
                    return null
                }
            },
        17526:
            /*!****************************************************************************************************************************!*\
              !*** ../../node_modules/.pnpm/@devextreme+runtime@3.0.13/node_modules/@devextreme/runtime/cjs/inferno/re_render_effect.js ***!
              \****************************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.createReRenderEffect = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 81167);
                var effect_1 = __webpack_require__( /*! ./effect */ 43017);
                exports.createReRenderEffect = function() {
                    return new effect_1.InfernoEffect((function() {
                        inferno_1.rerender()
                    }), [])
                }
            },
        8865:
            /*!**********************************************************************************************************************!*\
              !*** ../../node_modules/.pnpm/@devextreme+runtime@3.0.13/node_modules/@devextreme/runtime/cjs/inferno/ref_object.js ***!
              \**********************************************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                })
            },
        74757:
            /*!***************************************************************************************************************************!*\
              !*** ../../node_modules/.pnpm/@devextreme+runtime@3.0.13/node_modules/@devextreme/runtime/cjs/inferno/render_template.js ***!
              \***************************************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.hasTemplate = exports.renderTemplate = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 81167);
                var inferno_create_element_1 = __webpack_require__( /*! inferno-create-element */ 63935);
                exports.renderTemplate = function(template, props, _component) {
                    setTimeout((function() {
                        inferno_1.render(inferno_create_element_1.createElement(template, props), function(props) {
                            var _a, _b;
                            return (null === (_a = props.container) || void 0 === _a ? void 0 : _a.get(0)) || (null === (_b = props.item) || void 0 === _b ? void 0 : _b.get(0))
                        }(props))
                    }), 0)
                };
                exports.hasTemplate = function(name, properties, _component) {
                    var value = properties[name];
                    return !!value && "string" !== typeof value
                }
            },
        63935:
            /*!********************************************************************************************************************!*\
              !*** ../../node_modules/.pnpm/inferno-create-element@7.4.11/node_modules/inferno-create-element/dist/index.esm.js ***!
              \********************************************************************************************************************/
            function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {
                __webpack_require__.r(__webpack_exports__);
                __webpack_require__.d(__webpack_exports__, {
                    createElement: function() {
                        return createElement
                    }
                });
                var inferno__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__( /*! inferno */ 81167);

                function isNullOrUndef(o) {
                    return void 0 === o || null === o
                }

                function isUndefined(o) {
                    return void 0 === o
                }
                var componentHooks = {
                    onComponentDidMount: 1,
                    onComponentDidUpdate: 1,
                    onComponentShouldUpdate: 1,
                    onComponentWillMount: 1,
                    onComponentWillUnmount: 1,
                    onComponentWillUpdate: 1
                };

                function createElement(type, props, _children) {
                    var arguments$1 = arguments;
                    var children;
                    var ref = null;
                    var key = null;
                    var className = null;
                    var flags = 0;
                    var newProps;
                    var childLen = arguments.length - 2;
                    if (1 === childLen) {
                        children = _children
                    } else if (childLen > 1) {
                        children = [];
                        while (childLen-- > 0) {
                            children[childLen] = arguments$1[childLen + 2]
                        }
                    }
                    if (o = type, "string" === typeof o) {
                        flags = (0, inferno__WEBPACK_IMPORTED_MODULE_0__.getFlagsForElementVnode)(type);
                        if (!isNullOrUndef(props)) {
                            newProps = {};
                            for (var prop in props) {
                                if ("className" === prop || "class" === prop) {
                                    className = props[prop]
                                } else if ("key" === prop) {
                                    key = props.key
                                } else if ("children" === prop && isUndefined(children)) {
                                    children = props.children
                                } else if ("ref" === prop) {
                                    ref = props.ref
                                } else {
                                    if ("contenteditable" === prop) {
                                        flags |= 4096
                                    }
                                    newProps[prop] = props[prop]
                                }
                            }
                        }
                    } else {
                        flags = 2;
                        if (!isUndefined(children)) {
                            if (!props) {
                                props = {}
                            }
                            props.children = children
                        }
                        if (!isNullOrUndef(props)) {
                            newProps = {};
                            for (var prop$1 in props) {
                                if ("key" === prop$1) {
                                    key = props.key
                                } else if ("ref" === prop$1) {
                                    ref = props.ref
                                } else if (1 === componentHooks[prop$1]) {
                                    if (!ref) {
                                        ref = {}
                                    }
                                    ref[prop$1] = props[prop$1]
                                } else {
                                    newProps[prop$1] = props[prop$1]
                                }
                            }
                        }
                        return (0, inferno__WEBPACK_IMPORTED_MODULE_0__.createComponentVNode)(flags, type, newProps, key, ref)
                    }
                    var o;
                    if (8192 & flags) {
                        return (0, inferno__WEBPACK_IMPORTED_MODULE_0__.createFragment)(1 === childLen ? [children] : children, 0, key)
                    }
                    return (0, inferno__WEBPACK_IMPORTED_MODULE_0__.createVNode)(flags, type, className, children, 0, newProps, key, ref)
                }
            },
        81167:
            /*!*********************************************************************************************!*\
              !*** ../../node_modules/.pnpm/inferno@7.4.11/node_modules/inferno/index.esm.js + 1 modules ***!
              \*********************************************************************************************/
            function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {
                __webpack_require__.r(__webpack_exports__);
                __webpack_require__.d(__webpack_exports__, {
                    Component: function() {
                        return Component
                    },
                    EMPTY_OBJ: function() {
                        return EMPTY_OBJ
                    },
                    Fragment: function() {
                        return Fragment
                    },
                    _CI: function() {
                        return createClassComponentInstance
                    },
                    _HI: function() {
                        return normalizeRoot
                    },
                    _M: function() {
                        return mount
                    },
                    _MCCC: function() {
                        return mountClassComponentCallbacks
                    },
                    _ME: function() {
                        return mountElement
                    },
                    _MFCC: function() {
                        return mountFunctionalComponentCallbacks
                    },
                    _MP: function() {
                        return mountProps
                    },
                    _MR: function() {
                        return mountRef
                    },
                    _RFC: function() {
                        return renderFunctionalComponent
                    },
                    __render: function() {
                        return __render
                    },
                    createComponentVNode: function() {
                        return createComponentVNode
                    },
                    createFragment: function() {
                        return createFragment
                    },
                    createPortal: function() {
                        return createPortal
                    },
                    createRef: function() {
                        return createRef
                    },
                    createRenderer: function() {
                        return createRenderer
                    },
                    createTextVNode: function() {
                        return createTextVNode
                    },
                    createVNode: function() {
                        return createVNode
                    },
                    directClone: function() {
                        return directClone
                    },
                    findDOMfromVNode: function() {
                        return findDOMfromVNode
                    },
                    forwardRef: function() {
                        return forwardRef
                    },
                    getFlagsForElementVnode: function() {
                        return getFlagsForElementVnode
                    },
                    linkEvent: function() {
                        return linkEvent
                    },
                    normalizeProps: function() {
                        return normalizeProps
                    },
                    options: function() {
                        return options
                    },
                    render: function() {
                        return render
                    },
                    rerender: function() {
                        return rerender
                    },
                    version: function() {
                        return version
                    }
                });
                var isArray = Array.isArray;

                function isStringOrNumber(o) {
                    var type = typeof o;
                    return "string" === type || "number" === type
                }

                function isNullOrUndef(o) {
                    return void 0 === o || null === o
                }

                function isInvalid(o) {
                    return null === o || false === o || true === o || void 0 === o
                }

                function isFunction(o) {
                    return "function" === typeof o
                }

                function isString(o) {
                    return "string" === typeof o
                }

                function isNull(o) {
                    return null === o
                }

                function combineFrom(first, second) {
                    var out = {};
                    if (first) {
                        for (var key in first) {
                            out[key] = first[key]
                        }
                    }
                    if (second) {
                        for (var key$1 in second) {
                            out[key$1] = second[key$1]
                        }
                    }
                    return out
                }

                function linkEvent(data, event) {
                    if (isFunction(event)) {
                        return {
                            data: data,
                            event: event
                        }
                    }
                    return null
                }

                function isLinkEventObject(o) {
                    return !isNull(o) && "object" === typeof o
                }
                var EMPTY_OBJ = {};
                var Fragment = "$F";

                function normalizeEventName(name) {
                    return name.substr(2).toLowerCase()
                }

                function appendChild(parentDOM, dom) {
                    parentDOM.appendChild(dom)
                }

                function insertOrAppend(parentDOM, newNode, nextNode) {
                    if (isNull(nextNode)) {
                        appendChild(parentDOM, newNode)
                    } else {
                        parentDOM.insertBefore(newNode, nextNode)
                    }
                }

                function removeChild(parentDOM, childNode) {
                    parentDOM.removeChild(childNode)
                }

                function callAll(arrayFn) {
                    for (var i = 0; i < arrayFn.length; i++) {
                        arrayFn[i]()
                    }
                }

                function findChildVNode(vNode, startEdge, flags) {
                    var children = vNode.children;
                    if (4 & flags) {
                        return children.$LI
                    }
                    if (8192 & flags) {
                        return 2 === vNode.childFlags ? children : children[startEdge ? 0 : children.length - 1]
                    }
                    return children
                }

                function findDOMfromVNode(vNode, startEdge) {
                    var flags;
                    while (vNode) {
                        flags = vNode.flags;
                        if (2033 & flags) {
                            return vNode.dom
                        }
                        vNode = findChildVNode(vNode, startEdge, flags)
                    }
                    return null
                }

                function removeVNodeDOM(vNode, parentDOM) {
                    do {
                        var flags = vNode.flags;
                        if (2033 & flags) {
                            removeChild(parentDOM, vNode.dom);
                            return
                        }
                        var children = vNode.children;
                        if (4 & flags) {
                            vNode = children.$LI
                        }
                        if (8 & flags) {
                            vNode = children
                        }
                        if (8192 & flags) {
                            if (2 === vNode.childFlags) {
                                vNode = children
                            } else {
                                for (var i = 0, len = children.length; i < len; ++i) {
                                    removeVNodeDOM(children[i], parentDOM)
                                }
                                return
                            }
                        }
                    } while (vNode)
                }

                function moveVNodeDOM(vNode, parentDOM, nextNode) {
                    do {
                        var flags = vNode.flags;
                        if (2033 & flags) {
                            insertOrAppend(parentDOM, vNode.dom, nextNode);
                            return
                        }
                        var children = vNode.children;
                        if (4 & flags) {
                            vNode = children.$LI
                        }
                        if (8 & flags) {
                            vNode = children
                        }
                        if (8192 & flags) {
                            if (2 === vNode.childFlags) {
                                vNode = children
                            } else {
                                for (var i = 0, len = children.length; i < len; ++i) {
                                    moveVNodeDOM(children[i], parentDOM, nextNode)
                                }
                                return
                            }
                        }
                    } while (vNode)
                }

                function createDerivedState(instance, nextProps, state) {
                    if (instance.constructor.getDerivedStateFromProps) {
                        return combineFrom(state, instance.constructor.getDerivedStateFromProps(nextProps, state))
                    }
                    return state
                }
                var renderCheck = {
                    v: false
                };
                var options = {
                    componentComparator: null,
                    createVNode: null,
                    renderComplete: null
                };

                function setTextContent(dom, children) {
                    dom.textContent = children
                }

                function isLastValueSameLinkEvent(lastValue, nextValue) {
                    return isLinkEventObject(lastValue) && lastValue.event === nextValue.event && lastValue.data === nextValue.data
                }

                function mergeUnsetProperties(to, from) {
                    for (var propName in from) {
                        if (o = to[propName], void 0 === o) {
                            to[propName] = from[propName]
                        }
                    }
                    var o;
                    return to
                }

                function safeCall1(method, arg1) {
                    return !!isFunction(method) && (method(arg1), true)
                }
                var keyPrefix = "$";

                function V(childFlags, children, className, flags, key, props, ref, type) {
                    this.childFlags = childFlags;
                    this.children = children;
                    this.className = className;
                    this.dom = null;
                    this.flags = flags;
                    this.key = void 0 === key ? null : key;
                    this.props = void 0 === props ? null : props;
                    this.ref = void 0 === ref ? null : ref;
                    this.type = type
                }

                function createVNode(flags, type, className, children, childFlags, props, key, ref) {
                    var childFlag = void 0 === childFlags ? 1 : childFlags;
                    var vNode = new V(childFlag, children, className, flags, key, props, ref, type);
                    if (options.createVNode) {
                        options.createVNode(vNode)
                    }
                    if (0 === childFlag) {
                        normalizeChildren(vNode, vNode.children)
                    }
                    return vNode
                }

                function createComponentVNode(flags, type, props, key, ref) {
                    flags = function(flags, type) {
                        if (12 & flags) {
                            return flags
                        }
                        if (type.prototype && type.prototype.render) {
                            return 4
                        }
                        if (type.render) {
                            return 32776
                        }
                        return 8
                    }(flags, type);
                    var vNode = new V(1, null, null, flags, key, function(flags, type, props) {
                        var defaultProps = (32768 & flags ? type.render : type).defaultProps;
                        if (isNullOrUndef(defaultProps)) {
                            return props
                        }
                        if (isNullOrUndef(props)) {
                            return combineFrom(defaultProps, null)
                        }
                        return mergeUnsetProperties(props, defaultProps)
                    }(flags, type, props), function(flags, type, ref) {
                        if (4 & flags) {
                            return ref
                        }
                        var defaultHooks = (32768 & flags ? type.render : type).defaultHooks;
                        if (isNullOrUndef(defaultHooks)) {
                            return ref
                        }
                        if (isNullOrUndef(ref)) {
                            return defaultHooks
                        }
                        return mergeUnsetProperties(ref, defaultHooks)
                    }(flags, type, ref), type);
                    if (options.createVNode) {
                        options.createVNode(vNode)
                    }
                    return vNode
                }

                function createTextVNode(text, key) {
                    return new V(1, isNullOrUndef(text) || true === text || false === text ? "" : text, null, 16, key, null, null, null)
                }

                function createFragment(children, childFlags, key) {
                    var fragment = createVNode(8192, 8192, null, children, childFlags, null, key, null);
                    switch (fragment.childFlags) {
                        case 1:
                            fragment.children = createVoidVNode();
                            fragment.childFlags = 2;
                            break;
                        case 16:
                            fragment.children = [createTextVNode(children)];
                            fragment.childFlags = 4
                    }
                    return fragment
                }

                function normalizeProps(vNode) {
                    var props = vNode.props;
                    if (props) {
                        var flags = vNode.flags;
                        if (481 & flags) {
                            if (void 0 !== props.children && isNullOrUndef(vNode.children)) {
                                normalizeChildren(vNode, props.children)
                            }
                            if (void 0 !== props.className) {
                                if (isNullOrUndef(vNode.className)) {
                                    vNode.className = props.className || null
                                }
                                props.className = void 0
                            }
                        }
                        if (void 0 !== props.key) {
                            vNode.key = props.key;
                            props.key = void 0
                        }
                        if (void 0 !== props.ref) {
                            if (8 & flags) {
                                vNode.ref = combineFrom(vNode.ref, props.ref)
                            } else {
                                vNode.ref = props.ref
                            }
                            props.ref = void 0
                        }
                    }
                    return vNode
                }

                function directClone(vNodeToClone) {
                    var flags = -16385 & vNodeToClone.flags;
                    var props = vNodeToClone.props;
                    if (14 & flags) {
                        if (!isNull(props)) {
                            var propsToClone = props;
                            props = {};
                            for (var key in propsToClone) {
                                props[key] = propsToClone[key]
                            }
                        }
                    }
                    if (0 === (8192 & flags)) {
                        return new V(vNodeToClone.childFlags, vNodeToClone.children, vNodeToClone.className, flags, vNodeToClone.key, props, vNodeToClone.ref, vNodeToClone.type)
                    }
                    return function(vNodeToClone) {
                        var oldChildren = vNodeToClone.children;
                        var childFlags = vNodeToClone.childFlags;
                        return createFragment(2 === childFlags ? directClone(oldChildren) : oldChildren.map(directClone), childFlags, vNodeToClone.key)
                    }(vNodeToClone)
                }

                function createVoidVNode() {
                    return createTextVNode("", null)
                }

                function createPortal(children, container) {
                    var normalizedRoot = normalizeRoot(children);
                    return createVNode(1024, 1024, null, normalizedRoot, 0, null, normalizedRoot.key, container)
                }

                function _normalizeVNodes(nodes, result, index, currentKey) {
                    for (var len = nodes.length; index < len; index++) {
                        var n = nodes[index];
                        if (!isInvalid(n)) {
                            var newKey = currentKey + keyPrefix + index;
                            if (isArray(n)) {
                                _normalizeVNodes(n, result, 0, newKey)
                            } else {
                                if (isStringOrNumber(n)) {
                                    n = createTextVNode(n, newKey)
                                } else {
                                    var oldKey = n.key;
                                    var isPrefixedKey = isString(oldKey) && oldKey[0] === keyPrefix;
                                    if (81920 & n.flags || isPrefixedKey) {
                                        n = directClone(n)
                                    }
                                    n.flags |= 65536;
                                    if (!isPrefixedKey) {
                                        if (isNull(oldKey)) {
                                            n.key = newKey
                                        } else {
                                            n.key = currentKey + oldKey
                                        }
                                    } else if (oldKey.substring(0, currentKey.length) !== currentKey) {
                                        n.key = currentKey + oldKey
                                    }
                                }
                                result.push(n)
                            }
                        }
                    }
                }

                function getFlagsForElementVnode(type) {
                    switch (type) {
                        case "svg":
                            return 32;
                        case "input":
                            return 64;
                        case "select":
                            return 256;
                        case "textarea":
                            return 128;
                        case Fragment:
                            return 8192;
                        default:
                            return 1
                    }
                }

                function normalizeChildren(vNode, children) {
                    var newChildren;
                    var newChildFlags = 1;
                    if (isInvalid(children)) {
                        newChildren = children
                    } else if (isStringOrNumber(children)) {
                        newChildFlags = 16;
                        newChildren = children
                    } else if (isArray(children)) {
                        var len = children.length;
                        for (var i = 0; i < len; ++i) {
                            var n = children[i];
                            if (isInvalid(n) || isArray(n)) {
                                newChildren = newChildren || children.slice(0, i);
                                _normalizeVNodes(children, newChildren, i, "");
                                break
                            } else if (isStringOrNumber(n)) {
                                newChildren = newChildren || children.slice(0, i);
                                newChildren.push(createTextVNode(n, keyPrefix + i))
                            } else {
                                var key = n.key;
                                var needsCloning = (81920 & n.flags) > 0;
                                var isNullKey = isNull(key);
                                var isPrefixed = isString(key) && key[0] === keyPrefix;
                                if (needsCloning || isNullKey || isPrefixed) {
                                    newChildren = newChildren || children.slice(0, i);
                                    if (needsCloning || isPrefixed) {
                                        n = directClone(n)
                                    }
                                    if (isNullKey || isPrefixed) {
                                        n.key = keyPrefix + i
                                    }
                                    newChildren.push(n)
                                } else if (newChildren) {
                                    newChildren.push(n)
                                }
                                n.flags |= 65536
                            }
                        }
                        newChildren = newChildren || children;
                        if (0 === newChildren.length) {
                            newChildFlags = 1
                        } else {
                            newChildFlags = 8
                        }
                    } else {
                        newChildren = children;
                        newChildren.flags |= 65536;
                        if (81920 & children.flags) {
                            newChildren = directClone(children)
                        }
                        newChildFlags = 2
                    }
                    vNode.children = newChildren;
                    vNode.childFlags = newChildFlags;
                    return vNode
                }

                function normalizeRoot(input) {
                    if (isInvalid(input) || isStringOrNumber(input)) {
                        return createTextVNode(input, null)
                    }
                    if (isArray(input)) {
                        return createFragment(input, 0, null)
                    }
                    return 16384 & input.flags ? directClone(input) : input
                }
                var xlinkNS = "http://www.w3.org/1999/xlink";
                var xmlNS = "http://www.w3.org/XML/1998/namespace";
                var namespaces = {
                    "xlink:actuate": xlinkNS,
                    "xlink:arcrole": xlinkNS,
                    "xlink:href": xlinkNS,
                    "xlink:role": xlinkNS,
                    "xlink:show": xlinkNS,
                    "xlink:title": xlinkNS,
                    "xlink:type": xlinkNS,
                    "xml:base": xmlNS,
                    "xml:lang": xmlNS,
                    "xml:space": xmlNS
                };

                function getDelegatedEventObject(v) {
                    return {
                        onClick: v,
                        onDblClick: v,
                        onFocusIn: v,
                        onFocusOut: v,
                        onKeyDown: v,
                        onKeyPress: v,
                        onKeyUp: v,
                        onMouseDown: v,
                        onMouseMove: v,
                        onMouseUp: v,
                        onTouchEnd: v,
                        onTouchMove: v,
                        onTouchStart: v
                    }
                }
                var attachedEventCounts = getDelegatedEventObject(0);
                var attachedEvents = getDelegatedEventObject(null);
                var syntheticEvents = getDelegatedEventObject(true);

                function updateOrAddSyntheticEvent(name, dom) {
                    var eventsObject = dom.$EV;
                    if (!eventsObject) {
                        eventsObject = dom.$EV = getDelegatedEventObject(null)
                    }
                    if (!eventsObject[name]) {
                        if (1 === ++attachedEventCounts[name]) {
                            attachedEvents[name] = function(name) {
                                var attachedEvent = "onClick" === name || "onDblClick" === name ? function(name) {
                                    return function(event) {
                                        if (0 !== event.button) {
                                            event.stopPropagation();
                                            return
                                        }
                                        dispatchEvents(event, true, name, extendEventProperties(event))
                                    }
                                }(name) : function(name) {
                                    return function(event) {
                                        dispatchEvents(event, false, name, extendEventProperties(event))
                                    }
                                }(name);
                                document.addEventListener(normalizeEventName(name), attachedEvent);
                                return attachedEvent
                            }(name)
                        }
                    }
                    return eventsObject
                }

                function unmountSyntheticEvent(name, dom) {
                    var eventsObject = dom.$EV;
                    if (eventsObject && eventsObject[name]) {
                        if (0 === --attachedEventCounts[name]) {
                            document.removeEventListener(normalizeEventName(name), attachedEvents[name]);
                            attachedEvents[name] = null
                        }
                        eventsObject[name] = null
                    }
                }

                function dispatchEvents(event, isClick, name, eventData) {
                    var dom = function(event) {
                        return isFunction(event.composedPath) ? event.composedPath()[0] : event.target
                    }(event);
                    do {
                        if (isClick && dom.disabled) {
                            return
                        }
                        var eventsObject = dom.$EV;
                        if (eventsObject) {
                            var currentEvent = eventsObject[name];
                            if (currentEvent) {
                                eventData.dom = dom;
                                currentEvent.event ? currentEvent.event(currentEvent.data, event) : currentEvent(event);
                                if (event.cancelBubble) {
                                    return
                                }
                            }
                        }
                        dom = dom.parentNode
                    } while (!isNull(dom))
                }

                function stopPropagation() {
                    this.cancelBubble = true;
                    if (!this.immediatePropagationStopped) {
                        this.stopImmediatePropagation()
                    }
                }

                function isDefaultPrevented() {
                    return this.defaultPrevented
                }

                function isPropagationStopped() {
                    return this.cancelBubble
                }

                function extendEventProperties(event) {
                    var eventData = {
                        dom: document
                    };
                    event.isDefaultPrevented = isDefaultPrevented;
                    event.isPropagationStopped = isPropagationStopped;
                    event.stopPropagation = stopPropagation;
                    Object.defineProperty(event, "currentTarget", {
                        configurable: true,
                        get: function() {
                            return eventData.dom
                        }
                    });
                    return eventData
                }

                function triggerEventListener(props, methodName, e) {
                    if (props[methodName]) {
                        var listener = props[methodName];
                        if (listener.event) {
                            listener.event(listener.data, e)
                        } else {
                            listener(e)
                        }
                    } else {
                        var nativeListenerName = methodName.toLowerCase();
                        if (props[nativeListenerName]) {
                            props[nativeListenerName](e)
                        }
                    }
                }

                function createWrappedFunction(methodName, applyValue) {
                    var fnMethod = function(e) {
                        var vNode = this.$V;
                        if (!vNode) {
                            return
                        }
                        var props = vNode.props || EMPTY_OBJ;
                        var dom = vNode.dom;
                        if (isString(methodName)) {
                            triggerEventListener(props, methodName, e)
                        } else {
                            for (var i = 0; i < methodName.length; ++i) {
                                triggerEventListener(props, methodName[i], e)
                            }
                        }
                        if (isFunction(applyValue)) {
                            var newVNode = this.$V;
                            var newProps = newVNode.props || EMPTY_OBJ;
                            applyValue(newProps, dom, false, newVNode)
                        }
                    };
                    Object.defineProperty(fnMethod, "wrapped", {
                        configurable: false,
                        enumerable: false,
                        value: true,
                        writable: false
                    });
                    return fnMethod
                }

                function attachEvent(dom, eventName, handler) {
                    var previousKey = "$" + eventName;
                    var previousArgs = dom[previousKey];
                    if (previousArgs) {
                        if (previousArgs[1].wrapped) {
                            return
                        }
                        dom.removeEventListener(previousArgs[0], previousArgs[1]);
                        dom[previousKey] = null
                    }
                    if (isFunction(handler)) {
                        dom.addEventListener(eventName, handler);
                        dom[previousKey] = [eventName, handler]
                    }
                }

                function isCheckedType(type) {
                    return "checkbox" === type || "radio" === type
                }
                var onTextInputChange = createWrappedFunction("onInput", applyValueInput);
                var wrappedOnChange = createWrappedFunction(["onClick", "onChange"], applyValueInput);

                function emptywrapper(event) {
                    event.stopPropagation()
                }
                emptywrapper.wrapped = true;

                function applyValueInput(nextPropsOrEmpty, dom) {
                    var type = nextPropsOrEmpty.type;
                    var value = nextPropsOrEmpty.value;
                    var checked = nextPropsOrEmpty.checked;
                    var multiple = nextPropsOrEmpty.multiple;
                    var defaultValue = nextPropsOrEmpty.defaultValue;
                    var hasValue = !isNullOrUndef(value);
                    if (type && type !== dom.type) {
                        dom.setAttribute("type", type)
                    }
                    if (!isNullOrUndef(multiple) && multiple !== dom.multiple) {
                        dom.multiple = multiple
                    }
                    if (!isNullOrUndef(defaultValue) && !hasValue) {
                        dom.defaultValue = defaultValue + ""
                    }
                    if (isCheckedType(type)) {
                        if (hasValue) {
                            dom.value = value
                        }
                        if (!isNullOrUndef(checked)) {
                            dom.checked = checked
                        }
                    } else if (hasValue && dom.value !== value) {
                        dom.defaultValue = value;
                        dom.value = value
                    } else if (!isNullOrUndef(checked)) {
                        dom.checked = checked
                    }
                }

                function updateChildOptions(vNode, value) {
                    if ("option" === vNode.type) {
                        ! function(vNode, value) {
                            var props = vNode.props || EMPTY_OBJ;
                            var dom = vNode.dom;
                            dom.value = props.value;
                            if (props.value === value || isArray(value) && -1 !== value.indexOf(props.value)) {
                                dom.selected = true
                            } else if (!isNullOrUndef(value) || !isNullOrUndef(props.selected)) {
                                dom.selected = props.selected || false
                            }
                        }(vNode, value)
                    } else {
                        var children = vNode.children;
                        var flags = vNode.flags;
                        if (4 & flags) {
                            updateChildOptions(children.$LI, value)
                        } else if (8 & flags) {
                            updateChildOptions(children, value)
                        } else if (2 === vNode.childFlags) {
                            updateChildOptions(children, value)
                        } else if (12 & vNode.childFlags) {
                            for (var i = 0, len = children.length; i < len; ++i) {
                                updateChildOptions(children[i], value)
                            }
                        }
                    }
                }
                var onSelectChange = createWrappedFunction("onChange", applyValueSelect);

                function applyValueSelect(nextPropsOrEmpty, dom, mounting, vNode) {
                    var multiplePropInBoolean = Boolean(nextPropsOrEmpty.multiple);
                    if (!isNullOrUndef(nextPropsOrEmpty.multiple) && multiplePropInBoolean !== dom.multiple) {
                        dom.multiple = multiplePropInBoolean
                    }
                    var index = nextPropsOrEmpty.selectedIndex;
                    if (-1 === index) {
                        dom.selectedIndex = -1
                    }
                    var childFlags = vNode.childFlags;
                    if (1 !== childFlags) {
                        var value = nextPropsOrEmpty.value;
                        if ((o = index, "number" === typeof o) && index > -1 && dom.options[index]) {
                            value = dom.options[index].value
                        }
                        if (mounting && isNullOrUndef(value)) {
                            value = nextPropsOrEmpty.defaultValue
                        }
                        updateChildOptions(vNode, value)
                    }
                    var o
                }
                var onTextareaInputChange = createWrappedFunction("onInput", applyValueTextArea);
                var wrappedOnChange$1 = createWrappedFunction("onChange");

                function applyValueTextArea(nextPropsOrEmpty, dom, mounting) {
                    var value = nextPropsOrEmpty.value;
                    var domValue = dom.value;
                    if (isNullOrUndef(value)) {
                        if (mounting) {
                            var defaultValue = nextPropsOrEmpty.defaultValue;
                            if (!isNullOrUndef(defaultValue) && defaultValue !== domValue) {
                                dom.defaultValue = defaultValue;
                                dom.value = defaultValue
                            }
                        }
                    } else if (domValue !== value) {
                        dom.defaultValue = value;
                        dom.value = value
                    }
                }

                function processElement(flags, vNode, dom, nextPropsOrEmpty, mounting, isControlled) {
                    if (64 & flags) {
                        applyValueInput(nextPropsOrEmpty, dom)
                    } else if (256 & flags) {
                        applyValueSelect(nextPropsOrEmpty, dom, mounting, vNode)
                    } else if (128 & flags) {
                        applyValueTextArea(nextPropsOrEmpty, dom, mounting)
                    }
                    if (isControlled) {
                        dom.$V = vNode
                    }
                }

                function addFormElementEventHandlers(flags, dom, nextPropsOrEmpty) {
                    if (64 & flags) {
                        ! function(dom, nextPropsOrEmpty) {
                            if (isCheckedType(nextPropsOrEmpty.type)) {
                                attachEvent(dom, "change", wrappedOnChange);
                                attachEvent(dom, "click", emptywrapper)
                            } else {
                                attachEvent(dom, "input", onTextInputChange)
                            }
                        }(dom, nextPropsOrEmpty)
                    } else if (256 & flags) {
                        ! function(dom) {
                            attachEvent(dom, "change", onSelectChange)
                        }(dom)
                    } else if (128 & flags) {
                        ! function(dom, nextPropsOrEmpty) {
                            attachEvent(dom, "input", onTextareaInputChange);
                            if (nextPropsOrEmpty.onChange) {
                                attachEvent(dom, "change", wrappedOnChange$1)
                            }
                        }(dom, nextPropsOrEmpty)
                    }
                }

                function isControlledFormElement(nextPropsOrEmpty) {
                    return nextPropsOrEmpty.type && isCheckedType(nextPropsOrEmpty.type) ? !isNullOrUndef(nextPropsOrEmpty.checked) : !isNullOrUndef(nextPropsOrEmpty.value)
                }

                function createRef() {
                    return {
                        current: null
                    }
                }

                function forwardRef(render) {
                    return {
                        render: render
                    }
                }

                function unmountRef(ref) {
                    if (ref) {
                        if (!safeCall1(ref, null) && ref.current) {
                            ref.current = null
                        }
                    }
                }

                function mountRef(ref, value, lifecycle) {
                    if (ref && (isFunction(ref) || void 0 !== ref.current)) {
                        lifecycle.push((function() {
                            if (!safeCall1(ref, value) && void 0 !== ref.current) {
                                ref.current = value
                            }
                        }))
                    }
                }

                function remove(vNode, parentDOM) {
                    unmount(vNode);
                    removeVNodeDOM(vNode, parentDOM)
                }

                function unmount(vNode) {
                    var flags = vNode.flags;
                    var children = vNode.children;
                    var ref;
                    if (481 & flags) {
                        ref = vNode.ref;
                        var props = vNode.props;
                        unmountRef(ref);
                        var childFlags = vNode.childFlags;
                        if (!isNull(props)) {
                            var keys = Object.keys(props);
                            for (var i = 0, len = keys.length; i < len; i++) {
                                var key = keys[i];
                                if (syntheticEvents[key]) {
                                    unmountSyntheticEvent(key, vNode.dom)
                                }
                            }
                        }
                        if (12 & childFlags) {
                            unmountAllChildren(children)
                        } else if (2 === childFlags) {
                            unmount(children)
                        }
                    } else if (children) {
                        if (4 & flags) {
                            if (isFunction(children.componentWillUnmount)) {
                                children.componentWillUnmount()
                            }
                            unmountRef(vNode.ref);
                            children.$UN = true;
                            unmount(children.$LI)
                        } else if (8 & flags) {
                            ref = vNode.ref;
                            if (!isNullOrUndef(ref) && isFunction(ref.onComponentWillUnmount)) {
                                ref.onComponentWillUnmount(findDOMfromVNode(vNode, true), vNode.props || EMPTY_OBJ)
                            }
                            unmount(children)
                        } else if (1024 & flags) {
                            remove(children, vNode.ref)
                        } else if (8192 & flags) {
                            if (12 & vNode.childFlags) {
                                unmountAllChildren(children)
                            }
                        }
                    }
                }

                function unmountAllChildren(children) {
                    for (var i = 0, len = children.length; i < len; ++i) {
                        unmount(children[i])
                    }
                }

                function clearDOM(dom) {
                    dom.textContent = ""
                }

                function removeAllChildren(dom, vNode, children) {
                    unmountAllChildren(children);
                    if (8192 & vNode.flags) {
                        removeVNodeDOM(vNode, dom)
                    } else {
                        clearDOM(dom)
                    }
                }

                function patchDangerInnerHTML(lastValue, nextValue, lastVNode, dom) {
                    var lastHtml = lastValue && lastValue.__html || "";
                    var nextHtml = nextValue && nextValue.__html || "";
                    if (lastHtml !== nextHtml) {
                        if (!isNullOrUndef(nextHtml) && ! function(dom, innerHTML) {
                                var tempdom = document.createElement("i");
                                tempdom.innerHTML = innerHTML;
                                return tempdom.innerHTML === dom.innerHTML
                            }(dom, nextHtml)) {
                            if (!isNull(lastVNode)) {
                                if (12 & lastVNode.childFlags) {
                                    unmountAllChildren(lastVNode.children)
                                } else if (2 === lastVNode.childFlags) {
                                    unmount(lastVNode.children)
                                }
                                lastVNode.children = null;
                                lastVNode.childFlags = 1
                            }
                            dom.innerHTML = nextHtml
                        }
                    }
                }

                function patchProp(prop, lastValue, nextValue, dom, isSVG, hasControlledValue, lastVNode) {
                    switch (prop) {
                        case "children":
                        case "childrenType":
                        case "className":
                        case "defaultValue":
                        case "key":
                        case "multiple":
                        case "ref":
                        case "selectedIndex":
                            break;
                        case "autoFocus":
                            dom.autofocus = !!nextValue;
                            break;
                        case "allowfullscreen":
                        case "autoplay":
                        case "capture":
                        case "checked":
                        case "controls":
                        case "default":
                        case "disabled":
                        case "hidden":
                        case "indeterminate":
                        case "loop":
                        case "muted":
                        case "novalidate":
                        case "open":
                        case "readOnly":
                        case "required":
                        case "reversed":
                        case "scoped":
                        case "seamless":
                        case "selected":
                            dom[prop] = !!nextValue;
                            break;
                        case "defaultChecked":
                        case "value":
                        case "volume":
                            if (hasControlledValue && "value" === prop) {
                                break
                            }
                            var value = isNullOrUndef(nextValue) ? "" : nextValue;
                            if (dom[prop] !== value) {
                                dom[prop] = value
                            }
                            break;
                        case "style":
                            ! function(lastAttrValue, nextAttrValue, dom) {
                                if (isNullOrUndef(nextAttrValue)) {
                                    dom.removeAttribute("style");
                                    return
                                }
                                var domStyle = dom.style;
                                var style;
                                var value;
                                if (isString(nextAttrValue)) {
                                    domStyle.cssText = nextAttrValue;
                                    return
                                }
                                if (!isNullOrUndef(lastAttrValue) && !isString(lastAttrValue)) {
                                    for (style in nextAttrValue) {
                                        value = nextAttrValue[style];
                                        if (value !== lastAttrValue[style]) {
                                            domStyle.setProperty(style, value)
                                        }
                                    }
                                    for (style in lastAttrValue) {
                                        if (isNullOrUndef(nextAttrValue[style])) {
                                            domStyle.removeProperty(style)
                                        }
                                    }
                                } else {
                                    for (style in nextAttrValue) {
                                        value = nextAttrValue[style];
                                        domStyle.setProperty(style, value)
                                    }
                                }
                            }(lastValue, nextValue, dom);
                            break;
                        case "dangerouslySetInnerHTML":
                            patchDangerInnerHTML(lastValue, nextValue, lastVNode, dom);
                            break;
                        default:
                            if (syntheticEvents[prop]) {
                                ! function(name, lastEvent, nextEvent, dom) {
                                    if (isFunction(nextEvent)) {
                                        updateOrAddSyntheticEvent(name, dom)[name] = nextEvent
                                    } else if (isLinkEventObject(nextEvent)) {
                                        if (isLastValueSameLinkEvent(lastEvent, nextEvent)) {
                                            return
                                        }
                                        updateOrAddSyntheticEvent(name, dom)[name] = nextEvent
                                    } else {
                                        unmountSyntheticEvent(name, dom)
                                    }
                                }(prop, lastValue, nextValue, dom)
                            } else if (111 === prop.charCodeAt(0) && 110 === prop.charCodeAt(1)) {
                                ! function(name, lastValue, nextValue, dom) {
                                    if (isLinkEventObject(nextValue)) {
                                        if (isLastValueSameLinkEvent(lastValue, nextValue)) {
                                            return
                                        }
                                        nextValue = function(nextValue) {
                                            var ev = nextValue.event;
                                            return function(e) {
                                                ev(nextValue.data, e)
                                            }
                                        }(nextValue)
                                    }
                                    attachEvent(dom, normalizeEventName(name), nextValue)
                                }(prop, lastValue, nextValue, dom)
                            } else if (isNullOrUndef(nextValue)) {
                                dom.removeAttribute(prop)
                            } else if (isSVG && namespaces[prop]) {
                                dom.setAttributeNS(namespaces[prop], prop, nextValue)
                            } else {
                                dom.setAttribute(prop, nextValue)
                            }
                    }
                }

                function mountProps(vNode, flags, props, dom, isSVG) {
                    var hasControlledValue = false;
                    var isFormElement = (448 & flags) > 0;
                    if (isFormElement) {
                        hasControlledValue = isControlledFormElement(props);
                        if (hasControlledValue) {
                            addFormElementEventHandlers(flags, dom, props)
                        }
                    }
                    for (var prop in props) {
                        patchProp(prop, null, props[prop], dom, isSVG, hasControlledValue, null)
                    }
                    if (isFormElement) {
                        processElement(flags, vNode, dom, props, true, hasControlledValue)
                    }
                }

                function renderNewInput(instance, props, context) {
                    var nextInput = normalizeRoot(instance.render(props, instance.state, context));
                    var childContext = context;
                    if (isFunction(instance.getChildContext)) {
                        childContext = combineFrom(context, instance.getChildContext())
                    }
                    instance.$CX = childContext;
                    return nextInput
                }

                function createClassComponentInstance(vNode, Component, props, context, isSVG, lifecycle) {
                    var instance = new Component(props, context);
                    var usesNewAPI = instance.$N = Boolean(Component.getDerivedStateFromProps || instance.getSnapshotBeforeUpdate);
                    instance.$SVG = isSVG;
                    instance.$L = lifecycle;
                    vNode.children = instance;
                    instance.$BS = false;
                    instance.context = context;
                    if (instance.props === EMPTY_OBJ) {
                        instance.props = props
                    }
                    if (!usesNewAPI) {
                        if (isFunction(instance.componentWillMount)) {
                            instance.$BR = true;
                            instance.componentWillMount();
                            var pending = instance.$PS;
                            if (!isNull(pending)) {
                                var state = instance.state;
                                if (isNull(state)) {
                                    instance.state = pending
                                } else {
                                    for (var key in pending) {
                                        state[key] = pending[key]
                                    }
                                }
                                instance.$PS = null
                            }
                            instance.$BR = false
                        }
                    } else {
                        instance.state = createDerivedState(instance, props, instance.state)
                    }
                    instance.$LI = renderNewInput(instance, props, context);
                    return instance
                }

                function renderFunctionalComponent(vNode, context) {
                    var props = vNode.props || EMPTY_OBJ;
                    return 32768 & vNode.flags ? vNode.type.render(props, vNode.ref, context) : vNode.type(props, context)
                }

                function mount(vNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                    var flags = vNode.flags |= 16384;
                    if (481 & flags) {
                        mountElement(vNode, parentDOM, context, isSVG, nextNode, lifecycle)
                    } else if (4 & flags) {
                        ! function(vNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                            var instance = createClassComponentInstance(vNode, vNode.type, vNode.props || EMPTY_OBJ, context, isSVG, lifecycle);
                            mount(instance.$LI, parentDOM, instance.$CX, isSVG, nextNode, lifecycle);
                            mountClassComponentCallbacks(vNode.ref, instance, lifecycle)
                        }(vNode, parentDOM, context, isSVG, nextNode, lifecycle)
                    } else if (8 & flags) {
                        ! function(vNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                            mount(vNode.children = normalizeRoot(renderFunctionalComponent(vNode, context)), parentDOM, context, isSVG, nextNode, lifecycle)
                        }(vNode, parentDOM, context, isSVG, nextNode, lifecycle);
                        mountFunctionalComponentCallbacks(vNode, lifecycle)
                    } else if (512 & flags || 16 & flags) {
                        mountText(vNode, parentDOM, nextNode)
                    } else if (8192 & flags) {
                        ! function(vNode, context, parentDOM, isSVG, nextNode, lifecycle) {
                            var children = vNode.children;
                            var childFlags = vNode.childFlags;
                            if (12 & childFlags && 0 === children.length) {
                                childFlags = vNode.childFlags = 2;
                                children = vNode.children = createVoidVNode()
                            }
                            if (2 === childFlags) {
                                mount(children, parentDOM, context, isSVG, nextNode, lifecycle)
                            } else {
                                mountArrayChildren(children, parentDOM, context, isSVG, nextNode, lifecycle)
                            }
                        }(vNode, context, parentDOM, isSVG, nextNode, lifecycle)
                    } else if (1024 & flags) {
                        ! function(vNode, context, parentDOM, nextNode, lifecycle) {
                            mount(vNode.children, vNode.ref, context, false, null, lifecycle);
                            var placeHolderVNode = createVoidVNode();
                            mountText(placeHolderVNode, parentDOM, nextNode);
                            vNode.dom = placeHolderVNode.dom
                        }(vNode, context, parentDOM, nextNode, lifecycle)
                    }
                }

                function mountText(vNode, parentDOM, nextNode) {
                    var dom = vNode.dom = document.createTextNode(vNode.children);
                    if (!isNull(parentDOM)) {
                        insertOrAppend(parentDOM, dom, nextNode)
                    }
                }

                function mountElement(vNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                    var flags = vNode.flags;
                    var props = vNode.props;
                    var className = vNode.className;
                    var childFlags = vNode.childFlags;
                    var dom = vNode.dom = function(tag, isSVG) {
                        if (isSVG) {
                            return document.createElementNS("http://www.w3.org/2000/svg", tag)
                        }
                        return document.createElement(tag)
                    }(vNode.type, isSVG = isSVG || (32 & flags) > 0);
                    var children = vNode.children;
                    if (!isNullOrUndef(className) && "" !== className) {
                        if (isSVG) {
                            dom.setAttribute("class", className)
                        } else {
                            dom.className = className
                        }
                    }
                    if (16 === childFlags) {
                        setTextContent(dom, children)
                    } else if (1 !== childFlags) {
                        var childrenIsSVG = isSVG && "foreignObject" !== vNode.type;
                        if (2 === childFlags) {
                            if (16384 & children.flags) {
                                vNode.children = children = directClone(children)
                            }
                            mount(children, dom, context, childrenIsSVG, null, lifecycle)
                        } else if (8 === childFlags || 4 === childFlags) {
                            mountArrayChildren(children, dom, context, childrenIsSVG, null, lifecycle)
                        }
                    }
                    if (!isNull(parentDOM)) {
                        insertOrAppend(parentDOM, dom, nextNode)
                    }
                    if (!isNull(props)) {
                        mountProps(vNode, flags, props, dom, isSVG)
                    }
                    mountRef(vNode.ref, dom, lifecycle)
                }

                function mountArrayChildren(children, dom, context, isSVG, nextNode, lifecycle) {
                    for (var i = 0; i < children.length; ++i) {
                        var child = children[i];
                        if (16384 & child.flags) {
                            children[i] = child = directClone(child)
                        }
                        mount(child, dom, context, isSVG, nextNode, lifecycle)
                    }
                }

                function mountClassComponentCallbacks(ref, instance, lifecycle) {
                    mountRef(ref, instance, lifecycle);
                    if (isFunction(instance.componentDidMount)) {
                        lifecycle.push(function(instance) {
                            return function() {
                                instance.componentDidMount()
                            }
                        }(instance))
                    }
                }

                function mountFunctionalComponentCallbacks(vNode, lifecycle) {
                    var ref = vNode.ref;
                    if (!isNullOrUndef(ref)) {
                        safeCall1(ref.onComponentWillMount, vNode.props || EMPTY_OBJ);
                        if (isFunction(ref.onComponentDidMount)) {
                            lifecycle.push(function(ref, vNode) {
                                return function() {
                                    ref.onComponentDidMount(findDOMfromVNode(vNode, true), vNode.props || EMPTY_OBJ)
                                }
                            }(ref, vNode))
                        }
                    }
                }

                function patch(lastVNode, nextVNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                    var nextFlags = nextVNode.flags |= 16384;
                    if (lastVNode.flags !== nextFlags || lastVNode.type !== nextVNode.type || lastVNode.key !== nextVNode.key || 2048 & nextFlags) {
                        if (16384 & lastVNode.flags) {
                            ! function(lastVNode, nextVNode, parentDOM, context, isSVG, lifecycle) {
                                unmount(lastVNode);
                                if (0 !== (nextVNode.flags & lastVNode.flags & 2033)) {
                                    mount(nextVNode, null, context, isSVG, null, lifecycle);
                                    ! function(parentDOM, newDom, lastDom) {
                                        parentDOM.replaceChild(newDom, lastDom)
                                    }(parentDOM, nextVNode.dom, lastVNode.dom)
                                } else {
                                    mount(nextVNode, parentDOM, context, isSVG, findDOMfromVNode(lastVNode, true), lifecycle);
                                    removeVNodeDOM(lastVNode, parentDOM)
                                }
                            }(lastVNode, nextVNode, parentDOM, context, isSVG, lifecycle)
                        } else {
                            mount(nextVNode, parentDOM, context, isSVG, nextNode, lifecycle)
                        }
                    } else if (481 & nextFlags) {
                        ! function(lastVNode, nextVNode, context, isSVG, nextFlags, lifecycle) {
                            var dom = nextVNode.dom = lastVNode.dom;
                            var lastProps = lastVNode.props;
                            var nextProps = nextVNode.props;
                            var isFormElement = false;
                            var hasControlledValue = false;
                            var nextPropsOrEmpty;
                            isSVG = isSVG || (32 & nextFlags) > 0;
                            if (lastProps !== nextProps) {
                                var lastPropsOrEmpty = lastProps || EMPTY_OBJ;
                                nextPropsOrEmpty = nextProps || EMPTY_OBJ;
                                if (nextPropsOrEmpty !== EMPTY_OBJ) {
                                    isFormElement = (448 & nextFlags) > 0;
                                    if (isFormElement) {
                                        hasControlledValue = isControlledFormElement(nextPropsOrEmpty)
                                    }
                                    for (var prop in nextPropsOrEmpty) {
                                        var lastValue = lastPropsOrEmpty[prop];
                                        var nextValue = nextPropsOrEmpty[prop];
                                        if (lastValue !== nextValue) {
                                            patchProp(prop, lastValue, nextValue, dom, isSVG, hasControlledValue, lastVNode)
                                        }
                                    }
                                }
                                if (lastPropsOrEmpty !== EMPTY_OBJ) {
                                    for (var prop$1 in lastPropsOrEmpty) {
                                        if (isNullOrUndef(nextPropsOrEmpty[prop$1]) && !isNullOrUndef(lastPropsOrEmpty[prop$1])) {
                                            patchProp(prop$1, lastPropsOrEmpty[prop$1], null, dom, isSVG, hasControlledValue, lastVNode)
                                        }
                                    }
                                }
                            }
                            var nextChildren = nextVNode.children;
                            var nextClassName = nextVNode.className;
                            if (lastVNode.className !== nextClassName) {
                                if (isNullOrUndef(nextClassName)) {
                                    dom.removeAttribute("class")
                                } else if (isSVG) {
                                    dom.setAttribute("class", nextClassName)
                                } else {
                                    dom.className = nextClassName
                                }
                            }
                            if (4096 & nextFlags) {
                                ! function(dom, nextChildren) {
                                    if (dom.textContent !== nextChildren) {
                                        dom.textContent = nextChildren
                                    }
                                }(dom, nextChildren)
                            } else {
                                patchChildren(lastVNode.childFlags, nextVNode.childFlags, lastVNode.children, nextChildren, dom, context, isSVG && "foreignObject" !== nextVNode.type, null, lastVNode, lifecycle)
                            }
                            if (isFormElement) {
                                processElement(nextFlags, nextVNode, dom, nextPropsOrEmpty, false, hasControlledValue)
                            }
                            var nextRef = nextVNode.ref;
                            var lastRef = lastVNode.ref;
                            if (lastRef !== nextRef) {
                                unmountRef(lastRef);
                                mountRef(nextRef, dom, lifecycle)
                            }
                        }(lastVNode, nextVNode, context, isSVG, nextFlags, lifecycle)
                    } else if (4 & nextFlags) {
                        ! function(lastVNode, nextVNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                            var instance = nextVNode.children = lastVNode.children;
                            if (isNull(instance)) {
                                return
                            }
                            instance.$L = lifecycle;
                            var nextProps = nextVNode.props || EMPTY_OBJ;
                            var nextRef = nextVNode.ref;
                            var lastRef = lastVNode.ref;
                            var nextState = instance.state;
                            if (!instance.$N) {
                                if (isFunction(instance.componentWillReceiveProps)) {
                                    instance.$BR = true;
                                    instance.componentWillReceiveProps(nextProps, context);
                                    if (instance.$UN) {
                                        return
                                    }
                                    instance.$BR = false
                                }
                                if (!isNull(instance.$PS)) {
                                    nextState = combineFrom(nextState, instance.$PS);
                                    instance.$PS = null
                                }
                            }
                            updateClassComponent(instance, nextState, nextProps, parentDOM, context, isSVG, false, nextNode, lifecycle);
                            if (lastRef !== nextRef) {
                                unmountRef(lastRef);
                                mountRef(nextRef, instance, lifecycle)
                            }
                        }(lastVNode, nextVNode, parentDOM, context, isSVG, nextNode, lifecycle)
                    } else if (8 & nextFlags) {
                        ! function(lastVNode, nextVNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                            var shouldUpdate = true;
                            var nextProps = nextVNode.props || EMPTY_OBJ;
                            var nextRef = nextVNode.ref;
                            var lastProps = lastVNode.props;
                            var nextHooksDefined = !isNullOrUndef(nextRef);
                            var lastInput = lastVNode.children;
                            if (nextHooksDefined && isFunction(nextRef.onComponentShouldUpdate)) {
                                shouldUpdate = nextRef.onComponentShouldUpdate(lastProps, nextProps)
                            }
                            if (false !== shouldUpdate) {
                                if (nextHooksDefined && isFunction(nextRef.onComponentWillUpdate)) {
                                    nextRef.onComponentWillUpdate(lastProps, nextProps)
                                }
                                var nextInput = normalizeRoot(renderFunctionalComponent(nextVNode, context));
                                patch(lastInput, nextInput, parentDOM, context, isSVG, nextNode, lifecycle);
                                nextVNode.children = nextInput;
                                if (nextHooksDefined && isFunction(nextRef.onComponentDidUpdate)) {
                                    nextRef.onComponentDidUpdate(lastProps, nextProps)
                                }
                            } else {
                                nextVNode.children = lastInput
                            }
                        }(lastVNode, nextVNode, parentDOM, context, isSVG, nextNode, lifecycle)
                    } else if (16 & nextFlags) {
                        ! function(lastVNode, nextVNode) {
                            var nextText = nextVNode.children;
                            var dom = nextVNode.dom = lastVNode.dom;
                            if (nextText !== lastVNode.children) {
                                dom.nodeValue = nextText
                            }
                        }(lastVNode, nextVNode)
                    } else if (512 & nextFlags) {
                        nextVNode.dom = lastVNode.dom
                    } else if (8192 & nextFlags) {
                        ! function(lastVNode, nextVNode, parentDOM, context, isSVG, lifecycle) {
                            var lastChildren = lastVNode.children;
                            var nextChildren = nextVNode.children;
                            var lastChildFlags = lastVNode.childFlags;
                            var nextChildFlags = nextVNode.childFlags;
                            var nextNode = null;
                            if (12 & nextChildFlags && 0 === nextChildren.length) {
                                nextChildFlags = nextVNode.childFlags = 2;
                                nextChildren = nextVNode.children = createVoidVNode()
                            }
                            var nextIsSingle = 0 !== (2 & nextChildFlags);
                            if (12 & lastChildFlags) {
                                var lastLen = lastChildren.length;
                                if (8 & lastChildFlags && 8 & nextChildFlags || nextIsSingle || !nextIsSingle && nextChildren.length > lastLen) {
                                    nextNode = findDOMfromVNode(lastChildren[lastLen - 1], false).nextSibling
                                }
                            }
                            patchChildren(lastChildFlags, nextChildFlags, lastChildren, nextChildren, parentDOM, context, isSVG, nextNode, lastVNode, lifecycle)
                        }(lastVNode, nextVNode, parentDOM, context, isSVG, lifecycle)
                    } else {
                        ! function(lastVNode, nextVNode, context, lifecycle) {
                            var lastContainer = lastVNode.ref;
                            var nextContainer = nextVNode.ref;
                            var nextChildren = nextVNode.children;
                            patchChildren(lastVNode.childFlags, nextVNode.childFlags, lastVNode.children, nextChildren, lastContainer, context, false, null, lastVNode, lifecycle);
                            nextVNode.dom = lastVNode.dom;
                            if (lastContainer !== nextContainer && !isInvalid(nextChildren)) {
                                var node = nextChildren.dom;
                                removeChild(lastContainer, node);
                                appendChild(nextContainer, node)
                            }
                        }(lastVNode, nextVNode, context, lifecycle)
                    }
                }

                function patchChildren(lastChildFlags, nextChildFlags, lastChildren, nextChildren, parentDOM, context, isSVG, nextNode, parentVNode, lifecycle) {
                    switch (lastChildFlags) {
                        case 2:
                            switch (nextChildFlags) {
                                case 2:
                                    patch(lastChildren, nextChildren, parentDOM, context, isSVG, nextNode, lifecycle);
                                    break;
                                case 1:
                                    remove(lastChildren, parentDOM);
                                    break;
                                case 16:
                                    unmount(lastChildren);
                                    setTextContent(parentDOM, nextChildren);
                                    break;
                                default:
                                    ! function(lastChildren, nextChildren, parentDOM, context, isSVG, lifecycle) {
                                        unmount(lastChildren);
                                        mountArrayChildren(nextChildren, parentDOM, context, isSVG, findDOMfromVNode(lastChildren, true), lifecycle);
                                        removeVNodeDOM(lastChildren, parentDOM)
                                    }(lastChildren, nextChildren, parentDOM, context, isSVG, lifecycle)
                            }
                            break;
                        case 1:
                            switch (nextChildFlags) {
                                case 2:
                                    mount(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle);
                                    break;
                                case 1:
                                    break;
                                case 16:
                                    setTextContent(parentDOM, nextChildren);
                                    break;
                                default:
                                    mountArrayChildren(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle)
                            }
                            break;
                        case 16:
                            switch (nextChildFlags) {
                                case 16:
                                    ! function(lastChildren, nextChildren, parentDOM) {
                                        if (lastChildren !== nextChildren) {
                                            if ("" !== lastChildren) {
                                                parentDOM.firstChild.nodeValue = nextChildren
                                            } else {
                                                setTextContent(parentDOM, nextChildren)
                                            }
                                        }
                                    }(lastChildren, nextChildren, parentDOM);
                                    break;
                                case 2:
                                    clearDOM(parentDOM);
                                    mount(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle);
                                    break;
                                case 1:
                                    clearDOM(parentDOM);
                                    break;
                                default:
                                    clearDOM(parentDOM);
                                    mountArrayChildren(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle)
                            }
                            break;
                        default:
                            switch (nextChildFlags) {
                                case 16:
                                    unmountAllChildren(lastChildren);
                                    setTextContent(parentDOM, nextChildren);
                                    break;
                                case 2:
                                    removeAllChildren(parentDOM, parentVNode, lastChildren);
                                    mount(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle);
                                    break;
                                case 1:
                                    removeAllChildren(parentDOM, parentVNode, lastChildren);
                                    break;
                                default:
                                    var lastLength = 0 | lastChildren.length;
                                    var nextLength = 0 | nextChildren.length;
                                    if (0 === lastLength) {
                                        if (nextLength > 0) {
                                            mountArrayChildren(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle)
                                        }
                                    } else if (0 === nextLength) {
                                        removeAllChildren(parentDOM, parentVNode, lastChildren)
                                    } else if (8 === nextChildFlags && 8 === lastChildFlags) {
                                        ! function(a, b, dom, context, isSVG, aLength, bLength, outerEdge, parentVNode, lifecycle) {
                                            var aEnd = aLength - 1;
                                            var bEnd = bLength - 1;
                                            var j = 0;
                                            var aNode = a[j];
                                            var bNode = b[j];
                                            var nextPos;
                                            var nextNode;
                                            outer: {
                                                while (aNode.key === bNode.key) {
                                                    if (16384 & bNode.flags) {
                                                        b[j] = bNode = directClone(bNode)
                                                    }
                                                    patch(aNode, bNode, dom, context, isSVG, outerEdge, lifecycle);
                                                    a[j] = bNode;
                                                    ++j;
                                                    if (j > aEnd || j > bEnd) {
                                                        break outer
                                                    }
                                                    aNode = a[j];
                                                    bNode = b[j]
                                                }
                                                aNode = a[aEnd];bNode = b[bEnd];
                                                while (aNode.key === bNode.key) {
                                                    if (16384 & bNode.flags) {
                                                        b[bEnd] = bNode = directClone(bNode)
                                                    }
                                                    patch(aNode, bNode, dom, context, isSVG, outerEdge, lifecycle);
                                                    a[aEnd] = bNode;
                                                    aEnd--;
                                                    bEnd--;
                                                    if (j > aEnd || j > bEnd) {
                                                        break outer
                                                    }
                                                    aNode = a[aEnd];
                                                    bNode = b[bEnd]
                                                }
                                            }
                                            if (j > aEnd) {
                                                if (j <= bEnd) {
                                                    nextPos = bEnd + 1;
                                                    nextNode = nextPos < bLength ? findDOMfromVNode(b[nextPos], true) : outerEdge;
                                                    while (j <= bEnd) {
                                                        bNode = b[j];
                                                        if (16384 & bNode.flags) {
                                                            b[j] = bNode = directClone(bNode)
                                                        }++j;
                                                        mount(bNode, dom, context, isSVG, nextNode, lifecycle)
                                                    }
                                                }
                                            } else if (j > bEnd) {
                                                while (j <= aEnd) {
                                                    remove(a[j++], dom)
                                                }
                                            } else {
                                                ! function(a, b, context, aLength, bLength, aEnd, bEnd, j, dom, isSVG, outerEdge, parentVNode, lifecycle) {
                                                    var aNode;
                                                    var bNode;
                                                    var nextPos;
                                                    var i = 0;
                                                    var aStart = j;
                                                    var bStart = j;
                                                    var aLeft = aEnd - j + 1;
                                                    var bLeft = bEnd - j + 1;
                                                    var sources = new Int32Array(bLeft + 1);
                                                    var canRemoveWholeContent = aLeft === aLength;
                                                    var moved = false;
                                                    var pos = 0;
                                                    var patched = 0;
                                                    if (bLength < 4 || (aLeft | bLeft) < 32) {
                                                        for (i = aStart; i <= aEnd; ++i) {
                                                            aNode = a[i];
                                                            if (patched < bLeft) {
                                                                for (j = bStart; j <= bEnd; j++) {
                                                                    bNode = b[j];
                                                                    if (aNode.key === bNode.key) {
                                                                        sources[j - bStart] = i + 1;
                                                                        if (canRemoveWholeContent) {
                                                                            canRemoveWholeContent = false;
                                                                            while (aStart < i) {
                                                                                remove(a[aStart++], dom)
                                                                            }
                                                                        }
                                                                        if (pos > j) {
                                                                            moved = true
                                                                        } else {
                                                                            pos = j
                                                                        }
                                                                        if (16384 & bNode.flags) {
                                                                            b[j] = bNode = directClone(bNode)
                                                                        }
                                                                        patch(aNode, bNode, dom, context, isSVG, outerEdge, lifecycle);
                                                                        ++patched;
                                                                        break
                                                                    }
                                                                }
                                                                if (!canRemoveWholeContent && j > bEnd) {
                                                                    remove(aNode, dom)
                                                                }
                                                            } else if (!canRemoveWholeContent) {
                                                                remove(aNode, dom)
                                                            }
                                                        }
                                                    } else {
                                                        var keyIndex = {};
                                                        for (i = bStart; i <= bEnd; ++i) {
                                                            keyIndex[b[i].key] = i
                                                        }
                                                        for (i = aStart; i <= aEnd; ++i) {
                                                            aNode = a[i];
                                                            if (patched < bLeft) {
                                                                j = keyIndex[aNode.key];
                                                                if (void 0 !== j) {
                                                                    if (canRemoveWholeContent) {
                                                                        canRemoveWholeContent = false;
                                                                        while (i > aStart) {
                                                                            remove(a[aStart++], dom)
                                                                        }
                                                                    }
                                                                    sources[j - bStart] = i + 1;
                                                                    if (pos > j) {
                                                                        moved = true
                                                                    } else {
                                                                        pos = j
                                                                    }
                                                                    bNode = b[j];
                                                                    if (16384 & bNode.flags) {
                                                                        b[j] = bNode = directClone(bNode)
                                                                    }
                                                                    patch(aNode, bNode, dom, context, isSVG, outerEdge, lifecycle);
                                                                    ++patched
                                                                } else if (!canRemoveWholeContent) {
                                                                    remove(aNode, dom)
                                                                }
                                                            } else if (!canRemoveWholeContent) {
                                                                remove(aNode, dom)
                                                            }
                                                        }
                                                    }
                                                    if (canRemoveWholeContent) {
                                                        removeAllChildren(dom, parentVNode, a);
                                                        mountArrayChildren(b, dom, context, isSVG, outerEdge, lifecycle)
                                                    } else if (moved) {
                                                        var seq = function(arr) {
                                                            var arrI = 0;
                                                            var i = 0;
                                                            var j = 0;
                                                            var k = 0;
                                                            var u = 0;
                                                            var v = 0;
                                                            var c = 0;
                                                            var len = arr.length;
                                                            if (len > maxLen) {
                                                                maxLen = len;
                                                                result = new Int32Array(len);
                                                                p = new Int32Array(len)
                                                            }
                                                            for (; i < len; ++i) {
                                                                arrI = arr[i];
                                                                if (0 !== arrI) {
                                                                    j = result[k];
                                                                    if (arr[j] < arrI) {
                                                                        p[i] = j;
                                                                        result[++k] = i;
                                                                        continue
                                                                    }
                                                                    u = 0;
                                                                    v = k;
                                                                    while (u < v) {
                                                                        c = u + v >> 1;
                                                                        if (arr[result[c]] < arrI) {
                                                                            u = c + 1
                                                                        } else {
                                                                            v = c
                                                                        }
                                                                    }
                                                                    if (arrI < arr[result[u]]) {
                                                                        if (u > 0) {
                                                                            p[i] = result[u - 1]
                                                                        }
                                                                        result[u] = i
                                                                    }
                                                                }
                                                            }
                                                            u = k + 1;
                                                            var seq = new Int32Array(u);
                                                            v = result[u - 1];
                                                            while (u-- > 0) {
                                                                seq[u] = v;
                                                                v = p[v];
                                                                result[u] = 0
                                                            }
                                                            return seq
                                                        }(sources);
                                                        j = seq.length - 1;
                                                        for (i = bLeft - 1; i >= 0; i--) {
                                                            if (0 === sources[i]) {
                                                                pos = i + bStart;
                                                                bNode = b[pos];
                                                                if (16384 & bNode.flags) {
                                                                    b[pos] = bNode = directClone(bNode)
                                                                }
                                                                nextPos = pos + 1;
                                                                mount(bNode, dom, context, isSVG, nextPos < bLength ? findDOMfromVNode(b[nextPos], true) : outerEdge, lifecycle)
                                                            } else if (j < 0 || i !== seq[j]) {
                                                                pos = i + bStart;
                                                                bNode = b[pos];
                                                                nextPos = pos + 1;
                                                                moveVNodeDOM(bNode, dom, nextPos < bLength ? findDOMfromVNode(b[nextPos], true) : outerEdge)
                                                            } else {
                                                                j--
                                                            }
                                                        }
                                                    } else if (patched !== bLeft) {
                                                        for (i = bLeft - 1; i >= 0; i--) {
                                                            if (0 === sources[i]) {
                                                                pos = i + bStart;
                                                                bNode = b[pos];
                                                                if (16384 & bNode.flags) {
                                                                    b[pos] = bNode = directClone(bNode)
                                                                }
                                                                nextPos = pos + 1;
                                                                mount(bNode, dom, context, isSVG, nextPos < bLength ? findDOMfromVNode(b[nextPos], true) : outerEdge, lifecycle)
                                                            }
                                                        }
                                                    }
                                                }(a, b, context, aLength, bLength, aEnd, bEnd, j, dom, isSVG, outerEdge, parentVNode, lifecycle)
                                            }
                                        }(lastChildren, nextChildren, parentDOM, context, isSVG, lastLength, nextLength, nextNode, parentVNode, lifecycle)
                                    } else {
                                        ! function(lastChildren, nextChildren, dom, context, isSVG, lastChildrenLength, nextChildrenLength, nextNode, lifecycle) {
                                            var commonLength = lastChildrenLength > nextChildrenLength ? nextChildrenLength : lastChildrenLength;
                                            var i = 0;
                                            var nextChild;
                                            var lastChild;
                                            for (; i < commonLength; ++i) {
                                                nextChild = nextChildren[i];
                                                lastChild = lastChildren[i];
                                                if (16384 & nextChild.flags) {
                                                    nextChild = nextChildren[i] = directClone(nextChild)
                                                }
                                                patch(lastChild, nextChild, dom, context, isSVG, nextNode, lifecycle);
                                                lastChildren[i] = nextChild
                                            }
                                            if (lastChildrenLength < nextChildrenLength) {
                                                for (i = commonLength; i < nextChildrenLength; ++i) {
                                                    nextChild = nextChildren[i];
                                                    if (16384 & nextChild.flags) {
                                                        nextChild = nextChildren[i] = directClone(nextChild)
                                                    }
                                                    mount(nextChild, dom, context, isSVG, nextNode, lifecycle)
                                                }
                                            } else if (lastChildrenLength > nextChildrenLength) {
                                                for (i = commonLength; i < lastChildrenLength; ++i) {
                                                    remove(lastChildren[i], dom)
                                                }
                                            }
                                        }(lastChildren, nextChildren, parentDOM, context, isSVG, lastLength, nextLength, nextNode, lifecycle)
                                    }
                            }
                    }
                }

                function updateClassComponent(instance, nextState, nextProps, parentDOM, context, isSVG, force, nextNode, lifecycle) {
                    var lastState = instance.state;
                    var lastProps = instance.props;
                    var usesNewAPI = Boolean(instance.$N);
                    var hasSCU = isFunction(instance.shouldComponentUpdate);
                    if (usesNewAPI) {
                        nextState = createDerivedState(instance, nextProps, nextState !== lastState ? combineFrom(lastState, nextState) : nextState)
                    }
                    if (force || !hasSCU || hasSCU && instance.shouldComponentUpdate(nextProps, nextState, context)) {
                        if (!usesNewAPI && isFunction(instance.componentWillUpdate)) {
                            instance.componentWillUpdate(nextProps, nextState, context)
                        }
                        instance.props = nextProps;
                        instance.state = nextState;
                        instance.context = context;
                        var snapshot = null;
                        var nextInput = renderNewInput(instance, nextProps, context);
                        if (usesNewAPI && isFunction(instance.getSnapshotBeforeUpdate)) {
                            snapshot = instance.getSnapshotBeforeUpdate(lastProps, lastState)
                        }
                        patch(instance.$LI, nextInput, parentDOM, instance.$CX, isSVG, nextNode, lifecycle);
                        instance.$LI = nextInput;
                        if (isFunction(instance.componentDidUpdate)) {
                            ! function(instance, lastProps, lastState, snapshot, lifecycle) {
                                lifecycle.push((function() {
                                    instance.componentDidUpdate(lastProps, lastState, snapshot)
                                }))
                            }(instance, lastProps, lastState, snapshot, lifecycle)
                        }
                    } else {
                        instance.props = nextProps;
                        instance.state = nextState;
                        instance.context = context
                    }
                }
                var result;
                var p;
                var maxLen = 0;
                var hasDocumentAvailable = "undefined" !== typeof document;
                if (hasDocumentAvailable) {
                    if (window.Node) {
                        Node.prototype.$EV = null;
                        Node.prototype.$V = null
                    }
                }

                function __render(input, parentDOM, callback, context) {
                    var lifecycle = [];
                    var rootInput = parentDOM.$V;
                    renderCheck.v = true;
                    if (isNullOrUndef(rootInput)) {
                        if (!isNullOrUndef(input)) {
                            if (16384 & input.flags) {
                                input = directClone(input)
                            }
                            mount(input, parentDOM, context, false, null, lifecycle);
                            parentDOM.$V = input;
                            rootInput = input
                        }
                    } else if (isNullOrUndef(input)) {
                        remove(rootInput, parentDOM);
                        parentDOM.$V = null
                    } else {
                        if (16384 & input.flags) {
                            input = directClone(input)
                        }
                        patch(rootInput, input, parentDOM, context, false, null, lifecycle);
                        rootInput = parentDOM.$V = input
                    }
                    callAll(lifecycle);
                    renderCheck.v = false;
                    if (isFunction(callback)) {
                        callback()
                    }
                    if (isFunction(options.renderComplete)) {
                        options.renderComplete(rootInput, parentDOM)
                    }
                }

                function render(input, parentDOM, callback, context) {
                    if (void 0 === callback) {
                        callback = null
                    }
                    if (void 0 === context) {
                        context = EMPTY_OBJ
                    }
                    __render(input, parentDOM, callback, context)
                }

                function createRenderer(parentDOM) {
                    return function(lastInput, nextInput, callback, context) {
                        if (!parentDOM) {
                            parentDOM = lastInput
                        }
                        render(nextInput, parentDOM, callback, context)
                    }
                }
                var QUEUE = [];
                var nextTick = "undefined" !== typeof Promise ? Promise.resolve().then.bind(Promise.resolve()) : function(a) {
                    window.setTimeout(a, 0)
                };
                var microTaskPending = false;

                function queueStateChanges(component, newState, callback, force) {
                    var pending = component.$PS;
                    if (isFunction(newState)) {
                        newState = newState(pending ? combineFrom(component.state, pending) : component.state, component.props, component.context)
                    }
                    if (isNullOrUndef(pending)) {
                        component.$PS = newState
                    } else {
                        for (var stateKey in newState) {
                            pending[stateKey] = newState[stateKey]
                        }
                    }
                    if (!component.$BR) {
                        if (!renderCheck.v) {
                            if (0 === QUEUE.length) {
                                applyState(component, force);
                                if (isFunction(callback)) {
                                    callback.call(component)
                                }
                                return
                            }
                        }
                        if (-1 === QUEUE.indexOf(component)) {
                            QUEUE.push(component)
                        }
                        if (force) {
                            component.$F = true
                        }
                        if (!microTaskPending) {
                            microTaskPending = true;
                            nextTick(rerender)
                        }
                        if (isFunction(callback)) {
                            var QU = component.$QU;
                            if (!QU) {
                                QU = component.$QU = []
                            }
                            QU.push(callback)
                        }
                    } else if (isFunction(callback)) {
                        component.$L.push(callback.bind(component))
                    }
                }

                function callSetStateCallbacks(component) {
                    var queue = component.$QU;
                    for (var i = 0; i < queue.length; ++i) {
                        queue[i].call(component)
                    }
                    component.$QU = null
                }

                function rerender() {
                    var component;
                    microTaskPending = false;
                    while (component = QUEUE.shift()) {
                        if (!component.$UN) {
                            var force = component.$F;
                            component.$F = false;
                            applyState(component, force);
                            if (component.$QU) {
                                callSetStateCallbacks(component)
                            }
                        }
                    }
                }

                function applyState(component, force) {
                    if (force || !component.$BR) {
                        var pendingState = component.$PS;
                        component.$PS = null;
                        var lifecycle = [];
                        renderCheck.v = true;
                        updateClassComponent(component, combineFrom(component.state, pendingState), component.props, findDOMfromVNode(component.$LI, true).parentNode, component.context, component.$SVG, force, null, lifecycle);
                        callAll(lifecycle);
                        renderCheck.v = false
                    } else {
                        component.state = component.$PS;
                        component.$PS = null
                    }
                }
                var Component = function(props, context) {
                    this.state = null;
                    this.$BR = false;
                    this.$BS = true;
                    this.$PS = null;
                    this.$LI = null;
                    this.$UN = false;
                    this.$CX = null;
                    this.$QU = null;
                    this.$N = false;
                    this.$L = null;
                    this.$SVG = false;
                    this.$F = false;
                    this.props = props || EMPTY_OBJ;
                    this.context = context || EMPTY_OBJ
                };
                Component.prototype.forceUpdate = function(callback) {
                    if (this.$UN) {
                        return
                    }
                    queueStateChanges(this, {}, callback, true)
                };
                Component.prototype.setState = function(newState, callback) {
                    if (this.$UN) {
                        return
                    }
                    if (!this.$BS) {
                        queueStateChanges(this, newState, callback, false)
                    }
                };
                Component.prototype.render = function(_nextProps, _nextState, _nextContext) {
                    return null
                };
                var version = "7.4.11";
                if (false) {}
            },
        65636:
            /*!**********************************************************************************************!*\
              !*** ../../node_modules/.pnpm/rrule@2.8.1/node_modules/rrule/dist/esm/index.js + 28 modules ***!
              \**********************************************************************************************/
            function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {
                __webpack_require__.r(__webpack_exports__);
                __webpack_require__.d(__webpack_exports__, {
                    ALL_WEEKDAYS: function() {
                        return ALL_WEEKDAYS
                    },
                    Frequency: function() {
                        return Frequency
                    },
                    RRule: function() {
                        return RRule
                    },
                    RRuleSet: function() {
                        return RRuleSet
                    },
                    Weekday: function() {
                        return Weekday
                    },
                    datetime: function() {
                        return datetime
                    },
                    rrulestr: function() {
                        return rrulestr
                    }
                });
                var ALL_WEEKDAYS = ["MO", "TU", "WE", "TH", "FR", "SA", "SU"];
                var Weekday = function() {
                    function Weekday(weekday, n) {
                        if (0 === n) {
                            throw new Error("Can't create weekday with n == 0")
                        }
                        this.weekday = weekday;
                        this.n = n
                    }
                    Weekday.fromStr = function(str) {
                        return new Weekday(ALL_WEEKDAYS.indexOf(str))
                    };
                    Weekday.prototype.nth = function(n) {
                        return this.n === n ? this : new Weekday(this.weekday, n)
                    };
                    Weekday.prototype.equals = function(other) {
                        return this.weekday === other.weekday && this.n === other.n
                    };
                    Weekday.prototype.toString = function() {
                        var s = ALL_WEEKDAYS[this.weekday];
                        if (this.n) {
                            s = (this.n > 0 ? "+" : "") + String(this.n) + s
                        }
                        return s
                    };
                    Weekday.prototype.getJsWeekday = function() {
                        return 6 === this.weekday ? 0 : this.weekday + 1
                    };
                    return Weekday
                }();
                var isPresent = function(value) {
                    return null !== value && void 0 !== value
                };
                var isNumber = function(value) {
                    return "number" === typeof value
                };
                var isWeekdayStr = function(value) {
                    return "string" === typeof value && ALL_WEEKDAYS.includes(value)
                };
                var isArray = Array.isArray;
                var range = function(start, end) {
                    if (void 0 === end) {
                        end = start
                    }
                    if (1 === arguments.length) {
                        end = start;
                        start = 0
                    }
                    var rang = [];
                    for (var i = start; i < end; i++) {
                        rang.push(i)
                    }
                    return rang
                };
                var repeat = function(value, times) {
                    var i = 0;
                    var array = [];
                    if (isArray(value)) {
                        for (; i < times; i++) {
                            array[i] = [].concat(value)
                        }
                    } else {
                        for (; i < times; i++) {
                            array[i] = value
                        }
                    }
                    return array
                };
                var toArray = function(item) {
                    if (isArray(item)) {
                        return item
                    }
                    return [item]
                };

                function padStart(item, targetLength, padString) {
                    if (void 0 === padString) {
                        padString = " "
                    }
                    var str = String(item);
                    targetLength |= 0;
                    if (str.length > targetLength) {
                        return String(str)
                    }
                    targetLength -= str.length;
                    if (targetLength > padString.length) {
                        padString += repeat(padString, targetLength / padString.length)
                    }
                    return padString.slice(0, targetLength) + String(str)
                }
                var split = function(str, sep, num) {
                    var splits = str.split(sep);
                    return num ? splits.slice(0, num).concat([splits.slice(num).join(sep)]) : splits
                };
                var pymod = function(a, b) {
                    var r = a % b;
                    return r * b < 0 ? r + b : r
                };
                var divmod = function(a, b) {
                    return {
                        div: Math.floor(a / b),
                        mod: pymod(a, b)
                    }
                };
                var empty = function(obj) {
                    return !isPresent(obj) || 0 === obj.length
                };
                var notEmpty = function(obj) {
                    return !empty(obj)
                };
                var includes = function(arr, val) {
                    return notEmpty(arr) && -1 !== arr.indexOf(val)
                };
                var datetime = function(y, m, d, h, i, s) {
                    if (void 0 === h) {
                        h = 0
                    }
                    if (void 0 === i) {
                        i = 0
                    }
                    if (void 0 === s) {
                        s = 0
                    }
                    return new Date(Date.UTC(y, m - 1, d, h, i, s))
                };
                var MONTH_DAYS = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
                var MAXYEAR = 9999;
                var ORDINAL_BASE = datetime(1970, 1, 1);
                var PY_WEEKDAYS = [6, 0, 1, 2, 3, 4, 5];
                var isLeapYear = function(year) {
                    return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0
                };
                var isDate = function(value) {
                    return value instanceof Date
                };
                var isValidDate = function(value) {
                    return isDate(value) && !isNaN(value.getTime())
                };
                var toOrdinal = function(date) {
                    return date1 = date, date2 = ORDINAL_BASE, date1ms = date1.getTime(), date2ms = date2.getTime(), differencems = date1ms - date2ms, Math.round(differencems / 864e5);
                    var date1, date2, date1ms, date2ms, differencems
                };
                var fromOrdinal = function(ordinal) {
                    return new Date(ORDINAL_BASE.getTime() + 864e5 * ordinal)
                };
                var getMonthDays = function(date) {
                    var month = date.getUTCMonth();
                    return 1 === month && isLeapYear(date.getUTCFullYear()) ? 29 : MONTH_DAYS[month]
                };
                var getWeekday = function(date) {
                    return PY_WEEKDAYS[date.getUTCDay()]
                };
                var monthRange = function(year, month) {
                    var date = datetime(year, month + 1, 1);
                    return [getWeekday(date), getMonthDays(date)]
                };
                var combine = function(date, time) {
                    time = time || date;
                    return new Date(Date.UTC(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate(), time.getHours(), time.getMinutes(), time.getSeconds(), time.getMilliseconds()))
                };
                var dateutil_clone = function(date) {
                    var dolly = new Date(date.getTime());
                    return dolly
                };
                var cloneDates = function(dates) {
                    var clones = [];
                    for (var i = 0; i < dates.length; i++) {
                        clones.push(dateutil_clone(dates[i]))
                    }
                    return clones
                };
                var sort = function(dates) {
                    dates.sort((function(a, b) {
                        return a.getTime() - b.getTime()
                    }))
                };
                var timeToUntilString = function(time, utc) {
                    if (void 0 === utc) {
                        utc = true
                    }
                    var date = new Date(time);
                    return [padStart(date.getUTCFullYear().toString(), 4, "0"), padStart(date.getUTCMonth() + 1, 2, "0"), padStart(date.getUTCDate(), 2, "0"), "T", padStart(date.getUTCHours(), 2, "0"), padStart(date.getUTCMinutes(), 2, "0"), padStart(date.getUTCSeconds(), 2, "0"), utc ? "Z" : ""].join("")
                };
                var untilStringToDate = function(until) {
                    var bits = /^(\d{4})(\d{2})(\d{2})(T(\d{2})(\d{2})(\d{2})Z?)?$/.exec(until);
                    if (!bits) {
                        throw new Error("Invalid UNTIL value: ".concat(until))
                    }
                    return new Date(Date.UTC(parseInt(bits[1], 10), parseInt(bits[2], 10) - 1, parseInt(bits[3], 10), parseInt(bits[5], 10) || 0, parseInt(bits[6], 10) || 0, parseInt(bits[7], 10) || 0))
                };
                var dateTZtoISO8601 = function(date, timeZone) {
                    var dateStr = date.toLocaleString("sv-SE", {
                        timeZone: timeZone
                    });
                    return dateStr.replace(" ", "T") + "Z"
                };
                var IterResult = function() {
                    function IterResult(method, args) {
                        this.minDate = null;
                        this.maxDate = null;
                        this._result = [];
                        this.total = 0;
                        this.method = method;
                        this.args = args;
                        if ("between" === method) {
                            this.maxDate = args.inc ? args.before : new Date(args.before.getTime() - 1);
                            this.minDate = args.inc ? args.after : new Date(args.after.getTime() + 1)
                        } else if ("before" === method) {
                            this.maxDate = args.inc ? args.dt : new Date(args.dt.getTime() - 1)
                        } else if ("after" === method) {
                            this.minDate = args.inc ? args.dt : new Date(args.dt.getTime() + 1)
                        }
                    }
                    IterResult.prototype.accept = function(date) {
                        ++this.total;
                        var tooEarly = this.minDate && date < this.minDate;
                        var tooLate = this.maxDate && date > this.maxDate;
                        if ("between" === this.method) {
                            if (tooEarly) {
                                return true
                            }
                            if (tooLate) {
                                return false
                            }
                        } else if ("before" === this.method) {
                            if (tooLate) {
                                return false
                            }
                        } else if ("after" === this.method) {
                            if (tooEarly) {
                                return true
                            }
                            this.add(date);
                            return false
                        }
                        return this.add(date)
                    };
                    IterResult.prototype.add = function(date) {
                        this._result.push(date);
                        return true
                    };
                    IterResult.prototype.getValue = function() {
                        var res = this._result;
                        switch (this.method) {
                            case "all":
                            case "between":
                                return res;
                            default:
                                return res.length ? res[res.length - 1] : null
                        }
                    };
                    IterResult.prototype.clone = function() {
                        return new IterResult(this.method, this.args)
                    };
                    return IterResult
                }();
                var iterresult = IterResult;
                var extendStatics = function(d, b) {
                    extendStatics = Object.setPrototypeOf || {
                        __proto__: []
                    }
                    instanceof Array && function(d, b) {
                        d.__proto__ = b
                    } || function(d, b) {
                        for (var p in b) {
                            if (Object.prototype.hasOwnProperty.call(b, p)) {
                                d[p] = b[p]
                            }
                        }
                    };
                    return extendStatics(d, b)
                };

                function __extends(d, b) {
                    if ("function" !== typeof b && null !== b) {
                        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null")
                    }
                    extendStatics(d, b);

                    function __() {
                        this.constructor = d
                    }
                    d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, new __)
                }
                var __assign = function() {
                    __assign = Object.assign || function(t) {
                        for (var s, i = 1, n = arguments.length; i < n; i++) {
                            s = arguments[i];
                            for (var p in s) {
                                if (Object.prototype.hasOwnProperty.call(s, p)) {
                                    t[p] = s[p]
                                }
                            }
                        }
                        return t
                    };
                    return __assign.apply(this, arguments)
                };
                Object.create;

                function __spreadArray(to, from, pack) {
                    if (pack || 2 === arguments.length) {
                        for (var ar, i = 0, l = from.length; i < l; i++) {
                            if (ar || !(i in from)) {
                                if (!ar) {
                                    ar = Array.prototype.slice.call(from, 0, i)
                                }
                                ar[i] = from[i]
                            }
                        }
                    }
                    return to.concat(ar || Array.prototype.slice.call(from))
                }
                Object.create;
                "function" === typeof SuppressedError && SuppressedError;
                var CallbackIterResult = function(_super) {
                    __extends(CallbackIterResult, _super);

                    function CallbackIterResult(method, args, iterator) {
                        var _this = _super.call(this, method, args) || this;
                        _this.iterator = iterator;
                        return _this
                    }
                    CallbackIterResult.prototype.add = function(date) {
                        if (this.iterator(date, this._result.length)) {
                            this._result.push(date);
                            return true
                        }
                        return false
                    };
                    return CallbackIterResult
                }(iterresult);
                var callbackiterresult = CallbackIterResult;
                var i18n = {
                    dayNames: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
                    monthNames: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
                    tokens: {
                        SKIP: /^[ \r\n\t]+|^\.$/,
                        number: /^[1-9][0-9]*/,
                        numberAsText: /^(one|two|three)/i,
                        every: /^every/i,
                        "day(s)": /^days?/i,
                        "weekday(s)": /^weekdays?/i,
                        "week(s)": /^weeks?/i,
                        "hour(s)": /^hours?/i,
                        "minute(s)": /^minutes?/i,
                        "month(s)": /^months?/i,
                        "year(s)": /^years?/i,
                        on: /^(on|in)/i,
                        at: /^(at)/i,
                        the: /^the/i,
                        first: /^first/i,
                        second: /^second/i,
                        third: /^third/i,
                        nth: /^([1-9][0-9]*)(\.|th|nd|rd|st)/i,
                        last: /^last/i,
                        for: /^for/i,
                        "time(s)": /^times?/i,
                        until: /^(un)?til/i,
                        monday: /^mo(n(day)?)?/i,
                        tuesday: /^tu(e(s(day)?)?)?/i,
                        wednesday: /^we(d(n(esday)?)?)?/i,
                        thursday: /^th(u(r(sday)?)?)?/i,
                        friday: /^fr(i(day)?)?/i,
                        saturday: /^sa(t(urday)?)?/i,
                        sunday: /^su(n(day)?)?/i,
                        january: /^jan(uary)?/i,
                        february: /^feb(ruary)?/i,
                        march: /^mar(ch)?/i,
                        april: /^apr(il)?/i,
                        may: /^may/i,
                        june: /^june?/i,
                        july: /^july?/i,
                        august: /^aug(ust)?/i,
                        september: /^sep(t(ember)?)?/i,
                        october: /^oct(ober)?/i,
                        november: /^nov(ember)?/i,
                        december: /^dec(ember)?/i,
                        comma: /^(,\s*|(and|or)\s*)+/i
                    }
                };
                var contains = function(arr, val) {
                    return -1 !== arr.indexOf(val)
                };
                var defaultGetText = function(id) {
                    return id.toString()
                };
                var defaultDateFormatter = function(year, month, day) {
                    return "".concat(month, " ").concat(day, ", ").concat(year)
                };
                var ToText = function() {
                    function ToText(rrule, gettext, language, dateFormatter) {
                        if (void 0 === gettext) {
                            gettext = defaultGetText
                        }
                        if (void 0 === language) {
                            language = i18n
                        }
                        if (void 0 === dateFormatter) {
                            dateFormatter = defaultDateFormatter
                        }
                        this.text = [];
                        this.language = language || i18n;
                        this.gettext = gettext;
                        this.dateFormatter = dateFormatter;
                        this.rrule = rrule;
                        this.options = rrule.options;
                        this.origOptions = rrule.origOptions;
                        if (this.origOptions.bymonthday) {
                            var bymonthday = [].concat(this.options.bymonthday);
                            var bynmonthday = [].concat(this.options.bynmonthday);
                            bymonthday.sort((function(a, b) {
                                return a - b
                            }));
                            bynmonthday.sort((function(a, b) {
                                return b - a
                            }));
                            this.bymonthday = bymonthday.concat(bynmonthday);
                            if (!this.bymonthday.length) {
                                this.bymonthday = null
                            }
                        }
                        if (isPresent(this.origOptions.byweekday)) {
                            var byweekday = !isArray(this.origOptions.byweekday) ? [this.origOptions.byweekday] : this.origOptions.byweekday;
                            var days = String(byweekday);
                            this.byweekday = {
                                allWeeks: byweekday.filter((function(weekday) {
                                    return !weekday.n
                                })),
                                someWeeks: byweekday.filter((function(weekday) {
                                    return Boolean(weekday.n)
                                })),
                                isWeekdays: -1 !== days.indexOf("MO") && -1 !== days.indexOf("TU") && -1 !== days.indexOf("WE") && -1 !== days.indexOf("TH") && -1 !== days.indexOf("FR") && -1 === days.indexOf("SA") && -1 === days.indexOf("SU"),
                                isEveryDay: -1 !== days.indexOf("MO") && -1 !== days.indexOf("TU") && -1 !== days.indexOf("WE") && -1 !== days.indexOf("TH") && -1 !== days.indexOf("FR") && -1 !== days.indexOf("SA") && -1 !== days.indexOf("SU")
                            };
                            var sortWeekDays = function(a, b) {
                                return a.weekday - b.weekday
                            };
                            this.byweekday.allWeeks.sort(sortWeekDays);
                            this.byweekday.someWeeks.sort(sortWeekDays);
                            if (!this.byweekday.allWeeks.length) {
                                this.byweekday.allWeeks = null
                            }
                            if (!this.byweekday.someWeeks.length) {
                                this.byweekday.someWeeks = null
                            }
                        } else {
                            this.byweekday = null
                        }
                    }
                    ToText.isFullyConvertible = function(rrule) {
                        if (!(rrule.options.freq in ToText.IMPLEMENTED)) {
                            return false
                        }
                        if (rrule.origOptions.until && rrule.origOptions.count) {
                            return false
                        }
                        for (var key in rrule.origOptions) {
                            if (contains(["dtstart", "tzid", "wkst", "freq"], key)) {
                                return true
                            }
                            if (!contains(ToText.IMPLEMENTED[rrule.options.freq], key)) {
                                return false
                            }
                        }
                        return true
                    };
                    ToText.prototype.isFullyConvertible = function() {
                        return ToText.isFullyConvertible(this.rrule)
                    };
                    ToText.prototype.toString = function() {
                        var gettext = this.gettext;
                        if (!(this.options.freq in ToText.IMPLEMENTED)) {
                            return gettext("RRule error: Unable to fully convert this rrule to text")
                        }
                        this.text = [gettext("every")];
                        this[RRule.FREQUENCIES[this.options.freq]]();
                        if (this.options.until) {
                            this.add(gettext("until"));
                            var until = this.options.until;
                            this.add(this.dateFormatter(until.getUTCFullYear(), this.language.monthNames[until.getUTCMonth()], until.getUTCDate()))
                        } else if (this.options.count) {
                            this.add(gettext("for")).add(this.options.count.toString()).add(this.plural(this.options.count) ? gettext("times") : gettext("time"))
                        }
                        if (!this.isFullyConvertible()) {
                            this.add(gettext("(~ approximate)"))
                        }
                        return this.text.join("")
                    };
                    ToText.prototype.HOURLY = function() {
                        var gettext = this.gettext;
                        if (1 !== this.options.interval) {
                            this.add(this.options.interval.toString())
                        }
                        this.add(this.plural(this.options.interval) ? gettext("hours") : gettext("hour"))
                    };
                    ToText.prototype.MINUTELY = function() {
                        var gettext = this.gettext;
                        if (1 !== this.options.interval) {
                            this.add(this.options.interval.toString())
                        }
                        this.add(this.plural(this.options.interval) ? gettext("minutes") : gettext("minute"))
                    };
                    ToText.prototype.DAILY = function() {
                        var gettext = this.gettext;
                        if (1 !== this.options.interval) {
                            this.add(this.options.interval.toString())
                        }
                        if (this.byweekday && this.byweekday.isWeekdays) {
                            this.add(this.plural(this.options.interval) ? gettext("weekdays") : gettext("weekday"))
                        } else {
                            this.add(this.plural(this.options.interval) ? gettext("days") : gettext("day"))
                        }
                        if (this.origOptions.bymonth) {
                            this.add(gettext("in"));
                            this._bymonth()
                        }
                        if (this.bymonthday) {
                            this._bymonthday()
                        } else if (this.byweekday) {
                            this._byweekday()
                        } else if (this.origOptions.byhour) {
                            this._byhour()
                        }
                    };
                    ToText.prototype.WEEKLY = function() {
                        var gettext = this.gettext;
                        if (1 !== this.options.interval) {
                            this.add(this.options.interval.toString()).add(this.plural(this.options.interval) ? gettext("weeks") : gettext("week"))
                        }
                        if (this.byweekday && this.byweekday.isWeekdays) {
                            if (1 === this.options.interval) {
                                this.add(this.plural(this.options.interval) ? gettext("weekdays") : gettext("weekday"))
                            } else {
                                this.add(gettext("on")).add(gettext("weekdays"))
                            }
                        } else if (this.byweekday && this.byweekday.isEveryDay) {
                            this.add(this.plural(this.options.interval) ? gettext("days") : gettext("day"))
                        } else {
                            if (1 === this.options.interval) {
                                this.add(gettext("week"))
                            }
                            if (this.origOptions.bymonth) {
                                this.add(gettext("in"));
                                this._bymonth()
                            }
                            if (this.bymonthday) {
                                this._bymonthday()
                            } else if (this.byweekday) {
                                this._byweekday()
                            }
                            if (this.origOptions.byhour) {
                                this._byhour()
                            }
                        }
                    };
                    ToText.prototype.MONTHLY = function() {
                        var gettext = this.gettext;
                        if (this.origOptions.bymonth) {
                            if (1 !== this.options.interval) {
                                this.add(this.options.interval.toString()).add(gettext("months"));
                                if (this.plural(this.options.interval)) {
                                    this.add(gettext("in"))
                                }
                            }
                            this._bymonth()
                        } else {
                            if (1 !== this.options.interval) {
                                this.add(this.options.interval.toString())
                            }
                            this.add(this.plural(this.options.interval) ? gettext("months") : gettext("month"))
                        }
                        if (this.bymonthday) {
                            this._bymonthday()
                        } else if (this.byweekday && this.byweekday.isWeekdays) {
                            this.add(gettext("on")).add(gettext("weekdays"))
                        } else if (this.byweekday) {
                            this._byweekday()
                        }
                    };
                    ToText.prototype.YEARLY = function() {
                        var gettext = this.gettext;
                        if (this.origOptions.bymonth) {
                            if (1 !== this.options.interval) {
                                this.add(this.options.interval.toString());
                                this.add(gettext("years"))
                            }
                            this._bymonth()
                        } else {
                            if (1 !== this.options.interval) {
                                this.add(this.options.interval.toString())
                            }
                            this.add(this.plural(this.options.interval) ? gettext("years") : gettext("year"))
                        }
                        if (this.bymonthday) {
                            this._bymonthday()
                        } else if (this.byweekday) {
                            this._byweekday()
                        }
                        if (this.options.byyearday) {
                            this.add(gettext("on the")).add(this.list(this.options.byyearday, this.nth, gettext("and"))).add(gettext("day"))
                        }
                        if (this.options.byweekno) {
                            this.add(gettext("in")).add(this.plural(this.options.byweekno.length) ? gettext("weeks") : gettext("week")).add(this.list(this.options.byweekno, void 0, gettext("and")))
                        }
                    };
                    ToText.prototype._bymonthday = function() {
                        var gettext = this.gettext;
                        if (this.byweekday && this.byweekday.allWeeks) {
                            this.add(gettext("on")).add(this.list(this.byweekday.allWeeks, this.weekdaytext, gettext("or"))).add(gettext("the")).add(this.list(this.bymonthday, this.nth, gettext("or")))
                        } else {
                            this.add(gettext("on the")).add(this.list(this.bymonthday, this.nth, gettext("and")))
                        }
                    };
                    ToText.prototype._byweekday = function() {
                        var gettext = this.gettext;
                        if (this.byweekday.allWeeks && !this.byweekday.isWeekdays) {
                            this.add(gettext("on")).add(this.list(this.byweekday.allWeeks, this.weekdaytext))
                        }
                        if (this.byweekday.someWeeks) {
                            if (this.byweekday.allWeeks) {
                                this.add(gettext("and"))
                            }
                            this.add(gettext("on the")).add(this.list(this.byweekday.someWeeks, this.weekdaytext, gettext("and")))
                        }
                    };
                    ToText.prototype._byhour = function() {
                        var gettext = this.gettext;
                        this.add(gettext("at")).add(this.list(this.origOptions.byhour, void 0, gettext("and")))
                    };
                    ToText.prototype._bymonth = function() {
                        this.add(this.list(this.options.bymonth, this.monthtext, this.gettext("and")))
                    };
                    ToText.prototype.nth = function(n) {
                        n = parseInt(n.toString(), 10);
                        var nth;
                        var gettext = this.gettext;
                        if (-1 === n) {
                            return gettext("last")
                        }
                        var npos = Math.abs(n);
                        switch (npos) {
                            case 1:
                            case 21:
                            case 31:
                                nth = npos + gettext("st");
                                break;
                            case 2:
                            case 22:
                                nth = npos + gettext("nd");
                                break;
                            case 3:
                            case 23:
                                nth = npos + gettext("rd");
                                break;
                            default:
                                nth = npos + gettext("th")
                        }
                        return n < 0 ? nth + " " + gettext("last") : nth
                    };
                    ToText.prototype.monthtext = function(m) {
                        return this.language.monthNames[m - 1]
                    };
                    ToText.prototype.weekdaytext = function(wday) {
                        var weekday = isNumber(wday) ? (wday + 1) % 7 : wday.getJsWeekday();
                        return (wday.n ? this.nth(wday.n) + " " : "") + this.language.dayNames[weekday]
                    };
                    ToText.prototype.plural = function(n) {
                        return n % 100 !== 1
                    };
                    ToText.prototype.add = function(s) {
                        this.text.push(" ");
                        this.text.push(s);
                        return this
                    };
                    ToText.prototype.list = function(arr, callback, finalDelim, delim) {
                        var _this = this;
                        if (void 0 === delim) {
                            delim = ","
                        }
                        if (!isArray(arr)) {
                            arr = [arr]
                        }
                        callback = callback || function(o) {
                            return o.toString()
                        };
                        var realCallback = function(arg) {
                            return callback && callback.call(_this, arg)
                        };
                        if (finalDelim) {
                            return function(array, delimiter, finalDelimiter) {
                                var list = "";
                                for (var i = 0; i < array.length; i++) {
                                    if (0 !== i) {
                                        if (i === array.length - 1) {
                                            list += " " + finalDelimiter + " "
                                        } else {
                                            list += delimiter + " "
                                        }
                                    }
                                    list += array[i]
                                }
                                return list
                            }(arr.map(realCallback), delim, finalDelim)
                        } else {
                            return arr.map(realCallback).join(delim + " ")
                        }
                    };
                    return ToText
                }();
                var totext = ToText;
                var Parser = function() {
                    function Parser(rules) {
                        this.done = true;
                        this.rules = rules
                    }
                    Parser.prototype.start = function(text) {
                        this.text = text;
                        this.done = false;
                        return this.nextSymbol()
                    };
                    Parser.prototype.isDone = function() {
                        return this.done && null === this.symbol
                    };
                    Parser.prototype.nextSymbol = function() {
                        var best;
                        var bestSymbol;
                        this.symbol = null;
                        this.value = null;
                        do {
                            if (this.done) {
                                return false
                            }
                            var rule = void 0;
                            best = null;
                            for (var name_1 in this.rules) {
                                rule = this.rules[name_1];
                                var match = rule.exec(this.text);
                                if (match) {
                                    if (null === best || match[0].length > best[0].length) {
                                        best = match;
                                        bestSymbol = name_1
                                    }
                                }
                            }
                            if (null != best) {
                                this.text = this.text.substr(best[0].length);
                                if ("" === this.text) {
                                    this.done = true
                                }
                            }
                            if (null == best) {
                                this.done = true;
                                this.symbol = null;
                                this.value = null;
                                return
                            }
                        } while ("SKIP" === bestSymbol);
                        this.symbol = bestSymbol;
                        this.value = best;
                        return true
                    };
                    Parser.prototype.accept = function(name) {
                        if (this.symbol === name) {
                            if (this.value) {
                                var v = this.value;
                                this.nextSymbol();
                                return v
                            }
                            this.nextSymbol();
                            return true
                        }
                        return false
                    };
                    Parser.prototype.acceptNumber = function() {
                        return this.accept("number")
                    };
                    Parser.prototype.expect = function(name) {
                        if (this.accept(name)) {
                            return true
                        }
                        throw new Error("expected " + name + " but found " + this.symbol)
                    };
                    return Parser
                }();

                function parseText(text, language) {
                    if (void 0 === language) {
                        language = i18n
                    }
                    var options = {};
                    var ttr = new Parser(language.tokens);
                    if (!ttr.start(text)) {
                        return null
                    }! function() {
                        ttr.expect("every");
                        var n = ttr.acceptNumber();
                        if (n) {
                            options.interval = parseInt(n[0], 10)
                        }
                        if (ttr.isDone()) {
                            throw new Error("Unexpected end")
                        }
                        switch (ttr.symbol) {
                            case "day(s)":
                                options.freq = RRule.DAILY;
                                if (ttr.nextSymbol()) {
                                    AT();
                                    F()
                                }
                                break;
                            case "weekday(s)":
                                options.freq = RRule.WEEKLY;
                                options.byweekday = [RRule.MO, RRule.TU, RRule.WE, RRule.TH, RRule.FR];
                                ttr.nextSymbol();
                                AT();
                                F();
                                break;
                            case "week(s)":
                                options.freq = RRule.WEEKLY;
                                if (ttr.nextSymbol()) {
                                    ON();
                                    AT();
                                    F()
                                }
                                break;
                            case "hour(s)":
                                options.freq = RRule.HOURLY;
                                if (ttr.nextSymbol()) {
                                    ON();
                                    F()
                                }
                                break;
                            case "minute(s)":
                                options.freq = RRule.MINUTELY;
                                if (ttr.nextSymbol()) {
                                    ON();
                                    F()
                                }
                                break;
                            case "month(s)":
                                options.freq = RRule.MONTHLY;
                                if (ttr.nextSymbol()) {
                                    ON();
                                    F()
                                }
                                break;
                            case "year(s)":
                                options.freq = RRule.YEARLY;
                                if (ttr.nextSymbol()) {
                                    ON();
                                    F()
                                }
                                break;
                            case "monday":
                            case "tuesday":
                            case "wednesday":
                            case "thursday":
                            case "friday":
                            case "saturday":
                            case "sunday":
                                options.freq = RRule.WEEKLY;
                                var key = ttr.symbol.substr(0, 2).toUpperCase();
                                options.byweekday = [RRule[key]];
                                if (!ttr.nextSymbol()) {
                                    return
                                }
                                while (ttr.accept("comma")) {
                                    if (ttr.isDone()) {
                                        throw new Error("Unexpected end")
                                    }
                                    var wkd = decodeWKD();
                                    if (!wkd) {
                                        throw new Error("Unexpected symbol " + ttr.symbol + ", expected weekday")
                                    }
                                    options.byweekday.push(RRule[wkd]);
                                    ttr.nextSymbol()
                                }
                                AT();
                                ! function() {
                                    ttr.accept("on");
                                    ttr.accept("the");
                                    var nth = decodeNTH();
                                    if (!nth) {
                                        return
                                    }
                                    options.bymonthday = [nth];
                                    ttr.nextSymbol();
                                    while (ttr.accept("comma")) {
                                        nth = decodeNTH();
                                        if (!nth) {
                                            throw new Error("Unexpected symbol " + ttr.symbol + "; expected monthday")
                                        }
                                        options.bymonthday.push(nth);
                                        ttr.nextSymbol()
                                    }
                                }();
                                F();
                                break;
                            case "january":
                            case "february":
                            case "march":
                            case "april":
                            case "may":
                            case "june":
                            case "july":
                            case "august":
                            case "september":
                            case "october":
                            case "november":
                            case "december":
                                options.freq = RRule.YEARLY;
                                options.bymonth = [decodeM()];
                                if (!ttr.nextSymbol()) {
                                    return
                                }
                                while (ttr.accept("comma")) {
                                    if (ttr.isDone()) {
                                        throw new Error("Unexpected end")
                                    }
                                    var m = decodeM();
                                    if (!m) {
                                        throw new Error("Unexpected symbol " + ttr.symbol + ", expected month")
                                    }
                                    options.bymonth.push(m);
                                    ttr.nextSymbol()
                                }
                                ON();
                                F();
                                break;
                            default:
                                throw new Error("Unknown symbol")
                        }
                    }();
                    return options;

                    function ON() {
                        var on = ttr.accept("on");
                        var the = ttr.accept("the");
                        if (!(on || the)) {
                            return
                        }
                        do {
                            var nth = decodeNTH();
                            var wkd = decodeWKD();
                            var m = decodeM();
                            if (nth) {
                                if (wkd) {
                                    ttr.nextSymbol();
                                    if (!options.byweekday) {
                                        options.byweekday = []
                                    }
                                    options.byweekday.push(RRule[wkd].nth(nth))
                                } else {
                                    if (!options.bymonthday) {
                                        options.bymonthday = []
                                    }
                                    options.bymonthday.push(nth);
                                    ttr.accept("day(s)")
                                }
                            } else if (wkd) {
                                ttr.nextSymbol();
                                if (!options.byweekday) {
                                    options.byweekday = []
                                }
                                options.byweekday.push(RRule[wkd])
                            } else if ("weekday(s)" === ttr.symbol) {
                                ttr.nextSymbol();
                                if (!options.byweekday) {
                                    options.byweekday = [RRule.MO, RRule.TU, RRule.WE, RRule.TH, RRule.FR]
                                }
                            } else if ("week(s)" === ttr.symbol) {
                                ttr.nextSymbol();
                                var n = ttr.acceptNumber();
                                if (!n) {
                                    throw new Error("Unexpected symbol " + ttr.symbol + ", expected week number")
                                }
                                options.byweekno = [parseInt(n[0], 10)];
                                while (ttr.accept("comma")) {
                                    n = ttr.acceptNumber();
                                    if (!n) {
                                        throw new Error("Unexpected symbol " + ttr.symbol + "; expected monthday")
                                    }
                                    options.byweekno.push(parseInt(n[0], 10))
                                }
                            } else if (m) {
                                ttr.nextSymbol();
                                if (!options.bymonth) {
                                    options.bymonth = []
                                }
                                options.bymonth.push(m)
                            } else {
                                return
                            }
                        } while (ttr.accept("comma") || ttr.accept("the") || ttr.accept("on"))
                    }

                    function AT() {
                        var at = ttr.accept("at");
                        if (!at) {
                            return
                        }
                        do {
                            var n = ttr.acceptNumber();
                            if (!n) {
                                throw new Error("Unexpected symbol " + ttr.symbol + ", expected hour")
                            }
                            options.byhour = [parseInt(n[0], 10)];
                            while (ttr.accept("comma")) {
                                n = ttr.acceptNumber();
                                if (!n) {
                                    throw new Error("Unexpected symbol " + ttr.symbol + "; expected hour")
                                }
                                options.byhour.push(parseInt(n[0], 10))
                            }
                        } while (ttr.accept("comma") || ttr.accept("at"))
                    }

                    function decodeM() {
                        switch (ttr.symbol) {
                            case "january":
                                return 1;
                            case "february":
                                return 2;
                            case "march":
                                return 3;
                            case "april":
                                return 4;
                            case "may":
                                return 5;
                            case "june":
                                return 6;
                            case "july":
                                return 7;
                            case "august":
                                return 8;
                            case "september":
                                return 9;
                            case "october":
                                return 10;
                            case "november":
                                return 11;
                            case "december":
                                return 12;
                            default:
                                return false
                        }
                    }

                    function decodeWKD() {
                        switch (ttr.symbol) {
                            case "monday":
                            case "tuesday":
                            case "wednesday":
                            case "thursday":
                            case "friday":
                            case "saturday":
                            case "sunday":
                                return ttr.symbol.substr(0, 2).toUpperCase();
                            default:
                                return false
                        }
                    }

                    function decodeNTH() {
                        switch (ttr.symbol) {
                            case "last":
                                ttr.nextSymbol();
                                return -1;
                            case "first":
                                ttr.nextSymbol();
                                return 1;
                            case "second":
                                ttr.nextSymbol();
                                return ttr.accept("last") ? -2 : 2;
                            case "third":
                                ttr.nextSymbol();
                                return ttr.accept("last") ? -3 : 3;
                            case "nth":
                                var v = parseInt(ttr.value[1], 10);
                                if (v < -366 || v > 366) {
                                    throw new Error("Nth out of range: " + v)
                                }
                                ttr.nextSymbol();
                                return ttr.accept("last") ? -v : v;
                            default:
                                return false
                        }
                    }

                    function F() {
                        if ("until" === ttr.symbol) {
                            var date = Date.parse(ttr.text);
                            if (!date) {
                                throw new Error("Cannot parse until date:" + ttr.text)
                            }
                            options.until = new Date(date)
                        } else if (ttr.accept("for")) {
                            options.count = parseInt(ttr.value[0], 10);
                            ttr.expect("number")
                        }
                    }
                }
                var Frequency;
                ! function(Frequency) {
                    Frequency[Frequency.YEARLY = 0] = "YEARLY";
                    Frequency[Frequency.MONTHLY = 1] = "MONTHLY";
                    Frequency[Frequency.WEEKLY = 2] = "WEEKLY";
                    Frequency[Frequency.DAILY = 3] = "DAILY";
                    Frequency[Frequency.HOURLY = 4] = "HOURLY";
                    Frequency[Frequency.MINUTELY = 5] = "MINUTELY";
                    Frequency[Frequency.SECONDLY = 6] = "SECONDLY"
                }(Frequency || (Frequency = {}));

                function freqIsDailyOrGreater(freq) {
                    return freq < Frequency.HOURLY
                }
                /* !
                 * rrule.js - Library for working with recurrence rules for calendar dates.
                 * https://github.com/jakubroztocil/rrule
                 *
                 * Copyright 2010, Jakub Roztocil and Lars Schoning
                 * Licenced under the BSD licence.
                 * https://github.com/jakubroztocil/rrule/blob/master/LICENCE
                 *
                 */
                var fromText = function(text, language) {
                    if (void 0 === language) {
                        language = i18n
                    }
                    return new RRule(parseText(text, language) || void 0)
                };
                var common = ["count", "until", "interval", "byweekday", "bymonthday", "bymonth"];
                totext.IMPLEMENTED = [];
                totext.IMPLEMENTED[Frequency.HOURLY] = common;
                totext.IMPLEMENTED[Frequency.MINUTELY] = common;
                totext.IMPLEMENTED[Frequency.DAILY] = ["byhour"].concat(common);
                totext.IMPLEMENTED[Frequency.WEEKLY] = common;
                totext.IMPLEMENTED[Frequency.MONTHLY] = common;
                totext.IMPLEMENTED[Frequency.YEARLY] = ["byweekno", "byyearday"].concat(common);
                var isFullyConvertible = totext.isFullyConvertible;
                var Time = function() {
                    function Time(hour, minute, second, millisecond) {
                        this.hour = hour;
                        this.minute = minute;
                        this.second = second;
                        this.millisecond = millisecond || 0
                    }
                    Time.prototype.getHours = function() {
                        return this.hour
                    };
                    Time.prototype.getMinutes = function() {
                        return this.minute
                    };
                    Time.prototype.getSeconds = function() {
                        return this.second
                    };
                    Time.prototype.getMilliseconds = function() {
                        return this.millisecond
                    };
                    Time.prototype.getTime = function() {
                        return 1e3 * (60 * this.hour * 60 + 60 * this.minute + this.second) + this.millisecond
                    };
                    return Time
                }();
                var DateTime = function(_super) {
                    __extends(DateTime, _super);

                    function DateTime(year, month, day, hour, minute, second, millisecond) {
                        var _this = _super.call(this, hour, minute, second, millisecond) || this;
                        _this.year = year;
                        _this.month = month;
                        _this.day = day;
                        return _this
                    }
                    DateTime.fromDate = function(date) {
                        return new this(date.getUTCFullYear(), date.getUTCMonth() + 1, date.getUTCDate(), date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds(), date.valueOf() % 1e3)
                    };
                    DateTime.prototype.getWeekday = function() {
                        return getWeekday(new Date(this.getTime()))
                    };
                    DateTime.prototype.getTime = function() {
                        return new Date(Date.UTC(this.year, this.month - 1, this.day, this.hour, this.minute, this.second, this.millisecond)).getTime()
                    };
                    DateTime.prototype.getDay = function() {
                        return this.day
                    };
                    DateTime.prototype.getMonth = function() {
                        return this.month
                    };
                    DateTime.prototype.getYear = function() {
                        return this.year
                    };
                    DateTime.prototype.addYears = function(years) {
                        this.year += years
                    };
                    DateTime.prototype.addMonths = function(months) {
                        this.month += months;
                        if (this.month > 12) {
                            var yearDiv = Math.floor(this.month / 12);
                            var monthMod = pymod(this.month, 12);
                            this.month = monthMod;
                            this.year += yearDiv;
                            if (0 === this.month) {
                                this.month = 12;
                                --this.year
                            }
                        }
                    };
                    DateTime.prototype.addWeekly = function(days, wkst) {
                        if (wkst > this.getWeekday()) {
                            this.day += -(this.getWeekday() + 1 + (6 - wkst)) + 7 * days
                        } else {
                            this.day += -(this.getWeekday() - wkst) + 7 * days
                        }
                        this.fixDay()
                    };
                    DateTime.prototype.addDaily = function(days) {
                        this.day += days;
                        this.fixDay()
                    };
                    DateTime.prototype.addHours = function(hours, filtered, byhour) {
                        if (filtered) {
                            this.hour += Math.floor((23 - this.hour) / hours) * hours
                        }
                        for (;;) {
                            this.hour += hours;
                            var _a = divmod(this.hour, 24),
                                dayDiv = _a.div,
                                hourMod = _a.mod;
                            if (dayDiv) {
                                this.hour = hourMod;
                                this.addDaily(dayDiv)
                            }
                            if (empty(byhour) || includes(byhour, this.hour)) {
                                break
                            }
                        }
                    };
                    DateTime.prototype.addMinutes = function(minutes, filtered, byhour, byminute) {
                        if (filtered) {
                            this.minute += Math.floor((1439 - (60 * this.hour + this.minute)) / minutes) * minutes
                        }
                        for (;;) {
                            this.minute += minutes;
                            var _a = divmod(this.minute, 60),
                                hourDiv = _a.div,
                                minuteMod = _a.mod;
                            if (hourDiv) {
                                this.minute = minuteMod;
                                this.addHours(hourDiv, false, byhour)
                            }
                            if ((empty(byhour) || includes(byhour, this.hour)) && (empty(byminute) || includes(byminute, this.minute))) {
                                break
                            }
                        }
                    };
                    DateTime.prototype.addSeconds = function(seconds, filtered, byhour, byminute, bysecond) {
                        if (filtered) {
                            this.second += Math.floor((86399 - (3600 * this.hour + 60 * this.minute + this.second)) / seconds) * seconds
                        }
                        for (;;) {
                            this.second += seconds;
                            var _a = divmod(this.second, 60),
                                minuteDiv = _a.div,
                                secondMod = _a.mod;
                            if (minuteDiv) {
                                this.second = secondMod;
                                this.addMinutes(minuteDiv, false, byhour, byminute)
                            }
                            if ((empty(byhour) || includes(byhour, this.hour)) && (empty(byminute) || includes(byminute, this.minute)) && (empty(bysecond) || includes(bysecond, this.second))) {
                                break
                            }
                        }
                    };
                    DateTime.prototype.fixDay = function() {
                        if (this.day <= 28) {
                            return
                        }
                        var daysinmonth = monthRange(this.year, this.month - 1)[1];
                        if (this.day <= daysinmonth) {
                            return
                        }
                        while (this.day > daysinmonth) {
                            this.day -= daysinmonth;
                            ++this.month;
                            if (13 === this.month) {
                                this.month = 1;
                                ++this.year;
                                if (this.year > MAXYEAR) {
                                    return
                                }
                            }
                            daysinmonth = monthRange(this.year, this.month - 1)[1]
                        }
                    };
                    DateTime.prototype.add = function(options, filtered) {
                        var freq = options.freq,
                            interval = options.interval,
                            wkst = options.wkst,
                            byhour = options.byhour,
                            byminute = options.byminute,
                            bysecond = options.bysecond;
                        switch (freq) {
                            case Frequency.YEARLY:
                                return this.addYears(interval);
                            case Frequency.MONTHLY:
                                return this.addMonths(interval);
                            case Frequency.WEEKLY:
                                return this.addWeekly(interval, wkst);
                            case Frequency.DAILY:
                                return this.addDaily(interval);
                            case Frequency.HOURLY:
                                return this.addHours(interval, filtered, byhour);
                            case Frequency.MINUTELY:
                                return this.addMinutes(interval, filtered, byhour, byminute);
                            case Frequency.SECONDLY:
                                return this.addSeconds(interval, filtered, byhour, byminute, bysecond)
                        }
                    };
                    return DateTime
                }(Time);

                function initializeOptions(options) {
                    var invalid = [];
                    var keys = Object.keys(options);
                    for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
                        var key = keys_1[_i];
                        if (!includes(defaultKeys, key)) {
                            invalid.push(key)
                        }
                        if (isDate(options[key]) && !isValidDate(options[key])) {
                            invalid.push(key)
                        }
                    }
                    if (invalid.length) {
                        throw new Error("Invalid options: " + invalid.join(", "))
                    }
                    return __assign({}, options)
                }

                function parseOptions(options) {
                    var opts = __assign(__assign({}, DEFAULT_OPTIONS), initializeOptions(options));
                    if (isPresent(opts.byeaster)) {
                        opts.freq = RRule.YEARLY
                    }
                    if (!(isPresent(opts.freq) && RRule.FREQUENCIES[opts.freq])) {
                        throw new Error("Invalid frequency: ".concat(opts.freq, " ").concat(options.freq))
                    }
                    if (!opts.dtstart) {
                        opts.dtstart = new Date((new Date).setMilliseconds(0))
                    }
                    if (!isPresent(opts.wkst)) {
                        opts.wkst = RRule.MO.weekday
                    } else if (isNumber(opts.wkst)) {} else {
                        opts.wkst = opts.wkst.weekday
                    }
                    if (isPresent(opts.bysetpos)) {
                        if (isNumber(opts.bysetpos)) {
                            opts.bysetpos = [opts.bysetpos]
                        }
                        for (var i = 0; i < opts.bysetpos.length; i++) {
                            var v = opts.bysetpos[i];
                            if (0 === v || !(v >= -366 && v <= 366)) {
                                throw new Error("bysetpos must be between 1 and 366, or between -366 and -1")
                            }
                        }
                    }
                    if (!(Boolean(opts.byweekno) || notEmpty(opts.byweekno) || notEmpty(opts.byyearday) || Boolean(opts.bymonthday) || notEmpty(opts.bymonthday) || isPresent(opts.byweekday) || isPresent(opts.byeaster))) {
                        switch (opts.freq) {
                            case RRule.YEARLY:
                                if (!opts.bymonth) {
                                    opts.bymonth = opts.dtstart.getUTCMonth() + 1
                                }
                                opts.bymonthday = opts.dtstart.getUTCDate();
                                break;
                            case RRule.MONTHLY:
                                opts.bymonthday = opts.dtstart.getUTCDate();
                                break;
                            case RRule.WEEKLY:
                                opts.byweekday = [getWeekday(opts.dtstart)]
                        }
                    }
                    if (isPresent(opts.bymonth) && !isArray(opts.bymonth)) {
                        opts.bymonth = [opts.bymonth]
                    }
                    if (isPresent(opts.byyearday) && !isArray(opts.byyearday) && isNumber(opts.byyearday)) {
                        opts.byyearday = [opts.byyearday]
                    }
                    if (!isPresent(opts.bymonthday)) {
                        opts.bymonthday = [];
                        opts.bynmonthday = []
                    } else if (isArray(opts.bymonthday)) {
                        var bymonthday = [];
                        var bynmonthday = [];
                        for (i = 0; i < opts.bymonthday.length; i++) {
                            v = opts.bymonthday[i];
                            if (v > 0) {
                                bymonthday.push(v)
                            } else if (v < 0) {
                                bynmonthday.push(v)
                            }
                        }
                        opts.bymonthday = bymonthday;
                        opts.bynmonthday = bynmonthday
                    } else if (opts.bymonthday < 0) {
                        opts.bynmonthday = [opts.bymonthday];
                        opts.bymonthday = []
                    } else {
                        opts.bynmonthday = [];
                        opts.bymonthday = [opts.bymonthday]
                    }
                    if (isPresent(opts.byweekno) && !isArray(opts.byweekno)) {
                        opts.byweekno = [opts.byweekno]
                    }
                    if (!isPresent(opts.byweekday)) {
                        opts.bynweekday = null
                    } else if (isNumber(opts.byweekday)) {
                        opts.byweekday = [opts.byweekday];
                        opts.bynweekday = null
                    } else if (isWeekdayStr(opts.byweekday)) {
                        opts.byweekday = [Weekday.fromStr(opts.byweekday).weekday];
                        opts.bynweekday = null
                    } else if (opts.byweekday instanceof Weekday) {
                        if (!opts.byweekday.n || opts.freq > RRule.MONTHLY) {
                            opts.byweekday = [opts.byweekday.weekday];
                            opts.bynweekday = null
                        } else {
                            opts.bynweekday = [
                                [opts.byweekday.weekday, opts.byweekday.n]
                            ];
                            opts.byweekday = null
                        }
                    } else {
                        var byweekday = [];
                        var bynweekday = [];
                        for (i = 0; i < opts.byweekday.length; i++) {
                            var wday = opts.byweekday[i];
                            if (isNumber(wday)) {
                                byweekday.push(wday);
                                continue
                            } else if (isWeekdayStr(wday)) {
                                byweekday.push(Weekday.fromStr(wday).weekday);
                                continue
                            }
                            if (!wday.n || opts.freq > RRule.MONTHLY) {
                                byweekday.push(wday.weekday)
                            } else {
                                bynweekday.push([wday.weekday, wday.n])
                            }
                        }
                        opts.byweekday = notEmpty(byweekday) ? byweekday : null;
                        opts.bynweekday = notEmpty(bynweekday) ? bynweekday : null
                    }
                    if (!isPresent(opts.byhour)) {
                        opts.byhour = opts.freq < RRule.HOURLY ? [opts.dtstart.getUTCHours()] : null
                    } else if (isNumber(opts.byhour)) {
                        opts.byhour = [opts.byhour]
                    }
                    if (!isPresent(opts.byminute)) {
                        opts.byminute = opts.freq < RRule.MINUTELY ? [opts.dtstart.getUTCMinutes()] : null
                    } else if (isNumber(opts.byminute)) {
                        opts.byminute = [opts.byminute]
                    }
                    if (!isPresent(opts.bysecond)) {
                        opts.bysecond = opts.freq < RRule.SECONDLY ? [opts.dtstart.getUTCSeconds()] : null
                    } else if (isNumber(opts.bysecond)) {
                        opts.bysecond = [opts.bysecond]
                    }
                    return {
                        parsedOptions: opts
                    }
                }

                function parseString(rfcString) {
                    var options = rfcString.split("\n").map(parseLine).filter((function(x) {
                        return null !== x
                    }));
                    return __assign(__assign({}, options[0]), options[1])
                }

                function parseDtstart(line) {
                    var options = {};
                    var dtstartWithZone = /DTSTART(?:;TZID=([^:=]+?))?(?::|=)([^;\s]+)/i.exec(line);
                    if (!dtstartWithZone) {
                        return options
                    }
                    var tzid = dtstartWithZone[1],
                        dtstart = dtstartWithZone[2];
                    if (tzid) {
                        options.tzid = tzid
                    }
                    options.dtstart = untilStringToDate(dtstart);
                    return options
                }

                function parseLine(rfcString) {
                    rfcString = rfcString.replace(/^\s+|\s+$/, "");
                    if (!rfcString.length) {
                        return null
                    }
                    var header = /^([A-Z]+?)[:;]/.exec(rfcString.toUpperCase());
                    if (!header) {
                        return parseRrule(rfcString)
                    }
                    var key = header[1];
                    switch (key.toUpperCase()) {
                        case "RRULE":
                        case "EXRULE":
                            return parseRrule(rfcString);
                        case "DTSTART":
                            return parseDtstart(rfcString);
                        default:
                            throw new Error("Unsupported RFC prop ".concat(key, " in ").concat(rfcString))
                    }
                }

                function parseRrule(line) {
                    var strippedLine = line.replace(/^RRULE:/i, "");
                    var options = parseDtstart(strippedLine);
                    var attrs = line.replace(/^(?:RRULE|EXRULE):/i, "").split(";");
                    attrs.forEach((function(attr) {
                        var _a = attr.split("="),
                            key = _a[0],
                            value = _a[1];
                        switch (key.toUpperCase()) {
                            case "FREQ":
                                options.freq = Frequency[value.toUpperCase()];
                                break;
                            case "WKST":
                                options.wkst = Days[value.toUpperCase()];
                                break;
                            case "COUNT":
                            case "INTERVAL":
                            case "BYSETPOS":
                            case "BYMONTH":
                            case "BYMONTHDAY":
                            case "BYYEARDAY":
                            case "BYWEEKNO":
                            case "BYHOUR":
                            case "BYMINUTE":
                            case "BYSECOND":
                                var num = function(value) {
                                    if (-1 !== value.indexOf(",")) {
                                        var values = value.split(",");
                                        return values.map(parseIndividualNumber)
                                    }
                                    return parseIndividualNumber(value)
                                }(value);
                                var optionKey = key.toLowerCase();
                                options[optionKey] = num;
                                break;
                            case "BYWEEKDAY":
                            case "BYDAY":
                                options.byweekday = function(value) {
                                    var days = value.split(",");
                                    return days.map((function(day) {
                                        if (2 === day.length) {
                                            return Days[day]
                                        }
                                        var parts = day.match(/^([+-]?\d{1,2})([A-Z]{2})$/);
                                        if (!parts || parts.length < 3) {
                                            throw new SyntaxError("Invalid weekday string: ".concat(day))
                                        }
                                        var n = Number(parts[1]);
                                        var wdaypart = parts[2];
                                        var wday = Days[wdaypart].weekday;
                                        return new Weekday(wday, n)
                                    }))
                                }(value);
                                break;
                            case "DTSTART":
                            case "TZID":
                                var dtstart = parseDtstart(line);
                                options.tzid = dtstart.tzid;
                                options.dtstart = dtstart.dtstart;
                                break;
                            case "UNTIL":
                                options.until = untilStringToDate(value);
                                break;
                            case "BYEASTER":
                                options.byeaster = Number(value);
                                break;
                            default:
                                throw new Error("Unknown RRULE property '" + key + "'")
                        }
                    }));
                    return options
                }

                function parseIndividualNumber(value) {
                    if (/^[+-]?\d+$/.test(value)) {
                        return Number(value)
                    }
                    return value
                }
                var DateWithZone = function() {
                    function DateWithZone(date, tzid) {
                        if (isNaN(date.getTime())) {
                            throw new RangeError("Invalid date passed to DateWithZone")
                        }
                        this.date = date;
                        this.tzid = tzid
                    }
                    Object.defineProperty(DateWithZone.prototype, "isUTC", {
                        get: function() {
                            return !this.tzid || "UTC" === this.tzid.toUpperCase()
                        },
                        enumerable: false,
                        configurable: true
                    });
                    DateWithZone.prototype.toString = function() {
                        var datestr = timeToUntilString(this.date.getTime(), this.isUTC);
                        if (!this.isUTC) {
                            return ";TZID=".concat(this.tzid, ":").concat(datestr)
                        }
                        return ":".concat(datestr)
                    };
                    DateWithZone.prototype.getTime = function() {
                        return this.date.getTime()
                    };
                    DateWithZone.prototype.rezonedDate = function() {
                        if (this.isUTC) {
                            return this.date
                        }
                        return function(date, timeZone) {
                            var localTimeZone = Intl.DateTimeFormat().resolvedOptions().timeZone;
                            var dateInLocalTZ = new Date(dateTZtoISO8601(date, localTimeZone));
                            var dateInTargetTZ = new Date(dateTZtoISO8601(date, null !== timeZone && void 0 !== timeZone ? timeZone : "UTC"));
                            var tzOffset = dateInTargetTZ.getTime() - dateInLocalTZ.getTime();
                            return new Date(date.getTime() - tzOffset)
                        }(this.date, this.tzid)
                    };
                    return DateWithZone
                }();

                function optionsToString(options) {
                    var rrule = [];
                    var dtstart = "";
                    var keys = Object.keys(options);
                    var defaultKeys = Object.keys(DEFAULT_OPTIONS);
                    for (var i = 0; i < keys.length; i++) {
                        if ("tzid" === keys[i]) {
                            continue
                        }
                        if (!includes(defaultKeys, keys[i])) {
                            continue
                        }
                        var key = keys[i].toUpperCase();
                        var value = options[keys[i]];
                        var outValue = "";
                        if (!isPresent(value) || isArray(value) && !value.length) {
                            continue
                        }
                        switch (key) {
                            case "FREQ":
                                outValue = RRule.FREQUENCIES[options.freq];
                                break;
                            case "WKST":
                                if (isNumber(value)) {
                                    outValue = new Weekday(value).toString()
                                } else {
                                    outValue = value.toString()
                                }
                                break;
                            case "BYWEEKDAY":
                                key = "BYDAY";
                                outValue = toArray(value).map((function(wday) {
                                    if (wday instanceof Weekday) {
                                        return wday
                                    }
                                    if (isArray(wday)) {
                                        return new Weekday(wday[0], wday[1])
                                    }
                                    return new Weekday(wday)
                                })).toString();
                                break;
                            case "DTSTART":
                                dtstart = buildDtstart(value, options.tzid);
                                break;
                            case "UNTIL":
                                outValue = timeToUntilString(value, !options.tzid);
                                break;
                            default:
                                if (isArray(value)) {
                                    var strValues = [];
                                    for (var j = 0; j < value.length; j++) {
                                        strValues[j] = String(value[j])
                                    }
                                    outValue = strValues.toString()
                                } else {
                                    outValue = String(value)
                                }
                        }
                        if (outValue) {
                            rrule.push([key, outValue])
                        }
                    }
                    var rules = rrule.map((function(_a) {
                        var key = _a[0],
                            value = _a[1];
                        return "".concat(key, "=").concat(value.toString())
                    })).join(";");
                    var ruleString = "";
                    if ("" !== rules) {
                        ruleString = "RRULE:".concat(rules)
                    }
                    return [dtstart, ruleString].filter((function(x) {
                        return !!x
                    })).join("\n")
                }

                function buildDtstart(dtstart, tzid) {
                    if (!dtstart) {
                        return ""
                    }
                    return "DTSTART" + new DateWithZone(new Date(dtstart), tzid).toString()
                }

                function argsMatch(left, right) {
                    if (Array.isArray(left)) {
                        if (!Array.isArray(right)) {
                            return false
                        }
                        if (left.length !== right.length) {
                            return false
                        }
                        return left.every((function(date, i) {
                            return date.getTime() === right[i].getTime()
                        }))
                    }
                    if (left instanceof Date) {
                        return right instanceof Date && left.getTime() === right.getTime()
                    }
                    return left === right
                }
                var Cache = function() {
                    function Cache() {
                        this.all = false;
                        this.before = [];
                        this.after = [];
                        this.between = []
                    }
                    Cache.prototype._cacheAdd = function(what, value, args) {
                        if (value) {
                            value = value instanceof Date ? dateutil_clone(value) : cloneDates(value)
                        }
                        if ("all" === what) {
                            this.all = value
                        } else {
                            args._value = value;
                            this[what].push(args)
                        }
                    };
                    Cache.prototype._cacheGet = function(what, args) {
                        var cached = false;
                        var argsKeys = args ? Object.keys(args) : [];
                        var findCacheDiff = function(item) {
                            for (var i = 0; i < argsKeys.length; i++) {
                                var key = argsKeys[i];
                                if (!argsMatch(args[key], item[key])) {
                                    return true
                                }
                            }
                            return false
                        };
                        var cachedObject = this[what];
                        if ("all" === what) {
                            cached = this.all
                        } else if (isArray(cachedObject)) {
                            for (var i = 0; i < cachedObject.length; i++) {
                                var item = cachedObject[i];
                                if (argsKeys.length && findCacheDiff(item)) {
                                    continue
                                }
                                cached = item._value;
                                break
                            }
                        }
                        if (!cached && this.all) {
                            var iterResult = new iterresult(what, args);
                            for (i = 0; i < this.all.length; i++) {
                                if (!iterResult.accept(this.all[i])) {
                                    break
                                }
                            }
                            cached = iterResult.getValue();
                            this._cacheAdd(what, cached, args)
                        }
                        return isArray(cached) ? cloneDates(cached) : cached instanceof Date ? dateutil_clone(cached) : cached
                    };
                    return Cache
                }();
                var M365MASK = __spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray([], repeat(1, 31), true), repeat(2, 28), true), repeat(3, 31), true), repeat(4, 30), true), repeat(5, 31), true), repeat(6, 30), true), repeat(7, 31), true), repeat(8, 31), true), repeat(9, 30), true), repeat(10, 31), true), repeat(11, 30), true), repeat(12, 31), true), repeat(1, 7), true);
                var M366MASK = __spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray([], repeat(1, 31), true), repeat(2, 29), true), repeat(3, 31), true), repeat(4, 30), true), repeat(5, 31), true), repeat(6, 30), true), repeat(7, 31), true), repeat(8, 31), true), repeat(9, 30), true), repeat(10, 31), true), repeat(11, 30), true), repeat(12, 31), true), repeat(1, 7), true);
                var M28 = range(1, 29);
                var M29 = range(1, 30);
                var M30 = range(1, 31);
                var M31 = range(1, 32);
                var MDAY366MASK = __spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray([], M31, true), M29, true), M31, true), M30, true), M31, true), M30, true), M31, true), M31, true), M30, true), M31, true), M30, true), M31, true), M31.slice(0, 7), true);
                var MDAY365MASK = __spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray([], M31, true), M28, true), M31, true), M30, true), M31, true), M30, true), M31, true), M31, true), M30, true), M31, true), M30, true), M31, true), M31.slice(0, 7), true);
                var NM28 = range(-28, 0);
                var NM29 = range(-29, 0);
                var NM30 = range(-30, 0);
                var NM31 = range(-31, 0);
                var NMDAY366MASK = __spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray([], NM31, true), NM29, true), NM31, true), NM30, true), NM31, true), NM30, true), NM31, true), NM31, true), NM30, true), NM31, true), NM30, true), NM31, true), NM31.slice(0, 7), true);
                var NMDAY365MASK = __spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray(__spreadArray([], NM31, true), NM28, true), NM31, true), NM30, true), NM31, true), NM30, true), NM31, true), NM31, true), NM30, true), NM31, true), NM30, true), NM31, true), NM31.slice(0, 7), true);
                var M366RANGE = [0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366];
                var M365RANGE = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365];
                var WDAYMASK = function() {
                    var wdaymask = [];
                    for (var i = 0; i < 55; i++) {
                        wdaymask = wdaymask.concat(range(7))
                    }
                    return wdaymask
                }();

                function rebuildYear(year, options) {
                    var firstyday = datetime(year, 1, 1);
                    var yearlen = isLeapYear(year) ? 366 : 365;
                    var nextyearlen = isLeapYear(year + 1) ? 366 : 365;
                    var yearordinal = toOrdinal(firstyday);
                    var yearweekday = getWeekday(firstyday);
                    var result = __assign(__assign({
                        yearlen: yearlen,
                        nextyearlen: nextyearlen,
                        yearordinal: yearordinal,
                        yearweekday: yearweekday
                    }, function(year) {
                        var yearlen = isLeapYear(year) ? 366 : 365;
                        var firstyday = datetime(year, 1, 1);
                        var wday = getWeekday(firstyday);
                        if (365 === yearlen) {
                            return {
                                mmask: M365MASK,
                                mdaymask: MDAY365MASK,
                                nmdaymask: NMDAY365MASK,
                                wdaymask: WDAYMASK.slice(wday),
                                mrange: M365RANGE
                            }
                        }
                        return {
                            mmask: M366MASK,
                            mdaymask: MDAY366MASK,
                            nmdaymask: NMDAY366MASK,
                            wdaymask: WDAYMASK.slice(wday),
                            mrange: M366RANGE
                        }
                    }(year)), {
                        wnomask: null
                    });
                    if (empty(options.byweekno)) {
                        return result
                    }
                    result.wnomask = repeat(0, yearlen + 7);
                    var firstwkst;
                    var wyearlen;
                    var no1wkst = firstwkst = pymod(7 - yearweekday + options.wkst, 7);
                    if (no1wkst >= 4) {
                        no1wkst = 0;
                        wyearlen = result.yearlen + pymod(yearweekday - options.wkst, 7)
                    } else {
                        wyearlen = yearlen - no1wkst
                    }
                    var div = Math.floor(wyearlen / 7);
                    var mod = pymod(wyearlen, 7);
                    var numweeks = Math.floor(div + mod / 4);
                    for (var j = 0; j < options.byweekno.length; j++) {
                        var n = options.byweekno[j];
                        if (n < 0) {
                            n += numweeks + 1
                        }
                        if (!(n > 0 && n <= numweeks)) {
                            continue
                        }
                        var i = void 0;
                        if (n > 1) {
                            i = no1wkst + 7 * (n - 1);
                            if (no1wkst !== firstwkst) {
                                i -= 7 - firstwkst
                            }
                        } else {
                            i = no1wkst
                        }
                        for (var k = 0; k < 7; k++) {
                            result.wnomask[i] = 1;
                            i++;
                            if (result.wdaymask[i] === options.wkst) {
                                break
                            }
                        }
                    }
                    if (includes(options.byweekno, 1)) {
                        i = no1wkst + 7 * numweeks;
                        if (no1wkst !== firstwkst) {
                            i -= 7 - firstwkst
                        }
                        if (i < yearlen) {
                            for (j = 0; j < 7; j++) {
                                result.wnomask[i] = 1;
                                i += 1;
                                if (result.wdaymask[i] === options.wkst) {
                                    break
                                }
                            }
                        }
                    }
                    if (no1wkst) {
                        var lnumweeks = void 0;
                        if (!includes(options.byweekno, -1)) {
                            var lyearweekday = getWeekday(datetime(year - 1, 1, 1));
                            var lno1wkst = pymod(7 - lyearweekday.valueOf() + options.wkst, 7);
                            var lyearlen = isLeapYear(year - 1) ? 366 : 365;
                            var weekst = void 0;
                            if (lno1wkst >= 4) {
                                lno1wkst = 0;
                                weekst = lyearlen + pymod(lyearweekday - options.wkst, 7)
                            } else {
                                weekst = yearlen - no1wkst
                            }
                            lnumweeks = Math.floor(52 + pymod(weekst, 7) / 4)
                        } else {
                            lnumweeks = -1
                        }
                        if (includes(options.byweekno, lnumweeks)) {
                            for (i = 0; i < no1wkst; i++) {
                                result.wnomask[i] = 1
                            }
                        }
                    }
                    return result
                }
                var Iterinfo = function() {
                    function Iterinfo(options) {
                        this.options = options
                    }
                    Iterinfo.prototype.rebuild = function(year, month) {
                        var options = this.options;
                        if (year !== this.lastyear) {
                            this.yearinfo = rebuildYear(year, options)
                        }
                        if (notEmpty(options.bynweekday) && (month !== this.lastmonth || year !== this.lastyear)) {
                            var _a = this.yearinfo,
                                yearlen = _a.yearlen,
                                mrange = _a.mrange,
                                wdaymask = _a.wdaymask;
                            this.monthinfo = function(year, month, yearlen, mrange, wdaymask, options) {
                                var result = {
                                    lastyear: year,
                                    lastmonth: month,
                                    nwdaymask: []
                                };
                                var ranges = [];
                                if (options.freq === RRule.YEARLY) {
                                    if (empty(options.bymonth)) {
                                        ranges = [
                                            [0, yearlen]
                                        ]
                                    } else {
                                        for (var j = 0; j < options.bymonth.length; j++) {
                                            month = options.bymonth[j];
                                            ranges.push(mrange.slice(month - 1, month + 1))
                                        }
                                    }
                                } else if (options.freq === RRule.MONTHLY) {
                                    ranges = [mrange.slice(month - 1, month + 1)]
                                }
                                if (empty(ranges)) {
                                    return result
                                }
                                result.nwdaymask = repeat(0, yearlen);
                                for (j = 0; j < ranges.length; j++) {
                                    var rang = ranges[j];
                                    var first = rang[0];
                                    var last = rang[1] - 1;
                                    for (var k = 0; k < options.bynweekday.length; k++) {
                                        var i = void 0;
                                        var _a = options.bynweekday[k],
                                            wday = _a[0],
                                            n = _a[1];
                                        if (n < 0) {
                                            i = last + 7 * (n + 1);
                                            i -= pymod(wdaymask[i] - wday, 7)
                                        } else {
                                            i = first + 7 * (n - 1);
                                            i += pymod(7 - wdaymask[i] + wday, 7)
                                        }
                                        if (first <= i && i <= last) {
                                            result.nwdaymask[i] = 1
                                        }
                                    }
                                }
                                return result
                            }(year, month, yearlen, mrange, wdaymask, options)
                        }
                        if (isPresent(options.byeaster)) {
                            this.eastermask = function(y, offset) {
                                if (void 0 === offset) {
                                    offset = 0
                                }
                                var a = y % 19;
                                var b = Math.floor(y / 100);
                                var c = y % 100;
                                var d = Math.floor(b / 4);
                                var e = b % 4;
                                var f = Math.floor((b + 8) / 25);
                                var g = Math.floor((b - f + 1) / 3);
                                var h = Math.floor(19 * a + b - d - g + 15) % 30;
                                var i = Math.floor(c / 4);
                                var k = c % 4;
                                var l = Math.floor(32 + 2 * e + 2 * i - h - k) % 7;
                                var m = Math.floor((a + 11 * h + 22 * l) / 451);
                                var month = Math.floor((h + l - 7 * m + 114) / 31);
                                var day = (h + l - 7 * m + 114) % 31 + 1;
                                var date = Date.UTC(y, month - 1, day + offset);
                                var yearStart = Date.UTC(y, 0, 1);
                                return [Math.ceil((date - yearStart) / 864e5)]
                            }(year, options.byeaster)
                        }
                    };
                    Object.defineProperty(Iterinfo.prototype, "lastyear", {
                        get: function() {
                            return this.monthinfo ? this.monthinfo.lastyear : null
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "lastmonth", {
                        get: function() {
                            return this.monthinfo ? this.monthinfo.lastmonth : null
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "yearlen", {
                        get: function() {
                            return this.yearinfo.yearlen
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "yearordinal", {
                        get: function() {
                            return this.yearinfo.yearordinal
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "mrange", {
                        get: function() {
                            return this.yearinfo.mrange
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "wdaymask", {
                        get: function() {
                            return this.yearinfo.wdaymask
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "mmask", {
                        get: function() {
                            return this.yearinfo.mmask
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "wnomask", {
                        get: function() {
                            return this.yearinfo.wnomask
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "nwdaymask", {
                        get: function() {
                            return this.monthinfo ? this.monthinfo.nwdaymask : []
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "nextyearlen", {
                        get: function() {
                            return this.yearinfo.nextyearlen
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "mdaymask", {
                        get: function() {
                            return this.yearinfo.mdaymask
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Object.defineProperty(Iterinfo.prototype, "nmdaymask", {
                        get: function() {
                            return this.yearinfo.nmdaymask
                        },
                        enumerable: false,
                        configurable: true
                    });
                    Iterinfo.prototype.ydayset = function() {
                        return [range(this.yearlen), 0, this.yearlen]
                    };
                    Iterinfo.prototype.mdayset = function(_, month) {
                        var start = this.mrange[month - 1];
                        var end = this.mrange[month];
                        var set = repeat(null, this.yearlen);
                        for (var i = start; i < end; i++) {
                            set[i] = i
                        }
                        return [set, start, end]
                    };
                    Iterinfo.prototype.wdayset = function(year, month, day) {
                        var set = repeat(null, this.yearlen + 7);
                        var i = toOrdinal(datetime(year, month, day)) - this.yearordinal;
                        var start = i;
                        for (var j = 0; j < 7; j++) {
                            set[i] = i;
                            ++i;
                            if (this.wdaymask[i] === this.options.wkst) {
                                break
                            }
                        }
                        return [set, start, i]
                    };
                    Iterinfo.prototype.ddayset = function(year, month, day) {
                        var set = repeat(null, this.yearlen);
                        var i = toOrdinal(datetime(year, month, day)) - this.yearordinal;
                        set[i] = i;
                        return [set, i, i + 1]
                    };
                    Iterinfo.prototype.htimeset = function(hour, _, second, millisecond) {
                        var _this = this;
                        var set = [];
                        this.options.byminute.forEach((function(minute) {
                            set = set.concat(_this.mtimeset(hour, minute, second, millisecond))
                        }));
                        sort(set);
                        return set
                    };
                    Iterinfo.prototype.mtimeset = function(hour, minute, _, millisecond) {
                        var set = this.options.bysecond.map((function(second) {
                            return new Time(hour, minute, second, millisecond)
                        }));
                        sort(set);
                        return set
                    };
                    Iterinfo.prototype.stimeset = function(hour, minute, second, millisecond) {
                        return [new Time(hour, minute, second, millisecond)]
                    };
                    Iterinfo.prototype.getdayset = function(freq) {
                        switch (freq) {
                            case Frequency.YEARLY:
                                return this.ydayset.bind(this);
                            case Frequency.MONTHLY:
                                return this.mdayset.bind(this);
                            case Frequency.WEEKLY:
                                return this.wdayset.bind(this);
                            case Frequency.DAILY:
                            default:
                                return this.ddayset.bind(this)
                        }
                    };
                    Iterinfo.prototype.gettimeset = function(freq) {
                        switch (freq) {
                            case Frequency.HOURLY:
                                return this.htimeset.bind(this);
                            case Frequency.MINUTELY:
                                return this.mtimeset.bind(this);
                            case Frequency.SECONDLY:
                                return this.stimeset.bind(this)
                        }
                    };
                    return Iterinfo
                }();
                var iterinfo = Iterinfo;

                function buildPoslist(bysetpos, timeset, start, end, ii, dayset) {
                    var poslist = [];
                    for (var j = 0; j < bysetpos.length; j++) {
                        var daypos = void 0;
                        var timepos = void 0;
                        var pos = bysetpos[j];
                        if (pos < 0) {
                            daypos = Math.floor(pos / timeset.length);
                            timepos = pymod(pos, timeset.length)
                        } else {
                            daypos = Math.floor((pos - 1) / timeset.length);
                            timepos = pymod(pos - 1, timeset.length)
                        }
                        var tmp = [];
                        for (var k = start; k < end; k++) {
                            var val = dayset[k];
                            if (!isPresent(val)) {
                                continue
                            }
                            tmp.push(val)
                        }
                        var i = void 0;
                        if (daypos < 0) {
                            i = tmp.slice(daypos)[0]
                        } else {
                            i = tmp[daypos]
                        }
                        var time = timeset[timepos];
                        var date = fromOrdinal(ii.yearordinal + i);
                        var res = combine(date, time);
                        if (!includes(poslist, res)) {
                            poslist.push(res)
                        }
                    }
                    sort(poslist);
                    return poslist
                }

                function iter(iterResult, options) {
                    var dtstart = options.dtstart,
                        freq = options.freq,
                        interval = options.interval,
                        until = options.until,
                        bysetpos = options.bysetpos;
                    var count = options.count;
                    if (0 === count || 0 === interval) {
                        return emitResult(iterResult)
                    }
                    var counterDate = DateTime.fromDate(dtstart);
                    var ii = new iterinfo(options);
                    ii.rebuild(counterDate.year, counterDate.month);
                    var timeset = function(ii, counterDate, options) {
                        var freq = options.freq,
                            byhour = options.byhour,
                            byminute = options.byminute,
                            bysecond = options.bysecond;
                        if (freqIsDailyOrGreater(freq)) {
                            return function(opts) {
                                var millisecondModulo = opts.dtstart.getTime() % 1e3;
                                if (!freqIsDailyOrGreater(opts.freq)) {
                                    return []
                                }
                                var timeset = [];
                                opts.byhour.forEach((function(hour) {
                                    opts.byminute.forEach((function(minute) {
                                        opts.bysecond.forEach((function(second) {
                                            timeset.push(new Time(hour, minute, second, millisecondModulo))
                                        }))
                                    }))
                                }));
                                return timeset
                            }(options)
                        }
                        if (freq >= RRule.HOURLY && notEmpty(byhour) && !includes(byhour, counterDate.hour) || freq >= RRule.MINUTELY && notEmpty(byminute) && !includes(byminute, counterDate.minute) || freq >= RRule.SECONDLY && notEmpty(bysecond) && !includes(bysecond, counterDate.second)) {
                            return []
                        }
                        return ii.gettimeset(freq)(counterDate.hour, counterDate.minute, counterDate.second, counterDate.millisecond)
                    }(ii, counterDate, options);
                    for (;;) {
                        var _a = ii.getdayset(freq)(counterDate.year, counterDate.month, counterDate.day),
                            dayset = _a[0],
                            start = _a[1],
                            end = _a[2];
                        var filtered = removeFilteredDays(dayset, start, end, ii, options);
                        if (notEmpty(bysetpos)) {
                            var poslist = buildPoslist(bysetpos, timeset, start, end, ii, dayset);
                            for (var j = 0; j < poslist.length; j++) {
                                var res = poslist[j];
                                if (until && res > until) {
                                    return emitResult(iterResult)
                                }
                                if (res >= dtstart) {
                                    var rezonedDate = rezoneIfNeeded(res, options);
                                    if (!iterResult.accept(rezonedDate)) {
                                        return emitResult(iterResult)
                                    }
                                    if (count) {
                                        --count;
                                        if (!count) {
                                            return emitResult(iterResult)
                                        }
                                    }
                                }
                            }
                        } else {
                            for (j = start; j < end; j++) {
                                var currentDay = dayset[j];
                                if (!isPresent(currentDay)) {
                                    continue
                                }
                                var date = fromOrdinal(ii.yearordinal + currentDay);
                                for (var k = 0; k < timeset.length; k++) {
                                    var time = timeset[k];
                                    res = combine(date, time);
                                    if (until && res > until) {
                                        return emitResult(iterResult)
                                    }
                                    if (res >= dtstart) {
                                        rezonedDate = rezoneIfNeeded(res, options);
                                        if (!iterResult.accept(rezonedDate)) {
                                            return emitResult(iterResult)
                                        }
                                        if (count) {
                                            --count;
                                            if (!count) {
                                                return emitResult(iterResult)
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        if (0 === options.interval) {
                            return emitResult(iterResult)
                        }
                        counterDate.add(options, filtered);
                        if (counterDate.year > MAXYEAR) {
                            return emitResult(iterResult)
                        }
                        if (!freqIsDailyOrGreater(freq)) {
                            timeset = ii.gettimeset(freq)(counterDate.hour, counterDate.minute, counterDate.second, 0)
                        }
                        ii.rebuild(counterDate.year, counterDate.month)
                    }
                }

                function isFiltered(ii, currentDay, options) {
                    var bymonth = options.bymonth,
                        byweekno = options.byweekno,
                        byweekday = options.byweekday,
                        byeaster = options.byeaster,
                        bymonthday = options.bymonthday,
                        bynmonthday = options.bynmonthday,
                        byyearday = options.byyearday;
                    return notEmpty(bymonth) && !includes(bymonth, ii.mmask[currentDay]) || notEmpty(byweekno) && !ii.wnomask[currentDay] || notEmpty(byweekday) && !includes(byweekday, ii.wdaymask[currentDay]) || notEmpty(ii.nwdaymask) && !ii.nwdaymask[currentDay] || null !== byeaster && !includes(ii.eastermask, currentDay) || (notEmpty(bymonthday) || notEmpty(bynmonthday)) && !includes(bymonthday, ii.mdaymask[currentDay]) && !includes(bynmonthday, ii.nmdaymask[currentDay]) || notEmpty(byyearday) && (currentDay < ii.yearlen && !includes(byyearday, currentDay + 1) && !includes(byyearday, -ii.yearlen + currentDay) || currentDay >= ii.yearlen && !includes(byyearday, currentDay + 1 - ii.yearlen) && !includes(byyearday, -ii.nextyearlen + currentDay - ii.yearlen))
                }

                function rezoneIfNeeded(date, options) {
                    return new DateWithZone(date, options.tzid).rezonedDate()
                }

                function emitResult(iterResult) {
                    return iterResult.getValue()
                }

                function removeFilteredDays(dayset, start, end, ii, options) {
                    var filtered = false;
                    for (var dayCounter = start; dayCounter < end; dayCounter++) {
                        var currentDay = dayset[dayCounter];
                        filtered = isFiltered(ii, currentDay, options);
                        if (filtered) {
                            dayset[currentDay] = null
                        }
                    }
                    return filtered
                }
                var Days = {
                    MO: new Weekday(0),
                    TU: new Weekday(1),
                    WE: new Weekday(2),
                    TH: new Weekday(3),
                    FR: new Weekday(4),
                    SA: new Weekday(5),
                    SU: new Weekday(6)
                };
                var DEFAULT_OPTIONS = {
                    freq: Frequency.YEARLY,
                    dtstart: null,
                    interval: 1,
                    wkst: Days.MO,
                    count: null,
                    until: null,
                    tzid: null,
                    bysetpos: null,
                    bymonth: null,
                    bymonthday: null,
                    bynmonthday: null,
                    byyearday: null,
                    byweekno: null,
                    byweekday: null,
                    bynweekday: null,
                    byhour: null,
                    byminute: null,
                    bysecond: null,
                    byeaster: null
                };
                var defaultKeys = Object.keys(DEFAULT_OPTIONS);
                var RRule = function() {
                    function RRule(options, noCache) {
                        if (void 0 === options) {
                            options = {}
                        }
                        if (void 0 === noCache) {
                            noCache = false
                        }
                        this._cache = noCache ? null : new Cache;
                        this.origOptions = initializeOptions(options);
                        var parsedOptions = parseOptions(options).parsedOptions;
                        this.options = parsedOptions
                    }
                    RRule.parseText = function(text, language) {
                        return parseText(text, language)
                    };
                    RRule.fromText = function(text, language) {
                        return fromText(text, language)
                    };
                    RRule.fromString = function(str) {
                        return new RRule(RRule.parseString(str) || void 0)
                    };
                    RRule.prototype._iter = function(iterResult) {
                        return iter(iterResult, this.options)
                    };
                    RRule.prototype._cacheGet = function(what, args) {
                        if (!this._cache) {
                            return false
                        }
                        return this._cache._cacheGet(what, args)
                    };
                    RRule.prototype._cacheAdd = function(what, value, args) {
                        if (!this._cache) {
                            return
                        }
                        return this._cache._cacheAdd(what, value, args)
                    };
                    RRule.prototype.all = function(iterator) {
                        if (iterator) {
                            return this._iter(new callbackiterresult("all", {}, iterator))
                        }
                        var result = this._cacheGet("all");
                        if (false === result) {
                            result = this._iter(new iterresult("all", {}));
                            this._cacheAdd("all", result)
                        }
                        return result
                    };
                    RRule.prototype.between = function(after, before, inc, iterator) {
                        if (void 0 === inc) {
                            inc = false
                        }
                        if (!isValidDate(after) || !isValidDate(before)) {
                            throw new Error("Invalid date passed in to RRule.between")
                        }
                        var args = {
                            before: before,
                            after: after,
                            inc: inc
                        };
                        if (iterator) {
                            return this._iter(new callbackiterresult("between", args, iterator))
                        }
                        var result = this._cacheGet("between", args);
                        if (false === result) {
                            result = this._iter(new iterresult("between", args));
                            this._cacheAdd("between", result, args)
                        }
                        return result
                    };
                    RRule.prototype.before = function(dt, inc) {
                        if (void 0 === inc) {
                            inc = false
                        }
                        if (!isValidDate(dt)) {
                            throw new Error("Invalid date passed in to RRule.before")
                        }
                        var args = {
                            dt: dt,
                            inc: inc
                        };
                        var result = this._cacheGet("before", args);
                        if (false === result) {
                            result = this._iter(new iterresult("before", args));
                            this._cacheAdd("before", result, args)
                        }
                        return result
                    };
                    RRule.prototype.after = function(dt, inc) {
                        if (void 0 === inc) {
                            inc = false
                        }
                        if (!isValidDate(dt)) {
                            throw new Error("Invalid date passed in to RRule.after")
                        }
                        var args = {
                            dt: dt,
                            inc: inc
                        };
                        var result = this._cacheGet("after", args);
                        if (false === result) {
                            result = this._iter(new iterresult("after", args));
                            this._cacheAdd("after", result, args)
                        }
                        return result
                    };
                    RRule.prototype.count = function() {
                        return this.all().length
                    };
                    RRule.prototype.toString = function() {
                        return optionsToString(this.origOptions)
                    };
                    RRule.prototype.toText = function(gettext, language, dateFormatter) {
                        return function(rrule, gettext, language, dateFormatter) {
                            return new totext(rrule, gettext, language, dateFormatter).toString()
                        }(this, gettext, language, dateFormatter)
                    };
                    RRule.prototype.isFullyConvertibleToText = function() {
                        return isFullyConvertible(this)
                    };
                    RRule.prototype.clone = function() {
                        return new RRule(this.origOptions)
                    };
                    RRule.FREQUENCIES = ["YEARLY", "MONTHLY", "WEEKLY", "DAILY", "HOURLY", "MINUTELY", "SECONDLY"];
                    RRule.YEARLY = Frequency.YEARLY;
                    RRule.MONTHLY = Frequency.MONTHLY;
                    RRule.WEEKLY = Frequency.WEEKLY;
                    RRule.DAILY = Frequency.DAILY;
                    RRule.HOURLY = Frequency.HOURLY;
                    RRule.MINUTELY = Frequency.MINUTELY;
                    RRule.SECONDLY = Frequency.SECONDLY;
                    RRule.MO = Days.MO;
                    RRule.TU = Days.TU;
                    RRule.WE = Days.WE;
                    RRule.TH = Days.TH;
                    RRule.FR = Days.FR;
                    RRule.SA = Days.SA;
                    RRule.SU = Days.SU;
                    RRule.parseString = parseString;
                    RRule.optionsToString = optionsToString;
                    return RRule
                }();
                var rrulestr_DEFAULT_OPTIONS = {
                    dtstart: null,
                    cache: false,
                    unfold: false,
                    forceset: false,
                    compatible: false,
                    tzid: null
                };

                function parseInput(s, options) {
                    var rrulevals = [];
                    var rdatevals = [];
                    var exrulevals = [];
                    var exdatevals = [];
                    var parsedDtstart = parseDtstart(s);
                    var dtstart = parsedDtstart.dtstart;
                    var tzid = parsedDtstart.tzid;
                    var lines = function(s, unfold) {
                        if (void 0 === unfold) {
                            unfold = false
                        }
                        s = s && s.trim();
                        if (!s) {
                            throw new Error("Invalid empty string")
                        }
                        if (!unfold) {
                            return s.split(/\s/)
                        }
                        var lines = s.split("\n");
                        var i = 0;
                        while (i < lines.length) {
                            var line = lines[i] = lines[i].replace(/\s+$/g, "");
                            if (!line) {
                                lines.splice(i, 1)
                            } else if (i > 0 && " " === line[0]) {
                                lines[i - 1] += line.slice(1);
                                lines.splice(i, 1)
                            } else {
                                i += 1
                            }
                        }
                        return lines
                    }(s, options.unfold);
                    lines.forEach((function(line) {
                        var _a;
                        if (!line) {
                            return
                        }
                        var _b = function(line) {
                                var _a = function(line) {
                                        if (-1 === line.indexOf(":")) {
                                            return {
                                                name: "RRULE",
                                                value: line
                                            }
                                        }
                                        var _a = split(line, ":", 1),
                                            name = _a[0],
                                            value = _a[1];
                                        return {
                                            name: name,
                                            value: value
                                        }
                                    }(line),
                                    name = _a.name,
                                    value = _a.value;
                                var parms = name.split(";");
                                if (!parms) {
                                    throw new Error("empty property name")
                                }
                                return {
                                    name: parms[0].toUpperCase(),
                                    parms: parms.slice(1),
                                    value: value
                                }
                            }(line),
                            name = _b.name,
                            parms = _b.parms,
                            value = _b.value;
                        switch (name.toUpperCase()) {
                            case "RRULE":
                                if (parms.length) {
                                    throw new Error("unsupported RRULE parm: ".concat(parms.join(",")))
                                }
                                rrulevals.push(parseString(line));
                                break;
                            case "RDATE":
                                var _c = null !== (_a = /RDATE(?:;TZID=([^:=]+))?/i.exec(line)) && void 0 !== _a ? _a : [],
                                    rdateTzid = _c[1];
                                if (rdateTzid && !tzid) {
                                    tzid = rdateTzid
                                }
                                rdatevals = rdatevals.concat(parseRDate(value, parms));
                                break;
                            case "EXRULE":
                                if (parms.length) {
                                    throw new Error("unsupported EXRULE parm: ".concat(parms.join(",")))
                                }
                                exrulevals.push(parseString(value));
                                break;
                            case "EXDATE":
                                exdatevals = exdatevals.concat(parseRDate(value, parms));
                                break;
                            case "DTSTART":
                                break;
                            default:
                                throw new Error("unsupported property: " + name)
                        }
                    }));
                    return {
                        dtstart: dtstart,
                        tzid: tzid,
                        rrulevals: rrulevals,
                        rdatevals: rdatevals,
                        exrulevals: exrulevals,
                        exdatevals: exdatevals
                    }
                }

                function rrulestr(s, options) {
                    if (void 0 === options) {
                        options = {}
                    }
                    return function(s, options) {
                        var _a = parseInput(s, options),
                            rrulevals = _a.rrulevals,
                            rdatevals = _a.rdatevals,
                            exrulevals = _a.exrulevals,
                            exdatevals = _a.exdatevals,
                            dtstart = _a.dtstart,
                            tzid = _a.tzid;
                        var noCache = false === options.cache;
                        if (options.compatible) {
                            options.forceset = true;
                            options.unfold = true
                        }
                        if (options.forceset || rrulevals.length > 1 || rdatevals.length || exrulevals.length || exdatevals.length) {
                            var rset_1 = new RRuleSet(noCache);
                            rset_1.dtstart(dtstart);
                            rset_1.tzid(tzid || void 0);
                            rrulevals.forEach((function(val) {
                                rset_1.rrule(new RRule(groomRruleOptions(val, dtstart, tzid), noCache))
                            }));
                            rdatevals.forEach((function(date) {
                                rset_1.rdate(date)
                            }));
                            exrulevals.forEach((function(val) {
                                rset_1.exrule(new RRule(groomRruleOptions(val, dtstart, tzid), noCache))
                            }));
                            exdatevals.forEach((function(date) {
                                rset_1.exdate(date)
                            }));
                            if (options.compatible && options.dtstart) {
                                rset_1.rdate(dtstart)
                            }
                            return rset_1
                        }
                        var val = rrulevals[0] || {};
                        return new RRule(groomRruleOptions(val, val.dtstart || options.dtstart || dtstart, val.tzid || options.tzid || tzid), noCache)
                    }(s, function(options) {
                        var invalid = [];
                        var keys = Object.keys(options);
                        var defaultKeys = Object.keys(rrulestr_DEFAULT_OPTIONS);
                        keys.forEach((function(key) {
                            if (!includes(defaultKeys, key)) {
                                invalid.push(key)
                            }
                        }));
                        if (invalid.length) {
                            throw new Error("Invalid options: " + invalid.join(", "))
                        }
                        return __assign(__assign({}, rrulestr_DEFAULT_OPTIONS), options)
                    }(options))
                }

                function groomRruleOptions(val, dtstart, tzid) {
                    return __assign(__assign({}, val), {
                        dtstart: dtstart,
                        tzid: tzid
                    })
                }

                function parseRDate(rdateval, parms) {
                    ! function(parms) {
                        parms.forEach((function(parm) {
                            if (!/(VALUE=DATE(-TIME)?)|(TZID=)/.test(parm)) {
                                throw new Error("unsupported RDATE/EXDATE parm: " + parm)
                            }
                        }))
                    }(parms);
                    return rdateval.split(",").map((function(datestr) {
                        return untilStringToDate(datestr)
                    }))
                }

                function createGetterSetter(fieldName) {
                    var _this = this;
                    return function(field) {
                        if (void 0 !== field) {
                            _this["_".concat(fieldName)] = field
                        }
                        if (void 0 !== _this["_".concat(fieldName)]) {
                            return _this["_".concat(fieldName)]
                        }
                        for (var i = 0; i < _this._rrule.length; i++) {
                            var field_1 = _this._rrule[i].origOptions[fieldName];
                            if (field_1) {
                                return field_1
                            }
                        }
                    }
                }
                var RRuleSet = function(_super) {
                    __extends(RRuleSet, _super);

                    function RRuleSet(noCache) {
                        if (void 0 === noCache) {
                            noCache = false
                        }
                        var _this = _super.call(this, {}, noCache) || this;
                        _this.dtstart = createGetterSetter.apply(_this, ["dtstart"]);
                        _this.tzid = createGetterSetter.apply(_this, ["tzid"]);
                        _this._rrule = [];
                        _this._rdate = [];
                        _this._exrule = [];
                        _this._exdate = [];
                        return _this
                    }
                    RRuleSet.prototype._iter = function(iterResult) {
                        return function(iterResult, _rrule, _exrule, _rdate, _exdate, tzid) {
                            var _exdateHash = {};
                            var _accept = iterResult.accept;

                            function evalExdate(after, before) {
                                _exrule.forEach((function(rrule) {
                                    rrule.between(after, before, true).forEach((function(date) {
                                        _exdateHash[Number(date)] = true
                                    }))
                                }))
                            }
                            _exdate.forEach((function(date) {
                                var zonedDate = new DateWithZone(date, tzid).rezonedDate();
                                _exdateHash[Number(zonedDate)] = true
                            }));
                            iterResult.accept = function(date) {
                                var dt = Number(date);
                                if (isNaN(dt)) {
                                    return _accept.call(this, date)
                                }
                                if (!_exdateHash[dt]) {
                                    evalExdate(new Date(dt - 1), new Date(dt + 1));
                                    if (!_exdateHash[dt]) {
                                        _exdateHash[dt] = true;
                                        return _accept.call(this, date)
                                    }
                                }
                                return true
                            };
                            if ("between" === iterResult.method) {
                                evalExdate(iterResult.args.after, iterResult.args.before);
                                iterResult.accept = function(date) {
                                    var dt = Number(date);
                                    if (!_exdateHash[dt]) {
                                        _exdateHash[dt] = true;
                                        return _accept.call(this, date)
                                    }
                                    return true
                                }
                            }
                            for (var i = 0; i < _rdate.length; i++) {
                                var zonedDate = new DateWithZone(_rdate[i], tzid).rezonedDate();
                                if (!iterResult.accept(new Date(zonedDate.getTime()))) {
                                    break
                                }
                            }
                            _rrule.forEach((function(rrule) {
                                iter(iterResult, rrule.options)
                            }));
                            var res = iterResult._result;
                            sort(res);
                            switch (iterResult.method) {
                                case "all":
                                case "between":
                                    return res;
                                case "before":
                                    return res.length && res[res.length - 1] || null;
                                default:
                                    return res.length && res[0] || null
                            }
                        }(iterResult, this._rrule, this._exrule, this._rdate, this._exdate, this.tzid())
                    };
                    RRuleSet.prototype.rrule = function(rrule) {
                        _addRule(rrule, this._rrule)
                    };
                    RRuleSet.prototype.exrule = function(rrule) {
                        _addRule(rrule, this._exrule)
                    };
                    RRuleSet.prototype.rdate = function(date) {
                        _addDate(date, this._rdate)
                    };
                    RRuleSet.prototype.exdate = function(date) {
                        _addDate(date, this._exdate)
                    };
                    RRuleSet.prototype.rrules = function() {
                        return this._rrule.map((function(e) {
                            return rrulestr(e.toString())
                        }))
                    };
                    RRuleSet.prototype.exrules = function() {
                        return this._exrule.map((function(e) {
                            return rrulestr(e.toString())
                        }))
                    };
                    RRuleSet.prototype.rdates = function() {
                        return this._rdate.map((function(e) {
                            return new Date(e.getTime())
                        }))
                    };
                    RRuleSet.prototype.exdates = function() {
                        return this._exdate.map((function(e) {
                            return new Date(e.getTime())
                        }))
                    };
                    RRuleSet.prototype.valueOf = function() {
                        var result = [];
                        if (!this._rrule.length && this._dtstart) {
                            result = result.concat(optionsToString({
                                dtstart: this._dtstart
                            }))
                        }
                        this._rrule.forEach((function(rrule) {
                            result = result.concat(rrule.toString().split("\n"))
                        }));
                        this._exrule.forEach((function(exrule) {
                            result = result.concat(exrule.toString().split("\n").map((function(line) {
                                return line.replace(/^RRULE:/, "EXRULE:")
                            })).filter((function(line) {
                                return !/^DTSTART/.test(line)
                            })))
                        }));
                        if (this._rdate.length) {
                            result.push(rdatesToString("RDATE", this._rdate, this.tzid()))
                        }
                        if (this._exdate.length) {
                            result.push(rdatesToString("EXDATE", this._exdate, this.tzid()))
                        }
                        return result
                    };
                    RRuleSet.prototype.toString = function() {
                        return this.valueOf().join("\n")
                    };
                    RRuleSet.prototype.clone = function() {
                        var rrs = new RRuleSet(!!this._cache);
                        this._rrule.forEach((function(rule) {
                            return rrs.rrule(rule.clone())
                        }));
                        this._exrule.forEach((function(rule) {
                            return rrs.exrule(rule.clone())
                        }));
                        this._rdate.forEach((function(date) {
                            return rrs.rdate(new Date(date.getTime()))
                        }));
                        this._exdate.forEach((function(date) {
                            return rrs.exdate(new Date(date.getTime()))
                        }));
                        return rrs
                    };
                    return RRuleSet
                }(RRule);

                function _addRule(rrule, collection) {
                    if (!(rrule instanceof RRule)) {
                        throw new TypeError(String(rrule) + " is not RRule instance")
                    }
                    if (!includes(collection.map(String), String(rrule))) {
                        collection.push(rrule)
                    }
                }

                function _addDate(date, collection) {
                    if (!(date instanceof Date)) {
                        throw new TypeError(String(date) + " is not Date instance")
                    }
                    if (!includes(collection.map(Number), Number(date))) {
                        collection.push(date);
                        sort(collection)
                    }
                }

                function rdatesToString(param, rdates, tzid) {
                    var isUTC = !tzid || "UTC" === tzid.toUpperCase();
                    var header = isUTC ? "".concat(param, ":") : "".concat(param, ";TZID=").concat(tzid, ":");
                    var dateString = rdates.map((function(rdate) {
                        return timeToUntilString(rdate.valueOf(), isUTC)
                    })).join(",");
                    return "".concat(header).concat(dateString)
                }
            },
        55351:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/common/m_charts.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.registerPattern = exports.registerGradient = exports.default = void 0;
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 28779);

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const graphicObjects = {};
                exports.registerPattern = options => {
                    const id = (0, _utils.getNextDefsSvgId)();
                    graphicObjects[id] = _extends({
                        type: "pattern"
                    }, options);
                    return id
                };
                exports.registerGradient = (type, options) => {
                    const id = (0, _utils.getNextDefsSvgId)();
                    graphicObjects[id] = _extends({
                        type: type
                    }, options);
                    return id
                };
                exports.default = {
                    getGraphicObjects: () => graphicObjects
                }
            },
        22692:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/license/byte_utils.js ***!
              \***********************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.base64ToBytes = function(base64) {
                    return new Uint8Array(atob(base64).split("").map((s => s.charCodeAt(0))))
                };
                exports.bytesToHex = function(bytes) {
                    return [...bytes].map((b => b.toString(16).padStart(2, "0"))).join("")
                };
                exports.bytesToWords = function(bytes) {
                    const words = new Uint32Array(1 + (bytes.length - 1 >> 2));
                    for (let k = 0; k < bytes.length; k += 1) {
                        words[k >> 2] |= bytes[k] << 8 * (3 - k % 4)
                    }
                    return words
                };
                exports.concatBytes = function(a, b) {
                    const result = new Uint8Array(a.length + b.length);
                    result.set(a, 0);
                    result.set(b, a.length);
                    return result
                };
                exports.hexToBytes = function(string) {
                    var _string$match;
                    return new Uint8Array((null === (_string$match = string.match(/.{1,2}/g)) || void 0 === _string$match ? void 0 : _string$match.map((byte => parseInt(byte, 16)))) ?? [])
                };
                exports.leftRotate = function(x, n) {
                    return (x << n | x >>> 32 - n) >>> 0
                };
                exports.stringToBytes = function(string) {
                    const bytes = new Uint8Array(string.length);
                    for (let k = 0; k < string.length; k += 1) {
                        bytes[k] = 255 & string.charCodeAt(k)
                    }
                    return bytes
                };
                exports.wordsToBytes = function(words) {
                    const bytes = new Uint8Array(4 * words.length);
                    for (let k = 0; k < bytes.length; k += 1) {
                        bytes[k] = words[k >> 2] >>> 8 * (3 - k % 4)
                    }
                    return bytes
                };
                exports.wordsToHex = function(words) {
                    return [...words].map((w => w.toString(16).padStart(8, "0"))).join("")
                }
            },
        78157:
            /*!****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/license/key.js ***!
              \****************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.PUBLIC_KEY = exports.INTERNAL_USAGE_ID = void 0;
                exports.PUBLIC_KEY = {
                    e: 65537,
                    n: new Uint8Array([200, 219, 153, 203, 140, 7, 228, 253, 193, 243, 62, 137, 139, 60, 68, 242, 48, 142, 113, 88, 185, 235, 253, 105, 80, 74, 32, 170, 96, 74, 111, 250, 7, 205, 154, 3, 146, 115, 153, 53, 45, 132, 123, 56, 61, 208, 184, 201, 63, 24, 109, 223, 0, 179, 169, 102, 139, 224, 73, 233, 45, 173, 138, 66, 98, 88, 69, 76, 177, 111, 113, 218, 192, 33, 101, 152, 25, 134, 34, 173, 32, 82, 230, 44, 247, 200, 253, 170, 192, 246, 30, 12, 96, 205, 100, 249, 181, 93, 0, 231])
                };
                exports.INTERNAL_USAGE_ID = "i9qS7usDB0eYJ_dN-hixdQ"
            },
        93391:
            /*!*******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/license/license_validation.js ***!
              \*******************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                exports.parseLicenseKey = parseLicenseKey;
                exports.peekValidationPerformed = function() {
                    return validationPerformed
                };
                exports.setLicenseCheckSkipCondition = function() {};
                exports.validateLicense = validateLicense;
                var _config = _interopRequireDefault(__webpack_require__( /*! ../../../core/config */ 66636));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../../../core/errors */ 87129));
                var _version = __webpack_require__( /*! ../../../core/version */ 1956);
                var _version2 = __webpack_require__( /*! ../../utils/version */ 20258);
                var _byte_utils = __webpack_require__( /*! ./byte_utils */ 22692);
                var _key = __webpack_require__( /*! ./key */ 78157);
                var _pkcs = __webpack_require__( /*! ./pkcs1 */ 1012);
                var _rsa_bigint = __webpack_require__( /*! ./rsa_bigint */ 42752);
                var _sha = __webpack_require__( /*! ./sha1 */ 94281);
                var _trial_panel = __webpack_require__( /*! ./trial_panel */ 99671);
                var _types = __webpack_require__( /*! ./types */ 13407);
                const _excluded = ["customerId", "maxVersionAllowed", "format", "internalUsageId"];

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const FORMAT = 1;
                const RTM_MIN_PATCH_VERSION = 3;
                const KEY_SPLITTER = ".";
                const BUY_NOW_LINK = "https://go.devexpress.com/Licensing_Installer_Watermark_DevExtremeJQuery.aspx";
                const GENERAL_ERROR = {
                    kind: _types.TokenKind.corrupted,
                    error: "general"
                };
                const VERIFICATION_ERROR = {
                    kind: _types.TokenKind.corrupted,
                    error: "verification"
                };
                const DECODING_ERROR = {
                    kind: _types.TokenKind.corrupted,
                    error: "decoding"
                };
                const DESERIALIZATION_ERROR = {
                    kind: _types.TokenKind.corrupted,
                    error: "deserialization"
                };
                const PAYLOAD_ERROR = {
                    kind: _types.TokenKind.corrupted,
                    error: "payload"
                };
                const VERSION_ERROR = {
                    kind: _types.TokenKind.corrupted,
                    error: "version"
                };
                let validationPerformed = false;

                function parseLicenseKey(encodedKey) {
                    if (void 0 === encodedKey) {
                        return GENERAL_ERROR
                    }
                    const parts = encodedKey.split(KEY_SPLITTER);
                    if (2 !== parts.length || 0 === parts[0].length || 0 === parts[1].length) {
                        return GENERAL_ERROR
                    }
                    if (! function(_ref) {
                            let {
                                text: text,
                                signature: encodedSignature
                            } = _ref;
                            return (0, _rsa_bigint.compareSignatures)({
                                key: _key.PUBLIC_KEY,
                                signature: (0, _byte_utils.base64ToBytes)(encodedSignature),
                                actual: (0, _pkcs.pad)((0, _sha.sha1)(text))
                            })
                        }({
                            text: parts[0],
                            signature: parts[1]
                        })) {
                        return VERIFICATION_ERROR
                    }
                    let decodedPayload = "";
                    try {
                        decodedPayload = atob(parts[0])
                    } catch {
                        return DECODING_ERROR
                    }
                    let payload = {};
                    try {
                        payload = JSON.parse(decodedPayload)
                    } catch {
                        return DESERIALIZATION_ERROR
                    }
                    const {
                        customerId: customerId,
                        maxVersionAllowed: maxVersionAllowed,
                        format: format,
                        internalUsageId: internalUsageId
                    } = payload, rest = function(source, excluded) {
                        if (null == source) {
                            return {}
                        }
                        var target = {};
                        for (var key in source) {
                            if (Object.prototype.hasOwnProperty.call(source, key)) {
                                if (excluded.indexOf(key) >= 0) {
                                    continue
                                }
                                target[key] = source[key]
                            }
                        }
                        return target
                    }(payload, _excluded);
                    if (void 0 !== internalUsageId) {
                        return {
                            kind: _types.TokenKind.internal,
                            internalUsageId: internalUsageId
                        }
                    }
                    if (void 0 === customerId || void 0 === maxVersionAllowed || void 0 === format) {
                        return PAYLOAD_ERROR
                    }
                    if (format !== FORMAT) {
                        return VERSION_ERROR
                    }
                    return {
                        kind: _types.TokenKind.verified,
                        payload: _extends({
                            customerId: customerId,
                            maxVersionAllowed: maxVersionAllowed
                        }, rest)
                    }
                }

                function isPreview(patch) {
                    return isNaN(patch) || patch < RTM_MIN_PATCH_VERSION
                }

                function validateLicense(licenseKey) {
                    let versionStr = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : _version.fullVersion;
                    if (validationPerformed) {
                        return
                    }
                    validationPerformed = true;
                    const version = (0, _version2.parseVersion)(versionStr);
                    const versionsCompatible = (0, _version2.assertedVersionsCompatible)(version);
                    const {
                        internal: internal,
                        error: error
                    } = function(_ref2) {
                        let {
                            licenseKey: licenseKey,
                            version: version
                        } = _ref2;
                        let preview = false;
                        try {
                            preview = isPreview(version.patch);
                            const {
                                major: major,
                                minor: minor
                            } = preview ? (0, _version2.getPreviousMajorVersion)(version) : version;
                            if (!licenseKey) {
                                return {
                                    preview: preview,
                                    error: "W0019"
                                }
                            }
                            const license = parseLicenseKey(licenseKey);
                            if (license.kind === _types.TokenKind.corrupted) {
                                return {
                                    preview: preview,
                                    error: "W0021"
                                }
                            }
                            if (license.kind === _types.TokenKind.internal) {
                                return {
                                    preview: preview,
                                    internal: true,
                                    error: license.internalUsageId === _key.INTERNAL_USAGE_ID ? void 0 : "W0020"
                                }
                            }
                            if (!(major && minor)) {
                                return {
                                    preview: preview,
                                    error: "W0021"
                                }
                            }
                            if (10 * major + minor > license.payload.maxVersionAllowed) {
                                return {
                                    preview: preview,
                                    error: "W0020"
                                }
                            }
                            return {
                                preview: preview,
                                error: void 0
                            }
                        } catch {
                            return {
                                preview: preview,
                                error: "W0021"
                            }
                        }
                    }({
                        licenseKey: licenseKey,
                        version: version
                    });
                    if (!versionsCompatible && internal) {
                        return
                    }
                    if (error && !internal) {
                        (0, _trial_panel.showTrialPanel)((0, _config.default)().buyNowLink ?? BUY_NOW_LINK, _version.fullVersion)
                    }
                    const preview = isPreview(version.patch);
                    if (error) {
                        _errors.default.log(preview ? "W0022" : error);
                        return
                    }
                    if (preview && !internal) {
                        _errors.default.log("W0022")
                    }
                }
                exports.default = {
                    validateLicense: validateLicense
                }
            },
        1012:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/license/pkcs1.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.pad = function(hash) {
                    const dataLength = (8 * _key.PUBLIC_KEY.n.length + 6) / 8;
                    const data = (0, _byte_utils.concatBytes)((0, _byte_utils.hexToBytes)(ASN1_SHA1), hash);
                    if (data.length + 10 > dataLength) {
                        throw Error("Key is too short for SHA1 signing algorithm")
                    }
                    const padding = new Uint8Array(dataLength - data.length);
                    padding.fill(255, 0, padding.length - 1);
                    padding[0] = 0;
                    padding[1] = 1;
                    padding[padding.length - 1] = 0;
                    return (0, _byte_utils.concatBytes)(padding, data)
                };
                var _byte_utils = __webpack_require__( /*! ./byte_utils */ 22692);
                var _key = __webpack_require__( /*! ./key */ 78157);
                const ASN1_SHA1 = "3021300906052b0e03021a05000414"
            },
        42752:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/license/rsa_bigint.js ***!
              \***********************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.compareSignatures = function(args) {
                    try {
                        const zero = BigInt(0);
                        const one = BigInt(1);
                        const eight = BigInt(8);
                        const modExp = (base, exponent, modulus) => {
                            let result = one;
                            let b = base;
                            let e = exponent;
                            while (e) {
                                if (e & one) {
                                    result = result * b % modulus
                                }
                                b = b * b % modulus;
                                e >>= one
                            }
                            return result
                        };
                        const bigIntFromBytes = bytes => bytes.reduce(((acc, cur) => (acc << eight) + BigInt(cur)), zero);
                        const actual = bigIntFromBytes(args.actual);
                        const signature = bigIntFromBytes(args.signature);
                        const exponent = BigInt(args.key.e);
                        const modulus = bigIntFromBytes(args.key.n);
                        const expected = modExp(signature, exponent, modulus);
                        return expected === actual
                    } catch {
                        return true
                    }
                }
            },
        94281:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/license/sha1.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.preprocess = preprocess;
                exports.sha1 = function(text) {
                    const message = preprocess(text);
                    const h = new Uint32Array([1732584193, 4023233417, 2562383102, 271733878, 3285377520]);
                    for (let i = 0; i < message.length; i += 16) {
                        const w = new Uint32Array(80);
                        for (let j = 0; j < 16; j += 1) {
                            w[j] = message[i + j]
                        }
                        for (let j = 16; j < 80; j += 1) {
                            const n = w[j - 3] ^ w[j - 8] ^ w[j - 14] ^ w[j - 16];
                            w[j] = n << 1 | n >>> 31
                        }
                        let a = h[0];
                        let b = h[1];
                        let c = h[2];
                        let d = h[3];
                        let e = h[4];
                        for (let j = 0; j < 80; j += 1) {
                            const [f, k] = j < 20 ? [b & c | ~b & d, 1518500249] : j < 40 ? [b ^ c ^ d, 1859775393] : j < 60 ? [b & c | b & d | c & d, 2400959708] : [b ^ c ^ d, 3395469782];
                            const temp = (0, _byte_utils.leftRotate)(a, 5) + f + e + k + w[j];
                            e = d;
                            d = c;
                            c = (0, _byte_utils.leftRotate)(b, 30);
                            b = a;
                            a = temp
                        }
                        h[0] += a;
                        h[1] += b;
                        h[2] += c;
                        h[3] += d;
                        h[4] += e
                    }
                    return (0, _byte_utils.wordsToBytes)(h)
                };
                var _byte_utils = __webpack_require__( /*! ./byte_utils */ 22692);

                function preprocess(text) {
                    const bytes = new Uint8Array(text.length + 1);
                    bytes.set((0, _byte_utils.stringToBytes)(text));
                    bytes[bytes.length - 1] = 128;
                    const words = (0, _byte_utils.bytesToWords)(new Uint8Array(bytes));
                    const result = new Uint32Array(16 * Math.ceil((words.length + 2) / 16));
                    result.set(words, 0);
                    result[result.length - 1] = 8 * (bytes.length - 1);
                    return result
                }
            },
        42570:
            /*!*******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/license/trial_panel.client.js ***!
              \*******************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.isClient = exports.BASE_Z_INDEX = void 0;
                exports.registerCustomComponents = registerCustomComponents;
                exports.renderTrialPanel = function(buyNowUrl, version, customStyles) {
                    registerCustomComponents(customStyles);
                    const trialPanelTrigger = document.createElement(componentNames.trigger);
                    trialPanelTrigger.setAttribute(attributeNames.buyNow, buyNowUrl);
                    trialPanelTrigger.setAttribute(attributeNames.version, version);
                    document.body.appendChild(trialPanelTrigger)
                };

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const BASE_Z_INDEX = exports.BASE_Z_INDEX = 1500;
                const isClient = () => "undefined" !== typeof HTMLElement && "undefined" !== typeof customElements;
                exports.isClient = isClient;
                const SafeHTMLElement = isClient() ? HTMLElement : class {};
                const componentNames = {
                    trigger: "dx-license-trigger",
                    panel: "dx-license"
                };
                const attributeNames = {
                    buyNow: "buy-now",
                    version: "version"
                };
                const commonStyles = {
                    opacity: "1",
                    visibility: "visible",
                    "clip-path": "none",
                    filter: "none"
                };
                const contentStyles = _extends({}, commonStyles, {
                    width: "100%",
                    height: "auto",
                    "line-height": "normal",
                    display: "block",
                    "z-index": `${BASE_Z_INDEX}`,
                    position: "static",
                    transform: "translate(0px, 0px)",
                    "background-color": "#FF7200",
                    border: "none",
                    margin: "auto",
                    "box-sizing": "border-box",
                    "text-align": "center"
                });
                const containerStyles = _extends({}, contentStyles, {
                    display: "flex",
                    "align-items": "center",
                    "flex-direction": "row",
                    position: "relative",
                    top: "0px",
                    left: "0px",
                    padding: "0.5rem"
                });
                const buttonStyles = {
                    width: "1rem",
                    cursor: "pointer",
                    height: "1rem"
                };
                const textStyles = _extends({}, commonStyles, {
                    display: "inline",
                    position: "static",
                    padding: "0px",
                    margin: "0px",
                    color: "white",
                    "font-family": "'Segoe UI','Open Sans Condensed',-apple-system,BlinkMacSystemFont,avenir next,avenir,helvetica neue,helvetica,Cantarell,Ubuntu,roboto,noto,arial,sans-serif",
                    "font-size": "0.875rem",
                    "font-wight": "600"
                });

                function createImportantStyles(defaultStyles, customStyles) {
                    const styles = customStyles ? _extends({}, defaultStyles, customStyles) : defaultStyles;
                    return Object.keys(styles).reduce(((cssString, currentKey) => `${cssString}${[currentKey,`${styles[currentKey]} !important;`].join(": ")}`), "")
                }
                class DxLicense extends SafeHTMLElement {
                    constructor() {
                        var _DxLicense$customStyl, _DxLicense$customStyl2, _DxLicense$customStyl3, _DxLicense$customStyl4, _DxLicense$customStyl5;
                        super();
                        this._observer = null;
                        this._inReassign = false;
                        this._hidden = false;
                        this._spanStyles = createImportantStyles(textStyles, null === (_DxLicense$customStyl = DxLicense.customStyles) || void 0 === _DxLicense$customStyl ? void 0 : _DxLicense$customStyl.textStyles);
                        this._linkStyles = createImportantStyles(textStyles, null === (_DxLicense$customStyl2 = DxLicense.customStyles) || void 0 === _DxLicense$customStyl2 ? void 0 : _DxLicense$customStyl2.linkStyles);
                        this._containerStyles = createImportantStyles(containerStyles, null === (_DxLicense$customStyl3 = DxLicense.customStyles) || void 0 === _DxLicense$customStyl3 ? void 0 : _DxLicense$customStyl3.containerStyles);
                        this._contentStyles = createImportantStyles(contentStyles, null === (_DxLicense$customStyl4 = DxLicense.customStyles) || void 0 === _DxLicense$customStyl4 ? void 0 : _DxLicense$customStyl4.contentStyles);
                        this._buttonStyles = createImportantStyles(buttonStyles, null === (_DxLicense$customStyl5 = DxLicense.customStyles) || void 0 === _DxLicense$customStyl5 ? void 0 : _DxLicense$customStyl5.contentStyles)
                    }
                    _createSpan(text) {
                        const span = document.createElement("span");
                        span.innerText = text;
                        span.style.cssText = this._spanStyles;
                        return span
                    }
                    _createLink(text, href) {
                        const link = document.createElement("a");
                        link.innerText = text;
                        link.style.cssText = this._linkStyles;
                        link.href = href;
                        link.target = "_blank";
                        return link
                    }
                    _createButton() {
                        const button = document.createElement("div");
                        button.style.cssText = this._buttonStyles;
                        const polygon = document.createElementNS("http://www.w3.org/2000/svg", "polygon");
                        const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
                        polygon.setAttribute("points", "13.4 12.7 8.7 8 13.4 3.4 12.6 2.6 8 7.3 3.4 2.6 2.6 3.4 7.3 8 2.6 12.6 3.4 13.4 8 8.7 12.7 13.4 13.4 12.7");
                        polygon.style.cssText = createImportantStyles({
                            fill: "#fff",
                            opacity: ".5",
                            "stroke-width": "0px"
                        });
                        svg.setAttribute("id", "Layer_1");
                        svg.setAttribute("data-name", "Layer 1");
                        svg.setAttribute("version", "1.1");
                        svg.setAttribute("viewBox", "0 0 16 16");
                        svg.style.cssText = createImportantStyles({
                            "vertical-align": "baseline"
                        });
                        svg.appendChild(polygon);
                        button.appendChild(svg);
                        button.onclick = () => {
                            this._hidden = true;
                            this.style.cssText = createImportantStyles({
                                display: "none"
                            })
                        };
                        return button
                    }
                    _createContentContainer() {
                        const contentContainer = document.createElement("div");
                        contentContainer.style.cssText = this._contentStyles;
                        contentContainer.append(this._createSpan("For evaluation purposes only. Redistribution prohibited. Please "), this._createLink("purchase a license", this.getAttribute(attributeNames.buyNow)), this._createSpan(` to continue use of DevExpress product libraries (v${this.getAttribute(attributeNames.version)}).`));
                        return contentContainer
                    }
                    _reassignComponent() {
                        this.innerHTML = "";
                        this.style.cssText = this._containerStyles;
                        this.append(this._createContentContainer(), this._createButton())
                    }
                    connectedCallback() {
                        this._reassignComponent();
                        if (!this._observer) {
                            this._observer = new MutationObserver((() => {
                                if (this._hidden) {
                                    var _this$_observer;
                                    null === (_this$_observer = this._observer) || void 0 === _this$_observer || _this$_observer.disconnect();
                                    return
                                }
                                if (this._inReassign) {
                                    this._inReassign = false
                                } else {
                                    this._inReassign = true;
                                    this._reassignComponent()
                                }
                            }));
                            this._observer.observe(this, {
                                childList: true,
                                attributes: true,
                                subtree: true
                            })
                        }
                    }
                    disconnectedCallback() {
                        setTimeout((() => {
                            const licensePanel = document.getElementsByTagName(componentNames.panel);
                            if (!licensePanel.length) {
                                document.body.prepend(this)
                            }
                        }), 100)
                    }
                }
                DxLicense.customStyles = void 0;
                class DxLicenseTrigger extends SafeHTMLElement {
                    connectedCallback() {
                        this.style.cssText = createImportantStyles({
                            display: "none"
                        });
                        const licensePanel = document.getElementsByTagName(componentNames.panel);
                        if (!licensePanel.length) {
                            const license = document.createElement(componentNames.panel);
                            license.setAttribute(attributeNames.version, this.getAttribute(attributeNames.version));
                            license.setAttribute(attributeNames.buyNow, this.getAttribute(attributeNames.buyNow));
                            license.setAttribute("data-permanent", "true");
                            document.body.prepend(license)
                        }
                    }
                }

                function registerCustomComponents(customStyles) {
                    if (!customElements.get(componentNames.trigger)) {
                        DxLicense.customStyles = customStyles;
                        customElements.define(componentNames.trigger, DxLicenseTrigger);
                        customElements.define(componentNames.panel, DxLicense)
                    }
                }
            },
        99671:
            /*!************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/license/trial_panel.js ***!
              \************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.registerTrialPanelComponents = function(customStyles) {
                    if ((0, _trial_panel.isClient)()) {
                        (0, _trial_panel.registerCustomComponents)(customStyles)
                    }
                };
                exports.showTrialPanel = function(buyNowUrl, version, customStyles) {
                    if ((0, _trial_panel.isClient)()) {
                        (0, _trial_panel.renderTrialPanel)(buyNowUrl, version, customStyles)
                    }
                };
                var _trial_panel = __webpack_require__( /*! ./trial_panel.client */ 42570)
            },
        13407:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/license/types.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.TokenKind = void 0;
                var TokenKind;
                ! function(TokenKind) {
                    TokenKind.corrupted = "corrupted";
                    TokenKind.verified = "verified";
                    TokenKind.internal = "internal"
                }(TokenKind || (exports.TokenKind = TokenKind = {}))
            },
        3226:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_action.js ***!
              \*************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = exports.Action = void 0;
                var _renderer = (obj = __webpack_require__( /*! ../../core/renderer */ 64553), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                var _window = __webpack_require__( /*! ../../core/utils/window */ 3104);
                class Action {
                    constructor(action, config) {
                        config = config || {};
                        this._action = action;
                        this._context = config.context || (0, _window.getWindow)();
                        this._beforeExecute = config.beforeExecute;
                        this._afterExecute = config.afterExecute;
                        this._component = config.component;
                        this._validatingTargetName = config.validatingTargetName;
                        const excludeValidators = this._excludeValidators = {};
                        if (config.excludeValidators) {
                            for (let i = 0; i < config.excludeValidators.length; i++) {
                                excludeValidators[config.excludeValidators[i]] = true
                            }
                        }
                    }
                    execute() {
                        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                            args[_key] = arguments[_key]
                        }
                        const e = {
                            action: this._action,
                            args: Array.prototype.slice.call(args),
                            context: this._context,
                            component: this._component,
                            validatingTargetName: this._validatingTargetName,
                            cancel: false,
                            handled: false
                        };
                        const beforeExecute = this._beforeExecute;
                        const afterExecute = this._afterExecute;
                        const argsBag = e.args[0] || {};
                        if (!this._validateAction(e)) {
                            return
                        }
                        null === beforeExecute || void 0 === beforeExecute || beforeExecute.call(this._context, e);
                        if (e.cancel) {
                            return
                        }
                        const result = this._executeAction(e);
                        if (argsBag.cancel) {
                            return
                        }
                        null === afterExecute || void 0 === afterExecute || afterExecute.call(this._context, e);
                        return result
                    }
                    _validateAction(e) {
                        const excludeValidators = this._excludeValidators;
                        const {
                            executors: executors
                        } = Action;
                        for (const name in executors) {
                            if (!excludeValidators[name]) {
                                var _executor$validate;
                                const executor = executors[name];
                                null === (_executor$validate = executor.validate) || void 0 === _executor$validate || _executor$validate.call(executor, e);
                                if (e.cancel) {
                                    return false
                                }
                            }
                        }
                        return true
                    }
                    _executeAction(e) {
                        let result;
                        const {
                            executors: executors
                        } = Action;
                        for (const name in executors) {
                            var _executor$execute;
                            const executor = executors[name];
                            null === (_executor$execute = executor.execute) || void 0 === _executor$execute || _executor$execute.call(executor, e);
                            if (e.handled) {
                                result = e.result;
                                break
                            }
                        }
                        return result
                    }
                    static registerExecutor(name, executor) {
                        if ((0, _type.isPlainObject)(name)) {
                            (0, _iterator.each)(name, Action.registerExecutor);
                            return
                        }
                        Action.executors[name] = executor
                    }
                    static unregisterExecutor() {
                        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                            args[_key2] = arguments[_key2]
                        }(0, _iterator.each)(args, (function() {
                            delete Action.executors[this]
                        }))
                    }
                }
                exports.Action = Action;
                Action.executors = {};
                const createValidatorByTargetElement = condition => e => {
                    if (!e.args.length) {
                        return
                    }
                    const args = e.args[0];
                    const element = args[e.validatingTargetName] || args.element;
                    if (element && condition((0, _renderer.default)(element))) {
                        e.cancel = true
                    }
                };
                Action.registerExecutor({
                    disabled: {
                        validate: createValidatorByTargetElement(($target => $target.is(".dx-state-disabled, .dx-state-disabled *")))
                    },
                    readOnly: {
                        validate: createValidatorByTargetElement(($target => $target.is(".dx-state-readonly, .dx-state-readonly *:not(.dx-state-independent)")))
                    },
                    undefined: {
                        execute: e => {
                            if (!e.action) {
                                e.result = void 0;
                                e.handled = true
                            }
                        }
                    },
                    func: {
                        execute: e => {
                            if ((0, _type.isFunction)(e.action)) {
                                e.result = e.action.call(e.context, e.args[0]);
                                e.handled = true
                            }
                        }
                    }
                });
                exports.default = Action
            },
        40958:
            /*!************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_class.js ***!
              \************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _errors = (obj = __webpack_require__( /*! ../../core/errors */ 87129), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                const wrapOverridden = function(baseProto, methodName, method) {
                    return function() {
                        const prevCallBase = this.callBase;
                        this.callBase = baseProto[methodName];
                        try {
                            return method.apply(this, arguments)
                        } finally {
                            this.callBase = prevCallBase
                        }
                    }
                };
                const redefine = function(members) {
                    const that = this;
                    let overridden;
                    let memberName;
                    let member;
                    if (!members) {
                        return that
                    }
                    for (memberName in members) {
                        member = members[memberName];
                        overridden = "function" === typeof that.prototype[memberName] && "function" === typeof member;
                        that.prototype[memberName] = overridden ? wrapOverridden(that.parent.prototype, memberName, member) : member
                    }
                    return that
                };
                const include = function() {
                    const classObj = this;
                    let argument;
                    let name;
                    let i;
                    const hasClassObjOwnProperty = Object.prototype.hasOwnProperty.bind(classObj);
                    const isES6Class = !hasClassObjOwnProperty("_includedCtors") && !hasClassObjOwnProperty("_includedPostCtors");
                    if (isES6Class) {
                        classObj._includedCtors = classObj._includedCtors.slice(0);
                        classObj._includedPostCtors = classObj._includedPostCtors.slice(0)
                    }
                    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                        args[_key] = arguments[_key]
                    }
                    for (i = 0; i < args.length; i++) {
                        argument = args[i];
                        if (argument.ctor) {
                            classObj._includedCtors.push(argument.ctor)
                        }
                        if (argument.postCtor) {
                            classObj._includedPostCtors.push(argument.postCtor)
                        }
                        for (name in argument) {
                            if ("ctor" === name || "postCtor" === name || "default" === name) {
                                continue
                            }
                            classObj.prototype[name] = argument[name]
                        }
                    }
                    return classObj
                };
                const subclassOf = function(parentClass) {
                    const hasParentProperty = Object.prototype.hasOwnProperty.bind(this)("parent");
                    const isES6Class = !hasParentProperty && this.parent;
                    if (isES6Class) {
                        const baseClass = Object.getPrototypeOf(this);
                        return baseClass === parentClass || baseClass.subclassOf(parentClass)
                    }
                    if (this.parent === parentClass) {
                        return true
                    }
                    if (!this.parent || !this.parent.subclassOf) {
                        return false
                    }
                    return this.parent.subclassOf(parentClass)
                };
                const abstract = function() {
                    throw _errors.default.Error("E0001")
                };
                const classImpl = function() {};
                classImpl.inherit = function(members) {
                    const inheritor = function() {
                        if (!this || (0, _type.isWindow)(this) || "function" !== typeof this.constructor) {
                            throw _errors.default.Error("E0003")
                        }
                        const instance = this;
                        const {
                            ctor: ctor
                        } = instance;
                        const includedCtors = instance.constructor._includedCtors;
                        const includedPostCtors = instance.constructor._includedPostCtors;
                        let i;
                        for (i = 0; i < includedCtors.length; i++) {
                            includedCtors[i].call(instance)
                        }
                        if (ctor) {
                            for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                                args[_key2] = arguments[_key2]
                            }
                            ctor.apply(instance, args)
                        }
                        for (i = 0; i < includedPostCtors.length; i++) {
                            includedPostCtors[i].call(instance)
                        }
                    };
                    inheritor.prototype = function(obj) {
                        const func = function() {};
                        func.prototype = obj.prototype;
                        return new func
                    }(this);
                    Object.setPrototypeOf(inheritor, this);
                    inheritor.inherit = this.inherit;
                    inheritor.abstract = abstract;
                    inheritor.redefine = redefine;
                    inheritor.include = include;
                    inheritor.subclassOf = subclassOf;
                    inheritor.parent = this;
                    inheritor._includedCtors = this._includedCtors ? this._includedCtors.slice(0) : [];
                    inheritor._includedPostCtors = this._includedPostCtors ? this._includedPostCtors.slice(0) : [];
                    inheritor.prototype.constructor = inheritor;
                    inheritor.redefine(members);
                    return inheritor
                };
                classImpl.abstract = abstract;
                exports.default = classImpl
            },
        10718:
            /*!****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_component_registrator.js ***!
              \****************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.registerComponent = void 0;
                var _component_registrator_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/component_registrator_callbacks */ 55771));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../../core/errors */ 87129));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 64553));
                var _public_component = __webpack_require__( /*! ../../core/utils/public_component */ 85521);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                exports.registerComponent = function(name, namespace, componentClass) {
                    if (!componentClass) {
                        componentClass = namespace
                    } else {
                        namespace[name] = componentClass
                    }(0, _public_component.name)(componentClass, name);
                    _component_registrator_callbacks.default.fire(name, componentClass)
                };
                _component_registrator_callbacks.default.add((function(name, componentClass) {
                    _renderer.default.fn[name] = function(options) {
                        const isMemberInvoke = "string" === typeof options;
                        let result;
                        if (isMemberInvoke) {
                            const memberName = options;
                            const memberArgs = [].slice.call(arguments).slice(1);
                            this.each((function() {
                                const instance = componentClass.getInstance(this);
                                if (!instance) {
                                    throw _errors.default.Error("E0009", name)
                                }
                                const member = instance[memberName];
                                const memberValue = member.apply(instance, memberArgs);
                                if (void 0 === result) {
                                    result = memberValue
                                }
                            }))
                        } else {
                            this.each((function() {
                                const instance = componentClass.getInstance(this);
                                if (instance) {
                                    instance.option(options)
                                } else {
                                    new componentClass(this, options)
                                }
                            }));
                            result = this
                        }
                        return result
                    }
                }))
            },
        21233:
            /*!**************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_component_registrator_callbacks.js ***!
              \**************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.componentRegistratorCallbacks = void 0;
                var _memorized_callbacks = (obj = __webpack_require__( /*! ../../core/memorized_callbacks */ 35329), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                exports.componentRegistratorCallbacks = new _memorized_callbacks.default
            },
        34338:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_config.js ***!
              \*************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _errors = (obj = __webpack_require__( /*! ../../core/errors */ 87129), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 52576);
                const config = {
                    rtlEnabled: false,
                    defaultCurrency: "USD",
                    defaultUseCurrencyAccountingStyle: true,
                    oDataFilterToLower: true,
                    serverDecimalSeparator: ".",
                    decimalSeparator: ".",
                    thousandsSeparator: ",",
                    forceIsoDateParsing: true,
                    wrapActionsBeforeExecute: true,
                    useLegacyStoreResult: false,
                    useJQuery: void 0,
                    editorStylingMode: void 0,
                    useLegacyVisibleIndex: false,
                    floatingActionButtonConfig: {
                        icon: "add",
                        closeIcon: "close",
                        label: "",
                        position: {
                            at: "right bottom",
                            my: "right bottom",
                            offset: {
                                x: -16,
                                y: -16
                            }
                        },
                        maxSpeedDialActionCount: 5,
                        shading: false,
                        direction: "auto"
                    },
                    optionsParser: optionsString => {
                        if ("{" !== optionsString.trim().charAt(0)) {
                            optionsString = `{${optionsString}}`
                        }
                        try {
                            return JSON.parse(optionsString)
                        } catch (ex) {
                            try {
                                return JSON.parse(normalizeToJSONString(optionsString))
                            } catch (exNormalize) {
                                throw _errors.default.Error("E3018", ex, optionsString)
                            }
                        }
                    }
                };
                const normalizeToJSONString = optionsString => optionsString.replace(/'/g, '"').replace(/,\s*([\]}])/g, "$1").replace(/([{,])\s*([^":\s]+)\s*:/g, '$1"$2":');
                const deprecatedFields = ["decimalSeparator", "thousandsSeparator"];
                const configMethod = function() {
                    if (!arguments.length) {
                        return config
                    }
                    const newConfig = arguments.length <= 0 ? void 0 : arguments[0];
                    deprecatedFields.forEach((deprecatedField => {
                        if (newConfig[deprecatedField]) {
                            const message = `Now, the ${deprecatedField} is selected based on the specified locale.`;
                            _errors.default.log("W0003", "config", deprecatedField, "19.2", message)
                        }
                    }));
                    (0, _extend.extend)(config, newConfig)
                };
                if ("undefined" !== typeof DevExpress && DevExpress.config) {
                    configMethod(DevExpress.config)
                }
                exports.default = configMethod
            },
        98905:
            /*!**************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_devices.js ***!
              \**************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _config = _interopRequireDefault(__webpack_require__( /*! ../../core/config */ 66636));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../../core/errors */ 87129));
                var _events_strategy = __webpack_require__( /*! ../../core/events_strategy */ 2607);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 64553));
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/callbacks */ 84718));
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 52576);
                var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/ready_callbacks */ 3122));
                var _resize_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/resize_callbacks */ 63283));
                var _size = __webpack_require__( /*! ../../core/utils/size */ 57653);
                var _storage = __webpack_require__( /*! ../../core/utils/storage */ 98479);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                var _view_port = __webpack_require__( /*! ../../core/utils/view_port */ 55355);
                var _window = __webpack_require__( /*! ../../core/utils/window */ 3104);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const window = (0, _window.getWindow)();
                const KNOWN_UA_TABLE = {
                    iPhone: "iPhone",
                    iPhone5: "iPhone",
                    iPhone6: "iPhone",
                    iPhone6plus: "iPhone",
                    iPad: "iPad",
                    iPadMini: "iPad Mini",
                    androidPhone: "Android Mobile",
                    androidTablet: "Android",
                    msSurface: "Windows ARM Tablet PC",
                    desktop: "desktop"
                };
                const DEFAULT_DEVICE = {
                    deviceType: "desktop",
                    platform: "generic",
                    version: [],
                    phone: false,
                    tablet: false,
                    android: false,
                    ios: false,
                    generic: true,
                    grade: "A",
                    mac: false
                };
                const UA_PARSERS = {
                    generic(userAgent) {
                        const isPhone = /windows phone/i.test(userAgent) || userAgent.match(/WPDesktop/);
                        const isTablet = !isPhone && /Windows(.*)arm(.*)Tablet PC/i.test(userAgent);
                        const isDesktop = !isPhone && !isTablet && /msapphost/i.test(userAgent);
                        const isMac = /((intel|ppc) mac os x)/.test(userAgent.toLowerCase());
                        if (!(isPhone || isTablet || isDesktop || isMac)) {
                            return null
                        }
                        return {
                            deviceType: isPhone ? "phone" : isTablet ? "tablet" : "desktop",
                            platform: "generic",
                            version: [],
                            grade: "A",
                            mac: isMac
                        }
                    },
                    appleTouchDevice(userAgent) {
                        const navigator = (0, _window.getNavigator)();
                        const isIpadOs = /Macintosh/i.test(userAgent) && (null === navigator || void 0 === navigator ? void 0 : navigator.maxTouchPoints) > 2;
                        const isAppleDevice = /ip(hone|od|ad)/i.test(userAgent);
                        if (!isAppleDevice && !isIpadOs) {
                            return null
                        }
                        const isPhone = /ip(hone|od)/i.test(userAgent);
                        const matches = userAgent.match(/os\s{0,}X? (\d+)_(\d+)_?(\d+)?/i);
                        const version = matches ? [parseInt(matches[1], 10), parseInt(matches[2], 10), parseInt(matches[3] || 0, 10)] : [];
                        const isIPhone4 = 480 === window.screen.height;
                        const grade = isIPhone4 ? "B" : "A";
                        return {
                            deviceType: isPhone ? "phone" : "tablet",
                            platform: "ios",
                            version: version,
                            grade: grade
                        }
                    },
                    android(userAgent) {
                        const isAndroid = /android|htc_|silk/i.test(userAgent);
                        const isWinPhone = /windows phone/i.test(userAgent);
                        if (!isAndroid || isWinPhone) {
                            return null
                        }
                        const isPhone = /mobile/i.test(userAgent);
                        const matches = userAgent.match(/android (\d+)\.?(\d+)?\.?(\d+)?/i);
                        const version = matches ? [parseInt(matches[1], 10), parseInt(matches[2] || 0, 10), parseInt(matches[3] || 0, 10)] : [];
                        const worseThan4_4 = version.length > 1 && (version[0] < 4 || 4 === version[0] && version[1] < 4);
                        const grade = worseThan4_4 ? "B" : "A";
                        return {
                            deviceType: isPhone ? "phone" : "tablet",
                            platform: "android",
                            version: version,
                            grade: grade
                        }
                    }
                };
                const UA_PARSERS_ARRAY = [UA_PARSERS.appleTouchDevice, UA_PARSERS.android, UA_PARSERS.generic];
                const devices = new class {
                    constructor(options) {
                        this._window = (null === options || void 0 === options ? void 0 : options.window) ?? window;
                        this._realDevice = this._getDevice();
                        this._currentDevice = void 0;
                        this._currentOrientation = void 0;
                        this._eventsStrategy = new _events_strategy.EventsStrategy(this);
                        this.changed = (0, _callbacks.default)();
                        if ((0, _window.hasWindow)()) {
                            _ready_callbacks.default.add(this._recalculateOrientation.bind(this));
                            _resize_callbacks.default.add(this._recalculateOrientation.bind(this))
                        }
                    }
                    current(deviceOrName) {
                        if (deviceOrName) {
                            this._currentDevice = this._getDevice(deviceOrName);
                            this._forced = true;
                            this.changed.fire();
                            return
                        }
                        if (!this._currentDevice) {
                            deviceOrName = void 0;
                            try {
                                deviceOrName = this._getDeviceOrNameFromWindowScope()
                            } catch (e) {
                                deviceOrName = this._getDeviceNameFromSessionStorage()
                            } finally {
                                if (!deviceOrName) {
                                    deviceOrName = this._getDeviceNameFromSessionStorage()
                                }
                                if (deviceOrName) {
                                    this._forced = true
                                }
                            }
                            this._currentDevice = this._getDevice(deviceOrName)
                        }
                        return this._currentDevice
                    }
                    real(forceDevice) {
                        return (0, _extend.extend)({}, this._realDevice)
                    }
                    orientation() {
                        return this._currentOrientation
                    }
                    isForced() {
                        return this._forced
                    }
                    isRippleEmulator() {
                        return !!this._window.tinyHippos
                    }
                    _getCssClasses(device) {
                        const result = [];
                        const realDevice = this._realDevice;
                        device = device || this.current();
                        if (device.deviceType) {
                            result.push(`dx-device-${device.deviceType}`);
                            if ("desktop" !== device.deviceType) {
                                result.push("dx-device-mobile")
                            }
                        }
                        result.push(`dx-device-${realDevice.platform}`);
                        if (realDevice.version && realDevice.version.length) {
                            result.push(`dx-device-${realDevice.platform}-${realDevice.version[0]}`)
                        }
                        if (this.isSimulator()) {
                            result.push("dx-simulator")
                        }
                        if ((0, _config.default)().rtlEnabled) {
                            result.push("dx-rtl")
                        }
                        return result
                    }
                    attachCssClasses(element, device) {
                        this._deviceClasses = this._getCssClasses(device).join(" ");
                        (0, _renderer.default)(element).addClass(this._deviceClasses)
                    }
                    detachCssClasses(element) {
                        (0, _renderer.default)(element).removeClass(this._deviceClasses)
                    }
                    isSimulator() {
                        try {
                            var _this$_window$top;
                            return this._isSimulator || (0, _window.hasWindow)() && this._window.top !== this._window.self && (null === (_this$_window$top = this._window.top) || void 0 === _this$_window$top ? void 0 : _this$_window$top["dx-force-device"]) || this.isRippleEmulator()
                        } catch (e) {
                            return false
                        }
                    }
                    forceSimulator() {
                        this._isSimulator = true
                    }
                    _getDevice(deviceName) {
                        if ("genericPhone" === deviceName) {
                            deviceName = {
                                deviceType: "phone",
                                platform: "generic",
                                generic: true
                            }
                        }
                        if ((0, _type.isPlainObject)(deviceName)) {
                            return this._fromConfig(deviceName)
                        }
                        let ua;
                        if (deviceName) {
                            ua = KNOWN_UA_TABLE[deviceName];
                            if (!ua) {
                                throw _errors.default.Error("E0005")
                            }
                        } else {
                            const navigator = (0, _window.getNavigator)();
                            ua = navigator.userAgent
                        }
                        return this._fromUA(ua)
                    }
                    _getDeviceOrNameFromWindowScope() {
                        var _this$_window$top2, _this$_window$top3;
                        let result;
                        if ((0, _window.hasWindow)() && (null !== (_this$_window$top2 = this._window.top) && void 0 !== _this$_window$top2 && _this$_window$top2["dx-force-device-object"] || null !== (_this$_window$top3 = this._window.top) && void 0 !== _this$_window$top3 && _this$_window$top3["dx-force-device"])) {
                            var _this$_window$top4, _this$_window$top5;
                            result = (null === (_this$_window$top4 = this._window.top) || void 0 === _this$_window$top4 ? void 0 : _this$_window$top4["dx-force-device-object"]) || (null === (_this$_window$top5 = this._window.top) || void 0 === _this$_window$top5 ? void 0 : _this$_window$top5["dx-force-device"])
                        }
                        return result
                    }
                    _getDeviceNameFromSessionStorage() {
                        const sessionStorage = (0, _storage.sessionStorage)();
                        if (!sessionStorage) {
                            return
                        }
                        const deviceOrName = sessionStorage.getItem("dx-force-device");
                        try {
                            return JSON.parse(deviceOrName)
                        } catch (ex) {
                            return deviceOrName
                        }
                    }
                    _fromConfig(config) {
                        const result = (0, _extend.extend)({}, DEFAULT_DEVICE, this._currentDevice, config);
                        const shortcuts = {
                            phone: "phone" === result.deviceType,
                            tablet: "tablet" === result.deviceType,
                            android: "android" === result.platform,
                            ios: "ios" === result.platform,
                            generic: "generic" === result.platform
                        };
                        return (0, _extend.extend)(result, shortcuts)
                    }
                    _fromUA(ua) {
                        for (let idx = 0; idx < UA_PARSERS_ARRAY.length; idx += 1) {
                            const parser = UA_PARSERS_ARRAY[idx];
                            const config = parser(ua);
                            if (config) {
                                return this._fromConfig(config)
                            }
                        }
                        return DEFAULT_DEVICE
                    }
                    _changeOrientation() {
                        const $window = (0, _renderer.default)(this._window);
                        const orientation = (0, _size.getHeight)($window) > (0, _size.getWidth)($window) ? "portrait" : "landscape";
                        if (this._currentOrientation === orientation) {
                            return
                        }
                        this._currentOrientation = orientation;
                        this._eventsStrategy.fireEvent("orientationChanged", [{
                            orientation: orientation
                        }])
                    }
                    _recalculateOrientation() {
                        const windowWidth = (0, _size.getWidth)(this._window);
                        if (this._currentWidth === windowWidth) {
                            return
                        }
                        this._currentWidth = windowWidth;
                        this._changeOrientation()
                    }
                    on(eventName, eventHandler) {
                        this._eventsStrategy.on(eventName, eventHandler);
                        return this
                    }
                    off(eventName, eventHandler) {
                        this._eventsStrategy.off(eventName, eventHandler);
                        return this
                    }
                };
                const viewPortElement = (0, _view_port.value)();
                if (viewPortElement) {
                    devices.attachCssClasses(viewPortElement)
                }
                _view_port.changeCallback.add(((viewPort, prevViewport) => {
                    devices.detachCssClasses(prevViewport);
                    devices.attachCssClasses(viewPort)
                }));
                exports.default = devices
            },
        62018:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_dom_adapter.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.domAdapter = exports.default = void 0;
                var _common = __webpack_require__( /*! ../../core/utils/common */ 17781);
                var _dependency_injector = (obj = __webpack_require__( /*! ../../core/utils/dependency_injector */ 89656), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _shadow_dom = __webpack_require__( /*! ../../core/utils/shadow_dom */ 93631);
                const nativeDOMAdapterStrategy = {
                    querySelectorAll: (element, selector) => element.querySelectorAll(selector),
                    elementMatches(element, selector) {
                        const matches = element.matches || element.matchesSelector || element.mozMatchesSelector || element.msMatchesSelector || element.oMatchesSelector || element.webkitMatchesSelector || (selector => {
                            const doc = element.document || element.ownerDocument;
                            if (!doc) {
                                return false
                            }
                            const items = this.querySelectorAll(doc, selector);
                            for (let i = 0; i < items.length; i++) {
                                if (items[i] === element) {
                                    return true
                                }
                            }
                        });
                        return matches.call(element, selector)
                    },
                    createElement(tagName, context) {
                        context = context ?? this._document;
                        return context.createElement(tagName)
                    },
                    createElementNS(ns, tagName, context) {
                        context = context || this._document;
                        return context.createElementNS(ns, tagName)
                    },
                    createTextNode(text, context) {
                        context = context || this._document;
                        return context.createTextNode(text)
                    },
                    createAttribute(text, context) {
                        context = context || this._document;
                        return context.createAttribute(text)
                    },
                    isNode: element => !!element && "object" === typeof element && "nodeType" in element && "nodeName" in element,
                    isElementNode: element => !!element && 1 === element.nodeType,
                    isTextNode: element => element && 3 === element.nodeType,
                    isDocument: element => element && 9 === element.nodeType,
                    isDocumentFragment: element => element && 11 === element.nodeType,
                    removeElement(element) {
                        const parentNode = element && element.parentNode;
                        if (parentNode) {
                            parentNode.removeChild(element)
                        }
                    },
                    insertElement(parentElement, newElement, nextSiblingElement) {
                        if (parentElement && newElement && parentElement !== newElement) {
                            if (nextSiblingElement) {
                                parentElement.insertBefore(newElement, nextSiblingElement)
                            } else {
                                parentElement.appendChild(newElement)
                            }
                        }
                    },
                    getAttribute: (element, name) => element.getAttribute(name),
                    setAttribute(element, name, value) {
                        if ("style" === name) {
                            element.style.cssText = value
                        } else {
                            element.setAttribute(name, value)
                        }
                    },
                    removeAttribute(element, name) {
                        element.removeAttribute(name)
                    },
                    setProperty(element, name, value) {
                        element[name] = value
                    },
                    setText(element, text) {
                        if (element) {
                            element.textContent = text
                        }
                    },
                    setClass(element, className, isAdd) {
                        if (1 === element.nodeType && className) {
                            isAdd ? element.classList.add(className) : element.classList.remove(className)
                        }
                    },
                    setStyle(element, name, value) {
                        element.style[name] = value || ""
                    },
                    _document: "undefined" === typeof document ? void 0 : document,
                    getDocument() {
                        return this._document
                    },
                    getActiveElement(element) {
                        const activeElementHolder = this.getRootNode(element);
                        return activeElementHolder.activeElement
                    },
                    getRootNode(element) {
                        var _element$getRootNode;
                        return (null === element || void 0 === element || null === (_element$getRootNode = element.getRootNode) || void 0 === _element$getRootNode ? void 0 : _element$getRootNode.call(element)) ?? this._document
                    },
                    getBody() {
                        return this._document.body
                    },
                    createDocumentFragment() {
                        return this._document.createDocumentFragment()
                    },
                    getDocumentElement() {
                        return this._document.documentElement
                    },
                    getLocation() {
                        return this._document.location
                    },
                    getSelection() {
                        return this._document.selection
                    },
                    getReadyState() {
                        return this._document.readyState
                    },
                    getHead() {
                        return this._document.head
                    },
                    hasDocumentProperty(property) {
                        return property in this._document
                    },
                    listen(element, event, callback, options) {
                        if (!element || !("addEventListener" in element)) {
                            return _common.noop
                        }
                        element.addEventListener(event, callback, options);
                        return () => {
                            element.removeEventListener(event, callback)
                        }
                    },
                    elementsFromPoint(x, y, element) {
                        const activeElementHolder = this.getRootNode(element);
                        if (activeElementHolder.host) {
                            return (0, _shadow_dom.getShadowElementsFromPoint)(x, y, activeElementHolder)
                        }
                        return activeElementHolder.elementsFromPoint(x, y)
                    }
                };
                const domAdapter = exports.domAdapter = (0, _dependency_injector.default)(nativeDOMAdapterStrategy);
                exports.default = domAdapter
            },
        93630:
            /*!**************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_element.js ***!
              \**************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getPublicElement = function(element) {
                    return strategy(element)
                };
                exports.getPublicElementNonJquery = getPublicElementNonJquery;
                exports.setPublicElementWrapper = function(newStrategy) {
                    strategy = newStrategy
                };

                function getPublicElementNonJquery(element) {
                    if (element && element.get) {
                        return element.get(0)
                    }
                    return element
                }
                let strategy = getPublicElementNonJquery
            },
        29489:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_element_data.js ***!
              \*******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.afterCleanData = function(callback) {
                    afterCleanDataFunc = callback
                };
                exports.beforeCleanData = function(callback) {
                    beforeCleanDataFunc = callback
                };
                exports.cleanData = function(nodes) {
                    return strategy.cleanData.call(this, nodes)
                };
                exports.cleanDataRecursive = function(element, cleanSelf) {
                    if (!_dom_adapter.default.isElementNode(element)) {
                        return
                    }
                    const childElements = element.getElementsByTagName("*");
                    strategy.cleanData(childElements);
                    if (cleanSelf) {
                        strategy.cleanData([element])
                    }
                };
                exports.data = function() {
                    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                        args[_key] = arguments[_key]
                    }
                    return strategy.data.apply(this, args)
                };
                exports.getDataStrategy = function() {
                    return strategy
                };
                exports.removeData = function(element, key) {
                    return strategy.removeData.call(this, element, key)
                };
                exports.strategyChanging = exports.setDataStrategy = void 0;
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 64960));
                var _memorized_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/memorized_callbacks */ 35329));
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 76772));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const dataMap = new WeakMap;
                let strategy;
                const strategyChanging = exports.strategyChanging = new _memorized_callbacks.default;
                let beforeCleanDataFunc = function() {};
                let afterCleanDataFunc = function() {};
                const setDataStrategy = function(value) {
                    strategyChanging.fire(value);
                    strategy = value;
                    const {
                        cleanData: cleanData
                    } = strategy;
                    strategy.cleanData = function(nodes) {
                        beforeCleanDataFunc(nodes);
                        const result = cleanData.call(this, nodes);
                        afterCleanDataFunc(nodes);
                        return result
                    }
                };
                exports.setDataStrategy = setDataStrategy;
                setDataStrategy({
                    data: function() {
                        const element = arguments.length <= 0 ? void 0 : arguments[0];
                        const key = arguments.length <= 1 ? void 0 : arguments[1];
                        const value = arguments.length <= 2 ? void 0 : arguments[2];
                        if (!element) {
                            return
                        }
                        let elementData = dataMap.get(element);
                        if (!elementData) {
                            elementData = {};
                            dataMap.set(element, elementData)
                        }
                        if (void 0 === key) {
                            return elementData
                        }
                        if (2 === arguments.length) {
                            return elementData[key]
                        }
                        elementData[key] = value;
                        return value
                    },
                    removeData: function(element, key) {
                        if (!element) {
                            return
                        }
                        if (void 0 === key) {
                            dataMap.delete(element)
                        } else {
                            const elementData = dataMap.get(element);
                            if (elementData) {
                                delete elementData[key]
                            }
                        }
                    },
                    cleanData: function(elements) {
                        for (let i = 0; i < elements.length; i++) {
                            _events_engine.default.off(elements[i]);
                            dataMap.delete(elements[i])
                        }
                    }
                })
            },
        5583:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_errors.js ***!
              \*************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _error = (obj = __webpack_require__( /*! ../../core/utils/error */ 67264), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                exports.default = (0, _error.default)({
                    E0001: "Method is not implemented",
                    E0002: "Member name collision: {0}",
                    E0003: "A class must be instantiated using the 'new' keyword",
                    E0004: "The NAME property of the component is not specified",
                    E0005: "Unknown device",
                    E0006: "Unknown endpoint key is requested",
                    E0007: "'Invalidate' method is called outside the update transaction",
                    E0008: "Type of the option name is not appropriate to create an action",
                    E0009: "Component '{0}' has not been initialized for an element",
                    E0010: "Animation configuration with the '{0}' type requires '{1}' configuration as {2}",
                    E0011: "Unknown animation type '{0}'",
                    E0012: "jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",
                    E0013: "KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",
                    E0014: "The 'release' method shouldn't be called for an unlocked Lock object",
                    E0015: "Queued task returned an unexpected result",
                    E0017: "Event namespace is not defined",
                    E0018: "DevExpress.ui.DevExpressPopup widget is required",
                    E0020: "Template engine '{0}' is not supported",
                    E0021: "Unknown theme is set: {0}",
                    E0022: "LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",
                    E0023: "Template name is not specified",
                    E0024: "DevExtreme bundle already included",
                    E0025: "Unexpected argument type",
                    E0100: "Unknown validation type is detected",
                    E0101: "Misconfigured range validation rule is detected",
                    E0102: "Misconfigured comparison validation rule is detected",
                    E0103: "validationCallback of an asynchronous rule should return a jQuery or a native promise",
                    E0110: "Unknown validation group is detected",
                    E0120: "Adapter for a DevExpressValidator component cannot be configured",
                    E0121: "The 'customItem' parameter of the 'onCustomItemCreating' function is empty or contains invalid data. Assign a custom object or a Promise that is resolved after the item is created.",
                    W0000: "'{0}' is deprecated in {1}. {2}",
                    W0001: "{0} - '{1}' option is deprecated in {2}. {3}",
                    W0002: "{0} - '{1}' method is deprecated in {2}. {3}",
                    W0003: "{0} - '{1}' property is deprecated in {2}. {3}",
                    W0004: "Timeout for theme loading is over: {0}",
                    W0005: "'{0}' event is deprecated in {1}. {2}",
                    W0006: "Invalid recurrence rule: '{0}'",
                    W0007: "'{0}' Globalize culture is not defined",
                    W0008: "Invalid view name: '{0}'",
                    W0009: "Invalid time zone name: '{0}'",
                    W0010: "{0} is deprecated in {1}. {2}",
                    W0011: "Number parsing is invoked while the parser is not defined",
                    W0012: "Date parsing is invoked while the parser is not defined",
                    W0013: "'{0}' file is deprecated in {1}. {2}",
                    W0014: "{0} - '{1}' type is deprecated in {2}. {3}",
                    W0015: "Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",
                    W0016: 'The "{0}" option does not accept the "{1}" value since v{2}. {3}.',
                    W0017: 'Setting the "{0}" property with a function is deprecated since v21.2',
                    W0018: 'Setting the "position" property with a function is deprecated since v21.2',
                    W0019: "DevExtreme: Unable to Locate a Valid License Key.\n\nDetailed license/registration related information and instructions: https://js.devexpress.com/Documentation/Licensing/.\n\nIf you are using a 30-day trial version of DevExtreme, you must uninstall all copies of DevExtreme once your 30-day trial period expires. For terms and conditions that govern use of DevExtreme UI components/libraries, please refer to the DevExtreme End User License Agreement: https://js.devexpress.com/EULAs/DevExtremeComplete.\n\nTo use DevExtreme in a commercial project, you must purchase a license. For pricing/licensing options, please visit: https://js.devexpress.com/Buy.\n\nIf you have licensing-related questions or need help with a purchase, please email clientservices@devexpress.com.\n\n",
                    W0020: "DevExtreme: License Key Has Expired.\n\nDetailed license/registration related information and instructions: https://js.devexpress.com/Documentation/Licensing/.\n\nA mismatch exists between the license key used and the DevExtreme version referenced in this project.\n\nTo proceed, you can:\n\u2022 use a version of DevExtreme linked to your license key: https://www.devexpress.com/ClientCenter/DownloadManager\n\u2022 renew your DevExpress Subscription: https://www.devexpress.com/buy/renew (once you renew your subscription, you will be entitled to product updates and support service as defined in the DevExtreme End User License Agreement)\n\nIf you have licensing-related questions or need help with a renewal, please email clientservices@devexpress.com.\n\n",
                    W0021: "DevExtreme: License Key Verification Has Failed.\n\nDetailed license/registration related information and instructions: https://js.devexpress.com/Documentation/Licensing/.\n\nTo verify your DevExtreme license, make certain to specify a correct key in the GlobalConfig. If you continue to encounter this error, please visit https://www.devexpress.com/ClientCenter/DownloadManager to obtain a valid license key.\n\nIf you have a valid license and this problem persists, please submit a support ticket via the DevExpress Support Center. We will be happy to follow-up: https://supportcenter.devexpress.com/ticket/create.\n\n",
                    W0022: "DevExtreme: Pre-release software. Not suitable for commercial use.\n\nDetailed license/registration related information and instructions: https://js.devexpress.com/Documentation/Licensing/.\n\nPre-release software may contain deficiencies and as such, should not be considered for use or integrated in any mission critical application.\n\n",
                    W0023: "DevExtreme: the following 'devextreme' package version does not match versions of other DevExpress products used in this application:\n\n{0}\n\nInteroperability between different versions of the products listed herein cannot be guaranteed.\n\n"
                })
            },
        14201:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_events_strategy.js ***!
              \**********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.EventsStrategy = void 0;
                var _callbacks = (obj = __webpack_require__( /*! ../../core/utils/callbacks */ 84718), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                class EventsStrategy {
                    constructor(owner) {
                        let options = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
                        this._events = {};
                        this._owner = owner;
                        this._options = options
                    }
                    static create(owner, strategy) {
                        if (strategy) {
                            return (0, _type.isFunction)(strategy) ? strategy(owner) : strategy
                        }
                        return new EventsStrategy(owner)
                    }
                    hasEvent(eventName) {
                        const callbacks = this._events[eventName];
                        return callbacks ? callbacks.has() : false
                    }
                    fireEvent(eventName, eventArgs) {
                        const callbacks = this._events[eventName];
                        if (callbacks) {
                            callbacks.fireWith(this._owner, eventArgs)
                        }
                        return this._owner
                    }
                    on(eventName, eventHandler) {
                        if ((0, _type.isPlainObject)(eventName)) {
                            (0, _iterator.each)(eventName, ((e, h) => {
                                this.on(e, h)
                            }))
                        } else {
                            let callbacks = this._events[eventName];
                            if (!callbacks) {
                                callbacks = (0, _callbacks.default)({
                                    syncStrategy: this._options.syncStrategy
                                });
                                this._events[eventName] = callbacks
                            }
                            const addFn = callbacks.originalAdd || callbacks.add;
                            addFn.call(callbacks, eventHandler)
                        }
                    }
                    off(eventName, eventHandler) {
                        const callbacks = this._events[eventName];
                        if (callbacks) {
                            if ((0, _type.isFunction)(eventHandler)) {
                                callbacks.remove(eventHandler)
                            } else {
                                callbacks.empty()
                            }
                        }
                    }
                    dispose() {
                        (0, _iterator.each)(this._events, ((eventName, event) => {
                            event.empty()
                        }))
                    }
                }
                exports.EventsStrategy = EventsStrategy
            },
        7201:
            /*!***********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_guid.js ***!
              \***********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Guid = void 0;
                var _class = (obj = __webpack_require__( /*! ../../core/class */ 55620), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                exports.Guid = _class.default.inherit({
                    ctor: function(value) {
                        if (value) {
                            value = String(value)
                        }
                        this._value = this._normalize(value || this._generate())
                    },
                    _normalize: function(value) {
                        value = value.replace(/[^a-f0-9]/gi, "").toLowerCase();
                        while (value.length < 32) {
                            value += "0"
                        }
                        return [value.substr(0, 8), value.substr(8, 4), value.substr(12, 4), value.substr(16, 4), value.substr(20, 12)].join("-")
                    },
                    _generate: function() {
                        let value = "";
                        for (let i = 0; i < 32; i++) {
                            value += Math.round(15 * Math.random()).toString(16)
                        }
                        return value
                    },
                    toString: function() {
                        return this._value
                    },
                    valueOf: function() {
                        return this._value
                    },
                    toJSON: function() {
                        return this._value
                    }
                })
            },
        58670:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_http_request.js ***!
              \*******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.httpRequest = void 0;
                var _dependency_injector = (obj = __webpack_require__( /*! ../../core/utils/dependency_injector */ 89656), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _window = __webpack_require__( /*! ../../core/utils/window */ 3104);
                const window = (0, _window.getWindow)();
                const nativeXMLHttpRequest = {
                    getXhr: () => new window.XMLHttpRequest
                };
                exports.httpRequest = (0, _dependency_injector.default)(nativeXMLHttpRequest)
            },
        21327:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_inferno_renderer.js ***!
              \***********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.infernoRenderer = void 0;
                var _inferno = __webpack_require__( /*! @devextreme/runtime/inferno */ 49714);
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 64960));
                var _element_data = __webpack_require__( /*! ../../core/element_data */ 74663);
                var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/dependency_injector */ 89656));
                var _inferno2 = __webpack_require__( /*! inferno */ 81167);
                var _infernoCreateElement = __webpack_require__( /*! inferno-create-element */ 63935);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const remove = element => {
                    const {
                        parentNode: parentNode
                    } = element;
                    if (parentNode) {
                        const {
                            nextSibling: nextSibling
                        } = element;
                        (0, _element_data.cleanDataRecursive)(element);
                        parentNode.$V = element.$V;
                        (0, _inferno2.render)(null, parentNode);
                        parentNode.insertBefore(element, nextSibling);
                        element.innerHTML = "";
                        delete parentNode.$V
                    }
                    delete element.$V
                };
                exports.infernoRenderer = (0, _dependency_injector.default)({
                    createElement: (component, props) => (0, _infernoCreateElement.createElement)(component, props),
                    remove: remove,
                    onAfterRender: () => {
                        _inferno.InfernoEffectHost.callEffects()
                    },
                    onPreRender: () => {
                        _inferno.InfernoEffectHost.lock()
                    },
                    render: (component, props, container, replace) => {
                        if (!replace) {
                            const {
                                parentNode: parentNode
                            } = container;
                            const nextNode = null === container || void 0 === container ? void 0 : container.nextSibling;
                            const rootNode = _dom_adapter.default.createElement("div");
                            rootNode.appendChild(container);
                            const mountNode = _dom_adapter.default.createDocumentFragment().appendChild(rootNode);
                            const vNodeAlreadyExists = !!container.$V;
                            vNodeAlreadyExists && remove(container);
                            (0, _inferno.hydrate)((0, _infernoCreateElement.createElement)(component, props), mountNode);
                            container.$V = mountNode.$V;
                            if (parentNode) {
                                parentNode.insertBefore(container, nextNode)
                            }
                        } else {
                            (0, _inferno2.render)((0, _infernoCreateElement.createElement)(component, props), container)
                        }
                    }
                })
            },
        87107:
            /*!**************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_memorized_callbacks.js ***!
              \**************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.MemorizedCallbacks = void 0;
                var _callbacks = (obj = __webpack_require__( /*! ../../core/utils/callbacks */ 84718), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 21274);
                exports.MemorizedCallbacks = class {
                    constructor() {
                        this.memory = [];
                        this.callbacks = (0, _callbacks.default)()
                    }
                    add(fn) {
                        (0, _iterator.each)(this.memory, ((_, item) => fn.apply(fn, item)));
                        this.callbacks.add(fn)
                    }
                    remove(fn) {
                        this.callbacks.remove(fn)
                    }
                    fire() {
                        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                            args[_key] = arguments[_key]
                        }
                        this.memory.push(args);
                        this.callbacks.fire.apply(this.callbacks, args)
                    }
                }
            },
        45693:
            /*!***************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_postponed_operations.js ***!
              \***************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.PostponedOperations = void 0;
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 87739);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                exports.PostponedOperations = class {
                    constructor() {
                        this._postponedOperations = {}
                    }
                    add(key, fn, postponedPromise) {
                        if (key in this._postponedOperations) {
                            postponedPromise && this._postponedOperations[key].promises.push(postponedPromise)
                        } else {
                            const completePromise = new _deferred.Deferred;
                            this._postponedOperations[key] = {
                                fn: fn,
                                completePromise: completePromise,
                                promises: postponedPromise ? [postponedPromise] : []
                            }
                        }
                        return this._postponedOperations[key].completePromise.promise()
                    }
                    callPostponedOperations() {
                        for (const key in this._postponedOperations) {
                            const operation = this._postponedOperations[key];
                            if ((0, _type.isDefined)(operation)) {
                                if (operation.promises && operation.promises.length) {
                                    (0, _deferred.when)(...operation.promises).done(operation.fn).then(operation.completePromise.resolve)
                                } else {
                                    operation.fn().done(operation.completePromise.resolve)
                                }
                            }
                        }
                        this._postponedOperations = {}
                    }
                }
            },
        95539:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_renderer.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.renderer = exports.default = void 0;
                var _renderer_base = (obj = __webpack_require__( /*! ../../core/renderer_base */ 21681), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                const renderer = exports.renderer = _renderer_base.default.get();
                exports.default = renderer
            },
        1811:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_renderer_base.js ***!
              \********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _dom_adapter = (obj = __webpack_require__( /*! ../../core/dom_adapter */ 64960), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _element_data = __webpack_require__( /*! ../../core/element_data */ 74663);
                var _html_parser = __webpack_require__( /*! ../../core/utils/html_parser */ 23563);
                var _size = __webpack_require__( /*! ../../core/utils/size */ 57653);
                var _style = __webpack_require__( /*! ../../core/utils/style */ 58515);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                var _window = __webpack_require__( /*! ../../core/utils/window */ 3104);
                const window = (0, _window.getWindow)();
                let renderer;
                const initRender = function(selector, context) {
                    if (!selector) {
                        this.length = 0;
                        return this
                    }
                    if ("string" === typeof selector) {
                        if ("body" === selector) {
                            this[0] = context ? context.body : _dom_adapter.default.getBody();
                            this.length = 1;
                            return this
                        }
                        context = context || _dom_adapter.default.getDocument();
                        if (selector.startsWith("<")) {
                            this[0] = _dom_adapter.default.createElement(selector.slice(1, -1), context);
                            this.length = 1;
                            return this
                        } [].push.apply(this, _dom_adapter.default.querySelectorAll(context, selector));
                        return this
                    }
                    if (_dom_adapter.default.isNode(selector) || (0, _type.isWindow)(selector)) {
                        this[0] = selector;
                        this.length = 1;
                        return this
                    }
                    if (Array.isArray(selector)) {
                        [].push.apply(this, selector);
                        return this
                    }
                    return renderer(selector.toArray ? selector.toArray() : [selector])
                };
                renderer = function(selector, context) {
                    return new initRender(selector, context)
                };
                renderer.fn = {
                    dxRenderer: true
                };
                initRender.prototype = renderer.fn;
                const repeatMethod = function(methodName, args) {
                    for (let i = 0; i < this.length; i++) {
                        const item = renderer(this[i]);
                        item[methodName].apply(item, args)
                    }
                    return this
                };
                const setAttributeValue = function(element, attrName, value) {
                    if (void 0 !== value && null !== value && false !== value) {
                        _dom_adapter.default.setAttribute(element, attrName, value)
                    } else {
                        _dom_adapter.default.removeAttribute(element, attrName)
                    }
                };
                initRender.prototype.show = function() {
                    return this.toggle(true)
                };
                initRender.prototype.hide = function() {
                    return this.toggle(false)
                };
                initRender.prototype.toggle = function(value) {
                    if (this[0]) {
                        this.toggleClass("dx-state-invisible", !value)
                    }
                    return this
                };
                initRender.prototype.attr = function(attrName, value) {
                    if (this.length > 1 && arguments.length > 1) {
                        return repeatMethod.call(this, "attr", arguments)
                    }
                    if (!this[0]) {
                        if ((0, _type.isObject)(attrName) || void 0 !== value) {
                            return this
                        }
                        return
                    }
                    if (!this[0].getAttribute) {
                        return this.prop(attrName, value)
                    }
                    if ("string" === typeof attrName && 1 === arguments.length) {
                        const result = this[0].getAttribute(attrName);
                        return null == result ? void 0 : result
                    }
                    if ((0, _type.isPlainObject)(attrName)) {
                        for (const key in attrName) {
                            this.attr(key, attrName[key])
                        }
                    } else {
                        setAttributeValue(this[0], attrName, value)
                    }
                    return this
                };
                initRender.prototype.removeAttr = function(attrName) {
                    this[0] && _dom_adapter.default.removeAttribute(this[0], attrName);
                    return this
                };
                initRender.prototype.prop = function(propName, value) {
                    if (!this[0]) {
                        return this
                    }
                    if ("string" === typeof propName && 1 === arguments.length) {
                        return this[0][propName]
                    }
                    if ((0, _type.isPlainObject)(propName)) {
                        for (const key in propName) {
                            this.prop(key, propName[key])
                        }
                    } else {
                        _dom_adapter.default.setProperty(this[0], propName, value)
                    }
                    return this
                };
                initRender.prototype.addClass = function(className) {
                    return this.toggleClass(className, true)
                };
                initRender.prototype.removeClass = function(className) {
                    return this.toggleClass(className, false)
                };
                initRender.prototype.hasClass = function(className) {
                    if (!this[0] || void 0 === this[0].className) {
                        return false
                    }
                    const classNames = className.split(" ");
                    for (let i = 0; i < classNames.length; i++) {
                        if (this[0].classList) {
                            if (this[0].classList.contains(classNames[i])) {
                                return true
                            }
                        } else {
                            const className = (0, _type.isString)(this[0].className) ? this[0].className : _dom_adapter.default.getAttribute(this[0], "class");
                            if ((className || "").split(" ").indexOf(classNames[i]) >= 0) {
                                return true
                            }
                        }
                    }
                    return false
                };
                initRender.prototype.toggleClass = function(className, value) {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "toggleClass", arguments)
                    }
                    if (!this[0] || !className) {
                        return this
                    }
                    value = void 0 === value ? !this.hasClass(className) : value;
                    const classNames = className.split(" ");
                    for (let i = 0; i < classNames.length; i++) {
                        _dom_adapter.default.setClass(this[0], classNames[i], value)
                    }
                    return this
                };
                initRender.prototype.html = function(value) {
                    if (!arguments.length) {
                        return this[0].innerHTML
                    }
                    this.empty();
                    if ("string" === typeof value && !(0, _html_parser.isTablePart)(value) || "number" === typeof value) {
                        this[0].innerHTML = value;
                        return this
                    }
                    return this.append((0, _html_parser.parseHTML)(value))
                };
                const appendElements = function(element, nextSibling) {
                    if (!this[0] || !element) {
                        return
                    }
                    if ("string" === typeof element) {
                        element = (0, _html_parser.parseHTML)(element)
                    } else if (element.nodeType) {
                        element = [element]
                    } else if ((0, _type.isNumeric)(element)) {
                        element = [_dom_adapter.default.createTextNode(element)]
                    }
                    for (let i = 0; i < element.length; i++) {
                        const item = element[i];
                        let container = this[0];
                        const wrapTR = "TABLE" === container.tagName && "TR" === item.tagName;
                        if (wrapTR && container.tBodies && container.tBodies.length) {
                            container = container.tBodies[0]
                        }
                        _dom_adapter.default.insertElement(container, item.nodeType ? item : item[0], nextSibling)
                    }
                };
                const setCss = function(name, value) {
                    if (!this[0] || !this[0].style) {
                        return
                    }
                    if (null === value || "number" === typeof value && isNaN(value)) {
                        return
                    }
                    name = (0, _style.styleProp)(name);
                    for (let i = 0; i < this.length; i++) {
                        this[i].style[name] = (0, _style.normalizeStyleProp)(name, value)
                    }
                };
                initRender.prototype.css = function(name, value) {
                    if ((0, _type.isString)(name)) {
                        if (2 === arguments.length) {
                            setCss.call(this, name, value)
                        } else {
                            if (!this[0]) {
                                return
                            }
                            name = (0, _style.styleProp)(name);
                            const result = window.getComputedStyle(this[0])[name] || this[0].style[name];
                            return (0, _type.isNumeric)(result) ? result.toString() : result
                        }
                    } else if ((0, _type.isPlainObject)(name)) {
                        for (const key in name) {
                            setCss.call(this, key, name[key])
                        }
                    }
                    return this
                };
                initRender.prototype.prepend = function(element) {
                    if (arguments.length > 1) {
                        for (let i = 0; i < arguments.length; i++) {
                            this.prepend(arguments[i])
                        }
                        return this
                    }
                    appendElements.apply(this, [element, this[0].firstChild]);
                    return this
                };
                initRender.prototype.append = function(element) {
                    if (arguments.length > 1) {
                        for (let i = 0; i < arguments.length; i++) {
                            this.append(arguments[i])
                        }
                        return this
                    }
                    appendElements.apply(this, [element]);
                    return this
                };
                initRender.prototype.prependTo = function(element) {
                    if (this.length > 1) {
                        for (let i = this.length - 1; i >= 0; i--) {
                            renderer(this[i]).prependTo(element)
                        }
                        return this
                    }
                    element = renderer(element);
                    if (element[0]) {
                        _dom_adapter.default.insertElement(element[0], this[0], element[0].firstChild)
                    }
                    return this
                };
                initRender.prototype.appendTo = function(element) {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "appendTo", arguments)
                    }
                    _dom_adapter.default.insertElement(renderer(element)[0], this[0]);
                    return this
                };
                initRender.prototype.insertBefore = function(element) {
                    if (element && element[0]) {
                        _dom_adapter.default.insertElement(element[0].parentNode, this[0], element[0])
                    }
                    return this
                };
                initRender.prototype.insertAfter = function(element) {
                    if (element && element[0]) {
                        _dom_adapter.default.insertElement(element[0].parentNode, this[0], element[0].nextSibling)
                    }
                    return this
                };
                initRender.prototype.before = function(element) {
                    if (this[0]) {
                        _dom_adapter.default.insertElement(this[0].parentNode, element[0], this[0])
                    }
                    return this
                };
                initRender.prototype.after = function(element) {
                    if (this[0]) {
                        _dom_adapter.default.insertElement(this[0].parentNode, element[0], this[0].nextSibling)
                    }
                    return this
                };
                initRender.prototype.wrap = function(wrapper) {
                    if (this[0]) {
                        const wrap = renderer(wrapper);
                        wrap.insertBefore(this);
                        wrap.append(this)
                    }
                    return this
                };
                initRender.prototype.wrapInner = function(wrapper) {
                    const contents = this.contents();
                    if (contents.length) {
                        contents.wrap(wrapper)
                    } else {
                        this.append(wrapper)
                    }
                    return this
                };
                initRender.prototype.replaceWith = function(element) {
                    if (!(element && element[0])) {
                        return
                    }
                    if (element.is(this)) {
                        return this
                    }
                    element.insertBefore(this);
                    this.remove();
                    return element
                };
                initRender.prototype.remove = function() {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "remove", arguments)
                    }(0, _element_data.cleanDataRecursive)(this[0], true);
                    _dom_adapter.default.removeElement(this[0]);
                    return this
                };
                initRender.prototype.detach = function() {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "detach", arguments)
                    }
                    _dom_adapter.default.removeElement(this[0]);
                    return this
                };
                initRender.prototype.empty = function() {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "empty", arguments)
                    }(0, _element_data.cleanDataRecursive)(this[0]);
                    _dom_adapter.default.setText(this[0], "");
                    return this
                };
                initRender.prototype.clone = function() {
                    const result = [];
                    for (let i = 0; i < this.length; i++) {
                        result.push(this[i].cloneNode(true))
                    }
                    return renderer(result)
                };
                initRender.prototype.text = function(value) {
                    if (!arguments.length) {
                        let result = "";
                        for (let i = 0; i < this.length; i++) {
                            result += this[i] && this[i].textContent || ""
                        }
                        return result
                    }
                    const text = (0, _type.isFunction)(value) ? value() : value;
                    (0, _element_data.cleanDataRecursive)(this[0], false);
                    _dom_adapter.default.setText(this[0], (0, _type.isDefined)(text) ? text : "");
                    return this
                };
                initRender.prototype.val = function(value) {
                    if (1 === arguments.length) {
                        return this.prop("value", (0, _type.isDefined)(value) ? value : "")
                    }
                    return this.prop("value")
                };
                initRender.prototype.contents = function() {
                    if (!this[0]) {
                        return renderer()
                    }
                    const result = [];
                    result.push.apply(result, this[0].childNodes);
                    return renderer(result)
                };
                initRender.prototype.find = function(selector) {
                    const result = renderer();
                    if (!selector) {
                        return result
                    }
                    const nodes = [];
                    let i;
                    if ("string" === typeof selector) {
                        selector = selector.trim();
                        for (i = 0; i < this.length; i++) {
                            const element = this[i];
                            if (_dom_adapter.default.isElementNode(element)) {
                                const elementId = element.getAttribute("id");
                                let queryId = elementId || "dx-query-children";
                                if (!elementId) {
                                    setAttributeValue(element, "id", queryId)
                                }
                                queryId = `[id='${queryId}'] `;
                                const querySelector = queryId + selector.replace(/([^\\])(,)/g, `$1, ${queryId}`);
                                nodes.push.apply(nodes, _dom_adapter.default.querySelectorAll(element, querySelector));
                                setAttributeValue(element, "id", elementId)
                            } else if (_dom_adapter.default.isDocument(element) || _dom_adapter.default.isDocumentFragment(element)) {
                                nodes.push.apply(nodes, _dom_adapter.default.querySelectorAll(element, selector))
                            }
                        }
                    } else {
                        for (i = 0; i < this.length; i++) {
                            selector = _dom_adapter.default.isNode(selector) ? selector : selector[0];
                            if (this[i] !== selector && this[i].contains(selector)) {
                                nodes.push(selector)
                            }
                        }
                    }
                    return result.add(nodes)
                };
                const isVisible = function(_, element) {
                    var _element$getClientRec, _element;
                    element = element.host ?? element;
                    if (!element.nodeType) {
                        return true
                    }
                    return !!(element.offsetWidth || element.offsetHeight || null !== (_element$getClientRec = (_element = element).getClientRects) && void 0 !== _element$getClientRec && _element$getClientRec.call(_element).length)
                };
                initRender.prototype.filter = function(selector) {
                    if (!selector) {
                        return renderer()
                    }
                    if (":visible" === selector) {
                        return this.filter(isVisible)
                    }
                    if (":hidden" === selector) {
                        return this.filter((function(_, element) {
                            return !isVisible(0, element)
                        }))
                    }
                    const result = [];
                    for (let i = 0; i < this.length; i++) {
                        const item = this[i];
                        if (_dom_adapter.default.isElementNode(item) && "string" === (0, _type.type)(selector)) {
                            _dom_adapter.default.elementMatches(item, selector) && result.push(item)
                        } else if (_dom_adapter.default.isNode(selector) || (0, _type.isWindow)(selector)) {
                            selector === item && result.push(item)
                        } else if ((0, _type.isFunction)(selector)) {
                            selector.call(item, i, item) && result.push(item)
                        } else {
                            for (let j = 0; j < selector.length; j++) {
                                selector[j] === item && result.push(item)
                            }
                        }
                    }
                    return renderer(result)
                };
                initRender.prototype.not = function(selector) {
                    const result = [];
                    const nodes = this.filter(selector).toArray();
                    for (let i = 0; i < this.length; i++) {
                        if (-1 === nodes.indexOf(this[i])) {
                            result.push(this[i])
                        }
                    }
                    return renderer(result)
                };
                initRender.prototype.is = function(selector) {
                    return !!this.filter(selector).length
                };
                initRender.prototype.children = function(selector) {
                    let result = [];
                    for (let i = 0; i < this.length; i++) {
                        const nodes = this[i] ? this[i].childNodes : [];
                        for (let j = 0; j < nodes.length; j++) {
                            if (_dom_adapter.default.isElementNode(nodes[j])) {
                                result.push(nodes[j])
                            }
                        }
                    }
                    result = renderer(result);
                    return selector ? result.filter(selector) : result
                };
                initRender.prototype.siblings = function() {
                    const element = this[0];
                    if (!element || !element.parentNode) {
                        return renderer()
                    }
                    const result = [];
                    const parentChildNodes = element.parentNode.childNodes || [];
                    for (let i = 0; i < parentChildNodes.length; i++) {
                        const node = parentChildNodes[i];
                        if (_dom_adapter.default.isElementNode(node) && node !== element) {
                            result.push(node)
                        }
                    }
                    return renderer(result)
                };
                initRender.prototype.each = function(callback) {
                    for (let i = 0; i < this.length; i++) {
                        if (false === callback.call(this[i], i, this[i])) {
                            break
                        }
                    }
                };
                initRender.prototype.index = function(element) {
                    if (!element) {
                        return this.parent().children().index(this)
                    }
                    element = renderer(element);
                    return this.toArray().indexOf(element[0])
                };
                initRender.prototype.get = function(index) {
                    return this[index < 0 ? this.length + index : index]
                };
                initRender.prototype.eq = function(index) {
                    index = index < 0 ? this.length + index : index;
                    return renderer(this[index])
                };
                initRender.prototype.first = function() {
                    return this.eq(0)
                };
                initRender.prototype.last = function() {
                    return this.eq(-1)
                };
                initRender.prototype.select = function() {
                    for (let i = 0; i < this.length; i += 1) {
                        this[i].select && this[i].select()
                    }
                    return this
                };
                initRender.prototype.parent = function(selector) {
                    if (!this[0]) {
                        return renderer()
                    }
                    const result = renderer(this[0].parentNode);
                    return !selector || result.is(selector) ? result : renderer()
                };
                initRender.prototype.parents = function(selector) {
                    const result = [];
                    let parent = this.parent();
                    while (parent && parent[0] && !_dom_adapter.default.isDocument(parent[0])) {
                        if (_dom_adapter.default.isElementNode(parent[0])) {
                            if (!selector || parent.is(selector)) {
                                result.push(parent.get(0))
                            }
                        }
                        parent = parent.parent()
                    }
                    return renderer(result)
                };
                initRender.prototype.closest = function(selector) {
                    if (this.is(selector)) {
                        return this
                    }
                    let parent = this.parent();
                    while (parent && parent.length) {
                        if (parent.is(selector)) {
                            return parent
                        }
                        parent = parent.parent()
                    }
                    return renderer()
                };
                initRender.prototype.next = function(selector) {
                    if (!this[0]) {
                        return renderer()
                    }
                    let next = renderer(this[0].nextSibling);
                    if (!arguments.length) {
                        return next
                    }
                    while (next && next.length) {
                        if (next.is(selector)) {
                            return next
                        }
                        next = next.next()
                    }
                    return renderer()
                };
                initRender.prototype.prev = function() {
                    if (!this[0]) {
                        return renderer()
                    }
                    return renderer(this[0].previousSibling)
                };
                initRender.prototype.add = function(selector) {
                    const targets = renderer(selector);
                    const result = this.toArray();
                    for (let i = 0; i < targets.length; i++) {
                        const target = targets[i];
                        if (-1 === result.indexOf(target)) {
                            result.push(target)
                        }
                    }
                    return renderer(result)
                };
                const emptyArray = [];
                initRender.prototype.splice = function() {
                    return renderer(emptyArray.splice.apply(this, arguments))
                };
                initRender.prototype.slice = function() {
                    return renderer(emptyArray.slice.apply(this, arguments))
                };
                initRender.prototype.toArray = function() {
                    return emptyArray.slice.call(this)
                };
                initRender.prototype.offset = function() {
                    if (!this[0]) {
                        return
                    }
                    return (0, _size.getOffset)(this[0])
                };
                initRender.prototype.offsetParent = function() {
                    if (!this[0]) {
                        return renderer()
                    }
                    let offsetParent = renderer(this[0].offsetParent);
                    while (offsetParent[0] && "static" === offsetParent.css("position")) {
                        offsetParent = renderer(offsetParent[0].offsetParent)
                    }
                    offsetParent = offsetParent[0] ? offsetParent : renderer(_dom_adapter.default.getDocumentElement());
                    return offsetParent
                };
                initRender.prototype.position = function() {
                    if (!this[0]) {
                        return
                    }
                    let offset;
                    const marginTop = parseFloat(this.css("marginTop"));
                    const marginLeft = parseFloat(this.css("marginLeft"));
                    if ("fixed" === this.css("position")) {
                        offset = this[0].getBoundingClientRect();
                        return {
                            top: offset.top - marginTop,
                            left: offset.left - marginLeft
                        }
                    }
                    offset = this.offset();
                    const offsetParent = this.offsetParent();
                    let parentOffset = {
                        top: 0,
                        left: 0
                    };
                    if ("HTML" !== offsetParent[0].nodeName) {
                        parentOffset = offsetParent.offset()
                    }
                    parentOffset = {
                        top: parentOffset.top + parseFloat(offsetParent.css("borderTopWidth")),
                        left: parentOffset.left + parseFloat(offsetParent.css("borderLeftWidth"))
                    };
                    return {
                        top: offset.top - parentOffset.top - marginTop,
                        left: offset.left - parentOffset.left - marginLeft
                    }
                };
                [{
                    name: "scrollLeft",
                    offsetProp: "pageXOffset",
                    scrollWindow: function(win, value) {
                        win.scrollTo(value, win.pageYOffset)
                    }
                }, {
                    name: "scrollTop",
                    offsetProp: "pageYOffset",
                    scrollWindow: function(win, value) {
                        win.scrollTo(win.pageXOffset, value)
                    }
                }].forEach((function(directionStrategy) {
                    const propName = directionStrategy.name;
                    initRender.prototype[propName] = function(value) {
                        if (!this[0]) {
                            return
                        }
                        const window = (0, _size.getWindowByElement)(this[0]);
                        if (void 0 === value) {
                            return window ? window[directionStrategy.offsetProp] : this[0][propName]
                        }
                        if (window) {
                            directionStrategy.scrollWindow(window, value)
                        } else {
                            this[0][propName] = value
                        }
                        return this
                    }
                }));
                initRender.prototype.data = function(key, value) {
                    if (!this[0]) {
                        return
                    }
                    if (arguments.length < 2) {
                        return _element_data.data.call(renderer, this[0], key)
                    }
                    _element_data.data.call(renderer, this[0], key, value);
                    return this
                };
                initRender.prototype.removeData = function(key) {
                    this[0] && (0, _element_data.removeData)(this[0], key);
                    return this
                };
                const rendererWrapper = function() {
                    return renderer.apply(this, arguments)
                };
                Object.defineProperty(rendererWrapper, "fn", {
                    enumerable: true,
                    configurable: true,
                    get: function() {
                        return renderer.fn
                    },
                    set: function(value) {
                        renderer.fn = value
                    }
                });
                exports.default = {
                    set: function(strategy) {
                        renderer = strategy
                    },
                    get: function() {
                        return rendererWrapper
                    }
                }
            },
        57785:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_resize_observer.js ***!
              \**********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.resizeObserverSingleton = void 0;
                var _common = __webpack_require__( /*! ../../core/utils/common */ 17781);
                var _m_window = (obj = __webpack_require__( /*! ./utils/m_window */ 14470), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                const window = _m_window.default.getWindow();
                const ResizeObserverMock = {
                    observe: _common.noop,
                    unobserve: _common.noop,
                    disconnect: _common.noop
                };
                exports.resizeObserverSingleton = new class {
                    constructor() {
                        if (!_m_window.default.hasWindow() || !window.ResizeObserver) {
                            return ResizeObserverMock
                        }
                        this._callbacksMap = new Map;
                        this._observer = new window.ResizeObserver((entries => {
                            entries.forEach((entry => {
                                var _this$_callbacksMap$g;
                                null === (_this$_callbacksMap$g = this._callbacksMap.get(entry.target)) || void 0 === _this$_callbacksMap$g || _this$_callbacksMap$g(entry)
                            }))
                        }))
                    }
                    observe(element, callback) {
                        this._callbacksMap.set(element, callback);
                        this._observer.observe(element)
                    }
                    unobserve(element) {
                        this._callbacksMap.delete(element);
                        this._observer.unobserve(element)
                    }
                    disconnect() {
                        this._callbacksMap.clear();
                        this._observer.disconnect()
                    }
                }
            },
        66298:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_template_manager.js ***!
              \***********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = exports.TemplateManager = void 0;
                var _renderer = (obj = __webpack_require__( /*! ../../core/renderer */ 64553), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _empty_template = __webpack_require__( /*! ../../core/templates/empty_template */ 48650);
                var _function_template = __webpack_require__( /*! ../../core/templates/function_template */ 38699);
                var _common = __webpack_require__( /*! ../../core/utils/common */ 17781);
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 52576);
                var _template_manager = __webpack_require__( /*! ../../core/utils/template_manager */ 49194);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                const DX_POLYMORPH_WIDGET_TEMPLATE = new _function_template.FunctionTemplate((_ref => {
                    let {
                        model: model,
                        parent: parent
                    } = _ref;
                    const widgetName = model.widget;
                    if (!widgetName) {
                        return (0, _renderer.default)()
                    }
                    const widgetElement = (0, _renderer.default)("<div>");
                    const widgetOptions = model.options || {};
                    if (parent) {
                        parent._createComponent(widgetElement, widgetName, widgetOptions)
                    } else {
                        widgetElement[widgetName](widgetOptions)
                    }
                    return widgetElement
                }));
                class TemplateManager {
                    constructor(createElement, anonymousTemplateName) {
                        this._tempTemplates = [];
                        this._defaultTemplates = {};
                        this._anonymousTemplateName = anonymousTemplateName || "template";
                        this._createElement = createElement || _template_manager.defaultCreateElement;
                        this._createTemplateIfNeeded = this._createTemplateIfNeeded.bind(this)
                    }
                    static createDefaultOptions() {
                        return {
                            integrationOptions: {
                                watchMethod: function(fn, callback) {
                                    let options = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
                                    if (!options.skipImmediate) {
                                        callback(fn())
                                    }
                                    return _common.noop
                                },
                                templates: {
                                    "dx-polymorph-widget": DX_POLYMORPH_WIDGET_TEMPLATE
                                },
                                useDeferUpdateForTemplates: true
                            }
                        }
                    }
                    get anonymousTemplateName() {
                        return this._anonymousTemplateName
                    }
                    addDefaultTemplates(templates) {
                        this._defaultTemplates = (0, _extend.extend)({}, this._defaultTemplates, templates)
                    }
                    dispose() {
                        this._tempTemplates.forEach((tempTemplate => {
                            tempTemplate.template.dispose && tempTemplate.template.dispose()
                        }));
                        this._tempTemplates = []
                    }
                    extractTemplates($el) {
                        const templates = this._extractTemplates($el);
                        const anonymousTemplateMeta = this._extractAnonymousTemplate($el);
                        return {
                            templates: templates,
                            anonymousTemplateMeta: anonymousTemplateMeta
                        }
                    }
                    _extractTemplates($el) {
                        const templates = (0, _template_manager.findTemplates)($el, "dxTemplate");
                        const suitableTemplates = (0, _template_manager.suitableTemplatesByName)(templates);
                        templates.forEach((_ref2 => {
                            let {
                                element: element,
                                options: {
                                    name: name
                                }
                            } = _ref2;
                            if (element === suitableTemplates[name]) {
                                (0, _renderer.default)(element).addClass("dx-template-wrapper").detach()
                            } else {
                                (0, _renderer.default)(element).remove()
                            }
                        }));
                        return Object.keys(suitableTemplates).map((name => ({
                            name: name,
                            template: this._createTemplate(suitableTemplates[name])
                        })))
                    }
                    _extractAnonymousTemplate($el) {
                        const $anonymousTemplate = $el.contents().detach();
                        const $notJunkTemplateContent = $anonymousTemplate.filter(((_, element) => {
                            const isTextNode = 3 === element.nodeType;
                            const isEmptyText = (0, _renderer.default)(element).text().trim().length < 1;
                            return !(isTextNode && isEmptyText)
                        }));
                        return $notJunkTemplateContent.length > 0 ? {
                            template: this._createTemplate($anonymousTemplate),
                            name: this._anonymousTemplateName
                        } : {}
                    }
                    _createTemplateIfNeeded(templateSource) {
                        const cachedTemplate = this._tempTemplates.filter((tempTemplate => tempTemplate.source === (0, _template_manager.templateKey)(templateSource)))[0];
                        if (cachedTemplate) {
                            return cachedTemplate.template
                        }
                        const template = this._createTemplate(templateSource);
                        this._tempTemplates.push({
                            template: template,
                            source: (0, _template_manager.templateKey)(templateSource)
                        });
                        return template
                    }
                    _createTemplate(templateSource) {
                        return this._createElement((0, _template_manager.validateTemplateSource)(templateSource))
                    }
                    getTemplate(templateSource, templates, _ref3, context) {
                        let {
                            isAsyncTemplate: isAsyncTemplate,
                            skipTemplates: skipTemplates
                        } = _ref3;
                        if (!(0, _type.isFunction)(templateSource)) {
                            return (0, _template_manager.acquireTemplate)(templateSource, this._createTemplateIfNeeded, templates, isAsyncTemplate, skipTemplates, this._defaultTemplates)
                        }
                        return new _function_template.FunctionTemplate((options => {
                            const templateSourceResult = templateSource.apply(context, (0, _template_manager.getNormalizedTemplateArgs)(options));
                            if (!(0, _type.isDefined)(templateSourceResult)) {
                                return new _empty_template.EmptyTemplate
                            }
                            let dispose = false;
                            const template = (0, _template_manager.acquireTemplate)(templateSourceResult, (templateSource => {
                                if (templateSource.nodeType || (0, _type.isRenderer)(templateSource) && !(0, _renderer.default)(templateSource).is("script")) {
                                    return new _function_template.FunctionTemplate((() => templateSource))
                                }
                                dispose = true;
                                return this._createTemplate(templateSource)
                            }), templates, isAsyncTemplate, skipTemplates, this._defaultTemplates);
                            const result = template.render(options);
                            dispose && template.dispose && template.dispose();
                            return result
                        }))
                    }
                }
                exports.TemplateManager = TemplateManager;
                exports.default = {
                    TemplateManager: TemplateManager
                }
            },
        43399:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/options/m_index.js ***!
              \********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Options = void 0;
                var _option_manager = __webpack_require__( /*! ../../../core/options/option_manager */ 1896);
                var _utils = __webpack_require__( /*! ../../../core/options/utils */ 53904);
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _data = __webpack_require__( /*! ../../../core/utils/data */ 31e3);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                exports.Options = class {
                    constructor(options, defaultOptions, optionsByReference, deprecatedOptions) {
                        this._deprecatedCallback;
                        this._startChangeCallback;
                        this._endChangeCallback;
                        this._validateOptionsCallback;
                        this._default = defaultOptions;
                        this._deprecated = deprecatedOptions;
                        this._deprecatedNames = [];
                        this._initDeprecatedNames();
                        this._optionManager = new _option_manager.OptionManager(options, optionsByReference);
                        this._optionManager.onRelevantNamesPrepared(((options, name, value, silent) => this._setRelevantNames(options, name, value, silent)));
                        this._cachedOptions = {};
                        this._rules = []
                    }
                    set _initial(value) {
                        this._initialOptions = value
                    }
                    get _initial() {
                        if (!this._initialOptions) {
                            const rulesOptions = this._getByRules(this.silent("defaultOptionsRules"));
                            this._initialOptions = this._default;
                            this._optionManager._setByReference(this._initialOptions, rulesOptions)
                        }
                        return this._initialOptions
                    }
                    _initDeprecatedNames() {
                        for (const optionName in this._deprecated) {
                            this._deprecatedNames.push(optionName)
                        }
                    }
                    _getByRules(rules) {
                        rules = Array.isArray(rules) ? this._rules.concat(rules) : this._rules;
                        return (0, _utils.convertRulesToOptions)(rules)
                    }
                    _notifyDeprecated(option) {
                        const info = this._deprecated[option];
                        if (info) {
                            this._deprecatedCallback(option, info)
                        }
                    }
                    _setRelevantNames(options, name, value, silent) {
                        if (name) {
                            const normalizedName = this._normalizeName(name, silent);
                            if (normalizedName && normalizedName !== name) {
                                this._setField(options, normalizedName, value);
                                this._clearField(options, name)
                            }
                        }
                    }
                    _setField(options, fullName, value) {
                        let fieldName = "";
                        let fieldObject = null;
                        do {
                            fieldName = fieldName ? `.${fieldName}` : "";
                            fieldName = (0, _utils.getFieldName)(fullName) + fieldName;
                            fullName = (0, _utils.getParentName)(fullName);
                            fieldObject = fullName ? this._optionManager.get(options, fullName, false) : options
                        } while (!fieldObject);
                        fieldObject[fieldName] = value
                    }
                    _clearField(options, name) {
                        delete options[name];
                        const previousFieldName = (0, _utils.getParentName)(name);
                        const fieldObject = previousFieldName ? this._optionManager.get(options, previousFieldName, false) : options;
                        if (fieldObject) {
                            delete fieldObject[(0, _utils.getFieldName)(name)]
                        }
                    }
                    _normalizeName(name, silent) {
                        if (this._deprecatedNames.length && name) {
                            for (let i = 0; i < this._deprecatedNames.length; i++) {
                                if (this._deprecatedNames[i] === name) {
                                    const deprecate = this._deprecated[name];
                                    if (deprecate) {
                                        !silent && this._notifyDeprecated(name);
                                        return deprecate.alias || name
                                    }
                                }
                            }
                        }
                        return name
                    }
                    addRules(rules) {
                        this._rules = rules.concat(this._rules)
                    }
                    applyRules(rules) {
                        const options = this._getByRules(rules);
                        this.silent(options)
                    }
                    dispose() {
                        this._deprecatedCallback = _common.noop;
                        this._startChangeCallback = _common.noop;
                        this._endChangeCallback = _common.noop;
                        this._optionManager.dispose()
                    }
                    onChanging(callBack) {
                        this._optionManager.onChanging(callBack)
                    }
                    onChanged(callBack) {
                        this._optionManager.onChanged(callBack)
                    }
                    validateOptions(callBack) {
                        this._optionManager.onValidateOptions(callBack)
                    }
                    onDeprecated(callBack) {
                        this._deprecatedCallback = callBack
                    }
                    onStartChange(callBack) {
                        this._startChangeCallback = callBack
                    }
                    onEndChange(callBack) {
                        this._endChangeCallback = callBack
                    }
                    isInitial(name) {
                        const value = this.silent(name);
                        const initialValue = this.initial(name);
                        const areFunctions = (0, _type.isFunction)(value) && (0, _type.isFunction)(initialValue);
                        return areFunctions ? value.toString() === initialValue.toString() : (0, _common.equalByValue)(value, initialValue)
                    }
                    initial(name) {
                        return (0, _utils.getNestedOptionValue)(this._initial, name)
                    }
                    option(options, value) {
                        const isGetter = arguments.length < 2 && "object" !== (0, _type.type)(options);
                        if (isGetter) {
                            return this._optionManager.get(void 0, this._normalizeName(options))
                        }
                        this._startChangeCallback();
                        try {
                            this._optionManager.set(options, value)
                        } finally {
                            this._endChangeCallback()
                        }
                    }
                    silent(options, value) {
                        const isGetter = arguments.length < 2 && "object" !== (0, _type.type)(options);
                        if (isGetter) {
                            return this._optionManager.get(void 0, options, void 0, true)
                        }
                        this._optionManager.set(options, value, void 0, true)
                    }
                    reset(name) {
                        if (name) {
                            const fullPath = (0, _data.getPathParts)(name);
                            const value = fullPath.reduce(((value, field) => value ? value[field] : this.initial(field)), null);
                            const defaultValue = (0, _type.isObject)(value) ? _extends({}, value) : value;
                            this._optionManager.set(name, defaultValue, false)
                        }
                    }
                    getAliasesByName(name) {
                        return Object.keys(this._deprecated).filter((aliasName => name === this._deprecated[aliasName].alias))
                    }
                    isDeprecated(name) {
                        return Object.prototype.hasOwnProperty.call(this._deprecated, name)
                    }
                    cache(name, options) {
                        const isGetter = arguments.length < 2;
                        if (isGetter) {
                            return this._cachedOptions[name]
                        }
                        this._cachedOptions[name] = (0, _extend.extend)(this._cachedOptions[name], options)
                    }
                }
            },
        59830:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/options/m_option_manager.js ***!
              \*****************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.OptionManager = void 0;
                var _utils = __webpack_require__( /*! ../../../core/options/utils */ 53904);
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _comparator = __webpack_require__( /*! ../../../core/utils/comparator */ 60648);
                var _data = __webpack_require__( /*! ../../../core/utils/data */ 31e3);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                const cachedGetters = {};
                const cachedSetters = {};
                exports.OptionManager = class {
                    constructor(options, optionsByReference) {
                        this._options = options;
                        this._optionsByReference = optionsByReference;
                        this._changingCallback;
                        this._changedCallback;
                        this._namePreparedCallbacks;
                        this._validateOptionsCallback
                    }
                    _setByReference(options, rulesOptions) {
                        (0, _extend.extend)(true, options, rulesOptions);
                        for (const fieldName in this._optionsByReference) {
                            if (Object.prototype.hasOwnProperty.call(rulesOptions, fieldName)) {
                                options[fieldName] = rulesOptions[fieldName]
                            }
                        }
                    }
                    _setPreparedValue(name, value, merge, silent) {
                        const previousValue = this.get(this._options, name, false);
                        if (!(0, _comparator.equals)(previousValue, value)) {
                            const path = (0, _data.getPathParts)(name);
                            !silent && this._changingCallback(name, previousValue, value);
                            cachedSetters[name] = cachedSetters[name] || (0, _data.compileSetter)(name);
                            cachedSetters[name](this._options, value, {
                                functionsAsIs: true,
                                merge: (0, _type.isDefined)(merge) ? merge : !this._optionsByReference[name],
                                unwrapObservables: path.length > 1 && !!this._optionsByReference[path[0]]
                            });
                            !silent && this._changedCallback(name, value, previousValue)
                        }
                    }
                    _prepareRelevantNames(options, name, value, silent) {
                        if ((0, _type.isPlainObject)(value)) {
                            for (const valueName in value) {
                                this._prepareRelevantNames(options, `${name}.${valueName}`, value[valueName])
                            }
                        }
                        this._namePreparedCallbacks(options, name, value, silent)
                    }
                    get() {
                        let options = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : this._options;
                        let name = arguments.length > 1 ? arguments[1] : void 0;
                        let unwrapObservables = arguments.length > 2 ? arguments[2] : void 0;
                        cachedGetters[name] = cachedGetters[name] || (0, _data.compileGetter)(name);
                        return cachedGetters[name](options, {
                            functionsAsIs: true,
                            unwrapObservables: unwrapObservables
                        })
                    }
                    set(options, value, merge, silent) {
                        options = (0, _utils.normalizeOptions)(options, value);
                        for (const name in options) {
                            this._prepareRelevantNames(options, name, options[name], silent)
                        }
                        if (this._validateOptionsCallback) {
                            options = this._validateOptionsCallback(options)
                        }
                        for (const name in options) {
                            this._setPreparedValue(name, options[name], merge, silent)
                        }
                    }
                    onRelevantNamesPrepared(callBack) {
                        this._namePreparedCallbacks = callBack
                    }
                    onChanging(callBack) {
                        this._changingCallback = callBack
                    }
                    onChanged(callBack) {
                        this._changedCallback = callBack
                    }
                    onValidateOptions(callback) {
                        this._validateOptionsCallback = callback
                    }
                    dispose() {
                        this._changingCallback = _common.noop;
                        this._changedCallback = _common.noop
                    }
                }
            },
        33810:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/options/m_utils.js ***!
              \********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.normalizeOptions = exports.getParentName = exports.getNestedOptionValue = exports.getFieldName = exports.deviceMatch = exports.createDefaultOptionRules = exports.convertRulesToOptions = void 0;
                var _devices = (obj = __webpack_require__( /*! ../../../core/devices */ 65951), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _data = __webpack_require__( /*! ../../../core/utils/data */ 31e3);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                const cachedGetters = {};
                exports.convertRulesToOptions = rules => {
                    const currentDevice = _devices.default.current();
                    return rules.reduce(((options, _ref) => {
                        let {
                            device: device,
                            options: ruleOptions
                        } = _ref;
                        const deviceFilter = device || {};
                        const match = (0, _type.isFunction)(deviceFilter) ? deviceFilter(currentDevice) : deviceMatch(currentDevice, deviceFilter);
                        if (match) {
                            (0, _extend.extend)(true, options, ruleOptions)
                        }
                        return options
                    }), {})
                };
                exports.normalizeOptions = (options, value) => "string" !== typeof options ? options : {
                    [options]: value
                };
                const deviceMatch = (device, filter) => (0, _type.isEmptyObject)(filter) || (0, _common.findBestMatches)(device, [filter]).length > 0;
                exports.deviceMatch = deviceMatch;
                exports.getFieldName = fullName => fullName.substr(fullName.lastIndexOf(".") + 1);
                exports.getParentName = fullName => fullName.substr(0, fullName.lastIndexOf("."));
                exports.getNestedOptionValue = function(optionsObject, name) {
                    cachedGetters[name] = cachedGetters[name] || (0, _data.compileGetter)(name);
                    return cachedGetters[name](optionsObject, {
                        functionsAsIs: true
                    })
                };
                exports.createDefaultOptionRules = function() {
                    let options = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : [];
                    return options
                }
            },
        28112:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/base_props.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.BaseWidgetDefaultProps = void 0;
                exports.BaseWidgetDefaultProps = {
                    className: "",
                    activeStateEnabled: false,
                    disabled: false,
                    focusStateEnabled: false,
                    hoverStateEnabled: false,
                    tabIndex: 0,
                    visible: true
                }
            },
        34993:
            /*!*************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/component_wrapper.js ***!
              \*************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.ComponentWrapper = void 0;
                __webpack_require__( /*! ../../../events/click */ 73358);
                __webpack_require__( /*! ../../../events/core/emitter.feedback */ 34217);
                __webpack_require__( /*! ../../../events/hover */ 53952);
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../core/dom_adapter */ 64960));
                var _dom_component = _interopRequireDefault(__webpack_require__( /*! ../../../core/dom_component */ 97832));
                var _element = __webpack_require__( /*! ../../../core/element */ 61404);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _inferno = __webpack_require__( /*! inferno */ 81167);
                var _inferno_renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/inferno_renderer */ 16965));
                var _keyboard_processor = _interopRequireDefault(__webpack_require__( /*! ../../../events/core/keyboard_processor */ 4776));
                var _template_wrapper = __webpack_require__( /*! ./template_wrapper */ 34554);
                var _index = __webpack_require__( /*! ./utils/index */ 10632);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const setDefaultOptionValue = (options, defaultValueGetter) => name => {
                    if (Object.prototype.hasOwnProperty.call(options, name) && void 0 === options[name]) {
                        options[name] = defaultValueGetter(name)
                    }
                };
                class ComponentWrapper extends _dom_component.default {
                    get _propsInfo() {
                        return {
                            allowNull: [],
                            twoWay: [],
                            elements: [],
                            templates: [],
                            props: []
                        }
                    }
                    constructor(element, options) {
                        super(element, options);
                        this._shouldRaiseContentReady = false;
                        this.validateKeyDownHandler()
                    }
                    validateKeyDownHandler() {
                        const supportedKeyNames = this.getSupportedKeyNames();
                        const hasComponentDefaultKeyHandlers = supportedKeyNames.length > 0;
                        const hasComponentKeyDownMethod = "function" === typeof this._viewComponent.prototype.keyDown;
                        if (hasComponentDefaultKeyHandlers && !hasComponentKeyDownMethod) {
                            throw Error("Component's declaration must have 'keyDown' method.")
                        }
                    }
                    get viewRef() {
                        var _this$_viewRef;
                        return null === (_this$_viewRef = this._viewRef) || void 0 === _this$_viewRef ? void 0 : _this$_viewRef.current
                    }
                    _checkContentReadyOption(fullName) {
                        const contentReadyOptions = this._getContentReadyOptions().reduce(((options, name) => {
                            options[name] = true;
                            return options
                        }), {});
                        this._checkContentReadyOption = optionName => !!contentReadyOptions[optionName];
                        return this._checkContentReadyOption(fullName)
                    }
                    _getContentReadyOptions() {
                        return ["rtlEnabled"]
                    }
                    _fireContentReady() {
                        this._actionsMap.onContentReady({})
                    }
                    _getDefaultOptions() {
                        const viewDefaultProps = this._getViewComponentDefaultProps();
                        return (0, _extend.extend)(true, super._getDefaultOptions(), viewDefaultProps, this._propsInfo.twoWay.reduce(((options, _ref) => {
                            let [name, defaultName, eventName] = _ref;
                            return _extends({}, options, {
                                [name]: viewDefaultProps[defaultName],
                                [eventName]: value => this.option(name, value)
                            })
                        }), {}), this._propsInfo.templates.reduce(((options, name) => _extends({}, options, {
                            [name]: null
                        })), {}))
                    }
                    _getUnwrappedOption() {
                        const unwrappedProps = {};
                        Object.keys(this.option()).forEach((key => {
                            unwrappedProps[key] = this.option(key)
                        }));
                        return unwrappedProps
                    }
                    _initializeComponent() {
                        var _this$_templateManage;
                        super._initializeComponent();
                        null === (_this$_templateManage = this._templateManager) || void 0 === _this$_templateManage || _this$_templateManage.addDefaultTemplates(this.getDefaultTemplates());
                        const optionProxy = this._getUnwrappedOption();
                        this._props = this._optionsWithDefaultTemplates(optionProxy);
                        this._propsInfo.templates.forEach((template => {
                            this._componentTemplates[template] = this._createTemplateComponent(this._props[template])
                        }));
                        Object.keys(this._getActionConfigsFull()).forEach((name => this._addAction(name)));
                        this._viewRef = (0, _inferno.createRef)();
                        this.defaultKeyHandlers = this._createDefaultKeyHandlers()
                    }
                    _initMarkup() {
                        const props = this.getProps();
                        this._renderWrapper(props)
                    }
                    _renderWrapper(props) {
                        const containerNode = this.$element()[0];
                        if (!this._isNodeReplaced) {
                            _inferno_renderer.default.onPreRender()
                        }
                        _inferno_renderer.default.render(this._viewComponent, props, containerNode, this._isNodeReplaced);
                        if (!this._isNodeReplaced) {
                            this._isNodeReplaced = true;
                            _inferno_renderer.default.onAfterRender();
                            this._shouldRaiseContentReady = true
                        }
                        if (this._shouldRaiseContentReady) {
                            this._fireContentReady();
                            this._shouldRaiseContentReady = false
                        }
                    }
                    _silent(name, value) {
                        this._options.silent(name, value)
                    }
                    _render() {}
                    _removeWidget() {
                        _inferno_renderer.default.remove(this.$element()[0])
                    }
                    _dispose() {
                        this._removeWidget();
                        super._dispose()
                    }
                    get elementAttr() {
                        const element = this.$element()[0];
                        if (!this._elementAttr) {
                            const {
                                attributes: attributes
                            } = element;
                            const attrs = Array.from(attributes).filter((attr => {
                                var _attributes$attr$name;
                                return !this._propsInfo.templates.includes(attr.name) && (null === (_attributes$attr$name = attributes[attr.name]) || void 0 === _attributes$attr$name ? void 0 : _attributes$attr$name.specified)
                            })).reduce(((result, _ref2) => {
                                let {
                                    name: name,
                                    value: value
                                } = _ref2;
                                const updatedAttributes = result;
                                const isDomAttr = name in element;
                                updatedAttributes[name] = "" === value && isDomAttr ? element[name] : value;
                                return updatedAttributes
                            }), {});
                            this._elementAttr = attrs;
                            this._storedClasses = element.getAttribute("class") || ""
                        }
                        const elemStyle = element.style;
                        const style = {};
                        for (let i = 0; i < elemStyle.length; i += 1) {
                            style[elemStyle[i]] = elemStyle.getPropertyValue(elemStyle[i])
                        }
                        this._elementAttr.style = style;
                        this._elementAttr.class = this._storedClasses;
                        return this._elementAttr
                    }
                    _getAdditionalActionConfigs() {
                        return {
                            onContentReady: {
                                excludeValidators: ["disabled", "readOnly"]
                            }
                        }
                    }
                    _getAdditionalProps() {
                        return []
                    }
                    _patchOptionValues(options) {
                        const {
                            allowNull: allowNull,
                            twoWay: twoWay,
                            elements: elements,
                            props: props
                        } = this._propsInfo;
                        const viewDefaultProps = this._getViewComponentDefaultProps();
                        const defaultWidgetPropsKeys = Object.keys(viewDefaultProps);
                        const defaultOptions = this._getDefaultOptions();
                        const {
                            ref: ref,
                            children: children,
                            onKeyboardHandled: onKeyboardHandled
                        } = options;
                        const onKeyDown = onKeyboardHandled ? (_, event_options) => {
                            onKeyboardHandled(event_options)
                        } : void 0;
                        const widgetProps = {
                            ref: ref,
                            children: children,
                            onKeyDown: onKeyDown
                        };
                        [...props, ...this._getAdditionalProps()].forEach((propName => {
                            if (Object.prototype.hasOwnProperty.call(options, propName)) {
                                widgetProps[propName] = options[propName]
                            }
                        }));
                        allowNull.forEach(setDefaultOptionValue(widgetProps, (() => null)));
                        defaultWidgetPropsKeys.forEach(setDefaultOptionValue(widgetProps, (name => defaultOptions[name])));
                        twoWay.forEach((_ref3 => {
                            let [name, defaultName] = _ref3;
                            setDefaultOptionValue(widgetProps, (() => defaultOptions[defaultName]))(name)
                        }));
                        elements.forEach((name => {
                            if (name in widgetProps) {
                                const value = widgetProps[name];
                                if ((0, _type.isRenderer)(value)) {
                                    widgetProps[name] = this._patchElementParam(value)
                                }
                            }
                        }));
                        return widgetProps
                    }
                    getSupportedKeyNames() {
                        return []
                    }
                    prepareStyleProp(props) {
                        if ("string" === typeof props.style) {
                            return _extends({}, props, {
                                style: {},
                                cssText: props.style
                            })
                        }
                        return props
                    }
                    getProps() {
                        const {
                            elementAttr: elementAttr
                        } = this.option();
                        const options = this._patchOptionValues(_extends({}, this._props, {
                            ref: this._viewRef,
                            children: this._extractDefaultSlot(),
                            aria: this._aria
                        }));
                        this._propsInfo.templates.forEach((template => {
                            options[template] = this._componentTemplates[template]
                        }));
                        return this.prepareStyleProp(_extends({}, options, this.elementAttr, elementAttr, {
                            className: [...(this.elementAttr.class ?? "").split(" "), ...((null === elementAttr || void 0 === elementAttr ? void 0 : elementAttr.class) ?? "").split(" ")].filter(((c, i, a) => c && a.indexOf(c) === i)).join(" ").trim(),
                            class: ""
                        }, this._actionsMap))
                    }
                    _getActionConfigs() {
                        return {}
                    }
                    _getActionConfigsFull() {
                        return _extends({}, this._getActionConfigs(), this._getAdditionalActionConfigs())
                    }
                    getDefaultTemplates() {
                        const defaultTemplates = Object.values(this._templatesInfo);
                        const result = {};
                        defaultTemplates.forEach((template => {
                            result[template] = "dx-renovation-template-mock"
                        }));
                        return result
                    }
                    get _templatesInfo() {
                        return {}
                    }
                    _optionsWithDefaultTemplates(options) {
                        const templateOptions = Object.entries(this._templatesInfo).reduce(((result, _ref4) => {
                            let [templateName, templateValue] = _ref4;
                            return _extends({}, result, {
                                [templateName]: options[templateName] ?? templateValue
                            })
                        }), {});
                        return _extends({}, options, templateOptions)
                    }
                    _init() {
                        super._init();
                        this.customKeyHandlers = {};
                        this._actionsMap = {};
                        this._aria = {};
                        this._componentTemplates = {}
                    }
                    _createDefaultKeyHandlers() {
                        const result = {};
                        const keys = this.getSupportedKeyNames();
                        keys.forEach((key => {
                            result[key] = e => this.viewRef.keyDown(_keyboard_processor.default.createKeyDownOptions(e))
                        }));
                        return result
                    }
                    _addAction(event, actionToAdd) {
                        let action = actionToAdd;
                        if (!action) {
                            const actionByOption = this._createActionByOption(event, this._getActionConfigsFull()[event]);
                            action = actArgs => {
                                Object.keys(actArgs).forEach((name => {
                                    if ((0, _type.isDefined)(actArgs[name]) && _dom_adapter.default.isNode(actArgs[name])) {
                                        actArgs[name] = (0, _element.getPublicElement)((0, _renderer.default)(actArgs[name]))
                                    }
                                }));
                                return actionByOption(actArgs)
                            }
                        }
                        this._actionsMap[event] = action
                    }
                    _optionChanged(option) {
                        const {
                            name: name,
                            fullName: fullName,
                            value: value,
                            previousValue: previousValue
                        } = option;
                        (0, _index.updatePropsImmutable)(this._props, this.option(), name, fullName);
                        if (this._propsInfo.templates.includes(name) && value !== previousValue) {
                            this._componentTemplates[name] = this._createTemplateComponent(value)
                        }
                        if (name && this._getActionConfigsFull()[name]) {
                            this._addAction(name)
                        }
                        this._shouldRaiseContentReady = this._shouldRaiseContentReady || this._checkContentReadyOption(fullName);
                        super._optionChanged(option);
                        this._invalidate()
                    }
                    _validateOptions(options) {
                        return super._validateOptions(options)
                    }
                    _extractDefaultSlot() {
                        if (this.option("_hasAnonymousTemplateContent")) {
                            return _inferno_renderer.default.createElement(_template_wrapper.TemplateWrapper, {
                                template: this._getTemplate(this._templateManager.anonymousTemplateName),
                                transclude: true,
                                renovated: true
                            })
                        }
                        return null
                    }
                    _createTemplateComponent(templateOption) {
                        if (!templateOption) {
                            return
                        }
                        const template = this._getTemplate(templateOption);
                        if ((0, _type.isString)(template) && "dx-renovation-template-mock" === template) {
                            return
                        }
                        return model => _inferno_renderer.default.createElement(_template_wrapper.TemplateWrapper, (0, _template_wrapper.buildTemplateArgs)(model, template))
                    }
                    _wrapKeyDownHandler(initialHandler) {
                        return options => {
                            const {
                                originalEvent: originalEvent,
                                keyName: keyName,
                                which: which
                            } = options;
                            const keys = this.customKeyHandlers;
                            const func = keys[keyName] || keys[which];
                            if (void 0 !== func) {
                                const handler = func.bind(this);
                                const result = handler(originalEvent, options);
                                if (!result) {
                                    originalEvent.cancel = true;
                                    return originalEvent
                                }
                            }
                            return null === initialHandler || void 0 === initialHandler ? void 0 : initialHandler(originalEvent, options)
                        }
                    }
                    _toPublicElement(element) {
                        return (0, _element.getPublicElement)((0, _renderer.default)(element))
                    }
                    _patchElementParam(value) {
                        try {
                            const result = (0, _renderer.default)(value);
                            const element = null === result || void 0 === result ? void 0 : result.get(0);
                            return null !== element && void 0 !== element && element.nodeType ? element : value
                        } catch (error) {
                            return value
                        }
                    }
                    focus() {
                        const $root = this.$element();
                        const hasFocus = $root.is(":focus") || $root.find(":focus").length > 0;
                        if (hasFocus) {
                            return
                        }
                        if (this.option("focusStateEnabled")) {
                            $root.focus()
                        } else {
                            var _focusableElements$;
                            const focusableElements = $root.find("[tabindex]");
                            null === (_focusableElements$ = focusableElements[0]) || void 0 === _focusableElements$ || _focusableElements$.focus()
                        }
                    }
                    repaint() {
                        this._isNodeReplaced = false;
                        this._shouldRaiseContentReady = true;
                        this._removeWidget();
                        this._refresh()
                    }
                    _supportedKeys() {
                        return _extends({}, this.defaultKeyHandlers, this.customKeyHandlers)
                    }
                    registerKeyHandler(key, handler) {
                        this.customKeyHandlers[key] = handler
                    }
                    setAria(name, value) {
                        this._aria[name] = value;
                        this._initMarkup()
                    }
                    _getViewComponentDefaultProps() {
                        return this._viewComponent.defaultProps || {}
                    }
                }
                exports.ComponentWrapper = ComponentWrapper;
                ComponentWrapper.IS_RENOVATED_WIDGET = false;
                ComponentWrapper.IS_RENOVATED_WIDGET = true
            },
        12274:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/config_context.js ***!
              \**********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.ConfigContext = void 0;
                var _inferno = __webpack_require__( /*! @devextreme/runtime/inferno */ 49714);
                exports.ConfigContext = (0, _inferno.createContext)(void 0)
            },
        86688:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/config_provider.js ***!
              \***********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.ConfigProviderDefaultProps = exports.ConfigProvider = void 0;
                var _inferno = __webpack_require__( /*! @devextreme/runtime/inferno */ 49714);
                var _config_context = __webpack_require__( /*! ./config_context */ 12274);

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const ConfigProviderDefaultProps = exports.ConfigProviderDefaultProps = {};
                class ConfigProvider extends _inferno.BaseInfernoComponent {
                    constructor() {
                        super(...arguments);
                        this.state = {}
                    }
                    getConfig() {
                        return {
                            rtlEnabled: this.props.rtlEnabled
                        }
                    }
                    getChildContext() {
                        return _extends({}, this.context, {
                            [_config_context.ConfigContext.id]: this.getConfig() || _config_context.ConfigContext.defaultValue
                        })
                    }
                    render() {
                        return this.props.children
                    }
                }
                exports.ConfigProvider = ConfigProvider;
                ConfigProvider.defaultProps = ConfigProviderDefaultProps
            },
        10922:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/dom_component_wrapper.js ***!
              \*****************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.DomComponentWrapper = void 0;
                var _inferno = __webpack_require__( /*! inferno */ 81167);
                var _inferno2 = __webpack_require__( /*! @devextreme/runtime/inferno */ 49714);
                var _get_updated_options = __webpack_require__( /*! ../../core/r1/utils/get_updated_options */ 15393);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _config_context = __webpack_require__( /*! ./config_context */ 12274);
                const _excluded = ["componentProps", "componentType", "templateNames"];

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const normalizeProps = props => Object.keys(props).reduce(((accumulator, key) => {
                    if (void 0 !== props[key]) {
                        accumulator[key] = props[key]
                    }
                    return accumulator
                }), {});
                class DomComponentWrapper extends _inferno2.InfernoComponent {
                    constructor(props) {
                        super(props);
                        this.state = {};
                        this.refs = null;
                        this.widgetRef = (0, _inferno.createRef)();
                        this.instance = null;
                        this.prevProps = null;
                        this.getInstance = this.getInstance.bind(this);
                        this.setupWidget = this.setupWidget.bind(this);
                        this.updateWidget = this.updateWidget.bind(this)
                    }
                    getConfig() {
                        const {
                            id: id
                        } = _config_context.ConfigContext;
                        if (this.context[id]) {
                            return this.context[id]
                        }
                        return _config_context.ConfigContext.defaultValue
                    }
                    render() {
                        return normalizeProps((0, _inferno.createVNode)(1, "div", this.props.componentProps.className, null, 1, _extends({}, this.getRestAttributes()), null, this.widgetRef))
                    }
                    componentWillUpdate(nextProps, nextState, context) {
                        super.componentWillUpdate(nextProps, nextState, context)
                    }
                    createEffects() {
                        return [new _inferno2.InfernoEffect(this.setupWidget, []), new _inferno2.InfernoEffect(this.updateWidget, [this.props.componentProps, this.getConfig(), this.props.templateNames])]
                    }
                    updateEffects() {
                        var _this$_effects$;
                        const dependency = [this.props.componentProps, this.getConfig(), this.props.templateNames];
                        null === (_this$_effects$ = this._effects[1]) || void 0 === _this$_effects$ || _this$_effects$.update(dependency)
                    }
                    setupWidget() {
                        const current = this.widgetRef.current;
                        const componentInstance = new this.props.componentType(current, this.getProperties());
                        this.instance = componentInstance;
                        return () => {
                            componentInstance.dispose();
                            this.instance = null
                        }
                    }
                    updateWidget() {
                        if (!this.instance) {
                            return
                        }
                        const updatedOptions = (0, _get_updated_options.getUpdatedOptions)(this.prevProps ?? {}, this.getProperties());
                        if (updatedOptions.length) {
                            this.instance.beginUpdate();
                            updatedOptions.forEach((_ref2 => {
                                var _this$instance;
                                const {
                                    path: path,
                                    value: value
                                } = _ref2;
                                null === (_this$instance = this.instance) || void 0 === _this$instance || _this$instance.option(path, value)
                            }));
                            this.instance.endUpdate()
                        }
                        this.prevProps = this.getProperties()
                    }
                    getRestAttributes() {
                        const _this$props = this.props,
                            restAttr = function(source, excluded) {
                                if (null == source) {
                                    return {}
                                }
                                var target = {};
                                for (var key in source) {
                                    if (Object.prototype.hasOwnProperty.call(source, key)) {
                                        if (excluded.indexOf(key) >= 0) {
                                            continue
                                        }
                                        target[key] = source[key]
                                    }
                                }
                                return target
                            }(_this$props, _excluded);
                        return restAttr
                    }
                    getProperties() {
                        var _this$getConfig;
                        const normalizedProps = normalizeProps(this.props.componentProps);
                        const {
                            valueChange: valueChange
                        } = normalizedProps;
                        const properties = (0, _extend.extend)({
                            rtlEnabled: null === (_this$getConfig = this.getConfig()) || void 0 === _this$getConfig ? void 0 : _this$getConfig.rtlEnabled,
                            isRenovated: true
                        }, normalizedProps);
                        if (valueChange) {
                            properties.onValueChanged = _ref3 => {
                                const {
                                    value: value
                                } = _ref3;
                                return valueChange(value)
                            }
                        }
                        const templates = this.props.templateNames;
                        templates.forEach((name => {
                            if ((0, _inferno2.hasTemplate)(name, properties, this)) {
                                properties[name] = (item, index, container) => {
                                    (0, _inferno2.renderTemplate)(this.props.componentProps[name], {
                                        item: item,
                                        index: index,
                                        container: container
                                    }, this)
                                }
                            }
                        }));
                        return properties
                    }
                    getInstance() {
                        return this.instance
                    }
                }
                exports.DomComponentWrapper = DomComponentWrapper
            },
        84766:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/index.js ***!
              \*************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                Object.defineProperty(exports, "ComponentWrapper", {
                    enumerable: true,
                    get: function() {
                        return _component_wrapper.ComponentWrapper
                    }
                });
                var _component_wrapper = __webpack_require__( /*! ./component_wrapper */ 34993)
            },
        34554:
            /*!************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/template_wrapper.js ***!
              \************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.buildTemplateArgs = exports.TemplateWrapper = void 0;
                var _inferno = __webpack_require__( /*! @devextreme/runtime/inferno */ 49714);
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../core/dom_adapter */ 64960));
                var _element = __webpack_require__( /*! ../../../core/element */ 61404);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _dom = __webpack_require__( /*! ../../../core/utils/dom */ 86858);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _inferno2 = __webpack_require__( /*! inferno */ 81167);
                var _shallow_equals = __webpack_require__( /*! ./utils/shallow_equals */ 1270);
                const _excluded = ["isEqual"];

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                exports.buildTemplateArgs = (model, template) => {
                    const args = {
                        template: template,
                        model: _extends({}, model)
                    };
                    const _ref = model.data ?? {},
                        {
                            isEqual: isEqual
                        } = _ref,
                        data = function(source, excluded) {
                            if (null == source) {
                                return {}
                            }
                            var target = {};
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    if (excluded.indexOf(key) >= 0) {
                                        continue
                                    }
                                    target[key] = source[key]
                                }
                            }
                            return target
                        }(_ref, _excluded);
                    if (isEqual) {
                        args.model.data = data;
                        args.isEqual = isEqual
                    }
                    return args
                };
                class TemplateWrapper extends _inferno.InfernoComponent {
                    constructor(props) {
                        super(props);
                        this.renderTemplate = this.renderTemplate.bind(this)
                    }
                    renderTemplate() {
                        const node = (0, _inferno2.findDOMfromVNode)(this.$LI, true);
                        if (!(null !== node && void 0 !== node && node.parentNode)) {
                            return () => {}
                        }
                        const container = node.parentNode;
                        const $container = (0, _renderer.default)(container);
                        const $oldContainerContent = $container.contents().toArray();
                        const content = ((props, container) => {
                            const {
                                data: data,
                                index: index
                            } = props.model ?? {
                                data: {}
                            };
                            if (data) {
                                Object.keys(data).forEach((name => {
                                    if (data[name] && _dom_adapter.default.isNode(data[name])) {
                                        data[name] = (0, _element.getPublicElement)((0, _renderer.default)(data[name]))
                                    }
                                }))
                            }
                            const rendered = props.template.render(_extends({
                                container: container,
                                transclude: props.transclude
                            }, {
                                renovated: props.renovated
                            }, !props.transclude ? {
                                model: data
                            } : {}, !props.transclude && Number.isFinite(index) ? {
                                index: index
                            } : {}));
                            if (void 0 === rendered) {
                                return []
                            }
                            return (element = rendered, !!element.toArray) ? rendered.toArray() : [(0, _renderer.default)(rendered).get(0)];
                            var element
                        })(this.props, (0, _element.getPublicElement)($container));
                        (0, _dom.replaceWith)((0, _renderer.default)(node), (0, _renderer.default)(content));
                        return () => {
                            const $actualContainerContent = (0, _renderer.default)(container).contents().toArray();
                            oldChildren = $oldContainerContent, newChildren = $actualContainerContent, void newChildren.forEach((newElement => {
                                const hasOldChild = !!oldChildren.find((oldElement => newElement === oldElement));
                                if (!hasOldChild && newElement.parentNode) {
                                    (0, _renderer.default)(newElement).remove()
                                }
                            }));
                            var oldChildren, newChildren;
                            container.appendChild(node)
                        }
                    }
                    shouldComponentUpdate(nextProps) {
                        const {
                            template: template,
                            model: model
                        } = this.props;
                        const {
                            template: nextTemplate,
                            model: nextModel,
                            isEqual: isEqual
                        } = nextProps;
                        const equalityComparer = isEqual ?? _shallow_equals.shallowEquals;
                        if (template !== nextTemplate) {
                            return true
                        }
                        if (!(0, _type.isDefined)(model) || !(0, _type.isDefined)(nextModel)) {
                            return model !== nextModel
                        }
                        const {
                            data: data,
                            index: index
                        } = model;
                        const {
                            data: nextData,
                            index: nextIndex
                        } = nextModel;
                        if (index !== nextIndex) {
                            return true
                        }
                        return !equalityComparer(data, nextData)
                    }
                    createEffects() {
                        return [new _inferno.InfernoEffect(this.renderTemplate, [this.props.template, this.props.model])]
                    }
                    updateEffects() {
                        this._effects[0].update([this.props.template, this.props.model])
                    }
                    componentWillUnmount() {}
                    render() {
                        return null
                    }
                }
                exports.TemplateWrapper = TemplateWrapper
            },
        8808:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/utils/dom.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.querySelectorInSameDocument = function(el, selector) {
                    var _el$getRootNode;
                    const root = (null === (_el$getRootNode = el.getRootNode) || void 0 === _el$getRootNode ? void 0 : _el$getRootNode.call(el)) ?? document;
                    return root.querySelector(selector)
                }
            },
        31006:
            /*!********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/utils/get_computed_style.js ***!
              \********************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = function(el) {
                    var _window$getComputedSt;
                    const window = (0, _window.getWindow)();
                    return el ? null === (_window$getComputedSt = window.getComputedStyle) || void 0 === _window$getComputedSt ? void 0 : _window$getComputedSt.call(window, el) : null
                };
                var _window = __webpack_require__( /*! ../../../../core/utils/window */ 3104)
            },
        6909:
            /*!**************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/utils/get_template.js ***!
              \**************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getTemplate = void 0;
                var _inferno = __webpack_require__( /*! inferno */ 81167);

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                exports.getTemplate = TemplateProp => TemplateProp && (TemplateProp.defaultProps ? props => (0, _inferno.normalizeProps)((0, _inferno.createComponentVNode)(2, TemplateProp, _extends({}, props))) : TemplateProp)
            },
        15393:
            /*!*********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/utils/get_updated_options.js ***!
              \*********************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getUpdatedOptions = function(oldProps, props) {
                    let notDeepCopyArrays = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : defaultNotDeepCopyArrays;
                    return objectDiffsWithoutReactProps(oldProps, props, "", notDeepCopyArrays)
                };
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 11528);

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const defaultNotDeepCopyArrays = ["dataSource", "selectedRowKeys"];
                const propsToIgnore = {
                    integrationOptions: true
                };

                function getDiffItem(key, value, previousValue) {
                    return {
                        path: key,
                        value: value,
                        previousValue: previousValue
                    }
                }

                function compare(resultPaths, item1, item2, key, fullPropName, notDeepCopyArrays) {
                    if (propsToIgnore[key]) {
                        return
                    }
                    const type1 = (0, _type.type)(item1);
                    const type2 = (0, _type.type)(item2);
                    if (item1 === item2) {
                        return
                    }
                    if (type1 !== type2) {
                        resultPaths.push(getDiffItem(key, item2, item1))
                    } else if ("object" === type1) {
                        if (!(0, _type.isPlainObject)(item2)) {
                            resultPaths.push(getDiffItem(key, item2, item1))
                        } else {
                            const diffPaths = objectDiffs(item1, item2, fullPropName, notDeepCopyArrays);
                            resultPaths.push(...diffPaths.map((item => _extends({}, item, {
                                path: `${key}.${item.path}`
                            }))))
                        }
                    } else if ("array" === type1) {
                        const notDeepCopy = notDeepCopyArrays.some((prop => fullPropName.includes(prop)));
                        if (notDeepCopy && item1 !== item2) {
                            resultPaths.push(getDiffItem(key, item2, item1))
                        } else if (item1.length !== item2.length) {
                            resultPaths.push(getDiffItem(key, item2, item1))
                        } else {
                            const diffPaths = objectDiffs(item1, item2, fullPropName, notDeepCopyArrays);
                            [].push.apply(resultPaths, diffPaths.map((item => _extends({}, item, {
                                path: `${key}${item.path}`
                            }))))
                        }
                    } else {
                        resultPaths.push(getDiffItem(key, item2, item1))
                    }
                }
                const objectDiffsFiltered = propsEnumerator => (oldProps, props, fullPropName, notDeepCopyArrays) => {
                    const resultPaths = [];
                    const processItem = !Array.isArray(oldProps) ? propName => {
                        compare(resultPaths, oldProps[propName], props[propName], propName, `${fullPropName}.${propName}`, notDeepCopyArrays)
                    } : propName => {
                        compare(resultPaths, oldProps[propName], props[propName], `[${propName}]`, `${fullPropName}.${propName}`, notDeepCopyArrays)
                    };
                    propsEnumerator(oldProps).forEach(processItem);
                    Object.keys(props).filter((propName => !Object.prototype.hasOwnProperty.call(oldProps, propName) && oldProps[propName] !== props[propName])).forEach((propName => {
                        resultPaths.push({
                            path: propName,
                            value: props[propName],
                            previousValue: oldProps[propName]
                        })
                    }));
                    return resultPaths
                };
                const objectDiffs = objectDiffsFiltered((oldProps => Object.keys(oldProps)));
                const reactProps = {
                    key: true,
                    ref: true,
                    children: true,
                    style: true
                };
                const objectDiffsWithoutReactProps = objectDiffsFiltered((prop => Object.keys(prop).filter((p => !reactProps[p]))))
            },
        10632:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/utils/index.js ***!
              \*******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                Object.defineProperty(exports, "getTemplate", {
                    enumerable: true,
                    get: function() {
                        return _get_template.getTemplate
                    }
                });
                Object.defineProperty(exports, "shallowEquals", {
                    enumerable: true,
                    get: function() {
                        return _shallow_equals.shallowEquals
                    }
                });
                Object.defineProperty(exports, "updatePropsImmutable", {
                    enumerable: true,
                    get: function() {
                        return _update_props_immutable.updatePropsImmutable
                    }
                });
                var _get_template = __webpack_require__( /*! ./get_template */ 6909);
                var _shallow_equals = __webpack_require__( /*! ./shallow_equals */ 1270);
                var _update_props_immutable = __webpack_require__( /*! ./update_props_immutable */ 73725)
            },
        71312:
            /*!**************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/utils/render_utils.js ***!
              \**************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.combineClasses = void 0;
                exports.combineClasses = classesMap => Object.keys(classesMap).filter((cssClass => !!cssClass && classesMap[cssClass])).join(" ")
            },
        28477:
            /*!*************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/utils/resolve_rtl.js ***!
              \*************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.resolveRtlEnabled = function(rtlProp, config) {
                    if (void 0 !== rtlProp) {
                        return rtlProp
                    }
                    if (void 0 !== (null === config || void 0 === config ? void 0 : config.rtlEnabled)) {
                        return config.rtlEnabled
                    }
                    return (0, _config.default)().rtlEnabled
                };
                exports.resolveRtlEnabledDefinition = function(rtlProp, config) {
                    const isPropDefined = (0, _type.isDefined)(rtlProp);
                    const onlyGlobalDefined = (0, _type.isDefined)((0, _config.default)().rtlEnabled) && !isPropDefined && !(0, _type.isDefined)(null === config || void 0 === config ? void 0 : config.rtlEnabled);
                    return isPropDefined && rtlProp !== (null === config || void 0 === config ? void 0 : config.rtlEnabled) || onlyGlobalDefined
                };
                var _config = (obj = __webpack_require__( /*! ../../../../core/config */ 66636), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 11528)
            },
        1270:
            /*!****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/utils/shallow_equals.js ***!
              \****************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.shallowEquals = void 0;
                exports.shallowEquals = (firstObject, secondObject) => {
                    if (Object.keys(firstObject).length !== Object.keys(secondObject).length) {
                        return false
                    }
                    return Object.keys(firstObject).every((key => firstObject[key] === secondObject[key]))
                }
            },
        28677:
            /*!********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/utils/subscribe_to_event.js ***!
              \********************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.subscribeToDxInactiveEvent = exports.subscribeToDxHoverStartEvent = exports.subscribeToDxHoverEndEvent = exports.subscribeToDxFocusOutEvent = exports.subscribeToDxFocusInEvent = exports.subscribeToDxActiveEvent = exports.subscribeToDXScrollStopEvent = exports.subscribeToDXScrollStartEvent = exports.subscribeToDXScrollMoveEvent = exports.subscribeToDXScrollEndEvent = exports.subscribeToDXScrollCancelEvent = exports.subscribeToDXPointerUpEvent = exports.subscribeToDXPointerMoveEvent = exports.subscribeToDXPointerDownEvent = exports.subscribeToClickEvent = void 0;
                exports.subscribeToEvent = subscribeToEvent;
                exports.subscribeToScrollInitEvent = exports.subscribeToScrollEvent = exports.subscribeToMouseLeaveEvent = exports.subscribeToMouseEnterEvent = exports.subscribeToKeyDownEvent = void 0;
                var clickEvent = function(e, r) {
                    if (!r && e && e.__esModule) {
                        return e
                    }
                    if (null === e || "object" != typeof e && "function" != typeof e) {
                        return {
                            default: e
                        }
                    }
                    var t = _getRequireWildcardCache(r);
                    if (t && t.has(e)) {
                        return t.get(e)
                    }
                    var n = {
                            __proto__: null
                        },
                        a = Object.defineProperty && Object.getOwnPropertyDescriptor;
                    for (var u in e) {
                        if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
                            var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
                            i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]
                        }
                    }
                    return n.default = e, t && t.set(e, n), n
                }(__webpack_require__( /*! ../../../../events/click */ 73358));
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../../events/core/events_engine */ 76772));
                var _emitterGesture = _interopRequireDefault(__webpack_require__( /*! ../../../../events/gesture/emitter.gesture.scroll */ 92166));
                var _pointer = _interopRequireDefault(__webpack_require__( /*! ../../../../events/pointer */ 25895));
                var _index = __webpack_require__( /*! ../../../../events/utils/index */ 34356);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _getRequireWildcardCache(e) {
                    if ("function" != typeof WeakMap) {
                        return null
                    }
                    var r = new WeakMap,
                        t = new WeakMap;
                    return (_getRequireWildcardCache = function(e) {
                        return e ? t : r
                    })(e)
                }

                function subscribeToEvent(eventName) {
                    return (element, handler, eventData, namespace) => {
                        const event = namespace ? (0, _index.addNamespace)(eventName, namespace) : eventName;
                        if (handler) {
                            _events_engine.default.on(element, event, eventData, handler);
                            return () => {
                                _events_engine.default.off(element, event, handler)
                            }
                        }
                        return
                    }
                }
                exports.subscribeToClickEvent = subscribeToEvent(clickEvent.name);
                exports.subscribeToScrollEvent = subscribeToEvent(_emitterGesture.default.scroll);
                exports.subscribeToScrollInitEvent = subscribeToEvent(_emitterGesture.default.init);
                exports.subscribeToDXScrollStartEvent = subscribeToEvent(_emitterGesture.default.start);
                exports.subscribeToDXScrollMoveEvent = subscribeToEvent(_emitterGesture.default.move);
                exports.subscribeToDXScrollEndEvent = subscribeToEvent(_emitterGesture.default.end);
                exports.subscribeToDXScrollStopEvent = subscribeToEvent(_emitterGesture.default.stop);
                exports.subscribeToDXScrollCancelEvent = subscribeToEvent(_emitterGesture.default.cancel);
                exports.subscribeToDXPointerDownEvent = subscribeToEvent(_pointer.default.down);
                exports.subscribeToDXPointerUpEvent = subscribeToEvent(_pointer.default.up);
                exports.subscribeToDXPointerMoveEvent = subscribeToEvent(_pointer.default.move);
                exports.subscribeToMouseEnterEvent = subscribeToEvent("mouseenter");
                exports.subscribeToMouseLeaveEvent = subscribeToEvent("mouseleave");
                exports.subscribeToKeyDownEvent = subscribeToEvent("keydown");
                exports.subscribeToDxActiveEvent = subscribeToEvent("dxactive");
                exports.subscribeToDxInactiveEvent = subscribeToEvent("dxinactive");
                exports.subscribeToDxHoverStartEvent = subscribeToEvent("dxhoverstart");
                exports.subscribeToDxHoverEndEvent = subscribeToEvent("dxhoverend");
                exports.subscribeToDxFocusInEvent = subscribeToEvent("focusin");
                exports.subscribeToDxFocusOutEvent = subscribeToEvent("focusout")
            },
        7529:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/utils/type_conversion.js ***!
              \*****************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.toNumber = function(attribute) {
                    return attribute ? Number(attribute.replace("px", "")) : 0
                }
            },
        73725:
            /*!************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/utils/update_props_immutable.js ***!
              \************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.updatePropsImmutable = void 0;
                var _data = __webpack_require__( /*! ../../../../core/utils/data */ 31e3);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 11528);

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const cloneObjectValue = value => Array.isArray(value) ? [...value] : _extends({}, value);
                const cloneObjectProp = (value, prevValue, fullNameParts) => {
                    const result = fullNameParts.length > 0 && prevValue && value !== prevValue ? cloneObjectValue(prevValue) : cloneObjectValue(value);
                    const name = fullNameParts[0];
                    if (fullNameParts.length > 1) {
                        result[name] = cloneObjectProp(value[name], null === prevValue || void 0 === prevValue ? void 0 : prevValue[name], fullNameParts.slice(1))
                    } else if (name) {
                        if ((0, _type.isPlainObject)(value[name])) {
                            result[name] = cloneObjectValue(value[name])
                        } else {
                            result[name] = value[name]
                        }
                    }
                    return result
                };
                exports.updatePropsImmutable = (props, option, name, fullName) => {
                    const currentPropsValue = option[name];
                    const prevPropsValue = props[name];
                    const result = props;
                    if ((0, _type.isPlainObject)(currentPropsValue) || name !== fullName && Array.isArray(currentPropsValue)) {
                        result[name] = cloneObjectProp(currentPropsValue, prevPropsValue, (0, _data.getPathParts)(fullName).slice(1))
                    } else {
                        result[name] = currentPropsValue
                    }
                }
            },
        93796:
            /*!**************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/widget.js ***!
              \**************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.WidgetDefaultProps = exports.Widget = void 0;
                var _inferno = __webpack_require__( /*! inferno */ 81167);
                __webpack_require__( /*! ../../../events/click */ 73358);
                __webpack_require__( /*! ../../../events/hover */ 53952);
                var _inferno2 = __webpack_require__( /*! @devextreme/runtime/inferno */ 49714);
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../core/dom_adapter */ 64960));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../../../core/errors */ 87129));
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _resize_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/resize_callbacks */ 63283));
                var _style = __webpack_require__( /*! ../../../core/utils/style */ 58515);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _short = __webpack_require__( /*! ../../../events/short */ 67960);
                var _config_context = __webpack_require__( /*! ../../core/r1/config_context */ 12274);
                var _config_provider = __webpack_require__( /*! ../../core/r1/config_provider */ 86688);
                var _render_utils = __webpack_require__( /*! ../../core/r1/utils/render_utils */ 71312);
                var _resolve_rtl = __webpack_require__( /*! ../../core/r1/utils/resolve_rtl */ 28477);
                var _base_props = __webpack_require__( /*! ./base_props */ 28112);
                var _subscribe_to_event = __webpack_require__( /*! ./utils/subscribe_to_event */ 28677);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const WidgetDefaultProps = exports.WidgetDefaultProps = _extends({}, _base_props.BaseWidgetDefaultProps, {
                    _feedbackHideTimeout: 400,
                    _feedbackShowTimeout: 30,
                    cssText: "",
                    aria: {},
                    classes: "",
                    name: "",
                    addWidgetClass: true
                });
                class Widget extends _inferno2.InfernoWrapperComponent {
                    constructor(props) {
                        super(props);
                        this.state = {
                            active: false,
                            focused: false,
                            hovered: false
                        };
                        this.refs = null;
                        this.rootElementRef = (0, _inferno.createRef)();
                        this.widgetElementRef = (0, _inferno.createRef)();
                        this.setRootElementRef = this.setRootElementRef.bind(this);
                        this.activeEffect = this.activeEffect.bind(this);
                        this.inactiveEffect = this.inactiveEffect.bind(this);
                        this.clickEffect = this.clickEffect.bind(this);
                        this.focus = this.focus.bind(this);
                        this.blur = this.blur.bind(this);
                        this.activate = this.activate.bind(this);
                        this.deactivate = this.deactivate.bind(this);
                        this.focusInEffect = this.focusInEffect.bind(this);
                        this.focusOutEffect = this.focusOutEffect.bind(this);
                        this.hoverStartEffect = this.hoverStartEffect.bind(this);
                        this.hoverEndEffect = this.hoverEndEffect.bind(this);
                        this.keyboardEffect = this.keyboardEffect.bind(this);
                        this.resizeEffect = this.resizeEffect.bind(this);
                        this.windowResizeEffect = this.windowResizeEffect.bind(this);
                        this.visibilityEffect = this.visibilityEffect.bind(this);
                        this.checkDeprecation = this.checkDeprecation.bind(this);
                        this.applyCssTextEffect = this.applyCssTextEffect.bind(this)
                    }
                    componentWillUpdate(nextProps, nextState, context) {
                        super.componentWillUpdate(nextProps, nextState, context)
                    }
                    getConfig() {
                        if (this.context[_config_context.ConfigContext.id]) {
                            return this.context[_config_context.ConfigContext.id]
                        }
                        return _config_context.ConfigContext.defaultValue
                    }
                    createEffects() {
                        return [new _inferno2.InfernoEffect(this.setRootElementRef, []), new _inferno2.InfernoEffect(this.activeEffect, [this.props._feedbackShowTimeout, this.props.activeStateEnabled, this.props.activeStateUnit, this.props.disabled, this.props.onActive]), new _inferno2.InfernoEffect(this.inactiveEffect, [this.props._feedbackHideTimeout, this.props.activeStateEnabled, this.props.activeStateUnit, this.props.onInactive, this.state.active]), new _inferno2.InfernoEffect(this.clickEffect, [this.props.disabled, this.props.name, this.props.onClick]), new _inferno2.InfernoEffect(this.focusInEffect, [this.props.disabled, this.props.focusStateEnabled, this.props.name, this.props.onFocusIn]), new _inferno2.InfernoEffect(this.focusOutEffect, [this.props.focusStateEnabled, this.props.name, this.props.onFocusOut, this.state.focused]), new _inferno2.InfernoEffect(this.hoverStartEffect, [this.props.activeStateUnit, this.props.disabled, this.props.hoverStateEnabled, this.props.onHoverStart, this.state.active]), new _inferno2.InfernoEffect(this.hoverEndEffect, [this.props.activeStateUnit, this.props.hoverStateEnabled, this.props.onHoverEnd, this.state.hovered]), new _inferno2.InfernoEffect(this.keyboardEffect, [this.props.focusStateEnabled, this.props.onKeyDown]), new _inferno2.InfernoEffect(this.resizeEffect, [this.props.name, this.props.onDimensionChanged]), new _inferno2.InfernoEffect(this.windowResizeEffect, [this.props.onDimensionChanged]), new _inferno2.InfernoEffect(this.visibilityEffect, [this.props.name, this.props.onVisibilityChange]), new _inferno2.InfernoEffect(this.checkDeprecation, [this.props.height, this.props.width]), new _inferno2.InfernoEffect(this.applyCssTextEffect, [this.props.cssText]), (0, _inferno2.createReRenderEffect)()]
                    }
                    updateEffects() {
                        var _this$_effects$, _this$_effects$2, _this$_effects$3, _this$_effects$4, _this$_effects$5, _this$_effects$6, _this$_effects$7, _this$_effects$8, _this$_effects$9, _this$_effects$10, _this$_effects$11, _this$_effects$12, _this$_effects$13;
                        null === (_this$_effects$ = this._effects[1]) || void 0 === _this$_effects$ || _this$_effects$.update([this.props._feedbackShowTimeout, this.props.activeStateEnabled, this.props.activeStateUnit, this.props.disabled, this.props.onActive]);
                        null === (_this$_effects$2 = this._effects[2]) || void 0 === _this$_effects$2 || _this$_effects$2.update([this.props._feedbackHideTimeout, this.props.activeStateEnabled, this.props.activeStateUnit, this.props.onInactive, this.state.active]);
                        null === (_this$_effects$3 = this._effects[3]) || void 0 === _this$_effects$3 || _this$_effects$3.update([this.props.disabled, this.props.name, this.props.onClick]);
                        null === (_this$_effects$4 = this._effects[4]) || void 0 === _this$_effects$4 || _this$_effects$4.update([this.props.disabled, this.props.focusStateEnabled, this.props.name, this.props.onFocusIn]);
                        null === (_this$_effects$5 = this._effects[5]) || void 0 === _this$_effects$5 || _this$_effects$5.update([this.props.focusStateEnabled, this.props.name, this.props.onFocusOut, this.state.focused]);
                        null === (_this$_effects$6 = this._effects[6]) || void 0 === _this$_effects$6 || _this$_effects$6.update([this.props.activeStateUnit, this.props.disabled, this.props.hoverStateEnabled, this.props.onHoverStart, this.state.active]);
                        null === (_this$_effects$7 = this._effects[7]) || void 0 === _this$_effects$7 || _this$_effects$7.update([this.props.activeStateUnit, this.props.hoverStateEnabled, this.props.onHoverEnd, this.state.hovered]);
                        null === (_this$_effects$8 = this._effects[8]) || void 0 === _this$_effects$8 || _this$_effects$8.update([this.props.focusStateEnabled, this.props.onKeyDown]);
                        null === (_this$_effects$9 = this._effects[9]) || void 0 === _this$_effects$9 || _this$_effects$9.update([this.props.name, this.props.onDimensionChanged]);
                        null === (_this$_effects$10 = this._effects[10]) || void 0 === _this$_effects$10 || _this$_effects$10.update([this.props.onDimensionChanged]);
                        null === (_this$_effects$11 = this._effects[11]) || void 0 === _this$_effects$11 || _this$_effects$11.update([this.props.name, this.props.onVisibilityChange]);
                        null === (_this$_effects$12 = this._effects[12]) || void 0 === _this$_effects$12 || _this$_effects$12.update([this.props.height, this.props.width]);
                        null === (_this$_effects$13 = this._effects[13]) || void 0 === _this$_effects$13 || _this$_effects$13.update([this.props.cssText])
                    }
                    setRootElementRef() {
                        var _this$widgetElementRe;
                        const {
                            rootElementRef: rootElementRef,
                            onRootElementRendered: onRootElementRendered
                        } = this.props;
                        if (rootElementRef && this.widgetElementRef) {
                            rootElementRef.current = this.widgetElementRef.current
                        }
                        if (null !== this && void 0 !== this && null !== (_this$widgetElementRe = this.widgetElementRef) && void 0 !== _this$widgetElementRe && _this$widgetElementRe.current) {
                            null === onRootElementRendered || void 0 === onRootElementRendered || onRootElementRendered(this.widgetElementRef.current)
                        }
                    }
                    activeEffect() {
                        const {
                            activeStateEnabled: activeStateEnabled,
                            activeStateUnit: activeStateUnit,
                            disabled: disabled,
                            _feedbackShowTimeout: _feedbackShowTimeout,
                            onActive: onActive
                        } = this.props;
                        const selector = activeStateUnit;
                        if (activeStateEnabled) {
                            if (!disabled) {
                                var _this$widgetElementRe2;
                                return (0, _subscribe_to_event.subscribeToDxActiveEvent)(null === (_this$widgetElementRe2 = this.widgetElementRef) || void 0 === _this$widgetElementRe2 ? void 0 : _this$widgetElementRe2.current, (event => {
                                    this.setState({
                                        active: true
                                    });
                                    null === onActive || void 0 === onActive || onActive(event)
                                }), {
                                    timeout: _feedbackShowTimeout,
                                    selector: selector
                                }, "UIFeedback")
                            }
                        }
                        return
                    }
                    inactiveEffect() {
                        const {
                            activeStateEnabled: activeStateEnabled,
                            activeStateUnit: activeStateUnit,
                            _feedbackHideTimeout: _feedbackHideTimeout,
                            onInactive: onInactive
                        } = this.props;
                        const selector = activeStateUnit;
                        if (activeStateEnabled) {
                            var _this$widgetElementRe3;
                            return (0, _subscribe_to_event.subscribeToDxInactiveEvent)(null === (_this$widgetElementRe3 = this.widgetElementRef) || void 0 === _this$widgetElementRe3 ? void 0 : _this$widgetElementRe3.current, (event => {
                                if (this.state.active) {
                                    this.setState({
                                        active: false
                                    });
                                    null === onInactive || void 0 === onInactive || onInactive(event)
                                }
                            }), {
                                timeout: _feedbackHideTimeout,
                                selector: selector
                            }, "UIFeedback")
                        }
                        return
                    }
                    clickEffect() {
                        const {
                            name: name,
                            onClick: onClick,
                            disabled: disabled
                        } = this.props;
                        const namespace = name;
                        if (onClick && !disabled) {
                            var _this$widgetElementRe4;
                            _short.dxClick.on(null === (_this$widgetElementRe4 = this.widgetElementRef) || void 0 === _this$widgetElementRe4 ? void 0 : _this$widgetElementRe4.current, onClick, {
                                namespace: namespace
                            });
                            return () => {
                                var _this$widgetElementRe5;
                                return _short.dxClick.off(null === (_this$widgetElementRe5 = this.widgetElementRef) || void 0 === _this$widgetElementRe5 ? void 0 : _this$widgetElementRe5.current, {
                                    namespace: namespace
                                })
                            }
                        }
                        return
                    }
                    focusInEffect() {
                        const {
                            disabled: disabled,
                            focusStateEnabled: focusStateEnabled,
                            name: name,
                            onFocusIn: onFocusIn
                        } = this.props;
                        const namespace = `${name}Focus`;
                        if (focusStateEnabled) {
                            if (!disabled) {
                                var _this$widgetElementRe6;
                                return (0, _subscribe_to_event.subscribeToDxFocusInEvent)(null === (_this$widgetElementRe6 = this.widgetElementRef) || void 0 === _this$widgetElementRe6 ? void 0 : _this$widgetElementRe6.current, (event => {
                                    if (!event.isDefaultPrevented()) {
                                        this.setState({
                                            focused: true
                                        });
                                        null === onFocusIn || void 0 === onFocusIn || onFocusIn(event)
                                    }
                                }), null, namespace)
                            }
                        }
                        return
                    }
                    focusOutEffect() {
                        const {
                            focusStateEnabled: focusStateEnabled,
                            name: name,
                            onFocusOut: onFocusOut
                        } = this.props;
                        const namespace = `${name}Focus`;
                        if (focusStateEnabled) {
                            var _this$widgetElementRe7;
                            return (0, _subscribe_to_event.subscribeToDxFocusOutEvent)(null === (_this$widgetElementRe7 = this.widgetElementRef) || void 0 === _this$widgetElementRe7 ? void 0 : _this$widgetElementRe7.current, (event => {
                                if (!event.isDefaultPrevented() && this.state.focused) {
                                    this.setState({
                                        focused: false
                                    });
                                    null === onFocusOut || void 0 === onFocusOut || onFocusOut(event)
                                }
                            }), null, namespace)
                        }
                        return
                    }
                    hoverStartEffect() {
                        const {
                            activeStateUnit: activeStateUnit,
                            hoverStateEnabled: hoverStateEnabled,
                            disabled: disabled,
                            onHoverStart: onHoverStart
                        } = this.props;
                        const selector = activeStateUnit;
                        if (hoverStateEnabled) {
                            if (!disabled) {
                                var _this$widgetElementRe8;
                                return (0, _subscribe_to_event.subscribeToDxHoverStartEvent)(null === (_this$widgetElementRe8 = this.widgetElementRef) || void 0 === _this$widgetElementRe8 ? void 0 : _this$widgetElementRe8.current, (event => {
                                    if (!this.state.active) {
                                        this.setState({
                                            hovered: true
                                        })
                                    }
                                    null === onHoverStart || void 0 === onHoverStart || onHoverStart(event)
                                }), {
                                    selector: selector
                                }, "UIFeedback")
                            }
                        }
                        return
                    }
                    hoverEndEffect() {
                        const {
                            activeStateUnit: activeStateUnit,
                            hoverStateEnabled: hoverStateEnabled,
                            onHoverEnd: onHoverEnd
                        } = this.props;
                        const selector = activeStateUnit;
                        if (hoverStateEnabled) {
                            var _this$widgetElementRe9;
                            return (0, _subscribe_to_event.subscribeToDxHoverEndEvent)(null === (_this$widgetElementRe9 = this.widgetElementRef) || void 0 === _this$widgetElementRe9 ? void 0 : _this$widgetElementRe9.current, (event => {
                                if (this.state.hovered) {
                                    this.setState({
                                        hovered: false
                                    });
                                    null === onHoverEnd || void 0 === onHoverEnd || onHoverEnd(event)
                                }
                            }), {
                                selector: selector
                            }, "UIFeedback")
                        }
                        return
                    }
                    keyboardEffect() {
                        const {
                            onKeyDown: onKeyDown,
                            focusStateEnabled: focusStateEnabled
                        } = this.props;
                        if (focusStateEnabled && onKeyDown) {
                            var _this$widgetElementRe10, _this$widgetElementRe11;
                            const id = _short.keyboard.on(null === (_this$widgetElementRe10 = this.widgetElementRef) || void 0 === _this$widgetElementRe10 ? void 0 : _this$widgetElementRe10.current, null === (_this$widgetElementRe11 = this.widgetElementRef) || void 0 === _this$widgetElementRe11 ? void 0 : _this$widgetElementRe11.current, (e => onKeyDown(e)));
                            return () => _short.keyboard.off(id)
                        }
                        return
                    }
                    resizeEffect() {
                        const namespace = `${this.props.name}VisibilityChange`;
                        const {
                            onDimensionChanged: onDimensionChanged
                        } = this.props;
                        if (onDimensionChanged) {
                            var _this$widgetElementRe12;
                            _short.resize.on(null === (_this$widgetElementRe12 = this.widgetElementRef) || void 0 === _this$widgetElementRe12 ? void 0 : _this$widgetElementRe12.current, onDimensionChanged, {
                                namespace: namespace
                            });
                            return () => {
                                var _this$widgetElementRe13;
                                return _short.resize.off(null === (_this$widgetElementRe13 = this.widgetElementRef) || void 0 === _this$widgetElementRe13 ? void 0 : _this$widgetElementRe13.current, {
                                    namespace: namespace
                                })
                            }
                        }
                        return
                    }
                    windowResizeEffect() {
                        const {
                            onDimensionChanged: onDimensionChanged
                        } = this.props;
                        if (onDimensionChanged) {
                            _resize_callbacks.default.add(onDimensionChanged);
                            return () => {
                                _resize_callbacks.default.remove(onDimensionChanged)
                            }
                        }
                        return
                    }
                    visibilityEffect() {
                        const {
                            name: name,
                            onVisibilityChange: onVisibilityChange
                        } = this.props;
                        const namespace = `${name}VisibilityChange`;
                        if (onVisibilityChange) {
                            var _this$widgetElementRe14;
                            _short.visibility.on(null === (_this$widgetElementRe14 = this.widgetElementRef) || void 0 === _this$widgetElementRe14 ? void 0 : _this$widgetElementRe14.current, (() => onVisibilityChange(true)), (() => onVisibilityChange(false)), {
                                namespace: namespace
                            });
                            return () => {
                                var _this$widgetElementRe15;
                                return _short.visibility.off(null === (_this$widgetElementRe15 = this.widgetElementRef) || void 0 === _this$widgetElementRe15 ? void 0 : _this$widgetElementRe15.current, {
                                    namespace: namespace
                                })
                            }
                        }
                        return
                    }
                    checkDeprecation() {
                        const {
                            width: width,
                            height: height
                        } = this.props;
                        if ((0, _type.isFunction)(width)) {
                            _errors.default.log("W0017", "width")
                        }
                        if ((0, _type.isFunction)(height)) {
                            _errors.default.log("W0017", "height")
                        }
                    }
                    applyCssTextEffect() {
                        var _this$widgetElementRe16;
                        const {
                            cssText: cssText
                        } = this.props;
                        if (void 0 !== cssText && "" !== cssText && null !== (_this$widgetElementRe16 = this.widgetElementRef) && void 0 !== _this$widgetElementRe16 && _this$widgetElementRe16.current) {
                            this.widgetElementRef.current.style.cssText = cssText
                        }
                    }
                    getShouldRenderConfigProvider() {
                        const {
                            rtlEnabled: rtlEnabled
                        } = this.props;
                        return (0, _resolve_rtl.resolveRtlEnabledDefinition)(rtlEnabled, this.config)
                    }
                    getRtlEnabled() {
                        const {
                            rtlEnabled: rtlEnabled
                        } = this.props;
                        return (0, _resolve_rtl.resolveRtlEnabled)(rtlEnabled, this.config)
                    }
                    getAttributes() {
                        const {
                            aria: aria,
                            disabled: disabled,
                            focusStateEnabled: focusStateEnabled,
                            visible: visible
                        } = this.props;
                        const accessKey = focusStateEnabled && !disabled && this.props.accessKey;
                        const props = _extends({}, (0, _extend.extend)({}, accessKey && {
                            accessKey: accessKey
                        }), (args = _extends({}, aria, {
                            disabled: disabled,
                            hidden: !visible
                        }), Object.keys(args).reduce(((r, key) => {
                            if (args[key]) {
                                return _extends({}, r, {
                                    ["role" === key || "id" === key ? key : `aria-${key}`]: String(args[key])
                                })
                            }
                            return r
                        }), {})), (0, _extend.extend)({}, this.getRestAttributes(this.props)));
                        var args;
                        return props
                    }
                    getRestAttributes(props) {
                        const result = _extends({}, props);
                        ["_feedbackHideTimeout", "_feedbackShowTimeout", "accessKey", "activeStateEnabled", "activeStateUnit", "addWidgetClass", "aria", "children", "className", "classes", "cssText", "disabled", "focusStateEnabled", "height", "hint", "hoverStateEnabled", "name", "onActive", "onClick", "onDimensionChanged", "onFocusIn", "onFocusOut", "onHoverEnd", "onHoverStart", "onInactive", "onKeyDown", "onRootElementRendered", "onVisibilityChange", "rootElementRef", "rtlEnabled", "tabIndex", "visible", "width"].forEach((exclude => {
                            delete result[exclude]
                        }));
                        return result
                    }
                    getStyles() {
                        const {
                            width: width,
                            height: height
                        } = this.props;
                        const style = this.props.style || {};
                        const computedWidth = (0, _style.normalizeStyleProp)("width", (0, _type.isFunction)(width) ? width() : width);
                        const computedHeight = (0, _style.normalizeStyleProp)("height", (0, _type.isFunction)(height) ? height() : height);
                        return _extends({}, style, {
                            height: computedHeight ?? style.height,
                            width: computedWidth ?? style.width
                        })
                    }
                    getCssClasses() {
                        const {
                            classes: classes,
                            addWidgetClass: addWidgetClass,
                            className: className,
                            disabled: disabled,
                            activeStateEnabled: activeStateEnabled,
                            focusStateEnabled: focusStateEnabled,
                            hoverStateEnabled: hoverStateEnabled,
                            onVisibilityChange: onVisibilityChange,
                            visible: visible
                        } = this.props;
                        const isFocusable = !!focusStateEnabled && !disabled;
                        const isHoverable = !!hoverStateEnabled && !disabled;
                        const canBeActive = !!activeStateEnabled && !disabled;
                        const classesMap = {
                            "dx-widget": !!addWidgetClass,
                            [String(classes)]: !!classes,
                            [String(className)]: !!className,
                            "dx-state-disabled": !!disabled,
                            "dx-state-invisible": !visible,
                            "dx-state-focused": !!this.state.focused && isFocusable,
                            "dx-state-active": !!this.state.active && canBeActive,
                            "dx-state-hover": !!this.state.hovered && isHoverable && !this.state.active,
                            "dx-rtl": !!this.props.rtlEnabled,
                            "dx-visibility-change-handler": !!onVisibilityChange
                        };
                        return (0, _render_utils.combineClasses)(classesMap)
                    }
                    getTabIndex() {
                        const {
                            focusStateEnabled: focusStateEnabled,
                            disabled: disabled,
                            tabIndex: tabIndex
                        } = this.props;
                        const isFocusable = focusStateEnabled && !disabled;
                        return isFocusable ? tabIndex : void 0
                    }
                    focus() {
                        var _this$widgetElementRe17;
                        _short.focus.trigger(null === (_this$widgetElementRe17 = this.widgetElementRef) || void 0 === _this$widgetElementRe17 ? void 0 : _this$widgetElementRe17.current)
                    }
                    blur() {
                        var _this$widgetElementRe18, _this$widgetElementRe19;
                        const activeElement = _dom_adapter.default.getActiveElement(null === (_this$widgetElementRe18 = this.widgetElementRef) || void 0 === _this$widgetElementRe18 ? void 0 : _this$widgetElementRe18.current);
                        if ((null === (_this$widgetElementRe19 = this.widgetElementRef) || void 0 === _this$widgetElementRe19 ? void 0 : _this$widgetElementRe19.current) === activeElement) {
                            activeElement.blur()
                        }
                    }
                    activate() {
                        this.setState({
                            active: true
                        })
                    }
                    deactivate() {
                        this.setState({
                            active: false
                        })
                    }
                    render() {
                        const {
                            hint: hint,
                            children: children
                        } = this.props;
                        const widget = (0, _inferno.normalizeProps)((0, _inferno.createVNode)(1, "div", this.getCssClasses(), children, 0, _extends({}, this.getAttributes(), {
                            tabIndex: this.getTabIndex(),
                            title: hint,
                            style: this.getStyles()
                        }), null, this.widgetElementRef));
                        return this.getShouldRenderConfigProvider() ? (0, _inferno.createComponentVNode)(2, _config_provider.ConfigProvider, {
                            rtlEnabled: this.getRtlEnabled(),
                            children: widget
                        }) : widget
                    }
                }
                exports.Widget = Widget;
                Widget.defaultProps = WidgetDefaultProps
            },
        52820:
            /*!**********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/templates/m_bindable_template.js ***!
              \**********************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.BindableTemplate = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _template_base = __webpack_require__( /*! ../../../core/templates/template_base */ 42186);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../events/core/events_engine */ 76772));
                var _remove = __webpack_require__( /*! ../../../events/remove */ 92492);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const watchChanges = function(rawData, watchMethod, fields, fieldsMap, callback) {
                    let fieldsDispose;
                    const globalDispose = ((data, watchMethod, callback) => watchMethod((() => data), callback))(rawData, watchMethod, (dataWithRawFields => {
                        fieldsDispose && fieldsDispose();
                        if ((0, _type.isPrimitive)(dataWithRawFields)) {
                            callback(dataWithRawFields);
                            return
                        }
                        fieldsDispose = function(data, watchMethod, fields, fieldsMap, callback) {
                            const resolvedData = {};
                            const missedFields = fields.slice();
                            const watchHandlers = fields.map((name => {
                                const fieldGetter = fieldsMap[name];
                                return watchMethod(fieldGetter ? () => fieldGetter(data) : () => data[name], (value => {
                                    resolvedData[name] = value;
                                    if (missedFields.length) {
                                        const index = missedFields.indexOf(name);
                                        if (index >= 0) {
                                            missedFields.splice(index, 1)
                                        }
                                    }
                                    if (!missedFields.length) {
                                        callback(resolvedData)
                                    }
                                }))
                            }));
                            return function() {
                                watchHandlers.forEach((dispose => dispose()))
                            }
                        }(dataWithRawFields, watchMethod, fields, fieldsMap, callback)
                    }));
                    return function() {
                        fieldsDispose && fieldsDispose();
                        globalDispose && globalDispose()
                    }
                };
                class BindableTemplate extends _template_base.TemplateBase {
                    constructor(render, fields, watchMethod, fieldsMap) {
                        super();
                        this._render = render;
                        this._fields = fields;
                        this._fieldsMap = fieldsMap || {};
                        this._watchMethod = watchMethod
                    }
                    _renderCore(options) {
                        const $container = (0, _renderer.default)(options.container);
                        const dispose = watchChanges(options.model, this._watchMethod, this._fields, this._fieldsMap, (data => {
                            $container.empty();
                            this._render($container, data, options.model)
                        }));
                        _events_engine.default.on($container, _remove.removeEvent, dispose);
                        return $container.contents()
                    }
                }
                exports.BindableTemplate = BindableTemplate
            },
        93971:
            /*!***************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/templates/m_child_default_template.js ***!
              \***************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.ChildDefaultTemplate = void 0;
                var _template_base = __webpack_require__( /*! ../../../core/templates/template_base */ 42186);
                class ChildDefaultTemplate extends _template_base.TemplateBase {
                    constructor(name) {
                        super();
                        this.name = name
                    }
                }
                exports.ChildDefaultTemplate = ChildDefaultTemplate
            },
        11768:
            /*!*******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/templates/m_empty_template.js ***!
              \*******************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.EmptyTemplate = void 0;
                var _renderer = (obj = __webpack_require__( /*! ../../../core/renderer */ 64553), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _template_base = __webpack_require__( /*! ../../../core/templates/template_base */ 42186);
                class EmptyTemplate extends _template_base.TemplateBase {
                    _renderCore() {
                        return (0, _renderer.default)()
                    }
                }
                exports.EmptyTemplate = EmptyTemplate
            },
        88969:
            /*!**********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/templates/m_function_template.js ***!
              \**********************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.FunctionTemplate = void 0;
                var _template_base = __webpack_require__( /*! ../../../core/templates/template_base */ 42186);
                var _dom = __webpack_require__( /*! ../../../core/utils/dom */ 86858);
                class FunctionTemplate extends _template_base.TemplateBase {
                    constructor(render) {
                        super();
                        this._render = render
                    }
                    _renderCore(options) {
                        return (0, _dom.normalizeTemplateElement)(this._render(options))
                    }
                }
                exports.FunctionTemplate = FunctionTemplate
            },
        52538:
            /*!*************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/templates/m_template.js ***!
              \*************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Template = void 0;
                var _renderer = (obj = __webpack_require__( /*! ../../../core/renderer */ 64553), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _template_base = __webpack_require__( /*! ../../../core/templates/template_base */ 42186);
                var _template_engine_registry = __webpack_require__( /*! ../../../core/templates/template_engine_registry */ 35155);
                var _dom = __webpack_require__( /*! ../../../core/utils/dom */ 86858);
                (0, _template_engine_registry.registerTemplateEngine)("default", {
                    compile: element => (0, _dom.normalizeTemplateElement)(element),
                    render: (template, model, index) => template.clone()
                });
                (0, _template_engine_registry.setTemplateEngine)("default");
                class Template extends _template_base.TemplateBase {
                    constructor(element) {
                        super();
                        this._element = element
                    }
                    _renderCore(options) {
                        const {
                            transclude: transclude
                        } = options;
                        if (!transclude && !this._compiledTemplate) {
                            this._compiledTemplate = (0, _template_engine_registry.getCurrentTemplateEngine)().compile(this._element)
                        }
                        return (0, _renderer.default)("<div>").append(transclude ? this._element : (0, _template_engine_registry.getCurrentTemplateEngine)().render(this._compiledTemplate, options.model, options.index)).contents()
                    }
                    source() {
                        return (0, _renderer.default)(this._element).clone()
                    }
                }
                exports.Template = Template
            },
        31292:
            /*!******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/templates/m_template_base.js ***!
              \******************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.renderedCallbacks = exports.TemplateBase = void 0;
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../core/dom_adapter */ 64960));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../../../core/errors */ 87129));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/callbacks */ 84718));
                var _dom = __webpack_require__( /*! ../../../core/utils/dom */ 86858);
                var _visibility_change = __webpack_require__( /*! ../../../events/visibility_change */ 37943);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const renderedCallbacks = exports.renderedCallbacks = (0, _callbacks.default)({
                    syncStrategy: true
                });
                exports.TemplateBase = class {
                    render(options) {
                        options = options || {};
                        const {
                            onRendered: onRendered
                        } = options;
                        delete options.onRendered;
                        let $result;
                        if (options.renovated && options.transclude && this._element) {
                            $result = (0, _renderer.default)("<div>").append(this._element).contents()
                        } else {
                            $result = this._renderCore(options)
                        }
                        this._ensureResultInContainer($result, options.container);
                        renderedCallbacks.fire($result, options.container);
                        onRendered && onRendered();
                        return $result
                    }
                    _ensureResultInContainer($result, container) {
                        if (!container) {
                            return
                        }
                        const $container = (0, _renderer.default)(container);
                        const resultInContainer = (0, _dom.contains)($container.get(0), $result.get(0));
                        $container.append($result);
                        if (resultInContainer) {
                            return
                        }
                        const resultInBody = (0, _dom.contains)(_dom_adapter.default.getBody(), $container.get(0));
                        if (!resultInBody) {
                            return
                        }(0, _visibility_change.triggerShownEvent)($result)
                    }
                    _renderCore() {
                        throw _errors.default.Error("E0001")
                    }
                }
            },
        70785:
            /*!*****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/templates/m_template_engine_registry.js ***!
              \*****************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getCurrentTemplateEngine = function() {
                    return currentTemplateEngine
                };
                exports.registerTemplateEngine = function(name, templateEngine) {
                    templateEngines[name] = templateEngine
                };
                exports.setTemplateEngine = function(templateEngine) {
                    if ((0, _type.isString)(templateEngine)) {
                        currentTemplateEngine = templateEngines[templateEngine];
                        if (!currentTemplateEngine) {
                            throw _errors.default.Error("E0020", templateEngine)
                        }
                    } else {
                        currentTemplateEngine = templateEngine
                    }
                };
                var _errors = (obj = __webpack_require__( /*! ../../../core/errors */ 87129), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                const templateEngines = {};
                let currentTemplateEngine
            },
        46190:
            /*!**************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/combine_classes.js ***!
              \**************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.combineClasses = function(classesMap) {
                    return Object.keys(classesMap).filter((p => classesMap[p])).join(" ")
                }
            },
        55594:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/date.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.dateUtilsTs = void 0;
                exports.dateUtilsTs = {
                    addOffsets: (date, offsets) => {
                        const newDateMs = offsets.reduce(((result, offset) => result + offset), date.getTime());
                        return new Date(newDateMs)
                    }
                }
            },
        14136:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_ajax.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Ajax = void 0;
                var _http_request = _interopRequireDefault(__webpack_require__( /*! ../../../core/http_request */ 35688));
                var _ajax_utils = __webpack_require__( /*! ../../../core/utils/ajax_utils */ 28248);
                var _deferred = __webpack_require__( /*! ../../../core/utils/deferred */ 87739);
                var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/dependency_injector */ 89656));
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 3104);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const window = (0, _window.getWindow)();
                exports.Ajax = (0, _dependency_injector.default)({
                    sendRequest: function(options) {
                        const xhr = _http_request.default.getXhr();
                        const d = new _deferred.Deferred;
                        const result = d.promise();
                        const async = (0, _type.isDefined)(options.async) ? options.async : true;
                        const {
                            dataType: dataType
                        } = options;
                        const timeout = options.timeout || 0;
                        let timeoutId;
                        options.crossDomain = (0, _ajax_utils.isCrossDomain)(options.url);
                        const needScriptEvaluation = "jsonp" === dataType || "script" === dataType;
                        if (void 0 === options.cache) {
                            options.cache = !needScriptEvaluation
                        }
                        const callbackName = (0, _ajax_utils.getJsonpCallbackName)(options);
                        const headers = (0, _ajax_utils.getRequestHeaders)(options);
                        const requestOptions = (0, _ajax_utils.getRequestOptions)(options, headers);
                        const {
                            url: url
                        } = requestOptions;
                        const {
                            parameters: parameters
                        } = requestOptions;
                        if (callbackName) {
                            window[callbackName] = function(data) {
                                d.resolve(data, "success", xhr)
                            }
                        }
                        if (options.crossDomain && needScriptEvaluation) {
                            const reject = function() {
                                d.reject(xhr, "error")
                            };
                            const resolve = function() {
                                if ("jsonp" === dataType) {
                                    return
                                }
                                d.resolve(null, "success", xhr)
                            };
                            (0, _ajax_utils.evalCrossDomainScript)(url).then(resolve, reject);
                            return result
                        }
                        if (options.crossDomain && !("withCredentials" in xhr)) {
                            d.reject(xhr, "error");
                            return result
                        }
                        xhr.open((0, _ajax_utils.getMethod)(options), url, async, options.username, options.password);
                        if (async) {
                            xhr.timeout = timeout;
                            timeoutId = function(timeout, xhr) {
                                return timeout && setTimeout((function() {
                                    xhr.customStatus = "timeout";
                                    xhr.abort()
                                }), timeout)
                            }(timeout, xhr)
                        }
                        xhr.onreadystatechange = function(e) {
                            if (4 === xhr.readyState) {
                                clearTimeout(timeoutId);
                                if (status = xhr.status, status >= 200 && status < 300) {
                                    if (function(status) {
                                            return 204 !== status
                                        }(xhr.status)) {
                                        ! function(deferred, xhr, dataType) {
                                            const data = function(xhr) {
                                                return xhr.responseType && "text" !== xhr.responseType || "string" !== typeof xhr.responseText ? xhr.response : xhr.responseText
                                            }(xhr);
                                            switch (dataType) {
                                                case "jsonp":
                                                    (0, _ajax_utils.evalScript)(data);
                                                    break;
                                                case "script":
                                                    (0, _ajax_utils.evalScript)(data);
                                                    deferred.resolve(data, "success", xhr);
                                                    break;
                                                case "json":
                                                    try {
                                                        deferred.resolve(JSON.parse(data), "success", xhr)
                                                    } catch (e) {
                                                        deferred.reject(xhr, "parsererror", e)
                                                    }
                                                    break;
                                                default:
                                                    deferred.resolve(data, "success", xhr)
                                            }
                                        }(d, xhr, dataType)
                                    } else {
                                        d.resolve(null, "nocontent", xhr)
                                    }
                                } else {
                                    d.reject(xhr, xhr.customStatus || "error")
                                }
                            }
                            var status
                        };
                        if (options.upload) {
                            xhr.upload.onprogress = options.upload.onprogress;
                            xhr.upload.onloadstart = options.upload.onloadstart;
                            xhr.upload.onabort = options.upload.onabort
                        }
                        if (options.xhrFields) {
                            for (const field in options.xhrFields) {
                                xhr[field] = options.xhrFields[field]
                            }
                        }
                        if ("arraybuffer" === options.responseType) {
                            xhr.responseType = options.responseType
                        }
                        for (const name in headers) {
                            if (Object.prototype.hasOwnProperty.call(headers, name) && (0, _type.isDefined)(headers[name])) {
                                xhr.setRequestHeader(name, headers[name])
                            }
                        }
                        if (options.beforeSend) {
                            options.beforeSend(xhr)
                        }
                        xhr.send(parameters);
                        result.abort = function() {
                            xhr.abort()
                        };
                        return result
                    }
                })
            },
        42202:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_ajax_utils.js ***!
              \***********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getJsonpCallbackName = exports.getAcceptHeader = exports.evalScript = exports.evalCrossDomainScript = void 0;
                exports.getMethod = getMethod;
                exports.isCrossDomain = exports.getRequestOptions = exports.getRequestHeaders = void 0;
                var _dom_adapter = (obj = __webpack_require__( /*! ../../../core/dom_adapter */ 64960), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 3104);
                const window = (0, _window.getWindow)();
                const createScript = function(options) {
                    const script = _dom_adapter.default.createElement("script");
                    for (const name in options) {
                        script[name] = options[name]
                    }
                    return script
                };
                const appendToHead = function(element) {
                    return _dom_adapter.default.getHead().appendChild(element)
                };
                const removeScript = function(scriptNode) {
                    scriptNode.parentNode.removeChild(scriptNode)
                };
                exports.evalScript = function(code) {
                    const script = createScript({
                        text: code
                    });
                    appendToHead(script);
                    removeScript(script)
                };
                exports.evalCrossDomainScript = function(url) {
                    const script = createScript({
                        src: url
                    });
                    return new Promise(((resolve, reject) => {
                        const events = {
                            load: resolve,
                            error: reject
                        };
                        const loadHandler = function(e) {
                            events[e.type]();
                            removeScript(script)
                        };
                        for (const event in events) {
                            _dom_adapter.default.listen(script, event, loadHandler)
                        }
                        appendToHead(script)
                    }))
                };

                function getMethod(options) {
                    return (options.method || "GET").toUpperCase()
                }
                const getAcceptHeader = function(options) {
                    const dataType = options.dataType || "*";
                    const scriptAccept = "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript";
                    const accepts = {
                        "*": "*/*",
                        text: "text/plain",
                        html: "text/html",
                        xml: "application/xml, text/xml",
                        json: "application/json, text/javascript",
                        jsonp: scriptAccept,
                        script: scriptAccept
                    };
                    (0, _extend.extendFromObject)(accepts, options.accepts, true);
                    return accepts[dataType] ? accepts[dataType] + ("*" !== dataType ? ", */*; q=0.01" : "") : accepts["*"]
                };
                exports.getAcceptHeader = getAcceptHeader;
                exports.getRequestHeaders = function(options) {
                    const headers = options.headers || {};
                    headers["Content-Type"] = headers["Content-Type"] || function(options) {
                        let defaultContentType;
                        if (options.data && !options.upload && "GET" !== getMethod(options)) {
                            defaultContentType = "application/x-www-form-urlencoded;charset=utf-8"
                        }
                        return options.contentType || defaultContentType
                    }(options);
                    headers.Accept = headers.Accept || getAcceptHeader(options);
                    if (!options.crossDomain && !headers["X-Requested-With"]) {
                        headers["X-Requested-With"] = "XMLHttpRequest"
                    }
                    return headers
                };
                exports.getJsonpCallbackName = function(options) {
                    if ("jsonp" === options.dataType) {
                        const random = Math.random().toString().replace(/\D/g, "");
                        const callbackName = options.jsonpCallback || `dxCallback${Date.now()}_${random}`;
                        const callbackParameter = options.jsonp || "callback";
                        options.data = options.data || {};
                        options.data[callbackParameter] = callbackName;
                        return callbackName
                    }
                };
                exports.getRequestOptions = function(options, headers) {
                    let params = options.data;
                    const paramsAlreadyString = "string" === typeof params;
                    let url = options.url || window.location.href;
                    if (!paramsAlreadyString && !options.cache) {
                        params = params || {};
                        params._ = Date.now()
                    }
                    if (params && !options.upload) {
                        if (!paramsAlreadyString) {
                            params = function(params) {
                                const result = [];
                                for (const name in params) {
                                    let value = params[name];
                                    if (void 0 === value) {
                                        continue
                                    }
                                    if (null === value) {
                                        value = ""
                                    }
                                    if ("function" === typeof value) {
                                        value = value()
                                    }
                                    result.push(`${encodeURIComponent(name)}=${encodeURIComponent(value)}`)
                                }
                                return result.join("&")
                            }(params)
                        }
                        if ("GET" === getMethod(options)) {
                            if ("" !== params) {
                                url += (url.indexOf("?") > -1 ? "&" : "?") + params
                            }
                            params = null
                        } else if (headers["Content-Type"] && headers["Content-Type"].indexOf("application/x-www-form-urlencoded") > -1) {
                            params = params.replace(/%20/g, "+")
                        }
                    }
                    return {
                        url: url,
                        parameters: params
                    }
                };
                exports.isCrossDomain = function(url) {
                    if (!(0, _window.hasWindow)()) {
                        return true
                    }
                    let crossDomain = false;
                    const originAnchor = _dom_adapter.default.createElement("a");
                    const urlAnchor = _dom_adapter.default.createElement("a");
                    originAnchor.href = window.location.href;
                    try {
                        urlAnchor.href = url;
                        urlAnchor.href = urlAnchor.href;
                        crossDomain = `${originAnchor.protocol}//${originAnchor.host}` !== `${urlAnchor.protocol}//${urlAnchor.host}`
                    } catch (e) {
                        crossDomain = true
                    }
                    return crossDomain
                }
            },
        28601:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_array.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.wrapToArray = exports.removeDuplicates = exports.normalizeIndexes = exports.groupBy = exports.getUniqueValues = exports.getIntersection = void 0;
                var _config = (obj = __webpack_require__( /*! ../../../core/config */ 66636), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _object = __webpack_require__( /*! ../../../core/utils/object */ 22263);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);

                function createOccurrenceMap(array) {
                    return array.reduce(((map, value) => {
                        const count = (map.get(value) ?? 0) + 1;
                        map.set(value, count);
                        return map
                    }), new Map)
                }
                exports.wrapToArray = function(item) {
                    return Array.isArray(item) ? item : [item]
                };
                exports.getUniqueValues = function(values) {
                    return [...new Set(values)]
                };
                exports.getIntersection = function(firstArray, secondArray) {
                    const toRemoveMap = createOccurrenceMap(secondArray);
                    return firstArray.filter((value => {
                        const occurrencesCount = toRemoveMap.get(value);
                        occurrencesCount && toRemoveMap.set(value, occurrencesCount - 1);
                        return occurrencesCount
                    }))
                };
                exports.removeDuplicates = function() {
                    let from = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : [];
                    let toRemove = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : [];
                    const toRemoveMap = createOccurrenceMap(toRemove);
                    return from.filter((value => {
                        const occurrencesCount = toRemoveMap.get(value);
                        occurrencesCount && toRemoveMap.set(value, occurrencesCount - 1);
                        return !occurrencesCount
                    }))
                };
                exports.normalizeIndexes = function(items, indexPropName, currentItem, needIndexCallback) {
                    const indexedItems = {};
                    const {
                        useLegacyVisibleIndex: useLegacyVisibleIndex
                    } = (0, _config.default)();
                    let currentIndex = 0;
                    const shouldUpdateIndex = item => !(0, _type.isDefined)(item[indexPropName]) && (!needIndexCallback || needIndexCallback(item));
                    items.forEach((item => {
                        const index = item[indexPropName];
                        if (index >= 0) {
                            indexedItems[index] = indexedItems[index] || [];
                            if (item === currentItem) {
                                indexedItems[index].unshift(item)
                            } else {
                                indexedItems[index].push(item)
                            }
                        } else {
                            item[indexPropName] = void 0
                        }
                    }));
                    if (!useLegacyVisibleIndex) {
                        items.forEach((item => {
                            if (shouldUpdateIndex(item)) {
                                while (indexedItems[currentIndex]) {
                                    currentIndex++
                                }
                                indexedItems[currentIndex] = [item];
                                currentIndex++
                            }
                        }))
                    }
                    currentIndex = 0;
                    (0, _object.orderEach)(indexedItems, (function(index, items) {
                        items.forEach((item => {
                            if (index >= 0) {
                                item[indexPropName] = currentIndex++
                            }
                        }))
                    }));
                    if (useLegacyVisibleIndex) {
                        items.forEach((item => {
                            if (shouldUpdateIndex(item)) {
                                item[indexPropName] = currentIndex++
                            }
                        }))
                    }
                };
                exports.groupBy = (array, getGroupName) => array.reduce(((groupedResult, item) => {
                    const groupName = getGroupName(item);
                    groupedResult[groupName] = groupedResult[groupName] ?? [];
                    groupedResult[groupName].push(item);
                    return groupedResult
                }), {})
            },
        87525:
            /*!**************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_array_compare.js ***!
              \**************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.isKeysEqual = exports.findChanges = void 0;
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                const getKeyWrapper = function(item, getKey) {
                    const key = getKey(item);
                    if ((0, _type.isObject)(key)) {
                        try {
                            return JSON.stringify(key)
                        } catch (e) {
                            return key
                        }
                    }
                    return key
                };
                const getSameNewByOld = function(oldItem, newItems, newIndexByKey, getKey) {
                    const key = getKeyWrapper(oldItem, getKey);
                    return newItems[newIndexByKey[key]]
                };
                exports.isKeysEqual = function(oldKeys, newKeys) {
                    if (oldKeys.length !== newKeys.length) {
                        return false
                    }
                    for (let i = 0; i < newKeys.length; i++) {
                        if (oldKeys[i] !== newKeys[i]) {
                            return false
                        }
                    }
                    return true
                };
                exports.findChanges = function(oldItems, newItems, getKey, isItemEquals) {
                    const oldIndexByKey = {};
                    const newIndexByKey = {};
                    let addedCount = 0;
                    let removeCount = 0;
                    const result = [];
                    oldItems.forEach((function(item, index) {
                        const key = getKeyWrapper(item, getKey);
                        oldIndexByKey[key] = index
                    }));
                    newItems.forEach((function(item, index) {
                        const key = getKeyWrapper(item, getKey);
                        newIndexByKey[key] = index
                    }));
                    const itemCount = Math.max(oldItems.length, newItems.length);
                    for (let index = 0; index < itemCount + addedCount; index++) {
                        const newItem = newItems[index];
                        const oldNextIndex = index - addedCount + removeCount;
                        const nextOldItem = oldItems[oldNextIndex];
                        const isRemoved = !newItem || nextOldItem && !getSameNewByOld(nextOldItem, newItems, newIndexByKey, getKey);
                        if (isRemoved) {
                            if (nextOldItem) {
                                result.push({
                                    type: "remove",
                                    key: getKey(nextOldItem),
                                    index: index,
                                    oldItem: nextOldItem
                                });
                                removeCount++;
                                index--
                            }
                        } else {
                            const key = getKeyWrapper(newItem, getKey);
                            const oldIndex = oldIndexByKey[key];
                            const oldItem = oldItems[oldIndex];
                            if (!oldItem) {
                                addedCount++;
                                result.push({
                                    type: "insert",
                                    data: newItem,
                                    index: index
                                })
                            } else if (oldIndex === oldNextIndex) {
                                if (!isItemEquals(oldItem, newItem)) {
                                    result.push({
                                        type: "update",
                                        data: newItem,
                                        key: getKey(newItem),
                                        index: index,
                                        oldItem: oldItem
                                    })
                                }
                            } else {
                                return
                            }
                        }
                    }
                    return result
                }
            },
        33436:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_browser.js ***!
              \********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.browser = void 0;
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 3104);
                const navigator = (0, _window.getNavigator)();
                const webkitRegExp = /(webkit)[ /]([\w.]+)/;
                const mozillaRegExp = /(mozilla)(?:.*? rv:([\w.]+))/;
                const browserFromUA = ua => {
                    ua = ua.toLowerCase();
                    const result = {};
                    const matches = webkitRegExp.exec(ua) || ua.indexOf("compatible") < 0 && mozillaRegExp.exec(ua) || [];
                    let browserName = matches[1];
                    let browserVersion = matches[2];
                    if ("webkit" === browserName) {
                        result.webkit = true;
                        if (ua.indexOf("chrome") >= 0 || ua.indexOf("crios") >= 0) {
                            browserName = "chrome";
                            browserVersion = /(?:chrome|crios)\/(\d+\.\d+)/.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        } else if (ua.indexOf("fxios") >= 0) {
                            browserName = "mozilla";
                            browserVersion = /fxios\/(\d+\.\d+)/.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        } else if (ua.indexOf("safari") >= 0 && /version|phantomjs/.test(ua)) {
                            browserName = "safari";
                            browserVersion = /(?:version|phantomjs)\/([0-9.]+)/.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        } else {
                            browserName = "unknown";
                            browserVersion = /applewebkit\/([0-9.]+)/.exec(ua);
                            browserVersion = browserVersion && browserVersion[1]
                        }
                    }
                    if (browserName) {
                        result[browserName] = true;
                        result.version = browserVersion
                    }
                    return result
                };
                exports.browser = (0, _extend.extend)({
                    _fromUA: browserFromUA
                }, browserFromUA(navigator.userAgent))
            },
        58060:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_call_once.js ***!
              \**********************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.callOnce = void 0;
                exports.callOnce = function(handler) {
                    let result;
                    let wrappedHandler = function() {
                        result = handler.apply(this, arguments);
                        wrappedHandler = function() {
                            return result
                        };
                        return result
                    };
                    return function() {
                        return wrappedHandler.apply(this, arguments)
                    }
                }
            },
        63172:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_callbacks.js ***!
              \**********************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = exports.Callbacks = void 0;
                const Callback = function(options) {
                    this._options = options || {};
                    this._list = [];
                    this._queue = [];
                    this._firing = false;
                    this._fired = false;
                    this._firingIndexes = []
                };
                Callback.prototype._fireCore = function(context, args) {
                    const firingIndexes = this._firingIndexes;
                    const list = this._list;
                    const {
                        stopOnFalse: stopOnFalse
                    } = this._options;
                    const step = firingIndexes.length;
                    for (firingIndexes[step] = 0; firingIndexes[step] < list.length; firingIndexes[step]++) {
                        const result = list[firingIndexes[step]].apply(context, args);
                        if (false === result && stopOnFalse) {
                            break
                        }
                    }
                    firingIndexes.pop()
                };
                Callback.prototype.add = function(fn) {
                    if ("function" === typeof fn && (!this._options.unique || !this.has(fn))) {
                        this._list.push(fn)
                    }
                    return this
                };
                Callback.prototype.remove = function(fn) {
                    const list = this._list;
                    const firingIndexes = this._firingIndexes;
                    const index = list.indexOf(fn);
                    if (index > -1) {
                        list.splice(index, 1);
                        if (this._firing && firingIndexes.length) {
                            for (let step = 0; step < firingIndexes.length; step++) {
                                if (index <= firingIndexes[step]) {
                                    firingIndexes[step]--
                                }
                            }
                        }
                    }
                    return this
                };
                Callback.prototype.has = function(fn) {
                    const list = this._list;
                    return fn ? list.indexOf(fn) > -1 : !!list.length
                };
                Callback.prototype.empty = function(fn) {
                    this._list = [];
                    return this
                };
                Callback.prototype.fireWith = function(context, args) {
                    const queue = this._queue;
                    args = args || [];
                    args = args.slice ? args.slice() : args;
                    if (this._options.syncStrategy) {
                        this._firing = true;
                        this._fireCore(context, args)
                    } else {
                        queue.push([context, args]);
                        if (this._firing) {
                            return
                        }
                        this._firing = true;
                        while (queue.length) {
                            const memory = queue.shift();
                            this._fireCore(memory[0], memory[1])
                        }
                    }
                    this._firing = false;
                    this._fired = true;
                    return this
                };
                Callback.prototype.fire = function() {
                    this.fireWith(this, arguments)
                };
                Callback.prototype.fired = function() {
                    return this._fired
                };
                const Callbacks = function(options) {
                    return new Callback(options)
                };
                exports.Callbacks = Callbacks;
                exports.default = Callbacks
            },
        39315:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_common.js ***!
              \*******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.splitPair = exports.pairToObject = exports.normalizeKey = exports.noop = exports.grep = exports.getKeyHash = exports.findBestMatches = exports.executeAsync = exports.escapeRegExp = exports.equalByValue = exports.ensureDefined = exports.denormalizeKey = exports.deferUpdater = exports.deferUpdate = exports.deferRenderer = exports.deferRender = exports.default = exports.asyncNoop = exports.applyServerDecimalSeparator = void 0;
                var _config = _interopRequireDefault(__webpack_require__( /*! ../../../core/config */ 66636));
                var _guid = _interopRequireDefault(__webpack_require__( /*! ../../../core/guid */ 19427));
                var _data = __webpack_require__( /*! ../../../core/utils/data */ 31e3);
                var _deferred = __webpack_require__( /*! ../../../core/utils/deferred */ 87739);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const ensureDefined = function(value, defaultValue) {
                    return (0, _type.isDefined)(value) ? value : defaultValue
                };
                exports.ensureDefined = ensureDefined;
                const executeAsync = function(action, context) {
                    const deferred = new _deferred.Deferred;
                    const normalizedContext = context || this;
                    const task = {
                        promise: deferred.promise(),
                        abort() {
                            clearTimeout(timerId);
                            deferred.rejectWith(normalizedContext)
                        }
                    };
                    const timerId = (arguments[2] || setTimeout)((function() {
                        const result = action.call(normalizedContext);
                        if (result && result.done && (0, _type.isFunction)(result.done)) {
                            result.done((function() {
                                deferred.resolveWith(normalizedContext)
                            }))
                        } else {
                            deferred.resolveWith(normalizedContext)
                        }
                    }), "number" === typeof context ? context : 0);
                    return task
                };
                exports.executeAsync = executeAsync;
                const delayedFuncs = [];
                const delayedNames = [];
                const delayedDeferreds = [];
                let executingName;
                const deferExecute = function(name, func, deferred) {
                    if (executingName && executingName !== name) {
                        delayedFuncs.push(func);
                        delayedNames.push(name);
                        deferred = deferred || new _deferred.Deferred;
                        delayedDeferreds.push(deferred);
                        return deferred
                    }
                    const oldExecutingName = executingName;
                    const currentDelayedCount = delayedDeferreds.length;
                    executingName = name;
                    let result = func();
                    if (!result) {
                        if (delayedDeferreds.length > currentDelayedCount) {
                            result = _deferred.when.apply(this, delayedDeferreds.slice(currentDelayedCount))
                        } else if (deferred) {
                            deferred.resolve()
                        }
                    }
                    executingName = oldExecutingName;
                    if (deferred && result && result.done) {
                        result.done(deferred.resolve).fail(deferred.reject)
                    }
                    if (!executingName && delayedFuncs.length) {
                        ("render" === delayedNames.shift() ? deferRender : deferUpdate)(delayedFuncs.shift(), delayedDeferreds.shift())
                    }
                    return result || (0, _deferred.when)()
                };
                const deferRender = function(func, deferred) {
                    return deferExecute("render", func, deferred)
                };
                exports.deferRender = deferRender;
                const deferUpdate = function(func, deferred) {
                    return deferExecute("update", func, deferred)
                };
                exports.deferUpdate = deferUpdate;
                const deferRenderer = function(func) {
                    return function() {
                        const that = this;
                        return deferExecute("render", (function() {
                            return func.call(that)
                        }))
                    }
                };
                exports.deferRenderer = deferRenderer;
                const deferUpdater = function(func) {
                    return function() {
                        const that = this;
                        return deferExecute("update", (function() {
                            return func.call(that)
                        }))
                    }
                };
                exports.deferUpdater = deferUpdater;
                const findBestMatches = (targetFilter, items, mapFn) => {
                    const bestMatches = [];
                    let maxMatchCount = 0;
                    (0, _iterator.each)(items, ((index, itemSrc) => {
                        let matchCount = 0;
                        const item = mapFn ? mapFn(itemSrc) : itemSrc;
                        (0, _iterator.each)(targetFilter, ((paramName, targetValue) => {
                            const value = item[paramName];
                            if (void 0 === value) {
                                return
                            }
                            if (match(value, targetValue)) {
                                matchCount++;
                                return
                            }
                            matchCount = -1;
                            return false
                        }));
                        if (matchCount < maxMatchCount) {
                            return
                        }
                        if (matchCount > maxMatchCount) {
                            bestMatches.length = 0;
                            maxMatchCount = matchCount
                        }
                        bestMatches.push(itemSrc)
                    }));
                    return bestMatches
                };
                exports.findBestMatches = findBestMatches;
                const match = function(value, targetValue) {
                    if (Array.isArray(value) && Array.isArray(targetValue)) {
                        let mismatch = false;
                        (0, _iterator.each)(value, ((index, valueItem) => {
                            if (valueItem !== targetValue[index]) {
                                mismatch = true;
                                return false
                            }
                        }));
                        if (mismatch) {
                            return false
                        }
                        return true
                    }
                    if (value === targetValue) {
                        return true
                    }
                    return false
                };
                const splitPair = function(raw) {
                    switch ((0, _type.type)(raw)) {
                        case "string":
                            return raw.split(/\s+/, 2);
                        case "object":
                            return [raw.x ?? raw.h, raw.y ?? raw.v];
                        case "number":
                            return [raw];
                        case "array":
                            return raw;
                        default:
                            return null
                    }
                };
                exports.splitPair = splitPair;
                const normalizeKey = function(id) {
                    let key = (0, _type.isString)(id) ? id : id.toString();
                    const arr = key.match(/[^a-zA-Z0-9_]/g);
                    arr && (0, _iterator.each)(arr, ((_, sign) => {
                        key = key.replace(sign, `__${sign.charCodeAt()}__`)
                    }));
                    return key
                };
                exports.normalizeKey = normalizeKey;
                const denormalizeKey = function(key) {
                    const arr = key.match(/__\d+__/g);
                    arr && arr.forEach((char => {
                        const charCode = parseInt(char.replace("__", ""));
                        key = key.replace(char, String.fromCharCode(charCode))
                    }));
                    return key
                };
                exports.denormalizeKey = denormalizeKey;
                const pairToObject = function(raw, preventRound) {
                    const pair = splitPair(raw);
                    let h = preventRound ? parseFloat(pair && pair[0]) : parseInt(pair && pair[0], 10);
                    let v = preventRound ? parseFloat(pair && pair[1]) : parseInt(pair && pair[1], 10);
                    if (!isFinite(h)) {
                        h = 0
                    }
                    if (!isFinite(v)) {
                        v = h
                    }
                    return {
                        h: h,
                        v: v
                    }
                };
                exports.pairToObject = pairToObject;
                const getKeyHash = function(key) {
                    if (key instanceof _guid.default) {
                        return key.toString()
                    }
                    if ((0, _type.isObject)(key) || Array.isArray(key)) {
                        try {
                            const keyHash = JSON.stringify(key);
                            return "{}" === keyHash ? key : keyHash
                        } catch (e) {
                            return key
                        }
                    }
                    return key
                };
                exports.getKeyHash = getKeyHash;
                const escapeRegExp = function(string) {
                    return string.replace(/[[\]{}\-()*+?.\\^$|\s]/g, "\\$&")
                };
                exports.escapeRegExp = escapeRegExp;
                const applyServerDecimalSeparator = function(value) {
                    const separator = (0, _config.default)().serverDecimalSeparator;
                    if ((0, _type.isDefined)(value)) {
                        value = value.toString().replace(".", separator)
                    }
                    return value
                };
                exports.applyServerDecimalSeparator = applyServerDecimalSeparator;
                const noop = function() {};
                exports.noop = noop;
                const asyncNoop = function() {
                    return (new _deferred.Deferred).resolve().promise()
                };
                exports.asyncNoop = asyncNoop;
                const grep = function(elements, checkFunction, invert) {
                    const result = [];
                    let check;
                    const expectedCheck = !invert;
                    for (let i = 0; i < elements.length; i++) {
                        check = !!checkFunction(elements[i], i);
                        if (check === expectedCheck) {
                            result.push(elements[i])
                        }
                    }
                    return result
                };
                exports.grep = grep;
                const DEFAULT_EQUAL_BY_VALUE_OPTS = {
                    maxDepth: 3,
                    strict: true
                };
                const compareByValue = (value1, value2, depth, options) => {
                    const {
                        strict: strict,
                        maxDepth: maxDepth
                    } = options;
                    const comparable1 = (0, _data.toComparable)(value1, true);
                    const comparable2 = (0, _data.toComparable)(value2, true);
                    const comparisonResult = strict ? comparable1 === comparable2 : comparable1 == comparable2;
                    switch (true) {
                        case comparisonResult:
                        case depth >= maxDepth:
                            return true;
                        case (0, _type.isObject)(comparable1) && (0, _type.isObject)(comparable2):
                            return ((object1, object2, depth, options) => {
                                const keys1 = Object.keys(object1);
                                const keys2 = Object.keys(object2);
                                if (keys1.length !== keys2.length) {
                                    return false
                                }
                                const keys2Set = new Set(keys2);
                                return !keys1.some((key => !keys2Set.has(key) || !compareByValue(object1[key], object2[key], depth + 1, options)))
                            })(comparable1, comparable2, depth, options);
                        case Array.isArray(comparable1) && Array.isArray(comparable2):
                            return ((array1, array2, depth, options) => {
                                if (array1.length !== array2.length) {
                                    return false
                                }
                                return !array1.some(((item, idx) => !compareByValue(item, array2[idx], depth + 1, _extends({}, options, {
                                    strict: true
                                }))))
                            })(comparable1, comparable2, depth, options);
                        default:
                            return false
                    }
                };
                const equalByValue = function(value1, value2) {
                    let options = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : DEFAULT_EQUAL_BY_VALUE_OPTS;
                    const compareOptions = _extends({}, DEFAULT_EQUAL_BY_VALUE_OPTS, options);
                    return compareByValue(value1, value2, 0, compareOptions)
                };
                exports.equalByValue = equalByValue;
                exports.default = {
                    ensureDefined: ensureDefined,
                    executeAsync: executeAsync,
                    deferRender: deferRender,
                    deferUpdate: deferUpdate,
                    deferRenderer: deferRenderer,
                    deferUpdater: deferUpdater,
                    findBestMatches: findBestMatches,
                    splitPair: splitPair,
                    normalizeKey: normalizeKey,
                    denormalizeKey: denormalizeKey,
                    pairToObject: pairToObject,
                    getKeyHash: getKeyHash,
                    escapeRegExp: escapeRegExp,
                    applyServerDecimalSeparator: applyServerDecimalSeparator,
                    noop: noop,
                    asyncNoop: asyncNoop,
                    grep: grep,
                    equalByValue: equalByValue
                }
            },
        90834:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_comparator.js ***!
              \***********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.equals = void 0;
                var _dom_adapter = (obj = __webpack_require__( /*! ../../../core/dom_adapter */ 64960), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _data = __webpack_require__( /*! ../../../core/utils/data */ 31e3);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                exports.equals = function(oldValue, newValue) {
                    oldValue = (0, _data.toComparable)(oldValue, true);
                    newValue = (0, _data.toComparable)(newValue, true);
                    if (oldValue && newValue && (0, _type.isRenderer)(oldValue) && (0, _type.isRenderer)(newValue)) {
                        return newValue.is(oldValue)
                    }
                    const oldValueIsNaN = oldValue !== oldValue;
                    const newValueIsNaN = newValue !== newValue;
                    if (oldValueIsNaN && newValueIsNaN) {
                        return true
                    }
                    if (0 === oldValue && 0 === newValue) {
                        return function(oldValue, newValue) {
                            return 1 / oldValue === 1 / newValue
                        }(oldValue, newValue)
                    }
                    if (null === oldValue || "object" !== typeof oldValue || _dom_adapter.default.isElementNode(oldValue)) {
                        return oldValue === newValue
                    }
                    return false
                }
            },
        35005:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_console.js ***!
              \********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.logger = exports.default = exports.debug = void 0;
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                const noop = function() {};
                const getConsoleMethod = function(method) {
                    if ("undefined" === typeof console || !(0, _type.isFunction)(console[method])) {
                        return noop
                    }
                    return console[method].bind(console)
                };
                const logger = exports.logger = {
                    log: getConsoleMethod("log"),
                    info: getConsoleMethod("info"),
                    warn: getConsoleMethod("warn"),
                    error: getConsoleMethod("error")
                };
                const debug = exports.debug = function() {
                    function assert(condition, message) {
                        if (!condition) {
                            throw new Error(message)
                        }
                    }
                    return {
                        assert: assert,
                        assertParam: function(parameter, message) {
                            assert(null !== parameter && void 0 !== parameter, message)
                        }
                    }
                }();
                exports.default = {
                    logger: logger,
                    debug: debug
                }
            },
        93142:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_data.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.toComparable = exports.getPathParts = exports.compileSetter = exports.compileGetter = void 0;
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../../core/class */ 55620));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../../../core/errors */ 87129));
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 21274);
                var _object = __webpack_require__( /*! ../../../core/utils/object */ 22263);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _variable_wrapper = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/variable_wrapper */ 40216));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const unwrapVariable = _variable_wrapper.default.unwrap;
                const {
                    isWrapped: isWrapped
                } = _variable_wrapper.default;
                const {
                    assign: assign
                } = _variable_wrapper.default;
                const getPathParts = function(name) {
                    return (expr = name, expr.replace(/\[/g, ".").replace(/\]/g, "")).split(".");
                    var expr
                };
                exports.getPathParts = getPathParts;
                const assignPropValue = function(obj, propName, value, options) {
                    if ("this" === propName) {
                        throw new _errors.default.Error("E4016")
                    }
                    const propValue = obj[propName];
                    if (options.unwrapObservables && isWrapped(propValue)) {
                        assign(propValue, value)
                    } else {
                        obj[propName] = value
                    }
                };
                const prepareOptions = function(options) {
                    options = options || {};
                    options.unwrapObservables = void 0 !== options.unwrapObservables ? options.unwrapObservables : true;
                    return options
                };

                function unwrap(value, options) {
                    return options.unwrapObservables ? unwrapVariable(value) : value
                }
                const compileGetter = function(expr) {
                    if (arguments.length > 1) {
                        expr = [].slice.call(arguments)
                    }
                    if (!expr || "this" === expr) {
                        return function(obj) {
                            return obj
                        }
                    }
                    if ("string" === typeof expr) {
                        const path = getPathParts(expr);
                        return function(obj, options) {
                            options = prepareOptions(options);
                            const functionAsIs = options.functionsAsIs;
                            const hasDefaultValue = "defaultValue" in options;
                            let current = unwrap(obj, options);
                            for (let i = 0; i < path.length; i++) {
                                if (!current) {
                                    if (null == current && hasDefaultValue) {
                                        return options.defaultValue
                                    }
                                    break
                                }
                                const pathPart = path[i];
                                if (hasDefaultValue && (0, _type.isObject)(current) && !(pathPart in current)) {
                                    return options.defaultValue
                                }
                                let next = unwrap(current[pathPart], options);
                                if (!functionAsIs && (0, _type.isFunction)(next)) {
                                    next = next.call(current)
                                }
                                current = next
                            }
                            return current
                        }
                    }
                    if (Array.isArray(expr)) {
                        return function(getters) {
                            const compiledGetters = {};
                            for (let i = 0, l = getters.length; i < l; i++) {
                                const getter = getters[i];
                                compiledGetters[getter] = compileGetter(getter)
                            }
                            return function(obj, options) {
                                let result;
                                (0, _iterator.each)(compiledGetters, (function(name) {
                                    const value = this(obj, options);
                                    if (void 0 === value) {
                                        return
                                    }
                                    let current = result || (result = {});
                                    const path = name.split(".");
                                    const last = path.length - 1;
                                    for (let i = 0; i < last; i++) {
                                        const pathItem = path[i];
                                        if (!(pathItem in current)) {
                                            current[pathItem] = {}
                                        }
                                        current = current[pathItem]
                                    }
                                    current[path[last]] = value
                                }));
                                return result
                            }
                        }(expr)
                    }
                    if ((0, _type.isFunction)(expr)) {
                        return expr
                    }
                };
                exports.compileGetter = compileGetter;

                function toLowerCase(value, options) {
                    return null !== options && void 0 !== options && options.locale ? value.toLocaleLowerCase(options.locale) : value.toLowerCase()
                }

                function toUpperCase(value, options) {
                    return null !== options && void 0 !== options && options.locale ? value.toLocaleUpperCase(options.locale) : value.toUpperCase()
                }
                const ensurePropValueDefined = function(obj, propName, value, options) {
                    if ((0, _type.isDefined)(value)) {
                        return value
                    }
                    const newValue = {};
                    assignPropValue(obj, propName, newValue, options);
                    return newValue
                };
                exports.compileSetter = function(expr) {
                    expr = getPathParts(expr || "this");
                    const lastLevelIndex = expr.length - 1;
                    return function(obj, value, options) {
                        options = prepareOptions(options);
                        let currentValue = unwrap(obj, options);
                        expr.forEach((function(propertyName, levelIndex) {
                            let propertyValue = function(obj, propName, options) {
                                options = options || {};
                                if ("this" === propName) {
                                    return unwrap(obj, options)
                                }
                                return unwrap(obj[propName], options)
                            }(currentValue, propertyName, options);
                            const isPropertyFunc = !options.functionsAsIs && (0, _type.isFunction)(propertyValue) && !isWrapped(propertyValue);
                            if (levelIndex === lastLevelIndex) {
                                if (options.merge && (0, _type.isPlainObject)(value) && (!(0, _type.isDefined)(propertyValue) || (0, _type.isPlainObject)(propertyValue))) {
                                    propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                                    (0, _object.deepExtendArraySafe)(propertyValue, value, false, true)
                                } else if (isPropertyFunc) {
                                    currentValue[propertyName](value)
                                } else {
                                    assignPropValue(currentValue, propertyName, value, options)
                                }
                            } else {
                                propertyValue = ensurePropValueDefined(currentValue, propertyName, propertyValue, options);
                                if (isPropertyFunc) {
                                    propertyValue = propertyValue.call(currentValue)
                                }
                                currentValue = propertyValue
                            }
                        }))
                    }
                };
                exports.toComparable = function(value, caseSensitive) {
                    var _options$collatorOpti;
                    let options = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
                    if (value instanceof Date) {
                        return value.getTime()
                    }
                    const collatorSensitivity = null === options || void 0 === options || null === (_options$collatorOpti = options.collatorOptions) || void 0 === _options$collatorOpti ? void 0 : _options$collatorOpti.sensitivity;
                    if (value && value instanceof _class.default && value.valueOf) {
                        value = value.valueOf()
                    } else if ("string" === typeof value && ("base" === collatorSensitivity || "case" === collatorSensitivity)) {
                        const REMOVE_DIACRITICAL_MARKS_REGEXP = /[\u0300-\u036f]/g;
                        if ("base" === collatorSensitivity) {
                            value = toLowerCase(value, options)
                        }
                        value = value.normalize("NFD").replace(REMOVE_DIACRITICAL_MARKS_REGEXP, "")
                    }
                    const isCaseSensitive = caseSensitive || "case" === collatorSensitivity || "variant" === collatorSensitivity;
                    if ("string" === typeof value && !isCaseSensitive) {
                        var _options$locale;
                        const locale = null === options || void 0 === options || null === (_options$locale = options.locale) || void 0 === _options$locale ? void 0 : _options$locale.toLowerCase();
                        const useUpperCase = locale && !!["hy", "el"].find((code => locale === code || locale.startsWith(`${code}-`)));
                        return (useUpperCase ? toUpperCase : toLowerCase)(value, options)
                    }
                    return value
                }
            },
        66570:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_date.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.dateUtils = void 0;
                var _date_serialization = (obj = __webpack_require__( /*! ../../../core/utils/date_serialization */ 71051), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _inflector = __webpack_require__( /*! ../../../core/utils/inflector */ 53124);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 21274);
                var _math = __webpack_require__( /*! ../../../core/utils/math */ 50254);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _toMilliseconds = __webpack_require__( /*! ../../utils/toMilliseconds */ 24491);
                const DAYS_IN_WEEK = 7;
                const dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "week", "month", "quarter", "year"];
                const convertMillisecondsToDateUnits = function(value) {
                    let i;
                    let dateUnitCount;
                    let dateUnitInterval;
                    const dateUnitIntervals = ["millisecond", "second", "minute", "hour", "day", "month", "year"];
                    const result = {};
                    for (i = dateUnitIntervals.length - 1; i >= 0; i--) {
                        dateUnitInterval = dateUnitIntervals[i];
                        dateUnitCount = Math.floor(value / (0, _toMilliseconds.toMilliseconds)(dateUnitInterval));
                        if (dateUnitCount > 0) {
                            result[`${dateUnitInterval}s`] = dateUnitCount;
                            value -= convertDateUnitToMilliseconds(dateUnitInterval, dateUnitCount)
                        }
                    }
                    return result
                };

                function convertDateUnitToMilliseconds(dateUnit, count) {
                    return (0, _toMilliseconds.toMilliseconds)(dateUnit) * count
                }

                function getDateUnitInterval(tickInterval) {
                    let maxInterval = -1;
                    let i;
                    if ((0, _type.isString)(tickInterval)) {
                        return tickInterval
                    }
                    if ((0, _type.isObject)(tickInterval)) {
                        (0, _iterator.each)(tickInterval, (function(key, value) {
                            for (i = 0; i < dateUnitIntervals.length; i++) {
                                if (value && (key === `${dateUnitIntervals[i]}s` || key === dateUnitIntervals[i]) && maxInterval < i) {
                                    maxInterval = i
                                }
                            }
                        }));
                        return dateUnitIntervals[maxInterval]
                    }
                    return ""
                }
                const tickIntervalToFormatMap = {
                    millisecond: "millisecond",
                    second: "longtime",
                    minute: "shorttime",
                    hour: "shorttime",
                    day: "day",
                    week: "day",
                    month: "month",
                    quarter: "quarter",
                    year: "year"
                };
                const getQuarter = function(month) {
                    return Math.floor(month / 3)
                };
                const getFirstQuarterMonth = function(month) {
                    return 3 * getQuarter(month)
                };

                function correctDateWithUnitBeginning(date, dateInterval, withCorrection, firstDayOfWeek) {
                    date = new Date(date.getTime());
                    const oldDate = new Date(date.getTime());
                    let firstQuarterMonth;
                    let month;
                    const dateUnitInterval = getDateUnitInterval(dateInterval);
                    switch (dateUnitInterval) {
                        case "second":
                            date = new Date(1e3 * Math.floor(oldDate.getTime() / 1e3));
                            break;
                        case "minute":
                            date = new Date(6e4 * Math.floor(oldDate.getTime() / 6e4));
                            break;
                        case "hour":
                            date = new Date(36e5 * Math.floor(oldDate.getTime() / 36e5));
                            break;
                        case "year":
                            date.setMonth(0);
                        case "month":
                            date.setDate(1);
                        case "day":
                            date.setHours(0, 0, 0, 0);
                            break;
                        case "week":
                            date = getFirstWeekDate(date, firstDayOfWeek || 0);
                            date.setHours(0, 0, 0, 0);
                            break;
                        case "quarter":
                            firstQuarterMonth = getFirstQuarterMonth(date.getMonth());
                            month = date.getMonth();
                            date.setDate(1);
                            date.setHours(0, 0, 0, 0);
                            if (month !== firstQuarterMonth) {
                                date.setMonth(firstQuarterMonth)
                            }
                    }
                    if (withCorrection && "hour" !== dateUnitInterval && "minute" !== dateUnitInterval && "second" !== dateUnitInterval) {
                        fixTimezoneGap(oldDate, date)
                    }
                    return date
                }

                function trimTime(date) {
                    return correctDateWithUnitBeginning(date, "day")
                }

                function addDateInterval(value, interval, dir) {
                    const result = new Date(value.getTime());
                    const intervalObject = (0, _type.isString)(interval) ? getDateIntervalByString(interval.toLowerCase()) : (0, _type.isNumeric)(interval) ? convertMillisecondsToDateUnits(interval) : interval;
                    if (intervalObject.years) {
                        result.setFullYear(result.getFullYear() + intervalObject.years * dir)
                    }
                    if (intervalObject.quarters) {
                        result.setMonth(result.getMonth() + 3 * intervalObject.quarters * dir)
                    }
                    if (intervalObject.months) {
                        result.setMonth(result.getMonth() + intervalObject.months * dir)
                    }
                    if (intervalObject.weeks) {
                        result.setDate(result.getDate() + 7 * intervalObject.weeks * dir)
                    }
                    if (intervalObject.days) {
                        result.setDate(result.getDate() + intervalObject.days * dir)
                    }
                    if (intervalObject.hours) {
                        result.setTime(result.getTime() + 36e5 * intervalObject.hours * dir)
                    }
                    if (intervalObject.minutes) {
                        result.setTime(result.getTime() + 6e4 * intervalObject.minutes * dir)
                    }
                    if (intervalObject.seconds) {
                        result.setTime(result.getTime() + 1e3 * intervalObject.seconds * dir)
                    }
                    if (intervalObject.milliseconds) {
                        result.setTime(result.getTime() + intervalObject.milliseconds * dir)
                    }
                    return result
                }
                const addInterval = function(value, interval, isNegative) {
                    const dir = isNegative ? -1 : 1;
                    return (0, _type.isDate)(value) ? addDateInterval(value, interval, dir) : (0, _math.adjust)(value + interval * dir, interval)
                };

                function getLastMonthDay(date) {
                    const resultDate = createDateWithFullYear(date.getFullYear(), date.getMonth() + 1, 0);
                    return resultDate.getDate()
                }

                function getDateIntervalByString(intervalString) {
                    const result = {};
                    switch (intervalString) {
                        case "year":
                            result.years = 1;
                            break;
                        case "month":
                            result.months = 1;
                            break;
                        case "quarter":
                            result.months = 3;
                            break;
                        case "week":
                            result.weeks = 1;
                            break;
                        case "day":
                            result.days = 1;
                            break;
                        case "hour":
                            result.hours = 1;
                            break;
                        case "minute":
                            result.minutes = 1;
                            break;
                        case "second":
                            result.seconds = 1;
                            break;
                        case "millisecond":
                            result.milliseconds = 1
                    }
                    return result
                }

                function sameMonthAndYear(date1, date2) {
                    return sameYear(date1, date2) && date1.getMonth() === date2.getMonth()
                }

                function sameYear(date1, date2) {
                    return date1 && date2 && date1.getFullYear() === date2.getFullYear()
                }

                function getFirstDecadeInCentury(date) {
                    return date && date.getFullYear() - date.getFullYear() % 100
                }

                function getFirstYearInDecade(date) {
                    return date && date.getFullYear() - date.getFullYear() % 10
                }

                function getFirstWeekDate(date, firstDayOfWeek) {
                    const delta = (date.getDay() - firstDayOfWeek + DAYS_IN_WEEK) % DAYS_IN_WEEK;
                    const result = new Date(date);
                    result.setDate(date.getDate() - delta);
                    return result
                }

                function getUTCTime(date) {
                    return Date.UTC(date.getFullYear(), date.getMonth(), date.getDate())
                }

                function getFirstDateInYear(year) {
                    return new Date(year, 0, 1)
                }

                function getLastDateInYear(year) {
                    return new Date(year, 11, 31)
                }

                function getDayWeekNumber(date, firstDayOfWeek) {
                    let day = date.getDay() - firstDayOfWeek + 1;
                    if (day <= 0) {
                        day += DAYS_IN_WEEK
                    }
                    return day
                }

                function normalizeDate(date, min, max) {
                    let normalizedDate = date;
                    if (!(0, _type.isDefined)(date)) {
                        return date
                    }
                    if ((0, _type.isDefined)(min) && date < min) {
                        normalizedDate = min
                    }
                    if ((0, _type.isDefined)(max) && date > max) {
                        normalizedDate = max
                    }
                    return normalizedDate
                }

                function fixTimezoneGap(oldDate, newDate) {
                    if (!(0, _type.isDefined)(oldDate)) {
                        return
                    }
                    const diff = newDate.getHours() - oldDate.getHours();
                    if (0 === diff) {
                        return
                    }
                    const sign = 1 === diff || -23 === diff ? -1 : 1;
                    const trial = new Date(newDate.getTime() + 36e5 * sign);
                    if (sign > 0 || trial.getDate() === newDate.getDate()) {
                        newDate.setTime(trial.getTime())
                    }
                }

                function getTimezonesDifference(min, max) {
                    return 60 * (max.getTimezoneOffset() - min.getTimezoneOffset()) * 1e3
                }
                const createDateWithFullYear = function(year) {
                    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                        args[_key - 1] = arguments[_key]
                    }
                    const result = new Date(year, ...args);
                    result.setFullYear(year);
                    return result
                };
                const dateUtils = exports.dateUtils = {
                    dateUnitIntervals: dateUnitIntervals,
                    convertMillisecondsToDateUnits: convertMillisecondsToDateUnits,
                    dateToMilliseconds: function(tickInterval) {
                        let milliseconds = 0;
                        if ((0, _type.isObject)(tickInterval)) {
                            (0, _iterator.each)(tickInterval, (function(key, value) {
                                milliseconds += convertDateUnitToMilliseconds(key.substr(0, key.length - 1), value)
                            }))
                        }
                        if ((0, _type.isString)(tickInterval)) {
                            milliseconds = convertDateUnitToMilliseconds(tickInterval, 1)
                        }
                        return milliseconds
                    },
                    getNextDateUnit: function(unit, withWeeks) {
                        const interval = getDateUnitInterval(unit);
                        switch (interval) {
                            case "millisecond":
                                return "second";
                            case "second":
                                return "minute";
                            case "minute":
                                return "hour";
                            case "hour":
                                return "day";
                            case "day":
                                return withWeeks ? "week" : "month";
                            case "week":
                                return "month";
                            case "month":
                                return "quarter";
                            case "quarter":
                            case "year":
                                return "year";
                            default:
                                return 0
                        }
                    },
                    convertDateUnitToMilliseconds: convertDateUnitToMilliseconds,
                    getDateUnitInterval: getDateUnitInterval,
                    getDateFormatByTickInterval: function(tickInterval) {
                        return tickIntervalToFormatMap[getDateUnitInterval(tickInterval)] || ""
                    },
                    getDatesDifferences: function(date1, date2) {
                        let counter = 0;
                        const differences = {
                            year: date1.getFullYear() !== date2.getFullYear(),
                            month: date1.getMonth() !== date2.getMonth(),
                            day: date1.getDate() !== date2.getDate(),
                            hour: date1.getHours() !== date2.getHours(),
                            minute: date1.getMinutes() !== date2.getMinutes(),
                            second: date1.getSeconds() !== date2.getSeconds(),
                            millisecond: date1.getMilliseconds() !== date2.getMilliseconds()
                        };
                        (0, _iterator.each)(differences, (function(key, value) {
                            if (value) {
                                counter++
                            }
                        }));
                        if (0 === counter && 0 !== getTimezonesDifference(date1, date2)) {
                            differences.hour = true;
                            counter++
                        }
                        differences.count = counter;
                        return differences
                    },
                    correctDateWithUnitBeginning: correctDateWithUnitBeginning,
                    trimTime: trimTime,
                    setToDayEnd: function(date) {
                        const result = trimTime(date);
                        result.setDate(result.getDate() + 1);
                        return new Date(result.getTime() - 1)
                    },
                    roundDateByStartDayHour: function(date, startDayHour) {
                        const startTime = this.dateTimeFromDecimal(startDayHour);
                        const result = new Date(date);
                        if (date.getHours() === startTime.hours && date.getMinutes() < startTime.minutes || date.getHours() < startTime.hours) {
                            result.setHours(startTime.hours, startTime.minutes, 0, 0)
                        }
                        return result
                    },
                    dateTimeFromDecimal: function(number) {
                        const hours = Math.floor(number);
                        const minutes = number % 1 * 60;
                        return {
                            hours: hours,
                            minutes: minutes
                        }
                    },
                    addDateInterval: addDateInterval,
                    addInterval: addInterval,
                    getSequenceByInterval: function(min, max, interval) {
                        const intervals = [];
                        let cur;
                        intervals.push((0, _type.isDate)(min) ? new Date(min.getTime()) : min);
                        cur = min;
                        while (cur < max) {
                            cur = addInterval(cur, interval);
                            intervals.push(cur)
                        }
                        return intervals
                    },
                    getDateIntervalByString: getDateIntervalByString,
                    sameHoursAndMinutes: function(date1, date2) {
                        return date1 && date2 && date1.getHours() === date2.getHours() && date1.getMinutes() === date2.getMinutes()
                    },
                    sameDate: function(date1, date2) {
                        return sameMonthAndYear(date1, date2) && date1.getDate() === date2.getDate()
                    },
                    sameMonthAndYear: sameMonthAndYear,
                    sameMonth: sameMonthAndYear,
                    sameYear: sameYear,
                    sameDecade: function(date1, date2) {
                        if (!(0, _type.isDefined)(date1) || !(0, _type.isDefined)(date2)) {
                            return
                        }
                        const startDecadeDate1 = date1.getFullYear() - date1.getFullYear() % 10;
                        const startDecadeDate2 = date2.getFullYear() - date2.getFullYear() % 10;
                        return date1 && date2 && startDecadeDate1 === startDecadeDate2
                    },
                    sameCentury: function(date1, date2) {
                        if (!(0, _type.isDefined)(date1) || !(0, _type.isDefined)(date2)) {
                            return
                        }
                        const startCenturyDate1 = date1.getFullYear() - date1.getFullYear() % 100;
                        const startCenturyDate2 = date2.getFullYear() - date2.getFullYear() % 100;
                        return date1 && date2 && startCenturyDate1 === startCenturyDate2
                    },
                    sameView: function(view, date1, date2) {
                        return dateUtils[(0, _inflector.camelize)(`same ${view}`)](date1, date2)
                    },
                    getDifferenceInMonth: function(typeView) {
                        let difference = 1;
                        if ("year" === typeView) {
                            difference = 12
                        }
                        if ("decade" === typeView) {
                            difference = 120
                        }
                        if ("century" === typeView) {
                            difference = 1200
                        }
                        return difference
                    },
                    getDifferenceInMonthForCells: function(typeView) {
                        let difference = 1;
                        if ("decade" === typeView) {
                            difference = 12
                        }
                        if ("century" === typeView) {
                            difference = 120
                        }
                        return difference
                    },
                    getFirstYearInDecade: getFirstYearInDecade,
                    getFirstDecadeInCentury: getFirstDecadeInCentury,
                    getShortDateFormat: function() {
                        return "yyyy/MM/dd"
                    },
                    getViewFirstCellDate: function(viewType, date) {
                        if ("month" === viewType) {
                            return createDateWithFullYear(date.getFullYear(), date.getMonth(), 1)
                        }
                        if ("year" === viewType) {
                            return createDateWithFullYear(date.getFullYear(), 0, date.getDate())
                        }
                        if ("decade" === viewType) {
                            return createDateWithFullYear(getFirstYearInDecade(date), date.getMonth(), date.getDate())
                        }
                        if ("century" === viewType) {
                            return createDateWithFullYear(getFirstDecadeInCentury(date), date.getMonth(), date.getDate())
                        }
                    },
                    getViewLastCellDate: function(viewType, date) {
                        if ("month" === viewType) {
                            return createDateWithFullYear(date.getFullYear(), date.getMonth(), getLastMonthDay(date))
                        }
                        if ("year" === viewType) {
                            return createDateWithFullYear(date.getFullYear(), 11, date.getDate())
                        }
                        if ("decade" === viewType) {
                            return createDateWithFullYear(getFirstYearInDecade(date) + 9, date.getMonth(), date.getDate())
                        }
                        if ("century" === viewType) {
                            return createDateWithFullYear(getFirstDecadeInCentury(date) + 90, date.getMonth(), date.getDate())
                        }
                    },
                    getViewDown: function(typeView) {
                        switch (typeView) {
                            case "century":
                                return "decade";
                            case "decade":
                                return "year";
                            case "year":
                                return "month"
                        }
                    },
                    getViewUp: function(typeView) {
                        switch (typeView) {
                            case "month":
                                return "year";
                            case "year":
                                return "decade";
                            case "decade":
                                return "century"
                        }
                    },
                    getLastMonthDay: getLastMonthDay,
                    getLastMonthDate: function(date) {
                        if (!(0, _type.isDefined)(date)) {
                            return
                        }
                        return createDateWithFullYear(date.getFullYear(), date.getMonth() + 1, 0)
                    },
                    getFirstMonthDate: function(date) {
                        if (!(0, _type.isDefined)(date)) {
                            return
                        }
                        return createDateWithFullYear(date.getFullYear(), date.getMonth(), 1)
                    },
                    getFirstWeekDate: getFirstWeekDate,
                    getWeekNumber: function getWeekNumber(date, firstDayOfWeek, rule) {
                        const firstWeekDayInYear = getDayWeekNumber(getFirstDateInYear(date.getFullYear()), firstDayOfWeek);
                        const lastWeekDayInYear = getDayWeekNumber(getLastDateInYear(date.getFullYear()), firstDayOfWeek);
                        const daysInFirstWeek = DAYS_IN_WEEK - firstWeekDayInYear + 1;
                        let weekNumber = Math.ceil((function(date) {
                            const ms = getUTCTime(date) - getUTCTime(getFirstDateInYear(date.getFullYear()));
                            return 1 + Math.floor(ms / (0, _toMilliseconds.toMilliseconds)("day"))
                        }(date) - daysInFirstWeek) / 7);
                        switch (rule) {
                            case "fullWeek":
                                if (daysInFirstWeek === DAYS_IN_WEEK) {
                                    weekNumber++
                                }
                                if (0 === weekNumber) {
                                    const lastDateInPreviousYear = getLastDateInYear(date.getFullYear() - 1);
                                    return getWeekNumber(lastDateInPreviousYear, firstDayOfWeek, rule)
                                }
                                return weekNumber;
                            case "firstDay": {
                                if (daysInFirstWeek > 0) {
                                    weekNumber++
                                }
                                const isSunday = 7 === firstWeekDayInYear || 7 === lastWeekDayInYear;
                                if (weekNumber > 52 && !isSunday || 54 === weekNumber) {
                                    weekNumber = 1
                                }
                                return weekNumber
                            }
                            case "firstFourDays": {
                                if (daysInFirstWeek > 3) {
                                    weekNumber++
                                }
                                const isThursday = 4 === firstWeekDayInYear || 4 === lastWeekDayInYear;
                                if (weekNumber > 52 && !isThursday) {
                                    weekNumber = 1
                                }
                                if (0 === weekNumber) {
                                    const lastDateInPreviousYear = getLastDateInYear(date.getFullYear() - 1);
                                    return getWeekNumber(lastDateInPreviousYear, firstDayOfWeek, rule)
                                }
                                return weekNumber
                            }
                        }
                    },
                    normalizeDateByWeek: function(date, currentDate) {
                        const differenceInDays = dateUtils.getDatesInterval(date, currentDate, "day");
                        let resultDate = new Date(date);
                        if (differenceInDays >= 6) {
                            resultDate = new Date(resultDate.setDate(resultDate.getDate() + 7))
                        }
                        return resultDate
                    },
                    getQuarter: getQuarter,
                    getFirstQuarterMonth: getFirstQuarterMonth,
                    dateInRange: function(date, min, max, format) {
                        if ("date" === format) {
                            min = min && dateUtils.correctDateWithUnitBeginning(min, "day");
                            max = max && dateUtils.correctDateWithUnitBeginning(max, "day");
                            date = date && dateUtils.correctDateWithUnitBeginning(date, "day")
                        }
                        return normalizeDate(date, min, max) === date
                    },
                    intervalsOverlap: function(options) {
                        const {
                            firstMin: firstMin,
                            firstMax: firstMax,
                            secondMin: secondMin,
                            secondMax: secondMax
                        } = options;
                        return firstMin <= secondMin && secondMin <= firstMax || firstMin > secondMin && firstMin < secondMax || firstMin < secondMax && firstMax > secondMax
                    },
                    roundToHour: function(date) {
                        const result = new Date(date.getTime());
                        result.setHours(result.getHours() + 1);
                        result.setMinutes(0);
                        return result
                    },
                    normalizeDate: normalizeDate,
                    getViewMinBoundaryDate: function(viewType, date) {
                        const resultDate = createDateWithFullYear(date.getFullYear(), date.getMonth(), 1);
                        if ("month" === viewType) {
                            return resultDate
                        }
                        resultDate.setMonth(0);
                        if ("year" === viewType) {
                            return resultDate
                        }
                        if ("decade" === viewType) {
                            resultDate.setFullYear(getFirstYearInDecade(date))
                        }
                        if ("century" === viewType) {
                            resultDate.setFullYear(getFirstDecadeInCentury(date))
                        }
                        return resultDate
                    },
                    getViewMaxBoundaryDate: function(viewType, date) {
                        const resultDate = new Date(date);
                        resultDate.setDate(getLastMonthDay(date));
                        if ("month" === viewType) {
                            return resultDate
                        }
                        resultDate.setMonth(11);
                        resultDate.setDate(getLastMonthDay(resultDate));
                        if ("year" === viewType) {
                            return resultDate
                        }
                        if ("decade" === viewType) {
                            resultDate.setFullYear(getFirstYearInDecade(date) + 9)
                        }
                        if ("century" === viewType) {
                            resultDate.setFullYear(getFirstDecadeInCentury(date) + 99)
                        }
                        return resultDate
                    },
                    fixTimezoneGap: fixTimezoneGap,
                    getTimezonesDifference: getTimezonesDifference,
                    makeDate: function(date) {
                        return new Date(date)
                    },
                    getDatesInterval: function(startDate, endDate, intervalUnit) {
                        const delta = endDate.getTime() - startDate.getTime();
                        const millisecondCount = (0, _toMilliseconds.toMilliseconds)(intervalUnit) || 1;
                        return Math.floor(delta / millisecondCount)
                    },
                    getDatesOfInterval: function(startDate, endDate, step) {
                        const result = [];
                        let currentDate = new Date(startDate.getTime());
                        while (currentDate < endDate) {
                            result.push(new Date(currentDate.getTime()));
                            currentDate = this.addInterval(currentDate, step)
                        }
                        return result
                    },
                    createDateWithFullYear: createDateWithFullYear,
                    getMachineTimezoneName: () => {
                        const hasIntl = "undefined" !== typeof Intl;
                        return hasIntl ? Intl.DateTimeFormat().resolvedOptions().timeZone : null
                    },
                    getRangesByDates: dates => {
                        const datesInMilliseconds = dates.map((value => correctDateWithUnitBeginning(value, "day").getTime()));
                        const sortedDates = datesInMilliseconds.sort(((a, b) => a - b));
                        const msInDay = (0, _toMilliseconds.toMilliseconds)("day");
                        const ranges = [];
                        let startDate = sortedDates[0];
                        for (let i = 1; i <= sortedDates.length; ++i) {
                            const nextDate = sortedDates[i];
                            const currentDate = sortedDates[i - 1];
                            const isNewRange = nextDate - currentDate > msInDay;
                            if (isNewRange || i === sortedDates.length) {
                                const range = startDate === sortedDates[i - 1] ? [startDate] : [startDate, sortedDates[i - 1]];
                                const serializedRange = range.map((value => _date_serialization.default.deserializeDate(value)));
                                ranges.push(serializedRange);
                                startDate = nextDate
                            }
                        }
                        return ranges
                    }
                }
            },
        62897:
            /*!*******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_date_serialization.js ***!
              \*******************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.dateSerialization = void 0;
                var _config = _interopRequireDefault(__webpack_require__( /*! ../../../core/config */ 66636));
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _default_date_names = _interopRequireDefault(__webpack_require__( /*! ../../../localization/default_date_names */ 29761));
                var _date = __webpack_require__( /*! ../../../localization/ldml/date.formatter */ 45588);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const ISO8601_PATTERN = /^(\d{4,})(-)?(\d{2})(-)?(\d{2})(?:T(\d{2})(:)?(\d{2})?(:)?(\d{2}(?:\.(\d{1,3})\d*)?)?)?(Z|([+-])(\d{2})(:)?(\d{2})?)?$/;
                const ISO8601_TIME_PATTERN = /^(\d{2}):(\d{2})(:(\d{2}))?$/;
                const ISO8601_PATTERN_PARTS = ["", "yyyy", "", "MM", "", "dd", "THH", "", "mm", "", "ss", ".SSS"];
                const DATE_SERIALIZATION_PATTERN = /^(\d{4})\/(\d{2})\/(\d{2})$/;
                const dateParser = function(text, skipISO8601Parsing) {
                    let result;
                    if ((0, _type.isString)(text) && !skipISO8601Parsing) {
                        result = function(text) {
                            let parts = text.match(ISO8601_PATTERN);
                            if (!parts) {
                                parts = text.match(ISO8601_TIME_PATTERN);
                                if (parts) {
                                    return new Date(0, 0, 0, getTimePart(parts[1]), getTimePart(parts[2]), getTimePart(parts[4]))
                                }
                                return
                            }
                            const year = getTimePart(parts[1]);
                            const month = --parts[3];
                            const day = parts[5];
                            let timeZoneHour = 0;
                            let timeZoneMinute = 0;
                            const correctYear = d => {
                                year < 100 && d.setFullYear(year);
                                return d
                            };
                            timeZoneHour = getTimePart(parts[14]);
                            timeZoneMinute = getTimePart(parts[16]);
                            if ("-" === parts[13]) {
                                timeZoneHour = -timeZoneHour;
                                timeZoneMinute = -timeZoneMinute
                            }
                            const hour = getTimePart(parts[6]) - timeZoneHour;
                            const minute = getTimePart(parts[8]) - timeZoneMinute;
                            const second = getTimePart(parts[10]);
                            const parseMilliseconds = function(part) {
                                part = part || "";
                                return getTimePart(part) * 10 ** (3 - part.length)
                            };
                            const millisecond = parseMilliseconds(parts[11]);
                            if (parts[12]) {
                                return correctYear(new Date(Date.UTC(year, month, day, hour, minute, second, millisecond)))
                            }
                            return correctYear(new Date(year, month, day, hour, minute, second, millisecond))
                        }(text)
                    }
                    return result || function(text) {
                        const isDefaultSerializationFormat = "yyyy/MM/dd" === getDateSerializationFormat(text);
                        const parsedValue = !(0, _type.isDate)(text) && Date.parse(text);
                        if (!parsedValue && isDefaultSerializationFormat) {
                            const parts = text.match(DATE_SERIALIZATION_PATTERN);
                            if (parts) {
                                const newDate = new Date(getTimePart(parts[1]), getTimePart(parts[2]), getTimePart(parts[3]));
                                newDate.setFullYear(getTimePart(parts[1]));
                                newDate.setMonth(getTimePart(parts[2]) - 1);
                                newDate.setDate(getTimePart(parts[3]));
                                return newDate
                            }
                        }
                        return (0, _type.isNumeric)(parsedValue) ? new Date(parsedValue) : text
                    }(text)
                };

                function getTimePart(part) {
                    return +part || 0
                }
                const getDateSerializationFormat = function(value) {
                    if ("number" === typeof value) {
                        return "number"
                    }
                    if ((0, _type.isString)(value)) {
                        let format;
                        if ((0, _config.default)().forceIsoDateParsing) {
                            format = function(text, useUtc) {
                                let parts = text.match(ISO8601_PATTERN);
                                let result = "";
                                if (!parts) {
                                    parts = text.match(ISO8601_TIME_PATTERN);
                                    if (parts) {
                                        return parts[3] ? "HH:mm:ss" : "HH:mm"
                                    }
                                    return
                                }
                                for (let i = 1; i < ISO8601_PATTERN_PARTS.length; i++) {
                                    if (parts[i]) {
                                        result += ISO8601_PATTERN_PARTS[i] || parts[i]
                                    }
                                }
                                if ("Z" === parts[12]) {
                                    result += "'Z'"
                                }
                                if (parts[14]) {
                                    if (parts[15]) {
                                        result += "xxx"
                                    } else if (parts[16]) {
                                        result += "xx"
                                    } else {
                                        result += "x"
                                    }
                                }
                                return result
                            }(value)
                        }
                        if (format) {
                            return format
                        }
                        if (value.includes(":")) {
                            return "yyyy/MM/dd HH:mm:ss"
                        }
                        return "yyyy/MM/dd"
                    }
                    if (value) {
                        return null
                    }
                };
                exports.dateSerialization = {
                    dateParser: dateParser,
                    deserializeDate: function(value) {
                        if ("number" === typeof value) {
                            return new Date(value)
                        }
                        return dateParser(value, !(0, _config.default)().forceIsoDateParsing)
                    },
                    serializeDate: function(value, serializationFormat) {
                        if (!serializationFormat) {
                            return value
                        }
                        if (!(0, _type.isDate)(value)) {
                            return null
                        }
                        if ("number" === serializationFormat) {
                            return value && value.valueOf ? value.valueOf() : null
                        }
                        return (0, _date.getFormatter)(serializationFormat, _default_date_names.default)(value)
                    },
                    getDateSerializationFormat: getDateSerializationFormat
                }
            },
        77117:
            /*!*********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_deferred.js ***!
              \*********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Deferred = function() {
                    return new DeferredObj
                };
                exports.fromPromise = fromPromise;
                exports.setStrategy = function(value) {
                    DeferredObj = value.Deferred;
                    whenFunc = value.when
                };
                exports.when = function() {
                    return whenFunc.apply(this, arguments)
                };
                var _callbacks = (obj = __webpack_require__( /*! ../../../core/utils/callbacks */ 84718), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                const deferredConfig = [{
                    method: "resolve",
                    handler: "done",
                    state: "resolved"
                }, {
                    method: "reject",
                    handler: "fail",
                    state: "rejected"
                }, {
                    method: "notify",
                    handler: "progress"
                }];
                let DeferredObj = function() {
                    const that = this;
                    this._state = "pending";
                    this._promise = {};
                    deferredConfig.forEach(function(config) {
                        const methodName = config.method;
                        this[`${methodName}Callbacks`] = (0, _callbacks.default)();
                        this[methodName] = function() {
                            return this[`${methodName}With`](this._promise, arguments)
                        }.bind(this);
                        this._promise[config.handler] = function(handler) {
                            if (!handler) {
                                return this
                            }
                            const callbacks = that[`${methodName}Callbacks`];
                            if (callbacks.fired()) {
                                handler.apply(that[`${methodName}Context`], that[`${methodName}Args`])
                            } else {
                                callbacks.add((function(context, args) {
                                    handler.apply(context, args)
                                }))
                            }
                            return this
                        }
                    }.bind(this));
                    this._promise.always = function(handler) {
                        return this.done(handler).fail(handler)
                    };
                    this._promise.catch = function(handler) {
                        return this.then(null, handler)
                    };
                    this._promise.then = function(resolve, reject) {
                        const result = new DeferredObj;
                        ["done", "fail"].forEach(function(method) {
                            const callback = "done" === method ? resolve : reject;
                            this[method]((function() {
                                if (!callback) {
                                    result["done" === method ? "resolve" : "reject"].apply(this, arguments);
                                    return
                                }
                                const callbackResult = callback && callback.apply(this, arguments);
                                if ((0, _type.isDeferred)(callbackResult)) {
                                    callbackResult.done(result.resolve).fail(result.reject)
                                } else if ((0, _type.isPromise)(callbackResult)) {
                                    callbackResult.then(result.resolve, result.reject)
                                } else {
                                    result.resolve.apply(this, (0, _type.isDefined)(callbackResult) ? [callbackResult] : arguments)
                                }
                            }))
                        }.bind(this));
                        return result.promise()
                    };
                    this._promise.state = function() {
                        return that._state
                    };
                    this._promise.promise = function(args) {
                        return args ? (0, _extend.extend)(args, that._promise) : that._promise
                    };
                    this._promise.promise(this)
                };
                deferredConfig.forEach((function(config) {
                    const methodName = config.method;
                    const {
                        state: state
                    } = config;
                    DeferredObj.prototype[`${methodName}With`] = function(context, args) {
                        const callbacks = this[`${methodName}Callbacks`];
                        if ("pending" === this.state()) {
                            this[`${methodName}Args`] = args;
                            this[`${methodName}Context`] = context;
                            if (state) {
                                this._state = state
                            }
                            callbacks.fire(context, args);
                            if ("pending" !== state) {
                                this.resolveCallbacks.empty();
                                this.rejectCallbacks.empty()
                            }
                        }
                        return this
                    }
                }));

                function fromPromise(promise, context) {
                    if ((0, _type.isDeferred)(promise)) {
                        return promise
                    }
                    if ((0, _type.isPromise)(promise)) {
                        const d = new DeferredObj;
                        promise.then((function() {
                            d.resolveWith.apply(d, [context].concat([
                                [].slice.call(arguments)
                            ]))
                        }), (function() {
                            d.rejectWith.apply(d, [context].concat([
                                [].slice.call(arguments)
                            ]))
                        }));
                        return d
                    }
                    return (new DeferredObj).resolveWith(context, [promise])
                }
                let whenFunc = function() {
                    if (1 === arguments.length) {
                        return fromPromise(arguments[0])
                    }
                    const values = [].slice.call(arguments);
                    const contexts = [];
                    let resolvedCount = 0;
                    const deferred = new DeferredObj;
                    const updateState = function(i) {
                        return function(value) {
                            contexts[i] = this;
                            values[i] = arguments.length > 1 ? [].slice.call(arguments) : value;
                            resolvedCount++;
                            if (resolvedCount === values.length) {
                                deferred.resolveWith(contexts, values)
                            }
                        }
                    };
                    for (let i = 0; i < values.length; i++) {
                        if ((0, _type.isDeferred)(values[i])) {
                            values[i].promise().done(updateState(i)).fail(deferred.reject)
                        } else {
                            resolvedCount++
                        }
                    }
                    if (resolvedCount === values.length) {
                        deferred.resolveWith(contexts, values)
                    }
                    return deferred.promise()
                }
            },
        62142:
            /*!********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_dependency_injector.js ***!
              \********************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.injector = function(object) {
                    const BaseClass = _class.default.inherit(object);
                    let InjectedClass = BaseClass;
                    let instance = new InjectedClass(object);
                    const initialFields = {};
                    const injectFields = function(injectionObject, initial) {
                        (0, _iterator.each)(injectionObject, (function(key) {
                            if ((0, _type.isFunction)(instance[key])) {
                                if (initial || !object[key]) {
                                    object[key] = function() {
                                        return instance[key].apply(object, arguments)
                                    }
                                }
                            } else {
                                if (initial) {
                                    initialFields[key] = object[key]
                                }
                                object[key] = instance[key]
                            }
                        }))
                    };
                    injectFields(object, true);
                    object.inject = function(injectionObject) {
                        InjectedClass = InjectedClass.inherit(injectionObject);
                        instance = new InjectedClass;
                        injectFields(injectionObject)
                    };
                    object.resetInjection = function() {
                        (0, _extend.extend)(object, initialFields);
                        InjectedClass = BaseClass;
                        instance = new BaseClass
                    };
                    return object
                };
                var _class = (obj = __webpack_require__( /*! ../../../core/class */ 55620), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528)
            },
        76400:
            /*!****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_dom.js ***!
              \****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.resetActiveElement = exports.replaceWith = exports.normalizeTemplateElement = exports.isElementInDom = exports.insertBefore = exports.extractTemplateMarkup = exports.default = exports.createTextElementHiddenCopy = exports.contains = exports.closestCommonParent = exports.clipboardText = exports.clearSelection = void 0;
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../core/dom_adapter */ 64960));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 3104);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const window = (0, _window.getWindow)();
                const resetActiveElement = () => {
                    const activeElement = _dom_adapter.default.getActiveElement();
                    if (activeElement && activeElement !== _dom_adapter.default.getBody()) {
                        var _activeElement$blur;
                        null === (_activeElement$blur = activeElement.blur) || void 0 === _activeElement$blur || _activeElement$blur.call(activeElement)
                    }
                };
                exports.resetActiveElement = resetActiveElement;
                const clearSelection = () => {
                    const selection = window.getSelection();
                    if (!selection) {
                        return
                    }
                    if ("Caret" === selection.type) {
                        return
                    }
                    if (selection.empty) {
                        selection.empty()
                    } else if (selection.removeAllRanges) {
                        try {
                            selection.removeAllRanges()
                        } catch (e) {}
                    }
                };
                exports.clearSelection = clearSelection;
                const closestCommonParent = (startTarget, endTarget) => {
                    const $startTarget = (0, _renderer.default)(startTarget);
                    const $endTarget = (0, _renderer.default)(endTarget);
                    if ($startTarget[0] === $endTarget[0]) {
                        return $startTarget[0]
                    }
                    const $startParents = $startTarget.parents();
                    const $endParents = $endTarget.parents();
                    const startingParent = Math.min($startParents.length, $endParents.length);
                    for (let i = -startingParent; i < 0; i++) {
                        if ($startParents.get(i) === $endParents.get(i)) {
                            return $startParents.get(i)
                        }
                    }
                };
                exports.closestCommonParent = closestCommonParent;
                const extractTemplateMarkup = element => {
                    element = (0, _renderer.default)(element);
                    const templateTag = element.length && element.filter((function() {
                        const $node = (0, _renderer.default)(this);
                        return $node.is("script[type]") && !$node.attr("type").includes("script")
                    }));
                    if (templateTag.length) {
                        return templateTag.eq(0).html()
                    }
                    element = (0, _renderer.default)("<div>").append(element);
                    return element.html()
                };
                exports.extractTemplateMarkup = extractTemplateMarkup;
                const normalizeTemplateElement = element => {
                    let $element = (0, _type.isDefined)(element) && (element.nodeType || (0, _type.isRenderer)(element)) ? (0, _renderer.default)(element) : (0, _renderer.default)("<div>").html(element).contents();
                    if (1 === $element.length) {
                        if ($element.is("script")) {
                            $element = normalizeTemplateElement($element.html().trim())
                        } else if ($element.is("table")) {
                            $element = $element.children("tbody").contents()
                        }
                    }
                    return $element
                };
                exports.normalizeTemplateElement = normalizeTemplateElement;
                const clipboardText = (event, text) => {
                    const clipboard = event.originalEvent && event.originalEvent.clipboardData || window.clipboardData;
                    if (!text) {
                        return clipboard && clipboard.getData("Text")
                    }
                    clipboard && clipboard.setData("Text", text)
                };
                exports.clipboardText = clipboardText;
                const contains = (container, element) => {
                    if (!element) {
                        return false
                    }
                    if ((0, _type.isWindow)(container)) {
                        return contains(container.document, element)
                    }
                    return container.contains(element) || contains(container, (element => {
                        if (!element.getRootNode) {
                            return
                        }
                        const {
                            host: host
                        } = element.getRootNode();
                        if ((0, _type.isString)(host)) {
                            return
                        }
                        return host
                    })(element))
                };
                exports.contains = contains;
                const createTextElementHiddenCopy = (element, text, options) => {
                    const elementStyles = window.getComputedStyle((0, _renderer.default)(element).get(0));
                    const includePaddings = options && options.includePaddings;
                    return (0, _renderer.default)("<div>").text(text).css({
                        fontStyle: elementStyles.fontStyle,
                        fontVariant: elementStyles.fontVariant,
                        fontWeight: elementStyles.fontWeight,
                        fontSize: elementStyles.fontSize,
                        fontFamily: elementStyles.fontFamily,
                        letterSpacing: elementStyles.letterSpacing,
                        border: elementStyles.border,
                        paddingTop: includePaddings ? elementStyles.paddingTop : "",
                        paddingRight: includePaddings ? elementStyles.paddingRight : "",
                        paddingBottom: includePaddings ? elementStyles.paddingBottom : "",
                        paddingLeft: includePaddings ? elementStyles.paddingLeft : "",
                        visibility: "hidden",
                        whiteSpace: "pre",
                        position: "absolute",
                        float: "left"
                    })
                };
                exports.createTextElementHiddenCopy = createTextElementHiddenCopy;
                const insertBefore = (element, newElement) => {
                    if (newElement) {
                        _dom_adapter.default.insertElement(element.parentNode, newElement, element)
                    }
                    return element
                };
                exports.insertBefore = insertBefore;
                const replaceWith = (element, newElement) => {
                    if (!(newElement && newElement[0])) {
                        return
                    }
                    if (newElement.is(element)) {
                        return element
                    }(0, _iterator.each)(newElement, ((_, currentElement) => {
                        insertBefore(element[0], currentElement)
                    }));
                    element.remove();
                    return newElement
                };
                exports.replaceWith = replaceWith;
                const isElementInDom = $element => {
                    const element = null === $element || void 0 === $element ? void 0 : $element.get(0);
                    const shadowHost = null === element || void 0 === element ? void 0 : element.getRootNode().host;
                    return !!(0, _renderer.default)(shadowHost || element).closest((0, _window.getWindow)().document).length
                };
                exports.isElementInDom = isElementInDom;
                exports.default = {
                    resetActiveElement: resetActiveElement,
                    clearSelection: clearSelection,
                    closestCommonParent: closestCommonParent,
                    extractTemplateMarkup: extractTemplateMarkup,
                    normalizeTemplateElement: normalizeTemplateElement,
                    clipboardText: clipboardText,
                    contains: contains,
                    createTextElementHiddenCopy: createTextElementHiddenCopy,
                    insertBefore: insertBefore,
                    replaceWith: replaceWith,
                    isElementInDom: isElementInDom
                }
            },
        40818:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_error.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                exports.error = error;
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _string = __webpack_require__( /*! ../../../core/utils/string */ 54497);
                var _version = __webpack_require__( /*! ../../../core/version */ 1956);
                var _m_console = (obj = __webpack_require__( /*! ./m_console */ 35005), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                const ERROR_URL = `https://js.devexpress.com/error/${_version.version.split(".").slice(0,2).join("_")}/`;

                function error(baseErrors, errors) {
                    const exports = {
                        ERROR_MESSAGES: (0, _extend.extend)(errors, baseErrors),
                        Error: function() {
                            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                                args[_key] = arguments[_key]
                            }
                            return function(args) {
                                const id = args[0];
                                args = args.slice(1);
                                const details = formatDetails(id, args);
                                const url = getErrorUrl(id);
                                const message = formatMessage(id, details);
                                return (0, _extend.extend)(new Error(message), {
                                    __id: id,
                                    __details: details,
                                    url: url
                                })
                            }(args)
                        },
                        log() {
                            for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                                args[_key2] = arguments[_key2]
                            }
                            const id = args[0];
                            let method = "log";
                            if (/^E\d+$/.test(id)) {
                                method = "error"
                            } else if (/^W\d+$/.test(id)) {
                                method = "warn"
                            }
                            _m_console.default.logger[method]("log" === method ? id : function(args) {
                                const id = args[0];
                                args = args.slice(1);
                                return formatMessage(id, formatDetails(id, args))
                            }(args))
                        }
                    };

                    function formatDetails(id, args) {
                        args = [exports.ERROR_MESSAGES[id]].concat(args);
                        return _string.format.apply(this, args).replace(/\.*\s*?$/, "")
                    }

                    function formatMessage(id, details) {
                        const kind = null !== id && void 0 !== id && id.startsWith("W") ? "warning" : "error";
                        return _string.format.apply(this, ["{0} - {1}.\n\nFor additional information on this {2} message, see: {3}", id, details, kind, getErrorUrl(id)])
                    }

                    function getErrorUrl(id) {
                        return ERROR_URL + id
                    }
                    return exports
                }
                exports.default = error
            },
        96298:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_extend.js ***!
              \*******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.extendFromObject = exports.extend = void 0;
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                exports.extendFromObject = function(target, source, overrideExistingValues) {
                    target = target || {};
                    for (const prop in source) {
                        if (Object.prototype.hasOwnProperty.call(source, prop)) {
                            const value = source[prop];
                            if (!(prop in target) || overrideExistingValues) {
                                target[prop] = value
                            }
                        }
                    }
                    return target
                };
                const extend = function(target) {
                    target = target || {};
                    let i = 1;
                    let deep = false;
                    if ("boolean" === typeof target) {
                        deep = target;
                        target = arguments[1] || {};
                        i++
                    }
                    for (; i < arguments.length; i++) {
                        const source = arguments[i];
                        if (null == source) {
                            continue
                        }
                        for (const key in source) {
                            const targetValue = target[key];
                            const sourceValue = source[key];
                            let sourceValueIsArray = false;
                            let clone;
                            if ("__proto__" === key || "constructor" === key || target === sourceValue) {
                                continue
                            }
                            if (deep && sourceValue && ((0, _type.isPlainObject)(sourceValue) || (sourceValueIsArray = Array.isArray(sourceValue)))) {
                                if (sourceValueIsArray) {
                                    clone = targetValue && Array.isArray(targetValue) ? targetValue : []
                                } else {
                                    clone = targetValue && (0, _type.isPlainObject)(targetValue) ? targetValue : {}
                                }
                                target[key] = extend(deep, clone, sourceValue)
                            } else if (void 0 !== sourceValue) {
                                target[key] = sourceValue
                            }
                        }
                    }
                    return target
                };
                exports.extend = extend
            },
        25317:
            /*!************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_html_parser.js ***!
              \************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.parseHTML = exports.isTablePart = void 0;
                var _dom_adapter = (obj = __webpack_require__( /*! ../../../core/dom_adapter */ 64960), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                const isTagName = /<([a-z][^/\0>\x20\t\r\n\f]+)/i;
                const tagWrappers = {
                    default: {
                        tagsCount: 0,
                        startTags: "",
                        endTags: ""
                    },
                    thead: {
                        tagsCount: 1,
                        startTags: "<table>",
                        endTags: "</table>"
                    },
                    td: {
                        tagsCount: 3,
                        startTags: "<table><tbody><tr>",
                        endTags: "</tr></tbody></table>"
                    },
                    col: {
                        tagsCount: 2,
                        startTags: "<table><colgroup>",
                        endTags: "</colgroup></table>"
                    },
                    tr: {
                        tagsCount: 2,
                        startTags: "<table><tbody>",
                        endTags: "</tbody></table>"
                    }
                };
                tagWrappers.tbody = tagWrappers.colgroup = tagWrappers.caption = tagWrappers.tfoot = tagWrappers.thead;
                tagWrappers.th = tagWrappers.td;
                exports.parseHTML = function(html) {
                    if ("string" !== typeof html) {
                        return null
                    }
                    const fragment = _dom_adapter.default.createDocumentFragment();
                    let container = fragment.appendChild(_dom_adapter.default.createElement("div"));
                    const tags = isTagName.exec(html);
                    const firstRootTag = null === tags || void 0 === tags ? void 0 : tags[1].toLowerCase();
                    const tagWrapper = tagWrappers[firstRootTag] || tagWrappers.default;
                    container.innerHTML = tagWrapper.startTags + html + tagWrapper.endTags;
                    for (let i = 0; i < tagWrapper.tagsCount; i++) {
                        container = container.lastChild
                    }
                    return [...container.childNodes]
                };
                exports.isTablePart = function(html) {
                    const tags = isTagName.exec(html);
                    return tags && tags[1] in tagWrappers
                }
            },
        42463:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_icon.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getImageSourceType = exports.getImageContainer = void 0;
                var _renderer = (obj = __webpack_require__( /*! ../../../core/renderer */ 64553), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                const getImageSourceType = source => {
                    if (!source || "string" !== typeof source) {
                        return false
                    }
                    if (/^\s*<svg[^>]*>(.|\r?\n)*?<\/svg>\s*$/i.test(source)) {
                        return "svg"
                    }
                    if (/data:.*base64|\.|[^<\s]\/{1,1}/.test(source)) {
                        return "image"
                    }
                    if (/^[\w-_]+$/.test(source)) {
                        return "dxIcon"
                    }
                    if (/^\s?([\w-_:]\s?)+$/.test(source)) {
                        return "fontIcon"
                    }
                    return false
                };
                exports.getImageSourceType = getImageSourceType;
                exports.getImageContainer = source => {
                    switch (getImageSourceType(source)) {
                        case "image":
                            return (0, _renderer.default)("<img>").attr("src", source).addClass("dx-icon");
                        case "fontIcon":
                            return (0, _renderer.default)("<i>").addClass(`dx-icon ${source}`);
                        case "dxIcon":
                            return (0, _renderer.default)("<i>").addClass(`dx-icon dx-icon-${source}`);
                        case "svg":
                            return (0, _renderer.default)("<i>").addClass("dx-icon dx-svg-icon").append(source);
                        default:
                            return null
                    }
                }
            },
        66122:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_inflector.js ***!
              \**********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.underscore = exports.titleize = exports.humanize = exports.default = exports.dasherize = exports.captionize = exports.camelize = void 0;
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 21274);
                const _normalize = function(text) {
                    if (void 0 === text || null === text) {
                        return ""
                    }
                    return String(text)
                };
                const _upperCaseFirst = function(text) {
                    return _normalize(text).charAt(0).toUpperCase() + text.substr(1)
                };
                const _chop = function(text) {
                    return _normalize(text).replace(/([a-z\d])([A-Z])/g, "$1 $2").split(/[\s_-]+/)
                };
                const dasherize = function(text) {
                    return (0, _iterator.map)(_chop(text), (function(p) {
                        return p.toLowerCase()
                    })).join("-")
                };
                exports.dasherize = dasherize;
                const underscore = function(text) {
                    return dasherize(text).replace(/-/g, "_")
                };
                exports.underscore = underscore;
                const camelize = function(text, upperFirst) {
                    return (0, _iterator.map)(_chop(text), (function(p, i) {
                        p = p.toLowerCase();
                        if (upperFirst || i > 0) {
                            p = _upperCaseFirst(p)
                        }
                        return p
                    })).join("")
                };
                exports.camelize = camelize;
                const humanize = function(text) {
                    return _upperCaseFirst(dasherize(text).replace(/-/g, " "))
                };
                exports.humanize = humanize;
                const titleize = function(text) {
                    return (0, _iterator.map)(_chop(text), (function(p) {
                        return _upperCaseFirst(p.toLowerCase())
                    })).join(" ")
                };
                exports.titleize = titleize;
                const DIGIT_CHARS = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];
                const captionize = function(name) {
                    const captionList = [];
                    let i;
                    let char;
                    let isPrevCharNewWord = false;
                    let isNewWord = false;
                    for (i = 0; i < name.length; i++) {
                        char = name.charAt(i);
                        isNewWord = char === char.toUpperCase() && "-" !== char && ")" !== char && "/" !== char || char in DIGIT_CHARS;
                        if ("_" === char || "." === char) {
                            char = " ";
                            isNewWord = true
                        } else if (0 === i) {
                            char = char.toUpperCase();
                            isNewWord = true
                        } else if (!isPrevCharNewWord && isNewWord) {
                            if (captionList.length > 0) {
                                captionList.push(" ")
                            }
                        }
                        captionList.push(char);
                        isPrevCharNewWord = isNewWord
                    }
                    return captionList.join("")
                };
                exports.captionize = captionize;
                exports.default = {
                    dasherize: dasherize,
                    underscore: underscore,
                    camelize: camelize,
                    humanize: humanize,
                    titleize: titleize,
                    captionize: captionize
                }
            },
        26044:
            /*!*********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_iterator.js ***!
              \*********************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.reverseEach = exports.map = exports.each = void 0;
                exports.map = (values, callback) => {
                    if (Array.isArray(values)) {
                        return values.map(callback)
                    }
                    const result = [];
                    for (const key in values) {
                        result.push(callback(values[key], key))
                    }
                    return result
                };
                exports.each = (values, callback) => {
                    if (!values) {
                        return
                    }
                    if ("length" in values) {
                        for (let i = 0; i < values.length; i++) {
                            if (false === callback.call(values[i], i, values[i])) {
                                break
                            }
                        }
                    } else {
                        for (const key in values) {
                            if (false === callback.call(values[key], key, values[key])) {
                                break
                            }
                        }
                    }
                    return values
                };
                exports.reverseEach = (array, callback) => {
                    if (!array || !("length" in array) || 0 === array.length) {
                        return
                    }
                    for (let i = array.length - 1; i >= 0; i--) {
                        if (false === callback.call(array[i], i, array[i])) {
                            break
                        }
                    }
                }
            },
        24574:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_locker.js ***!
              \*******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Locker = void 0;
                var _errors = (obj = __webpack_require__( /*! ../../../core/errors */ 87129), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                exports.Locker = function() {
                    const info = {};
                    const currentCount = function(lockName) {
                        return info[lockName] || 0
                    };
                    return {
                        obtain(lockName) {
                            info[lockName] = currentCount(lockName) + 1
                        },
                        release(lockName) {
                            const count = currentCount(lockName);
                            if (count < 1) {
                                throw _errors.default.Error("E0014")
                            }
                            if (1 === count) {
                                delete info[lockName]
                            } else {
                                info[lockName] = count - 1
                            }
                        },
                        locked: lockName => currentCount(lockName) > 0
                    }
                }
            },
        80764:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_math.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.adjust = function(value, interval) {
                    let precision = getPrecision(interval || 0) + 2;
                    const separatedValue = value.toString().split(".");
                    const sourceValue = value;
                    const absValue = Math.abs(value);
                    let separatedAdjustedValue;
                    const isExponentValue = (0, _type.isExponential)(value);
                    const integerPart = absValue > 1 ? 10 : 0;
                    if (1 === separatedValue.length) {
                        return value
                    }
                    if (!isExponentValue) {
                        if ((0, _type.isExponential)(interval)) {
                            precision = separatedValue[0].length + getExponent(interval)
                        }
                        value = absValue;
                        value = value - Math.floor(value) + integerPart
                    }
                    precision = function() {
                        const value = 3e-4;
                        const correctValue = "0.000300";
                        const precisionValue = 3;
                        return correctValue !== value.toPrecision(precisionValue)
                    }() && getExponent(value) > 6 || precision > 7 ? 15 : 7;
                    if (!isExponentValue) {
                        separatedAdjustedValue = parseFloat(value.toPrecision(precision)).toString().split(".");
                        if (separatedAdjustedValue[0] === integerPart.toString()) {
                            return parseFloat(`${separatedValue[0]}.${separatedAdjustedValue[1]}`)
                        }
                    }
                    return parseFloat(sourceValue.toPrecision(precision))
                };
                exports.fitIntoRange = void 0;
                exports.getExponent = getExponent;
                exports.getExponentLength = function(value) {
                    var _valueString$split$;
                    const valueString = value.toString();
                    return (null === (_valueString$split$ = valueString.split(".")[1]) || void 0 === _valueString$split$ ? void 0 : _valueString$split$.length) || parseInt(valueString.split("e-")[1], 10) || 0
                };
                exports.getPrecision = getPrecision;
                exports.getRemainderByDivision = function(dividend, divider, digitsCount) {
                    if (divider === parseInt(divider, 10)) {
                        return dividend % divider
                    }
                    const quotient = roundFloatPart(dividend / divider, digitsCount);
                    return (quotient - parseInt(quotient, 10)) * divider
                };
                exports.getRoot = getRoot;
                exports.inRange = void 0;
                exports.multiplyInExponentialForm = function(value, exponentShift) {
                    const exponentialNotation = function(value) {
                        const parts = value.toExponential().split("e");
                        const mantissa = parseFloat(parts[0]);
                        const exponent = parseInt(parts[1], 10);
                        return {
                            exponent: exponent,
                            mantissa: mantissa
                        }
                    }(value);
                    return parseFloat(`${exponentialNotation.mantissa}e${exponentialNotation.exponent+exponentShift}`)
                };
                exports.roundFloatPart = roundFloatPart;
                exports.sign = void 0;
                exports.solveCubicEquation = function(a, b, c, d) {
                    if (Math.abs(a) < 1e-8) {
                        a = b;
                        b = c;
                        c = d;
                        if (Math.abs(a) < 1e-8) {
                            a = b;
                            b = c;
                            if (Math.abs(a) < 1e-8) {
                                return []
                            }
                            return [-b / a]
                        }
                        const D2 = b * b - 4 * a * c;
                        if (Math.abs(D2) < 1e-8) {
                            return [-b / (2 * a)]
                        }
                        if (D2 > 0) {
                            return [(-b + Math.sqrt(D2)) / (2 * a), (-b - Math.sqrt(D2)) / (2 * a)]
                        }
                        return []
                    }
                    const p = (3 * a * c - b * b) / (3 * a * a);
                    const q = (2 * b * b * b - 9 * a * b * c + 27 * a * a * d) / (27 * a * a * a);
                    let roots;
                    let u;
                    if (Math.abs(p) < 1e-8) {
                        roots = [getRoot(-q, 3)]
                    } else if (Math.abs(q) < 1e-8) {
                        roots = [0].concat(p < 0 ? [Math.sqrt(-p), -Math.sqrt(-p)] : [])
                    } else {
                        const D3 = q * q / 4 + p * p * p / 27;
                        if (Math.abs(D3) < 1e-8) {
                            roots = [-1.5 * q / p, 3 * q / p]
                        } else if (D3 > 0) {
                            u = getRoot(-q / 2 - Math.sqrt(D3), 3);
                            roots = [u - p / (3 * u)]
                        } else {
                            u = 2 * Math.sqrt(-p / 3);
                            const t = Math.acos(3 * q / p / u) / 3;
                            const k = 2 * Math.PI / 3;
                            roots = [u * Math.cos(t), u * Math.cos(t - k), u * Math.cos(t - 2 * k)]
                        }
                    }
                    for (let i = 0; i < roots.length; i++) {
                        roots[i] -= b / (3 * a)
                    }
                    return roots
                };
                exports.trunc = function(value) {
                    return Math.trunc ? Math.trunc(value) : value > 0 ? Math.floor(value) : Math.ceil(value)
                };
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                exports.sign = function(value) {
                    if (0 === value) {
                        return 0
                    }
                    return value / Math.abs(value)
                };
                exports.fitIntoRange = function(value, minValue, maxValue) {
                    const isMinValueUndefined = !minValue && 0 !== minValue;
                    const isMaxValueUndefined = !maxValue && 0 !== maxValue;
                    isMinValueUndefined && (minValue = !isMaxValueUndefined ? Math.min(value, maxValue) : value);
                    isMaxValueUndefined && (maxValue = !isMinValueUndefined ? Math.max(value, minValue) : value);
                    return Math.min(Math.max(value, minValue), maxValue)
                };
                exports.inRange = function(value, minValue, maxValue) {
                    return value >= minValue && value <= maxValue
                };

                function getExponent(value) {
                    return Math.abs(parseInt(value.toExponential().split("e")[1], 10))
                }

                function getPrecision(value) {
                    const str = value.toString();
                    if (str.indexOf(".") < 0) {
                        return 0
                    }
                    const mantissa = str.split(".");
                    const positionOfDelimiter = mantissa[1].indexOf("e");
                    return positionOfDelimiter >= 0 ? positionOfDelimiter : mantissa[1].length
                }

                function getRoot(x, n) {
                    if (x < 0 && n % 2 !== 1) {
                        return NaN
                    }
                    const y = Math.abs(x) ** (1 / n);
                    return n % 2 === 1 && x < 0 ? -y : y
                }

                function roundFloatPart(value) {
                    let digitsCount = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 0;
                    return parseFloat(value.toFixed(digitsCount))
                }
            },
        86005:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_object.js ***!
              \*******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.orderEach = exports.newAssign = exports.legacyAssign = exports.deepExtendArraySafe = exports.clone = void 0;
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _variable_wrapper = (obj = __webpack_require__( /*! ../../../core/utils/variable_wrapper */ 40216), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                exports.clone = function() {
                    function Clone() {}
                    return function(obj) {
                        Clone.prototype = obj;
                        return new Clone
                    }
                }();
                exports.orderEach = function(map, func) {
                    const keys = [];
                    let key;
                    let i;
                    for (key in map) {
                        if (Object.prototype.hasOwnProperty.call(map, key)) {
                            keys.push(key)
                        }
                    }
                    keys.sort((function(x, y) {
                        const isNumberX = (0, _type.isNumeric)(x);
                        const isNumberY = (0, _type.isNumeric)(y);
                        if (isNumberX && isNumberY) {
                            return x - y
                        }
                        if (isNumberX && !isNumberY) {
                            return -1
                        }
                        if (!isNumberX && isNumberY) {
                            return 1
                        }
                        if (x < y) {
                            return -1
                        }
                        if (x > y) {
                            return 1
                        }
                        return 0
                    }));
                    for (i = 0; i < keys.length; i++) {
                        key = keys[i];
                        func(key, map[key])
                    }
                };
                const getDeepCopyTarget = item => {
                    if ((0, _type.isObject)(item)) {
                        return Array.isArray(item) ? [] : {}
                    }
                    return item
                };
                const legacyAssign = function(target, property, value, extendComplexObject, assignByReference, shouldCopyUndefined) {
                    if (!assignByReference && _variable_wrapper.default.isWrapped(target[property])) {
                        _variable_wrapper.default.assign(target[property], value)
                    } else {
                        target[property] = value
                    }
                };
                exports.legacyAssign = legacyAssign;
                const newAssign = function(target, property, value, extendComplexObject, assignByReference, shouldCopyUndefined) {
                    const goDeeper = extendComplexObject ? (0, _type.isObject)(target) : (0, _type.isPlainObject)(target);
                    if (!assignByReference && _variable_wrapper.default.isWrapped(target[property])) {
                        _variable_wrapper.default.assign(target[property], value)
                    } else if (!assignByReference && Array.isArray(value)) {
                        target[property] = value.map((item => deepExtendArraySafe(getDeepCopyTarget(item), item, extendComplexObject, assignByReference, shouldCopyUndefined)))
                    } else if (!assignByReference && goDeeper) {
                        target[property] = deepExtendArraySafe(getDeepCopyTarget(value), value, extendComplexObject, assignByReference, shouldCopyUndefined, newAssign)
                    } else {
                        target[property] = value
                    }
                };
                exports.newAssign = newAssign;
                const deepExtendArraySafe = function(target, changes, extendComplexObject, assignByReference, shouldCopyUndefined, useNewAssign) {
                    let prevValue;
                    let newValue;
                    const assignFunc = useNewAssign ? newAssign : legacyAssign;
                    for (const name in changes) {
                        prevValue = target[name];
                        newValue = changes[name];
                        if ("__proto__" === name || "constructor" === name || target === newValue) {
                            continue
                        }
                        if ((0, _type.isPlainObject)(newValue)) {
                            const goDeeper = extendComplexObject ? (0, _type.isObject)(prevValue) : (0, _type.isPlainObject)(prevValue);
                            newValue = deepExtendArraySafe(goDeeper ? prevValue : {}, newValue, extendComplexObject, assignByReference, shouldCopyUndefined)
                        }
                        const isDeepCopyArray = Array.isArray(newValue) && !assignByReference;
                        const hasDifferentNewValue = (shouldCopyUndefined || void 0 !== newValue) && prevValue !== newValue || shouldCopyUndefined && void 0 === prevValue;
                        if (isDeepCopyArray || hasDifferentNewValue) {
                            assignFunc(target, name, newValue, extendComplexObject, assignByReference, shouldCopyUndefined)
                        }
                    }
                    return target
                };
                exports.deepExtendArraySafe = deepExtendArraySafe
            },
        80125:
            /*!*********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_position.js ***!
              \*********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getDefaultAlignment = exports.getBoundingRect = void 0;
                var _config = (obj = __webpack_require__( /*! ../../../core/config */ 66636), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                exports.getDefaultAlignment = isRtlEnabled => {
                    const rtlEnabled = isRtlEnabled ?? (0, _config.default)().rtlEnabled;
                    return rtlEnabled ? "right" : "left"
                };
                exports.getBoundingRect = element => {
                    var _element$getBoundingC;
                    if ((0, _type.isWindow)(element)) {
                        return {
                            width: element.outerWidth,
                            height: element.outerHeight
                        }
                    }
                    return null === (_element$getBoundingC = element.getBoundingClientRect) || void 0 === _element$getBoundingC ? void 0 : _element$getBoundingC.call(element)
                }
            },
        871:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_public_component.js ***!
              \*****************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.attachInstanceToElement = function($element, componentInstance, disposeFn) {
                    const data = (0, _element_data.data)($element.get(0));
                    const name = getName(componentInstance.constructor);
                    data[name] = componentInstance;
                    if (disposeFn) {
                        _events_engine.default.one($element, _remove.removeEvent, (function() {
                            disposeFn.call(componentInstance)
                        }))
                    }
                    if (!data[COMPONENT_NAMES_DATA_KEY]) {
                        data[COMPONENT_NAMES_DATA_KEY] = []
                    }
                    data[COMPONENT_NAMES_DATA_KEY].push(name)
                };
                exports.default = void 0;
                exports.getInstanceByElement = function($element, componentClass) {
                    const name = getName(componentClass);
                    return (0, _element_data.data)($element.get(0), name)
                };
                exports.name = void 0;
                var _element_data = __webpack_require__( /*! ../../../core/element_data */ 74663);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _events_engine = (obj = __webpack_require__( /*! ../../../events/core/events_engine */ 76772), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _remove = __webpack_require__( /*! ../../../events/remove */ 92492);
                const COMPONENT_NAMES_DATA_KEY = "dxComponents";
                const componentNames = new WeakMap;
                let nextAnonymousComponent = 0;
                const getName = function(componentClass, newName) {
                    if ((0, _type.isDefined)(newName)) {
                        componentNames.set(componentClass, newName);
                        return
                    }
                    if (!componentNames.has(componentClass)) {
                        const generatedName = "dxPrivateComponent" + nextAnonymousComponent++;
                        componentNames.set(componentClass, generatedName);
                        return generatedName
                    }
                    return componentNames.get(componentClass)
                };
                exports.name = getName;
                exports.default = {
                    name: getName
                }
            },
        52799:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_queue.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.create = createQueue;
                exports.enqueue = void 0;
                var _errors = (obj = __webpack_require__( /*! ../../../core/errors */ 87129), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _deferred = __webpack_require__( /*! ../../../core/utils/deferred */ 87739);

                function createQueue(discardPendingTasks) {
                    let _tasks = [];
                    let _busy = false;

                    function exec() {
                        while (_tasks.length) {
                            _busy = true;
                            const task = _tasks.shift();
                            const result = task();
                            if (void 0 === result) {
                                continue
                            }
                            if (result.then) {
                                (0, _deferred.when)(result).always(exec);
                                return
                            }
                            throw _errors.default.Error("E0015")
                        }
                        _busy = false
                    }
                    return {
                        add: function(task, removeTaskCallback) {
                            if (!discardPendingTasks) {
                                _tasks.push(task)
                            } else {
                                if (_tasks[0] && removeTaskCallback) {
                                    removeTaskCallback(_tasks[0])
                                }
                                _tasks = [task]
                            }
                            if (!_busy) {
                                exec()
                            }
                        },
                        busy: function() {
                            return _busy
                        }
                    }
                }
                exports.enqueue = createQueue().add
            },
        18344:
            /*!****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_ready_callbacks.js ***!
              \****************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.readyCallbacksModule = exports.default = void 0;
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../core/dom_adapter */ 64960));
                var _call_once = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/call_once */ 13630));
                var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/dependency_injector */ 89656));
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 3104);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                let callbacks = [];
                const subscribeReady = (0, _call_once.default)((() => {
                    const removeListener = _dom_adapter.default.listen(_dom_adapter.default.getDocument(), "DOMContentLoaded", (() => {
                        readyCallbacks.fire();
                        removeListener()
                    }))
                }));
                const readyCallbacks = {
                    add: callback => {
                        const windowExists = (0, _window.hasWindow)();
                        if (windowExists && "loading" !== _dom_adapter.default.getReadyState()) {
                            callback()
                        } else {
                            callbacks.push(callback);
                            windowExists && subscribeReady()
                        }
                    },
                    fire: () => {
                        callbacks.forEach((callback => callback()));
                        callbacks = []
                    }
                };
                const readyCallbacksModule = exports.readyCallbacksModule = (0, _dependency_injector.default)(readyCallbacks);
                exports.default = readyCallbacksModule
            },
        33717:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_resize_callbacks.js ***!
              \*****************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.resizeCallbacks = exports.default = void 0;
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../core/dom_adapter */ 64960));
                var _call_once = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/call_once */ 13630));
                var _m_callbacks = _interopRequireDefault(__webpack_require__( /*! ./m_callbacks */ 63172));
                var _m_ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ./m_ready_callbacks */ 18344));
                var _m_window = _interopRequireDefault(__webpack_require__( /*! ./m_window */ 14470));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const resizeCallbacks = exports.resizeCallbacks = function() {
                    let prevSize;
                    const callbacks = (0, _m_callbacks.default)();
                    const originalCallbacksAdd = callbacks.add;
                    const originalCallbacksRemove = callbacks.remove;
                    if (!_m_window.default.hasWindow()) {
                        return callbacks
                    }
                    const formatSize = function() {
                        const window = _m_window.default.getWindow();
                        return {
                            width: window.innerWidth,
                            height: window.innerHeight
                        }
                    };
                    const handleResize = function() {
                        const now = formatSize();
                        if (now.width === prevSize.width && now.height === prevSize.height) {
                            return
                        }
                        let changedDimension;
                        if (now.width === prevSize.width) {
                            changedDimension = "height"
                        }
                        if (now.height === prevSize.height) {
                            changedDimension = "width"
                        }
                        prevSize = now;
                        callbacks.fire(changedDimension)
                    };
                    const setPrevSize = (0, _call_once.default)((function() {
                        prevSize = formatSize()
                    }));
                    let removeListener;
                    callbacks.add = function() {
                        const result = originalCallbacksAdd.apply(callbacks, arguments);
                        setPrevSize();
                        _m_ready_callbacks.default.add((function() {
                            if (!removeListener && callbacks.has()) {
                                removeListener = _dom_adapter.default.listen(_m_window.default.getWindow(), "resize", handleResize)
                            }
                        }));
                        return result
                    };
                    callbacks.remove = function() {
                        const result = originalCallbacksRemove.apply(callbacks, arguments);
                        if (!callbacks.has() && removeListener) {
                            removeListener();
                            removeListener = void 0
                        }
                        return result
                    };
                    return callbacks
                }();
                exports.default = resizeCallbacks
            },
        67135:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_selection_filter.js ***!
              \*****************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.SelectionFilterCreator = void 0;
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _data = __webpack_require__( /*! ../../../core/utils/data */ 31e3);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                exports.SelectionFilterCreator = function(selectedItemKeys, isSelectAll) {
                    this.getLocalFilter = function(keyGetter, equalKeys, equalByReference, keyExpr) {
                        equalKeys = void 0 === equalKeys ? _common.equalByValue : equalKeys;
                        return functionFilter.bind(this, equalKeys, keyGetter, equalByReference, keyExpr)
                    };
                    this.getExpr = function(keyExpr) {
                        if (!keyExpr) {
                            return
                        }
                        let filterExpr;
                        selectedItemKeys.forEach((function(key, index) {
                            filterExpr = filterExpr || [];
                            let filterExprPart;
                            if (index > 0) {
                                filterExpr.push(isSelectAll ? "and" : "or")
                            }
                            if ((0, _type.isString)(keyExpr)) {
                                filterExprPart = getFilterForPlainKey(keyExpr, key)
                            } else {
                                filterExprPart = function(keyExpr, itemKeyValue) {
                                    const filterExpr = [];
                                    for (let i = 0, {
                                            length: length
                                        } = keyExpr; i < length; i++) {
                                        const currentKeyExpr = keyExpr[i];
                                        const keyValueGetter = (0, _data.compileGetter)(currentKeyExpr);
                                        const currentKeyValue = itemKeyValue && keyValueGetter(itemKeyValue);
                                        const filterExprPart = getFilterForPlainKey(currentKeyExpr, currentKeyValue);
                                        if (!filterExprPart) {
                                            break
                                        }
                                        if (i > 0) {
                                            filterExpr.push(isSelectAll ? "or" : "and")
                                        }
                                        filterExpr.push(filterExprPart)
                                    }
                                    return filterExpr
                                }(keyExpr, key)
                            }
                            filterExpr.push(filterExprPart)
                        }));
                        if (filterExpr && 1 === filterExpr.length) {
                            filterExpr = filterExpr[0]
                        }
                        return filterExpr
                    };
                    this.getCombinedFilter = function(keyExpr, dataSourceFilter) {
                        let forceCombinedFilter = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : false;
                        const filterExpr = this.getExpr(keyExpr);
                        let combinedFilter = filterExpr;
                        if ((forceCombinedFilter || isSelectAll) && dataSourceFilter) {
                            if (filterExpr) {
                                combinedFilter = [];
                                combinedFilter.push(filterExpr);
                                combinedFilter.push(dataSourceFilter)
                            } else {
                                combinedFilter = dataSourceFilter
                            }
                        }
                        return combinedFilter
                    };
                    let selectedItemKeyHashesMap;
                    const getSelectedItemKeyHashesMap = function(keyOf, keyExpr) {
                        if (!selectedItemKeyHashesMap) {
                            selectedItemKeyHashesMap = {};
                            const normalizedKeys = normalizeKeys(selectedItemKeys, keyOf, keyExpr);
                            for (let i = 0; i < normalizedKeys.length; i++) {
                                selectedItemKeyHashesMap[(0, _common.getKeyHash)(normalizedKeys[i])] = true
                            }
                        }
                        return selectedItemKeyHashesMap
                    };
                    const normalizeKeys = function(keys, keyOf, keyExpr) {
                        return Array.isArray(keyExpr) ? keys.map((key => keyOf(key))) : keys
                    };

                    function functionFilter(equalKeys, keyOf, equalByReference, keyExpr, item) {
                        const key = keyOf(item);
                        let keyHash;
                        let i;
                        if (!equalByReference) {
                            keyHash = (0, _common.getKeyHash)(key);
                            if (!(0, _type.isObject)(keyHash)) {
                                const selectedKeyHashesMap = getSelectedItemKeyHashesMap(keyOf, keyExpr);
                                if (selectedKeyHashesMap[keyHash]) {
                                    return !isSelectAll
                                }
                                return !!isSelectAll
                            }
                        }
                        for (i = 0; i < selectedItemKeys.length; i++) {
                            if (equalKeys(selectedItemKeys[i], key)) {
                                return !isSelectAll
                            }
                        }
                        return !!isSelectAll
                    }

                    function getFilterForPlainKey(keyExpr, keyValue) {
                        if (void 0 === keyValue) {
                            return
                        }
                        return [keyExpr, isSelectAll ? "<>" : "=", keyValue]
                    }
                }
            },
        17113:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_shadow_dom.js ***!
              \***********************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.addShadowDomStyles = function($element) {
                    var _el$getRootNode;
                    const el = $element.get(0);
                    const root = null === (_el$getRootNode = el.getRootNode) || void 0 === _el$getRootNode ? void 0 : _el$getRootNode.call(el);
                    if (!(null !== root && void 0 !== root && root.host)) {
                        return
                    }
                    if (!ownerDocumentStyleSheet) {
                        ownerDocumentStyleSheet = createConstructedStyleSheet(root);
                        processRules(ownerDocumentStyleSheet, el.ownerDocument.styleSheets, false)
                    }
                    const currentShadowDomStyleSheet = createConstructedStyleSheet(root);
                    processRules(currentShadowDomStyleSheet, root.styleSheets, true);
                    root.adoptedStyleSheets = [ownerDocumentStyleSheet, currentShadowDomStyleSheet]
                };
                exports.getShadowElementsFromPoint = function(x, y, root) {
                    const elementQueue = function() {
                        let shiftIndex = 0;
                        const items = [];
                        return {
                            push(item) {
                                items.push(item);
                                return this
                            },
                            shift() {
                                shiftIndex++;
                                return items[shiftIndex - 1]
                            },
                            get length() {
                                return items.length - shiftIndex
                            },
                            get items() {
                                return items
                            }
                        }
                    }().push(root);
                    while (elementQueue.length) {
                        const el = elementQueue.shift();
                        for (let i = 0; i < el.childNodes.length; i++) {
                            const childNode = el.childNodes[i];
                            if (childNode.nodeType === Node.ELEMENT_NODE && isPositionInElementRectangle(childNode, x, y) && "none" !== getComputedStyle(childNode).pointerEvents) {
                                elementQueue.push(childNode)
                            }
                        }
                    }
                    const result = elementQueue.items.reverse();
                    result.pop();
                    return result
                };
                const DX_RULE_PREFIX = "dx-";
                let ownerDocumentStyleSheet = null;

                function createConstructedStyleSheet(rootNode) {
                    try {
                        return new CSSStyleSheet
                    } catch (err) {
                        const styleElement = rootNode.ownerDocument.createElement("style");
                        rootNode.appendChild(styleElement);
                        return styleElement.sheet
                    }
                }

                function processRules(targetStyleSheet, styleSheets, needApplyAllStyles) {
                    for (let i = 0; i < styleSheets.length; i++) {
                        const sheet = styleSheets[i];
                        try {
                            for (let j = 0; j < sheet.cssRules.length; j++) {
                                insertRule(targetStyleSheet, sheet.cssRules[j], needApplyAllStyles)
                            }
                        } catch (err) {}
                    }
                }

                function insertRule(targetStyleSheet, rule, needApplyAllStyles) {
                    var _rule$selectorText, _rule$cssRules, _rule$name, _rule$style;
                    const isDxRule = needApplyAllStyles || (null === (_rule$selectorText = rule.selectorText) || void 0 === _rule$selectorText ? void 0 : _rule$selectorText.includes(DX_RULE_PREFIX)) || (null === (_rule$cssRules = rule.cssRules) || void 0 === _rule$cssRules || null === (_rule$cssRules = _rule$cssRules[0]) || void 0 === _rule$cssRules || null === (_rule$cssRules = _rule$cssRules.selectorText) || void 0 === _rule$cssRules ? void 0 : _rule$cssRules.includes(DX_RULE_PREFIX)) || (null === (_rule$name = rule.name) || void 0 === _rule$name ? void 0 : _rule$name.startsWith(DX_RULE_PREFIX)) || "DXIcons" === (null === (_rule$style = rule.style) || void 0 === _rule$style ? void 0 : _rule$style.fontFamily);
                    if (isDxRule) {
                        targetStyleSheet.insertRule(rule.cssText, targetStyleSheet.cssRules.length)
                    }
                }

                function isPositionInElementRectangle(element, x, y) {
                    var _element$getBoundingC;
                    const rect = null === (_element$getBoundingC = element.getBoundingClientRect) || void 0 === _element$getBoundingC ? void 0 : _element$getBoundingC.call(element);
                    return rect && x >= rect.left && x < rect.right && y >= rect.top && y < rect.bottom
                }
            },
        64587:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_size.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.setWidth = exports.setOuterWidth = exports.setOuterHeight = exports.setInnerWidth = exports.setInnerHeight = exports.setHeight = exports.parseHeight = exports.implementationsMap = exports.getWindowByElement = exports.getWidth = exports.getVisibleHeight = exports.getVerticalOffsets = exports.getSize = exports.getOuterWidth = exports.getOuterHeight = exports.getOffset = exports.getInnerWidth = exports.getInnerHeight = exports.getHeight = exports.getElementBoxParams = exports.addOffsetToMinHeight = exports.addOffsetToMaxHeight = void 0;
                var _dom_adapter = (obj = __webpack_require__( /*! ../../../core/dom_adapter */ 64960), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 3104);
                const window = (0, _window.getWindow)();
                const SPECIAL_HEIGHT_VALUES = ["auto", "none", "inherit", "initial"];
                const getSizeByStyles = function(elementStyles, styles) {
                    let result = 0;
                    styles.forEach((function(style) {
                        result += parseFloat(elementStyles[style]) || 0
                    }));
                    return result
                };
                const getElementBoxParams = function(name, elementStyles) {
                    const beforeName = "width" === name ? "Left" : "Top";
                    const afterName = "width" === name ? "Right" : "Bottom";
                    return {
                        padding: getSizeByStyles(elementStyles, [`padding${beforeName}`, `padding${afterName}`]),
                        border: getSizeByStyles(elementStyles, [`border${beforeName}Width`, `border${afterName}Width`]),
                        margin: getSizeByStyles(elementStyles, [`margin${beforeName}`, `margin${afterName}`])
                    }
                };
                exports.getElementBoxParams = getElementBoxParams;
                const getElementComputedStyle = function(element) {
                    var _element$ownerDocumen;
                    const view = (null === element || void 0 === element || null === (_element$ownerDocumen = element.ownerDocument) || void 0 === _element$ownerDocumen ? void 0 : _element$ownerDocumen.defaultView) || window;
                    return view.getComputedStyle && view.getComputedStyle(element)
                };
                const getCSSProperty = function(element, styles, name, defaultValue) {
                    var _element$style;
                    return (null === styles || void 0 === styles ? void 0 : styles[name]) || (null === (_element$style = element.style) || void 0 === _element$style ? void 0 : _element$style[name]) || defaultValue
                };
                const boxIndices = {
                    content: 0,
                    padding: 1,
                    border: 2,
                    margin: 3,
                    "content-box": 0,
                    "border-box": 2
                };
                const dimensionComponents = {
                    width: ["left", "right"],
                    height: ["top", "bottom"]
                };

                function getComponentThickness(elem, dimension, component, styles) {
                    const get = (elem, styles, field) => parseFloat(getCSSProperty(elem, styles, field, "0")) || 0;
                    const suffix = "border" === component ? "-width" : "";
                    return get(elem, styles, `${component}-${dimensionComponents[dimension][0]}${suffix}`) + get(elem, styles, `${component}-${dimensionComponents[dimension][1]}${suffix}`)
                }
                const getSize = function(element, dimension, box) {
                    const offsetFieldName = "width" === dimension ? "offsetWidth" : "offsetHeight";
                    const styles = getElementComputedStyle(element);
                    let result = getCSSProperty(element, styles, dimension);
                    if ("" === result || "auto" === result) {
                        result = element[offsetFieldName]
                    }
                    result = parseFloat(result) || 0;
                    const currentBox = getCSSProperty(element, styles, "boxSizing", "content-box");
                    const targetBox = box || currentBox;
                    let targetBoxIndex = boxIndices[targetBox];
                    let currentBoxIndex = boxIndices[currentBox];
                    if (void 0 === targetBoxIndex || void 0 === currentBoxIndex) {
                        throw new Error
                    }
                    if (currentBoxIndex === targetBoxIndex) {
                        return result
                    }
                    const coeff = Math.sign(targetBoxIndex - currentBoxIndex);
                    let padding = false;
                    let border = false;
                    let margin = false;
                    let scrollThickness = false;
                    if (1 === coeff) {
                        targetBoxIndex += 1;
                        currentBoxIndex += 1
                    }
                    for (let boxPart = currentBoxIndex; boxPart !== targetBoxIndex; boxPart += coeff) {
                        switch (boxPart) {
                            case boxIndices.content:
                                break;
                            case boxIndices.padding:
                                padding = coeff * getComponentThickness(element, dimension, "padding", styles);
                                break;
                            case boxIndices.border:
                                border = coeff * getComponentThickness(element, dimension, "border", styles);
                                break;
                            case boxIndices.margin:
                                margin = coeff * getComponentThickness(element, dimension, "margin", styles)
                        }
                    }
                    if (padding || border) {
                        const paddingAndBorder = (false === padding ? coeff * getComponentThickness(element, dimension, "padding", styles) : padding) + (false === border ? coeff * getComponentThickness(element, dimension, "border", styles) : border);
                        scrollThickness = coeff * Math.max(0, Math.floor(element[offsetFieldName] - result - coeff * paddingAndBorder)) || 0
                    }
                    return result + margin + padding + border + scrollThickness
                };
                exports.getSize = getSize;
                const parseHeight = function(value, container, element) {
                    if (value.indexOf("px") > 0) {
                        value = parseInt(value.replace("px", ""))
                    } else if (value.indexOf("%") > 0) {
                        value = parseInt(value.replace("%", "")) * function(container) {
                            return (0, _type.isWindow)(container) ? container.innerHeight : container.offsetHeight
                        }(container) / 100
                    } else if (!isNaN(value)) {
                        value = parseInt(value)
                    } else if (value.indexOf("vh") > 0) {
                        value = window.innerHeight / 100 * parseInt(value.replace("vh", ""))
                    } else if (element && value.indexOf("em") > 0) {
                        value = parseFloat(value.replace("em", "")) * parseFloat(window.getComputedStyle(element).fontSize)
                    }
                    return value
                };
                exports.parseHeight = parseHeight;
                const getHeightWithOffset = function(value, offset, container) {
                    if (!value) {
                        return null
                    }
                    if (SPECIAL_HEIGHT_VALUES.includes(value)) {
                        return offset ? null : value
                    }
                    if ((0, _type.isString)(value)) {
                        value = parseHeight(value, container)
                    }
                    if ((0, _type.isNumeric)(value)) {
                        return Math.max(0, value + offset)
                    }
                    const operationString = offset < 0 ? " - " : " ";
                    return `calc(${value}${operationString}${Math.abs(offset)}px)`
                };
                exports.addOffsetToMaxHeight = function(value, offset, container) {
                    const maxHeight = getHeightWithOffset(value, offset, container);
                    return null !== maxHeight ? maxHeight : "none"
                };
                exports.addOffsetToMinHeight = function(value, offset, container) {
                    const minHeight = getHeightWithOffset(value, offset, container);
                    return null !== minHeight ? minHeight : 0
                };
                exports.getVerticalOffsets = function(element, withMargins) {
                    if (!element) {
                        return 0
                    }
                    const boxParams = getElementBoxParams("height", window.getComputedStyle(element));
                    return boxParams.padding + boxParams.border + (withMargins ? boxParams.margin : 0)
                };
                exports.getVisibleHeight = function(element) {
                    if (element) {
                        var _element$getBoundingC;
                        const boundingClientRect = null === (_element$getBoundingC = element.getBoundingClientRect) || void 0 === _element$getBoundingC ? void 0 : _element$getBoundingC.call(element);
                        if (null !== boundingClientRect && void 0 !== boundingClientRect && boundingClientRect.height) {
                            return boundingClientRect.height
                        }
                    }
                    return 0
                };
                const implementationsMap = exports.implementationsMap = {
                    getWidth: function() {
                        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                            args[_key] = arguments[_key]
                        }
                        return elementSizeHelper("width", ...args)
                    },
                    setWidth: function() {
                        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                            args[_key2] = arguments[_key2]
                        }
                        return elementSizeHelper("width", ...args)
                    },
                    getHeight: function() {
                        for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
                            args[_key3] = arguments[_key3]
                        }
                        return elementSizeHelper("height", ...args)
                    },
                    setHeight: function() {
                        for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
                            args[_key4] = arguments[_key4]
                        }
                        return elementSizeHelper("height", ...args)
                    },
                    getOuterWidth: function() {
                        for (var _len5 = arguments.length, args = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
                            args[_key5] = arguments[_key5]
                        }
                        return elementSizeHelper("outerWidth", ...args)
                    },
                    setOuterWidth: function() {
                        for (var _len6 = arguments.length, args = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
                            args[_key6] = arguments[_key6]
                        }
                        return elementSizeHelper("outerWidth", ...args)
                    },
                    getOuterHeight: function() {
                        for (var _len7 = arguments.length, args = new Array(_len7), _key7 = 0; _key7 < _len7; _key7++) {
                            args[_key7] = arguments[_key7]
                        }
                        return elementSizeHelper("outerHeight", ...args)
                    },
                    setOuterHeight: function() {
                        for (var _len8 = arguments.length, args = new Array(_len8), _key8 = 0; _key8 < _len8; _key8++) {
                            args[_key8] = arguments[_key8]
                        }
                        return elementSizeHelper("outerHeight", ...args)
                    },
                    getInnerWidth: function() {
                        for (var _len9 = arguments.length, args = new Array(_len9), _key9 = 0; _key9 < _len9; _key9++) {
                            args[_key9] = arguments[_key9]
                        }
                        return elementSizeHelper("innerWidth", ...args)
                    },
                    setInnerWidth: function() {
                        for (var _len10 = arguments.length, args = new Array(_len10), _key10 = 0; _key10 < _len10; _key10++) {
                            args[_key10] = arguments[_key10]
                        }
                        return elementSizeHelper("innerWidth", ...args)
                    },
                    getInnerHeight: function() {
                        for (var _len11 = arguments.length, args = new Array(_len11), _key11 = 0; _key11 < _len11; _key11++) {
                            args[_key11] = arguments[_key11]
                        }
                        return elementSizeHelper("innerHeight", ...args)
                    },
                    setInnerHeight: function() {
                        for (var _len12 = arguments.length, args = new Array(_len12), _key12 = 0; _key12 < _len12; _key12++) {
                            args[_key12] = arguments[_key12]
                        }
                        return elementSizeHelper("innerHeight", ...args)
                    }
                };

                function elementSizeHelper(sizeProperty, el, value) {
                    return 2 === arguments.length ? elementSize(el, sizeProperty) : elementSize(el, sizeProperty, value)
                }
                exports.getWidth = el => implementationsMap.getWidth(el);
                exports.setWidth = (el, value) => implementationsMap.setWidth(el, value);
                exports.getHeight = el => implementationsMap.getHeight(el);
                exports.setHeight = (el, value) => implementationsMap.setHeight(el, value);
                exports.getOuterWidth = (el, includeMargin) => implementationsMap.getOuterWidth(el, includeMargin || false);
                exports.setOuterWidth = (el, value) => implementationsMap.setOuterWidth(el, value);
                exports.getOuterHeight = (el, includeMargin) => implementationsMap.getOuterHeight(el, includeMargin || false);
                exports.setOuterHeight = (el, value) => implementationsMap.setOuterHeight(el, value);
                exports.getInnerWidth = el => implementationsMap.getInnerWidth(el);
                exports.setInnerWidth = (el, value) => implementationsMap.setInnerWidth(el, value);
                exports.getInnerHeight = el => implementationsMap.getInnerHeight(el);
                exports.setInnerHeight = (el, value) => implementationsMap.setInnerHeight(el, value);
                const elementSize = function(el, sizeProperty, value) {
                    const partialName = sizeProperty.toLowerCase().indexOf("width") >= 0 ? "Width" : "Height";
                    const propName = partialName.toLowerCase();
                    const isOuter = 0 === sizeProperty.indexOf("outer");
                    const isInner = 0 === sizeProperty.indexOf("inner");
                    const isGetter = 2 === arguments.length || "boolean" === typeof value;
                    if ((0, _type.isRenderer)(el)) {
                        if (el.length > 1 && !isGetter) {
                            for (let i = 0; i < el.length; i++) {
                                elementSize(el[i], sizeProperty, value)
                            }
                            return
                        }
                        el = el[0]
                    }
                    if (!el) {
                        return
                    }
                    if ((0, _type.isWindow)(el)) {
                        return isOuter ? el[`inner${partialName}`] : _dom_adapter.default.getDocumentElement()[`client${partialName}`]
                    }
                    if (_dom_adapter.default.isDocument(el)) {
                        const documentElement = _dom_adapter.default.getDocumentElement();
                        const body = _dom_adapter.default.getBody();
                        return Math.max(body[`scroll${partialName}`], body[`offset${partialName}`], documentElement[`scroll${partialName}`], documentElement[`offset${partialName}`], documentElement[`client${partialName}`])
                    }
                    if (isGetter) {
                        let box = "content";
                        if (isOuter) {
                            box = value ? "margin" : "border"
                        }
                        if (isInner) {
                            box = "padding"
                        }
                        return getSize(el, propName, box)
                    }
                    if ((0, _type.isNumeric)(value)) {
                        const elementStyles = getElementComputedStyle(el);
                        const sizeAdjustment = getElementBoxParams(propName, elementStyles);
                        const isBorderBox = "border-box" === elementStyles.boxSizing;
                        value = Number(value);
                        if (isOuter) {
                            value -= isBorderBox ? 0 : sizeAdjustment.border + sizeAdjustment.padding
                        } else if (isInner) {
                            value += isBorderBox ? sizeAdjustment.border : -sizeAdjustment.padding
                        } else if (isBorderBox) {
                            value += sizeAdjustment.border + sizeAdjustment.padding
                        }
                    }
                    value += (0, _type.isNumeric)(value) ? "px" : "";
                    _dom_adapter.default.setStyle(el, propName, value);
                    return null
                };
                const getWindowByElement = el => (0, _type.isWindow)(el) ? el : el.defaultView;
                exports.getWindowByElement = getWindowByElement;
                exports.getOffset = el => {
                    if (!el.getClientRects().length) {
                        return {
                            top: 0,
                            left: 0
                        }
                    }
                    const rect = el.getBoundingClientRect();
                    const win = getWindowByElement(el.ownerDocument);
                    const docElem = el.ownerDocument.documentElement;
                    return {
                        top: rect.top + win.pageYOffset - docElem.clientTop,
                        left: rect.left + win.pageXOffset - docElem.clientLeft
                    }
                }
            },
        47865:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_storage.js ***!
              \********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.sessionStorage = void 0;
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 3104);
                const window = (0, _window.getWindow)();
                exports.sessionStorage = function() {
                    let sessionStorage;
                    try {
                        sessionStorage = window.sessionStorage
                    } catch (e) {}
                    return sessionStorage
                }
            },
        32527:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_string.js ***!
              \*******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.encodeHtml = void 0;
                exports.format = function(template) {
                    for (var _len = arguments.length, values = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                        values[_key - 1] = arguments[_key]
                    }
                    if ((0, _type.isFunction)(template)) {
                        return template(...values)
                    }
                    values.forEach(((value, index) => {
                        if ((0, _type.isString)(value)) {
                            value = value.replace(/\$/g, "$$$$")
                        }
                        const placeholderReg = new RegExp(`\\{${index}\\}`, "gm");
                        template = template.replace(placeholderReg, value)
                    }));
                    return template
                };
                exports.quadToObject = exports.isEmpty = void 0;
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                exports.encodeHtml = function() {
                    const encodeRegExp = [new RegExp("&", "g"), new RegExp('"', "g"), new RegExp("'", "g"), new RegExp("<", "g"), new RegExp(">", "g")];
                    return function(str) {
                        return String(str).replace(encodeRegExp[0], "&amp;").replace(encodeRegExp[1], "&quot;").replace(encodeRegExp[2], "&#39;").replace(encodeRegExp[3], "&lt;").replace(encodeRegExp[4], "&gt;")
                    }
                }();
                exports.quadToObject = function(raw) {
                    const quad = function(raw) {
                        switch (typeof raw) {
                            case "string":
                                return raw.split(/\s+/, 4);
                            case "object":
                                return [raw.x || raw.h || raw.left, raw.y || raw.v || raw.top, raw.x || raw.h || raw.right, raw.y || raw.v || raw.bottom];
                            case "number":
                                return [raw];
                            default:
                                return raw
                        }
                    }(raw);
                    let left = parseInt(quad && quad[0], 10);
                    let top = parseInt(quad && quad[1], 10);
                    let right = parseInt(quad && quad[2], 10);
                    let bottom = parseInt(quad && quad[3], 10);
                    if (!isFinite(left)) {
                        left = 0
                    }
                    if (!isFinite(top)) {
                        top = left
                    }
                    if (!isFinite(right)) {
                        right = left
                    }
                    if (!isFinite(bottom)) {
                        bottom = top
                    }
                    return {
                        top: top,
                        right: right,
                        bottom: bottom,
                        left: left
                    }
                };
                exports.isEmpty = function() {
                    const SPACE_REGEXP = /\s/g;
                    return function(text) {
                        return !text || !text.replace(SPACE_REGEXP, "")
                    }
                }()
            },
        47453:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_stubs.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.stubComponent = function(componentName) {
                    return class {
                        constructor() {
                            throw new Error(`Module '${componentName}' not found`)
                        }
                        static getInstance() {}
                    }
                }
            },
        11953:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_style.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.stylePropPrefix = exports.styleProp = exports.setWidth = exports.setStyle = exports.setHeight = exports.parsePixelValue = exports.normalizeStyleProp = void 0;
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../core/dom_adapter */ 64960));
                var _call_once = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/call_once */ 13630));
                var _inflector = __webpack_require__( /*! ../../../core/utils/inflector */ 53124);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const jsPrefixes = ["", "Webkit", "Moz", "O", "Ms"];
                const cssPrefixes = {
                    "": "",
                    Webkit: "-webkit-",
                    Moz: "-moz-",
                    O: "-o-",
                    ms: "-ms-"
                };
                const getStyles = (0, _call_once.default)((function() {
                    return _dom_adapter.default.createElement("dx").style
                }));
                exports.styleProp = function(name) {
                    if (name in getStyles()) {
                        return name
                    }
                    const originalName = name;
                    name = name.charAt(0).toUpperCase() + name.substr(1);
                    for (let i = 1; i < jsPrefixes.length; i++) {
                        const prefixedProp = jsPrefixes[i].toLowerCase() + name;
                        if (prefixedProp in getStyles()) {
                            return prefixedProp
                        }
                    }
                    return originalName
                };
                exports.stylePropPrefix = function(prop) {
                    return function(prop, callBack) {
                        prop = (0, _inflector.camelize)(prop, true);
                        let result;
                        for (let i = 0, cssPrefixesCount = jsPrefixes.length; i < cssPrefixesCount; i++) {
                            const jsPrefix = jsPrefixes[i];
                            const prefixedProp = jsPrefix + prop;
                            const lowerPrefixedProp = (0, _inflector.camelize)(prefixedProp);
                            result = callBack(lowerPrefixedProp, jsPrefix);
                            if (void 0 === result) {
                                result = callBack(prefixedProp, jsPrefix)
                            }
                            if (void 0 !== result) {
                                break
                            }
                        }
                        return result || ""
                    }(prop, (function(specific, jsPrefix) {
                        if (specific in getStyles()) {
                            return cssPrefixes[jsPrefix]
                        }
                    }))
                };
                const pxExceptions = ["fillOpacity", "columnCount", "flexGrow", "flexShrink", "fontWeight", "lineHeight", "opacity", "zIndex", "zoom"];
                exports.parsePixelValue = function(value) {
                    if ((0, _type.isNumeric)(value)) {
                        return value
                    }
                    if ((0, _type.isString)(value)) {
                        return Number(value.replace("px", ""))
                    }
                    return NaN
                };
                exports.normalizeStyleProp = function(prop, value) {
                    if ((0, _type.isNumeric)(value) && !pxExceptions.includes(prop)) {
                        value += "px"
                    }
                    return value
                };
                const setDimensionProperty = function(elements, propertyName, value) {
                    if (elements) {
                        value = (0, _type.isNumeric)(value) ? value += "px" : value;
                        for (let i = 0; i < elements.length; ++i) {
                            elements[i].style[propertyName] = value
                        }
                    }
                };
                exports.setWidth = function(elements, value) {
                    setDimensionProperty(elements, "width", value)
                };
                exports.setHeight = function(elements, value) {
                    setDimensionProperty(elements, "height", value)
                };
                exports.setStyle = function(element, styleString) {
                    let resetStyle = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : true;
                    if (resetStyle) {
                        const styleList = [].slice.call(element.style);
                        styleList.forEach((propertyName => {
                            element.style.removeProperty(propertyName)
                        }))
                    }
                    styleString.split(";").forEach((style => {
                        const parts = style.split(":").map((stylePart => stylePart.trim()));
                        if (2 === parts.length) {
                            const [property, value] = parts;
                            element.style[property] = value
                        }
                    }))
                }
            },
        85991:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_support.js ***!
              \********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.pointerEvents = exports.nativeScrolling = exports.inputType = exports.default = exports.animation = void 0;
                Object.defineProperty(exports, "styleProp", {
                    enumerable: true,
                    get: function() {
                        return _style.styleProp
                    }
                });
                Object.defineProperty(exports, "stylePropPrefix", {
                    enumerable: true,
                    get: function() {
                        return _style.stylePropPrefix
                    }
                });
                exports.transitionEndEventName = exports.transition = exports.touchEvents = exports.touch = exports.supportProp = void 0;
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../../core/devices */ 65951));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../core/dom_adapter */ 64960));
                var _call_once = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/call_once */ 13630));
                var _style = __webpack_require__( /*! ../../../core/utils/style */ 58515);
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 3104);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const {
                    maxTouchPoints: maxTouchPoints
                } = (0, _window.getNavigator)();
                const transitionEndEventNames = {
                    webkitTransition: "webkitTransitionEnd",
                    MozTransition: "transitionend",
                    OTransition: "oTransitionEnd",
                    transition: "transitionend"
                };
                const supportProp = function(prop) {
                    return !!(0, _style.styleProp)(prop)
                };
                exports.supportProp = supportProp;
                const inputType = function(type) {
                    if ("text" === type) {
                        return true
                    }
                    const input = _dom_adapter.default.createElement("input");
                    try {
                        input.setAttribute("type", type);
                        input.value = "wrongValue";
                        return !input.value
                    } catch (e) {
                        return false
                    }
                };
                exports.inputType = inputType;
                const touchEvents = exports.touchEvents = function(hasWindowProperty, maxTouchPoints) {
                    return (hasWindowProperty("ontouchstart") || !!maxTouchPoints) && !hasWindowProperty("callPhantom")
                }(_window.hasProperty, maxTouchPoints);
                const pointerEvents = exports.pointerEvents = (hasWindowProperty = _window.hasProperty, hasWindowProperty("PointerEvent"));
                var hasWindowProperty;
                const touchPointersPresent = !!maxTouchPoints;
                const touch = exports.touch = touchEvents || pointerEvents && touchPointersPresent;
                const transition = exports.transition = (0, _call_once.default)((function() {
                    return supportProp("transition")
                }));
                const transitionEndEventName = exports.transitionEndEventName = (0, _call_once.default)((function() {
                    return transitionEndEventNames[(0, _style.styleProp)("transition")]
                }));
                const animation = exports.animation = (0, _call_once.default)((function() {
                    return supportProp("animation")
                }));
                const nativeScrolling = exports.nativeScrolling = function() {
                    const {
                        platform: platform,
                        mac: isMac
                    } = _devices.default.real();
                    const isNativeScrollDevice = "ios" === platform || "android" === platform || isMac;
                    return isNativeScrollDevice
                }();
                exports.default = {
                    animation: animation,
                    inputType: inputType,
                    nativeScrolling: nativeScrolling,
                    pointerEvents: pointerEvents,
                    styleProp: _style.styleProp,
                    stylePropPrefix: _style.stylePropPrefix,
                    supportProp: supportProp,
                    touch: touch,
                    touchEvents: touchEvents,
                    transition: transition,
                    transitionEndEventName: transitionEndEventName
                }
            },
        89650:
            /*!****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_svg.js ***!
              \****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = exports.HIDDEN_FOR_EXPORT = void 0;
                exports.getSvgElement = getSvgElement;
                exports.getSvgMarkup = getSvgMarkup;
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../core/dom_adapter */ 64960));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 3104);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const window = (0, _window.getWindow)();
                const HIDDEN_FOR_EXPORT = exports.HIDDEN_FOR_EXPORT = "hidden-for-export";

                function getSvgMarkup(element, backgroundColor) {
                    return function(markup) {
                        let first = true;
                        if (-1 === markup.indexOf("xmlns:xlink")) {
                            markup = markup.replace("<svg", '<svg xmlns:xlink="http://www.w3.org/1999/xlink"')
                        }
                        markup = markup.replace(/xmlns="[\s\S]*?"/gi, (function(match) {
                            if (!first) {
                                return ""
                            }
                            first = false;
                            return match
                        }));
                        return markup.replace(/xmlns:NS1="[\s\S]*?"/gi, "").replace(/NS1:xmlns:xlink="([\s\S]*?)"/gi, 'xmlns:xlink="$1"')
                    }((markup = function(element, backgroundColor) {
                        const temp = _dom_adapter.default.createElement("div");
                        const clone = element.cloneNode(true);
                        if (backgroundColor) {
                            (0, _renderer.default)(clone).css("backgroundColor", backgroundColor)
                        }
                        temp.appendChild(clone);
                        return temp.innerHTML
                    }(element, backgroundColor), markup.replace(/&quot;/gi, "&#34;").replace(/&amp;/gi, "&#38;").replace(/&apos;/gi, "&#39;").replace(/&lt;/gi, "&#60;").replace(/&gt;/gi, "&#62;").replace(/&nbsp;/gi, "&#160;").replace(/&shy;/gi, "&#173;")));
                    var markup
                }

                function getSvgElement(markup) {
                    if ((0, _type.isString)(markup)) {
                        const parsedMarkup = (new window.DOMParser).parseFromString(markup, "image/svg+xml").childNodes[0];
                        return parsedMarkup
                    }
                    if (_dom_adapter.default.isNode(markup)) {
                        return markup
                    }
                    if ((0, _type.isRenderer)(markup)) {
                        return markup.get(0)
                    }
                }
                exports.default = {
                    getSvgElement: getSvgElement,
                    getSvgMarkup: getSvgMarkup,
                    HIDDEN_FOR_EXPORT: HIDDEN_FOR_EXPORT
                }
            },
        91008:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_template_manager.js ***!
              \*****************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.validateTemplateSource = exports.templateKey = exports.suitableTemplatesByName = exports.getNormalizedTemplateArgs = exports.findTemplates = exports.defaultCreateElement = exports.default = exports.addPublicElementNormalization = exports.addOneRenderedCall = exports.acquireTemplate = exports.acquireIntegrationTemplate = void 0;
                var _config = _interopRequireDefault(__webpack_require__( /*! ../../../core/config */ 66636));
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../../core/devices */ 65951));
                var _element = __webpack_require__( /*! ../../../core/element */ 61404);
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../../../core/errors */ 87129));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _child_default_template = __webpack_require__( /*! ../../../core/templates/child_default_template */ 91585);
                var _empty_template = __webpack_require__( /*! ../../../core/templates/empty_template */ 48650);
                var _template = __webpack_require__( /*! ../../../core/templates/template */ 67872);
                var _template_base = __webpack_require__( /*! ../../../core/templates/template_base */ 42186);
                var _array = __webpack_require__( /*! ../../../core/utils/array */ 94487);
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _m_dom = _interopRequireDefault(__webpack_require__( /*! ./m_dom */ 76400));
                var _m_type = _interopRequireDefault(__webpack_require__( /*! ./m_type */ 39918));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const findTemplates = (element, name) => {
                    const templates = (0, _renderer.default)(element).contents().filter(`[data-options*="${name}"]`);
                    return [].slice.call(templates).map((element => {
                        const optionsString = (0, _renderer.default)(element).attr("data-options") || "";
                        return {
                            element: element,
                            options: (0, _config.default)().optionsParser(optionsString)[name]
                        }
                    })).filter((template => !!template.options))
                };
                exports.findTemplates = findTemplates;
                const suitableTemplatesByName = rawTemplates => {
                    const templatesMap = (0, _array.groupBy)(rawTemplates, (template => template.options.name));
                    if (templatesMap.undefined) {
                        throw _errors.default.Error("E0023")
                    }
                    const result = {};
                    Object.keys(templatesMap).forEach((name => {
                        var _findBestMatches$;
                        const suitableTemplate = null === (_findBestMatches$ = (0, _common.findBestMatches)(_devices.default.current(), templatesMap[name], (template => template.options))[0]) || void 0 === _findBestMatches$ ? void 0 : _findBestMatches$.element;
                        if (suitableTemplate) {
                            result[name] = suitableTemplate
                        }
                    }));
                    return result
                };
                exports.suitableTemplatesByName = suitableTemplatesByName;
                const addOneRenderedCall = template => {
                    const render = template.render.bind(template);
                    return (0, _extend.extend)({}, template, {
                        render(options) {
                            const templateResult = render(options);
                            options && options.onRendered && options.onRendered();
                            return templateResult
                        }
                    })
                };
                exports.addOneRenderedCall = addOneRenderedCall;
                const addPublicElementNormalization = template => {
                    const render = template.render.bind(template);
                    return (0, _extend.extend)({}, template, {
                        render(options) {
                            const $container = (0, _renderer.default)(options.container);
                            return render(_extends({}, options, {
                                container: (0, _element.getPublicElement)($container)
                            }))
                        }
                    })
                };
                exports.addPublicElementNormalization = addPublicElementNormalization;
                const getNormalizedTemplateArgs = options => {
                    const args = [];
                    if ("model" in options) {
                        args.push(options.model)
                    }
                    if ("index" in options) {
                        args.push(options.index)
                    }
                    args.push(options.container);
                    return args
                };
                exports.getNormalizedTemplateArgs = getNormalizedTemplateArgs;
                const validateTemplateSource = templateSource => "string" === typeof templateSource ? _m_dom.default.normalizeTemplateElement(templateSource) : templateSource;
                exports.validateTemplateSource = validateTemplateSource;
                const templateKey = templateSource => _m_type.default.isRenderer(templateSource) && templateSource[0] || templateSource;
                exports.templateKey = templateKey;
                const defaultCreateElement = element => new _template.Template(element);
                exports.defaultCreateElement = defaultCreateElement;
                const acquireIntegrationTemplate = (templateSource, templates, isAsyncTemplate, skipTemplates) => {
                    let integrationTemplate = null;
                    if (!skipTemplates || -1 === skipTemplates.indexOf(templateSource)) {
                        integrationTemplate = templates[templateSource];
                        if (integrationTemplate && !(integrationTemplate instanceof _template_base.TemplateBase)) {
                            if (_m_type.default.isFunction(integrationTemplate.render)) {
                                integrationTemplate = addPublicElementNormalization(integrationTemplate)
                            }
                            if (!isAsyncTemplate) {
                                integrationTemplate = addOneRenderedCall(integrationTemplate)
                            }
                        }
                    }
                    return integrationTemplate
                };
                exports.acquireIntegrationTemplate = acquireIntegrationTemplate;
                const acquireTemplate = (templateSource, createTemplate, templates, isAsyncTemplate, skipTemplates, defaultTemplates) => {
                    if (null == templateSource) {
                        return new _empty_template.EmptyTemplate
                    }
                    if (templateSource instanceof _child_default_template.ChildDefaultTemplate) {
                        return defaultTemplates[templateSource.name]
                    }
                    if (templateSource instanceof _template_base.TemplateBase) {
                        return templateSource
                    }
                    if (_m_type.default.isFunction(templateSource.render) && !_m_type.default.isRenderer(templateSource)) {
                        return isAsyncTemplate ? templateSource : addOneRenderedCall(templateSource)
                    }
                    if (templateSource.nodeType || _m_type.default.isRenderer(templateSource)) {
                        return createTemplate((0, _renderer.default)(templateSource))
                    }
                    return acquireIntegrationTemplate(templateSource, templates, isAsyncTemplate, skipTemplates) || defaultTemplates[templateSource] || createTemplate(templateSource)
                };
                exports.acquireTemplate = acquireTemplate;
                exports.default = {
                    findTemplates: findTemplates,
                    suitableTemplatesByName: suitableTemplatesByName,
                    addOneRenderedCall: addOneRenderedCall,
                    addPublicElementNormalization: addPublicElementNormalization,
                    getNormalizedTemplateArgs: getNormalizedTemplateArgs,
                    validateTemplateSource: validateTemplateSource,
                    templateKey: templateKey,
                    defaultCreateElement: defaultCreateElement,
                    acquireIntegrationTemplate: acquireIntegrationTemplate,
                    acquireTemplate: acquireTemplate
                }
            },
        39918:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_type.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.type = exports.isWindow = exports.isString = exports.isRenderer = exports.isPromise = exports.isPrimitive = exports.isPlainObject = exports.isObject = exports.isNumeric = exports.isFunction = exports.isExponential = exports.isEvent = exports.isEmptyObject = exports.isDefined = exports.isDeferred = exports.isDate = exports.isBoolean = exports.default = void 0;
                const types = {
                    "[object Array]": "array",
                    "[object Date]": "date",
                    "[object Object]": "object",
                    "[object String]": "string"
                };
                const type = function(object) {
                    if (null === object) {
                        return "null"
                    }
                    const typeOfObject = Object.prototype.toString.call(object);
                    return "object" === typeof object ? types[typeOfObject] || "object" : typeof object
                };
                exports.type = type;
                const isBoolean = function(object) {
                    return "boolean" === typeof object
                };
                exports.isBoolean = isBoolean;
                const isExponential = function(value) {
                    return isNumeric(value) && -1 !== value.toString().indexOf("e")
                };
                exports.isExponential = isExponential;
                const isDate = function(object) {
                    return "date" === type(object)
                };
                exports.isDate = isDate;
                const isDefined = function(object) {
                    return null !== object && void 0 !== object
                };
                exports.isDefined = isDefined;
                const isFunction = function(object) {
                    return "function" === typeof object
                };
                exports.isFunction = isFunction;
                const isString = function(object) {
                    return "string" === typeof object
                };
                exports.isString = isString;
                const isNumeric = function(object) {
                    return "number" === typeof object && isFinite(object) || !isNaN(object - parseFloat(object))
                };
                exports.isNumeric = isNumeric;
                const isObject = function(object) {
                    return "object" === type(object)
                };
                exports.isObject = isObject;
                const isEmptyObject = function(object) {
                    let property;
                    for (property in object) {
                        return false
                    }
                    return true
                };
                exports.isEmptyObject = isEmptyObject;
                const isPlainObject = function(object) {
                    if (!object || "object" !== type(object)) {
                        return false
                    }
                    const proto = Object.getPrototypeOf(object);
                    if (!proto) {
                        return true
                    }
                    const ctor = Object.hasOwnProperty.call(proto, "constructor") && proto.constructor;
                    return "function" === typeof ctor && Object.toString.call(ctor) === Object.toString.call(Object)
                };
                exports.isPlainObject = isPlainObject;
                const isPrimitive = function(value) {
                    return !["object", "array", "function"].includes(type(value))
                };
                exports.isPrimitive = isPrimitive;
                const isWindow = function(object) {
                    return null != object && object === object.window
                };
                exports.isWindow = isWindow;
                const isRenderer = function(object) {
                    return !!object && !!(object.jquery || object.dxRenderer)
                };
                exports.isRenderer = isRenderer;
                const isPromise = function(object) {
                    return !!object && isFunction(object.then)
                };
                exports.isPromise = isPromise;
                const isDeferred = function(object) {
                    return !!object && isFunction(object.done) && isFunction(object.fail)
                };
                exports.isDeferred = isDeferred;
                const isEvent = function(object) {
                    return !!(object && object.preventDefault)
                };
                exports.isEvent = isEvent;
                exports.default = {
                    isBoolean: isBoolean,
                    isDate: isDate,
                    isDeferred: isDeferred,
                    isDefined: isDefined,
                    isEmptyObject: isEmptyObject,
                    isEvent: isEvent,
                    isExponential: isExponential,
                    isFunction: isFunction,
                    isNumeric: isNumeric,
                    isObject: isObject,
                    isPlainObject: isPlainObject,
                    isPrimitive: isPrimitive,
                    isPromise: isPromise,
                    isRenderer: isRenderer,
                    isString: isString,
                    isWindow: isWindow,
                    type: type
                }
            },
        66082:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_variable_wrapper.js ***!
              \*****************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.variableWrapper = void 0;
                var _console = __webpack_require__( /*! ../../../core/utils/console */ 31951);
                var _dependency_injector = (obj = __webpack_require__( /*! ../../../core/utils/dependency_injector */ 89656), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                exports.variableWrapper = (0, _dependency_injector.default)({
                    isWrapped: function() {
                        return false
                    },
                    isWritableWrapped: function() {
                        return false
                    },
                    wrap: function(value) {
                        return value
                    },
                    unwrap: function(value) {
                        return value
                    },
                    assign: function() {
                        _console.logger.error("Method 'assign' should not be used for not wrapped variables. Use 'isWrapped' method for ensuring.")
                    }
                })
            },
        5388:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_version.js ***!
              \********************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.compare = function(x, y, maxLevel) {
                    function normalizeArg(value) {
                        if ("string" === typeof value) {
                            return value.split(".")
                        }
                        if ("number" === typeof value) {
                            return [value]
                        }
                        return value
                    }
                    x = normalizeArg(x);
                    y = normalizeArg(y);
                    let length = Math.max(x.length, y.length);
                    if (isFinite(maxLevel)) {
                        length = Math.min(length, maxLevel)
                    }
                    for (let i = 0; i < length; i++) {
                        const xItem = parseInt(x[i] || 0, 10);
                        const yItem = parseInt(y[i] || 0, 10);
                        if (xItem < yItem) {
                            return -1
                        }
                        if (xItem > yItem) {
                            return 1
                        }
                    }
                    return 0
                }
            },
        65913:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_view_port.js ***!
              \**********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.changeCallback = void 0;
                exports.originalViewPort = function() {
                    return $originalViewPort
                };
                exports.value = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/callbacks */ 84718));
                var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/ready_callbacks */ 3122));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const ready = _ready_callbacks.default.add;
                const changeCallback = exports.changeCallback = (0, _callbacks.default)();
                let $originalViewPort = (0, _renderer.default)();
                const value = exports.value = function() {
                    let $current;
                    return function(element) {
                        if (!arguments.length) {
                            return $current
                        }
                        const $element = (0, _renderer.default)(element);
                        $originalViewPort = $element;
                        const isNewViewportFound = !!$element.length;
                        const prevViewPort = value();
                        $current = isNewViewportFound ? $element : (0, _renderer.default)("body");
                        changeCallback.fire(isNewViewportFound ? value() : (0, _renderer.default)(), prevViewPort)
                    }
                }();
                ready((function() {
                    value(".dx-viewport")
                }))
            },
        14470:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_window.js ***!
              \*******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.setWindow = exports.hasWindow = exports.hasProperty = exports.getWindow = exports.getNavigator = exports.getCurrentScreenFactor = exports.defaultScreenFactorFunc = exports.default = void 0;
                var _dom_adapter = (obj = __webpack_require__( /*! ../../../core/dom_adapter */ 64960), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                let hasWindowValue = "undefined" !== typeof window;
                const hasWindow = () => hasWindowValue;
                exports.hasWindow = hasWindow;
                let windowObject = hasWindow() ? window : void 0;
                if (!windowObject) {
                    windowObject = {};
                    windowObject.window = windowObject
                }
                const getWindow = () => windowObject;
                exports.getWindow = getWindow;
                const setWindow = (newWindowObject, hasWindow) => {
                    if (void 0 === hasWindow) {
                        hasWindowValue = "undefined" !== typeof window && window === newWindowObject
                    } else {
                        hasWindowValue = hasWindow
                    }
                    windowObject = newWindowObject
                };
                exports.setWindow = setWindow;
                const hasProperty = prop => hasWindow() && prop in windowObject;
                exports.hasProperty = hasProperty;
                const defaultScreenFactorFunc = width => {
                    if (width < 768) {
                        return "xs"
                    }
                    if (width < 992) {
                        return "sm"
                    }
                    if (width < 1200) {
                        return "md"
                    }
                    return "lg"
                };
                exports.defaultScreenFactorFunc = defaultScreenFactorFunc;
                const getCurrentScreenFactor = screenFactorCallback => {
                    const screenFactorFunc = screenFactorCallback || defaultScreenFactorFunc;
                    const windowWidth = _dom_adapter.default.getDocumentElement().clientWidth;
                    return screenFactorFunc(windowWidth)
                };
                exports.getCurrentScreenFactor = getCurrentScreenFactor;
                const getNavigator = () => {
                    var _windowObject;
                    return hasWindow() ? null === (_windowObject = windowObject) || void 0 === _windowObject ? void 0 : _windowObject.navigator : {
                        userAgent: ""
                    }
                };
                exports.getNavigator = getNavigator;
                exports.default = {
                    defaultScreenFactorFunc: defaultScreenFactorFunc,
                    getCurrentScreenFactor: getCurrentScreenFactor,
                    getNavigator: getNavigator,
                    getWindow: getWindow,
                    hasProperty: hasProperty,
                    hasWindow: hasWindow,
                    setWindow: setWindow
                }
            },
        12220:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/math.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.shiftIntegerByModule = void 0;
                exports.shiftIntegerByModule = (integerValue, moduleValue) => {
                    if (!Number.isInteger(integerValue)) {
                        throw Error(`Passed integer value ${integerValue} is not an integer.`)
                    }
                    if (!Number.isInteger(moduleValue)) {
                        throw Error(`Passed module value ${moduleValue} is not an integer.`)
                    }
                    if (moduleValue <= 0) {
                        throw Error(`Passed module value ${moduleValue} must be > 0.`)
                    }
                    const normalizedInteger = integerValue % moduleValue;
                    switch (true) {
                        case 0 === normalizedInteger:
                            return 0;
                        case normalizedInteger > 0:
                            return normalizedInteger;
                        case normalizedInteger < 0:
                            return moduleValue + normalizedInteger;
                        default:
                            throw Error(`Unexpected division (${integerValue} % ${moduleValue}) occurred.`)
                    }
                }
            },
        51413:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/promise.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.createPromise = function() {
                    let resolve;
                    let reject;
                    const promise = new Promise(((res, rej) => {
                        resolve = res;
                        reject = rej
                    }));
                    return {
                        promise: promise,
                        resolve: resolve,
                        reject: reject
                    }
                }
            },
        11371:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/scroll.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getMemoizeScrollTo = function(getScrollableInstance) {
                    const instance = getScrollableInstance();
                    let lastParams = {};
                    return function(params) {
                        let force = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : false;
                        const normalizedParams = {
                            top: void 0 !== params.top ? Math.ceil(params.top) : void 0,
                            left: void 0 !== params.left ? Math.ceil(params.left) : void 0
                        };
                        const isSameParams = normalizedParams.top === lastParams.top && normalizedParams.left === lastParams.left;
                        if (!force && isSameParams) {
                            return
                        }
                        lastParams = normalizedParams;
                        instance.scrollTo(params)
                    }
                }
            },
        65020:
            /*!*********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/widget/component.js ***!
              \*********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Component = void 0;
                var _action = _interopRequireDefault(__webpack_require__( /*! ../../../core/action */ 88412));
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../../core/class */ 55620));
                var _config = _interopRequireDefault(__webpack_require__( /*! ../../../core/config */ 66636));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../../../core/errors */ 87129));
                var _events_strategy = __webpack_require__( /*! ../../../core/events_strategy */ 2607);
                var _index = __webpack_require__( /*! ../../../core/options/index */ 74453);
                var _utils = __webpack_require__( /*! ../../../core/options/utils */ 53904);
                var _postponed_operations = __webpack_require__( /*! ../../../core/postponed_operations */ 21971);
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/callbacks */ 84718));
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _data = __webpack_require__( /*! ../../../core/utils/data */ 31e3);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _public_component = __webpack_require__( /*! ../../../core/utils/public_component */ 85521);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const getEventName = actionName => actionName.charAt(2).toLowerCase() + actionName.substr(3);
                class Component extends(_class.default.inherit({})) {
                    _setDeprecatedOptions() {
                        this._deprecatedOptions = {}
                    }
                    _getDeprecatedOptions() {
                        return this._deprecatedOptions
                    }
                    _getDefaultOptions() {
                        return {
                            onInitialized: null,
                            onOptionChanged: null,
                            onDisposing: null,
                            defaultOptionsRules: null
                        }
                    }
                    _defaultOptionsRules() {
                        return []
                    }
                    _setOptionsByDevice(rules) {
                        this._options.applyRules(rules)
                    }
                    _convertRulesToOptions(rules) {
                        return (0, _utils.convertRulesToOptions)(rules)
                    }
                    _isInitialOptionValue(name) {
                        return this._options.isInitial(name)
                    }
                    _setOptionsByReference() {
                        this._optionsByReference = {}
                    }
                    _getOptionsByReference() {
                        return this._optionsByReference
                    }
                    ctor() {
                        let options = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {};
                        const {
                            _optionChangedCallbacks: _optionChangedCallbacks,
                            _disposingCallbacks: _disposingCallbacks
                        } = options;
                        this.NAME = (0, _public_component.name)(this.constructor);
                        this._eventsStrategy = _events_strategy.EventsStrategy.create(this, options.eventsStrategy);
                        this._updateLockCount = 0;
                        this._optionChangedCallbacks = _optionChangedCallbacks || (0, _callbacks.default)();
                        this._disposingCallbacks = _disposingCallbacks || (0, _callbacks.default)();
                        this.postponedOperations = new _postponed_operations.PostponedOperations;
                        this._createOptions(options)
                    }
                    _createOptions(options) {
                        this.beginUpdate();
                        try {
                            this._setOptionsByReference();
                            this._setDeprecatedOptions();
                            this._options = new _index.Options(this._getDefaultOptions(), this._getDefaultOptions(), this._getOptionsByReference(), this._getDeprecatedOptions());
                            this._options.onChanging(((name, previousValue, value) => this._initialized && this._optionChanging(name, previousValue, value)));
                            this._options.onDeprecated(((option, info) => this._logDeprecatedOptionWarning(option, info)));
                            this._options.onChanged(((name, value, previousValue) => this._notifyOptionChanged(name, value, previousValue)));
                            this._options.onStartChange((() => this.beginUpdate()));
                            this._options.onEndChange((() => this.endUpdate()));
                            this._options.addRules(this._defaultOptionsRules());
                            this._options.validateOptions((o => this._validateOptions(o)));
                            if (options && options.onInitializing) {
                                options.onInitializing.apply(this, [options])
                            }
                            this._setOptionsByDevice(options.defaultOptionsRules);
                            this._initOptions(options)
                        } finally {
                            this.endUpdate()
                        }
                    }
                    _initOptions(options) {
                        this.option(options)
                    }
                    _init() {
                        this._createOptionChangedAction();
                        this.on("disposing", (args => {
                            this._disposingCallbacks.fireWith(this, [args])
                        }))
                    }
                    _logDeprecatedOptionWarning(option, info) {
                        const message = info.message || `Use the '${info.alias}' option instead`;
                        _errors.default.log("W0001", this.NAME, option, info.since, message)
                    }
                    _logDeprecatedComponentWarning(since, alias) {
                        _errors.default.log("W0000", this.NAME, since, `Use the '${alias}' widget instead`)
                    }
                    _createOptionChangedAction() {
                        this._optionChangedAction = this._createActionByOption("onOptionChanged", {
                            excludeValidators: ["disabled", "readOnly"]
                        })
                    }
                    _createDisposingAction() {
                        this._disposingAction = this._createActionByOption("onDisposing", {
                            excludeValidators: ["disabled", "readOnly"]
                        })
                    }
                    _optionChanged(args) {
                        const {
                            name: name
                        } = args;
                        switch (name) {
                            case "onDisposing":
                            case "onInitialized":
                            case "defaultOptionsRules":
                            default:
                                break;
                            case "onOptionChanged":
                                this._createOptionChangedAction()
                        }
                    }
                    _dispose() {
                        var _this$_disposingActio;
                        this._optionChangedCallbacks.empty();
                        this._createDisposingAction();
                        null === (_this$_disposingActio = this._disposingAction) || void 0 === _this$_disposingActio || _this$_disposingActio.call(this);
                        this._eventsStrategy.dispose();
                        this._options.dispose();
                        this._disposed = true
                    }
                    _lockUpdate() {
                        this._updateLockCount++
                    }
                    _unlockUpdate() {
                        this._updateLockCount = Math.max(this._updateLockCount - 1, 0)
                    }
                    _isUpdateAllowed() {
                        return 0 === this._updateLockCount
                    }
                    _isInitializingRequired() {
                        return !this._initializing && !this._initialized
                    }
                    isInitialized() {
                        return this._initialized
                    }
                    _commitUpdate() {
                        this.postponedOperations.callPostponedOperations();
                        this._isInitializingRequired() && this._initializeComponent()
                    }
                    _initializeComponent() {
                        this._initializing = true;
                        try {
                            this._init()
                        } finally {
                            this._initializing = false;
                            this._lockUpdate();
                            this._createActionByOption("onInitialized", {
                                excludeValidators: ["disabled", "readOnly"]
                            })();
                            this._unlockUpdate();
                            this._initialized = true
                        }
                    }
                    instance() {
                        return this
                    }
                    beginUpdate() {
                        this._lockUpdate()
                    }
                    endUpdate() {
                        this._unlockUpdate();
                        this._isUpdateAllowed() && this._commitUpdate()
                    }
                    _optionChanging() {}
                    _notifyOptionChanged(option, value, previousValue) {
                        if (this._initialized) {
                            const optionNames = [option].concat(this._options.getAliasesByName(option));
                            for (let i = 0; i < optionNames.length; i++) {
                                const name = optionNames[i];
                                const args = {
                                    name: (0, _data.getPathParts)(name)[0],
                                    fullName: name,
                                    value: value,
                                    previousValue: previousValue
                                };
                                if (!(optionName = name, 0 === optionName.indexOf("_", 0))) {
                                    var _this$_optionChangedA;
                                    this._optionChangedCallbacks.fireWith(this, [(0, _extend.extend)(this._defaultActionArgs(), args)]);
                                    null === (_this$_optionChangedA = this._optionChangedAction) || void 0 === _this$_optionChangedA || _this$_optionChangedA.call(this, (0, _extend.extend)({}, args))
                                }
                                if (!this._disposed && this._cancelOptionChange !== name) {
                                    this._optionChanged(args)
                                }
                            }
                        }
                        var optionName
                    }
                    initialOption(name) {
                        return this._options.initial(name)
                    }
                    _defaultActionConfig() {
                        return {
                            context: this,
                            component: this
                        }
                    }
                    _defaultActionArgs() {
                        return {
                            component: this
                        }
                    }
                    _createAction(actionSource, config) {
                        let action;
                        return e => {
                            if (!(0, _type.isDefined)(e)) {
                                e = {}
                            }
                            if (!(0, _type.isPlainObject)(e)) {
                                e = {
                                    actionValue: e
                                }
                            }
                            action = action || new _action.default(actionSource, (0, _extend.extend)({}, config, this._defaultActionConfig()));
                            return action.execute.call(action, (0, _extend.extend)(e, this._defaultActionArgs()))
                        }
                    }
                    _createActionByOption(optionName, config) {
                        var _this = this;
                        let action;
                        let eventName;
                        let actionFunc;
                        config = (0, _extend.extend)({}, config);
                        const result = function() {
                            if (!eventName) {
                                config = config || {};
                                if ("string" !== typeof optionName) {
                                    throw _errors.default.Error("E0008")
                                }
                                if (optionName.startsWith("on")) {
                                    eventName = getEventName(optionName)
                                }
                                actionFunc = _this.option(optionName)
                            }
                            if (!action && !actionFunc && !config.beforeExecute && !config.afterExecute && !_this._eventsStrategy.hasEvent(eventName)) {
                                return
                            }
                            if (!action) {
                                const {
                                    beforeExecute: beforeExecute
                                } = config;
                                config.beforeExecute = function() {
                                    for (var _len2 = arguments.length, props = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                                        props[_key2] = arguments[_key2]
                                    }
                                    beforeExecute && beforeExecute.apply(_this, props);
                                    _this._eventsStrategy.fireEvent(eventName, props[0].args)
                                };
                                action = _this._createAction(actionFunc, config)
                            }
                            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                                args[_key] = arguments[_key]
                            }
                            if ((0, _config.default)().wrapActionsBeforeExecute) {
                                const beforeActionExecute = _this.option("beforeActionExecute") || _common.noop;
                                const wrappedAction = beforeActionExecute(_this, action, config) || action;
                                return wrappedAction.apply(_this, args)
                            }
                            return action.apply(_this, args)
                        };
                        if ((0, _config.default)().wrapActionsBeforeExecute) {
                            return result
                        }
                        const onActionCreated = this.option("onActionCreated") || _common.noop;
                        return onActionCreated(this, result, config) || result
                    }
                    on(eventName, eventHandler) {
                        this._eventsStrategy.on(eventName, eventHandler);
                        return this
                    }
                    off(eventName, eventHandler) {
                        this._eventsStrategy.off(eventName, eventHandler);
                        return this
                    }
                    hasActionSubscription(actionName) {
                        return !!this._options.silent(actionName) || this._eventsStrategy.hasEvent(getEventName(actionName))
                    }
                    isOptionDeprecated(name) {
                        return this._options.isDeprecated(name)
                    }
                    _setOptionWithoutOptionChange(name, value) {
                        this._cancelOptionChange = name;
                        this.option(name, value);
                        this._cancelOptionChange = false
                    }
                    _getOptionValue(name, context) {
                        const value = this.option(name);
                        if ((0, _type.isFunction)(value)) {
                            return value.bind(context)()
                        }
                        return value
                    }
                    option() {
                        return this._options.option(...arguments)
                    }
                    resetOption(name) {
                        this.beginUpdate();
                        this._options.reset(name);
                        this.endUpdate()
                    }
                    _validateOptions(options) {
                        return options
                    }
                }
                exports.Component = Component
            },
        22331:
            /*!*************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/widget/dom_component.js ***!
              \*************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _config = _interopRequireDefault(__webpack_require__( /*! ../../../core/config */ 66636));
                var _element = __webpack_require__( /*! ../../../core/element */ 61404);
                var _element_data = __webpack_require__( /*! ../../../core/element_data */ 74663);
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../../../core/errors */ 87129));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 21274);
                var _public_component = __webpack_require__( /*! ../../../core/utils/public_component */ 85521);
                var _resize_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/resize_callbacks */ 63283));
                var _shadow_dom = __webpack_require__( /*! ../../../core/utils/shadow_dom */ 93631);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 3104);
                var _short = __webpack_require__( /*! ../../../events/short */ 67960);
                var _license_validation = function(e, r) {
                    if (!r && e && e.__esModule) {
                        return e
                    }
                    if (null === e || "object" != typeof e && "function" != typeof e) {
                        return {
                            default: e
                        }
                    }
                    var t = _getRequireWildcardCache(r);
                    if (t && t.has(e)) {
                        return t.get(e)
                    }
                    var n = {
                            __proto__: null
                        },
                        a = Object.defineProperty && Object.getOwnPropertyDescriptor;
                    for (var u in e) {
                        if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
                            var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
                            i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]
                        }
                    }
                    return n.default = e, t && t.set(e, n), n
                }(__webpack_require__( /*! ../../core/license/license_validation */ 93391));
                var _m_template_manager = _interopRequireDefault(__webpack_require__( /*! ../../core/m_template_manager */ 66298));
                var _component = __webpack_require__( /*! ./component */ 65020);

                function _getRequireWildcardCache(e) {
                    if ("function" != typeof WeakMap) {
                        return null
                    }
                    var r = new WeakMap,
                        t = new WeakMap;
                    return (_getRequireWildcardCache = function(e) {
                        return e ? t : r
                    })(e)
                }

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                class DOMComponent extends _component.Component {
                    static getInstance(element) {
                        return (0, _public_component.getInstanceByElement)((0, _renderer.default)(element), this)
                    }
                    static defaultOptions(rule) {
                        this._classCustomRules = Object.hasOwnProperty.bind(this)("_classCustomRules") && this._classCustomRules ? this._classCustomRules : [];
                        this._classCustomRules.push(rule)
                    }
                    _getDefaultOptions() {
                        return (0, _extend.extend)(super._getDefaultOptions(), {
                            width: void 0,
                            height: void 0,
                            rtlEnabled: (0, _config.default)().rtlEnabled,
                            elementAttr: {},
                            disabled: false,
                            integrationOptions: {}
                        }, this._useTemplates() ? _m_template_manager.default.TemplateManager.createDefaultOptions() : {})
                    }
                    ctor(element, options) {
                        this._customClass = null;
                        this._createElement(element);
                        (0, _public_component.attachInstanceToElement)(this._$element, this, this._dispose);
                        super.ctor(options);
                        const validationAlreadyPerformed = (0, _license_validation.peekValidationPerformed)();
                        _license_validation.default.validateLicense((0, _config.default)().licenseKey);
                        if (!validationAlreadyPerformed && (0, _license_validation.peekValidationPerformed)()) {
                            (0, _config.default)({
                                licenseKey: ""
                            })
                        }
                    }
                    _createElement(element) {
                        this._$element = (0, _renderer.default)(element)
                    }
                    _getSynchronizableOptionsForCreateComponent() {
                        return ["rtlEnabled", "disabled", "templatesRenderAsynchronously"]
                    }
                    _checkFunctionValueDeprecation(optionNames) {
                        if (!this.option("_ignoreFunctionValueDeprecation")) {
                            optionNames.forEach((optionName => {
                                if ((0, _type.isFunction)(this.option(optionName))) {
                                    _errors.default.log("W0017", optionName)
                                }
                            }))
                        }
                    }
                    _visibilityChanged(value) {}
                    _dimensionChanged() {}
                    _init() {
                        super._init();
                        this._checkFunctionValueDeprecation(["width", "height", "maxHeight", "maxWidth", "minHeight", "minWidth", "popupHeight", "popupWidth"]);
                        this._attachWindowResizeCallback();
                        this._initTemplateManager()
                    }
                    _setOptionsByDevice(instanceCustomRules) {
                        super._setOptionsByDevice([].concat(this.constructor._classCustomRules || [], instanceCustomRules || []))
                    }
                    _isInitialOptionValue(name) {
                        const isCustomOption = this.constructor._classCustomRules && Object.prototype.hasOwnProperty.call(this._convertRulesToOptions(this.constructor._classCustomRules), name);
                        return !isCustomOption && super._isInitialOptionValue(name)
                    }
                    _attachWindowResizeCallback() {
                        if (this._isDimensionChangeSupported()) {
                            const windowResizeCallBack = this._windowResizeCallBack = this._dimensionChanged.bind(this);
                            _resize_callbacks.default.add(windowResizeCallBack)
                        }
                    }
                    _isDimensionChangeSupported() {
                        return this._dimensionChanged !== DOMComponent.prototype._dimensionChanged
                    }
                    _renderComponent() {
                        (0, _shadow_dom.addShadowDomStyles)(this.$element());
                        this._initMarkup();
                        (0, _window.hasWindow)() && this._render()
                    }
                    _initMarkup() {
                        const {
                            rtlEnabled: rtlEnabled
                        } = this.option() || {};
                        this._renderElementAttributes();
                        this._toggleRTLDirection(rtlEnabled);
                        this._renderVisibilityChange();
                        this._renderDimensions()
                    }
                    _render() {
                        this._attachVisibilityChangeHandlers()
                    }
                    _renderElementAttributes() {
                        const {
                            elementAttr: elementAttr
                        } = this.option() || {};
                        const attributes = (0, _extend.extend)({}, elementAttr);
                        const classNames = attributes.class;
                        delete attributes.class;
                        this.$element().attr(attributes).removeClass(this._customClass).addClass(classNames);
                        this._customClass = classNames
                    }
                    _renderVisibilityChange() {
                        if (this._isDimensionChangeSupported()) {
                            this._attachDimensionChangeHandlers()
                        }
                        if (this._isVisibilityChangeSupported()) {
                            const $element = this.$element();
                            $element.addClass("dx-visibility-change-handler")
                        }
                    }
                    _renderDimensions() {
                        const $element = this.$element();
                        const element = $element.get(0);
                        const width = this._getOptionValue("width", element);
                        const height = this._getOptionValue("height", element);
                        if (this._isCssUpdateRequired(element, height, width)) {
                            $element.css({
                                width: null === width ? "" : width,
                                height: null === height ? "" : height
                            })
                        }
                    }
                    _isCssUpdateRequired(element, height, width) {
                        return !!((0, _type.isDefined)(width) || (0, _type.isDefined)(height) || element.style.width || element.style.height)
                    }
                    _attachDimensionChangeHandlers() {
                        const $el = this.$element();
                        const namespace = `${this.NAME}VisibilityChange`;
                        _short.resize.off($el, {
                            namespace: namespace
                        });
                        _short.resize.on($el, (() => this._dimensionChanged()), {
                            namespace: namespace
                        })
                    }
                    _attachVisibilityChangeHandlers() {
                        if (this._isVisibilityChangeSupported()) {
                            const $el = this.$element();
                            const namespace = `${this.NAME}VisibilityChange`;
                            this._isHidden = !this._isVisible();
                            _short.visibility.off($el, {
                                namespace: namespace
                            });
                            _short.visibility.on($el, (() => this._checkVisibilityChanged("shown")), (() => this._checkVisibilityChanged("hiding")), {
                                namespace: namespace
                            })
                        }
                    }
                    _isVisible() {
                        const $element = this.$element();
                        return $element.is(":visible")
                    }
                    _checkVisibilityChanged(action) {
                        const isVisible = this._isVisible();
                        if (isVisible) {
                            if ("hiding" === action && !this._isHidden) {
                                this._visibilityChanged(false);
                                this._isHidden = true
                            } else if ("shown" === action && this._isHidden) {
                                this._isHidden = false;
                                this._visibilityChanged(true)
                            }
                        }
                    }
                    _isVisibilityChangeSupported() {
                        return this._visibilityChanged !== DOMComponent.prototype._visibilityChanged && (0, _window.hasWindow)()
                    }
                    _clean() {}
                    _modelByElement(element) {
                        const {
                            modelByElement: modelByElement
                        } = this.option();
                        const $element = this.$element();
                        return modelByElement ? modelByElement($element) : void 0
                    }
                    _invalidate() {
                        if (this._isUpdateAllowed()) {
                            throw _errors.default.Error("E0007")
                        }
                        this._requireRefresh = true
                    }
                    _refresh() {
                        this._clean();
                        this._renderComponent()
                    }
                    _dispose() {
                        this._templateManager && this._templateManager.dispose();
                        super._dispose();
                        this._clean();
                        this._detachWindowResizeCallback()
                    }
                    _detachWindowResizeCallback() {
                        if (this._isDimensionChangeSupported()) {
                            _resize_callbacks.default.remove(this._windowResizeCallBack)
                        }
                    }
                    _toggleRTLDirection(rtl) {
                        const $element = this.$element();
                        $element.toggleClass("dx-rtl", rtl)
                    }
                    _createComponent(element, component, componentConfiguration) {
                        const configuration = componentConfiguration ?? {};
                        const synchronizableOptions = (0, _common.grep)(this._getSynchronizableOptionsForCreateComponent(), (value => !(value in configuration)));
                        const {
                            integrationOptions: integrationOptions
                        } = this.option();
                        let {
                            nestedComponentOptions: nestedComponentOptions
                        } = this.option();
                        nestedComponentOptions = nestedComponentOptions ?? _common.noop;
                        const nestedComponentConfig = (0, _extend.extend)({
                            integrationOptions: integrationOptions
                        }, nestedComponentOptions(this));
                        synchronizableOptions.forEach((optionName => nestedComponentConfig[optionName] = this.option(optionName)));
                        this._extendConfig(configuration, nestedComponentConfig);
                        let instance;
                        if ((0, _type.isString)(component)) {
                            const $element = (0, _renderer.default)(element)[component](configuration);
                            instance = $element[component]("instance")
                        } else if (element) {
                            instance = component.getInstance(element);
                            if (instance) {
                                instance.option(configuration)
                            } else {
                                instance = new component(element, configuration)
                            }
                        }
                        if (instance) {
                            const optionChangedHandler = _ref => {
                                let {
                                    name: name,
                                    value: value
                                } = _ref;
                                if (synchronizableOptions.includes(name)) {
                                    instance.option(name, value)
                                }
                            };
                            this.on("optionChanged", optionChangedHandler);
                            instance.on("disposing", (() => this.off("optionChanged", optionChangedHandler)))
                        }
                        return instance
                    }
                    _extendConfig(configuration, extendConfig) {
                        (0, _iterator.each)(extendConfig, ((key, value) => {
                            !Object.prototype.hasOwnProperty.call(configuration, key) && (configuration[key] = value)
                        }))
                    }
                    _defaultActionConfig() {
                        const $element = this.$element();
                        const context = this._modelByElement($element);
                        return (0, _extend.extend)(super._defaultActionConfig(), {
                            context: context
                        })
                    }
                    _defaultActionArgs() {
                        const $element = this.$element();
                        const model = this._modelByElement($element);
                        const element = this.element();
                        return (0, _extend.extend)(super._defaultActionArgs(), {
                            element: element,
                            model: model
                        })
                    }
                    _optionChanged(args) {
                        const {
                            name: name
                        } = args;
                        switch (name) {
                            case "width":
                            case "height":
                                this._renderDimensions();
                                break;
                            case "rtlEnabled":
                                this._invalidate();
                                break;
                            case "elementAttr":
                                this._renderElementAttributes();
                                break;
                            case "disabled":
                            case "integrationOptions":
                                break;
                            default:
                                super._optionChanged(args)
                        }
                    }
                    _removeAttributes(element) {
                        const attrs = element.attributes;
                        for (let i = attrs.length - 1; i >= 0; i--) {
                            const attr = attrs[i];
                            if (attr) {
                                const {
                                    name: name
                                } = attr;
                                if (!name.indexOf("aria-") || -1 !== name.indexOf("dx-") || "role" === name || "style" === name || "tabindex" === name) {
                                    element.removeAttribute(name)
                                }
                            }
                        }
                    }
                    _removeClasses(element) {
                        element.className = element.className.split(" ").filter((cssClass => 0 !== cssClass.lastIndexOf("dx-", 0))).join(" ")
                    }
                    _updateDOMComponent(renderRequired) {
                        if (renderRequired) {
                            this._renderComponent()
                        } else if (this._requireRefresh) {
                            this._requireRefresh = false;
                            this._refresh()
                        }
                    }
                    endUpdate() {
                        const renderRequired = this._isInitializingRequired();
                        super.endUpdate();
                        this._isUpdateAllowed() && this._updateDOMComponent(renderRequired)
                    }
                    $element() {
                        return this._$element
                    }
                    element() {
                        const $element = this.$element();
                        return (0, _element.getPublicElement)($element)
                    }
                    dispose() {
                        const element = this.$element().get(0);
                        (0, _element_data.cleanDataRecursive)(element, true);
                        element.textContent = "";
                        this._removeAttributes(element);
                        this._removeClasses(element)
                    }
                    resetOption(optionName) {
                        super.resetOption(optionName);
                        if ("width" === optionName || "height" === optionName) {
                            const initialOption = this.initialOption(optionName);
                            !(0, _type.isDefined)(initialOption) && this.$element().css(optionName, "")
                        }
                    }
                    _getAnonymousTemplateName() {
                        return
                    }
                    _initTemplateManager() {
                        if (this._templateManager || !this._useTemplates()) {
                            return
                        }
                        const {
                            integrationOptions: integrationOptions = {}
                        } = this.option();
                        const {
                            createTemplate: createTemplate
                        } = integrationOptions;
                        this._templateManager = new _m_template_manager.default.TemplateManager(createTemplate, this._getAnonymousTemplateName());
                        this._initTemplates();
                        return
                    }
                    _initTemplates() {
                        const {
                            templates: templates,
                            anonymousTemplateMeta: anonymousTemplateMeta
                        } = this._templateManager.extractTemplates(this.$element());
                        const anonymousTemplate = this.option(`integrationOptions.templates.${anonymousTemplateMeta.name}`);
                        templates.forEach((_ref2 => {
                            let {
                                name: name,
                                template: template
                            } = _ref2;
                            this._options.silent(`integrationOptions.templates.${name}`, template)
                        }));
                        if (anonymousTemplateMeta.name && !anonymousTemplate) {
                            this._options.silent(`integrationOptions.templates.${anonymousTemplateMeta.name}`, anonymousTemplateMeta.template);
                            this._options.silent("_hasAnonymousTemplateContent", true)
                        }
                    }
                    _getTemplateByOption(optionName) {
                        return this._getTemplate(this.option(optionName))
                    }
                    _getTemplate(templateSource) {
                        const templates = this.option("integrationOptions.templates");
                        const isAsyncTemplate = this.option("templatesRenderAsynchronously");
                        const skipTemplates = this.option("integrationOptions.skipTemplates");
                        return this._templateManager.getTemplate(templateSource, templates, {
                            isAsyncTemplate: isAsyncTemplate,
                            skipTemplates: skipTemplates
                        }, this)
                    }
                    _saveTemplate(name, template) {
                        this._setOptionWithoutOptionChange(`integrationOptions.templates.${name}`, this._templateManager._createTemplate(template))
                    }
                    _useTemplates() {
                        return true
                    }
                }
                exports.default = DOMComponent
            },
        89275:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/widget/widget.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                __webpack_require__( /*! ../../../events/click */ 73358);
                __webpack_require__( /*! ../../../events/core/emitter.feedback */ 34217);
                __webpack_require__( /*! ../../../events/hover */ 53952);
                var _action = _interopRequireDefault(__webpack_require__( /*! ../../../core/action */ 88412));
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../../core/devices */ 65951));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _version = __webpack_require__( /*! ../../../core/utils/version */ 20142);
                var _short = __webpack_require__( /*! ../../../events/short */ 67960);
                var _selectors = __webpack_require__( /*! ../../../ui/widget/selectors */ 35944);
                var _dom_component = _interopRequireDefault(__webpack_require__( /*! ./dom_component */ 22331));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function setAttribute(name, value, target) {
                    name = "role" === name || "id" === name ? name : `aria-${name}`;
                    value = (0, _type.isDefined)(value) ? value.toString() : null;
                    target.attr(name, value)
                }
                class Widget extends _dom_component.default {
                    constructor() {
                        super(...arguments);
                        this._feedbackHideTimeout = 400;
                        this._feedbackShowTimeout = 30
                    }
                    static getOptionsFromContainer(_ref) {
                        let {
                            name: name,
                            fullName: fullName,
                            value: value
                        } = _ref;
                        let options = {};
                        if (name === fullName) {
                            options = value
                        } else {
                            const option = fullName.split(".").pop();
                            options[option] = value
                        }
                        return options
                    }
                    _supportedKeys() {
                        return {}
                    }
                    _getDefaultOptions() {
                        return (0, _extend.extend)(super._getDefaultOptions(), {
                            hoveredElement: null,
                            isActive: false,
                            disabled: false,
                            visible: true,
                            hint: void 0,
                            activeStateEnabled: false,
                            onContentReady: null,
                            hoverStateEnabled: false,
                            focusStateEnabled: false,
                            tabIndex: 0,
                            accessKey: void 0,
                            onFocusIn: null,
                            onFocusOut: null,
                            onKeyboardHandled: null,
                            ignoreParentReadOnly: false,
                            useResizeObserver: true
                        })
                    }
                    _defaultOptionsRules() {
                        return super._defaultOptionsRules().concat([{
                            device() {
                                const device = _devices.default.real();
                                const {
                                    platform: platform
                                } = device;
                                const {
                                    version: version
                                } = device;
                                return "ios" === platform && (0, _version.compare)(version, "13.3") <= 0
                            },
                            options: {
                                useResizeObserver: false
                            }
                        }])
                    }
                    _init() {
                        super._init();
                        this._initContentReadyAction()
                    }
                    _innerWidgetOptionChanged(innerWidget, args) {
                        const options = Widget.getOptionsFromContainer(args);
                        innerWidget && innerWidget.option(options);
                        this._options.cache(args.name, options)
                    }
                    _bindInnerWidgetOptions(innerWidget, optionsContainer) {
                        const syncOptions = () => this._options.silent(optionsContainer, (0, _extend.extend)({}, innerWidget.option()));
                        syncOptions();
                        innerWidget.on("optionChanged", syncOptions)
                    }
                    _getAriaTarget() {
                        return this._focusTarget()
                    }
                    _initContentReadyAction() {
                        this._contentReadyAction = this._createActionByOption("onContentReady", {
                            excludeValidators: ["disabled", "readOnly"]
                        })
                    }
                    _initMarkup() {
                        const {
                            disabled: disabled,
                            visible: visible
                        } = this.option();
                        this.$element().addClass("dx-widget");
                        this._toggleDisabledState(disabled);
                        this._toggleVisibility(visible);
                        this._renderHint();
                        this._isFocusable() && this._renderFocusTarget();
                        super._initMarkup()
                    }
                    _render() {
                        super._render();
                        this._renderContent();
                        this._renderFocusState();
                        this._attachFeedbackEvents();
                        this._attachHoverEvents();
                        this._toggleIndependentState()
                    }
                    _renderHint() {
                        const {
                            hint: hint
                        } = this.option();
                        this.$element().attr("title", hint || null)
                    }
                    _renderContent() {
                        (0, _common.deferRender)((() => !this._disposed ? this._renderContentImpl() : void 0)).done((() => !this._disposed ? this._fireContentReadyAction() : void 0))
                    }
                    _renderContentImpl() {}
                    _fireContentReadyAction() {
                        return (0, _common.deferRender)((() => {
                            var _this$_contentReadyAc;
                            return null === (_this$_contentReadyAc = this._contentReadyAction) || void 0 === _this$_contentReadyAc ? void 0 : _this$_contentReadyAc.call(this)
                        }))
                    }
                    _dispose() {
                        this._contentReadyAction = null;
                        this._detachKeyboardEvents();
                        super._dispose()
                    }
                    _resetActiveState() {
                        this._toggleActiveState(this._eventBindingTarget(), false)
                    }
                    _clean() {
                        this._cleanFocusState();
                        this._resetActiveState();
                        super._clean();
                        this.$element().empty()
                    }
                    _toggleVisibility(visible) {
                        this.$element().toggleClass("dx-state-invisible", !visible)
                    }
                    _renderFocusState() {
                        this._attachKeyboardEvents();
                        if (this._isFocusable()) {
                            this._renderFocusTarget();
                            this._attachFocusEvents();
                            this._renderAccessKey()
                        }
                    }
                    _renderAccessKey() {
                        const $el = this._focusTarget();
                        const {
                            accessKey: accessKey
                        } = this.option();
                        $el.attr("accesskey", accessKey)
                    }
                    _isFocusable() {
                        const {
                            focusStateEnabled: focusStateEnabled,
                            disabled: disabled
                        } = this.option();
                        return focusStateEnabled && !disabled
                    }
                    _eventBindingTarget() {
                        return this.$element()
                    }
                    _focusTarget() {
                        return this._getActiveElement()
                    }
                    _isFocusTarget(element) {
                        const focusTargets = (0, _renderer.default)(this._focusTarget()).toArray();
                        return focusTargets.includes(element)
                    }
                    _findActiveTarget($element) {
                        return $element.find(this._activeStateUnit).not(".dx-state-disabled")
                    }
                    _getActiveElement() {
                        const activeElement = this._eventBindingTarget();
                        if (this._activeStateUnit) {
                            return this._findActiveTarget(activeElement)
                        }
                        return activeElement
                    }
                    _renderFocusTarget() {
                        const {
                            tabIndex: tabIndex
                        } = this.option();
                        this._focusTarget().attr("tabIndex", tabIndex)
                    }
                    _keyboardEventBindingTarget() {
                        return this._eventBindingTarget()
                    }
                    _refreshFocusEvent() {
                        this._detachFocusEvents();
                        this._attachFocusEvents()
                    }
                    _focusEventTarget() {
                        return this._focusTarget()
                    }
                    _focusInHandler(event) {
                        if (!event.isDefaultPrevented()) {
                            this._createActionByOption("onFocusIn", {
                                beforeExecute: () => this._updateFocusState(event, true),
                                excludeValidators: ["readOnly"]
                            })({
                                event: event
                            })
                        }
                    }
                    _focusOutHandler(event) {
                        if (!event.isDefaultPrevented()) {
                            this._createActionByOption("onFocusOut", {
                                beforeExecute: () => this._updateFocusState(event, false),
                                excludeValidators: ["readOnly", "disabled"]
                            })({
                                event: event
                            })
                        }
                    }
                    _updateFocusState(_ref2, isFocused) {
                        let {
                            target: target
                        } = _ref2;
                        if (this._isFocusTarget(target)) {
                            this._toggleFocusClass(isFocused, (0, _renderer.default)(target))
                        }
                    }
                    _toggleFocusClass(isFocused, $element) {
                        const $focusTarget = $element && $element.length ? $element : this._focusTarget();
                        $focusTarget.toggleClass("dx-state-focused", isFocused)
                    }
                    _hasFocusClass(element) {
                        const $focusTarget = (0, _renderer.default)(element ?? this._focusTarget());
                        return $focusTarget.hasClass("dx-state-focused")
                    }
                    _isFocused() {
                        return this._hasFocusClass()
                    }
                    _getKeyboardListeners() {
                        return []
                    }
                    _attachKeyboardEvents() {
                        this._detachKeyboardEvents();
                        const {
                            focusStateEnabled: focusStateEnabled,
                            onKeyboardHandled: onKeyboardHandled
                        } = this.option();
                        const hasChildListeners = this._getKeyboardListeners().length;
                        const hasKeyboardEventHandler = !!onKeyboardHandled;
                        const shouldAttach = focusStateEnabled || hasChildListeners || hasKeyboardEventHandler;
                        if (shouldAttach) {
                            this._keyboardListenerId = _short.keyboard.on(this._keyboardEventBindingTarget(), this._focusTarget(), (opts => this._keyboardHandler(opts)))
                        }
                    }
                    _keyboardHandler(options, onlyChildProcessing) {
                        if (!onlyChildProcessing) {
                            const {
                                originalEvent: originalEvent,
                                keyName: keyName,
                                which: which
                            } = options;
                            const keys = this._supportedKeys(originalEvent);
                            const func = keys[keyName] || keys[which];
                            if (void 0 !== func) {
                                const handler = func.bind(this);
                                const result = handler(originalEvent, options);
                                if (!result) {
                                    return false
                                }
                            }
                        }
                        const keyboardListeners = this._getKeyboardListeners();
                        const {
                            onKeyboardHandled: onKeyboardHandled
                        } = this.option();
                        keyboardListeners.forEach((listener => listener && listener._keyboardHandler(options)));
                        onKeyboardHandled && onKeyboardHandled(options);
                        return true
                    }
                    _refreshFocusState() {
                        this._cleanFocusState();
                        this._renderFocusState()
                    }
                    _cleanFocusState() {
                        const $element = this._focusTarget();
                        $element.removeAttr("tabIndex");
                        this._toggleFocusClass(false);
                        this._detachFocusEvents();
                        this._detachKeyboardEvents()
                    }
                    _detachKeyboardEvents() {
                        _short.keyboard.off(this._keyboardListenerId);
                        this._keyboardListenerId = null
                    }
                    _attachHoverEvents() {
                        const {
                            hoverStateEnabled: hoverStateEnabled
                        } = this.option();
                        const selector = this._activeStateUnit;
                        const $el = this._eventBindingTarget();
                        _short.hover.off($el, {
                            selector: selector,
                            namespace: "UIFeedback"
                        });
                        if (hoverStateEnabled) {
                            _short.hover.on($el, new _action.default((_ref3 => {
                                let {
                                    event: event,
                                    element: element
                                } = _ref3;
                                this._hoverStartHandler(event);
                                this.option("hoveredElement", (0, _renderer.default)(element))
                            }), {
                                excludeValidators: ["readOnly"]
                            }), (event => {
                                this.option("hoveredElement", null);
                                this._hoverEndHandler(event)
                            }), {
                                selector: selector,
                                namespace: "UIFeedback"
                            })
                        }
                    }
                    _attachFeedbackEvents() {
                        const {
                            activeStateEnabled: activeStateEnabled
                        } = this.option();
                        const selector = this._activeStateUnit;
                        const $el = this._eventBindingTarget();
                        _short.active.off($el, {
                            namespace: "UIFeedback",
                            selector: selector
                        });
                        if (activeStateEnabled) {
                            _short.active.on($el, new _action.default((_ref4 => {
                                let {
                                    event: event,
                                    element: element
                                } = _ref4;
                                return this._toggleActiveState((0, _renderer.default)(element), true, event)
                            })), new _action.default((_ref5 => {
                                let {
                                    event: event,
                                    element: element
                                } = _ref5;
                                return this._toggleActiveState((0, _renderer.default)(element), false, event)
                            }), {
                                excludeValidators: ["disabled", "readOnly"]
                            }), {
                                showTimeout: this._feedbackShowTimeout,
                                hideTimeout: this._feedbackHideTimeout,
                                selector: selector,
                                namespace: "UIFeedback"
                            })
                        }
                    }
                    _detachFocusEvents() {
                        const $el = this._focusEventTarget();
                        _short.focus.off($el, {
                            namespace: `${this.NAME}Focus`
                        })
                    }
                    _attachFocusEvents() {
                        const $el = this._focusEventTarget();
                        _short.focus.on($el, (e => this._focusInHandler(e)), (e => this._focusOutHandler(e)), {
                            namespace: `${this.NAME}Focus`,
                            isFocusable: (index, el) => (0, _renderer.default)(el).is(_selectors.focusable)
                        })
                    }
                    _hoverStartHandler(event) {}
                    _hoverEndHandler(event) {}
                    _toggleActiveState($element, value, event) {
                        this.option("isActive", value);
                        $element.toggleClass("dx-state-active", value)
                    }
                    _updatedHover() {
                        const hoveredElement = this._options.silent("hoveredElement");
                        this._hover(hoveredElement, hoveredElement)
                    }
                    _findHoverTarget($el) {
                        return $el && $el.closest(this._activeStateUnit || this._eventBindingTarget())
                    }
                    _hover($el, $previous) {
                        const {
                            hoverStateEnabled: hoverStateEnabled,
                            disabled: disabled,
                            isActive: isActive
                        } = this.option();
                        $previous = this._findHoverTarget($previous);
                        $previous && $previous.toggleClass("dx-state-hover", false);
                        if ($el && hoverStateEnabled && !disabled && !isActive) {
                            const newHoveredElement = this._findHoverTarget($el);
                            newHoveredElement && newHoveredElement.toggleClass("dx-state-hover", true)
                        }
                    }
                    _toggleDisabledState(value) {
                        this.$element().toggleClass("dx-state-disabled", Boolean(value));
                        this.setAria("disabled", value || void 0)
                    }
                    _toggleIndependentState() {
                        const {
                            ignoreParentReadOnly: ignoreParentReadOnly
                        } = this.option();
                        this.$element().toggleClass("dx-state-independent", ignoreParentReadOnly)
                    }
                    _setWidgetOption(widgetName, args) {
                        if (!this[widgetName]) {
                            return
                        }
                        if ((0, _type.isPlainObject)(args[0])) {
                            (0, _iterator.each)(args[0], ((option, value) => this._setWidgetOption(widgetName, [option, value])));
                            return
                        }
                        const optionName = args[0];
                        let value = args[1];
                        if (1 === args.length) {
                            value = this.option(optionName)
                        }
                        const widgetOptionMap = this[`${widgetName}OptionMap`];
                        this[widgetName].option(widgetOptionMap ? widgetOptionMap(optionName) : optionName, value)
                    }
                    _optionChanged(args) {
                        const {
                            name: name,
                            value: value,
                            previousValue: previousValue
                        } = args;
                        switch (name) {
                            case "disabled":
                                this._toggleDisabledState(value);
                                this._updatedHover();
                                this._refreshFocusState();
                                break;
                            case "hint":
                                this._renderHint();
                                break;
                            case "ignoreParentReadOnly":
                                this._toggleIndependentState();
                                break;
                            case "activeStateEnabled":
                                this._attachFeedbackEvents();
                                break;
                            case "hoverStateEnabled":
                                this._attachHoverEvents();
                                this._updatedHover();
                                break;
                            case "tabIndex":
                            case "focusStateEnabled":
                                this._refreshFocusState();
                                break;
                            case "onFocusIn":
                            case "onFocusOut":
                            case "useResizeObserver":
                                break;
                            case "accessKey":
                                this._renderAccessKey();
                                break;
                            case "hoveredElement":
                                this._hover(value, previousValue);
                                break;
                            case "isActive":
                                this._updatedHover();
                                break;
                            case "visible":
                                this._toggleVisibility(value);
                                if (this._isVisibilityChangeSupported()) {
                                    this._checkVisibilityChanged(value ? "shown" : "hiding")
                                }
                                break;
                            case "onKeyboardHandled":
                                this._attachKeyboardEvents();
                                break;
                            case "onContentReady":
                                this._initContentReadyAction();
                                break;
                            default:
                                super._optionChanged(args)
                        }
                    }
                    _isVisible() {
                        const {
                            visible: visible
                        } = this.option();
                        return super._isVisible() && visible
                    }
                    beginUpdate() {
                        this._ready(false);
                        super.beginUpdate()
                    }
                    endUpdate() {
                        super.endUpdate();
                        if (this._initialized) {
                            this._ready(true)
                        }
                    }
                    _ready(value) {
                        if (0 === arguments.length) {
                            return !!this._isReady
                        }
                        this._isReady = !!value;
                        return this._isReady
                    }
                    setAria() {
                        if (!(0, _type.isPlainObject)(arguments.length <= 0 ? void 0 : arguments[0])) {
                            setAttribute(arguments.length <= 0 ? void 0 : arguments[0], arguments.length <= 1 ? void 0 : arguments[1], (arguments.length <= 2 ? void 0 : arguments[2]) || this._getAriaTarget())
                        } else {
                            const target = (arguments.length <= 1 ? void 0 : arguments[1]) || this._getAriaTarget();
                            (0, _iterator.each)(arguments.length <= 0 ? void 0 : arguments[0], ((name, value) => setAttribute(name, value, target)))
                        }
                    }
                    isReady() {
                        return this._ready()
                    }
                    repaint() {
                        this._refresh()
                    }
                    focus() {
                        _short.focus.trigger(this._focusTarget())
                    }
                    registerKeyHandler(key, handler) {
                        const currentKeys = this._supportedKeys();
                        this._supportedKeys = () => (0, _extend.extend)(currentKeys, {
                            [key]: handler
                        })
                    }
                }
                exports.default = Widget
            },
        79562:
            /*!******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/data/data_source/m_data_source.js ***!
              \******************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.DataSource = void 0;
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../../core/class */ 55620));
                var _events_strategy = __webpack_require__( /*! ../../../core/events_strategy */ 2607);
                var _deferred = __webpack_require__( /*! ../../../core/utils/deferred */ 87739);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 21274);
                var _queue = __webpack_require__( /*! ../../../core/utils/queue */ 65221);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _array_utils = __webpack_require__( /*! ../../../data/array_utils */ 58756);
                var _custom_store = _interopRequireDefault(__webpack_require__( /*! ../../../data/custom_store */ 37754));
                var _operation_manager = _interopRequireDefault(__webpack_require__( /*! ../../../data/data_source/operation_manager */ 17209));
                var _utils = __webpack_require__( /*! ../../../data/data_source/utils */ 15125);
                var _errors = __webpack_require__( /*! ../../../data/errors */ 74760);
                var _utils2 = __webpack_require__( /*! ../../../data/utils */ 99354);
                var _m_common = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/m_common */ 39315));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                exports.DataSource = _class.default.inherit({
                    ctor(options) {
                        options = (0, _utils.normalizeDataSourceOptions)(options);
                        this._eventsStrategy = new _events_strategy.EventsStrategy(this, {
                            syncStrategy: true
                        });
                        this._store = options.store;
                        this._changedTime = 0;
                        const needThrottling = 0 !== options.pushAggregationTimeout;
                        if (needThrottling) {
                            const throttlingTimeout = void 0 === options.pushAggregationTimeout ? () => 5 * this._changedTime : options.pushAggregationTimeout;
                            let pushDeferred;
                            let lastPushWaiters;
                            const throttlingPushHandler = (0, _utils2.throttleChanges)((changes => {
                                pushDeferred.resolve();
                                const storePushPending = (0, _deferred.when)(...lastPushWaiters);
                                storePushPending.done((() => this._onPush(changes)));
                                lastPushWaiters = void 0;
                                pushDeferred = void 0
                            }), throttlingTimeout);
                            this._onPushHandler = args => {
                                this._aggregationTimeoutId = throttlingPushHandler(args.changes);
                                if (!pushDeferred) {
                                    pushDeferred = new _deferred.Deferred
                                }
                                lastPushWaiters = args.waitFor;
                                args.waitFor.push(pushDeferred.promise())
                            };
                            this._store.on("beforePushAggregation", this._onPushHandler)
                        } else {
                            this._onPushHandler = changes => this._onPush(changes);
                            this._store.on("push", this._onPushHandler)
                        }
                        this._storeLoadOptions = this._extractLoadOptions(options);
                        this._mapFunc = options.map;
                        this._postProcessFunc = options.postProcess;
                        this._pageIndex = void 0 !== options.pageIndex ? options.pageIndex : 0;
                        this._pageSize = void 0 !== options.pageSize ? options.pageSize : 20;
                        this._loadingCount = 0;
                        this._loadQueue = this._createLoadQueue();
                        this._searchValue = "searchValue" in options ? options.searchValue : null;
                        this._searchOperation = options.searchOperation || "contains";
                        this._searchExpr = options.searchExpr;
                        this._paginate = options.paginate;
                        this._reshapeOnPush = options.reshapeOnPush ?? false;
                        (0, _iterator.each)(["onChanged", "onLoadError", "onLoadingChanged", "onCustomizeLoadResult", "onCustomizeStoreLoadOptions"], ((_, optionName) => {
                            if (optionName in options) {
                                this.on(optionName.substr(2, 1).toLowerCase() + optionName.substr(3), options[optionName])
                            }
                        }));
                        this._operationManager = new _operation_manager.default;
                        this._init()
                    },
                    _init() {
                        this._items = [];
                        this._userData = {};
                        this._totalCount = -1;
                        this._isLoaded = false;
                        if (!(0, _type.isDefined)(this._paginate)) {
                            this._paginate = !this.group()
                        }
                        this._isLastPage = !this._paginate
                    },
                    dispose() {
                        var _this$_delayedLoadTas;
                        this._store.off("beforePushAggregation", this._onPushHandler);
                        this._store.off("push", this._onPushHandler);
                        this._eventsStrategy.dispose();
                        clearTimeout(this._aggregationTimeoutId);
                        null === (_this$_delayedLoadTas = this._delayedLoadTask) || void 0 === _this$_delayedLoadTas || _this$_delayedLoadTas.abort();
                        this._operationManager.cancelAll();
                        delete this._store;
                        delete this._items;
                        delete this._delayedLoadTask;
                        this._disposed = true
                    },
                    _extractLoadOptions(options) {
                        const result = {};
                        let names = ["sort", "filter", "langParams", "select", "group", "requireTotalCount"];
                        const customNames = this._store._customLoadOptions();
                        if (customNames) {
                            names = names.concat(customNames)
                        }(0, _iterator.each)(names, (function() {
                            result[this] = options[this]
                        }));
                        return result
                    },
                    loadOptions() {
                        return this._storeLoadOptions
                    },
                    items() {
                        return this._items
                    },
                    pageIndex(newIndex) {
                        if (!(0, _type.isNumeric)(newIndex)) {
                            return this._pageIndex
                        }
                        this._pageIndex = newIndex;
                        this._isLastPage = !this._paginate
                    },
                    paginate(value) {
                        if (!(0, _type.isBoolean)(value)) {
                            return this._paginate
                        }
                        if (this._paginate !== value) {
                            this._paginate = value;
                            this.pageIndex(0)
                        }
                    },
                    pageSize(value) {
                        if (!(0, _type.isNumeric)(value)) {
                            return this._pageSize
                        }
                        this._pageSize = value
                    },
                    isLastPage() {
                        return this._isLastPage
                    },
                    generateStoreLoadOptionAccessor(optionName) {
                        return args => {
                            const normalizedArgs = (0, _utils.normalizeStoreLoadOptionAccessorArguments)(args);
                            if (void 0 === normalizedArgs) {
                                return this._storeLoadOptions[optionName]
                            }
                            this._storeLoadOptions[optionName] = normalizedArgs
                        }
                    },
                    sort() {
                        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                            args[_key] = arguments[_key]
                        }
                        return this.generateStoreLoadOptionAccessor("sort")(args)
                    },
                    filter() {
                        const newFilter = (0, _utils.normalizeStoreLoadOptionAccessorArguments)(arguments);
                        if (void 0 === newFilter) {
                            return this._storeLoadOptions.filter
                        }
                        this._storeLoadOptions.filter = newFilter;
                        this.pageIndex(0)
                    },
                    group() {
                        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                            args[_key2] = arguments[_key2]
                        }
                        return this.generateStoreLoadOptionAccessor("group")(args)
                    },
                    select() {
                        for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
                            args[_key3] = arguments[_key3]
                        }
                        return this.generateStoreLoadOptionAccessor("select")(args)
                    },
                    requireTotalCount(value) {
                        if (!(0, _type.isBoolean)(value)) {
                            return this._storeLoadOptions.requireTotalCount
                        }
                        this._storeLoadOptions.requireTotalCount = value
                    },
                    searchValue(value) {
                        if (arguments.length < 1) {
                            return this._searchValue
                        }
                        this._searchValue = value;
                        this.pageIndex(0)
                    },
                    searchOperation(op) {
                        if (!(0, _type.isString)(op)) {
                            return this._searchOperation
                        }
                        this._searchOperation = op;
                        this.pageIndex(0)
                    },
                    searchExpr(expr) {
                        const argc = arguments.length;
                        if (0 === argc) {
                            return this._searchExpr
                        }
                        if (argc > 1) {
                            expr = [].slice.call(arguments)
                        }
                        this._searchExpr = expr;
                        this.pageIndex(0)
                    },
                    store() {
                        return this._store
                    },
                    key() {
                        var _this$_store;
                        return null === (_this$_store = this._store) || void 0 === _this$_store ? void 0 : _this$_store.key()
                    },
                    totalCount() {
                        return this._totalCount
                    },
                    isLoaded() {
                        return this._isLoaded
                    },
                    isLoading() {
                        return this._loadingCount > 0
                    },
                    beginLoading() {
                        this._changeLoadingCount(1)
                    },
                    endLoading() {
                        this._changeLoadingCount(-1)
                    },
                    _createLoadQueue: () => (0, _queue.create)(),
                    _changeLoadingCount(increment) {
                        const oldLoading = this.isLoading();
                        this._loadingCount += increment;
                        const newLoading = this.isLoading();
                        if (oldLoading ^ newLoading) {
                            this._eventsStrategy.fireEvent("loadingChanged", [newLoading])
                        }
                    },
                    _scheduleLoadCallbacks(deferred) {
                        this.beginLoading();
                        deferred.always((() => {
                            this.endLoading()
                        }))
                    },
                    _scheduleFailCallbacks(deferred) {
                        var _this = this;
                        deferred.fail((function() {
                            for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
                                args[_key4] = arguments[_key4]
                            }
                            if (args[0] === _utils.CANCELED_TOKEN) {
                                return
                            }
                            _this._eventsStrategy.fireEvent("loadError", args)
                        }))
                    },
                    _fireChanged(args) {
                        const date = new Date;
                        this._eventsStrategy.fireEvent("changed", args);
                        this._changedTime = new Date - date
                    },
                    _scheduleChangedCallbacks(deferred) {
                        deferred.done((() => this._fireChanged()))
                    },
                    loadSingle(propName, propValue) {
                        const d = new _deferred.Deferred;
                        const key = this.key();
                        const store = this._store;
                        const options = this._createStoreLoadOptions();
                        this._scheduleFailCallbacks(d);
                        if (arguments.length < 2) {
                            propValue = propName;
                            propName = key
                        }
                        delete options.skip;
                        delete options.group;
                        delete options.refresh;
                        delete options.pageIndex;
                        delete options.searchString;
                        (() => {
                            if (propName === key || store instanceof _custom_store.default && !store._byKeyViaLoad()) {
                                return store.byKey(propValue, options)
                            }
                            options.take = 1;
                            options.filter = options.filter ? [options.filter, [propName, propValue]] : [propName, propValue];
                            return store.load(options)
                        })().fail(d.reject).done((data => {
                            const isEmptyArray = Array.isArray(data) && !data.length;
                            if (!(0, _type.isDefined)(data) || isEmptyArray) {
                                d.reject(new _errors.errors.Error("E4009"))
                            } else {
                                if (!Array.isArray(data)) {
                                    data = [data]
                                }
                                d.resolve(this._applyMapFunction(data)[0])
                            }
                        }));
                        return d.promise()
                    },
                    load() {
                        const d = new _deferred.Deferred;
                        const loadTask = () => {
                            if (this._disposed) {
                                return
                            }
                            if (!(0, _utils.isPending)(d)) {
                                return
                            }
                            return this._loadFromStore(loadOperation, d)
                        };
                        this._scheduleLoadCallbacks(d);
                        this._scheduleFailCallbacks(d);
                        this._scheduleChangedCallbacks(d);
                        const loadOperation = this._createLoadOperation(d);
                        this._eventsStrategy.fireEvent("customizeStoreLoadOptions", [loadOperation]);
                        this._loadQueue.add((() => {
                            if ("number" === typeof loadOperation.delay) {
                                this._delayedLoadTask = _m_common.default.executeAsync(loadTask, loadOperation.delay)
                            } else {
                                loadTask()
                            }
                            return d.promise()
                        }));
                        return d.promise({
                            operationId: loadOperation.operationId
                        })
                    },
                    _onPush(changes) {
                        if (this._reshapeOnPush) {
                            this.load()
                        } else {
                            const changingArgs = {
                                changes: changes
                            };
                            this._eventsStrategy.fireEvent("changing", [changingArgs]);
                            const group = this.group();
                            const items = this.items();
                            let groupLevel = 0;
                            let dataSourceChanges = this.paginate() || group ? changes.filter((item => "update" === item.type)) : changes;
                            if (group) {
                                groupLevel = Array.isArray(group) ? group.length : 1
                            }
                            if (this._mapFunc) {
                                dataSourceChanges.forEach((item => {
                                    if ("insert" === item.type) {
                                        item.data = this._mapFunc(item.data)
                                    }
                                }))
                            }
                            if (changingArgs.postProcessChanges) {
                                dataSourceChanges = changingArgs.postProcessChanges(dataSourceChanges)
                            }(0, _array_utils.applyBatch)({
                                keyInfo: this.store(),
                                data: items,
                                changes: dataSourceChanges,
                                groupCount: groupLevel,
                                useInsertIndex: true
                            });
                            this._fireChanged([{
                                changes: changes
                            }])
                        }
                    },
                    _createLoadOperation(deferred) {
                        const operationId = this._operationManager.add(deferred);
                        const storeLoadOptions = this._createStoreLoadOptions();
                        if (this._store && !(0, _type.isEmptyObject)(null === storeLoadOptions || void 0 === storeLoadOptions ? void 0 : storeLoadOptions.langParams)) {
                            this._store._langParams = _extends({}, this._store._langParams, storeLoadOptions.langParams)
                        }
                        deferred.always((() => this._operationManager.remove(operationId)));
                        return {
                            operationId: operationId,
                            storeLoadOptions: storeLoadOptions
                        }
                    },
                    reload() {
                        const store = this.store();
                        store._clearCache();
                        this._init();
                        return this.load()
                    },
                    cancel(operationId) {
                        return this._operationManager.cancel(operationId)
                    },
                    cancelAll() {
                        return this._operationManager.cancelAll()
                    },
                    _addSearchOptions(storeLoadOptions) {
                        if (this._disposed) {
                            return
                        }
                        if (this.store()._useDefaultSearch) {
                            this._addSearchFilter(storeLoadOptions)
                        } else {
                            storeLoadOptions.searchOperation = this._searchOperation;
                            storeLoadOptions.searchValue = this._searchValue;
                            storeLoadOptions.searchExpr = this._searchExpr
                        }
                    },
                    _createStoreLoadOptions() {
                        const result = (0, _extend.extend)({}, this._storeLoadOptions);
                        this._addSearchOptions(result);
                        if (this._paginate) {
                            if (this._pageSize) {
                                result.skip = this._pageIndex * this._pageSize;
                                result.take = this._pageSize
                            }
                        }
                        result.userData = this._userData;
                        return result
                    },
                    _addSearchFilter(storeLoadOptions) {
                        const value = this._searchValue;
                        const op = this._searchOperation;
                        let selector = this._searchExpr;
                        const searchFilter = [];
                        if (!value) {
                            return
                        }
                        if (!selector) {
                            selector = "this"
                        }
                        if (!Array.isArray(selector)) {
                            selector = [selector]
                        }(0, _iterator.each)(selector, ((i, item) => {
                            if (searchFilter.length) {
                                searchFilter.push("or")
                            }
                            searchFilter.push([item, op, value])
                        }));
                        if (storeLoadOptions.filter) {
                            storeLoadOptions.filter = [searchFilter, storeLoadOptions.filter]
                        } else {
                            storeLoadOptions.filter = searchFilter
                        }
                    },
                    _loadFromStore(loadOptions, pendingDeferred) {
                        const handleSuccess = (data, extra) => {
                            if (this._disposed) {
                                return
                            }
                            if (!(0, _utils.isPending)(pendingDeferred)) {
                                return
                            }
                            const loadResult = (0, _extend.extend)((0, _utils.normalizeLoadResult)(data, extra), loadOptions);
                            this._eventsStrategy.fireEvent("customizeLoadResult", [loadResult]);
                            (0, _deferred.when)(loadResult.data).done((data => {
                                loadResult.data = data;
                                this._processStoreLoadResult(loadResult, pendingDeferred)
                            })).fail(pendingDeferred.reject)
                        };
                        if (loadOptions.data) {
                            return (new _deferred.Deferred).resolve(loadOptions.data).done(handleSuccess)
                        }
                        return this.store().load(loadOptions.storeLoadOptions).done(handleSuccess).fail(pendingDeferred.reject)
                    },
                    _processStoreLoadResult(loadResult, pendingDeferred) {
                        let {
                            data: data
                        } = loadResult;
                        let {
                            extra: extra
                        } = loadResult;
                        const {
                            storeLoadOptions: storeLoadOptions
                        } = loadResult;
                        const resolvePendingDeferred = () => {
                            this._isLoaded = true;
                            this._totalCount = isFinite(extra.totalCount) ? extra.totalCount : -1;
                            return pendingDeferred.resolve(data, extra)
                        };
                        const proceedLoadingTotalCount = () => {
                            this.store().totalCount(storeLoadOptions).done((count => {
                                extra.totalCount = count;
                                resolvePendingDeferred()
                            })).fail(pendingDeferred.reject)
                        };
                        if (this._disposed) {
                            return
                        }
                        data = this._applyPostProcessFunction(this._applyMapFunction(data));
                        if (!(0, _type.isObject)(extra)) {
                            extra = {}
                        }
                        this._items = data;
                        if (!data.length || !this._paginate || this._pageSize && data.length < this._pageSize) {
                            this._isLastPage = true
                        }
                        if (storeLoadOptions.requireTotalCount && !isFinite(extra.totalCount)) {
                            proceedLoadingTotalCount()
                        } else {
                            resolvePendingDeferred()
                        }
                    },
                    _applyMapFunction(data) {
                        if (this._mapFunc) {
                            return (0, _utils.mapDataRespectingGrouping)(data, this._mapFunc, this.group())
                        }
                        return data
                    },
                    _applyPostProcessFunction(data) {
                        if (this._postProcessFunc) {
                            return this._postProcessFunc(data)
                        }
                        return data
                    },
                    on(eventName, eventHandler) {
                        this._eventsStrategy.on(eventName, eventHandler);
                        return this
                    },
                    off(eventName, eventHandler) {
                        this._eventsStrategy.off(eventName, eventHandler);
                        return this
                    }
                })
            },
        9427:
            /*!************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/data/data_source/m_operation_manager.js ***!
              \************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _utils = __webpack_require__( /*! ../../../data/data_source/utils */ 15125);
                exports.default = class {
                    constructor() {
                        this._counter = -1;
                        this._deferreds = {}
                    }
                    add(deferred) {
                        this._counter++;
                        this._deferreds[this._counter] = deferred;
                        return this._counter
                    }
                    remove(operationId) {
                        return delete this._deferreds[operationId]
                    }
                    cancel(operationId) {
                        if (operationId in this._deferreds) {
                            this._deferreds[operationId].reject(_utils.CANCELED_TOKEN);
                            return true
                        }
                        return false
                    }
                    cancelAll() {
                        while (this._counter > -1) {
                            this.cancel(this._counter);
                            this._counter--
                        }
                    }
                }
            },
        23923:
            /*!************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/data/data_source/m_utils.js ***!
              \************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.normalizeStoreLoadOptionAccessorArguments = exports.normalizeLoadResult = exports.normalizeDataSourceOptions = exports.mapDataRespectingGrouping = exports.isPending = exports.CANCELED_TOKEN = void 0;
                var _ajax = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/ajax */ 78670));
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _abstract_store = _interopRequireDefault(__webpack_require__( /*! ../../../data/abstract_store */ 77735));
                var _array_store = _interopRequireDefault(__webpack_require__( /*! ../../../data/array_store */ 67664));
                var _custom_store = _interopRequireDefault(__webpack_require__( /*! ../../../data/custom_store */ 37754));
                var _utils = __webpack_require__( /*! ../../../data/utils */ 99354);
                const _excluded = ["items"];

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                exports.CANCELED_TOKEN = "canceled";
                exports.isPending = deferred => "pending" === deferred.state();
                exports.normalizeStoreLoadOptionAccessorArguments = originalArguments => {
                    switch (originalArguments.length) {
                        case 0:
                            return;
                        case 1:
                            return originalArguments[0]
                    }
                    return [].slice.call(originalArguments)
                };
                const mapGroup = (group, level, mapper) => (0, _iterator.map)(group, (item => {
                    const restItem = function(source, excluded) {
                        if (null == source) {
                            return {}
                        }
                        var target = {};
                        for (var key in source) {
                            if (Object.prototype.hasOwnProperty.call(source, key)) {
                                if (excluded.indexOf(key) >= 0) {
                                    continue
                                }
                                target[key] = source[key]
                            }
                        }
                        return target
                    }(item, _excluded);
                    return _extends({}, restItem, {
                        items: mapRecursive(item.items, level - 1, mapper)
                    })
                }));
                const mapRecursive = (items, level, mapper) => {
                    if (!Array.isArray(items)) {
                        return items
                    }
                    return level ? mapGroup(items, level, mapper) : (0, _iterator.map)(items, mapper)
                };
                exports.mapDataRespectingGrouping = (items, mapper, groupInfo) => {
                    const level = groupInfo ? (0, _utils.normalizeSortingInfo)(groupInfo).length : 0;
                    return mapRecursive(items, level, mapper)
                };
                exports.normalizeLoadResult = (data, extra) => {
                    var _data;
                    if (null !== (_data = data) && void 0 !== _data && _data.data) {
                        extra = data;
                        data = data.data
                    }
                    if (!Array.isArray(data)) {
                        data = [data]
                    }
                    return {
                        data: data,
                        extra: extra
                    }
                };
                const createCustomStoreFromLoadFunc = options => {
                    const storeConfig = {};
                    (0, _iterator.each)(["useDefaultSearch", "key", "load", "loadMode", "cacheRawData", "byKey", "lookup", "totalCount", "insert", "update", "remove"], (function() {
                        storeConfig[this] = options[this];
                        delete options[this]
                    }));
                    return new _custom_store.default(storeConfig)
                };
                const createCustomStoreFromUrl = (url, normalizationOptions) => new _custom_store.default({
                    load: () => _ajax.default.sendRequest({
                        url: url,
                        dataType: "json"
                    }),
                    loadMode: null === normalizationOptions || void 0 === normalizationOptions ? void 0 : normalizationOptions.fromUrlLoadMode
                });
                exports.normalizeDataSourceOptions = (options, normalizationOptions) => {
                    let store;
                    if ("string" === typeof options) {
                        options = {
                            paginate: false,
                            store: createCustomStoreFromUrl(options, normalizationOptions)
                        }
                    }
                    if (void 0 === options) {
                        options = []
                    }
                    if (Array.isArray(options) || options instanceof _abstract_store.default) {
                        options = {
                            store: options
                        }
                    } else {
                        options = (0, _extend.extend)({}, options)
                    }
                    if (void 0 === options.store) {
                        options.store = []
                    }
                    store = options.store;
                    if ("load" in options) {
                        store = createCustomStoreFromLoadFunc(options)
                    } else if (Array.isArray(store)) {
                        store = new _array_store.default(store)
                    } else if ((0, _type.isPlainObject)(store)) {
                        store = (storeConfig => {
                            const alias = storeConfig.type;
                            delete storeConfig.type;
                            return _abstract_store.default.create(alias, storeConfig)
                        })((0, _extend.extend)({}, store))
                    }
                    options.store = store;
                    return options
                }
            },
        1773:
            /*!*********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/data/m_abstract_store.js ***!
              \*********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 55620));
                var _events_strategy = __webpack_require__( /*! ../../core/events_strategy */ 2607);
                var _common = __webpack_require__( /*! ../../core/utils/common */ 17781);
                var _data = __webpack_require__( /*! ../../core/utils/data */ 31e3);
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 87739);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                var _errors = __webpack_require__( /*! ../../data/errors */ 74760);
                var _store_helper = _interopRequireDefault(__webpack_require__( /*! ../../data/store_helper */ 22197));
                var _utils = __webpack_require__( /*! ../../data/utils */ 99354);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const {
                    abstract: abstract
                } = _class.default;
                const {
                    queryByOptions: queryByOptions
                } = _store_helper.default;
                const storeImpl = {};
                const Store = _class.default.inherit({
                    _langParams: {},
                    ctor(options) {
                        const that = this;
                        options = options || {};
                        this._eventsStrategy = new _events_strategy.EventsStrategy(this);
                        (0, _iterator.each)(["onLoaded", "onLoading", "onInserted", "onInserting", "onUpdated", "onUpdating", "onPush", "onRemoved", "onRemoving", "onModified", "onModifying"], ((_, optionName) => {
                            if (optionName in options) {
                                that.on(optionName.slice(2).toLowerCase(), options[optionName])
                            }
                        }));
                        this._key = options.key;
                        this._errorHandler = options.errorHandler;
                        this._useDefaultSearch = true
                    },
                    _clearCache: _common.noop,
                    _customLoadOptions: () => null,
                    key() {
                        return this._key
                    },
                    keyOf(obj) {
                        if (!this._keyGetter) {
                            this._keyGetter = (0, _data.compileGetter)(this.key())
                        }
                        return this._keyGetter(obj)
                    },
                    _requireKey() {
                        if (!this.key()) {
                            throw _errors.errors.Error("E4005")
                        }
                    },
                    load(options) {
                        const that = this;
                        options = options || {};
                        this._eventsStrategy.fireEvent("loading", [options]);
                        return this._withLock(this._loadImpl(options)).done((result => {
                            that._eventsStrategy.fireEvent("loaded", [result, options])
                        }))
                    },
                    _loadImpl(options) {
                        if (!(0, _type.isEmptyObject)(this._langParams)) {
                            options = options || {};
                            options._langParams = _extends({}, this._langParams, options._langParams)
                        }
                        return queryByOptions(this.createQuery(options), options).enumerate()
                    },
                    _withLock(task) {
                        const result = new _deferred.Deferred;
                        task.done((function() {
                            const that = this;
                            const args = arguments;
                            _utils.processRequestResultLock.promise().done((() => {
                                result.resolveWith(that, args)
                            }))
                        })).fail((function() {
                            result.rejectWith(this, arguments)
                        }));
                        return result
                    },
                    createQuery: abstract,
                    totalCount(options) {
                        return this._totalCountImpl(options)
                    },
                    _totalCountImpl(options) {
                        return queryByOptions(this.createQuery(options), options, true).count()
                    },
                    byKey(key, extraOptions) {
                        return this._addFailHandlers(this._withLock(this._byKeyImpl(key, extraOptions)))
                    },
                    _byKeyImpl: abstract,
                    insert(values) {
                        const that = this;
                        that._eventsStrategy.fireEvent("modifying");
                        that._eventsStrategy.fireEvent("inserting", [values]);
                        return that._addFailHandlers(that._insertImpl(values).done(((callbackValues, callbackKey) => {
                            that._eventsStrategy.fireEvent("inserted", [callbackValues, callbackKey]);
                            that._eventsStrategy.fireEvent("modified")
                        })))
                    },
                    _insertImpl: abstract,
                    update(key, values) {
                        const that = this;
                        that._eventsStrategy.fireEvent("modifying");
                        that._eventsStrategy.fireEvent("updating", [key, values]);
                        return that._addFailHandlers(that._updateImpl(key, values).done((() => {
                            that._eventsStrategy.fireEvent("updated", [key, values]);
                            that._eventsStrategy.fireEvent("modified")
                        })))
                    },
                    _updateImpl: abstract,
                    push(changes) {
                        const beforePushArgs = {
                            changes: changes,
                            waitFor: []
                        };
                        this._eventsStrategy.fireEvent("beforePushAggregation", [beforePushArgs]);
                        (0, _deferred.when)(...beforePushArgs.waitFor).done((() => {
                            this._pushImpl(changes);
                            this._eventsStrategy.fireEvent("beforePush", [{
                                changes: changes
                            }]);
                            this._eventsStrategy.fireEvent("push", [changes])
                        }))
                    },
                    _pushImpl: _common.noop,
                    remove(key) {
                        const that = this;
                        that._eventsStrategy.fireEvent("modifying");
                        that._eventsStrategy.fireEvent("removing", [key]);
                        return that._addFailHandlers(that._removeImpl(key).done((callbackKey => {
                            that._eventsStrategy.fireEvent("removed", [callbackKey]);
                            that._eventsStrategy.fireEvent("modified")
                        })))
                    },
                    _removeImpl: abstract,
                    _addFailHandlers(deferred) {
                        return deferred.fail(this._errorHandler).fail(_errors.handleError)
                    },
                    on(eventName, eventHandler) {
                        this._eventsStrategy.on(eventName, eventHandler);
                        return this
                    },
                    off(eventName, eventHandler) {
                        this._eventsStrategy.off(eventName, eventHandler);
                        return this
                    }
                });
                Store.create = function(alias, options) {
                    if (!(alias in storeImpl)) {
                        throw _errors.errors.Error("E4020", alias)
                    }
                    return new storeImpl[alias](options)
                };
                Store.registerClass = function(type, alias) {
                    if (alias) {
                        storeImpl[alias] = type
                    }
                    return type
                };
                Store.inherit = (inheritor = Store.inherit, function(members, alias) {
                    const type = inheritor.apply(this, [members]);
                    Store.registerClass(type, alias);
                    return type
                });
                var inheritor;
                exports.default = Store
            },
        79587:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/data/m_array_query.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _class = (obj = __webpack_require__( /*! ../../core/class */ 55620), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _data = __webpack_require__( /*! ../../core/utils/data */ 31e3);
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 87739);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                var _errors = __webpack_require__( /*! ../../data/errors */ 74760);
                var _utils = __webpack_require__( /*! ../../data/utils */ 99354);
                const Iterator = _class.default.inherit({
                    toArray() {
                        const result = [];
                        this.reset();
                        while (this.next()) {
                            result.push(this.current())
                        }
                        return result
                    },
                    countable: () => false
                });
                const ArrayIterator = Iterator.inherit({
                    ctor(array) {
                        this.array = array;
                        this.index = -1
                    },
                    next() {
                        if (this.index + 1 < this.array.length) {
                            this.index++;
                            return true
                        }
                        return false
                    },
                    current() {
                        return this.array[this.index]
                    },
                    reset() {
                        this.index = -1
                    },
                    toArray() {
                        return this.array.slice(0)
                    },
                    countable: () => true,
                    count() {
                        return this.array.length
                    }
                });
                const WrappedIterator = Iterator.inherit({
                    ctor(iter) {
                        this.iter = iter
                    },
                    next() {
                        return this.iter.next()
                    },
                    current() {
                        return this.iter.current()
                    },
                    reset() {
                        return this.iter.reset()
                    }
                });
                const MapIterator = WrappedIterator.inherit({
                    ctor(iter, mapper) {
                        this.callBase(iter);
                        this.index = -1;
                        this.mapper = mapper
                    },
                    current() {
                        return this.mapper(this.callBase(), this.index)
                    },
                    next() {
                        const hasNext = this.callBase();
                        if (hasNext) {
                            this.index++
                        }
                        return hasNext
                    }
                });
                const SortIterator = Iterator.inherit({
                    ctor(iter, getter, desc, compare) {
                        this.langParams = iter.langParams;
                        if (!(iter instanceof MapIterator)) {
                            iter = new MapIterator(iter, this._wrap);
                            iter.langParams = this.langParams
                        }
                        this.iter = iter;
                        this.rules = [{
                            getter: getter,
                            desc: desc,
                            compare: compare,
                            langParams: this.langParams
                        }]
                    },
                    thenBy(getter, desc, compare) {
                        const result = new SortIterator(this.sortedIter || this.iter, getter, desc, comp