/*!
 * DevExpress Diagram (dx-diagram)
 * Version: 2.2.13
 * Build date: Mon Nov 11 2024
 *
 * Copyright (c) 2012 - 2024 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExpress licensing here: https://www.devexpress.com/Support/EULAs
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["DevExpress"] = factory();
	else
		root["DevExpress"] = root["DevExpress"] || {}, root["DevExpress"]["diagram"] = factory();
})(this, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 9279:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Browser = void 0;
var Browser = (function () {
    function Browser() {
    }
    Browser.IdentUserAgent = function (userAgent, ignoreDocumentMode) {
        if (ignoreDocumentMode === void 0) { ignoreDocumentMode = false; }
        var browserTypesOrderedList = ['Mozilla', 'IE', 'Firefox', 'Netscape', 'Safari', 'Chrome', 'Opera', 'Opera10', 'Edge'];
        var defaultBrowserType = 'IE';
        var defaultPlatform = 'Win';
        var defaultVersions = { Safari: 2, Chrome: 0.1, Mozilla: 1.9, Netscape: 8, Firefox: 2, Opera: 9, IE: 6, Edge: 12 };
        if (!userAgent || userAgent.length === 0) {
            Browser.fillUserAgentInfo(browserTypesOrderedList, defaultBrowserType, defaultVersions[defaultBrowserType], defaultPlatform);
            return;
        }
        userAgent = userAgent.toLowerCase();
        Browser.indentPlatformMajorVersion(userAgent);
        try {
            var platformIdentStrings = {
                'Windows': 'Win',
                'Macintosh': 'Mac',
                'Mac OS': 'Mac',
                'Mac_PowerPC': 'Mac',
                'cpu os': 'MacMobile',
                'cpu iphone os': 'MacMobile',
                'Android': 'Android',
                '!Windows Phone': 'WinPhone',
                '!WPDesktop': 'WinPhone',
                '!ZuneWP': 'WinPhone'
            };
            var optSlashOrSpace = '(?:/|\\s*)?';
            var versionString = '(\\d+)(?:\\.((?:\\d+?[1-9])|\\d)0*?)?';
            var optVersion = '(?:' + versionString + ')?';
            var patterns = {
                Safari: 'applewebkit(?:.*?(?:version/' + versionString + '[\\.\\w\\d]*?(?:\\s+mobile/\\S*)?\\s+safari))?',
                Chrome: '(?:chrome|crios)(?!frame)' + optSlashOrSpace + optVersion,
                Mozilla: 'mozilla(?:.*rv:' + optVersion + '.*Gecko)?',
                Netscape: '(?:netscape|navigator)\\d*/?\\s*' + optVersion,
                Firefox: 'firefox' + optSlashOrSpace + optVersion,
                Opera: '(?:opera|\\sopr)' + optSlashOrSpace + optVersion,
                Opera10: 'opera.*\\s*version' + optSlashOrSpace + optVersion,
                IE: 'msie\\s*' + optVersion,
                Edge: 'edge' + optSlashOrSpace + optVersion
            };
            var browserType = null;
            var version = -1;
            for (var i = 0; i < browserTypesOrderedList.length; i++) {
                var browserTypeCandidate = browserTypesOrderedList[i];
                var regExp = new RegExp(patterns[browserTypeCandidate], 'i');
                var matches = regExp.exec(userAgent);
                if (matches && matches.index >= 0) {
                    if (browserType === 'IE' && version >= 11 && browserTypeCandidate === 'Safari')
                        continue;
                    browserType = browserTypeCandidate;
                    if (browserType === 'Opera10')
                        browserType = 'Opera';
                    var tridentPattern = 'trident' + optSlashOrSpace + optVersion;
                    version = Browser.GetBrowserVersion(userAgent, matches, tridentPattern, Browser.getIECompatibleVersionString());
                    if (browserType === 'Mozilla' && version >= 11)
                        browserType = 'IE';
                }
            }
            if (!browserType)
                browserType = defaultBrowserType;
            var browserVersionDetected = version !== -1;
            if (!browserVersionDetected)
                version = defaultVersions[browserType];
            var platform = null;
            var minOccurenceIndex = Number.MAX_VALUE;
            for (var identStr in platformIdentStrings) {
                if (!Object.prototype.hasOwnProperty.call(platformIdentStrings, identStr))
                    continue;
                var importantIdent = identStr.substr(0, 1) === '!';
                var occurenceIndex = userAgent.indexOf((importantIdent ? identStr.substr(1) : identStr).toLowerCase());
                if (occurenceIndex >= 0 && (occurenceIndex < minOccurenceIndex || importantIdent)) {
                    minOccurenceIndex = importantIdent ? 0 : occurenceIndex;
                    platform = platformIdentStrings[identStr];
                }
            }
            var samsungPattern = 'SM-[A-Z]';
            var m = userAgent.toUpperCase().match(samsungPattern);
            var isSamsungAndroidDevice = m && m.length > 0;
            if (platform === 'WinPhone' && version < 9)
                version = Math.floor(Browser.getVersionFromTrident(userAgent, 'trident' + optSlashOrSpace + optVersion));
            if (!ignoreDocumentMode && browserType === 'IE' && version > 7 && document.documentMode < version)
                version = document.documentMode;
            if (platform === 'WinPhone')
                version = Math.max(9, version);
            if (!platform)
                platform = defaultPlatform;
            if (platform === platformIdentStrings['cpu os'] && !browserVersionDetected)
                version = 4;
            Browser.fillUserAgentInfo(browserTypesOrderedList, browserType, version, platform, isSamsungAndroidDevice);
        }
        catch (e) {
            Browser.fillUserAgentInfo(browserTypesOrderedList, defaultBrowserType, defaultVersions[defaultBrowserType], defaultPlatform);
        }
    };
    Browser.GetBrowserVersion = function (userAgent, matches, tridentPattern, ieCompatibleVersionString) {
        var version = Browser.getVersionFromMatches(matches);
        if (ieCompatibleVersionString) {
            var versionFromTrident = Browser.getVersionFromTrident(userAgent, tridentPattern);
            if (ieCompatibleVersionString === 'edge' || parseInt(ieCompatibleVersionString) === versionFromTrident)
                return versionFromTrident;
        }
        return version;
    };
    Browser.getIECompatibleVersionString = function () {
        if (document.compatible) {
            for (var i = 0; i < document.compatible.length; i++) {
                if (document.compatible[i].userAgent === 'IE' && document.compatible[i].version)
                    return document.compatible[i].version.toLowerCase();
            }
        }
        return '';
    };
    Browser.isTouchEnabled = function () {
        return Browser.hasTouchStart() || Browser.hasMaxTouchPoints() || Browser.hasMsMaxTouchPoints();
    };
    Browser.hasTouchStart = function () {
        return ('ontouchstart' in window);
    };
    Browser.hasMaxTouchPoints = function () {
        return navigator['maxTouchPoints'] > 0;
    };
    Browser.hasMsMaxTouchPoints = function () {
        return navigator['msMaxTouchPoints'] > 0;
    };
    Browser.hasNavigator = function () {
        return typeof navigator !== 'undefined';
    };
    Browser.fillUserAgentInfo = function (browserTypesOrderedList, browserType, version, platform, isSamsungAndroidDevice) {
        if (isSamsungAndroidDevice === void 0) { isSamsungAndroidDevice = false; }
        for (var i = 0; i < browserTypesOrderedList.length; i++) {
            var type = browserTypesOrderedList[i];
            Browser[type] = type === browserType;
        }
        Browser.Version = Math.floor(10.0 * version) / 10.0;
        Browser.MajorVersion = Math.floor(Browser.Version);
        Browser.WindowsPlatform = platform === 'Win' || platform === 'WinPhone';
        Browser.MacOSMobilePlatform = platform === 'MacMobile' || (platform === 'Mac' && Browser.isTouchEnabled());
        Browser.MacOSPlatform = platform === 'Mac' && !Browser.MacOSMobilePlatform;
        Browser.AndroidMobilePlatform = platform === 'Android';
        Browser.WindowsPhonePlatform = platform === 'WinPhone';
        Browser.WebKitFamily = Browser.Safari || Browser.Chrome || Browser.Opera && Browser.MajorVersion >= 15;
        Browser.NetscapeFamily = Browser.Netscape || Browser.Mozilla || Browser.Firefox;
        Browser.WebKitTouchUI = Browser.MacOSMobilePlatform || Browser.AndroidMobilePlatform;
        var isIETouchUI = Browser.IE && Browser.MajorVersion > 9 && Browser.WindowsPlatform && Browser.UserAgent.toLowerCase().indexOf('touch') >= 0;
        Browser.MSTouchUI = isIETouchUI || (Browser.Edge && !!window.navigator.maxTouchPoints);
        Browser.TouchUI = Browser.WebKitTouchUI || Browser.MSTouchUI;
        Browser.MobileUI = Browser.WebKitTouchUI || Browser.WindowsPhonePlatform;
        Browser.AndroidDefaultBrowser = Browser.AndroidMobilePlatform && !Browser.Chrome;
        Browser.AndroidChromeBrowser = Browser.AndroidMobilePlatform && Browser.Chrome;
        if (isSamsungAndroidDevice)
            Browser.SamsungAndroidDevice = isSamsungAndroidDevice;
        if (Browser.MSTouchUI) {
            var isARMArchitecture = Browser.UserAgent.toLowerCase().indexOf('arm;') > -1;
            Browser.VirtualKeyboardSupported = isARMArchitecture || Browser.WindowsPhonePlatform;
        }
        else
            Browser.VirtualKeyboardSupported = Browser.WebKitTouchUI;
        Browser.fillDocumentElementBrowserTypeClassNames(browserTypesOrderedList);
    };
    Browser.indentPlatformMajorVersion = function (userAgent) {
        var regex = /(?:(?:windows nt|macintosh|mac os|cpu os|cpu iphone os|android|windows phone|linux) )(\d+)(?:[-0-9_.])*/;
        var matches = regex.exec(userAgent);
        if (matches)
            Browser.PlaformMajorVersion = matches[1];
    };
    Browser.getVersionFromMatches = function (matches) {
        var result = -1;
        var versionStr = '';
        if (matches) {
            if (matches[1]) {
                versionStr += matches[1];
                if (matches[2])
                    versionStr += '.' + matches[2];
            }
            if (versionStr !== '') {
                result = parseFloat(versionStr);
                if (isNaN(result))
                    result = -1;
            }
        }
        return result;
    };
    Browser.getVersionFromTrident = function (userAgent, tridentPattern) {
        var tridentDiffFromVersion = 4;
        var matches = new RegExp(tridentPattern, 'i').exec(userAgent);
        return Browser.getVersionFromMatches(matches) + tridentDiffFromVersion;
    };
    Browser.fillDocumentElementBrowserTypeClassNames = function (browserTypesOrderedList) {
        var documentElementClassName = '';
        var browserTypeslist = browserTypesOrderedList.concat(['WindowsPlatform', 'MacOSPlatform', 'MacOSMobilePlatform', 'AndroidMobilePlatform',
            'WindowsPhonePlatform', 'WebKitFamily', 'WebKitTouchUI', 'MSTouchUI', 'TouchUI', 'AndroidDefaultBrowser']);
        for (var i = 0; i < browserTypeslist.length; i++) {
            var type = browserTypeslist[i];
            if (Browser[type])
                documentElementClassName += 'dx' + type + ' ';
        }
        documentElementClassName += 'dxBrowserVersion-' + Browser.MajorVersion;
        if (typeof document !== 'undefined' && document && document.documentElement) {
            if (document.documentElement.className !== '')
                documentElementClassName = ' ' + documentElementClassName;
            document.documentElement.className += documentElementClassName;
            Browser.Info = documentElementClassName;
        }
    };
    Browser.getUserAgent = function () {
        return Browser.hasNavigator() && navigator.userAgent ? navigator.userAgent.toLowerCase() : '';
    };
    Browser.UserAgent = Browser.getUserAgent();
    Browser._foo = Browser.IdentUserAgent(Browser.UserAgent);
    return Browser;
}());
exports.Browser = Browser;


/***/ }),

/***/ 1772:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EmptyBatchUpdatableObject = exports.BatchUpdatableObject = void 0;
var BatchUpdatableObject = (function () {
    function BatchUpdatableObject() {
        this.suspendUpdateCount = 0;
        this.occurredEvents = 0;
    }
    BatchUpdatableObject.prototype.beginUpdate = function () {
        if (this.suspendUpdateCount === 0)
            this.onUpdateLocked();
        if (this.suspendUpdateCount < 0)
            this.suspendUpdateCount--;
        else
            this.suspendUpdateCount++;
    };
    BatchUpdatableObject.prototype.endUpdate = function () {
        if (this.suspendUpdateCount < 0)
            this.suspendUpdateCount++;
        else if (this.suspendUpdateCount > 0)
            this.suspendUpdateCount--;
        if (!this.isUpdateLocked()) {
            var occurredEvents = this.occurredEvents;
            this.occurredEvents = 0;
            this.onUpdateUnlocked(occurredEvents);
        }
    };
    BatchUpdatableObject.prototype.suspendUpdate = function () {
        if (this.suspendUpdateCount > 0) {
            this.suspendUpdateCount *= -1;
            var occurredEvents = this.occurredEvents;
            this.occurredEvents = 0;
            this.onUpdateUnlocked(occurredEvents);
        }
    };
    BatchUpdatableObject.prototype.continueUpdate = function () {
        if (this.suspendUpdateCount < 0)
            this.suspendUpdateCount *= -1;
    };
    BatchUpdatableObject.prototype.isUpdateLocked = function () {
        return this.suspendUpdateCount > 0;
    };
    BatchUpdatableObject.prototype.onUpdateLocked = function () { };
    BatchUpdatableObject.prototype.registerOccurredEvent = function (eventMask) {
        this.occurredEvents |= eventMask;
    };
    BatchUpdatableObject.prototype.resetOccurredEvents = function () {
        this.occurredEvents = 0;
    };
    BatchUpdatableObject.prototype.isLocked = function () {
        return this.suspendUpdateCount !== 0;
    };
    return BatchUpdatableObject;
}());
exports.BatchUpdatableObject = BatchUpdatableObject;
var EmptyBatchUpdatableObject = (function () {
    function EmptyBatchUpdatableObject() {
    }
    EmptyBatchUpdatableObject.prototype.beginUpdate = function () { };
    EmptyBatchUpdatableObject.prototype.endUpdate = function () { };
    return EmptyBatchUpdatableObject;
}());
exports.EmptyBatchUpdatableObject = EmptyBatchUpdatableObject;


/***/ }),

/***/ 7820:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Flag = void 0;
var Flag = (function () {
    function Flag(initValue) {
        if (initValue === void 0) { initValue = 0; }
        this.value = initValue;
    }
    Flag.prototype.get = function (enumVal) {
        return (this.value & enumVal) === enumVal;
    };
    Flag.prototype.set = function (enumVal, newValue) {
        var currVal = (this.value & enumVal) === enumVal;
        if (currVal !== newValue) {
            if (newValue)
                this.value |= enumVal;
            else
                this.value ^= enumVal;
        }
        return this;
    };
    Flag.prototype.add = function (value) {
        this.value |= value;
    };
    Flag.prototype.anyOf = function () {
        var flags = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            flags[_i] = arguments[_i];
        }
        for (var _a = 0, flags_1 = flags; _a < flags_1.length; _a++) {
            var flag = flags_1[_a];
            if ((this.value & flag) === flag)
                return true;
        }
        return false;
    };
    Flag.prototype.getValue = function () {
        return this.value;
    };
    Flag.prototype.clone = function () {
        return new Flag(this.value);
    };
    return Flag;
}());
exports.Flag = Flag;


/***/ }),

/***/ 6799:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExtendedMinMax = exports.ExtendedMax = exports.ExtendedMin = exports.MinMaxNumber = exports.MinMax = void 0;
var tslib_1 = __webpack_require__(655);
var MinMax = (function () {
    function MinMax(minElement, maxElement) {
        this.minElement = minElement;
        this.maxElement = maxElement;
    }
    return MinMax;
}());
exports.MinMax = MinMax;
var MinMaxNumber = (function (_super) {
    tslib_1.__extends(MinMaxNumber, _super);
    function MinMaxNumber() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(MinMaxNumber.prototype, "length", {
        get: function () {
            return this.maxElement - this.minElement;
        },
        enumerable: false,
        configurable: true
    });
    return MinMaxNumber;
}(MinMax));
exports.MinMaxNumber = MinMaxNumber;
var ExtendedMin = (function () {
    function ExtendedMin(minElement, minValue) {
        this.minElement = minElement;
        this.minValue = minValue;
    }
    return ExtendedMin;
}());
exports.ExtendedMin = ExtendedMin;
var ExtendedMax = (function () {
    function ExtendedMax(maxElement, maxValue) {
        this.maxElement = maxElement;
        this.maxValue = maxValue;
    }
    return ExtendedMax;
}());
exports.ExtendedMax = ExtendedMax;
var ExtendedMinMax = (function (_super) {
    tslib_1.__extends(ExtendedMinMax, _super);
    function ExtendedMinMax(minElement, minValue, maxElement, maxValue) {
        var _this = _super.call(this, minElement, maxElement) || this;
        _this.minValue = minValue;
        _this.maxValue = maxValue;
        return _this;
    }
    return ExtendedMinMax;
}(MinMax));
exports.ExtendedMinMax = ExtendedMinMax;


/***/ }),

/***/ 9291:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UnitConverter = void 0;
var UnitConverter = (function () {
    function UnitConverter() {
    }
    UnitConverter.hundredthsOfMillimeterToTwipsRound = function (value) {
        return Math.round(1440 * value / 2540.0);
    };
    UnitConverter.documentsToTwips = function (value) {
        return 24 * value / 5;
    };
    UnitConverter.pixelsToTwips = function (value) {
        return Math.round(UnitConverter.pixelsToTwipsF(value));
    };
    UnitConverter.pixelsToTwipsCustomDpi = function (value, dpi) {
        return Math.round(UnitConverter.pixelsToTwipsFCustomDpi(value, dpi));
    };
    UnitConverter.inchesToTwips = function (value) {
        return Math.round(UnitConverter.inchesToTwipsF(value));
    };
    UnitConverter.pointsToTwips = function (value) {
        return Math.round(UnitConverter.pointsToTwipsF(value));
    };
    UnitConverter.picasToTwips = function (value) {
        return Math.round(value * 1440 / UnitConverter.PICAS_PER_INCH);
    };
    UnitConverter.centimetersToTwips = function (value) {
        return Math.round(UnitConverter.centimetersToTwipsF(value));
    };
    UnitConverter.pixelsToTwipsF = function (value) {
        return value * 1440 / UnitConverter.DPI;
    };
    UnitConverter.pixelsToTwipsFCustomDpi = function (value, dpi) {
        return value * 1440 / dpi;
    };
    UnitConverter.inchesToTwipsF = function (value) {
        return value * 1440;
    };
    UnitConverter.pointsToTwipsF = function (value) {
        return value * 20;
    };
    UnitConverter.centimetersToTwipsF = function (value) {
        return value * 1440 / UnitConverter.CENTIMETERS_PER_INCH;
    };
    UnitConverter.twipsToDegrees = function (value) {
        return value / 60000;
    };
    UnitConverter.twipsToRadians = function (value) {
        return value / 60000 * Math.PI / 180;
    };
    UnitConverter.degreesToTwips = function (value) {
        return value * 60000;
    };
    UnitConverter.radiansToTwips = function (value) {
        return value * 60000 / Math.PI * 180;
    };
    UnitConverter.radiansToDegrees = function (value) {
        return value / Math.PI * 180;
    };
    UnitConverter.twipsToFD = function (value) {
        return Math.round(value * 2048 / 1875);
    };
    UnitConverter.fdToTwips = function (value) {
        return Math.round(value * 1875 / 2048);
    };
    UnitConverter.emuToTwips = function (val) {
        return val / 635;
    };
    UnitConverter.twipsToPixels = function (value) {
        return Math.round(UnitConverter.twipsToPixelsF(value));
    };
    UnitConverter.inchesToPixels = function (value) {
        return Math.round(UnitConverter.DPI * value);
    };
    UnitConverter.centimeterToPixel = function (value) {
        return Math.round(this.centimeterToPixelF(value));
    };
    UnitConverter.centimeterToPixelF = function (value) {
        return value * UnitConverter.DPI / UnitConverter.CENTIMETERS_PER_INCH;
    };
    UnitConverter.millimetersToPixel = function (value) {
        return Math.round(value / (UnitConverter.CENTIMETERS_PER_INCH / UnitConverter.DPI) / 10);
    };
    UnitConverter.pointsToPixels = function (value) {
        return Math.round(value * UnitConverter.DPI / 72);
    };
    UnitConverter.pointsToPixelsF = function (value) {
        return value * UnitConverter.DPI / 72;
    };
    UnitConverter.twipsToPixelsF = function (value) {
        return value * UnitConverter.DPI / 1440;
    };
    UnitConverter.pixelsToPoints = function (value) {
        return Math.round(value * 72 / UnitConverter.DPI);
    };
    UnitConverter.pixelsToPointsF = function (value) {
        return value * 72 / UnitConverter.DPI;
    };
    UnitConverter.twipsToPoints = function (value) {
        return Math.round(this.twipsToPointsF(value));
    };
    UnitConverter.twipsToPointsF = function (value) {
        return value / 20;
    };
    UnitConverter.twipsToInches = function (value) {
        return value / 1440;
    };
    UnitConverter.pixelsToInches = function (value) {
        return value / UnitConverter.DPI;
    };
    UnitConverter.twipsToCentimeters = function (value) {
        return value * UnitConverter.CENTIMETERS_PER_INCH / 1440;
    };
    UnitConverter.pixelToCentimeters = function (value) {
        return value * UnitConverter.CENTIMETERS_PER_INCH / UnitConverter.DPI;
    };
    UnitConverter.twipsToHundredthsOfMillimeter = function (value) {
        return Math.round(127 * value / 72);
    };
    UnitConverter.pixelsToHundredthsOfMillimeter = function (value) {
        return Math.round(2540 * value / UnitConverter.DPI);
    };
    UnitConverter.hundredthsOfMillimeterToTwips = function (value) {
        return 15 * value / 127;
    };
    UnitConverter.twipsToEmu = function (val) {
        return val * 635;
    };
    UnitConverter.twipsToDegree = function (value) {
        return value / 60000;
    };
    UnitConverter.DPI = 96;
    UnitConverter.CENTIMETERS_PER_INCH = 2.54;
    UnitConverter.PICAS_PER_INCH = 6;
    return UnitConverter;
}());
exports.UnitConverter = UnitConverter;


/***/ }),

/***/ 5596:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Metrics = void 0;
var Metrics = (function () {
    function Metrics() {
    }
    Metrics.euclideanDistance = function (a, b) {
        var xDist = a.x - b.x;
        var yDist = a.y - b.y;
        return Math.sqrt(xDist * xDist + yDist * yDist);
    };
    Metrics.manhattanDistance = function (a, b) {
        return Math.abs(a.x - b.x) + Math.abs(a.y - b.y);
    };
    return Metrics;
}());
exports.Metrics = Metrics;


/***/ }),

/***/ 4125:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Offsets = void 0;
var Offsets = (function () {
    function Offsets(left, right, top, bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
    }
    Offsets.empty = function () {
        return new Offsets(0, 0, 0, 0);
    };
    Object.defineProperty(Offsets.prototype, "horizontal", {
        get: function () {
            return this.left + this.right;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Offsets.prototype, "vertical", {
        get: function () {
            return this.top + this.bottom;
        },
        enumerable: false,
        configurable: true
    });
    Offsets.fromNumber = function (offset) {
        return new Offsets(offset, offset, offset, offset);
    };
    Offsets.fromOffsets = function (offsets) {
        return new Offsets(offsets.left, offsets.right, offsets.top, offsets.bottom);
    };
    Offsets.fromSide = function (horizontal, vertical) {
        return new Offsets(horizontal, horizontal, vertical, vertical);
    };
    Offsets.prototype.normalize = function () {
        this.left = Math.max(0, this.left);
        this.right = Math.max(0, this.right);
        this.top = Math.max(0, this.top);
        this.bottom = Math.max(0, this.bottom);
        return this;
    };
    Offsets.prototype.toString = function () {
        return JSON.stringify(this);
    };
    Offsets.prototype.isEmpty = function () {
        return this.left === 0 && this.right === 0 && this.top === 0 && this.bottom === 0;
    };
    Offsets.prototype.offset = function (offset) {
        this.left += offset.left;
        this.right += offset.right;
        this.top += offset.top;
        this.bottom += offset.bottom;
        return this;
    };
    Offsets.prototype.multiply = function (multLeft, multRight, multTop, multBottom) {
        switch (arguments.length) {
            case 1: {
                this.left *= multLeft;
                this.right *= multLeft;
                this.top *= multLeft;
                this.bottom *= multLeft;
                return this;
            }
            case 2: {
                this.left *= multLeft;
                this.right *= multLeft;
                this.top *= multRight;
                this.bottom *= multRight;
                return this;
            }
            case 4: {
                this.left *= multLeft;
                this.right *= multRight;
                this.top *= multTop;
                this.bottom *= multBottom;
                return this;
            }
        }
        return this;
    };
    Offsets.prototype.clone = function () {
        return new Offsets(this.left, this.right, this.top, this.bottom);
    };
    Offsets.prototype.copyFrom = function (obj) {
        this.left = obj.left;
        this.right = obj.right;
        this.top = obj.top;
        this.bottom = obj.bottom;
    };
    Offsets.prototype.equals = function (obj) {
        return this.top === obj.top &&
            this.bottom === obj.bottom &&
            this.right === obj.right &&
            this.left === obj.left;
    };
    Offsets.prototype.applyConverter = function (converter) {
        this.left = converter(this.left);
        this.right = converter(this.right);
        this.top = converter(this.top);
        this.bottom = converter(this.bottom);
        return this;
    };
    return Offsets;
}());
exports.Offsets = Offsets;


/***/ }),

/***/ 8900:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Point = void 0;
var Point = (function () {
    function Point(x, y) {
        this.x = x;
        this.y = y;
    }
    Point.zero = function () {
        return new Point(0, 0);
    };
    Point.fromNumber = function (num) {
        return new Point(num, num);
    };
    Point.prototype.isZero = function () {
        return this.x === 0 && this.y === 0;
    };
    Point.prototype.toString = function () {
        return JSON.stringify(this);
    };
    Point.prototype.copyFrom = function (obj) {
        this.x = obj.x;
        this.y = obj.y;
    };
    Point.prototype.clone = function () {
        return new Point(this.x, this.y);
    };
    Point.prototype.equals = function (obj) {
        return this.x === obj.x && this.y === obj.y;
    };
    Point.prototype.offset = function (offsetX, offsetY) {
        this.x += offsetX;
        this.y += offsetY;
        return this;
    };
    Point.prototype.offsetByPoint = function (offset) {
        this.x += offset.x;
        this.y += offset.y;
        return this;
    };
    Point.prototype.multiply = function (multiplierX, multiplierY) {
        this.x *= multiplierX;
        this.y *= multiplierY;
        return this;
    };
    Point.prototype.negative = function () {
        this.x *= -1;
        this.y *= -1;
        return this;
    };
    Point.prototype.applyConverter = function (converter) {
        this.x = converter(this.x);
        this.y = converter(this.y);
        return this;
    };
    Point.plus = function (a, b) {
        return new Point(a.x + b.x, a.y + b.y);
    };
    Point.minus = function (a, b) {
        return new Point(a.x - b.x, a.y - b.y);
    };
    Point.xComparer = function (a, b) {
        return a.x - b.x;
    };
    Point.yComparer = function (a, b) {
        return a.y - b.y;
    };
    Point.equals = function (a, b) {
        return a.x === b.x && a.y === b.y;
    };
    return Point;
}());
exports.Point = Point;


/***/ }),

/***/ 8011:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RectangleDeviation = exports.HitTestDeviation = exports.Rectangle = void 0;
var flag_1 = __webpack_require__(7820);
var algorithms_1 = __webpack_require__(1104);
var fixed_1 = __webpack_require__(8860);
var point_1 = __webpack_require__(8900);
var size_1 = __webpack_require__(6353);
var Rectangle = (function () {
    function Rectangle(x, y, width, height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }
    Object.defineProperty(Rectangle.prototype, "right", {
        get: function () {
            return this.x + this.width;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "bottom", {
        get: function () {
            return this.y + this.height;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "center", {
        get: function () {
            return Rectangle.center(this);
        },
        enumerable: false,
        configurable: true
    });
    Rectangle.prototype.createRectangle = function () {
        return new Rectangle(this.x, this.y, this.width, this.height);
    };
    Rectangle.prototype.createSize = function () {
        return new size_1.Size(this.width, this.height);
    };
    Rectangle.prototype.createPosition = function () {
        return new point_1.Point(this.x, this.y);
    };
    Rectangle.prototype.createVerticalInterval = function () {
        return new fixed_1.FixedInterval(this.y, this.height);
    };
    Rectangle.prototype.createHorizontalInterval = function () {
        return new fixed_1.FixedInterval(this.x, this.width);
    };
    Rectangle.fromGeometry = function (point, size) {
        return new Rectangle(point.x, point.y, size.width, size.height);
    };
    Rectangle.fromPoints = function (pointA, pointB) {
        var x = Math.min(pointA.x, pointB.x);
        var y = Math.min(pointA.y, pointB.y);
        var width = Math.abs(pointA.x - pointB.x);
        var height = Math.abs(pointA.y - pointB.y);
        return new Rectangle(x, y, width, height);
    };
    Rectangle.fromPositions = function (x1, y1, x2, y2) {
        var x = Math.min(x1, x2);
        var y = Math.min(y1, y2);
        var width = Math.abs(x2 - x1);
        var height = Math.abs(y2 - y1);
        return new Rectangle(x, y, width, height);
    };
    Rectangle.fromCenter = function (center, minRadius) {
        return new Rectangle(center.x - minRadius, center.y - minRadius, minRadius * 2, minRadius * 2);
    };
    Rectangle.prototype.isCollapsed = function () {
        return this.width === 0 || this.height === 0;
    };
    Rectangle.prototype.isEmpty = function () {
        return this.x === 0 && this.y === 0 &&
            this.width === 0 && this.height === 0;
    };
    Rectangle.prototype.toString = function () {
        return JSON.stringify(this);
    };
    Rectangle.prototype.setPosition = function (pos) {
        this.x = pos.x;
        this.y = pos.y;
        return this;
    };
    Rectangle.prototype.setSize = function (size) {
        this.width = size.width;
        this.height = size.height;
        return this;
    };
    Rectangle.prototype.setGeomerty = function (rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
        return this;
    };
    Rectangle.prototype.moveRectangle = function (offsetX, offsetY) {
        this.x += offsetX;
        this.y += offsetY;
        return this;
    };
    Rectangle.prototype.moveRectangleByPoint = function (offset) {
        this.x += offset.x;
        this.y += offset.y;
        return this;
    };
    Rectangle.prototype.resize = function (deltaX, deltaY) {
        this.width += deltaX;
        this.height += deltaY;
        return this;
    };
    Rectangle.prototype.nonNegativeSize = function () {
        if (this.width < 0)
            this.width = 0;
        if (this.height < 0)
            this.height = 0;
        return this;
    };
    Rectangle.prototype.multiply = function (multiplierX, multiplierY) {
        this.x *= multiplierX;
        this.y *= multiplierY;
        this.width *= multiplierX;
        this.height *= multiplierY;
        return this;
    };
    Rectangle.prototype.equals = function (obj) {
        return Rectangle.equals(this, obj);
    };
    Rectangle.prototype.clone = function () {
        var rect = new Rectangle(0, 0, 0, 0);
        rect.copyFrom(this);
        return rect;
    };
    Rectangle.prototype.copyFrom = function (obj) {
        this.x = obj.x;
        this.y = obj.y;
        this.width = obj.width;
        this.height = obj.height;
    };
    Rectangle.prototype.containsPoint = function (point) {
        return Rectangle.containsPoint(this, point);
    };
    Rectangle.prototype.containsRectangle = function (rectangle) {
        return this.x <= rectangle.x &&
            this.right >= rectangle.right &&
            this.y <= rectangle.y &&
            this.bottom >= rectangle.bottom;
    };
    Rectangle.prototype.inflate = function (deltaX, deltaY) {
        if (deltaY === void 0) { deltaY = deltaX; }
        this.x -= deltaX;
        this.y -= deltaY;
        this.width += deltaX * 2;
        this.height += deltaY * 2;
        return this;
    };
    Rectangle.prototype.applyOffsetsInside = function (offsets) {
        this.x += offsets.left;
        this.y += offsets.top;
        this.width -= offsets.left + offsets.right;
        this.height -= offsets.top + offsets.bottom;
        return this;
    };
    Rectangle.prototype.applyNormalizedOffsetsInside = function (offsets) {
        var left = Math.max(0, offsets.left);
        var right = Math.max(0, offsets.right);
        var horSum = left + right;
        if (horSum !== 0) {
            if (horSum <= this.width) {
                this.x += left;
                this.width -= horSum;
            }
            else {
                this.x += this.width * (left / horSum);
                this.width = 0;
            }
        }
        var top = Math.max(0, offsets.top);
        var bottom = Math.max(0, offsets.bottom);
        var vertSum = top + bottom;
        if (vertSum !== 0) {
            if (vertSum <= this.height) {
                this.y += top;
                this.height -= vertSum;
            }
            else {
                this.y += this.height * (top / vertSum);
                this.height = 0;
            }
        }
        return this;
    };
    Rectangle.prototype.applyOffsetsOutside = function (offsets) {
        this.x -= offsets.left;
        this.y -= offsets.top;
        this.width += offsets.left + offsets.right;
        this.height += offsets.top + offsets.bottom;
        return this;
    };
    Rectangle.prototype.applyConverter = function (converter) {
        this.x = converter(this.x);
        this.y = converter(this.y);
        this.width = converter(this.width);
        this.height = converter(this.height);
        return this;
    };
    Rectangle.getHorizIntersection = function (objA, objB) {
        return algorithms_1.IntervalAlgorithms.getIntersection(new fixed_1.FixedInterval(objA.x, objA.width), new fixed_1.FixedInterval(objB.x, objB.width));
    };
    Rectangle.getVertIntersection = function (objA, objB) {
        return algorithms_1.IntervalAlgorithms.getIntersection(new fixed_1.FixedInterval(objA.y, objA.height), new fixed_1.FixedInterval(objB.y, objB.height));
    };
    Rectangle.getIntersection = function (objA, objB) {
        var horInters = algorithms_1.IntervalAlgorithms.getIntersection(new fixed_1.FixedInterval(objA.x, objA.width), new fixed_1.FixedInterval(objB.x, objB.width));
        if (!horInters)
            return null;
        var vertInters = algorithms_1.IntervalAlgorithms.getIntersection(new fixed_1.FixedInterval(objA.y, objA.height), new fixed_1.FixedInterval(objB.y, objB.height));
        if (!vertInters)
            return null;
        return new Rectangle(horInters.start, vertInters.start, horInters.length, vertInters.length);
    };
    Rectangle.getHorNonCollapsedIntersection = function (objA, objB) {
        var inters = Rectangle.getHorizIntersection(objA, objB);
        return inters && !inters.isCollapsed() ? inters : null;
    };
    Rectangle.getVertNonCollapsedIntersection = function (objA, objB) {
        var inters = Rectangle.getVertIntersection(objA, objB);
        return inters && !inters.isCollapsed() ? inters : null;
    };
    Rectangle.getNonCollapsedIntersection = function (objA, objB) {
        var inters = Rectangle.getIntersection(objA, objB);
        return inters && !inters.isCollapsed() ? inters : null;
    };
    Rectangle.areIntersected = function (rectA, rectB) {
        return !(rectA.x > rectB.x + rectB.width || rectB.x > rectA.x + rectA.width) &&
            !(rectA.y > rectB.y + rectB.height || rectB.y > rectA.y + rectA.height);
    };
    Rectangle.union = function (rectA, rectB) {
        var right = Math.max(rectA.x + rectA.width, rectB.x + rectB.width);
        var bottom = Math.max(rectA.y + rectA.height, rectB.y + rectB.height);
        var x = Math.min(rectA.x, rectB.x);
        var y = Math.min(rectA.y, rectB.y);
        return new Rectangle(x, y, right - x, bottom - y);
    };
    Rectangle.equals = function (a, b) {
        return a.x === b.x &&
            a.y === b.y &&
            a.width === b.width &&
            a.height === b.height;
    };
    Rectangle.center = function (rect) {
        return new point_1.Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
    };
    Rectangle.containsPoint = function (rect, point) {
        var right = rect.x + rect.width;
        var bottom = rect.y + rect.height;
        return point.y >= rect.y && bottom >= point.y &&
            point.x >= rect.x && right >= point.x;
    };
    return Rectangle;
}());
exports.Rectangle = Rectangle;
var HitTestDeviation;
(function (HitTestDeviation) {
    HitTestDeviation[HitTestDeviation["None"] = 0] = "None";
    HitTestDeviation[HitTestDeviation["Top"] = 1] = "Top";
    HitTestDeviation[HitTestDeviation["Bottom"] = 2] = "Bottom";
    HitTestDeviation[HitTestDeviation["Left"] = 4] = "Left";
    HitTestDeviation[HitTestDeviation["Right"] = 8] = "Right";
})(HitTestDeviation = exports.HitTestDeviation || (exports.HitTestDeviation = {}));
var RectangleDeviation = (function () {
    function RectangleDeviation(initRectangle, initPoint) {
        this.initRectangle = initRectangle;
        this.initPoint = initPoint;
        this.deviation = new flag_1.Flag(HitTestDeviation.None);
    }
    RectangleDeviation.prototype.calcDeviation = function () {
        if (this.initPoint.x < this.initRectangle.x)
            this.deviation.set(HitTestDeviation.Left, true);
        else if (this.initPoint.x > this.initRectangle.right)
            this.deviation.set(HitTestDeviation.Right, true);
        if (this.initPoint.y < this.initRectangle.y)
            this.deviation.set(HitTestDeviation.Top, true);
        else if (this.initPoint.y > this.initRectangle.bottom)
            this.deviation.set(HitTestDeviation.Bottom, true);
        return this;
    };
    RectangleDeviation.prototype.calcAdditionalParams = function () {
        this.insidePoint = this.initPoint.clone();
        this.offsetToInside = new point_1.Point(0, 0);
        if (this.deviation.get(HitTestDeviation.Left)) {
            this.insidePoint.x = this.initRectangle.x;
            this.offsetToInside.x = this.insidePoint.x - this.initPoint.x;
        }
        else if (this.deviation.get(HitTestDeviation.Right)) {
            this.insidePoint.x = this.initRectangle.right;
            this.offsetToInside.x = this.initPoint.x - this.insidePoint.x;
        }
        if (this.deviation.get(HitTestDeviation.Top)) {
            this.insidePoint.y = this.initRectangle.y;
            this.offsetToInside.y = this.insidePoint.y - this.initPoint.y;
        }
        else if (this.deviation.get(HitTestDeviation.Bottom)) {
            this.insidePoint.y = this.initRectangle.bottom;
            this.offsetToInside.y = this.initPoint.y - this.insidePoint.y;
        }
        return this;
    };
    return RectangleDeviation;
}());
exports.RectangleDeviation = RectangleDeviation;


/***/ }),

/***/ 1335:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Segment = void 0;
var math_1 = __webpack_require__(8679);
var metrics_1 = __webpack_require__(5596);
var point_1 = __webpack_require__(8900);
var rectangle_1 = __webpack_require__(8011);
var Segment = (function () {
    function Segment(startPoint, endPoint) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }
    Object.defineProperty(Segment.prototype, "length", {
        get: function () {
            return metrics_1.Metrics.euclideanDistance(this.startPoint, this.endPoint);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Segment.prototype, "xLength", {
        get: function () {
            return Math.abs(this.endPoint.x - this.startPoint.x);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Segment.prototype, "yLength", {
        get: function () {
            return Math.abs(this.endPoint.y - this.startPoint.y);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Segment.prototype, "center", {
        get: function () {
            return new point_1.Point(this.startPoint.x + (this.endPoint.x - this.startPoint.x) / 2, this.startPoint.y + (this.endPoint.y - this.startPoint.y) / 2);
        },
        enumerable: false,
        configurable: true
    });
    Segment.prototype.isIntersected = function (segment) {
        return this.startPoint.equals(segment.startPoint) || this.endPoint.equals(segment.startPoint) ||
            this.startPoint.equals(segment.endPoint) || this.endPoint.equals(segment.endPoint) ||
            (this.intersectCore(segment) && segment.intersectCore(this));
    };
    Segment.prototype.containsPoint = function (point, accuracy) {
        if (accuracy === void 0) { accuracy = 0.0000001; }
        return this.startPoint.equals(point) || this.endPoint.equals(point) ||
            math_1.MathUtils.numberCloseTo(this.length, metrics_1.Metrics.euclideanDistance(this.startPoint, point) + metrics_1.Metrics.euclideanDistance(this.endPoint, point), accuracy);
    };
    Segment.prototype.isIntersectedByRect = function (rect) {
        if (rectangle_1.Rectangle.containsPoint(rect, this.startPoint) || rectangle_1.Rectangle.containsPoint(rect, this.endPoint))
            return true;
        var left = rect.x;
        var right = rect.x + rect.width;
        var top = rect.y;
        var bottom = rect.y + rect.height;
        return this.isIntersected(new Segment(new point_1.Point(left, top), new point_1.Point(left, bottom))) ||
            this.isIntersected(new Segment(new point_1.Point(right, top), new point_1.Point(right, bottom))) ||
            this.isIntersected(new Segment(new point_1.Point(left, top), new point_1.Point(right, top))) ||
            this.isIntersected(new Segment(new point_1.Point(left, bottom), new point_1.Point(right, bottom)));
    };
    Segment.prototype.intersectCore = function (segment) {
        if (this.startPoint.x === this.endPoint.x) {
            if (this.startPoint.x - segment.endPoint.x !== 0)
                return (this.startPoint.x - segment.startPoint.x) / (this.startPoint.x - segment.endPoint.x) <= 0;
            if (segment.endPoint.y - this.endPoint.y !== 0)
                return (segment.endPoint.y - this.startPoint.y) / (segment.endPoint.y - this.endPoint.y) <= 0;
        }
        if (this.startPoint.y === this.endPoint.y) {
            if (this.startPoint.y - segment.endPoint.y !== 0)
                return (this.startPoint.y - segment.startPoint.y) / (this.startPoint.y - segment.endPoint.y) <= 0;
            if (segment.endPoint.x - this.endPoint.x !== 0)
                return (segment.endPoint.x - this.startPoint.x) / (segment.endPoint.x - this.endPoint.x) <= 0;
        }
        var tg = (this.endPoint.y - this.startPoint.y) / (this.endPoint.x - this.startPoint.x);
        var y1 = this.startPoint.y + (segment.startPoint.x - this.startPoint.x) * tg;
        var y2 = this.startPoint.y + (segment.endPoint.x - this.startPoint.x) * tg;
        var dy1 = segment.startPoint.y - y1;
        var dy2 = segment.endPoint.y - y2;
        if (dy1 === 0 && dy2 === 0) {
            return (this.startPoint.y - y1) / (this.endPoint.y - y1) <= 0 ||
                (this.startPoint.y - y2) / (this.endPoint.y - y2) <= 0;
        }
        return dy1 === 0 || dy2 === 0 || dy1 / dy2 < 0;
    };
    return Segment;
}());
exports.Segment = Segment;


/***/ }),

/***/ 6353:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Size = void 0;
var Size = (function () {
    function Size(width, height) {
        this.width = width;
        this.height = height;
    }
    Size.empty = function () {
        return new Size(0, 0);
    };
    Size.fromNumber = function (num) {
        return new Size(num, num);
    };
    Size.initByCommonAction = function (action) {
        var widthAdp = function (s) { return s.width; };
        var heightAdp = function (s) { return s.height; };
        return new Size(action(widthAdp, heightAdp), action(heightAdp, widthAdp));
    };
    Size.prototype.isEmpty = function () {
        return this.width === 0 && this.height === 0;
    };
    Size.prototype.toString = function () {
        return JSON.stringify(this);
    };
    Size.prototype.nonNegativeSize = function () {
        if (this.width < 0)
            this.width = 0;
        if (this.height < 0)
            this.height = 0;
        return this;
    };
    Size.prototype.offset = function (offsetWidth, offsetHeight) {
        this.width = this.width + offsetWidth;
        this.height = this.height + offsetHeight;
        return this;
    };
    Size.prototype.multiply = function (multiplierW, multiplierH) {
        this.width *= multiplierW;
        this.height *= multiplierH;
        return this;
    };
    Size.prototype.equals = function (obj) {
        return this.width === obj.width && this.height === obj.height;
    };
    Size.prototype.clone = function () {
        return new Size(this.width, this.height);
    };
    Size.prototype.copyFrom = function (obj) {
        this.width = obj.width;
        this.height = obj.height;
    };
    Size.prototype.applyConverter = function (conv) {
        this.width = conv(this.width);
        this.height = conv(this.height);
        return this;
    };
    Size.equals = function (a, b) {
        return a.width === b.width && a.height === b.height;
    };
    return Size;
}());
exports.Size = Size;


/***/ }),

/***/ 9716:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Vector = void 0;
var Vector = (function () {
    function Vector(x, y) {
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        this.x = x;
        this.y = y;
    }
    Object.defineProperty(Vector.prototype, "length", {
        get: function () {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        },
        enumerable: false,
        configurable: true
    });
    Vector.fromPoints = function (begin, end) {
        return new Vector(end.x - begin.x, end.y - begin.y);
    };
    Vector.fromSegment = function (segment) {
        return new Vector(segment.endPoint.x - segment.startPoint.x, segment.endPoint.y - segment.startPoint.y);
    };
    Vector.prototype.normalize = function () {
        var length = this.length;
        if (length !== 0) {
            this.x /= length;
            this.y /= length;
        }
        return this;
    };
    Vector.prototype.negative = function () {
        this.x *= -1;
        this.y *= -1;
        return this;
    };
    Object.defineProperty(Vector, "axisX", {
        get: function () {
            return new Vector(1, 0);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Vector, "axisY", {
        get: function () {
            return new Vector(0, 1);
        },
        enumerable: false,
        configurable: true
    });
    Vector.angleBetween = function (a, b) {
        var cosFi = Vector.scalarProduct(a, b) / (a.length * b.length);
        return Math.acos(cosFi);
    };
    Vector.scalarProduct = function (a, b) {
        return a.x * b.x + a.y * b.y;
    };
    return Vector;
}());
exports.Vector = Vector;


/***/ }),

/***/ 1104:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IntervalAlgorithms = void 0;
var list_1 = __webpack_require__(2940);
var search_1 = __webpack_require__(2400);
var fixed_1 = __webpack_require__(8860);
var collector_1 = __webpack_require__(6102);
var IntervalAlgorithms = (function () {
    function IntervalAlgorithms() {
    }
    IntervalAlgorithms.oneConstainsOtherArraysOfInterval = function (mergedIntervalsA, intervalsB) {
        var shouldBeContais = list_1.ListUtils.deepCopy(intervalsB);
        var currenInterval = shouldBeContais.pop();
        while (currenInterval) {
            if (!list_1.ListUtils.unsafeAnyOf(mergedIntervalsA, function (mergedInterval) { return mergedInterval.containsInterval(currenInterval); }))
                return false;
            currenInterval = shouldBeContais.pop();
        }
        return true;
    };
    IntervalAlgorithms.getIntersection = function (intervalA, intervalB) {
        return IntervalAlgorithms.getIntersectionTemplate(intervalA, intervalB, intervalA);
    };
    IntervalAlgorithms.getIntersectionTemplate = function (intervalA, intervalB, template) {
        var start = Math.max(intervalA.start, intervalB.start);
        var end = Math.min(intervalA.end, intervalB.end);
        if (start > end)
            return null;
        return template.makeByStartEnd(start, end);
    };
    IntervalAlgorithms.getIntersectionNonNullLength = function (intervalA, intervalB) {
        return IntervalAlgorithms.getIntersectionNonNullLengthTemplate(intervalA, intervalB, intervalA);
    };
    IntervalAlgorithms.getIntersectionNonNullLengthTemplate = function (intervalA, intervalB, template) {
        var inters = IntervalAlgorithms.getIntersectionTemplate(intervalA, intervalB, template);
        return inters && inters.length ? inters : null;
    };
    IntervalAlgorithms.getIntersectionsTwoArraysOfInterval = function (intervalsA, intervalsB) {
        return IntervalAlgorithms.getIntersectionsTwoArraysOfIntervalTemplate(intervalsA, intervalsB, intervalsA[0]);
    };
    IntervalAlgorithms.getIntersectionsTwoArraysOfIntervalTemplate = function (intervalsA, intervalsB, template) {
        var result = [];
        var lengthIntervalsA = intervalsA.length;
        var lengthIntervalsB = intervalsB.length;
        var intervalsAIndex = 0;
        var intervalsBIndex = 0;
        var currAInterval = intervalsA[intervalsAIndex];
        var currBInterval = intervalsB[intervalsBIndex];
        var currResultInterval = null;
        while (intervalsAIndex < lengthIntervalsA && intervalsBIndex < lengthIntervalsB) {
            var intersection = IntervalAlgorithms.getIntersectionTemplate(currAInterval, currBInterval, template);
            if (intersection) {
                if (currResultInterval && currResultInterval.end === intersection.start)
                    currResultInterval.length += intersection.length;
                else {
                    currResultInterval = intersection;
                    result.push(currResultInterval);
                }
            }
            if (currAInterval.end < currBInterval.end) {
                intervalsAIndex++;
                currAInterval = intervalsA[intervalsAIndex];
            }
            else {
                intervalsBIndex++;
                currBInterval = intervalsB[intervalsBIndex];
            }
        }
        return result;
    };
    IntervalAlgorithms.getAffectedObjects = function (objects, intervals, getFirstIndex, conflictResolver) {
        if (getFirstIndex === void 0) { getFirstIndex = function (start) {
            return search_1.SearchUtils.normedInterpolationIndexOf(objects, function (obj) { return obj.interval.start; }, start);
        }; }
        if (conflictResolver === void 0) { conflictResolver = function (objectInterval, touchingIntervalLength, touchPoint) {
            return objectInterval.start === touchPoint && touchingIntervalLength === 0;
        }; }
        return IntervalAlgorithms.getAffectedObjectsTemplate(objects, intervals, intervals[0], getFirstIndex, conflictResolver);
    };
    IntervalAlgorithms.getAffectedObjectsTemplate = function (objects, intervals, template, getFirstIndex, conflictResolver) {
        if (getFirstIndex === void 0) { getFirstIndex = function (start) {
            return search_1.SearchUtils.normedInterpolationIndexOf(objects, function (obj) { return obj.interval.start; }, start);
        }; }
        if (conflictResolver === void 0) { conflictResolver = function (objectInterval, touchingIntervalLength, touchPoint) {
            return objectInterval.start === touchPoint && touchingIntervalLength === 0;
        }; }
        var collector = new collector_1.SparseIntervalsCollector(template);
        for (var _i = 0, intervals_1 = intervals; _i < intervals_1.length; _i++) {
            var interval = intervals_1[_i];
            var ind = Math.max(0, getFirstIndex(interval.start, objects));
            for (var obj = void 0; obj = objects[ind]; ind++) {
                var objInterval = obj.interval;
                if (objInterval.start > interval.end)
                    break;
                var intersection = IntervalAlgorithms.getIntersectionTemplate(objInterval, interval, template);
                if (intersection && (intersection.length || conflictResolver(objInterval, interval.length, intersection.start)))
                    collector.add(ind);
            }
        }
        return collector.getIntervals();
    };
    IntervalAlgorithms.handleAffectedObjects = function (objects, intervals, callback, getFirstIndex) {
        if (getFirstIndex === void 0) { getFirstIndex = function (start) {
            return search_1.SearchUtils.normedInterpolationIndexOf(objects, function (obj) { return obj.interval.start; }, start);
        }; }
        var template = new fixed_1.FixedInterval(0, 0);
        for (var _i = 0, intervals_2 = intervals; _i < intervals_2.length; _i++) {
            var interval = intervals_2[_i];
            var ind = Math.max(0, getFirstIndex(interval.start, objects));
            for (var obj = void 0; obj = objects[ind]; ind++) {
                var objInterval = obj.interval;
                if (objInterval.start > interval.end)
                    break;
                var intersection = IntervalAlgorithms.getIntersectionTemplate(objInterval, interval, template);
                if (intersection)
                    callback(obj, ind, interval, intersection);
            }
        }
    };
    IntervalAlgorithms.getMergedIntervals = function (intervals, needSort) {
        return IntervalAlgorithms.getMergedIntervalsTemplate(intervals, needSort, intervals[0]);
    };
    IntervalAlgorithms.getMergedIntervalsTemplate = function (intervals, needSort, template) {
        if (intervals.length < 2)
            return intervals.length > 0 ? [template.makeByStartLength(intervals[0].start, intervals[0].length)] : [];
        var sortedIntervals = needSort ?
            [].concat(intervals).sort(function (a, b) { return a.start - b.start; }) :
            intervals;
        var result = [];
        for (var i = 0, interval = void 0; interval = sortedIntervals[i];) {
            var minBound = interval.start;
            var maxBound = interval.end;
            for (++i; (interval = sortedIntervals[i]) !== undefined && (interval.start <= maxBound); i++) {
                if (interval.end > maxBound)
                    maxBound = interval.end;
            }
            result.push(template.makeByStartEnd(minBound, maxBound));
        }
        return result;
    };
    IntervalAlgorithms.reflectIntervals = function (intervals, bounds) {
        return IntervalAlgorithms.reflectIntervalsTemplate(intervals, bounds, bounds);
    };
    IntervalAlgorithms.reflectIntervalsTemplate = function (intervals, bounds, template) {
        if (!intervals.length)
            return [template.makeByStartLength(bounds.start, bounds.length)];
        var lastIntervalEnd = list_1.ListUtils.last(intervals).end;
        var result = list_1.ListUtils.reducedMap(intervals, function (curr, i) {
            return IntervalAlgorithms.getIntersectionNonNullLengthTemplate(template.makeByStartEnd(intervals[i - 1].end, curr.start), bounds, template);
        }, 1);
        if (bounds.start < intervals[0].start)
            result.unshift(template.makeByStartEnd(bounds.start, intervals[0].start));
        if (bounds.end > lastIntervalEnd)
            result.push(template.makeByStartEnd(lastIntervalEnd, bounds.end));
        return result;
    };
    IntervalAlgorithms.reflectionOfPointOnInterval = function (value, valInterval, targetInterval) {
        return (value - valInterval.start) / valInterval.length * targetInterval.length + targetInterval.start;
    };
    return IntervalAlgorithms;
}());
exports.IntervalAlgorithms = IntervalAlgorithms;


/***/ }),

/***/ 7814:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConstInterval = void 0;
var ConstInterval = (function () {
    function ConstInterval() {
    }
    Object.defineProperty(ConstInterval.prototype, "center", {
        get: function () {
            return this.start + (this.length / 2);
        },
        enumerable: false,
        configurable: true
    });
    ConstInterval.prototype.isNormalized = function () {
        return this.end >= this.start;
    };
    ConstInterval.prototype.isCollapsed = function () {
        return this.length === 0;
    };
    ConstInterval.prototype.equals = function (obj) {
        return this.start === obj.start && this.end === obj.end;
    };
    ConstInterval.isCollapsed = function (intervals) {
        return !intervals[1] && intervals[0].isCollapsed();
    };
    ConstInterval.prototype.containsInterval = function (interval) {
        return this.start <= interval.start && this.end >= interval.end;
    };
    ConstInterval.prototype.containsIntervalWithoutEnd = function (interval) {
        return this.start <= interval.start && this.end > interval.end;
    };
    ConstInterval.prototype.contains = function (pos) {
        return this.start <= pos && pos < this.end;
    };
    ConstInterval.prototype.containsWithIntervalEnd = function (val) {
        return this.start <= val && val <= this.end;
    };
    ConstInterval.prototype.containsWithoutIntervalEndAndStart = function (pos) {
        return this.start < pos && pos < this.end;
    };
    return ConstInterval;
}());
exports.ConstInterval = ConstInterval;


/***/ }),

/***/ 8860:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FixedInterval = void 0;
var tslib_1 = __webpack_require__(655);
var mutable_1 = __webpack_require__(8678);
var FixedInterval = (function (_super) {
    tslib_1.__extends(FixedInterval, _super);
    function FixedInterval(start, length) {
        var _this = _super.call(this) || this;
        _this.start = start;
        _this.length = length;
        return _this;
    }
    Object.defineProperty(FixedInterval.prototype, "end", {
        get: function () {
            return this.start + this.length;
        },
        set: function (newEnd) {
            this.length = newEnd - this.start;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FixedInterval.prototype, "center", {
        get: function () {
            return this.start + this.length / 2;
        },
        enumerable: false,
        configurable: true
    });
    FixedInterval.prototype.copyFrom = function (obj) {
        this.start = obj.start;
        this.length = obj.length;
    };
    FixedInterval.prototype.equals = function (obj) {
        return obj && this.start === obj.start && this.length === obj.length;
    };
    FixedInterval.prototype.clone = function () {
        return new FixedInterval(this.start, this.length);
    };
    FixedInterval.prototype.makeByStartEnd = function (start, end) {
        return new FixedInterval(start, end - start);
    };
    FixedInterval.prototype.makeByStartLength = function (start, length) {
        return new FixedInterval(start, length);
    };
    FixedInterval.prototype.makeByLengthEnd = function (length, end) {
        return new FixedInterval(end - length, length);
    };
    FixedInterval.fromPositions = function (start, end) {
        return new FixedInterval(start, end - start);
    };
    FixedInterval.makeByConstInterval = function (interval) {
        return new FixedInterval(interval.start, interval.length);
    };
    FixedInterval.prototype.expand = function (interval) {
        var end = Math.max(interval.end, this.end);
        this.start = Math.min(interval.start, this.start);
        this.end = end;
        return this;
    };
    return FixedInterval;
}(mutable_1.MutableInterval));
exports.FixedInterval = FixedInterval;


/***/ }),

/***/ 8678:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MutableInterval = void 0;
var tslib_1 = __webpack_require__(655);
var const_1 = __webpack_require__(7814);
var MutableInterval = (function (_super) {
    tslib_1.__extends(MutableInterval, _super);
    function MutableInterval() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MutableInterval.prototype.normalizeLength = function () {
        if (this.length < 0)
            this.length = 0;
        return this;
    };
    return MutableInterval;
}(const_1.ConstInterval));
exports.MutableInterval = MutableInterval;


/***/ }),

/***/ 6102:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SparseIntervalsCollector = void 0;
var intervals_1 = __webpack_require__(448);
var SparseIntervalsCollector = (function () {
    function SparseIntervalsCollector(template) {
        this.intervals = [];
        this.template = template;
    }
    SparseIntervalsCollector.prototype.add = function (index) {
        if (this.curr && this.curr.end === index) {
            this.curr.length++;
            return;
        }
        this.curr = this.template.makeByStartLength(index, 1);
        this.intervals.push(this.curr);
    };
    SparseIntervalsCollector.prototype.getIntervals = function () {
        return new intervals_1.SparseIntervals(this.intervals);
    };
    return SparseIntervalsCollector;
}());
exports.SparseIntervalsCollector = SparseIntervalsCollector;


/***/ }),

/***/ 448:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SparseIntervals = void 0;
var iterator_1 = __webpack_require__(8094);
var objects_iterator_1 = __webpack_require__(510);
var SparseIntervals = (function () {
    function SparseIntervals(list) {
        if (list === void 0) { list = []; }
        this.list = list;
        this._count = 0;
        this._numIntervals = 0;
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var curr = list_1[_i];
            this._count += curr.length;
            this._numIntervals++;
        }
    }
    Object.defineProperty(SparseIntervals.prototype, "count", {
        get: function () {
            return this._count;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SparseIntervals.prototype, "numIntervals", {
        get: function () {
            return this._numIntervals;
        },
        enumerable: false,
        configurable: true
    });
    SparseIntervals.prototype.getInterval = function (index) {
        return this.list[index];
    };
    SparseIntervals.prototype.getNativeIterator = function () {
        return new iterator_1.SparseIntervalsIterator(this);
    };
    SparseIntervals.prototype.getObjectsIterator = function (objects) {
        return new objects_iterator_1.SparseObjectsIterator(this, objects);
    };
    return SparseIntervals;
}());
exports.SparseIntervals = SparseIntervals;


/***/ }),

/***/ 8094:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SparseIntervalsIterator = void 0;
var SparseIntervalsIterator = (function () {
    function SparseIntervalsIterator(sparseIntervals) {
        this.sparseIntervals = sparseIntervals;
        this.intervalIndex = -1;
    }
    Object.defineProperty(SparseIntervalsIterator.prototype, "isStarted", {
        get: function () {
            return !!this.curr;
        },
        enumerable: false,
        configurable: true
    });
    SparseIntervalsIterator.prototype.moveNext = function () {
        if (this.curr && this.posInInterval + 1 < this.curr.length) {
            this.posInInterval++;
            this.index++;
            this.initObject();
            return true;
        }
        if (this.intervalIndex + 1 < this.sparseIntervals.numIntervals) {
            this.intervalIndex++;
            this.curr = this.sparseIntervals.getInterval(this.intervalIndex);
            if (!this.curr.length)
                return this.moveNext();
            this.posInInterval = 0;
            this.index = this.curr.start;
            this.initObject();
            return true;
        }
        return false;
    };
    SparseIntervalsIterator.prototype.movePrev = function () {
        if (this.curr && this.posInInterval - 1 >= this.curr.start) {
            this.posInInterval--;
            this.index--;
            this.initObject();
            return true;
        }
        if (!this.isStarted)
            this.intervalIndex = this.sparseIntervals.numIntervals;
        if (this.intervalIndex - 1 >= 0) {
            this.intervalIndex--;
            this.curr = this.sparseIntervals.getInterval(this.intervalIndex);
            this.posInInterval = Math.max(this.curr.length - 1, this.curr.start);
            this.index = this.curr.start;
            this.initObject();
            return true;
        }
        return false;
    };
    SparseIntervalsIterator.prototype.initObject = function () { };
    return SparseIntervalsIterator;
}());
exports.SparseIntervalsIterator = SparseIntervalsIterator;


/***/ }),

/***/ 510:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SparseObjectsIterator = void 0;
var tslib_1 = __webpack_require__(655);
var iterator_1 = __webpack_require__(8094);
var SparseObjectsIterator = (function (_super) {
    tslib_1.__extends(SparseObjectsIterator, _super);
    function SparseObjectsIterator(sparseIntervals, objects) {
        var _this = _super.call(this, sparseIntervals) || this;
        _this.objects = objects;
        return _this;
    }
    SparseObjectsIterator.prototype.initObject = function () {
        this.obj = this.objects[this.index];
    };
    return SparseObjectsIterator;
}(iterator_1.SparseIntervalsIterator));
exports.SparseObjectsIterator = SparseObjectsIterator;


/***/ }),

/***/ 6477:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Base64Utils = void 0;
var file_1 = __webpack_require__(2674);
var mime_type_1 = __webpack_require__(4633);
var Base64Utils = (function () {
    function Base64Utils() {
    }
    Base64Utils.normalizeToDataUrl = function (base64, mimeType) {
        if (!Base64Utils.checkPrependDataUrl(base64))
            base64 = Base64Utils.prependByDataUrl(base64, mimeType);
        return base64;
    };
    Base64Utils.prependByDataUrl = function (base64, mimeType) {
        return "data:" + mimeType + ";base64," + base64;
    };
    Base64Utils.checkPrependDataUrl = function (base64) {
        return Base64Utils.dataUrl.test(base64);
    };
    Base64Utils.deleteDataUrlPrefix = function (base64DataUrl) {
        return base64DataUrl.replace(Base64Utils.dataUrl, '');
    };
    Base64Utils.getUint8Array = function (base64) {
        base64 = atob(base64);
        var n = base64.length;
        var arr = new Uint8Array(n);
        while (n--)
            arr[n] = base64.charCodeAt(n);
        return arr;
    };
    Base64Utils.fromArrayBuffer = function (buffer) {
        var binary = [];
        var bytes = new Uint8Array(buffer);
        var len = bytes.byteLength;
        for (var i = 0; i < len; i++)
            binary.push(String.fromCharCode(bytes[i]));
        return window.btoa(binary.join(''));
    };
    Base64Utils.getFileFromBase64 = function (base64, fileName, options) {
        if (fileName === void 0) { fileName = ''; }
        var data = Base64Utils.getUint8Array(base64);
        return file_1.FileUtils.createFile([data], fileName, options);
    };
    Base64Utils.getMimeTypeAsString = function (base64) {
        var match = base64.match(Base64Utils.dataUrl);
        return match ? match[1] : null;
    };
    Base64Utils.getKnownMimeType = function (base64) {
        var match = base64.match(Base64Utils.dataUrl);
        return match ? mime_type_1.MimeTypeUtils.stringTypeToType(match[1]) : mime_type_1.DxMimeType.Unknown;
    };
    Base64Utils.fromBlobAsArrayBuffer = function (blob, callback) {
        var reader = new FileReader();
        reader.onloadend = function () { return callback(Base64Utils.fromArrayBuffer(reader.result)); };
        reader.readAsArrayBuffer(blob);
    };
    Base64Utils.fromBlobAsDataUrl = function (blob, callback) {
        var reader = new FileReader();
        reader.onloadend = function () { return callback(reader.result); };
        reader.readAsDataURL(blob);
    };
    Base64Utils.dataUrl = /^data:(.*?)(;(.*?))??(;base64)?,/;
    return Base64Utils;
}());
exports.Base64Utils = Base64Utils;


/***/ }),

/***/ 13:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColorUtils = void 0;
var string_1 = __webpack_require__(49);
var ColorUtils = (function () {
    function ColorUtils() {
    }
    ColorUtils.getAlpha = function (color) {
        return (color >> 24) & 255;
    };
    ColorUtils.getRed = function (color) {
        return (color >> 16) & 255;
    };
    ColorUtils.getGreen = function (color) {
        return (color >> 8) & 255;
    };
    ColorUtils.getBlue = function (color) {
        return color & 255;
    };
    ColorUtils.redPartToString = function (color) {
        var redStr = ColorUtils.getRed(color).toString(16);
        return redStr.length > 1 ? redStr : '0' + redStr;
    };
    ColorUtils.greenPartToString = function (color) {
        var greenStr = ColorUtils.getGreen(color).toString(16);
        return greenStr.length > 1 ? greenStr : '0' + greenStr;
    };
    ColorUtils.bluePartToString = function (color) {
        var blueStr = ColorUtils.getBlue(color).toString(16);
        return blueStr.length > 1 ? blueStr : '0' + blueStr;
    };
    ColorUtils.fromArgbNumber = function (alpha, red, green, blue) {
        return (alpha << 24) | (red << 16) | (green << 8) | blue;
    };
    ColorUtils.fromRgbaString = function (color, alpha) {
        if (alpha === void 0) { alpha = 255; }
        var matchesRGBA = color.replace(/ +/g, '').match(/(rgba?)|(\d+(\.\d+)?%?)|(\.\d+)/g);
        if (matchesRGBA && matchesRGBA.length > 3) {
            var result = [];
            for (var i = 1, matchItem = void 0; matchItem = matchesRGBA[i]; i++) {
                var item = matchItem.indexOf('%') !== -1 ?
                    Math.round(parseFloat(matchItem) * 2.55) :
                    parseInt(matchItem);
                if (item < 0 || item > 255)
                    return null;
                result.push(item);
            }
            if (color.indexOf('rgba') === 0) {
                if (isNaN(result[3]) || result[3] < 0 || result[3] > 1)
                    return null;
                else if (result[3] <= 1)
                    result[3] = Math.round(result[3] * 255);
            }
            else if (result[3])
                return null;
            return ((result[0] & 255) << 16) | ((result[1] & 255) << 8) | (result[2] & 255) |
                (((result.length > 3 ? result[3] : alpha) & 255) << 24);
        }
        return null;
    };
    ColorUtils.fromHashString = function (hash, alpha) {
        if (alpha === void 0) { alpha = 255; }
        if (!ColorUtils.isHashColorString(hash))
            return null;
        if (hash.charAt(0) === '#')
            hash = hash.substr(1);
        if (hash.length === 3)
            hash = string_1.StringUtils.repeat(hash.charAt(0), 2) + string_1.StringUtils.repeat(hash.charAt(1), 2) + string_1.StringUtils.repeat(hash.charAt(2), 2);
        return parseInt(hash, 16) | (alpha << 24);
    };
    ColorUtils.fromColorName = function (color, alpha) {
        if (alpha === void 0) { alpha = 255; }
        var colorNameAsHash = ColorUtils.colorNames[color.toLowerCase()];
        return colorNameAsHash ? ColorUtils.fromHashString(colorNameAsHash, alpha) : null;
    };
    ColorUtils.fromString = function (color, alpha) {
        if (alpha === void 0) { alpha = 255; }
        var rgbaColor = ColorUtils.fromRgbaString(color, alpha);
        if (rgbaColor !== null)
            return rgbaColor;
        var hashColor = ColorUtils.fromHashString(color, alpha);
        if (hashColor !== null)
            return hashColor;
        return ColorUtils.fromColorName(color, alpha);
    };
    ColorUtils.colorToHash = function (color) {
        return '#' + ColorUtils.redPartToString(color) + ColorUtils.greenPartToString(color) + ColorUtils.bluePartToString(color);
    };
    ColorUtils.stringToHash = function (color) {
        var result = this.fromString(color);
        return result !== null ? this.colorToHash(result) : null;
    };
    ColorUtils.isHashColorString = function (color) {
        return /^#?([0-9a-f]{6})$/i.test(color) || /^#?([0-9a-f]{3})$/i.test(color);
    };
    ColorUtils.isKnownColorName = function (color) {
        return !!ColorUtils.colorNames[color.toLowerCase()];
    };
    ColorUtils.isGray = function (color) {
        var red = ColorUtils.getRed(color);
        return red === ColorUtils.getGreen(color) && red === ColorUtils.getBlue(color);
    };
    ColorUtils.DARK_COLOR = -16777216;
    ColorUtils.LIGHT_COLOR = -1;
    ColorUtils.colorNames = {
        aliceblue: '#f0f8ff', antiquewhite: '#faebd7', aqua: '#00ffff',
        aquamarine: '#7fffd4', azure: '#f0ffff', beige: '#f5f5dc',
        bisque: '#ffe4c4', black: '#000000', blanchedalmond: '#ffebcd',
        blue: '#0000ff', blueviolet: '#8a2be2', brown: '#a52a2a',
        burlywood: '#deb887', cadetblue: '#5f9ea0', chartreuse: '#7fff00',
        chocolate: '#d2691e', coral: '#ff7f50', cornflowerblue: '#6495ed',
        cornsilk: '#fff8dc', crimson: '#dc143c', cyan: '#00ffff',
        darkblue: '#00008b', darkcyan: '#008b8b', darkgoldenrod: '#b8860b',
        darkgray: '#a9a9a9', darkgreen: '#006400', darkkhaki: '#bdb76b',
        darkmagenta: '#8b008b', darkolivegreen: '#556b2f', darkorange: '#ff8c00',
        darkorchid: '#9932cc', darkred: '#8b0000', darksalmon: '#e9967a',
        darkseagreen: '#8fbc8f', darkslateblue: '#483d8b', darkslategray: '#2f4f4f',
        darkturquoise: '#00ced1', darkviolet: '#9400d3', deeppink: '#ff1493',
        deepskyblue: '#00bfff', dimgray: '#696969', dodgerblue: '#1e90ff',
        feldspar: '#d19275', firebrick: '#b22222', floralwhite: '#fffaf0',
        forestgreen: '#228b22', fuchsia: '#ff00ff', gainsboro: '#dcdcdc',
        ghostwhite: '#f8f8ff', gold: '#ffd700', goldenrod: '#daa520', gray: '#808080',
        green: '#00ff00', greenyellow: '#adff2f', honeydew: '#f0fff0', hotpink: '#ff69b4',
        indianred: '#cd5c5c', indigo: '#4b0082', ivory: '#fffff0', khaki: '#f0e68c',
        lavender: '#e6e6fa', lavenderblush: '#fff0f5', lawngreen: '#7cfc00',
        lemonchiffon: '#fffacd', lightblue: '#add8e6', lightcoral: '#f08080',
        lightcyan: '#e0ffff', lightgoldenrodyellow: '#fafad2', lightgray: '#d3d3d3',
        lightgreen: '#90ee90', lightpink: '#ffb6c1', lightsalmon: '#ffa07a',
        lightseagreen: '#20b2aa', lightskyblue: '#87cefa', lightslateblue: '#8470ff',
        lightslategray: '#778899', lightsteelblue: '#b0c4de', lightyellow: '#ffffe0',
        lime: '#00ff00', limegreen: '#32cd32', linen: '#faf0e6', magenta: '#ff00ff',
        maroon: '#800000', mediumaquamarine: '#66cdaa', mediumblue: '#0000cd',
        mediumorchid: '#ba55d3', mediumpurple: '#9370d8', mediumseagreen: '#3cb371',
        mediumslateblue: '#7b68ee', mediumspringgreen: '#00fa9a', mediumturquoise: '#48d1cc',
        mediumvioletred: '#c71585', midnightblue: '#191970', mintcream: '#f5fffa',
        mistyrose: '#ffe4e1', moccasin: '#ffe4b5', navajowhite: '#ffdead', navy: '#000080',
        oldlace: '#fdf5e6', olive: '#808000', olivedrab: '#6b8e23', orange: '#ffa500',
        orangered: '#ff4500', orchid: '#da70d6', palegoldenrod: '#eee8aa', palegreen: '#98fb98',
        paleturquoise: '#afeeee', palevioletred: '#d87093', papayawhip: '#ffefd5',
        peachpuff: '#ffdab9', peru: '#cd853f', pink: '#ffc0cb', plum: '#dda0dd',
        powderblue: '#b0e0e6', purple: '#800080', red: '#ff0000', rosybrown: '#bc8f8f',
        royalblue: '#4169e1', saddlebrown: '#8b4513', salmon: '#fa8072', sandybrown: '#f4a460',
        seagreen: '#2e8b57', seashell: '#fff5ee', sienna: '#a0522d', silver: '#c0c0c0',
        skyblue: '#87ceeb', slateblue: '#6a5acd', slategray: '#708090', snow: '#fffafa',
        springgreen: '#00ff7f', steelblue: '#4682b4', tan: '#d2b48c', teal: '#008080',
        thistle: '#d8bfd8', tomato: '#ff6347', turquoise: '#40e0d0', violet: '#ee82ee',
        violetred: '#d02090', wheat: '#f5deb3', white: '#ffffff', whitesmoke: '#f5f5f5',
        yellow: '#ffff00', yellowgreen: '#9acd32', windowtext: '#000000'
    };
    return ColorUtils;
}());
exports.ColorUtils = ColorUtils;


/***/ }),

/***/ 2491:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.numberToStringHex = exports.numberToStringBin = exports.isOdd = exports.isEven = exports.isNonNullString = exports.isString = exports.isNumber = exports.boolToString = exports.boolToInt = exports.isDefined = void 0;
var string_1 = __webpack_require__(49);
function isDefined(value) {
    return value !== undefined && value !== null;
}
exports.isDefined = isDefined;
function boolToInt(value) {
    return value ? 1 : 0;
}
exports.boolToInt = boolToInt;
function boolToString(value) {
    return value ? '1' : '0';
}
exports.boolToString = boolToString;
function isNumber(obj) {
    return typeof obj === 'number';
}
exports.isNumber = isNumber;
function isString(obj) {
    return typeof obj === 'string';
}
exports.isString = isString;
function isNonNullString(str) {
    return !!str;
}
exports.isNonNullString = isNonNullString;
function isEven(num) {
    return (num % 2) !== 0;
}
exports.isEven = isEven;
function isOdd(num) {
    return (num % 2) === 0;
}
exports.isOdd = isOdd;
function numberToStringBin(num, minLength) {
    if (minLength === void 0) { minLength = 0; }
    return string_1.StringUtils.padLeft(num.toString(2), minLength, '0');
}
exports.numberToStringBin = numberToStringBin;
function numberToStringHex(num, minLength) {
    if (minLength === void 0) { minLength = 0; }
    return string_1.StringUtils.padLeft(num.toString(16), minLength, '0');
}
exports.numberToStringHex = numberToStringHex;


/***/ }),

/***/ 4170:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Equals = exports.Comparers = void 0;
var Comparers = (function () {
    function Comparers() {
    }
    Comparers.number = function (a, b) {
        return a - b;
    };
    Comparers.string = function (a, b) {
        return ((a === b) ? 0 : ((a > b) ? 1 : -1));
    };
    Comparers.stringIgnoreCase = function (a, b) {
        a = a.toLowerCase();
        b = b.toLowerCase();
        return ((a === b) ? 0 : ((a > b) ? 1 : -1));
    };
    return Comparers;
}());
exports.Comparers = Comparers;
var Equals = (function () {
    function Equals() {
    }
    Equals.simpleType = function (a, b) {
        return a === b;
    };
    Equals.object = function (a, b) {
        return a && b && (a === b || a.equals(b));
    };
    return Equals;
}());
exports.Equals = Equals;


/***/ }),

/***/ 6907:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DomUtils = void 0;
var browser_1 = __webpack_require__(9279);
var common_1 = __webpack_require__(2491);
var math_1 = __webpack_require__(8679);
var string_1 = __webpack_require__(49);
var DomUtils = (function () {
    function DomUtils() {
    }
    DomUtils.clearInnerHtml = function (element) {
        while (element.firstChild)
            element.removeChild(element.firstChild);
    };
    DomUtils.setStylePosition = function (style, point) {
        style.left = math_1.MathUtils.round(point.x, 3) + 'px';
        style.top = math_1.MathUtils.round(point.y, 3) + 'px';
    };
    DomUtils.setStyleSize = function (style, size) {
        style.width = math_1.MathUtils.round(size.width, 3) + 'px';
        style.height = math_1.MathUtils.round(size.height, 3) + 'px';
    };
    DomUtils.setStyleSizeAndPosition = function (style, rectangle) {
        DomUtils.setStylePosition(style, rectangle);
        DomUtils.setStyleSize(style, rectangle);
    };
    DomUtils.hideNode = function (node) {
        if (node) {
            var parentNode = node.parentNode;
            if (parentNode)
                parentNode.removeChild(node);
        }
    };
    DomUtils.isHTMLElementNode = function (node) {
        return node.nodeType === Node.ELEMENT_NODE;
    };
    DomUtils.isTextNode = function (node) {
        return node.nodeType === Node.TEXT_NODE;
    };
    DomUtils.isElementNode = function (node) {
        return node.nodeType === Node.ELEMENT_NODE;
    };
    DomUtils.isHTMLTableRowElement = function (element) {
        return element.tagName === 'TR';
    };
    DomUtils.isItParent = function (parentElement, element) {
        if (!parentElement || !element)
            return false;
        while (element) {
            if (element === parentElement)
                return true;
            if (element.tagName === 'BODY')
                return false;
            element = element.parentNode;
        }
        return false;
    };
    DomUtils.getParentByTagName = function (element, tagName) {
        tagName = tagName.toUpperCase();
        while (element) {
            if (element.tagName === 'BODY')
                return null;
            if (element.tagName === tagName)
                return element;
            element = element.parentNode;
        }
        return null;
    };
    DomUtils.getDocumentScrollTop = function () {
        var isScrollBodyIE = browser_1.Browser.IE && DomUtils.getCurrentStyle(document.body).overflow === 'hidden' && document.body.scrollTop > 0;
        if (browser_1.Browser.WebKitFamily || browser_1.Browser.Edge || isScrollBodyIE) {
            if (browser_1.Browser.MacOSMobilePlatform)
                return window.pageYOffset;
            if (browser_1.Browser.WebKitFamily)
                return document.documentElement.scrollTop || document.body.scrollTop;
            return document.body.scrollTop;
        }
        else
            return document.documentElement.scrollTop;
    };
    DomUtils.getDocumentScrollLeft = function () {
        var isScrollBodyIE = browser_1.Browser.IE && DomUtils.getCurrentStyle(document.body).overflow === 'hidden' && document.body.scrollLeft > 0;
        if (browser_1.Browser.Edge || isScrollBodyIE)
            return document.body ? document.body.scrollLeft : document.documentElement.scrollLeft;
        if (browser_1.Browser.WebKitFamily)
            return document.documentElement.scrollLeft || document.body.scrollLeft;
        return document.documentElement.scrollLeft;
    };
    DomUtils.getCurrentStyle = function (element) {
        if (element.currentStyle)
            return element.currentStyle;
        else if (document.defaultView && document.defaultView.getComputedStyle) {
            var result = document.defaultView.getComputedStyle(element, null);
            if (!result && browser_1.Browser.Firefox && window.frameElement) {
                var changes = [];
                var curElement = window.frameElement;
                while (!(result = document.defaultView.getComputedStyle(element, null))) {
                    changes.push([curElement, curElement.style.display]);
                    curElement.style.setProperty('display', 'block', 'important');
                    curElement = curElement.tagName === 'BODY' ? curElement.ownerDocument.defaultView.frameElement : curElement.parentNode;
                }
                result = cloneObject(result);
                for (var ch = void 0, i = 0; ch = changes[i]; i++)
                    ch[0].style.display = ch[1];
                document.body.offsetWidth;
            }
            return result;
        }
        return window.getComputedStyle(element, null);
    };
    DomUtils.setFocus = function (element) {
        function focusCore() {
            try {
                element.focus();
                if (browser_1.Browser.IE && document.activeElement !== element)
                    element.focus();
            }
            catch (e) {
            }
        }
        if (browser_1.Browser.MacOSMobilePlatform)
            focusCore();
        else {
            setTimeout(function () {
                focusCore();
            }, 100);
        }
    };
    DomUtils.hasClassName = function (element, className) {
        try {
            var classNames = className.split(' ');
            var classList = element.classList;
            if (classList) {
                for (var i = classNames.length - 1; i >= 0; i--) {
                    if (!classList.contains(classNames[i]))
                        return false;
                }
            }
            else {
                var elementClassName = element.getAttribute && element.getAttribute('class');
                if (!elementClassName)
                    return false;
                var elementClasses = elementClassName.split(' ');
                for (var i = classNames.length - 1; i >= 0; i--) {
                    if (elementClasses.indexOf(classNames[i]) < 0)
                        return false;
                }
            }
            return true;
        }
        catch (e) {
            return false;
        }
    };
    DomUtils.addClassName = function (element, className) {
        if (!DomUtils.hasClassName(element, className)) {
            var elementClassName = element.getAttribute && element.getAttribute('class');
            element.setAttribute('class', elementClassName === '' ? className : elementClassName + " " + className);
        }
    };
    DomUtils.removeClassName = function (element, className) {
        var elementClassName = element.getAttribute && element.getAttribute('class');
        var updClassName = " " + elementClassName + " ";
        var newClassName = updClassName.replace(" " + className + " ", ' ');
        if (updClassName.length !== newClassName.length)
            element.setAttribute('class', string_1.StringUtils.trim(newClassName));
    };
    DomUtils.toggleClassName = function (element, className, toggle) {
        if (toggle === undefined) {
            if (DomUtils.hasClassName(element, className))
                DomUtils.removeClassName(element, className);
            else
                DomUtils.addClassName(element, className);
        }
        else {
            if (toggle)
                DomUtils.addClassName(element, className);
            else
                DomUtils.removeClassName(element, className);
        }
    };
    DomUtils.pxToInt = function (px) {
        return pxToNumber(px, parseInt);
    };
    DomUtils.pxToFloat = function (px) {
        return pxToNumber(px, parseFloat);
    };
    DomUtils.getAbsolutePositionY = function (element) {
        function getAbsolutePositionY_IE(element) {
            return browser_1.Browser.IE && element.parentNode === null ?
                0 :
                element.getBoundingClientRect().top + DomUtils.getDocumentScrollTop();
        }
        function getAbsolutePositionY_FF3(element) {
            return Math.round(element.getBoundingClientRect().top + DomUtils.getDocumentScrollTop());
        }
        function getAbsolutePositionY_NS(curEl) {
            var pos = getAbsoluteScrollOffset_OperaFF(curEl, false);
            var isFirstCycle = true;
            while (curEl != null) {
                pos += curEl.offsetTop;
                if (!isFirstCycle && curEl.offsetParent != null)
                    pos -= curEl.scrollTop;
                if (!isFirstCycle && browser_1.Browser.Firefox) {
                    var style = DomUtils.getCurrentStyle(curEl);
                    if (curEl.tagName === 'DIV' && style.overflow !== 'visible')
                        pos += DomUtils.pxToInt(style.borderTopWidth);
                }
                isFirstCycle = false;
                curEl = curEl.offsetParent;
            }
            return pos;
        }
        function getAbsolutePositionY_Other(curEl) {
            var pos = 0;
            var isFirstCycle = true;
            while (curEl != null) {
                pos += curEl.offsetTop;
                if (!isFirstCycle && curEl.offsetParent != null)
                    pos -= curEl.scrollTop;
                isFirstCycle = false;
                curEl = curEl.offsetParent;
            }
            return pos;
        }
        if (!element)
            return 0;
        if (browser_1.Browser.IE)
            return getAbsolutePositionY_IE(element);
        else if (browser_1.Browser.Firefox && browser_1.Browser.Version >= 3)
            return getAbsolutePositionY_FF3(element);
        else if (browser_1.Browser.NetscapeFamily && (!browser_1.Browser.Firefox || browser_1.Browser.Version < 3))
            return getAbsolutePositionY_NS(element);
        else if (browser_1.Browser.WebKitFamily || browser_1.Browser.Edge)
            return getAbsolutePositionY_FF3(element);
        return getAbsolutePositionY_Other(element);
    };
    DomUtils.getAbsolutePositionX = function (element) {
        function getAbsolutePositionX_IE(element) {
            return browser_1.Browser.IE && element.parentNode === null ?
                0 :
                element.getBoundingClientRect().left + DomUtils.getDocumentScrollLeft();
        }
        function getAbsolutePositionX_FF3(element) {
            return Math.round(element.getBoundingClientRect().left + DomUtils.getDocumentScrollLeft());
        }
        function getAbsolutePositionX_Opera(curEl) {
            var isFirstCycle = true;
            var pos = getAbsoluteScrollOffset_OperaFF(curEl, true);
            while (curEl != null) {
                pos += curEl.offsetLeft;
                if (!isFirstCycle)
                    pos -= curEl.scrollLeft;
                curEl = curEl.offsetParent;
                isFirstCycle = false;
            }
            pos += document.body.scrollLeft;
            return pos;
        }
        function getAbsolutePositionX_NS(curEl) {
            var pos = getAbsoluteScrollOffset_OperaFF(curEl, true);
            var isFirstCycle = true;
            while (curEl != null) {
                pos += curEl.offsetLeft;
                if (!isFirstCycle && curEl.offsetParent != null)
                    pos -= curEl.scrollLeft;
                if (!isFirstCycle && browser_1.Browser.Firefox) {
                    var style = DomUtils.getCurrentStyle(curEl);
                    if (curEl.tagName === 'DIV' && style.overflow !== 'visible')
                        pos += DomUtils.pxToInt(style.borderLeftWidth);
                }
                isFirstCycle = false;
                curEl = curEl.offsetParent;
            }
            return pos;
        }
        function getAbsolutePositionX_Other(curEl) {
            var pos = 0;
            var isFirstCycle = true;
            while (curEl != null) {
                pos += curEl.offsetLeft;
                if (!isFirstCycle && curEl.offsetParent != null)
                    pos -= curEl.scrollLeft;
                isFirstCycle = false;
                curEl = curEl.offsetParent;
            }
            return pos;
        }
        if (!element)
            return 0;
        if (browser_1.Browser.IE)
            return getAbsolutePositionX_IE(element);
        else if (browser_1.Browser.Firefox && browser_1.Browser.Version >= 3)
            return getAbsolutePositionX_FF3(element);
        else if (browser_1.Browser.Opera && browser_1.Browser.Version <= 12)
            return getAbsolutePositionX_Opera(element);
        else if (browser_1.Browser.NetscapeFamily && (!browser_1.Browser.Firefox || browser_1.Browser.Version < 3))
            return getAbsolutePositionX_NS(element);
        else if (browser_1.Browser.WebKitFamily || browser_1.Browser.Edge)
            return getAbsolutePositionX_FF3(element);
        else
            return getAbsolutePositionX_Other(element);
    };
    DomUtils.isInteractiveControl = function (element) {
        return ['A', 'INPUT', 'SELECT', 'OPTION', 'TEXTAREA', 'BUTTON', 'IFRAME'].indexOf(element.tagName) > -1;
    };
    DomUtils.getClearClientHeight = function (element) {
        return element.offsetHeight - (DomUtils.getTopBottomPaddings(element) + DomUtils.getVerticalBordersWidth(element));
    };
    DomUtils.getTopBottomPaddings = function (element, style) {
        var currentStyle = style ? style : DomUtils.getCurrentStyle(element);
        return DomUtils.pxToInt(currentStyle.paddingTop) + DomUtils.pxToInt(currentStyle.paddingBottom);
    };
    DomUtils.getVerticalBordersWidth = function (element, style) {
        if (!common_1.isDefined(style))
            style = (browser_1.Browser.IE && browser_1.Browser.MajorVersion !== 9 && window.getComputedStyle) ? window.getComputedStyle(element) : DomUtils.getCurrentStyle(element);
        var res = 0;
        if (style.borderTopStyle !== 'none')
            res += DomUtils.pxToFloat(style.borderTopWidth);
        if (style.borderBottomStyle !== 'none')
            res += DomUtils.pxToFloat(style.borderBottomWidth);
        return res;
    };
    DomUtils.getNodes = function (parent, predicate) {
        var collection = parent.all || parent.getElementsByTagName('*');
        var result = [];
        for (var i = 0; i < collection.length; i++) {
            var element = collection[i];
            if (predicate(element))
                result.push(element);
        }
        return result;
    };
    DomUtils.getChildNodes = function (parent, predicate) {
        var collection = parent.childNodes;
        var result = [];
        for (var i = 0; i < collection.length; i++) {
            var element = collection[i];
            if (predicate(element))
                result.push(element);
        }
        return result;
    };
    DomUtils.getNodesByClassName = function (parent, className) {
        if (parent.querySelectorAll) {
            var children = parent.querySelectorAll("." + className);
            var result_1 = [];
            children.forEach(function (element) { return result_1.push(element); });
            return result_1;
        }
        else
            return DomUtils.getNodes(parent, function (elem) { return DomUtils.hasClassName(elem, className); });
    };
    DomUtils.getChildNodesByClassName = function (parent, className) {
        function nodeListToArray(nodeList, filter) {
            var result = [];
            for (var i = 0; i < nodeList.length; i++) {
                var element = nodeList[i];
                if (filter(element))
                    result.push(element);
            }
            return result;
        }
        if (parent.querySelectorAll) {
            var children = parent.querySelectorAll("." + className);
            return nodeListToArray(children, function (element) { return element.parentNode === parent; });
        }
        else {
            return DomUtils.getChildNodes(parent, function (elem) {
                if (DomUtils.isElementNode(elem))
                    return common_1.isNonNullString(elem.className) && DomUtils.hasClassName(elem, elem.className);
                else
                    return false;
            });
        }
    };
    DomUtils.getVerticalScrollBarWidth = function () {
        if (DomUtils.verticalScrollBarWidth === undefined) {
            var container = document.createElement('DIV');
            container.style.cssText = 'position: absolute; top: 0px; left: 0px; visibility: hidden; width: 200px; height: 150px; overflow: hidden; box-sizing: content-box';
            document.body.appendChild(container);
            var child = document.createElement('P');
            container.appendChild(child);
            child.style.cssText = 'width: 100%; height: 200px;';
            var widthWithoutScrollBar = child.offsetWidth;
            container.style.overflow = 'scroll';
            var widthWithScrollBar = child.offsetWidth;
            if (widthWithoutScrollBar === widthWithScrollBar)
                widthWithScrollBar = container.clientWidth;
            DomUtils.verticalScrollBarWidth = widthWithoutScrollBar - widthWithScrollBar;
            document.body.removeChild(container);
        }
        return DomUtils.verticalScrollBarWidth;
    };
    DomUtils.getHorizontalBordersWidth = function (element, style) {
        if (!common_1.isDefined(style))
            style = (browser_1.Browser.IE && window.getComputedStyle) ? window.getComputedStyle(element) : DomUtils.getCurrentStyle(element);
        var res = 0;
        if (style.borderLeftStyle !== 'none')
            res += DomUtils.pxToFloat(style.borderLeftWidth);
        if (style.borderRightStyle !== 'none')
            res += DomUtils.pxToFloat(style.borderRightWidth);
        return res;
    };
    DomUtils.getFontFamiliesFromCssString = function (cssString) {
        return cssString.split(',').map(function (fam) { return string_1.StringUtils.trim(fam.replace(/'|"/gi, '')); });
    };
    DomUtils.getInnerText = function (container) {
        if (browser_1.Browser.Safari && browser_1.Browser.MajorVersion <= 5) {
            if (DomUtils.html2PlainTextFilter === null) {
                DomUtils.html2PlainTextFilter = document.createElement('DIV');
                DomUtils.html2PlainTextFilter.style.width = '0';
                DomUtils.html2PlainTextFilter.style.height = '0';
                DomUtils.html2PlainTextFilter.style.overflow = 'visible';
                DomUtils.html2PlainTextFilter.style.display = 'none';
                document.body.appendChild(DomUtils.html2PlainTextFilter);
            }
            var filter = DomUtils.html2PlainTextFilter;
            filter.innerHTML = container.innerHTML;
            filter.style.display = '';
            var innerText = filter.innerText;
            filter.style.display = 'none';
            return innerText;
        }
        else if (browser_1.Browser.NetscapeFamily || browser_1.Browser.WebKitFamily || (browser_1.Browser.IE && browser_1.Browser.Version >= 9) || browser_1.Browser.Edge)
            return container.textContent;
        else
            return container.innerText;
    };
    DomUtils.html2PlainTextFilter = null;
    DomUtils.verticalScrollBarWidth = undefined;
    return DomUtils;
}());
exports.DomUtils = DomUtils;
function cloneObject(srcObject) {
    if (typeof (srcObject) !== 'object' || !common_1.isDefined(srcObject))
        return srcObject;
    var newObject = {};
    for (var i in srcObject)
        newObject[i] = srcObject[i];
    return newObject;
}
function pxToNumber(px, parseFunction) {
    var result = 0;
    if (common_1.isDefined(px) && px !== '') {
        try {
            var indexOfPx = px.indexOf('px');
            if (indexOfPx > -1)
                result = parseFunction(px.substr(0, indexOfPx));
        }
        catch (e) { }
    }
    return result;
}
function getAbsoluteScrollOffset_OperaFF(curEl, isX) {
    var pos = 0;
    var isFirstCycle = true;
    while (curEl != null) {
        if (curEl.tagName === 'BODY')
            break;
        var style = DomUtils.getCurrentStyle(curEl);
        if (style.position === 'absolute')
            break;
        if (!isFirstCycle && curEl.tagName === 'DIV' && (style.position === '' || style.position === 'static'))
            pos -= isX ? curEl.scrollLeft : curEl.scrollTop;
        curEl = curEl.parentNode;
        isFirstCycle = false;
    }
    return pos;
}


/***/ }),

/***/ 9712:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EncodeUtils = void 0;
var EncodeUtils = (function () {
    function EncodeUtils() {
    }
    EncodeUtils.encodeHtml = function (text) {
        return text
            .replace(/&/g, '&amp;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;');
    };
    EncodeUtils.decodeHtml = function (text) {
        return text
            .replace(/&amp;/g, '&')
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>');
    };
    EncodeUtils.prepareTextForRequest = function (text) {
        return text
            .replace(/%/g, '%25')
            .replace(/&/g, '%26amp;')
            .replace(/\+/g, '%2B')
            .replace(/</g, '%26lt;')
            .replace(/>/g, '%26gt;')
            .replace(/"/g, '%26quot;');
    };
    EncodeUtils.prepareTextForCallBackRequest = function (text) {
        return text
            .replace(/&/g, '&amp;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;')
            .replace(/"/g, '&quot;');
    };
    EncodeUtils.decodeViaTextArea = function (html) {
        var textArea = document.createElement('TEXTAREA');
        textArea.innerHTML = html;
        return textArea.value;
    };
    return EncodeUtils;
}());
exports.EncodeUtils = EncodeUtils;


/***/ }),

/***/ 3714:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EvtUtils = void 0;
var browser_1 = __webpack_require__(9279);
var common_1 = __webpack_require__(2491);
var dom_1 = __webpack_require__(6907);
var touch_1 = __webpack_require__(1632);
var EvtUtils = (function () {
    function EvtUtils() {
    }
    EvtUtils.preventEvent = function (evt) {
        if (!evt.cancelable)
            return;
        if (evt.preventDefault)
            evt.preventDefault();
        else
            evt.returnValue = false;
    };
    EvtUtils.getEventSource = function (evt) {
        return common_1.isDefined(evt) ? EvtUtils.getEventSourceCore(evt) : null;
    };
    EvtUtils.getEventSourceByPosition = function (evt) {
        if (!common_1.isDefined(evt))
            return null;
        if (!document.elementFromPoint)
            return EvtUtils.getEventSourceCore(evt);
        var clientX = EvtUtils.getEventX(evt) - (EvtUtils.clientEventRequiresDocScrollCorrection() ? dom_1.DomUtils.getDocumentScrollLeft() : 0);
        var clientY = EvtUtils.getEventY(evt) - (EvtUtils.clientEventRequiresDocScrollCorrection() ? dom_1.DomUtils.getDocumentScrollTop() : 0);
        if (clientX === undefined || clientY === undefined)
            return EvtUtils.getEventSourceCore(evt);
        return document.elementFromPoint(clientX, clientY);
    };
    EvtUtils.getEventSourceCore = function (evt) {
        return evt.srcElement ? evt.srcElement : evt.target;
    };
    EvtUtils.getMouseWheelEventName = function () {
        if (browser_1.Browser.Safari)
            return 'mousewheel';
        if (browser_1.Browser.NetscapeFamily && browser_1.Browser.MajorVersion < 17)
            return 'DOMMouseScroll';
        return 'wheel';
    };
    EvtUtils.isLeftButtonPressed = function (evt) {
        if (touch_1.TouchUtils.isTouchEvent(evt))
            return true;
        evt = (browser_1.Browser.IE && common_1.isDefined(event)) ? event : evt;
        if (!evt)
            return false;
        if (browser_1.Browser.IE && browser_1.Browser.Version < 11)
            return browser_1.Browser.MSTouchUI ? true : evt.button % 2 === 1;
        if (browser_1.Browser.WebKitFamily)
            return (evt.type === 'pointermove' || evt.type === 'pointerenter' || evt.type === 'pointerleave') ? evt.buttons === 1 : evt.which === 1;
        if (browser_1.Browser.NetscapeFamily || browser_1.Browser.Edge || (browser_1.Browser.IE && browser_1.Browser.Version >= 11))
            return EvtUtils.isMoveEventName(evt.type) ? evt.buttons === 1 : evt.which === 1;
        return browser_1.Browser.Opera ? evt.button === 0 : true;
    };
    EvtUtils.isMoveEventName = function (type) {
        return type === touch_1.TouchUtils.touchMouseMoveEventName || type === EvtUtils.getMoveEventName();
    };
    EvtUtils.getMoveEventName = function () {
        return window.PointerEvent ? 'pointermove' : (browser_1.Browser.TouchUI ? 'touchmove' : 'mousemove');
    };
    EvtUtils.preventEventAndBubble = function (evt) {
        EvtUtils.preventEvent(evt);
        if (evt.stopPropagation)
            evt.stopPropagation();
        evt.cancelBubble = true;
    };
    EvtUtils.clientEventRequiresDocScrollCorrection = function () {
        var isSafariVerLess3 = browser_1.Browser.Safari && browser_1.Browser.Version < 3;
        var isMacOSMobileVerLess51 = browser_1.Browser.MacOSMobilePlatform && browser_1.Browser.Version < 5.1;
        return browser_1.Browser.AndroidDefaultBrowser || browser_1.Browser.AndroidChromeBrowser || !(isSafariVerLess3 || isMacOSMobileVerLess51);
    };
    EvtUtils.getEventX = function (evt) {
        if (touch_1.TouchUtils.isTouchEvent(evt))
            return touch_1.TouchUtils.getEventX(evt);
        return evt.clientX + (EvtUtils.clientEventRequiresDocScrollCorrection() ? dom_1.DomUtils.getDocumentScrollLeft() : 0);
    };
    EvtUtils.getEventY = function (evt) {
        if (touch_1.TouchUtils.isTouchEvent(evt))
            return touch_1.TouchUtils.getEventY(evt);
        return evt.clientY + (EvtUtils.clientEventRequiresDocScrollCorrection() ? dom_1.DomUtils.getDocumentScrollTop() : 0);
    };
    EvtUtils.cancelBubble = function (evt) {
        evt.cancelBubble = true;
    };
    EvtUtils.getWheelDelta = function (evt) {
        var ret;
        if (browser_1.Browser.NetscapeFamily && browser_1.Browser.MajorVersion < 17)
            ret = -evt.detail;
        else if (browser_1.Browser.Safari)
            ret = evt.wheelDelta;
        else
            ret = -evt.deltaY;
        if (browser_1.Browser.Opera && browser_1.Browser.Version < 9)
            ret = -ret;
        return ret;
    };
    return EvtUtils;
}());
exports.EvtUtils = EvtUtils;


/***/ }),

/***/ 2674:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileUtils = void 0;
var browser_1 = __webpack_require__(9279);
var base64_1 = __webpack_require__(6477);
var common_1 = __webpack_require__(2491);
var FileUtils = (function () {
    function FileUtils() {
    }
    FileUtils.loadJavascriptFile = function (srcUri, callback) {
        var _a;
        var headElem = document.getElementsByTagName('head')[0];
        if (!headElem) {
            headElem = document.createElement('head');
            var bodyElem = document.getElementsByTagName('body')[0];
            (_a = bodyElem.parentNode) === null || _a === void 0 ? void 0 : _a.insertBefore(headElem, bodyElem);
        }
        var scriptElem = document.createElement('script');
        scriptElem.onload = callback;
        scriptElem.src = srcUri;
        headElem.appendChild(scriptElem);
        return { htmlScriptElement: scriptElem };
    };
    FileUtils.startDownloadFileLocal = function (content, fileName) {
        if (content instanceof ArrayBuffer)
            content = base64_1.Base64Utils.fromArrayBuffer(content);
        if (common_1.isString(content))
            content = base64_1.Base64Utils.getFileFromBase64(content);
        if (window.navigator.msSaveOrOpenBlob)
            window.navigator.msSaveOrOpenBlob(content, fileName);
        else {
            var a_1 = document.createElement('a');
            var url_1 = URL.createObjectURL(content);
            a_1.href = url_1;
            a_1.download = fileName;
            document.body.appendChild(a_1);
            a_1.click();
            setTimeout(function () {
                document.body.removeChild(a_1);
                window.URL.revokeObjectURL(url_1);
            }, 0);
        }
    };
    FileUtils.createFile = function (fileBits, fileName, options) {
        var _a;
        if (browser_1.Browser.IE || browser_1.Browser.Edge && browser_1.Browser.MajorVersion < 86) {
            var blob = new Blob(fileBits, options);
            blob['lastModifiedDate'] = (_a = options === null || options === void 0 ? void 0 : options.lastModified) !== null && _a !== void 0 ? _a : Date.now();
            blob['name'] = fileName;
            return blob;
        }
        else
            return new File(fileBits, fileName, options);
    };
    FileUtils.isFile = function (file) {
        if (browser_1.Browser.IE || browser_1.Browser.Edge && browser_1.Browser.MajorVersion < 86)
            return (file instanceof File) || (file instanceof Blob && common_1.isDefined(file.name));
        else
            return file instanceof File;
    };
    return FileUtils;
}());
exports.FileUtils = FileUtils;


/***/ }),

/***/ 2153:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KeyCode = exports.ModifierKey = exports.KeyUtils = void 0;
var browser_1 = __webpack_require__(9279);
var encode_1 = __webpack_require__(9712);
var string_1 = __webpack_require__(49);
var KeyUtils = (function () {
    function KeyUtils() {
    }
    KeyUtils.getKeyModifiers = function (evt) {
        var result = 0;
        if (evt.altKey)
            result |= ModifierKey.Alt;
        if (evt.ctrlKey)
            result |= ModifierKey.Ctrl;
        if (evt.shiftKey)
            result |= ModifierKey.Shift;
        if (evt.metaKey)
            result |= ModifierKey.Meta;
        return result;
    };
    KeyUtils.getShortcutCode = function (keyCode, isCtrlKey, isShiftKey, isAltKey, isMetaKey) {
        var value = keyCode;
        value |= isCtrlKey ? ModifierKey.Ctrl : 0;
        value |= isShiftKey ? ModifierKey.Shift : 0;
        value |= isAltKey ? ModifierKey.Alt : 0;
        value |= isMetaKey ? ModifierKey.Meta : 0;
        return value;
    };
    KeyUtils.getShortcutCodeByEvent = function (evt) {
        return KeyUtils.getShortcutCode(KeyUtils.getEventKeyCode(evt), evt.ctrlKey, evt.shiftKey, evt.altKey, browser_1.Browser.MacOSPlatform ? evt.metaKey : false);
    };
    KeyUtils.getEventKeyCode = function (evt) {
        return browser_1.Browser.NetscapeFamily || browser_1.Browser.Opera ? evt.which : evt.keyCode;
    };
    KeyUtils.parseShortcutString = function (shortcutString) {
        if (!shortcutString)
            return 0;
        var isCtrlKey = false;
        var isShiftKey = false;
        var isAltKey = false;
        var isMetaKey = false;
        var keyCode = null;
        var shcKeys = shortcutString.toString().split('+');
        if (shcKeys.length > 0) {
            for (var i = 0; i < shcKeys.length; i++) {
                var key = string_1.StringUtils.trim(shcKeys[i].toUpperCase());
                switch (key) {
                    case 'CONTROL':
                    case 'CONTROLKEY':
                    case 'CTRL':
                        isCtrlKey = true;
                        break;
                    case 'SHIFT':
                    case 'SHIFTKEY':
                        isShiftKey = true;
                        break;
                    case 'ALT':
                        isAltKey = true;
                        break;
                    case 'CMD':
                        isMetaKey = true;
                        break;
                    case 'F1':
                        keyCode = KeyCode.F1;
                        break;
                    case 'F2':
                        keyCode = KeyCode.F2;
                        break;
                    case 'F3':
                        keyCode = KeyCode.F3;
                        break;
                    case 'F4':
                        keyCode = KeyCode.F4;
                        break;
                    case 'F5':
                        keyCode = KeyCode.F5;
                        break;
                    case 'F6':
                        keyCode = KeyCode.F6;
                        break;
                    case 'F7':
                        keyCode = KeyCode.F7;
                        break;
                    case 'F8':
                        keyCode = KeyCode.F8;
                        break;
                    case 'F9':
                        keyCode = KeyCode.F9;
                        break;
                    case 'F10':
                        keyCode = KeyCode.F10;
                        break;
                    case 'F11':
                        keyCode = KeyCode.F11;
                        break;
                    case 'F12':
                        keyCode = KeyCode.F12;
                        break;
                    case 'RETURN':
                    case 'ENTER':
                        keyCode = KeyCode.Enter;
                        break;
                    case 'HOME':
                        keyCode = KeyCode.Home;
                        break;
                    case 'END':
                        keyCode = KeyCode.End;
                        break;
                    case 'LEFT':
                        keyCode = KeyCode.Left;
                        break;
                    case 'RIGHT':
                        keyCode = KeyCode.Right;
                        break;
                    case 'UP':
                        keyCode = KeyCode.Up;
                        break;
                    case 'DOWN':
                        keyCode = KeyCode.Down;
                        break;
                    case 'PAGEUP':
                        keyCode = KeyCode.PageUp;
                        break;
                    case 'PAGEDOWN':
                        keyCode = KeyCode.PageDown;
                        break;
                    case 'SPACE':
                        keyCode = KeyCode.Space;
                        break;
                    case 'TAB':
                        keyCode = KeyCode.Tab;
                        break;
                    case 'BACKSPACE':
                    case 'BACK':
                        keyCode = KeyCode.Backspace;
                        break;
                    case 'CONTEXT':
                        keyCode = KeyCode.ContextMenu;
                        break;
                    case 'ESCAPE':
                    case 'ESC':
                        keyCode = KeyCode.Esc;
                        break;
                    case 'DELETE':
                    case 'DEL':
                        keyCode = KeyCode.Delete;
                        break;
                    case 'INSERT':
                    case 'INS':
                        keyCode = KeyCode.Insert;
                        break;
                    case 'PLUS':
                        keyCode = '+'.charCodeAt(0);
                        break;
                    default:
                        keyCode = key.charCodeAt(0);
                        break;
                }
            }
        }
        else
            alert(encode_1.EncodeUtils.decodeViaTextArea('Invalid shortcut'));
        return KeyUtils.getShortcutCode(keyCode, isCtrlKey, isShiftKey, isAltKey, isMetaKey);
    };
    return KeyUtils;
}());
exports.KeyUtils = KeyUtils;
var ModifierKey;
(function (ModifierKey) {
    ModifierKey[ModifierKey["None"] = 0] = "None";
    ModifierKey[ModifierKey["Ctrl"] = 65536] = "Ctrl";
    ModifierKey[ModifierKey["Shift"] = 262144] = "Shift";
    ModifierKey[ModifierKey["Alt"] = 1048576] = "Alt";
    ModifierKey[ModifierKey["Meta"] = 16777216] = "Meta";
})(ModifierKey = exports.ModifierKey || (exports.ModifierKey = {}));
var KeyCode;
(function (KeyCode) {
    KeyCode[KeyCode["Backspace"] = 8] = "Backspace";
    KeyCode[KeyCode["Tab"] = 9] = "Tab";
    KeyCode[KeyCode["Enter"] = 13] = "Enter";
    KeyCode[KeyCode["Pause"] = 19] = "Pause";
    KeyCode[KeyCode["CapsLock"] = 20] = "CapsLock";
    KeyCode[KeyCode["Esc"] = 27] = "Esc";
    KeyCode[KeyCode["Space"] = 32] = "Space";
    KeyCode[KeyCode["PageUp"] = 33] = "PageUp";
    KeyCode[KeyCode["PageDown"] = 34] = "PageDown";
    KeyCode[KeyCode["End"] = 35] = "End";
    KeyCode[KeyCode["Home"] = 36] = "Home";
    KeyCode[KeyCode["Left"] = 37] = "Left";
    KeyCode[KeyCode["Up"] = 38] = "Up";
    KeyCode[KeyCode["Right"] = 39] = "Right";
    KeyCode[KeyCode["Down"] = 40] = "Down";
    KeyCode[KeyCode["Insert"] = 45] = "Insert";
    KeyCode[KeyCode["Delete"] = 46] = "Delete";
    KeyCode[KeyCode["Key_0"] = 48] = "Key_0";
    KeyCode[KeyCode["Key_1"] = 49] = "Key_1";
    KeyCode[KeyCode["Key_2"] = 50] = "Key_2";
    KeyCode[KeyCode["Key_3"] = 51] = "Key_3";
    KeyCode[KeyCode["Key_4"] = 52] = "Key_4";
    KeyCode[KeyCode["Key_5"] = 53] = "Key_5";
    KeyCode[KeyCode["Key_6"] = 54] = "Key_6";
    KeyCode[KeyCode["Key_7"] = 55] = "Key_7";
    KeyCode[KeyCode["Key_8"] = 56] = "Key_8";
    KeyCode[KeyCode["Key_9"] = 57] = "Key_9";
    KeyCode[KeyCode["Key_a"] = 65] = "Key_a";
    KeyCode[KeyCode["Key_b"] = 66] = "Key_b";
    KeyCode[KeyCode["Key_c"] = 67] = "Key_c";
    KeyCode[KeyCode["Key_d"] = 68] = "Key_d";
    KeyCode[KeyCode["Key_e"] = 69] = "Key_e";
    KeyCode[KeyCode["Key_f"] = 70] = "Key_f";
    KeyCode[KeyCode["Key_g"] = 71] = "Key_g";
    KeyCode[KeyCode["Key_h"] = 72] = "Key_h";
    KeyCode[KeyCode["Key_i"] = 73] = "Key_i";
    KeyCode[KeyCode["Key_j"] = 74] = "Key_j";
    KeyCode[KeyCode["Key_k"] = 75] = "Key_k";
    KeyCode[KeyCode["Key_l"] = 76] = "Key_l";
    KeyCode[KeyCode["Key_m"] = 77] = "Key_m";
    KeyCode[KeyCode["Key_n"] = 78] = "Key_n";
    KeyCode[KeyCode["Key_o"] = 79] = "Key_o";
    KeyCode[KeyCode["Key_p"] = 80] = "Key_p";
    KeyCode[KeyCode["Key_q"] = 81] = "Key_q";
    KeyCode[KeyCode["Key_r"] = 82] = "Key_r";
    KeyCode[KeyCode["Key_s"] = 83] = "Key_s";
    KeyCode[KeyCode["Key_t"] = 84] = "Key_t";
    KeyCode[KeyCode["Key_u"] = 85] = "Key_u";
    KeyCode[KeyCode["Key_v"] = 86] = "Key_v";
    KeyCode[KeyCode["Key_w"] = 87] = "Key_w";
    KeyCode[KeyCode["Key_x"] = 88] = "Key_x";
    KeyCode[KeyCode["Key_y"] = 89] = "Key_y";
    KeyCode[KeyCode["Key_z"] = 90] = "Key_z";
    KeyCode[KeyCode["Windows"] = 91] = "Windows";
    KeyCode[KeyCode["ContextMenu"] = 93] = "ContextMenu";
    KeyCode[KeyCode["Numpad_0"] = 96] = "Numpad_0";
    KeyCode[KeyCode["Numpad_1"] = 97] = "Numpad_1";
    KeyCode[KeyCode["Numpad_2"] = 98] = "Numpad_2";
    KeyCode[KeyCode["Numpad_3"] = 99] = "Numpad_3";
    KeyCode[KeyCode["Numpad_4"] = 100] = "Numpad_4";
    KeyCode[KeyCode["Numpad_5"] = 101] = "Numpad_5";
    KeyCode[KeyCode["Numpad_6"] = 102] = "Numpad_6";
    KeyCode[KeyCode["Numpad_7"] = 103] = "Numpad_7";
    KeyCode[KeyCode["Numpad_8"] = 104] = "Numpad_8";
    KeyCode[KeyCode["Numpad_9"] = 105] = "Numpad_9";
    KeyCode[KeyCode["Multiply"] = 106] = "Multiply";
    KeyCode[KeyCode["Add"] = 107] = "Add";
    KeyCode[KeyCode["Subtract"] = 109] = "Subtract";
    KeyCode[KeyCode["Decimal"] = 110] = "Decimal";
    KeyCode[KeyCode["Divide"] = 111] = "Divide";
    KeyCode[KeyCode["F1"] = 112] = "F1";
    KeyCode[KeyCode["F2"] = 113] = "F2";
    KeyCode[KeyCode["F3"] = 114] = "F3";
    KeyCode[KeyCode["F4"] = 115] = "F4";
    KeyCode[KeyCode["F5"] = 116] = "F5";
    KeyCode[KeyCode["F6"] = 117] = "F6";
    KeyCode[KeyCode["F7"] = 118] = "F7";
    KeyCode[KeyCode["F8"] = 119] = "F8";
    KeyCode[KeyCode["F9"] = 120] = "F9";
    KeyCode[KeyCode["F10"] = 121] = "F10";
    KeyCode[KeyCode["F11"] = 122] = "F11";
    KeyCode[KeyCode["F12"] = 123] = "F12";
    KeyCode[KeyCode["NumLock"] = 144] = "NumLock";
    KeyCode[KeyCode["ScrollLock"] = 145] = "ScrollLock";
    KeyCode[KeyCode["Semicolon"] = 186] = "Semicolon";
    KeyCode[KeyCode["Equals"] = 187] = "Equals";
    KeyCode[KeyCode["Comma"] = 188] = "Comma";
    KeyCode[KeyCode["Dash"] = 189] = "Dash";
    KeyCode[KeyCode["Period"] = 190] = "Period";
    KeyCode[KeyCode["ForwardSlash"] = 191] = "ForwardSlash";
    KeyCode[KeyCode["GraveAccent"] = 192] = "GraveAccent";
    KeyCode[KeyCode["OpenBracket"] = 219] = "OpenBracket";
    KeyCode[KeyCode["BackSlash"] = 220] = "BackSlash";
    KeyCode[KeyCode["CloseBracket"] = 221] = "CloseBracket";
    KeyCode[KeyCode["SingleQuote"] = 222] = "SingleQuote";
})(KeyCode = exports.KeyCode || (exports.KeyCode = {}));


/***/ }),

/***/ 2940:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ListUtils = void 0;
var min_max_1 = __webpack_require__(6799);
var comparers_1 = __webpack_require__(4170);
var ListUtils = (function () {
    function ListUtils() {
    }
    ListUtils.remove = function (list, element) {
        var index = list.indexOf(element, 0);
        if (index >= 0)
            list.splice(index, 1);
    };
    ListUtils.removeBy = function (list, callback) {
        var len = list.length;
        for (var index = 0; index < len; index++) {
            if (callback(list[index], index))
                return list.splice(index, 1)[0];
        }
        return null;
    };
    ListUtils.shallowCopy = function (list) {
        return list.slice();
    };
    ListUtils.deepCopy = function (list) {
        return ListUtils.map(list, function (val) { return val.clone(); });
    };
    ListUtils.initByValue = function (numElements, initValue) {
        var result = [];
        for (; numElements > 0; numElements--)
            result.push(initValue);
        return result;
    };
    ListUtils.initByCallback = function (numElements, initCallback) {
        var result = [];
        for (var index = 0; index < numElements; index++)
            result.push(initCallback(index));
        return result;
    };
    ListUtils.forEachOnInterval = function (interval, callback) {
        var end = interval.end;
        for (var index = interval.start; index < end; index++)
            callback(index);
    };
    ListUtils.reverseForEachOnInterval = function (interval, callback) {
        var start = interval.start;
        for (var index = interval.end - 1; index >= start; index--)
            callback(index);
    };
    ListUtils.reducedMap = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var result = [];
        for (var index = startIndex; index < endIndex; index++) {
            var newItem = callback(list[index], index);
            if (newItem !== null)
                result.push(newItem);
        }
        return result;
    };
    ListUtils.filter = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var result = [];
        for (var index = startIndex; index < endIndex; index++) {
            var item = list[index];
            if (callback(item, index))
                result.push(item);
        }
        return result;
    };
    ListUtils.map = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var result = [];
        for (var index = startIndex; index < endIndex; index++)
            result.push(callback(list[index], index));
        return result;
    };
    ListUtils.indexBy = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        for (var ind = startIndex; ind < endIndex; ind++) {
            if (callback(list[ind], ind))
                return ind;
        }
        return -1;
    };
    ListUtils.reverseIndexBy = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = list.length - 1; }
        if (endIndex === void 0) { endIndex = 0; }
        for (var ind = startIndex; ind >= endIndex; ind--) {
            if (callback(list[ind], ind))
                return ind;
        }
        return -1;
    };
    ListUtils.elementBy = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var ind = ListUtils.indexBy(list, callback, startIndex, endIndex);
        return ind < 0 ? null : list[ind];
    };
    ListUtils.reverseElementBy = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = list.length - 1; }
        if (endIndex === void 0) { endIndex = 0; }
        var ind = ListUtils.reverseIndexBy(list, callback, startIndex, endIndex);
        return ind < 0 ? null : list[ind];
    };
    ListUtils.last = function (list) {
        return list[list.length - 1];
    };
    ListUtils.setLast = function (list, newVal) {
        return list[list.length - 1] = newVal;
    };
    ListUtils.incLast = function (list) {
        return ++list[list.length - 1];
    };
    ListUtils.decLast = function (list) {
        return --list[list.length - 1];
    };
    ListUtils.equals = function (a, b) {
        return a.length === b.length && ListUtils.allOf2(a, b, function (a, b) { return a.equals(b); });
    };
    ListUtils.equalsByReference = function (a, b) {
        var aLen = a.length;
        var bLen = a.length;
        if (aLen !== bLen)
            return false;
        for (var i = 0; i < aLen; i++) {
            if (a[i] !== b[i])
                return false;
        }
        return true;
    };
    ListUtils.unique = function (list, cmp, equal, finalizeObj) {
        if (equal === void 0) { equal = cmp; }
        if (finalizeObj === void 0) { finalizeObj = function () { }; }
        var len = list.length;
        if (len === 0)
            return [];
        list = list.sort(cmp);
        var prevValue = list[0];
        var result = ListUtils.reducedMap(list, function (v) {
            if (equal(prevValue, v) !== 0) {
                prevValue = v;
                return v;
            }
            finalizeObj(v);
            return null;
        }, 1, len);
        result.unshift(list[0]);
        return result;
    };
    ListUtils.uniqueNumber = function (list) {
        list = list.sort(comparers_1.Comparers.number);
        var prevValue = Number.NaN;
        for (var i = list.length - 1; i >= 0; i--) {
            if (prevValue === list[i])
                list.splice(i, 1);
            else
                prevValue = list[i];
        }
        return list;
    };
    ListUtils.forEach = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        for (var index = startIndex; index < endIndex; index++)
            callback(list[index], index);
    };
    ListUtils.forEach2 = function (listA, listB, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = listA.length; }
        for (var index = startIndex; index < endIndex; index++)
            callback(listA[index], listB[index], index);
    };
    ListUtils.reverseForEach = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = list.length - 1; }
        if (endIndex === void 0) { endIndex = 0; }
        for (var index = startIndex; index >= endIndex; index--)
            callback(list[index], index);
    };
    ListUtils.reverseIndexOf = function (list, element, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = list.length - 1; }
        if (endIndex === void 0) { endIndex = 0; }
        for (var index = startIndex; index >= endIndex; index--) {
            if (list[index] === element)
                return index;
        }
        return -1;
    };
    ListUtils.accumulate = function (list, initAccValue, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var acc = initAccValue;
        for (var ind = startIndex; ind < endIndex; ind++)
            acc = callback(acc, list[ind], ind);
        return acc;
    };
    ListUtils.accumulateNumber = function (list, callback, initAccValue, startIndex, endIndex) {
        if (initAccValue === void 0) { initAccValue = 0; }
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var acc = initAccValue;
        for (var ind = startIndex; ind < endIndex; ind++)
            acc += callback(list[ind], ind, acc);
        return acc;
    };
    ListUtils.anyOf = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        for (var index = startIndex; index < endIndex; index++) {
            if (callback(list[index], index))
                return true;
        }
        return false;
    };
    ListUtils.unsafeAnyOf = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        for (var index = startIndex; index < endIndex; index++) {
            var currResult = callback(list[index], index);
            if (currResult)
                return currResult;
        }
        return null;
    };
    ListUtils.reverseAnyOf = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = list.length - 1; }
        if (endIndex === void 0) { endIndex = 0; }
        for (var index = startIndex; index >= endIndex; index--) {
            if (callback(list[index], index))
                return true;
        }
        return false;
    };
    ListUtils.unsafeReverseAnyOf = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = list.length - 1; }
        if (endIndex === void 0) { endIndex = 0; }
        for (var index = startIndex; index >= endIndex; index--) {
            var currResult = callback(list[index], index);
            if (currResult)
                return currResult;
        }
        return null;
    };
    ListUtils.anyOf2 = function (listA, listB, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = listA.length; }
        for (var index = startIndex; index < endIndex; index++) {
            if (callback(listA[index], listB[index], index))
                return true;
        }
        return false;
    };
    ListUtils.allOf = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        for (var index = startIndex; index < endIndex; index++) {
            if (!callback(list[index], index))
                return false;
        }
        return true;
    };
    ListUtils.allOf2 = function (listA, listB, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = listA.length; }
        for (var index = startIndex; index < endIndex; index++) {
            if (!callback(listA[index], listB[index], index))
                return false;
        }
        return true;
    };
    ListUtils.allOfOnInterval = function (interval, callback) {
        var endIndex = interval.end;
        for (var index = interval.start; index < endIndex; index++) {
            if (!callback(index))
                return false;
        }
        return true;
    };
    ListUtils.addListOnTail = function (resultList, addedList) {
        for (var i = 0, elem = void 0; elem = addedList[i]; i++)
            resultList.push(elem);
        return resultList;
    };
    ListUtils.joinLists = function (converter) {
        var lists = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            lists[_i - 1] = arguments[_i];
        }
        return ListUtils.accumulate(lists, [], function (accList, list) {
            ListUtils.addListOnTail(accList, converter(list));
            return accList;
        });
    };
    ListUtils.push = function (list, element) {
        list.push(element);
        return list;
    };
    ListUtils.countIf = function (list, callback) {
        return ListUtils.accumulateNumber(list, function (elem, ind) { return callback(elem, ind) ? 1 : 0; });
    };
    ListUtils.clear = function (list) {
        list.splice(0);
    };
    ListUtils.merge = function (list, cmp, shouldMerge, merge, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        list = list.slice(startIndex, endIndex);
        if (endIndex - startIndex < 2)
            return list;
        list = list.sort(cmp);
        var prevObj = list[startIndex];
        var result = [prevObj];
        for (var ind = startIndex + 1; ind < endIndex; ind++) {
            var obj = list[ind];
            if (shouldMerge(prevObj, obj))
                merge(prevObj, obj);
            else {
                prevObj = obj;
                result.push(prevObj);
            }
        }
        return result;
    };
    ListUtils.min = function (list, getValue, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var res = ListUtils.minExtended(list, getValue, startIndex, endIndex);
        return res ? res.minElement : null;
    };
    ListUtils.max = function (list, getValue, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var res = ListUtils.maxExtended(list, getValue, startIndex, endIndex);
        return res ? res.maxElement : null;
    };
    ListUtils.minMax = function (list, getValue, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var res = ListUtils.minMaxExtended(list, getValue, startIndex, endIndex);
        return res ? new min_max_1.MinMax(res.minElement, res.maxElement) : null;
    };
    ListUtils.minExtended = function (list, getValue, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        if (list.length === 0)
            return null;
        var minElement = list[startIndex];
        var minValue = getValue(minElement);
        for (var index = startIndex + 1; index < endIndex; index++) {
            var elem = list[index];
            var elemValue = getValue(elem);
            if (elemValue < minValue) {
                minValue = elemValue;
                minElement = elem;
            }
        }
        return new min_max_1.ExtendedMin(minElement, minValue);
    };
    ListUtils.maxExtended = function (list, getValue, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        if (list.length === 0)
            return null;
        var maxElement = list[startIndex];
        var maxValue = getValue(maxElement);
        for (var index = startIndex + 1; index < endIndex; index++) {
            var elem = list[index];
            var elemValue = getValue(elem);
            if (elemValue > maxValue) {
                maxValue = elemValue;
                maxElement = elem;
            }
        }
        return new min_max_1.ExtendedMax(maxElement, maxValue);
    };
    ListUtils.minMaxExtended = function (list, getValue, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        if (list.length === 0)
            return null;
        var minElement = list[startIndex];
        var maxElement = minElement;
        var minValue = getValue(minElement);
        var maxValue = minValue;
        for (var index = startIndex + 1; index < endIndex; index++) {
            var elem = list[index];
            var elemValue = getValue(elem);
            if (elemValue < minValue) {
                minValue = elemValue;
                minElement = elem;
            }
            else if (elemValue > maxValue) {
                maxValue = elemValue;
                maxElement = elem;
            }
        }
        return new min_max_1.ExtendedMinMax(minElement, minValue, maxElement, maxValue);
    };
    ListUtils.minByCmp = function (list, cmp, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        if (list.length === 0)
            return null;
        var found = list[startIndex];
        for (var index = startIndex + 1; index < endIndex; index++) {
            var elem = list[index];
            if (cmp(elem, found) < 0)
                found = elem;
        }
        return found;
    };
    ListUtils.maxByCmp = function (list, cmp, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        if (list.length === 0)
            return null;
        var found = list[startIndex];
        for (var index = startIndex + 1; index < endIndex; index++) {
            var elem = list[index];
            if (cmp(elem, found) > 0)
                found = elem;
        }
        return found;
    };
    ListUtils.minMaxByCmp = function (list, cmp, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        if (list.length === 0)
            return null;
        var min = list[startIndex];
        var max = min;
        for (var index = startIndex + 1; index < endIndex; index++) {
            var elem = list[index];
            var res = cmp(elem, min);
            if (res > 0)
                max = elem;
            else if (res < 0)
                min = elem;
        }
        return new min_max_1.MinMax(min, max);
    };
    return ListUtils;
}());
exports.ListUtils = ListUtils;


/***/ }),

/***/ 8679:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MathUtils = void 0;
var list_1 = __webpack_require__(2940);
var MathUtils = (function () {
    function MathUtils() {
    }
    MathUtils.round = function (value, digits) {
        if (digits === void 0) { digits = 0; }
        var factor = MathUtils.powFactor[digits];
        return Math.round(value * factor) / factor;
    };
    MathUtils.numberCloseTo = function (num, to, accuracy) {
        if (accuracy === void 0) { accuracy = 0.00001; }
        return Math.abs(num - to) < accuracy;
    };
    MathUtils.restrictValue = function (val, minVal, maxVal) {
        if (maxVal < minVal)
            maxVal = minVal;
        if (val > maxVal)
            return maxVal;
        else if (val < minVal)
            return minVal;
        return val;
    };
    MathUtils.getRandomInt = function (min, max) {
        return Math.floor(Math.random() * (max - min + 1)) + min;
    };
    MathUtils.generateGuid = function () {
        return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
            var r = Math.random() * 16 | 0;
            var v = c === 'x' ? r : (r & 0x3 | 0x8);
            return v.toString(16);
        });
    };
    MathUtils.powFactor = list_1.ListUtils.initByCallback(20, function (ind) { return Math.pow(10, ind); });
    MathUtils.somePrimes = [1009, 1013,
        1019, 1021, 1031, 1033, 1039, 1049, 1051, 1061, 1063, 1069,
        1087, 1091, 1093, 1097, 1103, 1109, 1117, 1123, 1129, 1151,
        1153, 1163, 1171, 1181, 1187, 1193, 1201, 1213, 1217, 1223,
        1229, 1231, 1237, 1249, 1259, 1277, 1279, 1283, 1289, 1291,
        1297, 1301, 1303, 1307, 1319, 1321, 1327, 1361, 1367, 1373,
        1381, 1399, 1409, 1423, 1427, 1429, 1433, 1439, 1447, 1451,
        1453, 1459, 1471, 1481, 1483, 1487, 1489, 1493, 1499, 1511,
        1523, 1531, 1543, 1549, 1553, 1559, 1567, 1571, 1579, 1583,
        1597, 1601, 1607, 1609, 1613, 1619, 1621, 1627, 1637, 1657,
        1663, 1667, 1669, 1693, 1697, 1699, 1709, 1721, 1723, 1733,
        1741, 1747, 1753, 1759, 1777, 1783, 1787, 1789, 1801, 1811,
        1823, 1831, 1847, 1861, 1867, 1871, 1873, 1877, 1879, 1889,
        1901, 1907, 1913, 1931, 1933, 1949, 1951, 1973, 1979, 1987,
        1993, 1997, 1999, 2003];
    return MathUtils;
}());
exports.MathUtils = MathUtils;


/***/ }),

/***/ 4633:
/***/ ((__unused_webpack_module, exports) => {


var _a, _b, _c;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MimeTypeUtils = exports.DxMimeType = exports.ImageWebpMimeType = exports.ImageWbmpMimeType = exports.ImageIcoMimeType = exports.ImageTiffMimeType = exports.ImageSvgMimeType = exports.ImagePjpegMimeType = exports.ImageJpegMimeType = exports.ImageGifMimeType = exports.ImagePngMimeType = exports.DocmMimeType = exports.HtmlMimeType = exports.PlainTextMimeType = exports.RtfMimeType = exports.OpenXmlMimeType = void 0;
exports.OpenXmlMimeType = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document';
exports.RtfMimeType = 'application/rtf';
exports.PlainTextMimeType = 'text/plain';
exports.HtmlMimeType = 'text/html';
exports.DocmMimeType = 'application/vnd.ms-word.document.macroEnabled.12';
exports.ImagePngMimeType = 'image/png';
exports.ImageGifMimeType = 'image/gif';
exports.ImageJpegMimeType = 'image/jpeg';
exports.ImagePjpegMimeType = 'image/pjpeg';
exports.ImageSvgMimeType = 'image/svg+xml';
exports.ImageTiffMimeType = 'image/tiff';
exports.ImageIcoMimeType = 'image/vnd.microsoft.icon';
exports.ImageWbmpMimeType = 'image/vnd.wap.wbmp';
exports.ImageWebpMimeType = 'image/webp';
var DxMimeType;
(function (DxMimeType) {
    DxMimeType[DxMimeType["Unknown"] = 0] = "Unknown";
    DxMimeType[DxMimeType["OpenXml"] = 1] = "OpenXml";
    DxMimeType[DxMimeType["Rtf"] = 2] = "Rtf";
    DxMimeType[DxMimeType["PlainText"] = 3] = "PlainText";
    DxMimeType[DxMimeType["Docm"] = 4] = "Docm";
    DxMimeType[DxMimeType["Png"] = 5] = "Png";
    DxMimeType[DxMimeType["Gif"] = 6] = "Gif";
    DxMimeType[DxMimeType["Jpeg"] = 7] = "Jpeg";
    DxMimeType[DxMimeType["Pjpeg"] = 8] = "Pjpeg";
    DxMimeType[DxMimeType["Svg"] = 9] = "Svg";
    DxMimeType[DxMimeType["Tiff"] = 10] = "Tiff";
    DxMimeType[DxMimeType["Ico"] = 11] = "Ico";
    DxMimeType[DxMimeType["Wbmp"] = 12] = "Wbmp";
    DxMimeType[DxMimeType["Webp"] = 13] = "Webp";
    DxMimeType[DxMimeType["Html"] = 14] = "Html";
})(DxMimeType = exports.DxMimeType || (exports.DxMimeType = {}));
var MimeTypeUtils = (function () {
    function MimeTypeUtils() {
    }
    MimeTypeUtils.stringTypeToExtension = function (mimeTypeAsStr) {
        var mimeType = MimeTypeUtils.stringTypeToTypeMap[mimeTypeAsStr];
        return mimeType === undefined ? '' : MimeTypeUtils.typeToExtensionMap[mimeType];
    };
    MimeTypeUtils.typeToExtension = function (mimeType) {
        var ext = MimeTypeUtils.typeToExtensionMap[mimeType];
        return ext !== null && ext !== void 0 ? ext : '';
    };
    MimeTypeUtils.extensionToType = function (extension) {
        extension = extension.toLowerCase();
        if (extension[0] !== '.')
            extension += '.';
        var mimeType = MimeTypeUtils.extensionToTypeMap[extension];
        return mimeType !== null && mimeType !== void 0 ? mimeType : DxMimeType.Unknown;
    };
    MimeTypeUtils.typeToStringType = function (mimeType) {
        var str = MimeTypeUtils.typeToStringTypeMap[mimeType];
        return str !== null && str !== void 0 ? str : '';
    };
    MimeTypeUtils.stringTypeToType = function (mimeTypeAsStr) {
        var mimeType = MimeTypeUtils.stringTypeToTypeMap[mimeTypeAsStr];
        return mimeType === undefined ? DxMimeType.Unknown : mimeType;
    };
    MimeTypeUtils.stringTypeToTypeMap = (_a = {},
        _a[exports.OpenXmlMimeType] = DxMimeType.OpenXml,
        _a[exports.RtfMimeType] = DxMimeType.Rtf,
        _a[exports.PlainTextMimeType] = DxMimeType.PlainText,
        _a[exports.DocmMimeType] = DxMimeType.Docm,
        _a[exports.HtmlMimeType] = DxMimeType.Html,
        _a[exports.ImagePngMimeType] = DxMimeType.Png,
        _a[exports.ImageGifMimeType] = DxMimeType.Gif,
        _a[exports.ImageJpegMimeType] = DxMimeType.Jpeg,
        _a[exports.ImagePjpegMimeType] = DxMimeType.Pjpeg,
        _a[exports.ImageSvgMimeType] = DxMimeType.Svg,
        _a[exports.ImageTiffMimeType] = DxMimeType.Tiff,
        _a[exports.ImageIcoMimeType] = DxMimeType.Ico,
        _a[exports.ImageWbmpMimeType] = DxMimeType.Wbmp,
        _a[exports.ImageWebpMimeType] = DxMimeType.Webp,
        _a);
    MimeTypeUtils.typeToStringTypeMap = (_b = {},
        _b[DxMimeType.Unknown] = undefined,
        _b[DxMimeType.OpenXml] = exports.OpenXmlMimeType,
        _b[DxMimeType.Rtf] = exports.RtfMimeType,
        _b[DxMimeType.PlainText] = exports.PlainTextMimeType,
        _b[DxMimeType.Docm] = exports.DocmMimeType,
        _b[DxMimeType.Html] = exports.HtmlMimeType,
        _b[DxMimeType.Png] = exports.ImagePngMimeType,
        _b[DxMimeType.Gif] = exports.ImageGifMimeType,
        _b[DxMimeType.Jpeg] = exports.ImageJpegMimeType,
        _b[DxMimeType.Pjpeg] = exports.ImagePjpegMimeType,
        _b[DxMimeType.Svg] = exports.ImageSvgMimeType,
        _b[DxMimeType.Tiff] = exports.ImageTiffMimeType,
        _b[DxMimeType.Ico] = exports.ImageIcoMimeType,
        _b[DxMimeType.Wbmp] = exports.ImageWbmpMimeType,
        _b[DxMimeType.Webp] = exports.ImageWebpMimeType,
        _b);
    MimeTypeUtils.typeToExtensionMap = (_c = {},
        _c[DxMimeType.Unknown] = undefined,
        _c[DxMimeType.OpenXml] = '.docx',
        _c[DxMimeType.Rtf] = '.rtf',
        _c[DxMimeType.PlainText] = '.txt',
        _c[DxMimeType.Docm] = '.docm',
        _c[DxMimeType.Html] = '.html',
        _c[DxMimeType.Png] = '.png',
        _c[DxMimeType.Gif] = '.gif',
        _c[DxMimeType.Jpeg] = '.jpeg',
        _c[DxMimeType.Pjpeg] = '.pjpeg',
        _c[DxMimeType.Svg] = '.svg',
        _c[DxMimeType.Tiff] = '.tiff',
        _c[DxMimeType.Ico] = '.ico',
        _c[DxMimeType.Wbmp] = '.wbmp',
        _c[DxMimeType.Webp] = '.webp',
        _c);
    MimeTypeUtils.extensionToTypeMap = {
        '.docx': DxMimeType.OpenXml,
        '.rtf': DxMimeType.Rtf,
        '.txt': DxMimeType.PlainText,
        '.docm': DxMimeType.Docm,
        '.html': DxMimeType.Html,
        '.htm': DxMimeType.Html,
        '.png': DxMimeType.Png,
        '.gif': DxMimeType.Gif,
        '.jpeg': DxMimeType.Jpeg,
        '.pjpeg': DxMimeType.Pjpeg,
        '.svg': DxMimeType.Svg,
        '.tiff': DxMimeType.Tiff,
        '.ico': DxMimeType.Ico,
        '.wbmp': DxMimeType.Wbmp,
        '.webp': DxMimeType.Webp,
    };
    return MimeTypeUtils;
}());
exports.MimeTypeUtils = MimeTypeUtils;


/***/ }),

/***/ 2400:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SearchUtils = void 0;
var SearchUtils = (function () {
    function SearchUtils() {
    }
    SearchUtils.binaryIndexOf = function (array, comparer, minIndex, maxIndex) {
        if (minIndex === void 0) { minIndex = 0; }
        if (maxIndex === void 0) { maxIndex = -2; }
        var findFromZeroPosition = minIndex === 0;
        if (maxIndex === -2)
            maxIndex = array.length - 1;
        while (minIndex <= maxIndex) {
            var currentIndex = (minIndex + ((maxIndex - minIndex) >> 1));
            var compare = comparer(array[currentIndex]);
            if (compare < 0)
                minIndex = currentIndex + 1;
            else if (compare > 0)
                maxIndex = currentIndex - 1;
            else
                return currentIndex;
        }
        return findFromZeroPosition ? ~minIndex : -1;
    };
    SearchUtils.normedBinaryIndexOf = function (array, comparer, minIndex, maxIndex) {
        if (minIndex === void 0) { minIndex = 0; }
        if (maxIndex === void 0) { maxIndex = -2; }
        var index = SearchUtils.binaryIndexOf(array, comparer, minIndex, maxIndex);
        return SearchUtils.binaryIndexNormalizator(index);
    };
    SearchUtils.binaryIndexNormalizator = function (index) {
        return index < 0 ? ~index - 1 : index;
    };
    SearchUtils.normedInterpolationIndexOf = function (array, getValue, toFind, lowIndex, highIndex) {
        if (lowIndex === void 0) { lowIndex = 0; }
        if (highIndex === void 0) { highIndex = -2; }
        if (highIndex === -2)
            highIndex = array.length - 1;
        var firstObject = array[Math.min(lowIndex, highIndex)];
        if (firstObject === undefined || toFind < getValue(firstObject))
            return -1;
        var lowValue = getValue(array[lowIndex]);
        var highValue = getValue(array[highIndex]);
        while (true) {
            if (toFind > lowValue && toFind < highValue) {
                var midIndex = lowIndex + Math.floor(((toFind - lowValue) * (highIndex - lowIndex)) / (highValue - lowValue));
                var midValue = getValue(array[midIndex]);
                if (toFind > midValue) {
                    lowIndex = midIndex + 1;
                    lowValue = getValue(array[lowIndex]);
                    if (toFind < lowValue)
                        return midIndex;
                }
                else if (toFind < midValue) {
                    highIndex = midIndex - 1;
                    highValue = getValue(array[highIndex]);
                }
                else
                    return midIndex;
            }
            else
                return toFind === lowValue ? lowIndex : highIndex;
        }
    };
    return SearchUtils;
}());
exports.SearchUtils = SearchUtils;


/***/ }),

/***/ 49:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StringUtils = void 0;
var StringUtils = (function () {
    function StringUtils() {
    }
    StringUtils.isAlpha = function (ch) {
        return (ch >= 'a' && ch <= 'z') || (ch >= 'A' && ch <= 'Z');
    };
    StringUtils.isDigit = function (ch) {
        return ch >= '0' && ch <= '9';
    };
    StringUtils.stringHashCode = function (str) {
        var hash = 0;
        if (str.length === 0)
            return hash;
        var strLen = str.length;
        for (var i = 0; i < strLen; i++) {
            hash = ((hash << 5) - hash) + str.charCodeAt(i);
            hash |= 0;
        }
        return hash;
    };
    StringUtils.endsAt = function (str, template) {
        var strInd = str.length - 1;
        var tmplInd = template.length - 1;
        var strStartInd = strInd - tmplInd;
        if (strStartInd < 0)
            return false;
        for (; strInd >= strStartInd; strInd--, tmplInd--) {
            if (str[strInd] !== template[tmplInd])
                return false;
        }
        return true;
    };
    StringUtils.startsAt = function (str, template) {
        return str.substr(0, template.length) === template;
    };
    StringUtils.stringInLowerCase = function (str) {
        return str.toLowerCase() === str;
    };
    StringUtils.stringInUpperCase = function (str) {
        return str.toUpperCase() === str;
    };
    StringUtils.atLeastOneSymbolInUpperCase = function (str) {
        for (var i = 0, char = void 0; char = str[i]; i++) {
            if (StringUtils.stringInUpperCase(char) && !StringUtils.stringInLowerCase(char))
                return true;
        }
        return false;
    };
    StringUtils.getSymbolFromEnd = function (text, posFromEnd) {
        return text[text.length - posFromEnd];
    };
    StringUtils.trim = function (str, trimChars) {
        if (trimChars === undefined)
            return StringUtils.trimInternal(str, true, true);
        else {
            var joinedChars = trimChars.join('');
            return str.replace(new RegExp("(^[" + joinedChars + "]*)|([" + joinedChars + "]*$)", 'g'), '');
        }
    };
    StringUtils.trimStart = function (str, trimChars) {
        if (trimChars === undefined)
            return StringUtils.trimInternal(str, true, false);
        else {
            var joinedChars = trimChars.join('');
            return str.replace(new RegExp("^[" + joinedChars + "]*", 'g'), '');
        }
    };
    StringUtils.trimEnd = function (str, trimChars) {
        if (trimChars === undefined)
            return StringUtils.trimInternal(str, false, true);
        else {
            var joinedChars = trimChars.join('');
            return str.replace(new RegExp("[" + joinedChars + "]*$", 'g'), '');
        }
    };
    StringUtils.getDecimalSeparator = function () {
        return (1.1).toLocaleString().substr(1, 1);
    };
    StringUtils.repeat = function (str, count) {
        return new Array(count <= 0 ? 0 : count + 1).join(str);
    };
    StringUtils.isNullOrEmpty = function (str) {
        return !str || !str.length;
    };
    StringUtils.padLeft = function (str, totalWidth, paddingChar) {
        return StringUtils.repeat(paddingChar, Math.max(0, totalWidth - str.length)) + str;
    };
    StringUtils.trimInternal = function (source, trimStart, trimEnd) {
        var len = source.length;
        if (!len)
            return source;
        if (len < 0xBABA1) {
            var result = source;
            if (trimStart)
                result = result.replace(/^\s+/, '');
            if (trimEnd)
                result = result.replace(/\s+$/, '');
            return result;
        }
        else {
            var start = 0;
            if (trimEnd) {
                while (len > 0 && /\s/.test(source[len - 1]))
                    len--;
            }
            if (trimStart && len > 0) {
                while (start < len && /\s/.test(source[start]))
                    start++;
            }
            return source.substring(start, len);
        }
    };
    return StringUtils;
}());
exports.StringUtils = StringUtils;


/***/ }),

/***/ 1632:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TouchUtils = void 0;
var browser_1 = __webpack_require__(9279);
var common_1 = __webpack_require__(2491);
var TouchUtils = (function () {
    function TouchUtils() {
    }
    TouchUtils.onEventAttachingToDocument = function (eventName, func) {
        if (browser_1.Browser.MacOSMobilePlatform && TouchUtils.isTouchEventName(eventName)) {
            if (!TouchUtils.documentTouchHandlers[eventName])
                TouchUtils.documentTouchHandlers[eventName] = [];
            TouchUtils.documentTouchHandlers[eventName].push(func);
            return TouchUtils.documentEventAttachingAllowed;
        }
        return true;
    };
    TouchUtils.isTouchEventName = function (eventName) {
        return browser_1.Browser.WebKitTouchUI && (eventName.indexOf('touch') > -1 || eventName.indexOf('gesture') > -1);
    };
    TouchUtils.isTouchEvent = function (evt) {
        return browser_1.Browser.WebKitTouchUI && common_1.isDefined(evt.changedTouches);
    };
    TouchUtils.getEventX = function (evt) {
        return browser_1.Browser.IE ? evt.pageX : evt.changedTouches[0].pageX;
    };
    TouchUtils.getEventY = function (evt) {
        return browser_1.Browser.IE ? evt.pageY : evt.changedTouches[0].pageY;
    };
    TouchUtils.touchMouseDownEventName = browser_1.Browser.WebKitTouchUI ? 'touchstart' : (browser_1.Browser.Edge && browser_1.Browser.MSTouchUI && window.PointerEvent ? 'pointerdown' : 'mousedown');
    TouchUtils.touchMouseUpEventName = browser_1.Browser.WebKitTouchUI ? 'touchend' : (browser_1.Browser.Edge && browser_1.Browser.MSTouchUI && window.PointerEvent ? 'pointerup' : 'mouseup');
    TouchUtils.touchMouseMoveEventName = browser_1.Browser.WebKitTouchUI ? 'touchmove' : (browser_1.Browser.Edge && browser_1.Browser.MSTouchUI && window.PointerEvent ? 'pointermove' : 'mousemove');
    TouchUtils.msTouchDraggableClassName = 'dxMSTouchDraggable';
    TouchUtils.documentTouchHandlers = {};
    TouchUtils.documentEventAttachingAllowed = true;
    return TouchUtils;
}());
exports.TouchUtils = TouchUtils;


/***/ }),

/***/ 7097:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {



(__webpack_require__(8091).polyfill)();


/***/ }),

/***/ 8091:
/***/ ((module) => {

/**
 * Code refactored from Mozilla Developer Network:
 * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/assign
 */



function assign(target, firstSource) {
  if (target === undefined || target === null) {
    throw new TypeError('Cannot convert first argument to object');
  }

  var to = Object(target);
  for (var i = 1; i < arguments.length; i++) {
    var nextSource = arguments[i];
    if (nextSource === undefined || nextSource === null) {
      continue;
    }

    var keysArray = Object.keys(Object(nextSource));
    for (var nextIndex = 0, len = keysArray.length; nextIndex < len; nextIndex++) {
      var nextKey = keysArray[nextIndex];
      var desc = Object.getOwnPropertyDescriptor(nextSource, nextKey);
      if (desc !== undefined && desc.enumerable) {
        to[nextKey] = nextSource[nextKey];
      }
    }
  }
  return to;
}

function polyfill() {
  if (!Object.assign) {
    Object.defineProperty(Object, 'assign', {
      enumerable: false,
      configurable: true,
      writable: true,
      value: assign
    });
  }
}

module.exports = {
  assign: assign,
  polyfill: polyfill
};


/***/ }),

/***/ 8721:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ 5656:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ApiController = void 0;
var batch_updatable_1 = __webpack_require__(1772);
var Event_1 = __webpack_require__(6031);
var ModelUtils_1 = __webpack_require__(4867);
var __1 = __webpack_require__(3607);
var ApiController = (function (_super) {
    __extends(ApiController, _super);
    function ApiController(events, selection, model) {
        var _this = _super.call(this) || this;
        _this.events = events;
        _this.model = model;
        _this.selection = selection;
        return _this;
    }
    ApiController.prototype.notifySelectionChanged = function (selection) {
        if (this.isUpdateLocked())
            this.registerOccurredEvent(ApiControllerAction.SelectionChanged);
        else
            this.raiseSelectionChanged();
    };
    ApiController.prototype.notifyToolboxDragStart = function () {
        this.events.raise("notifyToolboxItemDragStart");
    };
    ApiController.prototype.notifyToolboxDragEnd = function () {
        this.events.raise("notifyToolboxItemDragEnd");
    };
    ApiController.prototype.notifyToolboxDraggingMouseMove = function () {
    };
    ApiController.prototype.notifyClick = function (evt) {
        var _this = this;
        this.tryRaiseUserAction(evt, function (i) { return _this.events.raise("notifyItemClick", i); });
    };
    ApiController.prototype.notifyDblClick = function (evt) {
        var _this = this;
        this.tryRaiseUserAction(evt, function (i) { return _this.events.raise("notifyItemDblClick", i); });
    };
    ApiController.prototype.createNativeItem = function (item) {
        return item && this.cleanupNativeItem(item.toNative(this.model.units));
    };
    ApiController.prototype.createNativeShape = function (shape) {
        return this.createNativeItem(shape);
    };
    ApiController.prototype.createNativeConnector = function (connector) {
        return this.createNativeItem(connector);
    };
    ApiController.prototype.convertUnit = function (value) {
        return ModelUtils_1.ModelUtils.getlUnitValue(this.model.units, value);
    };
    ApiController.prototype.convertPoint = function (point) {
        return new __1.Point(this.convertUnit(point.x), this.convertUnit(point.y));
    };
    ApiController.prototype.convertSize = function (size) {
        return new __1.Size(this.convertUnit(size.width), this.convertUnit(size.height));
    };
    ApiController.prototype.cleanupNativeItem = function (item) {
        var ds = this.dataSource;
        if (ds) {
            if (ds.isAutoGeneratedKey(item.fromKey))
                item.fromKey = undefined;
            if (ds.isAutoGeneratedKey(item.key))
                item.key = undefined;
            if (ds.isAutoGeneratedKey(item.toKey))
                item.toKey = undefined;
        }
        return item;
    };
    ApiController.prototype.setDataSource = function (dataSource) {
        this.dataSource = dataSource;
    };
    ApiController.prototype.tryRaiseUserAction = function (evt, callEvent) {
        var _this = this;
        if (this.isUserAction(evt)) {
            var item_1 = this.model.findItem(evt.source.key);
            item_1 && this.events.raise1(function (l) { return callEvent(_this.createNativeItem(item_1)); });
        }
    };
    ApiController.prototype.isUserAction = function (evt) {
        return evt.source && (evt.source.type === Event_1.MouseEventElementType.Shape ||
            evt.source.type === Event_1.MouseEventElementType.ShapeExpandButton ||
            evt.source.type === Event_1.MouseEventElementType.ShapeParameterBox ||
            evt.source.type === Event_1.MouseEventElementType.ShapeResizeBox ||
            evt.source.type === Event_1.MouseEventElementType.ShapeConnectionPoint ||
            evt.source.type === Event_1.MouseEventElementType.Connector ||
            evt.source.type === Event_1.MouseEventElementType.ConnectorPoint ||
            evt.source.type === Event_1.MouseEventElementType.ConnectorSide ||
            evt.source.type === Event_1.MouseEventElementType.ConnectorOrthogonalSide ||
            evt.source.type === Event_1.MouseEventElementType.ConnectorText);
    };
    ApiController.prototype.onUpdateUnlocked = function (occurredEvents) {
        if (occurredEvents & ApiControllerAction.SelectionChanged)
            this.raiseSelectionChanged();
    };
    ApiController.prototype.raiseSelectionChanged = function () {
        var _this = this;
        var items = this.selection.getKeys().map(function (key) { return _this.createNativeItem(_this.model.findItem(key)); });
        this.events.raise1(function (l) { return l.notifySelectionChanged(items); });
    };
    return ApiController;
}(batch_updatable_1.BatchUpdatableObject));
exports.ApiController = ApiController;
var ApiControllerAction;
(function (ApiControllerAction) {
    ApiControllerAction[ApiControllerAction["SelectionChanged"] = 1] = "SelectionChanged";
})(ApiControllerAction || (ApiControllerAction = {}));


/***/ }),

/***/ 7185:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NativeConnector = exports.NativeShape = exports.NativeItem = void 0;
var ModelUtils_1 = __webpack_require__(4867);
var NativeItem = (function () {
    function NativeItem(id, key) {
        this.id = id;
        this.key = key;
        this.unitsApplied = false;
    }
    NativeItem.prototype.applyUnits = function (units) {
        if (!this.unitsApplied && units !== undefined) {
            this.applyUnitsCore(units);
            this.unitsApplied = true;
        }
    };
    return NativeItem;
}());
exports.NativeItem = NativeItem;
var NativeShape = (function (_super) {
    __extends(NativeShape, _super);
    function NativeShape() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    NativeShape.prototype.applyUnitsCore = function (units) {
        this.position.x = ModelUtils_1.ModelUtils.getlUnitValue(units, this.position.x);
        this.position.y = ModelUtils_1.ModelUtils.getlUnitValue(units, this.position.y);
        this.size.width = ModelUtils_1.ModelUtils.getlUnitValue(units, this.size.width);
        this.size.height = ModelUtils_1.ModelUtils.getlUnitValue(units, this.size.height);
    };
    return NativeShape;
}(NativeItem));
exports.NativeShape = NativeShape;
var NativeConnector = (function (_super) {
    __extends(NativeConnector, _super);
    function NativeConnector() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    NativeConnector.prototype.applyUnitsCore = function (units) {
        this.points.forEach(function (pt) {
            pt.x = ModelUtils_1.ModelUtils.getlUnitValue(units, pt.x);
            pt.y = ModelUtils_1.ModelUtils.getlUnitValue(units, pt.y);
        });
    };
    return NativeConnector;
}(NativeItem));
exports.NativeConnector = NativeConnector;


/***/ }),

/***/ 8906:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoLayoutCommandBase = void 0;
var ModelUtils_1 = __webpack_require__(4867);
var SimpleCommandBase_1 = __webpack_require__(9741);
var Shape_1 = __webpack_require__(5503);
var Connector_1 = __webpack_require__(7959);
var Utils_1 = __webpack_require__(8675);
var rectangle_1 = __webpack_require__(8011);
var ScrollIntoViewHistoryItem_1 = __webpack_require__(7626);
var AutoLayoutCommandBase = (function (_super) {
    __extends(AutoLayoutCommandBase, _super);
    function AutoLayoutCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutCommandBase.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var shapes = this.getAffectedShapes();
        var connectors = this.getAffectedConnectors();
        var settings = this.createLayoutSettings();
        var graphInfo = ModelUtils_1.ModelUtils.getGraphInfoByItems(this.control.model, shapes, connectors, false);
        if (graphInfo.length) {
            var rectangle_2;
            var model_1 = this.control.model;
            var commonRect = Utils_1.GeometryUtils.getCommonRectangle(Utils_1.Utils.flatten(graphInfo.map(function (g) { return g.graph.items.map(function (i) { return model_1.findItem(i.key); }); }))
                .concat(graphInfo.map(function (g) { return g.container; }))
                .filter(function (i) { return i; })
                .map(function (i) { return i.rectangle; }));
            this.control.history.addAndRedo(new ScrollIntoViewHistoryItem_1.ScrollIntoViewOnUndoHistoryItem(this.control.view, commonRect));
            graphInfo.forEach(function (info) {
                var layout = _this.createLayout(settings, info.graph);
                var nonGraphItems = ModelUtils_1.ModelUtils.getNonGraphItems(_this.control.model, info.container, layout.nodeToLayout, shapes, connectors);
                var layoutRect = ModelUtils_1.ModelUtils.applyLayout(_this.control.history, _this.control.model, info.container, info.graph, layout, nonGraphItems, settings, _this.control.settings.snapToGrid, _this.control.settings.gridSize, false);
                rectangle_2 = rectangle_2 && rectangle_1.Rectangle.union(rectangle_2, layoutRect) || layoutRect;
            });
            ModelUtils_1.ModelUtils.tryUpdateModelRectangle(this.control.history);
            this.control.history.addAndRedo(new ScrollIntoViewHistoryItem_1.ScrollIntoViewOnRedoHistoryItem(this.control.view, rectangle_2));
        }
        this.control.history.endTransaction();
        return true;
    };
    AutoLayoutCommandBase.prototype.getAffectedShapes = function () {
        return this.control.selection.isEmpty() ?
            this.control.model.items.filter((function (i) { return i instanceof Shape_1.Shape && !i.locked; })) :
            this.control.selection.getSelectedShapes(false, true);
    };
    AutoLayoutCommandBase.prototype.getAffectedConnectors = function () {
        return this.control.selection.isEmpty() ?
            this.control.model.items.filter((function (i) { return i instanceof Connector_1.Connector && !i.locked; })) :
            this.control.selection.getSelectedConnectors(false, true);
    };
    return AutoLayoutCommandBase;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.AutoLayoutCommandBase = AutoLayoutCommandBase;


/***/ }),

/***/ 30:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoLayoutLayeredHorizontalCommand = void 0;
var AutoLayoutCommandBase_1 = __webpack_require__(8906);
var Sugiyama_1 = __webpack_require__(1256);
var LayoutSettings_1 = __webpack_require__(8710);
var AutoLayoutLayeredHorizontalCommand = (function (_super) {
    __extends(AutoLayoutLayeredHorizontalCommand, _super);
    function AutoLayoutLayeredHorizontalCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutLayeredHorizontalCommand.prototype.createLayoutSettings = function () {
        var settings = new LayoutSettings_1.LayoutSettings();
        settings.orientation = LayoutSettings_1.DataLayoutOrientation.Horizontal;
        return settings;
    };
    AutoLayoutLayeredHorizontalCommand.prototype.createLayout = function (settings, graph) {
        return new Sugiyama_1.SugiyamaLayoutBuilder(settings, graph).build();
    };
    return AutoLayoutLayeredHorizontalCommand;
}(AutoLayoutCommandBase_1.AutoLayoutCommandBase));
exports.AutoLayoutLayeredHorizontalCommand = AutoLayoutLayeredHorizontalCommand;


/***/ }),

/***/ 7826:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoLayoutLayeredHorizontalRightToLeftCommand = void 0;
var LayoutSettings_1 = __webpack_require__(8710);
var AutoLayoutLayeredHorizontalCommand_1 = __webpack_require__(30);
var AutoLayoutLayeredHorizontalRightToLeftCommand = (function (_super) {
    __extends(AutoLayoutLayeredHorizontalRightToLeftCommand, _super);
    function AutoLayoutLayeredHorizontalRightToLeftCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutLayeredHorizontalRightToLeftCommand.prototype.createLayoutSettings = function () {
        var settings = _super.prototype.createLayoutSettings.call(this);
        settings.direction = LayoutSettings_1.LogicalDirectionKind.Backward;
        return settings;
    };
    return AutoLayoutLayeredHorizontalRightToLeftCommand;
}(AutoLayoutLayeredHorizontalCommand_1.AutoLayoutLayeredHorizontalCommand));
exports.AutoLayoutLayeredHorizontalRightToLeftCommand = AutoLayoutLayeredHorizontalRightToLeftCommand;


/***/ }),

/***/ 554:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoLayoutLayeredVerticalBottomToTopCommand = void 0;
var LayoutSettings_1 = __webpack_require__(8710);
var AutoLayoutLayeredVerticalCommand_1 = __webpack_require__(9427);
var AutoLayoutLayeredVerticalBottomToTopCommand = (function (_super) {
    __extends(AutoLayoutLayeredVerticalBottomToTopCommand, _super);
    function AutoLayoutLayeredVerticalBottomToTopCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutLayeredVerticalBottomToTopCommand.prototype.createLayoutSettings = function () {
        var settings = _super.prototype.createLayoutSettings.call(this);
        settings.direction = LayoutSettings_1.LogicalDirectionKind.Backward;
        return settings;
    };
    return AutoLayoutLayeredVerticalBottomToTopCommand;
}(AutoLayoutLayeredVerticalCommand_1.AutoLayoutLayeredVerticalCommand));
exports.AutoLayoutLayeredVerticalBottomToTopCommand = AutoLayoutLayeredVerticalBottomToTopCommand;


/***/ }),

/***/ 9427:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoLayoutLayeredVerticalCommand = void 0;
var AutoLayoutCommandBase_1 = __webpack_require__(8906);
var Sugiyama_1 = __webpack_require__(1256);
var LayoutSettings_1 = __webpack_require__(8710);
var AutoLayoutLayeredVerticalCommand = (function (_super) {
    __extends(AutoLayoutLayeredVerticalCommand, _super);
    function AutoLayoutLayeredVerticalCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutLayeredVerticalCommand.prototype.createLayoutSettings = function () {
        var settings = new LayoutSettings_1.LayoutSettings();
        settings.orientation = LayoutSettings_1.DataLayoutOrientation.Vertical;
        return settings;
    };
    AutoLayoutLayeredVerticalCommand.prototype.createLayout = function (settings, graph) {
        return new Sugiyama_1.SugiyamaLayoutBuilder(settings, graph).build();
    };
    return AutoLayoutLayeredVerticalCommand;
}(AutoLayoutCommandBase_1.AutoLayoutCommandBase));
exports.AutoLayoutLayeredVerticalCommand = AutoLayoutLayeredVerticalCommand;


/***/ }),

/***/ 7004:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoLayoutTreeHorizontalCommand = void 0;
var AutoLayoutCommandBase_1 = __webpack_require__(8906);
var WideTree_1 = __webpack_require__(9533);
var LayoutSettings_1 = __webpack_require__(8710);
var AutoLayoutTreeHorizontalCommand = (function (_super) {
    __extends(AutoLayoutTreeHorizontalCommand, _super);
    function AutoLayoutTreeHorizontalCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutTreeHorizontalCommand.prototype.createLayoutSettings = function () {
        var gridSize = this.control.settings.snapToGrid ? this.control.settings.gridSize : undefined;
        var settings = new LayoutSettings_1.TreeLayoutSettings(gridSize);
        settings.orientation = LayoutSettings_1.DataLayoutOrientation.Horizontal;
        return settings;
    };
    AutoLayoutTreeHorizontalCommand.prototype.createLayout = function (settings, graph) {
        return new WideTree_1.TreeLayoutBuilder(settings, graph).build();
    };
    return AutoLayoutTreeHorizontalCommand;
}(AutoLayoutCommandBase_1.AutoLayoutCommandBase));
exports.AutoLayoutTreeHorizontalCommand = AutoLayoutTreeHorizontalCommand;


/***/ }),

/***/ 5010:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoLayoutTreeHorizontalRightToLeftCommand = void 0;
var LayoutSettings_1 = __webpack_require__(8710);
var AutoLayoutTreeHorizontalCommand_1 = __webpack_require__(7004);
var AutoLayoutTreeHorizontalRightToLeftCommand = (function (_super) {
    __extends(AutoLayoutTreeHorizontalRightToLeftCommand, _super);
    function AutoLayoutTreeHorizontalRightToLeftCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutTreeHorizontalRightToLeftCommand.prototype.createLayoutSettings = function () {
        var settings = _super.prototype.createLayoutSettings.call(this);
        settings.direction = LayoutSettings_1.LogicalDirectionKind.Backward;
        return settings;
    };
    return AutoLayoutTreeHorizontalRightToLeftCommand;
}(AutoLayoutTreeHorizontalCommand_1.AutoLayoutTreeHorizontalCommand));
exports.AutoLayoutTreeHorizontalRightToLeftCommand = AutoLayoutTreeHorizontalRightToLeftCommand;


/***/ }),

/***/ 2217:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoLayoutTreeVerticalBottomToTopCommand = void 0;
var LayoutSettings_1 = __webpack_require__(8710);
var AutoLayoutTreeVerticalCommand_1 = __webpack_require__(375);
var AutoLayoutTreeVerticalBottomToTopCommand = (function (_super) {
    __extends(AutoLayoutTreeVerticalBottomToTopCommand, _super);
    function AutoLayoutTreeVerticalBottomToTopCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutTreeVerticalBottomToTopCommand.prototype.createLayoutSettings = function () {
        var settings = _super.prototype.createLayoutSettings.call(this);
        settings.direction = LayoutSettings_1.LogicalDirectionKind.Backward;
        return settings;
    };
    return AutoLayoutTreeVerticalBottomToTopCommand;
}(AutoLayoutTreeVerticalCommand_1.AutoLayoutTreeVerticalCommand));
exports.AutoLayoutTreeVerticalBottomToTopCommand = AutoLayoutTreeVerticalBottomToTopCommand;


/***/ }),

/***/ 375:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoLayoutTreeVerticalCommand = void 0;
var AutoLayoutCommandBase_1 = __webpack_require__(8906);
var WideTree_1 = __webpack_require__(9533);
var LayoutSettings_1 = __webpack_require__(8710);
var AutoLayoutTreeVerticalCommand = (function (_super) {
    __extends(AutoLayoutTreeVerticalCommand, _super);
    function AutoLayoutTreeVerticalCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutTreeVerticalCommand.prototype.createLayoutSettings = function () {
        var gridSize = this.control.settings.snapToGrid ? this.control.settings.gridSize : undefined;
        var settings = new LayoutSettings_1.TreeLayoutSettings(gridSize);
        settings.orientation = LayoutSettings_1.DataLayoutOrientation.Vertical;
        return settings;
    };
    AutoLayoutTreeVerticalCommand.prototype.createLayout = function (settings, graph) {
        return new WideTree_1.TreeLayoutBuilder(settings, graph).build();
    };
    return AutoLayoutTreeVerticalCommand;
}(AutoLayoutCommandBase_1.AutoLayoutCommandBase));
exports.AutoLayoutTreeVerticalCommand = AutoLayoutTreeVerticalCommand;


/***/ }),

/***/ 4982:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClipboardCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(9741);
var ClipboardCommand = (function (_super) {
    __extends(ClipboardCommand, _super);
    function ClipboardCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ClipboardCommand.prototype.setClipboardData = function (data) {
        if (this.control.render)
            this.control.render.input.setClipboardData(data);
        ClipboardCommand.clipboardData = data;
    };
    ClipboardCommand.prototype.getClipboardData = function (callback) {
        if (this.control.render && this.isPasteSupportedByBrowser())
            this.control.render.input.getClipboardData(callback);
        else
            callback(ClipboardCommand.clipboardData);
    };
    ClipboardCommand.prototype.isPasteSupportedByBrowser = function () {
        return this.control.render && this.control.render.input.isPasteSupportedByBrowser();
    };
    return ClipboardCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ClipboardCommand = ClipboardCommand;


/***/ }),

/***/ 5827:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CopySelectionCommand = void 0;
var Exporter_1 = __webpack_require__(5885);
var ClipboardCommand_1 = __webpack_require__(4982);
var CopySelectionCommand = (function (_super) {
    __extends(CopySelectionCommand, _super);
    function CopySelectionCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CopySelectionCommand.prototype.isEnabled = function () {
        return _super.prototype.isEnabled.call(this) && !this.control.selection.isEmpty(true);
    };
    CopySelectionCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    CopySelectionCommand.prototype.executeCore = function (state) {
        var exporter = new Exporter_1.Exporter();
        var data = exporter.exportItems(this.control.selection.getSelectedItems(true, true));
        this.setClipboardData(data);
        return true;
    };
    return CopySelectionCommand;
}(ClipboardCommand_1.ClipboardCommand));
exports.CopySelectionCommand = CopySelectionCommand;


/***/ }),

/***/ 2664:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CutSelectionCommand = void 0;
var Exporter_1 = __webpack_require__(5885);
var ModelUtils_1 = __webpack_require__(4867);
var ClipboardCommand_1 = __webpack_require__(4982);
var CutSelectionCommand = (function (_super) {
    __extends(CutSelectionCommand, _super);
    function CutSelectionCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CutSelectionCommand.prototype.isEnabled = function () {
        var items = this.control.selection.getSelectedItems();
        return _super.prototype.isEnabled.call(this) && items.length && (items.length > 1 || this.permissionsProvider.canDeleteItems(items));
    };
    CutSelectionCommand.prototype.executeCore = function (state) {
        var exporter = new Exporter_1.Exporter();
        var items = this.control.selection.getSelectedItems(true, true);
        var data = exporter.exportItems(items);
        this.permissionsProvider.beginDeleteItems(items);
        this.setClipboardData(data);
        ModelUtils_1.ModelUtils.deleteSelection(this.control.history, this.control.model, this.control.selection);
        this.permissionsProvider.endDeleteItems();
        return true;
    };
    Object.defineProperty(CutSelectionCommand.prototype, "isPermissionsRequired", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    return CutSelectionCommand;
}(ClipboardCommand_1.ClipboardCommand));
exports.CutSelectionCommand = CutSelectionCommand;


/***/ }),

/***/ 4200:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PasteSelectionCommand = void 0;
var point_1 = __webpack_require__(8900);
var PasteSelectionCommandBase_1 = __webpack_require__(7688);
var Shape_1 = __webpack_require__(5503);
var Connector_1 = __webpack_require__(7959);
var PasteSelectionCommand = (function (_super) {
    __extends(PasteSelectionCommand, _super);
    function PasteSelectionCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PasteSelectionCommand.prototype.getEventPositionOffset = function (items, _evtPosition) {
        var topLeftItem = items.reduce(function (acc, item) {
            var x = item instanceof Shape_1.Shape ? item.position.x : item instanceof Connector_1.Connector ? item.getMinX() : Number.MAX_VALUE;
            var y = item instanceof Shape_1.Shape ? item.position.y : item instanceof Connector_1.Connector ? item.getMinY() : Number.MAX_VALUE;
            if (y < acc.y || (y === acc.y && x < acc.x)) {
                acc.topLeftItem = item;
                acc.x = x;
                acc.y = y;
            }
            return acc;
        }, {
            topLeftItem: items[0],
            x: Number.MAX_VALUE,
            y: Number.MAX_VALUE
        }).topLeftItem;
        if (topLeftItem instanceof Shape_1.Shape) {
            var newPoint = this.getShapeCorrectedPosition(this.control.model, topLeftItem);
            return new point_1.Point(newPoint.x - topLeftItem.position.x, newPoint.y - topLeftItem.position.y);
        }
        else if (topLeftItem instanceof Connector_1.Connector) {
            var newPoints = this.getConnectorCorrectedPoints(this.control.model, topLeftItem);
            return new point_1.Point(topLeftItem.points[0].x - newPoints[0].x, topLeftItem.points[0].y - newPoints[0].y);
        }
    };
    PasteSelectionCommand.prototype.getShapeCorrectedPosition = function (model, shape) {
        var position = shape.position.clone();
        while (model.findShapeAtPosition(position))
            position.offset(PasteSelectionCommandBase_1.PasteSelectionCommandBase.positionOffset, PasteSelectionCommandBase_1.PasteSelectionCommandBase.positionOffset);
        return position;
    };
    PasteSelectionCommand.prototype.getConnectorCorrectedPoints = function (model, connector) {
        var points = connector.points.map(function (p) { return p.clone(); });
        while (model.findConnectorAtPoints(points))
            points.forEach(function (pt) {
                pt.x += PasteSelectionCommandBase_1.PasteSelectionCommandBase.positionOffset;
                pt.y += PasteSelectionCommandBase_1.PasteSelectionCommandBase.positionOffset;
            });
        return points;
    };
    return PasteSelectionCommand;
}(PasteSelectionCommandBase_1.PasteSelectionCommandBase));
exports.PasteSelectionCommand = PasteSelectionCommand;


/***/ }),

/***/ 7688:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PasteSelectionCommandBase = void 0;
var ClipboardCommand_1 = __webpack_require__(4982);
var Importer_1 = __webpack_require__(2406);
var Shape_1 = __webpack_require__(5503);
var ImportShapeHistoryItem_1 = __webpack_require__(4383);
var Connector_1 = __webpack_require__(7959);
var ImportConnectorHistoryItem_1 = __webpack_require__(3849);
var ModelUtils_1 = __webpack_require__(4867);
var SetSelectionHistoryItem_1 = __webpack_require__(4297);
var unit_converter_1 = __webpack_require__(9291);
var PasteSelectionCommandBase = (function (_super) {
    __extends(PasteSelectionCommandBase, _super);
    function PasteSelectionCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PasteSelectionCommandBase.prototype.isEnabled = function () {
        return _super.prototype.isEnabled.call(this) && (this.isPasteSupportedByBrowser() || ClipboardCommand_1.ClipboardCommand.clipboardData !== undefined);
    };
    PasteSelectionCommandBase.prototype.isVisible = function () {
        return this.isPasteSupportedByBrowser() || ClipboardCommand_1.ClipboardCommand.clipboardData !== undefined;
    };
    PasteSelectionCommandBase.prototype.parseClipboardData = function (data) {
        var items = [];
        var importer = new Importer_1.Importer(this.control.shapeDescriptionManager, data);
        items = importer.importItems(this.control.model);
        var offset = this.getEventPositionOffset(items, this.control.contextMenuPosition);
        for (var i = 0; i < items.length; i++) {
            var item = items[i];
            if (item instanceof Shape_1.Shape)
                item.position.offsetByPoint(offset);
            else if (item instanceof Connector_1.Connector) {
                item.points.forEach(function (p) { return p.offsetByPoint(offset); });
                item.clearRenderPoints();
            }
        }
        return items;
    };
    PasteSelectionCommandBase.prototype.executeCore = function (state, parameter) {
        var _this = this;
        var ret = true;
        if (parameter === undefined)
            this.getClipboardData(function (data) {
                ret = _this.execute(data);
            });
        else
            this.performPaste(parameter);
        return ret;
    };
    PasteSelectionCommandBase.prototype.addItemForSortingRecursive = function (itemsHashtable, item) {
        if (itemsHashtable[item.key])
            return itemsHashtable[item.key];
        if (item instanceof Connector_1.Connector) {
            if (item.endItem)
                itemsHashtable[item.key] = this.addItemForSortingRecursive(itemsHashtable, item.endItem) - 0.5;
            else if (item.beginItem)
                itemsHashtable[item.key] = this.addItemForSortingRecursive(itemsHashtable, item.beginItem) + 0.5;
            else
                itemsHashtable[item.key] = -1;
            return itemsHashtable[item.key];
        }
        if (item.attachedConnectors.length === 0)
            return itemsHashtable[item.key] = 0;
        else
            for (var i = 0; i < item.attachedConnectors.length; i++) {
                var beginItem = item.attachedConnectors[i].beginItem;
                if (item.attachedConnectors[i].endItem === item && beginItem && beginItem !== item.attachedConnectors[i].endItem)
                    return itemsHashtable[item.key] = this.addItemForSortingRecursive(itemsHashtable, beginItem) + 1;
                else
                    return itemsHashtable[item.key] = 0;
            }
    };
    PasteSelectionCommandBase.prototype.getSortedPasteItems = function (items) {
        var sortedItems = [];
        var connectors = [];
        var itemsHashtable = {};
        for (var i = 0; i < items.length; i++) {
            var item = items[i];
            if (item instanceof Shape_1.Shape)
                sortedItems.push(item);
            else if (item instanceof Connector_1.Connector) {
                connectors.push(item);
                this.addItemForSortingRecursive(itemsHashtable, item);
            }
        }
        connectors.sort(function (a, b) { return itemsHashtable[b.key] - itemsHashtable[a.key]; });
        return sortedItems.concat(connectors);
    };
    PasteSelectionCommandBase.prototype.performPaste = function (data) {
        this.control.beginUpdateCanvas();
        this.control.history.beginTransaction();
        var idsForSelection = {};
        var items = this.parseClipboardData(data);
        items = this.getSortedPasteItems(items);
        for (var i = 0; i < items.length; i++) {
            var item = items[i];
            if (item instanceof Shape_1.Shape)
                this.control.history.addAndRedo(new ImportShapeHistoryItem_1.ImportShapeHistoryItem(item));
            else if (item instanceof Connector_1.Connector)
                this.control.history.addAndRedo(new ImportConnectorHistoryItem_1.ImportConnectorHistoryItem(item));
            var containerKey = item.container && item.container.key;
            if (!containerKey || idsForSelection[containerKey] === undefined)
                idsForSelection[item.key] = true;
            else if (containerKey && idsForSelection[containerKey] !== undefined)
                idsForSelection[item.key] = false;
        }
        ModelUtils_1.ModelUtils.tryUpdateModelRectangle(this.control.history);
        this.control.history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(this.control.selection, Object.keys(idsForSelection).filter(function (id) { return idsForSelection[id]; })));
        this.control.history.endTransaction();
        this.control.endUpdateCanvas();
        this.control.barManager.updateItemsState();
    };
    Object.defineProperty(PasteSelectionCommandBase.prototype, "isPermissionsRequired", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    PasteSelectionCommandBase.positionOffset = unit_converter_1.UnitConverter.pixelsToTwips(10);
    return PasteSelectionCommandBase;
}(ClipboardCommand_1.ClipboardCommand));
exports.PasteSelectionCommandBase = PasteSelectionCommandBase;


/***/ }),

/***/ 437:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PasteSelectionInPositionCommand = void 0;
var PasteSelectionCommandBase_1 = __webpack_require__(7688);
var Shape_1 = __webpack_require__(5503);
var Connector_1 = __webpack_require__(7959);
var point_1 = __webpack_require__(8900);
var PasteSelectionInPositionCommand = (function (_super) {
    __extends(PasteSelectionInPositionCommand, _super);
    function PasteSelectionInPositionCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PasteSelectionInPositionCommand.prototype.getEventPositionOffset = function (items, evtPosition) {
        if (!evtPosition)
            return point_1.Point.zero();
        var selectionPos = items.reduce(function (min, i) {
            return {
                x: Math.min(min.x, i instanceof Shape_1.Shape ? i.position.x : i instanceof Connector_1.Connector ? i.getMinX() : Number.MAX_VALUE),
                y: Math.min(min.y, i instanceof Shape_1.Shape ? i.position.y : i instanceof Connector_1.Connector ? i.getMinY() : Number.MAX_VALUE)
            };
        }, {
            x: Number.MAX_VALUE,
            y: Number.MAX_VALUE
        });
        var newSelectionPos = this.control.render.getModelPointByEventPoint(evtPosition.x, evtPosition.y);
        return new point_1.Point(newSelectionPos.x - selectionPos.x, newSelectionPos.y - selectionPos.y);
    };
    return PasteSelectionInPositionCommand;
}(PasteSelectionCommandBase_1.PasteSelectionCommandBase));
exports.PasteSelectionInPositionCommand = PasteSelectionInPositionCommand;


/***/ }),

/***/ 9687:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommandBase = void 0;
var CommandBase = (function () {
    function CommandBase(control) {
        this.control = control;
    }
    CommandBase.prototype.execute = function (parameter) {
        if (this.isPermissionsRequired)
            this.permissionsProvider.lockPermissions();
        var state = this.getState();
        if (this.isPermissionsRequired)
            this.permissionsProvider.unlockPermissions();
        if (!state.enabled)
            return false;
        this.control.beginUpdate();
        var executed = false;
        if (this.isPermissionsRequired)
            executed = this.executeWithPermissions(state, parameter);
        else
            executed = this.executeCore(state, parameter);
        this.control.endUpdate();
        if (executed)
            this.updateControlState();
        return executed;
    };
    CommandBase.prototype.executeWithPermissions = function (state, parameter) {
        var executed = false;
        this.permissionsProvider.beginStorePermissions();
        this.control.history.beginTransaction();
        executed = this.executeCore(state, parameter);
        if (!this.permissionsProvider.isStoredPermissionsGranted()) {
            this.permissionsProvider.lockPermissions();
            this.control.history.undoTransaction();
            this.permissionsProvider.unlockPermissions();
            executed = false;
        }
        this.control.history.endTransaction();
        this.permissionsProvider.endStorePermissions();
        return executed;
    };
    CommandBase.prototype.updateControlState = function () {
        if (!this.lockInputPositionUpdating())
            this.control.selection.inputPosition.reset();
        if (!this.lockUIUpdating())
            this.control.barManager.updateItemsState();
    };
    Object.defineProperty(CommandBase.prototype, "permissionsProvider", {
        get: function () { return this.control && this.control.permissionsProvider; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CommandBase.prototype, "isPermissionsRequired", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    CommandBase.prototype.lockUIUpdating = function () {
        return false;
    };
    CommandBase.prototype.lockInputPositionUpdating = function () {
        return false;
    };
    return CommandBase;
}());
exports.CommandBase = CommandBase;


/***/ }),

/***/ 7156:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommandManager = exports.DiagramCommand = void 0;
var DeleteCommand_1 = __webpack_require__(264);
var UndoCommand_1 = __webpack_require__(6679);
var RedoCommand_1 = __webpack_require__(3614);
var ImportCommand_1 = __webpack_require__(6596);
var ExportCommand_1 = __webpack_require__(4845);
var ToggleFontBoldCommand_1 = __webpack_require__(4378);
var ToggleFontItalicCommand_1 = __webpack_require__(7607);
var ToggleFontUnderlineCommand_1 = __webpack_require__(3411);
var ChangeFontNameCommand_1 = __webpack_require__(7480);
var ChangeFontSizeCommand_1 = __webpack_require__(4077);
var ChangeFontColorCommand_1 = __webpack_require__(6106);
var ChangeFillColorCommand_1 = __webpack_require__(1649);
var ChangeStrokeColorCommand_1 = __webpack_require__(3166);
var ChangeTextAlignCommand_1 = __webpack_require__(8700);
var ChangeConnectorLineEndingCommand_1 = __webpack_require__(2301);
var ChangeConnectorLineOptionCommand_1 = __webpack_require__(7306);
var SelectAllCommand_1 = __webpack_require__(2452);
var key_1 = __webpack_require__(2153);
var AutoLayoutTreeVerticalCommand_1 = __webpack_require__(375);
var ChangeSnapToGridCommand_1 = __webpack_require__(4503);
var ChangeGridSizeCommand_1 = __webpack_require__(7550);
var ChangePageLandscapeCommand_1 = __webpack_require__(7649);
var ChangePageSizeCommand_1 = __webpack_require__(1813);
var ExportPngCommand_1 = __webpack_require__(3690);
var ExportSvgCommand_1 = __webpack_require__(2276);
var ExportJpgCommand_1 = __webpack_require__(1203);
var CopySelectionCommand_1 = __webpack_require__(5827);
var CutSelectionCommand_1 = __webpack_require__(2664);
var PasteSelectionCommand_1 = __webpack_require__(4200);
var ImportBPMNCommand_1 = __webpack_require__(1239);
var SendToBackCommand_1 = __webpack_require__(4624);
var BringToFrontCommand_1 = __webpack_require__(3591);
var AutoLayoutLayeredHorizontalCommand_1 = __webpack_require__(30);
var MoveCommands_1 = __webpack_require__(5925);
var ChangeZoomLevelCommand_1 = __webpack_require__(4522);
var BindDocumentCommand_1 = __webpack_require__(9538);
var UnbindDocumentCommand_1 = __webpack_require__(125);
var AutoLayoutTreeHorizontalCommand_1 = __webpack_require__(7004);
var AutoLayoutLayeredVerticalCommand_1 = __webpack_require__(9427);
var LockCommand_1 = __webpack_require__(9031);
var UnlockCommand_1 = __webpack_require__(6049);
var CloneCommand_1 = __webpack_require__(4999);
var ChangeUnitsCommand_1 = __webpack_require__(4419);
var ChangePageColorCommand_1 = __webpack_require__(8016);
var ChangeShowGridCommand_1 = __webpack_require__(72);
var ToggleFullscreenCommand_1 = __webpack_require__(6619);
var ToggleSimpleViewCommand_1 = __webpack_require__(7795);
var ToggleReadOnlyCommand_1 = __webpack_require__(9970);
var EditShapeImageCommand_1 = __webpack_require__(4281);
var PasteSelectionInPosition_1 = __webpack_require__(437);
var ImportXMLCommand_1 = __webpack_require__(5830);
var InsertShapeImageCommand_1 = __webpack_require__(9158);
var DeleteShapeImageCommand_1 = __webpack_require__(962);
var ChangeStrokeStyleCommand_1 = __webpack_require__(4643);
var ChangeStrokeWidthCommand_1 = __webpack_require__(4681);
var AutoLayoutTreeVerticalBottomToTopCommand_1 = __webpack_require__(2217);
var AutoLayoutTreeHorizontalRightToLeftCommand_1 = __webpack_require__(5010);
var AutoLayoutLayeredVerticalBottomToTopCommand_1 = __webpack_require__(554);
var AutoLayoutLayeredHorizontalRightToLeftCommand_1 = __webpack_require__(7826);
var ChangeConnectorRoutingModeCommand_1 = __webpack_require__(7717);
var DiagramCommand;
(function (DiagramCommand) {
    DiagramCommand[DiagramCommand["Undo"] = 0] = "Undo";
    DiagramCommand[DiagramCommand["Redo"] = 1] = "Redo";
    DiagramCommand[DiagramCommand["Cut"] = 2] = "Cut";
    DiagramCommand[DiagramCommand["Copy"] = 3] = "Copy";
    DiagramCommand[DiagramCommand["Paste"] = 4] = "Paste";
    DiagramCommand[DiagramCommand["PasteInPosition"] = 5] = "PasteInPosition";
    DiagramCommand[DiagramCommand["SelectAll"] = 6] = "SelectAll";
    DiagramCommand[DiagramCommand["Delete"] = 7] = "Delete";
    DiagramCommand[DiagramCommand["Import"] = 8] = "Import";
    DiagramCommand[DiagramCommand["ImportBPMN"] = 9] = "ImportBPMN";
    DiagramCommand[DiagramCommand["Export"] = 10] = "Export";
    DiagramCommand[DiagramCommand["ExportSvg"] = 11] = "ExportSvg";
    DiagramCommand[DiagramCommand["ExportPng"] = 12] = "ExportPng";
    DiagramCommand[DiagramCommand["ExportJpg"] = 13] = "ExportJpg";
    DiagramCommand[DiagramCommand["BindDocument"] = 14] = "BindDocument";
    DiagramCommand[DiagramCommand["UnbindDocument"] = 15] = "UnbindDocument";
    DiagramCommand[DiagramCommand["Bold"] = 16] = "Bold";
    DiagramCommand[DiagramCommand["Italic"] = 17] = "Italic";
    DiagramCommand[DiagramCommand["Underline"] = 18] = "Underline";
    DiagramCommand[DiagramCommand["FontName"] = 19] = "FontName";
    DiagramCommand[DiagramCommand["FontSize"] = 20] = "FontSize";
    DiagramCommand[DiagramCommand["FontColor"] = 21] = "FontColor";
    DiagramCommand[DiagramCommand["FillColor"] = 22] = "FillColor";
    DiagramCommand[DiagramCommand["StrokeColor"] = 23] = "StrokeColor";
    DiagramCommand[DiagramCommand["TextLeftAlign"] = 24] = "TextLeftAlign";
    DiagramCommand[DiagramCommand["TextCenterAlign"] = 25] = "TextCenterAlign";
    DiagramCommand[DiagramCommand["TextRightAlign"] = 26] = "TextRightAlign";
    DiagramCommand[DiagramCommand["ConnectorLineOption"] = 27] = "ConnectorLineOption";
    DiagramCommand[DiagramCommand["ConnectorStartLineEnding"] = 28] = "ConnectorStartLineEnding";
    DiagramCommand[DiagramCommand["ConnectorEndLineEnding"] = 29] = "ConnectorEndLineEnding";
    DiagramCommand[DiagramCommand["BringToFront"] = 30] = "BringToFront";
    DiagramCommand[DiagramCommand["SendToBack"] = 31] = "SendToBack";
    DiagramCommand[DiagramCommand["MoveLeft"] = 32] = "MoveLeft";
    DiagramCommand[DiagramCommand["MoveStepLeft"] = 33] = "MoveStepLeft";
    DiagramCommand[DiagramCommand["MoveRight"] = 34] = "MoveRight";
    DiagramCommand[DiagramCommand["MoveStepRight"] = 35] = "MoveStepRight";
    DiagramCommand[DiagramCommand["MoveUp"] = 36] = "MoveUp";
    DiagramCommand[DiagramCommand["MoveStepUp"] = 37] = "MoveStepUp";
    DiagramCommand[DiagramCommand["MoveDown"] = 38] = "MoveDown";
    DiagramCommand[DiagramCommand["MoveStepDown"] = 39] = "MoveStepDown";
    DiagramCommand[DiagramCommand["CloneLeft"] = 40] = "CloneLeft";
    DiagramCommand[DiagramCommand["CloneRight"] = 41] = "CloneRight";
    DiagramCommand[DiagramCommand["CloneUp"] = 42] = "CloneUp";
    DiagramCommand[DiagramCommand["CloneDown"] = 43] = "CloneDown";
    DiagramCommand[DiagramCommand["AutoLayoutTree"] = 44] = "AutoLayoutTree";
    DiagramCommand[DiagramCommand["AutoLayoutFlow"] = 45] = "AutoLayoutFlow";
    DiagramCommand[DiagramCommand["AutoLayoutTreeVertical"] = 46] = "AutoLayoutTreeVertical";
    DiagramCommand[DiagramCommand["AutoLayoutTreeHorizontal"] = 47] = "AutoLayoutTreeHorizontal";
    DiagramCommand[DiagramCommand["AutoLayoutLayeredVertical"] = 48] = "AutoLayoutLayeredVertical";
    DiagramCommand[DiagramCommand["AutoLayoutLayeredHorizontal"] = 49] = "AutoLayoutLayeredHorizontal";
    DiagramCommand[DiagramCommand["Lock"] = 50] = "Lock";
    DiagramCommand[DiagramCommand["Unlock"] = 51] = "Unlock";
    DiagramCommand[DiagramCommand["Units"] = 52] = "Units";
    DiagramCommand[DiagramCommand["ViewUnits"] = 53] = "ViewUnits";
    DiagramCommand[DiagramCommand["PageSize"] = 54] = "PageSize";
    DiagramCommand[DiagramCommand["PageLandscape"] = 55] = "PageLandscape";
    DiagramCommand[DiagramCommand["PageColor"] = 56] = "PageColor";
    DiagramCommand[DiagramCommand["GridSize"] = 57] = "GridSize";
    DiagramCommand[DiagramCommand["ShowGrid"] = 58] = "ShowGrid";
    DiagramCommand[DiagramCommand["SnapToGrid"] = 59] = "SnapToGrid";
    DiagramCommand[DiagramCommand["ZoomLevel"] = 60] = "ZoomLevel";
    DiagramCommand[DiagramCommand["Fullscreen"] = 61] = "Fullscreen";
    DiagramCommand[DiagramCommand["ToggleSimpleView"] = 62] = "ToggleSimpleView";
    DiagramCommand[DiagramCommand["ToggleReadOnly"] = 63] = "ToggleReadOnly";
    DiagramCommand[DiagramCommand["EditShapeImage"] = 64] = "EditShapeImage";
    DiagramCommand[DiagramCommand["FitToScreen"] = 65] = "FitToScreen";
    DiagramCommand[DiagramCommand["SwitchAutoZoom"] = 66] = "SwitchAutoZoom";
    DiagramCommand[DiagramCommand["ToggleAutoZoom"] = 67] = "ToggleAutoZoom";
    DiagramCommand[DiagramCommand["FitToWidth"] = 68] = "FitToWidth";
    DiagramCommand[DiagramCommand["ZoomLevelItems"] = 69] = "ZoomLevelItems";
    DiagramCommand[DiagramCommand["GridSizeItems"] = 70] = "GridSizeItems";
    DiagramCommand[DiagramCommand["PageSizeItems"] = 71] = "PageSizeItems";
    DiagramCommand[DiagramCommand["ImportXML"] = 72] = "ImportXML";
    DiagramCommand[DiagramCommand["InsertShapeImage"] = 73] = "InsertShapeImage";
    DiagramCommand[DiagramCommand["DeleteShapeImage"] = 74] = "DeleteShapeImage";
    DiagramCommand[DiagramCommand["StrokeStyle"] = 75] = "StrokeStyle";
    DiagramCommand[DiagramCommand["StrokeWidth"] = 76] = "StrokeWidth";
    DiagramCommand[DiagramCommand["AutoLayoutTreeVerticalBottomToTop"] = 77] = "AutoLayoutTreeVerticalBottomToTop";
    DiagramCommand[DiagramCommand["AutoLayoutTreeHorizontalRightToLeft"] = 78] = "AutoLayoutTreeHorizontalRightToLeft";
    DiagramCommand[DiagramCommand["AutoLayoutLayeredVerticalBottomToTop"] = 79] = "AutoLayoutLayeredVerticalBottomToTop";
    DiagramCommand[DiagramCommand["AutoLayoutLayeredHorizontalRightToLeft"] = 80] = "AutoLayoutLayeredHorizontalRightToLeft";
    DiagramCommand[DiagramCommand["Zoom25"] = 81] = "Zoom25";
    DiagramCommand[DiagramCommand["Zoom50"] = 82] = "Zoom50";
    DiagramCommand[DiagramCommand["Zoom75"] = 83] = "Zoom75";
    DiagramCommand[DiagramCommand["Zoom100"] = 84] = "Zoom100";
    DiagramCommand[DiagramCommand["Zoom125"] = 85] = "Zoom125";
    DiagramCommand[DiagramCommand["Zoom150"] = 86] = "Zoom150";
    DiagramCommand[DiagramCommand["Zoom200"] = 87] = "Zoom200";
    DiagramCommand[DiagramCommand["AutoZoomToContent"] = 88] = "AutoZoomToContent";
    DiagramCommand[DiagramCommand["AutoZoomToWidth"] = 89] = "AutoZoomToWidth";
    DiagramCommand[DiagramCommand["ZoomLevelInPercentage"] = 90] = "ZoomLevelInPercentage";
    DiagramCommand[DiagramCommand["ConnectorRoutingMode"] = 91] = "ConnectorRoutingMode";
})(DiagramCommand = exports.DiagramCommand || (exports.DiagramCommand = {}));
var CommandManager = (function () {
    function CommandManager(control) {
        this.commands = {};
        this.shortcutsToCommand = {};
        this.lastCommandsChain = [];
        this.executingCommandsChain = [];
        this.executingCommandCounter = 0;
        this.isPublicApiCall = false;
        this.createCommand(control, DiagramCommand.Undo, UndoCommand_1.UndoCommand, key_1.ModifierKey.Ctrl | key_1.KeyCode.Key_z, key_1.ModifierKey.Meta | key_1.KeyCode.Key_z);
        this.createCommand(control, DiagramCommand.Redo, RedoCommand_1.RedoCommand, key_1.ModifierKey.Ctrl | key_1.KeyCode.Key_y, key_1.ModifierKey.Ctrl | key_1.ModifierKey.Shift | key_1.KeyCode.Key_z, key_1.ModifierKey.Meta | key_1.ModifierKey.Shift | key_1.KeyCode.Key_z);
        this.createCommand(control, DiagramCommand.Cut, CutSelectionCommand_1.CutSelectionCommand, key_1.KeyCode.Key_x | key_1.ModifierKey.Ctrl, key_1.KeyCode.Key_x | key_1.ModifierKey.Meta, key_1.KeyCode.Delete | key_1.ModifierKey.Shift);
        this.createCommand(control, DiagramCommand.Copy, CopySelectionCommand_1.CopySelectionCommand, key_1.KeyCode.Key_c | key_1.ModifierKey.Ctrl, key_1.KeyCode.Key_c | key_1.ModifierKey.Meta, key_1.KeyCode.Insert | key_1.ModifierKey.Ctrl);
        this.createCommand(control, DiagramCommand.Paste, PasteSelectionCommand_1.PasteSelectionCommand);
        this.createCommand(control, DiagramCommand.PasteInPosition, PasteSelectionInPosition_1.PasteSelectionInPositionCommand);
        this.createCommand(control, DiagramCommand.SelectAll, SelectAllCommand_1.SelectAllCommand, key_1.KeyCode.Key_a | key_1.ModifierKey.Ctrl, key_1.KeyCode.Key_a | key_1.ModifierKey.Meta);
        this.createCommand(control, DiagramCommand.Delete, DeleteCommand_1.DeleteCommand, key_1.KeyCode.Delete, key_1.KeyCode.Backspace);
        this.createCommand(control, DiagramCommand.Import, ImportCommand_1.ImportCommand);
        this.createCommand(control, DiagramCommand.ImportBPMN, ImportBPMNCommand_1.ImportBPMNCommand);
        this.createCommand(control, DiagramCommand.ImportXML, ImportXMLCommand_1.ImportXMLCommand);
        this.createCommand(control, DiagramCommand.Export, ExportCommand_1.ExportCommand);
        this.createCommand(control, DiagramCommand.ExportSvg, ExportSvgCommand_1.ExportSvgCommand);
        this.createCommand(control, DiagramCommand.ExportPng, ExportPngCommand_1.ExportPngCommand);
        this.createCommand(control, DiagramCommand.ExportJpg, ExportJpgCommand_1.ExportJpgCommand);
        this.createCommand(control, DiagramCommand.BindDocument, BindDocumentCommand_1.BindDocumentCommand);
        this.createCommand(control, DiagramCommand.UnbindDocument, UnbindDocumentCommand_1.UnbindDocumentCommand);
        this.createCommand(control, DiagramCommand.Bold, ToggleFontBoldCommand_1.ToggleFontBoldCommand, key_1.ModifierKey.Ctrl | key_1.KeyCode.Key_b, key_1.ModifierKey.Meta | key_1.KeyCode.Key_b);
        this.createCommand(control, DiagramCommand.Italic, ToggleFontItalicCommand_1.ToggleFontItalicCommand, key_1.ModifierKey.Ctrl | key_1.KeyCode.Key_i, key_1.ModifierKey.Meta | key_1.KeyCode.Key_i);
        this.createCommand(control, DiagramCommand.Underline, ToggleFontUnderlineCommand_1.ToggleFontUnderlineCommand, key_1.ModifierKey.Ctrl | key_1.KeyCode.Key_u, key_1.ModifierKey.Meta | key_1.KeyCode.Key_u);
        this.createCommand(control, DiagramCommand.FontName, ChangeFontNameCommand_1.ChangeFontNameCommand);
        this.createCommand(control, DiagramCommand.FontSize, ChangeFontSizeCommand_1.ChangeFontSizeCommand);
        this.createCommand(control, DiagramCommand.FontColor, ChangeFontColorCommand_1.ChangeFontColorCommand);
        this.createCommand(control, DiagramCommand.FillColor, ChangeFillColorCommand_1.ChangeFillColorCommand);
        this.createCommand(control, DiagramCommand.StrokeColor, ChangeStrokeColorCommand_1.ChangeStrokeColorCommand);
        this.createCommand(control, DiagramCommand.StrokeStyle, ChangeStrokeStyleCommand_1.ChangeStrokeStyleCommand);
        this.createCommand(control, DiagramCommand.StrokeWidth, ChangeStrokeWidthCommand_1.ChangeStrokeWidthCommand);
        this.createCommand(control, DiagramCommand.TextLeftAlign, ChangeTextAlignCommand_1.TextLeftAlignCommand);
        this.createCommand(control, DiagramCommand.TextCenterAlign, ChangeTextAlignCommand_1.TextCenterAlignCommand);
        this.createCommand(control, DiagramCommand.TextRightAlign, ChangeTextAlignCommand_1.TextRightAlignCommand);
        this.createCommand(control, DiagramCommand.ConnectorLineOption, ChangeConnectorLineOptionCommand_1.ChangeConnectorLineOptionCommand);
        this.createCommand(control, DiagramCommand.ConnectorStartLineEnding, ChangeConnectorLineEndingCommand_1.ChangeConnectorStartLineEndingCommand);
        this.createCommand(control, DiagramCommand.ConnectorEndLineEnding, ChangeConnectorLineEndingCommand_1.ChangeConnectorEndLineEndingCommand);
        this.createCommand(control, DiagramCommand.BringToFront, BringToFrontCommand_1.BringToFrontCommand);
        this.createCommand(control, DiagramCommand.SendToBack, SendToBackCommand_1.SendToBackCommand);
        this.createCommand(control, DiagramCommand.MoveLeft, MoveCommands_1.MoveLeftCommand, key_1.ModifierKey.Ctrl | key_1.KeyCode.Left, key_1.ModifierKey.Ctrl | key_1.ModifierKey.Shift | key_1.KeyCode.Left);
        this.createCommand(control, DiagramCommand.MoveRight, MoveCommands_1.MoveRightCommand, key_1.ModifierKey.Ctrl | key_1.KeyCode.Right, key_1.ModifierKey.Ctrl | key_1.ModifierKey.Shift | key_1.KeyCode.Right);
        this.createCommand(control, DiagramCommand.MoveUp, MoveCommands_1.MoveUpCommand, key_1.ModifierKey.Ctrl | key_1.KeyCode.Up, key_1.ModifierKey.Ctrl | key_1.ModifierKey.Shift | key_1.KeyCode.Up);
        this.createCommand(control, DiagramCommand.MoveDown, MoveCommands_1.MoveDownCommand, key_1.ModifierKey.Ctrl | key_1.KeyCode.Down, key_1.ModifierKey.Ctrl | key_1.ModifierKey.Shift | key_1.KeyCode.Down);
        this.createCommand(control, DiagramCommand.MoveStepLeft, MoveCommands_1.MoveStepLeftCommand, key_1.KeyCode.Left, key_1.ModifierKey.Shift | key_1.KeyCode.Left);
        this.createCommand(control, DiagramCommand.MoveStepRight, MoveCommands_1.MoveStepRightCommand, key_1.KeyCode.Right, key_1.ModifierKey.Shift | key_1.KeyCode.Right);
        this.createCommand(control, DiagramCommand.MoveStepUp, MoveCommands_1.MoveStepUpCommand, key_1.KeyCode.Up, key_1.ModifierKey.Shift | key_1.KeyCode.Up);
        this.createCommand(control, DiagramCommand.MoveStepDown, MoveCommands_1.MoveStepDownCommand, key_1.KeyCode.Down, key_1.ModifierKey.Shift | key_1.KeyCode.Down);
        this.createCommand(control, DiagramCommand.CloneLeft, CloneCommand_1.CloneLeftCommand, key_1.ModifierKey.Alt | key_1.KeyCode.Left, key_1.ModifierKey.Alt | key_1.ModifierKey.Shift | key_1.KeyCode.Left);
        this.createCommand(control, DiagramCommand.CloneRight, CloneCommand_1.CloneRightCommand, key_1.ModifierKey.Alt | key_1.KeyCode.Right, key_1.ModifierKey.Alt | key_1.ModifierKey.Shift | key_1.KeyCode.Right);
        this.createCommand(control, DiagramCommand.CloneUp, CloneCommand_1.CloneUpCommand, key_1.ModifierKey.Alt | key_1.KeyCode.Up, key_1.ModifierKey.Alt | key_1.ModifierKey.Shift | key_1.KeyCode.Up);
        this.createCommand(control, DiagramCommand.CloneDown, CloneCommand_1.CloneDownCommand, key_1.ModifierKey.Alt | key_1.KeyCode.Down, key_1.ModifierKey.Alt | key_1.ModifierKey.Shift | key_1.KeyCode.Down);
        this.createCommand(control, DiagramCommand.Lock, LockCommand_1.LockCommand);
        this.createCommand(control, DiagramCommand.Unlock, UnlockCommand_1.UnLockCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutTree, AutoLayoutTreeVerticalCommand_1.AutoLayoutTreeVerticalCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutFlow, AutoLayoutLayeredHorizontalCommand_1.AutoLayoutLayeredHorizontalCommand);
        this.createCommand(control, DiagramCommand.Units, ChangeUnitsCommand_1.ChangeUnitsCommand);
        this.createCommand(control, DiagramCommand.ViewUnits, ChangeUnitsCommand_1.ChangeViewUnitsCommand);
        this.createCommand(control, DiagramCommand.PageSize, ChangePageSizeCommand_1.ChangePageSizeCommand);
        this.createCommand(control, DiagramCommand.PageLandscape, ChangePageLandscapeCommand_1.ChangePageLandscapeCommand);
        this.createCommand(control, DiagramCommand.PageColor, ChangePageColorCommand_1.ChangePageColorCommand);
        this.createCommand(control, DiagramCommand.GridSize, ChangeGridSizeCommand_1.ChangeGridSizeCommand);
        this.createCommand(control, DiagramCommand.ShowGrid, ChangeShowGridCommand_1.ChangeShowGridCommand);
        this.createCommand(control, DiagramCommand.SnapToGrid, ChangeSnapToGridCommand_1.ChangeSnapToGridCommand);
        this.createCommand(control, DiagramCommand.ZoomLevel, ChangeZoomLevelCommand_1.ChangeZoomLevelCommand);
        this.createCommand(control, DiagramCommand.ZoomLevelInPercentage, ChangeZoomLevelCommand_1.ChangeZoomLevelInPercentageCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutTreeVertical, AutoLayoutTreeVerticalCommand_1.AutoLayoutTreeVerticalCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutTreeVerticalBottomToTop, AutoLayoutTreeVerticalBottomToTopCommand_1.AutoLayoutTreeVerticalBottomToTopCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutTreeHorizontal, AutoLayoutTreeHorizontalCommand_1.AutoLayoutTreeHorizontalCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutTreeHorizontalRightToLeft, AutoLayoutTreeHorizontalRightToLeftCommand_1.AutoLayoutTreeHorizontalRightToLeftCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutLayeredVertical, AutoLayoutLayeredVerticalCommand_1.AutoLayoutLayeredVerticalCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutLayeredVerticalBottomToTop, AutoLayoutLayeredVerticalBottomToTopCommand_1.AutoLayoutLayeredVerticalBottomToTopCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutLayeredHorizontal, AutoLayoutLayeredHorizontalCommand_1.AutoLayoutLayeredHorizontalCommand);
        this.createCommand(control, DiagramCommand.AutoLayoutLayeredHorizontalRightToLeft, AutoLayoutLayeredHorizontalRightToLeftCommand_1.AutoLayoutLayeredHorizontalRightToLeftCommand);
        this.createCommand(control, DiagramCommand.Fullscreen, ToggleFullscreenCommand_1.ToggleFullscreenCommand, key_1.KeyCode.F11);
        this.createCommand(control, DiagramCommand.ToggleSimpleView, ToggleSimpleViewCommand_1.ToggleSimpleViewCommand);
        this.createCommand(control, DiagramCommand.ToggleReadOnly, ToggleReadOnlyCommand_1.ToggleReadOnlyCommand);
        this.createCommand(control, DiagramCommand.InsertShapeImage, InsertShapeImageCommand_1.InsertShapeImageCommand);
        this.createCommand(control, DiagramCommand.EditShapeImage, EditShapeImageCommand_1.EditShapeImageCommand);
        this.createCommand(control, DiagramCommand.DeleteShapeImage, DeleteShapeImageCommand_1.DeleteShapeImageCommand);
        this.createCommand(control, DiagramCommand.FitToScreen, ChangeZoomLevelCommand_1.FitToScreenCommand);
        this.createCommand(control, DiagramCommand.FitToWidth, ChangeZoomLevelCommand_1.FitToWidthCommand);
        this.createCommand(control, DiagramCommand.SwitchAutoZoom, ChangeZoomLevelCommand_1.SwitchAutoZoomCommand);
        this.createCommand(control, DiagramCommand.ToggleAutoZoom, ChangeZoomLevelCommand_1.ToggleAutoZoomCommand);
        this.createCommand(control, DiagramCommand.ZoomLevelItems, ChangeZoomLevelCommand_1.ChangeZoomLevelItemsCommand);
        this.createCommand(control, DiagramCommand.GridSizeItems, ChangeGridSizeCommand_1.ChangeGridSizeItemsCommand);
        this.createCommand(control, DiagramCommand.PageSizeItems, ChangePageSizeCommand_1.ChangePageSizeItemsCommand);
        this.createCommand(control, DiagramCommand.Zoom25, ChangeZoomLevelCommand_1.ChangeZoomLevelTo25Command);
        this.createCommand(control, DiagramCommand.Zoom50, ChangeZoomLevelCommand_1.ChangeZoomLevelTo50Command);
        this.createCommand(control, DiagramCommand.Zoom75, ChangeZoomLevelCommand_1.ChangeZoomLevelTo75Command);
        this.createCommand(control, DiagramCommand.Zoom100, ChangeZoomLevelCommand_1.ChangeZoomLevelTo100Command);
        this.createCommand(control, DiagramCommand.Zoom125, ChangeZoomLevelCommand_1.ChangeZoomLevelTo125Command);
        this.createCommand(control, DiagramCommand.Zoom150, ChangeZoomLevelCommand_1.ChangeZoomLevelTo150Command);
        this.createCommand(control, DiagramCommand.Zoom200, ChangeZoomLevelCommand_1.ChangeZoomLevelTo200Command);
        this.createCommand(control, DiagramCommand.AutoZoomToContent, ChangeZoomLevelCommand_1.ToggleAutoZoomToContentCommand);
        this.createCommand(control, DiagramCommand.AutoZoomToWidth, ChangeZoomLevelCommand_1.ToggleAutoZoomToWidthCommand);
        this.createCommand(control, DiagramCommand.ConnectorRoutingMode, ChangeConnectorRoutingModeCommand_1.ChangeConnectorRoutingModeCommand);
    }
    CommandManager.prototype.getCommand = function (key) {
        return this.commands[key];
    };
    CommandManager.prototype.beforeExecuting = function (command) {
        this.executingCommandsChain.push(command);
        this.executingCommandCounter++;
    };
    CommandManager.prototype.afterExecuting = function () {
        this.executingCommandCounter--;
        if (this.executingCommandCounter === 0) {
            this.lastCommandsChain = this.executingCommandsChain;
            this.executingCommandsChain = [];
        }
    };
    CommandManager.prototype.processShortcut = function (code) {
        var command = this.shortcutsToCommand[code];
        if (command)
            return command.execute();
        return false;
    };
    CommandManager.prototype.processPaste = function (clipboardData) {
        var command = this.getCommand(DiagramCommand.Paste);
        if (command && command.isEnabled())
            command.execute(clipboardData);
        return true;
    };
    CommandManager.prototype.notifySelectionChanged = function (_selection) {
        this.lastCommandsChain = [];
    };
    CommandManager.prototype.notifyScrollPositionChanged = function () { };
    CommandManager.prototype.createCommand = function (control, commandId, commandType) {
        var shortcuts = [];
        for (var _i = 3; _i < arguments.length; _i++) {
            shortcuts[_i - 3] = arguments[_i];
        }
        this.commands[commandId] = new commandType(control);
        for (var i = 0; i < shortcuts.length; i++) {
            var shortcut = shortcuts[i];
            if (typeof shortcut === "number")
                this.shortcutsToCommand[shortcut] = this.commands[commandId];
        }
    };
    return CommandManager;
}());
exports.CommandManager = CommandManager;


/***/ }),

/***/ 2102:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SimpleCommandState = void 0;
var SimpleCommandState = (function () {
    function SimpleCommandState(enabled, value, defaultValue, items, visible) {
        this.visible = true;
        this.denyUpdateValue = false;
        this.enabled = enabled;
        this.value = value;
        this.items = items;
        this.visible = visible;
        this.defaultValue = defaultValue;
    }
    return SimpleCommandState;
}());
exports.SimpleCommandState = SimpleCommandState;


/***/ }),

/***/ 264:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteCommand = void 0;
var ModelUtils_1 = __webpack_require__(4867);
var SimpleCommandBase_1 = __webpack_require__(9741);
var DeleteCommand = (function (_super) {
    __extends(DeleteCommand, _super);
    function DeleteCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    DeleteCommand.prototype.isEnabled = function () {
        var items = this.control.selection.getSelectedItems();
        return _super.prototype.isEnabled.call(this) && items.length && (items.length > 1 || this.permissionsProvider.canDeleteItems(items));
    };
    DeleteCommand.prototype.executeCore = function (state) {
        var items = this.control.selection.getSelectedItems(true, true);
        this.permissionsProvider.beginDeleteItems(items);
        ModelUtils_1.ModelUtils.deleteSelection(this.control.history, this.control.model, this.control.selection);
        this.permissionsProvider.endDeleteItems();
        return true;
    };
    Object.defineProperty(DeleteCommand.prototype, "isPermissionsRequired", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    return DeleteCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.DeleteCommand = DeleteCommand;


/***/ }),

/***/ 3614:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RedoCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(9741);
var RedoCommand = (function (_super) {
    __extends(RedoCommand, _super);
    function RedoCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    RedoCommand.prototype.executeCore = function (state) {
        this.control.beginUpdateCanvas();
        this.permissionsProvider.lockPermissions();
        this.control.history.redo();
        this.permissionsProvider.unlockPermissions();
        this.control.endUpdateCanvas();
        return true;
    };
    RedoCommand.prototype.isEnabled = function () {
        return _super.prototype.isEnabled.call(this) && this.control.history.canRedo();
    };
    return RedoCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.RedoCommand = RedoCommand;


/***/ }),

/***/ 2452:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SelectAllCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(9741);
var SelectAllCommand = (function (_super) {
    __extends(SelectAllCommand, _super);
    function SelectAllCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SelectAllCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    SelectAllCommand.prototype.executeCore = function (state, parameter) {
        var itemKeys = [];
        this.control.model.iterateItems(function (i) { return itemKeys.push(i.key); });
        this.control.selection.set(itemKeys);
        return true;
    };
    return SelectAllCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.SelectAllCommand = SelectAllCommand;


/***/ }),

/***/ 6679:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UndoCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(9741);
var UndoCommand = (function (_super) {
    __extends(UndoCommand, _super);
    function UndoCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UndoCommand.prototype.executeCore = function (state) {
        this.control.beginUpdateCanvas();
        this.permissionsProvider.lockPermissions();
        this.control.history.undo();
        this.permissionsProvider.unlockPermissions();
        this.control.endUpdateCanvas();
        return true;
    };
    UndoCommand.prototype.isEnabled = function () {
        return _super.prototype.isEnabled.call(this) && this.control.history.canUndo();
    };
    return UndoCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.UndoCommand = UndoCommand;


/***/ }),

/***/ 9538:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BindDocumentCommand = void 0;
var DataLayoutParameters_1 = __webpack_require__(3503);
var SimpleCommandBase_1 = __webpack_require__(9741);
var BindDocumentCommand = (function (_super) {
    __extends(BindDocumentCommand, _super);
    function BindDocumentCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BindDocumentCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    BindDocumentCommand.prototype.executeCore = function (state, parameter) {
        if (!parameter || !Array.isArray(parameter.nodeDataSource))
            throw Error("Format exception");
        this.performImportData(parameter);
        this.control.updateLayout(true);
        return true;
    };
    BindDocumentCommand.prototype.performImportData = function (parameter) {
        var dataSource = this.control.createDocumentDataSource(parameter.nodeDataSource, parameter.edgeDataSource, parameter.dataParameters, parameter.nodeDataImporter, parameter.edgeDataImporter);
        this.control.beginUpdateCanvas();
        this.permissionsProvider.lockPermissions();
        var layoutParameters = new DataLayoutParameters_1.DataLayoutParameters(this.control.settings, parameter.layoutParameters);
        dataSource.createModelItems(this.control.history, this.control.model, this.control.shapeDescriptionManager, this.control.selection, layoutParameters, this.control.settings.snapToGrid, this.control.settings.gridSize, this.control.measurer);
        this.permissionsProvider.unlockPermissions();
        this.control.endUpdateCanvas();
    };
    return BindDocumentCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.BindDocumentCommand = BindDocumentCommand;


/***/ }),

/***/ 125:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UnbindDocumentCommand = void 0;
var ModelUtils_1 = __webpack_require__(4867);
var SimpleCommandBase_1 = __webpack_require__(9741);
var UnbindDocumentCommand = (function (_super) {
    __extends(UnbindDocumentCommand, _super);
    function UnbindDocumentCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UnbindDocumentCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    UnbindDocumentCommand.prototype.executeCore = function (state) {
        this.permissionsProvider.lockPermissions();
        this.control.deleteDocumentDataSource();
        ModelUtils_1.ModelUtils.deleteAllItems(this.control.history, this.control.model, this.control.selection);
        this.control.history.clear();
        this.permissionsProvider.unlockPermissions();
        return true;
    };
    return UnbindDocumentCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.UnbindDocumentCommand = UnbindDocumentCommand;


/***/ }),

/***/ 4845:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExportCommand = void 0;
var Exporter_1 = __webpack_require__(5885);
var ExportImportCommandBase_1 = __webpack_require__(1081);
var ExportCommand = (function (_super) {
    __extends(ExportCommand, _super);
    function ExportCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportCommand.prototype.executeCore = function (state, parameter) {
        var exporter = new Exporter_1.Exporter();
        var data = exporter.export(this.control.model);
        parameter(data);
        return true;
    };
    return ExportCommand;
}(ExportImportCommandBase_1.ExportImportCommandBase));
exports.ExportCommand = ExportCommand;


/***/ }),

/***/ 4012:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExportImageCommand = void 0;
var CanvasItemsManager_1 = __webpack_require__(8693);
var CanvasExportManager_1 = __webpack_require__(3872);
var ExportImportCommandBase_1 = __webpack_require__(1081);
var Exporter_1 = __webpack_require__(5885);
var RenderHelper_1 = __webpack_require__(1114);
var TextMeasurer_1 = __webpack_require__(1733);
var DOMManipulator_1 = __webpack_require__(6078);
var ImageCache_1 = __webpack_require__(7176);
var ExportImageCommand = (function (_super) {
    __extends(ExportImageCommand, _super);
    function ExportImageCommand(control) {
        var _this = _super.call(this, control) || this;
        _this.exporter = new Exporter_1.Exporter();
        return _this;
    }
    ExportImageCommand.prototype.isEnabled = function () {
        return !ImageCache_1.ImageCache.instance.hasNonLoadedImages();
    };
    ExportImageCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        try {
            var exportManager = this.getExportManager();
            var exportFunc = this.getExportFunc();
            exportFunc(this.control.model.size.clone(), this.control.model.pageColor, exportManager, function (url) {
                parameter(url, _this.getExtension());
                _this.tryDispose();
            }, this.control.settings.useCanvgForExportToImage);
        }
        catch (e) {
            this.tryDispose();
            throw e;
        }
        return true;
    };
    ExportImageCommand.prototype.getExportManager = function () {
        var measurer = this.getOrCreateMeasurer();
        var itemsManager = (this.control.render && this.control.render.items) || this.createItemsManager(measurer);
        return this.exportManager || (this.exportManager = new CanvasExportManager_1.CanvasExportManager(itemsManager.itemsContainer, measurer, this.control.instanceId));
    };
    ExportImageCommand.prototype.createItemsManager = function (measurer) {
        this.svgElement = RenderHelper_1.RenderHelper.createSvgElement(document.body, true);
        var canvasManager = new CanvasItemsManager_1.CanvasItemsManager(this.svgElement, 1, new DOMManipulator_1.ExportDOMManipulator(measurer), this.control.instanceId);
        this.control.modelManipulator.onModelChanged.add(canvasManager);
        this.control.modelManipulator.commitItemsCreateChanges();
        return canvasManager;
    };
    ExportImageCommand.prototype.tryDispose = function () {
        if (this.svgElement) {
            document.body.removeChild(this.svgElement);
            delete this.svgElement;
        }
        if (this.tempMeasurer) {
            this.tempMeasurer.clean();
            this.tempMeasurer = undefined;
        }
        this.exportManager = undefined;
    };
    ExportImageCommand.prototype.getOrCreateMeasurer = function () {
        return this.control.measurer || (this.tempMeasurer = new TextMeasurer_1.TextMeasurer(document.body));
    };
    return ExportImageCommand;
}(ExportImportCommandBase_1.ExportImportCommandBase));
exports.ExportImageCommand = ExportImageCommand;


/***/ }),

/***/ 1081:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExportImportCommandBase = void 0;
var SimpleCommandBase_1 = __webpack_require__(9741);
var ExportImportCommandBase = (function (_super) {
    __extends(ExportImportCommandBase, _super);
    function ExportImportCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportImportCommandBase.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    return ExportImportCommandBase;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ExportImportCommandBase = ExportImportCommandBase;


/***/ }),

/***/ 1203:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExportJpgCommand = void 0;
var ExportImageCommand_1 = __webpack_require__(4012);
var ExportJpgCommand = (function (_super) {
    __extends(ExportJpgCommand, _super);
    function ExportJpgCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportJpgCommand.prototype.getExtension = function () { return "jpg"; };
    ExportJpgCommand.prototype.getExportFunc = function () {
        return this.exporter.exportJpg;
    };
    return ExportJpgCommand;
}(ExportImageCommand_1.ExportImageCommand));
exports.ExportJpgCommand = ExportJpgCommand;


/***/ }),

/***/ 3690:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExportPngCommand = void 0;
var ExportImageCommand_1 = __webpack_require__(4012);
var ExportPngCommand = (function (_super) {
    __extends(ExportPngCommand, _super);
    function ExportPngCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportPngCommand.prototype.getExtension = function () { return "png"; };
    ExportPngCommand.prototype.getExportFunc = function () {
        return this.exporter.exportPng;
    };
    return ExportPngCommand;
}(ExportImageCommand_1.ExportImageCommand));
exports.ExportPngCommand = ExportPngCommand;


/***/ }),

/***/ 2276:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExportSvgCommand = void 0;
var ExportImageCommand_1 = __webpack_require__(4012);
var ExportSvgCommand = (function (_super) {
    __extends(ExportSvgCommand, _super);
    function ExportSvgCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportSvgCommand.prototype.getExtension = function () { return "svg"; };
    ExportSvgCommand.prototype.getExportFunc = function () {
        return this.exporter.exportSvg;
    };
    return ExportSvgCommand;
}(ExportImageCommand_1.ExportImageCommand));
exports.ExportSvgCommand = ExportSvgCommand;


/***/ }),

/***/ 1239:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImportBPMNCommand = void 0;
var BPMNImporter_1 = __webpack_require__(5941);
var ModelUtils_1 = __webpack_require__(4867);
var AddShapeHistoryItem_1 = __webpack_require__(4145);
var point_1 = __webpack_require__(8900);
var Connector_1 = __webpack_require__(7959);
var AddConnectorHistoryItem_1 = __webpack_require__(9603);
var AddConnectionHistoryItem_1 = __webpack_require__(3477);
var Sugiyama_1 = __webpack_require__(1256);
var LayoutSettings_1 = __webpack_require__(8710);
var ExportImportCommandBase_1 = __webpack_require__(1081);
var ImportBPMNCommand = (function (_super) {
    __extends(ImportBPMNCommand, _super);
    function ImportBPMNCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ImportBPMNCommand.prototype.executeCore = function (state, parameter) {
        var importer = new BPMNImporter_1.BPMNImporter(parameter);
        var graph = importer.import();
        this.updateModel(graph);
        return true;
    };
    ImportBPMNCommand.prototype.updateModel = function (graph) {
        var _this = this;
        var externalKeyToModelKey = {};
        var shapes = [];
        var connectors = [];
        this.control.history.beginTransaction();
        graph.items.forEach(function (node) {
            var insert = new AddShapeHistoryItem_1.AddShapeHistoryItem(_this.getShapeDescription(node.type), new point_1.Point(0, 0), node.text, node.key);
            _this.control.history.addAndRedo(insert);
            externalKeyToModelKey[node.key] = insert.shapeKey;
            var shape = _this.control.model.findShape(insert.shapeKey);
            shapes.push(shape);
        });
        graph.edges.forEach(function (edge) {
            var from = _this.control.model.findShape(externalKeyToModelKey[edge.from]);
            var to = _this.control.model.findShape(externalKeyToModelKey[edge.to]);
            var insert = new AddConnectorHistoryItem_1.AddConnectorHistoryItem([from.getConnectionPointPosition(0), to.getConnectionPointPosition(0)]);
            _this.control.history.addAndRedo(insert);
            var connector = _this.control.model.findConnector(insert.connectorKey);
            _this.control.history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(connector, from, 0, Connector_1.ConnectorPosition.Begin));
            _this.control.history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(connector, to, 0, Connector_1.ConnectorPosition.End));
            connectors.push(connector);
        });
        var settings = new LayoutSettings_1.LayoutSettings();
        var graphInfo = ModelUtils_1.ModelUtils.getGraphInfoByItems(this.control.model, shapes, connectors);
        graphInfo.forEach(function (info) {
            var layout = new Sugiyama_1.SugiyamaLayoutBuilder(settings, info.graph).build();
            var nonGraphItems = ModelUtils_1.ModelUtils.getNonGraphItems(_this.control.model, info.container, layout.nodeToLayout, shapes, connectors);
            ModelUtils_1.ModelUtils.applyLayout(_this.control.history, _this.control.model, undefined, info.graph, layout, nonGraphItems, settings, _this.control.settings.snapToGrid, _this.control.settings.gridSize, false);
        });
        ModelUtils_1.ModelUtils.tryUpdateModelRectangle(this.control.history);
        this.control.history.endTransaction();
    };
    ImportBPMNCommand.prototype.getShapeDescription = function (shapeType) {
        return this.control.shapeDescriptionManager.get(shapeType);
    };
    return ImportBPMNCommand;
}(ExportImportCommandBase_1.ExportImportCommandBase));
exports.ImportBPMNCommand = ImportBPMNCommand;


/***/ }),

/***/ 6596:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImportCommand = void 0;
var Importer_1 = __webpack_require__(2406);
var ExportImportCommandBase_1 = __webpack_require__(1081);
var ImportCommand = (function (_super) {
    __extends(ImportCommand, _super);
    function ImportCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ImportCommand.prototype.executeCore = function (state, parameter) {
        this.permissionsProvider.lockPermissions();
        var data = parameter["data"] ? parameter["data"] : parameter;
        var importer = new Importer_1.Importer(this.control.shapeDescriptionManager, data);
        if (parameter["keepExistingItems"] === true) {
            importer.importItemsData(this.control.model);
            this.control.importItemsData();
        }
        else {
            var model = importer.import();
            this.control.importModel(model);
        }
        this.permissionsProvider.unlockPermissions();
        return true;
    };
    return ImportCommand;
}(ExportImportCommandBase_1.ExportImportCommandBase));
exports.ImportCommand = ImportCommand;


/***/ }),

/***/ 5830:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImportXMLCommand = void 0;
var XMLImporter_1 = __webpack_require__(780);
var ExportImportCommandBase_1 = __webpack_require__(1081);
var ImportXMLCommand = (function (_super) {
    __extends(ImportXMLCommand, _super);
    function ImportXMLCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ImportXMLCommand.prototype.executeCore = function (state, parameter) {
        var importer = new XMLImporter_1.XmlImporter(this.control.shapeDescriptionManager, parameter);
        var model = importer.import();
        this.control.importModel(model);
        return true;
    };
    return ImportXMLCommand;
}(ExportImportCommandBase_1.ExportImportCommandBase));
exports.ImportXMLCommand = ImportXMLCommand;


/***/ }),

/***/ 4999:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CloneDownCommand = exports.CloneUpCommand = exports.CloneRightCommand = exports.CloneLeftCommand = exports.CloneCommand = void 0;
var ModelUtils_1 = __webpack_require__(4867);
var SimpleCommandBase_1 = __webpack_require__(9741);
var CloneCommand = (function (_super) {
    __extends(CloneCommand, _super);
    function CloneCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CloneCommand.prototype.isEnabled = function () {
        var items = this.control.selection.getSelectedItems();
        return _super.prototype.isEnabled.call(this) && items.length && items.length > 0 && this.permissionsProvider.canAddItems(items);
    };
    CloneCommand.prototype.executeCore = function (state, parameter) {
        var selectionRect = ModelUtils_1.ModelUtils.createRectangle(this.control.selection.getSelectedItems());
        ModelUtils_1.ModelUtils.cloneSelectionToOffset(this.control.history, this.control.model, undefined, this.control.selection, this.getOffsetX(selectionRect), this.getOffsetY(selectionRect));
        return true;
    };
    Object.defineProperty(CloneCommand.prototype, "isPermissionsRequired", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    CloneCommand.prototype.getOffsetX = function (selectionRect) {
        return 0;
    };
    CloneCommand.prototype.getOffsetY = function (selectionRect) {
        return 0;
    };
    return CloneCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.CloneCommand = CloneCommand;
var CloneLeftCommand = (function (_super) {
    __extends(CloneLeftCommand, _super);
    function CloneLeftCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CloneLeftCommand.prototype.getOffsetX = function (selectionRect) {
        return -selectionRect.width;
    };
    return CloneLeftCommand;
}(CloneCommand));
exports.CloneLeftCommand = CloneLeftCommand;
var CloneRightCommand = (function (_super) {
    __extends(CloneRightCommand, _super);
    function CloneRightCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CloneRightCommand.prototype.getOffsetX = function (selectionRect) {
        return selectionRect.width;
    };
    return CloneRightCommand;
}(CloneCommand));
exports.CloneRightCommand = CloneRightCommand;
var CloneUpCommand = (function (_super) {
    __extends(CloneUpCommand, _super);
    function CloneUpCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CloneUpCommand.prototype.getOffsetY = function (selectionRect) {
        return -selectionRect.height;
    };
    return CloneUpCommand;
}(CloneCommand));
exports.CloneUpCommand = CloneUpCommand;
var CloneDownCommand = (function (_super) {
    __extends(CloneDownCommand, _super);
    function CloneDownCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CloneDownCommand.prototype.getOffsetY = function (selectionRect) {
        return selectionRect.height;
    };
    return CloneDownCommand;
}(CloneCommand));
exports.CloneDownCommand = CloneDownCommand;


/***/ }),

/***/ 5925:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MoveStepDownCommand = exports.MoveDownCommand = exports.MoveStepUpCommand = exports.MoveUpCommand = exports.MoveStepRightCommand = exports.MoveRightCommand = exports.MoveStepLeftCommand = exports.MoveLeftCommand = exports.MoveCommand = void 0;
var point_1 = __webpack_require__(8900);
var ModelUtils_1 = __webpack_require__(4867);
var unit_converter_1 = __webpack_require__(9291);
var SimpleCommandBase_1 = __webpack_require__(9741);
var DragHelper_1 = __webpack_require__(4742);
var MoveCommand = (function (_super) {
    __extends(MoveCommand, _super);
    function MoveCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveCommand.prototype.isEnabled = function () {
        return _super.prototype.isEnabled.call(this) && !this.control.selection.isEmpty();
    };
    MoveCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var selection = this.control.selection;
        var helper = new DragHelper_1.SelectionDragHelper(this.control.history, this.control.model, this.permissionsProvider, new point_1.Point(0, 0), selection.getSelectedItems(true));
        helper.initDraggingShapes(selection.getSelectedShapes(false, true), false);
        helper.initDraggingConnectors(selection.getSelectedConnectors(false, true), false);
        helper.move(false, function (p) { return _this.getPosition(p); }, function () { }, function () { });
        helper.finish();
        ModelUtils_1.ModelUtils.tryUpdateModelRectangle(this.control.history, function (offsetLeft, offsetTop) { return helper.onTryUpdateModelSize(offsetLeft, offsetTop); });
        this.control.history.endTransaction();
        return true;
    };
    Object.defineProperty(MoveCommand.prototype, "isPermissionsRequired", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    return MoveCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.MoveCommand = MoveCommand;
var MoveLeftCommand = (function (_super) {
    __extends(MoveLeftCommand, _super);
    function MoveLeftCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveLeftCommand.prototype.getPosition = function (position) {
        return position.clone().offset(-unit_converter_1.UnitConverter.pixelsToTwips(1), 0);
    };
    return MoveLeftCommand;
}(MoveCommand));
exports.MoveLeftCommand = MoveLeftCommand;
var MoveStepLeftCommand = (function (_super) {
    __extends(MoveStepLeftCommand, _super);
    function MoveStepLeftCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveStepLeftCommand.prototype.getPosition = function (position) {
        if (this.control.settings.snapToGrid)
            return new point_1.Point(ModelUtils_1.ModelUtils.getSnappedPos(this.control.model, this.control.settings.gridSize, position.x - (this.control.settings.gridSize / 2 + 2), true), position.y);
        else
            return position.clone().offset(-this.control.settings.gridSize, 0);
    };
    return MoveStepLeftCommand;
}(MoveCommand));
exports.MoveStepLeftCommand = MoveStepLeftCommand;
var MoveRightCommand = (function (_super) {
    __extends(MoveRightCommand, _super);
    function MoveRightCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveRightCommand.prototype.getPosition = function (position) {
        return position.clone().offset(unit_converter_1.UnitConverter.pixelsToTwips(1), 0);
    };
    return MoveRightCommand;
}(MoveCommand));
exports.MoveRightCommand = MoveRightCommand;
var MoveStepRightCommand = (function (_super) {
    __extends(MoveStepRightCommand, _super);
    function MoveStepRightCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveStepRightCommand.prototype.getPosition = function (position) {
        if (this.control.settings.snapToGrid)
            return new point_1.Point(ModelUtils_1.ModelUtils.getSnappedPos(this.control.model, this.control.settings.gridSize, position.x + (this.control.settings.gridSize / 2 + 2), true), position.y);
        else
            return position.clone().offset(this.control.settings.gridSize, 0);
    };
    return MoveStepRightCommand;
}(MoveCommand));
exports.MoveStepRightCommand = MoveStepRightCommand;
var MoveUpCommand = (function (_super) {
    __extends(MoveUpCommand, _super);
    function MoveUpCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveUpCommand.prototype.getPosition = function (position) {
        return position.clone().offset(0, -unit_converter_1.UnitConverter.pixelsToTwips(1));
    };
    return MoveUpCommand;
}(MoveCommand));
exports.MoveUpCommand = MoveUpCommand;
var MoveStepUpCommand = (function (_super) {
    __extends(MoveStepUpCommand, _super);
    function MoveStepUpCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveStepUpCommand.prototype.getPosition = function (position) {
        if (this.control.settings.snapToGrid)
            return new point_1.Point(position.x, ModelUtils_1.ModelUtils.getSnappedPos(this.control.model, this.control.settings.gridSize, position.y - (this.control.settings.gridSize / 2 + 2), false));
        else
            return position.clone().offset(0, -this.control.settings.gridSize);
    };
    return MoveStepUpCommand;
}(MoveCommand));
exports.MoveStepUpCommand = MoveStepUpCommand;
var MoveDownCommand = (function (_super) {
    __extends(MoveDownCommand, _super);
    function MoveDownCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveDownCommand.prototype.getPosition = function (position) {
        return position.clone().offset(0, unit_converter_1.UnitConverter.pixelsToTwips(1));
    };
    return MoveDownCommand;
}(MoveCommand));
exports.MoveDownCommand = MoveDownCommand;
var MoveStepDownCommand = (function (_super) {
    __extends(MoveStepDownCommand, _super);
    function MoveStepDownCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveStepDownCommand.prototype.getPosition = function (position) {
        if (this.control.settings.snapToGrid)
            return new point_1.Point(position.x, ModelUtils_1.ModelUtils.getSnappedPos(this.control.model, this.control.settings.gridSize, position.y + (this.control.settings.gridSize / 2 + 2), false));
        else
            return position.clone().offset(0, this.control.settings.gridSize);
    };
    return MoveStepDownCommand;
}(MoveCommand));
exports.MoveStepDownCommand = MoveStepDownCommand;


/***/ }),

/***/ 7550:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeGridSizeItemsCommand = exports.ChangeGridSizeCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(9741);
var ChangeGridSizeCommand = (function (_super) {
    __extends(ChangeGridSizeCommand, _super);
    function ChangeGridSizeCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeGridSizeCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ChangeGridSizeCommand.prototype.getValue = function () {
        return this.getModelUnit(this.control.settings.gridSize);
    };
    ChangeGridSizeCommand.prototype.executeCore = function (state, parameter) {
        this.control.settings.gridSize = this.getModelUnitTwipsValue(parameter);
        return true;
    };
    ChangeGridSizeCommand.prototype.getItems = function () {
        var _this = this;
        return this.control.settings.gridSizeItems.map(function (s) {
            return { value: _this.getModelUnit(s), text: _this.getViewUnitText(s) };
        });
    };
    return ChangeGridSizeCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeGridSizeCommand = ChangeGridSizeCommand;
var ChangeGridSizeItemsCommand = (function (_super) {
    __extends(ChangeGridSizeItemsCommand, _super);
    function ChangeGridSizeItemsCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeGridSizeItemsCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ChangeGridSizeItemsCommand.prototype.getValue = function () {
        var _this = this;
        return this.control.settings.gridSizeItems.map(function (s) { return _this.getModelUnit(s); });
    };
    ChangeGridSizeItemsCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.settings.gridSizeItems = parameter.map(function (s) { return _this.getModelUnitTwipsValue(s); });
        return true;
    };
    return ChangeGridSizeItemsCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeGridSizeItemsCommand = ChangeGridSizeItemsCommand;


/***/ }),

/***/ 8016:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangePageColorCommand = void 0;
var ChangePagePropertyCommand_1 = __webpack_require__(3499);
var ChangePageColorHistoryItem_1 = __webpack_require__(7195);
var Model_1 = __webpack_require__(6613);
var color_1 = __webpack_require__(13);
var ChangePageColorCommand = (function (_super) {
    __extends(ChangePageColorCommand, _super);
    function ChangePageColorCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePageColorCommand.prototype.getValue = function () {
        return color_1.ColorUtils.colorToHash(this.control.model.pageColor);
    };
    ChangePageColorCommand.prototype.getDefaultValue = function () {
        return color_1.ColorUtils.colorToHash(Model_1.DiagramModel.defaultPageColor);
    };
    ChangePageColorCommand.prototype.createHistoryItems = function (parameter) {
        return [new ChangePageColorHistoryItem_1.ChangePageColorHistoryItem(color_1.ColorUtils.fromString(parameter))];
    };
    return ChangePageColorCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangePageColorCommand = ChangePageColorCommand;


/***/ }),

/***/ 7649:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangePageLandscapeCommand = void 0;
var ChangePagePropertyCommand_1 = __webpack_require__(3499);
var ChangePageLandscapeHistoryItem_1 = __webpack_require__(1380);
var ChangePageLandscapeCommand = (function (_super) {
    __extends(ChangePageLandscapeCommand, _super);
    function ChangePageLandscapeCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePageLandscapeCommand.prototype.getValue = function () {
        return this.control.model.pageLandscape;
    };
    ChangePageLandscapeCommand.prototype.createHistoryItems = function (parameter) {
        return [new ChangePageLandscapeHistoryItem_1.ChangePageLandscapeHistoryItem(parameter)];
    };
    return ChangePageLandscapeCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangePageLandscapeCommand = ChangePageLandscapeCommand;


/***/ }),

/***/ 3499:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangePagePropertyCommand = void 0;
var ModelUtils_1 = __webpack_require__(4867);
var SimpleCommandBase_1 = __webpack_require__(9741);
var ChangePagePropertyCommand = (function (_super) {
    __extends(ChangePagePropertyCommand, _super);
    function ChangePagePropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePagePropertyCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var items = this.createHistoryItems(parameter);
        items.forEach(function (item) { _this.control.history.addAndRedo(item); });
        ModelUtils_1.ModelUtils.tryUpdateModelRectangle(this.control.history);
        this.control.history.endTransaction();
        return true;
    };
    ChangePagePropertyCommand.prototype.getItems = function () {
        return null;
    };
    return ChangePagePropertyCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangePagePropertyCommand = ChangePagePropertyCommand;


/***/ }),

/***/ 1813:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangePageSizeItemsCommand = exports.ChangePageSizeCommand = void 0;
var ChangePagePropertyCommand_1 = __webpack_require__(3499);
var size_1 = __webpack_require__(6353);
var ChangePageSizeHistoryItem_1 = __webpack_require__(1044);
var SimpleCommandBase_1 = __webpack_require__(9741);
var ChangePageSizeCommand = (function (_super) {
    __extends(ChangePageSizeCommand, _super);
    function ChangePageSizeCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePageSizeCommand.prototype.getValue = function () {
        return this.getModelUnitSize(this.control.model.pageSize);
    };
    ChangePageSizeCommand.prototype.createHistoryItems = function (parameter) {
        return [new ChangePageSizeHistoryItem_1.ChangePageSizeHistoryItem(new size_1.Size(this.getModelUnitTwipsValue(parameter.width), this.getModelUnitTwipsValue(parameter.height)))];
    };
    ChangePageSizeCommand.prototype.getItems = function () {
        var _this = this;
        return this.control.settings.pageSizeItems.map(function (i) {
            return {
                value: _this.getModelUnitSize(i.size),
                text: i.text.replace("{width}", _this.getViewUnitText(i.size.width)).replace("{height}", _this.getViewUnitText(i.size.height))
            };
        });
    };
    ChangePageSizeCommand.prototype.getModelUnitSize = function (size) {
        return new size_1.Size(this.getModelUnit(size.width), this.getModelUnit(size.height));
    };
    return ChangePageSizeCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangePageSizeCommand = ChangePageSizeCommand;
var ChangePageSizeItemsCommand = (function (_super) {
    __extends(ChangePageSizeItemsCommand, _super);
    function ChangePageSizeItemsCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePageSizeItemsCommand.prototype.isEnabled = function () {
        return true;
    };
    ChangePageSizeItemsCommand.prototype.getValue = function () {
        var _this = this;
        return this.control.settings.pageSizeItems.map(function (i) {
            return {
                size: new size_1.Size(_this.getModelUnit(i.width), _this.getModelUnit(i.height)),
                text: i.text
            };
        });
    };
    ChangePageSizeItemsCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.settings.pageSizeItems = parameter.map(function (i) {
            return {
                size: new size_1.Size(_this.getModelUnitTwipsValue(i.width), _this.getModelUnitTwipsValue(i.height)),
                text: i.text
            };
        });
        return true;
    };
    return ChangePageSizeItemsCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangePageSizeItemsCommand = ChangePageSizeItemsCommand;


/***/ }),

/***/ 72:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeShowGridCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(9741);
var ChangeShowGridCommand = (function (_super) {
    __extends(ChangeShowGridCommand, _super);
    function ChangeShowGridCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeShowGridCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ChangeShowGridCommand.prototype.executeCore = function (state, parameter) {
        var newValue = parameter === undefined ? !this.control.settings.showGrid : !!parameter;
        if (this.control.settings.showGrid !== newValue) {
            this.control.settings.showGrid = newValue;
            return true;
        }
        return false;
    };
    ChangeShowGridCommand.prototype.getValue = function () {
        return this.control.settings.showGrid;
    };
    return ChangeShowGridCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeShowGridCommand = ChangeShowGridCommand;


/***/ }),

/***/ 4503:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeSnapToGridCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(9741);
var ChangeSnapToGridCommand = (function (_super) {
    __extends(ChangeSnapToGridCommand, _super);
    function ChangeSnapToGridCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeSnapToGridCommand.prototype.executeCore = function (state, parameter) {
        var newValue = parameter === undefined ? !this.control.settings.snapToGrid : !!parameter;
        if (this.control.settings.snapToGrid !== newValue) {
            this.control.settings.snapToGrid = newValue;
            return true;
        }
        return false;
    };
    ChangeSnapToGridCommand.prototype.getValue = function () {
        return this.control.settings.snapToGrid;
    };
    return ChangeSnapToGridCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeSnapToGridCommand = ChangeSnapToGridCommand;


/***/ }),

/***/ 4419:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeViewUnitsCommand = exports.ChangeUnitsCommand = void 0;
var ChangePagePropertyCommand_1 = __webpack_require__(3499);
var ChangeUnitsHistoryItem_1 = __webpack_require__(7479);
var SimpleCommandBase_1 = __webpack_require__(9741);
var LocalizationService_1 = __webpack_require__(6224);
var ChangeUnitsCommand = (function (_super) {
    __extends(ChangeUnitsCommand, _super);
    function ChangeUnitsCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeUnitsCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ChangeUnitsCommand.prototype.getValue = function () {
        return this.control.model.units;
    };
    ChangeUnitsCommand.prototype.createHistoryItems = function (parameter) {
        return [new ChangeUnitsHistoryItem_1.ChangeUnitsHistoryItem(parameter)];
    };
    ChangeUnitsCommand.prototype.getItems = function () {
        return Object.keys(LocalizationService_1.DiagramLocalizationService.unitItems).map(function (key) {
            return { value: parseInt(key), text: LocalizationService_1.DiagramLocalizationService.unitItems[key] };
        });
    };
    return ChangeUnitsCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangeUnitsCommand = ChangeUnitsCommand;
var ChangeViewUnitsCommand = (function (_super) {
    __extends(ChangeViewUnitsCommand, _super);
    function ChangeViewUnitsCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeViewUnitsCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ChangeViewUnitsCommand.prototype.getValue = function () {
        return this.control.settings.viewUnits;
    };
    ChangeViewUnitsCommand.prototype.executeCore = function (state, parameter) {
        this.control.settings.viewUnits = parameter;
        return true;
    };
    ChangeViewUnitsCommand.prototype.getItems = function () {
        return Object.keys(LocalizationService_1.DiagramLocalizationService.unitItems).map(function (key) {
            return { value: parseInt(key), text: LocalizationService_1.DiagramLocalizationService.unitItems[key] };
        });
    };
    return ChangeViewUnitsCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeViewUnitsCommand = ChangeViewUnitsCommand;


/***/ }),

/***/ 4522:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleAutoZoomCommand = exports.ToggleAutoZoomToWidthCommand = exports.ToggleAutoZoomToContentCommand = exports.SwitchAutoZoomCommand = exports.FitToWidthCommand = exports.FitToScreenCommand = exports.ChangeZoomLevelItemsCommand = exports.ChangeZoomLevelTo200Command = exports.ChangeZoomLevelTo150Command = exports.ChangeZoomLevelTo125Command = exports.ChangeZoomLevelTo100Command = exports.ChangeZoomLevelTo75Command = exports.ChangeZoomLevelTo50Command = exports.ChangeZoomLevelTo25Command = exports.ChangeZoomLevelInPercentageCommand = exports.ChangeZoomLevelCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(9741);
var Settings_1 = __webpack_require__(240);
var ChangeZoomLevelCommand = (function (_super) {
    __extends(ChangeZoomLevelCommand, _super);
    function ChangeZoomLevelCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeZoomLevelCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ChangeZoomLevelCommand.prototype.getValue = function () {
        return this.control.view.getZoom();
    };
    ChangeZoomLevelCommand.prototype.executeCore = function (state, parameter) {
        this.control.settings.zoomLevel = parameter;
        this.control.settings.autoZoom = Settings_1.AutoZoomMode.Disabled;
        this.control.updateLayout(true);
        return true;
    };
    ChangeZoomLevelCommand.prototype.getItems = function () {
        return this.control.settings.zoomLevelItems.map(function (l) {
            return { value: l, text: l * 100 + "%" };
        });
    };
    return ChangeZoomLevelCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeZoomLevelCommand = ChangeZoomLevelCommand;
var ChangeZoomLevelInPercentageCommand = (function (_super) {
    __extends(ChangeZoomLevelInPercentageCommand, _super);
    function ChangeZoomLevelInPercentageCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeZoomLevelInPercentageCommand.prototype.executeCore = function (state, parameter) {
        return _super.prototype.executeCore.call(this, state, parameter / 100);
    };
    ChangeZoomLevelInPercentageCommand.prototype.getValue = function () {
        return this.control.view.getZoom() * 100;
    };
    return ChangeZoomLevelInPercentageCommand;
}(ChangeZoomLevelCommand));
exports.ChangeZoomLevelInPercentageCommand = ChangeZoomLevelInPercentageCommand;
var ChangeZoomLevelExactlyCommand = (function (_super) {
    __extends(ChangeZoomLevelExactlyCommand, _super);
    function ChangeZoomLevelExactlyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeZoomLevelExactlyCommand.prototype.getValue = function () {
        return this.control.view.getZoom() === this.exactValue;
    };
    ChangeZoomLevelExactlyCommand.prototype.executeCore = function (state, parameter) {
        _super.prototype.executeCore.call(this, state, this.exactValue);
        return true;
    };
    ChangeZoomLevelExactlyCommand.prototype.getItems = function () {
        return undefined;
    };
    return ChangeZoomLevelExactlyCommand;
}(ChangeZoomLevelCommand));
var ChangeZoomLevelTo25Command = (function (_super) {
    __extends(ChangeZoomLevelTo25Command, _super);
    function ChangeZoomLevelTo25Command() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exactValue = 0.25;
        return _this;
    }
    return ChangeZoomLevelTo25Command;
}(ChangeZoomLevelExactlyCommand));
exports.ChangeZoomLevelTo25Command = ChangeZoomLevelTo25Command;
var ChangeZoomLevelTo50Command = (function (_super) {
    __extends(ChangeZoomLevelTo50Command, _super);
    function ChangeZoomLevelTo50Command() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exactValue = 0.5;
        return _this;
    }
    return ChangeZoomLevelTo50Command;
}(ChangeZoomLevelExactlyCommand));
exports.ChangeZoomLevelTo50Command = ChangeZoomLevelTo50Command;
var ChangeZoomLevelTo75Command = (function (_super) {
    __extends(ChangeZoomLevelTo75Command, _super);
    function ChangeZoomLevelTo75Command() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exactValue = 0.75;
        return _this;
    }
    return ChangeZoomLevelTo75Command;
}(ChangeZoomLevelExactlyCommand));
exports.ChangeZoomLevelTo75Command = ChangeZoomLevelTo75Command;
var ChangeZoomLevelTo100Command = (function (_super) {
    __extends(ChangeZoomLevelTo100Command, _super);
    function ChangeZoomLevelTo100Command() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exactValue = 1;
        return _this;
    }
    return ChangeZoomLevelTo100Command;
}(ChangeZoomLevelExactlyCommand));
exports.ChangeZoomLevelTo100Command = ChangeZoomLevelTo100Command;
var ChangeZoomLevelTo125Command = (function (_super) {
    __extends(ChangeZoomLevelTo125Command, _super);
    function ChangeZoomLevelTo125Command() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exactValue = 1.25;
        return _this;
    }
    return ChangeZoomLevelTo125Command;
}(ChangeZoomLevelExactlyCommand));
exports.ChangeZoomLevelTo125Command = ChangeZoomLevelTo125Command;
var ChangeZoomLevelTo150Command = (function (_super) {
    __extends(ChangeZoomLevelTo150Command, _super);
    function ChangeZoomLevelTo150Command() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exactValue = 1.5;
        return _this;
    }
    return ChangeZoomLevelTo150Command;
}(ChangeZoomLevelExactlyCommand));
exports.ChangeZoomLevelTo150Command = ChangeZoomLevelTo150Command;
var ChangeZoomLevelTo200Command = (function (_super) {
    __extends(ChangeZoomLevelTo200Command, _super);
    function ChangeZoomLevelTo200Command() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exactValue = 2;
        return _this;
    }
    return ChangeZoomLevelTo200Command;
}(ChangeZoomLevelExactlyCommand));
exports.ChangeZoomLevelTo200Command = ChangeZoomLevelTo200Command;
var ChangeZoomLevelItemsCommand = (function (_super) {
    __extends(ChangeZoomLevelItemsCommand, _super);
    function ChangeZoomLevelItemsCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeZoomLevelItemsCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ChangeZoomLevelItemsCommand.prototype.getValue = function () {
        return this.control.settings.zoomLevelItems;
    };
    ChangeZoomLevelItemsCommand.prototype.executeCore = function (state, parameter) {
        this.control.settings.zoomLevelItems = parameter;
        return true;
    };
    return ChangeZoomLevelItemsCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeZoomLevelItemsCommand = ChangeZoomLevelItemsCommand;
var FitZoomCommandBase = (function (_super) {
    __extends(FitZoomCommandBase, _super);
    function FitZoomCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FitZoomCommandBase.prototype.isEnabled = function () {
        return _super.prototype.isEnabled.call(this) && !!this.control.render;
    };
    FitZoomCommandBase.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    FitZoomCommandBase.prototype.executeCore = function (state) {
        var zoomLevel = this.getZoomLevel();
        this.control.settings.zoomLevel = zoomLevel;
        this.control.settings.autoZoom = Settings_1.AutoZoomMode.Disabled;
        this.control.updateLayout(true);
        return true;
    };
    return FitZoomCommandBase;
}(SimpleCommandBase_1.SimpleCommandBase));
var FitToScreenCommand = (function (_super) {
    __extends(FitToScreenCommand, _super);
    function FitToScreenCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FitToScreenCommand.prototype.getZoomLevel = function () {
        return this.control.render.view.getActualAutoZoomLevel(Settings_1.AutoZoomMode.FitContent);
    };
    return FitToScreenCommand;
}(FitZoomCommandBase));
exports.FitToScreenCommand = FitToScreenCommand;
var FitToWidthCommand = (function (_super) {
    __extends(FitToWidthCommand, _super);
    function FitToWidthCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FitToWidthCommand.prototype.getZoomLevel = function () {
        return this.control.render.view.getActualAutoZoomLevel(Settings_1.AutoZoomMode.FitToWidth);
    };
    return FitToWidthCommand;
}(FitZoomCommandBase));
exports.FitToWidthCommand = FitToWidthCommand;
var SwitchAutoZoomCommand = (function (_super) {
    __extends(SwitchAutoZoomCommand, _super);
    function SwitchAutoZoomCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SwitchAutoZoomCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    SwitchAutoZoomCommand.prototype.getValue = function () {
        return this.control.settings.autoZoom;
    };
    SwitchAutoZoomCommand.prototype.executeCore = function (state, value) {
        value = parseInt(value);
        if (this.control.settings.autoZoom === value)
            return false;
        if (value === Settings_1.AutoZoomMode.Disabled)
            this.control.settings.zoomLevel = this.control.view.getZoom();
        this.control.settings.autoZoom = value;
        this.control.updateLayout(true);
        return true;
    };
    return SwitchAutoZoomCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.SwitchAutoZoomCommand = SwitchAutoZoomCommand;
var ToggleAutoZoomToContentCommand = (function (_super) {
    __extends(ToggleAutoZoomToContentCommand, _super);
    function ToggleAutoZoomToContentCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleAutoZoomToContentCommand.prototype.getValue = function () {
        return this.control.settings.autoZoom === Settings_1.AutoZoomMode.FitContent;
    };
    ToggleAutoZoomToContentCommand.prototype.executeCore = function (state, value) {
        return _super.prototype.executeCore.call(this, state, Settings_1.AutoZoomMode.FitContent);
    };
    return ToggleAutoZoomToContentCommand;
}(SwitchAutoZoomCommand));
exports.ToggleAutoZoomToContentCommand = ToggleAutoZoomToContentCommand;
var ToggleAutoZoomToWidthCommand = (function (_super) {
    __extends(ToggleAutoZoomToWidthCommand, _super);
    function ToggleAutoZoomToWidthCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleAutoZoomToWidthCommand.prototype.getValue = function () {
        return this.control.settings.autoZoom === Settings_1.AutoZoomMode.FitToWidth;
    };
    ToggleAutoZoomToWidthCommand.prototype.executeCore = function (state, value) {
        return _super.prototype.executeCore.call(this, state, Settings_1.AutoZoomMode.FitToWidth);
    };
    return ToggleAutoZoomToWidthCommand;
}(SwitchAutoZoomCommand));
exports.ToggleAutoZoomToWidthCommand = ToggleAutoZoomToWidthCommand;
var ToggleAutoZoomCommand = (function (_super) {
    __extends(ToggleAutoZoomCommand, _super);
    function ToggleAutoZoomCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleAutoZoomCommand.prototype.isEnabled = function () {
        return _super.prototype.isEnabled.call(this) && !!this.control.render;
    };
    ToggleAutoZoomCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ToggleAutoZoomCommand.prototype.getValue = function () {
        return this.control.settings.autoZoom;
    };
    ToggleAutoZoomCommand.prototype.executeCore = function (state, value) {
        var newValue;
        if (value === undefined)
            newValue = this.control.settings.autoZoom === Settings_1.AutoZoomMode.Disabled ? Settings_1.AutoZoomMode.FitContent : Settings_1.AutoZoomMode.Disabled;
        else
            newValue = value ? Settings_1.AutoZoomMode.FitContent : Settings_1.AutoZoomMode.Disabled;
        if (this.control.settings.autoZoom === newValue)
            return false;
        if (!newValue)
            this.control.settings.zoomLevel = this.control.view.getZoom();
        this.control.settings.autoZoom = newValue;
        this.control.updateLayout(true);
        return true;
    };
    return ToggleAutoZoomCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ToggleAutoZoomCommand = ToggleAutoZoomCommand;


/***/ }),

/***/ 6619:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleFullscreenCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(9741);
var ToggleFullscreenCommand = (function (_super) {
    __extends(ToggleFullscreenCommand, _super);
    function ToggleFullscreenCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleFullscreenCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ToggleFullscreenCommand.prototype.getValue = function () {
        return this.control.settings.fullscreen;
    };
    ToggleFullscreenCommand.prototype.executeCore = function (state, parameter) {
        var newValue = typeof parameter === "boolean" ? parameter : !state.value;
        if (this.control.settings.fullscreen !== newValue) {
            this.control.settings.fullscreen = !state.value;
            this.control.notifyToggleFullscreen(this.control.settings.fullscreen);
        }
        return true;
    };
    return ToggleFullscreenCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ToggleFullscreenCommand = ToggleFullscreenCommand;


/***/ }),

/***/ 9970:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleReadOnlyCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(9741);
var ToggleReadOnlyCommand = (function (_super) {
    __extends(ToggleReadOnlyCommand, _super);
    function ToggleReadOnlyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleReadOnlyCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ToggleReadOnlyCommand.prototype.getValue = function () {
        return this.control.settings.readOnly;
    };
    ToggleReadOnlyCommand.prototype.executeCore = function (state, parameter) {
        if (typeof parameter === "boolean")
            this.control.settings.readOnly = parameter;
        else if (parameter === undefined)
            this.control.settings.readOnly = !state.value;
        return true;
    };
    return ToggleReadOnlyCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ToggleReadOnlyCommand = ToggleReadOnlyCommand;


/***/ }),

/***/ 7795:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleSimpleViewCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(9741);
var ToggleSimpleViewCommand = (function (_super) {
    __extends(ToggleSimpleViewCommand, _super);
    function ToggleSimpleViewCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleSimpleViewCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ToggleSimpleViewCommand.prototype.getValue = function () {
        return this.control.settings.simpleView;
    };
    ToggleSimpleViewCommand.prototype.executeCore = function (state, parameter) {
        if (typeof parameter === "boolean")
            this.control.settings.simpleView = parameter;
        else if (parameter === undefined)
            this.control.settings.simpleView = !state.value;
        this.control.updateLayout(true);
        return true;
    };
    return ToggleSimpleViewCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ToggleSimpleViewCommand = ToggleSimpleViewCommand;


/***/ }),

/***/ 3591:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BringToFrontCommand = void 0;
var ChangeZindexHistoryItem_1 = __webpack_require__(5982);
var SimpleCommandBase_1 = __webpack_require__(9741);
var BringToFrontCommand = (function (_super) {
    __extends(BringToFrontCommand, _super);
    function BringToFrontCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BringToFrontCommand.prototype.isEnabled = function () {
        var items = this.control.selection.getSelectedItems();
        return _super.prototype.isEnabled.call(this) && items.length > 0 && this.needBringToFront(items);
    };
    BringToFrontCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var items = this.control.selection.getSelectedItems();
        items.forEach(function (item) {
            var newZIndex = _this.control.model.getIntersectItemsMaxZIndex(item) + 1;
            _this.control.history.addAndRedo(new ChangeZindexHistoryItem_1.ChangeZindexHistoryItem(item, newZIndex));
        });
        this.control.history.endTransaction();
        return true;
    };
    BringToFrontCommand.prototype.needBringToFront = function (items) {
        var _this = this;
        var _loop_1 = function (i) {
            var zIndex = this_1.control.model.getIntersectItemsMaxZIndex(items[i]);
            if (zIndex > items[i].zIndex)
                return { value: true };
            if (zIndex === items[i].zIndex) {
                var result_1 = false;
                var sameZIndexItems = this_1.control.model.getIntersectItems(items[i]).filter(function (item) { return item.zIndex === items[i].zIndex; });
                sameZIndexItems.forEach(function (item) {
                    if (_this.control.model.getItemIndex(item) > _this.control.model.getItemIndex(items[i])) {
                        result_1 = true;
                        return;
                    }
                });
                return { value: result_1 };
            }
        };
        var this_1 = this;
        for (var i = 0; i < items.length; i++) {
            var state_1 = _loop_1(i);
            if (typeof state_1 === "object")
                return state_1.value;
        }
        return false;
    };
    return BringToFrontCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.BringToFrontCommand = BringToFrontCommand;


/***/ }),

/***/ 2301:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeConnectorEndLineEndingCommand = exports.ChangeConnectorStartLineEndingCommand = void 0;
var ChangeConnectorPropertyCommand_1 = __webpack_require__(7551);
var ConnectorProperties_1 = __webpack_require__(4612);
var ChangeConnectorStartLineEndingCommand = (function (_super) {
    __extends(ChangeConnectorStartLineEndingCommand, _super);
    function ChangeConnectorStartLineEndingCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorStartLineEndingCommand.prototype.getPropertyName = function () {
        return "startLineEnding";
    };
    ChangeConnectorStartLineEndingCommand.prototype.getPropertyDefaultValue = function () {
        return ConnectorProperties_1.ConnectorLineEnding.None;
    };
    return ChangeConnectorStartLineEndingCommand;
}(ChangeConnectorPropertyCommand_1.ChangeConnectorPropertyCommand));
exports.ChangeConnectorStartLineEndingCommand = ChangeConnectorStartLineEndingCommand;
var ChangeConnectorEndLineEndingCommand = (function (_super) {
    __extends(ChangeConnectorEndLineEndingCommand, _super);
    function ChangeConnectorEndLineEndingCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorEndLineEndingCommand.prototype.getPropertyName = function () {
        return "endLineEnding";
    };
    ChangeConnectorEndLineEndingCommand.prototype.getPropertyDefaultValue = function () {
        return ConnectorProperties_1.ConnectorLineEnding.Arrow;
    };
    return ChangeConnectorEndLineEndingCommand;
}(ChangeConnectorPropertyCommand_1.ChangeConnectorPropertyCommand));
exports.ChangeConnectorEndLineEndingCommand = ChangeConnectorEndLineEndingCommand;


/***/ }),

/***/ 7306:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeConnectorLineOptionCommand = void 0;
var ChangeConnectorPropertyCommand_1 = __webpack_require__(7551);
var ConnectorProperties_1 = __webpack_require__(4612);
var ChangeConnectorLineOptionCommand = (function (_super) {
    __extends(ChangeConnectorLineOptionCommand, _super);
    function ChangeConnectorLineOptionCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorLineOptionCommand.prototype.getPropertyName = function () {
        return "lineOption";
    };
    ChangeConnectorLineOptionCommand.prototype.getPropertyDefaultValue = function () {
        return ConnectorProperties_1.ConnectorLineOption.Straight;
    };
    return ChangeConnectorLineOptionCommand;
}(ChangeConnectorPropertyCommand_1.ChangeConnectorPropertyCommand));
exports.ChangeConnectorLineOptionCommand = ChangeConnectorLineOptionCommand;


/***/ }),

/***/ 7551:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeConnectorPropertyCommand = void 0;
var ChangeConnectorPropertyHistoryItem_1 = __webpack_require__(8236);
var SimpleCommandBase_1 = __webpack_require__(9741);
var ChangeConnectorPropertyCommand = (function (_super) {
    __extends(ChangeConnectorPropertyCommand, _super);
    function ChangeConnectorPropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorPropertyCommand.prototype.getValue = function () {
        return this.control.selection.inputPosition.getCurrentConnectorPropertyValue(this.getPropertyName());
    };
    ChangeConnectorPropertyCommand.prototype.getDefaultValue = function () {
        return this.getPropertyDefaultValue();
    };
    ChangeConnectorPropertyCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var connectors = this.control.selection.getSelectedConnectors();
        connectors.forEach(function (connector) {
            var propertyName = _this.getPropertyName();
            _this.control.history.addAndRedo(new ChangeConnectorPropertyHistoryItem_1.ChangeConnectorPropertyHistoryItem(connector.key, propertyName, parameter));
        });
        this.control.selection.inputPosition.setConnectorPropertyValue(this.getPropertyName(), parameter);
        this.control.history.endTransaction();
        return true;
    };
    ChangeConnectorPropertyCommand.prototype.lockInputPositionUpdating = function () {
        return true;
    };
    ChangeConnectorPropertyCommand.prototype.isEnabled = function () {
        var connectors = this.control.selection.getSelectedConnectors();
        return _super.prototype.isEnabled.call(this) && connectors.length > 0;
    };
    return ChangeConnectorPropertyCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeConnectorPropertyCommand = ChangeConnectorPropertyCommand;


/***/ }),

/***/ 7717:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeConnectorRoutingModeCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(9741);
var Settings_1 = __webpack_require__(240);
var ChangeConnectorRoutingModeCommand = (function (_super) {
    __extends(ChangeConnectorRoutingModeCommand, _super);
    function ChangeConnectorRoutingModeCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorRoutingModeCommand.prototype.getValue = function () {
        return this.control.settings.connectorRoutingMode;
    };
    ChangeConnectorRoutingModeCommand.prototype.executeCore = function (state, parameter) {
        var mode = parameter !== undefined ? parameter : Settings_1.ConnectorRoutingMode.None;
        this.control.settings.connectorRoutingMode = mode;
        return true;
    };
    return ChangeConnectorRoutingModeCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeConnectorRoutingModeCommand = ChangeConnectorRoutingModeCommand;


/***/ }),

/***/ 1307:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeLockedCommand = void 0;
var ModelUtils_1 = __webpack_require__(4867);
var SimpleCommandBase_1 = __webpack_require__(9741);
var ChangeLockedCommand = (function (_super) {
    __extends(ChangeLockedCommand, _super);
    function ChangeLockedCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeLockedCommand.prototype.isEnabled = function () {
        var _this = this;
        var items = this.control.selection.getSelectedItems(true);
        var enabled = false;
        items.forEach(function (item) { if (item.locked !== _this.getLockState())
            enabled = true; });
        return _super.prototype.isEnabled.call(this) && enabled;
    };
    ChangeLockedCommand.prototype.executeCore = function (state, parameter) {
        ModelUtils_1.ModelUtils.changeSelectionLocked(this.control.history, this.control.model, this.control.selection, this.getLockState());
        return true;
    };
    return ChangeLockedCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeLockedCommand = ChangeLockedCommand;


/***/ }),

/***/ 9031:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LockCommand = void 0;
var ChangeLockedCommand_1 = __webpack_require__(1307);
var LockCommand = (function (_super) {
    __extends(LockCommand, _super);
    function LockCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    LockCommand.prototype.getLockState = function () {
        return true;
    };
    return LockCommand;
}(ChangeLockedCommand_1.ChangeLockedCommand));
exports.LockCommand = LockCommand;


/***/ }),

/***/ 4624:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SendToBackCommand = void 0;
var ChangeZindexHistoryItem_1 = __webpack_require__(5982);
var SimpleCommandBase_1 = __webpack_require__(9741);
var SendToBackCommand = (function (_super) {
    __extends(SendToBackCommand, _super);
    function SendToBackCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SendToBackCommand.prototype.isEnabled = function () {
        var items = this.control.selection.getSelectedItems();
        return _super.prototype.isEnabled.call(this) && items.length > 0 && this.needSendToBack(items);
    };
    SendToBackCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var items = this.control.selection.getSelectedItems();
        items.forEach(function (item) {
            var newZIndex = _this.control.model.getIntersectItemsMinZIndex(item) - 1;
            _this.control.history.addAndRedo(new ChangeZindexHistoryItem_1.ChangeZindexHistoryItem(item, newZIndex));
        });
        this.control.history.endTransaction();
        return true;
    };
    SendToBackCommand.prototype.needSendToBack = function (items) {
        var _this = this;
        var _loop_1 = function (i) {
            var zIndex = this_1.control.model.getIntersectItemsMinZIndex(items[i]);
            if (zIndex < items[i].zIndex)
                return { value: true };
            if (zIndex === items[i].zIndex) {
                var result_1 = false;
                var sameZIndexItems = this_1.control.model.getIntersectItems(items[i]).filter(function (item) { return item.zIndex === items[i].zIndex; });
                sameZIndexItems.forEach(function (item) {
                    if (_this.control.model.getItemIndex(item) < _this.control.model.getItemIndex(items[i])) {
                        result_1 = true;
                        return;
                    }
                });
                return { value: result_1 };
            }
        };
        var this_1 = this;
        for (var i = 0; i < items.length; i++) {
            var state_1 = _loop_1(i);
            if (typeof state_1 === "object")
                return state_1.value;
        }
        return false;
    };
    return SendToBackCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.SendToBackCommand = SendToBackCommand;


/***/ }),

/***/ 6049:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UnLockCommand = void 0;
var ChangeLockedCommand_1 = __webpack_require__(1307);
var UnLockCommand = (function (_super) {
    __extends(UnLockCommand, _super);
    function UnLockCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UnLockCommand.prototype.getLockState = function () {
        return false;
    };
    return UnLockCommand;
}(ChangeLockedCommand_1.ChangeLockedCommand));
exports.UnLockCommand = UnLockCommand;


/***/ }),

/***/ 962:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteShapeImageCommand = void 0;
var EditShapeImageCommandBase_1 = __webpack_require__(7650);
var DeleteShapeImageCommand = (function (_super) {
    __extends(DeleteShapeImageCommand, _super);
    function DeleteShapeImageCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    DeleteShapeImageCommand.prototype.isEnabled = function () {
        var selectedShape = this.getSelectedShape();
        return _super.prototype.isEnabled.call(this) && !selectedShape.image.isEmpty;
    };
    DeleteShapeImageCommand.prototype.executeCore = function (state, parameter) {
        return _super.prototype.executeCore.call(this, state, undefined);
    };
    return DeleteShapeImageCommand;
}(EditShapeImageCommandBase_1.EditShapeImageCommandBase));
exports.DeleteShapeImageCommand = DeleteShapeImageCommand;


/***/ }),

/***/ 4281:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EditShapeImageCommand = void 0;
var EditShapeImageCommandBase_1 = __webpack_require__(7650);
var EditShapeImageCommand = (function (_super) {
    __extends(EditShapeImageCommand, _super);
    function EditShapeImageCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    EditShapeImageCommand.prototype.isEnabled = function () {
        var selectedShape = this.getSelectedShape();
        return _super.prototype.isEnabled.call(this) && !selectedShape.image.isEmpty;
    };
    return EditShapeImageCommand;
}(EditShapeImageCommandBase_1.EditShapeImageCommandBase));
exports.EditShapeImageCommand = EditShapeImageCommand;


/***/ }),

/***/ 7650:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EditShapeImageCommandBase = void 0;
var ChangeShapeImageHistoryItem_1 = __webpack_require__(8210);
var SimpleCommandBase_1 = __webpack_require__(9741);
var EditShapeImageCommandBase = (function (_super) {
    __extends(EditShapeImageCommandBase, _super);
    function EditShapeImageCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    EditShapeImageCommandBase.prototype.isEnabled = function () {
        var selectedShape = this.getSelectedShape();
        return _super.prototype.isEnabled.call(this) && !!selectedShape && !selectedShape.locked && selectedShape.enableImage && selectedShape.allowEditImage;
    };
    EditShapeImageCommandBase.prototype.getValue = function () {
        var selectedShape = this.getSelectedShape();
        var imageUrl = (selectedShape) ? selectedShape.image.exportUrl : undefined;
        return imageUrl;
    };
    EditShapeImageCommandBase.prototype.getSelectedShape = function () {
        var selectedShapes = this.control.selection.getSelectedShapes(true);
        return (selectedShapes.length === 1) ? selectedShapes[0] : undefined;
    };
    EditShapeImageCommandBase.prototype.executeCore = function (state, parameter) {
        this.control.history.beginTransaction();
        var selectedUnlockedShapes = this.control.selection.getSelectedShapes(false);
        this.control.history.addAndRedo(new ChangeShapeImageHistoryItem_1.ChangeShapeImageHistoryItem(selectedUnlockedShapes[0], parameter));
        this.control.history.endTransaction();
        return true;
    };
    return EditShapeImageCommandBase;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.EditShapeImageCommandBase = EditShapeImageCommandBase;


/***/ }),

/***/ 9158:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InsertShapeImageCommand = void 0;
var EditShapeImageCommandBase_1 = __webpack_require__(7650);
var InsertShapeImageCommand = (function (_super) {
    __extends(InsertShapeImageCommand, _super);
    function InsertShapeImageCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    InsertShapeImageCommand.prototype.isEnabled = function () {
        var selectedShape = this.getSelectedShape();
        return _super.prototype.isEnabled.call(this) && selectedShape.image.isEmpty;
    };
    return InsertShapeImageCommand;
}(EditShapeImageCommandBase_1.EditShapeImageCommandBase));
exports.InsertShapeImageCommand = InsertShapeImageCommand;


/***/ }),

/***/ 9741:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SimpleCommandBase = void 0;
var CommandBase_1 = __webpack_require__(9687);
var CommandStates_1 = __webpack_require__(2102);
var ModelUtils_1 = __webpack_require__(4867);
var LocalizationService_1 = __webpack_require__(6224);
var SimpleCommandBase = (function (_super) {
    __extends(SimpleCommandBase, _super);
    function SimpleCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SimpleCommandBase.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(this.isEnabled(), this.getValue(), this.getDefaultValue(), this.getItems(), this.isVisible());
    };
    SimpleCommandBase.prototype.isVisible = function () {
        return true;
    };
    SimpleCommandBase.prototype.isEnabled = function () {
        return !this.control.settings.readOnly || this.isEnabledInReadOnlyMode();
    };
    SimpleCommandBase.prototype.isEnabledInReadOnlyMode = function () {
        return false;
    };
    SimpleCommandBase.prototype.getValue = function () {
        return undefined;
    };
    SimpleCommandBase.prototype.getDefaultValue = function () {
        return undefined;
    };
    SimpleCommandBase.prototype.getItems = function () {
        return undefined;
    };
    SimpleCommandBase.prototype.getModelUnit = function (value) {
        return ModelUtils_1.ModelUtils.getlUnitValue(this.control.model.units, value);
    };
    SimpleCommandBase.prototype.getModelUnitText = function (value) {
        return ModelUtils_1.ModelUtils.getUnitText(this.control.model.units, LocalizationService_1.DiagramLocalizationService.unitItems, LocalizationService_1.DiagramLocalizationService.formatUnit, value);
    };
    SimpleCommandBase.prototype.getModelUnitTwipsValue = function (value) {
        return ModelUtils_1.ModelUtils.getTwipsValue(this.control.model.units, value);
    };
    SimpleCommandBase.prototype.getViewUnit = function (value) {
        return ModelUtils_1.ModelUtils.getlUnitValue(this.control.settings.viewUnits, value);
    };
    SimpleCommandBase.prototype.getViewUnitText = function (value) {
        return ModelUtils_1.ModelUtils.getUnitText(this.control.settings.viewUnits, LocalizationService_1.DiagramLocalizationService.unitItems, LocalizationService_1.DiagramLocalizationService.formatUnit, value);
    };
    SimpleCommandBase.prototype.getViewUnitTwipsValue = function (value) {
        return ModelUtils_1.ModelUtils.getTwipsValue(this.control.settings.viewUnits, value);
    };
    return SimpleCommandBase;
}(CommandBase_1.CommandBase));
exports.SimpleCommandBase = SimpleCommandBase;


/***/ }),

/***/ 1649:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeFillColorCommand = void 0;
var ChangeStylePropertyCommand_1 = __webpack_require__(5726);
var color_1 = __webpack_require__(13);
var ChangeFillColorCommand = (function (_super) {
    __extends(ChangeFillColorCommand, _super);
    function ChangeFillColorCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeFillColorCommand.prototype.processParameter = function (parameter) {
        return color_1.ColorUtils.stringToHash(parameter);
    };
    ChangeFillColorCommand.prototype.getStyleProperty = function () {
        return "fill";
    };
    return ChangeFillColorCommand;
}(ChangeStylePropertyCommand_1.ChangeStylePropertyCommand));
exports.ChangeFillColorCommand = ChangeFillColorCommand;


/***/ }),

/***/ 6106:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeFontColorCommand = void 0;
var ChangeStyleTextPropertyCommand_1 = __webpack_require__(2722);
var color_1 = __webpack_require__(13);
var ChangeFontColorCommand = (function (_super) {
    __extends(ChangeFontColorCommand, _super);
    function ChangeFontColorCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeFontColorCommand.prototype.processParameter = function (parameter) {
        return color_1.ColorUtils.stringToHash(parameter);
    };
    ChangeFontColorCommand.prototype.getStyleProperty = function () {
        return "fill";
    };
    return ChangeFontColorCommand;
}(ChangeStyleTextPropertyCommand_1.ChangeStyleTextPropertyCommand));
exports.ChangeFontColorCommand = ChangeFontColorCommand;


/***/ }),

/***/ 7480:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeFontNameCommand = void 0;
var ChangeStyleTextPropertyCommand_1 = __webpack_require__(2722);
var ChangeFontNameCommand = (function (_super) {
    __extends(ChangeFontNameCommand, _super);
    function ChangeFontNameCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeFontNameCommand.prototype.getStyleProperty = function () {
        return "font-family";
    };
    return ChangeFontNameCommand;
}(ChangeStyleTextPropertyCommand_1.ChangeStyleTextPropertyCommand));
exports.ChangeFontNameCommand = ChangeFontNameCommand;


/***/ }),

/***/ 4077:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeFontSizeCommand = void 0;
var ChangeStyleTextPropertyCommand_1 = __webpack_require__(2722);
var ChangeFontSizeCommand = (function (_super) {
    __extends(ChangeFontSizeCommand, _super);
    function ChangeFontSizeCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeFontSizeCommand.prototype.getStyleProperty = function () {
        return "font-size";
    };
    return ChangeFontSizeCommand;
}(ChangeStyleTextPropertyCommand_1.ChangeStyleTextPropertyCommand));
exports.ChangeFontSizeCommand = ChangeFontSizeCommand;


/***/ }),

/***/ 3166:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeStrokeColorCommand = void 0;
var ChangeStylePropertyCommand_1 = __webpack_require__(5726);
var color_1 = __webpack_require__(13);
var ChangeStrokeColorCommand = (function (_super) {
    __extends(ChangeStrokeColorCommand, _super);
    function ChangeStrokeColorCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeStrokeColorCommand.prototype.processParameter = function (parameter) {
        return color_1.ColorUtils.stringToHash(parameter);
    };
    ChangeStrokeColorCommand.prototype.getStyleProperty = function () {
        return "stroke";
    };
    return ChangeStrokeColorCommand;
}(ChangeStylePropertyCommand_1.ChangeStylePropertyCommand));
exports.ChangeStrokeColorCommand = ChangeStrokeColorCommand;


/***/ }),

/***/ 4643:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeStrokeStyleCommand = void 0;
var ChangeStylePropertyCommand_1 = __webpack_require__(5726);
var ChangeStrokeStyleCommand = (function (_super) {
    __extends(ChangeStrokeStyleCommand, _super);
    function ChangeStrokeStyleCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeStrokeStyleCommand.prototype.getStyleProperty = function () {
        return "stroke-dasharray";
    };
    return ChangeStrokeStyleCommand;
}(ChangeStylePropertyCommand_1.ChangeStylePropertyCommand));
exports.ChangeStrokeStyleCommand = ChangeStrokeStyleCommand;


/***/ }),

/***/ 4681:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeStrokeWidthCommand = void 0;
var ChangeStylePropertyCommand_1 = __webpack_require__(5726);
var ChangeStrokeWidthCommand = (function (_super) {
    __extends(ChangeStrokeWidthCommand, _super);
    function ChangeStrokeWidthCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeStrokeWidthCommand.prototype.getStyleProperty = function () {
        return "stroke-width";
    };
    return ChangeStrokeWidthCommand;
}(ChangeStylePropertyCommand_1.ChangeStylePropertyCommand));
exports.ChangeStrokeWidthCommand = ChangeStrokeWidthCommand;


/***/ }),

/***/ 5726:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeStylePropertyCommand = void 0;
var ChangeStylePropertyCommandBase_1 = __webpack_require__(521);
var ChangeStyleHistoryItem_1 = __webpack_require__(4634);
var Style_1 = __webpack_require__(1552);
var ChangeStylePropertyCommand = (function (_super) {
    __extends(ChangeStylePropertyCommand, _super);
    function ChangeStylePropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeStylePropertyCommand.prototype.getValue = function () {
        return this.control.selection.inputPosition.getCurrentStylePropertyValue(this.getStyleProperty());
    };
    ChangeStylePropertyCommand.prototype.getStyleObj = function (item) {
        return item.style;
    };
    ChangeStylePropertyCommand.prototype.getDefaultStyleObj = function () {
        return new Style_1.Style();
    };
    ChangeStylePropertyCommand.prototype.createHistoryItem = function (item, styleProperty, styleValue) {
        return new ChangeStyleHistoryItem_1.ChangeStyleHistoryItem(item.key, styleProperty, styleValue);
    };
    ChangeStylePropertyCommand.prototype.updateInputPosition = function (value) {
        this.control.selection.inputPosition.setStylePropertyValue(this.getStyleProperty(), value);
    };
    return ChangeStylePropertyCommand;
}(ChangeStylePropertyCommandBase_1.ChangeStylePropertyCommandBase));
exports.ChangeStylePropertyCommand = ChangeStylePropertyCommand;


/***/ }),

/***/ 521:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeStylePropertyCommandBase = void 0;
var StylePropertyCommandBase_1 = __webpack_require__(8351);
var ChangeStylePropertyCommandBase = (function (_super) {
    __extends(ChangeStylePropertyCommandBase, _super);
    function ChangeStylePropertyCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeStylePropertyCommandBase.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var items = this.control.selection.getSelectedItems();
        parameter = this.processParameter(parameter);
        items.forEach(function (item) {
            var styleProperty = _this.getStyleProperty();
            _this.control.history.addAndRedo(_this.createHistoryItem(item, styleProperty, parameter));
        });
        this.updateInputPosition(parameter);
        this.control.history.endTransaction();
        return true;
    };
    ChangeStylePropertyCommandBase.prototype.getDefaultValue = function () {
        return this.getDefaultStyleObj()[this.getStyleProperty()];
    };
    ChangeStylePropertyCommandBase.prototype.processParameter = function (parameter) {
        return parameter;
    };
    return ChangeStylePropertyCommandBase;
}(StylePropertyCommandBase_1.StylePropertyCommandBase));
exports.ChangeStylePropertyCommandBase = ChangeStylePropertyCommandBase;


/***/ }),

/***/ 2722:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeStyleTextPropertyCommand = void 0;
var ChangeStylePropertyCommandBase_1 = __webpack_require__(521);
var ChangeStyleTextHistoryItem_1 = __webpack_require__(926);
var Style_1 = __webpack_require__(1552);
var ChangeStyleTextPropertyCommand = (function (_super) {
    __extends(ChangeStyleTextPropertyCommand, _super);
    function ChangeStyleTextPropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeStyleTextPropertyCommand.prototype.getValue = function () {
        return this.control.selection.inputPosition.getCurrentTextStylePropertyValue(this.getStyleProperty());
    };
    ChangeStyleTextPropertyCommand.prototype.getStyleObj = function (item) {
        return item.styleText;
    };
    ChangeStyleTextPropertyCommand.prototype.getDefaultStyleObj = function () {
        return new Style_1.TextStyle();
    };
    ChangeStyleTextPropertyCommand.prototype.createHistoryItem = function (item, styleProperty, styleValue) {
        return new ChangeStyleTextHistoryItem_1.ChangeStyleTextHistoryItem(item.key, styleProperty, styleValue);
    };
    ChangeStyleTextPropertyCommand.prototype.updateInputPosition = function (value) {
        this.control.selection.inputPosition.setTextStylePropertyValue(this.getStyleProperty(), value);
    };
    return ChangeStyleTextPropertyCommand;
}(ChangeStylePropertyCommandBase_1.ChangeStylePropertyCommandBase));
exports.ChangeStyleTextPropertyCommand = ChangeStyleTextPropertyCommand;


/***/ }),

/***/ 8700:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextRightAlignCommand = exports.TextCenterAlignCommand = exports.TextLeftAlignCommand = exports.ChangeTextAlignCommand = void 0;
var ToggleStyleTextPropertyCommand_1 = __webpack_require__(6980);
var ChangeTextAlignCommand = (function (_super) {
    __extends(ChangeTextAlignCommand, _super);
    function ChangeTextAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeTextAlignCommand.prototype.getStyleProperty = function () {
        return "text-anchor";
    };
    return ChangeTextAlignCommand;
}(ToggleStyleTextPropertyCommand_1.ToggleStyleTextPropertyCommand));
exports.ChangeTextAlignCommand = ChangeTextAlignCommand;
var TextLeftAlignCommand = (function (_super) {
    __extends(TextLeftAlignCommand, _super);
    function TextLeftAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TextLeftAlignCommand.prototype.getStylePropertyValue = function () {
        return "start";
    };
    return TextLeftAlignCommand;
}(ChangeTextAlignCommand));
exports.TextLeftAlignCommand = TextLeftAlignCommand;
var TextCenterAlignCommand = (function (_super) {
    __extends(TextCenterAlignCommand, _super);
    function TextCenterAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TextCenterAlignCommand.prototype.getStylePropertyValue = function () {
        return "middle";
    };
    return TextCenterAlignCommand;
}(ChangeTextAlignCommand));
exports.TextCenterAlignCommand = TextCenterAlignCommand;
var TextRightAlignCommand = (function (_super) {
    __extends(TextRightAlignCommand, _super);
    function TextRightAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TextRightAlignCommand.prototype.getStylePropertyValue = function () {
        return "end";
    };
    return TextRightAlignCommand;
}(ChangeTextAlignCommand));
exports.TextRightAlignCommand = TextRightAlignCommand;


/***/ }),

/***/ 8351:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StylePropertyCommandBase = void 0;
var SimpleCommandBase_1 = __webpack_require__(9741);
var StylePropertyCommandBase = (function (_super) {
    __extends(StylePropertyCommandBase, _super);
    function StylePropertyCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    StylePropertyCommandBase.prototype.lockInputPositionUpdating = function () {
        return true;
    };
    return StylePropertyCommandBase;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.StylePropertyCommandBase = StylePropertyCommandBase;


/***/ }),

/***/ 4378:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleFontBoldCommand = void 0;
var ToggleStyleTextPropertyCommand_1 = __webpack_require__(6980);
var ToggleFontBoldCommand = (function (_super) {
    __extends(ToggleFontBoldCommand, _super);
    function ToggleFontBoldCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleFontBoldCommand.prototype.getStyleProperty = function () {
        return "font-weight";
    };
    ToggleFontBoldCommand.prototype.getStylePropertyValue = function () {
        return "bold";
    };
    return ToggleFontBoldCommand;
}(ToggleStyleTextPropertyCommand_1.ToggleStyleTextPropertyCommand));
exports.ToggleFontBoldCommand = ToggleFontBoldCommand;


/***/ }),

/***/ 7607:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleFontItalicCommand = void 0;
var ToggleStyleTextPropertyCommand_1 = __webpack_require__(6980);
var ToggleFontItalicCommand = (function (_super) {
    __extends(ToggleFontItalicCommand, _super);
    function ToggleFontItalicCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleFontItalicCommand.prototype.getStyleProperty = function () {
        return "font-style";
    };
    ToggleFontItalicCommand.prototype.getStylePropertyValue = function () {
        return "italic";
    };
    return ToggleFontItalicCommand;
}(ToggleStyleTextPropertyCommand_1.ToggleStyleTextPropertyCommand));
exports.ToggleFontItalicCommand = ToggleFontItalicCommand;


/***/ }),

/***/ 3411:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleFontUnderlineCommand = void 0;
var ToggleStyleTextPropertyCommand_1 = __webpack_require__(6980);
var ToggleFontUnderlineCommand = (function (_super) {
    __extends(ToggleFontUnderlineCommand, _super);
    function ToggleFontUnderlineCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleFontUnderlineCommand.prototype.getStyleProperty = function () {
        return "text-decoration";
    };
    ToggleFontUnderlineCommand.prototype.getStylePropertyValue = function () {
        return "underline";
    };
    return ToggleFontUnderlineCommand;
}(ToggleStyleTextPropertyCommand_1.ToggleStyleTextPropertyCommand));
exports.ToggleFontUnderlineCommand = ToggleFontUnderlineCommand;


/***/ }),

/***/ 6980:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleStyleTextPropertyCommand = void 0;
var StylePropertyCommandBase_1 = __webpack_require__(8351);
var ChangeStyleTextHistoryItem_1 = __webpack_require__(926);
var Style_1 = __webpack_require__(1552);
var ToggleStyleTextPropertyCommand = (function (_super) {
    __extends(ToggleStyleTextPropertyCommand, _super);
    function ToggleStyleTextPropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleStyleTextPropertyCommand.prototype.getValue = function () {
        var value = this.control.selection.inputPosition.getCurrentTextStylePropertyValue(this.getStyleProperty());
        return value === this.getStylePropertyValue();
    };
    ToggleStyleTextPropertyCommand.prototype.executeCore = function (state) {
        var _this = this;
        this.control.history.beginTransaction();
        var styleProperty = this.getStyleProperty();
        var styleValue = state.value ? Style_1.TextStyle.defaultInstance[styleProperty] : this.getStylePropertyValue();
        var items = this.control.selection.getSelectedItems();
        items.forEach(function (item) {
            _this.control.history.addAndRedo(new ChangeStyleTextHistoryItem_1.ChangeStyleTextHistoryItem(item.key, styleProperty, styleValue));
        });
        this.control.selection.inputPosition.setTextStylePropertyValue(this.getStyleProperty(), styleValue);
        this.control.history.endTransaction();
        return true;
    };
    ToggleStyleTextPropertyCommand.prototype.getStyleObj = function (item) {
        return item.styleText;
    };
    ToggleStyleTextPropertyCommand.prototype.getDefaultStyleObj = function () {
        return new Style_1.TextStyle();
    };
    return ToggleStyleTextPropertyCommand;
}(StylePropertyCommandBase_1.StylePropertyCommandBase));
exports.ToggleStyleTextPropertyCommand = ToggleStyleTextPropertyCommand;


/***/ }),

/***/ 5035:
/***/ (function(__unused_webpack_module, exports) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DataSourceEdgeDataImporter = exports.DataSourceNodeDataImporter = exports.DataSourceItemDataImporter = void 0;
var DataSourceItemDataImporter = (function () {
    function DataSourceItemDataImporter() {
        this.getKey = function (obj) { return obj["id"]; };
        this.setKey = function (obj, value) { obj["id"] = value; };
        this.getCustomData = undefined;
        this.setCustomData = undefined;
        this.getLocked = undefined;
        this.setLocked = undefined;
        this.getStyle = undefined;
        this.setStyle = undefined;
        this.getStyleText = undefined;
        this.setStyleText = undefined;
        this.getZIndex = undefined;
        this.setZIndex = undefined;
    }
    return DataSourceItemDataImporter;
}());
exports.DataSourceItemDataImporter = DataSourceItemDataImporter;
var DataSourceNodeDataImporter = (function (_super) {
    __extends(DataSourceNodeDataImporter, _super);
    function DataSourceNodeDataImporter() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.getType = undefined;
        _this.setType = undefined;
        _this.getText = undefined;
        _this.setText = undefined;
        _this.getImage = undefined;
        _this.setImage = undefined;
        _this.getLeft = undefined;
        _this.setLeft = undefined;
        _this.getTop = undefined;
        _this.setTop = undefined;
        _this.getWidth = undefined;
        _this.setWidth = undefined;
        _this.getHeight = undefined;
        _this.setHeight = undefined;
        _this.getChildren = undefined;
        _this.setChildren = undefined;
        _this.getParentKey = undefined;
        _this.setParentKey = undefined;
        _this.getItems = undefined;
        _this.setItems = undefined;
        _this.getContainerKey = undefined;
        _this.setContainerKey = undefined;
        return _this;
    }
    return DataSourceNodeDataImporter;
}(DataSourceItemDataImporter));
exports.DataSourceNodeDataImporter = DataSourceNodeDataImporter;
var DataSourceEdgeDataImporter = (function (_super) {
    __extends(DataSourceEdgeDataImporter, _super);
    function DataSourceEdgeDataImporter() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.getFrom = function (obj) { return obj["from"]; };
        _this.setFrom = function (obj, value) { obj["from"] = value; };
        _this.getFromPointIndex = undefined;
        _this.setFromPointIndex = undefined;
        _this.getTo = function (obj) { return obj["to"]; };
        _this.setTo = function (obj, value) { obj["to"] = value; };
        _this.getToPointIndex = undefined;
        _this.setToPointIndex = undefined;
        _this.getPoints = undefined;
        _this.setPoints = undefined;
        _this.getText = undefined;
        _this.setText = undefined;
        _this.getLineOption = undefined;
        _this.setLineOption = undefined;
        _this.getStartLineEnding = undefined;
        _this.setStartLineEnding = undefined;
        _this.getEndLineEnding = undefined;
        _this.setEndLineEnding = undefined;
        return _this;
    }
    return DataSourceEdgeDataImporter;
}(DataSourceItemDataImporter));
exports.DataSourceEdgeDataImporter = DataSourceEdgeDataImporter;


/***/ }),

/***/ 3503:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DataLayoutParameters = exports.DataLayoutType = void 0;
var LayoutSettings_1 = __webpack_require__(8710);
var WideTree_1 = __webpack_require__(9533);
var Sugiyama_1 = __webpack_require__(1256);
var DataLayoutType;
(function (DataLayoutType) {
    DataLayoutType[DataLayoutType["Tree"] = 0] = "Tree";
    DataLayoutType[DataLayoutType["Sugiyama"] = 1] = "Sugiyama";
})(DataLayoutType = exports.DataLayoutType || (exports.DataLayoutType = {}));
var DataLayoutParameters = (function () {
    function DataLayoutParameters(sizeSettings, parameter) {
        this.sizeSettings = sizeSettings;
        if (parameter) {
            if (parameter.type !== undefined) {
                this.layoutType = parameter.type;
                this.layoutSettings = this.layoutType === DataLayoutType.Sugiyama ? new LayoutSettings_1.LayoutSettings() : new LayoutSettings_1.TreeLayoutSettings();
            }
            if (parameter.orientation !== undefined)
                this.layoutSettings.orientation = parameter.orientation;
            this.skipPointIndices = parameter.skipPointIndices;
            this.autoSizeEnabled = parameter.autoSizeEnabled;
        }
    }
    Object.defineProperty(DataLayoutParameters.prototype, "needAutoLayout", {
        get: function () { return this.layoutType !== undefined; },
        enumerable: false,
        configurable: true
    });
    DataLayoutParameters.prototype.getLayoutBuilder = function (graph) {
        return (this.layoutType === DataLayoutType.Tree) ?
            new WideTree_1.TreeLayoutBuilder(this.layoutSettings, graph) :
            new Sugiyama_1.SugiyamaLayoutBuilder(this.layoutSettings, graph);
    };
    return DataLayoutParameters;
}());
exports.DataLayoutParameters = DataLayoutParameters;


/***/ }),

/***/ 4225:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DataSource = void 0;
var unit_converter_1 = __webpack_require__(9291);
var point_1 = __webpack_require__(8900);
var size_1 = __webpack_require__(6353);
var AddConnectionHistoryItem_1 = __webpack_require__(3477);
var AddConnectorHistoryItem_1 = __webpack_require__(9603);
var AddShapeHistoryItem_1 = __webpack_require__(4145);
var DeleteConnectionHistoryItem_1 = __webpack_require__(8930);
var ResizeShapeHistoryItem_1 = __webpack_require__(4629);
var ChangeConnectorPropertyHistoryItem_1 = __webpack_require__(8236);
var ChangeConnectorTextHistoryItem_1 = __webpack_require__(5144);
var ChangeCustomDataHistoryItem_1 = __webpack_require__(9559);
var ChangeLockedHistoryItem_1 = __webpack_require__(7443);
var ChangeShapeImageHistoryItem_1 = __webpack_require__(8210);
var ChangeShapeTextHistoryItem_1 = __webpack_require__(6516);
var ChangeZindexHistoryItem_1 = __webpack_require__(5982);
var ChangeStyleHistoryItem_1 = __webpack_require__(4634);
var ChangeStyleTextHistoryItem_1 = __webpack_require__(926);
var Connector_1 = __webpack_require__(7959);
var ModelUtils_1 = __webpack_require__(4867);
var ShapeTypes_1 = __webpack_require__(2259);
var ITextMeasurer_1 = __webpack_require__(4246);
var Utils_1 = __webpack_require__(8675);
var color_1 = __webpack_require__(13);
var Data_1 = __webpack_require__(4914);
var Svg_1 = __webpack_require__(8396);
var TextUtils_1 = __webpack_require__(3490);
var DataImporter_1 = __webpack_require__(5035);
var DataSourceItems_1 = __webpack_require__(5558);
var ChangeConnectorPointsHistoryItem_1 = __webpack_require__(58);
var DataSource = (function () {
    function DataSource(key, nodeDataSource, edgeDataSource, parameters, nodeDataImporter, edgeDataImporter) {
        this.key = key;
        this.nodes = [];
        this.edges = [];
        this.autoGeneratedDataKeys = {};
        this.addInternalKeyOnInsert = false;
        this.useNodeParentId = false;
        this.useNodeContainerId = false;
        this.useNodeChildren = false;
        this.useNodeItems = false;
        this.canUseAutoSize = false;
        this.canUpdateEdgeDataSource = false;
        this.containers = null;
        if (key === undefined || key === null)
            throw new Error("DataSource key must be specified");
        this.key = key.toString();
        this.loadParameters(parameters || {});
        this.nodeDataImporter = this.createNodeDataImporter(nodeDataImporter);
        this.edgeDataImporter = this.createEdgeDataImporter(edgeDataImporter);
        this.nodeDataSource = nodeDataSource || [];
        this.edgeDataSource = edgeDataSource || [];
        this.canUpdateEdgeDataSource = !!edgeDataSource;
        this.fetchData();
    }
    DataSource.prototype.loadParameters = function (parameters) {
        this.addInternalKeyOnInsert = !!parameters.addInternalKeyOnInsert;
    };
    DataSource.prototype.isAutoGeneratedKey = function (dataKey) {
        return dataKey && !!this.autoGeneratedDataKeys[dataKey];
    };
    DataSource.prototype.createNodeDataImporter = function (source) {
        var result = new DataImporter_1.DataSourceNodeDataImporter();
        if (source)
            this.assignNodeDataImporterProperties(source, result);
        return result;
    };
    DataSource.prototype.createEdgeDataImporter = function (source) {
        var result = new DataImporter_1.DataSourceEdgeDataImporter();
        if (source)
            this.assignEdgeDataImporterProperties(source, result);
        return result;
    };
    DataSource.prototype.assignItemDataImporterProperties = function (source, importer) {
        if (source.getKey)
            importer.getKey = source.getKey;
        if (source.setKey)
            importer.setKey = source.setKey;
        if (source.getCustomData)
            importer.getCustomData = source.getCustomData;
        if (source.setCustomData)
            importer.setCustomData = source.setCustomData;
        if (source.getLocked)
            importer.getLocked = source.getLocked;
        if (source.setLocked)
            importer.setLocked = source.setLocked;
        if (source.getStyle)
            importer.getStyle = source.getStyle;
        if (source.setStyle)
            importer.setStyle = source.setStyle;
        if (source.getStyleText)
            importer.getStyleText = source.getStyleText;
        if (source.setStyleText)
            importer.setStyleText = source.setStyleText;
        if (source.getZIndex)
            importer.getZIndex = source.getZIndex;
        if (source.setZIndex)
            importer.setZIndex = source.setZIndex;
    };
    DataSource.prototype.assignNodeDataImporterProperties = function (source, importer) {
        this.assignItemDataImporterProperties(source, importer);
        if (source.getType)
            importer.getType = source.getType;
        if (source.setType)
            importer.setType = source.setType;
        if (source.getImage)
            importer.getImage = source.getImage;
        if (source.setImage)
            importer.setImage = source.setImage;
        if (source.getText)
            importer.getText = source.getText;
        if (source.setText)
            importer.setText = source.setText;
        if (source.getLeft)
            importer.getLeft = source.getLeft;
        if (source.setLeft)
            importer.setLeft = source.setLeft;
        if (source.getTop)
            importer.getTop = source.getTop;
        if (source.setTop)
            importer.setTop = source.setTop;
        if (source.getWidth)
            importer.getWidth = source.getWidth;
        if (source.setWidth)
            importer.setWidth = source.setWidth;
        if (source.getHeight)
            importer.getHeight = source.getHeight;
        if (source.setHeight)
            importer.setHeight = source.setHeight;
        if (source.getChildren)
            importer.getChildren = source.getChildren;
        if (source.setChildren)
            importer.setChildren = source.setChildren;
        if (source.getParentKey)
            importer.getParentKey = source.getParentKey;
        if (source.setParentKey)
            importer.setParentKey = source.setParentKey;
        if (source.getItems)
            importer.getItems = source.getItems;
        if (source.setItems)
            importer.setItems = source.setItems;
        if (source.getContainerKey)
            importer.getContainerKey = source.getContainerKey;
        if (source.setContainerKey)
            importer.setContainerKey = source.setContainerKey;
    };
    DataSource.prototype.assignEdgeDataImporterProperties = function (source, importer) {
        this.assignItemDataImporterProperties(source, importer);
        if (source.getFrom)
            importer.getFrom = source.getFrom;
        if (source.setFrom)
            importer.setFrom = source.setFrom;
        if (source.getFromPointIndex)
            importer.getFromPointIndex = source.getFromPointIndex;
        if (source.setFromPointIndex)
            importer.setFromPointIndex = source.setFromPointIndex;
        if (source.getTo)
            importer.getTo = source.getTo;
        if (source.setTo)
            importer.setTo = source.setTo;
        if (source.getToPointIndex)
            importer.getToPointIndex = source.getToPointIndex;
        if (source.setToPointIndex)
            importer.setToPointIndex = source.setToPointIndex;
        if (source.getPoints)
            importer.getPoints = source.getPoints;
        if (source.setPoints)
            importer.setPoints = source.setPoints;
        if (source.getText)
            importer.getText = source.getText;
        if (source.setText)
            importer.setText = source.setText;
        if (source.getLineOption)
            importer.getLineOption = source.getLineOption;
        if (source.setLineOption)
            importer.setLineOption = source.setLineOption;
        if (source.getStartLineEnding)
            importer.getStartLineEnding = source.getStartLineEnding;
        if (source.setStartLineEnding)
            importer.setStartLineEnding = source.setStartLineEnding;
        if (source.getEndLineEnding)
            importer.getEndLineEnding = source.getEndLineEnding;
        if (source.setEndLineEnding)
            importer.setEndLineEnding = source.setEndLineEnding;
    };
    DataSource.prototype.fetchData = function () {
        var _this = this;
        this.nodes = [];
        this.edges = [];
        this.autoGeneratedDataKeys = {};
        this.useNodeParentId = this.nodeDataImporter.getParentKey !== undefined;
        this.useNodeContainerId = this.nodeDataImporter.getContainerKey !== undefined;
        this.useNodeItems = this.nodeDataImporter.getItems !== undefined;
        this.useNodeChildren = this.nodeDataImporter.getChildren !== undefined;
        this.canUseAutoSize = this.nodeDataImporter.getWidth === undefined && this.nodeDataImporter.getText !== undefined;
        if (this.useEdgesArray() && this.useNodeParentId)
            throw new Error("You cannot use edges array and parentKey simultaneously.");
        if (this.useEdgesArray() && this.useNodeItems)
            throw new Error("You cannot use edges array and items array simultaneously.");
        if (this.useNodeParentId && this.useNodeItems)
            throw new Error("You cannot use parentKey and items array simultaneously.");
        if (this.useNodeContainerId && this.useNodeChildren)
            throw new Error("You cannot use containerKey and children array simultaneously.");
        this.nodeDataSource.forEach(function (nodeDataObj) {
            _this.addNode(nodeDataObj);
        });
        if (this.useEdgesArray())
            this.edgeDataSource.forEach(function (edgeDataObj) {
                _this.addEdge(edgeDataObj);
            });
        else
            this.nodes.forEach(function (node) {
                _this.addNodeEdgesByParentId(node);
            });
    };
    DataSource.prototype.isContainer = function (itemKey) {
        var _this = this;
        if (!this.containers && this.useNodeContainerId)
            this.containers = this.nodeDataSource
                .map(function (i) { return _this.nodeDataImporter.getContainerKey(i); })
                .filter(function (i) { return i !== undefined && i !== null; })
                .reduce(function (map, i) {
                map[i] = true;
                return map;
            }, {});
        return this.containers && this.containers[itemKey];
    };
    DataSource.prototype.refetchData = function (nodeDataSource, edgeDataSource) {
        var _this = this;
        this.nodeDataSource = nodeDataSource || this.nodeDataSource;
        this.edgeDataSource = edgeDataSource || this.edgeDataSource;
        var oldNodes = this.nodes.slice();
        var oldEdges = this.edges.slice();
        this.fetchData();
        var changedNodes = this.getItemChanges(oldNodes, this.nodes, function (item1, item2) {
            return (item1.key === item2.key) || (item1.dataObj === item2.dataObj);
        });
        var changedEdges = this.getItemChanges(oldEdges, this.edges, function (item1, item2) {
            if (_this.useNodeParentId || _this.useNodeItems)
                return (item1.key === item2.key) || (item1.from === item2.from && item1.to === item2.to);
            return (item1.key === item2.key) || (item1.dataObj === item2.dataObj);
        });
        return { nodes: changedNodes, edges: changedEdges };
    };
    DataSource.prototype.getItemChanges = function (oldItems, newItems, areEqual) {
        var _this = this;
        var remainedItems = oldItems.filter(function (item) { return _this.containsItem(newItems, item, areEqual); });
        var removedItems = oldItems.filter(function (item) { return !_this.containsItem(newItems, item, areEqual); });
        var addedItems = newItems.filter(function (item) { return !_this.containsItem(oldItems, item, areEqual); });
        return {
            remained: remainedItems.map(function (item) { return item.key; }),
            remainedNewKeys: remainedItems.map(function (item) { var _a; return (_a = newItems.find(function (i) { return areEqual(item, i); })) === null || _a === void 0 ? void 0 : _a.key; }),
            removed: removedItems.map(function (item) { return item.key; }),
            added: addedItems.map(function (item) { return item.key; })
        };
    };
    DataSource.prototype.containsItem = function (items, item, areEqual) {
        var result = false;
        items.forEach(function (i) {
            if (!result && areEqual(i, item))
                result = true;
        });
        return result;
    };
    DataSource.prototype.useEdgesArray = function () {
        return Array.isArray(this.edgeDataSource) && (this.edgeDataSource.length || !(this.useNodeParentId || this.useNodeItems));
    };
    DataSource.prototype.addNode = function (nodeDataObj, parentNodeDataObj, containerKey, containerNodeDataObj) {
        var _this = this;
        var childNodeDataObjs = this.nodeDataImporter.getChildren && this.nodeDataImporter.getChildren(nodeDataObj);
        var hasChildren = childNodeDataObjs && Array.isArray(childNodeDataObjs) && childNodeDataObjs.length;
        var isContainer = hasChildren || this.isContainer(this.nodeDataImporter.getKey(nodeDataObj));
        var type = this.nodeDataImporter.getType && this.nodeDataImporter.getType(nodeDataObj) || (isContainer && ShapeTypes_1.ShapeTypes.VerticalContainer) || ShapeTypes_1.ShapeTypes.Rectangle;
        var text = this.nodeDataImporter.getText && (this.nodeDataImporter.getText(nodeDataObj) || "");
        var node = this.addNodeInternal(nodeDataObj, type, text, parentNodeDataObj, containerKey, containerNodeDataObj);
        this.assignNodeProperties(node, nodeDataObj);
        if (hasChildren)
            childNodeDataObjs.forEach(function (childNodeDataObj) {
                _this.addNode(childNodeDataObj, undefined, node.key, nodeDataObj);
            });
        if (this.useNodeItems) {
            var itemDataObjs = this.nodeDataImporter.getItems(nodeDataObj);
            if (Array.isArray(itemDataObjs) && itemDataObjs.length)
                itemDataObjs.forEach(function (itemDataObj) {
                    var itemNode = _this.addNode(itemDataObj, nodeDataObj, containerKey, containerNodeDataObj);
                    _this.addEdgeInternal(undefined, node.key, itemNode.key);
                });
        }
        return node;
    };
    DataSource.prototype.addNodeEdgesByParentId = function (node) {
        if (this.useNodeParentId) {
            var parentKey = this.nodeDataImporter.getParentKey(node.dataObj);
            if (parentKey !== undefined && parentKey !== null) {
                var parentNode = this.findNode(parentKey);
                if (parentNode)
                    this.addEdgeInternal(undefined, this.getNodeKey(node.dataObj, this.nodeDataImporter.getParentKey), this.getNodeKey(node.dataObj, this.nodeDataImporter.getKey));
            }
        }
    };
    DataSource.prototype.addNodeInternal = function (nodeDataObj, type, text, parentNodeDataObj, containerKey, containerNodeDataObj) {
        var externalKey = this.nodeDataImporter.getKey(nodeDataObj);
        var key = (externalKey !== undefined && externalKey !== null) ? externalKey : ModelUtils_1.ModelUtils.getGuidItemKey();
        var node = new DataSourceItems_1.DataSourceNodeItem(this.key, key, nodeDataObj, type, text, parentNodeDataObj, containerKey, containerNodeDataObj);
        this.nodes.push(node);
        if (externalKey === undefined || externalKey === null) {
            externalKey = key;
            this.autoGeneratedDataKeys[key] = true;
        }
        return node;
    };
    DataSource.prototype.addEdge = function (edgeDataObj) {
        var edge = this.addEdgeInternal(edgeDataObj, this.getNodeKey(edgeDataObj, this.edgeDataImporter.getFrom), this.getNodeKey(edgeDataObj, this.edgeDataImporter.getTo));
        this.assignEdgeProperties(edge, edgeDataObj);
        return edge;
    };
    DataSource.prototype.addEdgeInternal = function (edgeDataObj, from, to) {
        var externalKey = edgeDataObj && this.edgeDataImporter.getKey(edgeDataObj);
        var key = (externalKey !== undefined && externalKey !== null) ? externalKey : ModelUtils_1.ModelUtils.getGuidItemKey();
        var edge = new DataSourceItems_1.DataSourceEdgeItem(this.key, key, edgeDataObj, from, to);
        this.edges.push(edge);
        if (externalKey === undefined || externalKey === null) {
            externalKey = key;
            this.autoGeneratedDataKeys[key] = true;
        }
        return edge;
    };
    DataSource.prototype.assignItemProperties = function (item, dataObj, importer) {
        if (importer.getCustomData)
            item.customData = Utils_1.ObjectUtils.cloneObject(importer.getCustomData(dataObj));
        if (importer.getLocked)
            item.locked = importer.getLocked(dataObj);
        if (importer.getStyle) {
            var style = importer.getStyle(dataObj);
            item.style = typeof style === "string" ? Data_1.Data.cssTextToObject(style) : style;
        }
        if (importer.getStyleText) {
            var style = importer.getStyleText(dataObj);
            item.styleText = typeof style === "string" ? Data_1.Data.cssTextToObject(style) : style;
        }
        if (importer.getZIndex)
            item.zIndex = importer.getZIndex(dataObj);
    };
    DataSource.prototype.assignNodeProperties = function (item, dataObj) {
        this.assignItemProperties(item, dataObj, this.nodeDataImporter);
        if (this.nodeDataImporter.getImage)
            item.image = this.nodeDataImporter.getImage(dataObj);
        if (this.nodeDataImporter.getLeft)
            item.left = this.nodeDataImporter.getLeft(dataObj);
        if (this.nodeDataImporter.getTop)
            item.top = this.nodeDataImporter.getTop(dataObj);
        if (this.nodeDataImporter.getWidth)
            item.width = this.nodeDataImporter.getWidth(dataObj);
        if (this.nodeDataImporter.getHeight)
            item.height = this.nodeDataImporter.getHeight(dataObj);
        if (this.nodeDataImporter.getContainerKey)
            item.containerKey = this.nodeDataImporter.getContainerKey(dataObj);
    };
    DataSource.prototype.assignEdgeProperties = function (item, dataObj) {
        this.assignItemProperties(item, dataObj, this.edgeDataImporter);
        if (this.edgeDataImporter.getFromPointIndex)
            item.fromPointIndex = this.edgeDataImporter.getFromPointIndex(dataObj);
        if (this.edgeDataImporter.getToPointIndex)
            item.toPointIndex = this.edgeDataImporter.getToPointIndex(dataObj);
        if (this.edgeDataImporter.getPoints)
            item.points = this.edgeDataImporter.getPoints(dataObj);
        if (this.edgeDataImporter.getText) {
            var texts = this.edgeDataImporter.getText(dataObj);
            item.texts = {};
            if (typeof texts === "object")
                for (var key in texts) {
                    if (!Object.prototype.hasOwnProperty.call(texts, key))
                        continue;
                    var position = parseFloat(key);
                    var text = texts[key];
                    if (!isNaN(position) && typeof text === "string" && text !== "") {
                        position = Math.min(1, Math.max(0, position));
                        item.texts[position] = text;
                    }
                }
            else if (typeof texts === "string" && texts !== "")
                item.texts[Connector_1.CONNECTOR_DEFAULT_TEXT_POSITION] = texts;
        }
        if (this.edgeDataImporter.getLineOption)
            item.lineOption = this.edgeDataImporter.getLineOption(dataObj);
        if (this.edgeDataImporter.getStartLineEnding)
            item.startLineEnding = this.edgeDataImporter.getStartLineEnding(dataObj);
        if (this.edgeDataImporter.getEndLineEnding)
            item.endLineEnding = this.edgeDataImporter.getEndLineEnding(dataObj);
    };
    DataSource.prototype.findNode = function (key) {
        return this.nodes.filter(function (i) { return key !== undefined && i.key === key; })[0];
    };
    DataSource.prototype.findEdge = function (key) {
        return this.edges.filter(function (i) { return key !== undefined && i.key === key; })[0];
    };
    DataSource.prototype.getNodeKey = function (nodeDataObj, getKey) {
        return getKey(nodeDataObj);
    };
    DataSource.prototype.createModelItems = function (history, model, shapeDescriptionManager, selection, layoutParameters, snapToGrid, gridSize, measurer) {
        var _this = this;
        this.beginChangesNotification();
        history.clear();
        history.beginTransaction();
        ModelUtils_1.ModelUtils.deleteAllItems(history, model, selection);
        model.initializeKeyCounter();
        var DEFAULT_STEP = snapToGrid ? Math.max(1, Math.floor(2000 / gridSize)) * gridSize : 2000;
        var rowIndex = 0;
        var colIndex = 0;
        var externalToInnerMap = {};
        var shapes = [];
        var connectors = [];
        this.nodes.forEach(function (node) {
            var point = new point_1.Point(colIndex++ * DEFAULT_STEP, rowIndex * DEFAULT_STEP);
            var shape = _this.createShapeByNode(history, model, selection, shapeDescriptionManager, node, point, layoutParameters, snapToGrid, gridSize, measurer);
            if (node.key !== undefined)
                externalToInnerMap[node.key] = shape.key;
            if (colIndex > 4) {
                colIndex = 0;
                rowIndex++;
            }
            shapes.push(shape);
        });
        this.nodes.forEach(function (node) {
            if (node.containerKey !== undefined && node.containerKey !== null) {
                var shapeKey = externalToInnerMap[node.key];
                var shape = model.findShape(shapeKey);
                var containerShapeKey = externalToInnerMap[node.containerKey];
                var containerShape = model.findShape(containerShapeKey);
                if (containerShape)
                    ModelUtils_1.ModelUtils.insertToContainer(history, model, shape, containerShape);
            }
        });
        this.edges.forEach(function (edge) {
            var toShape = model.findShape(externalToInnerMap[edge.to]);
            var fromShape = model.findShape(externalToInnerMap[edge.from]);
            var connector = _this.createConnectorByEdge(history, model, selection, edge, fromShape, toShape);
            if (connector) {
                connectors.push(connector);
                ModelUtils_1.ModelUtils.updateConnectorContainer(history, model, connector);
            }
        });
        if (layoutParameters.needAutoLayout)
            this.applyLayout(history, model, shapes, connectors, layoutParameters, snapToGrid, gridSize);
        ModelUtils_1.ModelUtils.tryUpdateModelRectangle(history);
        history.endTransaction(true);
        this.endChangesNotification(true);
    };
    DataSource.prototype.updateModelItems = function (history, model, shapeDescriptionManager, selection, layoutParameters, addNewHistoryItem, updateDataKeys, updateTemplateItem, changes, snapToGrid, gridSize, measurer) {
        var _this = this;
        this.beginChangesNotification();
        history.beginTransaction();
        var itemsToUpdate = [];
        var layoutShapes = [];
        var layoutConnectors = [];
        var shapesToRemove = changes.nodes.removed.map(function (key) { return model.findShapeByDataKey(key); }).filter(function (item) { return item; });
        shapesToRemove.forEach(function (shape) {
            shape.attachedConnectors.forEach(function (connector) {
                if (connector.beginItem && connector.beginItem !== shape)
                    layoutShapes.push(connector.beginItem);
                if (connector.endItem && connector.endItem !== shape)
                    layoutShapes.push(connector.endItem);
            });
        });
        ModelUtils_1.ModelUtils.deleteItems(history, model, selection, shapesToRemove, true);
        var connectorsToRemove = changes.edges.removed.map(function (key) { return model.findConnectorByDataKey(key); }).filter(function (item) { return item; });
        connectorsToRemove.forEach(function (connector) {
            if (connector.beginItem)
                layoutShapes.push(connector.beginItem);
            if (connector.endItem)
                layoutShapes.push(connector.endItem);
        });
        ModelUtils_1.ModelUtils.deleteItems(history, model, selection, connectorsToRemove, true);
        layoutShapes = this.purgeLayoutShapes(layoutShapes, shapesToRemove);
        var nodeKeysToUpdate = updateDataKeys || [];
        nodeKeysToUpdate.forEach(function (dataKey) {
            if (changes.nodes.remained.indexOf(dataKey) === -1)
                return;
            var node = _this.findNode(dataKey);
            if (node) {
                var shape = model.findShapeByDataKey(dataKey);
                if (shape) {
                    var position = shape.position.clone();
                    _this.changeShapeByDataItem(history, model, shape, node, position);
                    _this.changeItemByDataItem(history, shape, node);
                }
                else
                    shape = _this.createShapeByNode(history, model, selection, shapeDescriptionManager, node, new point_1.Point(0, 0), layoutParameters, snapToGrid, gridSize, measurer);
                _this.updateShapeContainer(history, model, shape, node);
                layoutShapes.push(shape);
                itemsToUpdate.push(shape);
            }
        });
        changes.nodes.remained.forEach(function (dataKey, index) {
            var shape = model.findShapeByDataKey(dataKey);
            if (shape)
                shape.dataKey = changes.nodes.remainedNewKeys[index];
        });
        changes.nodes.added.forEach(function (dataKey) {
            var node = _this.findNode(dataKey);
            var shape = _this.createShapeByNode(history, model, selection, shapeDescriptionManager, node, new point_1.Point(0, 0), layoutParameters, snapToGrid, gridSize, measurer);
            _this.updateShapeContainer(history, model, shape, node);
            layoutShapes.push(shape);
        });
        changes.edges.added.forEach(function (dataKey) {
            var edge = _this.findEdge(dataKey);
            var fromShape = model.findShapeByDataKey(edge.from);
            var toShape = model.findShapeByDataKey(edge.to);
            var connector = _this.createConnectorByEdge(history, model, selection, edge, fromShape, toShape);
            if (connector) {
                ModelUtils_1.ModelUtils.updateConnectorContainer(history, model, connector);
                layoutConnectors.push(connector);
            }
        });
        var edgeKeysToUpdate = updateDataKeys || [];
        changes.edges.remained.forEach(function (dataKey) {
            var edge = _this.findEdge(dataKey);
            if (edge && ((changes.nodes.added.indexOf(edge.from) !== -1) || (changes.nodes.added.indexOf(edge.to) !== -1)))
                edgeKeysToUpdate.push(dataKey);
        });
        edgeKeysToUpdate.forEach(function (dataKey) {
            if (changes.edges.remained.indexOf(dataKey) === -1)
                return;
            var edge = _this.findEdge(dataKey);
            if (edge) {
                var fromShape = model.findShapeByDataKey(edge.from);
                var toShape = model.findShapeByDataKey(edge.to);
                var connector = model.findConnectorByDataKey(dataKey);
                if (connector) {
                    _this.changeConnectorPointsByDataItem(history, connector, _this.getConnectorPointsByEdge(model, edge, fromShape, toShape, false));
                    _this.changeConnectorByDataItem(history, model, connector, fromShape, toShape, edge);
                    _this.changeItemByDataItem(history, connector, edge);
                }
                else
                    connector = _this.createConnectorByEdge(history, model, selection, edge, fromShape, toShape);
                if (connector) {
                    ModelUtils_1.ModelUtils.updateConnectorContainer(history, model, connector);
                    layoutConnectors.push(connector);
                    itemsToUpdate.push(connector);
                }
            }
        });
        changes.edges.remained.forEach(function (dataKey, index) {
            var connector = model.findConnectorByDataKey(dataKey);
            if (connector)
                connector.dataKey = changes.edges.remainedNewKeys[index];
        });
        if (itemsToUpdate.length && updateTemplateItem)
            itemsToUpdate.forEach(function (item) { item.hasTemplate && updateTemplateItem(item); });
        if (layoutParameters.needAutoLayout && (layoutShapes.length || layoutConnectors.length))
            this.applyLayout(history, model, layoutShapes, layoutConnectors, layoutParameters, snapToGrid, gridSize);
        ModelUtils_1.ModelUtils.tryUpdateModelRectangle(history);
        history.endTransaction(!addNewHistoryItem);
        this.endChangesNotification(false);
    };
    DataSource.prototype.purgeLayoutShapes = function (layoutShapes, shapesToRemove) {
        var shapesToRemoveKeySet = shapesToRemove.reduce(function (acc, shape) { return (acc[shape.key] = true) && acc; }, {});
        return layoutShapes.reduce(function (acc, shape) {
            if (acc.keySet[shape.key] === undefined && shapesToRemoveKeySet[shape.key] === undefined) {
                acc.uniqueShapes.push(shape);
                acc.keySet[shape.key] = true;
            }
            return acc;
        }, { uniqueShapes: [], keySet: {} }).uniqueShapes;
    };
    DataSource.prototype.applyShapeAutoSize = function (history, measurer, shapeSizeSettings, shape, snapToGrid, gridSize) {
        if (!shape.description.enableText)
            return;
        var shapeTextSize = shape.textRectangle.createSize();
        var shapeSize = shape.size;
        var textHorOffset = shapeTextSize.width - shapeSize.width;
        var textVerOffset = shapeTextSize.height - shapeSize.height;
        var maxWidth = shape.getMaxWidth(shapeSizeSettings.shapeMaxWidth);
        var maxHeight = shape.getMaxHeight(shapeSizeSettings.shapeMaxHeight);
        var sizeToPx = function (size, isHorizontal) { return typeof (size) === "number" ? unit_converter_1.UnitConverter.twipsToPixelsF(size + (isHorizontal ? textHorOffset : textVerOffset)) : undefined; };
        var newShapeTextSize = TextUtils_1.getOptimalTextRectangle(shape.text, shape.styleText, ITextMeasurer_1.TextOwner.Shape, measurer, shapeTextSize.clone().applyConverter(unit_converter_1.UnitConverter.twipsToPixelsF), shape.description.keepRatioOnAutoSize, sizeToPx(shape.getMinWidth(shapeSizeSettings.shapeMinWidth), true), sizeToPx(maxWidth, true), sizeToPx(shape.getMinHeight(shapeSizeSettings.shapeMinHeight), false), sizeToPx(maxHeight, false))
            .clone().applyConverter(unit_converter_1.UnitConverter.pixelsToTwips);
        if (!newShapeTextSize.equals(shapeTextSize)) {
            var shapeNewSize = shape.description.getSizeByText(newShapeTextSize, shape);
            if (snapToGrid && gridSize)
                shapeNewSize = new size_1.Size(Math.min(gridSize * Math.ceil(shapeNewSize.width / gridSize), maxWidth || Number.MAX_VALUE), Math.min(gridSize * Math.ceil(shapeNewSize.height / gridSize), maxHeight || Number.MAX_VALUE));
            history.addAndRedo(new ResizeShapeHistoryItem_1.ResizeShapeHistoryItem(shape.key, shape.position, shapeNewSize));
        }
    };
    DataSource.prototype.applyLayout = function (history, model, shapes, connectors, layoutParameters, snapToGrid, gridSize) {
        var graphInfo = ModelUtils_1.ModelUtils.getGraphInfoByItems(model, shapes, connectors);
        graphInfo.forEach(function (info) {
            var layout = layoutParameters.getLayoutBuilder(info.graph).build();
            var nonGraphItems = ModelUtils_1.ModelUtils.getNonGraphItems(model, info.container, layout.nodeToLayout, shapes, connectors);
            ModelUtils_1.ModelUtils.applyLayout(history, model, info.container, info.graph, layout, nonGraphItems, layoutParameters.layoutSettings, snapToGrid, gridSize, layoutParameters.skipPointIndices);
        });
    };
    DataSource.prototype.changeItemByDataItem = function (history, item, dataItem) {
        if (dataItem.customData !== undefined && !Utils_1.ObjectUtils.compareObjects(dataItem.customData, item.customData))
            history.addAndRedo(new ChangeCustomDataHistoryItem_1.ChangeCustomDataHistoryItem(item.key, dataItem.customData));
        if (dataItem.zIndex !== undefined && dataItem.zIndex !== item.zIndex)
            history.addAndRedo(new ChangeZindexHistoryItem_1.ChangeZindexHistoryItem(item, dataItem.zIndex));
        if (dataItem.style !== undefined)
            for (var key in dataItem.style) {
                if (!Object.prototype.hasOwnProperty.call(dataItem.style, key))
                    continue;
                var value = this.getPreparedStyleValue(dataItem.style[key], Svg_1.isColorProperty(key));
                if (value !== item.style[key])
                    history.addAndRedo(new ChangeStyleHistoryItem_1.ChangeStyleHistoryItem(item.key, key, value));
            }
        var defaultStyle = item.style.getDefaultInstance();
        item.style.forEach(function (key) {
            if ((dataItem.style && dataItem.style[key] === undefined) && item.style[key] !== defaultStyle[key])
                history.addAndRedo(new ChangeStyleHistoryItem_1.ChangeStyleHistoryItem(item.key, key, defaultStyle[key]));
        });
        if (dataItem.styleText !== undefined)
            for (var key in dataItem.styleText) {
                if (!Object.prototype.hasOwnProperty.call(dataItem.styleText, key))
                    continue;
                var value = this.getPreparedStyleValue(dataItem.styleText[key], Svg_1.isColorProperty(key));
                if (value !== item.styleText[key])
                    history.addAndRedo(new ChangeStyleTextHistoryItem_1.ChangeStyleTextHistoryItem(item.key, key, value));
            }
        var defaultTextStyle = item.styleText.getDefaultInstance();
        item.styleText.forEach(function (key) {
            if ((dataItem.styleText && dataItem.styleText[key] === undefined) && item.styleText[key] !== defaultTextStyle[key])
                history.addAndRedo(new ChangeStyleTextHistoryItem_1.ChangeStyleTextHistoryItem(item.key, key, defaultTextStyle[key]));
        });
        if (dataItem.locked !== undefined && dataItem.locked !== item.locked)
            history.addAndRedo(new ChangeLockedHistoryItem_1.ChangeLockedHistoryItem(item, dataItem.locked));
    };
    DataSource.prototype.getPreparedStyleValue = function (value, isColorProperty) {
        if (isColorProperty) {
            var colorValue = color_1.ColorUtils.stringToHash(value);
            if (colorValue !== null)
                value = colorValue;
        }
        return value;
    };
    DataSource.prototype.createShapeByNode = function (history, model, selection, shapeDescriptionManager, node, point, layoutParameters, snapToGrid, gridSize, measurer) {
        var insert = new AddShapeHistoryItem_1.AddShapeHistoryItem(shapeDescriptionManager.get(node.type), point, "", node.key);
        history.addAndRedo(insert);
        var shape = model.findShape(insert.shapeKey);
        ModelUtils_1.ModelUtils.updateNewShapeProperties(history, selection, insert.shapeKey);
        this.changeShapeByDataItem(history, model, shape, node, point);
        this.changeItemByDataItem(history, shape, node);
        if (measurer && this.canUseAutoSize && layoutParameters.autoSizeEnabled)
            this.applyShapeAutoSize(history, measurer, layoutParameters.sizeSettings, shape, snapToGrid, gridSize);
        return shape;
    };
    DataSource.prototype.changeShapeByDataItem = function (history, model, shape, node, point) {
        var updated = false;
        if (node.left !== undefined)
            point.x = ModelUtils_1.ModelUtils.getTwipsValue(model.units, node.left);
        if (node.top !== undefined)
            point.y = ModelUtils_1.ModelUtils.getTwipsValue(model.units, node.top);
        updated = ModelUtils_1.ModelUtils.setShapePosition(history, model, shape, point, false) || updated;
        if (node.type !== undefined)
            updated = ModelUtils_1.ModelUtils.changeShapeType(history, model, shape, node.type) || updated;
        var size = shape.size.clone();
        if (node.width !== undefined)
            size.width = ModelUtils_1.ModelUtils.getTwipsValue(model.units, node.width);
        if (node.height !== undefined)
            size.height = ModelUtils_1.ModelUtils.getTwipsValue(model.units, node.height);
        updated = ModelUtils_1.ModelUtils.setShapeSize(history, model, shape, point, size) || updated;
        if (updated)
            ModelUtils_1.ModelUtils.updateShapeAttachedConnectors(history, model, shape);
        if (node.text !== undefined && node.text !== shape.text)
            history.addAndRedo(new ChangeShapeTextHistoryItem_1.ChangeShapeTextHistoryItem(shape, node.text));
        if (node.image !== undefined && node.image !== shape.image.actualUrl)
            history.addAndRedo(new ChangeShapeImageHistoryItem_1.ChangeShapeImageHistoryItem(shape, node.image));
    };
    DataSource.prototype.updateShapeContainer = function (history, model, shape, node) {
        var containerShape = (node.containerKey !== undefined) ? model.findShapeByDataKey(node.containerKey) : undefined;
        if (containerShape !== shape.container)
            if (containerShape)
                ModelUtils_1.ModelUtils.insertToContainer(history, model, shape, containerShape);
            else
                ModelUtils_1.ModelUtils.removeFromContainer(history, model, shape);
    };
    DataSource.prototype.getConnectorPointsByEdge = function (model, edge, fromShape, toShape, forceCreate) {
        var result = [];
        var modelPoints = this.createModelPointFromDataSourceEdgeItemPoints(model.units, edge);
        if (modelPoints && modelPoints.length > 1) {
            var lastIndex = modelPoints.length - 1;
            for (var i = 0; i <= lastIndex; i++) {
                var modelPoint = modelPoints[i];
                if (modelPoint !== null)
                    result.push(modelPoint);
                else if (!fromShape && !toShape)
                    return undefined;
                else if (i === 0 && fromShape)
                    result.push(fromShape.position.clone());
                else if (i === lastIndex && toShape)
                    result.push(toShape.position.clone());
            }
        }
        else if (forceCreate) {
            if (fromShape)
                result.push(fromShape.position.clone());
            if (toShape)
                result.push(toShape.position.clone());
        }
        return result;
    };
    DataSource.prototype.createModelPointFromDataSourceEdgeItemPoints = function (units, edge) {
        var _this = this;
        var result = [];
        if (!Array.isArray(edge.points))
            return undefined;
        edge.points.forEach(function (dep) { return result.push(_this.isValidDataSourceEdgeItemPoint(dep) ? _this.createModelPoint(units, dep) : null); });
        return result;
    };
    DataSource.prototype.createModelPoint = function (units, point) {
        return new point_1.Point(ModelUtils_1.ModelUtils.getTwipsValue(units, point.x), ModelUtils_1.ModelUtils.getTwipsValue(units, point.y));
    };
    DataSource.prototype.isValidDataSourceEdgeItemPoint = function (point) {
        return point !== undefined && point !== null &&
            point.x !== undefined && point.y !== undefined &&
            point.x !== null && point.y !== null;
    };
    DataSource.prototype.createConnectorByEdge = function (history, model, selection, edge, fromShape, toShape) {
        var connector;
        var dataKey = edge.key;
        var points = this.getConnectorPointsByEdge(model, edge, fromShape, toShape, true);
        if (points && points.length > 1) {
            var insert = new AddConnectorHistoryItem_1.AddConnectorHistoryItem(points, dataKey);
            history.addAndRedo(insert);
            connector = model.findConnector(insert.connectorKey);
            ModelUtils_1.ModelUtils.updateNewConnectorProperties(history, selection, insert.connectorKey);
            this.changeConnectorByDataItem(history, model, connector, fromShape, toShape, edge);
            this.changeItemByDataItem(history, connector, edge);
        }
        return connector;
    };
    DataSource.prototype.changeConnectorByDataItem = function (history, model, connector, fromShape, toShape, edge) {
        var fromPointIndex = edge.fromPointIndex !== undefined ? edge.fromPointIndex : connector.beginConnectionPointIndex;
        if (connector.beginItem !== fromShape || connector.beginConnectionPointIndex !== fromPointIndex) {
            if (connector.beginItem)
                history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(connector, Connector_1.ConnectorPosition.Begin));
            if (fromShape)
                history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(connector, fromShape, fromPointIndex, Connector_1.ConnectorPosition.Begin));
        }
        var toPointIndex = edge.toPointIndex !== undefined ? edge.toPointIndex : connector.endConnectionPointIndex;
        if (connector.endItem !== toShape || connector.endConnectionPointIndex !== toPointIndex) {
            if (connector.endItem)
                history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(connector, Connector_1.ConnectorPosition.End));
            if (toShape)
                history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(connector, toShape, toPointIndex, Connector_1.ConnectorPosition.End));
        }
        ModelUtils_1.ModelUtils.updateConnectorAttachedPoints(history, model, connector);
        if (edge.texts !== undefined && !this.compareTexts(edge, connector)) {
            connector.texts.forEach(function (text) {
                history.addAndRedo(new ChangeConnectorTextHistoryItem_1.ChangeConnectorTextHistoryItem(connector, text.position, undefined));
            });
            for (var key in edge.texts) {
                if (!Object.prototype.hasOwnProperty.call(edge.texts, key))
                    continue;
                var position = parseFloat(key);
                history.addAndRedo(new ChangeConnectorTextHistoryItem_1.ChangeConnectorTextHistoryItem(connector, position, edge.texts[key]));
            }
        }
        if (edge.lineOption !== undefined && edge.lineOption !== connector.properties.lineOption)
            history.addAndRedo(new ChangeConnectorPropertyHistoryItem_1.ChangeConnectorPropertyHistoryItem(connector.key, "lineOption", edge.lineOption));
        if (edge.startLineEnding !== undefined && edge.startLineEnding !== connector.properties.startLineEnding)
            history.addAndRedo(new ChangeConnectorPropertyHistoryItem_1.ChangeConnectorPropertyHistoryItem(connector.key, "startLineEnding", edge.startLineEnding));
        if (edge.endLineEnding !== undefined && edge.endLineEnding !== connector.properties.endLineEnding)
            history.addAndRedo(new ChangeConnectorPropertyHistoryItem_1.ChangeConnectorPropertyHistoryItem(connector.key, "endLineEnding", edge.endLineEnding));
    };
    DataSource.prototype.changeConnectorPointsByDataItem = function (history, connector, newPoints) {
        if (newPoints && newPoints.length > 1 && newPoints.join(",") !== connector.points.join(","))
            history.addAndRedo(new ChangeConnectorPointsHistoryItem_1.ReplaceConnectorPointsHistoryItem(connector.key, newPoints));
    };
    DataSource.prototype.compareTexts = function (edgeObj, connector) {
        var texts = edgeObj.texts || {};
        var result = Object.keys(texts).length === connector.getTextCount();
        if (result)
            for (var key in texts) {
                if (!Object.prototype.hasOwnProperty.call(texts, key))
                    continue;
                var position = parseFloat(key);
                if (!this.compareStrings(connector.getText(position), texts[key]))
                    result = false;
            }
        return result;
    };
    DataSource.prototype.compareStrings = function (str1, str2) {
        if (typeof str1 === "string" && typeof str2 === "string")
            return str1 === str2;
        return this.isEmptyString(str1) && this.isEmptyString(str2);
    };
    DataSource.prototype.isEmptyString = function (str) {
        return str === "" || str === null || str === undefined;
    };
    return DataSource;
}());
exports.DataSource = DataSource;


/***/ }),

/***/ 5558:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DataSourceEdgeItem = exports.DataSourceNodeItem = exports.DataSourceItem = void 0;
var Connector_1 = __webpack_require__(7959);
var DataSourceItem = (function () {
    function DataSourceItem(sourceKey, key, dataObj) {
        this.sourceKey = sourceKey;
        this.key = key;
        this.dataObj = dataObj;
    }
    return DataSourceItem;
}());
exports.DataSourceItem = DataSourceItem;
var DataSourceNodeItem = (function (_super) {
    __extends(DataSourceNodeItem, _super);
    function DataSourceNodeItem(sourceKey, key, dataObj, type, text, parentDataObj, containerKey, containerDataObj) {
        var _this = _super.call(this, sourceKey, key, dataObj) || this;
        _this.type = type;
        _this.text = text;
        _this.parentDataObj = parentDataObj;
        _this.containerKey = containerKey;
        _this.containerDataObj = containerDataObj;
        return _this;
    }
    return DataSourceNodeItem;
}(DataSourceItem));
exports.DataSourceNodeItem = DataSourceNodeItem;
var DataSourceEdgeItem = (function (_super) {
    __extends(DataSourceEdgeItem, _super);
    function DataSourceEdgeItem(sourceKey, key, dataObj, from, to) {
        var _this = _super.call(this, sourceKey, key, dataObj) || this;
        _this.sourceKey = sourceKey;
        _this.from = from;
        _this.to = to;
        return _this;
    }
    Object.defineProperty(DataSourceEdgeItem.prototype, "text", {
        get: function () {
            return this.texts && this.texts[Connector_1.CONNECTOR_DEFAULT_TEXT_POSITION];
        },
        enumerable: false,
        configurable: true
    });
    return DataSourceEdgeItem;
}(DataSourceItem));
exports.DataSourceEdgeItem = DataSourceEdgeItem;


/***/ }),

/***/ 8717:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DocumentDataSource = exports.UpdateNodeKeyRelatedObjectsStackAction = exports.UpdateNodeKeyRelatedObjectsStackItem = void 0;
var ShapeTypes_1 = __webpack_require__(2259);
var Shape_1 = __webpack_require__(5503);
var Connector_1 = __webpack_require__(7959);
var DataSource_1 = __webpack_require__(4225);
var ModelUtils_1 = __webpack_require__(4867);
var Data_1 = __webpack_require__(4914);
var Utils_1 = __webpack_require__(8675);
var string_1 = __webpack_require__(49);
var math_1 = __webpack_require__(8679);
var UpdateNodeKeyRelatedObjectsStackItem = (function () {
    function UpdateNodeKeyRelatedObjectsStackItem(shape, nodeObj) {
        this.shape = shape;
        this.nodeObj = nodeObj;
    }
    return UpdateNodeKeyRelatedObjectsStackItem;
}());
exports.UpdateNodeKeyRelatedObjectsStackItem = UpdateNodeKeyRelatedObjectsStackItem;
var UpdateNodeKeyRelatedObjectsStackAction = (function () {
    function UpdateNodeKeyRelatedObjectsStackAction(kind, nodeObj) {
        this.kind = kind;
        this.nodeObj = nodeObj;
    }
    return UpdateNodeKeyRelatedObjectsStackAction;
}());
exports.UpdateNodeKeyRelatedObjectsStackAction = UpdateNodeKeyRelatedObjectsStackAction;
var DocumentDataSource = (function (_super) {
    __extends(DocumentDataSource, _super);
    function DocumentDataSource(changesListener, nodeDataSource, edgeDataSource, parameters, nodeDataImporter, edgeDataImporter) {
        var _this = _super.call(this, "Document", nodeDataSource, edgeDataSource, parameters, nodeDataImporter, edgeDataImporter) || this;
        _this.changesListener = changesListener;
        _this.nodeInsertingLockCount = 0;
        _this.updateNodeKeyRelatedObjectsCount = 0;
        _this.updateNodeKeyRelatedObjectsStack = [];
        _this.updateNodeKeyRelatedObjectsStackActions = [];
        return _this;
    }
    DocumentDataSource.prototype.updateItemsByModel = function (model) {
        var _this = this;
        this.beginChangesNotification();
        this.deleteNodes(model);
        this.deleteEdges(model);
        model.items.forEach(function (item) {
            if (item instanceof Shape_1.Shape)
                _this.updateNode(model, item);
        });
        model.items.forEach(function (item) {
            if (item instanceof Connector_1.Connector)
                _this.updateEdge(model, item);
        });
        this.endChangesNotification(false);
    };
    DocumentDataSource.prototype.isItemObjectModified = function (item, itemObj, importer) {
        var modified = (importer.setLocked && itemObj.locked !== item.locked) ||
            (importer.setZIndex && itemObj.zIndex !== item.zIndex) ||
            (importer.setCustomData && !Utils_1.ObjectUtils.compareObjects(itemObj.customData, item.customData));
        if (!modified && importer.setStyle) {
            var defaultStyle_1 = item.style.getDefaultInstance();
            item.style.forEach(function (key) {
                if (item.style[key] !== defaultStyle_1[key] && item.style[key] !== (itemObj.style && itemObj.style[key]))
                    modified = true;
            });
        }
        if (!modified && importer.setStyleText) {
            var defaultTextStyle_1 = item.styleText.getDefaultInstance();
            item.styleText.forEach(function (key) {
                if (item.styleText[key] !== defaultTextStyle_1[key] && item.styleText[key] !== (itemObj.styleText && itemObj.styleText[key]))
                    modified = true;
            });
        }
        return modified;
    };
    DocumentDataSource.prototype.setDataObjectKeyRelatedProperty = function (method, dataObj, key, allowAutoGeneratedProperty) {
        if (allowAutoGeneratedProperty || this.autoGeneratedDataKeys[key] === undefined)
            method(dataObj, key);
    };
    DocumentDataSource.prototype.updateItemObjectProperties = function (itemObj, item, importer) {
        if (importer.setCustomData) {
            itemObj.customData = Utils_1.ObjectUtils.cloneObject(item.customData);
            if (itemObj.dataObj && itemObj.customData !== undefined)
                importer.setCustomData(itemObj.dataObj, item.customData);
        }
        if (importer.setLocked) {
            itemObj.locked = item.locked;
            if (itemObj.dataObj && itemObj.locked !== undefined)
                importer.setLocked(itemObj.dataObj, item.locked);
        }
        if (importer.setStyle) {
            var styleObj = item.style.toObject();
            itemObj.style = styleObj;
            if (itemObj.dataObj && itemObj.style !== undefined)
                importer.setStyle(itemObj.dataObj, Data_1.Data.objectToCssText(styleObj));
        }
        if (importer.setStyleText) {
            var styleTextObj = item.styleText.toObject();
            itemObj.styleText = styleTextObj;
            if (itemObj.dataObj && itemObj.styleText !== undefined)
                importer.setStyleText(itemObj.dataObj, Data_1.Data.objectToCssText(styleTextObj));
        }
        if (importer.setZIndex) {
            itemObj.zIndex = item.zIndex;
            if (itemObj.dataObj && itemObj.zIndex !== undefined)
                importer.setZIndex(itemObj.dataObj, item.zIndex);
        }
    };
    DocumentDataSource.prototype.deleteItems = function (dataSourceItems, findItem, getParentArray, callback) {
        var items = dataSourceItems.slice();
        items.forEach(function (item) {
            if (item.key !== undefined && item.key !== null && !findItem(item.key)) {
                var parentArray = getParentArray(item);
                var index = parentArray.indexOf(item.dataObj);
                parentArray.splice(index, 1);
                callback(item, index > -1);
            }
        });
    };
    DocumentDataSource.prototype.updateNode = function (model, shape) {
        var _this = this;
        var nodeObj = this.findNode(shape.dataKey);
        if (!nodeObj) {
            var dataObj = {};
            if (shape.dataKey !== undefined && shape.dataKey !== null)
                this.nodeDataImporter.setKey(dataObj, shape.dataKey);
            nodeObj = this.addNodeInternal(dataObj, shape.description.key, shape.text);
            this.nodeDataSource.push(nodeObj.dataObj);
            this.setDataObjectKeyRelatedProperty(this.nodeDataImporter.setKey, dataObj, nodeObj.key, this.addInternalKeyOnInsert);
            this.updateNodeObjectProperties(shape, nodeObj, model.units);
            this.updateNodeObjectConnectedProperties(shape, nodeObj);
            this.updateNodeObjectKey(shape, nodeObj, nodeObj.dataObj);
            this.beginChangesNotification();
            this.beginNodeInserting();
            this.changesListener.notifyNodeInserted.call(this.changesListener, nodeObj.dataObj, function (data) {
                _this.updateNodeObjectKey(shape, nodeObj, data);
                _this.endNodeInserting();
                _this.endChangesNotification(false);
            }, function (error) {
                _this.endNodeInserting();
                _this.endChangesNotification(false);
            });
        }
        else if (this.isNodeObjectModified(shape, nodeObj, model.units)) {
            this.updateNodeObjectProperties(shape, nodeObj, model.units);
            this.updateNodeObjectConnectedProperties(shape, nodeObj);
            this.beginChangesNotification();
            this.changesListener.notifyNodeUpdated.call(this.changesListener, this.nodeDataImporter.getKey(nodeObj.dataObj || nodeObj.key), nodeObj.dataObj, function (key, data) {
                _this.endChangesNotification(false);
            }, function (error) {
                _this.endChangesNotification(false);
            });
        }
        else
            this.updateNodeObjectConnectedProperties(shape, nodeObj, this.changesListener);
    };
    DocumentDataSource.prototype.areImageUrlsEqual = function (url1, url2) {
        return (url1 === url2) ||
            (string_1.StringUtils.isNullOrEmpty(url1) && string_1.StringUtils.isNullOrEmpty(url2));
    };
    DocumentDataSource.prototype.isNodeObjectModified = function (shape, nodeObj, units) {
        return this.isItemObjectModified(shape, nodeObj, this.nodeDataImporter) ||
            (nodeObj.type !== shape.description.key && !(nodeObj.type === undefined && shape.description.key === ShapeTypes_1.ShapeTypes.Rectangle)) ||
            !this.compareStrings(nodeObj.text, shape.text) ||
            (this.nodeDataImporter.setImage && !this.areImageUrlsEqual(nodeObj.image, shape.image.actualUrl)) ||
            (this.nodeDataImporter.setLeft && !math_1.MathUtils.numberCloseTo(nodeObj.left, ModelUtils_1.ModelUtils.getlUnitValue(units, shape.position.x))) ||
            (this.nodeDataImporter.setTop && !math_1.MathUtils.numberCloseTo(nodeObj.top, ModelUtils_1.ModelUtils.getlUnitValue(units, shape.position.y))) ||
            (this.nodeDataImporter.setWidth && !math_1.MathUtils.numberCloseTo(nodeObj.width, ModelUtils_1.ModelUtils.getlUnitValue(units, shape.size.width))) ||
            (this.nodeDataImporter.setHeight && !math_1.MathUtils.numberCloseTo(nodeObj.height, ModelUtils_1.ModelUtils.getlUnitValue(units, shape.size.height)));
    };
    DocumentDataSource.prototype.updateNodeObjectProperties = function (shape, nodeObj, units) {
        this.updateItemObjectProperties(nodeObj, shape, this.nodeDataImporter);
        if (this.nodeDataImporter.setType) {
            nodeObj.type = shape.description.key;
            this.nodeDataImporter.setType(nodeObj.dataObj, shape.description.key);
        }
        if (this.nodeDataImporter.setText) {
            nodeObj.text = shape.text;
            this.nodeDataImporter.setText(nodeObj.dataObj, shape.text);
        }
        if (this.nodeDataImporter.setImage) {
            nodeObj.image = shape.image.actualUrl;
            this.nodeDataImporter.setImage(nodeObj.dataObj, shape.image.actualUrl === undefined ? null : shape.image.actualUrl);
        }
        if (this.nodeDataImporter.setLeft) {
            var left = ModelUtils_1.ModelUtils.getlUnitValue(units, shape.position.x);
            nodeObj.left = left;
            this.nodeDataImporter.setLeft(nodeObj.dataObj, left);
        }
        if (this.nodeDataImporter.setTop) {
            var top_1 = ModelUtils_1.ModelUtils.getlUnitValue(units, shape.position.y);
            nodeObj.top = top_1;
            this.nodeDataImporter.setTop(nodeObj.dataObj, top_1);
        }
        if (this.nodeDataImporter.setWidth) {
            var width = ModelUtils_1.ModelUtils.getlUnitValue(units, shape.size.width);
            nodeObj.width = width;
            this.nodeDataImporter.setWidth(nodeObj.dataObj, width);
        }
        if (this.nodeDataImporter.setHeight) {
            var height = ModelUtils_1.ModelUtils.getlUnitValue(units, shape.size.height);
            nodeObj.height = height;
            this.nodeDataImporter.setHeight(nodeObj.dataObj, height);
        }
    };
    DocumentDataSource.prototype.updateNodeObjectConnectedProperties = function (shape, nodeObj, changesListener) {
        if (this.useNodeParentId && this.nodeDataImporter.setParentKey !== undefined) {
            var parentKey = this.getParentItemKey(shape);
            var parentItem = this.findNode(parentKey);
            this.updateNodeObjectParentKey(nodeObj, parentItem, changesListener);
        }
        if (this.useNodeContainerId && this.nodeDataImporter.setContainerKey !== undefined) {
            var containerKey = this.getContainerShapeKey(shape);
            var containerItem = this.findNode(containerKey);
            this.updateNodeObjectContainerKey(nodeObj, containerItem, changesListener);
        }
        if (this.useNodeItems && this.nodeDataImporter.setItems !== undefined) {
            var parentKey = this.getParentItemKey(shape);
            var parentItem = this.findNode(parentKey);
            this.updateNodeObjectItems(nodeObj, parentItem, changesListener);
        }
        if (this.useNodeChildren && this.nodeDataImporter.setChildren !== undefined) {
            var containerKey = this.getContainerShapeKey(shape);
            var containerItem = this.findNode(containerKey);
            this.updateNodeObjectChildren(nodeObj, containerItem, changesListener);
        }
    };
    DocumentDataSource.prototype.IsNodeParentIdMode = function () {
        return (this.useNodeParentId && this.nodeDataImporter.setParentKey !== undefined);
    };
    DocumentDataSource.prototype.IsNodeItemsMode = function () {
        return (this.useNodeItems && this.nodeDataImporter.setItems !== undefined);
    };
    DocumentDataSource.prototype.updateNodeObjectParentKey = function (nodeObj, parentNodeObj, changesListener) {
        var parentKey = this.nodeDataImporter.getParentKey(nodeObj.dataObj);
        var newParentKey = parentNodeObj ? this.nodeDataImporter.getKey(parentNodeObj.dataObj) : undefined;
        if (parentKey !== newParentKey && !(this.isRootParentKey(parentKey) && this.isRootParentKey(newParentKey))) {
            this.setDataObjectKeyRelatedProperty(this.nodeDataImporter.setParentKey, nodeObj.dataObj, newParentKey, false);
            if (changesListener)
                if (this.isInUpdateNodeKeyRelatedObjects())
                    this.addToUpdateNodeKeyRelatedObjectsStackAction("shape", nodeObj);
                else
                    this.updateNodeObjectContainerOrParentKeyInternal(nodeObj, changesListener);
        }
    };
    DocumentDataSource.prototype.updateNodeObjectParentKeyInternal = function (nodeObj, changesListener) {
        var _this = this;
        this.beginChangesNotification();
        changesListener.notifyNodeUpdated.call(changesListener, this.nodeDataImporter.getKey(nodeObj.dataObj) || nodeObj.key, nodeObj.dataObj, function (key, data) {
            _this.endChangesNotification(false);
        }, function (error) {
            _this.endChangesNotification(false);
        });
    };
    DocumentDataSource.prototype.updateNodeObjectContainerKey = function (nodeObj, containerNodeObj, changesListener) {
        var containerKey = this.nodeDataImporter.getContainerKey(nodeObj.dataObj);
        var newContainerKey = containerNodeObj ? this.nodeDataImporter.getKey(containerNodeObj.dataObj) : undefined;
        if (containerKey !== newContainerKey && !(this.isRootParentKey(containerKey) && this.isRootParentKey(newContainerKey))) {
            this.setDataObjectKeyRelatedProperty(this.nodeDataImporter.setContainerKey, nodeObj.dataObj, newContainerKey, false);
            if (changesListener)
                if (this.isInUpdateNodeKeyRelatedObjects())
                    this.addToUpdateNodeKeyRelatedObjectsStackAction("shape", nodeObj);
                else
                    this.updateNodeObjectContainerOrParentKeyInternal(nodeObj, changesListener);
        }
    };
    DocumentDataSource.prototype.updateNodeObjectContainerOrParentKeyInternal = function (nodeObj, changesListener) {
        var _this = this;
        this.beginChangesNotification();
        changesListener.notifyNodeUpdated.call(changesListener, this.nodeDataImporter.getKey(nodeObj.dataObj) || nodeObj.key, nodeObj.dataObj, function (key, data) {
            _this.endChangesNotification(false);
        }, function (error) {
            _this.endChangesNotification(false);
        });
    };
    DocumentDataSource.prototype.isRootParentKey = function (key) {
        return key === undefined || key === null || !this.findNode(key);
    };
    DocumentDataSource.prototype.updateNodeObjectItems = function (nodeObj, parentNodeObj, changesListener) {
        var _this = this;
        if (parentNodeObj && nodeObj.parentDataObj !== parentNodeObj.dataObj ||
            !parentNodeObj && nodeObj.parentDataObj)
            if (!parentNodeObj || !this.checkNodeCyrcleItems(nodeObj.dataObj, parentNodeObj.dataObj)) {
                var oldItemsArray = nodeObj.parentDataObj ? this.nodeDataImporter.getItems(nodeObj.parentDataObj) : this.nodeDataSource;
                var index = oldItemsArray.indexOf(nodeObj.dataObj);
                oldItemsArray.splice(index, 1);
                var itemsArray = parentNodeObj ? this.nodeDataImporter.getItems(parentNodeObj.dataObj) : this.nodeDataSource;
                if (!itemsArray)
                    this.nodeDataImporter.setItems(parentNodeObj.dataObj, [nodeObj.dataObj]);
                else
                    itemsArray.push(nodeObj.dataObj);
                nodeObj.parentDataObj = parentNodeObj && parentNodeObj.dataObj;
                if (changesListener) {
                    this.beginChangesNotification();
                    changesListener.notifyNodeUpdated.call(changesListener, this.nodeDataImporter.getKey(nodeObj.dataObj) || nodeObj.key, nodeObj.dataObj, function (key, data) {
                        _this.endChangesNotification(false);
                    }, function (error) {
                        _this.endChangesNotification(false);
                    });
                }
            }
    };
    DocumentDataSource.prototype.updateNodeObjectChildren = function (nodeObj, containerNodeObj, changesListener) {
        var _this = this;
        if (containerNodeObj && nodeObj.containerDataObj !== containerNodeObj.dataObj ||
            !containerNodeObj && nodeObj.containerDataObj) {
            var oldChildrenArray = nodeObj.containerDataObj ? this.nodeDataImporter.getChildren(nodeObj.containerDataObj) : this.nodeDataSource;
            var index = oldChildrenArray.indexOf(nodeObj.dataObj);
            oldChildrenArray.splice(index, 1);
            var childrenArray = containerNodeObj ? this.nodeDataImporter.getChildren(containerNodeObj.dataObj) : this.nodeDataSource;
            if (!childrenArray)
                this.nodeDataImporter.setChildren(containerNodeObj.dataObj, [nodeObj.dataObj]);
            else
                childrenArray.push(nodeObj.dataObj);
            nodeObj.containerDataObj = containerNodeObj && containerNodeObj.dataObj;
            if (changesListener) {
                this.beginChangesNotification();
                changesListener.notifyNodeUpdated.call(changesListener, this.nodeDataImporter.getKey(nodeObj.dataObj) || nodeObj.key, nodeObj.dataObj, function (key, data) {
                    _this.endChangesNotification(false);
                }, function (error) {
                    _this.endChangesNotification(false);
                });
            }
        }
    };
    DocumentDataSource.prototype.checkNodeCyrcleItems = function (nodeDataObj, parentDataObjCandidate) {
        var _this = this;
        var result = false;
        var items = this.nodeDataImporter.getItems(nodeDataObj);
        if (items)
            items.forEach(function (childDataObj) {
                result = result || childDataObj === parentDataObjCandidate ||
                    _this.checkNodeCyrcleItems(childDataObj, parentDataObjCandidate);
            });
        return result;
    };
    DocumentDataSource.prototype.updateNodeObjectKey = function (shape, nodeObj, dataObj) {
        var key = this.nodeDataImporter.getKey(dataObj);
        var dataKeyChanged = false;
        if (key !== undefined && key !== null && key !== nodeObj.key) {
            delete this.autoGeneratedDataKeys[nodeObj.key];
            nodeObj.key = key;
            dataKeyChanged = true;
        }
        shape.dataKey = nodeObj.key;
        if (nodeObj.dataObj !== dataObj) {
            var parentArray = this.getNodeArray(nodeObj);
            var index = parentArray.indexOf(nodeObj.dataObj);
            parentArray.splice(index, 1, dataObj);
            nodeObj.dataObj = dataObj;
        }
        if (dataKeyChanged)
            this.updateNodeKeyRelatedObjects(shape, nodeObj);
    };
    DocumentDataSource.prototype.updateNodeKeyRelatedObjects = function (shape, nodeObj) {
        var _this = this;
        if (this.isInNodeInserting()) {
            this.addToUpdateNodeKeyRelatedObjectsStack(shape, nodeObj);
            return;
        }
        if (this.useNodeParentId && this.nodeDataImporter.setParentKey !== undefined) {
            var childItems = this.getChildItems(shape);
            childItems.forEach(function (item) {
                var childNodeObj = _this.findNode(item.dataKey);
                if (childNodeObj)
                    _this.updateNodeObjectParentKey(childNodeObj, nodeObj, _this.changesListener);
            });
        }
        if (this.useNodeContainerId && this.nodeDataImporter.setContainerKey !== undefined)
            shape.children.forEach(function (item) {
                var childNodeObj = item instanceof Shape_1.Shape ? _this.findNode(item.dataKey) : undefined;
                if (childNodeObj)
                    _this.updateNodeObjectContainerKey(childNodeObj, nodeObj, _this.changesListener);
            });
        if (this.useEdgesArray())
            shape.attachedConnectors.forEach(function (connector) {
                var edgeObj = _this.findEdge(connector.dataKey);
                if (edgeObj) {
                    if (shape === connector.beginItem)
                        _this.updateEdgeObjectFromProperty(nodeObj, edgeObj, _this.changesListener);
                    if (shape === connector.endItem)
                        _this.updateEdgeObjectToProperty(nodeObj, edgeObj, _this.changesListener);
                }
            });
    };
    DocumentDataSource.prototype.deleteNodes = function (model) {
        var _this = this;
        this.deleteItems(this.nodes, function (key) { return model.findShapeByDataKey(key); }, function (item) { return _this.getNodeArray(item); }, function (item, dataModified) {
            var key = (item.dataObj && _this.nodeDataImporter.getKey(item.dataObj)) || item.key;
            var nodeObj = _this.findNode(key);
            if (nodeObj)
                _this.nodes.splice(_this.nodes.indexOf(nodeObj), 1);
            if (dataModified) {
                _this.beginChangesNotification();
                _this.changesListener.notifyNodeRemoved.call(_this.changesListener, key, item.dataObj, function (key, data) {
                    _this.endChangesNotification(false);
                }, function (error) {
                    _this.endChangesNotification(false);
                });
            }
        });
    };
    DocumentDataSource.prototype.getParentItem = function (shape) {
        for (var i = 0; i < shape.attachedConnectors.length; i++)
            if (shape.attachedConnectors[i].endItem === shape)
                return shape.attachedConnectors[i].beginItem;
    };
    DocumentDataSource.prototype.getParentItemKey = function (shape) {
        var parent = this.getParentItem(shape);
        return parent && parent.dataKey;
    };
    DocumentDataSource.prototype.getNodeArray = function (item) {
        var items;
        if (this.useNodeItems && item.parentDataObj)
            items = this.nodeDataImporter.getItems(item.parentDataObj);
        else if (item.containerDataObj)
            items = this.nodeDataImporter.getChildren(item.containerDataObj);
        return items || this.nodeDataSource;
    };
    DocumentDataSource.prototype.getContainerShapeKey = function (shape) {
        return shape.container && shape.container.dataKey;
    };
    DocumentDataSource.prototype.getChildItems = function (shape) {
        var items = [];
        for (var i = 0; i < shape.attachedConnectors.length; i++)
            if (shape.attachedConnectors[i].beginItem === shape)
                if (shape.attachedConnectors[i].endItem)
                    items.push(shape.attachedConnectors[i].endItem);
        return items;
    };
    DocumentDataSource.prototype.updateEdge = function (model, connector) {
        var _this = this;
        var beginDataKey = connector.beginItem ? connector.beginItem.dataKey : undefined;
        var endDataKey = connector.endItem ? connector.endItem.dataKey : undefined;
        var edgeObj = this.findEdge(connector.dataKey);
        if (!edgeObj) {
            var dataObj = this.useEdgesArray() && this.canUpdateEdgeDataSource ? {} : undefined;
            if (dataObj && connector.dataKey !== undefined && connector.dataKey !== null)
                this.edgeDataImporter.setKey(dataObj, connector.dataKey);
            edgeObj = this.addEdgeInternal(dataObj, beginDataKey, endDataKey);
            if (dataObj) {
                this.setDataObjectKeyRelatedProperty(this.edgeDataImporter.setKey, dataObj, edgeObj.key, this.addInternalKeyOnInsert);
                this.edgeDataSource.push(edgeObj.dataObj);
            }
            this.updateEdgeObjectProperties(connector, edgeObj, model.units);
            this.updateEdgeObjectKey(connector, edgeObj, edgeObj.dataObj);
            if (dataObj) {
                this.beginChangesNotification();
                this.beginNodeInserting();
                this.changesListener.notifyEdgeInserted.call(this.changesListener, edgeObj.dataObj, function (data) {
                    _this.updateEdgeObjectKey(connector, edgeObj, data);
                    _this.endNodeInserting();
                    _this.endChangesNotification(false);
                }, function (error) {
                    _this.endNodeInserting();
                    _this.endChangesNotification(false);
                });
            }
        }
        else if (this.isEdgeObjectModified(connector, edgeObj, model.units)) {
            this.updateEdgeObjectProperties(connector, edgeObj, model.units);
            if (edgeObj.dataObj) {
                this.beginChangesNotification();
                this.changesListener.notifyEdgeUpdated.call(this.changesListener, this.edgeDataImporter.getKey(edgeObj.dataObj) || edgeObj.key, edgeObj.dataObj, function (key, data) {
                    _this.endChangesNotification(false);
                }, function (error) {
                    _this.endChangesNotification(false);
                });
            }
        }
    };
    DocumentDataSource.prototype.isEdgeObjectModified = function (connector, edgeObj, units) {
        return this.isItemObjectModified(connector, edgeObj, this.edgeDataImporter) ||
            (edgeObj.from !== null ? edgeObj.from : undefined) !== (connector.beginItem ? connector.beginItem.dataKey : undefined) ||
            (edgeObj.to === null ? undefined : edgeObj.to) !== (connector.endItem ? connector.endItem.dataKey : undefined) ||
            (this.edgeDataImporter.setFromPointIndex && edgeObj.fromPointIndex !== connector.beginConnectionPointIndex) ||
            (this.edgeDataImporter.setToPointIndex && edgeObj.toPointIndex !== connector.endConnectionPointIndex) ||
            (this.edgeDataImporter.setPoints && (!edgeObj.points ||
                !this.pointsAreEqual(edgeObj.points.map(function (ptObj) { return ptObj.x; }), connector.points.map(function (pt) { return ModelUtils_1.ModelUtils.getlUnitValue(units, pt.x); })) ||
                !this.pointsAreEqual(edgeObj.points.map(function (ptObj) { return ptObj.y; }), connector.points.map(function (pt) { return ModelUtils_1.ModelUtils.getlUnitValue(units, pt.y); })))) ||
            (this.edgeDataImporter.setText && !this.compareTexts(edgeObj, connector)) ||
            (this.edgeDataImporter.setLineOption && edgeObj.lineOption !== connector.properties.lineOption) ||
            (this.edgeDataImporter.setStartLineEnding && edgeObj.startLineEnding !== connector.properties.startLineEnding) ||
            (this.edgeDataImporter.setEndLineEnding && edgeObj.endLineEnding !== connector.properties.endLineEnding);
    };
    DocumentDataSource.prototype.pointsAreEqual = function (a, b) {
        var aLen = a.length;
        var bLen = a.length;
        if (aLen !== bLen)
            return false;
        for (var i = 0; i < aLen; i++)
            if (!math_1.MathUtils.numberCloseTo(a[i], b[i]))
                return false;
        return true;
    };
    DocumentDataSource.prototype.updateEdgeObjectFromProperty = function (fromObj, edgeObj, changesListener) {
        edgeObj.from = fromObj && fromObj.key;
        if (edgeObj.dataObj) {
            var fromKey = fromObj && fromObj.dataObj && this.nodeDataImporter.getKey(fromObj.dataObj);
            this.setDataObjectKeyRelatedProperty(this.edgeDataImporter.setFrom, edgeObj.dataObj, fromKey, false);
            if (changesListener)
                if (this.isInUpdateNodeKeyRelatedObjects())
                    this.addToUpdateNodeKeyRelatedObjectsStackAction("edge", edgeObj);
                else
                    this.updateEdgeObjectFromOrToPropertyInternal(edgeObj, changesListener);
        }
    };
    DocumentDataSource.prototype.updateEdgeObjectFromOrToPropertyInternal = function (edgeObj, changesListener) {
        var _this = this;
        this.beginChangesNotification();
        changesListener.notifyEdgeUpdated.call(changesListener, this.nodeDataImporter.getKey(edgeObj.dataObj) || edgeObj.key, edgeObj.dataObj, function (key, data) {
            _this.endChangesNotification(false);
        }, function (error) {
            _this.endChangesNotification(false);
        });
    };
    DocumentDataSource.prototype.updateEdgeObjectToProperty = function (toObj, edgeObj, changesListener) {
        edgeObj.to = toObj && toObj.key;
        if (edgeObj.dataObj) {
            var toKey = toObj && toObj.dataObj && this.nodeDataImporter.getKey(toObj.dataObj);
            this.setDataObjectKeyRelatedProperty(this.edgeDataImporter.setTo, edgeObj.dataObj, toKey, false);
            if (changesListener)
                if (this.isInUpdateNodeKeyRelatedObjects())
                    this.addToUpdateNodeKeyRelatedObjectsStackAction("edge", edgeObj);
                else
                    this.updateEdgeObjectFromOrToPropertyInternal(edgeObj, changesListener);
        }
    };
    DocumentDataSource.prototype.updateEdgeObjectProperties = function (connector, edgeObj, units) {
        this.updateItemObjectProperties(edgeObj, connector, this.edgeDataImporter);
        if (this.edgeDataImporter.setFrom) {
            var fromObj = this.findNode(connector.beginItem && connector.beginItem.dataKey);
            this.updateEdgeObjectFromProperty(fromObj, edgeObj);
        }
        if (this.edgeDataImporter.setTo) {
            var toObj = this.findNode(connector.endItem && connector.endItem.dataKey);
            this.updateEdgeObjectToProperty(toObj, edgeObj);
        }
        if (this.edgeDataImporter.setFromPointIndex) {
            edgeObj.fromPointIndex = connector.beginConnectionPointIndex;
            if (edgeObj.dataObj)
                this.edgeDataImporter.setFromPointIndex(edgeObj.dataObj, connector.beginConnectionPointIndex);
        }
        if (this.edgeDataImporter.setToPointIndex) {
            edgeObj.toPointIndex = connector.endConnectionPointIndex;
            if (edgeObj.dataObj)
                this.edgeDataImporter.setToPointIndex(edgeObj.dataObj, connector.endConnectionPointIndex);
        }
        if (this.edgeDataImporter.setPoints) {
            var points = connector.points.map(function (pt) {
                return {
                    x: ModelUtils_1.ModelUtils.getlUnitValue(units, pt.x),
                    y: ModelUtils_1.ModelUtils.getlUnitValue(units, pt.y)
                };
            });
            edgeObj.points = points;
            if (edgeObj.dataObj)
                this.edgeDataImporter.setPoints(edgeObj.dataObj, points);
        }
        if (this.edgeDataImporter.setText) {
            var text = void 0;
            if (connector.getTextCount() === 1 && connector.getText())
                text = connector.getText();
            var texts_1 = {};
            connector.texts.forEach(function (text) {
                texts_1[text.position] = text.value;
            });
            edgeObj.texts = texts_1;
            if (edgeObj.dataObj) {
                var textVal = "";
                if (text)
                    textVal = text;
                else if (texts_1 && Object.keys(texts_1).length)
                    textVal = texts_1;
                this.edgeDataImporter.setText(edgeObj.dataObj, textVal);
            }
        }
        if (this.edgeDataImporter.setLineOption) {
            edgeObj.lineOption = connector.properties.lineOption;
            if (edgeObj.dataObj)
                this.edgeDataImporter.setLineOption(edgeObj.dataObj, connector.properties.lineOption);
        }
        if (this.edgeDataImporter.setStartLineEnding) {
            edgeObj.startLineEnding = connector.properties.startLineEnding;
            if (edgeObj.dataObj)
                this.edgeDataImporter.setStartLineEnding(edgeObj.dataObj, connector.properties.startLineEnding);
        }
        if (this.edgeDataImporter.setEndLineEnding) {
            edgeObj.endLineEnding = connector.properties.endLineEnding;
            if (edgeObj.dataObj)
                this.edgeDataImporter.setEndLineEnding(edgeObj.dataObj, connector.properties.endLineEnding);
        }
    };
    DocumentDataSource.prototype.updateEdgeObjectKey = function (connector, edgeObj, dataObj) {
        var key = dataObj && this.edgeDataImporter.getKey(dataObj);
        if (key !== undefined && key !== null && key !== edgeObj.key) {
            delete this.autoGeneratedDataKeys[edgeObj.key];
            edgeObj.key = key;
        }
        connector.dataKey = edgeObj.key;
        if (edgeObj.dataObj !== dataObj) {
            var parentArray = this.edgeDataSource;
            var index = parentArray.indexOf(edgeObj.dataObj);
            parentArray.splice(index, 1, dataObj);
            edgeObj.dataObj = dataObj;
        }
    };
    DocumentDataSource.prototype.deleteEdges = function (model) {
        var _this = this;
        this.deleteItems(this.edges, function (key) { return model.findConnectorByDataKey(key); }, function (item) { return _this.edgeDataSource; }, function (item, dataModified) {
            var key = (item.dataObj && _this.edgeDataImporter.getKey(item.dataObj)) || item.key;
            var edgeObj = _this.findEdge(key);
            if (edgeObj)
                _this.edges.splice(_this.edges.indexOf(edgeObj), 1);
            if (dataModified) {
                _this.beginChangesNotification();
                _this.changesListener.notifyEdgeRemoved.call(_this.changesListener, key, item.dataObj, function (key, data) {
                    _this.endChangesNotification(false);
                }, function (error) {
                    _this.endChangesNotification(false);
                });
            }
        });
    };
    DocumentDataSource.prototype.beginNodeInserting = function () {
        this.nodeInsertingLockCount++;
    };
    DocumentDataSource.prototype.endNodeInserting = function () {
        this.nodeInsertingLockCount--;
        if (this.nodeInsertingLockCount === 0)
            this.raiseNodeInsertingStack();
    };
    DocumentDataSource.prototype.isInNodeInserting = function () {
        return this.nodeInsertingLockCount > 0;
    };
    DocumentDataSource.prototype.addToUpdateNodeKeyRelatedObjectsStack = function (shape, nodeObj) {
        var item = new UpdateNodeKeyRelatedObjectsStackItem(shape, nodeObj);
        this.updateNodeKeyRelatedObjectsStack.push(item);
    };
    DocumentDataSource.prototype.raiseNodeInsertingStack = function () {
        this.beginUpdateNodeKeyRelatedObjects();
        while (this.updateNodeKeyRelatedObjectsStack.length > 0) {
            var item = this.updateNodeKeyRelatedObjectsStack[0];
            this.updateNodeKeyRelatedObjects(item.shape, item.nodeObj);
            this.updateNodeKeyRelatedObjectsStack.splice(0, 1);
            if (item.shape.description.hasTemplate && item.nodeObj)
                this.changesListener.reloadInsertedItem(item.nodeObj.key);
        }
        this.endUpdateNodeKeyRelatedObjects();
    };
    DocumentDataSource.prototype.beginUpdateNodeKeyRelatedObjects = function () {
        this.updateNodeKeyRelatedObjectsCount++;
    };
    DocumentDataSource.prototype.endUpdateNodeKeyRelatedObjects = function () {
        this.updateNodeKeyRelatedObjectsCount--;
        if (this.updateNodeKeyRelatedObjectsCount === 0)
            this.raiseUpdateNodeKeyRelatedObjectsStack();
    };
    DocumentDataSource.prototype.isInUpdateNodeKeyRelatedObjects = function () {
        return this.updateNodeKeyRelatedObjectsCount > 0;
    };
    DocumentDataSource.prototype.addToUpdateNodeKeyRelatedObjectsStackAction = function (kind, nodeObj) {
        var item = new UpdateNodeKeyRelatedObjectsStackAction(kind, nodeObj);
        for (var i = 0; i < this.updateNodeKeyRelatedObjectsStackActions.length; i++)
            if ((this.updateNodeKeyRelatedObjectsStackActions[i].kind === kind) && (this.updateNodeKeyRelatedObjectsStackActions[i].nodeObj === nodeObj))
                return;
        this.updateNodeKeyRelatedObjectsStackActions.push(item);
    };
    DocumentDataSource.prototype.raiseUpdateNodeKeyRelatedObjectsStack = function () {
        while (this.updateNodeKeyRelatedObjectsStackActions.length > 0) {
            var item = this.updateNodeKeyRelatedObjectsStackActions[0];
            switch (item.kind) {
                case "shape":
                    this.updateNodeObjectContainerOrParentKeyInternal(item.nodeObj, this.changesListener);
                    break;
                case "edge":
                    this.updateEdgeObjectFromOrToPropertyInternal(item.nodeObj, this.changesListener);
                    break;
            }
            this.updateNodeKeyRelatedObjectsStackActions.splice(0, 1);
        }
    };
    DocumentDataSource.prototype.beginChangesNotification = function () {
        this.changesListener.beginChangesNotification();
    };
    DocumentDataSource.prototype.endChangesNotification = function (preventNotifyChanges) {
        this.changesListener.endChangesNotification(preventNotifyChanges);
    };
    return DocumentDataSource;
}(DataSource_1.DataSource));
exports.DocumentDataSource = DocumentDataSource;


/***/ }),

/***/ 9463:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Diagnostics = void 0;
var LoggerDisplayMode;
(function (LoggerDisplayMode) {
    LoggerDisplayMode[LoggerDisplayMode["Disabled"] = 0] = "Disabled";
    LoggerDisplayMode[LoggerDisplayMode["Console"] = 1] = "Console";
    LoggerDisplayMode[LoggerDisplayMode["Document"] = 2] = "Document";
})(LoggerDisplayMode || (LoggerDisplayMode = {}));
var Diagnostics = (function () {
    function Diagnostics() {
    }
    Diagnostics.beginAverage = function (groupName) {
        if (!this.enableLogsAndTimers)
            return;
        this.lastAverageGroupName = groupName;
    };
    Diagnostics.endAverage = function () {
        if (!this.enableLogsAndTimers)
            return;
        this.lastAverageGroupName = null;
    };
    Diagnostics.tryLogAverage = function (groupName) {
        var _this = this;
        if (this.lastAverageGroupName === groupName)
            return;
        var sameGroupTimers = Object.keys(this.timers)
            .map(function (t) { return _this.timers[t]; })
            .filter(function (t) { return t.groupName === groupName; });
        if (!sameGroupTimers.filter(function (t) { return !t.endTime; }).length) {
            var average = sameGroupTimers.reduce(function (acc, t) { return acc + (t.endTime - t.startTime); }, 0) / sameGroupTimers.length;
            this.log("average: " + average);
        }
    };
    Diagnostics.timer = function (message) {
        if (!this.enableLogsAndTimers)
            return;
        this.lastCreatedTimer = {
            message: message,
            startTime: performance.now(),
            groupName: this.lastAverageGroupName
        };
    };
    Diagnostics.endTimer = function () {
        var _this = this;
        if (!this.enableLogsAndTimers)
            return;
        var timer = this.lastCreatedTimer;
        var timeoutID = setTimeout(function () {
            timer.endTime = performance.now();
            _this.showMessage("timer \"" + timer.message + "\": " + (timer.endTime - timer.startTime));
            timer.groupName && _this.tryLogAverage(timer.groupName);
        }, 0);
        this.timers[timeoutID] = timer;
        this.lastCreatedTimer = null;
    };
    Diagnostics.logPerfInfo = function () {
        var nodesCount = document.querySelector(".dxdi-control > svg").querySelectorAll("*").length;
        var memory = performance["memory"];
        this.log("nodes: " + nodesCount.toLocaleString() + (memory ? " memory: " : "") + (memory ? memory["usedJSHeapSize"].toLocaleString() : ""));
    };
    Diagnostics.log = function (message) {
        this.showMessage(message);
    };
    Diagnostics.showMessage = function (message) {
        switch (Diagnostics.mode) {
            case LoggerDisplayMode.Console:
                console.log(message);
                break;
            case LoggerDisplayMode.Document: {
                var existText = this.getElement().value;
                if (this.lastMessage === message) {
                    var lastLineLength = existText.indexOf("\r\n");
                    if (lastLineLength < 0)
                        lastLineLength = existText.indexOf("\n");
                    var lastLine = existText.substr(0, lastLineLength);
                    var regex = /( \()([0-9]+)(\))$/;
                    if (regex.test(lastLine))
                        lastLine = lastLine.replace(/( \()([0-9]+)(\))$/, function (str, before, val, after) { return before + (++val) + after; });
                    else
                        lastLine += " (1)";
                    this.getElement().value = lastLine + existText.substr(lastLineLength);
                }
                else {
                    this.getElement().value = message + "\r\n" + existText;
                    this.lastMessage = message;
                }
            }
        }
    };
    Diagnostics.getElement = function () {
        var _this = this;
        if (!this.el) {
            this.el = document.createElement("textarea");
            this.el.style.top = "0px";
            this.el.style.right = "0px";
            this.el.style.position = "fixed";
            this.el.style.background = "transparent";
            this.el.style.fontSize = "11px";
            this.el.style.fontFamily = "monospace";
            this.el.style.overflow = "auto";
            this.el.style.width = "400px";
            document.body.appendChild(this.el);
            var clr = document.createElement("button");
            clr.innerHTML = "x";
            clr.addEventListener("click", function () { _this.el.value = ""; _this.lastMessage = ""; });
            clr.style.top = "0px";
            clr.style.right = "400px";
            clr.style.position = "fixed";
            clr.style.opacity = "0.1";
            document.body.appendChild(clr);
        }
        return this.el;
    };
    Diagnostics.mode = LoggerDisplayMode.Document;
    Diagnostics.optimizeUsingRAF = true;
    Diagnostics.optimizeLayers = true;
    Diagnostics.timers = {};
    Diagnostics.enableLogsAndTimers = false;
    return Diagnostics;
}());
exports.Diagnostics = Diagnostics;


/***/ }),

/***/ 2106:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DiagramControl = void 0;
var point_1 = __webpack_require__(8900);
var ModelManipulator_1 = __webpack_require__(1118);
var CommandManager_1 = __webpack_require__(7156);
var EventManager_1 = __webpack_require__(82);
var Model_1 = __webpack_require__(6613);
var Selection_1 = __webpack_require__(9021);
var History_1 = __webpack_require__(1864);
var BarManager_1 = __webpack_require__(2230);
var RenderManager_1 = __webpack_require__(8098);
var ShapeDescriptionManager_1 = __webpack_require__(8397);
var DocumentDataSource_1 = __webpack_require__(8717);
var Settings_1 = __webpack_require__(240);
var ModelOperationSettings_1 = __webpack_require__(6879);
var ViewController_1 = __webpack_require__(6734);
var ModelUtils_1 = __webpack_require__(4867);
var ToolboxManager_1 = __webpack_require__(3298);
var Utils_1 = __webpack_require__(8675);
var ApiController_1 = __webpack_require__(5656);
var ImageCache_1 = __webpack_require__(7176);
var PermissionsProvider_1 = __webpack_require__(2883);
var ConnectorRoutingModel_1 = __webpack_require__(5714);
var TextMeasurer_1 = __webpack_require__(1733);
var Connector_1 = __webpack_require__(7959);
var DataLayoutParameters_1 = __webpack_require__(3503);
var ReloadContentParameters_1 = __webpack_require__(6214);
var Utils_2 = __webpack_require__(3500);
var _1 = __webpack_require__(3607);
var math_1 = __webpack_require__(8679);
var DiagramControl = (function () {
    function DiagramControl() {
        this.updateLockCount = 0;
        this.shouldUpdateItemsByModel = false;
        this.reloadContentNeeded = false;
        this.reloadContentParameters = new ReloadContentParameters_1.ReloadContentParameters();
        this.reloadContentByExternalChangesParameters = new ReloadContentParameters_1.ReloadContentParameters();
        this.instanceId = math_1.MathUtils.generateGuid();
        this.settings = new Settings_1.DiagramSettings();
        this.shapeDescriptionManager = new ShapeDescriptionManager_1.ShapeDescriptionManager();
        this.shapeDescriptionManager.onShapeDecriptionChanged.add(this);
        this.model = new Model_1.DiagramModel();
        this.selection = new Selection_1.Selection(this.model);
        this.onNativeAction = new Utils_1.EventDispatcher();
        this.apiController = new ApiController_1.ApiController(this.onNativeAction, this.selection, this.model);
        this.permissionsProvider = new PermissionsProvider_1.PermissionsProvider(this.apiController);
        this.permissionsProvider.onRequestOperation.add(this);
        this.routingModel = new ConnectorRoutingModel_1.ConnectorRoutingModel();
        this.modelManipulator = new ModelManipulator_1.ModelManipulator(this.model, this.routingModel, this.permissionsProvider, this.shapeDescriptionManager);
        this.modelManipulator.onModelChanged.add(this.permissionsProvider);
        this.history = new History_1.History(this.modelManipulator, this);
        this.barManager = new BarManager_1.BarManager(this);
        this.view = new ViewController_1.ViewController(this.settings, this.barManager);
        this.commandManager = new CommandManager_1.CommandManager(this);
        this.eventManager = new EventManager_1.EventManager(this);
        this.settings.onReadOnlyChanged.add(this.eventManager.mouseHandler);
        this.settings.onReadOnlyChanged.add(this.eventManager.visualizersManager);
        this.selection.onChanged.add(this.barManager);
        this.selection.onChanged.add(this.apiController);
        this.selection.onChanged.add(this.permissionsProvider);
        this.modelManipulator.commitItemsCreateChanges();
        this.history.onChanged.add(this);
        this.toolboxManager = new ToolboxManager_1.ToolboxManager(this.shapeDescriptionManager);
        this.settings.onConnectorRoutingModeChanged.add(this.routingModel);
        ImageCache_1.ImageCache.instance.onReadyStateChanged.add(this);
    }
    Object.defineProperty(DiagramControl.prototype, "operationSettings", {
        get: function () {
            return this.permissionsProvider.operationSettings;
        },
        enumerable: false,
        configurable: true
    });
    DiagramControl.prototype.cleanMarkup = function (removeElement) {
        removeElement = removeElement || (function (element) { Utils_2.RenderUtils.removeElement(element); });
        this.toolboxManager.clean(removeElement);
        this.barManager.clean();
        if (this.render) {
            this.settings.onZoomChanged.remove(this.render.view);
            this.settings.onViewChanged.remove(this.render.page);
            this.settings.onViewChanged.remove(this.render.view);
            this.settings.onReadOnlyChanged.remove(this.render);
            this.settings.onReadOnlyChanged.remove(this.render.selection);
            this.eventManager.cleanToolboxes(this.settings.onReadOnlyChanged);
            this.eventManager.onTextInputOperation.remove(this.render.input);
            this.eventManager.onTextInputOperation.remove(this.render.items);
            this.eventManager.onTextInputOperation.remove(this.render.selection);
            this.eventManager.onMouseOperation.remove(this.render.items);
            this.eventManager.onMouseOperation.remove(this.render.selection);
            this.eventManager.onMouseOperation.remove(this.render.view);
            this.eventManager.onMouseOperation.remove(this.render);
            this.eventManager.onVisualizersUpdate.remove(this.render.selection);
            this.modelManipulator.onModelSizeChanged.remove(this.render.view);
            this.modelManipulator.onModelSizeChanged.remove(this.render.page);
            this.modelManipulator.onModelChanged.remove(this.render.items);
            this.modelManipulator.onModelChanged.remove(this.render.page);
            this.modelManipulator.onModelChanged.remove(this.render.selection);
            this.selection.onChanged.remove(this.render.selection);
            this.selection.onChanged.remove(this.render.items);
            this.render.clean(removeElement);
            this.render = undefined;
        }
        if (this.measurer && this.measurer instanceof TextMeasurer_1.TextMeasurer)
            this.measurer.clean();
    };
    DiagramControl.prototype.dispose = function () {
        ImageCache_1.ImageCache.instance.onReadyStateChanged.remove(this);
    };
    DiagramControl.prototype.createDocument = function (parent, scrollView, focusElementsParent) {
        if (!this.measurer)
            this.initMeasurer(parent);
        if (this.render)
            this.render.replaceParent(parent, scrollView);
        else {
            this.render = new RenderManager_1.RenderManager(parent, this.eventManager, this.measurer, {
                pageColor: this.model.pageColor,
                modelSize: this.model.size,
                pageLandscape: this.model.pageLandscape,
                pageSize: this.model.pageSize,
                simpleView: this.settings.simpleView,
                readOnly: this.settings.readOnly,
                contextMenuEnabled: this.settings.contextMenuEnabled,
                gridSize: this.settings.gridSize,
                gridVisible: this.settings.showGrid,
                zoomLevel: this.settings.zoomLevel,
                autoZoom: this.settings.autoZoom,
                rectangle: this.model.getRectangle(true)
            }, this.instanceId, scrollView, focusElementsParent);
            this.settings.onZoomChanged.add(this.render.view);
            this.settings.onViewChanged.add(this.render.page);
            this.settings.onViewChanged.add(this.render.view);
            this.settings.onReadOnlyChanged.add(this.render);
            this.settings.onReadOnlyChanged.add(this.render.selection);
            this.eventManager.onTextInputOperation.add(this.render.input);
            this.eventManager.onTextInputOperation.add(this.render.items);
            this.eventManager.onTextInputOperation.add(this.render.selection);
            this.eventManager.onTextInputOperation.add(this);
            this.eventManager.onMouseOperation.add(this.render.items);
            this.eventManager.onMouseOperation.add(this.render.selection);
            this.eventManager.onMouseOperation.add(this.render.view);
            this.eventManager.onMouseOperation.add(this.render);
            this.eventManager.onVisualizersUpdate.add(this.render.selection);
            this.modelManipulator.onModelSizeChanged.add(this.render.view);
            this.modelManipulator.onModelSizeChanged.add(this.render.page);
            this.modelManipulator.onModelChanged.add(this.render.items);
            this.modelManipulator.onModelChanged.add(this.render.page);
            this.modelManipulator.onModelChanged.add(this.render.selection);
            this.selection.onChanged.add(this.render.selection);
            this.selection.onChanged.add(this.render.items);
            this.render.update(false);
            this.render.onNewModel(this.model.items);
            this.modelManipulator.commitItemsCreateChanges();
            this.view.initialize(this.render.view);
            if (this.settings.zoomLevelWasChanged)
                this.raiseCanvasViewActualZoomChanged();
            this.selection.raiseSelectionChanged();
        }
    };
    DiagramControl.prototype.createToolbox = function (parent, renderAsText, shapes, options) {
        var toolbox = this.toolboxManager.create(parent, this.settings.readOnly, true, renderAsText, shapes, this.getToolboxAllowedShapeTypes.bind(this), this.instanceId, options);
        this.settings.onReadOnlyChanged.add(toolbox);
        toolbox.onDragOperation.add(this);
        toolbox.onDragOperation.add(this.apiController);
        this.eventManager.registerToolbox(toolbox);
    };
    DiagramControl.prototype.createContextToolbox = function (parent, renderAsText, shapes, options, onClick) {
        this.cleanContextToolbox();
        this.contextToolbox = this.toolboxManager.create(parent, this.settings.readOnly, false, renderAsText, shapes, this.getToolboxAllowedShapeTypes.bind(this), this.instanceId, options);
        this.contextToolbox.onClickOperation.add(this);
        this.contextToolboxOnClick = onClick;
    };
    DiagramControl.prototype.getToolboxAllowedShapeTypes = function (shapeTypes) {
        var _this = this;
        var allowedShapeTypes = [];
        this.permissionsProvider.beginUpdateUI();
        shapeTypes.forEach(function (shapeType) {
            if (_this.permissionsProvider.canAddShapeFromToolbox(shapeType))
                allowedShapeTypes.push(shapeType);
        });
        this.permissionsProvider.endUpdateUI();
        return allowedShapeTypes;
    };
    DiagramControl.prototype.cleanContextToolbox = function () {
        if (this.contextToolbox) {
            this.toolboxManager.clean(undefined, this.contextToolbox);
            this.contextToolbox = undefined;
            this.contextToolboxOnClick = undefined;
        }
    };
    DiagramControl.prototype.refreshToolbox = function (toolboxes) {
        this.permissionsProvider.clearCache(ModelOperationSettings_1.DiagramModelOperation.AddShapeFromToolbox);
        this.toolboxManager.refresh(toolboxes);
    };
    DiagramControl.prototype.applyToolboxFilter = function (shapeSubstring, toolboxes) {
        return this.toolboxManager.applyFilter(shapeSubstring, toolboxes);
    };
    DiagramControl.prototype.notifyToolboxClick = function (shapeType) {
        if (this.contextToolboxOnClick)
            this.contextToolboxOnClick(shapeType);
    };
    DiagramControl.prototype.initMeasurer = function (parent) {
        this.measurer = new TextMeasurer_1.TextMeasurer(parent);
    };
    DiagramControl.prototype.onDimensionChanged = function () {
        if (!_1.Browser.TouchUI)
            this.updateLayout(true);
    };
    DiagramControl.prototype.updateLayout = function (resetScroll) {
        if (resetScroll === void 0) { resetScroll = false; }
        this.render && this.render.update(!resetScroll);
    };
    DiagramControl.prototype.captureFocus = function () {
        this.render && this.render.input.captureFocus();
    };
    DiagramControl.prototype.isFocused = function () {
        return !this.render || this.render.input.isFocused();
    };
    DiagramControl.prototype.registerBar = function (bar) {
        this.barManager.registerBar(bar);
    };
    DiagramControl.prototype.updateBarItemsState = function (bar, queryCommands) {
        this.barManager.updateBarItemsState(bar, queryCommands);
    };
    DiagramControl.prototype.getCommand = function (key) {
        return this.commandManager.getCommand(key);
    };
    DiagramControl.prototype.getNativeItemByKey = function (key) {
        var item = this.model.findItem(key);
        return item && this.apiController.createNativeItem(item);
    };
    DiagramControl.prototype.getNativeItemByDataKey = function (dataKey) {
        var item = this.model.findItemByDataKey(dataKey);
        return item && this.apiController.createNativeItem(item);
    };
    DiagramControl.prototype.getNativeItems = function () {
        var _this = this;
        return this.model.items.map(function (item) { return _this.apiController.createNativeItem(item); });
    };
    DiagramControl.prototype.getNativeSelectedItems = function () {
        var _this = this;
        return this.selection.getKeys().map(function (key) { return _this.apiController.createNativeItem(_this.model.findItem(key)); });
    };
    DiagramControl.prototype.setSelectedItems = function (keys) {
        this.selection.set(keys);
    };
    DiagramControl.prototype.scrollToItems = function (keys) {
        var _this = this;
        var rectangle = Utils_1.GeometryUtils.getCommonRectangle(keys.map(function (key) { return _this.model.findItem(key).rectangle; }));
        this.view.scrollIntoView(rectangle);
    };
    DiagramControl.prototype.setInitialStyleProperties = function (style) {
        this.selection.inputPosition.setInitialStyleProperties(style);
    };
    DiagramControl.prototype.setInitialTextStyleProperties = function (style) {
        this.selection.inputPosition.setInitialTextStyleProperties(style);
    };
    DiagramControl.prototype.setInitialConnectorProperties = function (properties) {
        this.selection.inputPosition.setInitialConnectorProperties(properties);
    };
    DiagramControl.prototype.addCustomShapes = function (shapes) {
        var _this = this;
        shapes.forEach(function (shape) {
            shape.apiController = _this.apiController;
            if (shape.defaultWidth)
                shape.defaultWidth = ModelUtils_1.ModelUtils.getTwipsValue(_this.model.units, shape.defaultWidth);
            if (shape.defaultHeight)
                shape.defaultHeight = ModelUtils_1.ModelUtils.getTwipsValue(_this.model.units, shape.defaultHeight);
            if (shape.minWidth)
                shape.minWidth = ModelUtils_1.ModelUtils.getTwipsValue(_this.model.units, shape.minWidth);
            if (shape.minHeight)
                shape.minHeight = ModelUtils_1.ModelUtils.getTwipsValue(_this.model.units, shape.minHeight);
            if (shape.maxWidth)
                shape.maxWidth = ModelUtils_1.ModelUtils.getTwipsValue(_this.model.units, shape.maxWidth);
            if (shape.maxHeight)
                shape.maxHeight = ModelUtils_1.ModelUtils.getTwipsValue(_this.model.units, shape.maxHeight);
            _this.shapeDescriptionManager.registerCustomShape(shape);
        });
    };
    DiagramControl.prototype.removeCustomShapes = function (shapeTypes) {
        var _this = this;
        shapeTypes.forEach(function (shapeType) {
            _this.shapeDescriptionManager.unregisterCustomShape(shapeType);
        });
    };
    DiagramControl.prototype.removeAllCustomShapes = function () {
        this.shapeDescriptionManager.unregisterAllCustomShapes();
    };
    DiagramControl.prototype.importModel = function (model) {
        model.units = this.model.units;
        this.model = model;
        this.model.initializeKeyCounter();
        this.apiController.model = model;
        this.onImportData();
    };
    DiagramControl.prototype.importItemsData = function () {
        this.onImportData();
    };
    DiagramControl.prototype.onImportData = function () {
        if (this.render) {
            this.render.clear();
            this.render.onNewModel(this.model.items);
        }
        this.permissionsProvider.clearCache();
        this.selection.initialize(this.model);
        this.modelManipulator.initialize(this.model, this.routingModel);
        this.history.clear();
        this.eventManager.initialize();
        this.modelManipulator.commitPageChanges();
        this.modelManipulator.commitItemsCreateChanges();
        this.notifyViewChanged();
        this.notifyHistoryChanged();
    };
    DiagramControl.prototype.createDocumentDataSource = function (nodeDataSource, edgeDataSource, parameters, nodeDataImporter, edgeDataImporter) {
        this.documentDataSource = new DocumentDataSource_1.DocumentDataSource(this, nodeDataSource, edgeDataSource, parameters, nodeDataImporter, edgeDataImporter);
        this.apiController.setDataSource(this.documentDataSource);
        return this.documentDataSource;
    };
    DiagramControl.prototype.deleteDocumentDataSource = function () {
        this.apiController.setDataSource(null);
        delete this.documentDataSource;
    };
    DiagramControl.prototype.applyShapeSizeSettings = function (settings) {
        this.settings.applyShapeSizeSettings(settings, this.model.units);
    };
    DiagramControl.prototype.applyOperationSettings = function (settings) {
        this.permissionsProvider.operationSettings.applySettings(settings);
    };
    DiagramControl.prototype.beginUpdateCanvas = function () {
        if (this.render) {
            this.render.items.beginUpdate();
            this.render.selection.beginUpdate();
        }
    };
    DiagramControl.prototype.endUpdateCanvas = function () {
        if (this.render) {
            this.render.items.endUpdate();
            this.render.selection.endUpdate();
        }
    };
    DiagramControl.prototype.beginUpdate = function () {
        this.barManager.beginUpdate();
        this.apiController.beginUpdate();
        this.eventManager.beginUpdate();
    };
    DiagramControl.prototype.endUpdate = function () {
        this.barManager.endUpdate();
        this.apiController.endUpdate();
        this.eventManager.endUpdate();
    };
    DiagramControl.prototype.notifyEdgeInserted = function (data, callback, errorCallback) {
        if (this.onEdgeInserted)
            this.onEdgeInserted(data, callback, errorCallback);
        else
            callback(data);
    };
    DiagramControl.prototype.notifyEdgeUpdated = function (key, data, callback, errorCallback) {
        if (this.onEdgeUpdated)
            this.onEdgeUpdated(key, data, callback, errorCallback);
        else
            callback(key, data);
    };
    DiagramControl.prototype.notifyEdgeRemoved = function (key, data, callback, errorCallback) {
        if (this.onEdgeUpdated)
            this.onEdgeRemoved(key, data, callback, errorCallback);
        else
            callback(key, data);
    };
    DiagramControl.prototype.notifyNodeInserted = function (data, callback, errorCallback) {
        if (this.onNodeInserted)
            this.onNodeInserted(data, callback, errorCallback);
        else
            callback(data);
    };
    DiagramControl.prototype.notifyNodeUpdated = function (key, data, callback, errorCallback) {
        if (this.onNodeUpdated)
            this.onNodeUpdated(key, data, callback, errorCallback);
        else
            callback(key, data);
    };
    DiagramControl.prototype.notifyNodeRemoved = function (key, data, callback, errorCallback) {
        if (this.onNodeRemoved)
            this.onNodeRemoved(key, data, callback, errorCallback);
        else
            callback(key, data);
    };
    DiagramControl.prototype.reloadInsertedItem = function (dataKey) {
        if (this.settings.reloadInsertedItemRequired)
            this.reloadContent(dataKey);
    };
    DiagramControl.prototype.reloadContent = function (dataKey, getData, layoutParameters, isExternalChanges) {
        if (!this.documentDataSource)
            return;
        if (this.isChangesLocked())
            this.reloadContentNeeded = true;
        var addNewHistoryItem = isExternalChanges === true || (isExternalChanges === undefined && !this.reloadContentNeeded);
        var reloadContentParameters = addNewHistoryItem ? this.reloadContentByExternalChangesParameters : this.reloadContentParameters;
        reloadContentParameters.add(dataKey, getData, layoutParameters);
        if (!this.isChangesLocked()) {
            this.reloadContentCore(reloadContentParameters, addNewHistoryItem);
            this.barManager.updateItemsState();
        }
    };
    DiagramControl.prototype.reloadContentCore = function (parameters, addNewHistoryItem) {
        var _this = this;
        var data = parameters.getData && parameters.getData();
        var changes = this.documentDataSource.refetchData(data && data.nodeDataSource, data && data.edgeDataSource);
        this.beginUpdateCanvas();
        this.permissionsProvider.lockPermissions();
        this.documentDataSource.updateModelItems(this.history, this.model, this.shapeDescriptionManager, this.selection, new DataLayoutParameters_1.DataLayoutParameters(this.settings, parameters.layoutParameters), addNewHistoryItem, parameters.dataKeys, function (item) {
            _this.modelManipulator.commitItemUpdateChanges(item);
        }, changes, this.settings.snapToGrid, this.settings.gridSize, this.measurer);
        this.permissionsProvider.unlockPermissions();
        this.endUpdateCanvas();
        parameters.clear();
    };
    DiagramControl.prototype.notifyHistoryChanged = function () {
        if (this.documentDataSource) {
            this.shouldUpdateItemsByModel = true;
            if (!this.settings.readOnly)
                this.notifyDataChanges();
        }
        else
            this.raiseOnChanged();
    };
    DiagramControl.prototype.notifyViewChanged = function () {
        this.settings.notifyViewChanged();
    };
    DiagramControl.prototype.notifyToolboxDragStart = function (evt) {
        this.render.notifyToolboxDragStart(evt);
        if (this.onToolboxDragStart)
            this.onToolboxDragStart();
    };
    DiagramControl.prototype.notifyToolboxDragEnd = function (evt) {
        this.render.notifyToolboxDragEnd(evt);
        if (this.onToolboxDragEnd)
            this.onToolboxDragEnd();
    };
    DiagramControl.prototype.notifyToolboxDraggingMouseMove = function (evt) {
        if (this.render)
            this.render.notifyToolboxDraggingMouseMove(evt);
    };
    DiagramControl.prototype.notifyTextInputStart = function (item, text, position, size) {
        if (this.onTextInputStart)
            this.onTextInputStart();
    };
    DiagramControl.prototype.notifyTextInputEnd = function (item, captureFocus) {
        if (this.onTextInputEnd)
            this.onTextInputEnd();
    };
    DiagramControl.prototype.notifyTextInputPermissionsCheck = function (item, allowed) { };
    DiagramControl.prototype.notifyToggleFullscreen = function (value) {
        if (this.onToggleFullscreen)
            this.onToggleFullscreen(value);
    };
    DiagramControl.prototype.notifyShowContextMenu = function (eventPoint, modelPoint) {
        if (this.onShowContextMenu && this.render) {
            var selection = void 0;
            var selectedItems = this.selection.getSelectedItems(true);
            if (selectedItems.length > 0) {
                var rect = ModelUtils_1.ModelUtils.createRectangle(this.selection.getSelectedItems(true));
                var pos = this.render.getEventPointByModelPoint(rect.createPosition());
                var size = this.render.view.getAbsoluteSize(rect.createSize());
                selection = { x: pos.x, y: pos.y, width: size.width, height: size.height };
            }
            if (eventPoint) {
                this.contextMenuPosition = new point_1.Point(eventPoint.x, eventPoint.y);
                this.onShowContextMenu(eventPoint.x, eventPoint.y, selection);
            }
            else if (modelPoint) {
                var point = this.render.getEventPointByModelPoint(modelPoint);
                this.contextMenuPosition = point.clone();
                this.onShowContextMenu(point.x, point.y, selection);
            }
        }
    };
    DiagramControl.prototype.notifyHideContextMenu = function () {
        if (this.onHideContextMenu && this.render)
            this.onHideContextMenu();
    };
    DiagramControl.prototype.notifyShowContextToolbox = function (modelPoint, getPositionToInsertShapeTo, side, category, callback) {
        if (this.onShowContextToolbox && this.render) {
            var point = this.render.getEventPointByModelPoint(modelPoint);
            this.onShowContextToolbox(point.x, point.y, side, category, callback);
            this.render.view.notifyShowContextToolbox();
        }
    };
    DiagramControl.prototype.notifyHideContextToolbox = function () {
        if (this.onHideContextToolbox && this.render) {
            this.onHideContextToolbox();
            this.render.view.notifyHideContextToolbox();
        }
        this.cleanContextToolbox();
    };
    DiagramControl.prototype.notifyShapeDescriptionChanged = function (description) {
        this.modelManipulator.updateShapeDescription(description);
    };
    DiagramControl.prototype.notifyImageCacheReadyStateChanged = function (ready) {
        this.barManager.updateItemsState();
    };
    DiagramControl.prototype.raiseCanvasViewActualZoomChanged = function () {
        this.render.view.raiseActualZoomChanged();
    };
    DiagramControl.prototype.notifyRequestOperation = function (operation, args) {
        if (this.requestOperationByDataSource(operation, args))
            return;
        if (this.onRequestOperation)
            this.onRequestOperation(operation, args);
    };
    DiagramControl.prototype.requestOperationByDataSource = function (operation, args) {
        if (!(this.documentDataSource && (this.documentDataSource.IsNodeParentIdMode() || this.documentDataSource.IsNodeItemsMode())))
            return false;
        if (operation === ModelOperationSettings_1.DiagramModelOperation.ChangeConnection) {
            var e = args;
            var shape = e.shape && this.model.findItem(e.shape.id);
            var connector = e.connector && this.model.findItem(e.connector.id);
            if (!(shape && connector))
                return;
            if (e.position === Connector_1.ConnectorPosition.End)
                for (var i = 0; i < shape.attachedConnectors.length; i++) {
                    var attachedConnector = shape.attachedConnectors[i];
                    if (attachedConnector !== connector && attachedConnector.endItem && attachedConnector.endItem === shape) {
                        e.allowed = false;
                        break;
                    }
                }
            if (e.allowed && connector.beginItem && connector.endItem && this.isShapeParent(connector.endItem, connector.beginItem))
                e.allowed = false;
        }
        return !args.allowed;
    };
    DiagramControl.prototype.isShapeParent = function (parentShape, shape) {
        if (parentShape === shape)
            return true;
        for (var i = 0; i < parentShape.attachedConnectors.length; i++) {
            var attachedConnector = parentShape.attachedConnectors[i];
            if (attachedConnector.beginItem === parentShape && attachedConnector.endItem) {
                var childShape = attachedConnector.endItem;
                if (childShape === shape || this.isShapeParent(childShape, shape))
                    return true;
            }
        }
        return false;
    };
    DiagramControl.prototype.isChangesLocked = function () {
        return this.updateLockCount > 0;
    };
    DiagramControl.prototype.beginChangesNotification = function () {
        if (!this.isChangesLocked())
            if (this.changesLockChanged)
                this.changesLockChanged(true);
        this.updateLockCount++;
    };
    DiagramControl.prototype.endChangesNotification = function (preventNotifyReloadContent) {
        var _this = this;
        this.updateLockCount--;
        if (!this.isChangesLocked()) {
            this.changesLockChanged(false);
            if (!preventNotifyReloadContent)
                setTimeout(function () {
                    _this.notifyReloadContent();
                    _this.notifyDataChanges();
                }, 0);
        }
    };
    DiagramControl.prototype.changesLockChanged = function (locked) {
        if (locked)
            this.lockedReadOnly = this.settings.readOnly;
        else
            locked = this.lockedReadOnly;
        this.commandManager.getCommand(CommandManager_1.DiagramCommand.ToggleReadOnly).execute(locked);
    };
    DiagramControl.prototype.notifyDataChanges = function () {
        if (this.isChangesLocked())
            return;
        if (this.shouldUpdateItemsByModel) {
            this.documentDataSource.updateItemsByModel(this.model);
            this.shouldUpdateItemsByModel = false;
        }
        this.raiseOnChanged();
    };
    DiagramControl.prototype.notifyReloadContent = function () {
        if (this.reloadContentNeeded) {
            if (!this.reloadContentParameters.empty)
                this.reloadContentCore(this.reloadContentParameters, false);
            if (!this.reloadContentByExternalChangesParameters.empty)
                this.reloadContentCore(this.reloadContentByExternalChangesParameters, true);
            this.reloadContentNeeded = false;
        }
    };
    DiagramControl.prototype.raiseOnChanged = function () {
        if (this.onChanged)
            this.onChanged();
    };
    return DiagramControl;
}());
exports.DiagramControl = DiagramControl;


/***/ }),

/***/ 5383:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PageOrientation = exports.DiagramUnit = void 0;
var DiagramUnit;
(function (DiagramUnit) {
    DiagramUnit[DiagramUnit["In"] = 0] = "In";
    DiagramUnit[DiagramUnit["Cm"] = 1] = "Cm";
    DiagramUnit[DiagramUnit["Px"] = 2] = "Px";
})(DiagramUnit = exports.DiagramUnit || (exports.DiagramUnit = {}));
var PageOrientation;
(function (PageOrientation) {
    PageOrientation[PageOrientation["Portrait"] = 0] = "Portrait";
    PageOrientation[PageOrientation["Landscape"] = 1] = "Landscape";
})(PageOrientation = exports.PageOrientation || (exports.PageOrientation = {}));


/***/ }),

/***/ 9946:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContextMenuHandler = void 0;
var Utils_1 = __webpack_require__(8675);
var Event_1 = __webpack_require__(6031);
var key_1 = __webpack_require__(2153);
var batch_updatable_1 = __webpack_require__(1772);
var browser_1 = __webpack_require__(9279);
var ContextMenuHandler = (function (_super) {
    __extends(ContextMenuHandler, _super);
    function ContextMenuHandler() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.contextMenuVisible = false;
        _this.textInputStarted = false;
        _this.canHideContextMenu = true;
        _this.onVisibilityChanged = new Utils_1.EventDispatcher();
        return _this;
    }
    ContextMenuHandler.prototype.onMouseDown = function (evt) {
        if (evt.button === Event_1.MouseButton.Left && evt.source.type !== Event_1.MouseEventElementType.Undefined)
            this.hideContextMenu();
    };
    ContextMenuHandler.prototype.onMouseUp = function (evt) {
        if (!browser_1.Browser.MacOSPlatform || browser_1.Browser.MacOSPlatform && this.canHideContextMenu)
            this.hideContextMenu();
        this.canHideContextMenu = true;
    };
    ContextMenuHandler.prototype.onContextMenu = function (evt) {
        if (browser_1.Browser.MacOSPlatform)
            this.canHideContextMenu = false;
        this.showContextMenu(evt.eventPoint, evt.modelPoint);
    };
    ContextMenuHandler.prototype.onFocus = function (evt) { };
    ContextMenuHandler.prototype.onBlur = function (evt) { };
    ContextMenuHandler.prototype.onTextInputFocus = function (evt) { };
    ContextMenuHandler.prototype.onTextInputBlur = function (evt) { };
    ContextMenuHandler.prototype.onLongTouch = function (evt) { };
    ContextMenuHandler.prototype.onKeyDown = function (evt) {
        if (evt.keyCode === key_1.KeyCode.Esc)
            this.hideContextMenu();
    };
    ContextMenuHandler.prototype.onShortcut = function (evt) {
        this.hideContextMenu();
    };
    ContextMenuHandler.prototype.showContextMenu = function (eventPoint, modelPoint) {
        var _this = this;
        if (this.textInputStarted)
            return;
        window.setTimeout(function () {
            _this.onVisibilityChanged.raise1(function (l) { return l.notifyShowContextMenu(eventPoint, modelPoint); });
            _this.contextMenuVisible = true;
        }, 1);
    };
    ContextMenuHandler.prototype.hideContextMenu = function () {
        var _this = this;
        if (this.contextMenuVisible)
            window.setTimeout(function () {
                _this.onVisibilityChanged.raise1(function (l) { return l.notifyHideContextMenu(); });
                _this.contextMenuVisible = false;
            }, 1);
    };
    ContextMenuHandler.prototype.notifyDragStart = function (itemKeys) { };
    ContextMenuHandler.prototype.notifyDragEnd = function (itemKeys) { };
    ContextMenuHandler.prototype.notifyDragScrollStart = function () { };
    ContextMenuHandler.prototype.notifyDragScrollEnd = function () { };
    ContextMenuHandler.prototype.notifyShowContextToolbox = function (modelPoint, getPositionToInsertShapeTo, side, category, callback) { };
    ContextMenuHandler.prototype.notifyHideContextToolbox = function () { };
    ContextMenuHandler.prototype.notifyTextInputStart = function (item, text, position, size) {
        this.textInputStarted = true;
    };
    ContextMenuHandler.prototype.notifyTextInputEnd = function (item, captureFocus) {
        this.textInputStarted = false;
    };
    ContextMenuHandler.prototype.notifyTextInputPermissionsCheck = function (item, allowed) { };
    ContextMenuHandler.prototype.onUpdateUnlocked = function (occurredEvents) { };
    return ContextMenuHandler;
}(batch_updatable_1.BatchUpdatableObject));
exports.ContextMenuHandler = ContextMenuHandler;


/***/ }),

/***/ 151:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContextMenuTouchHandler = void 0;
var Event_1 = __webpack_require__(6031);
var ContextMenuHandler_1 = __webpack_require__(9946);
var ModelUtils_1 = __webpack_require__(4867);
var SELECTION_CHANGED_EVENT = 1;
var ContextMenuTouchHandler = (function (_super) {
    __extends(ContextMenuTouchHandler, _super);
    function ContextMenuTouchHandler(selection) {
        var _this = _super.call(this) || this;
        _this.selection = selection;
        _this.contextToolboxVisible = false;
        _this.selection.onChanged.add(_this);
        return _this;
    }
    ContextMenuTouchHandler.prototype.onMouseDown = function (evt) {
        if (evt.source.key === undefined)
            this.hideContextMenu();
    };
    ContextMenuTouchHandler.prototype.onMouseUp = function (evt) {
    };
    ContextMenuTouchHandler.prototype.onFocus = function (evt) {
        var _this = this;
        setTimeout(function () { _this.showContextMenuAtSelection(); }, 1);
    };
    ContextMenuTouchHandler.prototype.onBlur = function (evt) {
        var _this = this;
        setTimeout(function () { _this.hideContextMenu(); }, 1);
    };
    ContextMenuTouchHandler.prototype.onTextInputFocus = function (evt) {
        var _this = this;
        setTimeout(function () { _this.hideContextMenu(); }, 1);
    };
    ContextMenuTouchHandler.prototype.onTextInputBlur = function (evt) {
        var _this = this;
        setTimeout(function () { _this.showContextMenuAtSelection(); }, 1);
    };
    ContextMenuTouchHandler.prototype.onLongTouch = function (evt) {
        if (evt.source.type === Event_1.MouseEventElementType.Document)
            this.showContextMenuAtEmptySelection(evt.modelPoint);
    };
    ContextMenuTouchHandler.prototype.onKeyDown = function (evt) {
    };
    ContextMenuTouchHandler.prototype.onShortcut = function (evt) {
    };
    ContextMenuTouchHandler.prototype.getSelectedItems = function () {
        return this.selection.getSelectedItems(true);
    };
    ContextMenuTouchHandler.prototype.showContextMenuAtSelection = function () {
        if (this.contextToolboxVisible)
            return;
        var items = this.getSelectedItems();
        if (items.length !== 0)
            this.showContextMenu(undefined, ModelUtils_1.ModelUtils.createRectangle(items).createPosition());
    };
    ContextMenuTouchHandler.prototype.showContextMenuAtEmptySelection = function (point) {
        if (this.contextToolboxVisible)
            return;
        var items = this.getSelectedItems();
        if (items.length === 0)
            this.showContextMenu(undefined, point);
    };
    ContextMenuTouchHandler.prototype.notifyDragStart = function (itemKeys) {
        this.hideContextMenu();
    };
    ContextMenuTouchHandler.prototype.notifyDragEnd = function (itemKeys) {
        this.showContextMenuAtSelection();
    };
    ContextMenuTouchHandler.prototype.notifySelectionChanged = function (selection) {
        if (this.isUpdateLocked())
            this.registerOccurredEvent(SELECTION_CHANGED_EVENT);
        else
            this.raiseSelectionChanged();
    };
    ContextMenuTouchHandler.prototype.raiseSelectionChanged = function () {
        var items = this.getSelectedItems();
        if (items.length !== 0)
            this.showContextMenuAtSelection();
        else
            this.hideContextMenu();
    };
    ContextMenuTouchHandler.prototype.onUpdateUnlocked = function (occurredEvents) {
        if (occurredEvents & SELECTION_CHANGED_EVENT)
            this.raiseSelectionChanged();
    };
    ContextMenuTouchHandler.prototype.notifyShowContextToolbox = function (modelPoint, getPositionToInsertShapeTo, side, category, callback) {
        this.contextToolboxVisible = true;
        this.hideContextMenu();
    };
    ContextMenuTouchHandler.prototype.notifyHideContextToolbox = function () {
        this.contextToolboxVisible = false;
        this.showContextMenuAtSelection();
    };
    return ContextMenuTouchHandler;
}(ContextMenuHandler_1.ContextMenuHandler));
exports.ContextMenuTouchHandler = ContextMenuTouchHandler;


/***/ }),

/***/ 4426:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContextToolboxHandler = void 0;
var Event_1 = __webpack_require__(6031);
var Utils_1 = __webpack_require__(8675);
var key_1 = __webpack_require__(2153);
var browser_1 = __webpack_require__(9279);
var ContextToolboxHandler = (function () {
    function ContextToolboxHandler() {
        this.contextToolboxVisible = false;
        this.onVisibilityChanged = new Utils_1.EventDispatcher();
    }
    ContextToolboxHandler.prototype.onMouseDown = function (evt) {
        if (evt.source.type !== Event_1.MouseEventElementType.Undefined)
            this.hideContextToolbox();
    };
    ContextToolboxHandler.prototype.onMouseUp = function (evt) {
        if (evt.source.type !== Event_1.MouseEventElementType.Undefined || !browser_1.Browser.TouchUI)
            this.hideContextToolbox();
    };
    ContextToolboxHandler.prototype.onFocus = function (evt) { };
    ContextToolboxHandler.prototype.onBlur = function (evt) { };
    ContextToolboxHandler.prototype.onKeyDown = function (evt) {
        if (evt.keyCode === key_1.KeyCode.Esc)
            this.hideContextToolbox();
    };
    ContextToolboxHandler.prototype.onShortcut = function (evt) {
        this.hideContextToolbox();
    };
    ContextToolboxHandler.prototype.showContextToolbox = function (modelPoint, getPositionToInsertShapeTo, side, category, applyCallback, cancelCallback) {
        this.onVisibilityChanged.raise1(function (l) { return l.notifyShowContextToolbox(modelPoint, getPositionToInsertShapeTo, side, category, applyCallback); });
        this.contextToolboxVisible = true;
        this.contextToolboxCancelCallback = cancelCallback;
    };
    ContextToolboxHandler.prototype.hideContextToolbox = function (applyed) {
        if (this.contextToolboxVisible) {
            this.onVisibilityChanged.raise1(function (l) { return l.notifyHideContextToolbox(); });
            if (this.contextToolboxCancelCallback) {
                if (!applyed)
                    this.contextToolboxCancelCallback();
                this.contextToolboxCancelCallback = undefined;
            }
            this.contextToolboxVisible = false;
        }
    };
    return ContextToolboxHandler;
}());
exports.ContextToolboxHandler = ContextToolboxHandler;


/***/ }),

/***/ 6031:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DiagramClipboardEvent = exports.DiagramKeyboardEvent = exports.DiagramContextMenuEvent = exports.DiagramWheelEvent = exports.DiagramMouseEvent = exports.DiagramMouseEventBase = exports.DiagramMouseEventTouch = exports.DiagramFocusEvent = exports.DiagramEvent = exports.ResizeEventSource = exports.MouseEventSource = exports.MouseEventElementType = exports.MouseButton = void 0;
var key_1 = __webpack_require__(2153);
var MouseButton;
(function (MouseButton) {
    MouseButton[MouseButton["None"] = 0] = "None";
    MouseButton[MouseButton["Left"] = 1] = "Left";
    MouseButton[MouseButton["Right"] = 2] = "Right";
    MouseButton[MouseButton["Middle"] = 4] = "Middle";
})(MouseButton = exports.MouseButton || (exports.MouseButton = {}));
var MouseEventElementType;
(function (MouseEventElementType) {
    MouseEventElementType[MouseEventElementType["Undefined"] = 0] = "Undefined";
    MouseEventElementType[MouseEventElementType["Background"] = 1] = "Background";
    MouseEventElementType[MouseEventElementType["Document"] = 2] = "Document";
    MouseEventElementType[MouseEventElementType["Connector"] = 3] = "Connector";
    MouseEventElementType[MouseEventElementType["ConnectorPoint"] = 4] = "ConnectorPoint";
    MouseEventElementType[MouseEventElementType["ConnectorSide"] = 5] = "ConnectorSide";
    MouseEventElementType[MouseEventElementType["ConnectorOrthogonalSide"] = 6] = "ConnectorOrthogonalSide";
    MouseEventElementType[MouseEventElementType["ConnectorText"] = 7] = "ConnectorText";
    MouseEventElementType[MouseEventElementType["Shape"] = 8] = "Shape";
    MouseEventElementType[MouseEventElementType["ShapeResizeBox"] = 9] = "ShapeResizeBox";
    MouseEventElementType[MouseEventElementType["ShapeParameterBox"] = 10] = "ShapeParameterBox";
    MouseEventElementType[MouseEventElementType["SelectionRect"] = 11] = "SelectionRect";
    MouseEventElementType[MouseEventElementType["ShapeConnectionPoint"] = 12] = "ShapeConnectionPoint";
    MouseEventElementType[MouseEventElementType["ShapeExpandButton"] = 13] = "ShapeExpandButton";
})(MouseEventElementType = exports.MouseEventElementType || (exports.MouseEventElementType = {}));
var MouseEventSource = (function () {
    function MouseEventSource(type, key, value) {
        this.type = type;
        this.key = key;
        this.value = value;
    }
    Object.defineProperty(MouseEventSource.prototype, "isConnector", {
        get: function () { return this.type === MouseEventElementType.Connector || this.type === MouseEventElementType.ConnectorText; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MouseEventSource.prototype, "isShape", {
        get: function () { return this.type === MouseEventElementType.Shape || this.type === MouseEventElementType.ShapeConnectionPoint; },
        enumerable: false,
        configurable: true
    });
    return MouseEventSource;
}());
exports.MouseEventSource = MouseEventSource;
var ResizeEventSource;
(function (ResizeEventSource) {
    ResizeEventSource[ResizeEventSource["Undefined"] = 0] = "Undefined";
    ResizeEventSource[ResizeEventSource["ResizeBox_NW"] = 1] = "ResizeBox_NW";
    ResizeEventSource[ResizeEventSource["ResizeBox_NE"] = 2] = "ResizeBox_NE";
    ResizeEventSource[ResizeEventSource["ResizeBox_SE"] = 3] = "ResizeBox_SE";
    ResizeEventSource[ResizeEventSource["ResizeBox_SW"] = 4] = "ResizeBox_SW";
    ResizeEventSource[ResizeEventSource["ResizeBox_N"] = 5] = "ResizeBox_N";
    ResizeEventSource[ResizeEventSource["ResizeBox_E"] = 6] = "ResizeBox_E";
    ResizeEventSource[ResizeEventSource["ResizeBox_S"] = 7] = "ResizeBox_S";
    ResizeEventSource[ResizeEventSource["ResizeBox_W"] = 8] = "ResizeBox_W";
})(ResizeEventSource = exports.ResizeEventSource || (exports.ResizeEventSource = {}));
var DiagramEvent = (function () {
    function DiagramEvent(modifiers) {
        this.modifiers = modifiers;
    }
    return DiagramEvent;
}());
exports.DiagramEvent = DiagramEvent;
var DiagramFocusEvent = (function (_super) {
    __extends(DiagramFocusEvent, _super);
    function DiagramFocusEvent(inputText) {
        var _this = _super.call(this, key_1.ModifierKey.None) || this;
        _this.inputText = inputText;
        return _this;
    }
    return DiagramFocusEvent;
}(DiagramEvent));
exports.DiagramFocusEvent = DiagramFocusEvent;
var DiagramMouseEventTouch = (function () {
    function DiagramMouseEventTouch(offsetPoint, modelPoint) {
        this.offsetPoint = offsetPoint;
        this.modelPoint = modelPoint;
    }
    return DiagramMouseEventTouch;
}());
exports.DiagramMouseEventTouch = DiagramMouseEventTouch;
var DiagramMouseEventBase = (function (_super) {
    __extends(DiagramMouseEventBase, _super);
    function DiagramMouseEventBase(modifiers, offsetPoint, modelPoint, source) {
        var _this = _super.call(this, modifiers) || this;
        _this.offsetPoint = offsetPoint;
        _this.modelPoint = modelPoint;
        _this.source = source;
        return _this;
    }
    return DiagramMouseEventBase;
}(DiagramEvent));
exports.DiagramMouseEventBase = DiagramMouseEventBase;
var DiagramMouseEvent = (function (_super) {
    __extends(DiagramMouseEvent, _super);
    function DiagramMouseEvent(modifiers, button, offsetPoint, modelPoint, source, touches, isTouchMode) {
        if (touches === void 0) { touches = []; }
        var _this = _super.call(this, modifiers, offsetPoint, modelPoint, source) || this;
        _this.button = button;
        _this.touches = touches;
        _this.isTouchMode = isTouchMode;
        _this.scrollX = 0;
        _this.scrollY = 0;
        return _this;
    }
    return DiagramMouseEvent;
}(DiagramMouseEventBase));
exports.DiagramMouseEvent = DiagramMouseEvent;
var DiagramWheelEvent = (function (_super) {
    __extends(DiagramWheelEvent, _super);
    function DiagramWheelEvent(modifiers, deltaX, deltaY, offsetPoint, modelPoint, source) {
        var _this = _super.call(this, modifiers, offsetPoint, modelPoint, source) || this;
        _this.deltaX = deltaX;
        _this.deltaY = deltaY;
        return _this;
    }
    return DiagramWheelEvent;
}(DiagramMouseEventBase));
exports.DiagramWheelEvent = DiagramWheelEvent;
var DiagramContextMenuEvent = (function (_super) {
    __extends(DiagramContextMenuEvent, _super);
    function DiagramContextMenuEvent(modifiers, eventPoint, modelPoint) {
        var _this = _super.call(this, modifiers) || this;
        _this.eventPoint = eventPoint;
        _this.modelPoint = modelPoint;
        return _this;
    }
    return DiagramContextMenuEvent;
}(DiagramEvent));
exports.DiagramContextMenuEvent = DiagramContextMenuEvent;
var DiagramKeyboardEvent = (function (_super) {
    __extends(DiagramKeyboardEvent, _super);
    function DiagramKeyboardEvent(modifiers, keyCode, inputText) {
        var _this = _super.call(this, modifiers) || this;
        _this.keyCode = keyCode;
        _this.inputText = inputText;
        return _this;
    }
    DiagramKeyboardEvent.prototype.getShortcutCode = function () {
        return this.modifiers | this.keyCode;
    };
    return DiagramKeyboardEvent;
}(DiagramEvent));
exports.DiagramKeyboardEvent = DiagramKeyboardEvent;
var DiagramClipboardEvent = (function (_super) {
    __extends(DiagramClipboardEvent, _super);
    function DiagramClipboardEvent(clipboardData) {
        var _this = _super.call(this, key_1.ModifierKey.None) || this;
        _this.clipboardData = clipboardData;
        return _this;
    }
    return DiagramClipboardEvent;
}(DiagramEvent));
exports.DiagramClipboardEvent = DiagramClipboardEvent;


/***/ }),

/***/ 82:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EventManager = void 0;
var MouseHandler_1 = __webpack_require__(5689);
var Utils_1 = __webpack_require__(8675);
var TextInputHandler_1 = __webpack_require__(8376);
var ContextMenuHandler_1 = __webpack_require__(9946);
var ContextMenuTouchHandler_1 = __webpack_require__(151);
var VisualizersManager_1 = __webpack_require__(7733);
var VisualizersTouchManager_1 = __webpack_require__(7459);
var ContextToolboxHandler_1 = __webpack_require__(4426);
var browser_1 = __webpack_require__(9279);
var key_1 = __webpack_require__(2153);
var EventManager = (function () {
    function EventManager(control) {
        this.onMouseOperation = new Utils_1.EventDispatcher();
        this.onTextInputOperation = new Utils_1.EventDispatcher();
        this.toolboxes = [];
        this.control = control;
        this.visualizersManager = Utils_1.EventUtils.isTouchMode() ?
            new VisualizersTouchManager_1.VisualizerTouchManager(control.selection, control.model, this, control.settings) :
            new VisualizersManager_1.VisualizerManager(control.selection, control.model, this, control.settings);
        this.onMouseOperation.add(this.visualizersManager);
        this.contextMenuHandler = browser_1.Browser.TouchUI ?
            new ContextMenuTouchHandler_1.ContextMenuTouchHandler(control.selection) :
            new ContextMenuHandler_1.ContextMenuHandler();
        this.contextMenuHandler.onVisibilityChanged.add(control);
        this.onMouseOperation.add(this.contextMenuHandler);
        this.onTextInputOperation.add(this.contextMenuHandler);
        this.contextToolboxHandler = new ContextToolboxHandler_1.ContextToolboxHandler();
        this.contextToolboxHandler.onVisibilityChanged.add(control);
        this.contextToolboxHandler.onVisibilityChanged.add(this.contextMenuHandler);
        this.mouseHandler = new MouseHandler_1.MouseHandler(control.history, control.selection, control.model, this, control.settings.readOnly, control.view, this.visualizersManager, this.contextToolboxHandler, control.shapeDescriptionManager, control.settings, control.permissionsProvider);
        this.textInputHandler = new TextInputHandler_1.TextInputHandler(control);
        this.visualizersManager.onVisualizersUpdate.add(this.mouseHandler);
    }
    Object.defineProperty(EventManager.prototype, "onVisualizersUpdate", {
        get: function () {
            return this.visualizersManager.onVisualizersUpdate;
        },
        enumerable: false,
        configurable: true
    });
    EventManager.prototype.registerToolbox = function (toolbox) {
        this.toolboxes.push(toolbox);
    };
    EventManager.prototype.cleanToolboxes = function (eventDispatcher) {
        this.toolboxes.forEach(function (toolbox) {
            eventDispatcher.remove(toolbox);
        });
        this.toolboxes = [];
    };
    EventManager.prototype.initialize = function () {
        this.visualizersManager.initialize(this.control.model);
        this.mouseHandler.initialize(this.control.model);
    };
    EventManager.prototype.beginUpdate = function (lockUpdateCanvas) {
        this.contextMenuHandler.beginUpdate();
        this.visualizersManager.beginUpdate();
    };
    EventManager.prototype.endUpdate = function () {
        this.contextMenuHandler.endUpdate();
        this.visualizersManager.endUpdate();
    };
    EventManager.prototype.onMouseDown = function (evt) {
        this.mouseHandler.onMouseDown(evt);
        this.contextMenuHandler.onMouseDown(evt);
        this.visualizersManager.onMouseDown(evt);
        this.contextToolboxHandler.onMouseDown(evt);
    };
    EventManager.prototype.onMouseMove = function (evt) {
        this.processDragging(evt);
        this.mouseHandler.onMouseMove(evt);
    };
    EventManager.prototype.onMouseUp = function (evt) {
        this.contextToolboxHandler.onMouseUp(evt);
        this.mouseHandler.onMouseUp(evt);
        this.contextMenuHandler.onMouseUp(evt);
        this.visualizersManager.onMouseUp(evt);
        this.processDragging(evt);
    };
    EventManager.prototype.onMouseEnter = function (evt) {
        this.visualizersManager.onMouseEnter(evt);
    };
    EventManager.prototype.onMouseLeave = function (evt) {
        this.visualizersManager.onMouseLeave(evt);
    };
    EventManager.prototype.onDblClick = function (evt) {
        this.mouseHandler.onMouseDblClick(evt);
        this.textInputHandler.onDblClick(evt);
        this.control.apiController.notifyDblClick(evt);
    };
    EventManager.prototype.onClick = function (evt) {
        this.mouseHandler.onMouseClick(evt);
        this.control.apiController.notifyClick(evt);
    };
    EventManager.prototype.onContextMenu = function (evt) {
        this.contextMenuHandler.onContextMenu(evt);
    };
    EventManager.prototype.onLongTouch = function (evt) {
        this.mouseHandler.onLongTouch(evt);
        this.contextMenuHandler.onLongTouch(evt);
    };
    EventManager.prototype.onBlur = function (evt) {
        this.contextMenuHandler.onBlur(evt);
        this.contextToolboxHandler.onBlur(evt);
        this.visualizersManager.onBlur(evt);
    };
    EventManager.prototype.onFocus = function (evt) {
        this.contextMenuHandler.onFocus(evt);
        this.contextToolboxHandler.onFocus(evt);
        this.visualizersManager.onFocus(evt);
    };
    EventManager.prototype.onKeyDown = function (evt) {
        var scCode = evt.getShortcutCode();
        if (this.onShortcut(scCode)) {
            this.visualizersManager.updateConnectionPoints();
            this.contextMenuHandler.onShortcut(evt);
            this.contextToolboxHandler.onShortcut(evt);
            evt.preventDefault = true;
        }
        else if (this.isShortcutForFocusInput(scCode))
            evt.preventDefault = true;
        this.contextMenuHandler.onKeyDown(evt);
        this.contextToolboxHandler.onKeyDown(evt);
        this.mouseHandler.onKeyDown(evt);
    };
    EventManager.prototype.onKeyUp = function (evt) {
        this.mouseHandler.onKeyUp(evt);
    };
    EventManager.prototype.onTextInputBlur = function (evt) {
        this.textInputHandler.onBlur(evt);
        this.contextMenuHandler.onTextInputBlur(evt);
    };
    EventManager.prototype.onTextInputFocus = function (evt) {
        this.textInputHandler.onFocus(evt);
        this.contextMenuHandler.onTextInputFocus(evt);
    };
    EventManager.prototype.onTextInputKeyDown = function (evt) {
        this.textInputHandler.onKeyDown(evt);
    };
    EventManager.prototype.onShortcut = function (code) {
        if (this.control.commandManager.processShortcut(code))
            return true;
        if (this.mouseHandler.onShortcut(code))
            return true;
    };
    EventManager.prototype.isShortcutForFocusInput = function (code) {
        return code === key_1.KeyCode.Delete || code === (key_1.KeyCode.Delete | key_1.ModifierKey.Ctrl) || code === (key_1.KeyCode.Delete | key_1.ModifierKey.Meta) ||
            (code === key_1.KeyCode.Backspace) || code === (key_1.KeyCode.Backspace | key_1.ModifierKey.Ctrl) || code === (key_1.KeyCode.Backspace | key_1.ModifierKey.Shift) || code === (key_1.KeyCode.Backspace | key_1.ModifierKey.Meta) ||
            code === key_1.KeyCode.Home || code === key_1.KeyCode.End ||
            code === key_1.KeyCode.Up || code === (key_1.KeyCode.Up | key_1.ModifierKey.Ctrl) || code === (key_1.KeyCode.Up | key_1.ModifierKey.Meta) ||
            code === key_1.KeyCode.Down || code === (key_1.KeyCode.Down | key_1.ModifierKey.Ctrl) || code === (key_1.KeyCode.Down | key_1.ModifierKey.Meta) ||
            code === key_1.KeyCode.Left || code === (key_1.KeyCode.Left | key_1.ModifierKey.Ctrl) || code === (key_1.KeyCode.Left | key_1.ModifierKey.Meta) ||
            code === key_1.KeyCode.Right || code === (key_1.KeyCode.Right | key_1.ModifierKey.Ctrl) || code === (key_1.KeyCode.Right | key_1.ModifierKey.Meta);
    };
    EventManager.prototype.onPaste = function (evt) {
        if (!this.textInputHandler.isTextInputActive() && this.control.commandManager.processPaste(evt.clipboardData)) {
            this.visualizersManager.updateConnectionPoints();
            evt.preventDefault = true;
        }
    };
    EventManager.prototype.onMouseWheel = function (evt) {
        if (this.mouseHandler.onWheel(evt))
            evt.preventDefault = true;
    };
    EventManager.prototype.isFocused = function () {
        return this.control.isFocused();
    };
    EventManager.prototype.processDragging = function (evt) {
        var draggingEvt = this.getDraggingEvent();
        if (draggingEvt && this.draggingEvent !== draggingEvt) {
            this.draggingEvent = draggingEvt;
            this.mouseHandler.onDragStart(this.draggingEvent);
            this.control.captureFocus();
        }
        else if (!draggingEvt && this.draggingEvent) {
            delete this.draggingEvent;
            this.mouseHandler.onDragEnd(evt);
        }
    };
    EventManager.prototype.getDraggingEvent = function () {
        return this.toolboxes
            .filter(function (t) { return t.draggingObject; })
            .map(function (t) { return t.draggingObject.evt; })[0];
    };
    EventManager.prototype.onDocumentDragStart = function (itemKeys) {
        this.control.beginUpdate();
        this.control.captureFocus();
        this.onMouseOperation.raise("notifyDragStart", itemKeys);
    };
    EventManager.prototype.onDocumentDragEnd = function (itemKeys) {
        this.onMouseOperation.raise("notifyDragEnd", itemKeys);
        this.control.endUpdate();
        this.control.barManager.updateItemsState();
    };
    EventManager.prototype.onDocumentDragScrollStart = function () {
        this.onMouseOperation.raise1(function (l) { return l.notifyDragScrollStart(); });
    };
    EventManager.prototype.onDocumentDragScrollEnd = function () {
        this.onMouseOperation.raise1(function (l) { return l.notifyDragScrollEnd(); });
    };
    EventManager.prototype.onDocumentClick = function (itemKeys) {
        this.control.beginUpdate();
        this.control.endUpdate();
        this.control.barManager.updateItemsState();
    };
    EventManager.prototype.raiseTextInputStart = function (item, text, position, size) {
        this.onTextInputOperation.raise("notifyTextInputStart", item, text, position, size);
    };
    EventManager.prototype.raiseTextInputEnd = function (item, captureFocus) {
        this.onTextInputOperation.raise("notifyTextInputEnd", item, captureFocus);
    };
    EventManager.prototype.raiseTextInputPermissionsCheck = function (item, allowed) {
        this.onTextInputOperation.raise("notifyTextInputPermissionsCheck", item, allowed);
    };
    EventManager.prototype.canFinishTextEditing = function () {
        return this.textInputHandler.canFinishTextEditing();
    };
    return EventManager;
}());
exports.EventManager = EventManager;


/***/ }),

/***/ 5689:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandler = void 0;
var MouseHandlerDefaultState_1 = __webpack_require__(3250);
var Event_1 = __webpack_require__(6031);
var point_1 = __webpack_require__(8900);
var ModelUtils_1 = __webpack_require__(4867);
var MouseHandlerDefaultReadOnlyTouchState_1 = __webpack_require__(8032);
var MouseHandlerDefaultReadOnlyState_1 = __webpack_require__(7286);
var MouseHandlerDefaultTouchState_1 = __webpack_require__(8502);
var key_1 = __webpack_require__(2153);
var Utils_1 = __webpack_require__(8675);
var MouseHandler = (function () {
    function MouseHandler(history, selection, model, eventManager, readOnly, view, visualizerManager, contextToolboxHandler, shapeDescriptionManager, settings, permissionsProvider) {
        this.history = history;
        this.selection = selection;
        this.model = model;
        this.eventManager = eventManager;
        this.readOnly = readOnly;
        this.view = view;
        this.visualizerManager = visualizerManager;
        this.contextToolboxHandler = contextToolboxHandler;
        this.shapeDescriptionManager = shapeDescriptionManager;
        this.settings = settings;
        this.permissionsProvider = permissionsProvider;
        this.finishStateLock = 0;
        this.initialize(model);
        this.selection.onChanged.add(this);
    }
    MouseHandler.prototype.initialize = function (model) {
        this.model = model;
        this.allowMultipleSelection = true;
        this.allowCopyDiagramItems = true;
        this.allowSnapToCellOnDragDiagramItem = true;
        this.allowSnapToCellOnDragPoint = true;
        this.allowSnapToCellOnResizeShape = true;
        this.allowFixedDrag = true;
        this.allowZoomOnWheel = true;
        this.allowScrollPage = true;
        this.shouldScrollPage = false;
        this.copyDiagramItemsByCtrlAndShift = false;
        this.startScrollingPageByCtrl = false;
        this.initializeDefaultState();
    };
    MouseHandler.prototype.initializeDefaultState = function () {
        this.defaultState = this.readOnly ?
            (Utils_1.EventUtils.isTouchMode() ?
                new MouseHandlerDefaultReadOnlyTouchState_1.MouseHandlerDefaultReadOnlyTouchState(this, this.history, this.selection, this.model, this.view, this.visualizerManager, this.shapeDescriptionManager, this.settings) :
                new MouseHandlerDefaultReadOnlyState_1.MouseHandlerDefaultReadOnlyState(this, this.history, this.selection, this.model, this.view, this.visualizerManager, this.shapeDescriptionManager, this.settings)) :
            (Utils_1.EventUtils.isTouchMode() ?
                new MouseHandlerDefaultTouchState_1.MouseHandlerDefaultTouchState(this, this.history, this.selection, this.model, this.view, this.visualizerManager, this.shapeDescriptionManager, this.settings) :
                new MouseHandlerDefaultState_1.MouseHandlerDefaultState(this, this.history, this.selection, this.model, this.view, this.visualizerManager, this.shapeDescriptionManager, this.settings));
        this.switchToDefaultState();
    };
    MouseHandler.prototype.onMouseDown = function (evt) {
        this.mouseDownEvent = evt;
        this.state.onMouseDown(evt);
    };
    MouseHandler.prototype.onMouseMove = function (evt) {
        this.state.onMouseMove(evt);
    };
    MouseHandler.prototype.onMouseUp = function (evt) {
        this.state.onMouseUp(evt);
    };
    MouseHandler.prototype.onMouseDblClick = function (evt) {
        this.state.onMouseDblClick(evt);
    };
    MouseHandler.prototype.onMouseClick = function (evt) {
        this.state.onMouseClick(evt);
    };
    MouseHandler.prototype.onLongTouch = function (evt) {
        if (!evt.touches || evt.touches.length > 1)
            return;
        var key = evt.source.key;
        if (key === undefined)
            this.selection.clear();
        else if (this.selection.hasKey(key))
            this.selection.remove(key);
        else
            this.selection.add(key);
    };
    MouseHandler.prototype.onShortcut = function (code) {
        return this.state.onShortcut(code);
    };
    MouseHandler.prototype.onWheel = function (evt) {
        return this.state.onMouseWheel(evt);
    };
    MouseHandler.prototype.onDragStart = function (evt) {
        this.state.onDragStart(evt);
    };
    MouseHandler.prototype.onDragEnd = function (evt) {
        this.state.onDragEnd(evt);
    };
    MouseHandler.prototype.onKeyDown = function (evt) {
        this.state.onKeyDown(evt);
    };
    MouseHandler.prototype.onKeyUp = function (evt) {
        this.state.onKeyUp(evt);
    };
    MouseHandler.prototype.showContextToolbox = function (modelPoint, getPositionToInsertShapeTo, side, category, applyCallback, cancelCallback) {
        this.contextToolboxHandler.showContextToolbox(modelPoint, getPositionToInsertShapeTo, side, category, applyCallback, cancelCallback);
    };
    MouseHandler.prototype.hideContextToolbox = function (applyed) {
        this.contextToolboxHandler.hideContextToolbox(applyed);
    };
    MouseHandler.prototype.canScrollPage = function (evt) {
        if (this.startScrollingPageByCtrl) {
            if (!this.hasCtrlModifier(evt.modifiers))
                return false;
            if (!this.copyDiagramItemsByCtrlAndShift)
                return true;
            return !evt.source.isConnector && !evt.source.isShape;
        }
        return this.allowScrollPage && this.shouldScrollPage;
    };
    MouseHandler.prototype.canMultipleSelection = function (evt) {
        return this.allowMultipleSelection && this.hasCtrlOrShiftModifier(evt.modifiers);
    };
    MouseHandler.prototype.canCopySelectedItems = function (evt) {
        if (!this.allowCopyDiagramItems)
            return false;
        return this.copyDiagramItemsByCtrlAndShift ? this.hasCtrlAndShiftModifier(evt.modifiers) : this.hasAltModifier(evt.modifiers);
    };
    MouseHandler.prototype.canCalculateFixedPosition = function (evt) {
        if (!this.allowFixedDrag || !this.hasShiftModifier(evt.modifiers))
            return false;
        if (this.copyDiagramItemsByCtrlAndShift && this.hasCtrlModifier(evt.modifiers))
            return false;
        return true;
    };
    MouseHandler.prototype.canStartZoomOnWheel = function (evt) {
        return this.allowZoomOnWheel && this.hasCtrlModifier(evt.modifiers);
    };
    MouseHandler.prototype.canFinishZoomOnWheel = function (evt) {
        return this.allowZoomOnWheel && !this.hasCtrlModifier(evt.modifiers);
    };
    MouseHandler.prototype.onStartScrollPageByKeyboard = function (evt) {
        if (this.canStartScrollingPageByKeyboard(evt)) {
            this.raiseDragScrollStart();
            this.shouldScrollPage = true;
        }
    };
    MouseHandler.prototype.onFinishScrollPageByKeyboard = function (evt) {
        if (this.canEndScrollingPageByKeyboard(evt))
            this.finishScrollingPage();
    };
    MouseHandler.prototype.onFinishScrollPageByMouse = function (evt) {
        if (this.canEndScrollingPage(evt))
            this.finishScrollingPage();
    };
    MouseHandler.prototype.finishScrollingPage = function () {
        this.shouldScrollPage = false;
        this.raiseDragScrollEnd();
        this.switchToDefaultState();
    };
    MouseHandler.prototype.hasCtrlOrShiftModifier = function (key) {
        return this.hasCtrlModifier(key) || this.hasShiftModifier(key);
    };
    MouseHandler.prototype.hasCtrlAndShiftModifier = function (key) {
        return this.hasCtrlModifier(key) && this.hasShiftModifier(key);
    };
    MouseHandler.prototype.hasCtrlModifier = function (key) {
        return (key & key_1.ModifierKey.Ctrl) > 0;
    };
    MouseHandler.prototype.hasAltModifier = function (key) {
        return (key & key_1.ModifierKey.Alt) > 0;
    };
    MouseHandler.prototype.hasShiftModifier = function (key) {
        return (key & key_1.ModifierKey.Shift) > 0;
    };
    MouseHandler.prototype.canStartScrollingPageByKeyboard = function (evt) {
        return !this.startScrollingPageByCtrl && !this.shouldScrollPage && evt.keyCode === key_1.KeyCode.Space;
    };
    MouseHandler.prototype.canEndScrollingPageByKeyboard = function (evt) {
        return !this.startScrollingPageByCtrl && evt.keyCode === key_1.KeyCode.Space;
    };
    MouseHandler.prototype.canEndScrollingPage = function (evt) {
        return this.startScrollingPageByCtrl ? this.hasCtrlModifier(evt.modifiers) : true;
    };
    MouseHandler.prototype.getSnappedPointOnDragDiagramItem = function (evt, basePoint, fixedX, fixedY, startPoint) {
        var snapToCell = this.getSnapToCellOnDragDiagramItem(evt);
        return new point_1.Point(this.getSnappedPos(this.getFixedXPosition(evt, basePoint, fixedX, startPoint), true, snapToCell), this.getSnappedPos(this.getFixedYPosition(evt, basePoint, fixedY, startPoint), false, snapToCell));
    };
    MouseHandler.prototype.getSnappedPointOnDragPoint = function (evt, point, additionalSnappedPoint) {
        var snapToCell = this.getSnapToCellOnDragPoint(evt);
        var x = this.getSnappedPos(point.x, true, snapToCell);
        var y = this.getSnappedPos(point.y, false, snapToCell);
        if (additionalSnappedPoint === undefined)
            return new point_1.Point(x, y);
        else if (Math.pow(point.x - x, 2) + Math.pow(point.y - y, 2) < Math.pow(point.x - additionalSnappedPoint.x, 2) + Math.pow(point.y - additionalSnappedPoint.y, 2))
            return new point_1.Point(x, y);
        else
            return additionalSnappedPoint;
    };
    MouseHandler.prototype.getSnappedOffsetOnDragPoint = function (evt, startPoint) {
        var snapToCell = this.getSnapToCellOnDragPoint(evt);
        return new point_1.Point(this.getSnappedPos(evt.modelPoint.x - startPoint.x, true, snapToCell), this.getSnappedPos(evt.modelPoint.y - startPoint.y, false, snapToCell));
    };
    MouseHandler.prototype.lockAspectRatioOnShapeResize = function (evt) {
        return this.hasShiftModifier(evt.modifiers);
    };
    MouseHandler.prototype.getSnappedPositionOnResizeShape = function (evt, pos, isHorizontal) {
        if (!this.getSnapToCellOnResizeShape(evt))
            return pos;
        return ModelUtils_1.ModelUtils.getSnappedPos(this.model, this.settings.gridSize, pos, isHorizontal);
    };
    MouseHandler.prototype.getSnappedPos = function (pos, isHorizontal, snapToCell) {
        return snapToCell ? ModelUtils_1.ModelUtils.getSnappedPos(this.model, this.settings.gridSize, pos, isHorizontal) : pos;
    };
    MouseHandler.prototype.getFixedXPosition = function (evt, basePoint, fixedX, startPoint) {
        return fixedX ? basePoint.x : basePoint.x + evt.modelPoint.x - startPoint.x;
    };
    MouseHandler.prototype.getFixedYPosition = function (evt, basePoint, fixedY, startPoint) {
        return fixedY ? basePoint.y : basePoint.y + evt.modelPoint.y - startPoint.y;
    };
    MouseHandler.prototype.getSnapToCellOnDragDiagramItem = function (evt) {
        return this.allowSnapToCellOnDragDiagramItem &&
            this.settings.snapToGrid &&
            !this.hasCtrlModifier(evt.modifiers);
    };
    MouseHandler.prototype.getSnapToCellOnDragPoint = function (evt) {
        return this.allowSnapToCellOnDragPoint &&
            this.settings.snapToGrid &&
            !this.hasCtrlModifier(evt.modifiers);
    };
    MouseHandler.prototype.getSnapToCellOnResizeShape = function (evt) {
        return this.allowSnapToCellOnResizeShape &&
            this.settings.snapToGrid &&
            !this.hasCtrlModifier(evt.modifiers);
    };
    MouseHandler.prototype.tryUpdateModelSize = function (processPoints) {
        this.lockPermissions();
        ModelUtils_1.ModelUtils.tryUpdateModelRectangle(this.history, processPoints);
        this.unlockPermissions();
    };
    MouseHandler.prototype.canAddDiagramItemToSelection = function (evt) {
        return evt.source.key && (evt.button === Event_1.MouseButton.Left || evt.button === Event_1.MouseButton.Right);
    };
    MouseHandler.prototype.addDiagramItemToSelection = function (evt) {
        this.pressedDiagramItemKey = evt.source.key;
        this.pressedDiagramItemInSelection = this.selection.hasKey(this.pressedDiagramItemKey);
        if (this.canMultipleSelection(evt))
            this.selection.add(evt.source.key);
        else
            this.changeSingleSelection(evt.source.key);
    };
    MouseHandler.prototype.canRemoveDiagramItemToSelection = function (evt) {
        return this.pressedDiagramItemKey &&
            evt.source.key &&
            this.pressedDiagramItemKey === evt.source.key &&
            (evt.button === Event_1.MouseButton.Left || evt.button === Event_1.MouseButton.Right);
    };
    MouseHandler.prototype.removeDiagramItemFromSelection = function (button, sourceKey) {
        if (this.pressedDiagramItemInSelection && this.selection.getKeys().length > 1 && button === Event_1.MouseButton.Left)
            this.selection.remove(sourceKey);
    };
    MouseHandler.prototype.changeSingleSelection = function (key) {
        if (!this.selection.hasKey(key))
            this.selection.set([key]);
    };
    MouseHandler.prototype.notifySelectionChanged = function (selection) {
        if (this.pressedDiagramItemKey && !this.selection.hasKey(this.pressedDiagramItemKey)) {
            this.pressedDiagramItemKey = undefined;
            this.pressedDiagramItemInSelection = false;
        }
    };
    MouseHandler.prototype.raiseDragStart = function (keys) {
        this.eventManager.onDocumentDragStart(keys);
    };
    MouseHandler.prototype.raiseDragEnd = function (keys) {
        this.eventManager.onDocumentDragEnd(keys);
    };
    MouseHandler.prototype.raiseDragScrollStart = function () {
        this.eventManager.onDocumentDragScrollStart();
    };
    MouseHandler.prototype.raiseDragScrollEnd = function () {
        this.eventManager.onDocumentDragScrollEnd();
    };
    MouseHandler.prototype.raiseClick = function (keys) {
        this.eventManager.onDocumentClick(keys);
    };
    MouseHandler.prototype.beginStorePermissions = function () {
        this.permissionsProvider.beginStorePermissions();
    };
    MouseHandler.prototype.endStorePermissions = function () {
        this.permissionsProvider.endStorePermissions();
    };
    MouseHandler.prototype.isStoredPermissionsGranted = function () {
        return this.permissionsProvider.isStoredPermissionsGranted();
    };
    MouseHandler.prototype.lockPermissions = function () {
        this.permissionsProvider.lockPermissions();
    };
    MouseHandler.prototype.unlockPermissions = function () {
        this.permissionsProvider.unlockPermissions();
    };
    MouseHandler.prototype.canPerformChangeConnection = function (connector, operationParams) {
        var allowed = true;
        if (connector)
            allowed = this.permissionsProvider.canChangeConnection(connector, operationParams.item, operationParams.oldItem, operationParams.position, operationParams.connectionPointIndex);
        else if (operationParams.item)
            allowed = this.permissionsProvider.canChangeConnection(undefined, operationParams.item, operationParams.oldItem, operationParams.position, operationParams.connectionPointIndex);
        return allowed;
    };
    MouseHandler.prototype.canPerformChangeConnectionOnUpdateUI = function (connector, operationParams) {
        this.permissionsProvider.beginUpdateUI();
        var allowed = this.canPerformChangeConnection(connector, operationParams);
        this.permissionsProvider.endUpdateUI();
        return allowed;
    };
    MouseHandler.prototype.canFinishTextEditing = function () {
        return this.eventManager.canFinishTextEditing();
    };
    MouseHandler.prototype.restartState = function () {
        if (this.state && !this.finishStateLock) {
            this.finishStateLock++;
            this.state.finish();
            this.finishStateLock--;
        }
        this.state.start();
    };
    MouseHandler.prototype.switchToDefaultState = function () {
        this.switchState(this.defaultState);
    };
    MouseHandler.prototype.switchState = function (state) {
        this.newState = state;
        if (this.state && !this.finishStateLock) {
            this.finishStateLock++;
            this.state.finish();
            this.finishStateLock--;
        }
        if (this.newState) {
            this.state = this.newState;
            this.state.start();
            this.newState = undefined;
        }
    };
    MouseHandler.prototype.addInteractingItem = function (item, operation) {
        this.permissionsProvider.addInteractingItem(item, operation);
    };
    MouseHandler.prototype.clearInteractingItems = function () {
        this.permissionsProvider.clearInteractingItems();
    };
    MouseHandler.prototype.notifyReadOnlyChanged = function (readOnly) {
        this.readOnly = readOnly;
        this.initializeDefaultState();
    };
    MouseHandler.prototype.notifySelectionRectShow = function (rect) { };
    MouseHandler.prototype.notifySelectionRectHide = function () { };
    MouseHandler.prototype.notifyResizeInfoShow = function (point, text) { };
    MouseHandler.prototype.notifyResizeInfoHide = function () { };
    MouseHandler.prototype.notifyConnectionPointsShow = function (key, points, activePointIndex, outsideRectangle) {
        this.state.onConnectionPointsShow(key, points);
    };
    MouseHandler.prototype.notifyConnectionPointsHide = function () { };
    MouseHandler.prototype.notifyConnectionTargetShow = function (key, info) {
        this.state.onConnectionTargetShow(key, info);
    };
    MouseHandler.prototype.notifyConnectionTargetHide = function () { };
    MouseHandler.prototype.notifyContainerTargetShow = function (key, info) { };
    MouseHandler.prototype.notifyContainerTargetHide = function () { };
    MouseHandler.prototype.notifyExtensionLinesShow = function (lines) { };
    MouseHandler.prototype.notifyExtensionLinesHide = function () { };
    return MouseHandler;
}());
exports.MouseHandler = MouseHandler;


/***/ }),

/***/ 5627:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerCreateConnectorState = void 0;
var Connector_1 = __webpack_require__(7959);
var AddConnectionHistoryItem_1 = __webpack_require__(3477);
var AddConnectorHistoryItem_1 = __webpack_require__(9603);
var DiagramItem_1 = __webpack_require__(3742);
var MouseHandlerMoveConnectorPointStateBase_1 = __webpack_require__(7060);
var SetSelectionHistoryItem_1 = __webpack_require__(4297);
var AddShapeHistoryItem_1 = __webpack_require__(4145);
var ModelUtils_1 = __webpack_require__(4867);
var DeleteConnectionHistoryItem_1 = __webpack_require__(8930);
var DeleteConnectorHistoryItem_1 = __webpack_require__(9143);
var MouseHandlerCreateConnectorState = (function (_super) {
    __extends(MouseHandlerCreateConnectorState, _super);
    function MouseHandlerCreateConnectorState(handler, history, model, visualizerManager, shapeDescriptionManager, selection, connectionPointIndex) {
        var _this = _super.call(this, handler, history, model, visualizerManager) || this;
        _this.shapeDescriptionManager = shapeDescriptionManager;
        _this.selection = selection;
        _this.connectionPointIndex = connectionPointIndex;
        return _this;
    }
    MouseHandlerCreateConnectorState.prototype.onMouseDown = function (evt) {
        if (this.connectionPointIndex === undefined)
            this.connectionPointIndex = parseInt(evt.source.value);
        this.connectedItem = this.model.findItem(evt.source.key);
        this.pointIndex = 1;
        this.pointPosition = Connector_1.ConnectorPosition.End;
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerCreateConnectorState.prototype.onMouseUp = function (evt) {
        if (this.connector && !this.connector.endItem)
            this.createNewShapeAtConnectorEnd(evt);
        _super.prototype.onMouseUp.call(this, evt);
    };
    MouseHandlerCreateConnectorState.prototype.onApplyChanges = function (evt) {
        var point = this.getSnappedPoint(evt, evt.modelPoint);
        if (!this.connector) {
            var historyItem = new AddConnectorHistoryItem_1.AddConnectorHistoryItem([this.connectedItem.getConnectionPointPosition(this.connectionPointIndex, point), point]);
            this.history.addAndRedo(historyItem);
            this.connector = this.model.findConnector(historyItem.connectorKey);
            this.handler.addInteractingItem(this.connector);
            this.history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(this.connector, this.connectedItem, this.connectionPointIndex, Connector_1.ConnectorPosition.Begin));
            ModelUtils_1.ModelUtils.updateNewConnectorProperties(this.history, this.selection, this.connector.key);
        }
        else
            _super.prototype.onApplyChanges.call(this, evt);
    };
    MouseHandlerCreateConnectorState.prototype.checkStoredPermissionsOnFinish = function () {
        if (this.connector && this.connector.endItem)
            _super.prototype.checkStoredPermissionsOnFinish.call(this);
    };
    MouseHandlerCreateConnectorState.prototype.onFinishWithChanges = function () {
        _super.prototype.onFinishWithChanges.call(this);
        this.history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(this.selection, [this.connector.key]));
    };
    MouseHandlerCreateConnectorState.prototype.createNewShapeAtConnectorEnd = function (evt) {
        var _this = this;
        var beginShape = this.connector && this.connector.beginItem;
        if (!beginShape)
            return;
        if (this.connector && !this.handler.canPerformChangeConnection(this.connector, { position: Connector_1.ConnectorPosition.End, connectionPointIndex: -1 })) {
            this.cancelChanges();
            return;
        }
        var side = this.getNewShapeSide(this.connector);
        var point = this.getSnappedPoint(evt, evt.modelPoint);
        var category = this.shapeDescriptionManager.getCategoryByDescription(beginShape.description);
        var getPositionToInsertShapeTo = function (shape) {
            var clonedShape = shape.clone();
            clonedShape.position = point.clone();
            var position = _this.getNewShapePosition(clonedShape, side);
            return _this.handler.getSnappedPointOnDragPoint(evt, position);
        };
        this.handler.showContextToolbox(point, getPositionToInsertShapeTo, side, category, function (shapeType) {
            if (!shapeType)
                return;
            _this.handler.beginStorePermissions();
            _this.history.beginTransaction();
            var historyItem = new AddShapeHistoryItem_1.AddShapeHistoryItem(_this.shapeDescriptionManager.get(shapeType), point);
            _this.history.addAndRedo(historyItem);
            var shape = _this.model.findShape(historyItem.shapeKey);
            var container = _this.targetItem && _this.model.findNearestContainer(_this.targetItem.key);
            if (container)
                ModelUtils_1.ModelUtils.insertToContainer(_this.history, _this.model, shape, container);
            var newPosition = _this.getNewShapePosition(shape, side);
            ModelUtils_1.ModelUtils.setShapePosition(_this.history, _this.model, shape, _this.getSnappedPoint(evt, newPosition));
            ModelUtils_1.ModelUtils.updateNewShapeProperties(_this.history, _this.selection, shape.key);
            _this.history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(_this.connector, shape, shape.getConnectionPointIndexForSide(side), Connector_1.ConnectorPosition.End));
            if (container)
                ModelUtils_1.ModelUtils.updateConnectorContainer(_this.history, _this.model, _this.connector);
            ModelUtils_1.ModelUtils.updateShapeAttachedConnectors(_this.history, _this.model, shape);
            if (!_this.handler.isStoredPermissionsGranted()) {
                _this.handler.lockPermissions();
                _this.history.undoTransaction();
                _this.handler.unlockPermissions();
                _this.checkNewConnectorPermissions();
            }
            else {
                _this.handler.tryUpdateModelSize();
                _this.history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(_this.selection, [shape.key]));
            }
            _this.history.endTransaction();
            _this.handler.endStorePermissions();
            _this.handler.hideContextToolbox(true);
        }, function () {
            _this.checkNewConnectorPermissions();
        });
    };
    MouseHandlerCreateConnectorState.prototype.checkNewConnectorPermissions = function () {
        if (this.connector && !this.handler.canPerformChangeConnection(this.connector, { position: Connector_1.ConnectorPosition.End, connectionPointIndex: -1 })) {
            this.handler.lockPermissions();
            this.history.beginTransaction();
            this.history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(this.selection, []));
            if (this.connector.beginItem)
                this.history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(this.connector, Connector_1.ConnectorPosition.Begin));
            if (this.connector.endItem)
                this.history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(this.connector, Connector_1.ConnectorPosition.End));
            this.history.addAndRedo(new DeleteConnectorHistoryItem_1.DeleteConnectorHistoryItem(this.connector.key));
            this.history.endTransaction();
            this.handler.unlockPermissions();
        }
    };
    MouseHandlerCreateConnectorState.prototype.getNewShapePosition = function (shape, side) {
        switch (side) {
            case DiagramItem_1.ConnectionPointSide.North:
                return shape.position.clone().offset(-shape.size.width / 2, 0);
            case DiagramItem_1.ConnectionPointSide.South:
                return shape.position.clone().offset(-shape.size.width / 2, -shape.size.height);
            case DiagramItem_1.ConnectionPointSide.East:
                return shape.position.clone().offset(-shape.size.width, -shape.size.height / 2);
            case DiagramItem_1.ConnectionPointSide.West:
                return shape.position.clone().offset(0, -shape.size.height / 2);
        }
    };
    MouseHandlerCreateConnectorState.prototype.getNewShapeSide = function (connector) {
        var renderPoints = connector.getRenderPoints();
        return MouseHandlerCreateConnectorState.getNewShapeSideByConnectorPoints(renderPoints[renderPoints.length - 1], renderPoints[renderPoints.length - 2]);
    };
    MouseHandlerCreateConnectorState.prototype.getSourceItem = function () {
        return this.connectedItem;
    };
    MouseHandlerCreateConnectorState.getNewShapeSideByConnectorPoints = function (point, directionPoint) {
        if (point.x === directionPoint.x)
            if (point.y > directionPoint.y)
                return DiagramItem_1.ConnectionPointSide.North;
            else
                return DiagramItem_1.ConnectionPointSide.South;
        else if (point.x > directionPoint.x)
            if (point.y === directionPoint.y)
                return DiagramItem_1.ConnectionPointSide.West;
            else if (point.y > directionPoint.y)
                if (Math.abs(point.x - directionPoint.x) > Math.abs(point.y - directionPoint.y))
                    return DiagramItem_1.ConnectionPointSide.West;
                else
                    return DiagramItem_1.ConnectionPointSide.North;
            else if (Math.abs(point.x - directionPoint.x) > Math.abs(point.y - directionPoint.y))
                return DiagramItem_1.ConnectionPointSide.West;
            else
                return DiagramItem_1.ConnectionPointSide.South;
        else if (point.y === directionPoint.y)
            return DiagramItem_1.ConnectionPointSide.East;
        else if (point.y > directionPoint.y)
            if (Math.abs(point.x - directionPoint.x) > Math.abs(point.y - directionPoint.y))
                return DiagramItem_1.ConnectionPointSide.East;
            else
                return DiagramItem_1.ConnectionPointSide.North;
        else if (Math.abs(point.x - directionPoint.x) > Math.abs(point.y - directionPoint.y))
            return DiagramItem_1.ConnectionPointSide.East;
        else
            return DiagramItem_1.ConnectionPointSide.South;
    };
    return MouseHandlerCreateConnectorState;
}(MouseHandlerMoveConnectorPointStateBase_1.MouseHandlerMoveConnectorPointStateBase));
exports.MouseHandlerCreateConnectorState = MouseHandlerCreateConnectorState;


/***/ }),

/***/ 7286:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerDefaultReadOnlyState = void 0;
var MouseHandlerDefaultStateBase_1 = __webpack_require__(8213);
var MouseHandlerDefaultReadOnlyState = (function (_super) {
    __extends(MouseHandlerDefaultReadOnlyState, _super);
    function MouseHandlerDefaultReadOnlyState() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MouseHandlerDefaultReadOnlyState.prototype.canDragObjectOnMouseDown = function (key) {
        return false;
    };
    MouseHandlerDefaultReadOnlyState.prototype.canExpandContainerOnMouseDown = function (key) {
        return false;
    };
    MouseHandlerDefaultReadOnlyState.prototype.canClearSelectionOnMouseDown = function () {
        return false;
    };
    MouseHandlerDefaultReadOnlyState.prototype.canSelectOnMouseUp = function (key) {
        return true;
    };
    MouseHandlerDefaultReadOnlyState.prototype.canClearSelectionOnMouseUp = function () {
        return true;
    };
    MouseHandlerDefaultReadOnlyState.prototype.updateConnectionsOnMouseMove = function (evt) {
    };
    return MouseHandlerDefaultReadOnlyState;
}(MouseHandlerDefaultStateBase_1.MouseHandlerDefaultStateBase));
exports.MouseHandlerDefaultReadOnlyState = MouseHandlerDefaultReadOnlyState;


/***/ }),

/***/ 8032:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerDefaultReadOnlyTouchState = void 0;
var MouseHandlerDefaultReadOnlyState_1 = __webpack_require__(7286);
var MouseHandlerDefaultReadOnlyTouchState = (function (_super) {
    __extends(MouseHandlerDefaultReadOnlyTouchState, _super);
    function MouseHandlerDefaultReadOnlyTouchState() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MouseHandlerDefaultReadOnlyTouchState.prototype.canDragObjectOnMouseDown = function (key) {
        return false;
    };
    MouseHandlerDefaultReadOnlyTouchState.prototype.canExpandContainerOnMouseDown = function (key) {
        return false;
    };
    MouseHandlerDefaultReadOnlyTouchState.prototype.canClearSelectionOnMouseDown = function () {
        return true;
    };
    MouseHandlerDefaultReadOnlyTouchState.prototype.canSelectOnMouseUp = function (key) {
        return !this.inSelection(key);
    };
    MouseHandlerDefaultReadOnlyTouchState.prototype.canClearSelectionOnMouseUp = function () {
        return false;
    };
    return MouseHandlerDefaultReadOnlyTouchState;
}(MouseHandlerDefaultReadOnlyState_1.MouseHandlerDefaultReadOnlyState));
exports.MouseHandlerDefaultReadOnlyTouchState = MouseHandlerDefaultReadOnlyTouchState;


/***/ }),

/***/ 3250:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerDefaultState = void 0;
var Event_1 = __webpack_require__(6031);
var MouseHandlerMoveConnectorPointState_1 = __webpack_require__(4402);
var MouseHandlerResizeShapeState_1 = __webpack_require__(5609);
var MouseHandlerMoveConnectorSideState_1 = __webpack_require__(481);
var MouseHandlerDragParameterPointState_1 = __webpack_require__(4908);
var MouseHandlerCreateConnectorState_1 = __webpack_require__(5627);
var MouseHandlerMoveConnectorOrthogonalSideState_1 = __webpack_require__(5209);
var MouseHandlerToolboxDraggingState_1 = __webpack_require__(6918);
var MouseHandlerMoveConnectorTextState_1 = __webpack_require__(5391);
var MouseHandlerDefaultStateBase_1 = __webpack_require__(8213);
var MouseHandlerMoveShapeState_1 = __webpack_require__(9979);
var Connector_1 = __webpack_require__(7959);
var MouseHandlerMoveConnectorState_1 = __webpack_require__(5168);
var MouseHandlerDefaultState = (function (_super) {
    __extends(MouseHandlerDefaultState, _super);
    function MouseHandlerDefaultState() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MouseHandlerDefaultState.prototype.finish = function () {
        this.visualizerManager.resetConnectionPoints();
        _super.prototype.finish.call(this);
    };
    MouseHandlerDefaultState.prototype.onMouseDownCore = function (evt) {
        if (this.handler.canScrollPage(evt))
            this.startScrolling(evt);
        else if (evt.button === Event_1.MouseButton.Left && evt.source.type === Event_1.MouseEventElementType.ConnectorText) {
            this.handler.changeSingleSelection(evt.source.key);
            this.handler.switchState(new MouseHandlerMoveConnectorTextState_1.MouseHandlerMoveConnectorTextState(this.handler, this.history, this.model));
        }
        else if (evt.button === Event_1.MouseButton.Left && evt.source.type === Event_1.MouseEventElementType.ShapeResizeBox)
            this.handler.switchState(new MouseHandlerResizeShapeState_1.MouseHandlerResizeShapeState(this.handler, this.history, this.model, this.selection, this.visualizerManager, this.settings));
        else if (evt.button === Event_1.MouseButton.Left && evt.source.type === Event_1.MouseEventElementType.ShapeParameterBox)
            this.handler.switchState(new MouseHandlerDragParameterPointState_1.MouseHandlerDragParameterPointState(this.handler, this.history, this.model));
        else if (evt.button === Event_1.MouseButton.Left && evt.source.type === Event_1.MouseEventElementType.ConnectorPoint)
            this.handler.switchState(new MouseHandlerMoveConnectorPointState_1.MouseHandlerMoveConnectorPointState(this.handler, this.history, this.model, this.visualizerManager));
        else if (evt.button === Event_1.MouseButton.Left && evt.source.type === Event_1.MouseEventElementType.ConnectorSide)
            this.handler.switchState(new MouseHandlerMoveConnectorSideState_1.MouseHandlerMoveConnectorSideState(this.handler, this.history, this.model));
        else if (evt.button === Event_1.MouseButton.Left && evt.source.type === Event_1.MouseEventElementType.ConnectorOrthogonalSide)
            this.handler.switchState(new MouseHandlerMoveConnectorOrthogonalSideState_1.MouseHandlerMoveConnectorOrthogonalSideState(this.handler, this.history, this.model));
        else if (evt.button === Event_1.MouseButton.Left && evt.source.type === Event_1.MouseEventElementType.ShapeConnectionPoint)
            this.handler.switchState(new MouseHandlerCreateConnectorState_1.MouseHandlerCreateConnectorState(this.handler, this.history, this.model, this.visualizerManager, this.shapeDescriptionManager, this.selection));
        else
            _super.prototype.onMouseDownCore.call(this, evt);
    };
    MouseHandlerDefaultState.prototype.onDragDiagramItemOnMouseDown = function (evt) {
        if (!this.handler.canAddDiagramItemToSelection(evt))
            _super.prototype.onDragDiagramItemOnMouseDown.call(this, evt);
        else if (evt.source.isShape)
            this.handler.switchState(new MouseHandlerMoveShapeState_1.MouseHandlerMoveShapeState(this.handler, this.history, this.model, this.selection, this.visualizerManager));
        else if (evt.source.isConnector)
            this.handler.switchState(new MouseHandlerMoveConnectorState_1.MouseHandlerMoveConnectorState(this.handler, this.history, this.model, this.selection, this.visualizerManager));
    };
    MouseHandlerDefaultState.prototype.onDragStart = function (evt) {
        this.handler.switchState(new MouseHandlerToolboxDraggingState_1.MouseHandlerBeforeToolboxDraggingState(this.handler, this.history, this.model, this.selection, this.visualizerManager, this.shapeDescriptionManager));
        this.handler.state.onDragStart(evt);
    };
    MouseHandlerDefaultState.prototype.onMouseMoveCore = function (evt) {
        this.updateConnectionsOnMouseMove(evt);
        _super.prototype.onMouseMoveCore.call(this, evt);
    };
    MouseHandlerDefaultState.prototype.onMouseUp = function (evt) {
        if (this.handler.canRemoveDiagramItemToSelection(evt))
            this.handler.removeDiagramItemFromSelection(evt.button, evt.source.key);
        else
            _super.prototype.onMouseUp.call(this, evt);
    };
    MouseHandlerDefaultState.prototype.updateConnectionsOnMouseMove = function (evt) {
        var item = this.model.findItem(evt.source.key);
        this.visualizerManager.updateConnections(item, evt.source.type, evt.source.value);
    };
    MouseHandlerDefaultState.prototype.canDragObjectOnMouseDown = function (key) {
        return true;
    };
    MouseHandlerDefaultState.prototype.canExpandContainerOnMouseDown = function (key) {
        return true;
    };
    MouseHandlerDefaultState.prototype.canClearSelectionOnMouseDown = function () {
        return false;
    };
    MouseHandlerDefaultState.prototype.canSelectOnMouseUp = function (key) {
        return false;
    };
    MouseHandlerDefaultState.prototype.canClearSelectionOnMouseUp = function () {
        return true;
    };
    MouseHandlerDefaultState.prototype.onConnectionPointsShow = function (key, points) {
        var _this = this;
        var shape = this.model.findShape(key);
        if (shape)
            points.forEach(function (point, index) {
                point.allowed = _this.handler.canPerformChangeConnectionOnUpdateUI(undefined, { item: shape, position: Connector_1.ConnectorPosition.Begin, connectionPointIndex: index });
            });
    };
    return MouseHandlerDefaultState;
}(MouseHandlerDefaultStateBase_1.MouseHandlerDefaultStateBase));
exports.MouseHandlerDefaultState = MouseHandlerDefaultState;


/***/ }),

/***/ 8213:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerDefaultStateBase = void 0;
var MouseHandlerStateBase_1 = __webpack_require__(5434);
var Event_1 = __webpack_require__(6031);
var MouseHandlerToggleShapeExpandedState_1 = __webpack_require__(5752);
var MouseHandlerSelectionState_1 = __webpack_require__(4869);
var MouseHandlerZoomOnWheelState_1 = __webpack_require__(7189);
var MouseHandlerScrollingState_1 = __webpack_require__(9582);
var unit_converter_1 = __webpack_require__(9291);
var MouseHandlerZoomOnPinchState_1 = __webpack_require__(8461);
var MouseHandlerDefaultStateBase = (function (_super) {
    __extends(MouseHandlerDefaultStateBase, _super);
    function MouseHandlerDefaultStateBase(handler, history, selection, model, view, visualizerManager, shapeDescriptionManager, settings) {
        var _this = _super.call(this, handler) || this;
        _this.history = history;
        _this.selection = selection;
        _this.model = model;
        _this.view = view;
        _this.visualizerManager = visualizerManager;
        _this.shapeDescriptionManager = shapeDescriptionManager;
        _this.settings = settings;
        return _this;
    }
    MouseHandlerDefaultStateBase.prototype.onKeyDown = function (evt) {
        this.handler.onStartScrollPageByKeyboard(evt);
    };
    MouseHandlerDefaultStateBase.prototype.onKeyUp = function (evt) {
        this.handler.onFinishScrollPageByKeyboard(evt);
    };
    MouseHandlerDefaultStateBase.prototype.onMouseDown = function (evt) {
        if (!this.handler.canFinishTextEditing())
            return;
        this.onMouseDownCore(evt);
        if (this.handler.state !== this)
            this.handler.state.onMouseDown(evt);
    };
    MouseHandlerDefaultStateBase.prototype.onMouseDownCore = function (evt) {
        if (this.handler.canScrollPage(evt))
            this.startScrolling(evt);
        else if (this.hasDiagramItem(evt) && this.canDragObjectOnMouseDown(evt.source.key))
            this.onDragDiagramItemOnMouseDown(evt);
        else if (evt.button === Event_1.MouseButton.Left && evt.source.type === Event_1.MouseEventElementType.ShapeExpandButton && this.canExpandContainerOnMouseDown(evt.source.key))
            this.onShapeExpandBtnMouseDown(evt);
        else {
            if (!this.hasDiagramItem(evt) && this.canClearSelectionOnMouseDown())
                this.clearSelection();
            this.startPoint = evt.modelPoint;
        }
    };
    MouseHandlerDefaultStateBase.prototype.onDragDiagramItemOnMouseDown = function (evt) {
        this.replaceSelection(evt);
    };
    MouseHandlerDefaultStateBase.prototype.onMouseMove = function (evt) {
        this.onMouseMoveCore(evt);
        if (this.handler.state !== this) {
            this.handler.state.onMouseDown(this.handler.mouseDownEvent);
            this.handler.state.onMouseMove(evt);
        }
    };
    MouseHandlerDefaultStateBase.prototype.onMouseMoveCore = function (evt) {
        if (this.startPoint &&
            (Math.abs(this.startPoint.x - evt.modelPoint.x) > MouseHandlerDefaultStateBase.startLimit ||
                Math.abs(this.startPoint.y - evt.modelPoint.y) > MouseHandlerDefaultStateBase.startLimit)) {
            this.processOnMouseMoveAfterLimit(evt);
            this.startPoint = undefined;
        }
    };
    MouseHandlerDefaultStateBase.prototype.processOnMouseMoveAfterLimit = function (evt) {
        if (evt.isTouchMode)
            if (evt.touches.length > 1)
                this.startZooming(evt);
            else
                this.startScrolling(evt);
        else
            this.startSelection(evt);
    };
    MouseHandlerDefaultStateBase.prototype.onMouseUp = function (evt) {
        this.onMouseUpCore(evt);
        if (this.handler.state !== this)
            this.handler.state.onMouseUp(evt);
    };
    MouseHandlerDefaultStateBase.prototype.onMouseUpCore = function (evt) {
        if (evt.source.type === Event_1.MouseEventElementType.Shape && this.canSelectOnMouseUp(evt.source.key))
            this.replaceSelection(evt);
        else if (evt.source.type === Event_1.MouseEventElementType.Connector && this.canSelectOnMouseUp(evt.source.key))
            this.replaceSelection(evt);
        else if (evt.source.type === Event_1.MouseEventElementType.ShapeExpandButton && this.canSelectOnMouseUp(evt.source.key))
            this.replaceSelection(evt);
        else if (this.startPoint && this.canClearSelectionOnMouseUp())
            this.clearSelection();
        this.startPoint = undefined;
    };
    MouseHandlerDefaultStateBase.prototype.onMouseWheel = function (evt) {
        if (this.handler.canStartZoomOnWheel(evt)) {
            this.handler.switchState(new MouseHandlerZoomOnWheelState_1.MouseHandlerZoomOnWheelState(this.handler, this.settings, this.view));
            this.handler.state.onMouseWheel(evt);
            return true;
        }
        return false;
    };
    MouseHandlerDefaultStateBase.prototype.onLongTouch = function (evt) {
        this.replaceMultipleSelection(evt.source.key);
    };
    MouseHandlerDefaultStateBase.prototype.finish = function () {
        this.startPoint = undefined;
    };
    MouseHandlerDefaultStateBase.prototype.startSelection = function (evt) {
        if (evt.button === Event_1.MouseButton.Left)
            this.handler.switchState(new MouseHandlerSelectionState_1.MouseHandlerSelectionState(this.handler, this.selection, this.visualizerManager));
    };
    MouseHandlerDefaultStateBase.prototype.startScrolling = function (evt) {
        if (evt.button === Event_1.MouseButton.Left) {
            this.handler.raiseDragScrollStart();
            this.handler.switchState(new MouseHandlerScrollingState_1.MouseHandlerScrollingState(this.handler, this.view, this.selection));
        }
    };
    MouseHandlerDefaultStateBase.prototype.startZooming = function (evt) {
        this.handler.switchState(new MouseHandlerZoomOnPinchState_1.MouseHandlerZoomOnPinchState(this.handler, this.selection, this.settings, this.view));
    };
    MouseHandlerDefaultStateBase.prototype.inSelection = function (key) {
        return this.selection.hasKey(key);
    };
    MouseHandlerDefaultStateBase.prototype.hasDiagramItem = function (evt) {
        return evt.source.isShape || evt.source.isConnector;
    };
    MouseHandlerDefaultStateBase.prototype.onShapeExpandBtnMouseDown = function (evt) {
        this.handler.addDiagramItemToSelection(evt);
        this.handler.switchState(new MouseHandlerToggleShapeExpandedState_1.MouseHandlerToggleShapeExpandedState(this.handler, this.history, this.model, this.selection));
    };
    MouseHandlerDefaultStateBase.prototype.replaceSelection = function (evt) {
        if (this.handler.canMultipleSelection(evt))
            this.replaceMultipleSelection(evt.source.key);
        else
            this.handler.changeSingleSelection(evt.source.key);
    };
    MouseHandlerDefaultStateBase.prototype.replaceMultipleSelection = function (key) {
        if (this.selection.hasKey(key))
            this.selection.remove(key);
        else
            this.selection.add(key);
    };
    MouseHandlerDefaultStateBase.prototype.clearSelection = function () {
        this.selection.set([]);
    };
    MouseHandlerDefaultStateBase.startLimit = unit_converter_1.UnitConverter.pixelsToTwips(1);
    return MouseHandlerDefaultStateBase;
}(MouseHandlerStateBase_1.MouseHandlerStateBase));
exports.MouseHandlerDefaultStateBase = MouseHandlerDefaultStateBase;


/***/ }),

/***/ 8502:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerDefaultTouchState = void 0;
var MouseHandlerDefaultState_1 = __webpack_require__(3250);
var MouseHandlerDefaultTouchState = (function (_super) {
    __extends(MouseHandlerDefaultTouchState, _super);
    function MouseHandlerDefaultTouchState() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MouseHandlerDefaultTouchState.prototype.updateConnectionsOnMouseMove = function (evt) {
    };
    MouseHandlerDefaultTouchState.prototype.canDragObjectOnMouseDown = function (key) {
        return this.inSelection(key);
    };
    MouseHandlerDefaultTouchState.prototype.canExpandContainerOnMouseDown = function (key) {
        return true;
    };
    MouseHandlerDefaultTouchState.prototype.canClearSelectionOnMouseDown = function () {
        return true;
    };
    MouseHandlerDefaultTouchState.prototype.canSelectOnMouseUp = function (key) {
        return !this.inSelection(key);
    };
    MouseHandlerDefaultTouchState.prototype.canClearSelectionOnMouseUp = function () {
        return false;
    };
    return MouseHandlerDefaultTouchState;
}(MouseHandlerDefaultState_1.MouseHandlerDefaultState));
exports.MouseHandlerDefaultTouchState = MouseHandlerDefaultTouchState;


/***/ }),

/***/ 1717:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerDragDiagramItemStateBase = exports.DraggingConnector = void 0;
var ModelUtils_1 = __webpack_require__(4867);
var ModelOperationSettings_1 = __webpack_require__(6879);
var Event_1 = __webpack_require__(6031);
var MouseHandlerDraggingState_1 = __webpack_require__(8816);
var DragHelper_1 = __webpack_require__(4742);
var DraggingConnector = (function () {
    function DraggingConnector(connector) {
        this.connector = connector;
        this.startPoints = connector.points.map(function (x) { return x.clone(); });
        this.startRenderContext = connector.tryCreateRenderPointsContext();
    }
    return DraggingConnector;
}());
exports.DraggingConnector = DraggingConnector;
var MouseHandlerDragDiagramItemStateBase = (function (_super) {
    __extends(MouseHandlerDragDiagramItemStateBase, _super);
    function MouseHandlerDragDiagramItemStateBase(handler, history, model, selection, visualizerManager) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        _this.selection = selection;
        _this.visualizerManager = visualizerManager;
        _this.startScrollLeft = 0;
        _this.startScrollTop = 0;
        return _this;
    }
    MouseHandlerDragDiagramItemStateBase.prototype.finish = function () {
        var _a;
        (_a = this.dragHelper) === null || _a === void 0 ? void 0 : _a.finish();
        this.visualizerManager.resetExtensionLines();
        this.visualizerManager.resetContainerTarget();
        this.visualizerManager.resetConnectionTarget();
        this.visualizerManager.resetConnectionPoints();
        _super.prototype.finish.call(this);
    };
    MouseHandlerDragDiagramItemStateBase.prototype.onMouseDown = function (evt) {
        this.handler.addDiagramItemToSelection(evt);
        this.shouldClone = this.handler.canCopySelectedItems(evt);
        this.startPoint = evt.modelPoint;
        this.initDrag();
        this.lockInitDrag = false;
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerDragDiagramItemStateBase.prototype.onMouseMove = function (evt) {
        this.mouseMoveEvent = evt;
        if (evt.button !== Event_1.MouseButton.Left) {
            this.cancelChanges();
            this.handler.switchToDefaultState();
            return;
        }
        if (!this.canApplyChangesOnMouseMove(this.startPoint, evt.modelPoint))
            return;
        if (this.handler.canCopySelectedItems(evt))
            if (!this.lockInitDrag) {
                this.cancelChanges();
                this.shouldClone = true;
                this.copySelection();
                this.initDrag();
                this.lockInitDrag = true;
            }
        this.onApplyChanges(evt);
        this.onAfterApplyChanges();
        this.updateContainers(evt);
    };
    MouseHandlerDragDiagramItemStateBase.prototype.updateContainers = function (evt) {
        this.visualizerManager.setExtensionLines(this.selection.getSelectedShapes(false, true));
        var container = ModelUtils_1.ModelUtils.findContainerByEventKey(this.model, this.selection, evt.source.key);
        if (container && this.allowInsertToContainer(evt, container))
            this.visualizerManager.setContainerTarget(container, evt.source.type);
        else
            this.visualizerManager.resetContainerTarget();
    };
    MouseHandlerDragDiagramItemStateBase.prototype.onMouseUp = function (evt) {
        _super.prototype.onMouseUp.call(this, evt);
        if (this.handler.canRemoveDiagramItemToSelection(evt) && this.handler.canMultipleSelection(evt))
            this.handler.removeDiagramItemFromSelection(evt.button, evt.source.key);
    };
    MouseHandlerDragDiagramItemStateBase.prototype.onApplyChanges = function (evt) {
        var _this = this;
        this.calculateFixedPosition(evt);
        this.dragHelper.move(this.shouldClone, function (pt) { return _this.getSnappedPoint(evt, pt); }, function () {
            _this.visualizerManager.resetConnectionTarget();
            _this.visualizerManager.resetConnectionPoints();
        }, function (shape, connectionPointIndex) {
            _this.visualizerManager.setConnectionTarget(shape, Event_1.MouseEventElementType.Shape);
            _this.visualizerManager.setConnectionPoints(shape, Event_1.MouseEventElementType.Shape, connectionPointIndex, true);
        });
        var container = ModelUtils_1.ModelUtils.findContainerByEventKey(this.model, this.selection, evt.source.key);
        if (container && this.allowInsertToContainer(evt, container))
            ModelUtils_1.ModelUtils.insertSelectionToContainer(this.history, this.model, this.selection, container);
        else
            ModelUtils_1.ModelUtils.removeSelectionFromContainer(this.history, this.model, this.selection);
        this.handler.tryUpdateModelSize(function (offsetLeft, offsetTop) { return _this.dragHelper.onTryUpdateModelSize(offsetLeft, offsetTop); });
    };
    MouseHandlerDragDiagramItemStateBase.prototype.getDraggingElementKeys = function () {
        return this.dragHelper.draggingShapes.map(function (x) { return x.shape.key; }).concat(this.dragHelper.draggingConnectors.map(function (x) { return x.connector.key; }));
    };
    MouseHandlerDragDiagramItemStateBase.prototype.getSnappedPoint = function (evt, point) {
        return this.handler.getSnappedPointOnDragDiagramItem(evt, point, this.fixedX, this.fixedY, this.startPoint);
    };
    MouseHandlerDragDiagramItemStateBase.prototype.initDrag = function () {
        this.dragHelper = new DragHelper_1.SelectionDragHelper(this.history, this.model, this.handler.permissionsProvider, this.startPoint, this.selection.getSelectedItems(true));
        this.initDraggingShapes();
        if (!this.areValidDraggingShapes) {
            this.handler.switchToDefaultState();
            return;
        }
        this.initDraggingConnectors();
        if (!this.areValidDraggingConnectors) {
            this.handler.switchToDefaultState();
            return;
        }
    };
    MouseHandlerDragDiagramItemStateBase.prototype.initDraggingShapes = function () {
        this.dragHelper.initDraggingShapes(this.selection.getSelectedShapes(false, true), this.shouldClone);
    };
    MouseHandlerDragDiagramItemStateBase.prototype.initDraggingConnectors = function () {
        this.dragHelper.initDraggingConnectors(this.selection.getSelectedConnectors(false, true), this.shouldClone);
    };
    MouseHandlerDragDiagramItemStateBase.prototype.copySelection = function () {
        var _this = this;
        ModelUtils_1.ModelUtils.cloneSelectionToOffset(this.history, this.model, function (key) {
            var item = _this.model.findItem(key);
            if (item)
                _this.handler.addInteractingItem(item, ModelOperationSettings_1.DiagramModelOperation.AddShape);
        }, this.selection, 0, 0);
    };
    MouseHandlerDragDiagramItemStateBase.prototype.calculateFixedPosition = function (evt) {
        this.fixedX = false;
        this.fixedY = false;
        if (this.handler.canCalculateFixedPosition(evt)) {
            var dx = Math.abs(this.startPoint.x - evt.modelPoint.x);
            var dy = Math.abs(this.startPoint.y - evt.modelPoint.y);
            if (dx < dy)
                this.fixedX = true;
            else
                this.fixedY = true;
        }
    };
    MouseHandlerDragDiagramItemStateBase.prototype.allowInsertToContainer = function (evt, container) {
        if (this.handler.canMultipleSelection(evt))
            return false;
        return container && container.expanded && ModelUtils_1.ModelUtils.canInsertSelectionToContainer(this.model, this.selection, container);
    };
    return MouseHandlerDragDiagramItemStateBase;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerDragDiagramItemStateBase = MouseHandlerDragDiagramItemStateBase;


/***/ }),

/***/ 4908:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerDragParameterPointState = void 0;
var MouseHandlerDraggingState_1 = __webpack_require__(8816);
var ChangeShapeParametersHistoryItem_1 = __webpack_require__(329);
var MouseHandlerDragParameterPointState = (function (_super) {
    __extends(MouseHandlerDragParameterPointState, _super);
    function MouseHandlerDragParameterPointState(handler, history, model) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        _this.startScrollLeft = 0;
        _this.startScrollTop = 0;
        return _this;
    }
    MouseHandlerDragParameterPointState.prototype.onMouseDown = function (evt) {
        this.startPoint = evt.modelPoint;
        this.shape = this.model.findShape(evt.source.key);
        this.parameterPointKey = evt.source.value;
        this.startParameters = this.shape.parameters.clone();
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerDragParameterPointState.prototype.onApplyChanges = function (evt) {
        var offset = this.handler.getSnappedOffsetOnDragPoint(evt, this.startPoint);
        var parameters = this.startParameters.clone();
        this.shape.description.modifyParameters(this.shape, parameters, offset.x, offset.y);
        this.history.addAndRedo(new ChangeShapeParametersHistoryItem_1.ChangeShapeParametersHistoryItem(this.shape.key, parameters));
    };
    MouseHandlerDragParameterPointState.prototype.getDraggingElementKeys = function () {
        return [this.shape.key];
    };
    return MouseHandlerDragParameterPointState;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerDragParameterPointState = MouseHandlerDragParameterPointState;


/***/ }),

/***/ 8816:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerDraggingState = void 0;
var MouseHandlerStateBase_1 = __webpack_require__(5434);
var Event_1 = __webpack_require__(6031);
var unit_converter_1 = __webpack_require__(9291);
var MouseHandlerDraggingState = (function (_super) {
    __extends(MouseHandlerDraggingState, _super);
    function MouseHandlerDraggingState(handler, history) {
        var _this = _super.call(this, handler) || this;
        _this.history = history;
        return _this;
    }
    MouseHandlerDraggingState.prototype.canApplyChangesOnMouseMove = function (initPosition, position) {
        return !initPosition || !position ||
            Math.abs(initPosition.x - position.x) > MouseHandlerDraggingState.dragStartLimit ||
            Math.abs(initPosition.y - position.y) > MouseHandlerDraggingState.dragStartLimit;
    };
    MouseHandlerDraggingState.prototype.onAfterApplyChanges = function () {
        if (!this.modified)
            this.handler.raiseDragStart(this.getDraggingElementKeys());
        this.modified = true;
        this.mouseDownPoint = undefined;
    };
    MouseHandlerDraggingState.prototype.onMouseDown = function (evt) {
        this.mouseDownPoint = evt.modelPoint.clone();
    };
    MouseHandlerDraggingState.prototype.onMouseMove = function (evt) {
        this.mouseMoveEvent = evt;
        if (evt.button !== Event_1.MouseButton.Left) {
            this.cancelChanges();
            this.handler.switchToDefaultState();
        }
        else if (evt.button === Event_1.MouseButton.Left && this.canApplyChangesOnMouseMove(this.mouseDownPoint, evt.modelPoint)) {
            this.onApplyChanges(evt);
            this.onAfterApplyChanges();
        }
    };
    MouseHandlerDraggingState.prototype.onKeyDown = function (evt) {
        if (this.mouseMoveEvent && (evt.keyCode === 16 || evt.keyCode === 17 || evt.keyCode === 18))
            this.performMouseMoveEvent(evt.modifiers);
    };
    MouseHandlerDraggingState.prototype.onKeyUp = function (evt) {
        if (this.mouseMoveEvent && (evt.keyCode === 16 || evt.keyCode === 17 || evt.keyCode === 18))
            this.performMouseMoveEvent(evt.modifiers);
    };
    MouseHandlerDraggingState.prototype.onMouseUp = function (evt) {
        this.mouseDownPoint = undefined;
        this.mouseMoveEvent = undefined;
        this.handler.switchToDefaultState();
    };
    MouseHandlerDraggingState.prototype.performMouseMoveEvent = function (modifiers) {
        this.mouseMoveEvent.modifiers = modifiers;
        this.onMouseMove(this.mouseMoveEvent);
    };
    MouseHandlerDraggingState.prototype.start = function () {
        this.handler.beginStorePermissions();
        this.history.beginTransaction();
    };
    MouseHandlerDraggingState.prototype.finish = function () {
        this.checkStoredPermissionsOnFinish();
        if (this.modified) {
            this.onFinishWithChanges();
            this.modified = false;
            this.history.endTransaction();
            this.handler.raiseDragEnd(this.getDraggingElementKeys());
        }
        else
            this.history.endTransaction();
        this.handler.endStorePermissions();
        this.handler.clearInteractingItems();
    };
    MouseHandlerDraggingState.prototype.checkStoredPermissionsOnFinish = function () {
        if (!this.handler.isStoredPermissionsGranted()) {
            this.cancelChanges();
            this.modified = false;
        }
    };
    MouseHandlerDraggingState.prototype.onFinishWithChanges = function () { };
    MouseHandlerDraggingState.prototype.cancelChanges = function () {
        this.handler.lockPermissions();
        this.history.undoTransaction();
        this.handler.unlockPermissions();
        if (this.modified)
            this.handler.raiseDragEnd(this.getDraggingElementKeys());
        this.modified = false;
    };
    MouseHandlerDraggingState.prototype.getSnappedPoint = function (evt, point) {
        return this.handler.getSnappedPointOnDragPoint(evt, point);
    };
    MouseHandlerDraggingState.dragStartLimit = unit_converter_1.UnitConverter.pixelsToTwips(4);
    return MouseHandlerDraggingState;
}(MouseHandlerStateBase_1.MouseHandlerCancellableState));
exports.MouseHandlerDraggingState = MouseHandlerDraggingState;


/***/ }),

/***/ 5209:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerMoveConnectorOrthogonalSideState = void 0;
var point_1 = __webpack_require__(8900);
var Connector_1 = __webpack_require__(7959);
var DiagramItem_1 = __webpack_require__(3742);
var ModelUtils_1 = __webpack_require__(4867);
var MouseHandlerDraggingState_1 = __webpack_require__(8816);
var Utils_1 = __webpack_require__(8675);
var MouseHandlerMoveConnectorOrthogonalSideState = (function (_super) {
    __extends(MouseHandlerMoveConnectorOrthogonalSideState, _super);
    function MouseHandlerMoveConnectorOrthogonalSideState(handler, history, model) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        _this.canCreatePoints = true;
        return _this;
    }
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.saveSidePoints = function (markLeftRenderPointIndex, markRightRenderPointIndex) {
        var _this = this;
        var renderPoints = this.connector.getRenderPoints(true);
        this.isHorizontal = renderPoints[markLeftRenderPointIndex].y === renderPoints[markRightRenderPointIndex].y;
        this.iterateRenderPoints(renderPoints, markLeftRenderPointIndex, false, function (pt, i) {
            if (pt.pointIndex !== -1)
                _this.leftPointIndex = pt.pointIndex;
            _this.leftRenderPointIndex = i;
        }, function (pt) { return !Utils_1.GeometryUtils.arePointsOfOrthogonalLine(renderPoints[markLeftRenderPointIndex], pt, _this.isHorizontal); });
        this.iterateRenderPoints(renderPoints, this.leftRenderPointIndex, true, function (pt, i) {
            if (pt.pointIndex !== -1)
                _this.rightPointIndex = pt.pointIndex;
            _this.rightRenderPointIndex = i;
        }, function (pt) { return !Utils_1.GeometryUtils.arePointsOfOrthogonalLine(renderPoints[markLeftRenderPointIndex], pt, _this.isHorizontal); });
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.iterateRenderPoints = function (renderPoints, startIndex, direction, callback, stopPredicate) {
        for (var i = startIndex; direction ? i < renderPoints.length : i >= 0; direction ? i++ : i--) {
            var point = renderPoints[i];
            if (stopPredicate && stopPredicate(point, i))
                break;
            callback(point, i);
        }
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.onMouseDown = function (evt) {
        this.startPoint = evt.modelPoint;
        this.connector = this.model.findConnector(evt.source.key);
        this.handler.addInteractingItem(this.connector);
        var renderPointIndexes = evt.source.value.split("_");
        this.saveSidePoints(parseInt(renderPointIndexes[0]), parseInt(renderPointIndexes[1]));
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.shouldCreatePoint = function (isLeft) {
        if (!this.canCreatePoints)
            return false;
        if (isLeft && (this.leftPointIndex === undefined || this.leftPointIndex === 0))
            return true;
        if (!isLeft && (this.rightPointIndex === undefined || this.rightPointIndex === this.connector.points.length - 1))
            return true;
        var renderPoints = this.connector.getRenderPoints(true);
        if (isLeft && !this.connector.points[this.leftPointIndex].equals(renderPoints[this.leftRenderPointIndex]))
            return true;
        if (!isLeft && !this.connector.points[this.rightPointIndex].equals(renderPoints[this.rightRenderPointIndex]))
            return true;
        return false;
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.onApplyChanges = function (evt) {
        var _this = this;
        if (this.shouldCreatePoint(true) || this.shouldCreatePoint(false)) {
            var renderPoints = this.connector.getRenderPoints(true);
            var leftRenderPoint = renderPoints[this.leftRenderPointIndex];
            var rightRenderPoint = renderPoints[this.rightRenderPointIndex];
            if (this.shouldCreatePoint(true)) {
                var leftPoint = new point_1.Point(leftRenderPoint.x, leftRenderPoint.y);
                if (this.leftPointIndex === 0) {
                    this.leftPointIndex = 1;
                    this.correctEdgePoint(leftPoint, rightRenderPoint, this.connector.beginItem, this.connector.beginConnectionPointIndex);
                }
                else if (this.leftPointIndex === undefined)
                    this.iterateRenderPoints(renderPoints, this.leftRenderPointIndex, true, function (pt) {
                        if (pt.pointIndex !== -1)
                            _this.leftPointIndex = pt.pointIndex;
                    }, function () { return _this.leftPointIndex !== undefined; });
                ModelUtils_1.ModelUtils.addConnectorPoint(this.history, this.connector.key, this.leftPointIndex, leftPoint);
                if (this.rightPointIndex !== undefined)
                    this.rightPointIndex++;
            }
            if (this.shouldCreatePoint(false)) {
                renderPoints = this.connector.getRenderPoints(true);
                var rightPoint = new point_1.Point(rightRenderPoint.x, rightRenderPoint.y);
                if (this.rightPointIndex === this.connector.points.length - 1) {
                    this.correctEdgePoint(rightPoint, leftRenderPoint, this.connector.endItem, this.connector.endConnectionPointIndex);
                    this.rightPointIndex--;
                }
                else if (this.rightPointIndex === undefined)
                    this.iterateRenderPoints(renderPoints, this.rightRenderPointIndex, false, function (pt) {
                        if (pt.pointIndex !== -1)
                            _this.rightPointIndex = pt.pointIndex;
                    }, function () { return _this.rightPointIndex === _this.leftPointIndex; });
                this.rightPointIndex++;
                ModelUtils_1.ModelUtils.addConnectorPoint(this.history, this.connector.key, this.rightPointIndex, rightPoint);
            }
        }
        this.canCreatePoints = false;
        var point = this.getSnappedPoint(evt, evt.modelPoint);
        ModelUtils_1.ModelUtils.moveConnectorRightAnglePoints(this.history, this.connector, this.leftPointIndex, this.rightPointIndex, this.isHorizontal ? undefined : point.x, this.isHorizontal ? point.y : undefined);
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.onFinishWithChanges = function () {
        ModelUtils_1.ModelUtils.deleteConnectorUnnecessaryPoints(this.history, this.connector);
        ModelUtils_1.ModelUtils.fixConnectorBeginEndConnectionIndex(this.history, this.connector);
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.correctEdgePoint = function (point, directionPoint, item, connectionPointIndex) {
        var offset = 0;
        if (item) {
            var side = item.getConnectionPointSideByIndex(connectionPointIndex);
            var rect = item.rectangle;
            offset = Connector_1.Connector.minOffset;
            switch (side) {
                case DiagramItem_1.ConnectionPointSide.South:
                    offset += rect.bottom - point.y;
                    break;
                case DiagramItem_1.ConnectionPointSide.North:
                    offset += point.y - rect.y;
                    break;
                case DiagramItem_1.ConnectionPointSide.East:
                    offset += rect.right - point.x;
                    break;
                case DiagramItem_1.ConnectionPointSide.West:
                    offset += point.x - rect.x;
                    break;
            }
        }
        if (this.isHorizontal)
            if (point.x > directionPoint.x)
                point.x -= Math.min(offset, point.x - directionPoint.x);
            else
                point.x += Math.min(offset, directionPoint.x - point.x);
        else if (point.y > directionPoint.y)
            point.y -= Math.min(offset, point.y - directionPoint.y);
        else
            point.y += Math.min(offset, directionPoint.y - point.y);
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.getDraggingElementKeys = function () {
        return [this.connector.key];
    };
    return MouseHandlerMoveConnectorOrthogonalSideState;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerMoveConnectorOrthogonalSideState = MouseHandlerMoveConnectorOrthogonalSideState;


/***/ }),

/***/ 4402:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerMoveConnectorPointState = void 0;
var point_1 = __webpack_require__(8900);
var MouseHandlerMoveConnectorPointStateBase_1 = __webpack_require__(7060);
var Connector_1 = __webpack_require__(7959);
var ModelUtils_1 = __webpack_require__(4867);
var ConnectorProperties_1 = __webpack_require__(4612);
var MouseHandlerMoveConnectorPointState = (function (_super) {
    __extends(MouseHandlerMoveConnectorPointState, _super);
    function MouseHandlerMoveConnectorPointState() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MouseHandlerMoveConnectorPointState.prototype.onMouseDown = function (evt) {
        this.connector = this.model.findConnector(evt.source.key);
        this.pointIndex = parseInt(evt.source.value);
        if (this.pointIndex === 0)
            this.pointPosition = Connector_1.ConnectorPosition.Begin;
        else if (this.pointIndex === this.connector.points.length - 1)
            this.pointPosition = Connector_1.ConnectorPosition.End;
        this.handler.addInteractingItem(this.connector);
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerMoveConnectorPointState.prototype.onApplyChanges = function (evt) {
        if (this.connector.properties.lineOption !== ConnectorProperties_1.ConnectorLineOption.Orthogonal ||
            this.pointIndex === 0 || this.pointIndex === this.connector.points.length - 1)
            _super.prototype.onApplyChanges.call(this, evt);
    };
    MouseHandlerMoveConnectorPointState.prototype.onFinishWithChanges = function () {
        _super.prototype.onFinishWithChanges.call(this);
        ModelUtils_1.ModelUtils.deleteConnectorUnnecessaryPoints(this.history, this.connector);
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorPointState.prototype.getSnappedPoint = function (evt, point) {
        var points = this.connector.points;
        var index = this.pointIndex;
        if (0 < index && index < points.length - 1) {
            var tg = (points[index + 1].y - points[index - 1].y) / (points[index + 1].x - points[index - 1].x);
            var x = point.x;
            var y = points[index + 1].y - (points[index + 1].x - x) * tg;
            return this.handler.getSnappedPointOnDragPoint(evt, point, new point_1.Point(x, y));
        }
        return this.handler.getSnappedPointOnDragPoint(evt, point);
    };
    return MouseHandlerMoveConnectorPointState;
}(MouseHandlerMoveConnectorPointStateBase_1.MouseHandlerMoveConnectorPointStateBase));
exports.MouseHandlerMoveConnectorPointState = MouseHandlerMoveConnectorPointState;


/***/ }),

/***/ 7060:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerMoveConnectorPointStateBase = void 0;
var Connector_1 = __webpack_require__(7959);
var Event_1 = __webpack_require__(6031);
var MouseHandlerDraggingState_1 = __webpack_require__(8816);
var DeleteConnectionHistoryItem_1 = __webpack_require__(8930);
var AddConnectionHistoryItem_1 = __webpack_require__(3477);
var ModelUtils_1 = __webpack_require__(4867);
var MouseHandlerMoveConnectorPointStateBase = (function (_super) {
    __extends(MouseHandlerMoveConnectorPointStateBase, _super);
    function MouseHandlerMoveConnectorPointStateBase(handler, history, model, visualizerManager) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        _this.visualizerManager = visualizerManager;
        return _this;
    }
    MouseHandlerMoveConnectorPointStateBase.prototype.finish = function () {
        this.visualizerManager.resetConnectionTarget();
        this.visualizerManager.resetConnectionPoints();
        _super.prototype.finish.call(this);
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.onMouseDown = function (evt) {
        _super.prototype.onMouseDown.call(this, evt);
        if (this.connector)
            this.handler.addInteractingItem(this.connector);
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.onMouseMove = function (evt) {
        _super.prototype.onMouseMove.call(this, evt);
        if (!this.allowAttachToObjects(evt, false, false)) {
            this.visualizerManager.resetConnectionTarget();
            this.visualizerManager.resetConnectionPoints();
        }
        else if (this.connector) {
            var item = this.connector.getExtremeItem(this.pointPosition);
            this.visualizerManager.setConnectionTarget(item, evt.source.type);
            var pointIndex = this.connector.getExtremeConnectionPointIndex(this.pointPosition);
            if (!item && this.oppositeConnectionPointIndex !== -1 || !this.allowAttachToObjects(evt, true, false))
                item = this.model.findItem(evt.source.key);
            this.visualizerManager.setConnectionPoints(item, evt.source.type, pointIndex, true);
        }
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.onApplyChanges = function (evt) {
        var point = this.getSnappedPoint(evt, evt.modelPoint);
        if (this.pointPosition !== undefined) {
            if (this.oppositePointPosition === undefined) {
                this.oppositePointPosition = this.getOppositePointPosition();
                this.oppositeItem = this.connector.getExtremeItem(this.oppositePointPosition);
                this.oppositeConnectionPointIndex = this.connector.getExtremeConnectionPointIndex(this.oppositePointPosition);
            }
            this.targetItem = this.model.findItem(evt.source.key);
            var item = this.allowAttachToObjects(evt, true, true) ? this.targetItem : undefined;
            var connectionPointIndex = -1;
            if (evt.source.type === Event_1.MouseEventElementType.ShapeConnectionPoint)
                connectionPointIndex = parseInt(evt.source.value);
            if (item && (evt.source.type === Event_1.MouseEventElementType.Shape || evt.source.type === Event_1.MouseEventElementType.ShapeConnectionPoint) &&
                (this.connector.getExtremeItem(this.oppositePointPosition) !== item ||
                    (connectionPointIndex !== -1 && this.oppositeConnectionPointIndex !== -1 &&
                        connectionPointIndex !== this.oppositeConnectionPointIndex))) {
                if (this.connector.getExtremeItem(this.pointPosition) !== item ||
                    this.connector.getExtremeConnectionPointIndex(this.pointPosition) !== connectionPointIndex) {
                    if (this.connector.getExtremeItem(this.pointPosition))
                        this.history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(this.connector, this.pointPosition));
                    this.history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(this.connector, item, connectionPointIndex, this.pointPosition));
                    if (this.oppositeItem)
                        this.updateOppositeItemConnectionPointIndex(connectionPointIndex);
                }
                point = item.getConnectionPointPosition(connectionPointIndex, this.connector.points[this.pointIndex + (this.pointPosition === Connector_1.ConnectorPosition.End ? -1 : 1)]);
                this.visualizerManager.setConnectionPointIndex(connectionPointIndex);
            }
            else if (this.connector.getExtremeItem(this.pointPosition)) {
                this.history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(this.connector, this.pointPosition));
                if (this.oppositeItem)
                    this.updateOppositeItemConnectionPointIndex(this.oppositeConnectionPointIndex);
            }
        }
        ModelUtils_1.ModelUtils.moveConnectorPoint(this.history, this.connector, this.pointIndex, point);
        ModelUtils_1.ModelUtils.updateConnectorAttachedPoints(this.history, this.model, this.connector);
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.updateOppositeItemConnectionPointIndex = function (connectionPointIndex) {
        var pointIndex = connectionPointIndex === -1 ? -1 : this.oppositeConnectionPointIndex;
        if (pointIndex !== this.connector.getExtremeConnectionPointIndex(this.oppositePointPosition)) {
            this.history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(this.connector, this.oppositePointPosition));
            this.history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(this.connector, this.oppositeItem, pointIndex, this.oppositePointPosition));
        }
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.onFinishWithChanges = function () {
        ModelUtils_1.ModelUtils.updateConnectorContainer(this.history, this.model, this.connector);
        ModelUtils_1.ModelUtils.deleteConnectorUnnecessaryPoints(this.history, this.connector);
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.getDraggingElementKeys = function () {
        return this.connector ? [this.connector.key] : [];
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.getOppositePointPosition = function () {
        return this.pointPosition === Connector_1.ConnectorPosition.Begin ? Connector_1.ConnectorPosition.End : Connector_1.ConnectorPosition.Begin;
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.allowAttachToObjects = function (evt, checkContainers, checkOppositeItem) {
        if (this.handler.canMultipleSelection(evt))
            return false;
        var connector = this.connector;
        if (connector && evt.source.type === Event_1.MouseEventElementType.Shape) {
            var targetItem_1 = this.model.findItem(evt.source.key);
            if (checkContainers && this.model.findItemContainerCore(connector, function (c) { return c === targetItem_1; }))
                return false;
            if (checkContainers && this.oppositeItem && this.model.findItemContainerCore(this.oppositeItem, function (c) { return c === targetItem_1; }))
                return false;
            if (checkOppositeItem && this.oppositeItem === targetItem_1 && this.oppositeConnectionPointIndex === -1)
                return false;
        }
        return true;
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.onConnectionPointsShow = function (key, points) {
        var _this = this;
        if (this.connector && this.pointPosition !== undefined && (this.connector.endItem && this.connector.endItem.key === key || this.connector.beginItem && this.connector.beginItem.key === key)) {
            var position_1 = this.connector.beginItem && this.connector.beginItem.key === key ? Connector_1.ConnectorPosition.Begin : Connector_1.ConnectorPosition.End;
            points.forEach(function (point, index) {
                point.allowed = _this.handler.canPerformChangeConnectionOnUpdateUI(_this.connector, { item: _this.connector.getExtremeItem(position_1), position: position_1, connectionPointIndex: index });
            });
        }
    };
    MouseHandlerMoveConnectorPointStateBase.prototype.onConnectionTargetShow = function (key, info) {
        if (this.connector && this.pointPosition !== undefined && (this.connector.endItem && this.connector.endItem.key === key || this.connector.beginItem && this.connector.beginItem.key === key)) {
            var position = this.connector.beginItem && this.connector.beginItem.key === key ? Connector_1.ConnectorPosition.Begin : Connector_1.ConnectorPosition.End;
            info.allowed = this.handler.canPerformChangeConnectionOnUpdateUI(this.connector, { item: this.connector.getExtremeItem(position), position: position, connectionPointIndex: -1 });
        }
    };
    return MouseHandlerMoveConnectorPointStateBase;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerMoveConnectorPointStateBase = MouseHandlerMoveConnectorPointStateBase;


/***/ }),

/***/ 481:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerMoveConnectorSideState = void 0;
var MouseHandlerDraggingState_1 = __webpack_require__(8816);
var ModelUtils_1 = __webpack_require__(4867);
var MouseHandlerMoveConnectorSideState = (function (_super) {
    __extends(MouseHandlerMoveConnectorSideState, _super);
    function MouseHandlerMoveConnectorSideState(handler, history, model) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        return _this;
    }
    MouseHandlerMoveConnectorSideState.prototype.onMouseDown = function (evt) {
        this.startPoint = evt.modelPoint;
        this.connectorKey = evt.source.key;
        this.pointIndex = parseInt(evt.source.value) + 1;
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerMoveConnectorSideState.prototype.onApplyChanges = function (evt) {
        var point = this.getSnappedPoint(evt, evt.modelPoint);
        var connector = this.model.findConnector(this.connectorKey);
        if (!this.pointCreated) {
            this.handler.addInteractingItem(connector);
            ModelUtils_1.ModelUtils.addConnectorPoint(this.history, this.connectorKey, this.pointIndex, point.clone());
            this.pointCreated = true;
        }
        else
            ModelUtils_1.ModelUtils.moveConnectorPoint(this.history, connector, this.pointIndex, point);
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorSideState.prototype.onFinishWithChanges = function () {
        var connector = this.model.findConnector(this.connectorKey);
        ModelUtils_1.ModelUtils.deleteConnectorUnnecessaryPoints(this.history, connector);
        ModelUtils_1.ModelUtils.fixConnectorBeginEndConnectionIndex(this.history, connector);
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorSideState.prototype.getDraggingElementKeys = function () {
        return [this.connectorKey];
    };
    return MouseHandlerMoveConnectorSideState;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerMoveConnectorSideState = MouseHandlerMoveConnectorSideState;


/***/ }),

/***/ 5168:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerMoveConnectorState = void 0;
var ModelUtils_1 = __webpack_require__(4867);
var MouseHandlerDragDiagramItemStateBase_1 = __webpack_require__(1717);
var MouseHandlerMoveConnectorState = (function (_super) {
    __extends(MouseHandlerMoveConnectorState, _super);
    function MouseHandlerMoveConnectorState(handler, history, model, selection, visualizerManager) {
        var _this = _super.call(this, handler, history, model, selection, visualizerManager) || this;
        _this.model = model;
        _this.selection = selection;
        _this.visualizerManager = visualizerManager;
        return _this;
    }
    Object.defineProperty(MouseHandlerMoveConnectorState.prototype, "areValidDraggingShapes", {
        get: function () {
            return true;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MouseHandlerMoveConnectorState.prototype, "areValidDraggingConnectors", {
        get: function () {
            var _this = this;
            if (this.shouldClone)
                return this.dragHelper.draggingShapes.length > 0 || this.dragHelper.draggingConnectors.length > 0;
            if (!this.dragHelper.draggingConnectors.length)
                return false;
            if (!this.dragHelper.draggingShapes.length)
                return !this.dragHelper.draggingConnectors.some(function (x) { return !ModelUtils_1.ModelUtils.canMoveConnector(_this.dragHelper.selectedItems, x.connector); });
            return ModelUtils_1.ModelUtils.canMoveConnector(this.dragHelper.selectedItems, this.dragHelper.draggingConnectors[this.dragHelper.draggingConnectorsIndexByKey[this.handler.mouseDownEvent.source.key]].connector);
        },
        enumerable: false,
        configurable: true
    });
    return MouseHandlerMoveConnectorState;
}(MouseHandlerDragDiagramItemStateBase_1.MouseHandlerDragDiagramItemStateBase));
exports.MouseHandlerMoveConnectorState = MouseHandlerMoveConnectorState;


/***/ }),

/***/ 5391:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerMoveConnectorTextState = void 0;
var MouseHandlerDraggingState_1 = __webpack_require__(8816);
var ChangeConnectorTextPositionHistoryItem_1 = __webpack_require__(45);
var ChangeConnectorTextHistoryItem_1 = __webpack_require__(5144);
var MouseHandlerMoveConnectorTextState = (function (_super) {
    __extends(MouseHandlerMoveConnectorTextState, _super);
    function MouseHandlerMoveConnectorTextState(handler, history, model) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        return _this;
    }
    MouseHandlerMoveConnectorTextState.prototype.onMouseDown = function (evt) {
        this.connector = this.model.findConnector(evt.source.key);
        this.position = parseFloat(evt.source.value);
        this.text = this.connector.getText(this.position);
        this.savedText = "";
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerMoveConnectorTextState.prototype.onApplyChanges = function (evt) {
        var newPosition = this.connector.getTextPositionByPoint(evt.modelPoint);
        if (newPosition !== this.position) {
            var text = this.connector.getText(newPosition);
            if (text !== "" && text !== this.text) {
                this.history.addAndRedo(new ChangeConnectorTextHistoryItem_1.ChangeConnectorTextHistoryItem(this.connector, newPosition, ""));
                this.savedText = text;
            }
            this.history.addAndRedo(new ChangeConnectorTextPositionHistoryItem_1.ChangeConnectorTextPositionHistoryItem(this.connector, this.position, newPosition));
            if (this.savedText !== "" && this.savedText !== text) {
                this.history.addAndRedo(new ChangeConnectorTextHistoryItem_1.ChangeConnectorTextHistoryItem(this.connector, this.position, this.savedText));
                this.savedText = "";
            }
            this.position = newPosition;
        }
    };
    MouseHandlerMoveConnectorTextState.prototype.getDraggingElementKeys = function () {
        return [this.connector.key];
    };
    return MouseHandlerMoveConnectorTextState;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerMoveConnectorTextState = MouseHandlerMoveConnectorTextState;


/***/ }),

/***/ 9979:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerMoveShapeState = void 0;
var MouseHandlerDragDiagramItemStateBase_1 = __webpack_require__(1717);
var MouseHandlerMoveShapeState = (function (_super) {
    __extends(MouseHandlerMoveShapeState, _super);
    function MouseHandlerMoveShapeState(handler, history, model, selection, visualizerManager) {
        var _this = _super.call(this, handler, history, model, selection, visualizerManager) || this;
        _this.model = model;
        _this.selection = selection;
        _this.visualizerManager = visualizerManager;
        return _this;
    }
    Object.defineProperty(MouseHandlerMoveShapeState.prototype, "areValidDraggingShapes", {
        get: function () {
            return this.shouldClone || this.dragHelper.draggingShapes.length > 0;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MouseHandlerMoveShapeState.prototype, "areValidDraggingConnectors", {
        get: function () {
            return true;
        },
        enumerable: false,
        configurable: true
    });
    return MouseHandlerMoveShapeState;
}(MouseHandlerDragDiagramItemStateBase_1.MouseHandlerDragDiagramItemStateBase));
exports.MouseHandlerMoveShapeState = MouseHandlerMoveShapeState;


/***/ }),

/***/ 5609:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerResizeShapeState = void 0;
var size_1 = __webpack_require__(6353);
var point_1 = __webpack_require__(8900);
var Event_1 = __webpack_require__(6031);
var MouseHandlerDraggingState_1 = __webpack_require__(8816);
var ModelUtils_1 = __webpack_require__(4867);
var ShapeDescription_1 = __webpack_require__(6794);
var ModelOperationSettings_1 = __webpack_require__(6879);
var MouseHandlerResizeShapeState = (function (_super) {
    __extends(MouseHandlerResizeShapeState, _super);
    function MouseHandlerResizeShapeState(handler, history, model, selection, visualizerManager, settings) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        _this.selection = selection;
        _this.visualizerManager = visualizerManager;
        _this.settings = settings;
        _this.startScrollLeft = 0;
        _this.startScrollTop = 0;
        _this.rotation = 0;
        return _this;
    }
    MouseHandlerResizeShapeState.prototype.finish = function () {
        this.visualizerManager.resetResizeInfo();
        this.visualizerManager.resetExtensionLines();
        _super.prototype.finish.call(this);
    };
    MouseHandlerResizeShapeState.prototype.onMouseDown = function (evt) {
        var _this = this;
        var source = parseInt(evt.source.value);
        this.resizeEventSource = source;
        this.startPoint = evt.modelPoint;
        this.lockH = source === Event_1.ResizeEventSource.ResizeBox_S || source === Event_1.ResizeEventSource.ResizeBox_N;
        this.lockV = source === Event_1.ResizeEventSource.ResizeBox_E || source === Event_1.ResizeEventSource.ResizeBox_W;
        this.sideH = source === Event_1.ResizeEventSource.ResizeBox_E || source === Event_1.ResizeEventSource.ResizeBox_NE || source === Event_1.ResizeEventSource.ResizeBox_SE;
        this.sideV = source === Event_1.ResizeEventSource.ResizeBox_SE || source === Event_1.ResizeEventSource.ResizeBox_S || source === Event_1.ResizeEventSource.ResizeBox_SW;
        this.shapes = this.selection.getSelectedShapes();
        if (this.shapes.length === 0) {
            this.handler.switchToDefaultState();
            return;
        }
        this.shapes.forEach(function (shape) {
            _this.handler.addInteractingItem(shape, ModelOperationSettings_1.DiagramModelOperation.ResizeShape);
            _this.handler.addInteractingItem(shape, ModelOperationSettings_1.DiagramModelOperation.MoveShape);
        });
        this.connectors = this.selection.getSelectedConnectors();
        this.startRectangle = ModelUtils_1.ModelUtils.createRectangle(this.shapes);
        this.startShapeSizes = this.shapes.map(function (shape) { return shape.size.clone(); });
        this.startShapePositions = this.shapes.map(function (shape) { return shape.position.clone(); });
        this.startConnectorPoints = this.connectors.map(function (c) { return c.points.map(function (p) { return p.clone(); }); });
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerResizeShapeState.prototype.onMouseMove = function (evt) {
        _super.prototype.onMouseMove.call(this, evt);
        var shapes = this.selection.getSelectedShapes();
        this.visualizerManager.setExtensionLines(shapes);
    };
    MouseHandlerResizeShapeState.prototype.onApplyChanges = function (evt) {
        var _this = this;
        var rectangle = ModelUtils_1.ModelUtils.createRectangle(this.shapes);
        var minWidth = this.shapes.length === 1 ? this.shapes[0].getMinWidth(this.settings.shapeMinWidth) : ShapeDescription_1.ShapeMinDimension;
        var minHeight = this.shapes.length === 1 ? this.shapes[0].getMinHeight(this.settings.shapeMinHeight) : ShapeDescription_1.ShapeMinDimension;
        var maxWidth = this.shapes.length === 1 ? this.shapes[0].getMaxWidth(this.settings.shapeMaxWidth) : undefined;
        var maxHeight = this.shapes.length === 1 ? this.shapes[0].getMaxHeight(this.settings.shapeMaxHeight) : undefined;
        var size = this.getSize(evt, rectangle.createPosition(), this.startRectangle.createSize(), minWidth, minHeight, maxWidth, maxHeight, this.handler.lockAspectRatioOnShapeResize(evt));
        var pos = this.getPosition(evt, size, this.startRectangle.createSize(), this.startRectangle.createPosition());
        var ratioX = size.width / this.startRectangle.width;
        var ratioY = size.height / this.startRectangle.height;
        this.shapes.forEach(function (shape, index) {
            var shapeWidth = _this.startShapeSizes[index].width * (shape.allowResizeHorizontally ? ratioX : 1);
            shapeWidth = _this.getNormalizedSize(shapeWidth, shape.getMinWidth(_this.settings.shapeMinWidth), shape.getMaxWidth(_this.settings.shapeMaxWidth));
            var shapeHeight = _this.startShapeSizes[index].height * (shape.allowResizeVertically ? ratioY : 1);
            shapeHeight = _this.getNormalizedSize(shapeHeight, shape.getMinHeight(_this.settings.shapeMinHeight), shape.getMaxHeight(_this.settings.shapeMaxHeight));
            var shapeLeft = shape.allowResizeHorizontally ? (pos.x + (_this.startShapePositions[index].x - _this.startRectangle.x) * ratioX) : _this.startShapePositions[index].x;
            var shapeTop = shape.allowResizeVertically ? (pos.y + (_this.startShapePositions[index].y - _this.startRectangle.y) * ratioY) : _this.startShapePositions[index].y;
            ModelUtils_1.ModelUtils.setShapeSize(_this.history, _this.model, shape, new point_1.Point(shapeLeft, shapeTop), new size_1.Size(shapeWidth, shapeHeight));
        });
        this.connectors.forEach(function (connector, index) {
            var startPtIndex = connector.beginItem ? 1 : 0;
            var endPtIndex = connector.endItem ? (connector.points.length - 2) : (connector.points.length - 1);
            for (var i = startPtIndex; i <= endPtIndex; i++) {
                var connectorPtPos = new point_1.Point(pos.x + (_this.startConnectorPoints[index][i].x - _this.startRectangle.x) * ratioX, pos.y + (_this.startConnectorPoints[index][i].y - _this.startRectangle.y) * ratioY);
                ModelUtils_1.ModelUtils.moveConnectorPoint(_this.history, connector, i, connectorPtPos);
            }
        });
        var shapes = this.selection.getSelectedShapes(false, true);
        shapes.forEach(function (shape) {
            ModelUtils_1.ModelUtils.updateShapeAttachedConnectors(_this.history, _this.model, shape);
        });
        this.tryUpdateModelSize();
        this.visualizerManager.setResizeInfo(this.shapes);
    };
    MouseHandlerResizeShapeState.prototype.tryUpdateModelSize = function () {
        var _this = this;
        this.handler.tryUpdateModelSize(function (offsetLeft, offsetTop) {
            _this.startShapePositions.forEach(function (pt) {
                pt.x += offsetLeft;
                pt.y += offsetTop;
            });
            _this.startConnectorPoints.forEach(function (connector) {
                connector.forEach(function (pt) {
                    pt.x += offsetLeft;
                    pt.y += offsetTop;
                });
            });
            _this.startRectangle.x += offsetLeft;
            _this.startRectangle.y += offsetTop;
            _this.startPoint.x += offsetLeft;
            _this.startPoint.y += offsetTop;
        });
    };
    MouseHandlerResizeShapeState.prototype.getDraggingElementKeys = function () {
        return this.shapes.map(function (shape) { return shape.key; });
    };
    MouseHandlerResizeShapeState.prototype.getNormalizedSize = function (value, minValue, maxValue) {
        if (minValue !== undefined)
            value = Math.max(value, minValue);
        if (maxValue !== undefined)
            value = Math.min(value, maxValue);
        return value;
    };
    MouseHandlerResizeShapeState.prototype.getSize = function (evt, position, startSize, minWidth, minHeight, maxWidth, maxHeight, lockAspectRatio) {
        var absDeltaX = evt.modelPoint.x - (this.startScrollLeft - evt.scrollX) - this.startPoint.x;
        var absDeltaY = evt.modelPoint.y - (this.startScrollTop - evt.scrollY) - this.startPoint.y;
        var deltaX = absDeltaX * Math.cos(this.rotation) - (-absDeltaY) * Math.sin(this.rotation);
        var deltaY = -(absDeltaX * Math.sin(this.rotation) + (-absDeltaY) * Math.cos(this.rotation));
        var newWidth;
        var newHeight;
        deltaY = !this.sideV && deltaY > 0 ? Math.min(startSize.height + 1, deltaY) : deltaY;
        deltaX = !this.sideH && deltaX > 0 ? Math.min(startSize.width + 1, deltaX) : deltaX;
        if (!this.lockH && !this.lockV && lockAspectRatio)
            if (Math.abs(deltaX) > Math.abs(deltaY)) {
                newWidth = this.getNormalizedSize(this.sideH ? (startSize.width + deltaX) : (startSize.width - deltaX), minWidth, maxWidth);
                newHeight = startSize.height * (newWidth / startSize.width);
            }
            else {
                newHeight = this.getNormalizedSize(this.sideV ? (startSize.height + deltaY) : (startSize.height - deltaY), minHeight, maxHeight);
                newWidth = startSize.width * (newHeight / startSize.height);
            }
        else {
            deltaX = this.lockH ? 0 : deltaX;
            deltaY = this.lockV ? 0 : deltaY;
            newWidth = this.getNormalizedSize(this.sideH ? (startSize.width + deltaX) : (startSize.width - deltaX), minWidth, maxWidth);
            newHeight = this.getNormalizedSize(this.sideV ? (startSize.height + deltaY) : (startSize.height - deltaY), minHeight, maxHeight);
        }
        if (!this.lockH)
            newWidth = this.getSnappedPosition(evt, position.x + newWidth, true) - position.x;
        if (!this.lockV)
            newHeight = this.getSnappedPosition(evt, position.y + newHeight, false) - position.y;
        return new size_1.Size(newWidth, newHeight);
    };
    MouseHandlerResizeShapeState.prototype.getPosition = function (evt, size, startSize, startPosition) {
        var x = startPosition.x;
        var y = startPosition.y;
        if (this.resizeEventSource === Event_1.ResizeEventSource.ResizeBox_N ||
            this.resizeEventSource === Event_1.ResizeEventSource.ResizeBox_NE ||
            this.resizeEventSource === Event_1.ResizeEventSource.ResizeBox_NW) {
            y += startSize.height - size.height;
            var snappedY = this.getSnappedPosition(evt, y, false);
            size.height += y - snappedY;
            y = snappedY;
        }
        if (this.resizeEventSource === Event_1.ResizeEventSource.ResizeBox_W ||
            this.resizeEventSource === Event_1.ResizeEventSource.ResizeBox_NW ||
            this.resizeEventSource === Event_1.ResizeEventSource.ResizeBox_SW) {
            x += startSize.width - size.width;
            var snappedX = this.getSnappedPosition(evt, x, true);
            size.width += x - snappedX;
            x = snappedX;
        }
        return new point_1.Point(x, y);
    };
    MouseHandlerResizeShapeState.prototype.getSnappedPosition = function (evt, pos, isHorizontal) {
        return this.handler.getSnappedPositionOnResizeShape(evt, pos, isHorizontal);
    };
    return MouseHandlerResizeShapeState;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerResizeShapeState = MouseHandlerResizeShapeState;


/***/ }),

/***/ 9582:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerScrollingState = void 0;
var MouseHandlerStateBase_1 = __webpack_require__(5434);
var Event_1 = __webpack_require__(6031);
var point_1 = __webpack_require__(8900);
var MouseHandlerScrollingState = (function (_super) {
    __extends(MouseHandlerScrollingState, _super);
    function MouseHandlerScrollingState(handler, view, selection) {
        var _this = _super.call(this, handler) || this;
        _this.view = view;
        _this.selection = selection;
        _this.lastOffset = new point_1.Point(0, 0);
        return _this;
    }
    MouseHandlerScrollingState.prototype.onKeyUp = function (evt) {
        this.handler.onFinishScrollPageByKeyboard(evt);
    };
    MouseHandlerScrollingState.prototype.onMouseDown = function (evt) {
        evt.preventDefault = true;
        this.startPoint = this.getPointByEvent(evt);
    };
    MouseHandlerScrollingState.prototype.onMouseMove = function (evt) {
        if (evt.button !== Event_1.MouseButton.Left) {
            this.handler.onFinishScrollPageByMouse(evt);
            return;
        }
        var prevPoint = this.currentPoint || this.startPoint;
        evt.preventDefault = true;
        var point = this.getPointByEvent(evt);
        var actualOffset = this.view.scrollBy(new point_1.Point(point.x - prevPoint.x, point.y - prevPoint.y));
        this.lastOffset = this.lastOffset.clone().offset(actualOffset.x, actualOffset.y);
        this.currentPoint = point;
    };
    MouseHandlerScrollingState.prototype.onMouseUp = function (evt) {
        if (evt.button === Event_1.MouseButton.Left)
            this.handler.onFinishScrollPageByMouse(evt);
        this.handler.switchToDefaultState();
    };
    MouseHandlerScrollingState.prototype.cancelChanges = function () {
        if (this.currentPoint)
            this.view.scrollBy(this.lastOffset.clone().multiply(-1, -1));
    };
    MouseHandlerScrollingState.prototype.finish = function () {
        if (!this.currentPoint || !this.startPoint || this.currentPoint.equals(this.startPoint))
            this.selection.set([]);
        _super.prototype.finish.call(this);
    };
    MouseHandlerScrollingState.prototype.getPointByEvent = function (evt) {
        return evt.offsetPoint;
    };
    return MouseHandlerScrollingState;
}(MouseHandlerStateBase_1.MouseHandlerCancellableState));
exports.MouseHandlerScrollingState = MouseHandlerScrollingState;


/***/ }),

/***/ 4869:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerSelectionState = void 0;
var Event_1 = __webpack_require__(6031);
var rectangle_1 = __webpack_require__(8011);
var MouseHandlerStateBase_1 = __webpack_require__(5434);
var MouseHandlerSelectionState = (function (_super) {
    __extends(MouseHandlerSelectionState, _super);
    function MouseHandlerSelectionState(handler, selection, visualizerManager) {
        var _this = _super.call(this, handler) || this;
        _this.selection = selection;
        _this.visualizerManager = visualizerManager;
        return _this;
    }
    MouseHandlerSelectionState.prototype.finish = function () {
        this.handler.raiseDragEnd([]);
        this.visualizerManager.resetSelectionRectangle();
        _super.prototype.finish.call(this);
    };
    MouseHandlerSelectionState.prototype.cancelChanges = function () {
    };
    MouseHandlerSelectionState.prototype.onMouseDown = function (evt) {
        this.startPoint = evt.modelPoint;
        this.handler.raiseDragStart([]);
    };
    MouseHandlerSelectionState.prototype.onMouseMove = function (evt) {
        if (evt.button !== Event_1.MouseButton.Left)
            this.handler.switchToDefaultState();
        else {
            this.rectangle = rectangle_1.Rectangle.fromPoints(this.startPoint, evt.modelPoint);
            this.visualizerManager.setSelectionRectangle(this.rectangle);
        }
    };
    MouseHandlerSelectionState.prototype.onMouseUp = function (evt) {
        if (this.rectangle !== undefined)
            this.selection.selectRect(this.rectangle);
        else
            this.selection.set([]);
        this.rectangle = undefined;
        this.handler.switchToDefaultState();
    };
    return MouseHandlerSelectionState;
}(MouseHandlerStateBase_1.MouseHandlerCancellableState));
exports.MouseHandlerSelectionState = MouseHandlerSelectionState;


/***/ }),

/***/ 5434:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerCancellableState = exports.MouseHandlerStateBase = void 0;
var key_1 = __webpack_require__(2153);
var MouseHandlerStateBase = (function () {
    function MouseHandlerStateBase(handler) {
        this.handler = handler;
    }
    MouseHandlerStateBase.prototype.start = function () { };
    MouseHandlerStateBase.prototype.finish = function () { };
    MouseHandlerStateBase.prototype.onMouseClick = function (_evt) { };
    MouseHandlerStateBase.prototype.onMouseDblClick = function (_evt) {
        this.handler.switchToDefaultState();
    };
    MouseHandlerStateBase.prototype.onMouseDown = function (_evt) { };
    MouseHandlerStateBase.prototype.onMouseUp = function (_evt) { };
    MouseHandlerStateBase.prototype.onMouseMove = function (_evt) { };
    MouseHandlerStateBase.prototype.onMouseWheel = function (_evt) { return false; };
    MouseHandlerStateBase.prototype.onDragStart = function (_evt) { };
    MouseHandlerStateBase.prototype.onDragEnd = function (_evt) { };
    MouseHandlerStateBase.prototype.onShortcut = function (_shortcutCode) { return false; };
    MouseHandlerStateBase.prototype.onKeyDown = function (_evt) { };
    MouseHandlerStateBase.prototype.onKeyUp = function (_evt) { };
    MouseHandlerStateBase.prototype.onConnectionPointsShow = function (key, points) { };
    MouseHandlerStateBase.prototype.onConnectionTargetShow = function (key, info) { };
    return MouseHandlerStateBase;
}());
exports.MouseHandlerStateBase = MouseHandlerStateBase;
var MouseHandlerCancellableState = (function (_super) {
    __extends(MouseHandlerCancellableState, _super);
    function MouseHandlerCancellableState() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MouseHandlerCancellableState.prototype.onShortcut = function (code) {
        if (code === key_1.KeyCode.Esc) {
            this.cancelChanges();
            this.handler.switchToDefaultState();
            return true;
        }
        return false;
    };
    return MouseHandlerCancellableState;
}(MouseHandlerStateBase));
exports.MouseHandlerCancellableState = MouseHandlerCancellableState;


/***/ }),

/***/ 5752:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerToggleShapeExpandedState = void 0;
var MouseHandlerStateBase_1 = __webpack_require__(5434);
var ToggleShapeExpandedHistoryItem_1 = __webpack_require__(442);
var ModelUtils_1 = __webpack_require__(4867);
var MouseHandlerToggleShapeExpandedState = (function (_super) {
    __extends(MouseHandlerToggleShapeExpandedState, _super);
    function MouseHandlerToggleShapeExpandedState(handler, history, model, selection) {
        var _this = _super.call(this, handler) || this;
        _this.history = history;
        _this.model = model;
        _this.selection = selection;
        return _this;
    }
    MouseHandlerToggleShapeExpandedState.prototype.onMouseUp = function (evt) {
        var shape = this.model.findShape(evt.source.key);
        if (shape && !shape.isLocked) {
            this.history.beginTransaction();
            this.history.addAndRedo(new ToggleShapeExpandedHistoryItem_1.ToggleShapeExpandedHistoryItem(shape));
            ModelUtils_1.ModelUtils.updateShapeAttachedConnectors(this.history, this.model, shape);
            ModelUtils_1.ModelUtils.updateContainerConnectorsAttachedPoints(this.history, this.model, shape);
            ModelUtils_1.ModelUtils.updateSelection(this.history, this.selection);
            this.handler.tryUpdateModelSize();
            this.history.endTransaction();
            this.handler.raiseClick([shape.key]);
        }
        this.handler.switchToDefaultState();
    };
    return MouseHandlerToggleShapeExpandedState;
}(MouseHandlerStateBase_1.MouseHandlerStateBase));
exports.MouseHandlerToggleShapeExpandedState = MouseHandlerToggleShapeExpandedState;


/***/ }),

/***/ 6918:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerToolboxDraggingState = exports.MouseHandlerBeforeToolboxDraggingState = void 0;
var Event_1 = __webpack_require__(6031);
var point_1 = __webpack_require__(8900);
var AddShapeHistoryItem_1 = __webpack_require__(4145);
var SetSelectionHistoryItem_1 = __webpack_require__(4297);
var MouseHandlerDraggingState_1 = __webpack_require__(8816);
var DeleteShapeHistoryItem_1 = __webpack_require__(1704);
var ModelUtils_1 = __webpack_require__(4867);
var MouseHandlerStateBase_1 = __webpack_require__(5434);
var ModelOperationSettings_1 = __webpack_require__(6879);
var NON_DOCUMENT_TIMER = 500;
var LOCK_UPDATEPAGESIZE_TIMER = 300;
var MouseHandlerBeforeToolboxDraggingState = (function (_super) {
    __extends(MouseHandlerBeforeToolboxDraggingState, _super);
    function MouseHandlerBeforeToolboxDraggingState(handler, history, model, selection, visualizerManager, shapeDescriptionManager) {
        var _this = _super.call(this, handler) || this;
        _this.history = history;
        _this.model = model;
        _this.selection = selection;
        _this.visualizerManager = visualizerManager;
        _this.shapeDescriptionManager = shapeDescriptionManager;
        _this.isModelEmpty = model.items.length === 0;
        return _this;
    }
    MouseHandlerBeforeToolboxDraggingState.prototype.cancelChanges = function () {
        this.tryRemoveTimer();
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.onDragStart = function (evt) {
        this.dragging = evt;
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.onDragEnd = function (evt) {
        this.cancelChanges();
        this.handler.switchToDefaultState();
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.onMouseMove = function (evt) {
        var _this = this;
        if (evt.source.type > Event_1.MouseEventElementType.Background) {
            this.tryRemoveTimer();
            this.switchToDraggingState(evt, false);
        }
        else if (evt.source.type === Event_1.MouseEventElementType.Background && !this.isModelEmpty) {
            this.savedEvt = evt;
            if (this.nonPageAreaTimer === undefined)
                this.nonPageAreaTimer = setTimeout(function () { return _this.switchToDraggingState(_this.savedEvt, true); }, NON_DOCUMENT_TIMER);
        }
        else if (this.nonPageAreaTimer !== undefined)
            this.tryRemoveTimer();
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.switchToDraggingState = function (evt, skipLockUpdatePageSize) {
        this.handler.switchState(new MouseHandlerToolboxDraggingState(this.handler, this.history, this.model, this.selection, this.visualizerManager, this.shapeDescriptionManager, skipLockUpdatePageSize));
        this.handler.state.onDragStart(this.dragging);
        this.handler.state.onMouseMove(evt);
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.tryRemoveTimer = function () {
        if (this.nonPageAreaTimer !== undefined) {
            clearTimeout(this.nonPageAreaTimer);
            delete this.nonPageAreaTimer;
        }
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.finish = function () {
        this.tryRemoveTimer();
    };
    return MouseHandlerBeforeToolboxDraggingState;
}(MouseHandlerStateBase_1.MouseHandlerCancellableState));
exports.MouseHandlerBeforeToolboxDraggingState = MouseHandlerBeforeToolboxDraggingState;
var MouseHandlerToolboxDraggingState = (function (_super) {
    __extends(MouseHandlerToolboxDraggingState, _super);
    function MouseHandlerToolboxDraggingState(handler, history, model, selection, visualizerManager, shapeDescriptionManager, skipLockUpdatePageSize) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        _this.selection = selection;
        _this.visualizerManager = visualizerManager;
        _this.shapeDescriptionManager = shapeDescriptionManager;
        if (!skipLockUpdatePageSize)
            _this.updatePageSizeTimer = setTimeout(function () {
                _this.processAndRemoveUpdatePageSizeTimer();
            }, LOCK_UPDATEPAGESIZE_TIMER);
        return _this;
    }
    MouseHandlerToolboxDraggingState.prototype.cancelChanges = function () {
        this.tryRemoveUpdatePageSizeTimer();
        _super.prototype.cancelChanges.call(this);
    };
    MouseHandlerToolboxDraggingState.prototype.tryRemoveUpdatePageSizeTimer = function () {
        if (this.updatePageSizeTimer !== undefined) {
            clearTimeout(this.updatePageSizeTimer);
            delete this.updatePageSizeTimer;
        }
    };
    MouseHandlerToolboxDraggingState.prototype.processAndRemoveUpdatePageSizeTimer = function () {
        if (this.updatePageSizeTimer !== undefined) {
            this.handler.tryUpdateModelSize();
            delete this.updatePageSizeTimer;
        }
    };
    MouseHandlerToolboxDraggingState.prototype.onMouseMove = function (evt) {
        _super.prototype.onMouseMove.call(this, evt);
        var shape = this.model.findShape(this.shapeKey);
        if (shape) {
            this.visualizerManager.setExtensionLines([shape]);
            var container = ModelUtils_1.ModelUtils.findContainerByEventKey(this.model, this.selection, evt.source.key);
            if (container && this.allowInsertToContainer(evt, shape, container))
                this.visualizerManager.setContainerTarget(container, evt.source.type);
            else
                this.visualizerManager.resetContainerTarget();
        }
    };
    MouseHandlerToolboxDraggingState.prototype.getDraggingElementKeys = function () {
        return this.shapeKey === undefined ? [] : [this.shapeKey];
    };
    MouseHandlerToolboxDraggingState.prototype.onApplyChanges = function (evt) {
        var _this = this;
        if (evt.source.type === Event_1.MouseEventElementType.Undefined) {
            this.dragging.onCaptured(false);
            if (this.shapeKey !== undefined && !this.deleteHistoryItem) {
                var shape = this.model.findShape(this.shapeKey);
                ModelUtils_1.ModelUtils.detachConnectors(this.history, shape);
                ModelUtils_1.ModelUtils.removeFromContainer(this.history, this.model, shape);
                this.deleteHistoryItem = new DeleteShapeHistoryItem_1.DeleteShapeHistoryItem(this.shapeKey, true);
                this.history.addAndRedo(this.deleteHistoryItem);
            }
        }
        else {
            this.dragging.onCaptured(true);
            if (this.shapeKey === undefined) {
                this.startPoint = evt.modelPoint;
                this.shapeKey = this.insertToolboxItem(evt);
                var shape_1 = this.model.findShape(this.shapeKey);
                if (shape_1)
                    this.handler.addInteractingItem(shape_1, ModelOperationSettings_1.DiagramModelOperation.AddShape);
            }
            if (this.deleteHistoryItem) {
                this.history.undoTransactionTo(this.deleteHistoryItem);
                delete this.deleteHistoryItem;
            }
            var pos = this.getPosition(evt, this.startShapePosition);
            var shape = this.model.findShape(this.shapeKey);
            ModelUtils_1.ModelUtils.setShapePosition(this.history, this.model, shape, pos);
            ModelUtils_1.ModelUtils.updateMovingShapeConnections(this.history, shape, this.connectorsWithoutBeginItemInfo, this.connectorsWithoutEndItemInfo, function () {
                _this.visualizerManager.resetConnectionTarget();
                _this.visualizerManager.resetConnectionPoints();
            }, function (shape, connectionPointIndex) {
                _this.visualizerManager.setConnectionTarget(shape, Event_1.MouseEventElementType.Shape);
                _this.visualizerManager.setConnectionPoints(shape, Event_1.MouseEventElementType.Shape, connectionPointIndex, true);
            }, function (connector) { return _this.handler.addInteractingItem(connector); });
            ModelUtils_1.ModelUtils.updateShapeAttachedConnectors(this.history, this.model, shape);
            var container = ModelUtils_1.ModelUtils.findContainerByEventKey(this.model, this.selection, evt.source.key);
            if (shape && container && this.allowInsertToContainer(evt, shape, container))
                ModelUtils_1.ModelUtils.insertToContainer(this.history, this.model, shape, container);
            else
                ModelUtils_1.ModelUtils.removeFromContainer(this.history, this.model, shape);
            if (this.updatePageSizeTimer === undefined)
                this.handler.tryUpdateModelSize(function (offsetLeft, offsetTop) {
                    _this.connectorsWithoutBeginItemInfo.forEach(function (pi) {
                        pi.point.x += offsetLeft;
                        pi.point.y += offsetTop;
                    });
                    _this.connectorsWithoutEndItemInfo.forEach(function (pi) {
                        pi.point.x += offsetLeft;
                        pi.point.y += offsetTop;
                    });
                });
        }
    };
    MouseHandlerToolboxDraggingState.prototype.onFinishWithChanges = function () {
        if (!this.deleteHistoryItem)
            this.history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(this.selection, [this.shapeKey]));
    };
    MouseHandlerToolboxDraggingState.prototype.onDragStart = function (evt) {
        this.dragging = evt;
        this.connectorsWithoutBeginItemInfo = ModelUtils_1.ModelUtils.getConnectorsWithoutBeginItemInfo(this.model);
        this.connectorsWithoutEndItemInfo = ModelUtils_1.ModelUtils.getConnectorsWithoutEndItemInfo(this.model);
    };
    MouseHandlerToolboxDraggingState.prototype.onDragEnd = function (evt) {
        if (this.shapeKey !== undefined && evt.source.type === Event_1.MouseEventElementType.Undefined)
            this.cancelChanges();
        this.handler.switchToDefaultState();
    };
    MouseHandlerToolboxDraggingState.prototype.finish = function () {
        this.visualizerManager.resetExtensionLines();
        this.visualizerManager.resetContainerTarget();
        this.visualizerManager.resetConnectionTarget();
        this.visualizerManager.resetConnectionPoints();
        this.processAndRemoveUpdatePageSizeTimer();
        this.dragging.onFinishDragging();
        _super.prototype.finish.call(this);
    };
    MouseHandlerToolboxDraggingState.prototype.insertToolboxItem = function (evt) {
        var description = this.shapeDescriptionManager.get(this.dragging.data);
        this.startShapePosition = this.getSnappedPoint(evt, new point_1.Point(evt.modelPoint.x - description.defaultSize.width / 2, evt.modelPoint.y - description.defaultSize.height / 2));
        var historyItem = new AddShapeHistoryItem_1.AddShapeHistoryItem(description, this.startShapePosition);
        this.history.addAndRedo(historyItem);
        ModelUtils_1.ModelUtils.updateNewShapeProperties(this.history, this.selection, historyItem.shapeKey);
        return historyItem.shapeKey;
    };
    MouseHandlerToolboxDraggingState.prototype.allowInsertToContainer = function (evt, item, container) {
        if (this.handler.canMultipleSelection(evt))
            return false;
        return container && container.expanded && ModelUtils_1.ModelUtils.canInsertToContainer(this.model, item, container);
    };
    MouseHandlerToolboxDraggingState.prototype.getPosition = function (evt, basePoint) {
        return this.getSnappedPoint(evt, new point_1.Point(basePoint.x + evt.modelPoint.x - this.startPoint.x, basePoint.y + evt.modelPoint.y - this.startPoint.y));
    };
    return MouseHandlerToolboxDraggingState;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerToolboxDraggingState = MouseHandlerToolboxDraggingState;


/***/ }),

/***/ 8461:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerZoomOnPinchState = void 0;
var Settings_1 = __webpack_require__(240);
var point_1 = __webpack_require__(8900);
var MouseHandlerScrollingState_1 = __webpack_require__(9582);
var metrics_1 = __webpack_require__(5596);
var PINCH_CHANGE_DISTANCE = 1;
var MouseHandlerZoomOnPinchState = (function (_super) {
    __extends(MouseHandlerZoomOnPinchState, _super);
    function MouseHandlerZoomOnPinchState(handler, selection, settings, view) {
        var _this = _super.call(this, handler, view, selection) || this;
        _this.selection = selection;
        _this.settings = settings;
        _this.view = view;
        return _this;
    }
    MouseHandlerZoomOnPinchState.prototype.onMouseDown = function (evt) {
        _super.prototype.onMouseDown.call(this, evt);
        if (evt.touches.length > 1) {
            this.startDistance = this.getTouchDistance(evt);
            this.startZoomLevel = this.settings.zoomLevel;
            this.prevDistance = this.startDistance;
        }
    };
    MouseHandlerZoomOnPinchState.prototype.onMouseMove = function (evt) {
        if (evt.touches.length > 1) {
            var distance = this.getTouchDistance(evt);
            if (Math.abs(this.prevDistance - distance) > PINCH_CHANGE_DISTANCE) {
                this.settings.zoomLevel = this.startZoomLevel * (distance / this.startDistance);
                this.view.scrollTo(this.getMiddleLayoutPoint(evt), this.getMiddleAbsPoint(evt));
                this.view.normalize();
                this.prevDistance = distance;
            }
        }
        _super.prototype.onMouseMove.call(this, evt);
    };
    MouseHandlerZoomOnPinchState.prototype.onMouseUp = function (evt) {
        if (evt.touches.length === 0)
            setTimeout(function () {
                this.handler.switchToDefaultState();
            }.bind(this), 1);
    };
    MouseHandlerZoomOnPinchState.prototype.start = function () {
        _super.prototype.start.call(this);
        this.settings.zoomLevel = this.view.getZoom();
        this.settings.autoZoom = Settings_1.AutoZoomMode.Disabled;
    };
    MouseHandlerZoomOnPinchState.prototype.getTouchDistance = function (evt) {
        var pt0 = new point_1.Point(evt.touches[0].offsetPoint.x, evt.touches[0].offsetPoint.y);
        var pt1 = new point_1.Point(evt.touches[1].offsetPoint.x, evt.touches[1].offsetPoint.y);
        return metrics_1.Metrics.euclideanDistance(pt0, pt1);
    };
    MouseHandlerZoomOnPinchState.prototype.getPointByEvent = function (evt) {
        return this.getMiddleAbsPoint(evt);
    };
    MouseHandlerZoomOnPinchState.prototype.getMiddleAbsPoint = function (evt) {
        if (evt.touches.length > 1)
            return MouseHandlerZoomOnPinchState.getMiddlePointByEvent(evt, function (touch) { return touch.offsetPoint; });
        return evt.offsetPoint;
    };
    MouseHandlerZoomOnPinchState.prototype.getMiddleLayoutPoint = function (evt) {
        if (evt.touches.length > 1)
            return MouseHandlerZoomOnPinchState.getMiddlePointByEvent(evt, function (touch) { return touch.modelPoint; });
        return evt.modelPoint;
    };
    MouseHandlerZoomOnPinchState.getMiddlePointByEvent = function (evt, getPoint) {
        if (evt.touches.length > 1)
            return new point_1.Point((getPoint(evt.touches[0]).x + getPoint(evt.touches[1]).x) / 2, (getPoint(evt.touches[0]).y + getPoint(evt.touches[1]).y) / 2);
    };
    return MouseHandlerZoomOnPinchState;
}(MouseHandlerScrollingState_1.MouseHandlerScrollingState));
exports.MouseHandlerZoomOnPinchState = MouseHandlerZoomOnPinchState;


/***/ }),

/***/ 7189:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerZoomOnWheelState = void 0;
var MouseHandlerStateBase_1 = __webpack_require__(5434);
var Event_1 = __webpack_require__(6031);
var Settings_1 = __webpack_require__(240);
var MouseHandlerZoomOnWheelState = (function (_super) {
    __extends(MouseHandlerZoomOnWheelState, _super);
    function MouseHandlerZoomOnWheelState(handler, settings, view) {
        var _this = _super.call(this, handler) || this;
        _this.settings = settings;
        _this.view = view;
        return _this;
    }
    MouseHandlerZoomOnWheelState.prototype.onMouseWheel = function (evt) {
        if (!this.trySwitchToDefault(evt)) {
            this.settings.zoomLevel = this.view.getNextStepZoom(evt.deltaY < 0);
            if (evt.source.type === Event_1.MouseEventElementType.Background)
                this.view.resetScroll();
            else {
                this.view.scrollTo(evt.modelPoint, evt.offsetPoint);
                this.view.normalize();
            }
            evt.preventDefault = true;
            return true;
        }
        else
            return this.handler.state.onMouseWheel(evt);
    };
    MouseHandlerZoomOnWheelState.prototype.onMouseUp = function (evt) {
        this.handler.switchToDefaultState();
        this.handler.state.onMouseUp(evt);
    };
    MouseHandlerZoomOnWheelState.prototype.onMouseDown = function (evt) {
        this.handler.switchToDefaultState();
        this.handler.state.onMouseDown(evt);
    };
    MouseHandlerZoomOnWheelState.prototype.onMouseMove = function (evt) {
        this.trySwitchToDefault(evt) && this.handler.state.onMouseMove(evt);
    };
    MouseHandlerZoomOnWheelState.prototype.trySwitchToDefault = function (evt) {
        if (this.handler.canFinishZoomOnWheel(evt)) {
            this.handler.switchToDefaultState();
            return true;
        }
        return false;
    };
    MouseHandlerZoomOnWheelState.prototype.start = function () {
        _super.prototype.start.call(this);
        this.settings.zoomLevel = this.view.getZoom();
        this.settings.autoZoom = Settings_1.AutoZoomMode.Disabled;
    };
    return MouseHandlerZoomOnWheelState;
}(MouseHandlerStateBase_1.MouseHandlerStateBase));
exports.MouseHandlerZoomOnWheelState = MouseHandlerZoomOnWheelState;


/***/ }),

/***/ 8376:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextInputHandler = void 0;
var ChangeShapeTextHistoryItem_1 = __webpack_require__(6516);
var Event_1 = __webpack_require__(6031);
var key_1 = __webpack_require__(2153);
var Shape_1 = __webpack_require__(5503);
var Connector_1 = __webpack_require__(7959);
var ChangeConnectorTextHistoryItem_1 = __webpack_require__(5144);
var TextInputHandler = (function () {
    function TextInputHandler(control) {
        this.control = control;
    }
    TextInputHandler.prototype.startTextInput = function (item, position) {
        if (item.isLocked || !item.enableText || !item.allowEditText || this.control.settings.readOnly || !this.canFinishTextEditing())
            return;
        this.control.beginUpdate();
        this.textInputItem = item;
        var allowed = true;
        if (this.textInputItem instanceof Shape_1.Shape) {
            var textRect = this.textInputItem.textEditRectangle;
            allowed = this.control.permissionsProvider.canChangeShapeText(this.textInputItem);
            if (allowed)
                this.control.eventManager.raiseTextInputStart(this.textInputItem, this.textInputItem.text, textRect.createPosition(), textRect.createSize());
        }
        else if (this.textInputItem instanceof Connector_1.Connector) {
            this.textInputPosition = position;
            allowed = this.control.permissionsProvider.canChangeConnectorText(this.textInputItem, this.textInputPosition);
            if (allowed)
                this.control.eventManager.raiseTextInputStart(this.textInputItem, this.textInputItem.getText(this.textInputPosition), this.textInputItem.getTextPoint(this.textInputPosition));
        }
        if (!allowed) {
            delete this.textInputItem;
            this.control.endUpdate();
        }
    };
    TextInputHandler.prototype.endTextInput = function (captureFocus) {
        var textInputItem = this.textInputItem;
        delete this.textInputItem;
        this.control.eventManager.raiseTextInputEnd(textInputItem, captureFocus);
        this.control.endUpdate();
        this.control.barManager.updateItemsState();
    };
    TextInputHandler.prototype.raiseTextInputPermissionsCheck = function (allowed) {
        this.control.eventManager.raiseTextInputPermissionsCheck(this.textInputItem, allowed);
    };
    TextInputHandler.prototype.applyTextInput = function (text, captureFocus) {
        if (!this.canFinishTextEditing(text))
            return;
        var textInputItem = this.textInputItem;
        var textInputPosition = this.textInputPosition;
        this.endTextInput(captureFocus);
        if (textInputItem instanceof Shape_1.Shape) {
            if (textInputItem.text !== text)
                this.control.history.addAndRedo(new ChangeShapeTextHistoryItem_1.ChangeShapeTextHistoryItem(textInputItem, text));
        }
        else if (textInputItem instanceof Connector_1.Connector)
            if (textInputItem.getText(textInputPosition) !== text)
                this.control.history.addAndRedo(new ChangeConnectorTextHistoryItem_1.ChangeConnectorTextHistoryItem(textInputItem, textInputPosition, text));
    };
    TextInputHandler.prototype.canFinishTextEditing = function (text) {
        var allowed = true;
        if (this.isTextInputActive()) {
            var newText = text || this.getTextInputElementValue();
            if (this.textInputItem instanceof Shape_1.Shape)
                allowed = this.control.permissionsProvider.canApplyShapeTextChange(this.textInputItem, newText);
            else if (this.textInputItem instanceof Connector_1.Connector)
                allowed = this.control.permissionsProvider.canApplyConnectorTextChange(this.textInputItem, this.textInputPosition, newText);
            this.raiseTextInputPermissionsCheck(allowed);
        }
        return allowed;
    };
    TextInputHandler.prototype.getTextInputElementValue = function () {
        if (this.control.render)
            return this.control.render.input.getTextInputElementValue();
        return "";
    };
    TextInputHandler.prototype.cancelTextInput = function () {
        this.raiseTextInputPermissionsCheck(true);
        this.endTextInput(true);
    };
    TextInputHandler.prototype.isTextInputActive = function () {
        return this.textInputItem !== undefined;
    };
    TextInputHandler.prototype.processDblClick = function (evt) {
        if (evt.source.type === Event_1.MouseEventElementType.Shape) {
            var shape = this.control.model.findShape(evt.source.key);
            this.startTextInput(shape);
        }
        else if (evt.source.type === Event_1.MouseEventElementType.Connector) {
            var connector = this.control.model.findConnector(evt.source.key);
            var position = connector.getTextPositionByPoint(evt.modelPoint);
            this.startTextInput(connector, position);
        }
        else if (evt.source.type === Event_1.MouseEventElementType.ConnectorText) {
            var connector = this.control.model.findConnector(evt.source.key);
            var position = parseFloat(evt.source.value);
            this.startTextInput(connector, position);
        }
    };
    TextInputHandler.prototype.onDblClick = function (evt) {
        var _this = this;
        setTimeout(function () {
            _this.processDblClick(evt);
        }, 10);
    };
    TextInputHandler.prototype.onKeyDown = function (evt) {
        if (!this.isTextInputActive())
            return;
        if (evt.keyCode === 13 && this.hasCtrlModifier(evt.modifiers)) {
            evt.preventDefault = true;
            this.applyTextInput(evt.inputText, true);
        }
        if (evt.keyCode === 27)
            this.cancelTextInput();
    };
    TextInputHandler.prototype.onBlur = function (evt) {
        if (this.isTextInputActive())
            this.applyTextInput(evt.inputText);
    };
    TextInputHandler.prototype.onFocus = function (evt) {
    };
    TextInputHandler.prototype.hasCtrlModifier = function (key) {
        return (key & key_1.ModifierKey.Ctrl) > 0;
    };
    return TextInputHandler;
}());
exports.TextInputHandler = TextInputHandler;


/***/ }),

/***/ 3541:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectionPointsVisualizer = exports.ConnectionPointInfo = void 0;
var ConnectionPointInfo = (function () {
    function ConnectionPointInfo(point, side) {
        this.point = point;
        this.side = side;
        this.allowed = true;
    }
    return ConnectionPointInfo;
}());
exports.ConnectionPointInfo = ConnectionPointInfo;
var ConnectionPointsVisualizer = (function () {
    function ConnectionPointsVisualizer(dispatcher) {
        this.dispatcher = dispatcher;
    }
    ConnectionPointsVisualizer.prototype.getKey = function () {
        return this.key;
    };
    ConnectionPointsVisualizer.prototype.setPoints = function (key, points, pointIndex, outsideRectangle) {
        if (this.key !== key || this.pointIndex !== pointIndex) {
            this.key = key;
            this.points = points;
            this.pointIndex = pointIndex;
            this.outsideRectangle = outsideRectangle;
            this.raiseShow();
        }
    };
    ConnectionPointsVisualizer.prototype.setPointIndex = function (pointIndex) {
        if (0 <= pointIndex && pointIndex < this.points.length && this.pointIndex !== pointIndex) {
            this.pointIndex = pointIndex;
            this.raiseShow();
        }
    };
    ConnectionPointsVisualizer.prototype.update = function () {
        this.raiseShow();
    };
    ConnectionPointsVisualizer.prototype.reset = function () {
        if (this.key !== "-1") {
            this.key = "-1";
            this.points = [];
            this.pointIndex = -1;
            this.outsideRectangle = undefined;
            this.raiseHide();
        }
    };
    ConnectionPointsVisualizer.prototype.raiseShow = function () {
        var _this = this;
        this.dispatcher.raise1(function (l) { return l.notifyConnectionPointsShow(_this.key, _this.points, _this.pointIndex, _this.outsideRectangle); });
    };
    ConnectionPointsVisualizer.prototype.raiseHide = function () {
        this.dispatcher.raise1(function (l) { return l.notifyConnectionPointsHide(); });
    };
    return ConnectionPointsVisualizer;
}());
exports.ConnectionPointsVisualizer = ConnectionPointsVisualizer;


/***/ }),

/***/ 3702:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectionTargetVisualizer = exports.ConnectionTargetInfo = void 0;
var TargetVisualizerBase_1 = __webpack_require__(3785);
var ConnectionTargetInfo = (function () {
    function ConnectionTargetInfo(rect, strokeWidth) {
        this.rect = rect;
        this.strokeWidth = strokeWidth;
        this.allowed = true;
    }
    return ConnectionTargetInfo;
}());
exports.ConnectionTargetInfo = ConnectionTargetInfo;
var ConnectionTargetVisualizer = (function (_super) {
    __extends(ConnectionTargetVisualizer, _super);
    function ConnectionTargetVisualizer(dispatcher) {
        return _super.call(this, dispatcher) || this;
    }
    ConnectionTargetVisualizer.prototype.raiseShow = function () {
        var _this = this;
        var info = new ConnectionTargetInfo(this.targetRect, this.targetStrokeWidth);
        this.dispatcher.raise1(function (l) { return l.notifyConnectionTargetShow(_this.key, info); });
    };
    ConnectionTargetVisualizer.prototype.raiseHide = function () {
        this.dispatcher.raise1(function (l) { return l.notifyConnectionTargetHide(); });
    };
    return ConnectionTargetVisualizer;
}(TargetVisualizerBase_1.TargetVisualizerBase));
exports.ConnectionTargetVisualizer = ConnectionTargetVisualizer;


/***/ }),

/***/ 9198:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContainerTargetVisualizer = exports.ContainerTargetInfo = void 0;
var TargetVisualizerBase_1 = __webpack_require__(3785);
var ContainerTargetInfo = (function () {
    function ContainerTargetInfo(rect, strokeWidth) {
        this.rect = rect;
        this.strokeWidth = strokeWidth;
    }
    return ContainerTargetInfo;
}());
exports.ContainerTargetInfo = ContainerTargetInfo;
var ContainerTargetVisualizer = (function (_super) {
    __extends(ContainerTargetVisualizer, _super);
    function ContainerTargetVisualizer(dispatcher) {
        return _super.call(this, dispatcher) || this;
    }
    ContainerTargetVisualizer.prototype.raiseShow = function () {
        var _this = this;
        var info = new ContainerTargetInfo(this.targetRect, this.targetStrokeWidth);
        this.dispatcher.raise1(function (l) { return l.notifyContainerTargetShow(_this.key, info); });
    };
    ContainerTargetVisualizer.prototype.raiseHide = function () {
        this.dispatcher.raise1(function (l) { return l.notifyContainerTargetHide(); });
    };
    return ContainerTargetVisualizer;
}(TargetVisualizerBase_1.TargetVisualizerBase));
exports.ContainerTargetVisualizer = ContainerTargetVisualizer;


/***/ }),

/***/ 371:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExtensionLinesVisualizer = exports.ExtensionLine = exports.ExtensionLineType = void 0;
var ExtensionLineType;
(function (ExtensionLineType) {
    ExtensionLineType[ExtensionLineType["LeftToLeftAbove"] = 0] = "LeftToLeftAbove";
    ExtensionLineType[ExtensionLineType["LeftToLeftBelow"] = 1] = "LeftToLeftBelow";
    ExtensionLineType[ExtensionLineType["RightToRightAbove"] = 2] = "RightToRightAbove";
    ExtensionLineType[ExtensionLineType["RightToRightBelow"] = 3] = "RightToRightBelow";
    ExtensionLineType[ExtensionLineType["LeftToRightAbove"] = 4] = "LeftToRightAbove";
    ExtensionLineType[ExtensionLineType["LeftToRightBelow"] = 5] = "LeftToRightBelow";
    ExtensionLineType[ExtensionLineType["RightToLeftAbove"] = 6] = "RightToLeftAbove";
    ExtensionLineType[ExtensionLineType["RightToLeftBelow"] = 7] = "RightToLeftBelow";
    ExtensionLineType[ExtensionLineType["TopToTopBefore"] = 8] = "TopToTopBefore";
    ExtensionLineType[ExtensionLineType["TopToTopAfter"] = 9] = "TopToTopAfter";
    ExtensionLineType[ExtensionLineType["BottomToBottomBefore"] = 10] = "BottomToBottomBefore";
    ExtensionLineType[ExtensionLineType["BottomToBottomAfter"] = 11] = "BottomToBottomAfter";
    ExtensionLineType[ExtensionLineType["TopToBottomBefore"] = 12] = "TopToBottomBefore";
    ExtensionLineType[ExtensionLineType["TopToBottomAfter"] = 13] = "TopToBottomAfter";
    ExtensionLineType[ExtensionLineType["BottomToTopBefore"] = 14] = "BottomToTopBefore";
    ExtensionLineType[ExtensionLineType["BottomToTopAfter"] = 15] = "BottomToTopAfter";
    ExtensionLineType[ExtensionLineType["HorizontalCenterAbove"] = 16] = "HorizontalCenterAbove";
    ExtensionLineType[ExtensionLineType["HorizontalCenterBelow"] = 17] = "HorizontalCenterBelow";
    ExtensionLineType[ExtensionLineType["VerticalCenterBefore"] = 18] = "VerticalCenterBefore";
    ExtensionLineType[ExtensionLineType["VerticalCenterAfter"] = 19] = "VerticalCenterAfter";
    ExtensionLineType[ExtensionLineType["VerticalCenterToPageCenter"] = 20] = "VerticalCenterToPageCenter";
    ExtensionLineType[ExtensionLineType["HorizontalCenterToPageCenter"] = 21] = "HorizontalCenterToPageCenter";
    ExtensionLineType[ExtensionLineType["LeftToPageCenter"] = 22] = "LeftToPageCenter";
    ExtensionLineType[ExtensionLineType["RightToPageCenter"] = 23] = "RightToPageCenter";
    ExtensionLineType[ExtensionLineType["TopToPageCenter"] = 24] = "TopToPageCenter";
    ExtensionLineType[ExtensionLineType["BottomToPageCenter"] = 25] = "BottomToPageCenter";
})(ExtensionLineType = exports.ExtensionLineType || (exports.ExtensionLineType = {}));
var ExtensionLine = (function () {
    function ExtensionLine(type, segment, text) {
        this.type = type;
        this.segment = segment;
        this.text = text;
    }
    return ExtensionLine;
}());
exports.ExtensionLine = ExtensionLine;
var ExtensionLinesVisualizer = (function () {
    function ExtensionLinesVisualizer(dispatcher) {
        this.dispatcher = dispatcher;
        this.lines = [];
        this.lineIndexByType = {};
    }
    ExtensionLinesVisualizer.prototype.addSegment = function (type, segment, text) {
        var curIndex = this.lineIndexByType[type];
        if (curIndex === undefined) {
            var line = new ExtensionLine(type, segment, text);
            var index = this.lines.push(line);
            this.lineIndexByType[line.type] = index - 1;
            this.raiseShow();
        }
        else if (segment.length < this.lines[curIndex].segment.length) {
            var line = new ExtensionLine(type, segment, text);
            this.lines.splice(curIndex, 1, line);
            this.raiseShow();
        }
    };
    ExtensionLinesVisualizer.prototype.update = function () {
        this.raiseShow();
    };
    ExtensionLinesVisualizer.prototype.reset = function () {
        if (this.lines.length) {
            this.lines = [];
            this.lineIndexByType = {};
            this.raiseHide();
        }
    };
    ExtensionLinesVisualizer.prototype.raiseShow = function () {
        var _this = this;
        this.dispatcher.raise1(function (l) { return l.notifyExtensionLinesShow(_this.lines); });
    };
    ExtensionLinesVisualizer.prototype.raiseHide = function () {
        this.dispatcher.raise1(function (l) { return l.notifyExtensionLinesHide(); });
    };
    return ExtensionLinesVisualizer;
}());
exports.ExtensionLinesVisualizer = ExtensionLinesVisualizer;


/***/ }),

/***/ 6569:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ResizeInfoVisualizer = void 0;
var ResizeInfoVisualizer = (function () {
    function ResizeInfoVisualizer(dispatcher) {
        this.dispatcher = dispatcher;
    }
    ResizeInfoVisualizer.prototype.set = function (point, text) {
        this.point = point;
        this.text = text;
        this.raiseShow();
    };
    ResizeInfoVisualizer.prototype.reset = function () {
        if (this.point !== undefined) {
            this.point = undefined;
            this.text = undefined;
            this.raiseHide();
        }
    };
    ResizeInfoVisualizer.prototype.raiseShow = function () {
        var _this = this;
        this.dispatcher.raise1(function (l) { return l.notifyResizeInfoShow(_this.point, _this.text); });
    };
    ResizeInfoVisualizer.prototype.raiseHide = function () {
        this.dispatcher.raise1(function (l) { return l.notifyResizeInfoHide(); });
    };
    return ResizeInfoVisualizer;
}());
exports.ResizeInfoVisualizer = ResizeInfoVisualizer;


/***/ }),

/***/ 4753:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SelectionRectVisualizer = void 0;
var SelectionRectVisualizer = (function () {
    function SelectionRectVisualizer(dispatcher) {
        this.dispatcher = dispatcher;
    }
    SelectionRectVisualizer.prototype.setRectangle = function (rect) {
        this.rect = rect;
        this.raiseShow();
    };
    SelectionRectVisualizer.prototype.reset = function () {
        this.rect = undefined;
        this.raiseHide();
    };
    SelectionRectVisualizer.prototype.raiseShow = function () {
        var _this = this;
        this.dispatcher.raise1(function (l) { return l.notifySelectionRectShow(_this.rect); });
    };
    SelectionRectVisualizer.prototype.raiseHide = function () {
        this.dispatcher.raise1(function (l) { return l.notifySelectionRectHide(); });
    };
    return SelectionRectVisualizer;
}());
exports.SelectionRectVisualizer = SelectionRectVisualizer;


/***/ }),

/***/ 3785:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TargetVisualizerBase = void 0;
var TargetVisualizerBase = (function () {
    function TargetVisualizerBase(dispatcher) {
        this.dispatcher = dispatcher;
    }
    TargetVisualizerBase.prototype.getKey = function () {
        return this.key;
    };
    TargetVisualizerBase.prototype.setTargetRect = function (key, targetRect, targetStrokeWidth) {
        if (this.key !== key) {
            this.key = key;
            this.targetRect = targetRect;
            this.targetStrokeWidth = targetStrokeWidth;
            this.raiseShow();
        }
    };
    TargetVisualizerBase.prototype.reset = function () {
        if (this.key !== "-1") {
            this.key = "-1";
            this.targetRect = undefined;
            this.targetStrokeWidth = 0;
            this.raiseHide();
        }
    };
    return TargetVisualizerBase;
}());
exports.TargetVisualizerBase = TargetVisualizerBase;


/***/ }),

/***/ 7733:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.VisualizerManager = void 0;
var ConnectionTargetVisualizer_1 = __webpack_require__(3702);
var ContainerTargetVisualizer_1 = __webpack_require__(9198);
var ExtensionLinesVisualizer_1 = __webpack_require__(371);
var Event_1 = __webpack_require__(6031);
var ConnectionPointsVisualizer_1 = __webpack_require__(3541);
var Shape_1 = __webpack_require__(5503);
var Utils_1 = __webpack_require__(8675);
var segment_1 = __webpack_require__(1335);
var point_1 = __webpack_require__(8900);
var CanvasSelectionManager_1 = __webpack_require__(4000);
var ModelUtils_1 = __webpack_require__(4867);
var ResizeInfoVisualizer_1 = __webpack_require__(6569);
var SelectionRectVisualizer_1 = __webpack_require__(4753);
var batch_updatable_1 = __webpack_require__(1772);
var LocalizationService_1 = __webpack_require__(6224);
var VisualizerManager = (function (_super) {
    __extends(VisualizerManager, _super);
    function VisualizerManager(selection, model, eventManager, settings, readOnly) {
        if (readOnly === void 0) { readOnly = settings.readOnly; }
        var _this = _super.call(this) || this;
        _this.selection = selection;
        _this.model = model;
        _this.eventManager = eventManager;
        _this.settings = settings;
        _this.readOnly = readOnly;
        _this.onVisualizersUpdate = new Utils_1.EventDispatcher();
        _this.connectionPointsVisualizer = new ConnectionPointsVisualizer_1.ConnectionPointsVisualizer(_this.onVisualizersUpdate);
        _this.connectionPointsVisualizer = new ConnectionPointsVisualizer_1.ConnectionPointsVisualizer(_this.onVisualizersUpdate);
        _this.connectionTargetVisualizer = new ConnectionTargetVisualizer_1.ConnectionTargetVisualizer(_this.onVisualizersUpdate);
        _this.containerTargetVisualizer = new ContainerTargetVisualizer_1.ContainerTargetVisualizer(_this.onVisualizersUpdate);
        _this.extensionLinesVisualizer = new ExtensionLinesVisualizer_1.ExtensionLinesVisualizer(_this.onVisualizersUpdate);
        _this.resizeInfoVisualizer = new ResizeInfoVisualizer_1.ResizeInfoVisualizer(_this.onVisualizersUpdate);
        _this.selectionRectangleVisualizer = new SelectionRectVisualizer_1.SelectionRectVisualizer(_this.onVisualizersUpdate);
        return _this;
    }
    VisualizerManager.prototype.initialize = function (model) {
        this.model = model;
    };
    VisualizerManager.prototype.onMouseDown = function (evt) {
    };
    VisualizerManager.prototype.onMouseUp = function (evt) {
    };
    VisualizerManager.prototype.onMouseEnter = function (evt) {
    };
    VisualizerManager.prototype.onMouseLeave = function (evt) {
        this.resetConnectionPoints();
        this.resetConnectionTarget();
        this.resetExtensionLines();
        this.resetContainerTarget();
        this.resetResizeInfo();
        this.resetSelectionRectangle();
    };
    VisualizerManager.prototype.onBlur = function (evt) {
    };
    VisualizerManager.prototype.onFocus = function (evt) {
    };
    VisualizerManager.prototype.updateConnections = function (item, type, value) {
        var pointIndex = -1;
        if (value && type === Event_1.MouseEventElementType.ShapeConnectionPoint)
            pointIndex = parseInt(value);
        var preventShowOutside = item && ((!item.allowResizeHorizontally && !item.allowResizeVertically) || item.isLocked);
        this.setConnectionPoints(item, type, pointIndex, preventShowOutside);
    };
    VisualizerManager.prototype.setConnectionPoints = function (item, type, pointIndex, preventShowOutside) {
        if (!this.eventManager.isFocused())
            return;
        if (item && (type === Event_1.MouseEventElementType.Shape || type === Event_1.MouseEventElementType.ShapeResizeBox ||
            type === Event_1.MouseEventElementType.ShapeConnectionPoint) && item !== undefined) {
            var key = item.key;
            var isSelected = this.selection.hasKey(key);
            var points = item.getConnectionPoints();
            this.connectionPointsVisualizer.setPoints(key, points.map(function (pt) { return new ConnectionPointsVisualizer_1.ConnectionPointInfo(pt, item.getConnectionPointSide(pt)); }), pointIndex, isSelected && !preventShowOutside && item.rectangle);
        }
        else
            this.connectionPointsVisualizer.reset();
    };
    VisualizerManager.prototype.setConnectionPointIndex = function (index) {
        this.connectionPointsVisualizer.setPointIndex(index);
    };
    VisualizerManager.prototype.updateConnectionPoints = function () {
        var item = this.model.findItem(this.connectionPointsVisualizer.getKey());
        if (item !== undefined)
            this.connectionPointsVisualizer.update();
        else
            this.connectionPointsVisualizer.reset();
    };
    VisualizerManager.prototype.resetConnectionPoints = function () {
        this.connectionPointsVisualizer.reset();
    };
    VisualizerManager.prototype.setConnectionTarget = function (item, type) {
        if (item && (type === Event_1.MouseEventElementType.Shape ||
            type === Event_1.MouseEventElementType.ShapeConnectionPoint))
            this.connectionTargetVisualizer.setTargetRect(item.key, item.rectangle, item.strokeWidth);
        else
            this.connectionTargetVisualizer.reset();
    };
    VisualizerManager.prototype.resetConnectionTarget = function () {
        this.connectionTargetVisualizer.reset();
    };
    VisualizerManager.prototype.setContainerTarget = function (item, type) {
        if (item && !item.isLocked && (type === Event_1.MouseEventElementType.Shape) && item.enableChildren)
            this.containerTargetVisualizer.setTargetRect(item.key, item.rectangle, item.strokeWidth);
        else
            this.containerTargetVisualizer.reset();
    };
    VisualizerManager.prototype.resetContainerTarget = function () {
        this.containerTargetVisualizer.reset();
    };
    VisualizerManager.prototype.setExtensionLines = function (items) {
        var _this = this;
        if (!this.eventManager.isFocused())
            return;
        this.extensionLinesVisualizer.reset();
        var rect = ModelUtils_1.ModelUtils.createRectangle(items.filter(function (item) { return item; }));
        this.addPageExtensionLines(rect);
        this.model.items.forEach(function (item) {
            if (items.indexOf(item) > -1)
                return;
            if (item instanceof Shape_1.Shape)
                _this.addShapeExtensionLines(item, rect);
        });
    };
    VisualizerManager.prototype.addPageExtensionLines = function (rect) {
        var horPages = Math.round(this.model.size.width / this.model.pageWidth);
        var verPages = Math.round(this.model.size.height / this.model.pageHeight);
        for (var i = 0; i < horPages; i++)
            for (var j = 0; j < verPages; j++) {
                var center = new point_1.Point(i * this.model.pageWidth + this.model.pageWidth / 2, j * this.model.pageHeight + this.model.pageHeight / 2);
                if (Math.abs(rect.center.x - center.x) < this.settings.gridSize / 2) {
                    var segment = new segment_1.Segment(new point_1.Point(rect.center.x, 0), new point_1.Point(rect.center.x, this.model.size.height));
                    this.extensionLinesVisualizer.addSegment(ExtensionLinesVisualizer_1.ExtensionLineType.HorizontalCenterToPageCenter, segment, "");
                }
                if (Math.abs(rect.center.y - center.y) < this.settings.gridSize / 2) {
                    var segment = new segment_1.Segment(new point_1.Point(0, rect.center.y), new point_1.Point(this.model.size.width, rect.center.y));
                    this.extensionLinesVisualizer.addSegment(ExtensionLinesVisualizer_1.ExtensionLineType.VerticalCenterToPageCenter, segment, "");
                }
                if (Math.abs(rect.x - center.x) < this.settings.gridSize / 2) {
                    var segment = new segment_1.Segment(new point_1.Point(rect.x, 0), new point_1.Point(rect.x, this.model.size.height));
                    this.extensionLinesVisualizer.addSegment(ExtensionLinesVisualizer_1.ExtensionLineType.LeftToPageCenter, segment, "");
                }
                if (Math.abs(rect.y - center.y) < this.settings.gridSize / 2) {
                    var segment = new segment_1.Segment(new point_1.Point(0, rect.y), new point_1.Point(this.model.size.width, rect.y));
                    this.extensionLinesVisualizer.addSegment(ExtensionLinesVisualizer_1.ExtensionLineType.TopToPageCenter, segment, "");
                }
                if (Math.abs(rect.right - center.x) < this.settings.gridSize / 2) {
                    var segment = new segment_1.Segment(new point_1.Point(rect.right, 0), new point_1.Point(rect.right, this.model.size.height));
                    this.extensionLinesVisualizer.addSegment(ExtensionLinesVisualizer_1.ExtensionLineType.RightToPageCenter, segment, "");
                }
                if (Math.abs(rect.bottom - center.y) < this.settings.gridSize / 2) {
                    var segment = new segment_1.Segment(new point_1.Point(0, rect.bottom), new point_1.Point(this.model.size.width, rect.bottom));
                    this.extensionLinesVisualizer.addSegment(ExtensionLinesVisualizer_1.ExtensionLineType.BottomToPageCenter, segment, "");
                }
            }
    };
    VisualizerManager.prototype.addShapeExtensionLines = function (shape, rect) {
        var sRect = shape.rectangle;
        var lwCor = shape.strokeWidth - CanvasSelectionManager_1.CanvasSelectionManager.extensionLineWidth;
        var showDistance = true;
        var x1nc;
        var y1nc;
        var x2nc;
        var y2nc;
        var x1;
        var y1;
        var x2;
        var y2;
        if (rect.right < sRect.x) {
            x1nc = rect.right;
            x2nc = sRect.x;
            x1 = x1nc + lwCor + CanvasSelectionManager_1.CanvasSelectionManager.extensionLineOffset;
            x2 = x2nc - CanvasSelectionManager_1.CanvasSelectionManager.extensionLineOffset;
        }
        else if (rect.x > sRect.right) {
            x1nc = rect.x;
            x2nc = sRect.right;
            x1 = x1nc - CanvasSelectionManager_1.CanvasSelectionManager.extensionLineOffset;
            x2 = x2nc + lwCor + CanvasSelectionManager_1.CanvasSelectionManager.extensionLineOffset;
        }
        if (rect.bottom < sRect.y) {
            y1nc = rect.bottom;
            y2nc = sRect.y;
            y1 = y1nc + lwCor + CanvasSelectionManager_1.CanvasSelectionManager.extensionLineOffset;
            y2 = y2nc - CanvasSelectionManager_1.CanvasSelectionManager.extensionLineOffset;
        }
        else if (rect.y > sRect.bottom) {
            y1nc = rect.y;
            y2nc = sRect.bottom;
            y1 = y1nc - CanvasSelectionManager_1.CanvasSelectionManager.extensionLineOffset;
            y2 = y2nc + lwCor + CanvasSelectionManager_1.CanvasSelectionManager.extensionLineOffset;
        }
        if (x1 !== undefined && x2 !== undefined) {
            var distanceText = this.getViewUnitText(Math.abs(x1nc - x2nc));
            if (rect.center.y === sRect.center.y) {
                var segment = new segment_1.Segment(new point_1.Point(x1, rect.center.y), new point_1.Point(x2, sRect.center.y));
                this.extensionLinesVisualizer.addSegment(x1 > x2 ? ExtensionLinesVisualizer_1.ExtensionLineType.VerticalCenterAfter : ExtensionLinesVisualizer_1.ExtensionLineType.VerticalCenterBefore, segment, showDistance ? distanceText : "");
                showDistance = false;
            }
            if (rect.y === sRect.y) {
                var segment = new segment_1.Segment(new point_1.Point(x1, rect.y), new point_1.Point(x2, sRect.y));
                this.extensionLinesVisualizer.addSegment(x1 > x2 ? ExtensionLinesVisualizer_1.ExtensionLineType.TopToTopAfter : ExtensionLinesVisualizer_1.ExtensionLineType.TopToTopBefore, segment, showDistance ? distanceText : "");
            }
            if (rect.bottom === sRect.bottom) {
                var segment = new segment_1.Segment(new point_1.Point(x1, rect.bottom + lwCor), new point_1.Point(x2, sRect.bottom + lwCor));
                this.extensionLinesVisualizer.addSegment(x1 > x2 ? ExtensionLinesVisualizer_1.ExtensionLineType.BottomToBottomAfter : ExtensionLinesVisualizer_1.ExtensionLineType.BottomToBottomBefore, segment, showDistance ? distanceText : "");
            }
            if (rect.y === sRect.bottom) {
                var segment = new segment_1.Segment(new point_1.Point(x1, rect.y), new point_1.Point(x2, sRect.bottom + lwCor));
                this.extensionLinesVisualizer.addSegment(x1 > x2 ? ExtensionLinesVisualizer_1.ExtensionLineType.TopToBottomAfter : ExtensionLinesVisualizer_1.ExtensionLineType.TopToBottomBefore, segment, showDistance ? distanceText : "");
            }
            if (rect.bottom === sRect.y) {
                var segment = new segment_1.Segment(new point_1.Point(x1, rect.bottom + lwCor), new point_1.Point(x2, sRect.y));
                this.extensionLinesVisualizer.addSegment(x1 > x2 ? ExtensionLinesVisualizer_1.ExtensionLineType.BottomToTopAfter : ExtensionLinesVisualizer_1.ExtensionLineType.BottomToTopBefore, segment, showDistance ? distanceText : "");
            }
        }
        if (y1 !== undefined && y2 !== undefined) {
            var distanceText = this.getViewUnitText(Math.abs(y1nc - y2nc));
            if (rect.center.x === sRect.center.x) {
                var segment = new segment_1.Segment(new point_1.Point(rect.center.x, y1), new point_1.Point(sRect.center.x, y2));
                this.extensionLinesVisualizer.addSegment(y1 > y2 ? ExtensionLinesVisualizer_1.ExtensionLineType.HorizontalCenterBelow : ExtensionLinesVisualizer_1.ExtensionLineType.HorizontalCenterAbove, segment, showDistance ? distanceText : "");
                showDistance = false;
            }
            if (rect.x === sRect.x) {
                var segment = new segment_1.Segment(new point_1.Point(rect.x, y1), new point_1.Point(sRect.x, y2));
                this.extensionLinesVisualizer.addSegment(y1 > y2 ? ExtensionLinesVisualizer_1.ExtensionLineType.LeftToLeftBelow : ExtensionLinesVisualizer_1.ExtensionLineType.LeftToLeftAbove, segment, showDistance ? distanceText : "");
            }
            if (rect.right === sRect.right) {
                var segment = new segment_1.Segment(new point_1.Point(rect.right + lwCor, y1), new point_1.Point(sRect.right + lwCor, y2));
                this.extensionLinesVisualizer.addSegment(y1 > y2 ? ExtensionLinesVisualizer_1.ExtensionLineType.RightToRightBelow : ExtensionLinesVisualizer_1.ExtensionLineType.RightToRightAbove, segment, showDistance ? distanceText : "");
            }
            if (rect.x === sRect.right) {
                var segment = new segment_1.Segment(new point_1.Point(rect.x, y1), new point_1.Point(sRect.right + lwCor, y2));
                this.extensionLinesVisualizer.addSegment(y1 > y2 ? ExtensionLinesVisualizer_1.ExtensionLineType.LeftToRightBelow : ExtensionLinesVisualizer_1.ExtensionLineType.LeftToRightAbove, segment, showDistance ? distanceText : "");
            }
            if (rect.right === sRect.x) {
                var segment = new segment_1.Segment(new point_1.Point(rect.right + lwCor, y1), new point_1.Point(sRect.x, y2));
                this.extensionLinesVisualizer.addSegment(y1 > y2 ? ExtensionLinesVisualizer_1.ExtensionLineType.RightToLeftBelow : ExtensionLinesVisualizer_1.ExtensionLineType.RightToLeftAbove, segment, showDistance ? distanceText : "");
            }
        }
    };
    VisualizerManager.prototype.resetExtensionLines = function () {
        this.extensionLinesVisualizer.reset();
    };
    VisualizerManager.prototype.setResizeInfo = function (items) {
        var rect = ModelUtils_1.ModelUtils.createRectangle(items);
        var point = new point_1.Point(rect.center.x, rect.bottom + CanvasSelectionManager_1.CanvasSelectionManager.resizeInfoOffset);
        var text = this.getViewUnitText(rect.width) + " x " + this.getViewUnitText(rect.height);
        this.resizeInfoVisualizer.set(point, text);
    };
    VisualizerManager.prototype.resetResizeInfo = function () {
        this.resizeInfoVisualizer.reset();
    };
    VisualizerManager.prototype.setSelectionRectangle = function (rect) {
        this.selectionRectangleVisualizer.setRectangle(rect);
    };
    VisualizerManager.prototype.resetSelectionRectangle = function () {
        this.selectionRectangleVisualizer.reset();
    };
    VisualizerManager.prototype.getViewUnitText = function (value) {
        return ModelUtils_1.ModelUtils.getUnitText(this.settings.viewUnits, LocalizationService_1.DiagramLocalizationService.unitItems, LocalizationService_1.DiagramLocalizationService.formatUnit, value);
    };
    VisualizerManager.prototype.notifyReadOnlyChanged = function (readOnly) {
        this.readOnly = readOnly;
        if (this.readOnly) {
            this.resetConnectionPoints();
            this.resetConnectionTarget();
            this.resetExtensionLines();
            this.resetContainerTarget();
            this.resetResizeInfo();
            this.resetSelectionRectangle();
        }
    };
    VisualizerManager.prototype.notifyDragStart = function (itemKeys) { };
    VisualizerManager.prototype.notifyDragEnd = function (itemKeys) { };
    VisualizerManager.prototype.notifyDragScrollStart = function () { };
    VisualizerManager.prototype.notifyDragScrollEnd = function () { };
    VisualizerManager.prototype.onUpdateUnlocked = function (occurredEvents) { };
    return VisualizerManager;
}(batch_updatable_1.BatchUpdatableObject));
exports.VisualizerManager = VisualizerManager;


/***/ }),

/***/ 7459:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.VisualizerTouchManager = void 0;
var VisualizersManager_1 = __webpack_require__(7733);
var Event_1 = __webpack_require__(6031);
var SELECTION_CHANGED_EVENT = 1;
var VisualizerTouchManager = (function (_super) {
    __extends(VisualizerTouchManager, _super);
    function VisualizerTouchManager(selection, model, eventManager, settings, readOnly) {
        if (readOnly === void 0) { readOnly = settings.readOnly; }
        var _this = _super.call(this, selection, model, eventManager, settings, readOnly) || this;
        selection.onChanged.add(_this);
        return _this;
    }
    VisualizerTouchManager.prototype.onBlur = function (evt) {
        var _this = this;
        setTimeout(function () { _this.hideConnections(); }, 1);
    };
    VisualizerTouchManager.prototype.onFocus = function (evt) {
        var _this = this;
        setTimeout(function () { _this.showConnections(); }, 1);
    };
    VisualizerTouchManager.prototype.hideConnections = function () {
        if (this.readOnly)
            return;
        this.resetConnectionPoints();
    };
    VisualizerTouchManager.prototype.showConnections = function () {
        if (this.readOnly)
            return;
        if (this.needShowConnections()) {
            var shapes = this.selection.getSelectedShapes();
            if (shapes.length === 1)
                this.setConnectionPoints(shapes[0], Event_1.MouseEventElementType.ShapeConnectionPoint, -1, (!shapes[0].allowResizeHorizontally && !shapes[0].allowResizeVertically) || shapes[0].isLocked);
        }
    };
    VisualizerTouchManager.prototype.needShowConnections = function () {
        var items = this.selection.getSelectedItems();
        var shapes = this.selection.getSelectedShapes();
        return (items.length === 1 && shapes.length === 1);
    };
    VisualizerTouchManager.prototype.notifySelectionChanged = function (selection) {
        if (this.isUpdateLocked())
            this.registerOccurredEvent(SELECTION_CHANGED_EVENT);
        else
            this.raiseSelectionChanged();
    };
    VisualizerTouchManager.prototype.raiseSelectionChanged = function () {
        if (this.needShowConnections())
            this.showConnections();
        else
            this.hideConnections();
    };
    VisualizerTouchManager.prototype.onUpdateUnlocked = function (occurredEvents) {
        if (occurredEvents & SELECTION_CHANGED_EVENT)
            this.raiseSelectionChanged();
    };
    VisualizerTouchManager.prototype.notifyDragStart = function (itemKeys) {
        this.hideConnections();
    };
    VisualizerTouchManager.prototype.notifyDragEnd = function (itemKeys) {
        this.showConnections();
    };
    return VisualizerTouchManager;
}(VisualizersManager_1.VisualizerManager));
exports.VisualizerTouchManager = VisualizerTouchManager;


/***/ }),

/***/ 3477:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetConnectionPointIndexHistoryItem = exports.AddConnectionHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var Connector_1 = __webpack_require__(7959);
var AddConnectionHistoryItem = (function (_super) {
    __extends(AddConnectionHistoryItem, _super);
    function AddConnectionHistoryItem(connector, item, connectionPointIndex, position) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.itemKey = item.key;
        _this.connectionPointIndex = connectionPointIndex;
        _this.position = position;
        return _this;
    }
    AddConnectionHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.addConnection(connector, item, this.connectionPointIndex, this.position);
    };
    AddConnectionHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.deleteConnection(connector, this.position);
    };
    return AddConnectionHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.AddConnectionHistoryItem = AddConnectionHistoryItem;
var SetConnectionPointIndexHistoryItem = (function (_super) {
    __extends(SetConnectionPointIndexHistoryItem, _super);
    function SetConnectionPointIndexHistoryItem(connector, connectionPointIndex, position) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.connectionPointIndex = connectionPointIndex;
        _this.position = position;
        return _this;
    }
    SetConnectionPointIndexHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldConnectionPointIndex = this.position === Connector_1.ConnectorPosition.Begin ? connector.beginConnectionPointIndex : connector.endConnectionPointIndex;
        manipulator.setConnectionPointIndex(connector, this.connectionPointIndex, this.position);
    };
    SetConnectionPointIndexHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.setConnectionPointIndex(connector, this.oldConnectionPointIndex, this.position);
    };
    return SetConnectionPointIndexHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.SetConnectionPointIndexHistoryItem = SetConnectionPointIndexHistoryItem;


/***/ }),

/***/ 9603:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AddConnectorHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var Connector_1 = __webpack_require__(7959);
var AddConnectorHistoryItem = (function (_super) {
    __extends(AddConnectorHistoryItem, _super);
    function AddConnectorHistoryItem(points, dataKey, renderPointsContext) {
        var _this = _super.call(this) || this;
        _this.points = points;
        _this.dataKey = dataKey;
        _this.renderPointsContext = renderPointsContext;
        return _this;
    }
    AddConnectorHistoryItem.prototype.redo = function (manipulator) {
        var connector = new Connector_1.Connector(this.points);
        if (this.dataKey !== undefined)
            connector.dataKey = this.dataKey;
        if (this.renderPointsContext !== undefined)
            connector.replaceRenderPoints(this.renderPointsContext);
        manipulator.addConnector(connector, this.connectorKey);
        this.connectorKey = connector.key;
    };
    AddConnectorHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.deleteConnector(connector);
    };
    return AddConnectorHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.AddConnectorHistoryItem = AddConnectorHistoryItem;


/***/ }),

/***/ 4430:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AddConnectorPointHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var AddConnectorPointHistoryItem = (function (_super) {
    __extends(AddConnectorPointHistoryItem, _super);
    function AddConnectorPointHistoryItem(connectorKey, pointIndex, point) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        _this.pointIndex = pointIndex;
        _this.point = point;
        return _this;
    }
    AddConnectorPointHistoryItem.prototype.redo = function (manipulator) {
        var _this = this;
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.renderContext = connector.tryCreateRenderPointsContext();
        manipulator.addDeleteConnectorPoint(connector, function (connector) {
            connector.addPoint(_this.pointIndex, _this.point);
            connector.onAddPoint(_this.pointIndex, _this.point);
        });
    };
    AddConnectorPointHistoryItem.prototype.undo = function (manipulator) {
        var _this = this;
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.addDeleteConnectorPoint(connector, function (connector) {
            connector.deletePoint(_this.pointIndex);
            connector.replaceRenderPoints(_this.renderContext);
        });
    };
    return AddConnectorPointHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.AddConnectorPointHistoryItem = AddConnectorPointHistoryItem;


/***/ }),

/***/ 4145:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AddShapeHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var Shape_1 = __webpack_require__(5503);
var AddShapeHistoryItem = (function (_super) {
    __extends(AddShapeHistoryItem, _super);
    function AddShapeHistoryItem(shapeDescription, position, text, dataKey) {
        var _this = _super.call(this) || this;
        _this.shapeDescription = shapeDescription;
        _this.position = position;
        _this.text = text;
        _this.dataKey = dataKey;
        return _this;
    }
    AddShapeHistoryItem.prototype.redo = function (manipulator) {
        var shape = new Shape_1.Shape(this.shapeDescription, this.position);
        if (typeof this.text === "string")
            shape.text = this.text;
        if (this.dataKey !== undefined)
            shape.dataKey = this.dataKey;
        manipulator.addShape(shape, this.shapeKey);
        this.shapeKey = shape.key;
    };
    AddShapeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.deleteShape(manipulator.model.findShape(this.shapeKey), true);
    };
    return AddShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.AddShapeHistoryItem = AddShapeHistoryItem;


/***/ }),

/***/ 58:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ReplaceConnectorPointsHistoryItem = exports.ChangeConnectorPointsHistoryItem = exports.UpdateConnectorPointsHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var UpdateConnectorPointsHistoryItem = (function (_super) {
    __extends(UpdateConnectorPointsHistoryItem, _super);
    function UpdateConnectorPointsHistoryItem(connectorKey, newPoints) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        _this.newPoints = newPoints;
        return _this;
    }
    UpdateConnectorPointsHistoryItem.prototype.redo = function (manipulator) {
        var _this = this;
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldRenderContext = connector.tryCreateRenderPointsContext();
        this.oldPoints = connector.points.map(function (p) { return p.clone(); });
        manipulator.changeConnectorPoints(connector, function (connector) {
            connector.points = _this.newPoints;
            _this.updateRenderPoints(connector);
        });
    };
    UpdateConnectorPointsHistoryItem.prototype.undo = function (manipulator) {
        var _this = this;
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.changeConnectorPoints(connector, function (connector) {
            connector.points = _this.oldPoints;
            connector.replaceRenderPoints(_this.oldRenderContext);
        });
    };
    return UpdateConnectorPointsHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.UpdateConnectorPointsHistoryItem = UpdateConnectorPointsHistoryItem;
var ChangeConnectorPointsHistoryItem = (function (_super) {
    __extends(ChangeConnectorPointsHistoryItem, _super);
    function ChangeConnectorPointsHistoryItem(connectorKey, newPoints, newRenderContext) {
        var _this = _super.call(this, connectorKey, newPoints) || this;
        _this.connectorKey = connectorKey;
        _this.newPoints = newPoints;
        _this.newRenderContext = newRenderContext;
        return _this;
    }
    ChangeConnectorPointsHistoryItem.prototype.updateRenderPoints = function (connector) {
        connector.replaceRenderPoints(this.newRenderContext);
    };
    return ChangeConnectorPointsHistoryItem;
}(UpdateConnectorPointsHistoryItem));
exports.ChangeConnectorPointsHistoryItem = ChangeConnectorPointsHistoryItem;
var ReplaceConnectorPointsHistoryItem = (function (_super) {
    __extends(ReplaceConnectorPointsHistoryItem, _super);
    function ReplaceConnectorPointsHistoryItem(connectorKey, newPoints) {
        var _this = _super.call(this, connectorKey, newPoints) || this;
        _this.connectorKey = connectorKey;
        _this.newPoints = newPoints;
        return _this;
    }
    ReplaceConnectorPointsHistoryItem.prototype.updateRenderPoints = function (connector) {
        connector.clearRenderPoints();
    };
    return ReplaceConnectorPointsHistoryItem;
}(UpdateConnectorPointsHistoryItem));
exports.ReplaceConnectorPointsHistoryItem = ReplaceConnectorPointsHistoryItem;


/***/ }),

/***/ 329:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeShapeParametersHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ChangeShapeParametersHistoryItem = (function (_super) {
    __extends(ChangeShapeParametersHistoryItem, _super);
    function ChangeShapeParametersHistoryItem(shapeKey, parameters) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shapeKey;
        _this.parameters = parameters;
        return _this;
    }
    ChangeShapeParametersHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.oldParameters = shape.parameters.clone();
        manipulator.changeShapeParameters(shape, this.parameters);
    };
    ChangeShapeParametersHistoryItem.prototype.undo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.changeShapeParameters(shape, this.oldParameters);
    };
    return ChangeShapeParametersHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeShapeParametersHistoryItem = ChangeShapeParametersHistoryItem;


/***/ }),

/***/ 56:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeShapeTypeHistoryItem = void 0;
var ShapeParameters_1 = __webpack_require__(6629);
var HistoryItem_1 = __webpack_require__(4412);
var ChangeShapeTypeHistoryItem = (function (_super) {
    __extends(ChangeShapeTypeHistoryItem, _super);
    function ChangeShapeTypeHistoryItem(shape, newType) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shape.key;
        _this.newType = newType;
        return _this;
    }
    ChangeShapeTypeHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.oldType = shape.description.key;
        this.oldParameters = shape.parameters.clone();
        manipulator.updateShapeType(shape, this.newType, new ShapeParameters_1.ShapeParameters());
    };
    ChangeShapeTypeHistoryItem.prototype.undo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.updateShapeType(shape, this.oldType, this.oldParameters);
    };
    return ChangeShapeTypeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeShapeTypeHistoryItem = ChangeShapeTypeHistoryItem;


/***/ }),

/***/ 8930:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteConnectionHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var Connector_1 = __webpack_require__(7959);
var DeleteConnectionHistoryItem = (function (_super) {
    __extends(DeleteConnectionHistoryItem, _super);
    function DeleteConnectionHistoryItem(connector, position) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.position = position;
        _this.itemKey = connector.getExtremeItem(_this.position).key;
        return _this;
    }
    DeleteConnectionHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldConnectionPointIndex = this.position === Connector_1.ConnectorPosition.Begin ? connector.beginConnectionPointIndex : connector.endConnectionPointIndex;
        manipulator.deleteConnection(connector, this.position);
    };
    DeleteConnectionHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.addConnection(connector, item, this.oldConnectionPointIndex, this.position);
    };
    return DeleteConnectionHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.DeleteConnectionHistoryItem = DeleteConnectionHistoryItem;


/***/ }),

/***/ 9143:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteConnectorHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var DeleteConnectorHistoryItem = (function (_super) {
    __extends(DeleteConnectorHistoryItem, _super);
    function DeleteConnectorHistoryItem(connectorKey) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        return _this;
    }
    DeleteConnectorHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.connector = connector.clone();
        manipulator.deleteConnector(connector);
    };
    DeleteConnectorHistoryItem.prototype.undo = function (manipulator) {
        manipulator.addConnector(this.connector, this.connector.key);
    };
    return DeleteConnectorHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.DeleteConnectorHistoryItem = DeleteConnectorHistoryItem;


/***/ }),

/***/ 1704:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteShapeHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var DeleteShapeHistoryItem = (function (_super) {
    __extends(DeleteShapeHistoryItem, _super);
    function DeleteShapeHistoryItem(shapeKey, allowed) {
        if (allowed === void 0) { allowed = true; }
        var _this = _super.call(this) || this;
        _this.shapeKey = shapeKey;
        _this.allowed = allowed;
        return _this;
    }
    DeleteShapeHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.shape = shape.clone();
        manipulator.deleteShape(shape, this.allowed);
    };
    DeleteShapeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.addShape(this.shape, this.shape.key);
    };
    return DeleteShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.DeleteShapeHistoryItem = DeleteShapeHistoryItem;


/***/ }),

/***/ 3849:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImportConnectorHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ImportConnectorHistoryItem = (function (_super) {
    __extends(ImportConnectorHistoryItem, _super);
    function ImportConnectorHistoryItem(connector) {
        var _this = _super.call(this) || this;
        _this.connector = connector;
        return _this;
    }
    ImportConnectorHistoryItem.prototype.redo = function (manipulator) {
        this.connectorKey = this.connector.key;
        manipulator.insertConnector(this.connector);
    };
    ImportConnectorHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.removeConnector(connector);
    };
    return ImportConnectorHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ImportConnectorHistoryItem = ImportConnectorHistoryItem;


/***/ }),

/***/ 4383:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImportShapeHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ImportShapeHistoryItem = (function (_super) {
    __extends(ImportShapeHistoryItem, _super);
    function ImportShapeHistoryItem(shape) {
        var _this = _super.call(this) || this;
        _this.shape = shape;
        return _this;
    }
    ImportShapeHistoryItem.prototype.redo = function (manipulator) {
        this.shapeKey = this.shape.key;
        manipulator.insertShape(this.shape);
    };
    ImportShapeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.removeShape(manipulator.model.findShape(this.shapeKey), true);
    };
    return ImportShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ImportShapeHistoryItem = ImportShapeHistoryItem;


/***/ }),

/***/ 9310:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InsertToContainerHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var InsertToContainerHistoryItem = (function (_super) {
    __extends(InsertToContainerHistoryItem, _super);
    function InsertToContainerHistoryItem(item, container) {
        var _this = _super.call(this) || this;
        _this.containerKey = container.key;
        _this.itemKey = item.key;
        return _this;
    }
    InsertToContainerHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        var container = manipulator.model.findShape(this.containerKey);
        manipulator.insertToContainer(item, container);
    };
    InsertToContainerHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.removeFromContainer(item);
    };
    return InsertToContainerHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.InsertToContainerHistoryItem = InsertToContainerHistoryItem;


/***/ }),

/***/ 8338:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MoveConnectorRightAnglePointsHistoryItem = exports.MoveConnectorPointHistoryItem = void 0;
var point_1 = __webpack_require__(8900);
var HistoryItem_1 = __webpack_require__(4412);
var MoveConnectorPointHistoryItem = (function (_super) {
    __extends(MoveConnectorPointHistoryItem, _super);
    function MoveConnectorPointHistoryItem(connectorKey, pointIndex, newPoint) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        _this.pointIndex = pointIndex;
        _this.newPoint = newPoint;
        return _this;
    }
    MoveConnectorPointHistoryItem.prototype.redo = function (manipulator) {
        var _this = this;
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldPoint = connector.points[this.pointIndex].clone();
        this.renderContext = connector.tryCreateRenderPointsContext();
        manipulator.moveConnectorPoint(connector, this.pointIndex, function (connector) {
            connector.movePoint(_this.pointIndex, _this.newPoint);
            connector.onMovePoint(_this.pointIndex, _this.newPoint);
        });
    };
    MoveConnectorPointHistoryItem.prototype.undo = function (manipulator) {
        var _this = this;
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.moveConnectorPoint(connector, this.pointIndex, function (connector) {
            connector.movePoint(_this.pointIndex, _this.oldPoint);
            connector.replaceRenderPoints(_this.renderContext);
        });
    };
    return MoveConnectorPointHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.MoveConnectorPointHistoryItem = MoveConnectorPointHistoryItem;
var MoveConnectorRightAnglePointsHistoryItem = (function (_super) {
    __extends(MoveConnectorRightAnglePointsHistoryItem, _super);
    function MoveConnectorRightAnglePointsHistoryItem(connectorKey, beginPointIndex, lastPointIndex, newX, newY) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        _this.beginPointIndex = beginPointIndex;
        _this.lastPointIndex = lastPointIndex;
        _this.newX = newX;
        _this.newY = newY;
        _this.oldPoints = [];
        return _this;
    }
    MoveConnectorRightAnglePointsHistoryItem.prototype.redo = function (manipulator) {
        var _this = this;
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.renderContext = connector.tryCreateRenderPointsContext();
        this.oldPoints = connector.points.slice(this.beginPointIndex, this.lastPointIndex + 1).map(function (p) { return p.clone(); });
        var points = [];
        manipulator.changeConnectorPoints(connector, function (connector) {
            for (var i = _this.beginPointIndex; i <= _this.lastPointIndex; i++) {
                var newPoint = new point_1.Point(_this.newX === undefined ? connector.points[i].x : _this.newX, _this.newY === undefined ? connector.points[i].y : _this.newY);
                points.push(newPoint);
                connector.movePoint(i, newPoint);
            }
            connector.onMovePoints(_this.beginPointIndex, _this.lastPointIndex, points);
        });
    };
    MoveConnectorRightAnglePointsHistoryItem.prototype.undo = function (manipulator) {
        var _this = this;
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.changeConnectorPoints(connector, function (connector) {
            for (var i = _this.beginPointIndex; i <= _this.lastPointIndex; i++)
                connector.movePoint(i, _this.oldPoints[i - _this.beginPointIndex]);
            connector.replaceRenderPoints(_this.renderContext);
        });
    };
    return MoveConnectorRightAnglePointsHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.MoveConnectorRightAnglePointsHistoryItem = MoveConnectorRightAnglePointsHistoryItem;


/***/ }),

/***/ 4160:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MoveShapeHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var MoveShapeHistoryItem = (function (_super) {
    __extends(MoveShapeHistoryItem, _super);
    function MoveShapeHistoryItem(shapeKey, position) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shapeKey;
        _this.position = position;
        return _this;
    }
    MoveShapeHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.oldPosition = shape.position.clone();
        manipulator.moveShape(shape, this.position);
    };
    MoveShapeHistoryItem.prototype.undo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.moveShape(shape, this.oldPosition);
    };
    return MoveShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.MoveShapeHistoryItem = MoveShapeHistoryItem;


/***/ }),

/***/ 9753:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RemoveFromContainerHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var RemoveFromContainerHistoryItem = (function (_super) {
    __extends(RemoveFromContainerHistoryItem, _super);
    function RemoveFromContainerHistoryItem(item) {
        var _this = _super.call(this) || this;
        _this.itemKey = item.key;
        return _this;
    }
    RemoveFromContainerHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.containerKey = item.container && item.container.key;
        manipulator.removeFromContainer(item);
    };
    RemoveFromContainerHistoryItem.prototype.undo = function (manipulator) {
        var container = manipulator.model.findContainer(this.containerKey);
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.insertToContainer(item, container);
    };
    return RemoveFromContainerHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.RemoveFromContainerHistoryItem = RemoveFromContainerHistoryItem;


/***/ }),

/***/ 4629:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ResizeShapeHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ResizeShapeHistoryItem = (function (_super) {
    __extends(ResizeShapeHistoryItem, _super);
    function ResizeShapeHistoryItem(shapeKey, position, size) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shapeKey;
        _this.position = position;
        _this.size = size;
        return _this;
    }
    ResizeShapeHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.oldPosition = shape.position.clone();
        this.oldSize = shape.size.clone();
        manipulator.resizeShape(shape, this.position, this.size);
    };
    ResizeShapeHistoryItem.prototype.undo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.resizeShape(shape, this.oldPosition, this.oldSize);
    };
    return ResizeShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ResizeShapeHistoryItem = ResizeShapeHistoryItem;


/***/ }),

/***/ 7626:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ScrollIntoViewOnUndoHistoryItem = exports.ScrollIntoViewOnRedoHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ScrollIntoViewOnRedoHistoryItem = (function (_super) {
    __extends(ScrollIntoViewOnRedoHistoryItem, _super);
    function ScrollIntoViewOnRedoHistoryItem(view, rectangle) {
        var _this = _super.call(this) || this;
        _this.view = view;
        _this.rectangle = rectangle;
        _this.view = view;
        _this.rectangle = rectangle.clone();
        return _this;
    }
    ScrollIntoViewOnRedoHistoryItem.prototype.redo = function (manipulator) {
        this.view.scrollIntoView(this.rectangle);
    };
    ScrollIntoViewOnRedoHistoryItem.prototype.undo = function (manipulator) { };
    return ScrollIntoViewOnRedoHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ScrollIntoViewOnRedoHistoryItem = ScrollIntoViewOnRedoHistoryItem;
var ScrollIntoViewOnUndoHistoryItem = (function (_super) {
    __extends(ScrollIntoViewOnUndoHistoryItem, _super);
    function ScrollIntoViewOnUndoHistoryItem(view, rectangle) {
        var _this = _super.call(this) || this;
        _this.view = view;
        _this.rectangle = rectangle;
        _this.view = view;
        _this.rectangle = rectangle.clone();
        return _this;
    }
    ScrollIntoViewOnUndoHistoryItem.prototype.redo = function (manipulator) { };
    ScrollIntoViewOnUndoHistoryItem.prototype.undo = function (manipulator) {
        this.view.scrollIntoView(this.rectangle);
    };
    return ScrollIntoViewOnUndoHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ScrollIntoViewOnUndoHistoryItem = ScrollIntoViewOnUndoHistoryItem;


/***/ }),

/***/ 4297:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetSelectionHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var SetSelectionHistoryItem = (function (_super) {
    __extends(SetSelectionHistoryItem, _super);
    function SetSelectionHistoryItem(selection, selectedKeys, forceChange) {
        var _this = _super.call(this) || this;
        _this.selectedKeys = selectedKeys;
        _this.selection = selection;
        _this.forceChange = forceChange;
        return _this;
    }
    SetSelectionHistoryItem.prototype.redo = function () {
        this.oldSelection = this.selection.getKeys().slice(0);
        this.selection.set(this.selectedKeys, this.forceChange);
    };
    SetSelectionHistoryItem.prototype.undo = function () {
        this.selection.set(this.oldSelection, this.forceChange);
    };
    return SetSelectionHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.SetSelectionHistoryItem = SetSelectionHistoryItem;


/***/ }),

/***/ 1864:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.History = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var Utils_1 = __webpack_require__(8675);
var History = (function () {
    function History(modelManipulator, diagram) {
        this.modelManipulator = modelManipulator;
        this.diagram = diagram;
        this.historyItems = [];
        this.currentIndex = -1;
        this.incrementalId = -1;
        this.transactionLevel = -1;
        this.unmodifiedIndex = -1;
        this.currTransactionId = 0;
        this.onChanged = new Utils_1.EventDispatcher();
    }
    History.prototype.isModified = function () {
        if (this.unmodifiedIndex === this.currentIndex)
            return false;
        var startIndex = Math.min(this.unmodifiedIndex, this.currentIndex);
        var endIndex = Math.max(this.unmodifiedIndex, this.currentIndex);
        for (var i = startIndex + 1; i <= endIndex; i++)
            if (this.historyItems[i].changeModified())
                return true;
        return false;
    };
    History.prototype.undo = function () {
        if (!this.canUndo())
            return;
        this.historyItems[this.currentIndex].undo(this.modelManipulator);
        this.currentIndex--;
        this.raiseChanged();
    };
    History.prototype.redo = function () {
        if (!this.canRedo())
            return;
        if (this.startDataSyncItem) {
            this.startDataSyncItem.undo(this.modelManipulator);
            this.startDataSyncItem = undefined;
        }
        this.currentIndex++;
        this.historyItems[this.currentIndex].redo(this.modelManipulator);
        this.raiseChanged();
    };
    History.prototype.canUndo = function () {
        return this.currentIndex >= 0;
    };
    History.prototype.canRedo = function () {
        return this.currentIndex < this.historyItems.length - 1;
    };
    History.prototype.beginTransaction = function () {
        this.transactionLevel++;
        if (this.transactionLevel === 0)
            this.transaction = new HistoryItem_1.CompositionHistoryItem();
        var id = this.currTransactionId++;
        return id;
    };
    History.prototype.endTransaction = function (isDataSyncTransaction) {
        if (--this.transactionLevel >= 0)
            return;
        var transactionLength = this.transaction.historyItems.length;
        if (transactionLength > 0) {
            var historyItem = transactionLength > 1 ? this.transaction : this.transaction.historyItems.pop();
            if (isDataSyncTransaction)
                this.addDataSyncItem(historyItem);
            else
                this.addInternal(historyItem);
        }
        if (transactionLength > 0 && !isDataSyncTransaction)
            this.raiseChanged();
        delete this.transaction;
    };
    History.prototype.addAndRedo = function (historyItem) {
        this.add(historyItem);
        historyItem.redo(this.modelManipulator);
        this.raiseChanged();
    };
    History.prototype.add = function (historyItem) {
        if (this.transactionLevel >= 0)
            this.transaction.add(historyItem);
        else
            this.addInternal(historyItem);
    };
    History.prototype.addInternal = function (historyItem) {
        if (this.currentIndex < this.historyItems.length - 1) {
            this.historyItems.splice(this.currentIndex + 1);
            this.unmodifiedIndex = Math.min(this.unmodifiedIndex, this.currentIndex);
        }
        this.historyItems.push(historyItem);
        this.currentIndex++;
        this.deleteOldItems();
    };
    History.prototype.addDataSyncItem = function (historyItem) {
        var toHistoryItem = this.historyItems[this.currentIndex];
        if (toHistoryItem) {
            var compositionHistoryItem = void 0;
            if (toHistoryItem instanceof HistoryItem_1.CompositionHistoryItem)
                compositionHistoryItem = toHistoryItem;
            else {
                this.historyItems.splice(this.currentIndex, 1);
                compositionHistoryItem = new HistoryItem_1.CompositionHistoryItem();
                this.historyItems.push(compositionHistoryItem);
                compositionHistoryItem.historyItems.push(toHistoryItem);
            }
            compositionHistoryItem.dataSyncItems.push(historyItem);
        }
        else if (this.historyItems.length)
            this.startDataSyncItem = historyItem;
    };
    History.prototype.deleteOldItems = function () {
        var exceedItemsCount = this.historyItems.length - History.MAX_HISTORY_ITEM_COUNT;
        if (exceedItemsCount > 0 && this.currentIndex > exceedItemsCount) {
            this.historyItems.splice(0, exceedItemsCount);
            this.currentIndex -= exceedItemsCount;
        }
    };
    History.prototype.getNextId = function () {
        this.incrementalId++;
        return this.incrementalId;
    };
    History.prototype.clear = function () {
        this.currentIndex = -1;
        this.unmodifiedIndex = -1;
        this.incrementalId = -1;
        this.historyItems = [];
        delete this.transaction;
        this.transactionLevel = -1;
    };
    History.prototype.resetModified = function () {
        this.unmodifiedIndex = this.currentIndex;
    };
    History.prototype.getCurrentItemId = function () {
        if (this.currentIndex === -1)
            return -1;
        var currentItem = this.historyItems[this.currentIndex];
        if (currentItem.uniqueId === -1)
            currentItem.uniqueId = this.getNextId();
        return currentItem.uniqueId;
    };
    History.prototype.undoTransaction = function () {
        this.diagram.beginUpdateCanvas();
        var items = this.transaction.historyItems;
        while (items.length)
            items.pop().undo(this.modelManipulator);
        this.diagram.endUpdateCanvas();
    };
    History.prototype.undoTransactionTo = function (item) {
        this.diagram.beginUpdateCanvas();
        var items = this.transaction.historyItems;
        while (items.length) {
            var ti = items.pop();
            ti.undo(this.modelManipulator);
            if (ti === item)
                break;
        }
        this.diagram.endUpdateCanvas();
    };
    History.prototype.raiseChanged = function () {
        if (this.transactionLevel === -1)
            this.onChanged.raise("notifyHistoryChanged");
    };
    History.MAX_HISTORY_ITEM_COUNT = 100;
    return History;
}());
exports.History = History;


/***/ }),

/***/ 4412:
/***/ (function(__unused_webpack_module, exports) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CompositionHistoryItem = exports.HistoryItem = void 0;
var HistoryItem = (function () {
    function HistoryItem() {
        this.uniqueId = -1;
    }
    HistoryItem.prototype.changeModified = function () {
        return true;
    };
    HistoryItem.prototype.getName = function () {
        return this.constructor.name;
    };
    return HistoryItem;
}());
exports.HistoryItem = HistoryItem;
var CompositionHistoryItem = (function (_super) {
    __extends(CompositionHistoryItem, _super);
    function CompositionHistoryItem() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.historyItems = [];
        _this.dataSyncItems = [];
        return _this;
    }
    CompositionHistoryItem.prototype.changeModified = function () {
        var item;
        for (var i = 0; item = this.historyItems[i]; i++)
            if (item.changeModified())
                return true;
        return false;
    };
    CompositionHistoryItem.prototype.redo = function (manipulator) {
        var item;
        for (var i = 0; item = this.historyItems[i]; i++)
            item.redo(manipulator);
    };
    CompositionHistoryItem.prototype.undo = function (manipulator) {
        var item;
        for (var i = this.dataSyncItems.length - 1; item = this.dataSyncItems[i]; i--)
            item.undo(manipulator);
        this.dataSyncItems = [];
        for (var i = this.historyItems.length - 1; item = this.historyItems[i]; i--)
            item.undo(manipulator);
    };
    CompositionHistoryItem.prototype.add = function (historyItem) {
        if (historyItem == null)
            throw new Error("cannot be null");
        this.historyItems.push(historyItem);
    };
    return CompositionHistoryItem;
}(HistoryItem));
exports.CompositionHistoryItem = CompositionHistoryItem;


/***/ }),

/***/ 7195:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangePageColorHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ChangePageColorHistoryItem = (function (_super) {
    __extends(ChangePageColorHistoryItem, _super);
    function ChangePageColorHistoryItem(value) {
        var _this = _super.call(this) || this;
        _this.value = value;
        return _this;
    }
    ChangePageColorHistoryItem.prototype.redo = function (manipulator) {
        this.oldValue = manipulator.model.pageColor;
        manipulator.changePageColor(this.value);
    };
    ChangePageColorHistoryItem.prototype.undo = function (manipulator) {
        manipulator.changePageColor(this.oldValue);
    };
    return ChangePageColorHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangePageColorHistoryItem = ChangePageColorHistoryItem;


/***/ }),

/***/ 1380:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangePageLandscapeHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ChangePageLandscapeHistoryItem = (function (_super) {
    __extends(ChangePageLandscapeHistoryItem, _super);
    function ChangePageLandscapeHistoryItem(value) {
        var _this = _super.call(this) || this;
        _this.value = value;
        return _this;
    }
    ChangePageLandscapeHistoryItem.prototype.redo = function (manipulator) {
        this.oldValue = manipulator.model.pageLandscape;
        manipulator.changePageLandscape(this.value);
    };
    ChangePageLandscapeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.changePageLandscape(this.oldValue);
    };
    return ChangePageLandscapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangePageLandscapeHistoryItem = ChangePageLandscapeHistoryItem;


/***/ }),

/***/ 1044:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangePageSizeHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ChangePageSizeHistoryItem = (function (_super) {
    __extends(ChangePageSizeHistoryItem, _super);
    function ChangePageSizeHistoryItem(size) {
        var _this = _super.call(this) || this;
        _this.size = size;
        return _this;
    }
    ChangePageSizeHistoryItem.prototype.redo = function (manipulator) {
        this.oldSize = manipulator.model.pageSize;
        manipulator.changePageSize(this.size);
    };
    ChangePageSizeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.changePageSize(this.oldSize);
    };
    return ChangePageSizeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangePageSizeHistoryItem = ChangePageSizeHistoryItem;


/***/ }),

/***/ 7479:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeUnitsHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ChangeUnitsHistoryItem = (function (_super) {
    __extends(ChangeUnitsHistoryItem, _super);
    function ChangeUnitsHistoryItem(units) {
        var _this = _super.call(this) || this;
        _this.units = units;
        return _this;
    }
    ChangeUnitsHistoryItem.prototype.redo = function (manipulator) {
        this.oldUnits = manipulator.model.units;
        manipulator.model.units = this.units;
    };
    ChangeUnitsHistoryItem.prototype.undo = function (manipulator) {
        manipulator.model.units = this.oldUnits;
    };
    return ChangeUnitsHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeUnitsHistoryItem = ChangeUnitsHistoryItem;


/***/ }),

/***/ 1729:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ModelResizeHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var offsets_1 = __webpack_require__(4125);
var size_1 = __webpack_require__(6353);
var ModelResizeHistoryItem = (function (_super) {
    __extends(ModelResizeHistoryItem, _super);
    function ModelResizeHistoryItem(offset) {
        var _this = _super.call(this) || this;
        _this.offset = offset;
        return _this;
    }
    ModelResizeHistoryItem.prototype.redo = function (manipulator) {
        this.oldSize = manipulator.model.size.clone();
        this.backOffset = new offsets_1.Offsets(-this.offset.left, -this.offset.right, -this.offset.top, -this.offset.bottom);
        var newWidth = Math.max(this.oldSize.width + this.offset.left + this.offset.right, manipulator.model.pageWidth);
        var newHeight = Math.max(this.oldSize.height + this.offset.top + this.offset.bottom, manipulator.model.pageHeight);
        manipulator.changeModelSize(new size_1.Size(newWidth, newHeight), this.offset);
    };
    ModelResizeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.changeModelSize(this.oldSize, this.backOffset);
    };
    return ModelResizeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ModelResizeHistoryItem = ModelResizeHistoryItem;


/***/ }),

/***/ 4518:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UpdatePositionsOnPageResizeHistoryItem = void 0;
var Connector_1 = __webpack_require__(7959);
var Shape_1 = __webpack_require__(5503);
var HistoryItem_1 = __webpack_require__(4412);
var UpdatePositionsOnPageResizeHistoryItem = (function (_super) {
    __extends(UpdatePositionsOnPageResizeHistoryItem, _super);
    function UpdatePositionsOnPageResizeHistoryItem(offset) {
        var _this = _super.call(this) || this;
        _this.offset = offset;
        return _this;
    }
    UpdatePositionsOnPageResizeHistoryItem.prototype.redo = function (manipulator) {
        var _this = this;
        manipulator.model.iterateItems(function (item) {
            if (item instanceof Shape_1.Shape)
                manipulator.moveShape(item, _this.applyOffset(item.position, _this.offset.x, _this.offset.y));
            if (item instanceof Connector_1.Connector)
                manipulator.changeConnectorPoints(item, function (i) { return i.updatePointsOnPageResize(_this.offset.x, _this.offset.y); });
        });
    };
    UpdatePositionsOnPageResizeHistoryItem.prototype.undo = function (manipulator) {
        var _this = this;
        manipulator.model.iterateItems(function (item) {
            if (item instanceof Shape_1.Shape)
                manipulator.moveShape(item, _this.applyOffset(item.position, -_this.offset.x, -_this.offset.y));
            if (item instanceof Connector_1.Connector)
                manipulator.changeConnectorPoints(item, function (i) { return i.updatePointsOnPageResize(-_this.offset.x, -_this.offset.y); });
        });
    };
    UpdatePositionsOnPageResizeHistoryItem.prototype.applyOffset = function (point, offsetX, offsetY) {
        return point.clone().offset(offsetX, offsetY);
    };
    return UpdatePositionsOnPageResizeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.UpdatePositionsOnPageResizeHistoryItem = UpdatePositionsOnPageResizeHistoryItem;


/***/ }),

/***/ 8236:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeConnectorPropertyHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ChangeConnectorPropertyHistoryItem = (function (_super) {
    __extends(ChangeConnectorPropertyHistoryItem, _super);
    function ChangeConnectorPropertyHistoryItem(connectorKey, propertyName, value) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        _this.propertyName = propertyName;
        _this.value = value;
        return _this;
    }
    ChangeConnectorPropertyHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldValue = connector.properties[this.propertyName];
        manipulator.changeConnectorProperty(connector, this.propertyName, this.value);
    };
    ChangeConnectorPropertyHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.changeConnectorProperty(connector, this.propertyName, this.oldValue);
    };
    return ChangeConnectorPropertyHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeConnectorPropertyHistoryItem = ChangeConnectorPropertyHistoryItem;


/***/ }),

/***/ 5144:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeConnectorTextHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ChangeConnectorTextHistoryItem = (function (_super) {
    __extends(ChangeConnectorTextHistoryItem, _super);
    function ChangeConnectorTextHistoryItem(connector, position, text) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.text = text;
        _this.position = position;
        return _this;
    }
    ChangeConnectorTextHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldText = connector.getText(this.position);
        manipulator.changeConnectorText(connector, this.text, this.position);
    };
    ChangeConnectorTextHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.changeConnectorText(connector, this.oldText, this.position);
    };
    return ChangeConnectorTextHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeConnectorTextHistoryItem = ChangeConnectorTextHistoryItem;


/***/ }),

/***/ 45:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeConnectorTextPositionHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ChangeConnectorTextPositionHistoryItem = (function (_super) {
    __extends(ChangeConnectorTextPositionHistoryItem, _super);
    function ChangeConnectorTextPositionHistoryItem(connector, position, newPosition) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.position = position;
        _this.newPosition = newPosition;
        return _this;
    }
    ChangeConnectorTextPositionHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.changeConnectorTextPosition(connector, this.position, this.newPosition);
    };
    ChangeConnectorTextPositionHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.changeConnectorTextPosition(connector, this.newPosition, this.position);
    };
    return ChangeConnectorTextPositionHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeConnectorTextPositionHistoryItem = ChangeConnectorTextPositionHistoryItem;


/***/ }),

/***/ 9559:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeCustomDataHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var Utils_1 = __webpack_require__(8675);
var ChangeCustomDataHistoryItem = (function (_super) {
    __extends(ChangeCustomDataHistoryItem, _super);
    function ChangeCustomDataHistoryItem(itemKey, customData) {
        var _this = _super.call(this) || this;
        _this.itemKey = itemKey;
        _this.customData = Utils_1.ObjectUtils.cloneObject(customData);
        return _this;
    }
    ChangeCustomDataHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldCustomData = Utils_1.ObjectUtils.cloneObject(item.customData);
        manipulator.changeCustomData(item, this.customData);
    };
    ChangeCustomDataHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeCustomData(item, this.oldCustomData);
    };
    return ChangeCustomDataHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeCustomDataHistoryItem = ChangeCustomDataHistoryItem;


/***/ }),

/***/ 7443:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeLockedHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ChangeLockedHistoryItem = (function (_super) {
    __extends(ChangeLockedHistoryItem, _super);
    function ChangeLockedHistoryItem(item, locked) {
        var _this = _super.call(this) || this;
        _this.itemKey = item.key;
        _this.locked = locked;
        return _this;
    }
    ChangeLockedHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldLocked = item.locked;
        manipulator.changeLocked(item, this.locked);
    };
    ChangeLockedHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeLocked(item, this.oldLocked);
    };
    return ChangeLockedHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeLockedHistoryItem = ChangeLockedHistoryItem;


/***/ }),

/***/ 8210:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeShapeImageHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ImageInfo_1 = __webpack_require__(6617);
var ChangeShapeImageHistoryItem = (function (_super) {
    __extends(ChangeShapeImageHistoryItem, _super);
    function ChangeShapeImageHistoryItem(item, imageUrl) {
        var _this = _super.call(this) || this;
        _this.shapeKey = item.key;
        _this.imageUrl = imageUrl;
        return _this;
    }
    ChangeShapeImageHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findShape(this.shapeKey);
        this.oldImage = item.image;
        manipulator.changeShapeImage(item, new ImageInfo_1.ImageInfo(this.imageUrl));
    };
    ChangeShapeImageHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findShape(this.shapeKey);
        manipulator.changeShapeImage(item, this.oldImage);
    };
    return ChangeShapeImageHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeShapeImageHistoryItem = ChangeShapeImageHistoryItem;


/***/ }),

/***/ 6516:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeShapeTextHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ChangeShapeTextHistoryItem = (function (_super) {
    __extends(ChangeShapeTextHistoryItem, _super);
    function ChangeShapeTextHistoryItem(item, text) {
        var _this = _super.call(this) || this;
        _this.shapeKey = item.key;
        _this.text = text;
        return _this;
    }
    ChangeShapeTextHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findShape(this.shapeKey);
        this.oldText = item.text;
        manipulator.changeShapeText(item, this.text);
    };
    ChangeShapeTextHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findShape(this.shapeKey);
        manipulator.changeShapeText(item, this.oldText);
    };
    return ChangeShapeTextHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeShapeTextHistoryItem = ChangeShapeTextHistoryItem;


/***/ }),

/***/ 5982:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeZindexHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ChangeZindexHistoryItem = (function (_super) {
    __extends(ChangeZindexHistoryItem, _super);
    function ChangeZindexHistoryItem(item, zIndex) {
        var _this = _super.call(this) || this;
        _this.itemKey = item.key;
        _this.zIndex = zIndex;
        return _this;
    }
    ChangeZindexHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldZIndex = item.zIndex;
        manipulator.changeZIndex(item, this.zIndex);
    };
    ChangeZindexHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeZIndex(item, this.oldZIndex);
    };
    return ChangeZindexHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeZindexHistoryItem = ChangeZindexHistoryItem;


/***/ }),

/***/ 442:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleShapeExpandedHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ToggleShapeExpandedHistoryItem = (function (_super) {
    __extends(ToggleShapeExpandedHistoryItem, _super);
    function ToggleShapeExpandedHistoryItem(shape) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shape.key;
        _this.expanded = shape.expanded;
        return _this;
    }
    ToggleShapeExpandedHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.changeShapeExpanded(shape, !this.expanded);
    };
    ToggleShapeExpandedHistoryItem.prototype.undo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.changeShapeExpanded(shape, this.expanded);
    };
    return ToggleShapeExpandedHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ToggleShapeExpandedHistoryItem = ToggleShapeExpandedHistoryItem;


/***/ }),

/***/ 4634:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeStyleHistoryItem = void 0;
var ChangeStyleHistoryItemBase_1 = __webpack_require__(3259);
var ChangeStyleHistoryItem = (function (_super) {
    __extends(ChangeStyleHistoryItem, _super);
    function ChangeStyleHistoryItem(itemKey, styleProperty, styleValue) {
        return _super.call(this, itemKey, styleProperty, styleValue) || this;
    }
    ChangeStyleHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldStyleValue = item.style[this.styleProperty];
        manipulator.changeStyle(item, this.styleProperty, this.styleValue);
    };
    ChangeStyleHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeStyle(item, this.styleProperty, this.oldStyleValue);
    };
    return ChangeStyleHistoryItem;
}(ChangeStyleHistoryItemBase_1.ChangeStyleHistoryItemBase));
exports.ChangeStyleHistoryItem = ChangeStyleHistoryItem;


/***/ }),

/***/ 3259:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeStyleHistoryItemBase = void 0;
var HistoryItem_1 = __webpack_require__(4412);
var ChangeStyleHistoryItemBase = (function (_super) {
    __extends(ChangeStyleHistoryItemBase, _super);
    function ChangeStyleHistoryItemBase(itemKey, styleProperty, styleValue) {
        var _this = _super.call(this) || this;
        _this.itemKey = itemKey;
        _this.styleProperty = styleProperty;
        _this.styleValue = styleValue;
        return _this;
    }
    ChangeStyleHistoryItemBase.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldStyleValue = item.style[this.styleProperty];
        manipulator.changeStyle(item, this.styleProperty, this.styleValue);
    };
    ChangeStyleHistoryItemBase.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeStyle(item, this.styleProperty, this.oldStyleValue);
    };
    return ChangeStyleHistoryItemBase;
}(HistoryItem_1.HistoryItem));
exports.ChangeStyleHistoryItemBase = ChangeStyleHistoryItemBase;


/***/ }),

/***/ 926:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeStyleTextHistoryItem = void 0;
var ChangeStyleHistoryItemBase_1 = __webpack_require__(3259);
var ChangeStyleTextHistoryItem = (function (_super) {
    __extends(ChangeStyleTextHistoryItem, _super);
    function ChangeStyleTextHistoryItem(itemKey, styleProperty, styleValue) {
        return _super.call(this, itemKey, styleProperty, styleValue) || this;
    }
    ChangeStyleTextHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldStyleValue = item.styleText[this.styleProperty];
        manipulator.changeStyleText(item, this.styleProperty, this.styleValue);
    };
    ChangeStyleTextHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeStyleText(item, this.styleProperty, this.oldStyleValue);
    };
    return ChangeStyleTextHistoryItem;
}(ChangeStyleHistoryItemBase_1.ChangeStyleHistoryItemBase));
exports.ChangeStyleTextHistoryItem = ChangeStyleTextHistoryItem;


/***/ }),

/***/ 7176:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImageCache = exports.CacheImageInfo = void 0;
var base64_1 = __webpack_require__(6477);
var ImageInfo_1 = __webpack_require__(6617);
var Utils_1 = __webpack_require__(8675);
var CacheImageInfo = (function () {
    function CacheImageInfo(base64, actualId, imageUrl, referenceInfo, isLoaded) {
        this._base64 = base64 !== undefined ? base64_1.Base64Utils.normalizeToDataUrl(base64, "image/png") : undefined;
        this.actualId = actualId;
        this._referenceInfo = referenceInfo;
        this._isLoaded = isLoaded !== undefined ? isLoaded : false;
        this.imageUrl = imageUrl;
    }
    Object.defineProperty(CacheImageInfo.prototype, "isLoaded", {
        get: function () { return this._referenceInfo ? this._referenceInfo._isLoaded : this._isLoaded; },
        set: function (val) { this._isLoaded = val; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CacheImageInfo.prototype, "base64", {
        get: function () { return this._base64; },
        set: function (val) { this._base64 = base64_1.Base64Utils.normalizeToDataUrl(val, "image/png"); },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CacheImageInfo.prototype, "referenceInfo", {
        get: function () { return this._referenceInfo; },
        set: function (val) {
            this._referenceInfo = val;
            this._base64 = undefined;
            this._isLoaded = undefined;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CacheImageInfo.prototype, "isLoading", {
        get: function () { return this._referenceInfo ? this.referenceInfo._isLoading : this._isLoading; },
        enumerable: false,
        configurable: true
    });
    CacheImageInfo.prototype.startLoading = function () {
        if (this._referenceInfo)
            this._referenceInfo.startLoading();
        else
            this._isLoading = true;
    };
    CacheImageInfo.prototype.finalizeLoading = function () {
        if (this._referenceInfo)
            this._referenceInfo.finalizeLoading();
        else
            this._isLoading = false;
    };
    return CacheImageInfo;
}());
exports.CacheImageInfo = CacheImageInfo;
var ImageCache = (function () {
    function ImageCache() {
        this.emptyImageId = 0;
        this.lastActualId = 0;
        this.onReadyStateChanged = new Utils_1.EventDispatcher();
        this.cache = [];
        this.nonLoadedImages = [];
        var emptyImage = this.createUnloadedInfoByBase64(ImageInfo_1.ImageInfo.transparentOnePixelImage);
        emptyImage.isLoaded = true;
    }
    ImageCache.prototype.reset = function () {
        this.cache.splice(1);
        this.nonLoadedImages = [];
        this.lastActualId = 1;
    };
    Object.defineProperty(ImageCache.prototype, "emptyImage", {
        get: function () { return this.cache[this.emptyImageId]; },
        enumerable: false,
        configurable: true
    });
    ImageCache.prototype.getImageData = function (id) {
        return this.cache[id];
    };
    ImageCache.prototype.createUnloadedInfoByUrl = function (imageUrl) {
        var info = this.findInfoByUrl(imageUrl);
        if (info)
            return info;
        return this.registerImageData(new CacheImageInfo(undefined, this.getNextActualId(), imageUrl));
    };
    ImageCache.prototype.createUnloadedInfoByBase64 = function (base64) {
        var info = this.findInfoByBase64(base64);
        if (info)
            return info;
        return this.registerImageData(new CacheImageInfo(base64, this.getNextActualId()));
    };
    ImageCache.prototype.createUnloadedInfoByShapeImageInfo = function (imageInfo) {
        var data = imageInfo.exportUrl;
        return base64_1.Base64Utils.checkPrependDataUrl(data) ?
            this.createUnloadedInfoByBase64(data) :
            this.createUnloadedInfoByUrl(data);
    };
    ImageCache.prototype.registerImageData = function (data) {
        var existingData = this.cache[data.actualId];
        if (!existingData)
            existingData = data;
        if (data.actualId !== undefined)
            this.cache[data.actualId] = existingData;
        if (data.actualId !== 0) {
            this.nonLoadedImages.push(data);
            if (this.nonLoadedImages.length === 1)
                this.raiseReadyStateChanged(false);
        }
        return existingData;
    };
    ImageCache.prototype.loadAllImages = function (loader) {
        var _this = this;
        this.cache.forEach(function (cacheInfo) {
            if (_this.emptyImageId !== cacheInfo.actualId && !cacheInfo.isLoaded && !cacheInfo.isLoading)
                loader.load(cacheInfo);
        });
    };
    ImageCache.prototype.finalizeLoading = function (existingInfo, loadedInfo) {
        existingInfo.finalizeLoading();
        existingInfo.isLoaded = true;
        var imageInfoIndex = this.nonLoadedImages.indexOf(existingInfo);
        this.nonLoadedImages.splice(imageInfoIndex, 1);
        if (this.nonLoadedImages.length === 0)
            this.raiseReadyStateChanged(true);
        if (existingInfo.referenceInfo)
            return;
        if (loadedInfo.base64) {
            var base64_2 = base64_1.Base64Utils.normalizeToDataUrl(loadedInfo.base64, "image/png");
            this.cache.forEach(function (cacheElem) {
                var isReference = cacheElem.base64 === base64_2 && cacheElem !== existingInfo && cacheElem.isLoaded;
                if (isReference)
                    existingInfo.referenceInfo = cacheElem.referenceInfo ? cacheElem.referenceInfo : cacheElem;
                return isReference;
            });
            existingInfo.base64 = base64_2;
        }
    };
    ImageCache.prototype.hasNonLoadedImages = function () {
        return this.nonLoadedImages.length !== 0;
    };
    ImageCache.prototype.getNextActualId = function () {
        return this.lastActualId++;
    };
    ImageCache.prototype.findInfoByBase64 = function (base64) {
        base64 = base64_1.Base64Utils.normalizeToDataUrl(base64, "image/png");
        return this.findInfoCore(function (cacheImageInfo) { return cacheImageInfo.base64 === base64; });
    };
    ImageCache.prototype.findInfoByUrl = function (imageUrl) {
        return this.findInfoCore(function (cacheImageInfo) { return cacheImageInfo.imageUrl === imageUrl; });
    };
    ImageCache.prototype.findInfoCore = function (callback) {
        var cacheInfo;
        this.cache.forEach(function (item) {
            if (callback(item))
                cacheInfo = item;
        });
        return cacheInfo;
    };
    ImageCache.prototype.raiseReadyStateChanged = function (ready) {
        this.onReadyStateChanged.raise1(function (l) { return l.notifyImageCacheReadyStateChanged(ready); });
    };
    ImageCache.instance = new ImageCache();
    return ImageCache;
}());
exports.ImageCache = ImageCache;


/***/ }),

/***/ 6617:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImageInfo = void 0;
var base64_1 = __webpack_require__(6477);
var ImageInfo = (function () {
    function ImageInfo(imageUrlOrBase64) {
        this.url = undefined;
        this.base64 = undefined;
        if (imageUrlOrBase64)
            if (base64_1.Base64Utils.checkPrependDataUrl(imageUrlOrBase64))
                this.base64 = imageUrlOrBase64;
            else
                this.url = imageUrlOrBase64;
        this.loadFailed = false;
    }
    ImageInfo.prototype.clone = function () {
        var result = new ImageInfo();
        result.url = this.url;
        result.base64 = this.base64;
        return result;
    };
    Object.defineProperty(ImageInfo.prototype, "isEmpty", {
        get: function () { return this.url === undefined && this.base64 === undefined; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ImageInfo.prototype, "unableToLoad", {
        get: function () { return this.loadFailed; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ImageInfo.prototype, "renderUrl", {
        get: function () { return this.base64 || ""; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ImageInfo.prototype, "exportUrl", {
        get: function () { return this.base64 ? this.base64 : this.url; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ImageInfo.prototype, "actualUrl", {
        get: function () { return this.url ? this.url : this.base64; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ImageInfo, "transparentOnePixelImage", {
        get: function () { return this.transparentWhiteImage1_1; },
        enumerable: false,
        configurable: true
    });
    ImageInfo.prototype.loadBase64Content = function (base64Content) {
        this.base64 = base64_1.Base64Utils.normalizeToDataUrl(base64Content, "image/png");
    };
    ImageInfo.prototype.setUnableToLoadFlag = function () {
        this.loadFailed = true;
    };
    ImageInfo.transparentWhiteImage1_1 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAANSURBVBhXY/j///9/AAn7A/0FQ0XKAAAAAElFTkSuQmCC";
    return ImageInfo;
}());
exports.ImageInfo = ImageInfo;


/***/ }),

/***/ 590:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImageLoader = void 0;
var ImageCache_1 = __webpack_require__(7176);
var ImageLoader = (function () {
    function ImageLoader(loadedCallback) {
        this.loadedCallback = loadedCallback;
    }
    ImageLoader.prototype.load = function (data) {
        if (data.isLoaded)
            this.loadedCallback(data);
        else if (!data.isLoading)
            this.loadInner(data);
    };
    ImageLoader.prototype.loadInner = function (data) {
        var _this = this;
        if (data.imageUrl)
            this.loadPictureByUrl(data, function () { return _this.finalizeLoading(data, data); });
        else if (data.base64)
            this.loadPictureByBase64(data, function () { return _this.finalizeLoading(data, data); });
        return data;
    };
    ImageLoader.prototype.finalizeLoading = function (loadedData, existingInfo) {
        if (!existingInfo)
            existingInfo = ImageCache_1.ImageCache.instance.getImageData(loadedData.actualId);
        if (!existingInfo.isLoaded)
            ImageCache_1.ImageCache.instance.finalizeLoading(existingInfo, loadedData);
        this.loadedCallback(existingInfo);
    };
    ImageLoader.prototype.loadPictureByBase64 = function (data, imageLoaded) {
        var img = new Image();
        img.onload = function () {
            imageLoaded(data);
        };
        img.src = data.base64;
    };
    ImageLoader.prototype.loadPictureByUrl = function (data, imageLoaded) {
        var _this = this;
        var xhr = new XMLHttpRequest();
        try {
            xhr.onload = function () {
                var reader = new FileReader();
                reader.onloadend = function () {
                    data.base64 = reader.result;
                    _this.loadPictureByBase64(data, function (data) { return imageLoaded(data); });
                };
                reader.readAsDataURL(xhr.response);
            };
            xhr.onerror = function () { return imageLoaded(data); };
            xhr.onloadend = function () {
                if (xhr.status === 404)
                    imageLoaded(data);
            };
            xhr.open("GET", data.imageUrl, true);
            xhr.responseType = "blob";
            data.startLoading();
            xhr.send();
        }
        catch (_a) { }
    };
    return ImageLoader;
}());
exports.ImageLoader = ImageLoader;


/***/ }),

/***/ 5941:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BPMNNode = exports.BPMNImporter = void 0;
var Graph_1 = __webpack_require__(213);
var ShapeTypes_1 = __webpack_require__(2259);
var Structures_1 = __webpack_require__(8217);
var ImportUtils_1 = __webpack_require__(6572);
var BPMNImporter = (function () {
    function BPMNImporter(xml) {
        this.doc = ImportUtils_1.ImportUtils.createDocument(xml);
        this.graph = new Graph_1.Graph([], []);
    }
    BPMNImporter.prototype.import = function () {
        for (var child = void 0, i = 0; child = this.doc.children[i]; i++)
            if (child.nodeName.toUpperCase() === "DEFINITIONS")
                this.onDefinitionsElement(child);
        this.validate();
        return this.graph;
    };
    BPMNImporter.prototype.validate = function () {
        var nodesMap = {};
        this.graph.nodes.forEach(function (n) { return nodesMap[n] = true; });
        for (var i = 0, edge = void 0; edge = this.graph.edges[i]; i++)
            if (!nodesMap[edge.from] || !nodesMap[edge.to]) {
                this.graph.edges.splice(i, 1);
                i--;
            }
    };
    BPMNImporter.prototype.onDefinitionsElement = function (element) {
        this.dataSourceKey = element.getAttribute("id");
        for (var child = void 0, i = 0; child = element.children[i]; i++)
            if (child.nodeName.toUpperCase() === "PROCESS")
                this.onProcessElement(child);
    };
    BPMNImporter.prototype.onProcessElement = function (element) {
        for (var child = void 0, i = 0; child = element.children[i]; i++)
            switch (child.nodeName.toUpperCase()) {
                case "STARTEVENT":
                    this.onStartEventElement(child);
                    break;
                case "SEQUENCEFLOW":
                    this.onSequenceFlowElement(child);
                    break;
                case "SCRIPTTASK":
                    this.onScriptTaskElement(child);
                    break;
                case "USERTASK":
                    this.onUserTaskElement(child);
                    break;
                case "SERVICETASK":
                    this.onServiceTaskElement(child);
                    break;
                case "SENDTASK":
                    this.onSendTaskElement(child);
                    break;
                case "EXCLUSIVEGATEWAY":
                    this.onExclusiveGateway(child);
                    break;
                case "ENDEVENT":
                    this.onEndEventGateway(child);
                    break;
            }
    };
    BPMNImporter.prototype.onStartEventElement = function (element) {
        var node = this.createNode(element);
        node.type = ShapeTypes_1.ShapeTypes.Ellipse;
        node.text = element.getAttribute("name");
        this.graph.addNode(node);
    };
    BPMNImporter.prototype.onSequenceFlowElement = function (element) {
        var fromKey = element.getAttribute("sourceRef");
        var toKey = element.getAttribute("targetRef");
        var edge = this.createEdge(element, fromKey, toKey);
        if (element.hasAttribute("name"))
            edge.text = element.getAttribute("name");
        this.graph.addEdge(edge);
    };
    BPMNImporter.prototype.onScriptTaskElement = function (element) {
        var node = this.createNode(element);
        node.text = element.getAttribute("name");
        this.graph.addNode(node);
    };
    BPMNImporter.prototype.onUserTaskElement = function (element) {
        var node = this.createNode(element);
        node.text = element.getAttribute("name");
        this.graph.addNode(node);
    };
    BPMNImporter.prototype.onServiceTaskElement = function (element) {
        var node = this.createNode(element);
        node.text = element.getAttribute("name");
        this.graph.addNode(node);
    };
    BPMNImporter.prototype.onSendTaskElement = function (element) {
        var node = this.createNode(element);
        node.text = element.getAttribute("name");
        this.graph.addNode(node);
    };
    BPMNImporter.prototype.onExclusiveGateway = function (element) {
        var node = this.createNode(element);
        node.text = element.getAttribute("name");
        node.type = ShapeTypes_1.ShapeTypes.Decision;
        this.graph.addNode(node);
    };
    BPMNImporter.prototype.onEndEventGateway = function (element) {
        var node = this.createNode(element);
        node.text = element.getAttribute("name");
        node.type = ShapeTypes_1.ShapeTypes.Ellipse;
        this.graph.addNode(node);
    };
    BPMNImporter.prototype.createNode = function (element) {
        return new BPMNNode(this.dataSourceKey, element.getAttribute("id"));
    };
    BPMNImporter.prototype.createEdge = function (element, fromKey, toKey) {
        return new BPMNEdge(this.dataSourceKey, element.getAttribute("id"), fromKey, toKey);
    };
    return BPMNImporter;
}());
exports.BPMNImporter = BPMNImporter;
var BPMNNode = (function () {
    function BPMNNode(sourceKey, key) {
        this.sourceKey = sourceKey;
        this.key = key;
        this.type = ShapeTypes_1.ShapeTypes.Rectangle;
    }
    return BPMNNode;
}());
exports.BPMNNode = BPMNNode;
var BPMNEdge = (function (_super) {
    __extends(BPMNEdge, _super);
    function BPMNEdge(sourceKey, key, fromKey, toKey) {
        var _this = _super.call(this, key, fromKey, toKey) || this;
        _this.sourceKey = sourceKey;
        return _this;
    }
    return BPMNEdge;
}(Structures_1.Edge));


/***/ }),

/***/ 5885:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Exporter = void 0;
var Shape_1 = __webpack_require__(5503);
var Connector_1 = __webpack_require__(7959);
var Utils_1 = __webpack_require__(8675);
var Exporter = (function () {
    function Exporter() {
    }
    Exporter.prototype.export = function (model) {
        var obj = {
            page: {},
            connectors: [],
            shapes: []
        };
        obj.page = {
            "width": model.size.width,
            "height": model.size.height,
            "pageColor": model.pageColor,
            "pageWidth": model.pageSize.width,
            "pageHeight": model.pageSize.height,
            "pageLandscape": model.pageLandscape
        };
        this.exportItemsCore(model.items, obj);
        return JSON.stringify(obj);
    };
    Exporter.prototype.exportItems = function (items) {
        var obj = {
            connectors: [],
            shapes: []
        };
        this.exportItemsCore(items, obj);
        return JSON.stringify(obj);
    };
    Exporter.prototype.exportItemsCore = function (items, obj) {
        var _this = this;
        items.forEach(function (item) {
            if (item instanceof Shape_1.Shape)
                obj.shapes.push(_this.exportShape(item));
            else if (item instanceof Connector_1.Connector) {
                var connectorObj = _this.exportConnector(item);
                if (item.beginItem) {
                    connectorObj["beginItemKey"] = item.beginItem.key;
                    connectorObj["beginConnectionPointIndex"] = item.beginConnectionPointIndex;
                }
                if (item.endItem) {
                    connectorObj["endItemKey"] = item.endItem.key;
                    connectorObj["endConnectionPointIndex"] = item.endConnectionPointIndex;
                }
                obj.connectors.push(connectorObj);
            }
        });
    };
    Exporter.prototype.exportItem = function (item) {
        return {
            "key": item.key,
            "dataKey": item.dataKey,
            "customData": Utils_1.ObjectUtils.cloneObject(item.customData),
            "locked": item.locked,
            "zIndex": item.zIndex
        };
    };
    Exporter.prototype.exportShape = function (shape) {
        var result = this.exportItem(shape);
        result["type"] = shape.description.key;
        result["text"] = shape.text;
        if (!shape.image.isEmpty)
            result["imageUrl"] = shape.image.exportUrl;
        result["x"] = shape.position.x;
        result["y"] = shape.position.y;
        result["width"] = shape.size.width;
        result["height"] = shape.size.height;
        var paramsObj = shape.parameters.toObject();
        if (paramsObj)
            result["parameters"] = paramsObj;
        var styleObj = shape.style.toObject();
        if (styleObj)
            result["style"] = styleObj;
        var styleTextObj = shape.styleText.toObject();
        if (styleTextObj)
            result["styleText"] = styleTextObj;
        if (shape.children.length)
            result["childKeys"] = shape.children.map(function (child) { return child.key; });
        if (!shape.expanded)
            result["expanded"] = false;
        if (shape.expandedSize) {
            result["expandedWidth"] = shape.expandedSize.width;
            result["expandedHeight"] = shape.expandedSize.height;
        }
        return result;
    };
    Exporter.prototype.exportConnector = function (connector) {
        var result = this.exportItem(connector);
        result["points"] = connector.points.map(function (p) { return { "x": p.x, "y": p.y }; });
        var textObj = connector.texts.toObject();
        if (textObj)
            result["texts"] = textObj;
        var propsObj = connector.properties.toObject();
        if (propsObj)
            result["properties"] = propsObj;
        var styleObj = connector.style.toObject();
        if (styleObj)
            result["style"] = styleObj;
        var styleTextObj = connector.styleText.toObject();
        if (styleTextObj)
            result["styleText"] = styleTextObj;
        var context = connector.tryCreateRenderPointsContext();
        if (context)
            result["context"] = context.toObject();
        return result;
    };
    Exporter.prototype.exportSvg = function (modelSize, pageColor, exportManager, callback) {
        exportManager.exportSvgImage(modelSize, pageColor, callback);
    };
    Exporter.prototype.exportPng = function (modelSize, pageColor, exportManager, callback, useCanvgForExportToImage) {
        exportManager.exportPngImage(modelSize, pageColor, callback, useCanvgForExportToImage);
    };
    Exporter.prototype.exportJpg = function (modelSize, pageColor, exportManager, callback, useCanvgForExportToImage) {
        exportManager.exportJpgImage(modelSize, pageColor, callback, useCanvgForExportToImage);
    };
    return Exporter;
}());
exports.Exporter = Exporter;


/***/ }),

/***/ 6572:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImportUtils = void 0;
var ImportUtils = (function () {
    function ImportUtils() {
    }
    ImportUtils.parseJSON = function (json) {
        if (!json || json === "")
            return {};
        try {
            return JSON.parse(json);
        }
        catch (_a) {
            return {};
        }
    };
    ImportUtils.createDocument = function (xml) {
        var parser = new DOMParser();
        return parser.parseFromString(xml, "application/xml");
    };
    return ImportUtils;
}());
exports.ImportUtils = ImportUtils;


/***/ }),

/***/ 2406:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Importer = void 0;
var Shape_1 = __webpack_require__(5503);
var Utils_1 = __webpack_require__(8675);
var size_1 = __webpack_require__(6353);
var point_1 = __webpack_require__(8900);
var ShapeDescriptionManager_1 = __webpack_require__(8397);
var Connector_1 = __webpack_require__(7959);
var ImageInfo_1 = __webpack_require__(6617);
var ImporterBase_1 = __webpack_require__(8577);
var ImportUtils_1 = __webpack_require__(6572);
var color_1 = __webpack_require__(13);
var ConnectorRenderPointsContext_1 = __webpack_require__(1510);
var Importer = (function (_super) {
    __extends(Importer, _super);
    function Importer(shapeDescriptionManager, json) {
        var _this = _super.call(this, shapeDescriptionManager) || this;
        _this.obj = ImportUtils_1.ImportUtils.parseJSON(json);
        return _this;
    }
    Importer.prototype.getObject = function () {
        return this.obj;
    };
    Importer.prototype.getPageObject = function (obj) {
        return obj["page"];
    };
    Importer.prototype.getShapeObjects = function (obj) {
        return obj["shapes"];
    };
    Importer.prototype.getConnectorObjects = function (obj) {
        return obj["connectors"];
    };
    Importer.prototype.importPageSettings = function (model, pageObj) {
        if (!pageObj)
            return;
        this.assert(pageObj["width"], "number");
        this.assert(pageObj["height"], "number");
        if (typeof pageObj["width"] === "number")
            model.size.width = pageObj["width"];
        if (typeof pageObj["height"] === "number")
            model.size.height = pageObj["height"];
        if (typeof pageObj["pageColor"] === "number")
            model.pageColor = pageObj["pageColor"];
        else if (typeof pageObj["pageColor"] === "string")
            model.pageColor = color_1.ColorUtils.fromString(pageObj["pageColor"]);
        if (typeof pageObj["pageWidth"] === "number")
            model.pageSize.width = pageObj["pageWidth"];
        if (typeof pageObj["pageHeight"] === "number")
            model.pageSize.height = pageObj["pageHeight"];
        if (typeof pageObj["pageLandscape"] === "boolean")
            model.pageLandscape = pageObj["pageLandscape"];
    };
    Importer.prototype.importShape = function (shapeObj) {
        this.assert(shapeObj["key"], "string");
        this.assert(shapeObj["x"], "number");
        this.assert(shapeObj["y"], "number");
        this.assert(shapeObj["type"], "string");
        var shapeType = shapeObj["type"];
        var description = this.shapeDescriptionManager.get(shapeType);
        var position = new point_1.Point(shapeObj["x"], shapeObj["y"]);
        var shape = new Shape_1.Shape(description || ShapeDescriptionManager_1.ShapeDescriptionManager.default, position);
        shape.key = shapeObj["key"];
        if (typeof shapeObj["dataKey"] === "string" || typeof shapeObj["dataKey"] === "number")
            shape.dataKey = shapeObj["dataKey"];
        if (typeof shapeObj["customData"] === "object")
            shape.customData = Utils_1.ObjectUtils.cloneObject(shapeObj["customData"]);
        if (typeof shapeObj["locked"] === "boolean")
            shape.locked = shapeObj["locked"];
        if (typeof shapeObj["width"] === "number")
            shape.size.width = shapeObj["width"];
        if (typeof shapeObj["height"] === "number")
            shape.size.height = shapeObj["height"];
        if (typeof shapeObj["text"] === "string")
            shape.text = shapeObj["text"];
        if (typeof shapeObj["imageUrl"] === "string")
            shape.image = new ImageInfo_1.ImageInfo(shapeObj["imageUrl"]);
        if (shapeObj["parameters"]) {
            shape.parameters.fromObject(shapeObj["parameters"]);
            shape.description.normalizeParameters(shape, shape.parameters);
        }
        if (shapeObj["style"])
            shape.style.fromObject(shapeObj["style"]);
        if (shapeObj["styleText"])
            shape.styleText.fromObject(shapeObj["styleText"]);
        if (typeof shapeObj["zIndex"] === "number")
            shape.zIndex = shapeObj["zIndex"];
        if (Array.isArray(shapeObj["childKeys"]))
            shape["childKeys"] = shapeObj["childKeys"].slice();
        if (typeof shapeObj["expanded"] === "boolean")
            shape.expanded = shapeObj["expanded"];
        if (typeof shapeObj["expandedWidth"] === "number" && typeof shapeObj["expandedHeight"] === "number")
            shape.expandedSize = new size_1.Size(shapeObj["expandedWidth"], shapeObj["expandedHeight"]);
        return shape;
    };
    Importer.prototype.importShapeChildren = function (shapeObj, shape) {
        return [];
    };
    Importer.prototype.importConnector = function (connectorObj) {
        var _this = this;
        this.assert(connectorObj["key"], "string");
        if (!Array.isArray(connectorObj["points"]))
            throw Error("Invalid Format");
        var points = connectorObj["points"].map(function (pt) {
            _this.assert(pt["x"], "number");
            _this.assert(pt["y"], "number");
            return new point_1.Point(pt["x"], pt["y"]);
        });
        var connector = new Connector_1.Connector(points);
        connector.key = connectorObj["key"];
        if (typeof connectorObj["dataKey"] === "string" || typeof connectorObj["dataKey"] === "number")
            connector.dataKey = connectorObj["dataKey"];
        if (typeof connectorObj["customData"] === "object")
            connector.customData = Utils_1.ObjectUtils.cloneObject(connectorObj["customData"]);
        if (typeof connectorObj["locked"] === "boolean")
            connector.locked = connectorObj["locked"];
        connector.endConnectionPointIndex = typeof connectorObj["endConnectionPointIndex"] === "number" ? connectorObj["endConnectionPointIndex"] : -1;
        connector.beginConnectionPointIndex = typeof connectorObj["beginConnectionPointIndex"] === "number" ? connectorObj["beginConnectionPointIndex"] : -1;
        if (connectorObj["endItemKey"] !== undefined)
            this.assert(connectorObj["endItemKey"], "string");
        if (connectorObj["beginItemKey"] !== undefined)
            this.assert(connectorObj["beginItemKey"], "string");
        connector["endItemKey"] = connectorObj["endItemKey"];
        connector["beginItemKey"] = connectorObj["beginItemKey"];
        if (connectorObj["texts"])
            connector.texts.fromObject(connectorObj["texts"]);
        if (connectorObj["properties"])
            connector.properties.fromObject(connectorObj["properties"]);
        if (connectorObj["style"])
            connector.style.fromObject(connectorObj["style"]);
        if (connectorObj["styleText"])
            connector.styleText.fromObject(connectorObj["styleText"]);
        if (typeof connectorObj["zIndex"] === "number")
            connector.zIndex = connectorObj["zIndex"];
        if (connectorObj["context"] !== undefined)
            connector.replaceRenderPoints(ConnectorRenderPointsContext_1.ConnectorRenderPointsContext.fromObject(connectorObj["context"]), false);
        return connector;
    };
    return Importer;
}(ImporterBase_1.ImporterBase));
exports.Importer = Importer;


/***/ }),

/***/ 8577:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImporterBase = void 0;
var Model_1 = __webpack_require__(6613);
var Shape_1 = __webpack_require__(5503);
var ImporterBase = (function () {
    function ImporterBase(shapeDescriptionManager) {
        this.shapeDescriptionManager = shapeDescriptionManager;
    }
    ImporterBase.prototype.import = function () {
        var model = new Model_1.DiagramModel();
        var obj = this.getObject();
        this.importPageSettings(model, this.getPageObject(obj));
        var shapes = this.importShapes(this.getShapeObjects(obj));
        for (var i = 0; i < shapes.length; i++) {
            var shape = shapes[i];
            if (model.findItem(shape.key))
                throw Error("Item key is duplicated");
            model.pushItem(shape);
        }
        var connectors = this.importConnectors(this.getConnectorObjects(obj));
        for (var i = 0; i < connectors.length; i++) {
            var connector = connectors[i];
            connector.endItem = model.findItem(connector["endItemKey"]) || undefined;
            delete connector["endItemKey"];
            connector.beginItem = model.findItem(connector["beginItemKey"]) || undefined;
            delete connector["beginItemKey"];
            if (model.findItem(connector.key))
                throw Error("Item key is duplicated");
            model.pushItem(connector);
            this.updateConnections(connector);
        }
        this.updateChildren(model.items, function (key) { return model.findItem(key); });
        return model;
    };
    ImporterBase.prototype.importItems = function (model) {
        var result = [];
        var obj = this.getObject();
        var itemHash = {};
        var shapes = this.importShapes(this.getShapeObjects(obj));
        var key;
        for (var i = 0; i < shapes.length; i++) {
            var shape = shapes[i];
            var oldKey = shape.key;
            key = model.getNextKey();
            shape.key = key;
            itemHash[oldKey] = shape;
            if (shape.dataKey !== undefined)
                shape.dataKey = undefined;
            result.push(shape);
        }
        var connectors = this.importConnectors(this.getConnectorObjects(obj));
        for (var i = 0; i < connectors.length; i++) {
            var connector = connectors[i];
            var oldKey = connector.key;
            key = model.getNextKey();
            connector.key = key;
            itemHash[oldKey] = connector;
            if (connector.dataKey !== undefined)
                connector.dataKey = undefined;
            var endItemKey = connector["endItemKey"];
            connector.endItem = itemHash[endItemKey];
            delete connector["endItemKey"];
            var beginItemKey = connector["beginItemKey"];
            connector.beginItem = itemHash[beginItemKey];
            delete connector["beginItemKey"];
            result.push(connector);
            this.updateConnections(connector);
        }
        this.updateChildren(result, function (key) { return itemHash[key]; });
        return result;
    };
    ImporterBase.prototype.importItemsData = function (model) {
        var obj = this.getObject();
        var shapes = this.importShapes(this.getShapeObjects(obj));
        var shapeDataKeys = {};
        for (var i = 0; i < shapes.length; i++) {
            var srcShape = shapes[i];
            var destShape = void 0;
            if (srcShape.dataKey !== undefined)
                destShape = model.findShapeByDataKey(srcShape.dataKey);
            if (destShape) {
                destShape.dataKey = srcShape.dataKey;
                shapeDataKeys[srcShape.key] = srcShape.dataKey;
                destShape.locked = srcShape.locked;
                destShape.position = srcShape.position.clone();
                destShape.expanded = srcShape.expanded;
                if (srcShape.expandedSize)
                    destShape.expandedSize = srcShape.expandedSize.clone();
                destShape.size = srcShape.size.clone();
                destShape.parameters = srcShape.parameters.clone();
                destShape.style = srcShape.style.clone();
                destShape.styleText = srcShape.styleText.clone();
                destShape.zIndex = srcShape.zIndex;
                destShape.text = srcShape.text;
                destShape.description = srcShape.description;
                destShape.image = srcShape.image.clone();
            }
        }
        var connectors = this.importConnectors(this.getConnectorObjects(obj));
        for (var i = 0; i < connectors.length; i++) {
            var srcConnector = connectors[i];
            var destConnector = void 0;
            if (srcConnector.dataKey !== undefined)
                destConnector = model.findConnectorByDataKey(srcConnector.dataKey);
            if (!destConnector)
                destConnector = model.findConnectorByBeginEndDataKeys(shapeDataKeys[srcConnector["beginItemKey"]], shapeDataKeys[srcConnector["endItemKey"]]);
            if (destConnector) {
                destConnector.dataKey = srcConnector.dataKey;
                destConnector.locked = srcConnector.locked;
                destConnector.points = srcConnector.points.slice();
                destConnector.properties = srcConnector.properties.clone();
                destConnector.style = srcConnector.style.clone();
                destConnector.endConnectionPointIndex = srcConnector.endConnectionPointIndex;
                destConnector.beginConnectionPointIndex = srcConnector.beginConnectionPointIndex;
                destConnector.texts = srcConnector.texts.clone();
                destConnector.styleText = srcConnector.styleText.clone();
                destConnector.zIndex = srcConnector.zIndex;
            }
        }
    };
    ImporterBase.prototype.importShapes = function (shapeObjs) {
        var result = [];
        if (!shapeObjs)
            return result;
        if (!Array.isArray(shapeObjs))
            throw Error("Invalid Format");
        for (var i = 0; i < shapeObjs.length; i++) {
            var shapeObj = shapeObjs[i];
            var shape = this.importShape(shapeObj);
            result.push(shape);
            result = result.concat(this.importShapeChildren(shapeObj, shape));
        }
        return result;
    };
    ImporterBase.prototype.importConnectors = function (connectorObjs) {
        var result = [];
        if (!connectorObjs)
            return result;
        if (!Array.isArray(connectorObjs))
            throw Error("Invalid Format");
        for (var i = 0; i < connectorObjs.length; i++) {
            var shapeObj = connectorObjs[i];
            result.push(this.importConnector(shapeObj));
        }
        return result;
    };
    ImporterBase.prototype.updateChildren = function (items, findItem) {
        items.forEach(function (item) {
            if (item instanceof Shape_1.Shape && item["childKeys"]) {
                item["childKeys"].forEach(function (childKey) {
                    var child = findItem(childKey);
                    if (child) {
                        if (item.children.indexOf(child) === -1)
                            item.children.push(child);
                        child.container = item;
                    }
                });
                delete item["childKeys"];
            }
        });
    };
    ImporterBase.prototype.updateConnections = function (connector) {
        if (connector.endItem)
            if (connector.endItem instanceof Shape_1.Shape) {
                connector.endItem.attachedConnectors.push(connector);
                connector.points[connector.points.length - 1] = connector.endItem.getConnectionPointPosition(connector.endConnectionPointIndex, connector.points[connector.points.length - 2]);
            }
            else {
                connector.endItem = undefined;
                connector.endConnectionPointIndex = -1;
            }
        if (connector.beginItem)
            if (connector.beginItem instanceof Shape_1.Shape) {
                connector.beginItem.attachedConnectors.push(connector);
                connector.points[0] = connector.beginItem.getConnectionPointPosition(connector.beginConnectionPointIndex, connector.points[1]);
            }
            else {
                connector.beginItem = undefined;
                connector.beginConnectionPointIndex = -1;
            }
    };
    ImporterBase.prototype.assert = function (value, type) {
        if (value === undefined)
            throw Error("Invalid Format");
        if (type !== undefined && typeof value !== type)
            throw Error("Invalid Format");
    };
    return ImporterBase;
}());
exports.ImporterBase = ImporterBase;


/***/ }),

/***/ 780:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.XmlImporter = void 0;
var Connector_1 = __webpack_require__(7959);
var Shape_1 = __webpack_require__(5503);
var ImporterBase_1 = __webpack_require__(8577);
var ShapeTypes_1 = __webpack_require__(2259);
var ShapeDescriptionManager_1 = __webpack_require__(8397);
var size_1 = __webpack_require__(6353);
var point_1 = __webpack_require__(8900);
var ImportUtils_1 = __webpack_require__(6572);
var color_1 = __webpack_require__(13);
var unit_converter_1 = __webpack_require__(9291);
var XmlImporter = (function (_super) {
    __extends(XmlImporter, _super);
    function XmlImporter(shapeDescriptionManager, xml) {
        var _this = _super.call(this, shapeDescriptionManager) || this;
        _this.doc = ImportUtils_1.ImportUtils.createDocument(xml);
        return _this;
    }
    XmlImporter.prototype.getObject = function () {
        return this.doc;
    };
    XmlImporter.prototype.getPageObject = function (obj) {
        var pageElements = this.doc.querySelectorAll("[ItemKind='DiagramRoot']");
        return pageElements && pageElements[0];
    };
    XmlImporter.prototype.getShapeObjects = function (obj) {
        var shapeObjs = [];
        this.doc.querySelectorAll("[ItemKind='DiagramRoot'] > Children > [ItemKind='DiagramShape']").forEach(function (obj) { shapeObjs.push(obj); });
        this.doc.querySelectorAll("[ItemKind='DiagramRoot'] > Children > [ItemKind='DiagramContainer']").forEach(function (obj) { shapeObjs.push(obj); });
        return shapeObjs;
    };
    XmlImporter.prototype.getConnectorObjects = function (obj) {
        var connectorObjs = [];
        this.doc.querySelectorAll("[ItemKind='DiagramRoot'] > Children > [ItemKind='DiagramConnector']").forEach(function (obj) { connectorObjs.push(obj); });
        return connectorObjs;
    };
    XmlImporter.prototype.importPageSettings = function (model, pageObj) {
        if (!pageObj)
            return;
        var pageSizeAttr = pageObj.getAttribute("PageSize");
        var pageSize = this.getSize(pageSizeAttr);
        if (pageSize) {
            model.size = pageSize.clone();
            model.pageSize = pageSize.clone();
        }
    };
    XmlImporter.prototype.importShape = function (shapeObj) {
        var positionAttr = shapeObj.getAttribute("Position");
        var position = this.getPoint(positionAttr);
        var shapeAttr = shapeObj.getAttribute("Shape");
        var shapeType = this.getShapeType(shapeAttr);
        var description = this.shapeDescriptionManager.get(shapeType);
        var shape = new Shape_1.Shape(description || ShapeDescriptionManager_1.ShapeDescriptionManager.default, position);
        shape.key = this.getItemKey(shapeObj);
        var sizeAttr = shapeObj.getAttribute("Size");
        var size = this.getSize(sizeAttr);
        if (size)
            shape.size = size;
        var contentAttr = shapeObj.getAttribute("Content");
        if (typeof contentAttr === "string")
            shape.text = contentAttr;
        else {
            var headerAttr = shapeObj.getAttribute("Header");
            if (typeof headerAttr === "string")
                shape.text = headerAttr;
        }
        this.importStyle(shapeObj, shape);
        return shape;
    };
    XmlImporter.prototype.importShapeChildren = function (shapeObj, shape) {
        var childShapeObjs = [];
        shapeObj.setAttribute("dxDiagram", "");
        this.doc.querySelectorAll("[dxDiagram] > Children > [ItemKind='DiagramShape']").forEach(function (obj) { childShapeObjs.push(obj); });
        this.doc.querySelectorAll("[dxDiagram] > Children > [ItemKind='DiagramContainer']").forEach(function (obj) { childShapeObjs.push(obj); });
        shapeObj.removeAttribute("dxDiagram");
        var result = [];
        if (!childShapeObjs)
            return result;
        for (var i = 0; i < childShapeObjs.length; i++) {
            var childShapeObj = childShapeObjs[i];
            var childShape = this.importShape(childShapeObj);
            childShape.key = shape.key + "," + childShape.key;
            var rect = shape.clientRectangle;
            childShape.position = childShape.position.clone().offset(rect.x, rect.y);
            if (!shape["childKeys"])
                shape["childKeys"] = [];
            shape["childKeys"].push(childShape.key);
            result.push(childShape);
            result = result.concat(this.importShapeChildren(childShapeObj, childShape));
        }
        return result;
    };
    XmlImporter.prototype.importConnector = function (connectorObj) {
        var _this = this;
        var points = [];
        var beginPointAttr = connectorObj.getAttribute("BeginPoint");
        var beginPoint = this.getPoint(beginPointAttr);
        if (beginPoint)
            points.push(beginPoint);
        var pointsAttr = connectorObj.getAttribute("Points");
        pointsAttr.split(" ").forEach(function (pointAttr) {
            var point = _this.getPoint(pointAttr);
            if (point)
                points.push(point);
        });
        var endPointAttr = connectorObj.getAttribute("EndPoint");
        var endPoint = this.getPoint(endPointAttr);
        if (endPoint)
            points.push(endPoint);
        var connector = new Connector_1.Connector(points);
        connector.key = this.getItemKey(connectorObj);
        var endItemPointIndexAttr = connectorObj.getAttribute("EndItemPointIndex");
        var endItemPointIndex = parseInt(endItemPointIndexAttr);
        connector.endConnectionPointIndex = !isNaN(endItemPointIndex) ? endItemPointIndex : -1;
        var beginItemPointIndexAttr = connectorObj.getAttribute("BeginItemPointIndex");
        var beginItemPointIndex = parseInt(beginItemPointIndexAttr);
        connector.beginConnectionPointIndex = !isNaN(beginItemPointIndex) ? beginItemPointIndex : -1;
        var endItemAttr = connectorObj.getAttribute("EndItem");
        if (endItemAttr !== undefined)
            this.assert(endItemAttr, "string");
        var beginItemAttr = connectorObj.getAttribute("BeginItem");
        if (beginItemAttr !== undefined)
            this.assert(beginItemAttr, "string");
        connector["endItemKey"] = endItemAttr;
        connector["beginItemKey"] = beginItemAttr;
        var contentAttr = connectorObj.getAttribute("Content");
        if (typeof contentAttr === "string")
            connector.setText(contentAttr);
        this.importStyle(connectorObj, connector);
        return connector;
    };
    XmlImporter.prototype.importStyle = function (obj, item) {
        var backgroundAttr = obj.getAttribute("Background");
        if (typeof backgroundAttr === "string")
            item.style["fill"] = this.getColor(backgroundAttr);
        var strokeAttr = obj.getAttribute("Stroke");
        if (typeof strokeAttr === "string")
            item.style["stroke"] = this.getColor(strokeAttr);
        var foregroundAttr = obj.getAttribute("Foreground");
        if (typeof foregroundAttr === "string")
            item.styleText["fill"] = this.getColor(foregroundAttr);
        var fontFamilyAttr = obj.getAttribute("FontFamily");
        if (typeof fontFamilyAttr === "string")
            item.styleText["font-family"] = fontFamilyAttr;
        var fontSizeAttr = obj.getAttribute("FontSize");
        if (typeof fontSizeAttr === "string")
            item.styleText["font-size"] = fontSizeAttr;
        var fontWeightAttr = obj.getAttribute("FontWeight");
        if (fontWeightAttr === "Bold")
            item.styleText["font-weight"] = "bold";
        var fontStyleAttr = obj.getAttribute("FontStyle");
        if (fontStyleAttr === "Italic")
            item.styleText["font-style"] = "italic";
        var textDecorationsAttr = obj.getAttribute("TextDecorations");
        if (textDecorationsAttr === "Underline")
            item.styleText["text-decoration"] = "underline";
        var textAlignmentAttr = obj.getAttribute("TextAlignment");
        if (textAlignmentAttr === "Left")
            item.styleText["text-anchor"] = "start";
        else if (textAlignmentAttr === "Right")
            item.styleText["text-anchor"] = "end";
        else if (textAlignmentAttr === "Center")
            item.styleText["text-anchor"] = "middle";
    };
    XmlImporter.prototype.getShapeType = function (shapeAttr) {
        if (XmlImporter.shapeTypes[shapeAttr])
            return XmlImporter.shapeTypes[shapeAttr];
        if (shapeAttr && shapeAttr.toLowerCase().indexOf("container") > -1)
            return ShapeTypes_1.ShapeTypes.VerticalContainer;
        return ShapeTypes_1.ShapeTypes.Rectangle;
    };
    XmlImporter.prototype.getItemKey = function (obj) {
        return (parseInt(obj.tagName.replace("Item", "")) - 1).toString();
    };
    XmlImporter.prototype.getNumbers = function (s) {
        var parts = s.split(",");
        return parts && parts.length ? parts.map(function (part) { return +part; }) : [];
    };
    XmlImporter.prototype.getSize = function (attrValue) {
        if (attrValue) {
            var numbers = this.getNumbers(attrValue);
            if (numbers.length >= 2) {
                this.assert(numbers[0], "number");
                this.assert(numbers[1], "number");
                return new size_1.Size(unit_converter_1.UnitConverter.pixelsToTwips(numbers[0]), unit_converter_1.UnitConverter.pixelsToTwips(numbers[1]));
            }
        }
    };
    XmlImporter.prototype.getPoint = function (attrValue) {
        if (attrValue) {
            var numbers = this.getNumbers(attrValue);
            if (numbers.length >= 2) {
                this.assert(numbers[0], "number");
                this.assert(numbers[1], "number");
                return new point_1.Point(unit_converter_1.UnitConverter.pixelsToTwips(numbers[0]), unit_converter_1.UnitConverter.pixelsToTwips(numbers[1]));
            }
        }
    };
    XmlImporter.prototype.getColor = function (attrValue) {
        attrValue = attrValue.charAt(0) === "#" ? attrValue.substr(1) : attrValue;
        var color = parseInt(attrValue, 16);
        return !isNaN(color) ? color_1.ColorUtils.colorToHash(color) : undefined;
    };
    XmlImporter.shapeTypes = {
        "BasicShapes.Rectangle": ShapeTypes_1.ShapeTypes.Rectangle,
        "BasicShapes.Ellipse": ShapeTypes_1.ShapeTypes.Ellipse,
        "BasicShapes.Triangle": ShapeTypes_1.ShapeTypes.Triangle,
        "BasicShapes.Pentagon": ShapeTypes_1.ShapeTypes.Pentagon,
        "BasicShapes.Hexagon": ShapeTypes_1.ShapeTypes.Hexagon,
        "BasicShapes.Octagon": ShapeTypes_1.ShapeTypes.Octagon,
        "BasicShapes.Diamond": ShapeTypes_1.ShapeTypes.Diamond,
        "BasicShapes.Cross": ShapeTypes_1.ShapeTypes.Cross,
        "BasicShapes.Star5": ShapeTypes_1.ShapeTypes.Star,
        "BasicFlowchartShapes.StartEnd": ShapeTypes_1.ShapeTypes.Terminator,
        "BasicFlowchartShapes.Data": ShapeTypes_1.ShapeTypes.Data,
        "BasicFlowchartShapes.Database": ShapeTypes_1.ShapeTypes.Database,
        "BasicFlowchartShapes.ExternalData": ShapeTypes_1.ShapeTypes.StoredData,
        "BasicFlowchartShapes.Process": ShapeTypes_1.ShapeTypes.Process,
        "BasicFlowchartShapes.Decision": ShapeTypes_1.ShapeTypes.Decision,
        "BasicFlowchartShapes.Subprocess": ShapeTypes_1.ShapeTypes.PredefinedProcess,
        "BasicFlowchartShapes.Document": ShapeTypes_1.ShapeTypes.Document,
        "BasicFlowchartShapes.Custom1": ShapeTypes_1.ShapeTypes.ManualInput,
        "BasicFlowchartShapes.Custom2": ShapeTypes_1.ShapeTypes.ManualOperation,
        "ArrowShapes.SimpleArrow": ShapeTypes_1.ShapeTypes.ArrowLeft,
        "ArrowShapes.SimpleDoubleArrow": ShapeTypes_1.ShapeTypes.ArrowLeftRight
    };
    return XmlImporter;
}(ImporterBase_1.ImporterBase));
exports.XmlImporter = XmlImporter;


/***/ }),

/***/ 5227:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LayoutBuilder = void 0;
var LayoutSettings_1 = __webpack_require__(8710);
var LayoutBuilder = (function () {
    function LayoutBuilder(settings, graph) {
        this.settings = settings;
        this.graph = graph;
    }
    LayoutBuilder.prototype.getBreadthNodeSizeCore = function (node, excludeMargins) {
        var size = this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical ? node.size.width : node.size.height;
        if (!excludeMargins)
            size += this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical ? (node.margin.left + node.margin.right) : (node.margin.top + node.margin.bottom);
        return size;
    };
    LayoutBuilder.prototype.getDepthNodeSizeCore = function (node) {
        return this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal ?
            (node.size.width + node.margin.left + node.margin.right) :
            (node.size.height + node.margin.top + node.margin.bottom);
    };
    LayoutBuilder.prototype.chooseDirectionValue = function (near, far) {
        return this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward ? near : far;
    };
    LayoutBuilder.prototype.getDirectionValue = function (value) {
        return this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward ? value : -value;
    };
    LayoutBuilder.prototype.getComponentOffset = function (graphLayout) {
        var rect = graphLayout.getRectangle(true);
        var offset = this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical ? rect.width : rect.height;
        return offset + this.settings.componentSpacing;
    };
    LayoutBuilder.prototype.setComponentOffset = function (graphLayout, offset) {
        return this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical ?
            graphLayout.offsetNodes(offset) :
            graphLayout.offsetNodes(0, offset);
    };
    return LayoutBuilder;
}());
exports.LayoutBuilder = LayoutBuilder;


/***/ }),

/***/ 1256:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EdgeOnLayer = exports.NodeOnLayer = exports.SugiyamaNodesOrderer = exports.SugiyamaLayerDistributor = exports.SugiyamaLayoutBuilder = void 0;
var BaseBuilder_1 = __webpack_require__(5227);
var Graph_1 = __webpack_require__(213);
var NodeLayout_1 = __webpack_require__(617);
var Structures_1 = __webpack_require__(8217);
var ListUtils_1 = __webpack_require__(701);
var search_1 = __webpack_require__(2400);
var point_1 = __webpack_require__(8900);
var LayoutSettings_1 = __webpack_require__(8710);
var GraphLayout_1 = __webpack_require__(8119);
var Connector_1 = __webpack_require__(7959);
var CycleRemover_1 = __webpack_require__(7309);
var SugiyamaLayoutBuilder = (function (_super) {
    __extends(SugiyamaLayoutBuilder, _super);
    function SugiyamaLayoutBuilder() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SugiyamaLayoutBuilder.prototype.build = function () {
        var _this = this;
        var offset = 0;
        var layout = new GraphLayout_1.GraphLayout();
        var nodeOrderer = new SugiyamaNodesOrderer();
        this.graph.getConnectedComponents()
            .forEach(function (component) {
            var acyclicGraphInfo = CycleRemover_1.CycleRemover.removeCycles(component);
            var layers = SugiyamaLayerDistributor.getLayers(acyclicGraphInfo.graph);
            var orderedGraph = nodeOrderer.orderNodes(acyclicGraphInfo.graph, layers);
            var removedEdges = Object.keys(acyclicGraphInfo.removedEdges).map(function (ek) { return component.getEdge(ek); });
            var coordinatedGraph = nodeOrderer.assignAbsCoordinates(orderedGraph);
            var componentLayout = _this.createInfoGraphLayout(coordinatedGraph, acyclicGraphInfo.reversedEdges, removedEdges);
            layout.extend(_this.setComponentOffset(componentLayout, offset));
            offset += _this.getComponentOffset(componentLayout);
        });
        return layout;
    };
    SugiyamaLayoutBuilder.prototype.createInfoGraphLayout = function (coordinatedGraph, reversedEdges, removedEdges) {
        var _this = this;
        var currentPosition = new point_1.Point(0, 0);
        var items = coordinatedGraph.items;
        var sortedLayers = new ListUtils_1.HashSet(items.map(function (n) { return n.layer; }).sort(function (a, b) { return a - b; }));
        var absOffsetInfo = this.getAbsOffsetInfo(coordinatedGraph.items);
        var positions = {};
        var totalDepth = 0;
        var leftEdge = Number.MAX_SAFE_INTEGER || Number.MAX_VALUE;
        var rightEdge = Number.MIN_SAFE_INTEGER || Number.MAX_VALUE;
        var _loop_1 = function (i) {
            var layer = sortedLayers.item(i);
            var maxDepthLayer = 0;
            items
                .filter(function (n) { return n.layer === layer; })
                .sort(function (a, b) { return a.position - b.position; })
                .forEach(function (n) {
                var depthNodeSize = _this.getDepthNodeSize(n);
                var directionOffset = _this.chooseDirectionValue(0, depthNodeSize);
                var absPosition = _this.getAbsPosition(n.position, _this.getBreadthNodeSize(n), absOffsetInfo);
                currentPosition = _this.setBreadth(currentPosition, absPosition);
                var nodePosition = _this.setDepthOffset(currentPosition, -directionOffset);
                positions[n.key] = nodePosition;
                if (n.isDummy)
                    return;
                var breadth = _this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal ? nodePosition.y : nodePosition.x;
                leftEdge = Math.min(leftEdge, breadth);
                rightEdge = Math.max(rightEdge, breadth + _this.getBreadthNodeSize(n));
                maxDepthLayer = Math.max(maxDepthLayer, _this.getDepthNodeSize(n));
            });
            totalDepth += maxDepthLayer;
            currentPosition = this_1.setBreadth(currentPosition, 0);
            currentPosition = this_1.setDepthOffset(currentPosition, this_1.getDirectionValue(maxDepthLayer + this_1.settings.layerSpacing));
        };
        var this_1 = this;
        for (var i = 0; i < sortedLayers.length; i++) {
            _loop_1(i);
        }
        totalDepth += (sortedLayers.length - 1) * this.settings.layerSpacing;
        var layout = new GraphLayout_1.GraphLayout();
        this.createNodesLayout(coordinatedGraph, layout, leftEdge, totalDepth, positions);
        this.createEdgesLayout(coordinatedGraph, layout, reversedEdges, removedEdges);
        return layout;
    };
    SugiyamaLayoutBuilder.prototype.createNodesLayout = function (infoGraph, layout, leftEdge, totalDepth, positions) {
        var _this = this;
        var offset = this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical ?
            new point_1.Point(-leftEdge, this.chooseDirectionValue(0, totalDepth)) :
            new point_1.Point(this.chooseDirectionValue(0, totalDepth), -leftEdge);
        infoGraph.items.forEach(function (n) {
            if (!n.isDummy) {
                var node = _this.graph.getNode(n.key);
                layout.addNode(new NodeLayout_1.NodeLayout(node, positions[n.key].clone().offset(offset.x, offset.y)));
            }
        });
    };
    SugiyamaLayoutBuilder.prototype.createEdgesLayout = function (infoGraph, layout, reversedEdges, removedEdges) {
        var DIRECT = this.getDirectEdgeLayout();
        var TOP_TO_BOTTOM = this.getDiffLevelEdgeLayout(true);
        var BOTTOM_TO_TOP = this.getDiffLevelEdgeLayout(false);
        var TOP_TO_TOP = this.getSameLevelEdgeLayout(true);
        var BOTTOM_TO_BOTTOM = this.getSameLevelEdgeLayout(false);
        var occupied = {};
        infoGraph.edges
            .filter(function (e) { return !e.isDummy; })
            .concat(removedEdges.map(function (e) { return new EdgeOnLayer(e.key, false, e.from, e.to); }))
            .sort(function (a, b) {
            return (infoGraph.getNode(a.originFrom).layer - infoGraph.getNode(b.originFrom).layer) ||
                (infoGraph.getNode(a.to).layer - infoGraph.getNode(b.to).layer);
        })
            .forEach(function (e) {
            var isReversed = reversedEdges[e.key];
            var from = infoGraph.getNode(isReversed ? e.to : e.originFrom);
            var to = infoGraph.getNode(isReversed ? e.originFrom : e.to);
            if (to.layer - from.layer === 1)
                layout.addEdge(new NodeLayout_1.EdgeLayout(e.key, DIRECT.from, DIRECT.to));
            else {
                var candidates_1 = [];
                if (to.position - from.position >= 1) {
                    candidates_1.push(TOP_TO_BOTTOM);
                    candidates_1.push({ from: DIRECT.from, to: TOP_TO_BOTTOM.to });
                    candidates_1.push({ from: TOP_TO_BOTTOM.from, to: DIRECT.to });
                }
                else if (to.position - from.position <= -1) {
                    candidates_1.push(BOTTOM_TO_TOP);
                    candidates_1.push({ from: DIRECT.from, to: BOTTOM_TO_TOP.to });
                    candidates_1.push({ from: BOTTOM_TO_TOP.from, to: DIRECT.to });
                }
                else {
                    var oneliner = from.position === to.position && to.position === 0 ? [TOP_TO_TOP, BOTTOM_TO_BOTTOM] : [BOTTOM_TO_BOTTOM, TOP_TO_TOP];
                    oneliner.forEach(function (c) { return candidates_1.push(c); });
                    oneliner.forEach(function (c) {
                        candidates_1.push({ from: c.from, to: DIRECT.to });
                        candidates_1.push({ from: DIRECT.from, to: c.to });
                    });
                }
                candidates_1.push(DIRECT);
                for (var i = 0, candidate = void 0; candidate = candidates_1[i]; i++) {
                    var fromKey = from.key + "_" + candidate.from;
                    var toKey = to.key + "_" + candidate.to;
                    if (occupied[fromKey] !== Connector_1.ConnectorPosition.End && occupied[toKey] !== Connector_1.ConnectorPosition.Begin) {
                        layout.addEdge(new NodeLayout_1.EdgeLayout(e.key, candidate.from, candidate.to));
                        occupied[fromKey] = Connector_1.ConnectorPosition.Begin;
                        occupied[toKey] = Connector_1.ConnectorPosition.End;
                        break;
                    }
                }
            }
        });
    };
    SugiyamaLayoutBuilder.prototype.getDirectEdgeLayout = function () {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal)
            return this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward ? { from: 1, to: 3 } : { from: 3, to: 1 };
        return this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward ? { from: 2, to: 0 } : { from: 0, to: 2 };
    };
    SugiyamaLayoutBuilder.prototype.getDiffLevelEdgeLayout = function (topToBottom) {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal)
            return topToBottom ? { from: 2, to: 0 } : { from: 0, to: 2 };
        return topToBottom ? { from: 3, to: 1 } : { from: 1, to: 3 };
    };
    SugiyamaLayoutBuilder.prototype.getSameLevelEdgeLayout = function (topToBottom) {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal)
            return topToBottom ? { from: 0, to: 0 } : { from: 2, to: 2 };
        return topToBottom ? { from: 3, to: 3 } : { from: 1, to: 1 };
    };
    SugiyamaLayoutBuilder.prototype.getAbsOffsetInfo = function (nodesInfos) {
        var _this = this;
        var absOffsetMatrix = {};
        var addCell = function (n, intAbsCoord) {
            if (absOffsetMatrix[intAbsCoord] === undefined)
                absOffsetMatrix[intAbsCoord] = _this.getBreadthNodeSize(n);
            absOffsetMatrix[intAbsCoord] = Math.max(absOffsetMatrix[intAbsCoord], _this.getBreadthNodeSize(n));
        };
        nodesInfos.forEach(function (n) {
            var intAbsCoord = trunc(n.position);
            addCell(n, intAbsCoord);
            if (absOffsetMatrix[intAbsCoord] % 1 !== 0)
                addCell(n, intAbsCoord + 1);
        });
        var absOffsetInfo = {};
        var leftOffset = 0;
        Object.keys(absOffsetMatrix).sort(function (a, b) { return parseFloat(a) - parseFloat(b); }).forEach(function (coord) {
            absOffsetInfo[coord] = { leftOffset: leftOffset, width: absOffsetMatrix[coord] };
            leftOffset += absOffsetMatrix[coord] + _this.settings.columnSpacing;
        });
        return absOffsetInfo;
    };
    SugiyamaLayoutBuilder.prototype.setBreadth = function (position, breadthPosition) {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical)
            return new point_1.Point(breadthPosition, position.y);
        return new point_1.Point(position.x, breadthPosition);
    };
    SugiyamaLayoutBuilder.prototype.setDepthOffset = function (position, offset) {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal)
            return new point_1.Point(position.x + offset, position.y);
        return new point_1.Point(position.x, position.y + offset);
    };
    SugiyamaLayoutBuilder.prototype.getAbsPosition = function (absCoordinate, itemSize, absoluteOffsetInfo) {
        var intAbsCoord = trunc(absCoordinate);
        var absLeftOffset = absoluteOffsetInfo[intAbsCoord].leftOffset;
        var cellWidth = absoluteOffsetInfo[intAbsCoord].width;
        if (absCoordinate % 1 === 0)
            return absLeftOffset + (cellWidth - itemSize) / 2;
        return absLeftOffset + cellWidth - (itemSize - this.settings.columnSpacing) / 2;
    };
    SugiyamaLayoutBuilder.prototype.getBreadthNodeSize = function (node) {
        return node.isDummy ? 0 : this.getBreadthNodeSizeCore(this.graph.getNode(node.key));
    };
    SugiyamaLayoutBuilder.prototype.getDepthNodeSize = function (node) {
        return node.isDummy ? 0 : this.getDepthNodeSizeCore(this.graph.getNode(node.key));
    };
    return SugiyamaLayoutBuilder;
}(BaseBuilder_1.LayoutBuilder));
exports.SugiyamaLayoutBuilder = SugiyamaLayoutBuilder;
var SugiyamaLayerDistributor = (function () {
    function SugiyamaLayerDistributor() {
    }
    SugiyamaLayerDistributor.getLayers = function (acyclicGraph) {
        var feasibleTree = this.getFeasibleTree(acyclicGraph);
        return this.calcNodesLayers(feasibleTree);
    };
    SugiyamaLayerDistributor.getFeasibleTree = function (graph) {
        var layers = this.initLayerAssignment(graph);
        return graph.getSpanningGraph(graph.nodes[0], Structures_1.ConnectionMode.OutgoingAndIncoming, function (e) { return layers[e.to] - layers[e.from]; });
    };
    SugiyamaLayerDistributor.initLayerAssignment = function (graph) {
        var layers = {};
        var currentLayer = 0;
        var actualAssignedNodes = {};
        var assigningNodes = graph.nodes.filter(function (n) { return !graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Incoming).length; });
        var _loop_2 = function () {
            assigningNodes.forEach(function (n) {
                layers[n] = currentLayer;
                actualAssignedNodes[n] = true;
            });
            Object.keys(actualAssignedNodes).forEach(function (n) {
                if (graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Outgoing).filter(function (e) { return layers[e.to] === undefined; }).length === 0)
                    delete actualAssignedNodes[n];
            });
            var assigningNodesSet = {};
            Object.keys(actualAssignedNodes).forEach(function (n) {
                graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Outgoing)
                    .map(function (e) { return e.to; })
                    .filter(function (n) { return layers[n] === undefined && graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Incoming).reduce(function (acc, e) { return acc && layers[e.from] !== undefined; }, true); })
                    .forEach(function (n) { return assigningNodesSet[n] = true; });
            });
            assigningNodes = Object.keys(assigningNodesSet);
            currentLayer++;
        };
        while (assigningNodes.length) {
            _loop_2();
        }
        return layers;
    };
    SugiyamaLayerDistributor.calcNodesLayers = function (graph) {
        var layers = {};
        var minLayer = Number.MAX_SAFE_INTEGER || Number.MAX_VALUE;
        var currentLevel = 0;
        var iterator = graph.createIterator(Structures_1.ConnectionMode.OutgoingAndIncoming);
        iterator.visitEachEdgeOnce = false;
        iterator.onNode = function (n) {
            layers[n.key] = currentLevel;
            minLayer = Math.min(minLayer, currentLevel);
        };
        iterator.skipNode = function (n) { return layers[n.key] !== undefined; };
        iterator.skipEdge = function (e) { return layers[e.from] !== undefined && layers[e.to] !== undefined; };
        iterator.onEdge = function (e, out) {
            if (out)
                currentLevel = layers[e.from] + 1;
            else
                currentLevel = layers[e.to] - 1;
        };
        iterator.iterate(graph.nodes[0]);
        for (var key in layers) {
            if (!Object.prototype.hasOwnProperty.call(layers, key))
                continue;
            layers[key] -= minLayer;
        }
        return layers;
    };
    return SugiyamaLayerDistributor;
}());
exports.SugiyamaLayerDistributor = SugiyamaLayerDistributor;
var SugiyamaNodesOrderer = (function () {
    function SugiyamaNodesOrderer() {
        this.idCounter = -10000;
    }
    SugiyamaNodesOrderer.prototype.orderNodes = function (graph, layers) {
        var maxIteration = 14;
        var currentIteration = 1;
        var graphInfo = this.initGraphInfo(graph, layers);
        var nodeInfos = graphInfo.items;
        var orderInfo = this.initOrder(nodeInfos);
        var bestNodesPositions = this.getNodeToPositionMap(nodeInfos);
        var bestCrossCount = this.getCrossCount(orderInfo, graphInfo);
        var isParentToChildren = true;
        while (currentIteration < maxIteration && bestCrossCount !== 0) {
            orderInfo = this.getNodesOrder(orderInfo, graphInfo, isParentToChildren);
            var crossCount = this.getCrossCount(orderInfo, graphInfo);
            if (crossCount < bestCrossCount) {
                bestNodesPositions = this.getNodeToPositionMap(graphInfo.items);
                bestCrossCount = crossCount;
            }
            isParentToChildren = !isParentToChildren;
            currentIteration++;
        }
        graphInfo.items.forEach(function (n) { return n.position = bestNodesPositions[n.key]; });
        return graphInfo;
    };
    SugiyamaNodesOrderer.prototype.getNodesOrder = function (current, graph, isParentToChildren) {
        var _this = this;
        var order = {};
        var _loop_3 = function (layer) {
            if (!Object.prototype.hasOwnProperty.call(current, layer))
                return "continue";
            var nodePositions = {};
            var nodeKeys = [];
            current[layer].forEach(function (ni) {
                var adjacentNodesPositions = (isParentToChildren ? graph.getChildren(ni.key) : graph.getParents(ni.key))
                    .map(function (nk) { return graph.getNode(nk).position; });
                nodeKeys.push(ni.key);
                nodePositions[ni.key] = _this.getNodePosition(adjacentNodesPositions);
            });
            order[layer] = this_2.sortNodes(nodeKeys, nodePositions, graph);
        };
        var this_2 = this;
        for (var layer in current) {
            _loop_3(layer);
        }
        return order;
    };
    SugiyamaNodesOrderer.prototype.sortNodes = function (nodeKeys, nodePositions, graph) {
        return nodeKeys
            .sort(function (a, b) { return nodePositions[a] - nodePositions[b]; })
            .map(function (nk, index) {
            var node = graph.getNode(nk);
            node.position = index;
            return node;
        });
    };
    SugiyamaNodesOrderer.prototype.getNodePosition = function (adjacentNodesPositions) {
        adjacentNodesPositions = adjacentNodesPositions.sort(function (a, b) { return a - b; });
        if (!adjacentNodesPositions.length)
            return 0;
        var medianIndex = Math.floor(adjacentNodesPositions.length / 2);
        if (adjacentNodesPositions.length === 2 || adjacentNodesPositions.length % 2 === 1)
            return adjacentNodesPositions[medianIndex];
        var leftMedianPosition = adjacentNodesPositions[medianIndex - 1] - adjacentNodesPositions[0];
        var rightMedianPosition = adjacentNodesPositions[adjacentNodesPositions.length - 1] - adjacentNodesPositions[medianIndex];
        return Math.floor((adjacentNodesPositions[medianIndex - 1] * rightMedianPosition + adjacentNodesPositions[medianIndex] * leftMedianPosition) /
            (leftMedianPosition + rightMedianPosition));
    };
    SugiyamaNodesOrderer.prototype.initOrder = function (nodeInfos) {
        var result = {};
        nodeInfos.forEach(function (ni) { return (result[ni.layer] || (result[ni.layer] = [])).push(ni); });
        return result;
    };
    SugiyamaNodesOrderer.prototype.getCrossCount = function (orderInfo, graph) {
        var count = 0;
        var _loop_4 = function (layer) {
            if (!Object.prototype.hasOwnProperty.call(orderInfo, layer))
                return "continue";
            var viewedAdjacentNodesPositions = [];
            orderInfo[layer].forEach(function (n) {
                var positions = graph.getChildren(n.key).map(function (c) { return graph.getNode(c).position; });
                positions.forEach(function (p) {
                    count += viewedAdjacentNodesPositions.filter(function (vp) { return p < vp; }).length;
                });
                viewedAdjacentNodesPositions = viewedAdjacentNodesPositions.concat(positions);
            });
        };
        for (var layer in orderInfo) {
            _loop_4(layer);
        }
        return count;
    };
    SugiyamaNodesOrderer.prototype.initGraphInfo = function (graph, layers) {
        var _this = this;
        var countNodesOnLayer = {};
        var nodesInfoMap = {};
        var nodeInfos = [];
        var edgeInfos = [];
        graph.nodes.forEach(function (n) {
            var layer = layers[n];
            if (countNodesOnLayer[layer] === undefined)
                countNodesOnLayer[layer] = 0;
            var info = new NodeOnLayer(n, false, layer, countNodesOnLayer[layer]++);
            nodesInfoMap[n] = info;
            nodeInfos.push(info);
        });
        graph.edges.forEach(function (e) {
            var span = layers[e.to] - layers[e.from];
            if (span > 1) {
                var prevNodeInfo = nodesInfoMap[e.from];
                for (var delta = 1; delta < span; delta++) {
                    var dNodeInfo = new NodeOnLayer(_this.createDummyID(), true, layers[e.from] + delta, countNodesOnLayer[layers[e.from] + delta]++);
                    edgeInfos.push(new EdgeOnLayer(_this.createDummyID(), true, prevNodeInfo.key, dNodeInfo.key));
                    nodeInfos.push(dNodeInfo);
                    prevNodeInfo = dNodeInfo;
                }
                edgeInfos.push(new EdgeOnLayer(e.key, false, prevNodeInfo.key, nodesInfoMap[e.to].key, nodesInfoMap[e.from].key));
            }
            else
                edgeInfos.push(new EdgeOnLayer(e.key, false, nodesInfoMap[e.from].key, nodesInfoMap[e.to].key));
        });
        return new Graph_1.FastGraph(nodeInfos, edgeInfos);
    };
    SugiyamaNodesOrderer.prototype.createDummyID = function () {
        return "dummy_" + --this.idCounter;
    };
    SugiyamaNodesOrderer.prototype.getNodeToPositionMap = function (nodeInfos) {
        return nodeInfos.reduce(function (acc, ni) {
            acc[ni.key] = ni.position;
            return acc;
        }, {});
    };
    SugiyamaNodesOrderer.prototype.assignAbsCoordinates = function (graph) {
        var absCoordinates = this.getAbsCoodinate(graph);
        return new Graph_1.FastGraph(graph.items.map(function (n) { return new NodeOnLayer(n.key, n.isDummy, n.layer, absCoordinates[n.key]); }), graph.edges.slice(0));
    };
    SugiyamaNodesOrderer.prototype.getAbsCoodinate = function (graph) {
        var _this = this;
        var orderInfo = graph.items.reduce(function (acc, n) {
            acc[n.layer] = acc[n.layer] || [];
            var pos = search_1.SearchUtils.binaryIndexOf(acc[n.layer], function (ni) { return ni.position - n.position; });
            acc[n.layer].splice(pos < 0 ? ~pos : pos, 0, n);
            return acc;
        }, {});
        var medianPositions = [MedianAlignmentMode.TopLeft, MedianAlignmentMode.TopRight, MedianAlignmentMode.BottomLeft, MedianAlignmentMode.BottomRight]
            .map(function (alignment) { return _this.getPositionByMedian(graph, alignment, orderInfo); });
        var nodeToPosition = {};
        graph.items.forEach(function (n) {
            var posList = medianPositions.map(function (positions) { return positions[n.key]; }).sort(function (a, b) { return a - b; });
            nodeToPosition[n.key] = (posList[1] + posList[2]) / 2;
        });
        return nodeToPosition;
    };
    SugiyamaNodesOrderer.prototype.getPositionByMedian = function (graph, alignment, orderInfo) {
        var nodeInfos = graph.items;
        var positions = this.getNodeToPositionMap(nodeInfos);
        var medians = this.getMedians(graph, nodeInfos, alignment);
        medians = this.resolveMedianConflicts(graph, orderInfo, medians, alignment);
        this.getSortedBlocks(graph, nodeInfos, medians, alignment)
            .forEach(function (block) {
            var maxPos = block.reduce(function (acc, n) { return positions[n.key] > acc ? positions[n.key] : acc; }, -2);
            block.forEach(function (n) {
                var delta = maxPos - positions[n.key];
                if (delta > 0)
                    orderInfo[n.layer]
                        .filter(function (ln) { return ln.position > n.position; })
                        .forEach(function (ln) { return positions[ln.key] += delta; });
                positions[n.key] = maxPos;
            });
        });
        return positions;
    };
    SugiyamaNodesOrderer.prototype.getSortedBlocks = function (graph, nodeInfos, medians, alignment) {
        var blocks = [];
        var isBottom = alignment === MedianAlignmentMode.BottomLeft || alignment === MedianAlignmentMode.BottomRight;
        var allNodesInfo = new ListUtils_1.HashSet(nodeInfos.slice(0).sort(function (a, b) { return isBottom ? (a.layer - b.layer) : (b.layer - a.layer); }), function (n) { return n.key; });
        var knownNodes = new ListUtils_1.HashSet();
        while (allNodesInfo.length) {
            var firstNode = allNodesInfo.item(0);
            var block = this.getBlock(graph, firstNode, medians, alignment).filter(function (n) { return knownNodes.tryPush(n.key); });
            blocks.push(block);
            block.forEach(function (n) { return allNodesInfo.remove(n); });
        }
        blocks.sort(function (x, y) {
            var xMinNodeInfo = x.reduce(function (min, n) { return n.position < min.position ? n : min; }, x[0]);
            var yOnMinXLayer = y.filter(function (n) { return n.layer === xMinNodeInfo.layer; })[0];
            if (yOnMinXLayer)
                return xMinNodeInfo.position > yOnMinXLayer.position ? 1 : -1;
            var yMinNodeInfo = y.reduce(function (min, n) { return n.position < min.position ? n : min; }, y[0]);
            var xOnMinYLayer = x.filter(function (n) { return n.layer === yMinNodeInfo.layer; })[0];
            if (xOnMinYLayer)
                return xOnMinYLayer.position > yMinNodeInfo.position ? 1 : -1;
            return xMinNodeInfo.layer > yMinNodeInfo.layer ? 1 : -1;
        });
        return blocks;
    };
    SugiyamaNodesOrderer.prototype.getBlock = function (graph, root, medians, alignment) {
        var block = [];
        var median = null;
        do {
            if (median)
                root = alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.TopRight ? graph.getNode(median.from) : graph.getNode(median.to);
            block.push(root);
            median = medians[root.key];
        } while (median);
        return block;
    };
    SugiyamaNodesOrderer.prototype.resolveMedianConflicts = function (graph, layers, medians, alignment) {
        var _this = this;
        var filteredMedians = {};
        var _loop_5 = function (layer) {
            if (!Object.prototype.hasOwnProperty.call(layers, layer))
                return "continue";
            var minPos;
            var maxPos;
            var nodeInfos = layers[layer];
            if (alignment === MedianAlignmentMode.TopRight || alignment === MedianAlignmentMode.BottomRight)
                nodeInfos = nodeInfos.slice(0).sort(function (a, b) { return b.position - a.position; });
            nodeInfos.forEach(function (n) {
                var median = medians[n.key];
                if (!median)
                    filteredMedians[n.key] = null;
                else {
                    var medianItemKey = alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.TopRight ? median.from : median.to;
                    var medianPosition = graph.getNode(medianItemKey).position;
                    if (_this.checkMedianConfict(minPos, maxPos, medianPosition, alignment))
                        filteredMedians[n.key] = null;
                    else {
                        minPos = minPos === undefined ? medianPosition : Math.min(minPos, medianPosition);
                        maxPos = maxPos === undefined ? medianPosition : Math.max(maxPos, medianPosition);
                        filteredMedians[n.key] = median;
                    }
                }
            });
        };
        for (var layer in layers) {
            _loop_5(layer);
        }
        return filteredMedians;
    };
    SugiyamaNodesOrderer.prototype.checkMedianConfict = function (min, max, medianPosition, alignment) {
        if (min === undefined || max === undefined)
            return false;
        if (alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.BottomLeft)
            return max >= medianPosition;
        return min <= medianPosition;
    };
    SugiyamaNodesOrderer.prototype.getMedians = function (graph, nodeInfos, alignment) {
        var _this = this;
        var medians = {};
        nodeInfos.forEach(function (n) {
            var actualAdjacentEdges = _this.getActualAdjacentEdges(graph, n, alignment);
            var medianPosition = _this.getMedianPosition(actualAdjacentEdges.length, alignment);
            medians[n.key] = actualAdjacentEdges[medianPosition];
        });
        return medians;
    };
    SugiyamaNodesOrderer.prototype.getMedianPosition = function (length, alignment) {
        if (length === 0)
            return -1;
        if (length % 2 !== 0)
            return Math.floor(length / 2);
        if (alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.BottomLeft)
            return Math.floor(length / 2) - 1;
        if (alignment === MedianAlignmentMode.TopRight || alignment === MedianAlignmentMode.BottomRight)
            return Math.floor(length / 2);
        throw new Error("Invalid Operation");
    };
    SugiyamaNodesOrderer.prototype.getActualAdjacentEdges = function (graph, node, alignment) {
        if (alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.TopRight)
            return graph.getAdjacentEdges(node.key, Structures_1.ConnectionMode.Incoming).sort(function (a, b) { return graph.getNode(a.from).position - graph.getNode(b.from).position; });
        return graph.getAdjacentEdges(node.key, Structures_1.ConnectionMode.Outgoing).sort(function (a, b) { return graph.getNode(a.to).position - graph.getNode(b.to).position; });
    };
    return SugiyamaNodesOrderer;
}());
exports.SugiyamaNodesOrderer = SugiyamaNodesOrderer;
var NodeOnLayer = (function () {
    function NodeOnLayer(key, isDummy, layer, position) {
        this.key = key;
        this.isDummy = isDummy;
        this.layer = layer;
        this.position = position;
    }
    NodeOnLayer.prototype.getHashCode = function () {
        return this.key.toString();
    };
    return NodeOnLayer;
}());
exports.NodeOnLayer = NodeOnLayer;
var EdgeOnLayer = (function () {
    function EdgeOnLayer(key, isDummy, from, to, originFrom) {
        this.key = key;
        this.isDummy = isDummy;
        this.from = from;
        this.to = to;
        this._originFrom = originFrom;
    }
    EdgeOnLayer.prototype.getHashCode = function () {
        return this.from + "-" + this.to;
    };
    Object.defineProperty(EdgeOnLayer.prototype, "originFrom", {
        get: function () {
            return this._originFrom !== undefined ? this._originFrom : this.from;
        },
        enumerable: false,
        configurable: true
    });
    return EdgeOnLayer;
}());
exports.EdgeOnLayer = EdgeOnLayer;
var MedianAlignmentMode;
(function (MedianAlignmentMode) {
    MedianAlignmentMode[MedianAlignmentMode["TopLeft"] = 0] = "TopLeft";
    MedianAlignmentMode[MedianAlignmentMode["TopRight"] = 1] = "TopRight";
    MedianAlignmentMode[MedianAlignmentMode["BottomLeft"] = 2] = "BottomLeft";
    MedianAlignmentMode[MedianAlignmentMode["BottomRight"] = 3] = "BottomRight";
})(MedianAlignmentMode || (MedianAlignmentMode = {}));
function trunc(val) {
    if (Math.trunc)
        return Math.trunc(val);
    if (!isFinite(val))
        return val;
    return (val - val % 1) || (val < 0 ? -0 : val === 0 ? val : 0);
}


/***/ }),

/***/ 9533:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TreeLayoutBuilder = void 0;
var GraphLayout_1 = __webpack_require__(8119);
var Tree_1 = __webpack_require__(5148);
var NodeLayout_1 = __webpack_require__(617);
var Utils_1 = __webpack_require__(8675);
var point_1 = __webpack_require__(8900);
var BaseBuilder_1 = __webpack_require__(5227);
var Structures_1 = __webpack_require__(8217);
var DiagramItem_1 = __webpack_require__(3742);
var LayoutSettings_1 = __webpack_require__(8710);
var Graph_1 = __webpack_require__(213);
var TreeLayoutBuilder = (function (_super) {
    __extends(TreeLayoutBuilder, _super);
    function TreeLayoutBuilder() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.nodeToLevel = {};
        _this.levelDepthSize = {};
        return _this;
    }
    TreeLayoutBuilder.prototype.build = function () {
        var _this = this;
        var layout = new GraphLayout_1.GraphLayout();
        var offset = 0;
        this.graph.getConnectedComponents().forEach(function (c) {
            var tree = Tree_1.Tree.createSpanningTree(c);
            var componentLayout = _this.processTree(tree);
            var subOffset = _this.getComponentOffset(componentLayout);
            while (componentLayout.nodeKeys.length < c.nodes.length) {
                var subGraph = new Graph_1.Graph(c.nodes.filter(function (n) { return !componentLayout.nodeToLayout[n]; }).map(function (n) { return c.getNode(n); }), c.edges.filter(function (e) { return !componentLayout.edgeToPosition[e.key]; }));
                var subTree = Tree_1.Tree.createSpanningTree(subGraph);
                var subComponentLayout = _this.processTree(subTree);
                componentLayout.extend(_this.setComponentOffset(subComponentLayout, subOffset));
                subOffset += _this.getComponentOffset(subComponentLayout);
            }
            layout.extend(_this.setComponentOffset(componentLayout, offset));
            offset += _this.getComponentOffset(componentLayout);
        });
        return layout;
    };
    TreeLayoutBuilder.prototype.preProcessTree = function (tree, parents, level) {
        var _this = this;
        parents = parents.filter(function (p) { return (_this.nodeToLevel[p.key] === undefined ? (_this.nodeToLevel[p.key] = level) : -1) >= 0; });
        if (parents.length) {
            var maxDepthSize = this.getMaxDepthSize(parents);
            this.levelDepthSize[level] = maxDepthSize;
            this.preProcessTree(tree, [].concat.apply([], parents.map(function (p) { return tree.getChildren(p); })), level + 1);
        }
    };
    TreeLayoutBuilder.prototype.loadNodes = function (tree, layout, parent) {
        if (!parent)
            return [layout.addNode(new NodeLayout_1.NodeLayout(tree.root, point_1.Point.zero()))];
        return tree.getChildren(parent.info).map(function (child) {
            return !layout.hasNode(child.key) ? layout.addNode(new NodeLayout_1.NodeLayout(child, point_1.Point.zero())) : undefined;
        }).filter(function (nl) { return nl; });
    };
    TreeLayoutBuilder.prototype.processTree = function (tree) {
        var _this = this;
        var layout = new GraphLayout_1.GraphLayout();
        this.preProcessTree(tree, [tree.root], 0);
        this.processLevel(tree, layout, 0, new Utils_1.Range(0), 0);
        if (this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Backward) {
            var levelDepths = Object.keys(this.levelDepthSize).map(function (l) { return _this.levelDepthSize[l]; });
            var mostDepthPos_1 = levelDepths.reduce(function (acc, v) { return acc + v; }, 0) + (levelDepths.length - 1) * this.settings.layerSpacing;
            layout.forEachNode(function (n) { return _this.setDepthPos(n, _this.getDepthPos(n) + mostDepthPos_1); });
        }
        return layout;
    };
    TreeLayoutBuilder.prototype.processLevel = function (tree, layout, depthPos, breadthParentRange, level, parent) {
        var _this = this;
        var nodes = this.addNodes(tree, layout, level, parent);
        var parentEdges = parent ? this.graph.getAdjacentEdges(parent.key, Structures_1.ConnectionMode.Outgoing) : [];
        var maxDepthSize = this.getDirectionValue(this.levelDepthSize[level]);
        var layerSpacing = this.getDirectionValue(this.settings.layerSpacing);
        var prevRange;
        nodes.forEach(function (node) {
            var range = Utils_1.Range.fromLength(prevRange ? (prevRange.to + _this.settings.columnSpacing) : breadthParentRange.from, _this.getBreadthNodeSizeCore(node.info));
            node.position = _this.getNodePosition(range.from, depthPos, maxDepthSize).clone().offset(node.info.margin.left, node.info.margin.top);
            _this.processLevel(tree, layout, depthPos + maxDepthSize + layerSpacing, range, level + 1, node);
            _this.updateEdgeConnections(layout, parentEdges, node);
            breadthParentRange.extend(range);
            prevRange = range;
        });
        if (parent && nodes.length) {
            var lastChild = nodes[nodes.length - 1];
            var childRange = new Utils_1.Range(this.getBreadthPos(nodes[0]), this.getBreadthPos(lastChild) + this.getBreadthNodeSizeCore(lastChild.info, true));
            this.alignParent(parent, childRange, breadthParentRange);
        }
    };
    TreeLayoutBuilder.prototype.addNodes = function (tree, layout, level, parent) {
        var _this = this;
        if (level === 0)
            return [layout.addNode(new NodeLayout_1.NodeLayout(tree.root, point_1.Point.zero()))];
        return tree.getChildren(parent.info)
            .reduce(function (acc, n) {
            if (_this.nodeToLevel[n.key] === level && !layout.hasNode(n.key))
                acc.push(layout.addNode(new NodeLayout_1.NodeLayout(n, point_1.Point.zero())));
            return acc;
        }, []);
    };
    TreeLayoutBuilder.prototype.getMaxDepthSize = function (nodes) {
        var _this = this;
        return nodes.reduce(function (acc, node) { return Math.max(acc, _this.getDepthNodeSizeCore(node)); }, 0);
    };
    TreeLayoutBuilder.prototype.getNodePosition = function (breadthPos, depthPos, maxDepthSide) {
        if (this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward)
            return this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical ? new point_1.Point(breadthPos, depthPos) : new point_1.Point(depthPos, breadthPos);
        return this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical ? new point_1.Point(breadthPos, depthPos + maxDepthSide) : new point_1.Point(depthPos + maxDepthSide, breadthPos);
    };
    TreeLayoutBuilder.prototype.updateEdgeConnections = function (layout, edges, node) {
        var _this = this;
        edges.filter(function (e) { return e.to === node.key; }).forEach(function (e) {
            var beginIndex = _this.getBeginEdgeIndex();
            var endIndex = _this.getEndEdgeIndex();
            layout.addEdge(new NodeLayout_1.EdgeLayout(e.key, beginIndex, endIndex));
        });
    };
    TreeLayoutBuilder.prototype.getBeginEdgeIndex = function () {
        if (this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward)
            return this.isVertical() ? DiagramItem_1.ConnectionPointSide.South : DiagramItem_1.ConnectionPointSide.East;
        return this.isVertical() ? DiagramItem_1.ConnectionPointSide.North : DiagramItem_1.ConnectionPointSide.West;
    };
    TreeLayoutBuilder.prototype.getEndEdgeIndex = function () {
        if (this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward)
            return this.isVertical() ? DiagramItem_1.ConnectionPointSide.North : DiagramItem_1.ConnectionPointSide.West;
        return this.isVertical() ? DiagramItem_1.ConnectionPointSide.South : DiagramItem_1.ConnectionPointSide.East;
    };
    TreeLayoutBuilder.prototype.alignParent = function (parent, childRange, availableRange) {
        if (this.settings.alignment === LayoutSettings_1.Alignment.Center) {
            var alignedPosition = childRange.from + childRange.length / 2 - this.getBreadthNodeSizeCore(parent.info, true) / 2;
            if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical) {
                parent.position.x = Math.max(availableRange.from + parent.info.margin.left, alignedPosition);
                parent.position.x = Math.min(availableRange.to - parent.info.size.width - parent.info.margin.right, parent.position.x);
            }
            else {
                parent.position.y = Math.max(availableRange.from + parent.info.margin.top, alignedPosition);
                parent.position.y = Math.min(availableRange.to - parent.info.size.height - parent.info.margin.bottom, parent.position.y);
            }
        }
    };
    TreeLayoutBuilder.prototype.getDepthPos = function (node) {
        return this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical ? node.position.y : node.position.x;
    };
    TreeLayoutBuilder.prototype.getBreadthPos = function (node) {
        return this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical ? node.position.x : node.position.y;
    };
    TreeLayoutBuilder.prototype.setDepthPos = function (node, pos) {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical)
            node.position.y = pos;
        else
            node.position.x = pos;
    };
    TreeLayoutBuilder.prototype.isVertical = function () {
        return this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical;
    };
    return TreeLayoutBuilder;
}(BaseBuilder_1.LayoutBuilder));
exports.TreeLayoutBuilder = TreeLayoutBuilder;


/***/ }),

/***/ 213:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GraphIterator = exports.FastGraph = exports.Graph = void 0;
var Structures_1 = __webpack_require__(8217);
var Shape_1 = __webpack_require__(5503);
var search_1 = __webpack_require__(2400);
var ListUtils_1 = __webpack_require__(701);
var GraphBase = (function () {
    function GraphBase(nodes, edges) {
        this.nodeMap = {};
        this.edgeMap = {};
        this.nodes = [];
        this.edges = [];
        this.onInit();
        nodes.forEach(this.addNode.bind(this));
        edges.forEach(this.addEdge.bind(this));
    }
    Object.defineProperty(GraphBase.prototype, "items", {
        get: function () {
            return this.nodes.map(this.getNode.bind(this));
        },
        enumerable: false,
        configurable: true
    });
    GraphBase.prototype.onInit = function () { };
    GraphBase.prototype.addEdge = function (edge) {
        this.edgeMap[edge.key] = edge;
        this.edges.push(edge);
    };
    GraphBase.prototype.addNode = function (node) {
        this.nodeMap[node.key] = node;
        this.nodes.push(node.key);
    };
    GraphBase.prototype.getNode = function (key) {
        return this.nodeMap[key];
    };
    GraphBase.prototype.getEdge = function (key) {
        return this.edgeMap[key];
    };
    GraphBase.prototype.isEmpty = function () {
        return !this.nodes.length && !this.edges.length;
    };
    GraphBase.prototype.getAdjacentEdges = function (nodeKey, connectionMode) {
        if (connectionMode === void 0) { connectionMode = Structures_1.ConnectionMode.OutgoingAndIncoming; }
        return this.edges.filter(function (e) {
            return connectionMode & Structures_1.ConnectionMode.Incoming && e.to === nodeKey ||
                connectionMode & Structures_1.ConnectionMode.Outgoing && e.from === nodeKey;
        });
    };
    return GraphBase;
}());
var Graph = (function (_super) {
    __extends(Graph, _super);
    function Graph() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Graph.prototype.cast = function (castNode, castEdge) {
        var _this = this;
        var newNodes = this.nodes.map(function (nk) { return castNode(_this.getNode(nk)); });
        var newEdges = this.edges.map(function (e) { return castEdge ? castEdge(e) : e; });
        return new Graph(newNodes, newEdges);
    };
    Graph.prototype.getConnectedComponents = function () {
        var iterator = this.createIterator(Structures_1.ConnectionMode.OutgoingAndIncoming);
        iterator.visitEachEdgeOnce = true;
        var components = [];
        var _loop_1 = function (i) {
            var nodes = [];
            var edges = [];
            iterator.onNode = function (n) { return nodes.push(n); };
            iterator.onEdge = function (e) { return edges.push(e); };
            iterator.iterate(this_1.nodes[i]);
            if (nodes.length)
                components.push(new Graph(nodes, edges));
        };
        var this_1 = this;
        for (var i = 0; i < this.nodes.length; i++) {
            _loop_1(i);
        }
        return components;
    };
    Graph.prototype.createIterator = function (connectionMode) {
        var iterator = new GraphIterator(this, connectionMode);
        iterator.comparer = function (a, b) { return a.weight - b.weight; };
        return iterator;
    };
    Graph.prototype.getSpanningGraph = function (rootKey, connectionMode, edgeWeightFunc) {
        var _this = this;
        if (edgeWeightFunc === void 0) { edgeWeightFunc = undefined; }
        if (!this.nodes.length)
            return new Graph([], []);
        if (!edgeWeightFunc)
            edgeWeightFunc = function (e) { return e.weight; };
        var sortedAdjacentEdges = [];
        var spanningTreeNodesSet = new ListUtils_1.HashSet();
        var spanningTreeEdgesSet = new ListUtils_1.HashSet([], function (e) { return e.getHashKey(); });
        this.addNodeToSpanningGraph(rootKey, connectionMode, sortedAdjacentEdges, spanningTreeNodesSet, spanningTreeEdgesSet, edgeWeightFunc);
        while (sortedAdjacentEdges.length && spanningTreeNodesSet.length !== this.nodes.length) {
            var minWeighedEdge = sortedAdjacentEdges.shift();
            spanningTreeEdgesSet.tryPush(minWeighedEdge);
            var node = spanningTreeNodesSet.contains(minWeighedEdge.from) ? minWeighedEdge.to : minWeighedEdge.from;
            this.addNodeToSpanningGraph(node, connectionMode, sortedAdjacentEdges, spanningTreeNodesSet, spanningTreeEdgesSet, edgeWeightFunc);
            sortedAdjacentEdges = sortedAdjacentEdges.filter(function (e) { return !spanningTreeNodesSet.contains(e.from) || !spanningTreeNodesSet.contains(e.to); });
        }
        return new Graph(spanningTreeNodesSet.list().map(function (nk) { return _this.getNode(nk); }), spanningTreeEdgesSet.list());
    };
    Graph.prototype.addNodeToSpanningGraph = function (nodeKey, connectionMode, adjacentEdges, spanningTreeNodesSet, spanningTreeEdgesSet, edgeWeightFunc) {
        spanningTreeNodesSet.tryPush(nodeKey);
        this.getAdjacentEdges(nodeKey, connectionMode)
            .filter(function (e) { return !spanningTreeEdgesSet.contains(e); })
            .forEach(function (e) {
            var weight = edgeWeightFunc(e);
            var pos = search_1.SearchUtils.binaryIndexOf(adjacentEdges, function (a) { return a.weight - weight; });
            pos = pos < 0 ? ~pos : pos;
            while (pos < adjacentEdges.length && edgeWeightFunc(adjacentEdges[pos]) === weight)
                pos++;
            adjacentEdges.splice(pos, 0, new Structures_1.Edge(e.key, e.from, e.to, weight));
        });
    };
    Graph.create = function (shapes, connectors) {
        var nodes = shapes;
        var edges = connectors
            .filter(function (i) { return i.beginItem && i.endItem instanceof Shape_1.Shape && i.endItem && i.endItem instanceof Shape_1.Shape && i.beginItem !== i.endItem; })
            .map(function (i) { return new Structures_1.Edge(i.key, i.beginItem && i.beginItem.key, i.endItem && i.endItem.key); });
        return new Graph(nodes, edges);
    };
    return Graph;
}(GraphBase));
exports.Graph = Graph;
var FastGraph = (function (_super) {
    __extends(FastGraph, _super);
    function FastGraph() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FastGraph.prototype.onInit = function () {
        this.parentToChildren = {};
        this.childToParents = {};
    };
    FastGraph.prototype.addEdge = function (edge) {
        _super.prototype.addEdge.call(this, edge);
        (this.parentToChildren[edge.from] || (this.parentToChildren[edge.from] = [])).push(edge.to);
        (this.childToParents[edge.to] || (this.childToParents[edge.to] = [])).push(edge.from);
    };
    FastGraph.prototype.getChildren = function (parent) {
        return this.parentToChildren[parent] || [];
    };
    FastGraph.prototype.getParents = function (child) {
        return this.childToParents[child] || [];
    };
    FastGraph.prototype.createIterator = function (connectionMode) {
        return new GraphIterator(this, connectionMode);
    };
    return FastGraph;
}(GraphBase));
exports.FastGraph = FastGraph;
var GraphIterator = (function () {
    function GraphIterator(graph, connectionMode) {
        if (connectionMode === void 0) { connectionMode = Structures_1.ConnectionMode.OutgoingAndIncoming; }
        this.graph = graph;
        this.connectionMode = connectionMode;
        this.visitEachEdgeOnce = true;
        this.visitEachNodeOnce = true;
        this.visitedNodes = {};
        this.visitedEdges = {};
    }
    GraphIterator.prototype.iterate = function (nodeKey) {
        if (!this.visitEachNodeOnce && !this.visitEachEdgeOnce && !this.skipNode)
            throw "skipNode or visitEachNodeOnce or visitEachEdgeOnce must be set to avoid SOF";
        this.iterateCore(nodeKey);
    };
    GraphIterator.prototype.iterateCore = function (nodeKey) {
        var _this = this;
        var node = this.graph.getNode(nodeKey);
        if (!node || (this.skipNode && this.skipNode(node)) || (this.visitEachNodeOnce && this.isNodeVisited(nodeKey)))
            return;
        this.visitedNodes[nodeKey] = true;
        this.onNode && this.onNode(node);
        var edges = this.graph.getAdjacentEdges(nodeKey, this.connectionMode);
        if (this.skipEdge)
            edges = edges.filter(function (e) { return !_this.skipEdge(e); });
        if (this.connectionMode & Structures_1.ConnectionMode.Outgoing) {
            var outgoing = edges.filter(function (e) { return e.from === nodeKey; });
            if (this.comparer)
                outgoing.sort(this.comparer);
            outgoing.forEach(function (e) {
                if (_this.visitEachEdgeOnce && _this.visitedEdges[e.key])
                    return;
                _this.visitedEdges[e.key] = true;
                _this.onEdge && _this.onEdge(e, true);
                _this.iterateCore(e.to);
                _this.onAfterEdge && _this.onAfterEdge(e, true);
            });
        }
        this.onAllEdges && this.onAllEdges(node, true);
        if (this.connectionMode & Structures_1.ConnectionMode.Incoming) {
            var incoming = edges.filter(function (e) { return e.to === nodeKey; });
            if (this.comparer)
                incoming.sort(this.comparer);
            incoming.forEach(function (e) {
                if (_this.visitEachEdgeOnce && _this.visitedEdges[e.key])
                    return;
                _this.visitedEdges[e.key] = true;
                _this.onEdge && _this.onEdge(e, false);
                _this.iterateCore(e.from);
                _this.onAfterEdge && _this.onAfterEdge(e, false);
            });
        }
        this.onAllEdges && this.onAllEdges(node, false);
    };
    GraphIterator.prototype.isNodeVisited = function (nodeKey) {
        return !!this.visitedNodes[nodeKey];
    };
    GraphIterator.prototype.isEdgeVisited = function (edgeKey) {
        return !!this.visitedEdges[edgeKey];
    };
    return GraphIterator;
}());
exports.GraphIterator = GraphIterator;


/***/ }),

/***/ 7819:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GraphInfo = void 0;
var LayoutUtils_1 = __webpack_require__(1755);
var GraphInfo = (function () {
    function GraphInfo(container, sourceGraph) {
        this.container = container;
        this.sourceGraph = sourceGraph;
    }
    Object.defineProperty(GraphInfo.prototype, "graph", {
        get: function () {
            return this._graph || (this._graph = this.getNodeInfoGraph());
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(GraphInfo.prototype, "level", {
        get: function () {
            return this._level !== undefined ? this._level : (this._level = this.getLevel());
        },
        enumerable: false,
        configurable: true
    });
    GraphInfo.prototype.getNodeInfoGraph = function () {
        return this.sourceGraph.cast(LayoutUtils_1.LayoutUtils.shapeToLayout);
    };
    GraphInfo.prototype.getLevel = function () {
        var level = 0;
        if (this.container)
            level = this.getContainerLevel(this.container);
        return level;
    };
    GraphInfo.prototype.getContainerLevel = function (container) {
        var level = 1;
        var parentContainer = container.container;
        if (parentContainer)
            level += this.getContainerLevel(parentContainer);
        return level;
    };
    return GraphInfo;
}());
exports.GraphInfo = GraphInfo;


/***/ }),

/***/ 8119:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GraphLayout = void 0;
var Utils_1 = __webpack_require__(8675);
var NodeLayout_1 = __webpack_require__(617);
var GraphLayout = (function () {
    function GraphLayout() {
        this.nodeKeys = [];
        this.nodeToLayout = {};
        this.edgeToPosition = {};
    }
    GraphLayout.prototype.forEachNode = function (callback) {
        var _this = this;
        this.nodeKeys.forEach(function (nk) { return callback(_this.nodeToLayout[nk], nk); });
    };
    GraphLayout.prototype.reduce = function (callback, initValue) {
        var _this = this;
        return this.nodeKeys.reduce(function (acc, key, index) { return callback(acc, _this.nodeToLayout[key], index); }, initValue);
    };
    GraphLayout.prototype.addNode = function (nodeLayout) {
        if (this.nodeToLayout[nodeLayout.key])
            throw Error("Node layout is already registered");
        this.nodeKeys.push(nodeLayout.key);
        this.nodeToLayout[nodeLayout.key] = nodeLayout;
        return nodeLayout;
    };
    GraphLayout.prototype.hasNode = function (key) {
        return !!this.nodeToLayout[key];
    };
    GraphLayout.prototype.addEdge = function (edgeLayout) {
        if (this.edgeToPosition[edgeLayout.key])
            throw Error("Edge layout is already registered");
        this.edgeToPosition[edgeLayout.key] = edgeLayout;
    };
    GraphLayout.prototype.getRectangle = function (includeMargins) {
        var _this = this;
        return Utils_1.GeometryUtils.getCommonRectangle(this.nodeKeys.map(function (nk) { return _this.nodeToLayout[nk].rectangle; }));
    };
    GraphLayout.prototype.offsetNodes = function (deltaX, deltaY) {
        var _this = this;
        if (deltaX === void 0) { deltaX = 0; }
        if (deltaY === void 0) { deltaY = 0; }
        var layout = new GraphLayout();
        this.nodeKeys.forEach(function (nk) {
            var nl = _this.nodeToLayout[nk];
            layout.addNode(new NodeLayout_1.NodeLayout(nl.info, nl.position.clone().offset(deltaX, deltaY)));
        });
        layout.copyEdges(this);
        return layout;
    };
    GraphLayout.prototype.extend = function (layout) {
        var _this = this;
        layout.forEachNode(function (nl) { return _this.addNode(nl); });
        this.copyEdges(layout);
    };
    GraphLayout.prototype.copyEdges = function (source) {
        var _this = this;
        Object.keys(source.edgeToPosition).forEach(function (e) {
            var edge = source.edgeToPosition[e];
            _this.addEdge(new NodeLayout_1.EdgeLayout(edge.key, edge.beginIndex, edge.endIndex));
        });
    };
    return GraphLayout;
}());
exports.GraphLayout = GraphLayout;


/***/ }),

/***/ 8710:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Alignment = exports.DataLayoutOrientation = exports.LogicalDirectionKind = exports.TreeLayoutSettings = exports.LayoutSettings = void 0;
var Connector_1 = __webpack_require__(7959);
var LayoutSettings = (function () {
    function LayoutSettings(gridSize) {
        this.orientation = DataLayoutOrientation.Vertical;
        this.direction = LogicalDirectionKind.Forward;
        var baseSpacing = (gridSize && gridSize * 2 > Connector_1.Connector.minOffset) ? gridSize * 2 : Connector_1.Connector.minOffset;
        this.columnSpacing = baseSpacing;
        this.layerSpacing = baseSpacing * 2;
        this.containerPadding = baseSpacing * 2;
        this.componentSpacing = baseSpacing * 2;
    }
    return LayoutSettings;
}());
exports.LayoutSettings = LayoutSettings;
var TreeLayoutSettings = (function (_super) {
    __extends(TreeLayoutSettings, _super);
    function TreeLayoutSettings(gridSize) {
        var _this = _super.call(this, gridSize) || this;
        _this.alignment = Alignment.Center;
        _this.subTreeColumnSpacing = _this.componentSpacing / 2;
        return _this;
    }
    return TreeLayoutSettings;
}(LayoutSettings));
exports.TreeLayoutSettings = TreeLayoutSettings;
var LogicalDirectionKind;
(function (LogicalDirectionKind) {
    LogicalDirectionKind[LogicalDirectionKind["Backward"] = 0] = "Backward";
    LogicalDirectionKind[LogicalDirectionKind["Forward"] = 1] = "Forward";
})(LogicalDirectionKind = exports.LogicalDirectionKind || (exports.LogicalDirectionKind = {}));
var DataLayoutOrientation;
(function (DataLayoutOrientation) {
    DataLayoutOrientation[DataLayoutOrientation["Horizontal"] = 0] = "Horizontal";
    DataLayoutOrientation[DataLayoutOrientation["Vertical"] = 1] = "Vertical";
})(DataLayoutOrientation = exports.DataLayoutOrientation || (exports.DataLayoutOrientation = {}));
var Alignment;
(function (Alignment) {
    Alignment[Alignment["Left"] = 0] = "Left";
    Alignment[Alignment["Center"] = 1] = "Center";
})(Alignment = exports.Alignment || (exports.Alignment = {}));


/***/ }),

/***/ 1755:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LayoutUtils = void 0;
var NodeLayout_1 = __webpack_require__(617);
var LayoutUtils = (function () {
    function LayoutUtils() {
    }
    LayoutUtils.shapeToLayout = function (shape) {
        var margin = new NodeLayout_1.Margin(0);
        var shapeRect = shape.rectangle;
        shape.attachedConnectors.filter(function (c) { return !c.beginItem || !c.endItem; }).forEach(function (c) {
            var connRect = c.rectangle;
            margin.left = Math.max(margin.left, shapeRect.x - connRect.x);
            margin.right = Math.max(margin.right, connRect.right - shapeRect.right);
            margin.top = Math.max(margin.top, shapeRect.y - connRect.y);
            margin.bottom = Math.max(margin.bottom, connRect.bottom - shapeRect.bottom);
        });
        var layout = new NodeLayout_1.NodeInfo(shape.key, margin, shape.size.clone());
        layout.connectionPoints = shape.description.getConnectionPoints();
        return layout;
    };
    return LayoutUtils;
}());
exports.LayoutUtils = LayoutUtils;


/***/ }),

/***/ 617:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Margin = exports.EdgeLayout = exports.NodeLayout = exports.NodeInfo = void 0;
var rectangle_1 = __webpack_require__(8011);
var NodeInfo = (function () {
    function NodeInfo(key, margin, size, connectionPoints) {
        if (connectionPoints === void 0) { connectionPoints = []; }
        this.key = key;
        this.margin = margin;
        this.size = size;
        this.connectionPoints = connectionPoints;
    }
    return NodeInfo;
}());
exports.NodeInfo = NodeInfo;
var NodeLayout = (function () {
    function NodeLayout(info, position) {
        this.info = info;
        this.position = position;
    }
    Object.defineProperty(NodeLayout.prototype, "key", {
        get: function () { return this.info.key; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(NodeLayout.prototype, "rectangle", {
        get: function () {
            return rectangle_1.Rectangle.fromGeometry(this.position, this.info.size);
        },
        enumerable: false,
        configurable: true
    });
    return NodeLayout;
}());
exports.NodeLayout = NodeLayout;
var EdgeLayout = (function () {
    function EdgeLayout(key, beginIndex, endIndex) {
        this.key = key;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }
    return EdgeLayout;
}());
exports.EdgeLayout = EdgeLayout;
var Margin = (function () {
    function Margin(top, right, bottom, left) {
        if (right === void 0) { right = top; }
        if (bottom === void 0) { bottom = top; }
        if (left === void 0) { left = top; }
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }
    Margin.empty = function () {
        return new Margin(0);
    };
    return Margin;
}());
exports.Margin = Margin;


/***/ }),

/***/ 8217:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectionMode = exports.PositionInfo = exports.Edge = void 0;
var Edge = (function () {
    function Edge(key, from, to, weight) {
        if (weight === void 0) { weight = 1; }
        this.weight = weight;
        this.key = key;
        this.from = from;
        this.to = to;
    }
    Edge.prototype.getHashKey = function () {
        return this.from + "_" + this.to;
    };
    Edge.prototype.reverse = function () {
        return new Edge(this.key, this.to, this.from, this.weight);
    };
    return Edge;
}());
exports.Edge = Edge;
var PositionInfo = (function () {
    function PositionInfo(item, position) {
        this.item = item;
        this.position = position;
    }
    return PositionInfo;
}());
exports.PositionInfo = PositionInfo;
var ConnectionMode;
(function (ConnectionMode) {
    ConnectionMode[ConnectionMode["Outgoing"] = 1] = "Outgoing";
    ConnectionMode[ConnectionMode["Incoming"] = 2] = "Incoming";
    ConnectionMode[ConnectionMode["OutgoingAndIncoming"] = 3] = "OutgoingAndIncoming";
})(ConnectionMode = exports.ConnectionMode || (exports.ConnectionMode = {}));


/***/ }),

/***/ 5148:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Tree = void 0;
var Structures_1 = __webpack_require__(8217);
var Tree = (function () {
    function Tree(root, parentToChildren) {
        var _this = this;
        this.childToParent = {};
        this.root = root;
        this.parentToChildren = parentToChildren;
        var _loop_1 = function (key) {
            if (!Object.prototype.hasOwnProperty.call(parentToChildren, key))
                return "continue";
            parentToChildren[key].forEach(function (c) { return _this.childToParent[c.key] = key; });
        };
        for (var key in parentToChildren) {
            _loop_1(key);
        }
    }
    Tree.prototype.getChildren = function (node) {
        return node && this.parentToChildren[node.key] ? this.parentToChildren[node.key] : [];
    };
    Tree.prototype.hasChildren = function (node) {
        return this.parentToChildren[node.key] && this.parentToChildren[node.key].length > 0;
    };
    Tree.prototype.iterate = function (callback) {
        this.iterateCore(this.root, 0, callback);
    };
    Tree.createSpanningTree = function (component) {
        var rootKey = Tree.findRoot(component);
        var iterator = component.createIterator(Structures_1.ConnectionMode.Outgoing);
        var parentToChildren = {};
        iterator.skipEdge = (function (e) { return e.to === undefined || iterator.isNodeVisited(e.to); });
        iterator.onNode = function (n) { return parentToChildren[n.key] = []; };
        iterator.onEdge = function (e) {
            var node = component.getNode(e.to);
            node && parentToChildren[e.from].push(node);
        };
        iterator.iterate(rootKey);
        return new Tree(component.getNode(rootKey), parentToChildren);
    };
    Tree.prototype.iterateCore = function (node, level, callback) {
        var _this = this;
        callback(node, level);
        this.getChildren(node).forEach(function (n) { return _this.iterateCore(n, level + 1, callback); });
    };
    Tree.findRoot = function (component) {
        return component.nodes.reduce(function (aggregator, cur) {
            var edges = component.getAdjacentEdges(cur);
            var inc = edges.filter(function (l) { return l.to === cur; }).length;
            var out = edges.filter(function (l) { return l.from === cur; }).length;
            if (aggregator.candidate === undefined || (inc === 0 && aggregator.inc > 0) || (aggregator.inc !== 0 && aggregator.out - aggregator.inc < out - inc)) {
                aggregator.candidate = cur;
                aggregator.inc = inc;
                aggregator.out = out;
            }
            return aggregator;
        }, { inc: -1, out: -1, candidate: undefined }).candidate;
    };
    return Tree;
}());
exports.Tree = Tree;


/***/ }),

/***/ 7309:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CycleRemover = void 0;
var Graph_1 = __webpack_require__(213);
var Structures_1 = __webpack_require__(8217);
var ListUtils_1 = __webpack_require__(701);
var CycleRemover = (function () {
    function CycleRemover() {
    }
    CycleRemover.removeCycles = function (graph) {
        var feedbackSet = this.getFeedbackSet(graph);
        return this.reverseEdges(graph, feedbackSet);
    };
    CycleRemover.getFeedbackSet = function (graph) {
        var _this = this;
        var feedbackSet = {};
        var nonTrivialStronglyConnectedComponents = this.getNonTrivialStronglyConnectedComponents(graph);
        while (nonTrivialStronglyConnectedComponents.length) {
            nonTrivialStronglyConnectedComponents.forEach(function (g) {
                var maxCyclicEdges = _this.getMaxCyclicEdges(g);
                maxCyclicEdges.forEach(function (e) { return delete feedbackSet[e.reverse().getHashKey()]; });
                maxCyclicEdges.forEach(function (e) { return feedbackSet[e.getHashKey()] = true; });
            });
            nonTrivialStronglyConnectedComponents = this.getNonTrivialStronglyConnectedComponents(this.reverseEdges(graph, feedbackSet).graph);
        }
        return feedbackSet;
    };
    CycleRemover.getMaxCyclicEdges = function (graph) {
        var black = {};
        var gray = {};
        var edgeCycleCount = {};
        var visitedEdges = [];
        var cycles = [];
        var iterator = graph.createIterator(Structures_1.ConnectionMode.Outgoing);
        iterator.visitEachEdgeOnce = false;
        iterator.onNode = function (n) {
            gray[n.key] = true;
        };
        iterator.skipNode = function (n) {
            if (gray[n.key]) {
                var cycle = [];
                for (var i = 0; i < visitedEdges.length; i++) {
                    var e = visitedEdges[i];
                    if (edgeCycleCount[e.key] === undefined)
                        edgeCycleCount[e.key] = 0;
                    edgeCycleCount[e.key]++;
                    cycle.push(e);
                    if (e.from === n.key)
                        break;
                }
                cycles.push(cycle);
            }
            return gray[n.key] || black[n.key];
        };
        iterator.skipEdge = function (e) { return false; };
        iterator.onEdge = function (e) {
            visitedEdges.splice(0, 0, e);
        };
        iterator.onAfterEdge = function (e) {
            visitedEdges.splice(0, 1);
        };
        iterator.onAllEdges = function (e) {
            black[e.key] = true;
            gray[e.key] = false;
        };
        iterator.iterate(graph.nodes[0]);
        var edgeSet = new ListUtils_1.HashSet([], function (e) { return e.key; });
        cycles.forEach(function (c) {
            edgeSet.tryPush(c.reduce(function (max, curr) { return edgeCycleCount[curr.key] > edgeCycleCount[max.key] ? curr : max; }, c[0]));
        });
        return edgeSet.list();
    };
    CycleRemover.reverseEdges = function (graph, feedbackSet) {
        var edges = new ListUtils_1.HashSet([], function (e) { return e.getHashKey(); });
        var reversedEdges = {};
        var removedEdges = {};
        graph.edges.forEach(function (e) {
            if (feedbackSet[e.getHashKey()]) {
                e = e.reverse();
                reversedEdges[e.key] = true;
            }
            if (!edges.tryPush(e)) {
                removedEdges[e.key] = true;
                delete reversedEdges[e.key];
            }
        });
        return {
            graph: new Graph_1.Graph(graph.nodes.map(function (n) { return graph.getNode(n); }), edges.list()),
            reversedEdges: reversedEdges,
            removedEdges: removedEdges
        };
    };
    CycleRemover.getNonTrivialStronglyConnectedComponents = function (graph) {
        return this.getStronglyConnectedComponents(graph).filter(function (g) { return g.edges.length; });
    };
    CycleRemover.getStronglyConnectedComponents = function (graph) {
        var _this = this;
        var nodesStack = [];
        var index = 0;
        var lowIndex = {};
        var lowLink = {};
        var onStack = {};
        var components = [];
        var visitedNodes = {};
        for (var i = 0; i < graph.nodes.length; i++) {
            var nodeKey = graph.nodes[i];
            var iterator = graph.createIterator(Structures_1.ConnectionMode.Outgoing);
            iterator.visitEachEdgeOnce = false;
            iterator.visitEachNodeOnce = false;
            iterator.onNode = function (n) {
                visitedNodes[n.key] = true;
                nodesStack.push(n);
                onStack[n.key] = true;
                lowLink[n.key] = index;
                lowIndex[n.key] = index;
                index++;
            };
            iterator.skipNode = function (n) { return visitedNodes[n.key]; };
            iterator.skipEdge = function (e) {
                var isVisited = visitedNodes[e.to];
                if (isVisited && onStack[e.to])
                    lowLink[e.from] = Math.min(lowLink[e.from], lowIndex[e.to]);
                return isVisited;
            };
            iterator.onAfterEdge = function (e) {
                lowLink[e.from] = Math.min(lowLink[e.from], lowLink[e.to]);
            };
            iterator.onAllEdges = function (n, outgoing) {
                if (outgoing && lowLink[n.key] === lowIndex[n.key])
                    components.push(_this.getStronglyConnectedComponent(graph, n, nodesStack, onStack));
            };
            iterator.iterate(nodeKey);
        }
        return components;
    };
    CycleRemover.getStronglyConnectedComponent = function (graph, root, nodesStack, onStack) {
        var itemsMap = {};
        var nodes = [];
        var edges = [];
        var topStackNode;
        do {
            topStackNode = nodesStack.pop();
            if (!itemsMap[topStackNode.key])
                nodes.push(topStackNode);
            itemsMap[topStackNode.key] = true;
            onStack[topStackNode.key] = false;
        } while (topStackNode !== root);
        nodes.forEach(function (n) {
            var aEdges = graph.getAdjacentEdges(n.key, Structures_1.ConnectionMode.Outgoing);
            edges = edges.concat(aEdges.filter(function (e) { return !itemsMap[e.key] && itemsMap[e.to]; }));
            aEdges.forEach(function (e) { return itemsMap[e.key] = true; });
        });
        return new Graph_1.Graph(nodes, edges);
    };
    return CycleRemover;
}());
exports.CycleRemover = CycleRemover;


/***/ }),

/***/ 1057:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RTree = void 0;
var rectangle_1 = __webpack_require__(8011);
var RTree = (function () {
    function RTree(maxWidth) {
        if (maxWidth === void 0) { maxWidth = 6; }
        this.maxWidth = maxWidth;
        this.minWidth = Math.floor(maxWidth / 2);
        this.root = new RTreeNodeBranch(new rectangle_1.Rectangle(0, 0, 0, 0), []);
    }
    RTree.prototype.search = function (point) {
        var result = [];
        if (!this.root.rect.containsPoint(point))
            return result;
        var hitsStack = [];
        hitsStack.push(this.root.nodes);
        while (hitsStack.length) {
            var nodes = hitsStack.pop();
            for (var i = nodes.length - 1, node = void 0; node = nodes[i]; i--)
                if (node.rect.containsPoint(point))
                    if (isBranch(node))
                        hitsStack.push(node.nodes);
                    else
                        result.push(node.obj);
        }
        return result;
    };
    RTree.prototype.insert = function (rect, obj) {
        var newLeaf = new RTreeNodeLeaf(rect.clone(), obj);
        if (!this.root.nodes.length) {
            this.root.rect = rect.clone();
            this.root.nodes.push(newLeaf);
            return;
        }
        var treeStack = this.chooseLeafSubtree(newLeaf);
        var retObj = newLeaf;
        var current;
        var previous;
        while (treeStack.length) {
            if (current && isBranch(current) && !current.nodes.length) {
                previous = current;
                current = treeStack.pop();
                for (var i = 0, node = void 0; node = current.nodes[i]; i++) {
                    if (isBranch(node) && (node === previous || !node.nodes.length)) {
                        node.nodes.splice(i, 1);
                        break;
                    }
                }
            }
            else
                current = treeStack.pop();
            if (retObj instanceof RTreeNode || Array.isArray(retObj)) {
                if (Array.isArray(retObj)) {
                    for (var i = 0, retObjChild = void 0; retObjChild = retObj[i]; i++) {
                        expandRect(current.rect, retObjChild.rect);
                    }
                    current.nodes = current.nodes.concat(retObj);
                }
                else {
                    expandRect(current.rect, retObj.rect);
                    current.nodes.push(retObj);
                }
                if (current.nodes.length <= this.maxWidth) {
                    retObj = current.rect.clone();
                }
                else {
                    var a = this.linearSplit(current.nodes);
                    retObj = a;
                    if (!treeStack.length) {
                        current.nodes.push(a[0]);
                        treeStack.push(current);
                        retObj = a[1];
                    }
                }
            }
            else {
                expandRect(current.rect, retObj);
                retObj = current.rect.clone();
            }
        }
    };
    RTree.prototype.chooseLeafSubtree = function (newLeaf) {
        var result = [];
        var bestChoiceIndex = -1;
        var bestChoiceArea;
        var first = true;
        result.push(this.root);
        var nodes = this.root.nodes;
        while (first || bestChoiceIndex !== -1) {
            if (first)
                first = false;
            else {
                result.push(nodes[bestChoiceIndex]);
                nodes = nodes[bestChoiceIndex].nodes;
                bestChoiceIndex = -1;
            }
            for (var i = nodes.length - 1, ltree = void 0; ltree = nodes[i]; i--) {
                if (!isBranch(ltree)) {
                    bestChoiceIndex = -1;
                    break;
                }
                var oldLRatio = squarifiedRatio(ltree.rect.width, ltree.rect.height, ltree.nodes.length + 1);
                var nw = Math.max(ltree.rect.x + ltree.rect.width, newLeaf.rect.x + newLeaf.rect.width) - Math.min(ltree.rect.x, newLeaf.rect.x);
                var nh = Math.max(ltree.rect.y + ltree.rect.height, newLeaf.rect.y + newLeaf.rect.height) - Math.min(ltree.rect.y, newLeaf.rect.y);
                var lratio = squarifiedRatio(nw, nh, ltree.nodes.length + 2);
                if (bestChoiceIndex < 0 || Math.abs(lratio - oldLRatio) < bestChoiceArea) {
                    bestChoiceArea = Math.abs(lratio - oldLRatio);
                    bestChoiceIndex = i;
                }
            }
        }
        return result;
    };
    RTree.prototype.linearSplit = function (nodes) {
        var n = this.pickLinear(nodes);
        while (nodes.length > 0) {
            this.pickNext(nodes, n[0], n[1]);
        }
        return n;
    };
    RTree.prototype.pickLinear = function (nodes) {
        var lowestHighX = nodes.length - 1;
        var highestLowX = 0;
        var lowestHighY = nodes.length - 1;
        var highestLowY = 0;
        var t1;
        var t2;
        for (var i = nodes.length - 2, l = void 0; l = nodes[i]; i--) {
            if (l.rect.x > nodes[highestLowX].rect.x)
                highestLowX = i;
            else if (l.rect.right < nodes[lowestHighX].rect.right)
                lowestHighX = i;
            if (l.rect.y > nodes[highestLowY].rect.y)
                highestLowY = i;
            else if (l.rect.bottom < nodes[lowestHighY].rect.bottom)
                lowestHighY = i;
        }
        var dx = Math.abs((nodes[lowestHighX].rect.right) - nodes[highestLowX].rect.x);
        var dy = Math.abs((nodes[lowestHighY].rect.bottom) - nodes[highestLowY].rect.y);
        if (dx > dy) {
            if (lowestHighX > highestLowX) {
                t1 = nodes.splice(lowestHighX, 1)[0];
                t2 = nodes.splice(highestLowX, 1)[0];
            }
            else {
                t2 = nodes.splice(highestLowX, 1)[0];
                t1 = nodes.splice(lowestHighX, 1)[0];
            }
        }
        else {
            if (lowestHighY > highestLowY) {
                t1 = nodes.splice(lowestHighY, 1)[0];
                t2 = nodes.splice(highestLowY, 1)[0];
            }
            else {
                t2 = nodes.splice(highestLowY, 1)[0];
                t1 = nodes.splice(lowestHighY, 1)[0];
            }
        }
        return [
            new RTreeNodeBranch(t1.rect.clone(), [t1]),
            new RTreeNodeBranch(t2.rect.clone(), [t2])
        ];
    };
    RTree.prototype.pickNext = function (nodes, a, b) {
        var areaA = squarifiedRatio(a.rect.width, a.rect.height, a.nodes.length + 1);
        var areaB = squarifiedRatio(b.rect.width, b.rect.height, b.nodes.length + 1);
        var highAreaDelta;
        var highAreaNode;
        var lowestGrowthGroup;
        for (var i = nodes.length - 1, l = void 0; l = nodes[i]; i--) {
            var newAreaA = new rectangle_1.Rectangle(Math.min(a.rect.x, l.rect.x), Math.min(a.rect.y, l.rect.y), 0, 0);
            newAreaA.width = Math.max(a.rect.right, l.rect.right) - newAreaA.x;
            newAreaA.height = Math.max(a.rect.bottom, l.rect.bottom) - newAreaA.y;
            var changeNewAreaA = Math.abs(squarifiedRatio(newAreaA.width, newAreaA.height, a.nodes.length + 2) - areaA);
            var newAreaB = new rectangle_1.Rectangle(Math.min(b.rect.x, l.rect.x), Math.min(b.rect.y, l.rect.y), 0, 0);
            newAreaB.width = Math.max(b.rect.right, l.rect.right) - newAreaB.x;
            newAreaB.height = Math.max(b.rect.bottom, l.rect.bottom) - newAreaB.y;
            var changeNewAreaB = Math.abs(squarifiedRatio(newAreaB.width, newAreaB.height, b.nodes.length + 2) - areaB);
            if (!highAreaNode || !highAreaDelta || Math.abs(changeNewAreaB - changeNewAreaA) < highAreaDelta) {
                highAreaNode = i;
                highAreaDelta = Math.abs(changeNewAreaB - changeNewAreaA);
                lowestGrowthGroup = changeNewAreaB < changeNewAreaA ? b : a;
            }
        }
        var tmp = nodes.splice(highAreaNode, 1)[0];
        if (a.nodes.length + nodes.length + 1 <= this.minWidth) {
            a.nodes.push(tmp);
            expandRect(a.rect, tmp.rect);
        }
        else if (b.nodes.length + nodes.length + 1 <= this.minWidth) {
            b.nodes.push(tmp);
            expandRect(b.rect, tmp.rect);
        }
        else {
            lowestGrowthGroup.nodes.push(tmp);
            expandRect(lowestGrowthGroup.rect, tmp.rect);
        }
    };
    return RTree;
}());
exports.RTree = RTree;
var RTreeNode = (function () {
    function RTreeNode(rect) {
        this.rect = rect;
    }
    return RTreeNode;
}());
var RTreeNodeLeaf = (function (_super) {
    __extends(RTreeNodeLeaf, _super);
    function RTreeNodeLeaf(rect, obj) {
        var _this = _super.call(this, rect) || this;
        _this.obj = obj;
        return _this;
    }
    return RTreeNodeLeaf;
}(RTreeNode));
var RTreeNodeBranch = (function (_super) {
    __extends(RTreeNodeBranch, _super);
    function RTreeNodeBranch(rect, nodes) {
        var _this = _super.call(this, rect) || this;
        _this.nodes = nodes;
        return _this;
    }
    return RTreeNodeBranch;
}(RTreeNode));
function isBranch(node) {
    return "nodes" in node;
}
function squarifiedRatio(width, height, fill) {
    var lperi = (width + height) / 2;
    var larea = width * height;
    var lgeo = larea / (lperi * lperi);
    return larea * fill / lgeo;
}
function expandRect(rect, other) {
    var rx = Math.max(rect.right, other.right);
    var ry = Math.max(rect.bottom, other.bottom);
    rect.x = Math.min(rect.x, other.x);
    rect.y = Math.min(rect.y, other.y);
    rect.width = rx - rect.x;
    rect.height = ry - rect.y;
}


/***/ }),

/***/ 701:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HashSet = void 0;
var HashSet = (function () {
    function HashSet(list, getHashCode) {
        var _this = this;
        if (list === void 0) { list = []; }
        if (getHashCode === void 0) { getHashCode = function (item) { return item.toString(); }; }
        this.items = [];
        this.map = {};
        this.getHashCode = getHashCode;
        list.forEach(function (i) { return _this.tryPush(i); });
    }
    HashSet.prototype.tryPush = function (item) {
        var code = this.getHashCode(item);
        if (this.map[code] === undefined) {
            this.map[code] = this.items.push(item) - 1;
            return true;
        }
        return false;
    };
    HashSet.prototype.contains = function (item) {
        return this.map[this.getHashCode(item)] !== undefined;
    };
    HashSet.prototype.forEach = function (callback) {
        this.items.forEach(callback);
    };
    HashSet.prototype.filter = function (predicate) {
        return this.items.filter(predicate);
    };
    HashSet.prototype.list = function () {
        return this.items.slice(0);
    };
    HashSet.prototype.item = function (index) {
        return this.items[index];
    };
    HashSet.prototype.first = function () {
        return this.items[0];
    };
    HashSet.prototype.remove = function (item) {
        var code = this.getHashCode(item);
        var index = this.map[code];
        if (typeof index === "number") {
            delete this.map[code];
            this.items.splice(index, 1);
            for (var i = index; i < this.items.length; i++)
                this.map[this.getHashCode(this.items[i])]--;
        }
        else
            throw "Item not found";
    };
    Object.defineProperty(HashSet.prototype, "length", {
        get: function () { return this.items.length; },
        enumerable: false,
        configurable: true
    });
    return HashSet;
}());
exports.HashSet = HashSet;


/***/ }),

/***/ 6224:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DiagramLocalizationService = void 0;
var ShapeTypes_1 = __webpack_require__(2259);
var Enums_1 = __webpack_require__(5383);
var DiagramLocalizationService = (function () {
    function DiagramLocalizationService() {
    }
    DiagramLocalizationService.unitItems = {};
    DiagramLocalizationService.formatUnit = function (value) { return value.toString(); };
    DiagramLocalizationService.shapeTexts = {};
    return DiagramLocalizationService;
}());
exports.DiagramLocalizationService = DiagramLocalizationService;
DiagramLocalizationService.unitItems[Enums_1.DiagramUnit.In] = "in";
DiagramLocalizationService.unitItems[Enums_1.DiagramUnit.Cm] = "cm";
DiagramLocalizationService.unitItems[Enums_1.DiagramUnit.Px] = "px";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Text] = "Text";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Rectangle] = "Rectangle";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Ellipse] = "Ellipse";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Cross] = "Cross";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Triangle] = "Triangle";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Diamond] = "Diamond";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Heart] = "Heart";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Pentagon] = "Pentagon";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Hexagon] = "Hexagon";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Octagon] = "Octagon";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Star] = "Star";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ArrowLeft] = "Left Arrow";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ArrowUp] = "Up Arrow";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ArrowRight] = "Right Arrow";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ArrowDown] = "Down Arrow";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ArrowUpDown] = "Up Down Arrow";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ArrowLeftRight] = "Left Right Arrow";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Process] = "Process";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Decision] = "Decision";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Terminator] = "Terminator";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.PredefinedProcess] = "Predefined Process";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Document] = "Document";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.MultipleDocuments] = "Multiple Documents";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ManualInput] = "Manual Input";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Preparation] = "Preparation";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Data] = "Data";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Database] = "Database";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.HardDisk] = "Hard Disk";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.InternalStorage] = "Internal Storage";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.PaperTape] = "Paper Tape";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ManualOperation] = "Manual Operation";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Delay] = "Delay";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.StoredData] = "Stored Data";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Display] = "Display";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Merge] = "Merge";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Connector] = "Connector";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Or] = "Or";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.SummingJunction] = "Summing Junction";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Container] = "Container";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.VerticalContainer] = "Vertical Container";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.HorizontalContainer] = "Horizontal Container";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Card] = "Person's Name";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.CardWithImageOnLeft] = "Card with Image on the Left";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.CardWithImageOnTop] = "Card with Image on the Top";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.CardWithImageOnRight] = "Card with Image on the Right";


/***/ }),

/***/ 6879:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DiagramModelOperation = exports.ModelOperationSettings = void 0;
var ModelOperationSettings = (function () {
    function ModelOperationSettings() {
        this._addShape = true;
        this._addShapeFromToolbox = true;
        this._deleteShape = true;
        this._deleteConnector = true;
        this._changeConnection = true;
        this._changeConnectorPoints = true;
        this._changeShapeText = true;
        this._changeConnectorText = true;
        this._resizeShape = true;
        this._moveShape = true;
    }
    Object.defineProperty(ModelOperationSettings.prototype, "addShape", {
        get: function () { return this._addShape; },
        set: function (value) {
            if (value !== this._addShape)
                this._addShape = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ModelOperationSettings.prototype, "addShapeFromToolbox", {
        get: function () { return this._addShapeFromToolbox; },
        set: function (value) {
            if (value !== this._addShapeFromToolbox)
                this._addShapeFromToolbox = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ModelOperationSettings.prototype, "deleteShape", {
        get: function () { return this._deleteShape; },
        set: function (value) {
            if (value !== this._deleteShape)
                this._deleteShape = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ModelOperationSettings.prototype, "deleteConnector", {
        get: function () { return this._deleteConnector; },
        set: function (value) {
            if (value !== this._deleteConnector)
                this._deleteConnector = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ModelOperationSettings.prototype, "changeConnection", {
        get: function () { return this._changeConnection; },
        set: function (value) {
            if (value !== this._changeConnection)
                this._changeConnection = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ModelOperationSettings.prototype, "changeConnectorPoints", {
        get: function () { return this._changeConnectorPoints; },
        set: function (value) {
            if (value !== this._changeConnectorPoints)
                this._changeConnectorPoints = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ModelOperationSettings.prototype, "changeShapeText", {
        get: function () { return this._changeShapeText; },
        set: function (value) {
            if (value !== this._changeShapeText)
                this._changeShapeText = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ModelOperationSettings.prototype, "changeConnectorText", {
        get: function () { return this._changeConnectorText; },
        set: function (value) {
            if (value !== this._changeConnectorText)
                this._changeConnectorText = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ModelOperationSettings.prototype, "resizeShape", {
        get: function () { return this._resizeShape; },
        set: function (value) {
            if (value !== this._resizeShape)
                this._resizeShape = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ModelOperationSettings.prototype, "moveShape", {
        get: function () { return this._moveShape; },
        set: function (value) {
            if (value !== this._moveShape)
                this._moveShape = value;
        },
        enumerable: false,
        configurable: true
    });
    ModelOperationSettings.prototype.applySettings = function (settings) {
        if (!settings)
            return;
        if (typeof settings.addShape === "boolean")
            this.addShape = settings.addShape;
        if (typeof settings.addShapeFromToolbox === "boolean")
            this.addShapeFromToolbox = settings.addShapeFromToolbox;
        if (typeof settings.deleteShape === "boolean")
            this.deleteShape = settings.deleteShape;
        if (typeof settings.deleteConnector === "boolean")
            this.deleteConnector = settings.deleteConnector;
        if (typeof settings.changeConnection === "boolean")
            this.changeConnection = settings.changeConnection;
        if (typeof settings.changeConnectorPoints === "boolean")
            this.changeConnectorPoints = settings.changeConnectorPoints;
        if (typeof settings.changeShapeText === "boolean")
            this.changeShapeText = settings.changeShapeText;
        if (typeof settings.changeConnectorText === "boolean")
            this.changeConnectorText = settings.changeConnectorText;
        if (typeof settings.resizeShape === "boolean")
            this.resizeShape = settings.resizeShape;
        if (typeof settings.moveShape === "boolean")
            this.moveShape = settings.moveShape;
    };
    return ModelOperationSettings;
}());
exports.ModelOperationSettings = ModelOperationSettings;
var DiagramModelOperation;
(function (DiagramModelOperation) {
    DiagramModelOperation[DiagramModelOperation["AddShape"] = 0] = "AddShape";
    DiagramModelOperation[DiagramModelOperation["AddShapeFromToolbox"] = 1] = "AddShapeFromToolbox";
    DiagramModelOperation[DiagramModelOperation["DeleteShape"] = 2] = "DeleteShape";
    DiagramModelOperation[DiagramModelOperation["DeleteConnector"] = 3] = "DeleteConnector";
    DiagramModelOperation[DiagramModelOperation["ChangeConnection"] = 4] = "ChangeConnection";
    DiagramModelOperation[DiagramModelOperation["ChangeConnectorPoints"] = 5] = "ChangeConnectorPoints";
    DiagramModelOperation[DiagramModelOperation["BeforeChangeShapeText"] = 6] = "BeforeChangeShapeText";
    DiagramModelOperation[DiagramModelOperation["ChangeShapeText"] = 7] = "ChangeShapeText";
    DiagramModelOperation[DiagramModelOperation["BeforeChangeConnectorText"] = 8] = "BeforeChangeConnectorText";
    DiagramModelOperation[DiagramModelOperation["ChangeConnectorText"] = 9] = "ChangeConnectorText";
    DiagramModelOperation[DiagramModelOperation["ResizeShape"] = 10] = "ResizeShape";
    DiagramModelOperation[DiagramModelOperation["MoveShape"] = 11] = "MoveShape";
})(DiagramModelOperation = exports.DiagramModelOperation || (exports.DiagramModelOperation = {}));


/***/ }),

/***/ 7228:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectionPoint = void 0;
var point_1 = __webpack_require__(8900);
var DiagramItem_1 = __webpack_require__(3742);
var ConnectionPoint = (function (_super) {
    __extends(ConnectionPoint, _super);
    function ConnectionPoint(x, y, side) {
        if (side === void 0) { side = DiagramItem_1.ConnectionPointSide.Undefined; }
        var _this = _super.call(this, x, y) || this;
        _this.side = side;
        return _this;
    }
    ConnectionPoint.prototype.offset = function (offsetX, offsetY) {
        _super.prototype.offset.call(this, offsetX, offsetY);
        this.side = DiagramItem_1.ConnectionPointSide.Undefined;
        return this;
    };
    ConnectionPoint.prototype.multiply = function (multiplierX, multiplierY) {
        _super.prototype.multiply.call(this, multiplierX, multiplierY);
        this.side = DiagramItem_1.ConnectionPointSide.Undefined;
        return this;
    };
    ConnectionPoint.prototype.clone = function () { return new ConnectionPoint(this.x, this.y, this.side); };
    ConnectionPoint.prototype.toPoint = function () { return new point_1.Point(this.x, this.y); };
    return ConnectionPoint;
}(point_1.Point));
exports.ConnectionPoint = ConnectionPoint;


/***/ }),

/***/ 5800:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorPointsCalculator = void 0;
var ConnectorPointsCalculatorBase_1 = __webpack_require__(7595);
var ConnectorRenderPoint_1 = __webpack_require__(4717);
var ConnectorPointsCalculator = (function (_super) {
    __extends(ConnectorPointsCalculator, _super);
    function ConnectorPointsCalculator() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ConnectorPointsCalculator.prototype.getPoints = function () {
        return this.connector.points.map(function (pt, index) { return new ConnectorRenderPoint_1.ConnectorRenderPoint(pt.x, pt.y, index); });
    };
    return ConnectorPointsCalculator;
}(ConnectorPointsCalculatorBase_1.ConnectorPointsCalculatorBase));
exports.ConnectorPointsCalculator = ConnectorPointsCalculator;


/***/ }),

/***/ 7595:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorPointsCalculatorBase = void 0;
var ConnectorPointsCalculatorBase = (function () {
    function ConnectorPointsCalculatorBase(connector) {
        this.connector = connector;
    }
    return ConnectorPointsCalculatorBase;
}());
exports.ConnectorPointsCalculatorBase = ConnectorPointsCalculatorBase;


/***/ }),

/***/ 2342:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorPointsOrthogonalCalculator = void 0;
var rectangle_1 = __webpack_require__(8011);
var DiagramItem_1 = __webpack_require__(3742);
var ConnectorPointsCalculatorBase_1 = __webpack_require__(7595);
var ConnectorPointsOrthogonalUndefinedSideCalculator_1 = __webpack_require__(1686);
var ConnectorPointsOrthogonalSouthSideCalculator_1 = __webpack_require__(1774);
var ConnectorPointsOrthogonalNorthSideCalculator_1 = __webpack_require__(993);
var ConnectorPointsOrthogonalEastSideCalculator_1 = __webpack_require__(2290);
var ConnectorPointsOrthogonalWestSideCalculator_1 = __webpack_require__(7369);
var ConnectorRenderPoint_1 = __webpack_require__(4717);
var ModelUtils_1 = __webpack_require__(4867);
var ConnectorPointsOrthogonalCalculator = (function (_super) {
    __extends(ConnectorPointsOrthogonalCalculator, _super);
    function ConnectorPointsOrthogonalCalculator(connector) {
        var _this = _super.call(this, connector) || this;
        _this.sideCalculators = {};
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.Undefined] = new ConnectorPointsOrthogonalUndefinedSideCalculator_1.ConnectorPointsOrthogonalUndefinedSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.South] = new ConnectorPointsOrthogonalSouthSideCalculator_1.ConnectorPointsOrthogonalSouthSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.North] = new ConnectorPointsOrthogonalNorthSideCalculator_1.ConnectorPointsOrthogonalNorthSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.East] = new ConnectorPointsOrthogonalEastSideCalculator_1.ConnectorPointsOrthogonalEastSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.West] = new ConnectorPointsOrthogonalWestSideCalculator_1.ConnectorPointsOrthogonalWestSideCalculator(_this);
        return _this;
    }
    Object.defineProperty(ConnectorPointsOrthogonalCalculator.prototype, "beginRect", {
        get: function () { return this.connector.beginItem ? this.connector.beginItem.rectangle : undefined; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConnectorPointsOrthogonalCalculator.prototype, "endRect", {
        get: function () { return this.connector.endItem ? this.connector.endItem.rectangle : undefined; },
        enumerable: false,
        configurable: true
    });
    ConnectorPointsOrthogonalCalculator.prototype.getPoints = function () {
        var points = this.connector.points.map(function (pt, index) { return new ConnectorRenderPoint_1.ConnectorRenderPoint(pt.x, pt.y, index); });
        ModelUtils_1.ModelUtils.skipUnnecessaryRenderPoints(points, true);
        var beginIndex = 0;
        var endIndex = points.length - 1;
        var beginSide = this.getPointSide(points, 0);
        var beginNextSide = this.getPointSide(points, 1);
        var endSide = this.getPointSide(points, points.length - 1);
        var endPrevSide = this.getPointSide(points, points.length - 1 - 1);
        var beginSideCalculator = this.getSideCalculator(beginSide);
        var endSideCalculator = this.getSideCalculator(endSide);
        var originRect = this.beginRect;
        var originPoint = beginSideCalculator.getCorrectOriginPoint(points[beginIndex], originRect);
        var targetPoint = points[beginIndex + 1];
        if (points.length === 2 && beginSideCalculator.isOnSidePoint(originPoint, targetPoint) &&
            beginSideCalculator.isDirectConnectionAllowed(beginNextSide, originPoint, targetPoint)) {
            var directConnectionPoints = beginSideCalculator.getDirectConnectionPoints(originPoint, targetPoint);
            directConnectionPoints.forEach(function (pt) {
                points.splice(beginIndex + 1, 0, pt);
                beginIndex++;
                endIndex++;
            });
        }
        else {
            var bOffsetPoints = beginSideCalculator.getBeginOffsetPoints(beginNextSide, points[beginIndex], points[beginIndex + 1], this.beginRect);
            bOffsetPoints.forEach(function (pt) {
                points.splice(beginIndex + 1, 0, pt);
            });
            beginIndex += bOffsetPoints.length;
            endIndex += bOffsetPoints.length;
            var eOffsetPoints = endSideCalculator.getEndOffsetPoints(endPrevSide, points[endIndex], points[endIndex - 1], this.endRect);
            eOffsetPoints.forEach(function (pt, index) {
                points.splice(endIndex + index, 0, pt);
            });
            this.addMiddlePoints(points, beginIndex, endIndex);
        }
        ModelUtils_1.ModelUtils.skipUnnecessaryRenderPoints(points, true);
        return points;
    };
    ConnectorPointsOrthogonalCalculator.prototype.getSideCalculator = function (side) {
        return this.sideCalculators[side];
    };
    ConnectorPointsOrthogonalCalculator.prototype.getPointSide = function (points, index) {
        if (index === 0 && this.connector.beginItem) {
            var connectionPointIndex = this.connector.beginConnectionPointIndex;
            return this.connector.beginItem.getConnectionPointSideByIndex(connectionPointIndex, points[1]);
        }
        if (index === points.length - 1 && this.connector.endItem) {
            var connectionPointIndex = this.connector.endConnectionPointIndex;
            return this.connector.endItem.getConnectionPointSideByIndex(connectionPointIndex, points[points.length - 2]);
        }
        return DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalCalculator.prototype.addMiddlePoints = function (points, beginIndex, endIndex) {
        for (var index = beginIndex; index < endIndex; index++) {
            var nextIndex = index + 1;
            var middlePoint = this.getMiddlePoint(points[index], points[index - 1], index - 1 === 0, points[nextIndex], points[nextIndex + 1], nextIndex + 1 === points.length - 1);
            if (middlePoint !== undefined) {
                points.splice(index + 1, 0, middlePoint);
                index++;
                endIndex++;
            }
        }
    };
    ConnectorPointsOrthogonalCalculator.prototype.getMiddlePoints = function (point1, point2) {
        if (point1.x === point2.x || point1.y === point2.y)
            return [];
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(point1.x, point2.y),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(point2.x, point1.y)
        ];
    };
    ConnectorPointsOrthogonalCalculator.prototype.getMiddlePoint = function (point1, directionPoint1, nextToBegin, point2, directionPoint2, nextToEnd) {
        var _this = this;
        var point;
        var points = this.getMiddlePoints(point1, point2);
        points.forEach(function (pt) {
            var rect1 = _this.createPointsRect(point1, pt);
            var rect2 = _this.createPointsRect(pt, point2);
            var itemRect1 = _this.connector.beginItem ? _this.connector.beginItem.rectangle : undefined;
            var itemRect2 = _this.connector.endItem ? _this.connector.endItem.rectangle : undefined;
            if (itemRect1)
                if (rectangle_1.Rectangle.areIntersected(itemRect1, rect1) || rectangle_1.Rectangle.areIntersected(itemRect1, rect2))
                    return;
            if (itemRect2)
                if (rectangle_1.Rectangle.areIntersected(itemRect2, rect1) || rectangle_1.Rectangle.areIntersected(itemRect2, rect2))
                    return;
            if ((!_this.isReturnPoint(pt, point1, directionPoint1) || _this.isIntermediatePoints(point1, directionPoint1)) &&
                (!_this.isReturnPoint(pt, point2, directionPoint2) || _this.isIntermediatePoints(point2, directionPoint2)))
                if (point === undefined)
                    point = pt;
                else if (_this.isPriorMiddlePoint(pt, point1, directionPoint1, point2, directionPoint2))
                    point = pt;
        });
        if (point === undefined && points.length > 0)
            point = points[0];
        return point;
    };
    ConnectorPointsOrthogonalCalculator.prototype.createPointsRect = function (point1, point2) {
        var result = rectangle_1.Rectangle.fromPoints(point1, point2);
        if (result.width > 0)
            result = result.clone().inflate(-1, 0);
        if (result.height > 0)
            result = result.clone().inflate(0, -1);
        return result;
    };
    ConnectorPointsOrthogonalCalculator.prototype.isPriorMiddlePoint = function (point, point1, directionPoint1, point2, directionPoint2) {
        if (directionPoint1)
            if (point.x === directionPoint1.x || point.y === directionPoint1.y)
                return true;
        if (directionPoint2)
            if (point.x === directionPoint2.x || point.y === directionPoint2.y)
                return true;
        return false;
    };
    ConnectorPointsOrthogonalCalculator.prototype.isReturnPoint = function (point, point1, point2) {
        if (point1 !== undefined && point2 !== undefined) {
            if (point.x === point2.x)
                if (point1.y < point.y && point.y < point2.y || point1.y > point.y && point.y > point2.y)
                    return true;
            if (point.y === point2.y)
                if (point1.x < point.x && point.x < point2.x || point1.x > point.x && point.x > point2.x)
                    return true;
        }
        return false;
    };
    ConnectorPointsOrthogonalCalculator.prototype.isIntermediatePoints = function (point1, point2) {
        return 0 < point1.pointIndex && point1.pointIndex < this.connector.points.length - 1 &&
            0 < point2.pointIndex && point2.pointIndex < this.connector.points.length - 1;
    };
    return ConnectorPointsOrthogonalCalculator;
}(ConnectorPointsCalculatorBase_1.ConnectorPointsCalculatorBase));
exports.ConnectorPointsOrthogonalCalculator = ConnectorPointsOrthogonalCalculator;


/***/ }),

/***/ 2290:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorPointsOrthogonalEastSideCalculator = void 0;
var DiagramItem_1 = __webpack_require__(3742);
var ConnectorPointsOrthogonalSideCalculatorBase_1 = __webpack_require__(1816);
var ConnectorRenderPoint_1 = __webpack_require__(4717);
var ConnectorPointsOrthogonalEastSideCalculator = (function (_super) {
    __extends(ConnectorPointsOrthogonalEastSideCalculator, _super);
    function ConnectorPointsOrthogonalEastSideCalculator(parent) {
        return _super.call(this, parent) || this;
    }
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getCorrectOriginPoint = function (originPoint, originRect) {
        if (originPoint.x < originRect.right)
            originPoint = originPoint.clone().offset(originRect.right - originPoint.x, 0);
        return originPoint;
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getSameShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.North:
            case DiagramItem_1.ConnectionPointSide.South:
            case DiagramItem_1.ConnectionPointSide.East:
                return [originPoint.clone().offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset());
        }
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getOverlappedPointsOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                return [originPoint.clone().offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return [originPoint.clone().offset(-this.getMinOffset(), 0)];
        }
        return [];
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getBeginOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.North:
                if (originPoint.x < targetPoint.x)
                    if (originPoint.y < targetPoint.y)
                        return [];
                    else
                        return [originPoint.clone().offset(this.getMinOffset(), 0)];
                if (originPoint.x > this.endRect.right)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                return [originPoint.clone().offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.South:
                if (originPoint.x < targetPoint.x)
                    if (originPoint.y > targetPoint.y)
                        return [];
                    else
                        return [originPoint.clone().offset(this.getMinOffset(), 0)];
                if (originPoint.x > this.endRect.right)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                return [originPoint.clone().offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.East:
                return [originPoint.clone().offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), originPoint.y < targetPoint.y);
        }
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getEndOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                return [originPoint.clone().offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West: {
                var offset = this.getMinOffset();
                if (this.beginRect.right > originPoint.x)
                    offset += this.beginRect.right - originPoint.x;
                return [originPoint.clone().offset(offset, 0)];
            }
            case DiagramItem_1.ConnectionPointSide.North:
                if (targetPoint.x < originPoint.x)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                if (originPoint.y > targetPoint.y)
                    return [originPoint.clone().offset(this.getMinOffset(), 0)];
                return [];
            case DiagramItem_1.ConnectionPointSide.South:
                if (targetPoint.x < originPoint.x)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                if (originPoint.y < targetPoint.y)
                    return [originPoint.clone().offset(this.getMinOffset(), 0)];
                return [];
        }
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getBeginOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.clone().offset(this.getScaleableOffsetX(originPoint, targetPoint, false), 0)];
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getEndOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.clone().offset(this.getScaleableOffsetX(originPoint, targetPoint, true), 0)];
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getBeginOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.South:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, false);
                break;
            case DiagramItem_1.ConnectionPointSide.North:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, true);
                break;
            case DiagramItem_1.ConnectionPointSide.East:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
                break;
            case DiagramItem_1.ConnectionPointSide.Undefined:
            case DiagramItem_1.ConnectionPointSide.West:
                return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
        }
        return [originPoint.clone().offset(this.getScaleableOffsetX(originPoint, targetPoint, false), 0)];
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getEndOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        if (targetSide === DiagramItem_1.ConnectionPointSide.Undefined)
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true);
        else if (this.isBeginEndOverlappedY()) {
            var direction = this.beginRect.center.y > this.endRect.center.y;
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true, direction);
        }
        return [originPoint.clone().offset(this.getScaleableOffsetX(originPoint, targetPoint, true), 0)];
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getAsideOffsetPoints = function (originPoint, targetPoint, originRect, offset, asideOffset, direction) {
        var points = [];
        if (originRect !== undefined) {
            if (direction === undefined)
                direction = targetPoint.y < originPoint.y;
            if (direction)
                points.push(originPoint.clone().offset(offset, -(originPoint.y - originRect.y + asideOffset)));
            else
                points.push(originPoint.clone().offset(offset, (originRect.bottom - originPoint.y + asideOffset)));
        }
        points.push(originPoint.clone().offset(offset, 0));
        return points;
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getScaleableAsideOffsetPoints = function (originPoint, targetPoint, originRect, isEnd, direction) {
        var offset = this.getScaleableOffsetX(originPoint, targetPoint, isEnd);
        var asideOffset = this.getScaleableOffsetY(originPoint, targetPoint, isEnd);
        return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, offset, asideOffset, direction);
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getScaleableOffsetX = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            var distance = isEnd ? this.beginRect.x - originPoint.x : this.endRect.x - originPoint.x;
            if (distance > 0 && distance < this.getMinOffset() * 2)
                return distance / 2;
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getScaleableOffsetY = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect)
            if (!isEnd && !this.isBeginEndOverlappedY()) {
                var distance = void 0;
                if (targetPoint.y < originPoint.y)
                    distance = this.beginRect.y - this.endRect.bottom;
                else
                    distance = this.endRect.y - this.beginRect.bottom;
                if (distance < this.getMinOffset() * 2)
                    return distance / 2;
            }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.isOnSidePoint = function (originPoint, targetPoint) {
        return targetPoint.x > originPoint.x;
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.isDirectConnectionAllowed = function (targetSide, originPoint, targetPoint) {
        return targetSide === DiagramItem_1.ConnectionPointSide.West || targetSide === DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalEastSideCalculator.prototype.getDirectConnectionPoints = function (originPoint, targetPoint) {
        var cx = originPoint.x + (targetPoint.x - originPoint.x) / 2;
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, originPoint.y),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, targetPoint.y)
        ];
    };
    return ConnectorPointsOrthogonalEastSideCalculator;
}(ConnectorPointsOrthogonalSideCalculatorBase_1.ConnectorPointsOrthogonalSideCalculatorBase));
exports.ConnectorPointsOrthogonalEastSideCalculator = ConnectorPointsOrthogonalEastSideCalculator;


/***/ }),

/***/ 993:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorPointsOrthogonalNorthSideCalculator = void 0;
var DiagramItem_1 = __webpack_require__(3742);
var ConnectorPointsOrthogonalSideCalculatorBase_1 = __webpack_require__(1816);
var ConnectorRenderPoint_1 = __webpack_require__(4717);
var ConnectorPointsOrthogonalNorthSideCalculator = (function (_super) {
    __extends(ConnectorPointsOrthogonalNorthSideCalculator, _super);
    function ConnectorPointsOrthogonalNorthSideCalculator(parent) {
        return _super.call(this, parent) || this;
    }
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getCorrectOriginPoint = function (originPoint, originRect) {
        if (originPoint.y > originRect.y)
            originPoint = originPoint.clone().offset(0, originRect.y - originPoint.y);
        return originPoint;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getSameShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
            case DiagramItem_1.ConnectionPointSide.West:
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.clone().offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.South:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset());
        }
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getOverlappedPointsOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.South:
                return [originPoint.clone().offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.clone().offset(0, -this.getMinOffset())];
        }
        return [];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getBeginOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (originPoint.y > targetPoint.y)
                    if (originPoint.x > targetPoint.x)
                        return [];
                    else
                        return [originPoint.clone().offset(0, -this.getMinOffset())];
                if (originPoint.y < this.endRect.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                return [originPoint.clone().offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.West:
                if (originPoint.y > targetPoint.y)
                    if (originPoint.x < targetPoint.x)
                        return [];
                    else
                        return [originPoint.clone().offset(0, -this.getMinOffset())];
                if (originPoint.y < this.endRect.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                return [originPoint.clone().offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.clone().offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.South:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), originPoint.x < targetPoint.x);
        }
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getEndOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (targetPoint.y > originPoint.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                if (originPoint.x < targetPoint.x)
                    return [originPoint.clone().offset(0, -this.getMinOffset())];
                return [];
            case DiagramItem_1.ConnectionPointSide.West:
                if (targetPoint.y > originPoint.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                if (originPoint.x > targetPoint.x)
                    return [originPoint.clone().offset(0, -this.getMinOffset())];
                return [];
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.clone().offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.South: {
                var offset = -this.getMinOffset();
                if (this.beginRect.y < originPoint.y)
                    offset -= originPoint.y - this.beginRect.y;
                return [originPoint.clone().offset(0, offset)];
            }
        }
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getBeginOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.clone().offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, false))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getEndOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.clone().offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, true))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getBeginOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, false);
                break;
            case DiagramItem_1.ConnectionPointSide.West:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, true);
                break;
            case DiagramItem_1.ConnectionPointSide.North:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
                break;
            case DiagramItem_1.ConnectionPointSide.Undefined:
            case DiagramItem_1.ConnectionPointSide.South:
                return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
        }
        return [originPoint.clone().offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, false))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getEndOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        if (targetSide === DiagramItem_1.ConnectionPointSide.Undefined)
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true);
        else if (this.isBeginEndOverlappedX()) {
            var direction = this.beginRect.center.x > this.endRect.center.x;
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true, direction);
        }
        return [originPoint.clone().offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, true))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getAsideOffsetPoints = function (originPoint, targetPoint, originRect, offset, asideOffset, direction) {
        var points = [];
        if (originRect !== undefined) {
            if (direction === undefined)
                direction = targetPoint.x < originPoint.x;
            if (direction)
                points.push(originPoint.clone().offset(-(originPoint.x - originRect.x + asideOffset), -offset));
            else
                points.push(originPoint.clone().offset((originRect.right - originPoint.x + asideOffset), -offset));
        }
        points.push(originPoint.clone().offset(0, -offset));
        return points;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getScaleableAsideOffsetPoints = function (originPoint, targetPoint, originRect, isEnd, direction) {
        var offset = this.getScaleableOffsetY(originPoint, targetPoint, isEnd);
        var asideOffset = this.getScaleableOffsetX(originPoint, targetPoint, isEnd);
        return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, offset, asideOffset, direction);
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getScaleableOffsetX = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect)
            if (!isEnd && !this.isBeginEndOverlappedX()) {
                var distance = void 0;
                if (targetPoint.x < originPoint.x)
                    distance = this.beginRect.x - this.endRect.right;
                else
                    distance = this.endRect.x - this.beginRect.right;
                if (distance < this.getMinOffset() * 2)
                    return distance / 2;
            }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getScaleableOffsetY = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            var distance = isEnd ? originPoint.y - this.beginRect.bottom : originPoint.y - this.endRect.bottom;
            if (distance > 0 && distance < this.getMinOffset() * 2)
                return distance / 2;
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.isOnSidePoint = function (originPoint, targetPoint) {
        return targetPoint.y < originPoint.y;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.isDirectConnectionAllowed = function (targetSide, originPoint, targetPoint) {
        return targetSide === DiagramItem_1.ConnectionPointSide.South || targetSide === DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getDirectConnectionPoints = function (originPoint, targetPoint) {
        var cy = targetPoint.y + (originPoint.y - targetPoint.y) / 2;
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(originPoint.x, cy),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(targetPoint.x, cy)
        ];
    };
    return ConnectorPointsOrthogonalNorthSideCalculator;
}(ConnectorPointsOrthogonalSideCalculatorBase_1.ConnectorPointsOrthogonalSideCalculatorBase));
exports.ConnectorPointsOrthogonalNorthSideCalculator = ConnectorPointsOrthogonalNorthSideCalculator;


/***/ }),

/***/ 1816:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorPointsOrthogonalSideCalculatorBase = void 0;
var rectangle_1 = __webpack_require__(8011);
var DiagramItem_1 = __webpack_require__(3742);
var Connector_1 = __webpack_require__(7959);
var ConnectorPointsOrthogonalSideCalculatorBase = (function () {
    function ConnectorPointsOrthogonalSideCalculatorBase(parent) {
        this.parent = parent;
    }
    Object.defineProperty(ConnectorPointsOrthogonalSideCalculatorBase.prototype, "connector", {
        get: function () { return this.parent.connector; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConnectorPointsOrthogonalSideCalculatorBase.prototype, "beginRect", {
        get: function () { return this.parent.beginRect; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConnectorPointsOrthogonalSideCalculatorBase.prototype, "endRect", {
        get: function () { return this.parent.endRect; },
        enumerable: false,
        configurable: true
    });
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getBeginOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        originPoint = this.getCorrectOriginPoint(originPoint, originRect);
        if (targetSide !== DiagramItem_1.ConnectionPointSide.Undefined) {
            if (this.isBeginEndSame())
                return this.getSameShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlappedPoints(originPoint, targetPoint))
                return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlapped())
                return this.getBeginOverlappedShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        }
        else if (this.isOriginRectContainsTargetPoint(originRect, targetPoint))
            return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        if (this.isOnSidePoint(originPoint, targetPoint))
            return this.getBeginOnSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        return this.getBeginOffSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getEndOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        originPoint = this.getCorrectOriginPoint(originPoint, originRect);
        if (targetSide !== DiagramItem_1.ConnectionPointSide.Undefined) {
            if (this.isBeginEndSame())
                return this.getSameShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlappedPoints(targetPoint, originPoint))
                return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlapped())
                return this.getEndOverlappedShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        }
        else if (this.isOriginRectContainsTargetPoint(originRect, targetPoint))
            return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        if (this.isOnSidePoint(originPoint, targetPoint))
            return this.getEndOnSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        return this.getEndOffSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getSide = function (originPoint, targetPoint) {
        var diffX = Math.abs(targetPoint.x - originPoint.x);
        var diffY = Math.abs(targetPoint.y - originPoint.y);
        if (diffX > diffY)
            if (targetPoint.x > originPoint.x)
                return DiagramItem_1.ConnectionPointSide.East;
            else
                return DiagramItem_1.ConnectionPointSide.West;
        else if (targetPoint.y > originPoint.y)
            return DiagramItem_1.ConnectionPointSide.South;
        else
            return DiagramItem_1.ConnectionPointSide.North;
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getSideCalculator = function (originPoint, targetPoint) {
        return this.parent.getSideCalculator(this.getSide(originPoint, targetPoint));
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getMinOffset = function () {
        return Connector_1.Connector.minOffset;
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndSame = function () {
        return this.connector.beginItem === this.connector.endItem;
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlapped = function () {
        return this.beginRect && this.endRect && rectangle_1.Rectangle.areIntersected(this.beginRect, this.endRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlappedX = function () {
        return this.beginRect && this.endRect && !!rectangle_1.Rectangle.getHorizIntersection(this.beginRect, this.endRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlappedY = function () {
        return this.beginRect && this.endRect && !!rectangle_1.Rectangle.getVertIntersection(this.beginRect, this.endRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlappedPoints = function (beginPoint, endPoint) {
        return this.beginRect && this.endRect && (this.beginRect.containsPoint(endPoint) || this.endRect.containsPoint(beginPoint));
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isOriginRectContainsTargetPoint = function (originRect, targetPoint) {
        return originRect && targetPoint && originRect.containsPoint(targetPoint);
    };
    return ConnectorPointsOrthogonalSideCalculatorBase;
}());
exports.ConnectorPointsOrthogonalSideCalculatorBase = ConnectorPointsOrthogonalSideCalculatorBase;


/***/ }),

/***/ 1774:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorPointsOrthogonalSouthSideCalculator = void 0;
var DiagramItem_1 = __webpack_require__(3742);
var ConnectorPointsOrthogonalSideCalculatorBase_1 = __webpack_require__(1816);
var ConnectorRenderPoint_1 = __webpack_require__(4717);
var ConnectorPointsOrthogonalSouthSideCalculator = (function (_super) {
    __extends(ConnectorPointsOrthogonalSouthSideCalculator, _super);
    function ConnectorPointsOrthogonalSouthSideCalculator(parent) {
        return _super.call(this, parent) || this;
    }
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getCorrectOriginPoint = function (originPoint, originRect) {
        if (originPoint.y < originRect.bottom)
            originPoint = originPoint.clone().offset(0, originRect.bottom - originPoint.y);
        return originPoint;
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getSameShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
            case DiagramItem_1.ConnectionPointSide.West:
            case DiagramItem_1.ConnectionPointSide.South:
                return [originPoint.clone().offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset());
        }
    };
    ConnectorPointsOrthogonalSouthSideCalculator.prototype.getOverlappedPointsOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.South:
                return [originPoint.clone().offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
    