/*!
 * jQuery JavaScript Library v3.5.1
 * https://jquery.com/
 *
 * Includes Sizzle.js
 * https://sizzlejs.com/
 *
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2020-05-04T22:49Z
 */
( function( global, factory ) {

	"use strict";

	if ( typeof module === "object" && typeof module.exports === "object" ) {

		// For CommonJS and CommonJS-like environments where a proper `window`
		// is present, execute the factory and get jQuery.
		// For environments that do not have a `window` with a `document`
		// (such as Node.js), expose a factory as module.exports.
		// This accentuates the need for the creation of a real `window`.
		// e.g. var jQuery = require("jquery")(window);
		// See ticket #14549 for more info.
		module.exports = global.document ?
			factory( global, true ) :
			function( w ) {
				if ( !w.document ) {
					throw new Error( "jQuery requires a window with a document" );
				}
				return factory( w );
			};
	} else {
		factory( global );
	}

// Pass this if window is not defined yet
} )( typeof window !== "undefined" ? window : this, function( window, noGlobal ) {

// Edge <= 12 - 13+, Firefox <=18 - 45+, IE 10 - 11, Safari 5.1 - 9+, iOS 6 - 9.1
// throw exceptions when non-strict code (e.g., ASP.NET 4.5) accesses strict mode
// arguments.callee.caller (trac-13335). But as of jQuery 3.0 (2016), strict mode should be common
// enough that all such attempts are guarded in a try block.
"use strict";

var arr = [];

var getProto = Object.getPrototypeOf;

var slice = arr.slice;

var flat = arr.flat ? function( array ) {
	return arr.flat.call( array );
} : function( array ) {
	return arr.concat.apply( [], array );
};


var push = arr.push;

var indexOf = arr.indexOf;

var class2type = {};

var toString = class2type.toString;

var hasOwn = class2type.hasOwnProperty;

var fnToString = hasOwn.toString;

var ObjectFunctionString = fnToString.call( Object );

var support = {};

var isFunction = function isFunction( obj ) {

      // Support: Chrome <=57, Firefox <=52
      // In some browsers, typeof returns "function" for HTML <object> elements
      // (i.e., `typeof document.createElement( "object" ) === "function"`).
      // We don't want to classify *any* DOM node as a function.
      return typeof obj === "function" && typeof obj.nodeType !== "number";
  };


var isWindow = function isWindow( obj ) {
		return obj != null && obj === obj.window;
	};


var document = window.document;



	var preservedScriptAttributes = {
		type: true,
		src: true,
		nonce: true,
		noModule: true
	};

	function DOMEval( code, node, doc ) {
		doc = doc || document;

		var i, val,
			script = doc.createElement( "script" );

		script.text = code;
		if ( node ) {
			for ( i in preservedScriptAttributes ) {

				// Support: Firefox 64+, Edge 18+
				// Some browsers don't support the "nonce" property on scripts.
				// On the other hand, just using `getAttribute` is not enough as
				// the `nonce` attribute is reset to an empty string whenever it
				// becomes browsing-context connected.
				// See https://github.com/whatwg/html/issues/2369
				// See https://html.spec.whatwg.org/#nonce-attributes
				// The `node.getAttribute` check was added for the sake of
				// `jQuery.globalEval` so that it can fake a nonce-containing node
				// via an object.
				val = node[ i ] || node.getAttribute && node.getAttribute( i );
				if ( val ) {
					script.setAttribute( i, val );
				}
			}
		}
		doc.head.appendChild( script ).parentNode.removeChild( script );
	}


function toType( obj ) {
	if ( obj == null ) {
		return obj + "";
	}

	// Support: Android <=2.3 only (functionish RegExp)
	return typeof obj === "object" || typeof obj === "function" ?
		class2type[ toString.call( obj ) ] || "object" :
		typeof obj;
}
/* global Symbol */
// Defining this global in .eslintrc.json would create a danger of using the global
// unguarded in another place, it seems safer to define global only for this module



var
	version = "3.5.1",

	// Define a local copy of jQuery
	jQuery = function( selector, context ) {

		// The jQuery object is actually just the init constructor 'enhanced'
		// Need init if jQuery is called (just allow error to be thrown if not included)
		return new jQuery.fn.init( selector, context );
	};

jQuery.fn = jQuery.prototype = {

	// The current version of jQuery being used
	jquery: version,

	constructor: jQuery,

	// The default length of a jQuery object is 0
	length: 0,

	toArray: function() {
		return slice.call( this );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {

		// Return all the elements in a clean array
		if ( num == null ) {
			return slice.call( this );
		}

		// Return just the one element from the set
		return num < 0 ? this[ num + this.length ] : this[ num ];
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems ) {

		// Build a new jQuery matched element set
		var ret = jQuery.merge( this.constructor(), elems );

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	each: function( callback ) {
		return jQuery.each( this, callback );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map( this, function( elem, i ) {
			return callback.call( elem, i, elem );
		} ) );
	},

	slice: function() {
		return this.pushStack( slice.apply( this, arguments ) );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	even: function() {
		return this.pushStack( jQuery.grep( this, function( _elem, i ) {
			return ( i + 1 ) % 2;
		} ) );
	},

	odd: function() {
		return this.pushStack( jQuery.grep( this, function( _elem, i ) {
			return i % 2;
		} ) );
	},

	eq: function( i ) {
		var len = this.length,
			j = +i + ( i < 0 ? len : 0 );
		return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );
	},

	end: function() {
		return this.prevObject || this.constructor();
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: push,
	sort: arr.sort,
	splice: arr.splice
};

jQuery.extend = jQuery.fn.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[ 0 ] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;

		// Skip the boolean and the target
		target = arguments[ i ] || {};
		i++;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !isFunction( target ) ) {
		target = {};
	}

	// Extend jQuery itself if only one argument is passed
	if ( i === length ) {
		target = this;
		i--;
	}

	for ( ; i < length; i++ ) {

		// Only deal with non-null/undefined values
		if ( ( options = arguments[ i ] ) != null ) {

			// Extend the base object
			for ( name in options ) {
				copy = options[ name ];

				// Prevent Object.prototype pollution
				// Prevent never-ending loop
				if ( name === "__proto__" || target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject( copy ) ||
					( copyIsArray = Array.isArray( copy ) ) ) ) {
					src = target[ name ];

					// Ensure proper type for the source value
					if ( copyIsArray && !Array.isArray( src ) ) {
						clone = [];
					} else if ( !copyIsArray && !jQuery.isPlainObject( src ) ) {
						clone = {};
					} else {
						clone = src;
					}
					copyIsArray = false;

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend( {

	// Unique for each copy of jQuery on the page
	expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),

	// Assume jQuery is ready without the ready module
	isReady: true,

	error: function( msg ) {
		throw new Error( msg );
	},

	noop: function() {},

	isPlainObject: function( obj ) {
		var proto, Ctor;

		// Detect obvious negatives
		// Use toString instead of jQuery.type to catch host objects
		if ( !obj || toString.call( obj ) !== "[object Object]" ) {
			return false;
		}

		proto = getProto( obj );

		// Objects with no prototype (e.g., `Object.create( null )`) are plain
		if ( !proto ) {
			return true;
		}

		// Objects with prototype are plain iff they were constructed by a global Object function
		Ctor = hasOwn.call( proto, "constructor" ) && proto.constructor;
		return typeof Ctor === "function" && fnToString.call( Ctor ) === ObjectFunctionString;
	},

	isEmptyObject: function( obj ) {
		var name;

		for ( name in obj ) {
			return false;
		}
		return true;
	},

	// Evaluates a script in a provided context; falls back to the global one
	// if not specified.
	globalEval: function( code, options, doc ) {
		DOMEval( code, { nonce: options && options.nonce }, doc );
	},

	each: function( obj, callback ) {
		var length, i = 0;

		if ( isArrayLike( obj ) ) {
			length = obj.length;
			for ( ; i < length; i++ ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		} else {
			for ( i in obj ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		}

		return obj;
	},

	// results is for internal usage only
	makeArray: function( arr, results ) {
		var ret = results || [];

		if ( arr != null ) {
			if ( isArrayLike( Object( arr ) ) ) {
				jQuery.merge( ret,
					typeof arr === "string" ?
					[ arr ] : arr
				);
			} else {
				push.call( ret, arr );
			}
		}

		return ret;
	},

	inArray: function( elem, arr, i ) {
		return arr == null ? -1 : indexOf.call( arr, elem, i );
	},

	// Support: Android <=4.0 only, PhantomJS 1 only
	// push.apply(_, arraylike) throws on ancient WebKit
	merge: function( first, second ) {
		var len = +second.length,
			j = 0,
			i = first.length;

		for ( ; j < len; j++ ) {
			first[ i++ ] = second[ j ];
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, invert ) {
		var callbackInverse,
			matches = [],
			i = 0,
			length = elems.length,
			callbackExpect = !invert;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( ; i < length; i++ ) {
			callbackInverse = !callback( elems[ i ], i );
			if ( callbackInverse !== callbackExpect ) {
				matches.push( elems[ i ] );
			}
		}

		return matches;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var length, value,
			i = 0,
			ret = [];

		// Go through the array, translating each of the items to their new values
		if ( isArrayLike( elems ) ) {
			length = elems.length;
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}

		// Go through every key on the object,
		} else {
			for ( i in elems ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}
		}

		// Flatten any nested arrays
		return flat( ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// jQuery.support is not used in Core but other projects attach their
	// properties to it so it needs to exist.
	support: support
} );

if ( typeof Symbol === "function" ) {
	jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];
}

// Populate the class2type map
jQuery.each( "Boolean Number String Function Array Date RegExp Object Error Symbol".split( " " ),
function( _i, name ) {
	class2type[ "[object " + name + "]" ] = name.toLowerCase();
} );

function isArrayLike( obj ) {

	// Support: real iOS 8.2 only (not reproducible in simulator)
	// `in` check used to prevent JIT error (gh-2145)
	// hasOwn isn't used here due to false negatives
	// regarding Nodelist length in IE
	var length = !!obj && "length" in obj && obj.length,
		type = toType( obj );

	if ( isFunction( obj ) || isWindow( obj ) ) {
		return false;
	}

	return type === "array" || length === 0 ||
		typeof length === "number" && length > 0 && ( length - 1 ) in obj;
}
var Sizzle =
/*!
 * Sizzle CSS Selector Engine v2.3.5
 * https://sizzlejs.com/
 *
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://js.foundation/
 *
 * Date: 2020-03-14
 */
( function( window ) {
var i,
	support,
	Expr,
	getText,
	isXML,
	tokenize,
	compile,
	select,
	outermostContext,
	sortInput,
	hasDuplicate,

	// Local document vars
	setDocument,
	document,
	docElem,
	documentIsHTML,
	rbuggyQSA,
	rbuggyMatches,
	matches,
	contains,

	// Instance-specific data
	expando = "sizzle" + 1 * new Date(),
	preferredDoc = window.document,
	dirruns = 0,
	done = 0,
	classCache = createCache(),
	tokenCache = createCache(),
	compilerCache = createCache(),
	nonnativeSelectorCache = createCache(),
	sortOrder = function( a, b ) {
		if ( a === b ) {
			hasDuplicate = true;
		}
		return 0;
	},

	// Instance methods
	hasOwn = ( {} ).hasOwnProperty,
	arr = [],
	pop = arr.pop,
	pushNative = arr.push,
	push = arr.push,
	slice = arr.slice,

	// Use a stripped-down indexOf as it's faster than native
	// https://jsperf.com/thor-indexof-vs-for/5
	indexOf = function( list, elem ) {
		var i = 0,
			len = list.length;
		for ( ; i < len; i++ ) {
			if ( list[ i ] === elem ) {
				return i;
			}
		}
		return -1;
	},

	booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|" +
		"ismap|loop|multiple|open|readonly|required|scoped",

	// Regular expressions

	// http://www.w3.org/TR/css3-selectors/#whitespace
	whitespace = "[\\x20\\t\\r\\n\\f]",

	// https://www.w3.org/TR/css-syntax-3/#ident-token-diagram
	identifier = "(?:\\\\[\\da-fA-F]{1,6}" + whitespace +
		"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",

	// Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors
	attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace +

		// Operator (capture 2)
		"*([*^$|!~]?=)" + whitespace +

		// "Attribute values must be CSS identifiers [capture 5]
		// or strings [capture 3 or capture 4]"
		"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" +
		whitespace + "*\\]",

	pseudos = ":(" + identifier + ")(?:\\((" +

		// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
		// 1. quoted (capture 3; capture 4 or capture 5)
		"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +

		// 2. simple (capture 6)
		"((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" +

		// 3. anything else (capture 2)
		".*" +
		")\\)|)",

	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
	rwhitespace = new RegExp( whitespace + "+", "g" ),
	rtrim = new RegExp( "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" +
		whitespace + "+$", "g" ),

	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
	rcombinators = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace +
		"*" ),
	rdescend = new RegExp( whitespace + "|>" ),

	rpseudo = new RegExp( pseudos ),
	ridentifier = new RegExp( "^" + identifier + "$" ),

	matchExpr = {
		"ID": new RegExp( "^#(" + identifier + ")" ),
		"CLASS": new RegExp( "^\\.(" + identifier + ")" ),
		"TAG": new RegExp( "^(" + identifier + "|[*])" ),
		"ATTR": new RegExp( "^" + attributes ),
		"PSEUDO": new RegExp( "^" + pseudos ),
		"CHILD": new RegExp( "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" +
			whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" +
			whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i" ),
		"bool": new RegExp( "^(?:" + booleans + ")$", "i" ),

		// For use in libraries implementing .is()
		// We use this for POS matching in `select`
		"needsContext": new RegExp( "^" + whitespace +
			"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace +
			"*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i" )
	},

	rhtml = /HTML$/i,
	rinputs = /^(?:input|select|textarea|button)$/i,
	rheader = /^h\d$/i,

	rnative = /^[^{]+\{\s*\[native \w/,

	// Easily-parseable/retrievable ID or TAG or CLASS selectors
	rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,

	rsibling = /[+~]/,

	// CSS escapes
	// http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
	runescape = new RegExp( "\\\\[\\da-fA-F]{1,6}" + whitespace + "?|\\\\([^\\r\\n\\f])", "g" ),
	funescape = function( escape, nonHex ) {
		var high = "0x" + escape.slice( 1 ) - 0x10000;

		return nonHex ?

			// Strip the backslash prefix from a non-hex escape sequence
			nonHex :

			// Replace a hexadecimal escape sequence with the encoded Unicode code point
			// Support: IE <=11+
			// For values outside the Basic Multilingual Plane (BMP), manually construct a
			// surrogate pair
			high < 0 ?
				String.fromCharCode( high + 0x10000 ) :
				String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );
	},

	// CSS string/identifier serialization
	// https://drafts.csswg.org/cssom/#common-serializing-idioms
	rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,
	fcssescape = function( ch, asCodePoint ) {
		if ( asCodePoint ) {

			// U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
			if ( ch === "\0" ) {
				return "\uFFFD";
			}

			// Control characters and (dependent upon position) numbers get escaped as code points
			return ch.slice( 0, -1 ) + "\\" +
				ch.charCodeAt( ch.length - 1 ).toString( 16 ) + " ";
		}

		// Other potentially-special ASCII characters get backslash-escaped
		return "\\" + ch;
	},

	// Used for iframes
	// See setDocument()
	// Removing the function wrapper causes a "Permission Denied"
	// error in IE
	unloadHandler = function() {
		setDocument();
	},

	inDisabledFieldset = addCombinator(
		function( elem ) {
			return elem.disabled === true && elem.nodeName.toLowerCase() === "fieldset";
		},
		{ dir: "parentNode", next: "legend" }
	);

// Optimize for push.apply( _, NodeList )
try {
	push.apply(
		( arr = slice.call( preferredDoc.childNodes ) ),
		preferredDoc.childNodes
	);

	// Support: Android<4.0
	// Detect silently failing push.apply
	// eslint-disable-next-line no-unused-expressions
	arr[ preferredDoc.childNodes.length ].nodeType;
} catch ( e ) {
	push = { apply: arr.length ?

		// Leverage slice if possible
		function( target, els ) {
			pushNative.apply( target, slice.call( els ) );
		} :

		// Support: IE<9
		// Otherwise append directly
		function( target, els ) {
			var j = target.length,
				i = 0;

			// Can't trust NodeList.length
			while ( ( target[ j++ ] = els[ i++ ] ) ) {}
			target.length = j - 1;
		}
	};
}

function Sizzle( selector, context, results, seed ) {
	var m, i, elem, nid, match, groups, newSelector,
		newContext = context && context.ownerDocument,

		// nodeType defaults to 9, since context defaults to document
		nodeType = context ? context.nodeType : 9;

	results = results || [];

	// Return early from calls with invalid selector or context
	if ( typeof selector !== "string" || !selector ||
		nodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {

		return results;
	}

	// Try to shortcut find operations (as opposed to filters) in HTML documents
	if ( !seed ) {
		setDocument( context );
		context = context || document;

		if ( documentIsHTML ) {

			// If the selector is sufficiently simple, try using a "get*By*" DOM method
			// (excepting DocumentFragment context, where the methods don't exist)
			if ( nodeType !== 11 && ( match = rquickExpr.exec( selector ) ) ) {

				// ID selector
				if ( ( m = match[ 1 ] ) ) {

					// Document context
					if ( nodeType === 9 ) {
						if ( ( elem = context.getElementById( m ) ) ) {

							// Support: IE, Opera, Webkit
							// TODO: identify versions
							// getElementById can match elements by name instead of ID
							if ( elem.id === m ) {
								results.push( elem );
								return results;
							}
						} else {
							return results;
						}

					// Element context
					} else {

						// Support: IE, Opera, Webkit
						// TODO: identify versions
						// getElementById can match elements by name instead of ID
						if ( newContext && ( elem = newContext.getElementById( m ) ) &&
							contains( context, elem ) &&
							elem.id === m ) {

							results.push( elem );
							return results;
						}
					}

				// Type selector
				} else if ( match[ 2 ] ) {
					push.apply( results, context.getElementsByTagName( selector ) );
					return results;

				// Class selector
				} else if ( ( m = match[ 3 ] ) && support.getElementsByClassName &&
					context.getElementsByClassName ) {

					push.apply( results, context.getElementsByClassName( m ) );
					return results;
				}
			}

			// Take advantage of querySelectorAll
			if ( support.qsa &&
				!nonnativeSelectorCache[ selector + " " ] &&
				( !rbuggyQSA || !rbuggyQSA.test( selector ) ) &&

				// Support: IE 8 only
				// Exclude object elements
				( nodeType !== 1 || context.nodeName.toLowerCase() !== "object" ) ) {

				newSelector = selector;
				newContext = context;

				// qSA considers elements outside a scoping root when evaluating child or
				// descendant combinators, which is not what we want.
				// In such cases, we work around the behavior by prefixing every selector in the
				// list with an ID selector referencing the scope context.
				// The technique has to be used as well when a leading combinator is used
				// as such selectors are not recognized by querySelectorAll.
				// Thanks to Andrew Dupont for this technique.
				if ( nodeType === 1 &&
					( rdescend.test( selector ) || rcombinators.test( selector ) ) ) {

					// Expand context for sibling selectors
					newContext = rsibling.test( selector ) && testContext( context.parentNode ) ||
						context;

					// We can use :scope instead of the ID hack if the browser
					// supports it & if we're not changing the context.
					if ( newContext !== context || !support.scope ) {

						// Capture the context ID, setting it first if necessary
						if ( ( nid = context.getAttribute( "id" ) ) ) {
							nid = nid.replace( rcssescape, fcssescape );
						} else {
							context.setAttribute( "id", ( nid = expando ) );
						}
					}

					// Prefix every selector in the list
					groups = tokenize( selector );
					i = groups.length;
					while ( i-- ) {
						groups[ i ] = ( nid ? "#" + nid : ":scope" ) + " " +
							toSelector( groups[ i ] );
					}
					newSelector = groups.join( "," );
				}

				try {
					push.apply( results,
						newContext.querySelectorAll( newSelector )
					);
					return results;
				} catch ( qsaError ) {
					nonnativeSelectorCache( selector, true );
				} finally {
					if ( nid === expando ) {
						context.removeAttribute( "id" );
					}
				}
			}
		}
	}

	// All others
	return select( selector.replace( rtrim, "$1" ), context, results, seed );
}

/**
 * Create key-value caches of limited size
 * @returns {function(string, object)} Returns the Object data after storing it on itself with
 *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
 *	deleting the oldest entry
 */
function createCache() {
	var keys = [];

	function cache( key, value ) {

		// Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
		if ( keys.push( key + " " ) > Expr.cacheLength ) {

			// Only keep the most recent entries
			delete cache[ keys.shift() ];
		}
		return ( cache[ key + " " ] = value );
	}
	return cache;
}

/**
 * Mark a function for special use by Sizzle
 * @param {Function} fn The function to mark
 */
function markFunction( fn ) {
	fn[ expando ] = true;
	return fn;
}

/**
 * Support testing using an element
 * @param {Function} fn Passed the created element and returns a boolean result
 */
function assert( fn ) {
	var el = document.createElement( "fieldset" );

	try {
		return !!fn( el );
	} catch ( e ) {
		return false;
	} finally {

		// Remove from its parent by default
		if ( el.parentNode ) {
			el.parentNode.removeChild( el );
		}

		// release memory in IE
		el = null;
	}
}

/**
 * Adds the same handler for all of the specified attrs
 * @param {String} attrs Pipe-separated list of attributes
 * @param {Function} handler The method that will be applied
 */
function addHandle( attrs, handler ) {
	var arr = attrs.split( "|" ),
		i = arr.length;

	while ( i-- ) {
		Expr.attrHandle[ arr[ i ] ] = handler;
	}
}

/**
 * Checks document order of two siblings
 * @param {Element} a
 * @param {Element} b
 * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
 */
function siblingCheck( a, b ) {
	var cur = b && a,
		diff = cur && a.nodeType === 1 && b.nodeType === 1 &&
			a.sourceIndex - b.sourceIndex;

	// Use IE sourceIndex if available on both nodes
	if ( diff ) {
		return diff;
	}

	// Check if b follows a
	if ( cur ) {
		while ( ( cur = cur.nextSibling ) ) {
			if ( cur === b ) {
				return -1;
			}
		}
	}

	return a ? 1 : -1;
}

/**
 * Returns a function to use in pseudos for input types
 * @param {String} type
 */
function createInputPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return name === "input" && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for buttons
 * @param {String} type
 */
function createButtonPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return ( name === "input" || name === "button" ) && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for :enabled/:disabled
 * @param {Boolean} disabled true for :disabled; false for :enabled
 */
function createDisabledPseudo( disabled ) {

	// Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable
	return function( elem ) {

		// Only certain elements can match :enabled or :disabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled
		if ( "form" in elem ) {

			// Check for inherited disabledness on relevant non-disabled elements:
			// * listed form-associated elements in a disabled fieldset
			//   https://html.spec.whatwg.org/multipage/forms.html#category-listed
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled
			// * option elements in a disabled optgroup
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled
			// All such elements have a "form" property.
			if ( elem.parentNode && elem.disabled === false ) {

				// Option elements defer to a parent optgroup if present
				if ( "label" in elem ) {
					if ( "label" in elem.parentNode ) {
						return elem.parentNode.disabled === disabled;
					} else {
						return elem.disabled === disabled;
					}
				}

				// Support: IE 6 - 11
				// Use the isDisabled shortcut property to check for disabled fieldset ancestors
				return elem.isDisabled === disabled ||

					// Where there is no isDisabled, check manually
					/* jshint -W018 */
					elem.isDisabled !== !disabled &&
					inDisabledFieldset( elem ) === disabled;
			}

			return elem.disabled === disabled;

		// Try to winnow out elements that can't be disabled before trusting the disabled property.
		// Some victims get caught in our net (label, legend, menu, track), but it shouldn't
		// even exist on them, let alone have a boolean value.
		} else if ( "label" in elem ) {
			return elem.disabled === disabled;
		}

		// Remaining elements are neither :enabled nor :disabled
		return false;
	};
}

/**
 * Returns a function to use in pseudos for positionals
 * @param {Function} fn
 */
function createPositionalPseudo( fn ) {
	return markFunction( function( argument ) {
		argument = +argument;
		return markFunction( function( seed, matches ) {
			var j,
				matchIndexes = fn( [], seed.length, argument ),
				i = matchIndexes.length;

			// Match elements found at the specified indexes
			while ( i-- ) {
				if ( seed[ ( j = matchIndexes[ i ] ) ] ) {
					seed[ j ] = !( matches[ j ] = seed[ j ] );
				}
			}
		} );
	} );
}

/**
 * Checks a node for validity as a Sizzle context
 * @param {Element|Object=} context
 * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
 */
function testContext( context ) {
	return context && typeof context.getElementsByTagName !== "undefined" && context;
}

// Expose support vars for convenience
support = Sizzle.support = {};

/**
 * Detects XML nodes
 * @param {Element|Object} elem An element or a document
 * @returns {Boolean} True iff elem is a non-HTML XML node
 */
isXML = Sizzle.isXML = function( elem ) {
	var namespace = elem.namespaceURI,
		docElem = ( elem.ownerDocument || elem ).documentElement;

	// Support: IE <=8
	// Assume HTML when documentElement doesn't yet exist, such as inside loading iframes
	// https://bugs.jquery.com/ticket/4833
	return !rhtml.test( namespace || docElem && docElem.nodeName || "HTML" );
};

/**
 * Sets document-related variables once based on the current document
 * @param {Element|Object} [doc] An element or document object to use to set the document
 * @returns {Object} Returns the current document
 */
setDocument = Sizzle.setDocument = function( node ) {
	var hasCompare, subWindow,
		doc = node ? node.ownerDocument || node : preferredDoc;

	// Return early if doc is invalid or already selected
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( doc == document || doc.nodeType !== 9 || !doc.documentElement ) {
		return document;
	}

	// Update global variables
	document = doc;
	docElem = document.documentElement;
	documentIsHTML = !isXML( document );

	// Support: IE 9 - 11+, Edge 12 - 18+
	// Accessing iframe documents after unload throws "permission denied" errors (jQuery #13936)
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( preferredDoc != document &&
		( subWindow = document.defaultView ) && subWindow.top !== subWindow ) {

		// Support: IE 11, Edge
		if ( subWindow.addEventListener ) {
			subWindow.addEventListener( "unload", unloadHandler, false );

		// Support: IE 9 - 10 only
		} else if ( subWindow.attachEvent ) {
			subWindow.attachEvent( "onunload", unloadHandler );
		}
	}

	// Support: IE 8 - 11+, Edge 12 - 18+, Chrome <=16 - 25 only, Firefox <=3.6 - 31 only,
	// Safari 4 - 5 only, Opera <=11.6 - 12.x only
	// IE/Edge & older browsers don't support the :scope pseudo-class.
	// Support: Safari 6.0 only
	// Safari 6.0 supports :scope but it's an alias of :root there.
	support.scope = assert( function( el ) {
		docElem.appendChild( el ).appendChild( document.createElement( "div" ) );
		return typeof el.querySelectorAll !== "undefined" &&
			!el.querySelectorAll( ":scope fieldset div" ).length;
	} );

	/* Attributes
	---------------------------------------------------------------------- */

	// Support: IE<8
	// Verify that getAttribute really returns attributes and not properties
	// (excepting IE8 booleans)
	support.attributes = assert( function( el ) {
		el.className = "i";
		return !el.getAttribute( "className" );
	} );

	/* getElement(s)By*
	---------------------------------------------------------------------- */

	// Check if getElementsByTagName("*") returns only elements
	support.getElementsByTagName = assert( function( el ) {
		el.appendChild( document.createComment( "" ) );
		return !el.getElementsByTagName( "*" ).length;
	} );

	// Support: IE<9
	support.getElementsByClassName = rnative.test( document.getElementsByClassName );

	// Support: IE<10
	// Check if getElementById returns elements by name
	// The broken getElementById methods don't pick up programmatically-set names,
	// so use a roundabout getElementsByName test
	support.getById = assert( function( el ) {
		docElem.appendChild( el ).id = expando;
		return !document.getElementsByName || !document.getElementsByName( expando ).length;
	} );

	// ID filter and find
	if ( support.getById ) {
		Expr.filter[ "ID" ] = function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				return elem.getAttribute( "id" ) === attrId;
			};
		};
		Expr.find[ "ID" ] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var elem = context.getElementById( id );
				return elem ? [ elem ] : [];
			}
		};
	} else {
		Expr.filter[ "ID" ] =  function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				var node = typeof elem.getAttributeNode !== "undefined" &&
					elem.getAttributeNode( "id" );
				return node && node.value === attrId;
			};
		};

		// Support: IE 6 - 7 only
		// getElementById is not reliable as a find shortcut
		Expr.find[ "ID" ] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var node, i, elems,
					elem = context.getElementById( id );

				if ( elem ) {

					// Verify the id attribute
					node = elem.getAttributeNode( "id" );
					if ( node && node.value === id ) {
						return [ elem ];
					}

					// Fall back on getElementsByName
					elems = context.getElementsByName( id );
					i = 0;
					while ( ( elem = elems[ i++ ] ) ) {
						node = elem.getAttributeNode( "id" );
						if ( node && node.value === id ) {
							return [ elem ];
						}
					}
				}

				return [];
			}
		};
	}

	// Tag
	Expr.find[ "TAG" ] = support.getElementsByTagName ?
		function( tag, context ) {
			if ( typeof context.getElementsByTagName !== "undefined" ) {
				return context.getElementsByTagName( tag );

			// DocumentFragment nodes don't have gEBTN
			} else if ( support.qsa ) {
				return context.querySelectorAll( tag );
			}
		} :

		function( tag, context ) {
			var elem,
				tmp = [],
				i = 0,

				// By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too
				results = context.getElementsByTagName( tag );

			// Filter out possible comments
			if ( tag === "*" ) {
				while ( ( elem = results[ i++ ] ) ) {
					if ( elem.nodeType === 1 ) {
						tmp.push( elem );
					}
				}

				return tmp;
			}
			return results;
		};

	// Class
	Expr.find[ "CLASS" ] = support.getElementsByClassName && function( className, context ) {
		if ( typeof context.getElementsByClassName !== "undefined" && documentIsHTML ) {
			return context.getElementsByClassName( className );
		}
	};

	/* QSA/matchesSelector
	---------------------------------------------------------------------- */

	// QSA and matchesSelector support

	// matchesSelector(:active) reports false when true (IE9/Opera 11.5)
	rbuggyMatches = [];

	// qSa(:focus) reports false when true (Chrome 21)
	// We allow this because of a bug in IE8/9 that throws an error
	// whenever `document.activeElement` is accessed on an iframe
	// So, we allow :focus to pass through QSA all the time to avoid the IE error
	// See https://bugs.jquery.com/ticket/13378
	rbuggyQSA = [];

	if ( ( support.qsa = rnative.test( document.querySelectorAll ) ) ) {

		// Build QSA regex
		// Regex strategy adopted from Diego Perini
		assert( function( el ) {

			var input;

			// Select is set to empty string on purpose
			// This is to test IE's treatment of not explicitly
			// setting a boolean content attribute,
			// since its presence should be enough
			// https://bugs.jquery.com/ticket/12359
			docElem.appendChild( el ).innerHTML = "<a id='" + expando + "'></a>" +
				"<select id='" + expando + "-\r\\' msallowcapture=''>" +
				"<option selected=''></option></select>";

			// Support: IE8, Opera 11-12.16
			// Nothing should be selected when empty strings follow ^= or $= or *=
			// The test attribute must be unknown in Opera but "safe" for WinRT
			// https://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section
			if ( el.querySelectorAll( "[msallowcapture^='']" ).length ) {
				rbuggyQSA.push( "[*^$]=" + whitespace + "*(?:''|\"\")" );
			}

			// Support: IE8
			// Boolean attributes and "value" are not treated correctly
			if ( !el.querySelectorAll( "[selected]" ).length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*(?:value|" + booleans + ")" );
			}

			// Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+
			if ( !el.querySelectorAll( "[id~=" + expando + "-]" ).length ) {
				rbuggyQSA.push( "~=" );
			}

			// Support: IE 11+, Edge 15 - 18+
			// IE 11/Edge don't find elements on a `[name='']` query in some cases.
			// Adding a temporary attribute to the document before the selection works
			// around the issue.
			// Interestingly, IE 10 & older don't seem to have the issue.
			input = document.createElement( "input" );
			input.setAttribute( "name", "" );
			el.appendChild( input );
			if ( !el.querySelectorAll( "[name='']" ).length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*name" + whitespace + "*=" +
					whitespace + "*(?:''|\"\")" );
			}

			// Webkit/Opera - :checked should return selected option elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			// IE8 throws error here and will not see later tests
			if ( !el.querySelectorAll( ":checked" ).length ) {
				rbuggyQSA.push( ":checked" );
			}

			// Support: Safari 8+, iOS 8+
			// https://bugs.webkit.org/show_bug.cgi?id=136851
			// In-page `selector#id sibling-combinator selector` fails
			if ( !el.querySelectorAll( "a#" + expando + "+*" ).length ) {
				rbuggyQSA.push( ".#.+[+~]" );
			}

			// Support: Firefox <=3.6 - 5 only
			// Old Firefox doesn't throw on a badly-escaped identifier.
			el.querySelectorAll( "\\\f" );
			rbuggyQSA.push( "[\\r\\n\\f]" );
		} );

		assert( function( el ) {
			el.innerHTML = "<a href='' disabled='disabled'></a>" +
				"<select disabled='disabled'><option/></select>";

			// Support: Windows 8 Native Apps
			// The type and name attributes are restricted during .innerHTML assignment
			var input = document.createElement( "input" );
			input.setAttribute( "type", "hidden" );
			el.appendChild( input ).setAttribute( "name", "D" );

			// Support: IE8
			// Enforce case-sensitivity of name attribute
			if ( el.querySelectorAll( "[name=d]" ).length ) {
				rbuggyQSA.push( "name" + whitespace + "*[*^$|!~]?=" );
			}

			// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
			// IE8 throws error here and will not see later tests
			if ( el.querySelectorAll( ":enabled" ).length !== 2 ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Support: IE9-11+
			// IE's :disabled selector does not pick up the children of disabled fieldsets
			docElem.appendChild( el ).disabled = true;
			if ( el.querySelectorAll( ":disabled" ).length !== 2 ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Support: Opera 10 - 11 only
			// Opera 10-11 does not throw on post-comma invalid pseudos
			el.querySelectorAll( "*,:x" );
			rbuggyQSA.push( ",.*:" );
		} );
	}

	if ( ( support.matchesSelector = rnative.test( ( matches = docElem.matches ||
		docElem.webkitMatchesSelector ||
		docElem.mozMatchesSelector ||
		docElem.oMatchesSelector ||
		docElem.msMatchesSelector ) ) ) ) {

		assert( function( el ) {

			// Check to see if it's possible to do matchesSelector
			// on a disconnected node (IE 9)
			support.disconnectedMatch = matches.call( el, "*" );

			// This should fail with an exception
			// Gecko does not error, returns false instead
			matches.call( el, "[s!='']:x" );
			rbuggyMatches.push( "!=", pseudos );
		} );
	}

	rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join( "|" ) );
	rbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join( "|" ) );

	/* Contains
	---------------------------------------------------------------------- */
	hasCompare = rnative.test( docElem.compareDocumentPosition );

	// Element contains another
	// Purposefully self-exclusive
	// As in, an element does not contain itself
	contains = hasCompare || rnative.test( docElem.contains ) ?
		function( a, b ) {
			var adown = a.nodeType === 9 ? a.documentElement : a,
				bup = b && b.parentNode;
			return a === bup || !!( bup && bup.nodeType === 1 && (
				adown.contains ?
					adown.contains( bup ) :
					a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16
			) );
		} :
		function( a, b ) {
			if ( b ) {
				while ( ( b = b.parentNode ) ) {
					if ( b === a ) {
						return true;
					}
				}
			}
			return false;
		};

	/* Sorting
	---------------------------------------------------------------------- */

	// Document order sorting
	sortOrder = hasCompare ?
	function( a, b ) {

		// Flag for duplicate removal
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		// Sort on method existence if only one input has compareDocumentPosition
		var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
		if ( compare ) {
			return compare;
		}

		// Calculate position if both inputs belong to the same document
		// Support: IE 11+, Edge 17 - 18+
		// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
		// two documents; shallow comparisons work.
		// eslint-disable-next-line eqeqeq
		compare = ( a.ownerDocument || a ) == ( b.ownerDocument || b ) ?
			a.compareDocumentPosition( b ) :

			// Otherwise we know they are disconnected
			1;

		// Disconnected nodes
		if ( compare & 1 ||
			( !support.sortDetached && b.compareDocumentPosition( a ) === compare ) ) {

			// Choose the first element that is related to our preferred document
			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			// eslint-disable-next-line eqeqeq
			if ( a == document || a.ownerDocument == preferredDoc &&
				contains( preferredDoc, a ) ) {
				return -1;
			}

			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			// eslint-disable-next-line eqeqeq
			if ( b == document || b.ownerDocument == preferredDoc &&
				contains( preferredDoc, b ) ) {
				return 1;
			}

			// Maintain original order
			return sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;
		}

		return compare & 4 ? -1 : 1;
	} :
	function( a, b ) {

		// Exit early if the nodes are identical
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		var cur,
			i = 0,
			aup = a.parentNode,
			bup = b.parentNode,
			ap = [ a ],
			bp = [ b ];

		// Parentless nodes are either documents or disconnected
		if ( !aup || !bup ) {

			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			/* eslint-disable eqeqeq */
			return a == document ? -1 :
				b == document ? 1 :
				/* eslint-enable eqeqeq */
				aup ? -1 :
				bup ? 1 :
				sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;

		// If the nodes are siblings, we can do a quick check
		} else if ( aup === bup ) {
			return siblingCheck( a, b );
		}

		// Otherwise we need full lists of their ancestors for comparison
		cur = a;
		while ( ( cur = cur.parentNode ) ) {
			ap.unshift( cur );
		}
		cur = b;
		while ( ( cur = cur.parentNode ) ) {
			bp.unshift( cur );
		}

		// Walk down the tree looking for a discrepancy
		while ( ap[ i ] === bp[ i ] ) {
			i++;
		}

		return i ?

			// Do a sibling check if the nodes have a common ancestor
			siblingCheck( ap[ i ], bp[ i ] ) :

			// Otherwise nodes in our document sort first
			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			/* eslint-disable eqeqeq */
			ap[ i ] == preferredDoc ? -1 :
			bp[ i ] == preferredDoc ? 1 :
			/* eslint-enable eqeqeq */
			0;
	};

	return document;
};

Sizzle.matches = function( expr, elements ) {
	return Sizzle( expr, null, null, elements );
};

Sizzle.matchesSelector = function( elem, expr ) {
	setDocument( elem );

	if ( support.matchesSelector && documentIsHTML &&
		!nonnativeSelectorCache[ expr + " " ] &&
		( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&
		( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {

		try {
			var ret = matches.call( elem, expr );

			// IE 9's matchesSelector returns false on disconnected nodes
			if ( ret || support.disconnectedMatch ||

				// As well, disconnected nodes are said to be in a document
				// fragment in IE 9
				elem.document && elem.document.nodeType !== 11 ) {
				return ret;
			}
		} catch ( e ) {
			nonnativeSelectorCache( expr, true );
		}
	}

	return Sizzle( expr, document, null, [ elem ] ).length > 0;
};

Sizzle.contains = function( context, elem ) {

	// Set document vars if needed
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( ( context.ownerDocument || context ) != document ) {
		setDocument( context );
	}
	return contains( context, elem );
};

Sizzle.attr = function( elem, name ) {

	// Set document vars if needed
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( ( elem.ownerDocument || elem ) != document ) {
		setDocument( elem );
	}

	var fn = Expr.attrHandle[ name.toLowerCase() ],

		// Don't get fooled by Object.prototype properties (jQuery #13807)
		val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?
			fn( elem, name, !documentIsHTML ) :
			undefined;

	return val !== undefined ?
		val :
		support.attributes || !documentIsHTML ?
			elem.getAttribute( name ) :
			( val = elem.getAttributeNode( name ) ) && val.specified ?
				val.value :
				null;
};

Sizzle.escape = function( sel ) {
	return ( sel + "" ).replace( rcssescape, fcssescape );
};

Sizzle.error = function( msg ) {
	throw new Error( "Syntax error, unrecognized expression: " + msg );
};

/**
 * Document sorting and removing duplicates
 * @param {ArrayLike} results
 */
Sizzle.uniqueSort = function( results ) {
	var elem,
		duplicates = [],
		j = 0,
		i = 0;

	// Unless we *know* we can detect duplicates, assume their presence
	hasDuplicate = !support.detectDuplicates;
	sortInput = !support.sortStable && results.slice( 0 );
	results.sort( sortOrder );

	if ( hasDuplicate ) {
		while ( ( elem = results[ i++ ] ) ) {
			if ( elem === results[ i ] ) {
				j = duplicates.push( i );
			}
		}
		while ( j-- ) {
			results.splice( duplicates[ j ], 1 );
		}
	}

	// Clear input after sorting to release objects
	// See https://github.com/jquery/sizzle/pull/225
	sortInput = null;

	return results;
};

/**
 * Utility function for retrieving the text value of an array of DOM nodes
 * @param {Array|Element} elem
 */
getText = Sizzle.getText = function( elem ) {
	var node,
		ret = "",
		i = 0,
		nodeType = elem.nodeType;

	if ( !nodeType ) {

		// If no nodeType, this is expected to be an array
		while ( ( node = elem[ i++ ] ) ) {

			// Do not traverse comment nodes
			ret += getText( node );
		}
	} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {

		// Use textContent for elements
		// innerText usage removed for consistency of new lines (jQuery #11153)
		if ( typeof elem.textContent === "string" ) {
			return elem.textContent;
		} else {

			// Traverse its children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				ret += getText( elem );
			}
		}
	} else if ( nodeType === 3 || nodeType === 4 ) {
		return elem.nodeValue;
	}

	// Do not include comment or processing instruction nodes

	return ret;
};

Expr = Sizzle.selectors = {

	// Can be adjusted by the user
	cacheLength: 50,

	createPseudo: markFunction,

	match: matchExpr,

	attrHandle: {},

	find: {},

	relative: {
		">": { dir: "parentNode", first: true },
		" ": { dir: "parentNode" },
		"+": { dir: "previousSibling", first: true },
		"~": { dir: "previousSibling" }
	},

	preFilter: {
		"ATTR": function( match ) {
			match[ 1 ] = match[ 1 ].replace( runescape, funescape );

			// Move the given value to match[3] whether quoted or unquoted
			match[ 3 ] = ( match[ 3 ] || match[ 4 ] ||
				match[ 5 ] || "" ).replace( runescape, funescape );

			if ( match[ 2 ] === "~=" ) {
				match[ 3 ] = " " + match[ 3 ] + " ";
			}

			return match.slice( 0, 4 );
		},

		"CHILD": function( match ) {

			/* matches from matchExpr["CHILD"]
				1 type (only|nth|...)
				2 what (child|of-type)
				3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
				4 xn-component of xn+y argument ([+-]?\d*n|)
				5 sign of xn-component
				6 x of xn-component
				7 sign of y-component
				8 y of y-component
			*/
			match[ 1 ] = match[ 1 ].toLowerCase();

			if ( match[ 1 ].slice( 0, 3 ) === "nth" ) {

				// nth-* requires argument
				if ( !match[ 3 ] ) {
					Sizzle.error( match[ 0 ] );
				}

				// numeric x and y parameters for Expr.filter.CHILD
				// remember that false/true cast respectively to 0/1
				match[ 4 ] = +( match[ 4 ] ?
					match[ 5 ] + ( match[ 6 ] || 1 ) :
					2 * ( match[ 3 ] === "even" || match[ 3 ] === "odd" ) );
				match[ 5 ] = +( ( match[ 7 ] + match[ 8 ] ) || match[ 3 ] === "odd" );

				// other types prohibit arguments
			} else if ( match[ 3 ] ) {
				Sizzle.error( match[ 0 ] );
			}

			return match;
		},

		"PSEUDO": function( match ) {
			var excess,
				unquoted = !match[ 6 ] && match[ 2 ];

			if ( matchExpr[ "CHILD" ].test( match[ 0 ] ) ) {
				return null;
			}

			// Accept quoted arguments as-is
			if ( match[ 3 ] ) {
				match[ 2 ] = match[ 4 ] || match[ 5 ] || "";

			// Strip excess characters from unquoted arguments
			} else if ( unquoted && rpseudo.test( unquoted ) &&

				// Get excess from tokenize (recursively)
				( excess = tokenize( unquoted, true ) ) &&

				// advance to the next closing parenthesis
				( excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length ) ) {

				// excess is a negative index
				match[ 0 ] = match[ 0 ].slice( 0, excess );
				match[ 2 ] = unquoted.slice( 0, excess );
			}

			// Return only captures needed by the pseudo filter method (type and argument)
			return match.slice( 0, 3 );
		}
	},

	filter: {

		"TAG": function( nodeNameSelector ) {
			var nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();
			return nodeNameSelector === "*" ?
				function() {
					return true;
				} :
				function( elem ) {
					return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
				};
		},

		"CLASS": function( className ) {
			var pattern = classCache[ className + " " ];

			return pattern ||
				( pattern = new RegExp( "(^|" + whitespace +
					")" + className + "(" + whitespace + "|$)" ) ) && classCache(
						className, function( elem ) {
							return pattern.test(
								typeof elem.className === "string" && elem.className ||
								typeof elem.getAttribute !== "undefined" &&
									elem.getAttribute( "class" ) ||
								""
							);
				} );
		},

		"ATTR": function( name, operator, check ) {
			return function( elem ) {
				var result = Sizzle.attr( elem, name );

				if ( result == null ) {
					return operator === "!=";
				}
				if ( !operator ) {
					return true;
				}

				result += "";

				/* eslint-disable max-len */

				return operator === "=" ? result === check :
					operator === "!=" ? result !== check :
					operator === "^=" ? check && result.indexOf( check ) === 0 :
					operator === "*=" ? check && result.indexOf( check ) > -1 :
					operator === "$=" ? check && result.slice( -check.length ) === check :
					operator === "~=" ? ( " " + result.replace( rwhitespace, " " ) + " " ).indexOf( check ) > -1 :
					operator === "|=" ? result === check || result.slice( 0, check.length + 1 ) === check + "-" :
					false;
				/* eslint-enable max-len */

			};
		},

		"CHILD": function( type, what, _argument, first, last ) {
			var simple = type.slice( 0, 3 ) !== "nth",
				forward = type.slice( -4 ) !== "last",
				ofType = what === "of-type";

			return first === 1 && last === 0 ?

				// Shortcut for :nth-*(n)
				function( elem ) {
					return !!elem.parentNode;
				} :

				function( elem, _context, xml ) {
					var cache, uniqueCache, outerCache, node, nodeIndex, start,
						dir = simple !== forward ? "nextSibling" : "previousSibling",
						parent = elem.parentNode,
						name = ofType && elem.nodeName.toLowerCase(),
						useCache = !xml && !ofType,
						diff = false;

					if ( parent ) {

						// :(first|last|only)-(child|of-type)
						if ( simple ) {
							while ( dir ) {
								node = elem;
								while ( ( node = node[ dir ] ) ) {
									if ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) {

										return false;
									}
								}

								// Reverse direction for :only-* (if we haven't yet done so)
								start = dir = type === "only" && !start && "nextSibling";
							}
							return true;
						}

						start = [ forward ? parent.firstChild : parent.lastChild ];

						// non-xml :nth-child(...) stores cache data on `parent`
						if ( forward && useCache ) {

							// Seek `elem` from a previously-cached index

							// ...in a gzip-friendly way
							node = parent;
							outerCache = node[ expando ] || ( node[ expando ] = {} );

							// Support: IE <9 only
							// Defend against cloned attroperties (jQuery gh-1709)
							uniqueCache = outerCache[ node.uniqueID ] ||
								( outerCache[ node.uniqueID ] = {} );

							cache = uniqueCache[ type ] || [];
							nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
							diff = nodeIndex && cache[ 2 ];
							node = nodeIndex && parent.childNodes[ nodeIndex ];

							while ( ( node = ++nodeIndex && node && node[ dir ] ||

								// Fallback to seeking `elem` from the start
								( diff = nodeIndex = 0 ) || start.pop() ) ) {

								// When found, cache indexes on `parent` and break
								if ( node.nodeType === 1 && ++diff && node === elem ) {
									uniqueCache[ type ] = [ dirruns, nodeIndex, diff ];
									break;
								}
							}

						} else {

							// Use previously-cached element index if available
							if ( useCache ) {

								// ...in a gzip-friendly way
								node = elem;
								outerCache = node[ expando ] || ( node[ expando ] = {} );

								// Support: IE <9 only
								// Defend against cloned attroperties (jQuery gh-1709)
								uniqueCache = outerCache[ node.uniqueID ] ||
									( outerCache[ node.uniqueID ] = {} );

								cache = uniqueCache[ type ] || [];
								nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
								diff = nodeIndex;
							}

							// xml :nth-child(...)
							// or :nth-last-child(...) or :nth(-last)?-of-type(...)
							if ( diff === false ) {

								// Use the same loop as above to seek `elem` from the start
								while ( ( node = ++nodeIndex && node && node[ dir ] ||
									( diff = nodeIndex = 0 ) || start.pop() ) ) {

									if ( ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) &&
										++diff ) {

										// Cache the index of each encountered element
										if ( useCache ) {
											outerCache = node[ expando ] ||
												( node[ expando ] = {} );

											// Support: IE <9 only
											// Defend against cloned attroperties (jQuery gh-1709)
											uniqueCache = outerCache[ node.uniqueID ] ||
												( outerCache[ node.uniqueID ] = {} );

											uniqueCache[ type ] = [ dirruns, diff ];
										}

										if ( node === elem ) {
											break;
										}
									}
								}
							}
						}

						// Incorporate the offset, then check against cycle size
						diff -= last;
						return diff === first || ( diff % first === 0 && diff / first >= 0 );
					}
				};
		},

		"PSEUDO": function( pseudo, argument ) {

			// pseudo-class names are case-insensitive
			// http://www.w3.org/TR/selectors/#pseudo-classes
			// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
			// Remember that setFilters inherits from pseudos
			var args,
				fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||
					Sizzle.error( "unsupported pseudo: " + pseudo );

			// The user may use createPseudo to indicate that
			// arguments are needed to create the filter function
			// just as Sizzle does
			if ( fn[ expando ] ) {
				return fn( argument );
			}

			// But maintain support for old signatures
			if ( fn.length > 1 ) {
				args = [ pseudo, pseudo, "", argument ];
				return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?
					markFunction( function( seed, matches ) {
						var idx,
							matched = fn( seed, argument ),
							i = matched.length;
						while ( i-- ) {
							idx = indexOf( seed, matched[ i ] );
							seed[ idx ] = !( matches[ idx ] = matched[ i ] );
						}
					} ) :
					function( elem ) {
						return fn( elem, 0, args );
					};
			}

			return fn;
		}
	},

	pseudos: {

		// Potentially complex pseudos
		"not": markFunction( function( selector ) {

			// Trim the selector passed to compile
			// to avoid treating leading and trailing
			// spaces as combinators
			var input = [],
				results = [],
				matcher = compile( selector.replace( rtrim, "$1" ) );

			return matcher[ expando ] ?
				markFunction( function( seed, matches, _context, xml ) {
					var elem,
						unmatched = matcher( seed, null, xml, [] ),
						i = seed.length;

					// Match elements unmatched by `matcher`
					while ( i-- ) {
						if ( ( elem = unmatched[ i ] ) ) {
							seed[ i ] = !( matches[ i ] = elem );
						}
					}
				} ) :
				function( elem, _context, xml ) {
					input[ 0 ] = elem;
					matcher( input, null, xml, results );

					// Don't keep the element (issue #299)
					input[ 0 ] = null;
					return !results.pop();
				};
		} ),

		"has": markFunction( function( selector ) {
			return function( elem ) {
				return Sizzle( selector, elem ).length > 0;
			};
		} ),

		"contains": markFunction( function( text ) {
			text = text.replace( runescape, funescape );
			return function( elem ) {
				return ( elem.textContent || getText( elem ) ).indexOf( text ) > -1;
			};
		} ),

		// "Whether an element is represented by a :lang() selector
		// is based solely on the element's language value
		// being equal to the identifier C,
		// or beginning with the identifier C immediately followed by "-".
		// The matching of C against the element's language value is performed case-insensitively.
		// The identifier C does not have to be a valid language name."
		// http://www.w3.org/TR/selectors/#lang-pseudo
		"lang": markFunction( function( lang ) {

			// lang value must be a valid identifier
			if ( !ridentifier.test( lang || "" ) ) {
				Sizzle.error( "unsupported lang: " + lang );
			}
			lang = lang.replace( runescape, funescape ).toLowerCase();
			return function( elem ) {
				var elemLang;
				do {
					if ( ( elemLang = documentIsHTML ?
						elem.lang :
						elem.getAttribute( "xml:lang" ) || elem.getAttribute( "lang" ) ) ) {

						elemLang = elemLang.toLowerCase();
						return elemLang === lang || elemLang.indexOf( lang + "-" ) === 0;
					}
				} while ( ( elem = elem.parentNode ) && elem.nodeType === 1 );
				return false;
			};
		} ),

		// Miscellaneous
		"target": function( elem ) {
			var hash = window.location && window.location.hash;
			return hash && hash.slice( 1 ) === elem.id;
		},

		"root": function( elem ) {
			return elem === docElem;
		},

		"focus": function( elem ) {
			return elem === document.activeElement &&
				( !document.hasFocus || document.hasFocus() ) &&
				!!( elem.type || elem.href || ~elem.tabIndex );
		},

		// Boolean properties
		"enabled": createDisabledPseudo( false ),
		"disabled": createDisabledPseudo( true ),

		"checked": function( elem ) {

			// In CSS3, :checked should return both checked and selected elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			var nodeName = elem.nodeName.toLowerCase();
			return ( nodeName === "input" && !!elem.checked ) ||
				( nodeName === "option" && !!elem.selected );
		},

		"selected": function( elem ) {

			// Accessing this property makes selected-by-default
			// options in Safari work properly
			if ( elem.parentNode ) {
				// eslint-disable-next-line no-unused-expressions
				elem.parentNode.selectedIndex;
			}

			return elem.selected === true;
		},

		// Contents
		"empty": function( elem ) {

			// http://www.w3.org/TR/selectors/#empty-pseudo
			// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
			//   but not by others (comment: 8; processing instruction: 7; etc.)
			// nodeType < 6 works because attributes (2) do not appear as children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				if ( elem.nodeType < 6 ) {
					return false;
				}
			}
			return true;
		},

		"parent": function( elem ) {
			return !Expr.pseudos[ "empty" ]( elem );
		},

		// Element/input types
		"header": function( elem ) {
			return rheader.test( elem.nodeName );
		},

		"input": function( elem ) {
			return rinputs.test( elem.nodeName );
		},

		"button": function( elem ) {
			var name = elem.nodeName.toLowerCase();
			return name === "input" && elem.type === "button" || name === "button";
		},

		"text": function( elem ) {
			var attr;
			return elem.nodeName.toLowerCase() === "input" &&
				elem.type === "text" &&

				// Support: IE<8
				// New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
				( ( attr = elem.getAttribute( "type" ) ) == null ||
					attr.toLowerCase() === "text" );
		},

		// Position-in-collection
		"first": createPositionalPseudo( function() {
			return [ 0 ];
		} ),

		"last": createPositionalPseudo( function( _matchIndexes, length ) {
			return [ length - 1 ];
		} ),

		"eq": createPositionalPseudo( function( _matchIndexes, length, argument ) {
			return [ argument < 0 ? argument + length : argument ];
		} ),

		"even": createPositionalPseudo( function( matchIndexes, length ) {
			var i = 0;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		"odd": createPositionalPseudo( function( matchIndexes, length ) {
			var i = 1;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		"lt": createPositionalPseudo( function( matchIndexes, length, argument ) {
			var i = argument < 0 ?
				argument + length :
				argument > length ?
					length :
					argument;
			for ( ; --i >= 0; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		"gt": createPositionalPseudo( function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; ++i < length; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} )
	}
};

Expr.pseudos[ "nth" ] = Expr.pseudos[ "eq" ];

// Add button/input type pseudos
for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {
	Expr.pseudos[ i ] = createInputPseudo( i );
}
for ( i in { submit: true, reset: true } ) {
	Expr.pseudos[ i ] = createButtonPseudo( i );
}

// Easy API for creating new setFilters
function setFilters() {}
setFilters.prototype = Expr.filters = Expr.pseudos;
Expr.setFilters = new setFilters();

tokenize = Sizzle.tokenize = function( selector, parseOnly ) {
	var matched, match, tokens, type,
		soFar, groups, preFilters,
		cached = tokenCache[ selector + " " ];

	if ( cached ) {
		return parseOnly ? 0 : cached.slice( 0 );
	}

	soFar = selector;
	groups = [];
	preFilters = Expr.preFilter;

	while ( soFar ) {

		// Comma and first run
		if ( !matched || ( match = rcomma.exec( soFar ) ) ) {
			if ( match ) {

				// Don't consume trailing commas as valid
				soFar = soFar.slice( match[ 0 ].length ) || soFar;
			}
			groups.push( ( tokens = [] ) );
		}

		matched = false;

		// Combinators
		if ( ( match = rcombinators.exec( soFar ) ) ) {
			matched = match.shift();
			tokens.push( {
				value: matched,

				// Cast descendant combinators to space
				type: match[ 0 ].replace( rtrim, " " )
			} );
			soFar = soFar.slice( matched.length );
		}

		// Filters
		for ( type in Expr.filter ) {
			if ( ( match = matchExpr[ type ].exec( soFar ) ) && ( !preFilters[ type ] ||
				( match = preFilters[ type ]( match ) ) ) ) {
				matched = match.shift();
				tokens.push( {
					value: matched,
					type: type,
					matches: match
				} );
				soFar = soFar.slice( matched.length );
			}
		}

		if ( !matched ) {
			break;
		}
	}

	// Return the length of the invalid excess
	// if we're just parsing
	// Otherwise, throw an error or return tokens
	return parseOnly ?
		soFar.length :
		soFar ?
			Sizzle.error( selector ) :

			// Cache the tokens
			tokenCache( selector, groups ).slice( 0 );
};

function toSelector( tokens ) {
	var i = 0,
		len = tokens.length,
		selector = "";
	for ( ; i < len; i++ ) {
		selector += tokens[ i ].value;
	}
	return selector;
}

function addCombinator( matcher, combinator, base ) {
	var dir = combinator.dir,
		skip = combinator.next,
		key = skip || dir,
		checkNonElements = base && key === "parentNode",
		doneName = done++;

	return combinator.first ?

		// Check against closest ancestor/preceding element
		function( elem, context, xml ) {
			while ( ( elem = elem[ dir ] ) ) {
				if ( elem.nodeType === 1 || checkNonElements ) {
					return matcher( elem, context, xml );
				}
			}
			return false;
		} :

		// Check against all ancestor/preceding elements
		function( elem, context, xml ) {
			var oldCache, uniqueCache, outerCache,
				newCache = [ dirruns, doneName ];

			// We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching
			if ( xml ) {
				while ( ( elem = elem[ dir ] ) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						if ( matcher( elem, context, xml ) ) {
							return true;
						}
					}
				}
			} else {
				while ( ( elem = elem[ dir ] ) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						outerCache = elem[ expando ] || ( elem[ expando ] = {} );

						// Support: IE <9 only
						// Defend against cloned attroperties (jQuery gh-1709)
						uniqueCache = outerCache[ elem.uniqueID ] ||
							( outerCache[ elem.uniqueID ] = {} );

						if ( skip && skip === elem.nodeName.toLowerCase() ) {
							elem = elem[ dir ] || elem;
						} else if ( ( oldCache = uniqueCache[ key ] ) &&
							oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {

							// Assign to newCache so results back-propagate to previous elements
							return ( newCache[ 2 ] = oldCache[ 2 ] );
						} else {

							// Reuse newcache so results back-propagate to previous elements
							uniqueCache[ key ] = newCache;

							// A match means we're done; a fail means we have to keep checking
							if ( ( newCache[ 2 ] = matcher( elem, context, xml ) ) ) {
								return true;
							}
						}
					}
				}
			}
			return false;
		};
}

function elementMatcher( matchers ) {
	return matchers.length > 1 ?
		function( elem, context, xml ) {
			var i = matchers.length;
			while ( i-- ) {
				if ( !matchers[ i ]( elem, context, xml ) ) {
					return false;
				}
			}
			return true;
		} :
		matchers[ 0 ];
}

function multipleContexts( selector, contexts, results ) {
	var i = 0,
		len = contexts.length;
	for ( ; i < len; i++ ) {
		Sizzle( selector, contexts[ i ], results );
	}
	return results;
}

function condense( unmatched, map, filter, context, xml ) {
	var elem,
		newUnmatched = [],
		i = 0,
		len = unmatched.length,
		mapped = map != null;

	for ( ; i < len; i++ ) {
		if ( ( elem = unmatched[ i ] ) ) {
			if ( !filter || filter( elem, context, xml ) ) {
				newUnmatched.push( elem );
				if ( mapped ) {
					map.push( i );
				}
			}
		}
	}

	return newUnmatched;
}

function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {
	if ( postFilter && !postFilter[ expando ] ) {
		postFilter = setMatcher( postFilter );
	}
	if ( postFinder && !postFinder[ expando ] ) {
		postFinder = setMatcher( postFinder, postSelector );
	}
	return markFunction( function( seed, results, context, xml ) {
		var temp, i, elem,
			preMap = [],
			postMap = [],
			preexisting = results.length,

			// Get initial elements from seed or context
			elems = seed || multipleContexts(
				selector || "*",
				context.nodeType ? [ context ] : context,
				[]
			),

			// Prefilter to get matcher input, preserving a map for seed-results synchronization
			matcherIn = preFilter && ( seed || !selector ) ?
				condense( elems, preMap, preFilter, context, xml ) :
				elems,

			matcherOut = matcher ?

				// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
				postFinder || ( seed ? preFilter : preexisting || postFilter ) ?

					// ...intermediate processing is necessary
					[] :

					// ...otherwise use results directly
					results :
				matcherIn;

		// Find primary matches
		if ( matcher ) {
			matcher( matcherIn, matcherOut, context, xml );
		}

		// Apply postFilter
		if ( postFilter ) {
			temp = condense( matcherOut, postMap );
			postFilter( temp, [], context, xml );

			// Un-match failing elements by moving them back to matcherIn
			i = temp.length;
			while ( i-- ) {
				if ( ( elem = temp[ i ] ) ) {
					matcherOut[ postMap[ i ] ] = !( matcherIn[ postMap[ i ] ] = elem );
				}
			}
		}

		if ( seed ) {
			if ( postFinder || preFilter ) {
				if ( postFinder ) {

					// Get the final matcherOut by condensing this intermediate into postFinder contexts
					temp = [];
					i = matcherOut.length;
					while ( i-- ) {
						if ( ( elem = matcherOut[ i ] ) ) {

							// Restore matcherIn since elem is not yet a final match
							temp.push( ( matcherIn[ i ] = elem ) );
						}
					}
					postFinder( null, ( matcherOut = [] ), temp, xml );
				}

				// Move matched elements from seed to results to keep them synchronized
				i = matcherOut.length;
				while ( i-- ) {
					if ( ( elem = matcherOut[ i ] ) &&
						( temp = postFinder ? indexOf( seed, elem ) : preMap[ i ] ) > -1 ) {

						seed[ temp ] = !( results[ temp ] = elem );
					}
				}
			}

		// Add elements to results, through postFinder if defined
		} else {
			matcherOut = condense(
				matcherOut === results ?
					matcherOut.splice( preexisting, matcherOut.length ) :
					matcherOut
			);
			if ( postFinder ) {
				postFinder( null, results, matcherOut, xml );
			} else {
				push.apply( results, matcherOut );
			}
		}
	} );
}

function matcherFromTokens( tokens ) {
	var checkContext, matcher, j,
		len = tokens.length,
		leadingRelative = Expr.relative[ tokens[ 0 ].type ],
		implicitRelative = leadingRelative || Expr.relative[ " " ],
		i = leadingRelative ? 1 : 0,

		// The foundational matcher ensures that elements are reachable from top-level context(s)
		matchContext = addCombinator( function( elem ) {
			return elem === checkContext;
		}, implicitRelative, true ),
		matchAnyContext = addCombinator( function( elem ) {
			return indexOf( checkContext, elem ) > -1;
		}, implicitRelative, true ),
		matchers = [ function( elem, context, xml ) {
			var ret = ( !leadingRelative && ( xml || context !== outermostContext ) ) || (
				( checkContext = context ).nodeType ?
					matchContext( elem, context, xml ) :
					matchAnyContext( elem, context, xml ) );

			// Avoid hanging onto element (issue #299)
			checkContext = null;
			return ret;
		} ];

	for ( ; i < len; i++ ) {
		if ( ( matcher = Expr.relative[ tokens[ i ].type ] ) ) {
			matchers = [ addCombinator( elementMatcher( matchers ), matcher ) ];
		} else {
			matcher = Expr.filter[ tokens[ i ].type ].apply( null, tokens[ i ].matches );

			// Return special upon seeing a positional matcher
			if ( matcher[ expando ] ) {

				// Find the next relative operator (if any) for proper handling
				j = ++i;
				for ( ; j < len; j++ ) {
					if ( Expr.relative[ tokens[ j ].type ] ) {
						break;
					}
				}
				return setMatcher(
					i > 1 && elementMatcher( matchers ),
					i > 1 && toSelector(

					// If the preceding token was a descendant combinator, insert an implicit any-element `*`
					tokens
						.slice( 0, i - 1 )
						.concat( { value: tokens[ i - 2 ].type === " " ? "*" : "" } )
					).replace( rtrim, "$1" ),
					matcher,
					i < j && matcherFromTokens( tokens.slice( i, j ) ),
					j < len && matcherFromTokens( ( tokens = tokens.slice( j ) ) ),
					j < len && toSelector( tokens )
				);
			}
			matchers.push( matcher );
		}
	}

	return elementMatcher( matchers );
}

function matcherFromGroupMatchers( elementMatchers, setMatchers ) {
	var bySet = setMatchers.length > 0,
		byElement = elementMatchers.length > 0,
		superMatcher = function( seed, context, xml, results, outermost ) {
			var elem, j, matcher,
				matchedCount = 0,
				i = "0",
				unmatched = seed && [],
				setMatched = [],
				contextBackup = outermostContext,

				// We must always have either seed elements or outermost context
				elems = seed || byElement && Expr.find[ "TAG" ]( "*", outermost ),

				// Use integer dirruns iff this is the outermost matcher
				dirrunsUnique = ( dirruns += contextBackup == null ? 1 : Math.random() || 0.1 ),
				len = elems.length;

			if ( outermost ) {

				// Support: IE 11+, Edge 17 - 18+
				// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
				// two documents; shallow comparisons work.
				// eslint-disable-next-line eqeqeq
				outermostContext = context == document || context || outermost;
			}

			// Add elements passing elementMatchers directly to results
			// Support: IE<9, Safari
			// Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id
			for ( ; i !== len && ( elem = elems[ i ] ) != null; i++ ) {
				if ( byElement && elem ) {
					j = 0;

					// Support: IE 11+, Edge 17 - 18+
					// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
					// two documents; shallow comparisons work.
					// eslint-disable-next-line eqeqeq
					if ( !context && elem.ownerDocument != document ) {
						setDocument( elem );
						xml = !documentIsHTML;
					}
					while ( ( matcher = elementMatchers[ j++ ] ) ) {
						if ( matcher( elem, context || document, xml ) ) {
							results.push( elem );
							break;
						}
					}
					if ( outermost ) {
						dirruns = dirrunsUnique;
					}
				}

				// Track unmatched elements for set filters
				if ( bySet ) {

					// They will have gone through all possible matchers
					if ( ( elem = !matcher && elem ) ) {
						matchedCount--;
					}

					// Lengthen the array for every element, matched or not
					if ( seed ) {
						unmatched.push( elem );
					}
				}
			}

			// `i` is now the count of elements visited above, and adding it to `matchedCount`
			// makes the latter nonnegative.
			matchedCount += i;

			// Apply set filters to unmatched elements
			// NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
			// equals `i`), unless we didn't visit _any_ elements in the above loop because we have
			// no element matchers and no seed.
			// Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
			// case, which will result in a "00" `matchedCount` that differs from `i` but is also
			// numerically zero.
			if ( bySet && i !== matchedCount ) {
				j = 0;
				while ( ( matcher = setMatchers[ j++ ] ) ) {
					matcher( unmatched, setMatched, context, xml );
				}

				if ( seed ) {

					// Reintegrate element matches to eliminate the need for sorting
					if ( matchedCount > 0 ) {
						while ( i-- ) {
							if ( !( unmatched[ i ] || setMatched[ i ] ) ) {
								setMatched[ i ] = pop.call( results );
							}
						}
					}

					// Discard index placeholder values to get only actual matches
					setMatched = condense( setMatched );
				}

				// Add matches to results
				push.apply( results, setMatched );

				// Seedless set matches succeeding multiple successful matchers stipulate sorting
				if ( outermost && !seed && setMatched.length > 0 &&
					( matchedCount + setMatchers.length ) > 1 ) {

					Sizzle.uniqueSort( results );
				}
			}

			// Override manipulation of globals by nested matchers
			if ( outermost ) {
				dirruns = dirrunsUnique;
				outermostContext = contextBackup;
			}

			return unmatched;
		};

	return bySet ?
		markFunction( superMatcher ) :
		superMatcher;
}

compile = Sizzle.compile = function( selector, match /* Internal Use Only */ ) {
	var i,
		setMatchers = [],
		elementMatchers = [],
		cached = compilerCache[ selector + " " ];

	if ( !cached ) {

		// Generate a function of recursive functions that can be used to check each element
		if ( !match ) {
			match = tokenize( selector );
		}
		i = match.length;
		while ( i-- ) {
			cached = matcherFromTokens( match[ i ] );
			if ( cached[ expando ] ) {
				setMatchers.push( cached );
			} else {
				elementMatchers.push( cached );
			}
		}

		// Cache the compiled function
		cached = compilerCache(
			selector,
			matcherFromGroupMatchers( elementMatchers, setMatchers )
		);

		// Save selector and tokenization
		cached.selector = selector;
	}
	return cached;
};

/**
 * A low-level selection function that works with Sizzle's compiled
 *  selector functions
 * @param {String|Function} selector A selector or a pre-compiled
 *  selector function built with Sizzle.compile
 * @param {Element} context
 * @param {Array} [results]
 * @param {Array} [seed] A set of elements to match against
 */
select = Sizzle.select = function( selector, context, results, seed ) {
	var i, tokens, token, type, find,
		compiled = typeof selector === "function" && selector,
		match = !seed && tokenize( ( selector = compiled.selector || selector ) );

	results = results || [];

	// Try to minimize operations if there is only one selector in the list and no seed
	// (the latter of which guarantees us context)
	if ( match.length === 1 ) {

		// Reduce context if the leading compound selector is an ID
		tokens = match[ 0 ] = match[ 0 ].slice( 0 );
		if ( tokens.length > 2 && ( token = tokens[ 0 ] ).type === "ID" &&
			context.nodeType === 9 && documentIsHTML && Expr.relative[ tokens[ 1 ].type ] ) {

			context = ( Expr.find[ "ID" ]( token.matches[ 0 ]
				.replace( runescape, funescape ), context ) || [] )[ 0 ];
			if ( !context ) {
				return results;

			// Precompiled matchers will still verify ancestry, so step up a level
			} else if ( compiled ) {
				context = context.parentNode;
			}

			selector = selector.slice( tokens.shift().value.length );
		}

		// Fetch a seed set for right-to-left matching
		i = matchExpr[ "needsContext" ].test( selector ) ? 0 : tokens.length;
		while ( i-- ) {
			token = tokens[ i ];

			// Abort if we hit a combinator
			if ( Expr.relative[ ( type = token.type ) ] ) {
				break;
			}
			if ( ( find = Expr.find[ type ] ) ) {

				// Search, expanding context for leading sibling combinators
				if ( ( seed = find(
					token.matches[ 0 ].replace( runescape, funescape ),
					rsibling.test( tokens[ 0 ].type ) && testContext( context.parentNode ) ||
						context
				) ) ) {

					// If seed is empty or no tokens remain, we can return early
					tokens.splice( i, 1 );
					selector = seed.length && toSelector( tokens );
					if ( !selector ) {
						push.apply( results, seed );
						return results;
					}

					break;
				}
			}
		}
	}

	// Compile and execute a filtering function if one is not provided
	// Provide `match` to avoid retokenization if we modified the selector above
	( compiled || compile( selector, match ) )(
		seed,
		context,
		!documentIsHTML,
		results,
		!context || rsibling.test( selector ) && testContext( context.parentNode ) || context
	);
	return results;
};

// One-time assignments

// Sort stability
support.sortStable = expando.split( "" ).sort( sortOrder ).join( "" ) === expando;

// Support: Chrome 14-35+
// Always assume duplicates if they aren't passed to the comparison function
support.detectDuplicates = !!hasDuplicate;

// Initialize against the default document
setDocument();

// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)
// Detached nodes confoundingly follow *each other*
support.sortDetached = assert( function( el ) {

	// Should return 1, but returns 4 (following)
	return el.compareDocumentPosition( document.createElement( "fieldset" ) ) & 1;
} );

// Support: IE<8
// Prevent attribute/property "interpolation"
// https://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx
if ( !assert( function( el ) {
	el.innerHTML = "<a href='#'></a>";
	return el.firstChild.getAttribute( "href" ) === "#";
} ) ) {
	addHandle( "type|href|height|width", function( elem, name, isXML ) {
		if ( !isXML ) {
			return elem.getAttribute( name, name.toLowerCase() === "type" ? 1 : 2 );
		}
	} );
}

// Support: IE<9
// Use defaultValue in place of getAttribute("value")
if ( !support.attributes || !assert( function( el ) {
	el.innerHTML = "<input/>";
	el.firstChild.setAttribute( "value", "" );
	return el.firstChild.getAttribute( "value" ) === "";
} ) ) {
	addHandle( "value", function( elem, _name, isXML ) {
		if ( !isXML && elem.nodeName.toLowerCase() === "input" ) {
			return elem.defaultValue;
		}
	} );
}

// Support: IE<9
// Use getAttributeNode to fetch booleans when getAttribute lies
if ( !assert( function( el ) {
	return el.getAttribute( "disabled" ) == null;
} ) ) {
	addHandle( booleans, function( elem, name, isXML ) {
		var val;
		if ( !isXML ) {
			return elem[ name ] === true ? name.toLowerCase() :
				( val = elem.getAttributeNode( name ) ) && val.specified ?
					val.value :
					null;
		}
	} );
}

return Sizzle;

} )( window );



jQuery.find = Sizzle;
jQuery.expr = Sizzle.selectors;

// Deprecated
jQuery.expr[ ":" ] = jQuery.expr.pseudos;
jQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;
jQuery.text = Sizzle.getText;
jQuery.isXMLDoc = Sizzle.isXML;
jQuery.contains = Sizzle.contains;
jQuery.escapeSelector = Sizzle.escape;




var dir = function( elem, dir, until ) {
	var matched = [],
		truncate = until !== undefined;

	while ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {
		if ( elem.nodeType === 1 ) {
			if ( truncate && jQuery( elem ).is( until ) ) {
				break;
			}
			matched.push( elem );
		}
	}
	return matched;
};


var siblings = function( n, elem ) {
	var matched = [];

	for ( ; n; n = n.nextSibling ) {
		if ( n.nodeType === 1 && n !== elem ) {
			matched.push( n );
		}
	}

	return matched;
};


var rneedsContext = jQuery.expr.match.needsContext;



function nodeName( elem, name ) {

  return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();

};
var rsingleTag = ( /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i );



// Implement the identical functionality for filter and not
function winnow( elements, qualifier, not ) {
	if ( isFunction( qualifier ) ) {
		return jQuery.grep( elements, function( elem, i ) {
			return !!qualifier.call( elem, i, elem ) !== not;
		} );
	}

	// Single element
	if ( qualifier.nodeType ) {
		return jQuery.grep( elements, function( elem ) {
			return ( elem === qualifier ) !== not;
		} );
	}

	// Arraylike of elements (jQuery, arguments, Array)
	if ( typeof qualifier !== "string" ) {
		return jQuery.grep( elements, function( elem ) {
			return ( indexOf.call( qualifier, elem ) > -1 ) !== not;
		} );
	}

	// Filtered directly for both simple and complex selectors
	return jQuery.filter( qualifier, elements, not );
}

jQuery.filter = function( expr, elems, not ) {
	var elem = elems[ 0 ];

	if ( not ) {
		expr = ":not(" + expr + ")";
	}

	if ( elems.length === 1 && elem.nodeType === 1 ) {
		return jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [];
	}

	return jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {
		return elem.nodeType === 1;
	} ) );
};

jQuery.fn.extend( {
	find: function( selector ) {
		var i, ret,
			len = this.length,
			self = this;

		if ( typeof selector !== "string" ) {
			return this.pushStack( jQuery( selector ).filter( function() {
				for ( i = 0; i < len; i++ ) {
					if ( jQuery.contains( self[ i ], this ) ) {
						return true;
					}
				}
			} ) );
		}

		ret = this.pushStack( [] );

		for ( i = 0; i < len; i++ ) {
			jQuery.find( selector, self[ i ], ret );
		}

		return len > 1 ? jQuery.uniqueSort( ret ) : ret;
	},
	filter: function( selector ) {
		return this.pushStack( winnow( this, selector || [], false ) );
	},
	not: function( selector ) {
		return this.pushStack( winnow( this, selector || [], true ) );
	},
	is: function( selector ) {
		return !!winnow(
			this,

			// If this is a positional/relative selector, check membership in the returned set
			// so $("p:first").is("p:last") won't return true for a doc with two "p".
			typeof selector === "string" && rneedsContext.test( selector ) ?
				jQuery( selector ) :
				selector || [],
			false
		).length;
	}
} );


// Initialize a jQuery object


// A central reference to the root jQuery(document)
var rootjQuery,

	// A simple way to check for HTML strings
	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
	// Strict HTML recognition (#11290: must start with <)
	// Shortcut simple #id case for speed
	rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,

	init = jQuery.fn.init = function( selector, context, root ) {
		var match, elem;

		// HANDLE: $(""), $(null), $(undefined), $(false)
		if ( !selector ) {
			return this;
		}

		// Method init() accepts an alternate rootjQuery
		// so migrate can support jQuery.sub (gh-2101)
		root = root || rootjQuery;

		// Handle HTML strings
		if ( typeof selector === "string" ) {
			if ( selector[ 0 ] === "<" &&
				selector[ selector.length - 1 ] === ">" &&
				selector.length >= 3 ) {

				// Assume that strings that start and end with <> are HTML and skip the regex check
				match = [ null, selector, null ];

			} else {
				match = rquickExpr.exec( selector );
			}

			// Match html or make sure no context is specified for #id
			if ( match && ( match[ 1 ] || !context ) ) {

				// HANDLE: $(html) -> $(array)
				if ( match[ 1 ] ) {
					context = context instanceof jQuery ? context[ 0 ] : context;

					// Option to run scripts is true for back-compat
					// Intentionally let the error be thrown if parseHTML is not present
					jQuery.merge( this, jQuery.parseHTML(
						match[ 1 ],
						context && context.nodeType ? context.ownerDocument || context : document,
						true
					) );

					// HANDLE: $(html, props)
					if ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {
						for ( match in context ) {

							// Properties of context are called as methods if possible
							if ( isFunction( this[ match ] ) ) {
								this[ match ]( context[ match ] );

							// ...and otherwise set as attributes
							} else {
								this.attr( match, context[ match ] );
							}
						}
					}

					return this;

				// HANDLE: $(#id)
				} else {
					elem = document.getElementById( match[ 2 ] );

					if ( elem ) {

						// Inject the element directly into the jQuery object
						this[ 0 ] = elem;
						this.length = 1;
					}
					return this;
				}

			// HANDLE: $(expr, $(...))
			} else if ( !context || context.jquery ) {
				return ( context || root ).find( selector );

			// HANDLE: $(expr, context)
			// (which is just equivalent to: $(context).find(expr)
			} else {
				return this.constructor( context ).find( selector );
			}

		// HANDLE: $(DOMElement)
		} else if ( selector.nodeType ) {
			this[ 0 ] = selector;
			this.length = 1;
			return this;

		// HANDLE: $(function)
		// Shortcut for document ready
		} else if ( isFunction( selector ) ) {
			return root.ready !== undefined ?
				root.ready( selector ) :

				// Execute immediately if ready is not present
				selector( jQuery );
		}

		return jQuery.makeArray( selector, this );
	};

// Give the init function the jQuery prototype for later instantiation
init.prototype = jQuery.fn;

// Initialize central reference
rootjQuery = jQuery( document );


var rparentsprev = /^(?:parents|prev(?:Until|All))/,

	// Methods guaranteed to produce a unique set when starting from a unique set
	guaranteedUnique = {
		children: true,
		contents: true,
		next: true,
		prev: true
	};

jQuery.fn.extend( {
	has: function( target ) {
		var targets = jQuery( target, this ),
			l = targets.length;

		return this.filter( function() {
			var i = 0;
			for ( ; i < l; i++ ) {
				if ( jQuery.contains( this, targets[ i ] ) ) {
					return true;
				}
			}
		} );
	},

	closest: function( selectors, context ) {
		var cur,
			i = 0,
			l = this.length,
			matched = [],
			targets = typeof selectors !== "string" && jQuery( selectors );

		// Positional selectors never match, since there's no _selection_ context
		if ( !rneedsContext.test( selectors ) ) {
			for ( ; i < l; i++ ) {
				for ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {

					// Always skip document fragments
					if ( cur.nodeType < 11 && ( targets ?
						targets.index( cur ) > -1 :

						// Don't pass non-elements to Sizzle
						cur.nodeType === 1 &&
							jQuery.find.matchesSelector( cur, selectors ) ) ) {

						matched.push( cur );
						break;
					}
				}
			}
		}

		return this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );
	},

	// Determine the position of an element within the set
	index: function( elem ) {

		// No argument, return index in parent
		if ( !elem ) {
			return ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;
		}

		// Index in selector
		if ( typeof elem === "string" ) {
			return indexOf.call( jQuery( elem ), this[ 0 ] );
		}

		// Locate the position of the desired element
		return indexOf.call( this,

			// If it receives a jQuery object, the first element is used
			elem.jquery ? elem[ 0 ] : elem
		);
	},

	add: function( selector, context ) {
		return this.pushStack(
			jQuery.uniqueSort(
				jQuery.merge( this.get(), jQuery( selector, context ) )
			)
		);
	},

	addBack: function( selector ) {
		return this.add( selector == null ?
			this.prevObject : this.prevObject.filter( selector )
		);
	}
} );

function sibling( cur, dir ) {
	while ( ( cur = cur[ dir ] ) && cur.nodeType !== 1 ) {}
	return cur;
}

jQuery.each( {
	parent: function( elem ) {
		var parent = elem.parentNode;
		return parent && parent.nodeType !== 11 ? parent : null;
	},
	parents: function( elem ) {
		return dir( elem, "parentNode" );
	},
	parentsUntil: function( elem, _i, until ) {
		return dir( elem, "parentNode", until );
	},
	next: function( elem ) {
		return sibling( elem, "nextSibling" );
	},
	prev: function( elem ) {
		return sibling( elem, "previousSibling" );
	},
	nextAll: function( elem ) {
		return dir( elem, "nextSibling" );
	},
	prevAll: function( elem ) {
		return dir( elem, "previousSibling" );
	},
	nextUntil: function( elem, _i, until ) {
		return dir( elem, "nextSibling", until );
	},
	prevUntil: function( elem, _i, until ) {
		return dir( elem, "previousSibling", until );
	},
	siblings: function( elem ) {
		return siblings( ( elem.parentNode || {} ).firstChild, elem );
	},
	children: function( elem ) {
		return siblings( elem.firstChild );
	},
	contents: function( elem ) {
		if ( elem.contentDocument != null &&

			// Support: IE 11+
			// <object> elements with no `data` attribute has an object
			// `contentDocument` with a `null` prototype.
			getProto( elem.contentDocument ) ) {

			return elem.contentDocument;
		}

		// Support: IE 9 - 11 only, iOS 7 only, Android Browser <=4.3 only
		// Treat the template element as a regular one in browsers that
		// don't support it.
		if ( nodeName( elem, "template" ) ) {
			elem = elem.content || elem;
		}

		return jQuery.merge( [], elem.childNodes );
	}
}, function( name, fn ) {
	jQuery.fn[ name ] = function( until, selector ) {
		var matched = jQuery.map( this, fn, until );

		if ( name.slice( -5 ) !== "Until" ) {
			selector = until;
		}

		if ( selector && typeof selector === "string" ) {
			matched = jQuery.filter( selector, matched );
		}

		if ( this.length > 1 ) {

			// Remove duplicates
			if ( !guaranteedUnique[ name ] ) {
				jQuery.uniqueSort( matched );
			}

			// Reverse order for parents* and prev-derivatives
			if ( rparentsprev.test( name ) ) {
				matched.reverse();
			}
		}

		return this.pushStack( matched );
	};
} );
var rnothtmlwhite = ( /[^\x20\t\r\n\f]+/g );



// Convert String-formatted options into Object-formatted ones
function createOptions( options ) {
	var object = {};
	jQuery.each( options.match( rnothtmlwhite ) || [], function( _, flag ) {
		object[ flag ] = true;
	} );
	return object;
}

/*
 * Create a callback list using the following parameters:
 *
 *	options: an optional list of space-separated options that will change how
 *			the callback list behaves or a more traditional option object
 *
 * By default a callback list will act like an event callback list and can be
 * "fired" multiple times.
 *
 * Possible options:
 *
 *	once:			will ensure the callback list can only be fired once (like a Deferred)
 *
 *	memory:			will keep track of previous values and will call any callback added
 *					after the list has been fired right away with the latest "memorized"
 *					values (like a Deferred)
 *
 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
 *
 *	stopOnFalse:	interrupt callings when a callback returns false
 *
 */
jQuery.Callbacks = function( options ) {

	// Convert options from String-formatted to Object-formatted if needed
	// (we check in cache first)
	options = typeof options === "string" ?
		createOptions( options ) :
		jQuery.extend( {}, options );

	var // Flag to know if list is currently firing
		firing,

		// Last fire value for non-forgettable lists
		memory,

		// Flag to know if list was already fired
		fired,

		// Flag to prevent firing
		locked,

		// Actual callback list
		list = [],

		// Queue of execution data for repeatable lists
		queue = [],

		// Index of currently firing callback (modified by add/remove as needed)
		firingIndex = -1,

		// Fire callbacks
		fire = function() {

			// Enforce single-firing
			locked = locked || options.once;

			// Execute callbacks for all pending executions,
			// respecting firingIndex overrides and runtime changes
			fired = firing = true;
			for ( ; queue.length; firingIndex = -1 ) {
				memory = queue.shift();
				while ( ++firingIndex < list.length ) {

					// Run callback and check for early termination
					if ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&
						options.stopOnFalse ) {

						// Jump to end and forget the data so .add doesn't re-fire
						firingIndex = list.length;
						memory = false;
					}
				}
			}

			// Forget the data if we're done with it
			if ( !options.memory ) {
				memory = false;
			}

			firing = false;

			// Clean up if we're done firing for good
			if ( locked ) {

				// Keep an empty list if we have data for future add calls
				if ( memory ) {
					list = [];

				// Otherwise, this object is spent
				} else {
					list = "";
				}
			}
		},

		// Actual Callbacks object
		self = {

			// Add a callback or a collection of callbacks to the list
			add: function() {
				if ( list ) {

					// If we have memory from a past run, we should fire after adding
					if ( memory && !firing ) {
						firingIndex = list.length - 1;
						queue.push( memory );
					}

					( function add( args ) {
						jQuery.each( args, function( _, arg ) {
							if ( isFunction( arg ) ) {
								if ( !options.unique || !self.has( arg ) ) {
									list.push( arg );
								}
							} else if ( arg && arg.length && toType( arg ) !== "string" ) {

								// Inspect recursively
								add( arg );
							}
						} );
					} )( arguments );

					if ( memory && !firing ) {
						fire();
					}
				}
				return this;
			},

			// Remove a callback from the list
			remove: function() {
				jQuery.each( arguments, function( _, arg ) {
					var index;
					while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {
						list.splice( index, 1 );

						// Handle firing indexes
						if ( index <= firingIndex ) {
							firingIndex--;
						}
					}
				} );
				return this;
			},

			// Check if a given callback is in the list.
			// If no argument is given, return whether or not list has callbacks attached.
			has: function( fn ) {
				return fn ?
					jQuery.inArray( fn, list ) > -1 :
					list.length > 0;
			},

			// Remove all callbacks from the list
			empty: function() {
				if ( list ) {
					list = [];
				}
				return this;
			},

			// Disable .fire and .add
			// Abort any current/pending executions
			// Clear all callbacks and values
			disable: function() {
				locked = queue = [];
				list = memory = "";
				return this;
			},
			disabled: function() {
				return !list;
			},

			// Disable .fire
			// Also disable .add unless we have memory (since it would have no effect)
			// Abort any pending executions
			lock: function() {
				locked = queue = [];
				if ( !memory && !firing ) {
					list = memory = "";
				}
				return this;
			},
			locked: function() {
				return !!locked;
			},

			// Call all callbacks with the given context and arguments
			fireWith: function( context, args ) {
				if ( !locked ) {
					args = args || [];
					args = [ context, args.slice ? args.slice() : args ];
					queue.push( args );
					if ( !firing ) {
						fire();
					}
				}
				return this;
			},

			// Call all the callbacks with the given arguments
			fire: function() {
				self.fireWith( this, arguments );
				return this;
			},

			// To know if the callbacks have already been called at least once
			fired: function() {
				return !!fired;
			}
		};

	return self;
};


function Identity( v ) {
	return v;
}
function Thrower( ex ) {
	throw ex;
}

function adoptValue( value, resolve, reject, noValue ) {
	var method;

	try {

		// Check for promise aspect first to privilege synchronous behavior
		if ( value && isFunction( ( method = value.promise ) ) ) {
			method.call( value ).done( resolve ).fail( reject );

		// Other thenables
		} else if ( value && isFunction( ( method = value.then ) ) ) {
			method.call( value, resolve, reject );

		// Other non-thenables
		} else {

			// Control `resolve` arguments by letting Array#slice cast boolean `noValue` to integer:
			// * false: [ value ].slice( 0 ) => resolve( value )
			// * true: [ value ].slice( 1 ) => resolve()
			resolve.apply( undefined, [ value ].slice( noValue ) );
		}

	// For Promises/A+, convert exceptions into rejections
	// Since jQuery.when doesn't unwrap thenables, we can skip the extra checks appearing in
	// Deferred#then to conditionally suppress rejection.
	} catch ( value ) {

		// Support: Android 4.0 only
		// Strict mode functions invoked without .call/.apply get global-object context
		reject.apply( undefined, [ value ] );
	}
}

jQuery.extend( {

	Deferred: function( func ) {
		var tuples = [

				// action, add listener, callbacks,
				// ... .then handlers, argument index, [final state]
				[ "notify", "progress", jQuery.Callbacks( "memory" ),
					jQuery.Callbacks( "memory" ), 2 ],
				[ "resolve", "done", jQuery.Callbacks( "once memory" ),
					jQuery.Callbacks( "once memory" ), 0, "resolved" ],
				[ "reject", "fail", jQuery.Callbacks( "once memory" ),
					jQuery.Callbacks( "once memory" ), 1, "rejected" ]
			],
			state = "pending",
			promise = {
				state: function() {
					return state;
				},
				always: function() {
					deferred.done( arguments ).fail( arguments );
					return this;
				},
				"catch": function( fn ) {
					return promise.then( null, fn );
				},

				// Keep pipe for back-compat
				pipe: function( /* fnDone, fnFail, fnProgress */ ) {
					var fns = arguments;

					return jQuery.Deferred( function( newDefer ) {
						jQuery.each( tuples, function( _i, tuple ) {

							// Map tuples (progress, done, fail) to arguments (done, fail, progress)
							var fn = isFunction( fns[ tuple[ 4 ] ] ) && fns[ tuple[ 4 ] ];

							// deferred.progress(function() { bind to newDefer or newDefer.notify })
							// deferred.done(function() { bind to newDefer or newDefer.resolve })
							// deferred.fail(function() { bind to newDefer or newDefer.reject })
							deferred[ tuple[ 1 ] ]( function() {
								var returned = fn && fn.apply( this, arguments );
								if ( returned && isFunction( returned.promise ) ) {
									returned.promise()
										.progress( newDefer.notify )
										.done( newDefer.resolve )
										.fail( newDefer.reject );
								} else {
									newDefer[ tuple[ 0 ] + "With" ](
										this,
										fn ? [ returned ] : arguments
									);
								}
							} );
						} );
						fns = null;
					} ).promise();
				},
				then: function( onFulfilled, onRejected, onProgress ) {
					var maxDepth = 0;
					function resolve( depth, deferred, handler, special ) {
						return function() {
							var that = this,
								args = arguments,
								mightThrow = function() {
									var returned, then;

									// Support: Promises/A+ section 2.3.3.3.3
									// https://promisesaplus.com/#point-59
									// Ignore double-resolution attempts
									if ( depth < maxDepth ) {
										return;
									}

									returned = handler.apply( that, args );

									// Support: Promises/A+ section 2.3.1
									// https://promisesaplus.com/#point-48
									if ( returned === deferred.promise() ) {
										throw new TypeError( "Thenable self-resolution" );
									}

									// Support: Promises/A+ sections 2.3.3.1, 3.5
									// https://promisesaplus.com/#point-54
									// https://promisesaplus.com/#point-75
									// Retrieve `then` only once
									then = returned &&

										// Support: Promises/A+ section 2.3.4
										// https://promisesaplus.com/#point-64
										// Only check objects and functions for thenability
										( typeof returned === "object" ||
											typeof returned === "function" ) &&
										returned.then;

									// Handle a returned thenable
									if ( isFunction( then ) ) {

										// Special processors (notify) just wait for resolution
										if ( special ) {
											then.call(
												returned,
												resolve( maxDepth, deferred, Identity, special ),
												resolve( maxDepth, deferred, Thrower, special )
											);

										// Normal processors (resolve) also hook into progress
										} else {

											// ...and disregard older resolution values
											maxDepth++;

											then.call(
												returned,
												resolve( maxDepth, deferred, Identity, special ),
												resolve( maxDepth, deferred, Thrower, special ),
												resolve( maxDepth, deferred, Identity,
													deferred.notifyWith )
											);
										}

									// Handle all other returned values
									} else {

										// Only substitute handlers pass on context
										// and multiple values (non-spec behavior)
										if ( handler !== Identity ) {
											that = undefined;
											args = [ returned ];
										}

										// Process the value(s)
										// Default process is resolve
										( special || deferred.resolveWith )( that, args );
									}
								},

								// Only normal processors (resolve) catch and reject exceptions
								process = special ?
									mightThrow :
									function() {
										try {
											mightThrow();
										} catch ( e ) {

											if ( jQuery.Deferred.exceptionHook ) {
												jQuery.Deferred.exceptionHook( e,
													process.stackTrace );
											}

											// Support: Promises/A+ section 2.3.3.3.4.1
											// https://promisesaplus.com/#point-61
											// Ignore post-resolution exceptions
											if ( depth + 1 >= maxDepth ) {

												// Only substitute handlers pass on context
												// and multiple values (non-spec behavior)
												if ( handler !== Thrower ) {
													that = undefined;
													args = [ e ];
												}

												deferred.rejectWith( that, args );
											}
										}
									};

							// Support: Promises/A+ section 2.3.3.3.1
							// https://promisesaplus.com/#point-57
							// Re-resolve promises immediately to dodge false rejection from
							// subsequent errors
							if ( depth ) {
								process();
							} else {

								// Call an optional hook to record the stack, in case of exception
								// since it's otherwise lost when execution goes async
								if ( jQuery.Deferred.getStackHook ) {
									process.stackTrace = jQuery.Deferred.getStackHook();
								}
								window.setTimeout( process );
							}
						};
					}

					return jQuery.Deferred( function( newDefer ) {

						// progress_handlers.add( ... )
						tuples[ 0 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onProgress ) ?
									onProgress :
									Identity,
								newDefer.notifyWith
							)
						);

						// fulfilled_handlers.add( ... )
						tuples[ 1 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onFulfilled ) ?
									onFulfilled :
									Identity
							)
						);

						// rejected_handlers.add( ... )
						tuples[ 2 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onRejected ) ?
									onRejected :
									Thrower
							)
						);
					} ).promise();
				},

				// Get a promise for this deferred
				// If obj is provided, the promise aspect is added to the object
				promise: function( obj ) {
					return obj != null ? jQuery.extend( obj, promise ) : promise;
				}
			},
			deferred = {};

		// Add list-specific methods
		jQuery.each( tuples, function( i, tuple ) {
			var list = tuple[ 2 ],
				stateString = tuple[ 5 ];

			// promise.progress = list.add
			// promise.done = list.add
			// promise.fail = list.add
			promise[ tuple[ 1 ] ] = list.add;

			// Handle state
			if ( stateString ) {
				list.add(
					function() {

						// state = "resolved" (i.e., fulfilled)
						// state = "rejected"
						state = stateString;
					},

					// rejected_callbacks.disable
					// fulfilled_callbacks.disable
					tuples[ 3 - i ][ 2 ].disable,

					// rejected_handlers.disable
					// fulfilled_handlers.disable
					tuples[ 3 - i ][ 3 ].disable,

					// progress_callbacks.lock
					tuples[ 0 ][ 2 ].lock,

					// progress_handlers.lock
					tuples[ 0 ][ 3 ].lock
				);
			}

			// progress_handlers.fire
			// fulfilled_handlers.fire
			// rejected_handlers.fire
			list.add( tuple[ 3 ].fire );

			// deferred.notify = function() { deferred.notifyWith(...) }
			// deferred.resolve = function() { deferred.resolveWith(...) }
			// deferred.reject = function() { deferred.rejectWith(...) }
			deferred[ tuple[ 0 ] ] = function() {
				deferred[ tuple[ 0 ] + "With" ]( this === deferred ? undefined : this, arguments );
				return this;
			};

			// deferred.notifyWith = list.fireWith
			// deferred.resolveWith = list.fireWith
			// deferred.rejectWith = list.fireWith
			deferred[ tuple[ 0 ] + "With" ] = list.fireWith;
		} );

		// Make the deferred a promise
		promise.promise( deferred );

		// Call given func if any
		if ( func ) {
			func.call( deferred, deferred );
		}

		// All done!
		return deferred;
	},

	// Deferred helper
	when: function( singleValue ) {
		var

			// count of uncompleted subordinates
			remaining = arguments.length,

			// count of unprocessed arguments
			i = remaining,

			// subordinate fulfillment data
			resolveContexts = Array( i ),
			resolveValues = slice.call( arguments ),

			// the master Deferred
			master = jQuery.Deferred(),

			// subordinate callback factory
			updateFunc = function( i ) {
				return function( value ) {
					resolveContexts[ i ] = this;
					resolveValues[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;
					if ( !( --remaining ) ) {
						master.resolveWith( resolveContexts, resolveValues );
					}
				};
			};

		// Single- and empty arguments are adopted like Promise.resolve
		if ( remaining <= 1 ) {
			adoptValue( singleValue, master.done( updateFunc( i ) ).resolve, master.reject,
				!remaining );

			// Use .then() to unwrap secondary thenables (cf. gh-3000)
			if ( master.state() === "pending" ||
				isFunction( resolveValues[ i ] && resolveValues[ i ].then ) ) {

				return master.then();
			}
		}

		// Multiple arguments are aggregated like Promise.all array elements
		while ( i-- ) {
			adoptValue( resolveValues[ i ], updateFunc( i ), master.reject );
		}

		return master.promise();
	}
} );


// These usually indicate a programmer mistake during development,
// warn about them ASAP rather than swallowing them by default.
var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;

jQuery.Deferred.exceptionHook = function( error, stack ) {

	// Support: IE 8 - 9 only
	// Console exists when dev tools are open, which can happen at any time
	if ( window.console && window.console.warn && error && rerrorNames.test( error.name ) ) {
		window.console.warn( "jQuery.Deferred exception: " + error.message, error.stack, stack );
	}
};




jQuery.readyException = function( error ) {
	window.setTimeout( function() {
		throw error;
	} );
};




// The deferred used on DOM ready
var readyList = jQuery.Deferred();

jQuery.fn.ready = function( fn ) {

	readyList
		.then( fn )

		// Wrap jQuery.readyException in a function so that the lookup
		// happens at the time of error handling instead of callback
		// registration.
		.catch( function( error ) {
			jQuery.readyException( error );
		} );

	return this;
};

jQuery.extend( {

	// Is the DOM ready to be used? Set to true once it occurs.
	isReady: false,

	// A counter to track how many items to wait for before
	// the ready event fires. See #6781
	readyWait: 1,

	// Handle when the DOM is ready
	ready: function( wait ) {

		// Abort if there are pending holds or we're already ready
		if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {
			return;
		}

		// Remember that the DOM is ready
		jQuery.isReady = true;

		// If a normal DOM Ready event fired, decrement, and wait if need be
		if ( wait !== true && --jQuery.readyWait > 0 ) {
			return;
		}

		// If there are functions bound, to execute
		readyList.resolveWith( document, [ jQuery ] );
	}
} );

jQuery.ready.then = readyList.then;

// The ready event handler and self cleanup method
function completed() {
	document.removeEventListener( "DOMContentLoaded", completed );
	window.removeEventListener( "load", completed );
	jQuery.ready();
}

// Catch cases where $(document).ready() is called
// after the browser event has already occurred.
// Support: IE <=9 - 10 only
// Older IE sometimes signals "interactive" too soon
if ( document.readyState === "complete" ||
	( document.readyState !== "loading" && !document.documentElement.doScroll ) ) {

	// Handle it asynchronously to allow scripts the opportunity to delay ready
	window.setTimeout( jQuery.ready );

} else {

	// Use the handy event callback
	document.addEventListener( "DOMContentLoaded", completed );

	// A fallback to window.onload, that will always work
	window.addEventListener( "load", completed );
}




// Multifunctional method to get and set values of a collection
// The value/s can optionally be executed if it's a function
var access = function( elems, fn, key, value, chainable, emptyGet, raw ) {
	var i = 0,
		len = elems.length,
		bulk = key == null;

	// Sets many values
	if ( toType( key ) === "object" ) {
		chainable = true;
		for ( i in key ) {
			access( elems, fn, i, key[ i ], true, emptyGet, raw );
		}

	// Sets one value
	} else if ( value !== undefined ) {
		chainable = true;

		if ( !isFunction( value ) ) {
			raw = true;
		}

		if ( bulk ) {

			// Bulk operations run against the entire set
			if ( raw ) {
				fn.call( elems, value );
				fn = null;

			// ...except when executing function values
			} else {
				bulk = fn;
				fn = function( elem, _key, value ) {
					return bulk.call( jQuery( elem ), value );
				};
			}
		}

		if ( fn ) {
			for ( ; i < len; i++ ) {
				fn(
					elems[ i ], key, raw ?
					value :
					value.call( elems[ i ], i, fn( elems[ i ], key ) )
				);
			}
		}
	}

	if ( chainable ) {
		return elems;
	}

	// Gets
	if ( bulk ) {
		return fn.call( elems );
	}

	return len ? fn( elems[ 0 ], key ) : emptyGet;
};


// Matches dashed string for camelizing
var rmsPrefix = /^-ms-/,
	rdashAlpha = /-([a-z])/g;

// Used by camelCase as callback to replace()
function fcamelCase( _all, letter ) {
	return letter.toUpperCase();
}

// Convert dashed to camelCase; used by the css and data modules
// Support: IE <=9 - 11, Edge 12 - 15
// Microsoft forgot to hump their vendor prefix (#9572)
function camelCase( string ) {
	return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );
}
var acceptData = function( owner ) {

	// Accepts only:
	//  - Node
	//    - Node.ELEMENT_NODE
	//    - Node.DOCUMENT_NODE
	//  - Object
	//    - Any
	return owner.nodeType === 1 || owner.nodeType === 9 || !( +owner.nodeType );
};




function Data() {
	this.expando = jQuery.expando + Data.uid++;
}

Data.uid = 1;

Data.prototype = {

	cache: function( owner ) {

		// Check if the owner object already has a cache
		var value = owner[ this.expando ];

		// If not, create one
		if ( !value ) {
			value = {};

			// We can accept data for non-element nodes in modern browsers,
			// but we should not, see #8335.
			// Always return an empty object.
			if ( acceptData( owner ) ) {

				// If it is a node unlikely to be stringify-ed or looped over
				// use plain assignment
				if ( owner.nodeType ) {
					owner[ this.expando ] = value;

				// Otherwise secure it in a non-enumerable property
				// configurable must be true to allow the property to be
				// deleted when data is removed
				} else {
					Object.defineProperty( owner, this.expando, {
						value: value,
						configurable: true
					} );
				}
			}
		}

		return value;
	},
	set: function( owner, data, value ) {
		var prop,
			cache = this.cache( owner );

		// Handle: [ owner, key, value ] args
		// Always use camelCase key (gh-2257)
		if ( typeof data === "string" ) {
			cache[ camelCase( data ) ] = value;

		// Handle: [ owner, { properties } ] args
		} else {

			// Copy the properties one-by-one to the cache object
			for ( prop in data ) {
				cache[ camelCase( prop ) ] = data[ prop ];
			}
		}
		return cache;
	},
	get: function( owner, key ) {
		return key === undefined ?
			this.cache( owner ) :

			// Always use camelCase key (gh-2257)
			owner[ this.expando ] && owner[ this.expando ][ camelCase( key ) ];
	},
	access: function( owner, key, value ) {

		// In cases where either:
		//
		//   1. No key was specified
		//   2. A string key was specified, but no value provided
		//
		// Take the "read" path and allow the get method to determine
		// which value to return, respectively either:
		//
		//   1. The entire cache object
		//   2. The data stored at the key
		//
		if ( key === undefined ||
				( ( key && typeof key === "string" ) && value === undefined ) ) {

			return this.get( owner, key );
		}

		// When the key is not a string, or both a key and value
		// are specified, set or extend (existing objects) with either:
		//
		//   1. An object of properties
		//   2. A key and value
		//
		this.set( owner, key, value );

		// Since the "set" path can have two possible entry points
		// return the expected data based on which path was taken[*]
		return value !== undefined ? value : key;
	},
	remove: function( owner, key ) {
		var i,
			cache = owner[ this.expando ];

		if ( cache === undefined ) {
			return;
		}

		if ( key !== undefined ) {

			// Support array or space separated string of keys
			if ( Array.isArray( key ) ) {

				// If key is an array of keys...
				// We always set camelCase keys, so remove that.
				key = key.map( camelCase );
			} else {
				key = camelCase( key );

				// If a key with the spaces exists, use it.
				// Otherwise, create an array by matching non-whitespace
				key = key in cache ?
					[ key ] :
					( key.match( rnothtmlwhite ) || [] );
			}

			i = key.length;

			while ( i-- ) {
				delete cache[ key[ i ] ];
			}
		}

		// Remove the expando if there's no more data
		if ( key === undefined || jQuery.isEmptyObject( cache ) ) {

			// Support: Chrome <=35 - 45
			// Webkit & Blink performance suffers when deleting properties
			// from DOM nodes, so set to undefined instead
			// https://bugs.chromium.org/p/chromium/issues/detail?id=378607 (bug restricted)
			if ( owner.nodeType ) {
				owner[ this.expando ] = undefined;
			} else {
				delete owner[ this.expando ];
			}
		}
	},
	hasData: function( owner ) {
		var cache = owner[ this.expando ];
		return cache !== undefined && !jQuery.isEmptyObject( cache );
	}
};
var dataPriv = new Data();

var dataUser = new Data();



//	Implementation Summary
//
//	1. Enforce API surface and semantic compatibility with 1.9.x branch
//	2. Improve the module's maintainability by reducing the storage
//		paths to a single mechanism.
//	3. Use the same single mechanism to support "private" and "user" data.
//	4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)
//	5. Avoid exposing implementation details on user objects (eg. expando properties)
//	6. Provide a clear path for implementation upgrade to WeakMap in 2014

var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
	rmultiDash = /[A-Z]/g;

function getData( data ) {
	if ( data === "true" ) {
		return true;
	}

	if ( data === "false" ) {
		return false;
	}

	if ( data === "null" ) {
		return null;
	}

	// Only convert to a number if it doesn't change the string
	if ( data === +data + "" ) {
		return +data;
	}

	if ( rbrace.test( data ) ) {
		return JSON.parse( data );
	}

	return data;
}

function dataAttr( elem, key, data ) {
	var name;

	// If nothing was found internally, try to fetch any
	// data from the HTML5 data-* attribute
	if ( data === undefined && elem.nodeType === 1 ) {
		name = "data-" + key.replace( rmultiDash, "-$&" ).toLowerCase();
		data = elem.getAttribute( name );

		if ( typeof data === "string" ) {
			try {
				data = getData( data );
			} catch ( e ) {}

			// Make sure we set the data so it isn't changed later
			dataUser.set( elem, key, data );
		} else {
			data = undefined;
		}
	}
	return data;
}

jQuery.extend( {
	hasData: function( elem ) {
		return dataUser.hasData( elem ) || dataPriv.hasData( elem );
	},

	data: function( elem, name, data ) {
		return dataUser.access( elem, name, data );
	},

	removeData: function( elem, name ) {
		dataUser.remove( elem, name );
	},

	// TODO: Now that all calls to _data and _removeData have been replaced
	// with direct calls to dataPriv methods, these can be deprecated.
	_data: function( elem, name, data ) {
		return dataPriv.access( elem, name, data );
	},

	_removeData: function( elem, name ) {
		dataPriv.remove( elem, name );
	}
} );

jQuery.fn.extend( {
	data: function( key, value ) {
		var i, name, data,
			elem = this[ 0 ],
			attrs = elem && elem.attributes;

		// Gets all values
		if ( key === undefined ) {
			if ( this.length ) {
				data = dataUser.get( elem );

				if ( elem.nodeType === 1 && !dataPriv.get( elem, "hasDataAttrs" ) ) {
					i = attrs.length;
					while ( i-- ) {

						// Support: IE 11 only
						// The attrs elements can be null (#14894)
						if ( attrs[ i ] ) {
							name = attrs[ i ].name;
							if ( name.indexOf( "data-" ) === 0 ) {
								name = camelCase( name.slice( 5 ) );
								dataAttr( elem, name, data[ name ] );
							}
						}
					}
					dataPriv.set( elem, "hasDataAttrs", true );
				}
			}

			return data;
		}

		// Sets multiple values
		if ( typeof key === "object" ) {
			return this.each( function() {
				dataUser.set( this, key );
			} );
		}

		return access( this, function( value ) {
			var data;

			// The calling jQuery object (element matches) is not empty
			// (and therefore has an element appears at this[ 0 ]) and the
			// `value` parameter was not undefined. An empty jQuery object
			// will result in `undefined` for elem = this[ 0 ] which will
			// throw an exception if an attempt to read a data cache is made.
			if ( elem && value === undefined ) {

				// Attempt to get data from the cache
				// The key will always be camelCased in Data
				data = dataUser.get( elem, key );
				if ( data !== undefined ) {
					return data;
				}

				// Attempt to "discover" the data in
				// HTML5 custom data-* attrs
				data = dataAttr( elem, key );
				if ( data !== undefined ) {
					return data;
				}

				// We tried really hard, but the data doesn't exist.
				return;
			}

			// Set the data...
			this.each( function() {

				// We always store the camelCased key
				dataUser.set( this, key, value );
			} );
		}, null, value, arguments.length > 1, null, true );
	},

	removeData: function( key ) {
		return this.each( function() {
			dataUser.remove( this, key );
		} );
	}
} );


jQuery.extend( {
	queue: function( elem, type, data ) {
		var queue;

		if ( elem ) {
			type = ( type || "fx" ) + "queue";
			queue = dataPriv.get( elem, type );

			// Speed up dequeue by getting out quickly if this is just a lookup
			if ( data ) {
				if ( !queue || Array.isArray( data ) ) {
					queue = dataPriv.access( elem, type, jQuery.makeArray( data ) );
				} else {
					queue.push( data );
				}
			}
			return queue || [];
		}
	},

	dequeue: function( elem, type ) {
		type = type || "fx";

		var queue = jQuery.queue( elem, type ),
			startLength = queue.length,
			fn = queue.shift(),
			hooks = jQuery._queueHooks( elem, type ),
			next = function() {
				jQuery.dequeue( elem, type );
			};

		// If the fx queue is dequeued, always remove the progress sentinel
		if ( fn === "inprogress" ) {
			fn = queue.shift();
			startLength--;
		}

		if ( fn ) {

			// Add a progress sentinel to prevent the fx queue from being
			// automatically dequeued
			if ( type === "fx" ) {
				queue.unshift( "inprogress" );
			}

			// Clear up the last queue stop function
			delete hooks.stop;
			fn.call( elem, next, hooks );
		}

		if ( !startLength && hooks ) {
			hooks.empty.fire();
		}
	},

	// Not public - generate a queueHooks object, or return the current one
	_queueHooks: function( elem, type ) {
		var key = type + "queueHooks";
		return dataPriv.get( elem, key ) || dataPriv.access( elem, key, {
			empty: jQuery.Callbacks( "once memory" ).add( function() {
				dataPriv.remove( elem, [ type + "queue", key ] );
			} )
		} );
	}
} );

jQuery.fn.extend( {
	queue: function( type, data ) {
		var setter = 2;

		if ( typeof type !== "string" ) {
			data = type;
			type = "fx";
			setter--;
		}

		if ( arguments.length < setter ) {
			return jQuery.queue( this[ 0 ], type );
		}

		return data === undefined ?
			this :
			this.each( function() {
				var queue = jQuery.queue( this, type, data );

				// Ensure a hooks for this queue
				jQuery._queueHooks( this, type );

				if ( type === "fx" && queue[ 0 ] !== "inprogress" ) {
					jQuery.dequeue( this, type );
				}
			} );
	},
	dequeue: function( type ) {
		return this.each( function() {
			jQuery.dequeue( this, type );
		} );
	},
	clearQueue: function( type ) {
		return this.queue( type || "fx", [] );
	},

	// Get a promise resolved when queues of a certain type
	// are emptied (fx is the type by default)
	promise: function( type, obj ) {
		var tmp,
			count = 1,
			defer = jQuery.Deferred(),
			elements = this,
			i = this.length,
			resolve = function() {
				if ( !( --count ) ) {
					defer.resolveWith( elements, [ elements ] );
				}
			};

		if ( typeof type !== "string" ) {
			obj = type;
			type = undefined;
		}
		type = type || "fx";

		while ( i-- ) {
			tmp = dataPriv.get( elements[ i ], type + "queueHooks" );
			if ( tmp && tmp.empty ) {
				count++;
				tmp.empty.add( resolve );
			}
		}
		resolve();
		return defer.promise( obj );
	}
} );
var pnum = ( /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/ ).source;

var rcssNum = new RegExp( "^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i" );


var cssExpand = [ "Top", "Right", "Bottom", "Left" ];

var documentElement = document.documentElement;



	var isAttached = function( elem ) {
			return jQuery.contains( elem.ownerDocument, elem );
		},
		composed = { composed: true };

	// Support: IE 9 - 11+, Edge 12 - 18+, iOS 10.0 - 10.2 only
	// Check attachment across shadow DOM boundaries when possible (gh-3504)
	// Support: iOS 10.0-10.2 only
	// Early iOS 10 versions support `attachShadow` but not `getRootNode`,
	// leading to errors. We need to check for `getRootNode`.
	if ( documentElement.getRootNode ) {
		isAttached = function( elem ) {
			return jQuery.contains( elem.ownerDocument, elem ) ||
				elem.getRootNode( composed ) === elem.ownerDocument;
		};
	}
var isHiddenWithinTree = function( elem, el ) {

		// isHiddenWithinTree might be called from jQuery#filter function;
		// in that case, element will be second argument
		elem = el || elem;

		// Inline style trumps all
		return elem.style.display === "none" ||
			elem.style.display === "" &&

			// Otherwise, check computed style
			// Support: Firefox <=43 - 45
			// Disconnected elements can have computed display: none, so first confirm that elem is
			// in the document.
			isAttached( elem ) &&

			jQuery.css( elem, "display" ) === "none";
	};



function adjustCSS( elem, prop, valueParts, tween ) {
	var adjusted, scale,
		maxIterations = 20,
		currentValue = tween ?
			function() {
				return tween.cur();
			} :
			function() {
				return jQuery.css( elem, prop, "" );
			},
		initial = currentValue(),
		unit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? "" : "px" ),

		// Starting value computation is required for potential unit mismatches
		initialInUnit = elem.nodeType &&
			( jQuery.cssNumber[ prop ] || unit !== "px" && +initial ) &&
			rcssNum.exec( jQuery.css( elem, prop ) );

	if ( initialInUnit && initialInUnit[ 3 ] !== unit ) {

		// Support: Firefox <=54
		// Halve the iteration target value to prevent interference from CSS upper bounds (gh-2144)
		initial = initial / 2;

		// Trust units reported by jQuery.css
		unit = unit || initialInUnit[ 3 ];

		// Iteratively approximate from a nonzero starting point
		initialInUnit = +initial || 1;

		while ( maxIterations-- ) {

			// Evaluate and update our best guess (doubling guesses that zero out).
			// Finish if the scale equals or crosses 1 (making the old*new product non-positive).
			jQuery.style( elem, prop, initialInUnit + unit );
			if ( ( 1 - scale ) * ( 1 - ( scale = currentValue() / initial || 0.5 ) ) <= 0 ) {
				maxIterations = 0;
			}
			initialInUnit = initialInUnit / scale;

		}

		initialInUnit = initialInUnit * 2;
		jQuery.style( elem, prop, initialInUnit + unit );

		// Make sure we update the tween properties later on
		valueParts = valueParts || [];
	}

	if ( valueParts ) {
		initialInUnit = +initialInUnit || +initial || 0;

		// Apply relative offset (+=/-=) if specified
		adjusted = valueParts[ 1 ] ?
			initialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :
			+valueParts[ 2 ];
		if ( tween ) {
			tween.unit = unit;
			tween.start = initialInUnit;
			tween.end = adjusted;
		}
	}
	return adjusted;
}


var defaultDisplayMap = {};

function getDefaultDisplay( elem ) {
	var temp,
		doc = elem.ownerDocument,
		nodeName = elem.nodeName,
		display = defaultDisplayMap[ nodeName ];

	if ( display ) {
		return display;
	}

	temp = doc.body.appendChild( doc.createElement( nodeName ) );
	display = jQuery.css( temp, "display" );

	temp.parentNode.removeChild( temp );

	if ( display === "none" ) {
		display = "block";
	}
	defaultDisplayMap[ nodeName ] = display;

	return display;
}

function showHide( elements, show ) {
	var display, elem,
		values = [],
		index = 0,
		length = elements.length;

	// Determine new display value for elements that need to change
	for ( ; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}

		display = elem.style.display;
		if ( show ) {

			// Since we force visibility upon cascade-hidden elements, an immediate (and slow)
			// check is required in this first loop unless we have a nonempty display value (either
			// inline or about-to-be-restored)
			if ( display === "none" ) {
				values[ index ] = dataPriv.get( elem, "display" ) || null;
				if ( !values[ index ] ) {
					elem.style.display = "";
				}
			}
			if ( elem.style.display === "" && isHiddenWithinTree( elem ) ) {
				values[ index ] = getDefaultDisplay( elem );
			}
		} else {
			if ( display !== "none" ) {
				values[ index ] = "none";

				// Remember what we're overwriting
				dataPriv.set( elem, "display", display );
			}
		}
	}

	// Set the display of the elements in a second loop to avoid constant reflow
	for ( index = 0; index < length; index++ ) {
		if ( values[ index ] != null ) {
			elements[ index ].style.display = values[ index ];
		}
	}

	return elements;
}

jQuery.fn.extend( {
	show: function() {
		return showHide( this, true );
	},
	hide: function() {
		return showHide( this );
	},
	toggle: function( state ) {
		if ( typeof state === "boolean" ) {
			return state ? this.show() : this.hide();
		}

		return this.each( function() {
			if ( isHiddenWithinTree( this ) ) {
				jQuery( this ).show();
			} else {
				jQuery( this ).hide();
			}
		} );
	}
} );
var rcheckableType = ( /^(?:checkbox|radio)$/i );

var rtagName = ( /<([a-z][^\/\0>\x20\t\r\n\f]*)/i );

var rscriptType = ( /^$|^module$|\/(?:java|ecma)script/i );



( function() {
	var fragment = document.createDocumentFragment(),
		div = fragment.appendChild( document.createElement( "div" ) ),
		input = document.createElement( "input" );

	// Support: Android 4.0 - 4.3 only
	// Check state lost if the name is set (#11217)
	// Support: Windows Web Apps (WWA)
	// `name` and `type` must use .setAttribute for WWA (#14901)
	input.setAttribute( "type", "radio" );
	input.setAttribute( "checked", "checked" );
	input.setAttribute( "name", "t" );

	div.appendChild( input );

	// Support: Android <=4.1 only
	// Older WebKit doesn't clone checked state correctly in fragments
	support.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;

	// Support: IE <=11 only
	// Make sure textarea (and checkbox) defaultValue is properly cloned
	div.innerHTML = "<textarea>x</textarea>";
	support.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;

	// Support: IE <=9 only
	// IE <=9 replaces <option> tags with their contents when inserted outside of
	// the select element.
	div.innerHTML = "<option></option>";
	support.option = !!div.lastChild;
} )();


// We have to close these tags to support XHTML (#13200)
var wrapMap = {

	// XHTML parsers do not magically insert elements in the
	// same way that tag soup parsers do. So we cannot shorten
	// this by omitting <tbody> or other required elements.
	thead: [ 1, "<table>", "</table>" ],
	col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
	tr: [ 2, "<table><tbody>", "</tbody></table>" ],
	td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],

	_default: [ 0, "", "" ]
};

wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
wrapMap.th = wrapMap.td;

// Support: IE <=9 only
if ( !support.option ) {
	wrapMap.optgroup = wrapMap.option = [ 1, "<select multiple='multiple'>", "</select>" ];
}


function getAll( context, tag ) {

	// Support: IE <=9 - 11 only
	// Use typeof to avoid zero-argument method invocation on host objects (#15151)
	var ret;

	if ( typeof context.getElementsByTagName !== "undefined" ) {
		ret = context.getElementsByTagName( tag || "*" );

	} else if ( typeof context.querySelectorAll !== "undefined" ) {
		ret = context.querySelectorAll( tag || "*" );

	} else {
		ret = [];
	}

	if ( tag === undefined || tag && nodeName( context, tag ) ) {
		return jQuery.merge( [ context ], ret );
	}

	return ret;
}


// Mark scripts as having already been evaluated
function setGlobalEval( elems, refElements ) {
	var i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		dataPriv.set(
			elems[ i ],
			"globalEval",
			!refElements || dataPriv.get( refElements[ i ], "globalEval" )
		);
	}
}


var rhtml = /<|&#?\w+;/;

function buildFragment( elems, context, scripts, selection, ignored ) {
	var elem, tmp, tag, wrap, attached, j,
		fragment = context.createDocumentFragment(),
		nodes = [],
		i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		elem = elems[ i ];

		if ( elem || elem === 0 ) {

			// Add nodes directly
			if ( toType( elem ) === "object" ) {

				// Support: Android <=4.0 only, PhantomJS 1 only
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );

			// Convert non-html into a text node
			} else if ( !rhtml.test( elem ) ) {
				nodes.push( context.createTextNode( elem ) );

			// Convert html into DOM nodes
			} else {
				tmp = tmp || fragment.appendChild( context.createElement( "div" ) );

				// Deserialize a standard representation
				tag = ( rtagName.exec( elem ) || [ "", "" ] )[ 1 ].toLowerCase();
				wrap = wrapMap[ tag ] || wrapMap._default;
				tmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];

				// Descend through wrappers to the right content
				j = wrap[ 0 ];
				while ( j-- ) {
					tmp = tmp.lastChild;
				}

				// Support: Android <=4.0 only, PhantomJS 1 only
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, tmp.childNodes );

				// Remember the top-level container
				tmp = fragment.firstChild;

				// Ensure the created nodes are orphaned (#12392)
				tmp.textContent = "";
			}
		}
	}

	// Remove wrapper from fragment
	fragment.textContent = "";

	i = 0;
	while ( ( elem = nodes[ i++ ] ) ) {

		// Skip elements already in the context collection (trac-4087)
		if ( selection && jQuery.inArray( elem, selection ) > -1 ) {
			if ( ignored ) {
				ignored.push( elem );
			}
			continue;
		}

		attached = isAttached( elem );

		// Append to fragment
		tmp = getAll( fragment.appendChild( elem ), "script" );

		// Preserve script evaluation history
		if ( attached ) {
			setGlobalEval( tmp );
		}

		// Capture executables
		if ( scripts ) {
			j = 0;
			while ( ( elem = tmp[ j++ ] ) ) {
				if ( rscriptType.test( elem.type || "" ) ) {
					scripts.push( elem );
				}
			}
		}
	}

	return fragment;
}


var
	rkeyEvent = /^key/,
	rmouseEvent = /^(?:mouse|pointer|contextmenu|drag|drop)|click/,
	rtypenamespace = /^([^.]*)(?:\.(.+)|)/;

function returnTrue() {
	return true;
}

function returnFalse() {
	return false;
}

// Support: IE <=9 - 11+
// focus() and blur() are asynchronous, except when they are no-op.
// So expect focus to be synchronous when the element is already active,
// and blur to be synchronous when the element is not already active.
// (focus and blur are always synchronous in other supported browsers,
// this just defines when we can count on it).
function expectSync( elem, type ) {
	return ( elem === safeActiveElement() ) === ( type === "focus" );
}

// Support: IE <=9 only
// Accessing document.activeElement can throw unexpectedly
// https://bugs.jquery.com/ticket/13393
function safeActiveElement() {
	try {
		return document.activeElement;
	} catch ( err ) { }
}

function on( elem, types, selector, data, fn, one ) {
	var origFn, type;

	// Types can be a map of types/handlers
	if ( typeof types === "object" ) {

		// ( types-Object, selector, data )
		if ( typeof selector !== "string" ) {

			// ( types-Object, data )
			data = data || selector;
			selector = undefined;
		}
		for ( type in types ) {
			on( elem, type, selector, data, types[ type ], one );
		}
		return elem;
	}

	if ( data == null && fn == null ) {

		// ( types, fn )
		fn = selector;
		data = selector = undefined;
	} else if ( fn == null ) {
		if ( typeof selector === "string" ) {

			// ( types, selector, fn )
			fn = data;
			data = undefined;
		} else {

			// ( types, data, fn )
			fn = data;
			data = selector;
			selector = undefined;
		}
	}
	if ( fn === false ) {
		fn = returnFalse;
	} else if ( !fn ) {
		return elem;
	}

	if ( one === 1 ) {
		origFn = fn;
		fn = function( event ) {

			// Can use an empty set, since event contains the info
			jQuery().off( event );
			return origFn.apply( this, arguments );
		};

		// Use same guid so caller can remove using origFn
		fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );
	}
	return elem.each( function() {
		jQuery.event.add( this, types, fn, data, selector );
	} );
}

/*
 * Helper functions for managing events -- not part of the public interface.
 * Props to Dean Edwards' addEvent library for many of the ideas.
 */
jQuery.event = {

	global: {},

	add: function( elem, types, handler, data, selector ) {

		var handleObjIn, eventHandle, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.get( elem );

		// Only attach events to objects that accept data
		if ( !acceptData( elem ) ) {
			return;
		}

		// Caller can pass in an object of custom data in lieu of the handler
		if ( handler.handler ) {
			handleObjIn = handler;
			handler = handleObjIn.handler;
			selector = handleObjIn.selector;
		}

		// Ensure that invalid selectors throw exceptions at attach time
		// Evaluate against documentElement in case elem is a non-element node (e.g., document)
		if ( selector ) {
			jQuery.find.matchesSelector( documentElement, selector );
		}

		// Make sure that the handler has a unique ID, used to find/remove it later
		if ( !handler.guid ) {
			handler.guid = jQuery.guid++;
		}

		// Init the element's event structure and main handler, if this is the first
		if ( !( events = elemData.events ) ) {
			events = elemData.events = Object.create( null );
		}
		if ( !( eventHandle = elemData.handle ) ) {
			eventHandle = elemData.handle = function( e ) {

				// Discard the second event of a jQuery.event.trigger() and
				// when an event is called after a page has unloaded
				return typeof jQuery !== "undefined" && jQuery.event.triggered !== e.type ?
					jQuery.event.dispatch.apply( elem, arguments ) : undefined;
			};
		}

		// Handle multiple events separated by a space
		types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// There *must* be a type, no attaching namespace-only handlers
			if ( !type ) {
				continue;
			}

			// If event changes its type, use the special event handlers for the changed type
			special = jQuery.event.special[ type ] || {};

			// If selector defined, determine special event api type, otherwise given type
			type = ( selector ? special.delegateType : special.bindType ) || type;

			// Update special based on newly reset type
			special = jQuery.event.special[ type ] || {};

			// handleObj is passed to all event handlers
			handleObj = jQuery.extend( {
				type: type,
				origType: origType,
				data: data,
				handler: handler,
				guid: handler.guid,
				selector: selector,
				needsContext: selector && jQuery.expr.match.needsContext.test( selector ),
				namespace: namespaces.join( "." )
			}, handleObjIn );

			// Init the event handler queue if we're the first
			if ( !( handlers = events[ type ] ) ) {
				handlers = events[ type ] = [];
				handlers.delegateCount = 0;

				// Only use addEventListener if the special events handler returns false
				if ( !special.setup ||
					special.setup.call( elem, data, namespaces, eventHandle ) === false ) {

					if ( elem.addEventListener ) {
						elem.addEventListener( type, eventHandle );
					}
				}
			}

			if ( special.add ) {
				special.add.call( elem, handleObj );

				if ( !handleObj.handler.guid ) {
					handleObj.handler.guid = handler.guid;
				}
			}

			// Add to the element's handler list, delegates in front
			if ( selector ) {
				handlers.splice( handlers.delegateCount++, 0, handleObj );
			} else {
				handlers.push( handleObj );
			}

			// Keep track of which events have ever been used, for event optimization
			jQuery.event.global[ type ] = true;
		}

	},

	// Detach an event or set of events from an element
	remove: function( elem, types, handler, selector, mappedTypes ) {

		var j, origCount, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.hasData( elem ) && dataPriv.get( elem );

		if ( !elemData || !( events = elemData.events ) ) {
			return;
		}

		// Once for each type.namespace in types; type may be omitted
		types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// Unbind all events (on this namespace, if provided) for the element
			if ( !type ) {
				for ( type in events ) {
					jQuery.event.remove( elem, type + types[ t ], handler, selector, true );
				}
				continue;
			}

			special = jQuery.event.special[ type ] || {};
			type = ( selector ? special.delegateType : special.bindType ) || type;
			handlers = events[ type ] || [];
			tmp = tmp[ 2 ] &&
				new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" );

			// Remove matching events
			origCount = j = handlers.length;
			while ( j-- ) {
				handleObj = handlers[ j ];

				if ( ( mappedTypes || origType === handleObj.origType ) &&
					( !handler || handler.guid === handleObj.guid ) &&
					( !tmp || tmp.test( handleObj.namespace ) ) &&
					( !selector || selector === handleObj.selector ||
						selector === "**" && handleObj.selector ) ) {
					handlers.splice( j, 1 );

					if ( handleObj.selector ) {
						handlers.delegateCount--;
					}
					if ( special.remove ) {
						special.remove.call( elem, handleObj );
					}
				}
			}

			// Remove generic event handler if we removed something and no more handlers exist
			// (avoids potential for endless recursion during removal of special event handlers)
			if ( origCount && !handlers.length ) {
				if ( !special.teardown ||
					special.teardown.call( elem, namespaces, elemData.handle ) === false ) {

					jQuery.removeEvent( elem, type, elemData.handle );
				}

				delete events[ type ];
			}
		}

		// Remove data and the expando if it's no longer used
		if ( jQuery.isEmptyObject( events ) ) {
			dataPriv.remove( elem, "handle events" );
		}
	},

	dispatch: function( nativeEvent ) {

		var i, j, ret, matched, handleObj, handlerQueue,
			args = new Array( arguments.length ),

			// Make a writable jQuery.Event from the native event object
			event = jQuery.event.fix( nativeEvent ),

			handlers = (
					dataPriv.get( this, "events" ) || Object.create( null )
				)[ event.type ] || [],
			special = jQuery.event.special[ event.type ] || {};

		// Use the fix-ed jQuery.Event rather than the (read-only) native event
		args[ 0 ] = event;

		for ( i = 1; i < arguments.length; i++ ) {
			args[ i ] = arguments[ i ];
		}

		event.delegateTarget = this;

		// Call the preDispatch hook for the mapped type, and let it bail if desired
		if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {
			return;
		}

		// Determine handlers
		handlerQueue = jQuery.event.handlers.call( this, event, handlers );

		// Run delegates first; they may want to stop propagation beneath us
		i = 0;
		while ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {
			event.currentTarget = matched.elem;

			j = 0;
			while ( ( handleObj = matched.handlers[ j++ ] ) &&
				!event.isImmediatePropagationStopped() ) {

				// If the event is namespaced, then each handler is only invoked if it is
				// specially universal or its namespaces are a superset of the event's.
				if ( !event.rnamespace || handleObj.namespace === false ||
					event.rnamespace.test( handleObj.namespace ) ) {

					event.handleObj = handleObj;
					event.data = handleObj.data;

					ret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||
						handleObj.handler ).apply( matched.elem, args );

					if ( ret !== undefined ) {
						if ( ( event.result = ret ) === false ) {
							event.preventDefault();
							event.stopPropagation();
						}
					}
				}
			}
		}

		// Call the postDispatch hook for the mapped type
		if ( special.postDispatch ) {
			special.postDispatch.call( this, event );
		}

		return event.result;
	},

	handlers: function( event, handlers ) {
		var i, handleObj, sel, matchedHandlers, matchedSelectors,
			handlerQueue = [],
			delegateCount = handlers.delegateCount,
			cur = event.target;

		// Find delegate handlers
		if ( delegateCount &&

			// Support: IE <=9
			// Black-hole SVG <use> instance trees (trac-13180)
			cur.nodeType &&

			// Support: Firefox <=42
			// Suppress spec-violating clicks indicating a non-primary pointer button (trac-3861)
			// https://www.w3.org/TR/DOM-Level-3-Events/#event-type-click
			// Support: IE 11 only
			// ...but not arrow key "clicks" of radio inputs, which can have `button` -1 (gh-2343)
			!( event.type === "click" && event.button >= 1 ) ) {

			for ( ; cur !== this; cur = cur.parentNode || this ) {

				// Don't check non-elements (#13208)
				// Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)
				if ( cur.nodeType === 1 && !( event.type === "click" && cur.disabled === true ) ) {
					matchedHandlers = [];
					matchedSelectors = {};
					for ( i = 0; i < delegateCount; i++ ) {
						handleObj = handlers[ i ];

						// Don't conflict with Object.prototype properties (#13203)
						sel = handleObj.selector + " ";

						if ( matchedSelectors[ sel ] === undefined ) {
							matchedSelectors[ sel ] = handleObj.needsContext ?
								jQuery( sel, this ).index( cur ) > -1 :
								jQuery.find( sel, this, null, [ cur ] ).length;
						}
						if ( matchedSelectors[ sel ] ) {
							matchedHandlers.push( handleObj );
						}
					}
					if ( matchedHandlers.length ) {
						handlerQueue.push( { elem: cur, handlers: matchedHandlers } );
					}
				}
			}
		}

		// Add the remaining (directly-bound) handlers
		cur = this;
		if ( delegateCount < handlers.length ) {
			handlerQueue.push( { elem: cur, handlers: handlers.slice( delegateCount ) } );
		}

		return handlerQueue;
	},

	addProp: function( name, hook ) {
		Object.defineProperty( jQuery.Event.prototype, name, {
			enumerable: true,
			configurable: true,

			get: isFunction( hook ) ?
				function() {
					if ( this.originalEvent ) {
							return hook( this.originalEvent );
					}
				} :
				function() {
					if ( this.originalEvent ) {
							return this.originalEvent[ name ];
					}
				},

			set: function( value ) {
				Object.defineProperty( this, name, {
					enumerable: true,
					configurable: true,
					writable: true,
					value: value
				} );
			}
		} );
	},

	fix: function( originalEvent ) {
		return originalEvent[ jQuery.expando ] ?
			originalEvent :
			new jQuery.Event( originalEvent );
	},

	special: {
		load: {

			// Prevent triggered image.load events from bubbling to window.load
			noBubble: true
		},
		click: {

			// Utilize native event to ensure correct state for checkable inputs
			setup: function( data ) {

				// For mutual compressibility with _default, replace `this` access with a local var.
				// `|| data` is dead code meant only to preserve the variable through minification.
				var el = this || data;

				// Claim the first handler
				if ( rcheckableType.test( el.type ) &&
					el.click && nodeName( el, "input" ) ) {

					// dataPriv.set( el, "click", ... )
					leverageNative( el, "click", returnTrue );
				}

				// Return false to allow normal processing in the caller
				return false;
			},
			trigger: function( data ) {

				// For mutual compressibility with _default, replace `this` access with a local var.
				// `|| data` is dead code meant only to preserve the variable through minification.
				var el = this || data;

				// Force setup before triggering a click
				if ( rcheckableType.test( el.type ) &&
					el.click && nodeName( el, "input" ) ) {

					leverageNative( el, "click" );
				}

				// Return non-false to allow normal event-path propagation
				return true;
			},

			// For cross-browser consistency, suppress native .click() on links
			// Also prevent it if we're currently inside a leveraged native-event stack
			_default: function( event ) {
				var target = event.target;
				return rcheckableType.test( target.type ) &&
					target.click && nodeName( target, "input" ) &&
					dataPriv.get( target, "click" ) ||
					nodeName( target, "a" );
			}
		},

		beforeunload: {
			postDispatch: function( event ) {

				// Support: Firefox 20+
				// Firefox doesn't alert if the returnValue field is not set.
				if ( event.result !== undefined && event.originalEvent ) {
					event.originalEvent.returnValue = event.result;
				}
			}
		}
	}
};

// Ensure the presence of an event listener that handles manually-triggered
// synthetic events by interrupting progress until reinvoked in response to
// *native* events that it fires directly, ensuring that state changes have
// already occurred before other listeners are invoked.
function leverageNative( el, type, expectSync ) {

	// Missing expectSync indicates a trigger call, which must force setup through jQuery.event.add
	if ( !expectSync ) {
		if ( dataPriv.get( el, type ) === undefined ) {
			jQuery.event.add( el, type, returnTrue );
		}
		return;
	}

	// Register the controller as a special universal handler for all event namespaces
	dataPriv.set( el, type, false );
	jQuery.event.add( el, type, {
		namespace: false,
		handler: function( event ) {
			var notAsync, result,
				saved = dataPriv.get( this, type );

			if ( ( event.isTrigger & 1 ) && this[ type ] ) {

				// Interrupt processing of the outer synthetic .trigger()ed event
				// Saved data should be false in such cases, but might be a leftover capture object
				// from an async native handler (gh-4350)
				if ( !saved.length ) {

					// Store arguments for use when handling the inner native event
					// There will always be at least one argument (an event object), so this array
					// will not be confused with a leftover capture object.
					saved = slice.call( arguments );
					dataPriv.set( this, type, saved );

					// Trigger the native event and capture its result
					// Support: IE <=9 - 11+
					// focus() and blur() are asynchronous
					notAsync = expectSync( this, type );
					this[ type ]();
					result = dataPriv.get( this, type );
					if ( saved !== result || notAsync ) {
						dataPriv.set( this, type, false );
					} else {
						result = {};
					}
					if ( saved !== result ) {

						// Cancel the outer synthetic event
						event.stopImmediatePropagation();
						event.preventDefault();
						return result.value;
					}

				// If this is an inner synthetic event for an event with a bubbling surrogate
				// (focus or blur), assume that the surrogate already propagated from triggering the
				// native event and prevent that from happening again here.
				// This technically gets the ordering wrong w.r.t. to `.trigger()` (in which the
				// bubbling surrogate propagates *after* the non-bubbling base), but that seems
				// less bad than duplication.
				} else if ( ( jQuery.event.special[ type ] || {} ).delegateType ) {
					event.stopPropagation();
				}

			// If this is a native event triggered above, everything is now in order
			// Fire an inner synthetic event with the original arguments
			} else if ( saved.length ) {

				// ...and capture the result
				dataPriv.set( this, type, {
					value: jQuery.event.trigger(

						// Support: IE <=9 - 11+
						// Extend with the prototype to reset the above stopImmediatePropagation()
						jQuery.extend( saved[ 0 ], jQuery.Event.prototype ),
						saved.slice( 1 ),
						this
					)
				} );

				// Abort handling of the native event
				event.stopImmediatePropagation();
			}
		}
	} );
}

jQuery.removeEvent = function( elem, type, handle ) {

	// This "if" is needed for plain objects
	if ( elem.removeEventListener ) {
		elem.removeEventListener( type, handle );
	}
};

jQuery.Event = function( src, props ) {

	// Allow instantiation without the 'new' keyword
	if ( !( this instanceof jQuery.Event ) ) {
		return new jQuery.Event( src, props );
	}

	// Event object
	if ( src && src.type ) {
		this.originalEvent = src;
		this.type = src.type;

		// Events bubbling up the document may have been marked as prevented
		// by a handler lower down the tree; reflect the correct value.
		this.isDefaultPrevented = src.defaultPrevented ||
				src.defaultPrevented === undefined &&

				// Support: Android <=2.3 only
				src.returnValue === false ?
			returnTrue :
			returnFalse;

		// Create target properties
		// Support: Safari <=6 - 7 only
		// Target should not be a text node (#504, #13143)
		this.target = ( src.target && src.target.nodeType === 3 ) ?
			src.target.parentNode :
			src.target;

		this.currentTarget = src.currentTarget;
		this.relatedTarget = src.relatedTarget;

	// Event type
	} else {
		this.type = src;
	}

	// Put explicitly provided properties onto the event object
	if ( props ) {
		jQuery.extend( this, props );
	}

	// Create a timestamp if incoming event doesn't have one
	this.timeStamp = src && src.timeStamp || Date.now();

	// Mark it as fixed
	this[ jQuery.expando ] = true;
};

// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
// https://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
jQuery.Event.prototype = {
	constructor: jQuery.Event,
	isDefaultPrevented: returnFalse,
	isPropagationStopped: returnFalse,
	isImmediatePropagationStopped: returnFalse,
	isSimulated: false,

	preventDefault: function() {
		var e = this.originalEvent;

		this.isDefaultPrevented = returnTrue;

		if ( e && !this.isSimulated ) {
			e.preventDefault();
		}
	},
	stopPropagation: function() {
		var e = this.originalEvent;

		this.isPropagationStopped = returnTrue;

		if ( e && !this.isSimulated ) {
			e.stopPropagation();
		}
	},
	stopImmediatePropagation: function() {
		var e = this.originalEvent;

		this.isImmediatePropagationStopped = returnTrue;

		if ( e && !this.isSimulated ) {
			e.stopImmediatePropagation();
		}

		this.stopPropagation();
	}
};

// Includes all common event props including KeyEvent and MouseEvent specific props
jQuery.each( {
	altKey: true,
	bubbles: true,
	cancelable: true,
	changedTouches: true,
	ctrlKey: true,
	detail: true,
	eventPhase: true,
	metaKey: true,
	pageX: true,
	pageY: true,
	shiftKey: true,
	view: true,
	"char": true,
	code: true,
	charCode: true,
	key: true,
	keyCode: true,
	button: true,
	buttons: true,
	clientX: true,
	clientY: true,
	offsetX: true,
	offsetY: true,
	pointerId: true,
	pointerType: true,
	screenX: true,
	screenY: true,
	targetTouches: true,
	toElement: true,
	touches: true,

	which: function( event ) {
		var button = event.button;

		// Add which for key events
		if ( event.which == null && rkeyEvent.test( event.type ) ) {
			return event.charCode != null ? event.charCode : event.keyCode;
		}

		// Add which for click: 1 === left; 2 === middle; 3 === right
		if ( !event.which && button !== undefined && rmouseEvent.test( event.type ) ) {
			if ( button & 1 ) {
				return 1;
			}

			if ( button & 2 ) {
				return 3;
			}

			if ( button & 4 ) {
				return 2;
			}

			return 0;
		}

		return event.which;
	}
}, jQuery.event.addProp );

jQuery.each( { focus: "focusin", blur: "focusout" }, function( type, delegateType ) {
	jQuery.event.special[ type ] = {

		// Utilize native event if possible so blur/focus sequence is correct
		setup: function() {

			// Claim the first handler
			// dataPriv.set( this, "focus", ... )
			// dataPriv.set( this, "blur", ... )
			leverageNative( this, type, expectSync );

			// Return false to allow normal processing in the caller
			return false;
		},
		trigger: function() {

			// Force setup before trigger
			leverageNative( this, type );

			// Return non-false to allow normal event-path propagation
			return true;
		},

		delegateType: delegateType
	};
} );

// Create mouseenter/leave events using mouseover/out and event-time checks
// so that event delegation works in jQuery.
// Do the same for pointerenter/pointerleave and pointerover/pointerout
//
// Support: Safari 7 only
// Safari sends mouseenter too often; see:
// https://bugs.chromium.org/p/chromium/issues/detail?id=470258
// for the description of the bug (it existed in older Chrome versions as well).
jQuery.each( {
	mouseenter: "mouseover",
	mouseleave: "mouseout",
	pointerenter: "pointerover",
	pointerleave: "pointerout"
}, function( orig, fix ) {
	jQuery.event.special[ orig ] = {
		delegateType: fix,
		bindType: fix,

		handle: function( event ) {
			var ret,
				target = this,
				related = event.relatedTarget,
				handleObj = event.handleObj;

			// For mouseenter/leave call the handler if related is outside the target.
			// NB: No relatedTarget if the mouse left/entered the browser window
			if ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {
				event.type = handleObj.origType;
				ret = handleObj.handler.apply( this, arguments );
				event.type = fix;
			}
			return ret;
		}
	};
} );

jQuery.fn.extend( {

	on: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn );
	},
	one: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn, 1 );
	},
	off: function( types, selector, fn ) {
		var handleObj, type;
		if ( types && types.preventDefault && types.handleObj ) {

			// ( event )  dispatched jQuery.Event
			handleObj = types.handleObj;
			jQuery( types.delegateTarget ).off(
				handleObj.namespace ?
					handleObj.origType + "." + handleObj.namespace :
					handleObj.origType,
				handleObj.selector,
				handleObj.handler
			);
			return this;
		}
		if ( typeof types === "object" ) {

			// ( types-object [, selector] )
			for ( type in types ) {
				this.off( type, selector, types[ type ] );
			}
			return this;
		}
		if ( selector === false || typeof selector === "function" ) {

			// ( types [, fn] )
			fn = selector;
			selector = undefined;
		}
		if ( fn === false ) {
			fn = returnFalse;
		}
		return this.each( function() {
			jQuery.event.remove( this, types, fn, selector );
		} );
	}
} );


var

	// Support: IE <=10 - 11, Edge 12 - 13 only
	// In IE/Edge using regex groups here causes severe slowdowns.
	// See https://connect.microsoft.com/IE/feedback/details/1736512/
	rnoInnerhtml = /<script|<style|<link/i,

	// checked="checked" or checked
	rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
	rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;

// Prefer a tbody over its parent table for containing new rows
function manipulationTarget( elem, content ) {
	if ( nodeName( elem, "table" ) &&
		nodeName( content.nodeType !== 11 ? content : content.firstChild, "tr" ) ) {

		return jQuery( elem ).children( "tbody" )[ 0 ] || elem;
	}

	return elem;
}

// Replace/restore the type attribute of script elements for safe DOM manipulation
function disableScript( elem ) {
	elem.type = ( elem.getAttribute( "type" ) !== null ) + "/" + elem.type;
	return elem;
}
function restoreScript( elem ) {
	if ( ( elem.type || "" ).slice( 0, 5 ) === "true/" ) {
		elem.type = elem.type.slice( 5 );
	} else {
		elem.removeAttribute( "type" );
	}

	return elem;
}

function cloneCopyEvent( src, dest ) {
	var i, l, type, pdataOld, udataOld, udataCur, events;

	if ( dest.nodeType !== 1 ) {
		return;
	}

	// 1. Copy private data: events, handlers, etc.
	if ( dataPriv.hasData( src ) ) {
		pdataOld = dataPriv.get( src );
		events = pdataOld.events;

		if ( events ) {
			dataPriv.remove( dest, "handle events" );

			for ( type in events ) {
				for ( i = 0, l = events[ type ].length; i < l; i++ ) {
					jQuery.event.add( dest, type, events[ type ][ i ] );
				}
			}
		}
	}

	// 2. Copy user data
	if ( dataUser.hasData( src ) ) {
		udataOld = dataUser.access( src );
		udataCur = jQuery.extend( {}, udataOld );

		dataUser.set( dest, udataCur );
	}
}

// Fix IE bugs, see support tests
function fixInput( src, dest ) {
	var nodeName = dest.nodeName.toLowerCase();

	// Fails to persist the checked state of a cloned checkbox or radio button.
	if ( nodeName === "input" && rcheckableType.test( src.type ) ) {
		dest.checked = src.checked;

	// Fails to return the selected option to the default selected state when cloning options
	} else if ( nodeName === "input" || nodeName === "textarea" ) {
		dest.defaultValue = src.defaultValue;
	}
}

function domManip( collection, args, callback, ignored ) {

	// Flatten any nested arrays
	args = flat( args );

	var fragment, first, scripts, hasScripts, node, doc,
		i = 0,
		l = collection.length,
		iNoClone = l - 1,
		value = args[ 0 ],
		valueIsFunction = isFunction( value );

	// We can't cloneNode fragments that contain checked, in WebKit
	if ( valueIsFunction ||
			( l > 1 && typeof value === "string" &&
				!support.checkClone && rchecked.test( value ) ) ) {
		return collection.each( function( index ) {
			var self = collection.eq( index );
			if ( valueIsFunction ) {
				args[ 0 ] = value.call( this, index, self.html() );
			}
			domManip( self, args, callback, ignored );
		} );
	}

	if ( l ) {
		fragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );
		first = fragment.firstChild;

		if ( fragment.childNodes.length === 1 ) {
			fragment = first;
		}

		// Require either new content or an interest in ignored elements to invoke the callback
		if ( first || ignored ) {
			scripts = jQuery.map( getAll( fragment, "script" ), disableScript );
			hasScripts = scripts.length;

			// Use the original fragment for the last item
			// instead of the first because it can end up
			// being emptied incorrectly in certain situations (#8070).
			for ( ; i < l; i++ ) {
				node = fragment;

				if ( i !== iNoClone ) {
					node = jQuery.clone( node, true, true );

					// Keep references to cloned scripts for later restoration
					if ( hasScripts ) {

						// Support: Android <=4.0 only, PhantomJS 1 only
						// push.apply(_, arraylike) throws on ancient WebKit
						jQuery.merge( scripts, getAll( node, "script" ) );
					}
				}

				callback.call( collection[ i ], node, i );
			}

			if ( hasScripts ) {
				doc = scripts[ scripts.length - 1 ].ownerDocument;

				// Reenable scripts
				jQuery.map( scripts, restoreScript );

				// Evaluate executable scripts on first document insertion
				for ( i = 0; i < hasScripts; i++ ) {
					node = scripts[ i ];
					if ( rscriptType.test( node.type || "" ) &&
						!dataPriv.access( node, "globalEval" ) &&
						jQuery.contains( doc, node ) ) {

						if ( node.src && ( node.type || "" ).toLowerCase()  !== "module" ) {

							// Optional AJAX dependency, but won't run scripts if not present
							if ( jQuery._evalUrl && !node.noModule ) {
								jQuery._evalUrl( node.src, {
									nonce: node.nonce || node.getAttribute( "nonce" )
								}, doc );
							}
						} else {
							DOMEval( node.textContent.replace( rcleanScript, "" ), node, doc );
						}
					}
				}
			}
		}
	}

	return collection;
}

function remove( elem, selector, keepData ) {
	var node,
		nodes = selector ? jQuery.filter( selector, elem ) : elem,
		i = 0;

	for ( ; ( node = nodes[ i ] ) != null; i++ ) {
		if ( !keepData && node.nodeType === 1 ) {
			jQuery.cleanData( getAll( node ) );
		}

		if ( node.parentNode ) {
			if ( keepData && isAttached( node ) ) {
				setGlobalEval( getAll( node, "script" ) );
			}
			node.parentNode.removeChild( node );
		}
	}

	return elem;
}

jQuery.extend( {
	htmlPrefilter: function( html ) {
		return html;
	},

	clone: function( elem, dataAndEvents, deepDataAndEvents ) {
		var i, l, srcElements, destElements,
			clone = elem.cloneNode( true ),
			inPage = isAttached( elem );

		// Fix IE cloning issues
		if ( !support.noCloneChecked && ( elem.nodeType === 1 || elem.nodeType === 11 ) &&
				!jQuery.isXMLDoc( elem ) ) {

			// We eschew Sizzle here for performance reasons: https://jsperf.com/getall-vs-sizzle/2
			destElements = getAll( clone );
			srcElements = getAll( elem );

			for ( i = 0, l = srcElements.length; i < l; i++ ) {
				fixInput( srcElements[ i ], destElements[ i ] );
			}
		}

		// Copy the events from the original to the clone
		if ( dataAndEvents ) {
			if ( deepDataAndEvents ) {
				srcElements = srcElements || getAll( elem );
				destElements = destElements || getAll( clone );

				for ( i = 0, l = srcElements.length; i < l; i++ ) {
					cloneCopyEvent( srcElements[ i ], destElements[ i ] );
				}
			} else {
				cloneCopyEvent( elem, clone );
			}
		}

		// Preserve script evaluation history
		destElements = getAll( clone, "script" );
		if ( destElements.length > 0 ) {
			setGlobalEval( destElements, !inPage && getAll( elem, "script" ) );
		}

		// Return the cloned set
		return clone;
	},

	cleanData: function( elems ) {
		var data, elem, type,
			special = jQuery.event.special,
			i = 0;

		for ( ; ( elem = elems[ i ] ) !== undefined; i++ ) {
			if ( acceptData( elem ) ) {
				if ( ( data = elem[ dataPriv.expando ] ) ) {
					if ( data.events ) {
						for ( type in data.events ) {
							if ( special[ type ] ) {
								jQuery.event.remove( elem, type );

							// This is a shortcut to avoid jQuery.event.remove's overhead
							} else {
								jQuery.removeEvent( elem, type, data.handle );
							}
						}
					}

					// Support: Chrome <=35 - 45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataPriv.expando ] = undefined;
				}
				if ( elem[ dataUser.expando ] ) {

					// Support: Chrome <=35 - 45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataUser.expando ] = undefined;
				}
			}
		}
	}
} );

jQuery.fn.extend( {
	detach: function( selector ) {
		return remove( this, selector, true );
	},

	remove: function( selector ) {
		return remove( this, selector );
	},

	text: function( value ) {
		return access( this, function( value ) {
			return value === undefined ?
				jQuery.text( this ) :
				this.empty().each( function() {
					if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
						this.textContent = value;
					}
				} );
		}, null, value, arguments.length );
	},

	append: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.appendChild( elem );
			}
		} );
	},

	prepend: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.insertBefore( elem, target.firstChild );
			}
		} );
	},

	before: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this );
			}
		} );
	},

	after: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this.nextSibling );
			}
		} );
	},

	empty: function() {
		var elem,
			i = 0;

		for ( ; ( elem = this[ i ] ) != null; i++ ) {
			if ( elem.nodeType === 1 ) {

				// Prevent memory leaks
				jQuery.cleanData( getAll( elem, false ) );

				// Remove any remaining nodes
				elem.textContent = "";
			}
		}

		return this;
	},

	clone: function( dataAndEvents, deepDataAndEvents ) {
		dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
		deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

		return this.map( function() {
			return jQuery.clone( this, dataAndEvents, deepDataAndEvents );
		} );
	},

	html: function( value ) {
		return access( this, function( value ) {
			var elem = this[ 0 ] || {},
				i = 0,
				l = this.length;

			if ( value === undefined && elem.nodeType === 1 ) {
				return elem.innerHTML;
			}

			// See if we can take a shortcut and just use innerHTML
			if ( typeof value === "string" && !rnoInnerhtml.test( value ) &&
				!wrapMap[ ( rtagName.exec( value ) || [ "", "" ] )[ 1 ].toLowerCase() ] ) {

				value = jQuery.htmlPrefilter( value );

				try {
					for ( ; i < l; i++ ) {
						elem = this[ i ] || {};

						// Remove element nodes and prevent memory leaks
						if ( elem.nodeType === 1 ) {
							jQuery.cleanData( getAll( elem, false ) );
							elem.innerHTML = value;
						}
					}

					elem = 0;

				// If using innerHTML throws an exception, use the fallback method
				} catch ( e ) {}
			}

			if ( elem ) {
				this.empty().append( value );
			}
		}, null, value, arguments.length );
	},

	replaceWith: function() {
		var ignored = [];

		// Make the changes, replacing each non-ignored context element with the new content
		return domManip( this, arguments, function( elem ) {
			var parent = this.parentNode;

			if ( jQuery.inArray( this, ignored ) < 0 ) {
				jQuery.cleanData( getAll( this ) );
				if ( parent ) {
					parent.replaceChild( elem, this );
				}
			}

		// Force callback invocation
		}, ignored );
	}
} );

jQuery.each( {
	appendTo: "append",
	prependTo: "prepend",
	insertBefore: "before",
	insertAfter: "after",
	replaceAll: "replaceWith"
}, function( name, original ) {
	jQuery.fn[ name ] = function( selector ) {
		var elems,
			ret = [],
			insert = jQuery( selector ),
			last = insert.length - 1,
			i = 0;

		for ( ; i <= last; i++ ) {
			elems = i === last ? this : this.clone( true );
			jQuery( insert[ i ] )[ original ]( elems );

			// Support: Android <=4.0 only, PhantomJS 1 only
			// .get() because push.apply(_, arraylike) throws on ancient WebKit
			push.apply( ret, elems.get() );
		}

		return this.pushStack( ret );
	};
} );
var rnumnonpx = new RegExp( "^(" + pnum + ")(?!px)[a-z%]+$", "i" );

var getStyles = function( elem ) {

		// Support: IE <=11 only, Firefox <=30 (#15098, #14150)
		// IE throws on elements created in popups
		// FF meanwhile throws on frame elements through "defaultView.getComputedStyle"
		var view = elem.ownerDocument.defaultView;

		if ( !view || !view.opener ) {
			view = window;
		}

		return view.getComputedStyle( elem );
	};

var swap = function( elem, options, callback ) {
	var ret, name,
		old = {};

	// Remember the old values, and insert the new ones
	for ( name in options ) {
		old[ name ] = elem.style[ name ];
		elem.style[ name ] = options[ name ];
	}

	ret = callback.call( elem );

	// Revert the old values
	for ( name in options ) {
		elem.style[ name ] = old[ name ];
	}

	return ret;
};


var rboxStyle = new RegExp( cssExpand.join( "|" ), "i" );



( function() {

	// Executing both pixelPosition & boxSizingReliable tests require only one layout
	// so they're executed at the same time to save the second computation.
	function computeStyleTests() {

		// This is a singleton, we need to execute it only once
		if ( !div ) {
			return;
		}

		container.style.cssText = "position:absolute;left:-11111px;width:60px;" +
			"margin-top:1px;padding:0;border:0";
		div.style.cssText =
			"position:relative;display:block;box-sizing:border-box;overflow:scroll;" +
			"margin:auto;border:1px;padding:1px;" +
			"width:60%;top:1%";
		documentElement.appendChild( container ).appendChild( div );

		var divStyle = window.getComputedStyle( div );
		pixelPositionVal = divStyle.top !== "1%";

		// Support: Android 4.0 - 4.3 only, Firefox <=3 - 44
		reliableMarginLeftVal = roundPixelMeasures( divStyle.marginLeft ) === 12;

		// Support: Android 4.0 - 4.3 only, Safari <=9.1 - 10.1, iOS <=7.0 - 9.3
		// Some styles come back with percentage values, even though they shouldn't
		div.style.right = "60%";
		pixelBoxStylesVal = roundPixelMeasures( divStyle.right ) === 36;

		// Support: IE 9 - 11 only
		// Detect misreporting of content dimensions for box-sizing:border-box elements
		boxSizingReliableVal = roundPixelMeasures( divStyle.width ) === 36;

		// Support: IE 9 only
		// Detect overflow:scroll screwiness (gh-3699)
		// Support: Chrome <=64
		// Don't get tricked when zoom affects offsetWidth (gh-4029)
		div.style.position = "absolute";
		scrollboxSizeVal = roundPixelMeasures( div.offsetWidth / 3 ) === 12;

		documentElement.removeChild( container );

		// Nullify the div so it wouldn't be stored in the memory and
		// it will also be a sign that checks already performed
		div = null;
	}

	function roundPixelMeasures( measure ) {
		return Math.round( parseFloat( measure ) );
	}

	var pixelPositionVal, boxSizingReliableVal, scrollboxSizeVal, pixelBoxStylesVal,
		reliableTrDimensionsVal, reliableMarginLeftVal,
		container = document.createElement( "div" ),
		div = document.createElement( "div" );

	// Finish early in limited (non-browser) environments
	if ( !div.style ) {
		return;
	}

	// Support: IE <=9 - 11 only
	// Style of cloned element affects source element cloned (#8908)
	div.style.backgroundClip = "content-box";
	div.cloneNode( true ).style.backgroundClip = "";
	support.clearCloneStyle = div.style.backgroundClip === "content-box";

	jQuery.extend( support, {
		boxSizingReliable: function() {
			computeStyleTests();
			return boxSizingReliableVal;
		},
		pixelBoxStyles: function() {
			computeStyleTests();
			return pixelBoxStylesVal;
		},
		pixelPosition: function() {
			computeStyleTests();
			return pixelPositionVal;
		},
		reliableMarginLeft: function() {
			computeStyleTests();
			return reliableMarginLeftVal;
		},
		scrollboxSize: function() {
			computeStyleTests();
			return scrollboxSizeVal;
		},

		// Support: IE 9 - 11+, Edge 15 - 18+
		// IE/Edge misreport `getComputedStyle` of table rows with width/height
		// set in CSS while `offset*` properties report correct values.
		// Behavior in IE 9 is more subtle than in newer versions & it passes
		// some versions of this test; make sure not to make it pass there!
		reliableTrDimensions: function() {
			var table, tr, trChild, trStyle;
			if ( reliableTrDimensionsVal == null ) {
				table = document.createElement( "table" );
				tr = document.createElement( "tr" );
				trChild = document.createElement( "div" );

				table.style.cssText = "position:absolute;left:-11111px";
				tr.style.height = "1px";
				trChild.style.height = "9px";

				documentElement
					.appendChild( table )
					.appendChild( tr )
					.appendChild( trChild );

				trStyle = window.getComputedStyle( tr );
				reliableTrDimensionsVal = parseInt( trStyle.height ) > 3;

				documentElement.removeChild( table );
			}
			return reliableTrDimensionsVal;
		}
	} );
} )();


function curCSS( elem, name, computed ) {
	var width, minWidth, maxWidth, ret,

		// Support: Firefox 51+
		// Retrieving style before computed somehow
		// fixes an issue with getting wrong values
		// on detached elements
		style = elem.style;

	computed = computed || getStyles( elem );

	// getPropertyValue is needed for:
	//   .css('filter') (IE 9 only, #12537)
	//   .css('--customProperty) (#3144)
	if ( computed ) {
		ret = computed.getPropertyValue( name ) || computed[ name ];

		if ( ret === "" && !isAttached( elem ) ) {
			ret = jQuery.style( elem, name );
		}

		// A tribute to the "awesome hack by Dean Edwards"
		// Android Browser returns percentage for some values,
		// but width seems to be reliably pixels.
		// This is against the CSSOM draft spec:
		// https://drafts.csswg.org/cssom/#resolved-values
		if ( !support.pixelBoxStyles() && rnumnonpx.test( ret ) && rboxStyle.test( name ) ) {

			// Remember the original values
			width = style.width;
			minWidth = style.minWidth;
			maxWidth = style.maxWidth;

			// Put in the new values to get a computed value out
			style.minWidth = style.maxWidth = style.width = ret;
			ret = computed.width;

			// Revert the changed values
			style.width = width;
			style.minWidth = minWidth;
			style.maxWidth = maxWidth;
		}
	}

	return ret !== undefined ?

		// Support: IE <=9 - 11 only
		// IE returns zIndex value as an integer.
		ret + "" :
		ret;
}


function addGetHookIf( conditionFn, hookFn ) {

	// Define the hook, we'll check on the first run if it's really needed.
	return {
		get: function() {
			if ( conditionFn() ) {

				// Hook not needed (or it's not possible to use it due
				// to missing dependency), remove it.
				delete this.get;
				return;
			}

			// Hook needed; redefine it so that the support test is not executed again.
			return ( this.get = hookFn ).apply( this, arguments );
		}
	};
}


var cssPrefixes = [ "Webkit", "Moz", "ms" ],
	emptyStyle = document.createElement( "div" ).style,
	vendorProps = {};

// Return a vendor-prefixed property or undefined
function vendorPropName( name ) {

	// Check for vendor prefixed names
	var capName = name[ 0 ].toUpperCase() + name.slice( 1 ),
		i = cssPrefixes.length;

	while ( i-- ) {
		name = cssPrefixes[ i ] + capName;
		if ( name in emptyStyle ) {
			return name;
		}
	}
}

// Return a potentially-mapped jQuery.cssProps or vendor prefixed property
function finalPropName( name ) {
	var final = jQuery.cssProps[ name ] || vendorProps[ name ];

	if ( final ) {
		return final;
	}
	if ( name in emptyStyle ) {
		return name;
	}
	return vendorProps[ name ] = vendorPropName( name ) || name;
}


var

	// Swappable if display is none or starts with table
	// except "table", "table-cell", or "table-caption"
	// See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
	rdisplayswap = /^(none|table(?!-c[ea]).+)/,
	rcustomProp = /^--/,
	cssShow = { position: "absolute", visibility: "hidden", display: "block" },
	cssNormalTransform = {
		letterSpacing: "0",
		fontWeight: "400"
	};

function setPositiveNumber( _elem, value, subtract ) {

	// Any relative (+/-) values have already been
	// normalized at this point
	var matches = rcssNum.exec( value );
	return matches ?

		// Guard against undefined "subtract", e.g., when used as in cssHooks
		Math.max( 0, matches[ 2 ] - ( subtract || 0 ) ) + ( matches[ 3 ] || "px" ) :
		value;
}

function boxModelAdjustment( elem, dimension, box, isBorderBox, styles, computedVal ) {
	var i = dimension === "width" ? 1 : 0,
		extra = 0,
		delta = 0;

	// Adjustment may not be necessary
	if ( box === ( isBorderBox ? "border" : "content" ) ) {
		return 0;
	}

	for ( ; i < 4; i += 2 ) {

		// Both box models exclude margin
		if ( box === "margin" ) {
			delta += jQuery.css( elem, box + cssExpand[ i ], true, styles );
		}

		// If we get here with a content-box, we're seeking "padding" or "border" or "margin"
		if ( !isBorderBox ) {

			// Add padding
			delta += jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );

			// For "border" or "margin", add border
			if ( box !== "padding" ) {
				delta += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );

			// But still keep track of it otherwise
			} else {
				extra += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}

		// If we get here with a border-box (content + padding + border), we're seeking "content" or
		// "padding" or "margin"
		} else {

			// For "content", subtract padding
			if ( box === "content" ) {
				delta -= jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );
			}

			// For "content" or "padding", subtract border
			if ( box !== "margin" ) {
				delta -= jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}
		}
	}

	// Account for positive content-box scroll gutter when requested by providing computedVal
	if ( !isBorderBox && computedVal >= 0 ) {

		// offsetWidth/offsetHeight is a rounded sum of content, padding, scroll gutter, and border
		// Assuming integer scroll gutter, subtract the rest and round down
		delta += Math.max( 0, Math.ceil(
			elem[ "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -
			computedVal -
			delta -
			extra -
			0.5

		// If offsetWidth/offsetHeight is unknown, then we can't determine content-box scroll gutter
		// Use an explicit zero to avoid NaN (gh-3964)
		) ) || 0;
	}

	return delta;
}

function getWidthOrHeight( elem, dimension, extra ) {

	// Start with computed style
	var styles = getStyles( elem ),

		// To avoid forcing a reflow, only fetch boxSizing if we need it (gh-4322).
		// Fake content-box until we know it's needed to know the true value.
		boxSizingNeeded = !support.boxSizingReliable() || extra,
		isBorderBox = boxSizingNeeded &&
			jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
		valueIsBorderBox = isBorderBox,

		val = curCSS( elem, dimension, styles ),
		offsetProp = "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 );

	// Support: Firefox <=54
	// Return a confounding non-pixel value or feign ignorance, as appropriate.
	if ( rnumnonpx.test( val ) ) {
		if ( !extra ) {
			return val;
		}
		val = "auto";
	}


	// Support: IE 9 - 11 only
	// Use offsetWidth/offsetHeight for when box sizing is unreliable.
	// In those cases, the computed value can be trusted to be border-box.
	if ( ( !support.boxSizingReliable() && isBorderBox ||

		// Support: IE 10 - 11+, Edge 15 - 18+
		// IE/Edge misreport `getComputedStyle` of table rows with width/height
		// set in CSS while `offset*` properties report correct values.
		// Interestingly, in some cases IE 9 doesn't suffer from this issue.
		!support.reliableTrDimensions() && nodeName( elem, "tr" ) ||

		// Fall back to offsetWidth/offsetHeight when value is "auto"
		// This happens for inline elements with no explicit setting (gh-3571)
		val === "auto" ||

		// Support: Android <=4.1 - 4.3 only
		// Also use offsetWidth/offsetHeight for misreported inline dimensions (gh-3602)
		!parseFloat( val ) && jQuery.css( elem, "display", false, styles ) === "inline" ) &&

		// Make sure the element is visible & connected
		elem.getClientRects().length ) {

		isBorderBox = jQuery.css( elem, "boxSizing", false, styles ) === "border-box";

		// Where available, offsetWidth/offsetHeight approximate border box dimensions.
		// Where not available (e.g., SVG), assume unreliable box-sizing and interpret the
		// retrieved value as a content box dimension.
		valueIsBorderBox = offsetProp in elem;
		if ( valueIsBorderBox ) {
			val = elem[ offsetProp ];
		}
	}

	// Normalize "" and auto
	val = parseFloat( val ) || 0;

	// Adjust for the element's box model
	return ( val +
		boxModelAdjustment(
			elem,
			dimension,
			extra || ( isBorderBox ? "border" : "content" ),
			valueIsBorderBox,
			styles,

			// Provide the current computed size to request scroll gutter calculation (gh-3589)
			val
		)
	) + "px";
}

jQuery.extend( {

	// Add in style property hooks for overriding the default
	// behavior of getting and setting a style property
	cssHooks: {
		opacity: {
			get: function( elem, computed ) {
				if ( computed ) {

					// We should always get a number back from opacity
					var ret = curCSS( elem, "opacity" );
					return ret === "" ? "1" : ret;
				}
			}
		}
	},

	// Don't automatically add "px" to these possibly-unitless properties
	cssNumber: {
		"animationIterationCount": true,
		"columnCount": true,
		"fillOpacity": true,
		"flexGrow": true,
		"flexShrink": true,
		"fontWeight": true,
		"gridArea": true,
		"gridColumn": true,
		"gridColumnEnd": true,
		"gridColumnStart": true,
		"gridRow": true,
		"gridRowEnd": true,
		"gridRowStart": true,
		"lineHeight": true,
		"opacity": true,
		"order": true,
		"orphans": true,
		"widows": true,
		"zIndex": true,
		"zoom": true
	},

	// Add in properties whose names you wish to fix before
	// setting or getting the value
	cssProps: {},

	// Get and set the style property on a DOM Node
	style: function( elem, name, value, extra ) {

		// Don't set styles on text and comment nodes
		if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {
			return;
		}

		// Make sure that we're working with the right name
		var ret, type, hooks,
			origName = camelCase( name ),
			isCustomProp = rcustomProp.test( name ),
			style = elem.style;

		// Make sure that we're working with the right name. We don't
		// want to query the value if it is a CSS custom property
		// since they are user-defined.
		if ( !isCustomProp ) {
			name = finalPropName( origName );
		}

		// Gets hook for the prefixed version, then unprefixed version
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// Check if we're setting a value
		if ( value !== undefined ) {
			type = typeof value;

			// Convert "+=" or "-=" to relative numbers (#7345)
			if ( type === "string" && ( ret = rcssNum.exec( value ) ) && ret[ 1 ] ) {
				value = adjustCSS( elem, name, ret );

				// Fixes bug #9237
				type = "number";
			}

			// Make sure that null and NaN values aren't set (#7116)
			if ( value == null || value !== value ) {
				return;
			}

			// If a number was passed in, add the unit (except for certain CSS properties)
			// The isCustomProp check can be removed in jQuery 4.0 when we only auto-append
			// "px" to a few hardcoded values.
			if ( type === "number" && !isCustomProp ) {
				value += ret && ret[ 3 ] || ( jQuery.cssNumber[ origName ] ? "" : "px" );
			}

			// background-* props affect original clone's values
			if ( !support.clearCloneStyle && value === "" && name.indexOf( "background" ) === 0 ) {
				style[ name ] = "inherit";
			}

			// If a hook was provided, use that value, otherwise just set the specified value
			if ( !hooks || !( "set" in hooks ) ||
				( value = hooks.set( elem, value, extra ) ) !== undefined ) {

				if ( isCustomProp ) {
					style.setProperty( name, value );
				} else {
					style[ name ] = value;
				}
			}

		} else {

			// If a hook was provided get the non-computed value from there
			if ( hooks && "get" in hooks &&
				( ret = hooks.get( elem, false, extra ) ) !== undefined ) {

				return ret;
			}

			// Otherwise just get the value from the style object
			return style[ name ];
		}
	},

	css: function( elem, name, extra, styles ) {
		var val, num, hooks,
			origName = camelCase( name ),
			isCustomProp = rcustomProp.test( name );

		// Make sure that we're working with the right name. We don't
		// want to modify the value if it is a CSS custom property
		// since they are user-defined.
		if ( !isCustomProp ) {
			name = finalPropName( origName );
		}

		// Try prefixed name followed by the unprefixed name
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// If a hook was provided get the computed value from there
		if ( hooks && "get" in hooks ) {
			val = hooks.get( elem, true, extra );
		}

		// Otherwise, if a way to get the computed value exists, use that
		if ( val === undefined ) {
			val = curCSS( elem, name, styles );
		}

		// Convert "normal" to computed value
		if ( val === "normal" && name in cssNormalTransform ) {
			val = cssNormalTransform[ name ];
		}

		// Make numeric if forced or a qualifier was provided and val looks numeric
		if ( extra === "" || extra ) {
			num = parseFloat( val );
			return extra === true || isFinite( num ) ? num || 0 : val;
		}

		return val;
	}
} );

jQuery.each( [ "height", "width" ], function( _i, dimension ) {
	jQuery.cssHooks[ dimension ] = {
		get: function( elem, computed, extra ) {
			if ( computed ) {

				// Certain elements can have dimension info if we invisibly show them
				// but it must have a current display style that would benefit
				return rdisplayswap.test( jQuery.css( elem, "display" ) ) &&

					// Support: Safari 8+
					// Table columns in Safari have non-zero offsetWidth & zero
					// getBoundingClientRect().width unless display is changed.
					// Support: IE <=11 only
					// Running getBoundingClientRect on a disconnected node
					// in IE throws an error.
					( !elem.getClientRects().length || !elem.getBoundingClientRect().width ) ?
						swap( elem, cssShow, function() {
							return getWidthOrHeight( elem, dimension, extra );
						} ) :
						getWidthOrHeight( elem, dimension, extra );
			}
		},

		set: function( elem, value, extra ) {
			var matches,
				styles = getStyles( elem ),

				// Only read styles.position if the test has a chance to fail
				// to avoid forcing a reflow.
				scrollboxSizeBuggy = !support.scrollboxSize() &&
					styles.position === "absolute",

				// To avoid forcing a reflow, only fetch boxSizing if we need it (gh-3991)
				boxSizingNeeded = scrollboxSizeBuggy || extra,
				isBorderBox = boxSizingNeeded &&
					jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
				subtract = extra ?
					boxModelAdjustment(
						elem,
						dimension,
						extra,
						isBorderBox,
						styles
					) :
					0;

			// Account for unreliable border-box dimensions by comparing offset* to computed and
			// faking a content-box to get border and padding (gh-3699)
			if ( isBorderBox && scrollboxSizeBuggy ) {
				subtract -= Math.ceil(
					elem[ "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -
					parseFloat( styles[ dimension ] ) -
					boxModelAdjustment( elem, dimension, "border", false, styles ) -
					0.5
				);
			}

			// Convert to pixels if value adjustment is needed
			if ( subtract && ( matches = rcssNum.exec( value ) ) &&
				( matches[ 3 ] || "px" ) !== "px" ) {

				elem.style[ dimension ] = value;
				value = jQuery.css( elem, dimension );
			}

			return setPositiveNumber( elem, value, subtract );
		}
	};
} );

jQuery.cssHooks.marginLeft = addGetHookIf( support.reliableMarginLeft,
	function( elem, computed ) {
		if ( computed ) {
			return ( parseFloat( curCSS( elem, "marginLeft" ) ) ||
				elem.getBoundingClientRect().left -
					swap( elem, { marginLeft: 0 }, function() {
						return elem.getBoundingClientRect().left;
					} )
				) + "px";
		}
	}
);

// These hooks are used by animate to expand properties
jQuery.each( {
	margin: "",
	padding: "",
	border: "Width"
}, function( prefix, suffix ) {
	jQuery.cssHooks[ prefix + suffix ] = {
		expand: function( value ) {
			var i = 0,
				expanded = {},

				// Assumes a single number if not a string
				parts = typeof value === "string" ? value.split( " " ) : [ value ];

			for ( ; i < 4; i++ ) {
				expanded[ prefix + cssExpand[ i ] + suffix ] =
					parts[ i ] || parts[ i - 2 ] || parts[ 0 ];
			}

			return expanded;
		}
	};

	if ( prefix !== "margin" ) {
		jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;
	}
} );

jQuery.fn.extend( {
	css: function( name, value ) {
		return access( this, function( elem, name, value ) {
			var styles, len,
				map = {},
				i = 0;

			if ( Array.isArray( name ) ) {
				styles = getStyles( elem );
				len = name.length;

				for ( ; i < len; i++ ) {
					map[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );
				}

				return map;
			}

			return value !== undefined ?
				jQuery.style( elem, name, value ) :
				jQuery.css( elem, name );
		}, name, value, arguments.length > 1 );
	}
} );


function Tween( elem, options, prop, end, easing ) {
	return new Tween.prototype.init( elem, options, prop, end, easing );
}
jQuery.Tween = Tween;

Tween.prototype = {
	constructor: Tween,
	init: function( elem, options, prop, end, easing, unit ) {
		this.elem = elem;
		this.prop = prop;
		this.easing = easing || jQuery.easing._default;
		this.options = options;
		this.start = this.now = this.cur();
		this.end = end;
		this.unit = unit || ( jQuery.cssNumber[ prop ] ? "" : "px" );
	},
	cur: function() {
		var hooks = Tween.propHooks[ this.prop ];

		return hooks && hooks.get ?
			hooks.get( this ) :
			Tween.propHooks._default.get( this );
	},
	run: function( percent ) {
		var eased,
			hooks = Tween.propHooks[ this.prop ];

		if ( this.options.duration ) {
			this.pos = eased = jQuery.easing[ this.easing ](
				percent, this.options.duration * percent, 0, 1, this.options.duration
			);
		} else {
			this.pos = eased = percent;
		}
		this.now = ( this.end - this.start ) * eased + this.start;

		if ( this.options.step ) {
			this.options.step.call( this.elem, this.now, this );
		}

		if ( hooks && hooks.set ) {
			hooks.set( this );
		} else {
			Tween.propHooks._default.set( this );
		}
		return this;
	}
};

Tween.prototype.init.prototype = Tween.prototype;

Tween.propHooks = {
	_default: {
		get: function( tween ) {
			var result;

			// Use a property on the element directly when it is not a DOM element,
			// or when there is no matching style property that exists.
			if ( tween.elem.nodeType !== 1 ||
				tween.elem[ tween.prop ] != null && tween.elem.style[ tween.prop ] == null ) {
				return tween.elem[ tween.prop ];
			}

			// Passing an empty string as a 3rd parameter to .css will automatically
			// attempt a parseFloat and fallback to a string if the parse fails.
			// Simple values such as "10px" are parsed to Float;
			// complex values such as "rotate(1rad)" are returned as-is.
			result = jQuery.css( tween.elem, tween.prop, "" );

			// Empty strings, null, undefined and "auto" are converted to 0.
			return !result || result === "auto" ? 0 : result;
		},
		set: function( tween ) {

			// Use step hook for back compat.
			// Use cssHook if its there.
			// Use .style if available and use plain properties where available.
			if ( jQuery.fx.step[ tween.prop ] ) {
				jQuery.fx.step[ tween.prop ]( tween );
			} else if ( tween.elem.nodeType === 1 && (
					jQuery.cssHooks[ tween.prop ] ||
					tween.elem.style[ finalPropName( tween.prop ) ] != null ) ) {
				jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );
			} else {
				tween.elem[ tween.prop ] = tween.now;
			}
		}
	}
};

// Support: IE <=9 only
// Panic based approach to setting things on disconnected nodes
Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
	set: function( tween ) {
		if ( tween.elem.nodeType && tween.elem.parentNode ) {
			tween.elem[ tween.prop ] = tween.now;
		}
	}
};

jQuery.easing = {
	linear: function( p ) {
		return p;
	},
	swing: function( p ) {
		return 0.5 - Math.cos( p * Math.PI ) / 2;
	},
	_default: "swing"
};

jQuery.fx = Tween.prototype.init;

// Back compat <1.8 extension point
jQuery.fx.step = {};




var
	fxNow, inProgress,
	rfxtypes = /^(?:toggle|show|hide)$/,
	rrun = /queueHooks$/;

function schedule() {
	if ( inProgress ) {
		if ( document.hidden === false && window.requestAnimationFrame ) {
			window.requestAnimationFrame( schedule );
		} else {
			window.setTimeout( schedule, jQuery.fx.interval );
		}

		jQuery.fx.tick();
	}
}

// Animations created synchronously will run synchronously
function createFxNow() {
	window.setTimeout( function() {
		fxNow = undefined;
	} );
	return ( fxNow = Date.now() );
}

// Generate parameters to create a standard animation
function genFx( type, includeWidth ) {
	var which,
		i = 0,
		attrs = { height: type };

	// If we include width, step value is 1 to do all cssExpand values,
	// otherwise step value is 2 to skip over Left and Right
	includeWidth = includeWidth ? 1 : 0;
	for ( ; i < 4; i += 2 - includeWidth ) {
		which = cssExpand[ i ];
		attrs[ "margin" + which ] = attrs[ "padding" + which ] = type;
	}

	if ( includeWidth ) {
		attrs.opacity = attrs.width = type;
	}

	return attrs;
}

function createTween( value, prop, animation ) {
	var tween,
		collection = ( Animation.tweeners[ prop ] || [] ).concat( Animation.tweeners[ "*" ] ),
		index = 0,
		length = collection.length;
	for ( ; index < length; index++ ) {
		if ( ( tween = collection[ index ].call( animation, prop, value ) ) ) {

			// We're done with this property
			return tween;
		}
	}
}

function defaultPrefilter( elem, props, opts ) {
	var prop, value, toggle, hooks, oldfire, propTween, restoreDisplay, display,
		isBox = "width" in props || "height" in props,
		anim = this,
		orig = {},
		style = elem.style,
		hidden = elem.nodeType && isHiddenWithinTree( elem ),
		dataShow = dataPriv.get( elem, "fxshow" );

	// Queue-skipping animations hijack the fx hooks
	if ( !opts.queue ) {
		hooks = jQuery._queueHooks( elem, "fx" );
		if ( hooks.unqueued == null ) {
			hooks.unqueued = 0;
			oldfire = hooks.empty.fire;
			hooks.empty.fire = function() {
				if ( !hooks.unqueued ) {
					oldfire();
				}
			};
		}
		hooks.unqueued++;

		anim.always( function() {

			// Ensure the complete handler is called before this completes
			anim.always( function() {
				hooks.unqueued--;
				if ( !jQuery.queue( elem, "fx" ).length ) {
					hooks.empty.fire();
				}
			} );
		} );
	}

	// Detect show/hide animations
	for ( prop in props ) {
		value = props[ prop ];
		if ( rfxtypes.test( value ) ) {
			delete props[ prop ];
			toggle = toggle || value === "toggle";
			if ( value === ( hidden ? "hide" : "show" ) ) {

				// Pretend to be hidden if this is a "show" and
				// there is still data from a stopped show/hide
				if ( value === "show" && dataShow && dataShow[ prop ] !== undefined ) {
					hidden = true;

				// Ignore all other no-op show/hide data
				} else {
					continue;
				}
			}
			orig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );
		}
	}

	// Bail out if this is a no-op like .hide().hide()
	propTween = !jQuery.isEmptyObject( props );
	if ( !propTween && jQuery.isEmptyObject( orig ) ) {
		return;
	}

	// Restrict "overflow" and "display" styles during box animations
	if ( isBox && elem.nodeType === 1 ) {

		// Support: IE <=9 - 11, Edge 12 - 15
		// Record all 3 overflow attributes because IE does not infer the shorthand
		// from identically-valued overflowX and overflowY and Edge just mirrors
		// the overflowX value there.
		opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];

		// Identify a display type, preferring old show/hide data over the CSS cascade
		restoreDisplay = dataShow && dataShow.display;
		if ( restoreDisplay == null ) {
			restoreDisplay = dataPriv.get( elem, "display" );
		}
		display = jQuery.css( elem, "display" );
		if ( display === "none" ) {
			if ( restoreDisplay ) {
				display = restoreDisplay;
			} else {

				// Get nonempty value(s) by temporarily forcing visibility
				showHide( [ elem ], true );
				restoreDisplay = elem.style.display || restoreDisplay;
				display = jQuery.css( elem, "display" );
				showHide( [ elem ] );
			}
		}

		// Animate inline elements as inline-block
		if ( display === "inline" || display === "inline-block" && restoreDisplay != null ) {
			if ( jQuery.css( elem, "float" ) === "none" ) {

				// Restore the original display value at the end of pure show/hide animations
				if ( !propTween ) {
					anim.done( function() {
						style.display = restoreDisplay;
					} );
					if ( restoreDisplay == null ) {
						display = style.display;
						restoreDisplay = display === "none" ? "" : display;
					}
				}
				style.display = "inline-block";
			}
		}
	}

	if ( opts.overflow ) {
		style.overflow = "hidden";
		anim.always( function() {
			style.overflow = opts.overflow[ 0 ];
			style.overflowX = opts.overflow[ 1 ];
			style.overflowY = opts.overflow[ 2 ];
		} );
	}

	// Implement show/hide animations
	propTween = false;
	for ( prop in orig ) {

		// General show/hide setup for this element animation
		if ( !propTween ) {
			if ( dataShow ) {
				if ( "hidden" in dataShow ) {
					hidden = dataShow.hidden;
				}
			} else {
				dataShow = dataPriv.access( elem, "fxshow", { display: restoreDisplay } );
			}

			// Store hidden/visible for toggle so `.stop().toggle()` "reverses"
			if ( toggle ) {
				dataShow.hidden = !hidden;
			}

			// Show elements before animating them
			if ( hidden ) {
				showHide( [ elem ], true );
			}

			/* eslint-disable no-loop-func */

			anim.done( function() {

			/* eslint-enable no-loop-func */

				// The final step of a "hide" animation is actually hiding the element
				if ( !hidden ) {
					showHide( [ elem ] );
				}
				dataPriv.remove( elem, "fxshow" );
				for ( prop in orig ) {
					jQuery.style( elem, prop, orig[ prop ] );
				}
			} );
		}

		// Per-property setup
		propTween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );
		if ( !( prop in dataShow ) ) {
			dataShow[ prop ] = propTween.start;
			if ( hidden ) {
				propTween.end = propTween.start;
				propTween.start = 0;
			}
		}
	}
}

function propFilter( props, specialEasing ) {
	var index, name, easing, value, hooks;

	// camelCase, specialEasing and expand cssHook pass
	for ( index in props ) {
		name = camelCase( index );
		easing = specialEasing[ name ];
		value = props[ index ];
		if ( Array.isArray( value ) ) {
			easing = value[ 1 ];
			value = props[ index ] = value[ 0 ];
		}

		if ( index !== name ) {
			props[ name ] = value;
			delete props[ index ];
		}

		hooks = jQuery.cssHooks[ name ];
		if ( hooks && "expand" in hooks ) {
			value = hooks.expand( value );
			delete props[ name ];

			// Not quite $.extend, this won't overwrite existing keys.
			// Reusing 'index' because we have the correct "name"
			for ( index in value ) {
				if ( !( index in props ) ) {
					props[ index ] = value[ index ];
					specialEasing[ index ] = easing;
				}
			}
		} else {
			specialEasing[ name ] = easing;
		}
	}
}

function Animation( elem, properties, options ) {
	var result,
		stopped,
		index = 0,
		length = Animation.prefilters.length,
		deferred = jQuery.Deferred().always( function() {

			// Don't match elem in the :animated selector
			delete tick.elem;
		} ),
		tick = function() {
			if ( stopped ) {
				return false;
			}
			var currentTime = fxNow || createFxNow(),
				remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),

				// Support: Android 2.3 only
				// Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (#12497)
				temp = remaining / animation.duration || 0,
				percent = 1 - temp,
				index = 0,
				length = animation.tweens.length;

			for ( ; index < length; index++ ) {
				animation.tweens[ index ].run( percent );
			}

			deferred.notifyWith( elem, [ animation, percent, remaining ] );

			// If there's more to do, yield
			if ( percent < 1 && length ) {
				return remaining;
			}

			// If this was an empty animation, synthesize a final progress notification
			if ( !length ) {
				deferred.notifyWith( elem, [ animation, 1, 0 ] );
			}

			// Resolve the animation and report its conclusion
			deferred.resolveWith( elem, [ animation ] );
			return false;
		},
		animation = deferred.promise( {
			elem: elem,
			props: jQuery.extend( {}, properties ),
			opts: jQuery.extend( true, {
				specialEasing: {},
				easing: jQuery.easing._default
			}, options ),
			originalProperties: properties,
			originalOptions: options,
			startTime: fxNow || createFxNow(),
			duration: options.duration,
			tweens: [],
			createTween: function( prop, end ) {
				var tween = jQuery.Tween( elem, animation.opts, prop, end,
						animation.opts.specialEasing[ prop ] || animation.opts.easing );
				animation.tweens.push( tween );
				return tween;
			},
			stop: function( gotoEnd ) {
				var index = 0,

					// If we are going to the end, we want to run all the tweens
					// otherwise we skip this part
					length = gotoEnd ? animation.tweens.length : 0;
				if ( stopped ) {
					return this;
				}
				stopped = true;
				for ( ; index < length; index++ ) {
					animation.tweens[ index ].run( 1 );
				}

				// Resolve when we played the last frame; otherwise, reject
				if ( gotoEnd ) {
					deferred.notifyWith( elem, [ animation, 1, 0 ] );
					deferred.resolveWith( elem, [ animation, gotoEnd ] );
				} else {
					deferred.rejectWith( elem, [ animation, gotoEnd ] );
				}
				return this;
			}
		} ),
		props = animation.props;

	propFilter( props, animation.opts.specialEasing );

	for ( ; index < length; index++ ) {
		result = Animation.prefilters[ index ].call( animation, elem, props, animation.opts );
		if ( result ) {
			if ( isFunction( result.stop ) ) {
				jQuery._queueHooks( animation.elem, animation.opts.queue ).stop =
					result.stop.bind( result );
			}
			return result;
		}
	}

	jQuery.map( props, createTween, animation );

	if ( isFunction( animation.opts.start ) ) {
		animation.opts.start.call( elem, animation );
	}

	// Attach callbacks from options
	animation
		.progress( animation.opts.progress )
		.done( animation.opts.done, animation.opts.complete )
		.fail( animation.opts.fail )
		.always( animation.opts.always );

	jQuery.fx.timer(
		jQuery.extend( tick, {
			elem: elem,
			anim: animation,
			queue: animation.opts.queue
		} )
	);

	return animation;
}

jQuery.Animation = jQuery.extend( Animation, {

	tweeners: {
		"*": [ function( prop, value ) {
			var tween = this.createTween( prop, value );
			adjustCSS( tween.elem, prop, rcssNum.exec( value ), tween );
			return tween;
		} ]
	},

	tweener: function( props, callback ) {
		if ( isFunction( props ) ) {
			callback = props;
			props = [ "*" ];
		} else {
			props = props.match( rnothtmlwhite );
		}

		var prop,
			index = 0,
			length = props.length;

		for ( ; index < length; index++ ) {
			prop = props[ index ];
			Animation.tweeners[ prop ] = Animation.tweeners[ prop ] || [];
			Animation.tweeners[ prop ].unshift( callback );
		}
	},

	prefilters: [ defaultPrefilter ],

	prefilter: function( callback, prepend ) {
		if ( prepend ) {
			Animation.prefilters.unshift( callback );
		} else {
			Animation.prefilters.push( callback );
		}
	}
} );

jQuery.speed = function( speed, easing, fn ) {
	var opt = speed && typeof speed === "object" ? jQuery.extend( {}, speed ) : {
		complete: fn || !fn && easing ||
			isFunction( speed ) && speed,
		duration: speed,
		easing: fn && easing || easing && !isFunction( easing ) && easing
	};

	// Go to the end state if fx are off
	if ( jQuery.fx.off ) {
		opt.duration = 0;

	} else {
		if ( typeof opt.duration !== "number" ) {
			if ( opt.duration in jQuery.fx.speeds ) {
				opt.duration = jQuery.fx.speeds[ opt.duration ];

			} else {
				opt.duration = jQuery.fx.speeds._default;
			}
		}
	}

	// Normalize opt.queue - true/undefined/null -> "fx"
	if ( opt.queue == null || opt.queue === true ) {
		opt.queue = "fx";
	}

	// Queueing
	opt.old = opt.complete;

	opt.complete = function() {
		if ( isFunction( opt.old ) ) {
			opt.old.call( this );
		}

		if ( opt.queue ) {
			jQuery.dequeue( this, opt.queue );
		}
	};

	return opt;
};

jQuery.fn.extend( {
	fadeTo: function( speed, to, easing, callback ) {

		// Show any hidden elements after setting opacity to 0
		return this.filter( isHiddenWithinTree ).css( "opacity", 0 ).show()

			// Animate to the value specified
			.end().animate( { opacity: to }, speed, easing, callback );
	},
	animate: function( prop, speed, easing, callback ) {
		var empty = jQuery.isEmptyObject( prop ),
			optall = jQuery.speed( speed, easing, callback ),
			doAnimation = function() {

				// Operate on a copy of prop so per-property easing won't be lost
				var anim = Animation( this, jQuery.extend( {}, prop ), optall );

				// Empty animations, or finishing resolves immediately
				if ( empty || dataPriv.get( this, "finish" ) ) {
					anim.stop( true );
				}
			};
			doAnimation.finish = doAnimation;

		return empty || optall.queue === false ?
			this.each( doAnimation ) :
			this.queue( optall.queue, doAnimation );
	},
	stop: function( type, clearQueue, gotoEnd ) {
		var stopQueue = function( hooks ) {
			var stop = hooks.stop;
			delete hooks.stop;
			stop( gotoEnd );
		};

		if ( typeof type !== "string" ) {
			gotoEnd = clearQueue;
			clearQueue = type;
			type = undefined;
		}
		if ( clearQueue ) {
			this.queue( type || "fx", [] );
		}

		return this.each( function() {
			var dequeue = true,
				index = type != null && type + "queueHooks",
				timers = jQuery.timers,
				data = dataPriv.get( this );

			if ( index ) {
				if ( data[ index ] && data[ index ].stop ) {
					stopQueue( data[ index ] );
				}
			} else {
				for ( index in data ) {
					if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {
						stopQueue( data[ index ] );
					}
				}
			}

			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this &&
					( type == null || timers[ index ].queue === type ) ) {

					timers[ index ].anim.stop( gotoEnd );
					dequeue = false;
					timers.splice( index, 1 );
				}
			}

			// Start the next in the queue if the last step wasn't forced.
			// Timers currently will call their complete callbacks, which
			// will dequeue but only if they were gotoEnd.
			if ( dequeue || !gotoEnd ) {
				jQuery.dequeue( this, type );
			}
		} );
	},
	finish: function( type ) {
		if ( type !== false ) {
			type = type || "fx";
		}
		return this.each( function() {
			var index,
				data = dataPriv.get( this ),
				queue = data[ type + "queue" ],
				hooks = data[ type + "queueHooks" ],
				timers = jQuery.timers,
				length = queue ? queue.length : 0;

			// Enable finishing flag on private data
			data.finish = true;

			// Empty the queue first
			jQuery.queue( this, type, [] );

			if ( hooks && hooks.stop ) {
				hooks.stop.call( this, true );
			}

			// Look for any active animations, and finish them
			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this && timers[ index ].queue === type ) {
					timers[ index ].anim.stop( true );
					timers.splice( index, 1 );
				}
			}

			// Look for any animations in the old queue and finish them
			for ( index = 0; index < length; index++ ) {
				if ( queue[ index ] && queue[ index ].finish ) {
					queue[ index ].finish.call( this );
				}
			}

			// Turn off finishing flag
			delete data.finish;
		} );
	}
} );

jQuery.each( [ "toggle", "show", "hide" ], function( _i, name ) {
	var cssFn = jQuery.fn[ name ];
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return speed == null || typeof speed === "boolean" ?
			cssFn.apply( this, arguments ) :
			this.animate( genFx( name, true ), speed, easing, callback );
	};
} );

// Generate shortcuts for custom animations
jQuery.each( {
	slideDown: genFx( "show" ),
	slideUp: genFx( "hide" ),
	slideToggle: genFx( "toggle" ),
	fadeIn: { opacity: "show" },
	fadeOut: { opacity: "hide" },
	fadeToggle: { opacity: "toggle" }
}, function( name, props ) {
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return this.animate( props, speed, easing, callback );
	};
} );

jQuery.timers = [];
jQuery.fx.tick = function() {
	var timer,
		i = 0,
		timers = jQuery.timers;

	fxNow = Date.now();

	for ( ; i < timers.length; i++ ) {
		timer = timers[ i ];

		// Run the timer and safely remove it when done (allowing for external removal)
		if ( !timer() && timers[ i ] === timer ) {
			timers.splice( i--, 1 );
		}
	}

	if ( !timers.length ) {
		jQuery.fx.stop();
	}
	fxNow = undefined;
};

jQuery.fx.timer = function( timer ) {
	jQuery.timers.push( timer );
	jQuery.fx.start();
};

jQuery.fx.interval = 13;
jQuery.fx.start = function() {
	if ( inProgress ) {
		return;
	}

	inProgress = true;
	schedule();
};

jQuery.fx.stop = function() {
	inProgress = null;
};

jQuery.fx.speeds = {
	slow: 600,
	fast: 200,

	// Default speed
	_default: 400
};


// Based off of the plugin by Clint Helfers, with permission.
// https://web.archive.org/web/20100324014747/http://blindsignals.com/index.php/2009/07/jquery-delay/
jQuery.fn.delay = function( time, type ) {
	time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;
	type = type || "fx";

	return this.queue( type, function( next, hooks ) {
		var timeout = window.setTimeout( next, time );
		hooks.stop = function() {
			window.clearTimeout( timeout );
		};
	} );
};


( function() {
	var input = document.createElement( "input" ),
		select = document.createElement( "select" ),
		opt = select.appendChild( document.createElement( "option" ) );

	input.type = "checkbox";

	// Support: Android <=4.3 only
	// Default value for a checkbox should be "on"
	support.checkOn = input.value !== "";

	// Support: IE <=11 only
	// Must access selectedIndex to make default options select
	support.optSelected = opt.selected;

	// Support: IE <=11 only
	// An input loses its value after becoming a radio
	input = document.createElement( "input" );
	input.value = "t";
	input.type = "radio";
	support.radioValue = input.value === "t";
} )();


var boolHook,
	attrHandle = jQuery.expr.attrHandle;

jQuery.fn.extend( {
	attr: function( name, value ) {
		return access( this, jQuery.attr, name, value, arguments.length > 1 );
	},

	removeAttr: function( name ) {
		return this.each( function() {
			jQuery.removeAttr( this, name );
		} );
	}
} );

jQuery.extend( {
	attr: function( elem, name, value ) {
		var ret, hooks,
			nType = elem.nodeType;

		// Don't get/set attributes on text, comment and attribute nodes
		if ( nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		// Fallback to prop when attributes are not supported
		if ( typeof elem.getAttribute === "undefined" ) {
			return jQuery.prop( elem, name, value );
		}

		// Attribute hooks are determined by the lowercase version
		// Grab necessary hook if one is defined
		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {
			hooks = jQuery.attrHooks[ name.toLowerCase() ] ||
				( jQuery.expr.match.bool.test( name ) ? boolHook : undefined );
		}

		if ( value !== undefined ) {
			if ( value === null ) {
				jQuery.removeAttr( elem, name );
				return;
			}

			if ( hooks && "set" in hooks &&
				( ret = hooks.set( elem, value, name ) ) !== undefined ) {
				return ret;
			}

			elem.setAttribute( name, value + "" );
			return value;
		}

		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
			return ret;
		}

		ret = jQuery.find.attr( elem, name );

		// Non-existent attributes return null, we normalize to undefined
		return ret == null ? undefined : ret;
	},

	attrHooks: {
		type: {
			set: function( elem, value ) {
				if ( !support.radioValue && value === "radio" &&
					nodeName( elem, "input" ) ) {
					var val = elem.value;
					elem.setAttribute( "type", value );
					if ( val ) {
						elem.value = val;
					}
					return value;
				}
			}
		}
	},

	removeAttr: function( elem, value ) {
		var name,
			i = 0,

			// Attribute names can contain non-HTML whitespace characters
			// https://html.spec.whatwg.org/multipage/syntax.html#attributes-2
			attrNames = value && value.match( rnothtmlwhite );

		if ( attrNames && elem.nodeType === 1 ) {
			while ( ( name = attrNames[ i++ ] ) ) {
				elem.removeAttribute( name );
			}
		}
	}
} );

// Hooks for boolean attributes
boolHook = {
	set: function( elem, value, name ) {
		if ( value === false ) {

			// Remove boolean attributes when set to false
			jQuery.removeAttr( elem, name );
		} else {
			elem.setAttribute( name, name );
		}
		return name;
	}
};

jQuery.each( jQuery.expr.match.bool.source.match( /\w+/g ), function( _i, name ) {
	var getter = attrHandle[ name ] || jQuery.find.attr;

	attrHandle[ name ] = function( elem, name, isXML ) {
		var ret, handle,
			lowercaseName = name.toLowerCase();

		if ( !isXML ) {

			// Avoid an infinite loop by temporarily removing this function from the getter
			handle = attrHandle[ lowercaseName ];
			attrHandle[ lowercaseName ] = ret;
			ret = getter( elem, name, isXML ) != null ?
				lowercaseName :
				null;
			attrHandle[ lowercaseName ] = handle;
		}
		return ret;
	};
} );




var rfocusable = /^(?:input|select|textarea|button)$/i,
	rclickable = /^(?:a|area)$/i;

jQuery.fn.extend( {
	prop: function( name, value ) {
		return access( this, jQuery.prop, name, value, arguments.length > 1 );
	},

	removeProp: function( name ) {
		return this.each( function() {
			delete this[ jQuery.propFix[ name ] || name ];
		} );
	}
} );

jQuery.extend( {
	prop: function( elem, name, value ) {
		var ret, hooks,
			nType = elem.nodeType;

		// Don't get/set properties on text, comment and attribute nodes
		if ( nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {

			// Fix name and attach hooks
			name = jQuery.propFix[ name ] || name;
			hooks = jQuery.propHooks[ name ];
		}

		if ( value !== undefined ) {
			if ( hooks && "set" in hooks &&
				( ret = hooks.set( elem, value, name ) ) !== undefined ) {
				return ret;
			}

			return ( elem[ name ] = value );
		}

		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
			return ret;
		}

		return elem[ name ];
	},

	propHooks: {
		tabIndex: {
			get: function( elem ) {

				// Support: IE <=9 - 11 only
				// elem.tabIndex doesn't always return the
				// correct value when it hasn't been explicitly set
				// https://web.archive.org/web/20141116233347/http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
				// Use proper attribute retrieval(#12072)
				var tabindex = jQuery.find.attr( elem, "tabindex" );

				if ( tabindex ) {
					return parseInt( tabindex, 10 );
				}

				if (
					rfocusable.test( elem.nodeName ) ||
					rclickable.test( elem.nodeName ) &&
					elem.href
				) {
					return 0;
				}

				return -1;
			}
		}
	},

	propFix: {
		"for": "htmlFor",
		"class": "className"
	}
} );

// Support: IE <=11 only
// Accessing the selectedIndex property
// forces the browser to respect setting selected
// on the option
// The getter ensures a default option is selected
// when in an optgroup
// eslint rule "no-unused-expressions" is disabled for this code
// since it considers such accessions noop
if ( !support.optSelected ) {
	jQuery.propHooks.selected = {
		get: function( elem ) {

			/* eslint no-unused-expressions: "off" */

			var parent = elem.parentNode;
			if ( parent && parent.parentNode ) {
				parent.parentNode.selectedIndex;
			}
			return null;
		},
		set: function( elem ) {

			/* eslint no-unused-expressions: "off" */

			var parent = elem.parentNode;
			if ( parent ) {
				parent.selectedIndex;

				if ( parent.parentNode ) {
					parent.parentNode.selectedIndex;
				}
			}
		}
	};
}

jQuery.each( [
	"tabIndex",
	"readOnly",
	"maxLength",
	"cellSpacing",
	"cellPadding",
	"rowSpan",
	"colSpan",
	"useMap",
	"frameBorder",
	"contentEditable"
], function() {
	jQuery.propFix[ this.toLowerCase() ] = this;
} );




	// Strip and collapse whitespace according to HTML spec
	// https://infra.spec.whatwg.org/#strip-and-collapse-ascii-whitespace
	function stripAndCollapse( value ) {
		var tokens = value.match( rnothtmlwhite ) || [];
		return tokens.join( " " );
	}


function getClass( elem ) {
	return elem.getAttribute && elem.getAttribute( "class" ) || "";
}

function classesToArray( value ) {
	if ( Array.isArray( value ) ) {
		return value;
	}
	if ( typeof value === "string" ) {
		return value.match( rnothtmlwhite ) || [];
	}
	return [];
}

jQuery.fn.extend( {
	addClass: function( value ) {
		var classes, elem, cur, curValue, clazz, j, finalValue,
			i = 0;

		if ( isFunction( value ) ) {
			return this.each( function( j ) {
				jQuery( this ).addClass( value.call( this, j, getClass( this ) ) );
			} );
		}

		classes = classesToArray( value );

		if ( classes.length ) {
			while ( ( elem = this[ i++ ] ) ) {
				curValue = getClass( elem );
				cur = elem.nodeType === 1 && ( " " + stripAndCollapse( curValue ) + " " );

				if ( cur ) {
					j = 0;
					while ( ( clazz = classes[ j++ ] ) ) {
						if ( cur.indexOf( " " + clazz + " " ) < 0 ) {
							cur += clazz + " ";
						}
					}

					// Only assign if different to avoid unneeded rendering.
					finalValue = stripAndCollapse( cur );
					if ( curValue !== finalValue ) {
						elem.setAttribute( "class", finalValue );
					}
				}
			}
		}

		return this;
	},

	removeClass: function( value ) {
		var classes, elem, cur, curValue, clazz, j, finalValue,
			i = 0;

		if ( isFunction( value ) ) {
			return this.each( function( j ) {
				jQuery( this ).removeClass( value.call( this, j, getClass( this ) ) );
			} );
		}

		if ( !arguments.length ) {
			return this.attr( "class", "" );
		}

		classes = classesToArray( value );

		if ( classes.length ) {
			while ( ( elem = this[ i++ ] ) ) {
				curValue = getClass( elem );

				// This expression is here for better compressibility (see addClass)
				cur = elem.nodeType === 1 && ( " " + stripAndCollapse( curValue ) + " " );

				if ( cur ) {
					j = 0;
					while ( ( clazz = classes[ j++ ] ) ) {

						// Remove *all* instances
						while ( cur.indexOf( " " + clazz + " " ) > -1 ) {
							cur = cur.replace( " " + clazz + " ", " " );
						}
					}

					// Only assign if different to avoid unneeded rendering.
					finalValue = stripAndCollapse( cur );
					if ( curValue !== finalValue ) {
						elem.setAttribute( "class", finalValue );
					}
				}
			}
		}

		return this;
	},

	toggleClass: function( value, stateVal ) {
		var type = typeof value,
			isValidValue = type === "string" || Array.isArray( value );

		if ( typeof stateVal === "boolean" && isValidValue ) {
			return stateVal ? this.addClass( value ) : this.removeClass( value );
		}

		if ( isFunction( value ) ) {
			return this.each( function( i ) {
				jQuery( this ).toggleClass(
					value.call( this, i, getClass( this ), stateVal ),
					stateVal
				);
			} );
		}

		return this.each( function() {
			var className, i, self, classNames;

			if ( isValidValue ) {

				// Toggle individual class names
				i = 0;
				self = jQuery( this );
				classNames = classesToArray( value );

				while ( ( className = classNames[ i++ ] ) ) {

					// Check each className given, space separated list
					if ( self.hasClass( className ) ) {
						self.removeClass( className );
					} else {
						self.addClass( className );
					}
				}

			// Toggle whole class name
			} else if ( value === undefined || type === "boolean" ) {
				className = getClass( this );
				if ( className ) {

					// Store className if set
					dataPriv.set( this, "__className__", className );
				}

				// If the element has a class name or if we're passed `false`,
				// then remove the whole classname (if there was one, the above saved it).
				// Otherwise bring back whatever was previously saved (if anything),
				// falling back to the empty string if nothing was stored.
				if ( this.setAttribute ) {
					this.setAttribute( "class",
						className || value === false ?
						"" :
						dataPriv.get( this, "__className__" ) || ""
					);
				}
			}
		} );
	},

	hasClass: function( selector ) {
		var className, elem,
			i = 0;

		className = " " + selector + " ";
		while ( ( elem = this[ i++ ] ) ) {
			if ( elem.nodeType === 1 &&
				( " " + stripAndCollapse( getClass( elem ) ) + " " ).indexOf( className ) > -1 ) {
					return true;
			}
		}

		return false;
	}
} );




var rreturn = /\r/g;

jQuery.fn.extend( {
	val: function( value ) {
		var hooks, ret, valueIsFunction,
			elem = this[ 0 ];

		if ( !arguments.length ) {
			if ( elem ) {
				hooks = jQuery.valHooks[ elem.type ] ||
					jQuery.valHooks[ elem.nodeName.toLowerCase() ];

				if ( hooks &&
					"get" in hooks &&
					( ret = hooks.get( elem, "value" ) ) !== undefined
				) {
					return ret;
				}

				ret = elem.value;

				// Handle most common string cases
				if ( typeof ret === "string" ) {
					return ret.replace( rreturn, "" );
				}

				// Handle cases where value is null/undef or number
				return ret == null ? "" : ret;
			}

			return;
		}

		valueIsFunction = isFunction( value );

		return this.each( function( i ) {
			var val;

			if ( this.nodeType !== 1 ) {
				return;
			}

			if ( valueIsFunction ) {
				val = value.call( this, i, jQuery( this ).val() );
			} else {
				val = value;
			}

			// Treat null/undefined as ""; convert numbers to string
			if ( val == null ) {
				val = "";

			} else if ( typeof val === "number" ) {
				val += "";

			} else if ( Array.isArray( val ) ) {
				val = jQuery.map( val, function( value ) {
					return value == null ? "" : value + "";
				} );
			}

			hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];

			// If set returns undefined, fall back to normal setting
			if ( !hooks || !( "set" in hooks ) || hooks.set( this, val, "value" ) === undefined ) {
				this.value = val;
			}
		} );
	}
} );

jQuery.extend( {
	valHooks: {
		option: {
			get: function( elem ) {

				var val = jQuery.find.attr( elem, "value" );
				return val != null ?
					val :

					// Support: IE <=10 - 11 only
					// option.text throws exceptions (#14686, #14858)
					// Strip and collapse whitespace
					// https://html.spec.whatwg.org/#strip-and-collapse-whitespace
					stripAndCollapse( jQuery.text( elem ) );
			}
		},
		select: {
			get: function( elem ) {
				var value, option, i,
					options = elem.options,
					index = elem.selectedIndex,
					one = elem.type === "select-one",
					values = one ? null : [],
					max = one ? index + 1 : options.length;

				if ( index < 0 ) {
					i = max;

				} else {
					i = one ? index : 0;
				}

				// Loop through all the selected options
				for ( ; i < max; i++ ) {
					option = options[ i ];

					// Support: IE <=9 only
					// IE8-9 doesn't update selected after form reset (#2551)
					if ( ( option.selected || i === index ) &&

							// Don't return options that are disabled or in a disabled optgroup
							!option.disabled &&
							( !option.parentNode.disabled ||
								!nodeName( option.parentNode, "optgroup" ) ) ) {

						// Get the specific value for the option
						value = jQuery( option ).val();

						// We don't need an array for one selects
						if ( one ) {
							return value;
						}

						// Multi-Selects return an array
						values.push( value );
					}
				}

				return values;
			},

			set: function( elem, value ) {
				var optionSet, option,
					options = elem.options,
					values = jQuery.makeArray( value ),
					i = options.length;

				while ( i-- ) {
					option = options[ i ];

					/* eslint-disable no-cond-assign */

					if ( option.selected =
						jQuery.inArray( jQuery.valHooks.option.get( option ), values ) > -1
					) {
						optionSet = true;
					}

					/* eslint-enable no-cond-assign */
				}

				// Force browsers to behave consistently when non-matching value is set
				if ( !optionSet ) {
					elem.selectedIndex = -1;
				}
				return values;
			}
		}
	}
} );

// Radios and checkboxes getter/setter
jQuery.each( [ "radio", "checkbox" ], function() {
	jQuery.valHooks[ this ] = {
		set: function( elem, value ) {
			if ( Array.isArray( value ) ) {
				return ( elem.checked = jQuery.inArray( jQuery( elem ).val(), value ) > -1 );
			}
		}
	};
	if ( !support.checkOn ) {
		jQuery.valHooks[ this ].get = function( elem ) {
			return elem.getAttribute( "value" ) === null ? "on" : elem.value;
		};
	}
} );




// Return jQuery for attributes-only inclusion


support.focusin = "onfocusin" in window;


var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,
	stopPropagationCallback = function( e ) {
		e.stopPropagation();
	};

jQuery.extend( jQuery.event, {

	trigger: function( event, data, elem, onlyHandlers ) {

		var i, cur, tmp, bubbleType, ontype, handle, special, lastElement,
			eventPath = [ elem || document ],
			type = hasOwn.call( event, "type" ) ? event.type : event,
			namespaces = hasOwn.call( event, "namespace" ) ? event.namespace.split( "." ) : [];

		cur = lastElement = tmp = elem = elem || document;

		// Don't do events on text and comment nodes
		if ( elem.nodeType === 3 || elem.nodeType === 8 ) {
			return;
		}

		// focus/blur morphs to focusin/out; ensure we're not firing them right now
		if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {
			return;
		}

		if ( type.indexOf( "." ) > -1 ) {

			// Namespaced trigger; create a regexp to match event type in handle()
			namespaces = type.split( "." );
			type = namespaces.shift();
			namespaces.sort();
		}
		ontype = type.indexOf( ":" ) < 0 && "on" + type;

		// Caller can pass in a jQuery.Event object, Object, or just an event type string
		event = event[ jQuery.expando ] ?
			event :
			new jQuery.Event( type, typeof event === "object" && event );

		// Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)
		event.isTrigger = onlyHandlers ? 2 : 3;
		event.namespace = namespaces.join( "." );
		event.rnamespace = event.namespace ?
			new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" ) :
			null;

		// Clean up the event in case it is being reused
		event.result = undefined;
		if ( !event.target ) {
			event.target = elem;
		}

		// Clone any incoming data and prepend the event, creating the handler arg list
		data = data == null ?
			[ event ] :
			jQuery.makeArray( data, [ event ] );

		// Allow special events to draw outside the lines
		special = jQuery.event.special[ type ] || {};
		if ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {
			return;
		}

		// Determine event propagation path in advance, per W3C events spec (#9951)
		// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
		if ( !onlyHandlers && !special.noBubble && !isWindow( elem ) ) {

			bubbleType = special.delegateType || type;
			if ( !rfocusMorph.test( bubbleType + type ) ) {
				cur = cur.parentNode;
			}
			for ( ; cur; cur = cur.parentNode ) {
				eventPath.push( cur );
				tmp = cur;
			}

			// Only add window if we got to document (e.g., not plain obj or detached DOM)
			if ( tmp === ( elem.ownerDocument || document ) ) {
				eventPath.push( tmp.defaultView || tmp.parentWindow || window );
			}
		}

		// Fire handlers on the event path
		i = 0;
		while ( ( cur = eventPath[ i++ ] ) && !event.isPropagationStopped() ) {
			lastElement = cur;
			event.type = i > 1 ?
				bubbleType :
				special.bindType || type;

			// jQuery handler
			handle = (
					dataPriv.get( cur, "events" ) || Object.create( null )
				)[ event.type ] &&
				dataPriv.get( cur, "handle" );
			if ( handle ) {
				handle.apply( cur, data );
			}

			// Native handler
			handle = ontype && cur[ ontype ];
			if ( handle && handle.apply && acceptData( cur ) ) {
				event.result = handle.apply( cur, data );
				if ( event.result === false ) {
					event.preventDefault();
				}
			}
		}
		event.type = type;

		// If nobody prevented the default action, do it now
		if ( !onlyHandlers && !event.isDefaultPrevented() ) {

			if ( ( !special._default ||
				special._default.apply( eventPath.pop(), data ) === false ) &&
				acceptData( elem ) ) {

				// Call a native DOM method on the target with the same name as the event.
				// Don't do default actions on window, that's where global variables be (#6170)
				if ( ontype && isFunction( elem[ type ] ) && !isWindow( elem ) ) {

					// Don't re-trigger an onFOO event when we call its FOO() method
					tmp = elem[ ontype ];

					if ( tmp ) {
						elem[ ontype ] = null;
					}

					// Prevent re-triggering of the same event, since we already bubbled it above
					jQuery.event.triggered = type;

					if ( event.isPropagationStopped() ) {
						lastElement.addEventListener( type, stopPropagationCallback );
					}

					elem[ type ]();

					if ( event.isPropagationStopped() ) {
						lastElement.removeEventListener( type, stopPropagationCallback );
					}

					jQuery.event.triggered = undefined;

					if ( tmp ) {
						elem[ ontype ] = tmp;
					}
				}
			}
		}

		return event.result;
	},

	// Piggyback on a donor event to simulate a different one
	// Used only for `focus(in | out)` events
	simulate: function( type, elem, event ) {
		var e = jQuery.extend(
			new jQuery.Event(),
			event,
			{
				type: type,
				isSimulated: true
			}
		);

		jQuery.event.trigger( e, null, elem );
	}

} );

jQuery.fn.extend( {

	trigger: function( type, data ) {
		return this.each( function() {
			jQuery.event.trigger( type, data, this );
		} );
	},
	triggerHandler: function( type, data ) {
		var elem = this[ 0 ];
		if ( elem ) {
			return jQuery.event.trigger( type, data, elem, true );
		}
	}
} );


// Support: Firefox <=44
// Firefox doesn't have focus(in | out) events
// Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787
//
// Support: Chrome <=48 - 49, Safari <=9.0 - 9.1
// focus(in | out) events fire after focus & blur events,
// which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order
// Related ticket - https://bugs.chromium.org/p/chromium/issues/detail?id=449857
if ( !support.focusin ) {
	jQuery.each( { focus: "focusin", blur: "focusout" }, function( orig, fix ) {

		// Attach a single capturing handler on the document while someone wants focusin/focusout
		var handler = function( event ) {
			jQuery.event.simulate( fix, event.target, jQuery.event.fix( event ) );
		};

		jQuery.event.special[ fix ] = {
			setup: function() {

				// Handle: regular nodes (via `this.ownerDocument`), window
				// (via `this.document`) & document (via `this`).
				var doc = this.ownerDocument || this.document || this,
					attaches = dataPriv.access( doc, fix );

				if ( !attaches ) {
					doc.addEventListener( orig, handler, true );
				}
				dataPriv.access( doc, fix, ( attaches || 0 ) + 1 );
			},
			teardown: function() {
				var doc = this.ownerDocument || this.document || this,
					attaches = dataPriv.access( doc, fix ) - 1;

				if ( !attaches ) {
					doc.removeEventListener( orig, handler, true );
					dataPriv.remove( doc, fix );

				} else {
					dataPriv.access( doc, fix, attaches );
				}
			}
		};
	} );
}
var location = window.location;

var nonce = { guid: Date.now() };

var rquery = ( /\?/ );



// Cross-browser xml parsing
jQuery.parseXML = function( data ) {
	var xml;
	if ( !data || typeof data !== "string" ) {
		return null;
	}

	// Support: IE 9 - 11 only
	// IE throws on parseFromString with invalid input.
	try {
		xml = ( new window.DOMParser() ).parseFromString( data, "text/xml" );
	} catch ( e ) {
		xml = undefined;
	}

	if ( !xml || xml.getElementsByTagName( "parsererror" ).length ) {
		jQuery.error( "Invalid XML: " + data );
	}
	return xml;
};


var
	rbracket = /\[\]$/,
	rCRLF = /\r?\n/g,
	rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,
	rsubmittable = /^(?:input|select|textarea|keygen)/i;

function buildParams( prefix, obj, traditional, add ) {
	var name;

	if ( Array.isArray( obj ) ) {

		// Serialize array item.
		jQuery.each( obj, function( i, v ) {
			if ( traditional || rbracket.test( prefix ) ) {

				// Treat each array item as a scalar.
				add( prefix, v );

			} else {

				// Item is non-scalar (array or object), encode its numeric index.
				buildParams(
					prefix + "[" + ( typeof v === "object" && v != null ? i : "" ) + "]",
					v,
					traditional,
					add
				);
			}
		} );

	} else if ( !traditional && toType( obj ) === "object" ) {

		// Serialize object item.
		for ( name in obj ) {
			buildParams( prefix + "[" + name + "]", obj[ name ], traditional, add );
		}

	} else {

		// Serialize scalar item.
		add( prefix, obj );
	}
}

// Serialize an array of form elements or a set of
// key/values into a query string
jQuery.param = function( a, traditional ) {
	var prefix,
		s = [],
		add = function( key, valueOrFunction ) {

			// If value is a function, invoke it and use its return value
			var value = isFunction( valueOrFunction ) ?
				valueOrFunction() :
				valueOrFunction;

			s[ s.length ] = encodeURIComponent( key ) + "=" +
				encodeURIComponent( value == null ? "" : value );
		};

	if ( a == null ) {
		return "";
	}

	// If an array was passed in, assume that it is an array of form elements.
	if ( Array.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {

		// Serialize the form elements
		jQuery.each( a, function() {
			add( this.name, this.value );
		} );

	} else {

		// If traditional, encode the "old" way (the way 1.3.2 or older
		// did it), otherwise encode params recursively.
		for ( prefix in a ) {
			buildParams( prefix, a[ prefix ], traditional, add );
		}
	}

	// Return the resulting serialization
	return s.join( "&" );
};

jQuery.fn.extend( {
	serialize: function() {
		return jQuery.param( this.serializeArray() );
	},
	serializeArray: function() {
		return this.map( function() {

			// Can add propHook for "elements" to filter or add form elements
			var elements = jQuery.prop( this, "elements" );
			return elements ? jQuery.makeArray( elements ) : this;
		} )
		.filter( function() {
			var type = this.type;

			// Use .is( ":disabled" ) so that fieldset[disabled] works
			return this.name && !jQuery( this ).is( ":disabled" ) &&
				rsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&
				( this.checked || !rcheckableType.test( type ) );
		} )
		.map( function( _i, elem ) {
			var val = jQuery( this ).val();

			if ( val == null ) {
				return null;
			}

			if ( Array.isArray( val ) ) {
				return jQuery.map( val, function( val ) {
					return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
				} );
			}

			return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
		} ).get();
	}
} );


var
	r20 = /%20/g,
	rhash = /#.*$/,
	rantiCache = /([?&])_=[^&]*/,
	rheaders = /^(.*?):[ \t]*([^\r\n]*)$/mg,

	// #7653, #8125, #8152: local protocol detection
	rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,
	rnoContent = /^(?:GET|HEAD)$/,
	rprotocol = /^\/\//,

	/* Prefilters
	 * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
	 * 2) These are called:
	 *    - BEFORE asking for a transport
	 *    - AFTER param serialization (s.data is a string if s.processData is true)
	 * 3) key is the dataType
	 * 4) the catchall symbol "*" can be used
	 * 5) execution will start with transport dataType and THEN continue down to "*" if needed
	 */
	prefilters = {},

	/* Transports bindings
	 * 1) key is the dataType
	 * 2) the catchall symbol "*" can be used
	 * 3) selection will start with transport dataType and THEN go to "*" if needed
	 */
	transports = {},

	// Avoid comment-prolog char sequence (#10098); must appease lint and evade compression
	allTypes = "*/".concat( "*" ),

	// Anchor tag for parsing the document origin
	originAnchor = document.createElement( "a" );
	originAnchor.href = location.href;

// Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
function addToPrefiltersOrTransports( structure ) {

	// dataTypeExpression is optional and defaults to "*"
	return function( dataTypeExpression, func ) {

		if ( typeof dataTypeExpression !== "string" ) {
			func = dataTypeExpression;
			dataTypeExpression = "*";
		}

		var dataType,
			i = 0,
			dataTypes = dataTypeExpression.toLowerCase().match( rnothtmlwhite ) || [];

		if ( isFunction( func ) ) {

			// For each dataType in the dataTypeExpression
			while ( ( dataType = dataTypes[ i++ ] ) ) {

				// Prepend if requested
				if ( dataType[ 0 ] === "+" ) {
					dataType = dataType.slice( 1 ) || "*";
					( structure[ dataType ] = structure[ dataType ] || [] ).unshift( func );

				// Otherwise append
				} else {
					( structure[ dataType ] = structure[ dataType ] || [] ).push( func );
				}
			}
		}
	};
}

// Base inspection function for prefilters and transports
function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {

	var inspected = {},
		seekingTransport = ( structure === transports );

	function inspect( dataType ) {
		var selected;
		inspected[ dataType ] = true;
		jQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {
			var dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );
			if ( typeof dataTypeOrTransport === "string" &&
				!seekingTransport && !inspected[ dataTypeOrTransport ] ) {

				options.dataTypes.unshift( dataTypeOrTransport );
				inspect( dataTypeOrTransport );
				return false;
			} else if ( seekingTransport ) {
				return !( selected = dataTypeOrTransport );
			}
		} );
		return selected;
	}

	return inspect( options.dataTypes[ 0 ] ) || !inspected[ "*" ] && inspect( "*" );
}

// A special extend for ajax options
// that takes "flat" options (not to be deep extended)
// Fixes #9887
function ajaxExtend( target, src ) {
	var key, deep,
		flatOptions = jQuery.ajaxSettings.flatOptions || {};

	for ( key in src ) {
		if ( src[ key ] !== undefined ) {
			( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];
		}
	}
	if ( deep ) {
		jQuery.extend( true, target, deep );
	}

	return target;
}

/* Handles responses to an ajax request:
 * - finds the right dataType (mediates between content-type and expected dataType)
 * - returns the corresponding response
 */
function ajaxHandleResponses( s, jqXHR, responses ) {

	var ct, type, finalDataType, firstDataType,
		contents = s.contents,
		dataTypes = s.dataTypes;

	// Remove auto dataType and get content-type in the process
	while ( dataTypes[ 0 ] === "*" ) {
		dataTypes.shift();
		if ( ct === undefined ) {
			ct = s.mimeType || jqXHR.getResponseHeader( "Content-Type" );
		}
	}

	// Check if we're dealing with a known content-type
	if ( ct ) {
		for ( type in contents ) {
			if ( contents[ type ] && contents[ type ].test( ct ) ) {
				dataTypes.unshift( type );
				break;
			}
		}
	}

	// Check to see if we have a response for the expected dataType
	if ( dataTypes[ 0 ] in responses ) {
		finalDataType = dataTypes[ 0 ];
	} else {

		// Try convertible dataTypes
		for ( type in responses ) {
			if ( !dataTypes[ 0 ] || s.converters[ type + " " + dataTypes[ 0 ] ] ) {
				finalDataType = type;
				break;
			}
			if ( !firstDataType ) {
				firstDataType = type;
			}
		}

		// Or just use first one
		finalDataType = finalDataType || firstDataType;
	}

	// If we found a dataType
	// We add the dataType to the list if needed
	// and return the corresponding response
	if ( finalDataType ) {
		if ( finalDataType !== dataTypes[ 0 ] ) {
			dataTypes.unshift( finalDataType );
		}
		return responses[ finalDataType ];
	}
}

/* Chain conversions given the request and the original response
 * Also sets the responseXXX fields on the jqXHR instance
 */
function ajaxConvert( s, response, jqXHR, isSuccess ) {
	var conv2, current, conv, tmp, prev,
		converters = {},

		// Work with a copy of dataTypes in case we need to modify it for conversion
		dataTypes = s.dataTypes.slice();

	// Create converters map with lowercased keys
	if ( dataTypes[ 1 ] ) {
		for ( conv in s.converters ) {
			converters[ conv.toLowerCase() ] = s.converters[ conv ];
		}
	}

	current = dataTypes.shift();

	// Convert to each sequential dataType
	while ( current ) {

		if ( s.responseFields[ current ] ) {
			jqXHR[ s.responseFields[ current ] ] = response;
		}

		// Apply the dataFilter if provided
		if ( !prev && isSuccess && s.dataFilter ) {
			response = s.dataFilter( response, s.dataType );
		}

		prev = current;
		current = dataTypes.shift();

		if ( current ) {

			// There's only work to do if current dataType is non-auto
			if ( current === "*" ) {

				current = prev;

			// Convert response if prev dataType is non-auto and differs from current
			} else if ( prev !== "*" && prev !== current ) {

				// Seek a direct converter
				conv = converters[ prev + " " + current ] || converters[ "* " + current ];

				// If none found, seek a pair
				if ( !conv ) {
					for ( conv2 in converters ) {

						// If conv2 outputs current
						tmp = conv2.split( " " );
						if ( tmp[ 1 ] === current ) {

							// If prev can be converted to accepted input
							conv = converters[ prev + " " + tmp[ 0 ] ] ||
								converters[ "* " + tmp[ 0 ] ];
							if ( conv ) {

								// Condense equivalence converters
								if ( conv === true ) {
									conv = converters[ conv2 ];

								// Otherwise, insert the intermediate dataType
								} else if ( converters[ conv2 ] !== true ) {
									current = tmp[ 0 ];
									dataTypes.unshift( tmp[ 1 ] );
								}
								break;
							}
						}
					}
				}

				// Apply converter (if not an equivalence)
				if ( conv !== true ) {

					// Unless errors are allowed to bubble, catch and return them
					if ( conv && s.throws ) {
						response = conv( response );
					} else {
						try {
							response = conv( response );
						} catch ( e ) {
							return {
								state: "parsererror",
								error: conv ? e : "No conversion from " + prev + " to " + current
							};
						}
					}
				}
			}
		}
	}

	return { state: "success", data: response };
}

jQuery.extend( {

	// Counter for holding the number of active queries
	active: 0,

	// Last-Modified header cache for next request
	lastModified: {},
	etag: {},

	ajaxSettings: {
		url: location.href,
		type: "GET",
		isLocal: rlocalProtocol.test( location.protocol ),
		global: true,
		processData: true,
		async: true,
		contentType: "application/x-www-form-urlencoded; charset=UTF-8",

		/*
		timeout: 0,
		data: null,
		dataType: null,
		username: null,
		password: null,
		cache: null,
		throws: false,
		traditional: false,
		headers: {},
		*/

		accepts: {
			"*": allTypes,
			text: "text/plain",
			html: "text/html",
			xml: "application/xml, text/xml",
			json: "application/json, text/javascript"
		},

		contents: {
			xml: /\bxml\b/,
			html: /\bhtml/,
			json: /\bjson\b/
		},

		responseFields: {
			xml: "responseXML",
			text: "responseText",
			json: "responseJSON"
		},

		// Data converters
		// Keys separate source (or catchall "*") and destination types with a single space
		converters: {

			// Convert anything to text
			"* text": String,

			// Text to html (true = no transformation)
			"text html": true,

			// Evaluate text as a json expression
			"text json": JSON.parse,

			// Parse text as xml
			"text xml": jQuery.parseXML
		},

		// For options that shouldn't be deep extended:
		// you can add your own custom options here if
		// and when you create one that shouldn't be
		// deep extended (see ajaxExtend)
		flatOptions: {
			url: true,
			context: true
		}
	},

	// Creates a full fledged settings object into target
	// with both ajaxSettings and settings fields.
	// If target is omitted, writes into ajaxSettings.
	ajaxSetup: function( target, settings ) {
		return settings ?

			// Building a settings object
			ajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :

			// Extending ajaxSettings
			ajaxExtend( jQuery.ajaxSettings, target );
	},

	ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),
	ajaxTransport: addToPrefiltersOrTransports( transports ),

	// Main method
	ajax: function( url, options ) {

		// If url is an object, simulate pre-1.5 signature
		if ( typeof url === "object" ) {
			options = url;
			url = undefined;
		}

		// Force options to be an object
		options = options || {};

		var transport,

			// URL without anti-cache param
			cacheURL,

			// Response headers
			responseHeadersString,
			responseHeaders,

			// timeout handle
			timeoutTimer,

			// Url cleanup var
			urlAnchor,

			// Request state (becomes false upon send and true upon completion)
			completed,

			// To know if global events are to be dispatched
			fireGlobals,

			// Loop variable
			i,

			// uncached part of the url
			uncached,

			// Create the final options object
			s = jQuery.ajaxSetup( {}, options ),

			// Callbacks context
			callbackContext = s.context || s,

			// Context for global events is callbackContext if it is a DOM node or jQuery collection
			globalEventContext = s.context &&
				( callbackContext.nodeType || callbackContext.jquery ) ?
					jQuery( callbackContext ) :
					jQuery.event,

			// Deferreds
			deferred = jQuery.Deferred(),
			completeDeferred = jQuery.Callbacks( "once memory" ),

			// Status-dependent callbacks
			statusCode = s.statusCode || {},

			// Headers (they are sent all at once)
			requestHeaders = {},
			requestHeadersNames = {},

			// Default abort message
			strAbort = "canceled",

			// Fake xhr
			jqXHR = {
				readyState: 0,

				// Builds headers hashtable if needed
				getResponseHeader: function( key ) {
					var match;
					if ( completed ) {
						if ( !responseHeaders ) {
							responseHeaders = {};
							while ( ( match = rheaders.exec( responseHeadersString ) ) ) {
								responseHeaders[ match[ 1 ].toLowerCase() + " " ] =
									( responseHeaders[ match[ 1 ].toLowerCase() + " " ] || [] )
										.concat( match[ 2 ] );
							}
						}
						match = responseHeaders[ key.toLowerCase() + " " ];
					}
					return match == null ? null : match.join( ", " );
				},

				// Raw string
				getAllResponseHeaders: function() {
					return completed ? responseHeadersString : null;
				},

				// Caches the header
				setRequestHeader: function( name, value ) {
					if ( completed == null ) {
						name = requestHeadersNames[ name.toLowerCase() ] =
							requestHeadersNames[ name.toLowerCase() ] || name;
						requestHeaders[ name ] = value;
					}
					return this;
				},

				// Overrides response content-type header
				overrideMimeType: function( type ) {
					if ( completed == null ) {
						s.mimeType = type;
					}
					return this;
				},

				// Status-dependent callbacks
				statusCode: function( map ) {
					var code;
					if ( map ) {
						if ( completed ) {

							// Execute the appropriate callbacks
							jqXHR.always( map[ jqXHR.status ] );
						} else {

							// Lazy-add the new callbacks in a way that preserves old ones
							for ( code in map ) {
								statusCode[ code ] = [ statusCode[ code ], map[ code ] ];
							}
						}
					}
					return this;
				},

				// Cancel the request
				abort: function( statusText ) {
					var finalText = statusText || strAbort;
					if ( transport ) {
						transport.abort( finalText );
					}
					done( 0, finalText );
					return this;
				}
			};

		// Attach deferreds
		deferred.promise( jqXHR );

		// Add protocol if not provided (prefilters might expect it)
		// Handle falsy url in the settings object (#10093: consistency with old signature)
		// We also use the url parameter if available
		s.url = ( ( url || s.url || location.href ) + "" )
			.replace( rprotocol, location.protocol + "//" );

		// Alias method option to type as per ticket #12004
		s.type = options.method || options.type || s.method || s.type;

		// Extract dataTypes list
		s.dataTypes = ( s.dataType || "*" ).toLowerCase().match( rnothtmlwhite ) || [ "" ];

		// A cross-domain request is in order when the origin doesn't match the current origin.
		if ( s.crossDomain == null ) {
			urlAnchor = document.createElement( "a" );

			// Support: IE <=8 - 11, Edge 12 - 15
			// IE throws exception on accessing the href property if url is malformed,
			// e.g. http://example.com:80x/
			try {
				urlAnchor.href = s.url;

				// Support: IE <=8 - 11 only
				// Anchor's host property isn't correctly set when s.url is relative
				urlAnchor.href = urlAnchor.href;
				s.crossDomain = originAnchor.protocol + "//" + originAnchor.host !==
					urlAnchor.protocol + "//" + urlAnchor.host;
			} catch ( e ) {

				// If there is an error parsing the URL, assume it is crossDomain,
				// it can be rejected by the transport if it is invalid
				s.crossDomain = true;
			}
		}

		// Convert data if not already a string
		if ( s.data && s.processData && typeof s.data !== "string" ) {
			s.data = jQuery.param( s.data, s.traditional );
		}

		// Apply prefilters
		inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );

		// If request was aborted inside a prefilter, stop there
		if ( completed ) {
			return jqXHR;
		}

		// We can fire global events as of now if asked to
		// Don't fire events if jQuery.event is undefined in an AMD-usage scenario (#15118)
		fireGlobals = jQuery.event && s.global;

		// Watch for a new set of requests
		if ( fireGlobals && jQuery.active++ === 0 ) {
			jQuery.event.trigger( "ajaxStart" );
		}

		// Uppercase the type
		s.type = s.type.toUpperCase();

		// Determine if request has content
		s.hasContent = !rnoContent.test( s.type );

		// Save the URL in case we're toying with the If-Modified-Since
		// and/or If-None-Match header later on
		// Remove hash to simplify url manipulation
		cacheURL = s.url.replace( rhash, "" );

		// More options handling for requests with no content
		if ( !s.hasContent ) {

			// Remember the hash so we can put it back
			uncached = s.url.slice( cacheURL.length );

			// If data is available and should be processed, append data to url
			if ( s.data && ( s.processData || typeof s.data === "string" ) ) {
				cacheURL += ( rquery.test( cacheURL ) ? "&" : "?" ) + s.data;

				// #9682: remove data so that it's not used in an eventual retry
				delete s.data;
			}

			// Add or update anti-cache param if needed
			if ( s.cache === false ) {
				cacheURL = cacheURL.replace( rantiCache, "$1" );
				uncached = ( rquery.test( cacheURL ) ? "&" : "?" ) + "_=" + ( nonce.guid++ ) +
					uncached;
			}

			// Put hash and anti-cache on the URL that will be requested (gh-1732)
			s.url = cacheURL + uncached;

		// Change '%20' to '+' if this is encoded form body content (gh-2658)
		} else if ( s.data && s.processData &&
			( s.contentType || "" ).indexOf( "application/x-www-form-urlencoded" ) === 0 ) {
			s.data = s.data.replace( r20, "+" );
		}

		// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
		if ( s.ifModified ) {
			if ( jQuery.lastModified[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-Modified-Since", jQuery.lastModified[ cacheURL ] );
			}
			if ( jQuery.etag[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-None-Match", jQuery.etag[ cacheURL ] );
			}
		}

		// Set the correct header, if data is being sent
		if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {
			jqXHR.setRequestHeader( "Content-Type", s.contentType );
		}

		// Set the Accepts header for the server, depending on the dataType
		jqXHR.setRequestHeader(
			"Accept",
			s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[ 0 ] ] ?
				s.accepts[ s.dataTypes[ 0 ] ] +
					( s.dataTypes[ 0 ] !== "*" ? ", " + allTypes + "; q=0.01" : "" ) :
				s.accepts[ "*" ]
		);

		// Check for headers option
		for ( i in s.headers ) {
			jqXHR.setRequestHeader( i, s.headers[ i ] );
		}

		// Allow custom headers/mimetypes and early abort
		if ( s.beforeSend &&
			( s.beforeSend.call( callbackContext, jqXHR, s ) === false || completed ) ) {

			// Abort if not done already and return
			return jqXHR.abort();
		}

		// Aborting is no longer a cancellation
		strAbort = "abort";

		// Install callbacks on deferreds
		completeDeferred.add( s.complete );
		jqXHR.done( s.success );
		jqXHR.fail( s.error );

		// Get transport
		transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );

		// If no transport, we auto-abort
		if ( !transport ) {
			done( -1, "No Transport" );
		} else {
			jqXHR.readyState = 1;

			// Send global event
			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxSend", [ jqXHR, s ] );
			}

			// If request was aborted inside ajaxSend, stop there
			if ( completed ) {
				return jqXHR;
			}

			// Timeout
			if ( s.async && s.timeout > 0 ) {
				timeoutTimer = window.setTimeout( function() {
					jqXHR.abort( "timeout" );
				}, s.timeout );
			}

			try {
				completed = false;
				transport.send( requestHeaders, done );
			} catch ( e ) {

				// Rethrow post-completion exceptions
				if ( completed ) {
					throw e;
				}

				// Propagate others as results
				done( -1, e );
			}
		}

		// Callback for when everything is done
		function done( status, nativeStatusText, responses, headers ) {
			var isSuccess, success, error, response, modified,
				statusText = nativeStatusText;

			// Ignore repeat invocations
			if ( completed ) {
				return;
			}

			completed = true;

			// Clear timeout if it exists
			if ( timeoutTimer ) {
				window.clearTimeout( timeoutTimer );
			}

			// Dereference transport for early garbage collection
			// (no matter how long the jqXHR object will be used)
			transport = undefined;

			// Cache response headers
			responseHeadersString = headers || "";

			// Set readyState
			jqXHR.readyState = status > 0 ? 4 : 0;

			// Determine if successful
			isSuccess = status >= 200 && status < 300 || status === 304;

			// Get response data
			if ( responses ) {
				response = ajaxHandleResponses( s, jqXHR, responses );
			}

			// Use a noop converter for missing script
			if ( !isSuccess && jQuery.inArray( "script", s.dataTypes ) > -1 ) {
				s.converters[ "text script" ] = function() {};
			}

			// Convert no matter what (that way responseXXX fields are always set)
			response = ajaxConvert( s, response, jqXHR, isSuccess );

			// If successful, handle type chaining
			if ( isSuccess ) {

				// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
				if ( s.ifModified ) {
					modified = jqXHR.getResponseHeader( "Last-Modified" );
					if ( modified ) {
						jQuery.lastModified[ cacheURL ] = modified;
					}
					modified = jqXHR.getResponseHeader( "etag" );
					if ( modified ) {
						jQuery.etag[ cacheURL ] = modified;
					}
				}

				// if no content
				if ( status === 204 || s.type === "HEAD" ) {
					statusText = "nocontent";

				// if not modified
				} else if ( status === 304 ) {
					statusText = "notmodified";

				// If we have data, let's convert it
				} else {
					statusText = response.state;
					success = response.data;
					error = response.error;
					isSuccess = !error;
				}
			} else {

				// Extract error from statusText and normalize for non-aborts
				error = statusText;
				if ( status || !statusText ) {
					statusText = "error";
					if ( status < 0 ) {
						status = 0;
					}
				}
			}

			// Set data for the fake xhr object
			jqXHR.status = status;
			jqXHR.statusText = ( nativeStatusText || statusText ) + "";

			// Success/Error
			if ( isSuccess ) {
				deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );
			} else {
				deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );
			}

			// Status-dependent callbacks
			jqXHR.statusCode( statusCode );
			statusCode = undefined;

			if ( fireGlobals ) {
				globalEventContext.trigger( isSuccess ? "ajaxSuccess" : "ajaxError",
					[ jqXHR, s, isSuccess ? success : error ] );
			}

			// Complete
			completeDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );

			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxComplete", [ jqXHR, s ] );

				// Handle the global AJAX counter
				if ( !( --jQuery.active ) ) {
					jQuery.event.trigger( "ajaxStop" );
				}
			}
		}

		return jqXHR;
	},

	getJSON: function( url, data, callback ) {
		return jQuery.get( url, data, callback, "json" );
	},

	getScript: function( url, callback ) {
		return jQuery.get( url, undefined, callback, "script" );
	}
} );

jQuery.each( [ "get", "post" ], function( _i, method ) {
	jQuery[ method ] = function( url, data, callback, type ) {

		// Shift arguments if data argument was omitted
		if ( isFunction( data ) ) {
			type = type || callback;
			callback = data;
			data = undefined;
		}

		// The url can be an options object (which then must have .url)
		return jQuery.ajax( jQuery.extend( {
			url: url,
			type: method,
			dataType: type,
			data: data,
			success: callback
		}, jQuery.isPlainObject( url ) && url ) );
	};
} );

jQuery.ajaxPrefilter( function( s ) {
	var i;
	for ( i in s.headers ) {
		if ( i.toLowerCase() === "content-type" ) {
			s.contentType = s.headers[ i ] || "";
		}
	}
} );


jQuery._evalUrl = function( url, options, doc ) {
	return jQuery.ajax( {
		url: url,

		// Make this explicit, since user can override this through ajaxSetup (#11264)
		type: "GET",
		dataType: "script",
		cache: true,
		async: false,
		global: false,

		// Only evaluate the response if it is successful (gh-4126)
		// dataFilter is not invoked for failure responses, so using it instead
		// of the default converter is kludgy but it works.
		converters: {
			"text script": function() {}
		},
		dataFilter: function( response ) {
			jQuery.globalEval( response, options, doc );
		}
	} );
};


jQuery.fn.extend( {
	wrapAll: function( html ) {
		var wrap;

		if ( this[ 0 ] ) {
			if ( isFunction( html ) ) {
				html = html.call( this[ 0 ] );
			}

			// The elements to wrap the target around
			wrap = jQuery( html, this[ 0 ].ownerDocument ).eq( 0 ).clone( true );

			if ( this[ 0 ].parentNode ) {
				wrap.insertBefore( this[ 0 ] );
			}

			wrap.map( function() {
				var elem = this;

				while ( elem.firstElementChild ) {
					elem = elem.firstElementChild;
				}

				return elem;
			} ).append( this );
		}

		return this;
	},

	wrapInner: function( html ) {
		if ( isFunction( html ) ) {
			return this.each( function( i ) {
				jQuery( this ).wrapInner( html.call( this, i ) );
			} );
		}

		return this.each( function() {
			var self = jQuery( this ),
				contents = self.contents();

			if ( contents.length ) {
				contents.wrapAll( html );

			} else {
				self.append( html );
			}
		} );
	},

	wrap: function( html ) {
		var htmlIsFunction = isFunction( html );

		return this.each( function( i ) {
			jQuery( this ).wrapAll( htmlIsFunction ? html.call( this, i ) : html );
		} );
	},

	unwrap: function( selector ) {
		this.parent( selector ).not( "body" ).each( function() {
			jQuery( this ).replaceWith( this.childNodes );
		} );
		return this;
	}
} );


jQuery.expr.pseudos.hidden = function( elem ) {
	return !jQuery.expr.pseudos.visible( elem );
};
jQuery.expr.pseudos.visible = function( elem ) {
	return !!( elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length );
};




jQuery.ajaxSettings.xhr = function() {
	try {
		return new window.XMLHttpRequest();
	} catch ( e ) {}
};

var xhrSuccessStatus = {

		// File protocol always yields status code 0, assume 200
		0: 200,

		// Support: IE <=9 only
		// #1450: sometimes IE returns 1223 when it should be 204
		1223: 204
	},
	xhrSupported = jQuery.ajaxSettings.xhr();

support.cors = !!xhrSupported && ( "withCredentials" in xhrSupported );
support.ajax = xhrSupported = !!xhrSupported;

jQuery.ajaxTransport( function( options ) {
	var callback, errorCallback;

	// Cross domain only allowed if supported through XMLHttpRequest
	if ( support.cors || xhrSupported && !options.crossDomain ) {
		return {
			send: function( headers, complete ) {
				var i,
					xhr = options.xhr();

				xhr.open(
					options.type,
					options.url,
					options.async,
					options.username,
					options.password
				);

				// Apply custom fields if provided
				if ( options.xhrFields ) {
					for ( i in options.xhrFields ) {
						xhr[ i ] = options.xhrFields[ i ];
					}
				}

				// Override mime type if needed
				if ( options.mimeType && xhr.overrideMimeType ) {
					xhr.overrideMimeType( options.mimeType );
				}

				// X-Requested-With header
				// For cross-domain requests, seeing as conditions for a preflight are
				// akin to a jigsaw puzzle, we simply never set it to be sure.
				// (it can always be set on a per-request basis or even using ajaxSetup)
				// For same-domain requests, won't change header if already provided.
				if ( !options.crossDomain && !headers[ "X-Requested-With" ] ) {
					headers[ "X-Requested-With" ] = "XMLHttpRequest";
				}

				// Set headers
				for ( i in headers ) {
					xhr.setRequestHeader( i, headers[ i ] );
				}

				// Callback
				callback = function( type ) {
					return function() {
						if ( callback ) {
							callback = errorCallback = xhr.onload =
								xhr.onerror = xhr.onabort = xhr.ontimeout =
									xhr.onreadystatechange = null;

							if ( type === "abort" ) {
								xhr.abort();
							} else if ( type === "error" ) {

								// Support: IE <=9 only
								// On a manual native abort, IE9 throws
								// errors on any property access that is not readyState
								if ( typeof xhr.status !== "number" ) {
									complete( 0, "error" );
								} else {
									complete(

										// File: protocol always yields status 0; see #8605, #14207
										xhr.status,
										xhr.statusText
									);
								}
							} else {
								complete(
									xhrSuccessStatus[ xhr.status ] || xhr.status,
									xhr.statusText,

									// Support: IE <=9 only
									// IE9 has no XHR2 but throws on binary (trac-11426)
									// For XHR2 non-text, let the caller handle it (gh-2498)
									( xhr.responseType || "text" ) !== "text"  ||
									typeof xhr.responseText !== "string" ?
										{ binary: xhr.response } :
										{ text: xhr.responseText },
									xhr.getAllResponseHeaders()
								);
							}
						}
					};
				};

				// Listen to events
				xhr.onload = callback();
				errorCallback = xhr.onerror = xhr.ontimeout = callback( "error" );

				// Support: IE 9 only
				// Use onreadystatechange to replace onabort
				// to handle uncaught aborts
				if ( xhr.onabort !== undefined ) {
					xhr.onabort = errorCallback;
				} else {
					xhr.onreadystatechange = function() {

						// Check readyState before timeout as it changes
						if ( xhr.readyState === 4 ) {

							// Allow onerror to be called first,
							// but that will not handle a native abort
							// Also, save errorCallback to a variable
							// as xhr.onerror cannot be accessed
							window.setTimeout( function() {
								if ( callback ) {
									errorCallback();
								}
							} );
						}
					};
				}

				// Create the abort callback
				callback = callback( "abort" );

				try {

					// Do send the request (this may raise an exception)
					xhr.send( options.hasContent && options.data || null );
				} catch ( e ) {

					// #14683: Only rethrow if this hasn't been notified as an error yet
					if ( callback ) {
						throw e;
					}
				}
			},

			abort: function() {
				if ( callback ) {
					callback();
				}
			}
		};
	}
} );




// Prevent auto-execution of scripts when no explicit dataType was provided (See gh-2432)
jQuery.ajaxPrefilter( function( s ) {
	if ( s.crossDomain ) {
		s.contents.script = false;
	}
} );

// Install script dataType
jQuery.ajaxSetup( {
	accepts: {
		script: "text/javascript, application/javascript, " +
			"application/ecmascript, application/x-ecmascript"
	},
	contents: {
		script: /\b(?:java|ecma)script\b/
	},
	converters: {
		"text script": function( text ) {
			jQuery.globalEval( text );
			return text;
		}
	}
} );

// Handle cache's special case and crossDomain
jQuery.ajaxPrefilter( "script", function( s ) {
	if ( s.cache === undefined ) {
		s.cache = false;
	}
	if ( s.crossDomain ) {
		s.type = "GET";
	}
} );

// Bind script tag hack transport
jQuery.ajaxTransport( "script", function( s ) {

	// This transport only deals with cross domain or forced-by-attrs requests
	if ( s.crossDomain || s.scriptAttrs ) {
		var script, callback;
		return {
			send: function( _, complete ) {
				script = jQuery( "<script>" )
					.attr( s.scriptAttrs || {} )
					.prop( { charset: s.scriptCharset, src: s.url } )
					.on( "load error", callback = function( evt ) {
						script.remove();
						callback = null;
						if ( evt ) {
							complete( evt.type === "error" ? 404 : 200, evt.type );
						}
					} );

				// Use native DOM manipulation to avoid our domManip AJAX trickery
				document.head.appendChild( script[ 0 ] );
			},
			abort: function() {
				if ( callback ) {
					callback();
				}
			}
		};
	}
} );




var oldCallbacks = [],
	rjsonp = /(=)\?(?=&|$)|\?\?/;

// Default jsonp settings
jQuery.ajaxSetup( {
	jsonp: "callback",
	jsonpCallback: function() {
		var callback = oldCallbacks.pop() || ( jQuery.expando + "_" + ( nonce.guid++ ) );
		this[ callback ] = true;
		return callback;
	}
} );

// Detect, normalize options and install callbacks for jsonp requests
jQuery.ajaxPrefilter( "json jsonp", function( s, originalSettings, jqXHR ) {

	var callbackName, overwritten, responseContainer,
		jsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?
			"url" :
			typeof s.data === "string" &&
				( s.contentType || "" )
					.indexOf( "application/x-www-form-urlencoded" ) === 0 &&
				rjsonp.test( s.data ) && "data"
		);

	// Handle iff the expected data type is "jsonp" or we have a parameter to set
	if ( jsonProp || s.dataTypes[ 0 ] === "jsonp" ) {

		// Get callback name, remembering preexisting value associated with it
		callbackName = s.jsonpCallback = isFunction( s.jsonpCallback ) ?
			s.jsonpCallback() :
			s.jsonpCallback;

		// Insert callback into url or form data
		if ( jsonProp ) {
			s[ jsonProp ] = s[ jsonProp ].replace( rjsonp, "$1" + callbackName );
		} else if ( s.jsonp !== false ) {
			s.url += ( rquery.test( s.url ) ? "&" : "?" ) + s.jsonp + "=" + callbackName;
		}

		// Use data converter to retrieve json after script execution
		s.converters[ "script json" ] = function() {
			if ( !responseContainer ) {
				jQuery.error( callbackName + " was not called" );
			}
			return responseContainer[ 0 ];
		};

		// Force json dataType
		s.dataTypes[ 0 ] = "json";

		// Install callback
		overwritten = window[ callbackName ];
		window[ callbackName ] = function() {
			responseContainer = arguments;
		};

		// Clean-up function (fires after converters)
		jqXHR.always( function() {

			// If previous value didn't exist - remove it
			if ( overwritten === undefined ) {
				jQuery( window ).removeProp( callbackName );

			// Otherwise restore preexisting value
			} else {
				window[ callbackName ] = overwritten;
			}

			// Save back as free
			if ( s[ callbackName ] ) {

				// Make sure that re-using the options doesn't screw things around
				s.jsonpCallback = originalSettings.jsonpCallback;

				// Save the callback name for future use
				oldCallbacks.push( callbackName );
			}

			// Call if it was a function and we have a response
			if ( responseContainer && isFunction( overwritten ) ) {
				overwritten( responseContainer[ 0 ] );
			}

			responseContainer = overwritten = undefined;
		} );

		// Delegate to script
		return "script";
	}
} );




// Support: Safari 8 only
// In Safari 8 documents created via document.implementation.createHTMLDocument
// collapse sibling forms: the second one becomes a child of the first one.
// Because of that, this security measure has to be disabled in Safari 8.
// https://bugs.webkit.org/show_bug.cgi?id=137337
support.createHTMLDocument = ( function() {
	var body = document.implementation.createHTMLDocument( "" ).body;
	body.innerHTML = "<form></form><form></form>";
	return body.childNodes.length === 2;
} )();


// Argument "data" should be string of html
// context (optional): If specified, the fragment will be created in this context,
// defaults to document
// keepScripts (optional): If true, will include scripts passed in the html string
jQuery.parseHTML = function( data, context, keepScripts ) {
	if ( typeof data !== "string" ) {
		return [];
	}
	if ( typeof context === "boolean" ) {
		keepScripts = context;
		context = false;
	}

	var base, parsed, scripts;

	if ( !context ) {

		// Stop scripts or inline event handlers from being executed immediately
		// by using document.implementation
		if ( support.createHTMLDocument ) {
			context = document.implementation.createHTMLDocument( "" );

			// Set the base href for the created document
			// so any parsed elements with URLs
			// are based on the document's URL (gh-2965)
			base = context.createElement( "base" );
			base.href = document.location.href;
			context.head.appendChild( base );
		} else {
			context = document;
		}
	}

	parsed = rsingleTag.exec( data );
	scripts = !keepScripts && [];

	// Single tag
	if ( parsed ) {
		return [ context.createElement( parsed[ 1 ] ) ];
	}

	parsed = buildFragment( [ data ], context, scripts );

	if ( scripts && scripts.length ) {
		jQuery( scripts ).remove();
	}

	return jQuery.merge( [], parsed.childNodes );
};


/**
 * Load a url into a page
 */
jQuery.fn.load = function( url, params, callback ) {
	var selector, type, response,
		self = this,
		off = url.indexOf( " " );

	if ( off > -1 ) {
		selector = stripAndCollapse( url.slice( off ) );
		url = url.slice( 0, off );
	}

	// If it's a function
	if ( isFunction( params ) ) {

		// We assume that it's the callback
		callback = params;
		params = undefined;

	// Otherwise, build a param string
	} else if ( params && typeof params === "object" ) {
		type = "POST";
	}

	// If we have elements to modify, make the request
	if ( self.length > 0 ) {
		jQuery.ajax( {
			url: url,

			// If "type" variable is undefined, then "GET" method will be used.
			// Make value of this field explicit since
			// user can override it through ajaxSetup method
			type: type || "GET",
			dataType: "html",
			data: params
		} ).done( function( responseText ) {

			// Save response for use in complete callback
			response = arguments;

			self.html( selector ?

				// If a selector was specified, locate the right elements in a dummy div
				// Exclude scripts to avoid IE 'Permission Denied' errors
				jQuery( "<div>" ).append( jQuery.parseHTML( responseText ) ).find( selector ) :

				// Otherwise use the full result
				responseText );

		// If the request succeeds, this function gets "data", "status", "jqXHR"
		// but they are ignored because response was set above.
		// If it fails, this function gets "jqXHR", "status", "error"
		} ).always( callback && function( jqXHR, status ) {
			self.each( function() {
				callback.apply( this, response || [ jqXHR.responseText, status, jqXHR ] );
			} );
		} );
	}

	return this;
};




jQuery.expr.pseudos.animated = function( elem ) {
	return jQuery.grep( jQuery.timers, function( fn ) {
		return elem === fn.elem;
	} ).length;
};




jQuery.offset = {
	setOffset: function( elem, options, i ) {
		var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,
			position = jQuery.css( elem, "position" ),
			curElem = jQuery( elem ),
			props = {};

		// Set position first, in-case top/left are set even on static elem
		if ( position === "static" ) {
			elem.style.position = "relative";
		}

		curOffset = curElem.offset();
		curCSSTop = jQuery.css( elem, "top" );
		curCSSLeft = jQuery.css( elem, "left" );
		calculatePosition = ( position === "absolute" || position === "fixed" ) &&
			( curCSSTop + curCSSLeft ).indexOf( "auto" ) > -1;

		// Need to be able to calculate position if either
		// top or left is auto and position is either absolute or fixed
		if ( calculatePosition ) {
			curPosition = curElem.position();
			curTop = curPosition.top;
			curLeft = curPosition.left;

		} else {
			curTop = parseFloat( curCSSTop ) || 0;
			curLeft = parseFloat( curCSSLeft ) || 0;
		}

		if ( isFunction( options ) ) {

			// Use jQuery.extend here to allow modification of coordinates argument (gh-1848)
			options = options.call( elem, i, jQuery.extend( {}, curOffset ) );
		}

		if ( options.top != null ) {
			props.top = ( options.top - curOffset.top ) + curTop;
		}
		if ( options.left != null ) {
			props.left = ( options.left - curOffset.left ) + curLeft;
		}

		if ( "using" in options ) {
			options.using.call( elem, props );

		} else {
			if ( typeof props.top === "number" ) {
				props.top += "px";
			}
			if ( typeof props.left === "number" ) {
				props.left += "px";
			}
			curElem.css( props );
		}
	}
};

jQuery.fn.extend( {

	// offset() relates an element's border box to the document origin
	offset: function( options ) {

		// Preserve chaining for setter
		if ( arguments.length ) {
			return options === undefined ?
				this :
				this.each( function( i ) {
					jQuery.offset.setOffset( this, options, i );
				} );
		}

		var rect, win,
			elem = this[ 0 ];

		if ( !elem ) {
			return;
		}

		// Return zeros for disconnected and hidden (display: none) elements (gh-2310)
		// Support: IE <=11 only
		// Running getBoundingClientRect on a
		// disconnected node in IE throws an error
		if ( !elem.getClientRects().length ) {
			return { top: 0, left: 0 };
		}

		// Get document-relative position by adding viewport scroll to viewport-relative gBCR
		rect = elem.getBoundingClientRect();
		win = elem.ownerDocument.defaultView;
		return {
			top: rect.top + win.pageYOffset,
			left: rect.left + win.pageXOffset
		};
	},

	// position() relates an element's margin box to its offset parent's padding box
	// This corresponds to the behavior of CSS absolute positioning
	position: function() {
		if ( !this[ 0 ] ) {
			return;
		}

		var offsetParent, offset, doc,
			elem = this[ 0 ],
			parentOffset = { top: 0, left: 0 };

		// position:fixed elements are offset from the viewport, which itself always has zero offset
		if ( jQuery.css( elem, "position" ) === "fixed" ) {

			// Assume position:fixed implies availability of getBoundingClientRect
			offset = elem.getBoundingClientRect();

		} else {
			offset = this.offset();

			// Account for the *real* offset parent, which can be the document or its root element
			// when a statically positioned element is identified
			doc = elem.ownerDocument;
			offsetParent = elem.offsetParent || doc.documentElement;
			while ( offsetParent &&
				( offsetParent === doc.body || offsetParent === doc.documentElement ) &&
				jQuery.css( offsetParent, "position" ) === "static" ) {

				offsetParent = offsetParent.parentNode;
			}
			if ( offsetParent && offsetParent !== elem && offsetParent.nodeType === 1 ) {

				// Incorporate borders into its offset, since they are outside its content origin
				parentOffset = jQuery( offsetParent ).offset();
				parentOffset.top += jQuery.css( offsetParent, "borderTopWidth", true );
				parentOffset.left += jQuery.css( offsetParent, "borderLeftWidth", true );
			}
		}

		// Subtract parent offsets and element margins
		return {
			top: offset.top - parentOffset.top - jQuery.css( elem, "marginTop", true ),
			left: offset.left - parentOffset.left - jQuery.css( elem, "marginLeft", true )
		};
	},

	// This method will return documentElement in the following cases:
	// 1) For the element inside the iframe without offsetParent, this method will return
	//    documentElement of the parent window
	// 2) For the hidden or detached element
	// 3) For body or html element, i.e. in case of the html node - it will return itself
	//
	// but those exceptions were never presented as a real life use-cases
	// and might be considered as more preferable results.
	//
	// This logic, however, is not guaranteed and can change at any point in the future
	offsetParent: function() {
		return this.map( function() {
			var offsetParent = this.offsetParent;

			while ( offsetParent && jQuery.css( offsetParent, "position" ) === "static" ) {
				offsetParent = offsetParent.offsetParent;
			}

			return offsetParent || documentElement;
		} );
	}
} );

// Create scrollLeft and scrollTop methods
jQuery.each( { scrollLeft: "pageXOffset", scrollTop: "pageYOffset" }, function( method, prop ) {
	var top = "pageYOffset" === prop;

	jQuery.fn[ method ] = function( val ) {
		return access( this, function( elem, method, val ) {

			// Coalesce documents and windows
			var win;
			if ( isWindow( elem ) ) {
				win = elem;
			} else if ( elem.nodeType === 9 ) {
				win = elem.defaultView;
			}

			if ( val === undefined ) {
				return win ? win[ prop ] : elem[ method ];
			}

			if ( win ) {
				win.scrollTo(
					!top ? val : win.pageXOffset,
					top ? val : win.pageYOffset
				);

			} else {
				elem[ method ] = val;
			}
		}, method, val, arguments.length );
	};
} );

// Support: Safari <=7 - 9.1, Chrome <=37 - 49
// Add the top/left cssHooks using jQuery.fn.position
// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
// Blink bug: https://bugs.chromium.org/p/chromium/issues/detail?id=589347
// getComputedStyle returns percent when specified for top/left/bottom/right;
// rather than make the css module depend on the offset module, just check for it here
jQuery.each( [ "top", "left" ], function( _i, prop ) {
	jQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,
		function( elem, computed ) {
			if ( computed ) {
				computed = curCSS( elem, prop );

				// If curCSS returns percentage, fallback to offset
				return rnumnonpx.test( computed ) ?
					jQuery( elem ).position()[ prop ] + "px" :
					computed;
			}
		}
	);
} );


// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
jQuery.each( { Height: "height", Width: "width" }, function( name, type ) {
	jQuery.each( { padding: "inner" + name, content: type, "": "outer" + name },
		function( defaultExtra, funcName ) {

		// Margin is only for outerHeight, outerWidth
		jQuery.fn[ funcName ] = function( margin, value ) {
			var chainable = arguments.length && ( defaultExtra || typeof margin !== "boolean" ),
				extra = defaultExtra || ( margin === true || value === true ? "margin" : "border" );

			return access( this, function( elem, type, value ) {
				var doc;

				if ( isWindow( elem ) ) {

					// $( window ).outerWidth/Height return w/h including scrollbars (gh-1729)
					return funcName.indexOf( "outer" ) === 0 ?
						elem[ "inner" + name ] :
						elem.document.documentElement[ "client" + name ];
				}

				// Get document width or height
				if ( elem.nodeType === 9 ) {
					doc = elem.documentElement;

					// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],
					// whichever is greatest
					return Math.max(
						elem.body[ "scroll" + name ], doc[ "scroll" + name ],
						elem.body[ "offset" + name ], doc[ "offset" + name ],
						doc[ "client" + name ]
					);
				}

				return value === undefined ?

					// Get width or height on the element, requesting but not forcing parseFloat
					jQuery.css( elem, type, extra ) :

					// Set width or height on the element
					jQuery.style( elem, type, value, extra );
			}, type, chainable ? margin : undefined, chainable );
		};
	} );
} );


jQuery.each( [
	"ajaxStart",
	"ajaxStop",
	"ajaxComplete",
	"ajaxError",
	"ajaxSuccess",
	"ajaxSend"
], function( _i, type ) {
	jQuery.fn[ type ] = function( fn ) {
		return this.on( type, fn );
	};
} );




jQuery.fn.extend( {

	bind: function( types, data, fn ) {
		return this.on( types, null, data, fn );
	},
	unbind: function( types, fn ) {
		return this.off( types, null, fn );
	},

	delegate: function( selector, types, data, fn ) {
		return this.on( types, selector, data, fn );
	},
	undelegate: function( selector, types, fn ) {

		// ( namespace ) or ( selector, types [, fn] )
		return arguments.length === 1 ?
			this.off( selector, "**" ) :
			this.off( types, selector || "**", fn );
	},

	hover: function( fnOver, fnOut ) {
		return this.mouseenter( fnOver ).mouseleave( fnOut || fnOver );
	}
} );

jQuery.each( ( "blur focus focusin focusout resize scroll click dblclick " +
	"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
	"change select submit keydown keypress keyup contextmenu" ).split( " " ),
	function( _i, name ) {

		// Handle event binding
		jQuery.fn[ name ] = function( data, fn ) {
			return arguments.length > 0 ?
				this.on( name, null, data, fn ) :
				this.trigger( name );
		};
	} );




// Support: Android <=4.0 only
// Make sure we trim BOM and NBSP
var rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;

// Bind a function to a context, optionally partially applying any
// arguments.
// jQuery.proxy is deprecated to promote standards (specifically Function#bind)
// However, it is not slated for removal any time soon
jQuery.proxy = function( fn, context ) {
	var tmp, args, proxy;

	if ( typeof context === "string" ) {
		tmp = fn[ context ];
		context = fn;
		fn = tmp;
	}

	// Quick check to determine if target is callable, in the spec
	// this throws a TypeError, but we will just return undefined.
	if ( !isFunction( fn ) ) {
		return undefined;
	}

	// Simulated bind
	args = slice.call( arguments, 2 );
	proxy = function() {
		return fn.apply( context || this, args.concat( slice.call( arguments ) ) );
	};

	// Set the guid of unique handler to the same of original handler, so it can be removed
	proxy.guid = fn.guid = fn.guid || jQuery.guid++;

	return proxy;
};

jQuery.holdReady = function( hold ) {
	if ( hold ) {
		jQuery.readyWait++;
	} else {
		jQuery.ready( true );
	}
};
jQuery.isArray = Array.isArray;
jQuery.parseJSON = JSON.parse;
jQuery.nodeName = nodeName;
jQuery.isFunction = isFunction;
jQuery.isWindow = isWindow;
jQuery.camelCase = camelCase;
jQuery.type = toType;

jQuery.now = Date.now;

jQuery.isNumeric = function( obj ) {

	// As of jQuery 3.0, isNumeric is limited to
	// strings and numbers (primitives or objects)
	// that can be coerced to finite numbers (gh-2662)
	var type = jQuery.type( obj );
	return ( type === "number" || type === "string" ) &&

		// parseFloat NaNs numeric-cast false positives ("")
		// ...but misinterprets leading-number strings, particularly hex literals ("0x...")
		// subtraction forces infinities to NaN
		!isNaN( obj - parseFloat( obj ) );
};

jQuery.trim = function( text ) {
	return text == null ?
		"" :
		( text + "" ).replace( rtrim, "" );
};



// Register as a named AMD module, since jQuery can be concatenated with other
// files that may use define, but not via a proper concatenation script that
// understands anonymous AMD modules. A named AMD is safest and most robust
// way to register. Lowercase jquery is used because AMD module names are
// derived from file names, and jQuery is normally delivered in a lowercase
// file name. Do this after creating the global so that if an AMD module wants
// to call noConflict to hide this version of jQuery, it will work.

// Note that for maximum portability, libraries that are not jQuery should
// declare themselves as anonymous modules, and avoid setting a global if an
// AMD loader is present. jQuery is a special case. For more information, see
// https://github.com/jrburke/requirejs/wiki/Updating-existing-libraries#wiki-anon

if ( typeof define === "function" && define.amd ) {
	define( "jquery", [], function() {
		return jQuery;
	} );
}




var

	// Map over jQuery in case of overwrite
	_jQuery = window.jQuery,

	// Map over the $ in case of overwrite
	_$ = window.$;

jQuery.noConflict = function( deep ) {
	if ( window.$ === jQuery ) {
		window.$ = _$;
	}

	if ( deep && window.jQuery === jQuery ) {
		window.jQuery = _jQuery;
	}

	return jQuery;
};

// Expose jQuery and $ identifiers, even in AMD
// (#7102#comment:10, https://github.com/jquery/jquery/pull/557)
// and CommonJS for browser emulators (#13566)
if ( typeof noGlobal === "undefined" ) {
	window.jQuery = window.$ = jQuery;
}




return jQuery;
} );

/*!
  * Bootstrap v5.0.2 (https://getbootstrap.com/)
  * Copyright 2011-2021 The Bootstrap Authors (https://github.com/twbs/bootstrap/graphs/contributors)
  * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
  */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@popperjs/core')) :
  typeof define === 'function' && define.amd ? define(['@popperjs/core'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.bootstrap = factory(global.Popper));
}(this, (function (Popper) { 'use strict';

  function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    var n = Object.create(null);
    if (e) {
      Object.keys(e).forEach(function (k) {
        if (k !== 'default') {
          var d = Object.getOwnPropertyDescriptor(e, k);
          Object.defineProperty(n, k, d.get ? d : {
            enumerable: true,
            get: function () {
              return e[k];
            }
          });
        }
      });
    }
    n['default'] = e;
    return Object.freeze(n);
  }

  var Popper__namespace = /*#__PURE__*/_interopNamespace(Popper);

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): dom/selector-engine.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */

  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */
  const NODE_TEXT = 3;
  const SelectorEngine = {
    find(selector, element = document.documentElement) {
      return [].concat(...Element.prototype.querySelectorAll.call(element, selector));
    },

    findOne(selector, element = document.documentElement) {
      return Element.prototype.querySelector.call(element, selector);
    },

    children(element, selector) {
      return [].concat(...element.children).filter(child => child.matches(selector));
    },

    parents(element, selector) {
      const parents = [];
      let ancestor = element.parentNode;

      while (ancestor && ancestor.nodeType === Node.ELEMENT_NODE && ancestor.nodeType !== NODE_TEXT) {
        if (ancestor.matches(selector)) {
          parents.push(ancestor);
        }

        ancestor = ancestor.parentNode;
      }

      return parents;
    },

    prev(element, selector) {
      let previous = element.previousElementSibling;

      while (previous) {
        if (previous.matches(selector)) {
          return [previous];
        }

        previous = previous.previousElementSibling;
      }

      return [];
    },

    next(element, selector) {
      let next = element.nextElementSibling;

      while (next) {
        if (next.matches(selector)) {
          return [next];
        }

        next = next.nextElementSibling;
      }

      return [];
    }

  };

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): util/index.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */

  const MAX_UID = 1000000;
  const MILLISECONDS_MULTIPLIER = 1000;
  const TRANSITION_END = 'transitionend'; // Shoutout AngusCroll (https://goo.gl/pxwQGp)

  const toType = obj => {
    if (obj === null || obj === undefined) {
      return `${obj}`;
    }

    return {}.toString.call(obj).match(/\s([a-z]+)/i)[1].toLowerCase();
  };
  /**
   * --------------------------------------------------------------------------
   * Public Util Api
   * --------------------------------------------------------------------------
   */


  const getUID = prefix => {
    do {
      prefix += Math.floor(Math.random() * MAX_UID);
    } while (document.getElementById(prefix));

    return prefix;
  };

  const getSelector = element => {
    let selector = element.getAttribute('data-bs-target');

    if (!selector || selector === '#') {
      let hrefAttr = element.getAttribute('href'); // The only valid content that could double as a selector are IDs or classes,
      // so everything starting with `#` or `.`. If a "real" URL is used as the selector,
      // `document.querySelector` will rightfully complain it is invalid.
      // See https://github.com/twbs/bootstrap/issues/32273

      if (!hrefAttr || !hrefAttr.includes('#') && !hrefAttr.startsWith('.')) {
        return null;
      } // Just in case some CMS puts out a full URL with the anchor appended


      if (hrefAttr.includes('#') && !hrefAttr.startsWith('#')) {
        hrefAttr = `#${hrefAttr.split('#')[1]}`;
      }

      selector = hrefAttr && hrefAttr !== '#' ? hrefAttr.trim() : null;
    }

    return selector;
  };

  const getSelectorFromElement = element => {
    const selector = getSelector(element);

    if (selector) {
      return document.querySelector(selector) ? selector : null;
    }

    return null;
  };

  const getElementFromSelector = element => {
    const selector = getSelector(element);
    return selector ? document.querySelector(selector) : null;
  };

  const getTransitionDurationFromElement = element => {
    if (!element) {
      return 0;
    } // Get transition-duration of the element


    let {
      transitionDuration,
      transitionDelay
    } = window.getComputedStyle(element);
    const floatTransitionDuration = Number.parseFloat(transitionDuration);
    const floatTransitionDelay = Number.parseFloat(transitionDelay); // Return 0 if element or transition duration is not found

    if (!floatTransitionDuration && !floatTransitionDelay) {
      return 0;
    } // If multiple durations are defined, take the first


    transitionDuration = transitionDuration.split(',')[0];
    transitionDelay = transitionDelay.split(',')[0];
    return (Number.parseFloat(transitionDuration) + Number.parseFloat(transitionDelay)) * MILLISECONDS_MULTIPLIER;
  };

  const triggerTransitionEnd = element => {
    element.dispatchEvent(new Event(TRANSITION_END));
  };

  const isElement = obj => {
    if (!obj || typeof obj !== 'object') {
      return false;
    }

    if (typeof obj.jquery !== 'undefined') {
      obj = obj[0];
    }

    return typeof obj.nodeType !== 'undefined';
  };

  const getElement = obj => {
    if (isElement(obj)) {
      // it's a jQuery object or a node element
      return obj.jquery ? obj[0] : obj;
    }

    if (typeof obj === 'string' && obj.length > 0) {
      return SelectorEngine.findOne(obj);
    }

    return null;
  };

  const typeCheckConfig = (componentName, config, configTypes) => {
    Object.keys(configTypes).forEach(property => {
      const expectedTypes = configTypes[property];
      const value = config[property];
      const valueType = value && isElement(value) ? 'element' : toType(value);

      if (!new RegExp(expectedTypes).test(valueType)) {
        throw new TypeError(`${componentName.toUpperCase()}: Option "${property}" provided type "${valueType}" but expected type "${expectedTypes}".`);
      }
    });
  };

  const isVisible = element => {
    if (!isElement(element) || element.getClientRects().length === 0) {
      return false;
    }

    return getComputedStyle(element).getPropertyValue('visibility') === 'visible';
  };

  const isDisabled = element => {
    if (!element || element.nodeType !== Node.ELEMENT_NODE) {
      return true;
    }

    if (element.classList.contains('disabled')) {
      return true;
    }

    if (typeof element.disabled !== 'undefined') {
      return element.disabled;
    }

    return element.hasAttribute('disabled') && element.getAttribute('disabled') !== 'false';
  };

  const findShadowRoot = element => {
    if (!document.documentElement.attachShadow) {
      return null;
    } // Can find the shadow root otherwise it'll return the document


    if (typeof element.getRootNode === 'function') {
      const root = element.getRootNode();
      return root instanceof ShadowRoot ? root : null;
    }

    if (element instanceof ShadowRoot) {
      return element;
    } // when we don't find a shadow root


    if (!element.parentNode) {
      return null;
    }

    return findShadowRoot(element.parentNode);
  };

  const noop = () => {};

  const reflow = element => element.offsetHeight;

  const getjQuery = () => {
    const {
      jQuery
    } = window;

    if (jQuery && !document.body.hasAttribute('data-bs-no-jquery')) {
      return jQuery;
    }

    return null;
  };

  const DOMContentLoadedCallbacks = [];

  const onDOMContentLoaded = callback => {
    if (document.readyState === 'loading') {
      // add listener on the first call when the document is in loading state
      if (!DOMContentLoadedCallbacks.length) {
        document.addEventListener('DOMContentLoaded', () => {
          DOMContentLoadedCallbacks.forEach(callback => callback());
        });
      }

      DOMContentLoadedCallbacks.push(callback);
    } else {
      callback();
    }
  };

  const isRTL = () => document.documentElement.dir === 'rtl';

  const defineJQueryPlugin = plugin => {
    onDOMContentLoaded(() => {
      const $ = getjQuery();
      /* istanbul ignore if */

      if ($) {
        const name = plugin.NAME;
        const JQUERY_NO_CONFLICT = $.fn[name];
        $.fn[name] = plugin.jQueryInterface;
        $.fn[name].Constructor = plugin;

        $.fn[name].noConflict = () => {
          $.fn[name] = JQUERY_NO_CONFLICT;
          return plugin.jQueryInterface;
        };
      }
    });
  };

  const execute = callback => {
    if (typeof callback === 'function') {
      callback();
    }
  };

  const executeAfterTransition = (callback, transitionElement, waitForTransition = true) => {
    if (!waitForTransition) {
      execute(callback);
      return;
    }

    const durationPadding = 5;
    const emulatedDuration = getTransitionDurationFromElement(transitionElement) + durationPadding;
    let called = false;

    const handler = ({
      target
    }) => {
      if (target !== transitionElement) {
        return;
      }

      called = true;
      transitionElement.removeEventListener(TRANSITION_END, handler);
      execute(callback);
    };

    transitionElement.addEventListener(TRANSITION_END, handler);
    setTimeout(() => {
      if (!called) {
        triggerTransitionEnd(transitionElement);
      }
    }, emulatedDuration);
  };
  /**
   * Return the previous/next element of a list.
   *
   * @param {array} list    The list of elements
   * @param activeElement   The active element
   * @param shouldGetNext   Choose to get next or previous element
   * @param isCycleAllowed
   * @return {Element|elem} The proper element
   */


  const getNextActiveElement = (list, activeElement, shouldGetNext, isCycleAllowed) => {
    let index = list.indexOf(activeElement); // if the element does not exist in the list return an element depending on the direction and if cycle is allowed

    if (index === -1) {
      return list[!shouldGetNext && isCycleAllowed ? list.length - 1 : 0];
    }

    const listLength = list.length;
    index += shouldGetNext ? 1 : -1;

    if (isCycleAllowed) {
      index = (index + listLength) % listLength;
    }

    return list[Math.max(0, Math.min(index, listLength - 1))];
  };

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): dom/event-handler.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  const namespaceRegex = /[^.]*(?=\..*)\.|.*/;
  const stripNameRegex = /\..*/;
  const stripUidRegex = /::\d+$/;
  const eventRegistry = {}; // Events storage

  let uidEvent = 1;
  const customEvents = {
    mouseenter: 'mouseover',
    mouseleave: 'mouseout'
  };
  const customEventsRegex = /^(mouseenter|mouseleave)/i;
  const nativeEvents = new Set(['click', 'dblclick', 'mouseup', 'mousedown', 'contextmenu', 'mousewheel', 'DOMMouseScroll', 'mouseover', 'mouseout', 'mousemove', 'selectstart', 'selectend', 'keydown', 'keypress', 'keyup', 'orientationchange', 'touchstart', 'touchmove', 'touchend', 'touchcancel', 'pointerdown', 'pointermove', 'pointerup', 'pointerleave', 'pointercancel', 'gesturestart', 'gesturechange', 'gestureend', 'focus', 'blur', 'change', 'reset', 'select', 'submit', 'focusin', 'focusout', 'load', 'unload', 'beforeunload', 'resize', 'move', 'DOMContentLoaded', 'readystatechange', 'error', 'abort', 'scroll']);
  /**
   * ------------------------------------------------------------------------
   * Private methods
   * ------------------------------------------------------------------------
   */

  function getUidEvent(element, uid) {
    return uid && `${uid}::${uidEvent++}` || element.uidEvent || uidEvent++;
  }

  function getEvent(element) {
    const uid = getUidEvent(element);
    element.uidEvent = uid;
    eventRegistry[uid] = eventRegistry[uid] || {};
    return eventRegistry[uid];
  }

  function bootstrapHandler(element, fn) {
    return function handler(event) {
      event.delegateTarget = element;

      if (handler.oneOff) {
        EventHandler.off(element, event.type, fn);
      }

      return fn.apply(element, [event]);
    };
  }

  function bootstrapDelegationHandler(element, selector, fn) {
    return function handler(event) {
      const domElements = element.querySelectorAll(selector);

      for (let {
        target
      } = event; target && target !== this; target = target.parentNode) {
        for (let i = domElements.length; i--;) {
          if (domElements[i] === target) {
            event.delegateTarget = target;

            if (handler.oneOff) {
              // eslint-disable-next-line unicorn/consistent-destructuring
              EventHandler.off(element, event.type, selector, fn);
            }

            return fn.apply(target, [event]);
          }
        }
      } // To please ESLint


      return null;
    };
  }

  function findHandler(events, handler, delegationSelector = null) {
    const uidEventList = Object.keys(events);

    for (let i = 0, len = uidEventList.length; i < len; i++) {
      const event = events[uidEventList[i]];

      if (event.originalHandler === handler && event.delegationSelector === delegationSelector) {
        return event;
      }
    }

    return null;
  }

  function normalizeParams(originalTypeEvent, handler, delegationFn) {
    const delegation = typeof handler === 'string';
    const originalHandler = delegation ? delegationFn : handler;
    let typeEvent = getTypeEvent(originalTypeEvent);
    const isNative = nativeEvents.has(typeEvent);

    if (!isNative) {
      typeEvent = originalTypeEvent;
    }

    return [delegation, originalHandler, typeEvent];
  }

  function addHandler(element, originalTypeEvent, handler, delegationFn, oneOff) {
    if (typeof originalTypeEvent !== 'string' || !element) {
      return;
    }

    if (!handler) {
      handler = delegationFn;
      delegationFn = null;
    } // in case of mouseenter or mouseleave wrap the handler within a function that checks for its DOM position
    // this prevents the handler from being dispatched the same way as mouseover or mouseout does


    if (customEventsRegex.test(originalTypeEvent)) {
      const wrapFn = fn => {
        return function (event) {
          if (!event.relatedTarget || event.relatedTarget !== event.delegateTarget && !event.delegateTarget.contains(event.relatedTarget)) {
            return fn.call(this, event);
          }
        };
      };

      if (delegationFn) {
        delegationFn = wrapFn(delegationFn);
      } else {
        handler = wrapFn(handler);
      }
    }

    const [delegation, originalHandler, typeEvent] = normalizeParams(originalTypeEvent, handler, delegationFn);
    const events = getEvent(element);
    const handlers = events[typeEvent] || (events[typeEvent] = {});
    const previousFn = findHandler(handlers, originalHandler, delegation ? handler : null);

    if (previousFn) {
      previousFn.oneOff = previousFn.oneOff && oneOff;
      return;
    }

    const uid = getUidEvent(originalHandler, originalTypeEvent.replace(namespaceRegex, ''));
    const fn = delegation ? bootstrapDelegationHandler(element, handler, delegationFn) : bootstrapHandler(element, handler);
    fn.delegationSelector = delegation ? handler : null;
    fn.originalHandler = originalHandler;
    fn.oneOff = oneOff;
    fn.uidEvent = uid;
    handlers[uid] = fn;
    element.addEventListener(typeEvent, fn, delegation);
  }

  function removeHandler(element, events, typeEvent, handler, delegationSelector) {
    const fn = findHandler(events[typeEvent], handler, delegationSelector);

    if (!fn) {
      return;
    }

    element.removeEventListener(typeEvent, fn, Boolean(delegationSelector));
    delete events[typeEvent][fn.uidEvent];
  }

  function removeNamespacedHandlers(element, events, typeEvent, namespace) {
    const storeElementEvent = events[typeEvent] || {};
    Object.keys(storeElementEvent).forEach(handlerKey => {
      if (handlerKey.includes(namespace)) {
        const event = storeElementEvent[handlerKey];
        removeHandler(element, events, typeEvent, event.originalHandler, event.delegationSelector);
      }
    });
  }

  function getTypeEvent(event) {
    // allow to get the native events from namespaced events ('click.bs.button' --> 'click')
    event = event.replace(stripNameRegex, '');
    return customEvents[event] || event;
  }

  const EventHandler = {
    on(element, event, handler, delegationFn) {
      addHandler(element, event, handler, delegationFn, false);
    },

    one(element, event, handler, delegationFn) {
      addHandler(element, event, handler, delegationFn, true);
    },

    off(element, originalTypeEvent, handler, delegationFn) {
      if (typeof originalTypeEvent !== 'string' || !element) {
        return;
      }

      const [delegation, originalHandler, typeEvent] = normalizeParams(originalTypeEvent, handler, delegationFn);
      const inNamespace = typeEvent !== originalTypeEvent;
      const events = getEvent(element);
      const isNamespace = originalTypeEvent.startsWith('.');

      if (typeof originalHandler !== 'undefined') {
        // Simplest case: handler is passed, remove that listener ONLY.
        if (!events || !events[typeEvent]) {
          return;
        }

        removeHandler(element, events, typeEvent, originalHandler, delegation ? handler : null);
        return;
      }

      if (isNamespace) {
        Object.keys(events).forEach(elementEvent => {
          removeNamespacedHandlers(element, events, elementEvent, originalTypeEvent.slice(1));
        });
      }

      const storeElementEvent = events[typeEvent] || {};
      Object.keys(storeElementEvent).forEach(keyHandlers => {
        const handlerKey = keyHandlers.replace(stripUidRegex, '');

        if (!inNamespace || originalTypeEvent.includes(handlerKey)) {
          const event = storeElementEvent[keyHandlers];
          removeHandler(element, events, typeEvent, event.originalHandler, event.delegationSelector);
        }
      });
    },

    trigger(element, event, args) {
      if (typeof event !== 'string' || !element) {
        return null;
      }

      const $ = getjQuery();
      const typeEvent = getTypeEvent(event);
      const inNamespace = event !== typeEvent;
      const isNative = nativeEvents.has(typeEvent);
      let jQueryEvent;
      let bubbles = true;
      let nativeDispatch = true;
      let defaultPrevented = false;
      let evt = null;

      if (inNamespace && $) {
        jQueryEvent = $.Event(event, args);
        $(element).trigger(jQueryEvent);
        bubbles = !jQueryEvent.isPropagationStopped();
        nativeDispatch = !jQueryEvent.isImmediatePropagationStopped();
        defaultPrevented = jQueryEvent.isDefaultPrevented();
      }

      if (isNative) {
        evt = document.createEvent('HTMLEvents');
        evt.initEvent(typeEvent, bubbles, true);
      } else {
        evt = new CustomEvent(event, {
          bubbles,
          cancelable: true
        });
      } // merge custom information in our event


      if (typeof args !== 'undefined') {
        Object.keys(args).forEach(key => {
          Object.defineProperty(evt, key, {
            get() {
              return args[key];
            }

          });
        });
      }

      if (defaultPrevented) {
        evt.preventDefault();
      }

      if (nativeDispatch) {
        element.dispatchEvent(evt);
      }

      if (evt.defaultPrevented && typeof jQueryEvent !== 'undefined') {
        jQueryEvent.preventDefault();
      }

      return evt;
    }

  };

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): dom/data.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */

  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */
  const elementMap = new Map();
  var Data = {
    set(element, key, instance) {
      if (!elementMap.has(element)) {
        elementMap.set(element, new Map());
      }

      const instanceMap = elementMap.get(element); // make it clear we only want one instance per element
      // can be removed later when multiple key/instances are fine to be used

      if (!instanceMap.has(key) && instanceMap.size !== 0) {
        // eslint-disable-next-line no-console
        console.error(`Bootstrap doesn't allow more than one instance per element. Bound instance: ${Array.from(instanceMap.keys())[0]}.`);
        return;
      }

      instanceMap.set(key, instance);
    },

    get(element, key) {
      if (elementMap.has(element)) {
        return elementMap.get(element).get(key) || null;
      }

      return null;
    },

    remove(element, key) {
      if (!elementMap.has(element)) {
        return;
      }

      const instanceMap = elementMap.get(element);
      instanceMap.delete(key); // free up element references if there are no instances left for an element

      if (instanceMap.size === 0) {
        elementMap.delete(element);
      }
    }

  };

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): base-component.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  const VERSION = '5.0.2';

  class BaseComponent {
    constructor(element) {
      element = getElement(element);

      if (!element) {
        return;
      }

      this._element = element;
      Data.set(this._element, this.constructor.DATA_KEY, this);
    }

    dispose() {
      Data.remove(this._element, this.constructor.DATA_KEY);
      EventHandler.off(this._element, this.constructor.EVENT_KEY);
      Object.getOwnPropertyNames(this).forEach(propertyName => {
        this[propertyName] = null;
      });
    }

    _queueCallback(callback, element, isAnimated = true) {
      executeAfterTransition(callback, element, isAnimated);
    }
    /** Static */


    static getInstance(element) {
      return Data.get(element, this.DATA_KEY);
    }

    static getOrCreateInstance(element, config = {}) {
      return this.getInstance(element) || new this(element, typeof config === 'object' ? config : null);
    }

    static get VERSION() {
      return VERSION;
    }

    static get NAME() {
      throw new Error('You have to implement the static method "NAME", for each component!');
    }

    static get DATA_KEY() {
      return `bs.${this.NAME}`;
    }

    static get EVENT_KEY() {
      return `.${this.DATA_KEY}`;
    }

  }

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): alert.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  const NAME$c = 'alert';
  const DATA_KEY$b = 'bs.alert';
  const EVENT_KEY$b = `.${DATA_KEY$b}`;
  const DATA_API_KEY$8 = '.data-api';
  const SELECTOR_DISMISS = '[data-bs-dismiss="alert"]';
  const EVENT_CLOSE = `close${EVENT_KEY$b}`;
  const EVENT_CLOSED = `closed${EVENT_KEY$b}`;
  const EVENT_CLICK_DATA_API$7 = `click${EVENT_KEY$b}${DATA_API_KEY$8}`;
  const CLASS_NAME_ALERT = 'alert';
  const CLASS_NAME_FADE$6 = 'fade';
  const CLASS_NAME_SHOW$9 = 'show';
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  class Alert extends BaseComponent {
    // Getters
    static get NAME() {
      return NAME$c;
    } // Public


    close(element) {
      const rootElement = element ? this._getRootElement(element) : this._element;

      const customEvent = this._triggerCloseEvent(rootElement);

      if (customEvent === null || customEvent.defaultPrevented) {
        return;
      }

      this._removeElement(rootElement);
    } // Private


    _getRootElement(element) {
      return getElementFromSelector(element) || element.closest(`.${CLASS_NAME_ALERT}`);
    }

    _triggerCloseEvent(element) {
      return EventHandler.trigger(element, EVENT_CLOSE);
    }

    _removeElement(element) {
      element.classList.remove(CLASS_NAME_SHOW$9);
      const isAnimated = element.classList.contains(CLASS_NAME_FADE$6);

      this._queueCallback(() => this._destroyElement(element), element, isAnimated);
    }

    _destroyElement(element) {
      element.remove();
      EventHandler.trigger(element, EVENT_CLOSED);
    } // Static


    static jQueryInterface(config) {
      return this.each(function () {
        const data = Alert.getOrCreateInstance(this);

        if (config === 'close') {
          data[config](this);
        }
      });
    }

    static handleDismiss(alertInstance) {
      return function (event) {
        if (event) {
          event.preventDefault();
        }

        alertInstance.close(this);
      };
    }

  }
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  EventHandler.on(document, EVENT_CLICK_DATA_API$7, SELECTOR_DISMISS, Alert.handleDismiss(new Alert()));
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   * add .Alert to jQuery only if jQuery is present
   */

  defineJQueryPlugin(Alert);

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): button.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  const NAME$b = 'button';
  const DATA_KEY$a = 'bs.button';
  const EVENT_KEY$a = `.${DATA_KEY$a}`;
  const DATA_API_KEY$7 = '.data-api';
  const CLASS_NAME_ACTIVE$3 = 'active';
  const SELECTOR_DATA_TOGGLE$5 = '[data-bs-toggle="button"]';
  const EVENT_CLICK_DATA_API$6 = `click${EVENT_KEY$a}${DATA_API_KEY$7}`;
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  class Button extends BaseComponent {
    // Getters
    static get NAME() {
      return NAME$b;
    } // Public


    toggle() {
      // Toggle class and sync the `aria-pressed` attribute with the return value of the `.toggle()` method
      this._element.setAttribute('aria-pressed', this._element.classList.toggle(CLASS_NAME_ACTIVE$3));
    } // Static


    static jQueryInterface(config) {
      return this.each(function () {
        const data = Button.getOrCreateInstance(this);

        if (config === 'toggle') {
          data[config]();
        }
      });
    }

  }
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  EventHandler.on(document, EVENT_CLICK_DATA_API$6, SELECTOR_DATA_TOGGLE$5, event => {
    event.preventDefault();
    const button = event.target.closest(SELECTOR_DATA_TOGGLE$5);
    const data = Button.getOrCreateInstance(button);
    data.toggle();
  });
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   * add .Button to jQuery only if jQuery is present
   */

  defineJQueryPlugin(Button);

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): dom/manipulator.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  function normalizeData(val) {
    if (val === 'true') {
      return true;
    }

    if (val === 'false') {
      return false;
    }

    if (val === Number(val).toString()) {
      return Number(val);
    }

    if (val === '' || val === 'null') {
      return null;
    }

    return val;
  }

  function normalizeDataKey(key) {
    return key.replace(/[A-Z]/g, chr => `-${chr.toLowerCase()}`);
  }

  const Manipulator = {
    setDataAttribute(element, key, value) {
      element.setAttribute(`data-bs-${normalizeDataKey(key)}`, value);
    },

    removeDataAttribute(element, key) {
      element.removeAttribute(`data-bs-${normalizeDataKey(key)}`);
    },

    getDataAttributes(element) {
      if (!element) {
        return {};
      }

      const attributes = {};
      Object.keys(element.dataset).filter(key => key.startsWith('bs')).forEach(key => {
        let pureKey = key.replace(/^bs/, '');
        pureKey = pureKey.charAt(0).toLowerCase() + pureKey.slice(1, pureKey.length);
        attributes[pureKey] = normalizeData(element.dataset[key]);
      });
      return attributes;
    },

    getDataAttribute(element, key) {
      return normalizeData(element.getAttribute(`data-bs-${normalizeDataKey(key)}`));
    },

    offset(element) {
      const rect = element.getBoundingClientRect();
      return {
        top: rect.top + document.body.scrollTop,
        left: rect.left + document.body.scrollLeft
      };
    },

    position(element) {
      return {
        top: element.offsetTop,
        left: element.offsetLeft
      };
    }

  };

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): carousel.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  const NAME$a = 'carousel';
  const DATA_KEY$9 = 'bs.carousel';
  const EVENT_KEY$9 = `.${DATA_KEY$9}`;
  const DATA_API_KEY$6 = '.data-api';
  const ARROW_LEFT_KEY = 'ArrowLeft';
  const ARROW_RIGHT_KEY = 'ArrowRight';
  const TOUCHEVENT_COMPAT_WAIT = 500; // Time for mouse compat events to fire after touch

  const SWIPE_THRESHOLD = 40;
  const Default$9 = {
    interval: 5000,
    keyboard: true,
    slide: false,
    pause: 'hover',
    wrap: true,
    touch: true
  };
  const DefaultType$9 = {
    interval: '(number|boolean)',
    keyboard: 'boolean',
    slide: '(boolean|string)',
    pause: '(string|boolean)',
    wrap: 'boolean',
    touch: 'boolean'
  };
  const ORDER_NEXT = 'next';
  const ORDER_PREV = 'prev';
  const DIRECTION_LEFT = 'left';
  const DIRECTION_RIGHT = 'right';
  const KEY_TO_DIRECTION = {
    [ARROW_LEFT_KEY]: DIRECTION_RIGHT,
    [ARROW_RIGHT_KEY]: DIRECTION_LEFT
  };
  const EVENT_SLIDE = `slide${EVENT_KEY$9}`;
  const EVENT_SLID = `slid${EVENT_KEY$9}`;
  const EVENT_KEYDOWN = `keydown${EVENT_KEY$9}`;
  const EVENT_MOUSEENTER = `mouseenter${EVENT_KEY$9}`;
  const EVENT_MOUSELEAVE = `mouseleave${EVENT_KEY$9}`;
  const EVENT_TOUCHSTART = `touchstart${EVENT_KEY$9}`;
  const EVENT_TOUCHMOVE = `touchmove${EVENT_KEY$9}`;
  const EVENT_TOUCHEND = `touchend${EVENT_KEY$9}`;
  const EVENT_POINTERDOWN = `pointerdown${EVENT_KEY$9}`;
  const EVENT_POINTERUP = `pointerup${EVENT_KEY$9}`;
  const EVENT_DRAG_START = `dragstart${EVENT_KEY$9}`;
  const EVENT_LOAD_DATA_API$2 = `load${EVENT_KEY$9}${DATA_API_KEY$6}`;
  const EVENT_CLICK_DATA_API$5 = `click${EVENT_KEY$9}${DATA_API_KEY$6}`;
  const CLASS_NAME_CAROUSEL = 'carousel';
  const CLASS_NAME_ACTIVE$2 = 'active';
  const CLASS_NAME_SLIDE = 'slide';
  const CLASS_NAME_END = 'carousel-item-end';
  const CLASS_NAME_START = 'carousel-item-start';
  const CLASS_NAME_NEXT = 'carousel-item-next';
  const CLASS_NAME_PREV = 'carousel-item-prev';
  const CLASS_NAME_POINTER_EVENT = 'pointer-event';
  const SELECTOR_ACTIVE$1 = '.active';
  const SELECTOR_ACTIVE_ITEM = '.active.carousel-item';
  const SELECTOR_ITEM = '.carousel-item';
  const SELECTOR_ITEM_IMG = '.carousel-item img';
  const SELECTOR_NEXT_PREV = '.carousel-item-next, .carousel-item-prev';
  const SELECTOR_INDICATORS = '.carousel-indicators';
  const SELECTOR_INDICATOR = '[data-bs-target]';
  const SELECTOR_DATA_SLIDE = '[data-bs-slide], [data-bs-slide-to]';
  const SELECTOR_DATA_RIDE = '[data-bs-ride="carousel"]';
  const POINTER_TYPE_TOUCH = 'touch';
  const POINTER_TYPE_PEN = 'pen';
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  class Carousel extends BaseComponent {
    constructor(element, config) {
      super(element);
      this._items = null;
      this._interval = null;
      this._activeElement = null;
      this._isPaused = false;
      this._isSliding = false;
      this.touchTimeout = null;
      this.touchStartX = 0;
      this.touchDeltaX = 0;
      this._config = this._getConfig(config);
      this._indicatorsElement = SelectorEngine.findOne(SELECTOR_INDICATORS, this._element);
      this._touchSupported = 'ontouchstart' in document.documentElement || navigator.maxTouchPoints > 0;
      this._pointerEvent = Boolean(window.PointerEvent);

      this._addEventListeners();
    } // Getters


    static get Default() {
      return Default$9;
    }

    static get NAME() {
      return NAME$a;
    } // Public


    next() {
      this._slide(ORDER_NEXT);
    }

    nextWhenVisible() {
      // Don't call next when the page isn't visible
      // or the carousel or its parent isn't visible
      if (!document.hidden && isVisible(this._element)) {
        this.next();
      }
    }

    prev() {
      this._slide(ORDER_PREV);
    }

    pause(event) {
      if (!event) {
        this._isPaused = true;
      }

      if (SelectorEngine.findOne(SELECTOR_NEXT_PREV, this._element)) {
        triggerTransitionEnd(this._element);
        this.cycle(true);
      }

      clearInterval(this._interval);
      this._interval = null;
    }

    cycle(event) {
      if (!event) {
        this._isPaused = false;
      }

      if (this._interval) {
        clearInterval(this._interval);
        this._interval = null;
      }

      if (this._config && this._config.interval && !this._isPaused) {
        this._updateInterval();

        this._interval = setInterval((document.visibilityState ? this.nextWhenVisible : this.next).bind(this), this._config.interval);
      }
    }

    to(index) {
      this._activeElement = SelectorEngine.findOne(SELECTOR_ACTIVE_ITEM, this._element);

      const activeIndex = this._getItemIndex(this._activeElement);

      if (index > this._items.length - 1 || index < 0) {
        return;
      }

      if (this._isSliding) {
        EventHandler.one(this._element, EVENT_SLID, () => this.to(index));
        return;
      }

      if (activeIndex === index) {
        this.pause();
        this.cycle();
        return;
      }

      const order = index > activeIndex ? ORDER_NEXT : ORDER_PREV;

      this._slide(order, this._items[index]);
    } // Private


    _getConfig(config) {
      config = { ...Default$9,
        ...Manipulator.getDataAttributes(this._element),
        ...(typeof config === 'object' ? config : {})
      };
      typeCheckConfig(NAME$a, config, DefaultType$9);
      return config;
    }

    _handleSwipe() {
      const absDeltax = Math.abs(this.touchDeltaX);

      if (absDeltax <= SWIPE_THRESHOLD) {
        return;
      }

      const direction = absDeltax / this.touchDeltaX;
      this.touchDeltaX = 0;

      if (!direction) {
        return;
      }

      this._slide(direction > 0 ? DIRECTION_RIGHT : DIRECTION_LEFT);
    }

    _addEventListeners() {
      if (this._config.keyboard) {
        EventHandler.on(this._element, EVENT_KEYDOWN, event => this._keydown(event));
      }

      if (this._config.pause === 'hover') {
        EventHandler.on(this._element, EVENT_MOUSEENTER, event => this.pause(event));
        EventHandler.on(this._element, EVENT_MOUSELEAVE, event => this.cycle(event));
      }

      if (this._config.touch && this._touchSupported) {
        this._addTouchEventListeners();
      }
    }

    _addTouchEventListeners() {
      const start = event => {
        if (this._pointerEvent && (event.pointerType === POINTER_TYPE_PEN || event.pointerType === POINTER_TYPE_TOUCH)) {
          this.touchStartX = event.clientX;
        } else if (!this._pointerEvent) {
          this.touchStartX = event.touches[0].clientX;
        }
      };

      const move = event => {
        // ensure swiping with one touch and not pinching
        this.touchDeltaX = event.touches && event.touches.length > 1 ? 0 : event.touches[0].clientX - this.touchStartX;
      };

      const end = event => {
        if (this._pointerEvent && (event.pointerType === POINTER_TYPE_PEN || event.pointerType === POINTER_TYPE_TOUCH)) {
          this.touchDeltaX = event.clientX - this.touchStartX;
        }

        this._handleSwipe();

        if (this._config.pause === 'hover') {
          // If it's a touch-enabled device, mouseenter/leave are fired as
          // part of the mouse compatibility events on first tap - the carousel
          // would stop cycling until user tapped out of it;
          // here, we listen for touchend, explicitly pause the carousel
          // (as if it's the second time we tap on it, mouseenter compat event
          // is NOT fired) and after a timeout (to allow for mouse compatibility
          // events to fire) we explicitly restart cycling
          this.pause();

          if (this.touchTimeout) {
            clearTimeout(this.touchTimeout);
          }

          this.touchTimeout = setTimeout(event => this.cycle(event), TOUCHEVENT_COMPAT_WAIT + this._config.interval);
        }
      };

      SelectorEngine.find(SELECTOR_ITEM_IMG, this._element).forEach(itemImg => {
        EventHandler.on(itemImg, EVENT_DRAG_START, e => e.preventDefault());
      });

      if (this._pointerEvent) {
        EventHandler.on(this._element, EVENT_POINTERDOWN, event => start(event));
        EventHandler.on(this._element, EVENT_POINTERUP, event => end(event));

        this._element.classList.add(CLASS_NAME_POINTER_EVENT);
      } else {
        EventHandler.on(this._element, EVENT_TOUCHSTART, event => start(event));
        EventHandler.on(this._element, EVENT_TOUCHMOVE, event => move(event));
        EventHandler.on(this._element, EVENT_TOUCHEND, event => end(event));
      }
    }

    _keydown(event) {
      if (/input|textarea/i.test(event.target.tagName)) {
        return;
      }

      const direction = KEY_TO_DIRECTION[event.key];

      if (direction) {
        event.preventDefault();

        this._slide(direction);
      }
    }

    _getItemIndex(element) {
      this._items = element && element.parentNode ? SelectorEngine.find(SELECTOR_ITEM, element.parentNode) : [];
      return this._items.indexOf(element);
    }

    _getItemByOrder(order, activeElement) {
      const isNext = order === ORDER_NEXT;
      return getNextActiveElement(this._items, activeElement, isNext, this._config.wrap);
    }

    _triggerSlideEvent(relatedTarget, eventDirectionName) {
      const targetIndex = this._getItemIndex(relatedTarget);

      const fromIndex = this._getItemIndex(SelectorEngine.findOne(SELECTOR_ACTIVE_ITEM, this._element));

      return EventHandler.trigger(this._element, EVENT_SLIDE, {
        relatedTarget,
        direction: eventDirectionName,
        from: fromIndex,
        to: targetIndex
      });
    }

    _setActiveIndicatorElement(element) {
      if (this._indicatorsElement) {
        const activeIndicator = SelectorEngine.findOne(SELECTOR_ACTIVE$1, this._indicatorsElement);
        activeIndicator.classList.remove(CLASS_NAME_ACTIVE$2);
        activeIndicator.removeAttribute('aria-current');
        const indicators = SelectorEngine.find(SELECTOR_INDICATOR, this._indicatorsElement);

        for (let i = 0; i < indicators.length; i++) {
          if (Number.parseInt(indicators[i].getAttribute('data-bs-slide-to'), 10) === this._getItemIndex(element)) {
            indicators[i].classList.add(CLASS_NAME_ACTIVE$2);
            indicators[i].setAttribute('aria-current', 'true');
            break;
          }
        }
      }
    }

    _updateInterval() {
      const element = this._activeElement || SelectorEngine.findOne(SELECTOR_ACTIVE_ITEM, this._element);

      if (!element) {
        return;
      }

      const elementInterval = Number.parseInt(element.getAttribute('data-bs-interval'), 10);

      if (elementInterval) {
        this._config.defaultInterval = this._config.defaultInterval || this._config.interval;
        this._config.interval = elementInterval;
      } else {
        this._config.interval = this._config.defaultInterval || this._config.interval;
      }
    }

    _slide(directionOrOrder, element) {
      const order = this._directionToOrder(directionOrOrder);

      const activeElement = SelectorEngine.findOne(SELECTOR_ACTIVE_ITEM, this._element);

      const activeElementIndex = this._getItemIndex(activeElement);

      const nextElement = element || this._getItemByOrder(order, activeElement);

      const nextElementIndex = this._getItemIndex(nextElement);

      const isCycling = Boolean(this._interval);
      const isNext = order === ORDER_NEXT;
      const directionalClassName = isNext ? CLASS_NAME_START : CLASS_NAME_END;
      const orderClassName = isNext ? CLASS_NAME_NEXT : CLASS_NAME_PREV;

      const eventDirectionName = this._orderToDirection(order);

      if (nextElement && nextElement.classList.contains(CLASS_NAME_ACTIVE$2)) {
        this._isSliding = false;
        return;
      }

      if (this._isSliding) {
        return;
      }

      const slideEvent = this._triggerSlideEvent(nextElement, eventDirectionName);

      if (slideEvent.defaultPrevented) {
        return;
      }

      if (!activeElement || !nextElement) {
        // Some weirdness is happening, so we bail
        return;
      }

      this._isSliding = true;

      if (isCycling) {
        this.pause();
      }

      this._setActiveIndicatorElement(nextElement);

      this._activeElement = nextElement;

      const triggerSlidEvent = () => {
        EventHandler.trigger(this._element, EVENT_SLID, {
          relatedTarget: nextElement,
          direction: eventDirectionName,
          from: activeElementIndex,
          to: nextElementIndex
        });
      };

      if (this._element.classList.contains(CLASS_NAME_SLIDE)) {
        nextElement.classList.add(orderClassName);
        reflow(nextElement);
        activeElement.classList.add(directionalClassName);
        nextElement.classList.add(directionalClassName);

        const completeCallBack = () => {
          nextElement.classList.remove(directionalClassName, orderClassName);
          nextElement.classList.add(CLASS_NAME_ACTIVE$2);
          activeElement.classList.remove(CLASS_NAME_ACTIVE$2, orderClassName, directionalClassName);
          this._isSliding = false;
          setTimeout(triggerSlidEvent, 0);
        };

        this._queueCallback(completeCallBack, activeElement, true);
      } else {
        activeElement.classList.remove(CLASS_NAME_ACTIVE$2);
        nextElement.classList.add(CLASS_NAME_ACTIVE$2);
        this._isSliding = false;
        triggerSlidEvent();
      }

      if (isCycling) {
        this.cycle();
      }
    }

    _directionToOrder(direction) {
      if (![DIRECTION_RIGHT, DIRECTION_LEFT].includes(direction)) {
        return direction;
      }

      if (isRTL()) {
        return direction === DIRECTION_LEFT ? ORDER_PREV : ORDER_NEXT;
      }

      return direction === DIRECTION_LEFT ? ORDER_NEXT : ORDER_PREV;
    }

    _orderToDirection(order) {
      if (![ORDER_NEXT, ORDER_PREV].includes(order)) {
        return order;
      }

      if (isRTL()) {
        return order === ORDER_PREV ? DIRECTION_LEFT : DIRECTION_RIGHT;
      }

      return order === ORDER_PREV ? DIRECTION_RIGHT : DIRECTION_LEFT;
    } // Static


    static carouselInterface(element, config) {
      const data = Carousel.getOrCreateInstance(element, config);
      let {
        _config
      } = data;

      if (typeof config === 'object') {
        _config = { ..._config,
          ...config
        };
      }

      const action = typeof config === 'string' ? config : _config.slide;

      if (typeof config === 'number') {
        data.to(config);
      } else if (typeof action === 'string') {
        if (typeof data[action] === 'undefined') {
          throw new TypeError(`No method named "${action}"`);
        }

        data[action]();
      } else if (_config.interval && _config.ride) {
        data.pause();
        data.cycle();
      }
    }

    static jQueryInterface(config) {
      return this.each(function () {
        Carousel.carouselInterface(this, config);
      });
    }

    static dataApiClickHandler(event) {
      const target = getElementFromSelector(this);

      if (!target || !target.classList.contains(CLASS_NAME_CAROUSEL)) {
        return;
      }

      const config = { ...Manipulator.getDataAttributes(target),
        ...Manipulator.getDataAttributes(this)
      };
      const slideIndex = this.getAttribute('data-bs-slide-to');

      if (slideIndex) {
        config.interval = false;
      }

      Carousel.carouselInterface(target, config);

      if (slideIndex) {
        Carousel.getInstance(target).to(slideIndex);
      }

      event.preventDefault();
    }

  }
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  EventHandler.on(document, EVENT_CLICK_DATA_API$5, SELECTOR_DATA_SLIDE, Carousel.dataApiClickHandler);
  EventHandler.on(window, EVENT_LOAD_DATA_API$2, () => {
    const carousels = SelectorEngine.find(SELECTOR_DATA_RIDE);

    for (let i = 0, len = carousels.length; i < len; i++) {
      Carousel.carouselInterface(carousels[i], Carousel.getInstance(carousels[i]));
    }
  });
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   * add .Carousel to jQuery only if jQuery is present
   */

  defineJQueryPlugin(Carousel);

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): collapse.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  const NAME$9 = 'collapse';
  const DATA_KEY$8 = 'bs.collapse';
  const EVENT_KEY$8 = `.${DATA_KEY$8}`;
  const DATA_API_KEY$5 = '.data-api';
  const Default$8 = {
    toggle: true,
    parent: ''
  };
  const DefaultType$8 = {
    toggle: 'boolean',
    parent: '(string|element)'
  };
  const EVENT_SHOW$5 = `show${EVENT_KEY$8}`;
  const EVENT_SHOWN$5 = `shown${EVENT_KEY$8}`;
  const EVENT_HIDE$5 = `hide${EVENT_KEY$8}`;
  const EVENT_HIDDEN$5 = `hidden${EVENT_KEY$8}`;
  const EVENT_CLICK_DATA_API$4 = `click${EVENT_KEY$8}${DATA_API_KEY$5}`;
  const CLASS_NAME_SHOW$8 = 'show';
  const CLASS_NAME_COLLAPSE = 'collapse';
  const CLASS_NAME_COLLAPSING = 'collapsing';
  const CLASS_NAME_COLLAPSED = 'collapsed';
  const WIDTH = 'width';
  const HEIGHT = 'height';
  const SELECTOR_ACTIVES = '.show, .collapsing';
  const SELECTOR_DATA_TOGGLE$4 = '[data-bs-toggle="collapse"]';
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  class Collapse extends BaseComponent {
    constructor(element, config) {
      super(element);
      this._isTransitioning = false;
      this._config = this._getConfig(config);
      this._triggerArray = SelectorEngine.find(`${SELECTOR_DATA_TOGGLE$4}[href="#${this._element.id}"],` + `${SELECTOR_DATA_TOGGLE$4}[data-bs-target="#${this._element.id}"]`);
      const toggleList = SelectorEngine.find(SELECTOR_DATA_TOGGLE$4);

      for (let i = 0, len = toggleList.length; i < len; i++) {
        const elem = toggleList[i];
        const selector = getSelectorFromElement(elem);
        const filterElement = SelectorEngine.find(selector).filter(foundElem => foundElem === this._element);

        if (selector !== null && filterElement.length) {
          this._selector = selector;

          this._triggerArray.push(elem);
        }
      }

      this._parent = this._config.parent ? this._getParent() : null;

      if (!this._config.parent) {
        this._addAriaAndCollapsedClass(this._element, this._triggerArray);
      }

      if (this._config.toggle) {
        this.toggle();
      }
    } // Getters


    static get Default() {
      return Default$8;
    }

    static get NAME() {
      return NAME$9;
    } // Public


    toggle() {
      if (this._element.classList.contains(CLASS_NAME_SHOW$8)) {
        this.hide();
      } else {
        this.show();
      }
    }

    show() {
      if (this._isTransitioning || this._element.classList.contains(CLASS_NAME_SHOW$8)) {
        return;
      }

      let actives;
      let activesData;

      if (this._parent) {
        actives = SelectorEngine.find(SELECTOR_ACTIVES, this._parent).filter(elem => {
          if (typeof this._config.parent === 'string') {
            return elem.getAttribute('data-bs-parent') === this._config.parent;
          }

          return elem.classList.contains(CLASS_NAME_COLLAPSE);
        });

        if (actives.length === 0) {
          actives = null;
        }
      }

      const container = SelectorEngine.findOne(this._selector);

      if (actives) {
        const tempActiveData = actives.find(elem => container !== elem);
        activesData = tempActiveData ? Collapse.getInstance(tempActiveData) : null;

        if (activesData && activesData._isTransitioning) {
          return;
        }
      }

      const startEvent = EventHandler.trigger(this._element, EVENT_SHOW$5);

      if (startEvent.defaultPrevented) {
        return;
      }

      if (actives) {
        actives.forEach(elemActive => {
          if (container !== elemActive) {
            Collapse.collapseInterface(elemActive, 'hide');
          }

          if (!activesData) {
            Data.set(elemActive, DATA_KEY$8, null);
          }
        });
      }

      const dimension = this._getDimension();

      this._element.classList.remove(CLASS_NAME_COLLAPSE);

      this._element.classList.add(CLASS_NAME_COLLAPSING);

      this._element.style[dimension] = 0;

      if (this._triggerArray.length) {
        this._triggerArray.forEach(element => {
          element.classList.remove(CLASS_NAME_COLLAPSED);
          element.setAttribute('aria-expanded', true);
        });
      }

      this.setTransitioning(true);

      const complete = () => {
        this._element.classList.remove(CLASS_NAME_COLLAPSING);

        this._element.classList.add(CLASS_NAME_COLLAPSE, CLASS_NAME_SHOW$8);

        this._element.style[dimension] = '';
        this.setTransitioning(false);
        EventHandler.trigger(this._element, EVENT_SHOWN$5);
      };

      const capitalizedDimension = dimension[0].toUpperCase() + dimension.slice(1);
      const scrollSize = `scroll${capitalizedDimension}`;

      this._queueCallback(complete, this._element, true);

      this._element.style[dimension] = `${this._element[scrollSize]}px`;
    }

    hide() {
      if (this._isTransitioning || !this._element.classList.contains(CLASS_NAME_SHOW$8)) {
        return;
      }

      const startEvent = EventHandler.trigger(this._element, EVENT_HIDE$5);

      if (startEvent.defaultPrevented) {
        return;
      }

      const dimension = this._getDimension();

      this._element.style[dimension] = `${this._element.getBoundingClientRect()[dimension]}px`;
      reflow(this._element);

      this._element.classList.add(CLASS_NAME_COLLAPSING);

      this._element.classList.remove(CLASS_NAME_COLLAPSE, CLASS_NAME_SHOW$8);

      const triggerArrayLength = this._triggerArray.length;

      if (triggerArrayLength > 0) {
        for (let i = 0; i < triggerArrayLength; i++) {
          const trigger = this._triggerArray[i];
          const elem = getElementFromSelector(trigger);

          if (elem && !elem.classList.contains(CLASS_NAME_SHOW$8)) {
            trigger.classList.add(CLASS_NAME_COLLAPSED);
            trigger.setAttribute('aria-expanded', false);
          }
        }
      }

      this.setTransitioning(true);

      const complete = () => {
        this.setTransitioning(false);

        this._element.classList.remove(CLASS_NAME_COLLAPSING);

        this._element.classList.add(CLASS_NAME_COLLAPSE);

        EventHandler.trigger(this._element, EVENT_HIDDEN$5);
      };

      this._element.style[dimension] = '';

      this._queueCallback(complete, this._element, true);
    }

    setTransitioning(isTransitioning) {
      this._isTransitioning = isTransitioning;
    } // Private


    _getConfig(config) {
      config = { ...Default$8,
        ...config
      };
      config.toggle = Boolean(config.toggle); // Coerce string values

      typeCheckConfig(NAME$9, config, DefaultType$8);
      return config;
    }

    _getDimension() {
      return this._element.classList.contains(WIDTH) ? WIDTH : HEIGHT;
    }

    _getParent() {
      let {
        parent
      } = this._config;
      parent = getElement(parent);
      const selector = `${SELECTOR_DATA_TOGGLE$4}[data-bs-parent="${parent}"]`;
      SelectorEngine.find(selector, parent).forEach(element => {
        const selected = getElementFromSelector(element);

        this._addAriaAndCollapsedClass(selected, [element]);
      });
      return parent;
    }

    _addAriaAndCollapsedClass(element, triggerArray) {
      if (!element || !triggerArray.length) {
        return;
      }

      const isOpen = element.classList.contains(CLASS_NAME_SHOW$8);
      triggerArray.forEach(elem => {
        if (isOpen) {
          elem.classList.remove(CLASS_NAME_COLLAPSED);
        } else {
          elem.classList.add(CLASS_NAME_COLLAPSED);
        }

        elem.setAttribute('aria-expanded', isOpen);
      });
    } // Static


    static collapseInterface(element, config) {
      let data = Collapse.getInstance(element);
      const _config = { ...Default$8,
        ...Manipulator.getDataAttributes(element),
        ...(typeof config === 'object' && config ? config : {})
      };

      if (!data && _config.toggle && typeof config === 'string' && /show|hide/.test(config)) {
        _config.toggle = false;
      }

      if (!data) {
        data = new Collapse(element, _config);
      }

      if (typeof config === 'string') {
        if (typeof data[config] === 'undefined') {
          throw new TypeError(`No method named "${config}"`);
        }

        data[config]();
      }
    }

    static jQueryInterface(config) {
      return this.each(function () {
        Collapse.collapseInterface(this, config);
      });
    }

  }
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  EventHandler.on(document, EVENT_CLICK_DATA_API$4, SELECTOR_DATA_TOGGLE$4, function (event) {
    // preventDefault only for <a> elements (which change the URL) not inside the collapsible element
    if (event.target.tagName === 'A' || event.delegateTarget && event.delegateTarget.tagName === 'A') {
      event.preventDefault();
    }

    const triggerData = Manipulator.getDataAttributes(this);
    const selector = getSelectorFromElement(this);
    const selectorElements = SelectorEngine.find(selector);
    selectorElements.forEach(element => {
      const data = Collapse.getInstance(element);
      let config;

      if (data) {
        // update parent attribute
        if (data._parent === null && typeof triggerData.parent === 'string') {
          data._config.parent = triggerData.parent;
          data._parent = data._getParent();
        }

        config = 'toggle';
      } else {
        config = triggerData;
      }

      Collapse.collapseInterface(element, config);
    });
  });
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   * add .Collapse to jQuery only if jQuery is present
   */

  defineJQueryPlugin(Collapse);

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): dropdown.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  const NAME$8 = 'dropdown';
  const DATA_KEY$7 = 'bs.dropdown';
  const EVENT_KEY$7 = `.${DATA_KEY$7}`;
  const DATA_API_KEY$4 = '.data-api';
  const ESCAPE_KEY$2 = 'Escape';
  const SPACE_KEY = 'Space';
  const TAB_KEY = 'Tab';
  const ARROW_UP_KEY = 'ArrowUp';
  const ARROW_DOWN_KEY = 'ArrowDown';
  const RIGHT_MOUSE_BUTTON = 2; // MouseEvent.button value for the secondary button, usually the right button

  const REGEXP_KEYDOWN = new RegExp(`${ARROW_UP_KEY}|${ARROW_DOWN_KEY}|${ESCAPE_KEY$2}`);
  const EVENT_HIDE$4 = `hide${EVENT_KEY$7}`;
  const EVENT_HIDDEN$4 = `hidden${EVENT_KEY$7}`;
  const EVENT_SHOW$4 = `show${EVENT_KEY$7}`;
  const EVENT_SHOWN$4 = `shown${EVENT_KEY$7}`;
  const EVENT_CLICK = `click${EVENT_KEY$7}`;
  const EVENT_CLICK_DATA_API$3 = `click${EVENT_KEY$7}${DATA_API_KEY$4}`;
  const EVENT_KEYDOWN_DATA_API = `keydown${EVENT_KEY$7}${DATA_API_KEY$4}`;
  const EVENT_KEYUP_DATA_API = `keyup${EVENT_KEY$7}${DATA_API_KEY$4}`;
  const CLASS_NAME_SHOW$7 = 'show';
  const CLASS_NAME_DROPUP = 'dropup';
  const CLASS_NAME_DROPEND = 'dropend';
  const CLASS_NAME_DROPSTART = 'dropstart';
  const CLASS_NAME_NAVBAR = 'navbar';
  const SELECTOR_DATA_TOGGLE$3 = '[data-bs-toggle="dropdown"]';
  const SELECTOR_MENU = '.dropdown-menu';
  const SELECTOR_NAVBAR_NAV = '.navbar-nav';
  const SELECTOR_VISIBLE_ITEMS = '.dropdown-menu .dropdown-item:not(.disabled):not(:disabled)';
  const PLACEMENT_TOP = isRTL() ? 'top-end' : 'top-start';
  const PLACEMENT_TOPEND = isRTL() ? 'top-start' : 'top-end';
  const PLACEMENT_BOTTOM = isRTL() ? 'bottom-end' : 'bottom-start';
  const PLACEMENT_BOTTOMEND = isRTL() ? 'bottom-start' : 'bottom-end';
  const PLACEMENT_RIGHT = isRTL() ? 'left-start' : 'right-start';
  const PLACEMENT_LEFT = isRTL() ? 'right-start' : 'left-start';
  const Default$7 = {
    offset: [0, 2],
    boundary: 'clippingParents',
    reference: 'toggle',
    display: 'dynamic',
    popperConfig: null,
    autoClose: true
  };
  const DefaultType$7 = {
    offset: '(array|string|function)',
    boundary: '(string|element)',
    reference: '(string|element|object)',
    display: 'string',
    popperConfig: '(null|object|function)',
    autoClose: '(boolean|string)'
  };
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  class Dropdown extends BaseComponent {
    constructor(element, config) {
      super(element);
      this._popper = null;
      this._config = this._getConfig(config);
      this._menu = this._getMenuElement();
      this._inNavbar = this._detectNavbar();

      this._addEventListeners();
    } // Getters


    static get Default() {
      return Default$7;
    }

    static get DefaultType() {
      return DefaultType$7;
    }

    static get NAME() {
      return NAME$8;
    } // Public


    toggle() {
      if (isDisabled(this._element)) {
        return;
      }

      const isActive = this._element.classList.contains(CLASS_NAME_SHOW$7);

      if (isActive) {
        this.hide();
        return;
      }

      this.show();
    }

    show() {
      if (isDisabled(this._element) || this._menu.classList.contains(CLASS_NAME_SHOW$7)) {
        return;
      }

      const parent = Dropdown.getParentFromElement(this._element);
      const relatedTarget = {
        relatedTarget: this._element
      };
      const showEvent = EventHandler.trigger(this._element, EVENT_SHOW$4, relatedTarget);

      if (showEvent.defaultPrevented) {
        return;
      } // Totally disable Popper for Dropdowns in Navbar


      if (this._inNavbar) {
        Manipulator.setDataAttribute(this._menu, 'popper', 'none');
      } else {
        if (typeof Popper__namespace === 'undefined') {
          throw new TypeError('Bootstrap\'s dropdowns require Popper (https://popper.js.org)');
        }

        let referenceElement = this._element;

        if (this._config.reference === 'parent') {
          referenceElement = parent;
        } else if (isElement(this._config.reference)) {
          referenceElement = getElement(this._config.reference);
        } else if (typeof this._config.reference === 'object') {
          referenceElement = this._config.reference;
        }

        const popperConfig = this._getPopperConfig();

        const isDisplayStatic = popperConfig.modifiers.find(modifier => modifier.name === 'applyStyles' && modifier.enabled === false);
        this._popper = Popper__namespace.createPopper(referenceElement, this._menu, popperConfig);

        if (isDisplayStatic) {
          Manipulator.setDataAttribute(this._menu, 'popper', 'static');
        }
      } // If this is a touch-enabled device we add extra
      // empty mouseover listeners to the body's immediate children;
      // only needed because of broken event delegation on iOS
      // https://www.quirksmode.org/blog/archives/2014/02/mouse_event_bub.html


      if ('ontouchstart' in document.documentElement && !parent.closest(SELECTOR_NAVBAR_NAV)) {
        [].concat(...document.body.children).forEach(elem => EventHandler.on(elem, 'mouseover', noop));
      }

      this._element.focus();

      this._element.setAttribute('aria-expanded', true);

      this._menu.classList.toggle(CLASS_NAME_SHOW$7);

      this._element.classList.toggle(CLASS_NAME_SHOW$7);

      EventHandler.trigger(this._element, EVENT_SHOWN$4, relatedTarget);
    }

    hide() {
      if (isDisabled(this._element) || !this._menu.classList.contains(CLASS_NAME_SHOW$7)) {
        return;
      }

      const relatedTarget = {
        relatedTarget: this._element
      };

      this._completeHide(relatedTarget);
    }

    dispose() {
      if (this._popper) {
        this._popper.destroy();
      }

      super.dispose();
    }

    update() {
      this._inNavbar = this._detectNavbar();

      if (this._popper) {
        this._popper.update();
      }
    } // Private


    _addEventListeners() {
      EventHandler.on(this._element, EVENT_CLICK, event => {
        event.preventDefault();
        this.toggle();
      });
    }

    _completeHide(relatedTarget) {
      const hideEvent = EventHandler.trigger(this._element, EVENT_HIDE$4, relatedTarget);

      if (hideEvent.defaultPrevented) {
        return;
      } // If this is a touch-enabled device we remove the extra
      // empty mouseover listeners we added for iOS support


      if ('ontouchstart' in document.documentElement) {
        [].concat(...document.body.children).forEach(elem => EventHandler.off(elem, 'mouseover', noop));
      }

      if (this._popper) {
        this._popper.destroy();
      }

      this._menu.classList.remove(CLASS_NAME_SHOW$7);

      this._element.classList.remove(CLASS_NAME_SHOW$7);

      this._element.setAttribute('aria-expanded', 'false');

      Manipulator.removeDataAttribute(this._menu, 'popper');
      EventHandler.trigger(this._element, EVENT_HIDDEN$4, relatedTarget);
    }

    _getConfig(config) {
      config = { ...this.constructor.Default,
        ...Manipulator.getDataAttributes(this._element),
        ...config
      };
      typeCheckConfig(NAME$8, config, this.constructor.DefaultType);

      if (typeof config.reference === 'object' && !isElement(config.reference) && typeof config.reference.getBoundingClientRect !== 'function') {
        // Popper virtual elements require a getBoundingClientRect method
        throw new TypeError(`${NAME$8.toUpperCase()}: Option "reference" provided type "object" without a required "getBoundingClientRect" method.`);
      }

      return config;
    }

    _getMenuElement() {
      return SelectorEngine.next(this._element, SELECTOR_MENU)[0];
    }

    _getPlacement() {
      const parentDropdown = this._element.parentNode;

      if (parentDropdown.classList.contains(CLASS_NAME_DROPEND)) {
        return PLACEMENT_RIGHT;
      }

      if (parentDropdown.classList.contains(CLASS_NAME_DROPSTART)) {
        return PLACEMENT_LEFT;
      } // We need to trim the value because custom properties can also include spaces


      const isEnd = getComputedStyle(this._menu).getPropertyValue('--bs-position').trim() === 'end';

      if (parentDropdown.classList.contains(CLASS_NAME_DROPUP)) {
        return isEnd ? PLACEMENT_TOPEND : PLACEMENT_TOP;
      }

      return isEnd ? PLACEMENT_BOTTOMEND : PLACEMENT_BOTTOM;
    }

    _detectNavbar() {
      return this._element.closest(`.${CLASS_NAME_NAVBAR}`) !== null;
    }

    _getOffset() {
      const {
        offset
      } = this._config;

      if (typeof offset === 'string') {
        return offset.split(',').map(val => Number.parseInt(val, 10));
      }

      if (typeof offset === 'function') {
        return popperData => offset(popperData, this._element);
      }

      return offset;
    }

    _getPopperConfig() {
      const defaultBsPopperConfig = {
        placement: this._getPlacement(),
        modifiers: [{
          name: 'preventOverflow',
          options: {
            boundary: this._config.boundary
          }
        }, {
          name: 'offset',
          options: {
            offset: this._getOffset()
          }
        }]
      }; // Disable Popper if we have a static display

      if (this._config.display === 'static') {
        defaultBsPopperConfig.modifiers = [{
          name: 'applyStyles',
          enabled: false
        }];
      }

      return { ...defaultBsPopperConfig,
        ...(typeof this._config.popperConfig === 'function' ? this._config.popperConfig(defaultBsPopperConfig) : this._config.popperConfig)
      };
    }

    _selectMenuItem({
      key,
      target
    }) {
      const items = SelectorEngine.find(SELECTOR_VISIBLE_ITEMS, this._menu).filter(isVisible);

      if (!items.length) {
        return;
      } // if target isn't included in items (e.g. when expanding the dropdown)
      // allow cycling to get the last item in case key equals ARROW_UP_KEY


      getNextActiveElement(items, target, key === ARROW_DOWN_KEY, !items.includes(target)).focus();
    } // Static


    static dropdownInterface(element, config) {
      const data = Dropdown.getOrCreateInstance(element, config);

      if (typeof config === 'string') {
        if (typeof data[config] === 'undefined') {
          throw new TypeError(`No method named "${config}"`);
        }

        data[config]();
      }
    }

    static jQueryInterface(config) {
      return this.each(function () {
        Dropdown.dropdownInterface(this, config);
      });
    }

    static clearMenus(event) {
      if (event && (event.button === RIGHT_MOUSE_BUTTON || event.type === 'keyup' && event.key !== TAB_KEY)) {
        return;
      }

      const toggles = SelectorEngine.find(SELECTOR_DATA_TOGGLE$3);

      for (let i = 0, len = toggles.length; i < len; i++) {
        const context = Dropdown.getInstance(toggles[i]);

        if (!context || context._config.autoClose === false) {
          continue;
        }

        if (!context._element.classList.contains(CLASS_NAME_SHOW$7)) {
          continue;
        }

        const relatedTarget = {
          relatedTarget: context._element
        };

        if (event) {
          const composedPath = event.composedPath();
          const isMenuTarget = composedPath.includes(context._menu);

          if (composedPath.includes(context._element) || context._config.autoClose === 'inside' && !isMenuTarget || context._config.autoClose === 'outside' && isMenuTarget) {
            continue;
          } // Tab navigation through the dropdown menu or events from contained inputs shouldn't close the menu


          if (context._menu.contains(event.target) && (event.type === 'keyup' && event.key === TAB_KEY || /input|select|option|textarea|form/i.test(event.target.tagName))) {
            continue;
          }

          if (event.type === 'click') {
            relatedTarget.clickEvent = event;
          }
        }

        context._completeHide(relatedTarget);
      }
    }

    static getParentFromElement(element) {
      return getElementFromSelector(element) || element.parentNode;
    }

    static dataApiKeydownHandler(event) {
      // If not input/textarea:
      //  - And not a key in REGEXP_KEYDOWN => not a dropdown command
      // If input/textarea:
      //  - If space key => not a dropdown command
      //  - If key is other than escape
      //    - If key is not up or down => not a dropdown command
      //    - If trigger inside the menu => not a dropdown command
      if (/input|textarea/i.test(event.target.tagName) ? event.key === SPACE_KEY || event.key !== ESCAPE_KEY$2 && (event.key !== ARROW_DOWN_KEY && event.key !== ARROW_UP_KEY || event.target.closest(SELECTOR_MENU)) : !REGEXP_KEYDOWN.test(event.key)) {
        return;
      }

      const isActive = this.classList.contains(CLASS_NAME_SHOW$7);

      if (!isActive && event.key === ESCAPE_KEY$2) {
        return;
      }

      event.preventDefault();
      event.stopPropagation();

      if (isDisabled(this)) {
        return;
      }

      const getToggleButton = () => this.matches(SELECTOR_DATA_TOGGLE$3) ? this : SelectorEngine.prev(this, SELECTOR_DATA_TOGGLE$3)[0];

      if (event.key === ESCAPE_KEY$2) {
        getToggleButton().focus();
        Dropdown.clearMenus();
        return;
      }

      if (event.key === ARROW_UP_KEY || event.key === ARROW_DOWN_KEY) {
        if (!isActive) {
          getToggleButton().click();
        }

        Dropdown.getInstance(getToggleButton())._selectMenuItem(event);

        return;
      }

      if (!isActive || event.key === SPACE_KEY) {
        Dropdown.clearMenus();
      }
    }

  }
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  EventHandler.on(document, EVENT_KEYDOWN_DATA_API, SELECTOR_DATA_TOGGLE$3, Dropdown.dataApiKeydownHandler);
  EventHandler.on(document, EVENT_KEYDOWN_DATA_API, SELECTOR_MENU, Dropdown.dataApiKeydownHandler);
  EventHandler.on(document, EVENT_CLICK_DATA_API$3, Dropdown.clearMenus);
  EventHandler.on(document, EVENT_KEYUP_DATA_API, Dropdown.clearMenus);
  EventHandler.on(document, EVENT_CLICK_DATA_API$3, SELECTOR_DATA_TOGGLE$3, function (event) {
    event.preventDefault();
    Dropdown.dropdownInterface(this);
  });
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   * add .Dropdown to jQuery only if jQuery is present
   */

  defineJQueryPlugin(Dropdown);

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): util/scrollBar.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  const SELECTOR_FIXED_CONTENT = '.fixed-top, .fixed-bottom, .is-fixed, .sticky-top';
  const SELECTOR_STICKY_CONTENT = '.sticky-top';

  class ScrollBarHelper {
    constructor() {
      this._element = document.body;
    }

    getWidth() {
      // https://developer.mozilla.org/en-US/docs/Web/API/Window/innerWidth#usage_notes
      const documentWidth = document.documentElement.clientWidth;
      return Math.abs(window.innerWidth - documentWidth);
    }

    hide() {
      const width = this.getWidth();

      this._disableOverFlow(); // give padding to element to balance the hidden scrollbar width


      this._setElementAttributes(this._element, 'paddingRight', calculatedValue => calculatedValue + width); // trick: We adjust positive paddingRight and negative marginRight to sticky-top elements to keep showing fullwidth


      this._setElementAttributes(SELECTOR_FIXED_CONTENT, 'paddingRight', calculatedValue => calculatedValue + width);

      this._setElementAttributes(SELECTOR_STICKY_CONTENT, 'marginRight', calculatedValue => calculatedValue - width);
    }

    _disableOverFlow() {
      this._saveInitialAttribute(this._element, 'overflow');

      this._element.style.overflow = 'hidden';
    }

    _setElementAttributes(selector, styleProp, callback) {
      const scrollbarWidth = this.getWidth();

      const manipulationCallBack = element => {
        if (element !== this._element && window.innerWidth > element.clientWidth + scrollbarWidth) {
          return;
        }

        this._saveInitialAttribute(element, styleProp);

        const calculatedValue = window.getComputedStyle(element)[styleProp];
        element.style[styleProp] = `${callback(Number.parseFloat(calculatedValue))}px`;
      };

      this._applyManipulationCallback(selector, manipulationCallBack);
    }

    reset() {
      this._resetElementAttributes(this._element, 'overflow');

      this._resetElementAttributes(this._element, 'paddingRight');

      this._resetElementAttributes(SELECTOR_FIXED_CONTENT, 'paddingRight');

      this._resetElementAttributes(SELECTOR_STICKY_CONTENT, 'marginRight');
    }

    _saveInitialAttribute(element, styleProp) {
      const actualValue = element.style[styleProp];

      if (actualValue) {
        Manipulator.setDataAttribute(element, styleProp, actualValue);
      }
    }

    _resetElementAttributes(selector, styleProp) {
      const manipulationCallBack = element => {
        const value = Manipulator.getDataAttribute(element, styleProp);

        if (typeof value === 'undefined') {
          element.style.removeProperty(styleProp);
        } else {
          Manipulator.removeDataAttribute(element, styleProp);
          element.style[styleProp] = value;
        }
      };

      this._applyManipulationCallback(selector, manipulationCallBack);
    }

    _applyManipulationCallback(selector, callBack) {
      if (isElement(selector)) {
        callBack(selector);
      } else {
        SelectorEngine.find(selector, this._element).forEach(callBack);
      }
    }

    isOverflowing() {
      return this.getWidth() > 0;
    }

  }

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): util/backdrop.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
   * --------------------------------------------------------------------------
   */
  const Default$6 = {
    isVisible: true,
    // if false, we use the backdrop helper without adding any element to the dom
    isAnimated: false,
    rootElement: 'body',
    // give the choice to place backdrop under different elements
    clickCallback: null
  };
  const DefaultType$6 = {
    isVisible: 'boolean',
    isAnimated: 'boolean',
    rootElement: '(element|string)',
    clickCallback: '(function|null)'
  };
  const NAME$7 = 'backdrop';
  const CLASS_NAME_BACKDROP = 'modal-backdrop';
  const CLASS_NAME_FADE$5 = 'fade';
  const CLASS_NAME_SHOW$6 = 'show';
  const EVENT_MOUSEDOWN = `mousedown.bs.${NAME$7}`;

  class Backdrop {
    constructor(config) {
      this._config = this._getConfig(config);
      this._isAppended = false;
      this._element = null;
    }

    show(callback) {
      if (!this._config.isVisible) {
        execute(callback);
        return;
      }

      this._append();

      if (this._config.isAnimated) {
        reflow(this._getElement());
      }

      this._getElement().classList.add(CLASS_NAME_SHOW$6);

      this._emulateAnimation(() => {
        execute(callback);
      });
    }

    hide(callback) {
      if (!this._config.isVisible) {
        execute(callback);
        return;
      }

      this._getElement().classList.remove(CLASS_NAME_SHOW$6);

      this._emulateAnimation(() => {
        this.dispose();
        execute(callback);
      });
    } // Private


    _getElement() {
      if (!this._element) {
        const backdrop = document.createElement('div');
        backdrop.className = CLASS_NAME_BACKDROP;

        if (this._config.isAnimated) {
          backdrop.classList.add(CLASS_NAME_FADE$5);
        }

        this._element = backdrop;
      }

      return this._element;
    }

    _getConfig(config) {
      config = { ...Default$6,
        ...(typeof config === 'object' ? config : {})
      }; // use getElement() with the default "body" to get a fresh Element on each instantiation

      config.rootElement = getElement(config.rootElement);
      typeCheckConfig(NAME$7, config, DefaultType$6);
      return config;
    }

    _append() {
      if (this._isAppended) {
        return;
      }

      this._config.rootElement.appendChild(this._getElement());

      EventHandler.on(this._getElement(), EVENT_MOUSEDOWN, () => {
        execute(this._config.clickCallback);
      });
      this._isAppended = true;
    }

    dispose() {
      if (!this._isAppended) {
        return;
      }

      EventHandler.off(this._element, EVENT_MOUSEDOWN);

      this._element.remove();

      this._isAppended = false;
    }

    _emulateAnimation(callback) {
      executeAfterTransition(callback, this._getElement(), this._config.isAnimated);
    }

  }

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): modal.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  const NAME$6 = 'modal';
  const DATA_KEY$6 = 'bs.modal';
  const EVENT_KEY$6 = `.${DATA_KEY$6}`;
  const DATA_API_KEY$3 = '.data-api';
  const ESCAPE_KEY$1 = 'Escape';
  const Default$5 = {
    backdrop: true,
    keyboard: true,
    focus: true
  };
  const DefaultType$5 = {
    backdrop: '(boolean|string)',
    keyboard: 'boolean',
    focus: 'boolean'
  };
  const EVENT_HIDE$3 = `hide${EVENT_KEY$6}`;
  const EVENT_HIDE_PREVENTED = `hidePrevented${EVENT_KEY$6}`;
  const EVENT_HIDDEN$3 = `hidden${EVENT_KEY$6}`;
  const EVENT_SHOW$3 = `show${EVENT_KEY$6}`;
  const EVENT_SHOWN$3 = `shown${EVENT_KEY$6}`;
  const EVENT_FOCUSIN$2 = `focusin${EVENT_KEY$6}`;
  const EVENT_RESIZE = `resize${EVENT_KEY$6}`;
  const EVENT_CLICK_DISMISS$2 = `click.dismiss${EVENT_KEY$6}`;
  const EVENT_KEYDOWN_DISMISS$1 = `keydown.dismiss${EVENT_KEY$6}`;
  const EVENT_MOUSEUP_DISMISS = `mouseup.dismiss${EVENT_KEY$6}`;
  const EVENT_MOUSEDOWN_DISMISS = `mousedown.dismiss${EVENT_KEY$6}`;
  const EVENT_CLICK_DATA_API$2 = `click${EVENT_KEY$6}${DATA_API_KEY$3}`;
  const CLASS_NAME_OPEN = 'modal-open';
  const CLASS_NAME_FADE$4 = 'fade';
  const CLASS_NAME_SHOW$5 = 'show';
  const CLASS_NAME_STATIC = 'modal-static';
  const SELECTOR_DIALOG = '.modal-dialog';
  const SELECTOR_MODAL_BODY = '.modal-body';
  const SELECTOR_DATA_TOGGLE$2 = '[data-bs-toggle="modal"]';
  const SELECTOR_DATA_DISMISS$2 = '[data-bs-dismiss="modal"]';
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  class Modal extends BaseComponent {
    constructor(element, config) {
      super(element);
      this._config = this._getConfig(config);
      this._dialog = SelectorEngine.findOne(SELECTOR_DIALOG, this._element);
      this._backdrop = this._initializeBackDrop();
      this._isShown = false;
      this._ignoreBackdropClick = false;
      this._isTransitioning = false;
      this._scrollBar = new ScrollBarHelper();
    } // Getters


    static get Default() {
      return Default$5;
    }

    static get NAME() {
      return NAME$6;
    } // Public


    toggle(relatedTarget) {
      return this._isShown ? this.hide() : this.show(relatedTarget);
    }

    show(relatedTarget) {
      if (this._isShown || this._isTransitioning) {
        return;
      }

      const showEvent = EventHandler.trigger(this._element, EVENT_SHOW$3, {
        relatedTarget
      });

      if (showEvent.defaultPrevented) {
        return;
      }

      this._isShown = true;

      if (this._isAnimated()) {
        this._isTransitioning = true;
      }

      this._scrollBar.hide();

      document.body.classList.add(CLASS_NAME_OPEN);

      this._adjustDialog();

      this._setEscapeEvent();

      this._setResizeEvent();

      EventHandler.on(this._element, EVENT_CLICK_DISMISS$2, SELECTOR_DATA_DISMISS$2, event => this.hide(event));
      EventHandler.on(this._dialog, EVENT_MOUSEDOWN_DISMISS, () => {
        EventHandler.one(this._element, EVENT_MOUSEUP_DISMISS, event => {
          if (event.target === this._element) {
            this._ignoreBackdropClick = true;
          }
        });
      });

      this._showBackdrop(() => this._showElement(relatedTarget));
    }

    hide(event) {
      if (event && ['A', 'AREA'].includes(event.target.tagName)) {
        event.preventDefault();
      }

      if (!this._isShown || this._isTransitioning) {
        return;
      }

      const hideEvent = EventHandler.trigger(this._element, EVENT_HIDE$3);

      if (hideEvent.defaultPrevented) {
        return;
      }

      this._isShown = false;

      const isAnimated = this._isAnimated();

      if (isAnimated) {
        this._isTransitioning = true;
      }

      this._setEscapeEvent();

      this._setResizeEvent();

      EventHandler.off(document, EVENT_FOCUSIN$2);

      this._element.classList.remove(CLASS_NAME_SHOW$5);

      EventHandler.off(this._element, EVENT_CLICK_DISMISS$2);
      EventHandler.off(this._dialog, EVENT_MOUSEDOWN_DISMISS);

      this._queueCallback(() => this._hideModal(), this._element, isAnimated);
    }

    dispose() {
      [window, this._dialog].forEach(htmlElement => EventHandler.off(htmlElement, EVENT_KEY$6));

      this._backdrop.dispose();

      super.dispose();
      /**
       * `document` has 2 events `EVENT_FOCUSIN` and `EVENT_CLICK_DATA_API`
       * Do not move `document` in `htmlElements` array
       * It will remove `EVENT_CLICK_DATA_API` event that should remain
       */

      EventHandler.off(document, EVENT_FOCUSIN$2);
    }

    handleUpdate() {
      this._adjustDialog();
    } // Private


    _initializeBackDrop() {
      return new Backdrop({
        isVisible: Boolean(this._config.backdrop),
        // 'static' option will be translated to true, and booleans will keep their value
        isAnimated: this._isAnimated()
      });
    }

    _getConfig(config) {
      config = { ...Default$5,
        ...Manipulator.getDataAttributes(this._element),
        ...(typeof config === 'object' ? config : {})
      };
      typeCheckConfig(NAME$6, config, DefaultType$5);
      return config;
    }

    _showElement(relatedTarget) {
      const isAnimated = this._isAnimated();

      const modalBody = SelectorEngine.findOne(SELECTOR_MODAL_BODY, this._dialog);

      if (!this._element.parentNode || this._element.parentNode.nodeType !== Node.ELEMENT_NODE) {
        // Don't move modal's DOM position
        document.body.appendChild(this._element);
      }

      this._element.style.display = 'block';

      this._element.removeAttribute('aria-hidden');

      this._element.setAttribute('aria-modal', true);

      this._element.setAttribute('role', 'dialog');

      this._element.scrollTop = 0;

      if (modalBody) {
        modalBody.scrollTop = 0;
      }

      if (isAnimated) {
        reflow(this._element);
      }

      this._element.classList.add(CLASS_NAME_SHOW$5);

      if (this._config.focus) {
        this._enforceFocus();
      }

      const transitionComplete = () => {
        if (this._config.focus) {
          this._element.focus();
        }

        this._isTransitioning = false;
        EventHandler.trigger(this._element, EVENT_SHOWN$3, {
          relatedTarget
        });
      };

      this._queueCallback(transitionComplete, this._dialog, isAnimated);
    }

    _enforceFocus() {
      EventHandler.off(document, EVENT_FOCUSIN$2); // guard against infinite focus loop

      EventHandler.on(document, EVENT_FOCUSIN$2, event => {
        if (document !== event.target && this._element !== event.target && !this._element.contains(event.target)) {
          this._element.focus();
        }
      });
    }

    _setEscapeEvent() {
      if (this._isShown) {
        EventHandler.on(this._element, EVENT_KEYDOWN_DISMISS$1, event => {
          if (this._config.keyboard && event.key === ESCAPE_KEY$1) {
            event.preventDefault();
            this.hide();
          } else if (!this._config.keyboard && event.key === ESCAPE_KEY$1) {
            this._triggerBackdropTransition();
          }
        });
      } else {
        EventHandler.off(this._element, EVENT_KEYDOWN_DISMISS$1);
      }
    }

    _setResizeEvent() {
      if (this._isShown) {
        EventHandler.on(window, EVENT_RESIZE, () => this._adjustDialog());
      } else {
        EventHandler.off(window, EVENT_RESIZE);
      }
    }

    _hideModal() {
      this._element.style.display = 'none';

      this._element.setAttribute('aria-hidden', true);

      this._element.removeAttribute('aria-modal');

      this._element.removeAttribute('role');

      this._isTransitioning = false;

      this._backdrop.hide(() => {
        document.body.classList.remove(CLASS_NAME_OPEN);

        this._resetAdjustments();

        this._scrollBar.reset();

        EventHandler.trigger(this._element, EVENT_HIDDEN$3);
      });
    }

    _showBackdrop(callback) {
      EventHandler.on(this._element, EVENT_CLICK_DISMISS$2, event => {
        if (this._ignoreBackdropClick) {
          this._ignoreBackdropClick = false;
          return;
        }

        if (event.target !== event.currentTarget) {
          return;
        }

        if (this._config.backdrop === true) {
          this.hide();
        } else if (this._config.backdrop === 'static') {
          this._triggerBackdropTransition();
        }
      });

      this._backdrop.show(callback);
    }

    _isAnimated() {
      return this._element.classList.contains(CLASS_NAME_FADE$4);
    }

    _triggerBackdropTransition() {
      const hideEvent = EventHandler.trigger(this._element, EVENT_HIDE_PREVENTED);

      if (hideEvent.defaultPrevented) {
        return;
      }

      const {
        classList,
        scrollHeight,
        style
      } = this._element;
      const isModalOverflowing = scrollHeight > document.documentElement.clientHeight; // return if the following background transition hasn't yet completed

      if (!isModalOverflowing && style.overflowY === 'hidden' || classList.contains(CLASS_NAME_STATIC)) {
        return;
      }

      if (!isModalOverflowing) {
        style.overflowY = 'hidden';
      }

      classList.add(CLASS_NAME_STATIC);

      this._queueCallback(() => {
        classList.remove(CLASS_NAME_STATIC);

        if (!isModalOverflowing) {
          this._queueCallback(() => {
            style.overflowY = '';
          }, this._dialog);
        }
      }, this._dialog);

      this._element.focus();
    } // ----------------------------------------------------------------------
    // the following methods are used to handle overflowing modals
    // ----------------------------------------------------------------------


    _adjustDialog() {
      const isModalOverflowing = this._element.scrollHeight > document.documentElement.clientHeight;

      const scrollbarWidth = this._scrollBar.getWidth();

      const isBodyOverflowing = scrollbarWidth > 0;

      if (!isBodyOverflowing && isModalOverflowing && !isRTL() || isBodyOverflowing && !isModalOverflowing && isRTL()) {
        this._element.style.paddingLeft = `${scrollbarWidth}px`;
      }

      if (isBodyOverflowing && !isModalOverflowing && !isRTL() || !isBodyOverflowing && isModalOverflowing && isRTL()) {
        this._element.style.paddingRight = `${scrollbarWidth}px`;
      }
    }

    _resetAdjustments() {
      this._element.style.paddingLeft = '';
      this._element.style.paddingRight = '';
    } // Static


    static jQueryInterface(config, relatedTarget) {
      return this.each(function () {
        const data = Modal.getOrCreateInstance(this, config);

        if (typeof config !== 'string') {
          return;
        }

        if (typeof data[config] === 'undefined') {
          throw new TypeError(`No method named "${config}"`);
        }

        data[config](relatedTarget);
      });
    }

  }
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  EventHandler.on(document, EVENT_CLICK_DATA_API$2, SELECTOR_DATA_TOGGLE$2, function (event) {
    const target = getElementFromSelector(this);

    if (['A', 'AREA'].includes(this.tagName)) {
      event.preventDefault();
    }

    EventHandler.one(target, EVENT_SHOW$3, showEvent => {
      if (showEvent.defaultPrevented) {
        // only register focus restorer if modal will actually get shown
        return;
      }

      EventHandler.one(target, EVENT_HIDDEN$3, () => {
        if (isVisible(this)) {
          this.focus();
        }
      });
    });
    const data = Modal.getOrCreateInstance(target);
    data.toggle(this);
  });
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   * add .Modal to jQuery only if jQuery is present
   */

  defineJQueryPlugin(Modal);

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): offcanvas.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  const NAME$5 = 'offcanvas';
  const DATA_KEY$5 = 'bs.offcanvas';
  const EVENT_KEY$5 = `.${DATA_KEY$5}`;
  const DATA_API_KEY$2 = '.data-api';
  const EVENT_LOAD_DATA_API$1 = `load${EVENT_KEY$5}${DATA_API_KEY$2}`;
  const ESCAPE_KEY = 'Escape';
  const Default$4 = {
    backdrop: true,
    keyboard: true,
    scroll: false
  };
  const DefaultType$4 = {
    backdrop: 'boolean',
    keyboard: 'boolean',
    scroll: 'boolean'
  };
  const CLASS_NAME_SHOW$4 = 'show';
  const OPEN_SELECTOR = '.offcanvas.show';
  const EVENT_SHOW$2 = `show${EVENT_KEY$5}`;
  const EVENT_SHOWN$2 = `shown${EVENT_KEY$5}`;
  const EVENT_HIDE$2 = `hide${EVENT_KEY$5}`;
  const EVENT_HIDDEN$2 = `hidden${EVENT_KEY$5}`;
  const EVENT_FOCUSIN$1 = `focusin${EVENT_KEY$5}`;
  const EVENT_CLICK_DATA_API$1 = `click${EVENT_KEY$5}${DATA_API_KEY$2}`;
  const EVENT_CLICK_DISMISS$1 = `click.dismiss${EVENT_KEY$5}`;
  const EVENT_KEYDOWN_DISMISS = `keydown.dismiss${EVENT_KEY$5}`;
  const SELECTOR_DATA_DISMISS$1 = '[data-bs-dismiss="offcanvas"]';
  const SELECTOR_DATA_TOGGLE$1 = '[data-bs-toggle="offcanvas"]';
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  class Offcanvas extends BaseComponent {
    constructor(element, config) {
      super(element);
      this._config = this._getConfig(config);
      this._isShown = false;
      this._backdrop = this._initializeBackDrop();

      this._addEventListeners();
    } // Getters


    static get NAME() {
      return NAME$5;
    }

    static get Default() {
      return Default$4;
    } // Public


    toggle(relatedTarget) {
      return this._isShown ? this.hide() : this.show(relatedTarget);
    }

    show(relatedTarget) {
      if (this._isShown) {
        return;
      }

      const showEvent = EventHandler.trigger(this._element, EVENT_SHOW$2, {
        relatedTarget
      });

      if (showEvent.defaultPrevented) {
        return;
      }

      this._isShown = true;
      this._element.style.visibility = 'visible';

      this._backdrop.show();

      if (!this._config.scroll) {
        new ScrollBarHelper().hide();

        this._enforceFocusOnElement(this._element);
      }

      this._element.removeAttribute('aria-hidden');

      this._element.setAttribute('aria-modal', true);

      this._element.setAttribute('role', 'dialog');

      this._element.classList.add(CLASS_NAME_SHOW$4);

      const completeCallBack = () => {
        EventHandler.trigger(this._element, EVENT_SHOWN$2, {
          relatedTarget
        });
      };

      this._queueCallback(completeCallBack, this._element, true);
    }

    hide() {
      if (!this._isShown) {
        return;
      }

      const hideEvent = EventHandler.trigger(this._element, EVENT_HIDE$2);

      if (hideEvent.defaultPrevented) {
        return;
      }

      EventHandler.off(document, EVENT_FOCUSIN$1);

      this._element.blur();

      this._isShown = false;

      this._element.classList.remove(CLASS_NAME_SHOW$4);

      this._backdrop.hide();

      const completeCallback = () => {
        this._element.setAttribute('aria-hidden', true);

        this._element.removeAttribute('aria-modal');

        this._element.removeAttribute('role');

        this._element.style.visibility = 'hidden';

        if (!this._config.scroll) {
          new ScrollBarHelper().reset();
        }

        EventHandler.trigger(this._element, EVENT_HIDDEN$2);
      };

      this._queueCallback(completeCallback, this._element, true);
    }

    dispose() {
      this._backdrop.dispose();

      super.dispose();
      EventHandler.off(document, EVENT_FOCUSIN$1);
    } // Private


    _getConfig(config) {
      config = { ...Default$4,
        ...Manipulator.getDataAttributes(this._element),
        ...(typeof config === 'object' ? config : {})
      };
      typeCheckConfig(NAME$5, config, DefaultType$4);
      return config;
    }

    _initializeBackDrop() {
      return new Backdrop({
        isVisible: this._config.backdrop,
        isAnimated: true,
        rootElement: this._element.parentNode,
        clickCallback: () => this.hide()
      });
    }

    _enforceFocusOnElement(element) {
      EventHandler.off(document, EVENT_FOCUSIN$1); // guard against infinite focus loop

      EventHandler.on(document, EVENT_FOCUSIN$1, event => {
        if (document !== event.target && element !== event.target && !element.contains(event.target)) {
          element.focus();
        }
      });
      element.focus();
    }

    _addEventListeners() {
      EventHandler.on(this._element, EVENT_CLICK_DISMISS$1, SELECTOR_DATA_DISMISS$1, () => this.hide());
      EventHandler.on(this._element, EVENT_KEYDOWN_DISMISS, event => {
        if (this._config.keyboard && event.key === ESCAPE_KEY) {
          this.hide();
        }
      });
    } // Static


    static jQueryInterface(config) {
      return this.each(function () {
        const data = Offcanvas.getOrCreateInstance(this, config);

        if (typeof config !== 'string') {
          return;
        }

        if (data[config] === undefined || config.startsWith('_') || config === 'constructor') {
          throw new TypeError(`No method named "${config}"`);
        }

        data[config](this);
      });
    }

  }
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  EventHandler.on(document, EVENT_CLICK_DATA_API$1, SELECTOR_DATA_TOGGLE$1, function (event) {
    const target = getElementFromSelector(this);

    if (['A', 'AREA'].includes(this.tagName)) {
      event.preventDefault();
    }

    if (isDisabled(this)) {
      return;
    }

    EventHandler.one(target, EVENT_HIDDEN$2, () => {
      // focus on trigger when it is closed
      if (isVisible(this)) {
        this.focus();
      }
    }); // avoid conflict when clicking a toggler of an offcanvas, while another is open

    const allReadyOpen = SelectorEngine.findOne(OPEN_SELECTOR);

    if (allReadyOpen && allReadyOpen !== target) {
      Offcanvas.getInstance(allReadyOpen).hide();
    }

    const data = Offcanvas.getOrCreateInstance(target);
    data.toggle(this);
  });
  EventHandler.on(window, EVENT_LOAD_DATA_API$1, () => SelectorEngine.find(OPEN_SELECTOR).forEach(el => Offcanvas.getOrCreateInstance(el).show()));
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   */

  defineJQueryPlugin(Offcanvas);

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): util/sanitizer.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  const uriAttrs = new Set(['background', 'cite', 'href', 'itemtype', 'longdesc', 'poster', 'src', 'xlink:href']);
  const ARIA_ATTRIBUTE_PATTERN = /^aria-[\w-]*$/i;
  /**
   * A pattern that recognizes a commonly useful subset of URLs that are safe.
   *
   * Shoutout to Angular 7 https://github.com/angular/angular/blob/7.2.4/packages/core/src/sanitization/url_sanitizer.ts
   */

  const SAFE_URL_PATTERN = /^(?:(?:https?|mailto|ftp|tel|file):|[^#&/:?]*(?:[#/?]|$))/i;
  /**
   * A pattern that matches safe data URLs. Only matches image, video and audio types.
   *
   * Shoutout to Angular 7 https://github.com/angular/angular/blob/7.2.4/packages/core/src/sanitization/url_sanitizer.ts
   */

  const DATA_URL_PATTERN = /^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[\d+/a-z]+=*$/i;

  const allowedAttribute = (attr, allowedAttributeList) => {
    const attrName = attr.nodeName.toLowerCase();

    if (allowedAttributeList.includes(attrName)) {
      if (uriAttrs.has(attrName)) {
        return Boolean(SAFE_URL_PATTERN.test(attr.nodeValue) || DATA_URL_PATTERN.test(attr.nodeValue));
      }

      return true;
    }

    const regExp = allowedAttributeList.filter(attrRegex => attrRegex instanceof RegExp); // Check if a regular expression validates the attribute.

    for (let i = 0, len = regExp.length; i < len; i++) {
      if (regExp[i].test(attrName)) {
        return true;
      }
    }

    return false;
  };

  const DefaultAllowlist = {
    // Global attributes allowed on any supplied element below.
    '*': ['class', 'dir', 'id', 'lang', 'role', ARIA_ATTRIBUTE_PATTERN],
    a: ['target', 'href', 'title', 'rel'],
    area: [],
    b: [],
    br: [],
    col: [],
    code: [],
    div: [],
    em: [],
    hr: [],
    h1: [],
    h2: [],
    h3: [],
    h4: [],
    h5: [],
    h6: [],
    i: [],
    img: ['src', 'srcset', 'alt', 'title', 'width', 'height'],
    li: [],
    ol: [],
    p: [],
    pre: [],
    s: [],
    small: [],
    span: [],
    sub: [],
    sup: [],
    strong: [],
    u: [],
    ul: []
  };
  function sanitizeHtml(unsafeHtml, allowList, sanitizeFn) {
    if (!unsafeHtml.length) {
      return unsafeHtml;
    }

    if (sanitizeFn && typeof sanitizeFn === 'function') {
      return sanitizeFn(unsafeHtml);
    }

    const domParser = new window.DOMParser();
    const createdDocument = domParser.parseFromString(unsafeHtml, 'text/html');
    const allowlistKeys = Object.keys(allowList);
    const elements = [].concat(...createdDocument.body.querySelectorAll('*'));

    for (let i = 0, len = elements.length; i < len; i++) {
      const el = elements[i];
      const elName = el.nodeName.toLowerCase();

      if (!allowlistKeys.includes(elName)) {
        el.remove();
        continue;
      }

      const attributeList = [].concat(...el.attributes);
      const allowedAttributes = [].concat(allowList['*'] || [], allowList[elName] || []);
      attributeList.forEach(attr => {
        if (!allowedAttribute(attr, allowedAttributes)) {
          el.removeAttribute(attr.nodeName);
        }
      });
    }

    return createdDocument.body.innerHTML;
  }

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): tooltip.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  const NAME$4 = 'tooltip';
  const DATA_KEY$4 = 'bs.tooltip';
  const EVENT_KEY$4 = `.${DATA_KEY$4}`;
  const CLASS_PREFIX$1 = 'bs-tooltip';
  const BSCLS_PREFIX_REGEX$1 = new RegExp(`(^|\\s)${CLASS_PREFIX$1}\\S+`, 'g');
  const DISALLOWED_ATTRIBUTES = new Set(['sanitize', 'allowList', 'sanitizeFn']);
  const DefaultType$3 = {
    animation: 'boolean',
    template: 'string',
    title: '(string|element|function)',
    trigger: 'string',
    delay: '(number|object)',
    html: 'boolean',
    selector: '(string|boolean)',
    placement: '(string|function)',
    offset: '(array|string|function)',
    container: '(string|element|boolean)',
    fallbackPlacements: 'array',
    boundary: '(string|element)',
    customClass: '(string|function)',
    sanitize: 'boolean',
    sanitizeFn: '(null|function)',
    allowList: 'object',
    popperConfig: '(null|object|function)'
  };
  const AttachmentMap = {
    AUTO: 'auto',
    TOP: 'top',
    RIGHT: isRTL() ? 'left' : 'right',
    BOTTOM: 'bottom',
    LEFT: isRTL() ? 'right' : 'left'
  };
  const Default$3 = {
    animation: true,
    template: '<div class="tooltip" role="tooltip">' + '<div class="tooltip-arrow"></div>' + '<div class="tooltip-inner"></div>' + '</div>',
    trigger: 'hover focus',
    title: '',
    delay: 0,
    html: false,
    selector: false,
    placement: 'top',
    offset: [0, 0],
    container: false,
    fallbackPlacements: ['top', 'right', 'bottom', 'left'],
    boundary: 'clippingParents',
    customClass: '',
    sanitize: true,
    sanitizeFn: null,
    allowList: DefaultAllowlist,
    popperConfig: null
  };
  const Event$2 = {
    HIDE: `hide${EVENT_KEY$4}`,
    HIDDEN: `hidden${EVENT_KEY$4}`,
    SHOW: `show${EVENT_KEY$4}`,
    SHOWN: `shown${EVENT_KEY$4}`,
    INSERTED: `inserted${EVENT_KEY$4}`,
    CLICK: `click${EVENT_KEY$4}`,
    FOCUSIN: `focusin${EVENT_KEY$4}`,
    FOCUSOUT: `focusout${EVENT_KEY$4}`,
    MOUSEENTER: `mouseenter${EVENT_KEY$4}`,
    MOUSELEAVE: `mouseleave${EVENT_KEY$4}`
  };
  const CLASS_NAME_FADE$3 = 'fade';
  const CLASS_NAME_MODAL = 'modal';
  const CLASS_NAME_SHOW$3 = 'show';
  const HOVER_STATE_SHOW = 'show';
  const HOVER_STATE_OUT = 'out';
  const SELECTOR_TOOLTIP_INNER = '.tooltip-inner';
  const TRIGGER_HOVER = 'hover';
  const TRIGGER_FOCUS = 'focus';
  const TRIGGER_CLICK = 'click';
  const TRIGGER_MANUAL = 'manual';
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  class Tooltip extends BaseComponent {
    constructor(element, config) {
      if (typeof Popper__namespace === 'undefined') {
        throw new TypeError('Bootstrap\'s tooltips require Popper (https://popper.js.org)');
      }

      super(element); // private

      this._isEnabled = true;
      this._timeout = 0;
      this._hoverState = '';
      this._activeTrigger = {};
      this._popper = null; // Protected

      this._config = this._getConfig(config);
      this.tip = null;

      this._setListeners();
    } // Getters


    static get Default() {
      return Default$3;
    }

    static get NAME() {
      return NAME$4;
    }

    static get Event() {
      return Event$2;
    }

    static get DefaultType() {
      return DefaultType$3;
    } // Public


    enable() {
      this._isEnabled = true;
    }

    disable() {
      this._isEnabled = false;
    }

    toggleEnabled() {
      this._isEnabled = !this._isEnabled;
    }

    toggle(event) {
      if (!this._isEnabled) {
        return;
      }

      if (event) {
        const context = this._initializeOnDelegatedTarget(event);

        context._activeTrigger.click = !context._activeTrigger.click;

        if (context._isWithActiveTrigger()) {
          context._enter(null, context);
        } else {
          context._leave(null, context);
        }
      } else {
        if (this.getTipElement().classList.contains(CLASS_NAME_SHOW$3)) {
          this._leave(null, this);

          return;
        }

        this._enter(null, this);
      }
    }

    dispose() {
      clearTimeout(this._timeout);
      EventHandler.off(this._element.closest(`.${CLASS_NAME_MODAL}`), 'hide.bs.modal', this._hideModalHandler);

      if (this.tip) {
        this.tip.remove();
      }

      if (this._popper) {
        this._popper.destroy();
      }

      super.dispose();
    }

    show() {
      if (this._element.style.display === 'none') {
        throw new Error('Please use show on visible elements');
      }

      if (!(this.isWithContent() && this._isEnabled)) {
        return;
      }

      const showEvent = EventHandler.trigger(this._element, this.constructor.Event.SHOW);
      const shadowRoot = findShadowRoot(this._element);
      const isInTheDom = shadowRoot === null ? this._element.ownerDocument.documentElement.contains(this._element) : shadowRoot.contains(this._element);

      if (showEvent.defaultPrevented || !isInTheDom) {
        return;
      }

      const tip = this.getTipElement();
      const tipId = getUID(this.constructor.NAME);
      tip.setAttribute('id', tipId);

      this._element.setAttribute('aria-describedby', tipId);

      this.setContent();

      if (this._config.animation) {
        tip.classList.add(CLASS_NAME_FADE$3);
      }

      const placement = typeof this._config.placement === 'function' ? this._config.placement.call(this, tip, this._element) : this._config.placement;

      const attachment = this._getAttachment(placement);

      this._addAttachmentClass(attachment);

      const {
        container
      } = this._config;
      Data.set(tip, this.constructor.DATA_KEY, this);

      if (!this._element.ownerDocument.documentElement.contains(this.tip)) {
        container.appendChild(tip);
        EventHandler.trigger(this._element, this.constructor.Event.INSERTED);
      }

      if (this._popper) {
        this._popper.update();
      } else {
        this._popper = Popper__namespace.createPopper(this._element, tip, this._getPopperConfig(attachment));
      }

      tip.classList.add(CLASS_NAME_SHOW$3);
      const customClass = typeof this._config.customClass === 'function' ? this._config.customClass() : this._config.customClass;

      if (customClass) {
        tip.classList.add(...customClass.split(' '));
      } // If this is a touch-enabled device we add extra
      // empty mouseover listeners to the body's immediate children;
      // only needed because of broken event delegation on iOS
      // https://www.quirksmode.org/blog/archives/2014/02/mouse_event_bub.html


      if ('ontouchstart' in document.documentElement) {
        [].concat(...document.body.children).forEach(element => {
          EventHandler.on(element, 'mouseover', noop);
        });
      }

      const complete = () => {
        const prevHoverState = this._hoverState;
        this._hoverState = null;
        EventHandler.trigger(this._element, this.constructor.Event.SHOWN);

        if (prevHoverState === HOVER_STATE_OUT) {
          this._leave(null, this);
        }
      };

      const isAnimated = this.tip.classList.contains(CLASS_NAME_FADE$3);

      this._queueCallback(complete, this.tip, isAnimated);
    }

    hide() {
      if (!this._popper) {
        return;
      }

      const tip = this.getTipElement();

      const complete = () => {
        if (this._isWithActiveTrigger()) {
          return;
        }

        if (this._hoverState !== HOVER_STATE_SHOW) {
          tip.remove();
        }

        this._cleanTipClass();

        this._element.removeAttribute('aria-describedby');

        EventHandler.trigger(this._element, this.constructor.Event.HIDDEN);

        if (this._popper) {
          this._popper.destroy();

          this._popper = null;
        }
      };

      const hideEvent = EventHandler.trigger(this._element, this.constructor.Event.HIDE);

      if (hideEvent.defaultPrevented) {
        return;
      }

      tip.classList.remove(CLASS_NAME_SHOW$3); // If this is a touch-enabled device we remove the extra
      // empty mouseover listeners we added for iOS support

      if ('ontouchstart' in document.documentElement) {
        [].concat(...document.body.children).forEach(element => EventHandler.off(element, 'mouseover', noop));
      }

      this._activeTrigger[TRIGGER_CLICK] = false;
      this._activeTrigger[TRIGGER_FOCUS] = false;
      this._activeTrigger[TRIGGER_HOVER] = false;
      const isAnimated = this.tip.classList.contains(CLASS_NAME_FADE$3);

      this._queueCallback(complete, this.tip, isAnimated);

      this._hoverState = '';
    }

    update() {
      if (this._popper !== null) {
        this._popper.update();
      }
    } // Protected


    isWithContent() {
      return Boolean(this.getTitle());
    }

    getTipElement() {
      if (this.tip) {
        return this.tip;
      }

      const element = document.createElement('div');
      element.innerHTML = this._config.template;
      this.tip = element.children[0];
      return this.tip;
    }

    setContent() {
      const tip = this.getTipElement();
      this.setElementContent(SelectorEngine.findOne(SELECTOR_TOOLTIP_INNER, tip), this.getTitle());
      tip.classList.remove(CLASS_NAME_FADE$3, CLASS_NAME_SHOW$3);
    }

    setElementContent(element, content) {
      if (element === null) {
        return;
      }

      if (isElement(content)) {
        content = getElement(content); // content is a DOM node or a jQuery

        if (this._config.html) {
          if (content.parentNode !== element) {
            element.innerHTML = '';
            element.appendChild(content);
          }
        } else {
          element.textContent = content.textContent;
        }

        return;
      }

      if (this._config.html) {
        if (this._config.sanitize) {
          content = sanitizeHtml(content, this._config.allowList, this._config.sanitizeFn);
        }

        element.innerHTML = content;
      } else {
        element.textContent = content;
      }
    }

    getTitle() {
      let title = this._element.getAttribute('data-bs-original-title');

      if (!title) {
        title = typeof this._config.title === 'function' ? this._config.title.call(this._element) : this._config.title;
      }

      return title;
    }

    updateAttachment(attachment) {
      if (attachment === 'right') {
        return 'end';
      }

      if (attachment === 'left') {
        return 'start';
      }

      return attachment;
    } // Private


    _initializeOnDelegatedTarget(event, context) {
      const dataKey = this.constructor.DATA_KEY;
      context = context || Data.get(event.delegateTarget, dataKey);

      if (!context) {
        context = new this.constructor(event.delegateTarget, this._getDelegateConfig());
        Data.set(event.delegateTarget, dataKey, context);
      }

      return context;
    }

    _getOffset() {
      const {
        offset
      } = this._config;

      if (typeof offset === 'string') {
        return offset.split(',').map(val => Number.parseInt(val, 10));
      }

      if (typeof offset === 'function') {
        return popperData => offset(popperData, this._element);
      }

      return offset;
    }

    _getPopperConfig(attachment) {
      const defaultBsPopperConfig = {
        placement: attachment,
        modifiers: [{
          name: 'flip',
          options: {
            fallbackPlacements: this._config.fallbackPlacements
          }
        }, {
          name: 'offset',
          options: {
            offset: this._getOffset()
          }
        }, {
          name: 'preventOverflow',
          options: {
            boundary: this._config.boundary
          }
        }, {
          name: 'arrow',
          options: {
            element: `.${this.constructor.NAME}-arrow`
          }
        }, {
          name: 'onChange',
          enabled: true,
          phase: 'afterWrite',
          fn: data => this._handlePopperPlacementChange(data)
        }],
        onFirstUpdate: data => {
          if (data.options.placement !== data.placement) {
            this._handlePopperPlacementChange(data);
          }
        }
      };
      return { ...defaultBsPopperConfig,
        ...(typeof this._config.popperConfig === 'function' ? this._config.popperConfig(defaultBsPopperConfig) : this._config.popperConfig)
      };
    }

    _addAttachmentClass(attachment) {
      this.getTipElement().classList.add(`${CLASS_PREFIX$1}-${this.updateAttachment(attachment)}`);
    }

    _getAttachment(placement) {
      return AttachmentMap[placement.toUpperCase()];
    }

    _setListeners() {
      const triggers = this._config.trigger.split(' ');

      triggers.forEach(trigger => {
        if (trigger === 'click') {
          EventHandler.on(this._element, this.constructor.Event.CLICK, this._config.selector, event => this.toggle(event));
        } else if (trigger !== TRIGGER_MANUAL) {
          const eventIn = trigger === TRIGGER_HOVER ? this.constructor.Event.MOUSEENTER : this.constructor.Event.FOCUSIN;
          const eventOut = trigger === TRIGGER_HOVER ? this.constructor.Event.MOUSELEAVE : this.constructor.Event.FOCUSOUT;
          EventHandler.on(this._element, eventIn, this._config.selector, event => this._enter(event));
          EventHandler.on(this._element, eventOut, this._config.selector, event => this._leave(event));
        }
      });

      this._hideModalHandler = () => {
        if (this._element) {
          this.hide();
        }
      };

      EventHandler.on(this._element.closest(`.${CLASS_NAME_MODAL}`), 'hide.bs.modal', this._hideModalHandler);

      if (this._config.selector) {
        this._config = { ...this._config,
          trigger: 'manual',
          selector: ''
        };
      } else {
        this._fixTitle();
      }
    }

    _fixTitle() {
      const title = this._element.getAttribute('title');

      const originalTitleType = typeof this._element.getAttribute('data-bs-original-title');

      if (title || originalTitleType !== 'string') {
        this._element.setAttribute('data-bs-original-title', title || '');

        if (title && !this._element.getAttribute('aria-label') && !this._element.textContent) {
          this._element.setAttribute('aria-label', title);
        }

        this._element.setAttribute('title', '');
      }
    }

    _enter(event, context) {
      context = this._initializeOnDelegatedTarget(event, context);

      if (event) {
        context._activeTrigger[event.type === 'focusin' ? TRIGGER_FOCUS : TRIGGER_HOVER] = true;
      }

      if (context.getTipElement().classList.contains(CLASS_NAME_SHOW$3) || context._hoverState === HOVER_STATE_SHOW) {
        context._hoverState = HOVER_STATE_SHOW;
        return;
      }

      clearTimeout(context._timeout);
      context._hoverState = HOVER_STATE_SHOW;

      if (!context._config.delay || !context._config.delay.show) {
        context.show();
        return;
      }

      context._timeout = setTimeout(() => {
        if (context._hoverState === HOVER_STATE_SHOW) {
          context.show();
        }
      }, context._config.delay.show);
    }

    _leave(event, context) {
      context = this._initializeOnDelegatedTarget(event, context);

      if (event) {
        context._activeTrigger[event.type === 'focusout' ? TRIGGER_FOCUS : TRIGGER_HOVER] = context._element.contains(event.relatedTarget);
      }

      if (context._isWithActiveTrigger()) {
        return;
      }

      clearTimeout(context._timeout);
      context._hoverState = HOVER_STATE_OUT;

      if (!context._config.delay || !context._config.delay.hide) {
        context.hide();
        return;
      }

      context._timeout = setTimeout(() => {
        if (context._hoverState === HOVER_STATE_OUT) {
          context.hide();
        }
      }, context._config.delay.hide);
    }

    _isWithActiveTrigger() {
      for (const trigger in this._activeTrigger) {
        if (this._activeTrigger[trigger]) {
          return true;
        }
      }

      return false;
    }

    _getConfig(config) {
      const dataAttributes = Manipulator.getDataAttributes(this._element);
      Object.keys(dataAttributes).forEach(dataAttr => {
        if (DISALLOWED_ATTRIBUTES.has(dataAttr)) {
          delete dataAttributes[dataAttr];
        }
      });
      config = { ...this.constructor.Default,
        ...dataAttributes,
        ...(typeof config === 'object' && config ? config : {})
      };
      config.container = config.container === false ? document.body : getElement(config.container);

      if (typeof config.delay === 'number') {
        config.delay = {
          show: config.delay,
          hide: config.delay
        };
      }

      if (typeof config.title === 'number') {
        config.title = config.title.toString();
      }

      if (typeof config.content === 'number') {
        config.content = config.content.toString();
      }

      typeCheckConfig(NAME$4, config, this.constructor.DefaultType);

      if (config.sanitize) {
        config.template = sanitizeHtml(config.template, config.allowList, config.sanitizeFn);
      }

      return config;
    }

    _getDelegateConfig() {
      const config = {};

      if (this._config) {
        for (const key in this._config) {
          if (this.constructor.Default[key] !== this._config[key]) {
            config[key] = this._config[key];
          }
        }
      }

      return config;
    }

    _cleanTipClass() {
      const tip = this.getTipElement();
      const tabClass = tip.getAttribute('class').match(BSCLS_PREFIX_REGEX$1);

      if (tabClass !== null && tabClass.length > 0) {
        tabClass.map(token => token.trim()).forEach(tClass => tip.classList.remove(tClass));
      }
    }

    _handlePopperPlacementChange(popperData) {
      const {
        state
      } = popperData;

      if (!state) {
        return;
      }

      this.tip = state.elements.popper;

      this._cleanTipClass();

      this._addAttachmentClass(this._getAttachment(state.placement));
    } // Static


    static jQueryInterface(config) {
      return this.each(function () {
        const data = Tooltip.getOrCreateInstance(this, config);

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError(`No method named "${config}"`);
          }

          data[config]();
        }
      });
    }

  }
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   * add .Tooltip to jQuery only if jQuery is present
   */


  defineJQueryPlugin(Tooltip);

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): popover.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  const NAME$3 = 'popover';
  const DATA_KEY$3 = 'bs.popover';
  const EVENT_KEY$3 = `.${DATA_KEY$3}`;
  const CLASS_PREFIX = 'bs-popover';
  const BSCLS_PREFIX_REGEX = new RegExp(`(^|\\s)${CLASS_PREFIX}\\S+`, 'g');
  const Default$2 = { ...Tooltip.Default,
    placement: 'right',
    offset: [0, 8],
    trigger: 'click',
    content: '',
    template: '<div class="popover" role="tooltip">' + '<div class="popover-arrow"></div>' + '<h3 class="popover-header"></h3>' + '<div class="popover-body"></div>' + '</div>'
  };
  const DefaultType$2 = { ...Tooltip.DefaultType,
    content: '(string|element|function)'
  };
  const Event$1 = {
    HIDE: `hide${EVENT_KEY$3}`,
    HIDDEN: `hidden${EVENT_KEY$3}`,
    SHOW: `show${EVENT_KEY$3}`,
    SHOWN: `shown${EVENT_KEY$3}`,
    INSERTED: `inserted${EVENT_KEY$3}`,
    CLICK: `click${EVENT_KEY$3}`,
    FOCUSIN: `focusin${EVENT_KEY$3}`,
    FOCUSOUT: `focusout${EVENT_KEY$3}`,
    MOUSEENTER: `mouseenter${EVENT_KEY$3}`,
    MOUSELEAVE: `mouseleave${EVENT_KEY$3}`
  };
  const CLASS_NAME_FADE$2 = 'fade';
  const CLASS_NAME_SHOW$2 = 'show';
  const SELECTOR_TITLE = '.popover-header';
  const SELECTOR_CONTENT = '.popover-body';
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  class Popover extends Tooltip {
    // Getters
    static get Default() {
      return Default$2;
    }

    static get NAME() {
      return NAME$3;
    }

    static get Event() {
      return Event$1;
    }

    static get DefaultType() {
      return DefaultType$2;
    } // Overrides


    isWithContent() {
      return this.getTitle() || this._getContent();
    }

    getTipElement() {
      if (this.tip) {
        return this.tip;
      }

      this.tip = super.getTipElement();

      if (!this.getTitle()) {
        SelectorEngine.findOne(SELECTOR_TITLE, this.tip).remove();
      }

      if (!this._getContent()) {
        SelectorEngine.findOne(SELECTOR_CONTENT, this.tip).remove();
      }

      return this.tip;
    }

    setContent() {
      const tip = this.getTipElement(); // we use append for html objects to maintain js events

      this.setElementContent(SelectorEngine.findOne(SELECTOR_TITLE, tip), this.getTitle());

      let content = this._getContent();

      if (typeof content === 'function') {
        content = content.call(this._element);
      }

      this.setElementContent(SelectorEngine.findOne(SELECTOR_CONTENT, tip), content);
      tip.classList.remove(CLASS_NAME_FADE$2, CLASS_NAME_SHOW$2);
    } // Private


    _addAttachmentClass(attachment) {
      this.getTipElement().classList.add(`${CLASS_PREFIX}-${this.updateAttachment(attachment)}`);
    }

    _getContent() {
      return this._element.getAttribute('data-bs-content') || this._config.content;
    }

    _cleanTipClass() {
      const tip = this.getTipElement();
      const tabClass = tip.getAttribute('class').match(BSCLS_PREFIX_REGEX);

      if (tabClass !== null && tabClass.length > 0) {
        tabClass.map(token => token.trim()).forEach(tClass => tip.classList.remove(tClass));
      }
    } // Static


    static jQueryInterface(config) {
      return this.each(function () {
        const data = Popover.getOrCreateInstance(this, config);

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError(`No method named "${config}"`);
          }

          data[config]();
        }
      });
    }

  }
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   * add .Popover to jQuery only if jQuery is present
   */


  defineJQueryPlugin(Popover);

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): scrollspy.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  const NAME$2 = 'scrollspy';
  const DATA_KEY$2 = 'bs.scrollspy';
  const EVENT_KEY$2 = `.${DATA_KEY$2}`;
  const DATA_API_KEY$1 = '.data-api';
  const Default$1 = {
    offset: 10,
    method: 'auto',
    target: ''
  };
  const DefaultType$1 = {
    offset: 'number',
    method: 'string',
    target: '(string|element)'
  };
  const EVENT_ACTIVATE = `activate${EVENT_KEY$2}`;
  const EVENT_SCROLL = `scroll${EVENT_KEY$2}`;
  const EVENT_LOAD_DATA_API = `load${EVENT_KEY$2}${DATA_API_KEY$1}`;
  const CLASS_NAME_DROPDOWN_ITEM = 'dropdown-item';
  const CLASS_NAME_ACTIVE$1 = 'active';
  const SELECTOR_DATA_SPY = '[data-bs-spy="scroll"]';
  const SELECTOR_NAV_LIST_GROUP$1 = '.nav, .list-group';
  const SELECTOR_NAV_LINKS = '.nav-link';
  const SELECTOR_NAV_ITEMS = '.nav-item';
  const SELECTOR_LIST_ITEMS = '.list-group-item';
  const SELECTOR_DROPDOWN$1 = '.dropdown';
  const SELECTOR_DROPDOWN_TOGGLE$1 = '.dropdown-toggle';
  const METHOD_OFFSET = 'offset';
  const METHOD_POSITION = 'position';
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  class ScrollSpy extends BaseComponent {
    constructor(element, config) {
      super(element);
      this._scrollElement = this._element.tagName === 'BODY' ? window : this._element;
      this._config = this._getConfig(config);
      this._selector = `${this._config.target} ${SELECTOR_NAV_LINKS}, ${this._config.target} ${SELECTOR_LIST_ITEMS}, ${this._config.target} .${CLASS_NAME_DROPDOWN_ITEM}`;
      this._offsets = [];
      this._targets = [];
      this._activeTarget = null;
      this._scrollHeight = 0;
      EventHandler.on(this._scrollElement, EVENT_SCROLL, () => this._process());
      this.refresh();

      this._process();
    } // Getters


    static get Default() {
      return Default$1;
    }

    static get NAME() {
      return NAME$2;
    } // Public


    refresh() {
      const autoMethod = this._scrollElement === this._scrollElement.window ? METHOD_OFFSET : METHOD_POSITION;
      const offsetMethod = this._config.method === 'auto' ? autoMethod : this._config.method;
      const offsetBase = offsetMethod === METHOD_POSITION ? this._getScrollTop() : 0;
      this._offsets = [];
      this._targets = [];
      this._scrollHeight = this._getScrollHeight();
      const targets = SelectorEngine.find(this._selector);
      targets.map(element => {
        const targetSelector = getSelectorFromElement(element);
        const target = targetSelector ? SelectorEngine.findOne(targetSelector) : null;

        if (target) {
          const targetBCR = target.getBoundingClientRect();

          if (targetBCR.width || targetBCR.height) {
            return [Manipulator[offsetMethod](target).top + offsetBase, targetSelector];
          }
        }

        return null;
      }).filter(item => item).sort((a, b) => a[0] - b[0]).forEach(item => {
        this._offsets.push(item[0]);

        this._targets.push(item[1]);
      });
    }

    dispose() {
      EventHandler.off(this._scrollElement, EVENT_KEY$2);
      super.dispose();
    } // Private


    _getConfig(config) {
      config = { ...Default$1,
        ...Manipulator.getDataAttributes(this._element),
        ...(typeof config === 'object' && config ? config : {})
      };

      if (typeof config.target !== 'string' && isElement(config.target)) {
        let {
          id
        } = config.target;

        if (!id) {
          id = getUID(NAME$2);
          config.target.id = id;
        }

        config.target = `#${id}`;
      }

      typeCheckConfig(NAME$2, config, DefaultType$1);
      return config;
    }

    _getScrollTop() {
      return this._scrollElement === window ? this._scrollElement.pageYOffset : this._scrollElement.scrollTop;
    }

    _getScrollHeight() {
      return this._scrollElement.scrollHeight || Math.max(document.body.scrollHeight, document.documentElement.scrollHeight);
    }

    _getOffsetHeight() {
      return this._scrollElement === window ? window.innerHeight : this._scrollElement.getBoundingClientRect().height;
    }

    _process() {
      const scrollTop = this._getScrollTop() + this._config.offset;

      const scrollHeight = this._getScrollHeight();

      const maxScroll = this._config.offset + scrollHeight - this._getOffsetHeight();

      if (this._scrollHeight !== scrollHeight) {
        this.refresh();
      }

      if (scrollTop >= maxScroll) {
        const target = this._targets[this._targets.length - 1];

        if (this._activeTarget !== target) {
          this._activate(target);
        }

        return;
      }

      if (this._activeTarget && scrollTop < this._offsets[0] && this._offsets[0] > 0) {
        this._activeTarget = null;

        this._clear();

        return;
      }

      for (let i = this._offsets.length; i--;) {
        const isActiveTarget = this._activeTarget !== this._targets[i] && scrollTop >= this._offsets[i] && (typeof this._offsets[i + 1] === 'undefined' || scrollTop < this._offsets[i + 1]);

        if (isActiveTarget) {
          this._activate(this._targets[i]);
        }
      }
    }

    _activate(target) {
      this._activeTarget = target;

      this._clear();

      const queries = this._selector.split(',').map(selector => `${selector}[data-bs-target="${target}"],${selector}[href="${target}"]`);

      const link = SelectorEngine.findOne(queries.join(','));

      if (link.classList.contains(CLASS_NAME_DROPDOWN_ITEM)) {
        SelectorEngine.findOne(SELECTOR_DROPDOWN_TOGGLE$1, link.closest(SELECTOR_DROPDOWN$1)).classList.add(CLASS_NAME_ACTIVE$1);
        link.classList.add(CLASS_NAME_ACTIVE$1);
      } else {
        // Set triggered link as active
        link.classList.add(CLASS_NAME_ACTIVE$1);
        SelectorEngine.parents(link, SELECTOR_NAV_LIST_GROUP$1).forEach(listGroup => {
          // Set triggered links parents as active
          // With both <ul> and <nav> markup a parent is the previous sibling of any nav ancestor
          SelectorEngine.prev(listGroup, `${SELECTOR_NAV_LINKS}, ${SELECTOR_LIST_ITEMS}`).forEach(item => item.classList.add(CLASS_NAME_ACTIVE$1)); // Handle special case when .nav-link is inside .nav-item

          SelectorEngine.prev(listGroup, SELECTOR_NAV_ITEMS).forEach(navItem => {
            SelectorEngine.children(navItem, SELECTOR_NAV_LINKS).forEach(item => item.classList.add(CLASS_NAME_ACTIVE$1));
          });
        });
      }

      EventHandler.trigger(this._scrollElement, EVENT_ACTIVATE, {
        relatedTarget: target
      });
    }

    _clear() {
      SelectorEngine.find(this._selector).filter(node => node.classList.contains(CLASS_NAME_ACTIVE$1)).forEach(node => node.classList.remove(CLASS_NAME_ACTIVE$1));
    } // Static


    static jQueryInterface(config) {
      return this.each(function () {
        const data = ScrollSpy.getOrCreateInstance(this, config);

        if (typeof config !== 'string') {
          return;
        }

        if (typeof data[config] === 'undefined') {
          throw new TypeError(`No method named "${config}"`);
        }

        data[config]();
      });
    }

  }
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  EventHandler.on(window, EVENT_LOAD_DATA_API, () => {
    SelectorEngine.find(SELECTOR_DATA_SPY).forEach(spy => new ScrollSpy(spy));
  });
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   * add .ScrollSpy to jQuery only if jQuery is present
   */

  defineJQueryPlugin(ScrollSpy);

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): tab.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  const NAME$1 = 'tab';
  const DATA_KEY$1 = 'bs.tab';
  const EVENT_KEY$1 = `.${DATA_KEY$1}`;
  const DATA_API_KEY = '.data-api';
  const EVENT_HIDE$1 = `hide${EVENT_KEY$1}`;
  const EVENT_HIDDEN$1 = `hidden${EVENT_KEY$1}`;
  const EVENT_SHOW$1 = `show${EVENT_KEY$1}`;
  const EVENT_SHOWN$1 = `shown${EVENT_KEY$1}`;
  const EVENT_CLICK_DATA_API = `click${EVENT_KEY$1}${DATA_API_KEY}`;
  const CLASS_NAME_DROPDOWN_MENU = 'dropdown-menu';
  const CLASS_NAME_ACTIVE = 'active';
  const CLASS_NAME_FADE$1 = 'fade';
  const CLASS_NAME_SHOW$1 = 'show';
  const SELECTOR_DROPDOWN = '.dropdown';
  const SELECTOR_NAV_LIST_GROUP = '.nav, .list-group';
  const SELECTOR_ACTIVE = '.active';
  const SELECTOR_ACTIVE_UL = ':scope > li > .active';
  const SELECTOR_DATA_TOGGLE = '[data-bs-toggle="tab"], [data-bs-toggle="pill"], [data-bs-toggle="list"]';
  const SELECTOR_DROPDOWN_TOGGLE = '.dropdown-toggle';
  const SELECTOR_DROPDOWN_ACTIVE_CHILD = ':scope > .dropdown-menu .active';
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  class Tab extends BaseComponent {
    // Getters
    static get NAME() {
      return NAME$1;
    } // Public


    show() {
      if (this._element.parentNode && this._element.parentNode.nodeType === Node.ELEMENT_NODE && this._element.classList.contains(CLASS_NAME_ACTIVE)) {
        return;
      }

      let previous;
      const target = getElementFromSelector(this._element);

      const listElement = this._element.closest(SELECTOR_NAV_LIST_GROUP);

      if (listElement) {
        const itemSelector = listElement.nodeName === 'UL' || listElement.nodeName === 'OL' ? SELECTOR_ACTIVE_UL : SELECTOR_ACTIVE;
        previous = SelectorEngine.find(itemSelector, listElement);
        previous = previous[previous.length - 1];
      }

      const hideEvent = previous ? EventHandler.trigger(previous, EVENT_HIDE$1, {
        relatedTarget: this._element
      }) : null;
      const showEvent = EventHandler.trigger(this._element, EVENT_SHOW$1, {
        relatedTarget: previous
      });

      if (showEvent.defaultPrevented || hideEvent !== null && hideEvent.defaultPrevented) {
        return;
      }

      this._activate(this._element, listElement);

      const complete = () => {
        EventHandler.trigger(previous, EVENT_HIDDEN$1, {
          relatedTarget: this._element
        });
        EventHandler.trigger(this._element, EVENT_SHOWN$1, {
          relatedTarget: previous
        });
      };

      if (target) {
        this._activate(target, target.parentNode, complete);
      } else {
        complete();
      }
    } // Private


    _activate(element, container, callback) {
      const activeElements = container && (container.nodeName === 'UL' || container.nodeName === 'OL') ? SelectorEngine.find(SELECTOR_ACTIVE_UL, container) : SelectorEngine.children(container, SELECTOR_ACTIVE);
      const active = activeElements[0];
      const isTransitioning = callback && active && active.classList.contains(CLASS_NAME_FADE$1);

      const complete = () => this._transitionComplete(element, active, callback);

      if (active && isTransitioning) {
        active.classList.remove(CLASS_NAME_SHOW$1);

        this._queueCallback(complete, element, true);
      } else {
        complete();
      }
    }

    _transitionComplete(element, active, callback) {
      if (active) {
        active.classList.remove(CLASS_NAME_ACTIVE);
        const dropdownChild = SelectorEngine.findOne(SELECTOR_DROPDOWN_ACTIVE_CHILD, active.parentNode);

        if (dropdownChild) {
          dropdownChild.classList.remove(CLASS_NAME_ACTIVE);
        }

        if (active.getAttribute('role') === 'tab') {
          active.setAttribute('aria-selected', false);
        }
      }

      element.classList.add(CLASS_NAME_ACTIVE);

      if (element.getAttribute('role') === 'tab') {
        element.setAttribute('aria-selected', true);
      }

      reflow(element);

      if (element.classList.contains(CLASS_NAME_FADE$1)) {
        element.classList.add(CLASS_NAME_SHOW$1);
      }

      let parent = element.parentNode;

      if (parent && parent.nodeName === 'LI') {
        parent = parent.parentNode;
      }

      if (parent && parent.classList.contains(CLASS_NAME_DROPDOWN_MENU)) {
        const dropdownElement = element.closest(SELECTOR_DROPDOWN);

        if (dropdownElement) {
          SelectorEngine.find(SELECTOR_DROPDOWN_TOGGLE, dropdownElement).forEach(dropdown => dropdown.classList.add(CLASS_NAME_ACTIVE));
        }

        element.setAttribute('aria-expanded', true);
      }

      if (callback) {
        callback();
      }
    } // Static


    static jQueryInterface(config) {
      return this.each(function () {
        const data = Tab.getOrCreateInstance(this);

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError(`No method named "${config}"`);
          }

          data[config]();
        }
      });
    }

  }
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  EventHandler.on(document, EVENT_CLICK_DATA_API, SELECTOR_DATA_TOGGLE, function (event) {
    if (['A', 'AREA'].includes(this.tagName)) {
      event.preventDefault();
    }

    if (isDisabled(this)) {
      return;
    }

    const data = Tab.getOrCreateInstance(this);
    data.show();
  });
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   * add .Tab to jQuery only if jQuery is present
   */

  defineJQueryPlugin(Tab);

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): toast.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  const NAME = 'toast';
  const DATA_KEY = 'bs.toast';
  const EVENT_KEY = `.${DATA_KEY}`;
  const EVENT_CLICK_DISMISS = `click.dismiss${EVENT_KEY}`;
  const EVENT_MOUSEOVER = `mouseover${EVENT_KEY}`;
  const EVENT_MOUSEOUT = `mouseout${EVENT_KEY}`;
  const EVENT_FOCUSIN = `focusin${EVENT_KEY}`;
  const EVENT_FOCUSOUT = `focusout${EVENT_KEY}`;
  const EVENT_HIDE = `hide${EVENT_KEY}`;
  const EVENT_HIDDEN = `hidden${EVENT_KEY}`;
  const EVENT_SHOW = `show${EVENT_KEY}`;
  const EVENT_SHOWN = `shown${EVENT_KEY}`;
  const CLASS_NAME_FADE = 'fade';
  const CLASS_NAME_HIDE = 'hide';
  const CLASS_NAME_SHOW = 'show';
  const CLASS_NAME_SHOWING = 'showing';
  const DefaultType = {
    animation: 'boolean',
    autohide: 'boolean',
    delay: 'number'
  };
  const Default = {
    animation: true,
    autohide: true,
    delay: 5000
  };
  const SELECTOR_DATA_DISMISS = '[data-bs-dismiss="toast"]';
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  class Toast extends BaseComponent {
    constructor(element, config) {
      super(element);
      this._config = this._getConfig(config);
      this._timeout = null;
      this._hasMouseInteraction = false;
      this._hasKeyboardInteraction = false;

      this._setListeners();
    } // Getters


    static get DefaultType() {
      return DefaultType;
    }

    static get Default() {
      return Default;
    }

    static get NAME() {
      return NAME;
    } // Public


    show() {
      const showEvent = EventHandler.trigger(this._element, EVENT_SHOW);

      if (showEvent.defaultPrevented) {
        return;
      }

      this._clearTimeout();

      if (this._config.animation) {
        this._element.classList.add(CLASS_NAME_FADE);
      }

      const complete = () => {
        this._element.classList.remove(CLASS_NAME_SHOWING);

        this._element.classList.add(CLASS_NAME_SHOW);

        EventHandler.trigger(this._element, EVENT_SHOWN);

        this._maybeScheduleHide();
      };

      this._element.classList.remove(CLASS_NAME_HIDE);

      reflow(this._element);

      this._element.classList.add(CLASS_NAME_SHOWING);

      this._queueCallback(complete, this._element, this._config.animation);
    }

    hide() {
      if (!this._element.classList.contains(CLASS_NAME_SHOW)) {
        return;
      }

      const hideEvent = EventHandler.trigger(this._element, EVENT_HIDE);

      if (hideEvent.defaultPrevented) {
        return;
      }

      const complete = () => {
        this._element.classList.add(CLASS_NAME_HIDE);

        EventHandler.trigger(this._element, EVENT_HIDDEN);
      };

      this._element.classList.remove(CLASS_NAME_SHOW);

      this._queueCallback(complete, this._element, this._config.animation);
    }

    dispose() {
      this._clearTimeout();

      if (this._element.classList.contains(CLASS_NAME_SHOW)) {
        this._element.classList.remove(CLASS_NAME_SHOW);
      }

      super.dispose();
    } // Private


    _getConfig(config) {
      config = { ...Default,
        ...Manipulator.getDataAttributes(this._element),
        ...(typeof config === 'object' && config ? config : {})
      };
      typeCheckConfig(NAME, config, this.constructor.DefaultType);
      return config;
    }

    _maybeScheduleHide() {
      if (!this._config.autohide) {
        return;
      }

      if (this._hasMouseInteraction || this._hasKeyboardInteraction) {
        return;
      }

      this._timeout = setTimeout(() => {
        this.hide();
      }, this._config.delay);
    }

    _onInteraction(event, isInteracting) {
      switch (event.type) {
        case 'mouseover':
        case 'mouseout':
          this._hasMouseInteraction = isInteracting;
          break;

        case 'focusin':
        case 'focusout':
          this._hasKeyboardInteraction = isInteracting;
          break;
      }

      if (isInteracting) {
        this._clearTimeout();

        return;
      }

      const nextElement = event.relatedTarget;

      if (this._element === nextElement || this._element.contains(nextElement)) {
        return;
      }

      this._maybeScheduleHide();
    }

    _setListeners() {
      EventHandler.on(this._element, EVENT_CLICK_DISMISS, SELECTOR_DATA_DISMISS, () => this.hide());
      EventHandler.on(this._element, EVENT_MOUSEOVER, event => this._onInteraction(event, true));
      EventHandler.on(this._element, EVENT_MOUSEOUT, event => this._onInteraction(event, false));
      EventHandler.on(this._element, EVENT_FOCUSIN, event => this._onInteraction(event, true));
      EventHandler.on(this._element, EVENT_FOCUSOUT, event => this._onInteraction(event, false));
    }

    _clearTimeout() {
      clearTimeout(this._timeout);
      this._timeout = null;
    } // Static


    static jQueryInterface(config) {
      return this.each(function () {
        const data = Toast.getOrCreateInstance(this, config);

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError(`No method named "${config}"`);
          }

          data[config](this);
        }
      });
    }

  }
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   * add .Toast to jQuery only if jQuery is present
   */


  defineJQueryPlugin(Toast);

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v5.0.2): index.umd.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  var index_umd = {
    Alert,
    Button,
    Carousel,
    Collapse,
    Dropdown,
    Modal,
    Offcanvas,
    Popover,
    ScrollSpy,
    Tab,
    Toast,
    Tooltip
  };

  return index_umd;

})));
//# sourceMappingURL=bootstrap.js.map

/**
 * CLDR JavaScript Library v0.5.1
 * http://jquery.com/
 *
 * Copyright 2013 Rafael Xavier de Souza
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2019-01-21T13:43Z
 */
/*!
 * CLDR JavaScript Library v0.5.1 2019-01-21T13:43Z MIT license © Rafael Xavier
 * http://git.io/h4lmVg
 */
(function( root, factory ) {

	if ( typeof define === "function" && define.amd ) {
		// AMD.
		define( factory );
	} else if ( typeof module === "object" && typeof module.exports === "object" ) {
		// Node. CommonJS.
		module.exports = factory();
	} else {
		// Global
		root.Cldr = factory();
	}

}( this, function() {


	var arrayIsArray = Array.isArray || function( obj ) {
		return Object.prototype.toString.call( obj ) === "[object Array]";
	};




	var pathNormalize = function( path, attributes ) {
		if ( arrayIsArray( path ) ) {
			path = path.join( "/" );
		}
		if ( typeof path !== "string" ) {
			throw new Error( "invalid path \"" + path + "\"" );
		}
		// 1: Ignore leading slash `/`
		// 2: Ignore leading `cldr/`
		path = path
			.replace( /^\// , "" ) /* 1 */
			.replace( /^cldr\// , "" ); /* 2 */

		// Replace {attribute}'s
		path = path.replace( /{[a-zA-Z]+}/g, function( name ) {
			name = name.replace( /^{([^}]*)}$/, "$1" );
			return attributes[ name ];
		});

		return path.split( "/" );
	};




	var arraySome = function( array, callback ) {
		var i, length;
		if ( array.some ) {
			return array.some( callback );
		}
		for ( i = 0, length = array.length; i < length; i++ ) {
			if ( callback( array[ i ], i, array ) ) {
				return true;
			}
		}
		return false;
	};




	/**
	 * Return the maximized language id as defined in
	 * http://www.unicode.org/reports/tr35/#Likely_Subtags
	 * 1. Canonicalize.
	 * 1.1 Make sure the input locale is in canonical form: uses the right
	 * separator, and has the right casing.
	 * TODO Right casing? What df? It seems languages are lowercase, scripts are
	 * Capitalized, territory is uppercase. I am leaving this as an exercise to
	 * the user.
	 *
	 * 1.2 Replace any deprecated subtags with their canonical values using the
	 * <alias> data in supplemental metadata. Use the first value in the
	 * replacement list, if it exists. Language tag replacements may have multiple
	 * parts, such as "sh" ➞ "sr_Latn" or mo" ➞ "ro_MD". In such a case, the
	 * original script and/or region are retained if there is one. Thus
	 * "sh_Arab_AQ" ➞ "sr_Arab_AQ", not "sr_Latn_AQ".
	 * TODO What <alias> data?
	 *
	 * 1.3 If the tag is grandfathered (see <variable id="$grandfathered"
	 * type="choice"> in the supplemental data), then return it.
	 * TODO grandfathered?
	 *
	 * 1.4 Remove the script code 'Zzzz' and the region code 'ZZ' if they occur.
	 * 1.5 Get the components of the cleaned-up source tag (languages, scripts,
	 * and regions), plus any variants and extensions.
	 * 2. Lookup. Lookup each of the following in order, and stop on the first
	 * match:
	 * 2.1 languages_scripts_regions
	 * 2.2 languages_regions
	 * 2.3 languages_scripts
	 * 2.4 languages
	 * 2.5 und_scripts
	 * 3. Return
	 * 3.1 If there is no match, either return an error value, or the match for
	 * "und" (in APIs where a valid language tag is required).
	 * 3.2 Otherwise there is a match = languagem_scriptm_regionm
	 * 3.3 Let xr = xs if xs is not empty, and xm otherwise.
	 * 3.4 Return the language tag composed of languager _ scriptr _ regionr +
	 * variants + extensions.
	 *
	 * @subtags [Array] normalized language id subtags tuple (see init.js).
	 */
	var coreLikelySubtags = function( Cldr, cldr, subtags, options ) {
		var match, matchFound,
			language = subtags[ 0 ],
			script = subtags[ 1 ],
			sep = Cldr.localeSep,
			territory = subtags[ 2 ],
			variants = subtags.slice( 3, 4 );
		options = options || {};

		// Skip if (language, script, territory) is not empty [3.3]
		if ( language !== "und" && script !== "Zzzz" && territory !== "ZZ" ) {
			return [ language, script, territory ].concat( variants );
		}

		// Skip if no supplemental likelySubtags data is present
		if ( typeof cldr.get( "supplemental/likelySubtags" ) === "undefined" ) {
			return;
		}

		// [2]
		matchFound = arraySome([
			[ language, script, territory ],
			[ language, territory ],
			[ language, script ],
			[ language ],
			[ "und", script ]
		], function( test ) {
			return match = !(/\b(Zzzz|ZZ)\b/).test( test.join( sep ) ) /* [1.4] */ && cldr.get( [ "supplemental/likelySubtags", test.join( sep ) ] );
		});

		// [3]
		if ( matchFound ) {
			// [3.2 .. 3.4]
			match = match.split( sep );
			return [
				language !== "und" ? language : match[ 0 ],
				script !== "Zzzz" ? script : match[ 1 ],
				territory !== "ZZ" ? territory : match[ 2 ]
			].concat( variants );
		} else if ( options.force ) {
			// [3.1.2]
			return cldr.get( "supplemental/likelySubtags/und" ).split( sep );
		} else {
			// [3.1.1]
			return;
		}
	};



	/**
	 * Given a locale, remove any fields that Add Likely Subtags would add.
	 * http://www.unicode.org/reports/tr35/#Likely_Subtags
	 * 1. First get max = AddLikelySubtags(inputLocale). If an error is signaled,
	 * return it.
	 * 2. Remove the variants from max.
	 * 3. Then for trial in {language, language _ region, language _ script}. If
	 * AddLikelySubtags(trial) = max, then return trial + variants.
	 * 4. If you do not get a match, return max + variants.
	 * 
	 * @maxLanguageId [Array] maxLanguageId tuple (see init.js).
	 */
	var coreRemoveLikelySubtags = function( Cldr, cldr, maxLanguageId ) {
		var match, matchFound,
			language = maxLanguageId[ 0 ],
			script = maxLanguageId[ 1 ],
			territory = maxLanguageId[ 2 ],
			variants = maxLanguageId[ 3 ];

		// [3]
		matchFound = arraySome([
			[ [ language, "Zzzz", "ZZ" ], [ language ] ],
			[ [ language, "Zzzz", territory ], [ language, territory ] ],
			[ [ language, script, "ZZ" ], [ language, script ] ]
		], function( test ) {
			var result = coreLikelySubtags( Cldr, cldr, test[ 0 ] );
			match = test[ 1 ];
			return result && result[ 0 ] === maxLanguageId[ 0 ] &&
				result[ 1 ] === maxLanguageId[ 1 ] &&
				result[ 2 ] === maxLanguageId[ 2 ];
		});

		if ( matchFound ) {
			if ( variants ) {
				match.push( variants );
			}
			return match;
		}

		// [4]
		return maxLanguageId;
	};




	/**
	 * subtags( locale )
	 *
	 * @locale [String]
	 */
	var coreSubtags = function( locale ) {
		var aux, unicodeLanguageId,
			subtags = [];

		locale = locale.replace( /_/, "-" );

		// Unicode locale extensions.
		aux = locale.split( "-u-" );
		if ( aux[ 1 ] ) {
			aux[ 1 ] = aux[ 1 ].split( "-t-" );
			locale = aux[ 0 ] + ( aux[ 1 ][ 1 ] ? "-t-" + aux[ 1 ][ 1 ] : "");
			subtags[ 4 /* unicodeLocaleExtensions */ ] = aux[ 1 ][ 0 ];
		}

		// TODO normalize transformed extensions. Currently, skipped.
		// subtags[ x ] = locale.split( "-t-" )[ 1 ];
		unicodeLanguageId = locale.split( "-t-" )[ 0 ];

		// unicode_language_id = "root"
		//   | unicode_language_subtag         
		//     (sep unicode_script_subtag)? 
		//     (sep unicode_region_subtag)?
		//     (sep unicode_variant_subtag)* ;
		//
		// Although unicode_language_subtag = alpha{2,8}, I'm using alpha{2,3}. Because, there's no language on CLDR lengthier than 3.
		aux = unicodeLanguageId.match( /^(([a-z]{2,3})(-([A-Z][a-z]{3}))?(-([A-Z]{2}|[0-9]{3}))?)((-([a-zA-Z0-9]{5,8}|[0-9][a-zA-Z0-9]{3}))*)$|^(root)$/ );
		if ( aux === null ) {
			return [ "und", "Zzzz", "ZZ" ];
		}
		subtags[ 0 /* language */ ] = aux[ 10 ] /* root */ || aux[ 2 ] || "und";
		subtags[ 1 /* script */ ] = aux[ 4 ] || "Zzzz";
		subtags[ 2 /* territory */ ] = aux[ 6 ] || "ZZ";
		if ( aux[ 7 ] && aux[ 7 ].length ) {
			subtags[ 3 /* variant */ ] = aux[ 7 ].slice( 1 ) /* remove leading "-" */;
		}

		// 0: language
		// 1: script
		// 2: territory (aka region)
		// 3: variant
		// 4: unicodeLocaleExtensions
		return subtags;
	};




	var arrayForEach = function( array, callback ) {
		var i, length;
		if ( array.forEach ) {
			return array.forEach( callback );
		}
		for ( i = 0, length = array.length; i < length; i++ ) {
			callback( array[ i ], i, array );
		}
	};




	/**
	 * bundleLookup( minLanguageId )
	 *
	 * @Cldr [Cldr class]
	 *
	 * @cldr [Cldr instance]
	 *
	 * @minLanguageId [String] requested languageId after applied remove likely subtags.
	 */
	var bundleLookup = function( Cldr, cldr, minLanguageId ) {
		var availableBundleMap = Cldr._availableBundleMap,
			availableBundleMapQueue = Cldr._availableBundleMapQueue;

		if ( availableBundleMapQueue.length ) {
			arrayForEach( availableBundleMapQueue, function( bundle ) {
				var existing, maxBundle, minBundle, subtags;
				subtags = coreSubtags( bundle );
				maxBundle = coreLikelySubtags( Cldr, cldr, subtags );
				minBundle = coreRemoveLikelySubtags( Cldr, cldr, maxBundle );
				minBundle = minBundle.join( Cldr.localeSep );
				existing = availableBundleMap[ minBundle ];
				if ( existing && existing.length < bundle.length ) {
					return;
				}
				availableBundleMap[ minBundle ] = bundle;
			});
			Cldr._availableBundleMapQueue = [];
		}

		return availableBundleMap[ minLanguageId ] || null;
	};




	var objectKeys = function( object ) {
		var i,
			result = [];

		if ( Object.keys ) {
			return Object.keys( object );
		}

		for ( i in object ) {
			result.push( i );
		}

		return result;
	};




	var createError = function( code, attributes ) {
		var error, message;

		message = code + ( attributes && JSON ? ": " + JSON.stringify( attributes ) : "" );
		error = new Error( message );
		error.code = code;

		// extend( error, attributes );
		arrayForEach( objectKeys( attributes ), function( attribute ) {
			error[ attribute ] = attributes[ attribute ];
		});

		return error;
	};




	var validate = function( code, check, attributes ) {
		if ( !check ) {
			throw createError( code, attributes );
		}
	};




	var validatePresence = function( value, name ) {
		validate( "E_MISSING_PARAMETER", typeof value !== "undefined", {
			name: name
		});
	};




	var validateType = function( value, name, check, expected ) {
		validate( "E_INVALID_PAR_TYPE", check, {
			expected: expected,
			name: name,
			value: value
		});
	};




	var validateTypePath = function( value, name ) {
		validateType( value, name, typeof value === "string" || arrayIsArray( value ), "String or Array" );
	};




	/**
	 * Function inspired by jQuery Core, but reduced to our use case.
	 */
	var isPlainObject = function( obj ) {
		return obj !== null && "" + obj === "[object Object]";
	};




	var validateTypePlainObject = function( value, name ) {
		validateType( value, name, typeof value === "undefined" || isPlainObject( value ), "Plain Object" );
	};




	var validateTypeString = function( value, name ) {
		validateType( value, name, typeof value === "string", "a string" );
	};




	// @path: normalized path
	var resourceGet = function( data, path ) {
		var i,
			node = data,
			length = path.length;

		for ( i = 0; i < length - 1; i++ ) {
			node = node[ path[ i ] ];
			if ( !node ) {
				return undefined;
			}
		}
		return node[ path[ i ] ];
	};




	/**
	 * setAvailableBundles( Cldr, json )
	 *
	 * @Cldr [Cldr class]
	 *
	 * @json resolved/unresolved cldr data.
	 *
	 * Set available bundles queue based on passed json CLDR data. Considers a bundle as any String at /main/{bundle}.
	 */
	var coreSetAvailableBundles = function( Cldr, json ) {
		var bundle,
			availableBundleMapQueue = Cldr._availableBundleMapQueue,
			main = resourceGet( json, [ "main" ] );

		if ( main ) {
			for ( bundle in main ) {
				if ( main.hasOwnProperty( bundle ) && bundle !== "root" &&
							availableBundleMapQueue.indexOf( bundle ) === -1 ) {
					availableBundleMapQueue.push( bundle );
				}
			}
		}
	};



	var alwaysArray = function( somethingOrArray ) {
		return arrayIsArray( somethingOrArray ) ?  somethingOrArray : [ somethingOrArray ];
	};


	var jsonMerge = (function() {

	// Returns new deeply merged JSON.
	//
	// Eg.
	// merge( { a: { b: 1, c: 2 } }, { a: { b: 3, d: 4 } } )
	// -> { a: { b: 3, c: 2, d: 4 } }
	//
	// @arguments JSON's
	// 
	var merge = function() {
		var destination = {},
			sources = [].slice.call( arguments, 0 );
		arrayForEach( sources, function( source ) {
			var prop;
			for ( prop in source ) {
				if ( prop in destination && typeof destination[ prop ] === "object" && !arrayIsArray( destination[ prop ] ) ) {

					// Merge Objects
					destination[ prop ] = merge( destination[ prop ], source[ prop ] );

				} else {

					// Set new values
					destination[ prop ] = source[ prop ];

				}
			}
		});
		return destination;
	};

	return merge;

}());


	/**
	 * load( Cldr, source, jsons )
	 *
	 * @Cldr [Cldr class]
	 *
	 * @source [Object]
	 *
	 * @jsons [arguments]
	 */
	var coreLoad = function( Cldr, source, jsons ) {
		var i, j, json;

		validatePresence( jsons[ 0 ], "json" );

		// Support arbitrary parameters, e.g., `Cldr.load({...}, {...})`.
		for ( i = 0; i < jsons.length; i++ ) {

			// Support array parameters, e.g., `Cldr.load([{...}, {...}])`.
			json = alwaysArray( jsons[ i ] );

			for ( j = 0; j < json.length; j++ ) {
				validateTypePlainObject( json[ j ], "json" );
				source = jsonMerge( source, json[ j ] );
				coreSetAvailableBundles( Cldr, json[ j ] );
			}
		}

		return source;
	};



	var itemGetResolved = function( Cldr, path, attributes ) {
		// Resolve path
		var normalizedPath = pathNormalize( path, attributes );

		return resourceGet( Cldr._resolved, normalizedPath );
	};




	/**
	 * new Cldr()
	 */
	var Cldr = function( locale ) {
		this.init( locale );
	};

	// Build optimization hack to avoid duplicating functions across modules.
	Cldr._alwaysArray = alwaysArray;
	Cldr._coreLoad = coreLoad;
	Cldr._createError = createError;
	Cldr._itemGetResolved = itemGetResolved;
	Cldr._jsonMerge = jsonMerge;
	Cldr._pathNormalize = pathNormalize;
	Cldr._resourceGet = resourceGet;
	Cldr._validatePresence = validatePresence;
	Cldr._validateType = validateType;
	Cldr._validateTypePath = validateTypePath;
	Cldr._validateTypePlainObject = validateTypePlainObject;

	Cldr._availableBundleMap = {};
	Cldr._availableBundleMapQueue = [];
	Cldr._resolved = {};

	// Allow user to override locale separator "-" (default) | "_". According to http://www.unicode.org/reports/tr35/#Unicode_language_identifier, both "-" and "_" are valid locale separators (eg. "en_GB", "en-GB"). According to http://unicode.org/cldr/trac/ticket/6786 its usage must be consistent throughout the data set.
	Cldr.localeSep = "-";

	/**
	 * Cldr.load( json [, json, ...] )
	 *
	 * @json [JSON] CLDR data or [Array] Array of @json's.
	 *
	 * Load resolved cldr data.
	 */
	Cldr.load = function() {
		Cldr._resolved = coreLoad( Cldr, Cldr._resolved, arguments );
	};

	/**
	 * .init() automatically run on instantiation/construction.
	 */
	Cldr.prototype.init = function( locale ) {
		var attributes, language, maxLanguageId, minLanguageId, script, subtags, territory, unicodeLocaleExtensions, variant,
			sep = Cldr.localeSep,
			unicodeLocaleExtensionsRaw = "";

		validatePresence( locale, "locale" );
		validateTypeString( locale, "locale" );

		subtags = coreSubtags( locale );

		if ( subtags.length === 5 ) {
			unicodeLocaleExtensions = subtags.pop();
			unicodeLocaleExtensionsRaw = sep + "u" + sep + unicodeLocaleExtensions;
			// Remove trailing null when there is unicodeLocaleExtensions but no variants.
			if ( !subtags[ 3 ] ) {
				subtags.pop();
			}
		}
		variant = subtags[ 3 ];

		// Normalize locale code.
		// Get (or deduce) the "triple subtags": language, territory (also aliased as region), and script subtags.
		// Get the variant subtags (calendar, collation, currency, etc).
		// refs:
		// - http://www.unicode.org/reports/tr35/#Field_Definitions
		// - http://www.unicode.org/reports/tr35/#Language_and_Locale_IDs
		// - http://www.unicode.org/reports/tr35/#Unicode_locale_identifier

		// When a locale id does not specify a language, or territory (region), or script, they are obtained by Likely Subtags.
		maxLanguageId = coreLikelySubtags( Cldr, this, subtags, { force: true } ) || subtags;
		language = maxLanguageId[ 0 ];
		script = maxLanguageId[ 1 ];
		territory = maxLanguageId[ 2 ];

		minLanguageId = coreRemoveLikelySubtags( Cldr, this, maxLanguageId ).join( sep );

		// Set attributes
		this.attributes = attributes = {
			bundle: bundleLookup( Cldr, this, minLanguageId ),

			// Unicode Language Id
			minLanguageId: minLanguageId + unicodeLocaleExtensionsRaw,
			maxLanguageId: maxLanguageId.join( sep ) + unicodeLocaleExtensionsRaw,

			// Unicode Language Id Subtabs
			language: language,
			script: script,
			territory: territory,
			region: territory, /* alias */
			variant: variant
		};

		// Unicode locale extensions.
		unicodeLocaleExtensions && ( "-" + unicodeLocaleExtensions ).replace( /-[a-z]{3,8}|(-[a-z]{2})-([a-z]{3,8})/g, function( attribute, key, type ) {

			if ( key ) {

				// Extension is in the `keyword` form.
				attributes[ "u" + key ] = type;
			} else {

				// Extension is in the `attribute` form.
				attributes[ "u" + attribute ] = true;
			}
		});

		this.locale = locale;
	};

	/**
	 * .get()
	 */
	Cldr.prototype.get = function( path ) {

		validatePresence( path, "path" );
		validateTypePath( path, "path" );

		return itemGetResolved( Cldr, path, this.attributes );
	};

	/**
	 * .main()
	 */
	Cldr.prototype.main = function( path ) {
		validatePresence( path, "path" );
		validateTypePath( path, "path" );

		validate( "E_MISSING_BUNDLE", this.attributes.bundle !== null, {
			locale: this.locale
		});

		path = alwaysArray( path );
		return this.get( [ "main/{bundle}" ].concat( path ) );
	};

	return Cldr;




}));

/**
 * CLDR JavaScript Library v0.5.1
 * http://jquery.com/
 *
 * Copyright 2013 Rafael Xavier de Souza
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2019-01-21T13:43Z
 */
/*!
 * CLDR JavaScript Library v0.5.1 2019-01-21T13:43Z MIT license © Rafael Xavier
 * http://git.io/h4lmVg
 */
(function( factory ) {

	if ( typeof define === "function" && define.amd ) {
		// AMD.
		define( [ "../cldr" ], factory );
	} else if ( typeof module === "object" && typeof module.exports === "object" ) {
		// Node. CommonJS.
		module.exports = factory( require( "../cldr" ) );
	} else {
		// Global
		factory( Cldr );
	}

}(function( Cldr ) {

	// Build optimization hack to avoid duplicating functions across modules.
	var pathNormalize = Cldr._pathNormalize,
		validatePresence = Cldr._validatePresence,
		validateType = Cldr._validateType;

/*!
 * EventEmitter v4.2.7 - git.io/ee
 * Oliver Caldwell
 * MIT license
 * @preserve
 */

var EventEmitter;
/* jshint ignore:start */
EventEmitter = (function () {


	/**
	 * Class for managing events.
	 * Can be extended to provide event functionality in other classes.
	 *
	 * @class EventEmitter Manages event registering and emitting.
	 */
	function EventEmitter() {}

	// Shortcuts to improve speed and size
	var proto = EventEmitter.prototype;
	var exports = {};
	

	/**
	 * Finds the index of the listener for the event in it's storage array.
	 *
	 * @param {Function[]} listeners Array of listeners to search through.
	 * @param {Function} listener Method to look for.
	 * @return {Number} Index of the specified listener, -1 if not found
	 * @api private
	 */
	function indexOfListener(listeners, listener) {
		var i = listeners.length;
		while (i--) {
			if (listeners[i].listener === listener) {
				return i;
			}
		}

		return -1;
	}

	/**
	 * Alias a method while keeping the context correct, to allow for overwriting of target method.
	 *
	 * @param {String} name The name of the target method.
	 * @return {Function} The aliased method
	 * @api private
	 */
	function alias(name) {
		return function aliasClosure() {
			return this[name].apply(this, arguments);
		};
	}

	/**
	 * Returns the listener array for the specified event.
	 * Will initialise the event object and listener arrays if required.
	 * Will return an object if you use a regex search. The object contains keys for each matched event. So /ba[rz]/ might return an object containing bar and baz. But only if you have either defined them with defineEvent or added some listeners to them.
	 * Each property in the object response is an array of listener functions.
	 *
	 * @param {String|RegExp} evt Name of the event to return the listeners from.
	 * @return {Function[]|Object} All listener functions for the event.
	 */
	proto.getListeners = function getListeners(evt) {
		var events = this._getEvents();
		var response;
		var key;

		// Return a concatenated array of all matching events if
		// the selector is a regular expression.
		if (evt instanceof RegExp) {
			response = {};
			for (key in events) {
				if (events.hasOwnProperty(key) && evt.test(key)) {
					response[key] = events[key];
				}
			}
		}
		else {
			response = events[evt] || (events[evt] = []);
		}

		return response;
	};

	/**
	 * Takes a list of listener objects and flattens it into a list of listener functions.
	 *
	 * @param {Object[]} listeners Raw listener objects.
	 * @return {Function[]} Just the listener functions.
	 */
	proto.flattenListeners = function flattenListeners(listeners) {
		var flatListeners = [];
		var i;

		for (i = 0; i < listeners.length; i += 1) {
			flatListeners.push(listeners[i].listener);
		}

		return flatListeners;
	};

	/**
	 * Fetches the requested listeners via getListeners but will always return the results inside an object. This is mainly for internal use but others may find it useful.
	 *
	 * @param {String|RegExp} evt Name of the event to return the listeners from.
	 * @return {Object} All listener functions for an event in an object.
	 */
	proto.getListenersAsObject = function getListenersAsObject(evt) {
		var listeners = this.getListeners(evt);
		var response;

		if (listeners instanceof Array) {
			response = {};
			response[evt] = listeners;
		}

		return response || listeners;
	};

	/**
	 * Adds a listener function to the specified event.
	 * The listener will not be added if it is a duplicate.
	 * If the listener returns true then it will be removed after it is called.
	 * If you pass a regular expression as the event name then the listener will be added to all events that match it.
	 *
	 * @param {String|RegExp} evt Name of the event to attach the listener to.
	 * @param {Function} listener Method to be called when the event is emitted. If the function returns true then it will be removed after calling.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.addListener = function addListener(evt, listener) {
		var listeners = this.getListenersAsObject(evt);
		var listenerIsWrapped = typeof listener === 'object';
		var key;

		for (key in listeners) {
			if (listeners.hasOwnProperty(key) && indexOfListener(listeners[key], listener) === -1) {
				listeners[key].push(listenerIsWrapped ? listener : {
					listener: listener,
					once: false
				});
			}
		}

		return this;
	};

	/**
	 * Alias of addListener
	 */
	proto.on = alias('addListener');

	/**
	 * Semi-alias of addListener. It will add a listener that will be
	 * automatically removed after it's first execution.
	 *
	 * @param {String|RegExp} evt Name of the event to attach the listener to.
	 * @param {Function} listener Method to be called when the event is emitted. If the function returns true then it will be removed after calling.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.addOnceListener = function addOnceListener(evt, listener) {
		return this.addListener(evt, {
			listener: listener,
			once: true
		});
	};

	/**
	 * Alias of addOnceListener.
	 */
	proto.once = alias('addOnceListener');

	/**
	 * Defines an event name. This is required if you want to use a regex to add a listener to multiple events at once. If you don't do this then how do you expect it to know what event to add to? Should it just add to every possible match for a regex? No. That is scary and bad.
	 * You need to tell it what event names should be matched by a regex.
	 *
	 * @param {String} evt Name of the event to create.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.defineEvent = function defineEvent(evt) {
		this.getListeners(evt);
		return this;
	};

	/**
	 * Uses defineEvent to define multiple events.
	 *
	 * @param {String[]} evts An array of event names to define.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.defineEvents = function defineEvents(evts) {
		for (var i = 0; i < evts.length; i += 1) {
			this.defineEvent(evts[i]);
		}
		return this;
	};

	/**
	 * Removes a listener function from the specified event.
	 * When passed a regular expression as the event name, it will remove the listener from all events that match it.
	 *
	 * @param {String|RegExp} evt Name of the event to remove the listener from.
	 * @param {Function} listener Method to remove from the event.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.removeListener = function removeListener(evt, listener) {
		var listeners = this.getListenersAsObject(evt);
		var index;
		var key;

		for (key in listeners) {
			if (listeners.hasOwnProperty(key)) {
				index = indexOfListener(listeners[key], listener);

				if (index !== -1) {
					listeners[key].splice(index, 1);
				}
			}
		}

		return this;
	};

	/**
	 * Alias of removeListener
	 */
	proto.off = alias('removeListener');

	/**
	 * Adds listeners in bulk using the manipulateListeners method.
	 * If you pass an object as the second argument you can add to multiple events at once. The object should contain key value pairs of events and listeners or listener arrays. You can also pass it an event name and an array of listeners to be added.
	 * You can also pass it a regular expression to add the array of listeners to all events that match it.
	 * Yeah, this function does quite a bit. That's probably a bad thing.
	 *
	 * @param {String|Object|RegExp} evt An event name if you will pass an array of listeners next. An object if you wish to add to multiple events at once.
	 * @param {Function[]} [listeners] An optional array of listener functions to add.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.addListeners = function addListeners(evt, listeners) {
		// Pass through to manipulateListeners
		return this.manipulateListeners(false, evt, listeners);
	};

	/**
	 * Removes listeners in bulk using the manipulateListeners method.
	 * If you pass an object as the second argument you can remove from multiple events at once. The object should contain key value pairs of events and listeners or listener arrays.
	 * You can also pass it an event name and an array of listeners to be removed.
	 * You can also pass it a regular expression to remove the listeners from all events that match it.
	 *
	 * @param {String|Object|RegExp} evt An event name if you will pass an array of listeners next. An object if you wish to remove from multiple events at once.
	 * @param {Function[]} [listeners] An optional array of listener functions to remove.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.removeListeners = function removeListeners(evt, listeners) {
		// Pass through to manipulateListeners
		return this.manipulateListeners(true, evt, listeners);
	};

	/**
	 * Edits listeners in bulk. The addListeners and removeListeners methods both use this to do their job. You should really use those instead, this is a little lower level.
	 * The first argument will determine if the listeners are removed (true) or added (false).
	 * If you pass an object as the second argument you can add/remove from multiple events at once. The object should contain key value pairs of events and listeners or listener arrays.
	 * You can also pass it an event name and an array of listeners to be added/removed.
	 * You can also pass it a regular expression to manipulate the listeners of all events that match it.
	 *
	 * @param {Boolean} remove True if you want to remove listeners, false if you want to add.
	 * @param {String|Object|RegExp} evt An event name if you will pass an array of listeners next. An object if you wish to add/remove from multiple events at once.
	 * @param {Function[]} [listeners] An optional array of listener functions to add/remove.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.manipulateListeners = function manipulateListeners(remove, evt, listeners) {
		var i;
		var value;
		var single = remove ? this.removeListener : this.addListener;
		var multiple = remove ? this.removeListeners : this.addListeners;

		// If evt is an object then pass each of it's properties to this method
		if (typeof evt === 'object' && !(evt instanceof RegExp)) {
			for (i in evt) {
				if (evt.hasOwnProperty(i) && (value = evt[i])) {
					// Pass the single listener straight through to the singular method
					if (typeof value === 'function') {
						single.call(this, i, value);
					}
					else {
						// Otherwise pass back to the multiple function
						multiple.call(this, i, value);
					}
				}
			}
		}
		else {
			// So evt must be a string
			// And listeners must be an array of listeners
			// Loop over it and pass each one to the multiple method
			i = listeners.length;
			while (i--) {
				single.call(this, evt, listeners[i]);
			}
		}

		return this;
	};

	/**
	 * Removes all listeners from a specified event.
	 * If you do not specify an event then all listeners will be removed.
	 * That means every event will be emptied.
	 * You can also pass a regex to remove all events that match it.
	 *
	 * @param {String|RegExp} [evt] Optional name of the event to remove all listeners for. Will remove from every event if not passed.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.removeEvent = function removeEvent(evt) {
		var type = typeof evt;
		var events = this._getEvents();
		var key;

		// Remove different things depending on the state of evt
		if (type === 'string') {
			// Remove all listeners for the specified event
			delete events[evt];
		}
		else if (evt instanceof RegExp) {
			// Remove all events matching the regex.
			for (key in events) {
				if (events.hasOwnProperty(key) && evt.test(key)) {
					delete events[key];
				}
			}
		}
		else {
			// Remove all listeners in all events
			delete this._events;
		}

		return this;
	};

	/**
	 * Alias of removeEvent.
	 *
	 * Added to mirror the node API.
	 */
	proto.removeAllListeners = alias('removeEvent');

	/**
	 * Emits an event of your choice.
	 * When emitted, every listener attached to that event will be executed.
	 * If you pass the optional argument array then those arguments will be passed to every listener upon execution.
	 * Because it uses `apply`, your array of arguments will be passed as if you wrote them out separately.
	 * So they will not arrive within the array on the other side, they will be separate.
	 * You can also pass a regular expression to emit to all events that match it.
	 *
	 * @param {String|RegExp} evt Name of the event to emit and execute listeners for.
	 * @param {Array} [args] Optional array of arguments to be passed to each listener.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.emitEvent = function emitEvent(evt, args) {
		var listeners = this.getListenersAsObject(evt);
		var listener;
		var i;
		var key;
		var response;

		for (key in listeners) {
			if (listeners.hasOwnProperty(key)) {
				i = listeners[key].length;

				while (i--) {
					// If the listener returns true then it shall be removed from the event
					// The function is executed either with a basic call or an apply if there is an args array
					listener = listeners[key][i];

					if (listener.once === true) {
						this.removeListener(evt, listener.listener);
					}

					response = listener.listener.apply(this, args || []);

					if (response === this._getOnceReturnValue()) {
						this.removeListener(evt, listener.listener);
					}
				}
			}
		}

		return this;
	};

	/**
	 * Alias of emitEvent
	 */
	proto.trigger = alias('emitEvent');

	/**
	 * Subtly different from emitEvent in that it will pass its arguments on to the listeners, as opposed to taking a single array of arguments to pass on.
	 * As with emitEvent, you can pass a regex in place of the event name to emit to all events that match it.
	 *
	 * @param {String|RegExp} evt Name of the event to emit and execute listeners for.
	 * @param {...*} Optional additional arguments to be passed to each listener.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.emit = function emit(evt) {
		var args = Array.prototype.slice.call(arguments, 1);
		return this.emitEvent(evt, args);
	};

	/**
	 * Sets the current value to check against when executing listeners. If a
	 * listeners return value matches the one set here then it will be removed
	 * after execution. This value defaults to true.
	 *
	 * @param {*} value The new value to check for when executing listeners.
	 * @return {Object} Current instance of EventEmitter for chaining.
	 */
	proto.setOnceReturnValue = function setOnceReturnValue(value) {
		this._onceReturnValue = value;
		return this;
	};

	/**
	 * Fetches the current value to check against when executing listeners. If
	 * the listeners return value matches this one then it should be removed
	 * automatically. It will return true by default.
	 *
	 * @return {*|Boolean} The current value to check for or the default, true.
	 * @api private
	 */
	proto._getOnceReturnValue = function _getOnceReturnValue() {
		if (this.hasOwnProperty('_onceReturnValue')) {
			return this._onceReturnValue;
		}
		else {
			return true;
		}
	};

	/**
	 * Fetches the events object and creates one if required.
	 *
	 * @return {Object} The events storage object.
	 * @api private
	 */
	proto._getEvents = function _getEvents() {
		return this._events || (this._events = {});
	};

	/**
	 * Reverts the global {@link EventEmitter} to its previous value and returns a reference to this version.
	 *
	 * @return {Function} Non conflicting EventEmitter class.
	 */
	EventEmitter.noConflict = function noConflict() {
		exports.EventEmitter = originalGlobalValue;
		return EventEmitter;
	};

	return EventEmitter;
}());
/* jshint ignore:end */



	var validateTypeFunction = function( value, name ) {
		validateType( value, name, typeof value === "undefined" || typeof value === "function", "Function" );
	};




	var superGet, superInit,
		globalEe = new EventEmitter();

	function validateTypeEvent( value, name ) {
		validateType( value, name, typeof value === "string" || value instanceof RegExp, "String or RegExp" );
	}

	function validateThenCall( method, self ) {
		return function( event, listener ) {
			validatePresence( event, "event" );
			validateTypeEvent( event, "event" );

			validatePresence( listener, "listener" );
			validateTypeFunction( listener, "listener" );

			return self[ method ].apply( self, arguments );
		};
	}

	function off( self ) {
		return validateThenCall( "off", self );
	}

	function on( self ) {
		return validateThenCall( "on", self );
	}

	function once( self ) {
		return validateThenCall( "once", self );
	}

	Cldr.off = off( globalEe );
	Cldr.on = on( globalEe );
	Cldr.once = once( globalEe );

	/**
	 * Overload Cldr.prototype.init().
	 */
	superInit = Cldr.prototype.init;
	Cldr.prototype.init = function() {
		var ee;
		this.ee = ee = new EventEmitter();
		this.off = off( ee );
		this.on = on( ee );
		this.once = once( ee );
		superInit.apply( this, arguments );
	};

	/**
	 * getOverload is encapsulated, because of cldr/unresolved. If it's loaded
	 * after cldr/event (and note it overwrites .get), it can trigger this
	 * overload again.
	 */
	function getOverload() {

		/**
		 * Overload Cldr.prototype.get().
		 */
		superGet = Cldr.prototype.get;
		Cldr.prototype.get = function( path ) {
			var value = superGet.apply( this, arguments );
			path = pathNormalize( path, this.attributes ).join( "/" );
			globalEe.trigger( "get", [ path, value ] );
			this.ee.trigger( "get", [ path, value ] );
			return value;
		};
	}

	Cldr._eventInit = getOverload;
	getOverload();

	return Cldr;




}));

/**
 * CLDR JavaScript Library v0.5.1
 * http://jquery.com/
 *
 * Copyright 2013 Rafael Xavier de Souza
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2019-01-21T13:43Z
 */
/*!
 * CLDR JavaScript Library v0.5.1 2019-01-21T13:43Z MIT license © Rafael Xavier
 * http://git.io/h4lmVg
 */
(function( factory ) {

	if ( typeof define === "function" && define.amd ) {
		// AMD.
		define( [ "../cldr" ], factory );
	} else if ( typeof module === "object" && typeof module.exports === "object" ) {
		// Node. CommonJS.
		module.exports = factory( require( "../cldr" ) );
	} else {
		// Global
		factory( Cldr );
	}

}(function( Cldr ) {

	// Build optimization hack to avoid duplicating functions across modules.
	var alwaysArray = Cldr._alwaysArray;



	var supplementalMain = function( cldr ) {

		var prepend, supplemental;
		
		prepend = function( prepend ) {
			return function( path ) {
				path = alwaysArray( path );
				return cldr.get( [ prepend ].concat( path ) );
			};
		};

		supplemental = prepend( "supplemental" );

		// Week Data
		// http://www.unicode.org/reports/tr35/tr35-dates.html#Week_Data
		supplemental.weekData = prepend( "supplemental/weekData" );

		supplemental.weekData.firstDay = function() {
			return cldr.get( "supplemental/weekData/firstDay/{territory}" ) ||
				cldr.get( "supplemental/weekData/firstDay/001" );
		};

		supplemental.weekData.minDays = function() {
			var minDays = cldr.get( "supplemental/weekData/minDays/{territory}" ) ||
				cldr.get( "supplemental/weekData/minDays/001" );
			return parseInt( minDays, 10 );
		};

		// Time Data
		// http://www.unicode.org/reports/tr35/tr35-dates.html#Time_Data
		supplemental.timeData = prepend( "supplemental/timeData" );

		supplemental.timeData.allowed = function() {
			return cldr.get( "supplemental/timeData/{territory}/_allowed" ) ||
				cldr.get( "supplemental/timeData/001/_allowed" );
		};

		supplemental.timeData.preferred = function() {
			return cldr.get( "supplemental/timeData/{territory}/_preferred" ) ||
				cldr.get( "supplemental/timeData/001/_preferred" );
		};

		return supplemental;

	};




	var initSuper = Cldr.prototype.init;

	/**
	 * .init() automatically ran on construction.
	 *
	 * Overload .init().
	 */
	Cldr.prototype.init = function() {
		initSuper.apply( this, arguments );
		this.supplemental = supplementalMain( this );
	};

	return Cldr;




}));

/**
 * CLDR JavaScript Library v0.5.1
 * http://jquery.com/
 *
 * Copyright 2013 Rafael Xavier de Souza
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2019-01-21T13:43Z
 */
/*!
 * CLDR JavaScript Library v0.5.1 2019-01-21T13:43Z MIT license © Rafael Xavier
 * http://git.io/h4lmVg
 */
(function( factory ) {

	if ( typeof define === "function" && define.amd ) {
		// AMD.
		define( [ "../cldr" ], factory );
	} else if ( typeof module === "object" && typeof module.exports === "object" ) {
		// Node. CommonJS.
		module.exports = factory( require( "../cldr" ) );
	} else {
		// Global
		factory( Cldr );
	}

}(function( Cldr ) {

	// Build optimization hack to avoid duplicating functions across modules.
	var coreLoad = Cldr._coreLoad;
	var jsonMerge = Cldr._jsonMerge;
	var pathNormalize = Cldr._pathNormalize;
	var resourceGet = Cldr._resourceGet;
	var validatePresence = Cldr._validatePresence;
	var validateTypePath = Cldr._validateTypePath;



	var bundleParentLookup = function( Cldr, locale ) {
		var normalizedPath, parent;

		if ( locale === "root" ) {
			return;
		}

		// First, try to find parent on supplemental data.
		normalizedPath = pathNormalize( [ "supplemental/parentLocales/parentLocale", locale ] );
		parent = resourceGet( Cldr._resolved, normalizedPath ) || resourceGet( Cldr._raw, normalizedPath );
		if ( parent ) {
			return parent;
		}

		// Or truncate locale.
		parent = locale.substr( 0, locale.lastIndexOf( Cldr.localeSep ) );
		if ( !parent ) {
			return "root";
		}

		return parent;
	};




	// @path: normalized path
	var resourceSet = function( data, path, value ) {
		var i,
			node = data,
			length = path.length;

		for ( i = 0; i < length - 1; i++ ) {
			if ( !node[ path[ i ] ] ) {
				node[ path[ i ] ] = {};
			}
			node = node[ path[ i ] ];
		}
		node[ path[ i ] ] = value;
	};


	var itemLookup = (function() {

	var lookup;

	lookup = function( Cldr, locale, path, attributes, childLocale ) {
		var normalizedPath, parent, value;

		// 1: Finish recursion
		// 2: Avoid infinite loop
		if ( typeof locale === "undefined" /* 1 */ || locale === childLocale /* 2 */ ) {
			return;
		}

		// Resolve path
		normalizedPath = pathNormalize( path, attributes );

		// Check resolved (cached) data first
		// 1: Due to #16, never use the cached resolved non-leaf nodes. It may not
		//    represent its leafs in its entirety.
		value = resourceGet( Cldr._resolved, normalizedPath );
		if ( value !== undefined && typeof value !== "object" /* 1 */ ) {
			return value;
		}

		// Check raw data
		value = resourceGet( Cldr._raw, normalizedPath );

		if ( value === undefined ) {
			// Or, lookup at parent locale
			parent = bundleParentLookup( Cldr, locale );
			value = lookup( Cldr, parent, path, jsonMerge( attributes, { bundle: parent }), locale );
		}

		if ( value !== undefined ) {
			// Set resolved (cached)
			resourceSet( Cldr._resolved, normalizedPath, value );
		}

		return value;
	};

	return lookup;

}());


	Cldr._raw = {};

	/**
	 * Cldr.load( json [, json, ...] )
	 *
	 * @json [JSON] CLDR data or [Array] Array of @json's.
	 *
	 * Load resolved or unresolved cldr data.
	 * Overwrite Cldr.load().
	 */
	Cldr.load = function() {
		Cldr._raw = coreLoad( Cldr, Cldr._raw, arguments );
	};

	/**
	 * Overwrite Cldr.prototype.get().
	 */
	Cldr.prototype.get = function( path ) {
		validatePresence( path, "path" );
		validateTypePath( path, "path" );

		// 1: use bundle as locale on item lookup for simplification purposes, because no other extended subtag is used anyway on bundle parent lookup.
		// 2: during init(), this method is called, but bundle is yet not defined. Use "" as a workaround in this very specific scenario.
		return itemLookup( Cldr, this.attributes && this.attributes.bundle /* 1 */ || "" /* 2 */, path, this.attributes );
	};

	// In case cldr/unresolved is loaded after cldr/event, we trigger its overloads again. Because, .get is overwritten in here.
	if ( Cldr._eventInit ) {
		Cldr._eventInit();
	}

	return Cldr;




}));

/**
 * Globalize v1.4.2
 *
 * http://github.com/jquery/globalize
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2019-03-07T13:47Z
 */
/*!
 * Globalize v1.4.2 2019-03-07T13:47Z Released under the MIT license
 * http://git.io/TrdQbw
 */
(function( root, factory ) {

	// UMD returnExports
	if ( typeof define === "function" && define.amd ) {

		// AMD
		define([
			"cldr",
			"cldr/event"
		], factory );
	} else if ( typeof exports === "object" ) {

		// Node, CommonJS
		module.exports = factory( require( "cldrjs" ) );
	} else {

		// Global
		root.Globalize = factory( root.Cldr );
	}
}( this, function( Cldr ) {


/**
 * A toString method that outputs meaningful values for objects or arrays and
 * still performs as fast as a plain string in case variable is string, or as
 * fast as `"" + number` in case variable is a number.
 * Ref: http://jsperf.com/my-stringify
 */
var toString = function( variable ) {
	return typeof variable === "string" ? variable : ( typeof variable === "number" ? "" +
		variable : JSON.stringify( variable ) );
};




/**
 * formatMessage( message, data )
 *
 * @message [String] A message with optional {vars} to be replaced.
 *
 * @data [Array or JSON] Object with replacing-variables content.
 *
 * Return the formatted message. For example:
 *
 * - formatMessage( "{0} second", [ 1 ] ); // 1 second
 *
 * - formatMessage( "{0}/{1}", ["m", "s"] ); // m/s
 *
 * - formatMessage( "{name} <{email}>", {
 *     name: "Foo",
 *     email: "bar@baz.qux"
 *   }); // Foo <bar@baz.qux>
 */
var formatMessage = function( message, data ) {

	// Replace {attribute}'s
	message = message.replace( /{[0-9a-zA-Z-_. ]+}/g, function( name ) {
		name = name.replace( /^{([^}]*)}$/, "$1" );
		return toString( data[ name ] );
	});

	return message;
};




var objectExtend = function() {
	var destination = arguments[ 0 ],
		sources = [].slice.call( arguments, 1 );

	sources.forEach(function( source ) {
		var prop;
		for ( prop in source ) {
			destination[ prop ] = source[ prop ];
		}
	});

	return destination;
};




var createError = function( code, message, attributes ) {
	var error;

	message = code + ( message ? ": " + formatMessage( message, attributes ) : "" );
	error = new Error( message );
	error.code = code;

	objectExtend( error, attributes );

	return error;
};




var runtimeStringify = function( args ) {
	return JSON.stringify( args, function( key, value ) {
		if ( value && value.runtimeKey ) {
			return value.runtimeKey;
		}
		return value;
	} );
};




// Based on http://stackoverflow.com/questions/7616461/generate-a-hash-from-string-in-javascript-jquery
var stringHash = function( str ) {
	return [].reduce.call( str, function( hash, i ) {
		var chr = i.charCodeAt( 0 );
		hash = ( ( hash << 5 ) - hash ) + chr;
		return hash | 0;
	}, 0 );
};




var runtimeKey = function( fnName, locale, args, argsStr ) {
	var hash;
	argsStr = argsStr || runtimeStringify( args );
	hash = stringHash( fnName + locale + argsStr );
	return hash > 0 ? "a" + hash : "b" + Math.abs( hash );
};




var functionName = function( fn ) {
	if ( fn.name !== undefined ) {
		return fn.name;
	}

	// fn.name is not supported by IE.
	var matches = /^function\s+([\w\$]+)\s*\(/.exec( fn.toString() );

	if ( matches && matches.length > 0 ) {
		return matches[ 1 ];
	}
};




var runtimeBind = function( args, cldr, fn, runtimeArgs ) {

	var argsStr = runtimeStringify( args ),
		fnName = functionName( fn ),
		locale = cldr.locale;

	// If name of the function is not available, this is most likely due to uglification,
	// which most likely means we are in production, and runtimeBind here is not necessary.
	if ( !fnName ) {
		return fn;
	}

	fn.runtimeKey = runtimeKey( fnName, locale, null, argsStr );

	fn.generatorString = function() {
		return "Globalize(\"" + locale + "\")." + fnName + "(" + argsStr.slice( 1, -1 ) + ")";
	};

	fn.runtimeArgs = runtimeArgs;

	return fn;
};




var validate = function( code, message, check, attributes ) {
	if ( !check ) {
		throw createError( code, message, attributes );
	}
};




var alwaysArray = function( stringOrArray ) {
	return Array.isArray( stringOrArray ) ? stringOrArray : stringOrArray ? [ stringOrArray ] : [];
};




var validateCldr = function( path, value, options ) {
	var skipBoolean;
	options = options || {};

	skipBoolean = alwaysArray( options.skip ).some(function( pathRe ) {
		return pathRe.test( path );
	});

	validate( "E_MISSING_CLDR", "Missing required CLDR content `{path}`.", value || skipBoolean, {
		path: path
	});
};




var validateDefaultLocale = function( value ) {
	validate( "E_DEFAULT_LOCALE_NOT_DEFINED", "Default locale has not been defined.",
		value !== undefined, {} );
};




var validateParameterPresence = function( value, name ) {
	validate( "E_MISSING_PARAMETER", "Missing required parameter `{name}`.",
		value !== undefined, { name: name });
};




/**
 * range( value, name, minimum, maximum )
 *
 * @value [Number].
 *
 * @name [String] name of variable.
 *
 * @minimum [Number]. The lowest valid value, inclusive.
 *
 * @maximum [Number]. The greatest valid value, inclusive.
 */
var validateParameterRange = function( value, name, minimum, maximum ) {
	validate(
		"E_PAR_OUT_OF_RANGE",
		"Parameter `{name}` has value `{value}` out of range [{minimum}, {maximum}].",
		value === undefined || value >= minimum && value <= maximum,
		{
			maximum: maximum,
			minimum: minimum,
			name: name,
			value: value
		}
	);
};




var validateParameterType = function( value, name, check, expected ) {
	validate(
		"E_INVALID_PAR_TYPE",
		"Invalid `{name}` parameter ({value}). {expected} expected.",
		check,
		{
			expected: expected,
			name: name,
			value: value
		}
	);
};




var validateParameterTypeLocale = function( value, name ) {
	validateParameterType(
		value,
		name,
		value === undefined || typeof value === "string" || value instanceof Cldr,
		"String or Cldr instance"
	);
};




/**
 * Function inspired by jQuery Core, but reduced to our use case.
 */
var isPlainObject = function( obj ) {
	return obj !== null && "" + obj === "[object Object]";
};




var validateParameterTypePlainObject = function( value, name ) {
	validateParameterType(
		value,
		name,
		value === undefined || isPlainObject( value ),
		"Plain Object"
	);
};




var alwaysCldr = function( localeOrCldr ) {
	return localeOrCldr instanceof Cldr ? localeOrCldr : new Cldr( localeOrCldr );
};




// ref: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions?redirectlocale=en-US&redirectslug=JavaScript%2FGuide%2FRegular_Expressions
var regexpEscape = function( string ) {
	return string.replace( /([.*+?^=!:${}()|\[\]\/\\])/g, "\\$1" );
};




var stringPad = function( str, count, right ) {
	var length;
	if ( typeof str !== "string" ) {
		str = String( str );
	}
	for ( length = str.length; length < count; length += 1 ) {
		str = ( right ? ( str + "0" ) : ( "0" + str ) );
	}
	return str;
};




function validateLikelySubtags( cldr ) {
	cldr.once( "get", validateCldr );
	cldr.get( "supplemental/likelySubtags" );
}

/**
 * [new] Globalize( locale|cldr )
 *
 * @locale [String]
 *
 * @cldr [Cldr instance]
 *
 * Create a Globalize instance.
 */
function Globalize( locale ) {
	if ( !( this instanceof Globalize ) ) {
		return new Globalize( locale );
	}

	validateParameterPresence( locale, "locale" );
	validateParameterTypeLocale( locale, "locale" );

	this.cldr = alwaysCldr( locale );

	validateLikelySubtags( this.cldr );
}

/**
 * Globalize.load( json, ... )
 *
 * @json [JSON]
 *
 * Load resolved or unresolved cldr data.
 * Somewhat equivalent to previous Globalize.addCultureInfo(...).
 */
Globalize.load = function() {

	// validations are delegated to Cldr.load().
	Cldr.load.apply( Cldr, arguments );
};

/**
 * Globalize.locale( [locale|cldr] )
 *
 * @locale [String]
 *
 * @cldr [Cldr instance]
 *
 * Set default Cldr instance if locale or cldr argument is passed.
 *
 * Return the default Cldr instance.
 */
Globalize.locale = function( locale ) {
	validateParameterTypeLocale( locale, "locale" );

	if ( arguments.length ) {
		this.cldr = alwaysCldr( locale );
		validateLikelySubtags( this.cldr );
	}
	return this.cldr;
};

/**
 * Optimization to avoid duplicating some internal functions across modules.
 */
Globalize._alwaysArray = alwaysArray;
Globalize._createError = createError;
Globalize._formatMessage = formatMessage;
Globalize._isPlainObject = isPlainObject;
Globalize._objectExtend = objectExtend;
Globalize._regexpEscape = regexpEscape;
Globalize._runtimeBind = runtimeBind;
Globalize._stringPad = stringPad;
Globalize._validate = validate;
Globalize._validateCldr = validateCldr;
Globalize._validateDefaultLocale = validateDefaultLocale;
Globalize._validateParameterPresence = validateParameterPresence;
Globalize._validateParameterRange = validateParameterRange;
Globalize._validateParameterTypePlainObject = validateParameterTypePlainObject;
Globalize._validateParameterType = validateParameterType;

return Globalize;




}));

/**
 * Globalize v1.4.2
 *
 * http://github.com/jquery/globalize
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2019-03-07T13:47Z
 */
/*!
 * Globalize v1.4.2 2019-03-07T13:47Z Released under the MIT license
 * http://git.io/TrdQbw
 */
(function( root, factory ) {

	// UMD returnExports
	if ( typeof define === "function" && define.amd ) {

		// AMD
		define([
			"cldr",
			"../globalize",
			"cldr/event"
		], factory );
	} else if ( typeof exports === "object" ) {

		// Node, CommonJS
		module.exports = factory( require( "cldrjs" ), require( "../globalize" ) );
	} else {

		// Extend global
		factory( root.Cldr, root.Globalize );
	}
}(this, function( Cldr, Globalize ) {

var alwaysArray = Globalize._alwaysArray,
	createError = Globalize._createError,
	isPlainObject = Globalize._isPlainObject,
	runtimeBind = Globalize._runtimeBind,
	validateDefaultLocale = Globalize._validateDefaultLocale,
	validate = Globalize._validate,
	validateParameterPresence = Globalize._validateParameterPresence,
	validateParameterType = Globalize._validateParameterType,
	validateParameterTypePlainObject = Globalize._validateParameterTypePlainObject;
var MessageFormat;
/* jshint ignore:start */
MessageFormat = (function() {
MessageFormat._parse = (function() {

  /*
   * Generated by PEG.js 0.8.0.
   *
   * http://pegjs.majda.cz/
   */

  function peg$subclass(child, parent) {
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor();
  }

  function SyntaxError(message, expected, found, offset, line, column) {
    this.message  = message;
    this.expected = expected;
    this.found    = found;
    this.offset   = offset;
    this.line     = line;
    this.column   = column;

    this.name     = "SyntaxError";
  }

  peg$subclass(SyntaxError, Error);

  function parse(input) {
    var options = arguments.length > 1 ? arguments[1] : {},

        peg$FAILED = {},

        peg$startRuleFunctions = { start: peg$parsestart },
        peg$startRuleFunction  = peg$parsestart,

        peg$c0 = [],
        peg$c1 = function(st) {
              return { type: 'messageFormatPattern', statements: st };
            },
        peg$c2 = peg$FAILED,
        peg$c3 = "{",
        peg$c4 = { type: "literal", value: "{", description: "\"{\"" },
        peg$c5 = null,
        peg$c6 = ",",
        peg$c7 = { type: "literal", value: ",", description: "\",\"" },
        peg$c8 = "}",
        peg$c9 = { type: "literal", value: "}", description: "\"}\"" },
        peg$c10 = function(argIdx, efmt) {
              var res = {
                type: "messageFormatElement",
                argumentIndex: argIdx
              };
              if (efmt && efmt.length) {
                res.elementFormat = efmt[1];
              } else {
                res.output = true;
              }
              return res;
            },
        peg$c11 = "plural",
        peg$c12 = { type: "literal", value: "plural", description: "\"plural\"" },
        peg$c13 = function(t, s) {
              return { type: "elementFormat", key: t, val: s };
            },
        peg$c14 = "selectordinal",
        peg$c15 = { type: "literal", value: "selectordinal", description: "\"selectordinal\"" },
        peg$c16 = "select",
        peg$c17 = { type: "literal", value: "select", description: "\"select\"" },
        peg$c18 = function(t, p) {
              return { type: "elementFormat", key: t, val: p };
            },
        peg$c19 = function(op, pf) {
              return { type: "pluralFormatPattern", pluralForms: pf, offset: op || 0 };
            },
        peg$c20 = "offset",
        peg$c21 = { type: "literal", value: "offset", description: "\"offset\"" },
        peg$c22 = ":",
        peg$c23 = { type: "literal", value: ":", description: "\":\"" },
        peg$c24 = function(d) { return d; },
        peg$c25 = function(k, mfp) {
              return { key: k, val: mfp };
            },
        peg$c26 = function(i) { return i; },
        peg$c27 = "=",
        peg$c28 = { type: "literal", value: "=", description: "\"=\"" },
        peg$c29 = function(pf) { return { type: "selectFormatPattern", pluralForms: pf }; },
        peg$c30 = function(p) { return p; },
        peg$c31 = "#",
        peg$c32 = { type: "literal", value: "#", description: "\"#\"" },
        peg$c33 = function() { return {type: 'octothorpe'}; },
        peg$c34 = function(s) { return { type: "string", val: s.join('') }; },
        peg$c35 = { type: "other", description: "identifier" },
        peg$c36 = /^[0-9a-zA-Z$_]/,
        peg$c37 = { type: "class", value: "[0-9a-zA-Z$_]", description: "[0-9a-zA-Z$_]" },
        peg$c38 = /^[^ \t\n\r,.+={}]/,
        peg$c39 = { type: "class", value: "[^ \\t\\n\\r,.+={}]", description: "[^ \\t\\n\\r,.+={}]" },
        peg$c40 = function(s) { return s; },
        peg$c41 = function(chars) { return chars.join(''); },
        peg$c42 = /^[^{}#\\\0-\x1F \t\n\r]/,
        peg$c43 = { type: "class", value: "[^{}#\\\\\\0-\\x1F \\t\\n\\r]", description: "[^{}#\\\\\\0-\\x1F \\t\\n\\r]" },
        peg$c44 = function(x) { return x; },
        peg$c45 = "\\\\",
        peg$c46 = { type: "literal", value: "\\\\", description: "\"\\\\\\\\\"" },
        peg$c47 = function() { return "\\"; },
        peg$c48 = "\\#",
        peg$c49 = { type: "literal", value: "\\#", description: "\"\\\\#\"" },
        peg$c50 = function() { return "#"; },
        peg$c51 = "\\{",
        peg$c52 = { type: "literal", value: "\\{", description: "\"\\\\{\"" },
        peg$c53 = function() { return "\u007B"; },
        peg$c54 = "\\}",
        peg$c55 = { type: "literal", value: "\\}", description: "\"\\\\}\"" },
        peg$c56 = function() { return "\u007D"; },
        peg$c57 = "\\u",
        peg$c58 = { type: "literal", value: "\\u", description: "\"\\\\u\"" },
        peg$c59 = function(h1, h2, h3, h4) {
              return String.fromCharCode(parseInt("0x" + h1 + h2 + h3 + h4));
            },
        peg$c60 = /^[0-9]/,
        peg$c61 = { type: "class", value: "[0-9]", description: "[0-9]" },
        peg$c62 = function(ds) {
            //the number might start with 0 but must not be interpreted as an octal number
            //Hence, the base is passed to parseInt explicitely
            return parseInt((ds.join('')), 10);
          },
        peg$c63 = /^[0-9a-fA-F]/,
        peg$c64 = { type: "class", value: "[0-9a-fA-F]", description: "[0-9a-fA-F]" },
        peg$c65 = { type: "other", description: "whitespace" },
        peg$c66 = function(w) { return w.join(''); },
        peg$c67 = /^[ \t\n\r]/,
        peg$c68 = { type: "class", value: "[ \\t\\n\\r]", description: "[ \\t\\n\\r]" },

        peg$currPos          = 0,
        peg$reportedPos      = 0,
        peg$cachedPos        = 0,
        peg$cachedPosDetails = { line: 1, column: 1, seenCR: false },
        peg$maxFailPos       = 0,
        peg$maxFailExpected  = [],
        peg$silentFails      = 0,

        peg$result;

    if ("startRule" in options) {
      if (!(options.startRule in peg$startRuleFunctions)) {
        throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
      }

      peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
    }

    function text() {
      return input.substring(peg$reportedPos, peg$currPos);
    }

    function offset() {
      return peg$reportedPos;
    }

    function line() {
      return peg$computePosDetails(peg$reportedPos).line;
    }

    function column() {
      return peg$computePosDetails(peg$reportedPos).column;
    }

    function expected(description) {
      throw peg$buildException(
        null,
        [{ type: "other", description: description }],
        peg$reportedPos
      );
    }

    function error(message) {
      throw peg$buildException(message, null, peg$reportedPos);
    }

    function peg$computePosDetails(pos) {
      function advance(details, startPos, endPos) {
        var p, ch;

        for (p = startPos; p < endPos; p++) {
          ch = input.charAt(p);
          if (ch === "\n") {
            if (!details.seenCR) { details.line++; }
            details.column = 1;
            details.seenCR = false;
          } else if (ch === "\r" || ch === "\u2028" || ch === "\u2029") {
            details.line++;
            details.column = 1;
            details.seenCR = true;
          } else {
            details.column++;
            details.seenCR = false;
          }
        }
      }

      if (peg$cachedPos !== pos) {
        if (peg$cachedPos > pos) {
          peg$cachedPos = 0;
          peg$cachedPosDetails = { line: 1, column: 1, seenCR: false };
        }
        advance(peg$cachedPosDetails, peg$cachedPos, pos);
        peg$cachedPos = pos;
      }

      return peg$cachedPosDetails;
    }

    function peg$fail(expected) {
      if (peg$currPos < peg$maxFailPos) { return; }

      if (peg$currPos > peg$maxFailPos) {
        peg$maxFailPos = peg$currPos;
        peg$maxFailExpected = [];
      }

      peg$maxFailExpected.push(expected);
    }

    function peg$buildException(message, expected, pos) {
      function cleanupExpected(expected) {
        var i = 1;

        expected.sort(function(a, b) {
          if (a.description < b.description) {
            return -1;
          } else if (a.description > b.description) {
            return 1;
          } else {
            return 0;
          }
        });

        while (i < expected.length) {
          if (expected[i - 1] === expected[i]) {
            expected.splice(i, 1);
          } else {
            i++;
          }
        }
      }

      function buildMessage(expected, found) {
        function stringEscape(s) {
          function hex(ch) { return ch.charCodeAt(0).toString(16).toUpperCase(); }

          return s
            .replace(/\\/g,   '\\\\')
            .replace(/"/g,    '\\"')
            .replace(/\x08/g, '\\b')
            .replace(/\t/g,   '\\t')
            .replace(/\n/g,   '\\n')
            .replace(/\f/g,   '\\f')
            .replace(/\r/g,   '\\r')
            .replace(/[\x00-\x07\x0B\x0E\x0F]/g, function(ch) { return '\\x0' + hex(ch); })
            .replace(/[\x10-\x1F\x80-\xFF]/g,    function(ch) { return '\\x'  + hex(ch); })
            .replace(/[\u0180-\u0FFF]/g,         function(ch) { return '\\u0' + hex(ch); })
            .replace(/[\u1080-\uFFFF]/g,         function(ch) { return '\\u'  + hex(ch); });
        }

        var expectedDescs = new Array(expected.length),
            expectedDesc, foundDesc, i;

        for (i = 0; i < expected.length; i++) {
          expectedDescs[i] = expected[i].description;
        }

        expectedDesc = expected.length > 1
          ? expectedDescs.slice(0, -1).join(", ")
              + " or "
              + expectedDescs[expected.length - 1]
          : expectedDescs[0];

        foundDesc = found ? "\"" + stringEscape(found) + "\"" : "end of input";

        return "Expected " + expectedDesc + " but " + foundDesc + " found.";
      }

      var posDetails = peg$computePosDetails(pos),
          found      = pos < input.length ? input.charAt(pos) : null;

      if (expected !== null) {
        cleanupExpected(expected);
      }

      return new SyntaxError(
        message !== null ? message : buildMessage(expected, found),
        expected,
        found,
        pos,
        posDetails.line,
        posDetails.column
      );
    }

    function peg$parsestart() {
      var s0;

      s0 = peg$parsemessageFormatPattern();

      return s0;
    }

    function peg$parsemessageFormatPattern() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parsemessageFormatElement();
      if (s2 === peg$FAILED) {
        s2 = peg$parsestring();
        if (s2 === peg$FAILED) {
          s2 = peg$parseoctothorpe();
        }
      }
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parsemessageFormatElement();
        if (s2 === peg$FAILED) {
          s2 = peg$parsestring();
          if (s2 === peg$FAILED) {
            s2 = peg$parseoctothorpe();
          }
        }
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c1(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parsemessageFormatElement() {
      var s0, s1, s2, s3, s4, s5, s6;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 123) {
        s1 = peg$c3;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c4); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (s2 !== peg$FAILED) {
          s3 = peg$parseid();
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 44) {
              s5 = peg$c6;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c7); }
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parseelementFormat();
              if (s6 !== peg$FAILED) {
                s5 = [s5, s6];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$c2;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$c2;
            }
            if (s4 === peg$FAILED) {
              s4 = peg$c5;
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 125) {
                  s6 = peg$c8;
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c9); }
                }
                if (s6 !== peg$FAILED) {
                  peg$reportedPos = s0;
                  s1 = peg$c10(s3, s4);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }

      return s0;
    }

    function peg$parseelementFormat() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parse_();
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c11) {
          s2 = peg$c11;
          peg$currPos += 6;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c12); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parse_();
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 44) {
              s4 = peg$c6;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c7); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                s6 = peg$parsepluralFormatPattern();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parse_();
                  if (s7 !== peg$FAILED) {
                    peg$reportedPos = s0;
                    s1 = peg$c13(s2, s6);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$c2;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parse_();
        if (s1 !== peg$FAILED) {
          if (input.substr(peg$currPos, 13) === peg$c14) {
            s2 = peg$c14;
            peg$currPos += 13;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c15); }
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$parse_();
            if (s3 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 44) {
                s4 = peg$c6;
                peg$currPos++;
              } else {
                s4 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c7); }
              }
              if (s4 !== peg$FAILED) {
                s5 = peg$parse_();
                if (s5 !== peg$FAILED) {
                  s6 = peg$parsepluralFormatPattern();
                  if (s6 !== peg$FAILED) {
                    s7 = peg$parse_();
                    if (s7 !== peg$FAILED) {
                      peg$reportedPos = s0;
                      s1 = peg$c13(s2, s6);
                      s0 = s1;
                    } else {
                      peg$currPos = s0;
                      s0 = peg$c2;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$c2;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parse_();
          if (s1 !== peg$FAILED) {
            if (input.substr(peg$currPos, 6) === peg$c16) {
              s2 = peg$c16;
              peg$currPos += 6;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c17); }
            }
            if (s2 !== peg$FAILED) {
              s3 = peg$parse_();
              if (s3 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 44) {
                  s4 = peg$c6;
                  peg$currPos++;
                } else {
                  s4 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c7); }
                }
                if (s4 !== peg$FAILED) {
                  s5 = peg$parse_();
                  if (s5 !== peg$FAILED) {
                    s6 = peg$parseselectFormatPattern();
                    if (s6 !== peg$FAILED) {
                      s7 = peg$parse_();
                      if (s7 !== peg$FAILED) {
                        peg$reportedPos = s0;
                        s1 = peg$c13(s2, s6);
                        s0 = s1;
                      } else {
                        peg$currPos = s0;
                        s0 = peg$c2;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$c2;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$c2;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parse_();
            if (s1 !== peg$FAILED) {
              s2 = peg$parseid();
              if (s2 !== peg$FAILED) {
                s3 = [];
                s4 = peg$parseargStylePattern();
                while (s4 !== peg$FAILED) {
                  s3.push(s4);
                  s4 = peg$parseargStylePattern();
                }
                if (s3 !== peg$FAILED) {
                  peg$reportedPos = s0;
                  s1 = peg$c18(s2, s3);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          }
        }
      }

      return s0;
    }

    function peg$parsepluralFormatPattern() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parseoffsetPattern();
      if (s1 === peg$FAILED) {
        s1 = peg$c5;
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parsepluralForm();
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parsepluralForm();
          }
        } else {
          s2 = peg$c2;
        }
        if (s2 !== peg$FAILED) {
          peg$reportedPos = s0;
          s1 = peg$c19(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }

      return s0;
    }

    function peg$parseoffsetPattern() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$currPos;
      s1 = peg$parse_();
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c20) {
          s2 = peg$c20;
          peg$currPos += 6;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c21); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parse_();
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 58) {
              s4 = peg$c22;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c23); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                s6 = peg$parsedigits();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parse_();
                  if (s7 !== peg$FAILED) {
                    peg$reportedPos = s0;
                    s1 = peg$c24(s6);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$c2;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }

      return s0;
    }

    function peg$parsepluralForm() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      s0 = peg$currPos;
      s1 = peg$parse_();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsepluralKey();
        if (s2 !== peg$FAILED) {
          s3 = peg$parse_();
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 123) {
              s4 = peg$c3;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c4); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                s6 = peg$parsemessageFormatPattern();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parse_();
                  if (s7 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 125) {
                      s8 = peg$c8;
                      peg$currPos++;
                    } else {
                      s8 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c9); }
                    }
                    if (s8 !== peg$FAILED) {
                      peg$reportedPos = s0;
                      s1 = peg$c25(s2, s6);
                      s0 = s1;
                    } else {
                      peg$currPos = s0;
                      s0 = peg$c2;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$c2;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }

      return s0;
    }

    function peg$parsepluralKey() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = peg$parseid();
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c26(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 61) {
          s1 = peg$c27;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c28); }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parsedigits();
          if (s2 !== peg$FAILED) {
            peg$reportedPos = s0;
            s1 = peg$c24(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      }

      return s0;
    }

    function peg$parseselectFormatPattern() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseselectForm();
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parseselectForm();
        }
      } else {
        s1 = peg$c2;
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c29(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parseselectForm() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      s0 = peg$currPos;
      s1 = peg$parse_();
      if (s1 !== peg$FAILED) {
        s2 = peg$parseid();
        if (s2 !== peg$FAILED) {
          s3 = peg$parse_();
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 123) {
              s4 = peg$c3;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c4); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                s6 = peg$parsemessageFormatPattern();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parse_();
                  if (s7 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 125) {
                      s8 = peg$c8;
                      peg$currPos++;
                    } else {
                      s8 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c9); }
                    }
                    if (s8 !== peg$FAILED) {
                      peg$reportedPos = s0;
                      s1 = peg$c25(s2, s6);
                      s0 = s1;
                    } else {
                      peg$currPos = s0;
                      s0 = peg$c2;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$c2;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }

      return s0;
    }

    function peg$parseargStylePattern() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      s1 = peg$parse_();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 44) {
          s2 = peg$c6;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c7); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parse_();
          if (s3 !== peg$FAILED) {
            s4 = peg$parseid();
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                peg$reportedPos = s0;
                s1 = peg$c30(s4);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$c2;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$c2;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }

      return s0;
    }

    function peg$parseoctothorpe() {
      var s0, s1;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 35) {
        s1 = peg$c31;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c32); }
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c33();
      }
      s0 = s1;

      return s0;
    }

    function peg$parsestring() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parsechars();
      if (s2 === peg$FAILED) {
        s2 = peg$parsewhitespace();
      }
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parsechars();
          if (s2 === peg$FAILED) {
            s2 = peg$parsewhitespace();
          }
        }
      } else {
        s1 = peg$c2;
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c34(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parseid() {
      var s0, s1, s2, s3, s4, s5, s6;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parse_();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        s3 = peg$currPos;
        if (peg$c36.test(input.charAt(peg$currPos))) {
          s4 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c37); }
        }
        if (s4 !== peg$FAILED) {
          s5 = [];
          if (peg$c38.test(input.charAt(peg$currPos))) {
            s6 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c39); }
          }
          while (s6 !== peg$FAILED) {
            s5.push(s6);
            if (peg$c38.test(input.charAt(peg$currPos))) {
              s6 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c39); }
            }
          }
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$c2;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$c2;
        }
        if (s3 !== peg$FAILED) {
          s3 = input.substring(s2, peg$currPos);
        }
        s2 = s3;
        if (s2 !== peg$FAILED) {
          s3 = peg$parse_();
          if (s3 !== peg$FAILED) {
            peg$reportedPos = s0;
            s1 = peg$c40(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$c2;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$c2;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$c2;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c35); }
      }

      return s0;
    }

    function peg$parsechars() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parsechar();
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parsechar();
        }
      } else {
        s1 = peg$c2;
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c41(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parsechar() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      if (peg$c42.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c43); }
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c44(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c45) {
          s1 = peg$c45;
          peg$currPos += 2;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c46); }
        }
        if (s1 !== peg$FAILED) {
          peg$reportedPos = s0;
          s1 = peg$c47();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.substr(peg$currPos, 2) === peg$c48) {
            s1 = peg$c48;
            peg$currPos += 2;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c49); }
          }
          if (s1 !== peg$FAILED) {
            peg$reportedPos = s0;
            s1 = peg$c50();
          }
          s0 = s1;
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 2) === peg$c51) {
              s1 = peg$c51;
              peg$currPos += 2;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c52); }
            }
            if (s1 !== peg$FAILED) {
              peg$reportedPos = s0;
              s1 = peg$c53();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              if (input.substr(peg$currPos, 2) === peg$c54) {
                s1 = peg$c54;
                peg$currPos += 2;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c55); }
              }
              if (s1 !== peg$FAILED) {
                peg$reportedPos = s0;
                s1 = peg$c56();
              }
              s0 = s1;
              if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.substr(peg$currPos, 2) === peg$c57) {
                  s1 = peg$c57;
                  peg$currPos += 2;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c58); }
                }
                if (s1 !== peg$FAILED) {
                  s2 = peg$parsehexDigit();
                  if (s2 !== peg$FAILED) {
                    s3 = peg$parsehexDigit();
                    if (s3 !== peg$FAILED) {
                      s4 = peg$parsehexDigit();
                      if (s4 !== peg$FAILED) {
                        s5 = peg$parsehexDigit();
                        if (s5 !== peg$FAILED) {
                          peg$reportedPos = s0;
                          s1 = peg$c59(s2, s3, s4, s5);
                          s0 = s1;
                        } else {
                          peg$currPos = s0;
                          s0 = peg$c2;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$c2;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$c2;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$c2;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$c2;
                }
              }
            }
          }
        }
      }

      return s0;
    }

    function peg$parsedigits() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = [];
      if (peg$c60.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c61); }
      }
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          if (peg$c60.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c61); }
          }
        }
      } else {
        s1 = peg$c2;
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c62(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parsehexDigit() {
      var s0;

      if (peg$c63.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c64); }
      }

      return s0;
    }

    function peg$parse_() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parsewhitespace();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parsewhitespace();
      }
      if (s1 !== peg$FAILED) {
        peg$reportedPos = s0;
        s1 = peg$c66(s1);
      }
      s0 = s1;
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c65); }
      }

      return s0;
    }

    function peg$parsewhitespace() {
      var s0;

      if (peg$c67.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c68); }
      }

      return s0;
    }

    peg$result = peg$startRuleFunction();

    if (peg$result !== peg$FAILED && peg$currPos === input.length) {
      return peg$result;
    } else {
      if (peg$result !== peg$FAILED && peg$currPos < input.length) {
        peg$fail({ type: "end", description: "end of input" });
      }

      throw peg$buildException(null, peg$maxFailExpected, peg$maxFailPos);
    }
  }

  return {
    SyntaxError: SyntaxError,
    parse:       parse
  };
}()).parse;


/** @file messageformat.js - ICU PluralFormat + SelectFormat for JavaScript
 *  @author Alex Sexton - @SlexAxton
 *  @version 0.3.0-1
 *  @copyright 2012-2015 Alex Sexton, Eemeli Aro, and Contributors
 *  @license To use or fork, MIT. To contribute back, Dojo CLA  */


/** Utility function for quoting an Object's key value iff required
 *  @private  */
function propname(key, obj) {
  if (/^[A-Z_$][0-9A-Z_$]*$/i.test(key)) {
    return obj ? obj + '.' + key : key;
  } else {
    var jkey = JSON.stringify(key);
    return obj ? obj + '[' + jkey + ']' : jkey;
  }
};


/** Create a new message formatter
 *
 *  @class
 *  @global
 *  @param {string|string[]} [locale="en"] - The locale to use, with fallbacks
 *  @param {function} [pluralFunc] - Optional custom pluralization function
 *  @param {function[]} [formatters] - Optional custom formatting functions  */
function MessageFormat(locale, pluralFunc, formatters) {
  this.lc = [locale];  
  this.runtime.pluralFuncs = {};
  this.runtime.pluralFuncs[this.lc[0]] = pluralFunc;
  this.runtime.fmt = {};
  if (formatters) for (var f in formatters) {
    this.runtime.fmt[f] = formatters[f];
  }
}




/** Parse an input string to its AST
 *
 *  Precompiled from `lib/messageformat-parser.pegjs` by
 *  {@link http://pegjs.org/ PEG.js}. Included in MessageFormat object
 *  to enable testing.
 *
 *  @private  */



/** Pluralization functions from
 *  {@link http://github.com/eemeli/make-plural.js make-plural}
 *
 *  @memberof MessageFormat
 *  @type Object.<string,function>  */
MessageFormat.plurals = {};


/** Default number formatting functions in the style of ICU's
 *  {@link http://icu-project.org/apiref/icu4j/com/ibm/icu/text/MessageFormat.html simpleArg syntax}
 *  implemented using the
 *  {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl Intl}
 *  object defined by ECMA-402.
 *
 *  **Note**: Intl is not defined in default Node until 0.11.15 / 0.12.0, so
 *  earlier versions require a {@link https://www.npmjs.com/package/intl polyfill}.
 *  Therefore {@link MessageFormat.withIntlSupport} needs to be true for these
 *  functions to be available for inclusion in the output.
 *
 *  @see MessageFormat#setIntlSupport
 *
 *  @namespace
 *  @memberof MessageFormat
 *  @property {function} number - Represent a number as an integer, percent or currency value
 *  @property {function} date - Represent a date as a full/long/default/short string
 *  @property {function} time - Represent a time as a full/long/default/short string
 *
 *  @example
 *  > var MessageFormat = require('messageformat');
 *  > var mf = (new MessageFormat('en')).setIntlSupport(true);
 *  > mf.currency = 'EUR';
 *  > var mfunc = mf.compile("The total is {V,number,currency}.");
 *  > mfunc({V:5.5})
 *  "The total is €5.50."
 *
 *  @example
 *  > var MessageFormat = require('messageformat');
 *  > var mf = new MessageFormat('en', null, {number: MessageFormat.number});
 *  > mf.currency = 'EUR';
 *  > var mfunc = mf.compile("The total is {V,number,currency}.");
 *  > mfunc({V:5.5})
 *  "The total is €5.50."  */
MessageFormat.formatters = {};

/** Enable or disable support for the default formatters, which require the
 *  `Intl` object. Note that this can't be autodetected, as the environment
 *  in which the formatted text is compiled into Javascript functions is not
 *  necessarily the same environment in which they will get executed.
 *
 *  @see MessageFormat.formatters
 *
 *  @memberof MessageFormat
 *  @param {boolean} [enable=true]
 *  @returns {Object} The MessageFormat instance, to allow for chaining
 *  @example
 *  > var Intl = require('intl');
 *  > var MessageFormat = require('messageformat');
 *  > var mf = (new MessageFormat('en')).setIntlSupport(true);
 *  > mf.currency = 'EUR';
 *  > mf.compile("The total is {V,number,currency}.")({V:5.5});
 *  "The total is €5.50."  */



/** A set of utility functions that are called by the compiled Javascript
 *  functions, these are included locally in the output of {@link
 *  MessageFormat#compile compile()}.
 *
 *  @namespace
 *  @memberof MessageFormat  */
MessageFormat.prototype.runtime = {

  /** Utility function for `#` in plural rules
   *
   *  @param {number} value - The value to operate on
   *  @param {number} [offset=0] - An optional offset, set by the surrounding context  */
  number: function(value, offset) {
    if (isNaN(value)) throw new Error("'" + value + "' isn't a number.");
    return value - (offset || 0);
  },

  /** Utility function for `{N, plural|selectordinal, ...}`
   *
   *  @param {number} value - The key to use to find a pluralization rule
   *  @param {number} offset - An offset to apply to `value`
   *  @param {function} lcfunc - A locale function from `pluralFuncs`
   *  @param {Object.<string,string>} data - The object from which results are looked up
   *  @param {?boolean} isOrdinal - If true, use ordinal rather than cardinal rules
   *  @returns {string} The result of the pluralization  */
  plural: function(value, offset, lcfunc, data, isOrdinal) {
    if ({}.hasOwnProperty.call(data, value)) return data[value]();
    if (offset) value -= offset;
    var key = lcfunc(value, isOrdinal);
    if (key in data) return data[key]();
    return data.other();
  },

  /** Utility function for `{N, select, ...}`
   *
   *  @param {number} value - The key to use to find a selection
   *  @param {Object.<string,string>} data - The object from which results are looked up
   *  @returns {string} The result of the select statement  */
  select: function(value, data) {
    if ({}.hasOwnProperty.call(data, value)) return data[value]();
    return data.other()
  },

  /** Pluralization functions included in compiled output
   *  @instance
   *  @type Object.<string,function>  */
  pluralFuncs: {},

  /** Custom formatting functions called by `{var, fn[, args]*}` syntax
   *
   *  For examples, see {@link MessageFormat.formatters}
   *
   *  @instance
   *  @see MessageFormat.formatters
   *  @type Object.<string,function>  */
  fmt: {},

  /** Custom stringifier to clean up browser inconsistencies
   *  @instance  */
  toString: function () {
    var _stringify = function(o, level) {
      if (typeof o != 'object') {
        var funcStr = o.toString().replace(/^(function )\w*/, '$1');
        var indent = /([ \t]*)\S.*$/.exec(funcStr);
        return indent ? funcStr.replace(new RegExp('^' + indent[1], 'mg'), '') : funcStr;
      }
      var s = [];
      for (var i in o) if (i != 'toString') {
        if (level == 0) s.push('var ' + i + ' = ' + _stringify(o[i], level + 1) + ';\n');
        else s.push(propname(i) + ': ' + _stringify(o[i], level + 1));
      }
      if (level == 0) return s.join('');
      if (s.length == 0) return '{}';
      var indent = '  '; while (--level) indent += '  ';
      return '{\n' + s.join(',\n').replace(/^/gm, indent) + '\n}';
    };
    return _stringify(this, 0);
  }
};


/** Recursively map an AST to its resulting string
 *
 *  @memberof MessageFormat
 *
 *  @param ast - the Ast node for which the JS code should be generated
 *
 *  @private  */
MessageFormat.prototype._precompile = function(ast, data) {
  data = data || { keys: {}, offset: {} };
  var r = [], i, tmp, args = [];

  switch ( ast.type ) {
    case 'messageFormatPattern':
      for ( i = 0; i < ast.statements.length; ++i ) {
        r.push(this._precompile( ast.statements[i], data ));
      }
      tmp = r.join(' + ') || '""';
      return data.pf_count ? tmp : 'function(d) { return ' + tmp + '; }';

    case 'messageFormatElement':
      data.pf_count = data.pf_count || 0;
      if ( ast.output ) {
        return propname(ast.argumentIndex, 'd');
      }
      else {
        data.keys[data.pf_count] = ast.argumentIndex;
        return this._precompile( ast.elementFormat, data );
      }
      return '';

    case 'elementFormat':
      args = [ propname(data.keys[data.pf_count], 'd') ];
      switch (ast.key) {
        case 'select':
          args.push(this._precompile(ast.val, data));
          return 'select(' + args.join(', ') + ')';
        case 'selectordinal':
          args = args.concat([ 0, propname(this.lc[0], 'pluralFuncs'), this._precompile(ast.val, data), 1 ]);
          return 'plural(' + args.join(', ') + ')';
        case 'plural':
          data.offset[data.pf_count || 0] = ast.val.offset || 0;
          args = args.concat([ data.offset[data.pf_count] || 0, propname(this.lc[0], 'pluralFuncs'), this._precompile(ast.val, data) ]);
          return 'plural(' + args.join(', ') + ')';
        default:
          if (this.withIntlSupport && !(ast.key in this.runtime.fmt) && (ast.key in MessageFormat.formatters)) {
            tmp = MessageFormat.formatters[ast.key];
            this.runtime.fmt[ast.key] = (typeof tmp(this) == 'function') ? tmp(this) : tmp;
          }
          args.push(JSON.stringify(this.lc));
          if (ast.val && ast.val.length) args.push(JSON.stringify(ast.val.length == 1 ? ast.val[0] : ast.val));
          return 'fmt.' + ast.key + '(' + args.join(', ') + ')';
      }

    case 'pluralFormatPattern':
    case 'selectFormatPattern':
      data.pf_count = data.pf_count || 0;
      if (ast.type == 'selectFormatPattern') data.offset[data.pf_count] = 0;
      var needOther = true;
      for (i = 0; i < ast.pluralForms.length; ++i) {
        var key = ast.pluralForms[i].key;
        if (key === 'other') needOther = false;
        var data_copy = JSON.parse(JSON.stringify(data));
        data_copy.pf_count++;
        r.push(propname(key) + ': function() { return ' + this._precompile(ast.pluralForms[i].val, data_copy) + ';}');
      }
      if (needOther) throw new Error("No 'other' form found in " + ast.type + " " + data.pf_count);
      return '{ ' + r.join(', ') + ' }';

    case 'string':
      return JSON.stringify(ast.val || "");

    case 'octothorpe':
      if (!data.pf_count) return '"#"';
      args = [ propname(data.keys[data.pf_count-1], 'd') ];
      if (data.offset[data.pf_count-1]) args.push(data.offset[data.pf_count-1]);
      return 'number(' + args.join(', ') + ')';

    default:
      throw new Error( 'Bad AST type: ' + ast.type );
  }
};

/** Compile messages into an executable function with clean string
 *  representation.
 *
 *  If `messages` is a single string including ICU MessageFormat declarations,
 *  `opt` is ignored and the returned function takes a single Object parameter
 *  `d` representing each of the input's defined variables. The returned
 *  function will be defined in a local scope that includes all the required
 *  runtime variables.
 *
 *  If `messages` is a map of keys to strings, or a map of namespace keys to
 *  such key/string maps, the returned function will fill the specified global
 *  with javascript functions matching the structure of the input. In such use,
 *  the output of `compile()` is expected to be serialized using `.toString()`,
 *  and will include definitions of the runtime functions. If `opt.global` is
 *  null, calling the output function will return the object itself.
 *
 *  Together, the input parameters should match the following patterns:
 *  ```js
 *  messages = "string" || { key0: "string0", key1: "string1", ... } || {
 *    ns0: { key0: "string0", key1: "string1", ...  },
 *    ns1: { key0: "string0", key1: "string1", ...  },
 *    ...
 *  }
 *
 *  opt = null || {
 *    locale: null || {
 *      ns0: "lc0" || [ "lc0", ... ],
 *      ns1: "lc1" || [ "lc1", ... ],
 *      ...
 *    },
 *    global: null || "module.exports" || "exports" || "i18n" || ...
 *  }
 *  ```
 *
 *  @memberof MessageFormat
 *  @param {string|Object}
 *      messages - The input message(s) to be compiled, in ICU MessageFormat
 *  @param {Object} [opt={}] - Options controlling output for non-simple intput
 *  @param {Object} [opt.locale] - The locales to use for the messages, with a
 *      structure matching that of `messages`
 *  @param {string} [opt.global=""] - The global variable that the output
 *      function should use, or a null string for none. "exports" and
 *      "module.exports" are recognised as special cases.
 *  @returns {function} The first match found for the given locale(s)
 *
 *  @example
 * > var MessageFormat = require('messageformat'),
 * ...   mf = new MessageFormat('en'),
 * ...   mfunc0 = mf.compile('A {TYPE} example.');
 * > mfunc0({TYPE:'simple'})
 * 'A simple example.'
 * > mfunc0.toString()
 * 'function (d) { return "A " + d.TYPE + " example."; }'
 *
 *  @example
 * > var msgSet = { a: 'A {TYPE} example.',
 * ...              b: 'This has {COUNT, plural, one{one member} other{# members}}.' },
 * ...   mfuncSet = mf.compile(msgSet);
 * > mfuncSet().a({TYPE:'more complex'})
 * 'A more complex example.'
 * > mfuncSet().b({COUNT:2})
 * 'This has 2 members.'
 *
 * > console.log(mfuncSet.toString())
 * function anonymous() {
 * var number = function (value, offset) {
 *   if (isNaN(value)) throw new Error("'" + value + "' isn't a number.");
 *   return value - (offset || 0);
 * };
 * var plural = function (value, offset, lcfunc, data, isOrdinal) {
 *   if ({}.hasOwnProperty.call(data, value)) return data[value]();
 *   if (offset) value -= offset;
 *   var key = lcfunc(value, isOrdinal);
 *   if (key in data) return data[key]();
 *   return data.other();
 * };
 * var select = function (value, data) {
 *   if ({}.hasOwnProperty.call(data, value)) return data[value]();
 *   return data.other()
 * };
 * var pluralFuncs = {
 *   en: function (n, ord) {
 *     var s = String(n).split('.'), v0 = !s[1], t0 = Number(s[0]) == n,
 *         n10 = t0 && s[0].slice(-1), n100 = t0 && s[0].slice(-2);
 *     if (ord) return (n10 == 1 && n100 != 11) ? 'one'
 *         : (n10 == 2 && n100 != 12) ? 'two'
 *         : (n10 == 3 && n100 != 13) ? 'few'
 *         : 'other';
 *     return (n == 1 && v0) ? 'one' : 'other';
 *   }
 * };
 * var fmt = {};
 *
 * return {
 *   a: function(d) { return "A " + d.TYPE + " example."; },
 *   b: function(d) { return "This has " + plural(d.COUNT, 0, pluralFuncs.en, { one: function() { return "one member";}, other: function() { return number(d.COUNT)+" members";} }) + "."; }
 * }
 * }
 *
 *  @example
 * > mf.runtime.pluralFuncs.fi = MessageFormat.plurals.fi;
 * > var multiSet = { en: { a: 'A {TYPE} example.',
 * ...                      b: 'This is the {COUNT, selectordinal, one{#st} two{#nd} few{#rd} other{#th}} example.' },
 * ...                fi: { a: '{TYPE} esimerkki.',
 * ...                      b: 'Tämä on {COUNT, selectordinal, other{#.}} esimerkki.' } },
 * ...   multiSetLocales = { en: 'en', fi: 'fi' },
 * ...   mfuncSet = mf.compile(multiSet, { locale: multiSetLocales, global: 'i18n' });
 * > mfuncSet(this);
 * > i18n.en.b({COUNT:3})
 * 'This is the 3rd example.'
 * > i18n.fi.b({COUNT:3})
 * 'Tämä on 3. esimerkki.'  */
MessageFormat.prototype.compile = function ( messages, opt ) {
  var r = {}, lc0 = this.lc,
      compileMsg = function(self, msg) {
        try {
          var ast = MessageFormat._parse(msg);
          return self._precompile(ast);
        } catch (e) {
          throw new Error((ast ? 'Precompiler' : 'Parser') + ' error: ' + e.toString());
        }
      },
      stringify = function(r, level) {
        if (!level) level = 0;
        if (typeof r != 'object') return r;
        var o = [], indent = '';
        for (var i = 0; i < level; ++i) indent += '  ';
        for (var k in r) o.push('\n' + indent + '  ' + propname(k) + ': ' + stringify(r[k], level + 1));
        return '{' + o.join(',') + '\n' + indent + '}';
      };

  if (typeof messages == 'string') {
    var f = new Function(
        'number, plural, select, pluralFuncs, fmt',
        'return ' + compileMsg(this, messages));
    return f(this.runtime.number, this.runtime.plural, this.runtime.select,
        this.runtime.pluralFuncs, this.runtime.fmt);
  }

  opt = opt || {};

  for (var ns in messages) {
    if (opt.locale) this.lc = opt.locale[ns] && [].concat(opt.locale[ns]) || lc0;
    if (typeof messages[ns] == 'string') {
      try { r[ns] = compileMsg(this, messages[ns]); }
      catch (e) { e.message = e.message.replace(':', ' with `' + ns + '`:'); throw e; }
    } else {
      r[ns] = {};
      for (var key in messages[ns]) {
        try { r[ns][key] = compileMsg(this, messages[ns][key]); }
        catch (e) { e.message = e.message.replace(':', ' with `' + key + '` in `' + ns + '`:'); throw e; }
      }
    }
  }

  this.lc = lc0;
  var s = this.runtime.toString() + '\n';
  switch (opt.global || '') {
    case 'exports':
      var o = [];
      for (var k in r) o.push(propname(k, 'exports') + ' = ' + stringify(r[k]));
      return new Function(s + o.join(';\n'));
    case 'module.exports':
      return new Function(s + 'module.exports = ' + stringify(r));
    case '':
      return new Function(s + 'return ' + stringify(r));
    default:
      return new Function('G', s + propname(opt.global, 'G') + ' = ' + stringify(r));
  }
};


return MessageFormat;
}());
/* jshint ignore:end */


var createErrorPluralModulePresence = function() {
	return createError( "E_MISSING_PLURAL_MODULE", "Plural module not loaded." );
};




var validateMessageBundle = function( cldr ) {
	validate(
		"E_MISSING_MESSAGE_BUNDLE",
		"Missing message bundle for locale `{locale}`.",
		cldr.attributes.bundle && cldr.get( "globalize-messages/{bundle}" ) !== undefined,
		{
			locale: cldr.locale
		}
	);
};




var validateMessagePresence = function( path, value ) {
	path = path.join( "/" );
	validate( "E_MISSING_MESSAGE", "Missing required message content `{path}`.",
		value !== undefined, { path: path } );
};




var validateMessageType = function( path, value ) {
	path = path.join( "/" );
	validate(
		"E_INVALID_MESSAGE",
		"Invalid message content `{path}`. {expected} expected.",
		typeof value === "string",
		{
			expected: "a string",
			path: path
		}
	);
};




var validateParameterTypeMessageVariables = function( value, name ) {
	validateParameterType(
		value,
		name,
		value === undefined || isPlainObject( value ) || Array.isArray( value ),
		"Array or Plain Object"
	);
};




var messageFormatterFn = function( formatter ) {
	return function messageFormatter( variables ) {
		if ( typeof variables === "number" || typeof variables === "string" ) {
			variables = [].slice.call( arguments, 0 );
		}
		validateParameterTypeMessageVariables( variables, "variables" );
		return formatter( variables );
	};
};




var messageFormatterRuntimeBind = function( cldr, messageformatter ) {
	var locale = cldr.locale,
		origToString = messageformatter.toString;

	messageformatter.toString = function() {
		var argNames, argValues, output,
			args = {};

		// Properly adjust SlexAxton/messageformat.js compiled variables with Globalize variables:
		output = origToString.call( messageformatter );

		if ( /number\(/.test( output ) ) {
			args.number = "messageFormat.number";
		}

		if ( /plural\(/.test( output ) ) {
			args.plural = "messageFormat.plural";
		}

		if ( /select\(/.test( output ) ) {
			args.select = "messageFormat.select";
		}

		output.replace( /pluralFuncs(\[([^\]]+)\]|\.([a-zA-Z]+))/, function( match ) {
			args.pluralFuncs = "{" +
				"\"" + locale + "\": Globalize(\"" + locale + "\").pluralGenerator()" +
				"}";
			return match;
		});

		argNames = Object.keys( args ).join( ", " );
		argValues = Object.keys( args ).map(function( key ) {
			return args[ key ];
		}).join( ", " );

		return "(function( " + argNames + " ) {\n" +
			"  return " + output + "\n" +
			"})(" + argValues + ")";
	};

	return messageformatter;
};




var slice = [].slice;

/**
 * .loadMessages( json )
 *
 * @json [JSON]
 *
 * Load translation data.
 */
Globalize.loadMessages = function( json ) {
	var locale,
		customData = {
			"globalize-messages": json,
			"main": {}
		};

	validateParameterPresence( json, "json" );
	validateParameterTypePlainObject( json, "json" );

	// Set available bundles by populating customData main dataset.
	for ( locale in json ) {
		if ( json.hasOwnProperty( locale ) ) {
			customData.main[ locale ] = {};
		}
	}

	Cldr.load( customData );
};

/**
 * .messageFormatter( path )
 *
 * @path [String or Array]
 *
 * Format a message given its path.
 */
Globalize.messageFormatter =
Globalize.prototype.messageFormatter = function( path ) {
	var cldr, formatter, message, pluralGenerator, returnFn,
		args = slice.call( arguments, 0 );

	validateParameterPresence( path, "path" );
	validateParameterType( path, "path", typeof path === "string" || Array.isArray( path ),
		"a String nor an Array" );

	path = alwaysArray( path );
	cldr = this.cldr;

	validateDefaultLocale( cldr );
	validateMessageBundle( cldr );

	message = cldr.get( [ "globalize-messages/{bundle}" ].concat( path ) );
	validateMessagePresence( path, message );

	// If message is an Array, concatenate it.
	if ( Array.isArray( message ) ) {
		message = message.join( " " );
	}
	validateMessageType( path, message );

	// Is plural module present? Yes, use its generator. Nope, use an error generator.
	pluralGenerator = this.plural !== undefined ?
		this.pluralGenerator() :
		createErrorPluralModulePresence;

	formatter = new MessageFormat( cldr.locale, pluralGenerator ).compile( message );

	returnFn = messageFormatterFn( formatter );

	runtimeBind( args, cldr, returnFn,
		[ messageFormatterRuntimeBind( cldr, formatter ), pluralGenerator ] );

	return returnFn;
};

/**
 * .formatMessage( path [, variables] )
 *
 * @path [String or Array]
 *
 * @variables [Number, String, Array or Object]
 *
 * Format a message given its path.
 */
Globalize.formatMessage =
Globalize.prototype.formatMessage = function( path /* , variables */ ) {
	return this.messageFormatter( path ).apply( {}, slice.call( arguments, 1 ) );
};

return Globalize;




}));

/**
 * Globalize v1.4.2
 *
 * http://github.com/jquery/globalize
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2019-03-07T13:47Z
 */
/*!
 * Globalize v1.4.2 2019-03-07T13:47Z Released under the MIT license
 * http://git.io/TrdQbw
 */
(function( root, factory ) {

	// UMD returnExports
	if ( typeof define === "function" && define.amd ) {

		// AMD
		define([
			"cldr",
			"../globalize",
			"cldr/event",
			"cldr/supplemental"
		], factory );
	} else if ( typeof exports === "object" ) {

		// Node, CommonJS
		module.exports = factory( require( "cldrjs" ), require( "../globalize" ) );
	} else {

		// Global
		factory( root.Cldr, root.Globalize );
	}
}(this, function( Cldr, Globalize ) {

var createError = Globalize._createError,
	regexpEscape = Globalize._regexpEscape,
	runtimeBind = Globalize._runtimeBind,
	stringPad = Globalize._stringPad,
	validateCldr = Globalize._validateCldr,
	validateDefaultLocale = Globalize._validateDefaultLocale,
	validateParameterPresence = Globalize._validateParameterPresence,
	validateParameterRange = Globalize._validateParameterRange,
	validateParameterType = Globalize._validateParameterType,
	validateParameterTypePlainObject = Globalize._validateParameterTypePlainObject;


var createErrorUnsupportedFeature = function( feature ) {
	return createError( "E_UNSUPPORTED", "Unsupported {feature}.", {
		feature: feature
	});
};




var validateParameterTypeNumber = function( value, name ) {
	validateParameterType(
		value,
		name,
		value === undefined || typeof value === "number",
		"Number"
	);
};




var validateParameterTypeString = function( value, name ) {
	validateParameterType(
		value,
		name,
		value === undefined || typeof value === "string",
		"a string"
	);
};




/**
 * EBNF representation:
 *
 * compact_pattern_re =       prefix?
 *                            number_pattern_re
 *                            suffix?
 *
 * number_pattern_re =        0+
 *
 * Regexp groups:
 *
 *  0: compact_pattern_re
 *  1: prefix
 *  2: number_pattern_re (the number pattern to use in compact mode)
 *  3: suffix
 */
var numberCompactPatternRe = ( /^([^0]*)(0+)([^0]*)$/ );




/**
 * goupingSeparator( number, primaryGroupingSize, secondaryGroupingSize )
 *
 * @number [Number].
 *
 * @primaryGroupingSize [Number]
 *
 * @secondaryGroupingSize [Number]
 *
 * Return the formatted number with group separator.
 */
var numberFormatGroupingSeparator = function( number, primaryGroupingSize, secondaryGroupingSize ) {
	var index,
		currentGroupingSize = primaryGroupingSize,
		ret = "",
		sep = ",",
		switchToSecondary = secondaryGroupingSize ? true : false;

	number = String( number ).split( "." );
	index = number[ 0 ].length;

	while ( index > currentGroupingSize ) {
		ret = number[ 0 ].slice( index - currentGroupingSize, index ) +
			( ret.length ? sep : "" ) + ret;
		index -= currentGroupingSize;
		if ( switchToSecondary ) {
			currentGroupingSize = secondaryGroupingSize;
			switchToSecondary = false;
		}
	}

	number[ 0 ] = number[ 0 ].slice( 0, index ) + ( ret.length ? sep : "" ) + ret;
	return number.join( "." );
};




/**
 * integerFractionDigits( number, minimumIntegerDigits, minimumFractionDigits,
 * maximumFractionDigits, round, roundIncrement )
 *
 * @number [Number]
 *
 * @minimumIntegerDigits [Number]
 *
 * @minimumFractionDigits [Number]
 *
 * @maximumFractionDigits [Number]
 *
 * @round [Function]
 *
 * @roundIncrement [Function]
 *
 * Return the formatted integer and fraction digits.
 */
var numberFormatIntegerFractionDigits = function( number, minimumIntegerDigits, minimumFractionDigits, maximumFractionDigits, round,
	roundIncrement ) {

	// Fraction
	if ( maximumFractionDigits ) {

		// Rounding
		if ( roundIncrement ) {
			number = round( number, roundIncrement );

		// Maximum fraction digits
		} else {
			number = round( number, { exponent: -maximumFractionDigits } );
		}

	} else {
		number = round( number );
	}

	number = String( number );

	// Maximum integer digits (post string phase)
	if ( maximumFractionDigits && /e-/.test( number ) ) {

		// Use toFixed( maximumFractionDigits ) to make sure small numbers like 1e-7 are
		// displayed using plain digits instead of scientific notation.
		// 1: Remove leading decimal zeros.
		// 2: Remove leading decimal separator.
		// Note: String() is still preferred so it doesn't mess up with a number precision
		// unnecessarily, e.g., (123456789.123).toFixed(10) === "123456789.1229999959",
		// String(123456789.123) === "123456789.123".
		number = ( +number ).toFixed( maximumFractionDigits )
			.replace( /0+$/, "" ) /* 1 */
			.replace( /\.$/, "" ) /* 2 */;
	}

	// Minimum fraction digits (post string phase)
	if ( minimumFractionDigits ) {
		number = number.split( "." );
		number[ 1 ] = stringPad( number[ 1 ] || "", minimumFractionDigits, true );
		number = number.join( "." );
	}

	// Minimum integer digits
	if ( minimumIntegerDigits ) {
		number = number.split( "." );
		number[ 0 ] = stringPad( number[ 0 ], minimumIntegerDigits );
		number = number.join( "." );
	}

	return number;
};




/**
 * toPrecision( number, precision, round )
 *
 * @number (Number)
 *
 * @precision (Number) significant figures precision (not decimal precision).
 *
 * @round (Function)
 *
 * Return number.toPrecision( precision ) using the given round function.
 */
var numberToPrecision = function( number, precision, round ) {
	var roundOrder;

	roundOrder = Math.ceil( Math.log( Math.abs( number ) ) / Math.log( 10 ) );
	roundOrder -= precision;

	return round( number, { exponent: roundOrder } );
};




/**
 * toPrecision( number, minimumSignificantDigits, maximumSignificantDigits, round )
 *
 * @number [Number]
 *
 * @minimumSignificantDigits [Number]
 *
 * @maximumSignificantDigits [Number]
 *
 * @round [Function]
 *
 * Return the formatted significant digits number.
 */
var numberFormatSignificantDigits = function( number, minimumSignificantDigits, maximumSignificantDigits, round ) {
	var atMinimum, atMaximum;

	// Sanity check.
	if ( minimumSignificantDigits > maximumSignificantDigits ) {
		maximumSignificantDigits = minimumSignificantDigits;
	}

	atMinimum = numberToPrecision( number, minimumSignificantDigits, round );
	atMaximum = numberToPrecision( number, maximumSignificantDigits, round );

	// Use atMaximum only if it has more significant digits than atMinimum.
	number = +atMinimum === +atMaximum ? atMinimum : atMaximum;

	// Expand integer numbers, eg. 123e5 to 12300.
	number = ( +number ).toString( 10 );

	if ( ( /e/ ).test( number ) ) {
		throw createErrorUnsupportedFeature({
			feature: "integers out of (1e21, 1e-7)"
		});
	}

	// Add trailing zeros if necessary.
	if ( minimumSignificantDigits - number.replace( /^0+|\./g, "" ).length > 0 ) {
		number = number.split( "." );
		number[ 1 ] = stringPad( number[ 1 ] || "", minimumSignificantDigits - number[ 0 ].replace( /^0+/, "" ).length, true );
		number = number.join( "." );
	}

	return number;
};




/**
 * EBNF representation:
 *
 * number_pattern_re =        prefix?
 *                            padding?
 *                            (integer_fraction_pattern | significant_pattern)
 *                            scientific_notation?
 *                            suffix?
 *
 * prefix =                   non_number_stuff
 *
 * padding =                  "*" regexp(.)
 *
 * integer_fraction_pattern = integer_pattern
 *                            fraction_pattern?
 *
 * integer_pattern =          regexp([#,]*[0,]*0+)
 *
 * fraction_pattern =         "." regexp(0*[0-9]*#*)
 *
 * significant_pattern =      regexp([#,]*@+#*)
 *
 * scientific_notation =      regexp(E\+?0+)
 *
 * suffix =                   non_number_stuff
 *
 * non_number_stuff =         regexp(('[^']+'|''|[^*#@0,.E])*)
 *
 *
 * Regexp groups:
 *
 *  0: number_pattern_re
 *  1: prefix
 *  2: -
 *  3: -
 *  4: padding
 *  5: (integer_fraction_pattern | significant_pattern)
 *  6: integer_fraction_pattern
 *  7: integer_pattern
 *  8: fraction_pattern
 *  9: significant_pattern
 * 10: scientific_notation
 * 11: suffix
 * 12: -
 */
var numberPatternRe = ( /^(('([^']|'')*'|[^*#@0,.E])*)(\*.)?((([#,]*[0,]*0+)(\.0*[0-9]*#*)?)|([#,]*@+#*))(E\+?0+)?(('[^']+'|''|[^*#@0,.E])*)$/ );




/**
 * removeLiteralQuotes( string )
 *
 * Return:
 * - `` if input string is `''`.
 * - `o'clock` if input string is `'o''clock'`.
 * - `foo` if input string is `foo`, i.e., return the same value in case it isn't a single-quoted
 *   string.
 */
var removeLiteralQuotes = function( string ) {
	if ( string[ 0 ] + string[ string.length - 1 ] !== "''" ) {
		return string;
	}
	if ( string === "''" ) {
		return "";
	}
	return string.replace( /''/g, "'" ).slice( 1, -1 );
};




/**
 * format( number, properties )
 *
 * @number [Number].
 *
 * @properties [Object] Output of number/format-properties.
 *
 * Return the formatted number.
 * ref: http://www.unicode.org/reports/tr35/tr35-numbers.html
 */
var numberFormat = function( number, properties, pluralGenerator ) {
	var compactMap, infinitySymbol, maximumFractionDigits, maximumSignificantDigits,
	minimumFractionDigits, minimumIntegerDigits, minimumSignificantDigits, nanSymbol, nuDigitsMap,
	padding, prefix, primaryGroupingSize, pattern, ret, round, roundIncrement,
	secondaryGroupingSize, suffix, symbolMap;

	padding = properties[ 1 ];
	minimumIntegerDigits = properties[ 2 ];
	minimumFractionDigits = properties[ 3 ];
	maximumFractionDigits = properties[ 4 ];
	minimumSignificantDigits = properties[ 5 ];
	maximumSignificantDigits = properties[ 6 ];
	roundIncrement = properties[ 7 ];
	primaryGroupingSize = properties[ 8 ];
	secondaryGroupingSize = properties[ 9 ];
	round = properties[ 15 ];
	infinitySymbol = properties[ 16 ];
	nanSymbol = properties[ 17 ];
	symbolMap = properties[ 18 ];
	nuDigitsMap = properties[ 19 ];
	compactMap = properties[ 20 ];

	// NaN
	if ( isNaN( number ) ) {
		return nanSymbol;
	}

	if ( number < 0 ) {
		pattern = properties[ 12 ];
		prefix = properties[ 13 ];
		suffix = properties[ 14 ];
	} else {
		pattern = properties[ 11 ];
		prefix = properties[ 0 ];
		suffix = properties[ 10 ];
	}

	// Infinity
	if ( !isFinite( number ) ) {
		return prefix + infinitySymbol + suffix;
	}

	// Percent
	if ( pattern.indexOf( "%" ) !== -1 ) {
		number *= 100;

	// Per mille
	} else if ( pattern.indexOf( "\u2030" ) !== -1 ) {
		number *= 1000;
	}

	var compactPattern, compactDigits, compactProperties, divisor, numberExponent, pluralForm;

	// Compact mode: initial number digit processing
	if ( compactMap ) {
		numberExponent = Math.abs( Math.floor( number ) ).toString().length - 1;
		numberExponent = Math.min( numberExponent, compactMap.maxExponent );

		// Use default plural form to perform initial decimal shift
		if ( numberExponent >= 3 ) {
			compactPattern = compactMap[ numberExponent ] && compactMap[ numberExponent ].other;
		}

		if ( compactPattern === "0" ) {
			compactPattern = null;
		} else if ( compactPattern ) {
			compactDigits = compactPattern.split( "0" ).length - 1;
			divisor = numberExponent - ( compactDigits - 1 );
			number = number / Math.pow( 10, divisor );
		}
	}

	// Significant digit format
	if ( !isNaN( minimumSignificantDigits * maximumSignificantDigits ) ) {
		number = numberFormatSignificantDigits( number, minimumSignificantDigits,
			maximumSignificantDigits, round );

	// Integer and fractional format
	} else {
		number = numberFormatIntegerFractionDigits( number, minimumIntegerDigits,
			minimumFractionDigits, maximumFractionDigits, round, roundIncrement );
	}

	// Compact mode: apply formatting
	if ( compactMap && compactPattern ) {

		// Get plural form after possible roundings
		pluralForm = pluralGenerator ? pluralGenerator( +number ) : "other";

		compactPattern = compactMap[ numberExponent ][ pluralForm ] || compactPattern;
		compactProperties = compactPattern.match( numberCompactPatternRe );

		// update prefix/suffix with compact prefix/suffix
		prefix += compactProperties[ 1 ];
		suffix = compactProperties[ 3 ] + suffix;
	}

	// Remove the possible number minus sign
	number = number.replace( /^-/, "" );

	// Grouping separators
	if ( primaryGroupingSize ) {
		number = numberFormatGroupingSeparator( number, primaryGroupingSize,
			secondaryGroupingSize );
	}

	ret = prefix;

	ret += number;

	// Scientific notation
	// TODO implement here

	// Padding/'([^']|'')+'|''|[.,\-+E%\u2030]/g
	// TODO implement here

	ret += suffix;

	return ret.replace( /('([^']|'')+'|'')|./g, function( character, literal ) {

		// Literals
		if ( literal ) {
			return removeLiteralQuotes( literal );
		}

		// Symbols
		character = character.replace( /[.,\-+E%\u2030]/, function( symbol ) {
			return symbolMap[ symbol ];
		});

		// Numbering system
		if ( nuDigitsMap ) {
			character = character.replace( /[0-9]/, function( digit ) {
				return nuDigitsMap[ +digit ];
			});
		}

		return character;
	});
};




var numberFormatterFn = function( properties, pluralGenerator ) {
	return function numberFormatter( value ) {
		validateParameterPresence( value, "value" );
		validateParameterTypeNumber( value, "value" );

		return numberFormat( value, properties, pluralGenerator );
	};
};




/**
 * NumberingSystem( cldr )
 *
 * - http://www.unicode.org/reports/tr35/tr35-numbers.html#otherNumberingSystems
 * - http://cldr.unicode.org/index/bcp47-extension
 * - http://www.unicode.org/reports/tr35/#u_Extension
 */
var numberNumberingSystem = function( cldr ) {
	var nu = cldr.attributes[ "u-nu" ];

	if ( nu ) {
		if ( nu === "traditio" ) {
			nu = "traditional";
		}
		if ( [ "native", "traditional", "finance" ].indexOf( nu ) !== -1 ) {

			// Unicode locale extension `u-nu` is set using either (native, traditional or
			// finance). So, lookup the respective locale's numberingSystem and return it.
			return cldr.main([ "numbers/otherNumberingSystems", nu ]);
		}

		// Unicode locale extension `u-nu` is set with an explicit numberingSystem. Return it.
		return nu;
	}

	// Return the default numberingSystem.
	return cldr.main( "numbers/defaultNumberingSystem" );
};




/**
 * Compact( name, cldr )
 *
 * @compactType [String] Compact mode, `short` or `long`.
 *
 * @cldr [Cldr instance].
 *
 * Return the localized compact map for the given compact mode.
 */
var numberCompact = function( compactType, cldr ) {
	var maxExponent = 0;

	var object = cldr.main([
		"numbers/decimalFormats-numberSystem-" + numberNumberingSystem( cldr ),
		compactType,
		"decimalFormat"
	]);

	object = Object.keys( object ).reduce(function( newObject, compactKey ) {
		var numberExponent = compactKey.split( "0" ).length - 1;
		var pluralForm = compactKey.split( "-" )[ 2 ];
		newObject[ numberExponent ] = newObject[ numberExponent ] || {};
		newObject[ numberExponent ][ pluralForm ] = object[ compactKey ];
		maxExponent = Math.max( numberExponent, maxExponent );
		return newObject;
	}, {});

	object.maxExponent = maxExponent;

	return object;
};




/**
 * nuMap( cldr )
 *
 * @cldr [Cldr instance].
 *
 * Return digits map if numbering system is different than `latn`.
 */
var numberNumberingSystemDigitsMap = function( cldr ) {
	var aux,
		nu = numberNumberingSystem( cldr );

	if ( nu === "latn" ) {
		return;
	}

	aux = cldr.supplemental([ "numberingSystems", nu ]);

	if ( aux._type !== "numeric" ) {
		throw createErrorUnsupportedFeature( "`" + aux._type + "` numbering system" );
	}

	return aux._digits;
};




/**
 * format( number, pattern )
 *
 * @number [Number].
 *
 * @pattern [String] raw pattern for numbers.
 *
 * Return the formatted number.
 * ref: http://www.unicode.org/reports/tr35/tr35-numbers.html
 */
var numberPatternProperties = function( pattern ) {
	var aux1, aux2, fractionPattern, integerFractionOrSignificantPattern, integerPattern,
		maximumFractionDigits, maximumSignificantDigits, minimumFractionDigits,
		minimumIntegerDigits, minimumSignificantDigits, padding, prefix, primaryGroupingSize,
		roundIncrement, scientificNotation, secondaryGroupingSize, significantPattern, suffix;

	pattern = pattern.match( numberPatternRe );
	if ( !pattern ) {
		throw new Error( "Invalid pattern: " + pattern );
	}

	prefix = pattern[ 1 ];
	padding = pattern[ 4 ];
	integerFractionOrSignificantPattern = pattern[ 5 ];
	significantPattern = pattern[ 9 ];
	scientificNotation = pattern[ 10 ];
	suffix = pattern[ 11 ];

	// Significant digit format
	if ( significantPattern ) {
		significantPattern.replace( /(@+)(#*)/, function( match, minimumSignificantDigitsMatch, maximumSignificantDigitsMatch ) {
			minimumSignificantDigits = minimumSignificantDigitsMatch.length;
			maximumSignificantDigits = minimumSignificantDigits +
				maximumSignificantDigitsMatch.length;
		});

	// Integer and fractional format
	} else {
		fractionPattern = pattern[ 8 ];
		integerPattern = pattern[ 7 ];

		if ( fractionPattern ) {

			// Minimum fraction digits, and rounding.
			fractionPattern.replace( /[0-9]+/, function( match ) {
				minimumFractionDigits = match;
			});
			if ( minimumFractionDigits ) {
				roundIncrement = +( "0." + minimumFractionDigits );
				minimumFractionDigits = minimumFractionDigits.length;
			} else {
				minimumFractionDigits = 0;
			}

			// Maximum fraction digits
			// 1: ignore decimal character
			maximumFractionDigits = fractionPattern.length - 1 /* 1 */;
		} else {
			minimumFractionDigits = 0;
			maximumFractionDigits = 0;
		}

		// Minimum integer digits
		integerPattern.replace( /0+$/, function( match ) {
			minimumIntegerDigits = match.length;
		});
	}

	// Scientific notation
	if ( scientificNotation ) {
		throw createErrorUnsupportedFeature({
			feature: "scientific notation (not implemented)"
		});
	}

	// Padding
	if ( padding ) {
		throw createErrorUnsupportedFeature({
			feature: "padding (not implemented)"
		});
	}

	// Grouping
	if ( ( aux1 = integerFractionOrSignificantPattern.lastIndexOf( "," ) ) !== -1 ) {

		// Primary grouping size is the interval between the last group separator and the end of
		// the integer (or the end of the significant pattern).
		aux2 = integerFractionOrSignificantPattern.split( "." )[ 0 ];
		primaryGroupingSize = aux2.length - aux1 - 1;

		// Secondary grouping size is the interval between the last two group separators.
		if ( ( aux2 = integerFractionOrSignificantPattern.lastIndexOf( ",", aux1 - 1 ) ) !== -1 ) {
			secondaryGroupingSize = aux1 - 1 - aux2;
		}
	}

	// Return:
	//  0: @prefix String
	//  1: @padding Array [ <character>, <count> ] TODO
	//  2: @minimumIntegerDigits non-negative integer Number value indicating the minimum integer
	//        digits to be used. Numbers will be padded with leading zeroes if necessary.
	//  3: @minimumFractionDigits and
	//  4: @maximumFractionDigits are non-negative integer Number values indicating the minimum and
	//        maximum fraction digits to be used. Numbers will be rounded or padded with trailing
	//        zeroes if necessary.
	//  5: @minimumSignificantDigits and
	//  6: @maximumSignificantDigits are positive integer Number values indicating the minimum and
	//        maximum fraction digits to be shown. Either none or both of these properties are
	//        present; if they are, they override minimum and maximum integer and fraction digits
	//        – the formatter uses however many integer and fraction digits are required to display
	//        the specified number of significant digits.
	//  7: @roundIncrement Decimal round increment or null
	//  8: @primaryGroupingSize
	//  9: @secondaryGroupingSize
	// 10: @suffix String
	return [
		prefix,
		padding,
		minimumIntegerDigits,
		minimumFractionDigits,
		maximumFractionDigits,
		minimumSignificantDigits,
		maximumSignificantDigits,
		roundIncrement,
		primaryGroupingSize,
		secondaryGroupingSize,
		suffix
	];
};




/**
 * Symbol( name, cldr )
 *
 * @name [String] Symbol name.
 *
 * @cldr [Cldr instance].
 *
 * Return the localized symbol given its name.
 */
var numberSymbol = function( name, cldr ) {
	return cldr.main([
		"numbers/symbols-numberSystem-" + numberNumberingSystem( cldr ),
		name
	]);
};




var numberSymbolName = {
	".": "decimal",
	",": "group",
	"%": "percentSign",
	"+": "plusSign",
	"-": "minusSign",
	"E": "exponential",
	"\u2030": "perMille"
};




/**
 * symbolMap( cldr )
 *
 * @cldr [Cldr instance].
 *
 * Return the (localized symbol, pattern symbol) key value pair, eg. {
 *   ".": "٫",
 *   ",": "٬",
 *   "%": "٪",
 *   ...
 * };
 */
var numberSymbolMap = function( cldr ) {
	var symbol,
		symbolMap = {};

	for ( symbol in numberSymbolName ) {
		symbolMap[ symbol ] = numberSymbol( numberSymbolName[ symbol ], cldr );
	}

	return symbolMap;
};




var numberTruncate = function( value ) {
	if ( isNaN( value ) ) {
		return NaN;
	}
	return Math[ value < 0 ? "ceil" : "floor" ]( value );
};




/**
 * round( method )
 *
 * @method [String] with either "round", "ceil", "floor", or "truncate".
 *
 * Return function( value, incrementOrExp ):
 *
 *   @value [Number] eg. 123.45.
 *
 *   @incrementOrExp [Number] optional, eg. 0.1; or
 *     [Object] Either { increment: <value> } or { exponent: <value> }
 *
 *   Return the rounded number, eg:
 *   - round( "round" )( 123.45 ): 123;
 *   - round( "ceil" )( 123.45 ): 124;
 *   - round( "floor" )( 123.45 ): 123;
 *   - round( "truncate" )( 123.45 ): 123;
 *   - round( "round" )( 123.45, 0.1 ): 123.5;
 *   - round( "round" )( 123.45, 10 ): 120;
 *
 *   Based on https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/round
 *   Ref: #376
 */
var numberRound = function( method ) {
	method = method || "round";
	method = method === "truncate" ? numberTruncate : Math[ method ];

	return function( value, incrementOrExp ) {
		var exp, increment;

		value = +value;

		// If the value is not a number, return NaN.
		if ( isNaN( value ) ) {
			return NaN;
		}

		// Exponent given.
		if ( typeof incrementOrExp === "object" && incrementOrExp.exponent ) {
			exp = +incrementOrExp.exponent;
			increment = 1;

			if ( exp === 0 ) {
				return method( value );
			}

			// If the exp is not an integer, return NaN.
			if ( !( typeof exp === "number" && exp % 1 === 0 ) ) {
				return NaN;
			}

		// Increment given.
		} else {
			increment = +incrementOrExp || 1;

			if ( increment === 1 ) {
				return method( value );
			}

			// If the increment is not a number, return NaN.
			if ( isNaN( increment ) ) {
				return NaN;
			}

			increment = increment.toExponential().split( "e" );
			exp = +increment[ 1 ];
			increment = +increment[ 0 ];
		}

		// Shift & Round
		value = value.toString().split( "e" );
		value[ 0 ] = +value[ 0 ] / increment;
		value[ 1 ] = value[ 1 ] ? ( +value[ 1 ] - exp ) : -exp;
		value = method( +( value[ 0 ] + "e" + value[ 1 ] ) );

		// Shift back
		value = value.toString().split( "e" );
		value[ 0 ] = +value[ 0 ] * increment;
		value[ 1 ] = value[ 1 ] ? ( +value[ 1 ] + exp ) : exp;
		return +( value[ 0 ] + "e" + value[ 1 ] );
	};
};




/**
 * formatProperties( pattern, cldr [, options] )
 *
 * @pattern [String] raw pattern for numbers.
 *
 * @cldr [Cldr instance].
 *
 * @options [Object]:
 * - minimumIntegerDigits [Number]
 * - minimumFractionDigits, maximumFractionDigits [Number]
 * - minimumSignificantDigits, maximumSignificantDigits [Number]
 * - round [String] "ceil", "floor", "round" (default), or "truncate".
 * - useGrouping [Boolean] default true.
 *
 * Return the processed properties that will be used in number/format.
 * ref: http://www.unicode.org/reports/tr35/tr35-numbers.html
 */
var numberFormatProperties = function( pattern, cldr, options ) {
	var negativePattern, negativePrefix, negativeProperties, negativeSuffix, positivePattern,
		roundFn, properties;

	function getOptions( attribute, propertyIndex ) {
		if ( attribute in options ) {
			properties[ propertyIndex ] = options[ attribute ];
		}
	}

	options = options || {};
	pattern = pattern.split( ";" );

	positivePattern = pattern[ 0 ];

	negativePattern = pattern[ 1 ] || "-" + positivePattern;
	negativeProperties = numberPatternProperties( negativePattern );
	negativePrefix = negativeProperties[ 0 ];
	negativeSuffix = negativeProperties[ 10 ];

	// Have runtime code to refer to numberRound() instead of including it explicitly.
	roundFn = numberRound( options.round );
	roundFn.generatorString = function() {
		return "numberRound(" + ( options.round ? "\"" + options.round + "\"" : "" ) + ")";
	};

	properties = numberPatternProperties( positivePattern ).concat([
		positivePattern,
		negativePrefix + positivePattern + negativeSuffix,
		negativePrefix,
		negativeSuffix,
		roundFn,
		numberSymbol( "infinity", cldr ),
		numberSymbol( "nan", cldr ),
		numberSymbolMap( cldr ),
		numberNumberingSystemDigitsMap( cldr )
	]);

	if ( options.compact ) {

		// The compact digits number pattern is always `0+`, so override the following properties.
		// Note: minimumIntegerDigits would actually range from `0` to `000` based on the scale of
		// the value to be formatted, though we're always using 1 as a simplification, because the
		// number won't be zero-padded since we chose the right format based on the scale, i.e.,
		// we'd never see something like `003M` anyway.
		properties[ 2 ] = 1; // minimumIntegerDigits
		properties[ 3 ] = 0; // minimumFractionDigits
		properties[ 4 ] = 0; // maximumFractionDigits
		properties[ 5 ] = // minimumSignificantDigits &
			properties[ 6 ] = undefined ; // maximumSignificantDigits

		properties[20] = numberCompact( options.compact, cldr );
	}

	getOptions( "minimumIntegerDigits", 2 );
	getOptions( "minimumFractionDigits", 3 );
	getOptions( "maximumFractionDigits", 4 );
	getOptions( "minimumSignificantDigits", 5 );
	getOptions( "maximumSignificantDigits", 6 );

	// Grouping separators
	if ( options.useGrouping === false ) {
		properties[ 8 ] = null;
	}

	// Normalize number of digits if only one of either minimumFractionDigits or
	// maximumFractionDigits is passed in as an option
	if ( "minimumFractionDigits" in options && !( "maximumFractionDigits" in options ) ) {

		// maximumFractionDigits = Math.max( minimumFractionDigits, maximumFractionDigits );
		properties[ 4 ] = Math.max( properties[ 3 ], properties[ 4 ] );
	} else if ( !( "minimumFractionDigits" in options ) &&
			"maximumFractionDigits" in options ) {

		// minimumFractionDigits = Math.min( minimumFractionDigits, maximumFractionDigits );
		properties[ 3 ] = Math.min( properties[ 3 ], properties[ 4 ] );
	}

	// Return:
	// 0-10: see number/pattern-properties.
	// 11: @positivePattern [String] Positive pattern.
	// 12: @negativePattern [String] Negative pattern.
	// 13: @negativePrefix [String] Negative prefix.
	// 14: @negativeSuffix [String] Negative suffix.
	// 15: @round [Function] Round function.
	// 16: @infinitySymbol [String] Infinity symbol.
	// 17: @nanSymbol [String] NaN symbol.
	// 18: @symbolMap [Object] A bunch of other symbols.
	// 19: @nuDigitsMap [Array] Digits map if numbering system is different than `latn`.
	// 20: @compactMap [Object] Map of per-digit-count format patterns for specified compact mode.
	return properties;
};




/**
 * Generated by:
 *
 * var regenerate = require( "regenerate" );
 * var formatSymbols = require( * "unicode-8.0.0/General_Category/Format/symbols" );
 * regenerate().add( formatSymbols ).toString();
 *
 * https://github.com/mathiasbynens/regenerate
 * https://github.com/mathiasbynens/unicode-8.0.0
 */
var regexpCfG = /[\xAD\u0600-\u0605\u061C\u06DD\u070F\u180E\u200B-\u200F\u202A-\u202E\u2060-\u2064\u2066-\u206F\uFEFF\uFFF9-\uFFFB]|\uD804\uDCBD|\uD82F[\uDCA0-\uDCA3]|\uD834[\uDD73-\uDD7A]|\uDB40[\uDC01\uDC20-\uDC7F]/g;




/**
 * Generated by:
 *
 * var regenerate = require( "regenerate" );
 * var dashSymbols = require( * "unicode-8.0.0/General_Category/Dash_Punctuation/symbols" );
 * regenerate().add( dashSymbols ).toString();
 *
 * https://github.com/mathiasbynens/regenerate
 * https://github.com/mathiasbynens/unicode-8.0.0
 *
 * NOTE: In addition to [:dash:],  the below includes MINUS SIGN U+2212.
 */
var regexpDashG = /[\-\u058A\u05BE\u1400\u1806\u2010-\u2015\u2E17\u2E1A\u2E3A\u2E3B\u2E40\u301C\u3030\u30A0\uFE31\uFE32\uFE58\uFE63\uFF0D\u2212]/g;




/**
 * Generated by:
 *
 * var regenerate = require( "regenerate" );
 * var spaceSeparatorSymbols = require( "unicode-8.0.0/General_Category/Space_Separator/symbols" );
 * regenerate().add( spaceSeparatorSymbols ).toString();
 *
 * https://github.com/mathiasbynens/regenerate
 * https://github.com/mathiasbynens/unicode-8.0.0
 */
var regexpZsG = /[ \xA0\u1680\u2000-\u200A\u202F\u205F\u3000]/g;




/**
 * Loose Matching:
 * - Ignore all format characters, which includes RLM, LRM or ALM used to control BIDI
 *   formatting.
 * - Map all characters in [:Zs:] to U+0020 SPACE;
 * - Map all characters in [:Dash:] to U+002D HYPHEN-MINUS;
 */
var looseMatching = function( value ) {
	return value
		.replace( regexpCfG, "" )
		.replace( regexpDashG, "-" )
		.replace( regexpZsG, " " );
};




/**
 * parse( value, properties )
 *
 * @value [String].
 *
 * @properties [Object] Parser properties is a reduced pre-processed cldr
 * data set returned by numberParserProperties().
 *
 * Return the parsed Number (including Infinity) or NaN when value is invalid.
 * ref: http://www.unicode.org/reports/tr35/tr35-numbers.html
 */
var numberParse = function( value, properties ) {
	var grammar, invertedNuDigitsMap, invertedSymbolMap, negative, number, prefix, prefixNSuffix,
		suffix, tokenizer, valid;

	// Grammar:
	// - Value <=           NaN | PositiveNumber | NegativeNumber
	// - PositiveNumber <=  PositivePrefix NumberOrInf PositiveSufix
	// - NegativeNumber <=  NegativePrefix NumberOrInf
	// - NumberOrInf <=     Number | Inf
	grammar = [
		[ "nan" ],
		[ "prefix", "infinity", "suffix" ],
		[ "prefix", "number", "suffix" ],
		[ "negativePrefix", "infinity", "negativeSuffix" ],
		[ "negativePrefix", "number", "negativeSuffix" ]
	];

	invertedSymbolMap = properties[ 0 ];
	invertedNuDigitsMap = properties[ 1 ] || {};
	tokenizer = properties[ 2 ];

	value = looseMatching( value );

	function parse( type ) {
		return function( lexeme ) {

			// Reverse localized symbols and numbering system.
			lexeme = lexeme.split( "" ).map(function( character ) {
				return invertedSymbolMap[ character ] ||
					invertedNuDigitsMap[ character ] ||
					character;
			}).join( "" );

			switch ( type ) {
				case "infinity":
					number = Infinity;
					break;

				case "nan":
					number = NaN;
					break;

				case "number":

					// Remove grouping separators.
					lexeme = lexeme.replace( /,/g, "" );

					number = +lexeme;
					break;

				case "prefix":
				case "negativePrefix":
					prefix = lexeme;
					break;

				case "suffix":
					suffix = lexeme;
					break;

				case "negativeSuffix":
					suffix = lexeme;
					negative = true;
					break;

				// This should never be reached.
				default:
					throw new Error( "Internal error" );
			}
			return "";
		};
	}

	function tokenizeNParse( _value, grammar ) {
		return grammar.some(function( statement ) {
			var value = _value;

			// The whole grammar statement should be used (i.e., .every() return true) and value be
			// entirely consumed (i.e., !value.length).
			return statement.every(function( type ) {
				if ( value.match( tokenizer[ type ] ) === null ) {
					return false;
				}

				// Consume and parse it.
				value = value.replace( tokenizer[ type ], parse( type ) );
				return true;
			}) && !value.length;
		});
	}

	valid = tokenizeNParse( value, grammar );

	// NaN
	if ( !valid || isNaN( number ) ) {
		return NaN;
	}

	prefixNSuffix = "" + prefix + suffix;

	// Percent
	if ( prefixNSuffix.indexOf( "%" ) !== -1 ) {
		number /= 100;

	// Per mille
	} else if ( prefixNSuffix.indexOf( "\u2030" ) !== -1 ) {
		number /= 1000;
	}

	// Negative number
	if ( negative ) {
		number *= -1;
	}

	return number;
};




var numberParserFn = function( properties ) {
	return function numberParser( value ) {
		validateParameterPresence( value, "value" );
		validateParameterTypeString( value, "value" );

		return numberParse( value, properties );
	};

};




/**
 * symbolMap( cldr )
 *
 * @cldr [Cldr instance].
 *
 * Return the (localized symbol, pattern symbol) key value pair, eg. {
 *   "٫": ".",
 *   "٬": ",",
 *   "٪": "%",
 *   ...
 * };
 */
var numberSymbolInvertedMap = function( cldr ) {
	var symbol,
		symbolMap = {};

	for ( symbol in numberSymbolName ) {
		symbolMap[ numberSymbol( numberSymbolName[ symbol ], cldr ) ] = symbol;
	}

	return symbolMap;
};




/**
 * objectMap( object, fn)
 *
 * - object
 *
 * - fn( pair ) => pair
 */
var objectMap = function( object, fn ) {
	return Object.keys( object ).map(function( key ) {
		return fn([ key, object[ key ] ]);
	}).reduce(function( object, pair ) {
		object[ pair[ 0 ] ] = pair[ 1 ];
		return object;
	}, {});
};




/**
 * parseProperties( pattern, cldr )
 *
 * @pattern [String] raw pattern for numbers.
 *
 * @cldr [Cldr instance].
 *
 * Return parser properties, used to feed parser function.
 *
 * TODO:
 * - Scientific_notation;
 * - Padding;
 */
var numberParseProperties = function( pattern, cldr, options ) {
	var aux, decimalSymbolRe, digitsRe, groupingSeparatorRe, infinitySymbol, invertedNuDigitsMap,
		invertedSymbolMap, maximumFractionDigits, maximumSignificantDigits,
		minimumSignificantDigits, nanSymbol, negativePrefix, negativeSuffix, nuDigitsMap,
		numberTokenizer, prefix, primaryGroupingSize, secondaryGroupingSize, suffix, symbolMap,
		formatProperties = numberFormatProperties( pattern, cldr, options );

	prefix = looseMatching( formatProperties[ 0 ] );
	maximumFractionDigits = formatProperties[ 4 ];
	minimumSignificantDigits = formatProperties[ 5 ];
	maximumSignificantDigits = formatProperties[ 6 ];
	primaryGroupingSize = formatProperties[ 8 ];
	secondaryGroupingSize = formatProperties[ 9 ];
	suffix = looseMatching( formatProperties[ 10 ] );
	negativePrefix = looseMatching( formatProperties[ 13 ] );
	negativeSuffix = looseMatching( formatProperties[ 14 ] );
	infinitySymbol = looseMatching( formatProperties[ 16 ] );
	nanSymbol = looseMatching( formatProperties[ 17 ] );
	symbolMap = objectMap( formatProperties[ 18 ], function( pair ) {
		return [ pair[ 0 ], looseMatching( pair[ 1 ] ) ];
	});
	nuDigitsMap = formatProperties[ 19 ];

	invertedSymbolMap = objectMap( numberSymbolInvertedMap( cldr ), function( pair ) {
		return [ looseMatching( pair[ 0 ] ), pair[ 1 ] ];
	});

	digitsRe = nuDigitsMap ? "[" + nuDigitsMap + "]" : "\\d";
	groupingSeparatorRe = regexpEscape( symbolMap[ "," ] );
	decimalSymbolRe = regexpEscape( symbolMap[ "." ] );

	if ( nuDigitsMap ) {
		invertedNuDigitsMap = nuDigitsMap.split( "" ).reduce(function( object, localizedDigit, i ) {
			object[ localizedDigit ] = String( i );
			return object;
		}, {} );
	}

	aux = [ prefix, suffix, negativePrefix, negativeSuffix ].map(function( value ) {
		return value.replace( /('([^']|'')+'|'')|./g, function( character, literal ) {

			// Literals
			if ( literal ) {
				return removeLiteralQuotes( literal );
			}

			// Symbols
			character = character.replace( /[\-+E%\u2030]/, function( symbol ) {
				return symbolMap[ symbol ];
			});

			return character;
		});
	});

	prefix = aux[ 0 ];
	suffix = aux[ 1 ];
	negativePrefix = aux[ 2 ];
	negativeSuffix = aux[ 3 ];

	// Number
	//
	// number_re =                       integer fraction?
	//
	// integer =                         digits | digits_using_grouping_separators
	//
	// fraction =                        regexp((.\d+)?)
	//
	// digits =                          regexp(\d+)
	//
	// digits_w_grouping_separators =    digits_w_1_grouping_separators |
	//                                   digits_w_2_grouping_separators
	//
	// digits_w_1_grouping_separators =  regexp(\d{1,3}(,\d{3})+)
	//
	// digits_w_2_grouping_separators =  regexp(\d{1,2}((,\d{2})*(,\d{3})))

	// Integer part
	numberTokenizer = digitsRe + "+";

	// Grouping separators
	if ( primaryGroupingSize ) {
		if ( secondaryGroupingSize ) {
			aux = digitsRe + "{1," + secondaryGroupingSize + "}((" + groupingSeparatorRe +
				digitsRe + "{" + secondaryGroupingSize + "})*(" + groupingSeparatorRe +
				digitsRe + "{" + primaryGroupingSize + "}))";
		} else {
			aux = digitsRe + "{1," + primaryGroupingSize + "}(" + groupingSeparatorRe +
				digitsRe + "{" + primaryGroupingSize + "})+";
		}
		numberTokenizer = "(" + aux + "|" + numberTokenizer + ")";
	}

	// Fraction part? Only included if 1 or 2.
	// 1: Using significant digit format.
	// 2: Using integer and fractional format && it has a maximumFractionDigits.
	if ( !isNaN( minimumSignificantDigits * maximumSignificantDigits ) || /* 1 */
				maximumFractionDigits /* 2 */ ) {

		// 1: Handle trailing decimal separator, e.g., `"1." => `1``.
		aux = decimalSymbolRe + digitsRe + "+";
		numberTokenizer = numberTokenizer + "(" + aux + "|" + decimalSymbolRe /* 1 */ + ")?" +

			// Handle non-padded decimals, e.g., `".12"` => `0.12` by making the integer part
			// optional.
			"|(" + numberTokenizer + ")?" + aux;

		numberTokenizer = "(" + numberTokenizer + ")";
	}

	// 0: @invertedSymbolMap [Object] Inverted symbol map.
	// 1: @invertedNuDigitsMap [Object] Inverted digits map if numbering system is different than
	//    `latn`.
	// 2: @tokenizer [Object] Tokenizer map, used by parser to consume input.
	return [
		invertedSymbolMap,
		invertedNuDigitsMap,
		{
			infinity: new RegExp( "^" + regexpEscape( infinitySymbol ) ),
			nan:  new RegExp( "^" + regexpEscape( nanSymbol ) ),
			negativePrefix: new RegExp( "^" + regexpEscape( negativePrefix ) ),
			negativeSuffix: new RegExp( "^" + regexpEscape( negativeSuffix ) ),
			number: new RegExp( "^" + numberTokenizer ),
			prefix: new RegExp( "^" + regexpEscape( prefix ) ),
			suffix: new RegExp( "^" + regexpEscape( suffix ) )
		}
	];

};




/**
 * Pattern( style )
 *
 * @style [String] "decimal" (default) or "percent".
 *
 * @cldr [Cldr instance].
 */
var numberPattern = function( style, cldr ) {
	if ( style !== "decimal" && style !== "percent" ) {
		throw new Error( "Invalid style" );
	}

	return cldr.main([
		"numbers",
		style + "Formats-numberSystem-" + numberNumberingSystem( cldr ),
		"standard"
	]);
};




function validateDigits( properties ) {
	var minimumIntegerDigits = properties[ 2 ],
		minimumFractionDigits = properties[ 3 ],
		maximumFractionDigits = properties[ 4 ],
		minimumSignificantDigits = properties[ 5 ],
		maximumSignificantDigits = properties[ 6 ];

	// Validate significant digit format properties
	if ( !isNaN( minimumSignificantDigits * maximumSignificantDigits ) ) {
		validateParameterRange( minimumSignificantDigits, "minimumSignificantDigits", 1, 21 );
		validateParameterRange( maximumSignificantDigits, "maximumSignificantDigits",
			minimumSignificantDigits, 21 );

	} else if ( !isNaN( minimumSignificantDigits ) || !isNaN( maximumSignificantDigits ) ) {
		throw new Error( "Neither or both the minimum and maximum significant digits must be " +
			"present" );

	// Validate integer and fractional format
	} else {
		validateParameterRange( minimumIntegerDigits, "minimumIntegerDigits", 1, 21 );
		validateParameterRange( minimumFractionDigits, "minimumFractionDigits", 0, 20 );
		validateParameterRange( maximumFractionDigits, "maximumFractionDigits",
			minimumFractionDigits, 20 );
	}
}

/**
 * .numberFormatter( [options] )
 *
 * @options [Object]:
 * - style: [String] "decimal" (default) or "percent".
 * - see also number/format options.
 *
 * Return a function that formats a number according to the given options and default/instance
 * locale.
 */
Globalize.numberFormatter =
Globalize.prototype.numberFormatter = function( options ) {
	var args, cldr, fnArgs, pattern, properties, returnFn;

	validateParameterTypePlainObject( options, "options" );

	options = options || {};
	cldr = this.cldr;

	args = [ options ];

	validateDefaultLocale( cldr );

	cldr.on( "get", validateCldr );

	if ( options.raw ) {
		pattern = options.raw;
	} else {
		pattern = numberPattern( options.style || "decimal", cldr );
	}

	properties = numberFormatProperties( pattern, cldr, options );
	fnArgs = [ properties ];

	cldr.off( "get", validateCldr );

	validateDigits( properties );

	if ( options.compact ) {
		fnArgs.push( this.pluralGenerator() );
	}
	returnFn = numberFormatterFn.apply( null, fnArgs );
	runtimeBind( args, cldr, returnFn, fnArgs );

	return returnFn;
};

/**
 * .numberParser( [options] )
 *
 * @options [Object]:
 * - style: [String] "decimal" (default) or "percent".
 *
 * Return the number parser according to the default/instance locale.
 */
Globalize.numberParser =
Globalize.prototype.numberParser = function( options ) {
	var args, cldr, pattern, properties, returnFn;

	validateParameterTypePlainObject( options, "options" );

	options = options || {};
	cldr = this.cldr;

	args = [ options ];

	validateDefaultLocale( cldr );
	if ( options.compact ) {
		throw createErrorUnsupportedFeature({
			feature: "compact number parsing (not implemented)"
		});
	}

	cldr.on( "get", validateCldr );

	if ( options.raw ) {
		pattern = options.raw;
	} else {
		pattern = numberPattern( options.style || "decimal", cldr );
	}

	properties = numberParseProperties( pattern, cldr, options );

	cldr.off( "get", validateCldr );

	returnFn = numberParserFn( properties );

	runtimeBind( args, cldr, returnFn, [ properties ] );

	return returnFn;
};

/**
 * .formatNumber( value [, options] )
 *
 * @value [Number] number to be formatted.
 *
 * @options [Object]: see number/format-properties.
 *
 * Format a number according to the given options and default/instance locale.
 */
Globalize.formatNumber =
Globalize.prototype.formatNumber = function( value, options ) {
	validateParameterPresence( value, "value" );
	validateParameterTypeNumber( value, "value" );

	return this.numberFormatter( options )( value );
};

/**
 * .parseNumber( value [, options] )
 *
 * @value [String]
 *
 * @options [Object]: See numberParser().
 *
 * Return the parsed Number (including Infinity) or NaN when value is invalid.
 */
Globalize.parseNumber =
Globalize.prototype.parseNumber = function( value, options ) {
	validateParameterPresence( value, "value" );
	validateParameterTypeString( value, "value" );

	return this.numberParser( options )( value );
};

/**
 * Optimization to avoid duplicating some internal functions across modules.
 */
Globalize._createErrorUnsupportedFeature = createErrorUnsupportedFeature;
Globalize._numberNumberingSystem = numberNumberingSystem;
Globalize._numberNumberingSystemDigitsMap = numberNumberingSystemDigitsMap;
Globalize._numberPattern = numberPattern;
Globalize._numberSymbol = numberSymbol;
Globalize._looseMatching = looseMatching;
Globalize._removeLiteralQuotes = removeLiteralQuotes;
Globalize._stringPad = stringPad;
Globalize._validateParameterTypeNumber = validateParameterTypeNumber;
Globalize._validateParameterTypeString = validateParameterTypeString;

return Globalize;




}));

/*!
 * Globalize v1.4.2
 *
 * http://github.com/jquery/globalize
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2019-03-07T13:47Z
 */
(function( root, factory ) {

	// UMD returnExports
	if ( typeof define === "function" && define.amd ) {

		// AMD
		define([
			"cldr",
			"../globalize",
			"./number",
			"cldr/event",
			"cldr/supplemental"
		], factory );
	} else if ( typeof exports === "object" ) {

		// Node, CommonJS
		module.exports = factory( require( "cldrjs" ), require( "../globalize" ) );
	} else {

		// Global
		factory( root.Cldr, root.Globalize );
	}
}(this, function( Cldr, Globalize ) {

var alwaysArray = Globalize._alwaysArray,
	formatMessage = Globalize._formatMessage,
	numberNumberingSystem = Globalize._numberNumberingSystem,
	numberPattern = Globalize._numberPattern,
	runtimeBind = Globalize._runtimeBind,
	stringPad = Globalize._stringPad,
	validateCldr = Globalize._validateCldr,
	validateDefaultLocale = Globalize._validateDefaultLocale,
	validateParameterPresence = Globalize._validateParameterPresence,
	validateParameterType = Globalize._validateParameterType,
	validateParameterTypeNumber = Globalize._validateParameterTypeNumber,
	validateParameterTypePlainObject = Globalize._validateParameterTypePlainObject;


var validateParameterTypeCurrency = function( value, name ) {
	validateParameterType(
		value,
		name,
		value === undefined || typeof value === "string" && ( /^[A-Za-z]{3}$/ ).test( value ),
		"3-letter currency code string as defined by ISO 4217"
	);
};




/**
 * supplementalOverride( currency, pattern, cldr )
 *
 * Return pattern with fraction digits overriden by supplemental currency data.
 */
var currencySupplementalOverride = function( currency, pattern, cldr ) {
	var digits,
		fraction = "",
		fractionData = cldr.supplemental([ "currencyData/fractions", currency ]) ||
			cldr.supplemental( "currencyData/fractions/DEFAULT" );

	digits = +fractionData._digits;

	if ( digits ) {
		fraction = "." + stringPad( "0", digits ).slice( 0, -1 ) + fractionData._rounding;
	}

	return pattern.replace( /\.(#+|0*[0-9]|0+[0-9]?)/g, fraction );
};




var objectFilter = function( object, testRe ) {
	var key,
		copy = {};

	for ( key in object ) {
		if ( testRe.test( key ) ) {
			copy[ key ] = object[ key ];
		}
	}

	return copy;
};




var currencyUnitPatterns = function( cldr ) {
	return objectFilter( cldr.main([
		"numbers",
		"currencyFormats-numberSystem-" + numberNumberingSystem( cldr )
	]), /^unitPattern/ );
};




/**
 * codeProperties( currency, cldr )
 *
 * Return number pattern with the appropriate currency code in as literal.
 */
var currencyCodeProperties = function( currency, cldr ) {
	var pattern = numberPattern( "decimal", cldr );

	// The number of decimal places and the rounding for each currency is not locale-specific. Those
	// values overridden by Supplemental Currency Data.
	pattern = currencySupplementalOverride( currency, pattern, cldr );

	return {
		currency: currency,
		pattern: pattern,
		unitPatterns: currencyUnitPatterns( cldr )
	};
};




/**
 * nameFormat( formattedNumber, pluralForm, properties )
 *
 * Return the appropriate name form currency format.
 */
var currencyNameFormat = function( formattedNumber, pluralForm, properties ) {
	var displayName, unitPattern,
		displayNames = properties.displayNames || {},
		unitPatterns = properties.unitPatterns;

	displayName = displayNames[ "displayName-count-" + pluralForm ] ||
		displayNames[ "displayName-count-other" ] ||
		displayNames.displayName ||
		properties.currency;
	unitPattern = unitPatterns[ "unitPattern-count-" + pluralForm ] ||
		unitPatterns[ "unitPattern-count-other" ];

	return formatMessage( unitPattern, [ formattedNumber, displayName ]);
};




var currencyFormatterFn = function( numberFormatter, pluralGenerator, properties ) {
	var fn;

	// Return formatter when style is "code" or "name".
	if ( pluralGenerator && properties ) {
		fn = function currencyFormatter( value ) {
			validateParameterPresence( value, "value" );
			validateParameterTypeNumber( value, "value" );
			return currencyNameFormat(
				numberFormatter( value ),
				pluralGenerator( value ),
				properties
			);
		};

	// Return formatter when style is "symbol" or "accounting".
	} else {
		fn = function currencyFormatter( value ) {
			return numberFormatter( value );
		};
	}

	return fn;
};




/**
 * nameProperties( currency, cldr )
 *
 * Return number pattern with the appropriate currency code in as literal.
 */
var currencyNameProperties = function( currency, cldr ) {
	var properties = currencyCodeProperties( currency, cldr );

	properties.displayNames = objectFilter( cldr.main([
		"numbers/currencies",
		currency
	]), /^displayName/ );

	return properties;
};




/**
 * Unicode regular expression for: everything except math symbols, currency signs, dingbats, and
 * box-drawing characters.
 *
 * Generated by:
 *
 * regenerate()
 *   .addRange( 0x0, 0x10FFFF )
 *   .remove( require( "unicode-7.0.0/categories/S/symbols" ) ).toString();
 *
 * https://github.com/mathiasbynens/regenerate
 * https://github.com/mathiasbynens/unicode-7.0.0
 */
var regexpNotS = /[\0-#%-\*,-;\?-\]_a-\{\}\x7F-\xA1\xA7\xAA\xAB\xAD\xB2\xB3\xB5-\xB7\xB9-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0300-\u0374\u0376-\u0383\u0386-\u03F5\u03F7-\u0481\u0483-\u058C\u0590-\u0605\u0609\u060A\u060C\u060D\u0610-\u06DD\u06DF-\u06E8\u06EA-\u06FC\u06FF-\u07F5\u07F7-\u09F1\u09F4-\u09F9\u09FC-\u0AF0\u0AF2-\u0B6F\u0B71-\u0BF2\u0BFB-\u0C7E\u0C80-\u0D78\u0D7A-\u0E3E\u0E40-\u0F00\u0F04-\u0F12\u0F14\u0F18\u0F19\u0F20-\u0F33\u0F35\u0F37\u0F39-\u0FBD\u0FC6\u0FCD\u0FD0-\u0FD4\u0FD9-\u109D\u10A0-\u138F\u139A-\u17DA\u17DC-\u193F\u1941-\u19DD\u1A00-\u1B60\u1B6B-\u1B73\u1B7D-\u1FBC\u1FBE\u1FC2-\u1FCC\u1FD0-\u1FDC\u1FE0-\u1FEC\u1FF0-\u1FFC\u1FFF-\u2043\u2045-\u2051\u2053-\u2079\u207D-\u2089\u208D-\u209F\u20BE-\u20FF\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2150-\u218F\u2308-\u230B\u2329\u232A\u23FB-\u23FF\u2427-\u243F\u244B-\u249B\u24EA-\u24FF\u2768-\u2793\u27C5\u27C6\u27E6-\u27EF\u2983-\u2998\u29D8-\u29DB\u29FC\u29FD\u2B74\u2B75\u2B96\u2B97\u2BBA-\u2BBC\u2BC9\u2BD2-\u2CE4\u2CEB-\u2E7F\u2E9A\u2EF4-\u2EFF\u2FD6-\u2FEF\u2FFC-\u3003\u3005-\u3011\u3014-\u301F\u3021-\u3035\u3038-\u303D\u3040-\u309A\u309D-\u318F\u3192-\u3195\u31A0-\u31BF\u31E4-\u31FF\u321F-\u3229\u3248-\u324F\u3251-\u325F\u3280-\u3289\u32B1-\u32BF\u32FF\u3400-\u4DBF\u4E00-\uA48F\uA4C7-\uA6FF\uA717-\uA71F\uA722-\uA788\uA78B-\uA827\uA82C-\uA835\uA83A-\uAA76\uAA7A-\uAB5A\uAB5C-\uD7FF\uDC00-\uFB28\uFB2A-\uFBB1\uFBC2-\uFDFB\uFDFE-\uFE61\uFE63\uFE67\uFE68\uFE6A-\uFF03\uFF05-\uFF0A\uFF0C-\uFF1B\uFF1F-\uFF3D\uFF3F\uFF41-\uFF5B\uFF5D\uFF5F-\uFFDF\uFFE7\uFFEF-\uFFFB\uFFFE\uFFFF]|\uD800[\uDC00-\uDD36\uDD40-\uDD78\uDD8A\uDD8B\uDD8D-\uDD8F\uDD9C-\uDD9F\uDDA1-\uDDCF\uDDFD-\uDFFF]|[\uD801\uD803-\uD819\uD81B-\uD82E\uD830-\uD833\uD836-\uD83A\uD83F-\uDBFF][\uDC00-\uDFFF]|\uD802[\uDC00-\uDC76\uDC79-\uDEC7\uDEC9-\uDFFF]|\uD81A[\uDC00-\uDF3B\uDF40-\uDF44\uDF46-\uDFFF]|\uD82F[\uDC00-\uDC9B\uDC9D-\uDFFF]|\uD834[\uDCF6-\uDCFF\uDD27\uDD28\uDD65-\uDD69\uDD6D-\uDD82\uDD85-\uDD8B\uDDAA-\uDDAD\uDDDE-\uDDFF\uDE42-\uDE44\uDE46-\uDEFF\uDF57-\uDFFF]|\uD835[\uDC00-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFFF]|\uD83B[\uDC00-\uDEEF\uDEF2-\uDFFF]|\uD83C[\uDC2C-\uDC2F\uDC94-\uDC9F\uDCAF\uDCB0\uDCC0\uDCD0\uDCF6-\uDD0F\uDD2F\uDD6C-\uDD6F\uDD9B-\uDDE5\uDE03-\uDE0F\uDE3B-\uDE3F\uDE49-\uDE4F\uDE52-\uDEFF\uDF2D-\uDF2F\uDF7E\uDF7F\uDFCF-\uDFD3\uDFF8-\uDFFF]|\uD83D[\uDCFF\uDD4B-\uDD4F\uDD7A\uDDA4\uDE43\uDE44\uDED0-\uDEDF\uDEED-\uDEEF\uDEF4-\uDEFF\uDF74-\uDF7F\uDFD5-\uDFFF]|\uD83E[\uDC0C-\uDC0F\uDC48-\uDC4F\uDC5A-\uDC5F\uDC88-\uDC8F\uDCAE-\uDFFF]|[\uD800-\uDBFF]/;




/**
 * symbolProperties( currency, cldr )
 *
 * Return pattern replacing `¤` with the appropriate currency symbol literal.
 */
var currencySymbolProperties = function( currency, cldr, options ) {
	var currencySpacing, pattern, symbol,
		symbolEntries = [ "symbol" ],
		regexp = {
			"[:digit:]": /\d/,
			"[:^S:]": regexpNotS
		};

	// If options.symbolForm === "narrow" was passed, prepend it.
	if ( options.symbolForm === "narrow" ) {
		symbolEntries.unshift( "symbol-alt-narrow" );
	}

	symbolEntries.some(function( symbolEntry ) {
		return symbol = cldr.main([
			"numbers/currencies",
			currency,
			symbolEntry
		]);
	});

	currencySpacing = [ "beforeCurrency", "afterCurrency" ].map(function( position ) {
		return cldr.main([
			"numbers",
			"currencyFormats-numberSystem-" + numberNumberingSystem( cldr ),
			"currencySpacing",
			position
		]);
	});

	pattern = cldr.main([
		"numbers",
		"currencyFormats-numberSystem-" + numberNumberingSystem( cldr ),
		options.style === "accounting" ? "accounting" : "standard"
	]);

	pattern =

		// The number of decimal places and the rounding for each currency is not locale-specific.
		// Those values are overridden by Supplemental Currency Data.
		currencySupplementalOverride( currency, pattern, cldr )

		// Replace "¤" (\u00A4) with the appropriate symbol literal.
		.split( ";" ).map(function( pattern ) {

			return pattern.split( "\u00A4" ).map(function( part, i ) {
				var currencyMatch = regexp[ currencySpacing[ i ].currencyMatch ],
					surroundingMatch = regexp[ currencySpacing[ i ].surroundingMatch ],
					insertBetween = "";

				// For currencyMatch and surroundingMatch definitions, read [1].
				// When i === 0, beforeCurrency is being handled. Otherwise, afterCurrency.
				// 1: http://www.unicode.org/reports/tr35/tr35-numbers.html#Currencies
				currencyMatch = currencyMatch.test( symbol.charAt( i ? symbol.length - 1 : 0 ) );
				surroundingMatch = surroundingMatch.test(
					part.charAt( i ? 0 : part.length - 1 ).replace( /[#@,.]/g, "0" )
				);

				if ( currencyMatch && part && surroundingMatch ) {
					insertBetween = currencySpacing[ i ].insertBetween;
				}

				return ( i ? insertBetween : "" ) + part + ( i ? "" : insertBetween );
			}).join( "'" + symbol + "'" );
		}).join( ";" );

	return {
		pattern: pattern
	};
};




/**
 * objectOmit( object, keys )
 *
 * Return a copy of the object, filtered to omit the blacklisted key or array of keys.
 */
var objectOmit = function( object, keys ) {
	var key,
		copy = {};

	keys = alwaysArray( keys );

	for ( key in object ) {
		if ( keys.indexOf( key ) === -1 ) {
			copy[ key ] = object[ key ];
		}
	}

	return copy;
};




function validateRequiredCldr( path, value ) {
	validateCldr( path, value, {
		skip: [
			/numbers\/currencies\/[^/]+\/symbol-alt-/,
			/supplemental\/currencyData\/fractions\/[A-Za-z]{3}$/
		]
	});
}

/**
 * .currencyFormatter( currency [, options] )
 *
 * @currency [String] 3-letter currency code as defined by ISO 4217.
 *
 * @options [Object]:
 * - style: [String] "symbol" (default), "accounting", "code" or "name".
 * - see also number/format options.
 *
 * Return a function that formats a currency according to the given options and default/instance
 * locale.
 */
Globalize.currencyFormatter =
Globalize.prototype.currencyFormatter = function( currency, options ) {
	var args, cldr, numberFormatter, pluralGenerator, properties, returnFn, style;

	validateParameterPresence( currency, "currency" );
	validateParameterTypeCurrency( currency, "currency" );

	validateParameterTypePlainObject( options, "options" );

	cldr = this.cldr;
	options = options || {};

	args = [ currency, options ];
	style = options.style || "symbol";

	validateDefaultLocale( cldr );

	// Get properties given style ("symbol" default, "code" or "name").
	cldr.on( "get", validateRequiredCldr );
	properties = ({
		accounting: currencySymbolProperties,
		code: currencyCodeProperties,
		name: currencyNameProperties,
		symbol: currencySymbolProperties
	}[ style ] )( currency, cldr, options );
	cldr.off( "get", validateRequiredCldr );

	// options = options minus style, plus raw pattern.
	options = objectOmit( options, "style" );
	options.raw = properties.pattern;

	// Return formatter when style is "symbol" or "accounting".
	if ( style === "symbol" || style === "accounting" ) {
		numberFormatter = this.numberFormatter( options );

		returnFn = currencyFormatterFn( numberFormatter );

		runtimeBind( args, cldr, returnFn, [ numberFormatter ] );

	// Return formatter when style is "code" or "name".
	} else {
		numberFormatter = this.numberFormatter( options );
		pluralGenerator = this.pluralGenerator();

		returnFn = currencyFormatterFn( numberFormatter, pluralGenerator, properties );

		runtimeBind( args, cldr, returnFn, [ numberFormatter, pluralGenerator, properties ] );
	}

	return returnFn;
};

/**
 * .currencyParser( currency [, options] )
 *
 * @currency [String] 3-letter currency code as defined by ISO 4217.
 *
 * @options [Object] see currencyFormatter.
 *
 * Return the currency parser according to the given options and the default/instance locale.
 */
Globalize.currencyParser =
Globalize.prototype.currencyParser = function( /* currency, options */ ) {

	// TODO implement parser.

};

/**
 * .formatCurrency( value, currency [, options] )
 *
 * @value [Number] number to be formatted.
 *
 * @currency [String] 3-letter currency code as defined by ISO 4217.
 *
 * @options [Object] see currencyFormatter.
 *
 * Format a currency according to the given options and the default/instance locale.
 */
Globalize.formatCurrency =
Globalize.prototype.formatCurrency = function( value, currency, options ) {
	validateParameterPresence( value, "value" );
	validateParameterTypeNumber( value, "value" );

	return this.currencyFormatter( currency, options )( value );
};

/**
 * .parseCurrency( value, currency [, options] )
 *
 * @value [String]
 *
 * @currency [String] 3-letter currency code as defined by ISO 4217.
 *
 * @options [Object]: See currencyFormatter.
 *
 * Return the parsed currency or NaN when value is invalid.
 */
Globalize.parseCurrency =
Globalize.prototype.parseCurrency = function( /* value, currency, options */ ) {
};

return Globalize;




}));

/**
 * Globalize v1.4.2
 *
 * http://github.com/jquery/globalize
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2019-03-07T13:47Z
 */
/*!
 * Globalize v1.4.2 2019-03-07T13:47Z Released under the MIT license
 * http://git.io/TrdQbw
 */
(function( root, factory ) {

	// UMD returnExports
	if ( typeof define === "function" && define.amd ) {

		// AMD
		define([
			"cldr",
			"../globalize",
			"./number",
			"cldr/event",
			"cldr/supplemental"
		], factory );
	} else if ( typeof exports === "object" ) {

		// Node, CommonJS
		module.exports = factory( require( "cldrjs" ), require( "../globalize" ) );
	} else {

		// Extend global
		factory( root.Cldr, root.Globalize );
	}
}(this, function( Cldr, Globalize ) {

var createError = Globalize._createError,
	createErrorUnsupportedFeature = Globalize._createErrorUnsupportedFeature,
	formatMessage = Globalize._formatMessage,
	isPlainObject = Globalize._isPlainObject,
	looseMatching = Globalize._looseMatching,
	numberNumberingSystemDigitsMap = Globalize._numberNumberingSystemDigitsMap,
	numberSymbol = Globalize._numberSymbol,
	regexpEscape = Globalize._regexpEscape,
	removeLiteralQuotes = Globalize._removeLiteralQuotes,
	runtimeBind = Globalize._runtimeBind,
	stringPad = Globalize._stringPad,
	validate = Globalize._validate,
	validateCldr = Globalize._validateCldr,
	validateDefaultLocale = Globalize._validateDefaultLocale,
	validateParameterPresence = Globalize._validateParameterPresence,
	validateParameterType = Globalize._validateParameterType,
	validateParameterTypePlainObject = Globalize._validateParameterTypePlainObject,
	validateParameterTypeString = Globalize._validateParameterTypeString;


var validateParameterTypeDate = function( value, name ) {
	validateParameterType( value, name, value === undefined || value instanceof Date, "Date" );
};




var createErrorInvalidParameterValue = function( name, value ) {
	return createError( "E_INVALID_PAR_VALUE", "Invalid `{name}` value ({value}).", {
		name: name,
		value: value
	});
};




/**
 * Create a map between the skeleton fields and their positions, e.g.,
 * {
 *   G: 0
 *   y: 1
 *   ...
 * }
 */
var validateSkeletonFieldsPosMap = "GyYuUrQqMLlwWEecdDFghHKkmsSAzZOvVXx".split( "" ).reduce(function( memo, item, i ) {
	memo[ item ] = i;
	return memo;
}, {});




/**
 * validateSkeleton( skeleton )
 *
 * skeleton: Assume `j` has already been converted into a localized hour field.
 */
var validateSkeleton = function validateSkeleton( skeleton ) {
	var last,

		// Using easier to read variable.
		fieldsPosMap = validateSkeletonFieldsPosMap;

	// "The fields are from the Date Field Symbol Table in Date Format Patterns"
	// Ref: http://www.unicode.org/reports/tr35/tr35-dates.html#availableFormats_appendItems
	// I.e., check for invalid characters.
	skeleton.replace( /[^GyYuUrQqMLlwWEecdDFghHKkmsSAzZOvVXx]/, function( field ) {
		throw createError(
			"E_INVALID_OPTIONS", "Invalid field `{invalidField}` of skeleton `{value}`",
			{
				invalidField: field,
				type: "skeleton",
				value: skeleton
			}
		);
	});

	// "The canonical order is from top to bottom in that table; that is, yM not My".
	// http://www.unicode.org/reports/tr35/tr35-dates.html#availableFormats_appendItems
	// I.e., check for invalid order.
	skeleton.split( "" ).every(function( field ) {
		if ( fieldsPosMap[ field ] < last ) {
			throw createError(
				"E_INVALID_OPTIONS", "Invalid order `{invalidField}` of skeleton `{value}`",
				{
					invalidField: field,
					type: "skeleton",
					value: skeleton
				}
			);
		}
		last = fieldsPosMap[ field ];
		return true;
	});
};




/**
 * Returns a new object created by using `object`'s values as keys, and the keys as values.
 */
var objectInvert = function( object, fn ) {
	fn = fn || function( object, key, value ) {
		object[ value ] = key;
		return object;
	};
	return Object.keys( object ).reduce(function( newObject, key ) {
		return fn( newObject, key, object[ key ] );
	}, {});
};




// Invert key and values, e.g., {"e": "eEc"} ==> {"e": "e", "E": "e", "c": "e"}.
var dateExpandPatternSimilarFieldsMap = objectInvert({
	"e": "eEc",
	"L": "ML"
}, function( object, key, value ) {
	value.split( "" ).forEach(function( field ) {
		object[ field ] = key;
	});
	return object;
});




var dateExpandPatternNormalizePatternType = function( character ) {
	return dateExpandPatternSimilarFieldsMap[ character ] || character;
};




var datePatternRe = ( /([a-z])\1*|'([^']|'')+'|''|./ig );




var stringRepeat = function( str, count ) {
	var i, result = "";
	for ( i = 0; i < count; i++ ) {
		result = result + str;
	}
	return result;
};




function expandBestMatchFormat( skeletonWithoutFractionalSeconds, bestMatchFormat ) {
	var i, j, bestMatchFormatParts, matchedType, matchedLength, requestedType,
		requestedLength, requestedSkeletonParts,

		// Using an easier to read variable.
		normalizePatternType = dateExpandPatternNormalizePatternType;

	requestedSkeletonParts = skeletonWithoutFractionalSeconds.match( datePatternRe );
	bestMatchFormatParts = bestMatchFormat.match( datePatternRe );

	for ( i = 0; i < bestMatchFormatParts.length; i++ ) {
		matchedType = bestMatchFormatParts[i].charAt( 0 );
		matchedLength = bestMatchFormatParts[i].length;
		for ( j = 0; j < requestedSkeletonParts.length; j++ ) {
			requestedType = requestedSkeletonParts[j].charAt( 0 );
			requestedLength = requestedSkeletonParts[j].length;
			if ( normalizePatternType( matchedType ) === normalizePatternType( requestedType ) &&
				matchedLength < requestedLength
			) {
				bestMatchFormatParts[i] = stringRepeat( matchedType, requestedLength );
			}
		}
	}

	return bestMatchFormatParts.join( "" );
}

// See: http://www.unicode.org/reports/tr35/tr35-dates.html#Matching_Skeletons
var dateExpandPatternAugmentFormat = function( requestedSkeleton, bestMatchFormat, decimalSeparator ) {
	var countOfFractionalSeconds, fractionalSecondMatch, lastSecondIdx,
		skeletonWithoutFractionalSeconds;

	fractionalSecondMatch = requestedSkeleton.match( /S/g );
	countOfFractionalSeconds = fractionalSecondMatch ? fractionalSecondMatch.length : 0;
	skeletonWithoutFractionalSeconds = requestedSkeleton.replace( /S/g, "" );

	bestMatchFormat = expandBestMatchFormat( skeletonWithoutFractionalSeconds, bestMatchFormat );

	lastSecondIdx = bestMatchFormat.lastIndexOf( "s" );
	if ( lastSecondIdx !== -1 && countOfFractionalSeconds !== 0 ) {
		bestMatchFormat =
			bestMatchFormat.slice( 0, lastSecondIdx + 1 ) +
			decimalSeparator +
			stringRepeat( "S", countOfFractionalSeconds ) +
			bestMatchFormat.slice( lastSecondIdx + 1 );
	}
	return bestMatchFormat;
};




var dateExpandPatternCompareFormats = function( formatA, formatB ) {
	var a, b, distance, lenA, lenB, typeA, typeB, i, j,

		// Using easier to read variables.
		normalizePatternType = dateExpandPatternNormalizePatternType;

	if ( formatA === formatB ) {
		return 0;
	}

	formatA = formatA.match( datePatternRe );
	formatB = formatB.match( datePatternRe );

	if ( formatA.length !== formatB.length ) {
		return -1;
	}

	distance = 1;
	for ( i = 0; i < formatA.length; i++ ) {
		a = formatA[ i ].charAt( 0 );
		typeA = normalizePatternType( a );
		typeB = null;
		for ( j = 0; j < formatB.length; j++ ) {
			b = formatB[ j ].charAt( 0 );
			typeB = normalizePatternType( b );
			if ( typeA === typeB ) {
				break;
			} else {
				typeB = null;
			}
		}
		if ( typeB === null ) {
			return -1;
		}
		lenA = formatA[ i ].length;
		lenB = formatB[ j ].length;
		distance = distance + Math.abs( lenA - lenB );

		// Most symbols have a small distance from each other, e.g., M ≅ L; E ≅ c; a ≅ b ≅ B;
		// H ≅ k ≅ h ≅ K; ...
		if ( a !== b ) {
			distance += 1;
		}

		// Numeric (l<3) and text fields (l>=3) are given a larger distance from each other.
		if ( ( lenA < 3 && lenB >= 3 ) || ( lenA >= 3 && lenB < 3 ) ) {
			distance += 20;
		}
	}
	return distance;
};




var dateExpandPatternGetBestMatchPattern = function( cldr, askedSkeleton ) {
	var availableFormats, decimalSeparator, pattern, ratedFormats, skeleton,
		path = "dates/calendars/gregorian/dateTimeFormats/availableFormats",

		// Using easier to read variables.
		augmentFormat = dateExpandPatternAugmentFormat,
		compareFormats = dateExpandPatternCompareFormats;

	pattern = cldr.main([ path, askedSkeleton ]);

	if ( askedSkeleton && !pattern ) {
		availableFormats = cldr.main([ path ]);
		ratedFormats = [];

		for ( skeleton in availableFormats ) {
			ratedFormats.push({
				skeleton: skeleton,
				pattern: availableFormats[ skeleton ],
				rate: compareFormats( askedSkeleton, skeleton )
			});
		}

		ratedFormats = ratedFormats
			.filter( function( format ) {
				return format.rate > -1;
			} )
			.sort( function( formatA, formatB ) {
				return formatA.rate - formatB.rate;
			});

		if ( ratedFormats.length ) {
			decimalSeparator = numberSymbol( "decimal", cldr );
			pattern = augmentFormat( askedSkeleton, ratedFormats[0].pattern, decimalSeparator );
		}
	}

	return pattern;
};




/**
 * expandPattern( options, cldr )
 *
 * @options [Object] if String, it's considered a skeleton. Object accepts:
 * - skeleton: [String] lookup availableFormat;
 * - date: [String] ( "full" | "long" | "medium" | "short" );
 * - time: [String] ( "full" | "long" | "medium" | "short" );
 * - datetime: [String] ( "full" | "long" | "medium" | "short" );
 * - raw: [String] For more info see datetime/format.js.
 *
 * @cldr [Cldr instance].
 *
 * Return the corresponding pattern.
 * Eg for "en":
 * - "GyMMMd" returns "MMM d, y G";
 * - { skeleton: "GyMMMd" } returns "MMM d, y G";
 * - { date: "full" } returns "EEEE, MMMM d, y";
 * - { time: "full" } returns "h:mm:ss a zzzz";
 * - { datetime: "full" } returns "EEEE, MMMM d, y 'at' h:mm:ss a zzzz";
 * - { raw: "dd/mm" } returns "dd/mm";
 */
var dateExpandPattern = function( options, cldr ) {
	var dateSkeleton, result, skeleton, timeSkeleton, type,

		// Using easier to read variables.
		getBestMatchPattern = dateExpandPatternGetBestMatchPattern;

	function combineDateTime( type, datePattern, timePattern ) {
		return formatMessage(
			cldr.main([
				"dates/calendars/gregorian/dateTimeFormats",
				type
			]),
			[ timePattern, datePattern ]
		);
	}

	switch ( true ) {
		case "skeleton" in options:
			skeleton = options.skeleton;

			// Preferred hour (j).
			skeleton = skeleton.replace( /j/g, function() {
				return cldr.supplemental.timeData.preferred();
			});

			validateSkeleton( skeleton );

			// Try direct map (note that getBestMatchPattern handles it).
			// ... or, try to "best match" the whole skeleton.
			result = getBestMatchPattern(
				cldr,
				skeleton
			);
			if ( result ) {
				break;
			}

			// ... or, try to "best match" the date and time parts individually.
			timeSkeleton = skeleton.split( /[^hHKkmsSAzZOvVXx]/ ).slice( -1 )[ 0 ];
			dateSkeleton = skeleton.split( /[^GyYuUrQqMLlwWdDFgEec]/ )[ 0 ];
			dateSkeleton = getBestMatchPattern(
				cldr,
				dateSkeleton
			);
			timeSkeleton = getBestMatchPattern(
				cldr,
				timeSkeleton
			);

			if ( /(MMMM|LLLL).*[Ec]/.test( dateSkeleton ) ) {
				type = "full";
			} else if ( /MMMM|LLLL/.test( dateSkeleton ) ) {
				type = "long";
			} else if ( /MMM|LLL/.test( dateSkeleton ) ) {
				type = "medium";
			} else {
				type = "short";
			}

			if ( dateSkeleton && timeSkeleton ) {
				result = combineDateTime( type, dateSkeleton, timeSkeleton );
			} else {
				result = dateSkeleton || timeSkeleton;
			}

			break;

		case "date" in options:
		case "time" in options:
			result = cldr.main([
				"dates/calendars/gregorian",
				"date" in options ? "dateFormats" : "timeFormats",
				( options.date || options.time )
			]);
			break;

		case "datetime" in options:
			result = combineDateTime( options.datetime,
				cldr.main([ "dates/calendars/gregorian/dateFormats", options.datetime ]),
				cldr.main([ "dates/calendars/gregorian/timeFormats", options.datetime ])
			);
			break;

		case "raw" in options:
			result = options.raw;
			break;

		default:
			throw createErrorInvalidParameterValue({
				name: "options",
				value: options
			});
	}

	return result;
};




var dateWeekDays = [ "sun", "mon", "tue", "wed", "thu", "fri", "sat" ];




/**
 * firstDayOfWeek
 */
var dateFirstDayOfWeek = function( cldr ) {
	return dateWeekDays.indexOf( cldr.supplemental.weekData.firstDay() );
};




/**
 * getTimeZoneName( length, type )
 */
var dateGetTimeZoneName = function( length, type, timeZone, cldr ) {
	var metaZone, result;

	if ( !timeZone ) {
		return;
	}

	result = cldr.main([
		"dates/timeZoneNames/zone",
		timeZone,
		length < 4 ? "short" : "long",
		type
	]);

	if ( result ) {
		return result;
	}

	// The latest metazone data of the metazone array.
	// TODO expand to support the historic metazones based on the given date.
	metaZone = cldr.supplemental([
		"metaZones/metazoneInfo/timezone", timeZone, 0,
		"usesMetazone/_mzone"
	]);

	return cldr.main([
		"dates/timeZoneNames/metazone",
		metaZone,
		length < 4 ? "short" : "long",
		type
	]);
};




/**
 * timezoneHourFormatShortH( hourFormat )
 *
 * @hourFormat [String]
 *
 * Unofficial deduction of the short hourFormat given time zone `hourFormat` element.
 * Official spec is pending resolution: http://unicode.org/cldr/trac/ticket/8293
 *
 * Example:
 * - "+HH.mm;-HH.mm" => "+H;-H"
 * - "+HH:mm;-HH:mm" => "+H;-H"
 * - "+HH:mm;−HH:mm" => "+H;−H" (Note MINUS SIGN \u2212)
 * - "+HHmm;-HHmm" => "+H:-H"
 */
var dateTimezoneHourFormatH = function( hourFormat ) {
	return hourFormat
		.split( ";" )
		.map(function( format ) {
			return format.slice( 0, format.indexOf( "H" ) + 1 );
		})
		.join( ";" );
};




/**
 * timezoneHourFormatLongHm( hourFormat )
 *
 * @hourFormat [String]
 *
 * Unofficial deduction of the short hourFormat given time zone `hourFormat` element.
 * Official spec is pending resolution: http://unicode.org/cldr/trac/ticket/8293
 *
 * Example (hFormat === "H"): (used for short Hm)
 * - "+HH.mm;-HH.mm" => "+H.mm;-H.mm"
 * - "+HH:mm;-HH:mm" => "+H:mm;-H:mm"
 * - "+HH:mm;−HH:mm" => "+H:mm;−H:mm" (Note MINUS SIGN \u2212)
 * - "+HHmm;-HHmm" => "+Hmm:-Hmm"
 *
 * Example (hFormat === "HH": (used for long Hm)
 * - "+HH.mm;-HH.mm" => "+HH.mm;-HH.mm"
 * - "+HH:mm;-HH:mm" => "+HH:mm;-HH:mm"
 * - "+H:mm;-H:mm"   => "+HH:mm;-HH:mm"
 * - "+HH:mm;−HH:mm" => "+HH:mm;−HH:mm" (Note MINUS SIGN \u2212)
 * - "+HHmm;-HHmm" => "+HHmm:-HHmm"
 */
var dateTimezoneHourFormatHm = function( hourFormat, hFormat ) {
	return hourFormat
		.split( ";" )
		.map(function( format ) {
			var parts = format.split( /H+/ );
			parts.splice( 1, 0, hFormat );
			return parts.join( "" );
		})
		.join( ";" );
};




var runtimeCacheDataBind = function( key, data ) {
	var fn = function() {
		return data;
	};
	fn.dataCacheKey = key;
	return fn;
};




/**
 * properties( pattern, cldr )
 *
 * @pattern [String] raw pattern.
 * ref: http://www.unicode.org/reports/tr35/tr35-dates.html#Date_Format_Patterns
 *
 * @cldr [Cldr instance].
 *
 * Return the properties given the pattern and cldr.
 *
 * TODO Support other calendar types.
 */
var dateFormatProperties = function( pattern, cldr, timeZone ) {
	var properties = {
			numberFormatters: {},
			pattern: pattern,
			timeSeparator: numberSymbol( "timeSeparator", cldr )
		},
		widths = [ "abbreviated", "wide", "narrow" ];

	function setNumberFormatterPattern( pad ) {
		properties.numberFormatters[ pad ] = stringPad( "", pad );
	}

	if ( timeZone ) {
		properties.timeZoneData = runtimeCacheDataBind( "iana/" + timeZone, {
			offsets: cldr.get([ "globalize-iana/zoneData", timeZone, "offsets" ]),
			untils: cldr.get([ "globalize-iana/zoneData", timeZone, "untils" ]),
			isdsts: cldr.get([ "globalize-iana/zoneData", timeZone, "isdsts" ])
		});
	}

	pattern.replace( datePatternRe, function( current ) {
		var aux, chr, daylightTzName, formatNumber, genericTzName, length, standardTzName;

		chr = current.charAt( 0 );
		length = current.length;

		if ( chr === "j" ) {

			// Locale preferred hHKk.
			// http://www.unicode.org/reports/tr35/tr35-dates.html#Time_Data
			properties.preferredTime = chr = cldr.supplemental.timeData.preferred();
		}

		// ZZZZ: same as "OOOO".
		if ( chr === "Z" && length === 4 ) {
			chr = "O";
			length = 4;
		}

		// z...zzz: "{shortRegion}", eg. "PST" or "PDT".
		// zzzz: "{regionName} {Standard Time}" or "{regionName} {Daylight Time}",
		//       e.g., "Pacific Standard Time" or "Pacific Daylight Time".
		// http://unicode.org/reports/tr35/tr35-dates.html#Date_Format_Patterns
		if ( chr === "z" ) {
			standardTzName = dateGetTimeZoneName( length, "standard", timeZone, cldr );
			daylightTzName = dateGetTimeZoneName( length, "daylight", timeZone, cldr );
			if ( standardTzName ) {
				properties.standardTzName = standardTzName;
			}
			if ( daylightTzName ) {
				properties.daylightTzName = daylightTzName;
			}

			// Fall through the "O" format in case one name is missing.
			if ( !standardTzName || !daylightTzName ) {
				chr = "O";
				if ( length < 4 ) {
					length = 1;
				}
			}
		}

		// v...vvv: "{shortRegion}", eg. "PT".
		// vvvv: "{regionName} {Time}" or "{regionName} {Time}",
		// e.g., "Pacific Time"
		// http://unicode.org/reports/tr35/tr35-dates.html#Date_Format_Patterns
		if ( chr === "v" ) {
			genericTzName = dateGetTimeZoneName( length, "generic", timeZone, cldr );

			// Fall back to "V" format.
			if ( !genericTzName ) {
				chr = "V";
				length = 4;
			}
		}

		switch ( chr ) {

			// Era
			case "G":
				properties.eras = cldr.main([
					"dates/calendars/gregorian/eras",
					length <= 3 ? "eraAbbr" : ( length === 4 ? "eraNames" : "eraNarrow" )
				]);
				break;

			// Year
			case "y":

				// Plain year.
				formatNumber = true;
				break;

			case "Y":

				// Year in "Week of Year"
				properties.firstDay = dateFirstDayOfWeek( cldr );
				properties.minDays = cldr.supplemental.weekData.minDays();
				formatNumber = true;
				break;

			case "u": // Extended year. Need to be implemented.
			case "U": // Cyclic year name. Need to be implemented.
				throw createErrorUnsupportedFeature({
					feature: "year pattern `" + chr + "`"
				});

			// Quarter
			case "Q":
			case "q":
				if ( length > 2 ) {
					if ( !properties.quarters ) {
						properties.quarters = {};
					}
					if ( !properties.quarters[ chr ] ) {
						properties.quarters[ chr ] = {};
					}
					properties.quarters[ chr ][ length ] = cldr.main([
						"dates/calendars/gregorian/quarters",
						chr === "Q" ? "format" : "stand-alone",
						widths[ length - 3 ]
					]);
				} else {
					formatNumber = true;
				}
				break;

			// Month
			case "M":
			case "L":
				if ( length > 2 ) {
					if ( !properties.months ) {
						properties.months = {};
					}
					if ( !properties.months[ chr ] ) {
						properties.months[ chr ] = {};
					}
					properties.months[ chr ][ length ] = cldr.main([
						"dates/calendars/gregorian/months",
						chr === "M" ? "format" : "stand-alone",
						widths[ length - 3 ]
					]);
				} else {
					formatNumber = true;
				}
				break;

			// Week - Week of Year (w) or Week of Month (W).
			case "w":
			case "W":
				properties.firstDay = dateFirstDayOfWeek( cldr );
				properties.minDays = cldr.supplemental.weekData.minDays();
				formatNumber = true;
				break;

			// Day
			case "d":
			case "D":
			case "F":
				formatNumber = true;
				break;

			case "g":

				// Modified Julian day. Need to be implemented.
				throw createErrorUnsupportedFeature({
					feature: "Julian day pattern `g`"
				});

			// Week day
			case "e":
			case "c":
				if ( length <= 2 ) {
					properties.firstDay = dateFirstDayOfWeek( cldr );
					formatNumber = true;
					break;
				}

			/* falls through */
			case "E":
				if ( !properties.days ) {
					properties.days = {};
				}
				if ( !properties.days[ chr ] ) {
					properties.days[ chr ] = {};
				}
				if ( length === 6 ) {

					// If short day names are not explicitly specified, abbreviated day names are
					// used instead.
					// http://www.unicode.org/reports/tr35/tr35-dates.html#months_days_quarters_eras
					// http://unicode.org/cldr/trac/ticket/6790
					properties.days[ chr ][ length ] = cldr.main([
							"dates/calendars/gregorian/days",
							chr === "c" ? "stand-alone" : "format",
							"short"
						]) || cldr.main([
							"dates/calendars/gregorian/days",
							chr === "c" ? "stand-alone" : "format",
							"abbreviated"
						]);
				} else {
					properties.days[ chr ][ length ] = cldr.main([
						"dates/calendars/gregorian/days",
						chr === "c" ? "stand-alone" : "format",
						widths[ length < 3 ? 0 : length - 3 ]
					]);
				}
				break;

			// Period (AM or PM)
			case "a":
				properties.dayPeriods = {
					am: cldr.main(
						"dates/calendars/gregorian/dayPeriods/format/wide/am"
					),
					pm: cldr.main(
						"dates/calendars/gregorian/dayPeriods/format/wide/pm"
					)
				};
				break;

			// Hour
			case "h": // 1-12
			case "H": // 0-23
			case "K": // 0-11
			case "k": // 1-24

			// Minute
			case "m":

			// Second
			case "s":
			case "S":
			case "A":
				formatNumber = true;
				break;

			// Zone
			case "v":
				if ( length !== 1 && length !== 4 ) {
					throw createErrorUnsupportedFeature({
						feature: "timezone pattern `" + pattern + "`"
					});
				}
				properties.genericTzName = genericTzName;
				break;

			case "V":

				if ( length === 1 ) {
					throw createErrorUnsupportedFeature({
						feature: "timezone pattern `" + pattern + "`"
					});
				}

				if ( timeZone ) {
					if ( length === 2 ) {
						properties.timeZoneName = timeZone;
						break;
					}

					var timeZoneName,
						exemplarCity = cldr.main([
							"dates/timeZoneNames/zone", timeZone, "exemplarCity"
						]);

					if ( length === 3 ) {
						if ( !exemplarCity ) {
							exemplarCity = cldr.main([
								"dates/timeZoneNames/zone/Etc/Unknown/exemplarCity"
							]);
						}
						timeZoneName = exemplarCity;
					}

					if ( exemplarCity && length === 4 ) {
						timeZoneName = formatMessage(
							cldr.main(
								"dates/timeZoneNames/regionFormat"
							),
							[ exemplarCity ]
						);
					}

					if ( timeZoneName ) {
						properties.timeZoneName = timeZoneName;
						break;
					}
				}

				if ( current === "v" ) {
					length = 1;
				}

			/* falls through */
			case "O":

				// O: "{gmtFormat}+H;{gmtFormat}-H" or "{gmtZeroFormat}", eg. "GMT-8" or "GMT".
				// OOOO: "{gmtFormat}{hourFormat}" or "{gmtZeroFormat}", eg. "GMT-08:00" or "GMT".
				properties.gmtFormat = cldr.main( "dates/timeZoneNames/gmtFormat" );
				properties.gmtZeroFormat = cldr.main( "dates/timeZoneNames/gmtZeroFormat" );

				// Unofficial deduction of the hourFormat variations.
				// Official spec is pending resolution: http://unicode.org/cldr/trac/ticket/8293
				aux = cldr.main( "dates/timeZoneNames/hourFormat" );
				properties.hourFormat = length < 4 ?
					[ dateTimezoneHourFormatH( aux ), dateTimezoneHourFormatHm( aux, "H" ) ] :
					dateTimezoneHourFormatHm( aux, "HH" );

			/* falls through */
			case "Z":
			case "X":
			case "x":
				setNumberFormatterPattern( 1 );
				setNumberFormatterPattern( 2 );
				break;
		}

		if ( formatNumber ) {
			setNumberFormatterPattern( length );
		}
	});

	return properties;
};




var dateFormatterFn = function( dateToPartsFormatter ) {
	return function dateFormatter( value ) {
		return dateToPartsFormatter( value ).map( function( part ) {
			return part.value;
		}).join( "" );
	};
};




/**
 * parseProperties( cldr )
 *
 * @cldr [Cldr instance].
 *
 * @timeZone [String] FIXME.
 *
 * Return parser properties.
 */
var dateParseProperties = function( cldr, timeZone ) {
	var properties = {
		preferredTimeData: cldr.supplemental.timeData.preferred()
	};

	if ( timeZone ) {
		properties.timeZoneData = runtimeCacheDataBind( "iana/" + timeZone, {
			offsets: cldr.get([ "globalize-iana/zoneData", timeZone, "offsets" ]),
			untils: cldr.get([ "globalize-iana/zoneData", timeZone, "untils" ]),
			isdsts: cldr.get([ "globalize-iana/zoneData", timeZone, "isdsts" ])
		});
	}

	return properties;
};


var ZonedDateTime = (function() {
function definePrivateProperty(object, property, value) {
  Object.defineProperty(object, property, {
    value: value
  });
}

function getUntilsIndex(original, untils) {
  var index = 0;
  var originalTime = original.getTime();

  // TODO Should we do binary search for improved performance?
  while (index < untils.length - 1 && originalTime >= untils[index]) {
    index++;
  }
  return index;
}

function setWrap(fn) {
  var offset1 = this.getTimezoneOffset();
  var ret = fn();
  this.original.setTime(new Date(this.getTime()));
  var offset2 = this.getTimezoneOffset();
  if (offset2 - offset1) {
    this.original.setMinutes(this.original.getMinutes() + offset2 - offset1);
  }
  return ret;
}

var ZonedDateTime = function(date, timeZoneData) {
  definePrivateProperty(this, "original", new Date(date.getTime()));
  definePrivateProperty(this, "local", new Date(date.getTime()));
  definePrivateProperty(this, "timeZoneData", timeZoneData);
  definePrivateProperty(this, "setWrap", setWrap);
  if (!(timeZoneData.untils && timeZoneData.offsets && timeZoneData.isdsts)) {
    throw new Error("Invalid IANA data");
  }
  this.setTime(this.local.getTime() - this.getTimezoneOffset() * 60 * 1000);
};

ZonedDateTime.prototype.clone = function() {
  return new ZonedDateTime(this.original, this.timeZoneData);
};

// Date field getters.
["getFullYear", "getMonth", "getDate", "getDay", "getHours", "getMinutes",
"getSeconds", "getMilliseconds"].forEach(function(method) {
  // Corresponding UTC method, e.g., "getUTCFullYear" if method === "getFullYear".
  var utcMethod = "getUTC" + method.substr(3);
  ZonedDateTime.prototype[method] = function() {
    return this.local[utcMethod]();
  };
});

// Note: Define .valueOf = .getTime for arithmetic operations like date1 - date2.
ZonedDateTime.prototype.valueOf =
ZonedDateTime.prototype.getTime = function() {
  return this.local.getTime() + this.getTimezoneOffset() * 60 * 1000;
};

ZonedDateTime.prototype.getTimezoneOffset = function() {
  var index = getUntilsIndex(this.original, this.timeZoneData.untils);
  return this.timeZoneData.offsets[index];
};

// Date field setters.
["setFullYear", "setMonth", "setDate", "setHours", "setMinutes", "setSeconds", "setMilliseconds"].forEach(function(method) {
  // Corresponding UTC method, e.g., "setUTCFullYear" if method === "setFullYear".
  var utcMethod = "setUTC" + method.substr(3);
  ZonedDateTime.prototype[method] = function(value) {
    var local = this.local;
    // Note setWrap is needed for seconds and milliseconds just because
    // abs(value) could be >= a minute.
    return this.setWrap(function() {
      return local[utcMethod](value);
    });
  };
});

ZonedDateTime.prototype.setTime = function(time) {
  return this.local.setTime(time);
};

ZonedDateTime.prototype.isDST = function() {
  var index = getUntilsIndex(this.original, this.timeZoneData.untils);
  return Boolean(this.timeZoneData.isdsts[index]);
};

ZonedDateTime.prototype.inspect = function() {
  var index = getUntilsIndex(this.original, this.timeZoneData.untils);
  var abbrs = this.timeZoneData.abbrs;
  return this.local.toISOString().replace(/Z$/, "") + " " +
    (abbrs && abbrs[index] + " " || (this.getTimezoneOffset() * -1) + " ") +
    (this.isDST() ? "(daylight savings)" : "");
};

ZonedDateTime.prototype.toDate = function() {
  return new Date(this.getTime());
};

// Type cast getters.
["toISOString", "toJSON", "toUTCString"].forEach(function(method) {
  ZonedDateTime.prototype[method] = function() {
    return this.toDate()[method]();
  };
});

return ZonedDateTime;
}());


/**
 * isLeapYear( year )
 *
 * @year [Number]
 *
 * Returns an indication whether the specified year is a leap year.
 */
var dateIsLeapYear = function( year ) {
	return new Date( year, 1, 29 ).getMonth() === 1;
};




/**
 * lastDayOfMonth( date )
 *
 * @date [Date]
 *
 * Return the last day of the given date's month
 */
var dateLastDayOfMonth = function( date ) {
	return new Date( date.getFullYear(), date.getMonth() + 1, 0 ).getDate();
};




/**
 * startOf changes the input to the beginning of the given unit.
 *
 * For example, starting at the start of a day, resets hours, minutes
 * seconds and milliseconds to 0. Starting at the month does the same, but
 * also sets the date to 1.
 *
 * Returns the modified date
 */
var dateStartOf = function( date, unit ) {
	date = date instanceof ZonedDateTime ? date.clone() : new Date( date.getTime() );
	switch ( unit ) {
		case "year":
			date.setMonth( 0 );
		/* falls through */
		case "month":
			date.setDate( 1 );
		/* falls through */
		case "day":
			date.setHours( 0 );
		/* falls through */
		case "hour":
			date.setMinutes( 0 );
		/* falls through */
		case "minute":
			date.setSeconds( 0 );
		/* falls through */
		case "second":
			date.setMilliseconds( 0 );
	}
	return date;
};




/**
 * Differently from native date.setDate(), this function returns a date whose
 * day remains inside the month boundaries. For example:
 *
 * setDate( FebDate, 31 ): a "Feb 28" date.
 * setDate( SepDate, 31 ): a "Sep 30" date.
 */
var dateSetDate = function( date, day ) {
	var lastDay = new Date( date.getFullYear(), date.getMonth() + 1, 0 ).getDate();

	date.setDate( day < 1 ? 1 : day < lastDay ? day : lastDay );
};




/**
 * Differently from native date.setMonth(), this function adjusts date if
 * needed, so final month is always the one set.
 *
 * setMonth( Jan31Date, 1 ): a "Feb 28" date.
 * setDate( Jan31Date, 8 ): a "Sep 30" date.
 */
var dateSetMonth = function( date, month ) {
	var originalDate = date.getDate();

	date.setDate( 1 );
	date.setMonth( month );
	dateSetDate( date, originalDate );
};




var outOfRange = function( value, low, high ) {
	return value < low || value > high;
};




/**
 * parse( value, tokens, properties )
 *
 * @value [String] string date.
 *
 * @tokens [Object] tokens returned by date/tokenizer.
 *
 * @properties [Object] output returned by date/tokenizer-properties.
 *
 * ref: http://www.unicode.org/reports/tr35/tr35-dates.html#Date_Format_Patterns
 */
var dateParse = function( value, tokens, properties ) {
	var amPm, day, daysOfYear, month, era, hour, hour12, timezoneOffset, valid,
		YEAR = 0,
		MONTH = 1,
		DAY = 2,
		HOUR = 3,
		MINUTE = 4,
		SECOND = 5,
		MILLISECONDS = 6,
		date = new Date(),
		truncateAt = [],
		units = [ "year", "month", "day", "hour", "minute", "second", "milliseconds" ];

	// Create globalize date with given timezone data.
	if ( properties.timeZoneData ) {
		date = new ZonedDateTime( date, properties.timeZoneData() );
	}

	if ( !tokens.length ) {
		return null;
	}

	valid = tokens.every(function( token ) {
		var century, chr, value, length;

		if ( token.type === "literal" ) {

			// continue
			return true;
		}

		chr = token.type.charAt( 0 );
		length = token.type.length;

		if ( chr === "j" ) {

			// Locale preferred hHKk.
			// http://www.unicode.org/reports/tr35/tr35-dates.html#Time_Data
			chr = properties.preferredTimeData;
		}

		switch ( chr ) {

			// Era
			case "G":
				truncateAt.push( YEAR );
				era = +token.value;
				break;

			// Year
			case "y":
				value = token.value;
				if ( length === 2 ) {
					if ( outOfRange( value, 0, 99 ) ) {
						return false;
					}

					// mimic dojo/date/locale: choose century to apply, according to a sliding
					// window of 80 years before and 20 years after present year.
					century = Math.floor( date.getFullYear() / 100 ) * 100;
					value += century;
					if ( value > date.getFullYear() + 20 ) {
						value -= 100;
					}
				}
				date.setFullYear( value );
				truncateAt.push( YEAR );
				break;

			case "Y": // Year in "Week of Year"
				throw createErrorUnsupportedFeature({
					feature: "year pattern `" + chr + "`"
				});

			// Quarter (skip)
			case "Q":
			case "q":
				break;

			// Month
			case "M":
			case "L":
				if ( length <= 2 ) {
					value = token.value;
				} else {
					value = +token.value;
				}
				if ( outOfRange( value, 1, 12 ) ) {
					return false;
				}

				// Setting the month later so that we have the correct year and can determine
				// the correct last day of February in case of leap year.
				month = value;
				truncateAt.push( MONTH );
				break;

			// Week (skip)
			case "w": // Week of Year.
			case "W": // Week of Month.
				break;

			// Day
			case "d":
				day = token.value;
				truncateAt.push( DAY );
				break;

			case "D":
				daysOfYear = token.value;
				truncateAt.push( DAY );
				break;

			case "F":

				// Day of Week in month. eg. 2nd Wed in July.
				// Skip
				break;

			// Week day
			case "e":
			case "c":
			case "E":

				// Skip.
				// value = arrayIndexOf( dateWeekDays, token.value );
				break;

			// Period (AM or PM)
			case "a":
				amPm = token.value;
				break;

			// Hour
			case "h": // 1-12
				value = token.value;
				if ( outOfRange( value, 1, 12 ) ) {
					return false;
				}
				hour = hour12 = true;
				date.setHours( value === 12 ? 0 : value );
				truncateAt.push( HOUR );
				break;

			case "K": // 0-11
				value = token.value;
				if ( outOfRange( value, 0, 11 ) ) {
					return false;
				}
				hour = hour12 = true;
				date.setHours( value );
				truncateAt.push( HOUR );
				break;

			case "k": // 1-24
				value = token.value;
				if ( outOfRange( value, 1, 24 ) ) {
					return false;
				}
				hour = true;
				date.setHours( value === 24 ? 0 : value );
				truncateAt.push( HOUR );
				break;

			case "H": // 0-23
				value = token.value;
				if ( outOfRange( value, 0, 23 ) ) {
					return false;
				}
				hour = true;
				date.setHours( value );
				truncateAt.push( HOUR );
				break;

			// Minute
			case "m":
				value = token.value;
				if ( outOfRange( value, 0, 59 ) ) {
					return false;
				}
				date.setMinutes( value );
				truncateAt.push( MINUTE );
				break;

			// Second
			case "s":
				value = token.value;
				if ( outOfRange( value, 0, 59 ) ) {
					return false;
				}
				date.setSeconds( value );
				truncateAt.push( SECOND );
				break;

			case "A":
				date.setHours( 0 );
				date.setMinutes( 0 );
				date.setSeconds( 0 );

			/* falls through */
			case "S":
				value = Math.round( token.value * Math.pow( 10, 3 - length ) );
				date.setMilliseconds( value );
				truncateAt.push( MILLISECONDS );
				break;

			// Zone
			case "z":
			case "Z":
			case "O":
			case "v":
			case "V":
			case "X":
			case "x":
				if ( typeof token.value === "number" ) {
					timezoneOffset = token.value;
				}
				break;
		}

		return true;
	});

	if ( !valid ) {
		return null;
	}

	// 12-hour format needs AM or PM, 24-hour format doesn't, ie. return null
	// if amPm && !hour12 || !amPm && hour12.
	if ( hour && !( !amPm ^ hour12 ) ) {
		return null;
	}

	if ( era === 0 ) {

		// 1 BC = year 0
		date.setFullYear( date.getFullYear() * -1 + 1 );
	}

	if ( month !== undefined ) {
		dateSetMonth( date, month - 1 );
	}

	if ( day !== undefined ) {
		if ( outOfRange( day, 1, dateLastDayOfMonth( date ) ) ) {
			return null;
		}
		date.setDate( day );
	} else if ( daysOfYear !== undefined ) {
		if ( outOfRange( daysOfYear, 1, dateIsLeapYear( date.getFullYear() ) ? 366 : 365 ) ) {
			return null;
		}
		date.setMonth( 0 );
		date.setDate( daysOfYear );
	}

	if ( hour12 && amPm === "pm" ) {
		date.setHours( date.getHours() + 12 );
	}

	if ( timezoneOffset !== undefined ) {
		date.setMinutes( date.getMinutes() + timezoneOffset - date.getTimezoneOffset() );
	}

	// Truncate date at the most precise unit defined. Eg.
	// If value is "12/31", and pattern is "MM/dd":
	// => new Date( <current Year>, 12, 31, 0, 0, 0, 0 );
	truncateAt = Math.max.apply( null, truncateAt );
	date = dateStartOf( date, units[ truncateAt ] );

	// Get date back from globalize date.
	if ( date instanceof ZonedDateTime ) {
		date = date.toDate();
	}

	return date;
};




/**
 * tokenizer( value, numberParser, properties )
 *
 * @value [String] string date.
 *
 * @numberParser [Function]
 *
 * @properties [Object] output returned by date/tokenizer-properties.
 *
 * Returns an Array of tokens, eg. value "5 o'clock PM", pattern "h 'o''clock' a":
 * [{
 *   type: "h",
 *   lexeme: "5"
 * }, {
 *   type: "literal",
 *   lexeme: " "
 * }, {
 *   type: "literal",
 *   lexeme: "o'clock"
 * }, {
 *   type: "literal",
 *   lexeme: " "
 * }, {
 *   type: "a",
 *   lexeme: "PM",
 *   value: "pm"
 * }]
 *
 * OBS: lexeme's are always String and may return invalid ranges depending of the token type.
 * Eg. "99" for month number.
 *
 * Return an empty Array when not successfully parsed.
 */
var dateTokenizer = function( value, numberParser, properties ) {
	var digitsRe, valid,
		tokens = [],
		widths = [ "abbreviated", "wide", "narrow" ];

	digitsRe = properties.digitsRe;
	value = looseMatching( value );

	valid = properties.pattern.match( datePatternRe ).every(function( current ) {
		var aux, chr, length, numeric, tokenRe,
			token = {};

		function hourFormatParse( tokenRe, numberParser ) {
			var aux, isPositive,
				match = value.match( tokenRe );
			numberParser = numberParser || function( value ) {
				return +value;
			};

			if ( !match ) {
				return false;
			}

			isPositive = match[ 1 ];

			// hourFormat containing H only, e.g., `+H;-H`
			if ( match.length < 6 ) {
				aux = isPositive ? 1 : 3;
				token.value = numberParser( match[ aux ] ) * 60;

			// hourFormat containing H and m, e.g., `+HHmm;-HHmm`
			} else if ( match.length < 10 ) {
				aux = isPositive ? [ 1, 3 ] : [ 5, 7 ];
				token.value = numberParser( match[ aux[ 0 ] ] ) * 60 +
					numberParser( match[ aux[ 1 ] ] );

			// hourFormat containing H, m, and s e.g., `+HHmmss;-HHmmss`
			} else {
				aux = isPositive ? [ 1, 3, 5 ] : [ 7, 9, 11 ];
				token.value = numberParser( match[ aux[ 0 ] ] ) * 60 +
					numberParser( match[ aux[ 1 ] ] ) +
					numberParser( match[ aux[ 2 ] ] ) / 60;
			}

			if ( isPositive ) {
				token.value *= -1;
			}

			return true;
		}

		function oneDigitIfLengthOne() {
			if ( length === 1 ) {

				// Unicode equivalent to /\d/
				numeric = true;
				return tokenRe = digitsRe;
			}
		}

		function oneOrTwoDigitsIfLengthOne() {
			if ( length === 1 ) {

				// Unicode equivalent to /\d\d?/
				numeric = true;
				return tokenRe = new RegExp( "^(" + digitsRe.source + "){1,2}" );
			}
		}

		function oneOrTwoDigitsIfLengthOneOrTwo() {
			if ( length === 1 || length === 2 ) {

				// Unicode equivalent to /\d\d?/
				numeric = true;
				return tokenRe = new RegExp( "^(" + digitsRe.source + "){1,2}" );
			}
		}

		function twoDigitsIfLengthTwo() {
			if ( length === 2 ) {

				// Unicode equivalent to /\d\d/
				numeric = true;
				return tokenRe = new RegExp( "^(" + digitsRe.source + "){2}" );
			}
		}

		// Brute-force test every locale entry in an attempt to match the given value.
		// Return the first found one (and set token accordingly), or null.
		function lookup( path ) {
			var array = properties[ path.join( "/" ) ];

			if ( !array ) {
				return null;
			}

			// array of pairs [key, value] sorted by desc value length.
			array.some(function( item ) {
				var valueRe = item[ 1 ];
				if ( valueRe.test( value ) ) {
					token.value = item[ 0 ];
					tokenRe = item[ 1 ];
					return true;
				}
			});
			return null;
		}

		token.type = current;
		chr = current.charAt( 0 );
		length = current.length;

		if ( chr === "Z" ) {

			// Z..ZZZ: same as "xxxx".
			if ( length < 4 ) {
				chr = "x";
				length = 4;

			// ZZZZ: same as "OOOO".
			} else if ( length < 5 ) {
				chr = "O";
				length = 4;

			// ZZZZZ: same as "XXXXX"
			} else {
				chr = "X";
				length = 5;
			}
		}

		if ( chr === "z" ) {
			if ( properties.standardOrDaylightTzName ) {
				token.value = null;
				tokenRe = properties.standardOrDaylightTzName;
			}
		}

		// v...vvv: "{shortRegion}", eg. "PT".
		// vvvv: "{regionName} {Time}" or "{regionName} {Time}",
		// e.g., "Pacific Time"
		// http://unicode.org/reports/tr35/tr35-dates.html#Date_Format_Patterns
		if ( chr === "v" ) {
			if ( properties.genericTzName ) {
				token.value = null;
				tokenRe = properties.genericTzName;

			// Fall back to "V" format.
			} else {
				chr = "V";
				length = 4;
			}
		}

		if ( chr === "V" && properties.timeZoneName ) {
			token.value = length === 2 ? properties.timeZoneName : null;
			tokenRe = properties.timeZoneNameRe;
		}

		switch ( chr ) {

			// Era
			case "G":
				lookup([
					"gregorian/eras",
					length <= 3 ? "eraAbbr" : ( length === 4 ? "eraNames" : "eraNarrow" )
				]);
				break;

			// Year
			case "y":
			case "Y":
				numeric = true;

				// number l=1:+, l=2:{2}, l=3:{3,}, l=4:{4,}, ...
				if ( length === 1 ) {

					// Unicode equivalent to /\d+/.
					tokenRe = new RegExp( "^(" + digitsRe.source + ")+" );
				} else if ( length === 2 ) {

					// Lenient parsing: there's no year pattern to indicate non-zero-padded 2-digits
					// year, so parser accepts both zero-padded and non-zero-padded for `yy`.
					//
					// Unicode equivalent to /\d\d?/
					tokenRe = new RegExp( "^(" + digitsRe.source + "){1,2}" );
				} else {

					// Unicode equivalent to /\d{length,}/
					tokenRe = new RegExp( "^(" + digitsRe.source + "){" + length + ",}" );
				}
				break;

			// Quarter
			case "Q":
			case "q":

				// number l=1:{1}, l=2:{2}.
				// lookup l=3...
				oneDigitIfLengthOne() || twoDigitsIfLengthTwo() ||
					lookup([
						"gregorian/quarters",
						chr === "Q" ? "format" : "stand-alone",
						widths[ length - 3 ]
					]);
				break;

			// Month
			case "M":
			case "L":

				// number l=1:{1,2}, l=2:{2}.
				// lookup l=3...
				//
				// Lenient parsing: skeleton "yMd" (i.e., one M) may include MM for the pattern,
				// therefore parser accepts both zero-padded and non-zero-padded for M and MM.
				// Similar for L.
				oneOrTwoDigitsIfLengthOneOrTwo() || lookup([
					"gregorian/months",
					chr === "M" ? "format" : "stand-alone",
					widths[ length - 3 ]
				]);
				break;

			// Day
			case "D":

				// number {l,3}.
				if ( length <= 3 ) {

					// Equivalent to /\d{length,3}/
					numeric = true;
					tokenRe = new RegExp( "^(" + digitsRe.source + "){" + length + ",3}" );
				}
				break;

			case "W":
			case "F":

				// number l=1:{1}.
				oneDigitIfLengthOne();
				break;

			// Week day
			case "e":
			case "c":

				// number l=1:{1}, l=2:{2}.
				// lookup for length >=3.
				if ( length <= 2 ) {
					oneDigitIfLengthOne() || twoDigitsIfLengthTwo();
					break;
				}

			/* falls through */
			case "E":
				if ( length === 6 ) {

					// Note: if short day names are not explicitly specified, abbreviated day
					// names are used instead http://www.unicode.org/reports/tr35/tr35-dates.html#months_days_quarters_eras
					lookup([
						"gregorian/days",
						[ chr === "c" ? "stand-alone" : "format" ],
						"short"
					]) || lookup([
						"gregorian/days",
						[ chr === "c" ? "stand-alone" : "format" ],
						"abbreviated"
					]);
				} else {
					lookup([
						"gregorian/days",
						[ chr === "c" ? "stand-alone" : "format" ],
						widths[ length < 3 ? 0 : length - 3 ]
					]);
				}
				break;

			// Period (AM or PM)
			case "a":
				lookup([
					"gregorian/dayPeriods/format/wide"
				]);
				break;

			// Week
			case "w":

				// number l1:{1,2}, l2:{2}.
				oneOrTwoDigitsIfLengthOne() || twoDigitsIfLengthTwo();
				break;

			// Day, Hour, Minute, or Second
			case "d":
			case "h":
			case "H":
			case "K":
			case "k":
			case "j":
			case "m":
			case "s":

				// number l1:{1,2}, l2:{2}.
				//
				// Lenient parsing:
				// - skeleton "hms" (i.e., one m) always includes mm for the pattern, i.e., it's
				//   impossible to use a different skeleton to parse non-zero-padded minutes,
				//   therefore parser accepts both zero-padded and non-zero-padded for m. Similar
				//   for seconds s.
				// - skeleton "hms" (i.e., one h) may include h or hh for the pattern, i.e., it's
				//   impossible to use a different skeleton to parser non-zero-padded hours for some
				//   locales, therefore parser accepts both zero-padded and non-zero-padded for h.
				//   Similar for d (in skeleton yMd).
				oneOrTwoDigitsIfLengthOneOrTwo();
				break;

			case "S":

				// number {l}.

				// Unicode equivalent to /\d{length}/
				numeric = true;
				tokenRe = new RegExp( "^(" + digitsRe.source + "){" + length + "}" );
				break;

			case "A":

				// number {l+5}.

				// Unicode equivalent to /\d{length+5}/
				numeric = true;
				tokenRe = new RegExp( "^(" + digitsRe.source + "){" + ( length + 5 ) + "}" );
				break;

			// Zone
			case "v":
			case "V":
			case "z":
				if ( tokenRe && tokenRe.test( value ) ) {
					break;
				}
				if ( chr === "V" && length === 2 ) {
					break;
				}

			/* falls through */
			case "O":

				// O: "{gmtFormat}+H;{gmtFormat}-H" or "{gmtZeroFormat}", eg. "GMT-8" or "GMT".
				// OOOO: "{gmtFormat}{hourFormat}" or "{gmtZeroFormat}", eg. "GMT-08:00" or "GMT".
				if ( value === properties[ "timeZoneNames/gmtZeroFormat" ] ) {
					token.value = 0;
					tokenRe = properties[ "timeZoneNames/gmtZeroFormatRe" ];
				} else {
					aux = properties[ "timeZoneNames/hourFormat" ].some(function( hourFormatRe ) {
						if ( hourFormatParse( hourFormatRe, numberParser ) ) {
							tokenRe = hourFormatRe;
							return true;
						}
					});
					if ( !aux ) {
						return null;
					}
				}
				break;

			case "X":

				// Same as x*, except it uses "Z" for zero offset.
				if ( value === "Z" ) {
					token.value = 0;
					tokenRe = /^Z/;
					break;
				}

			/* falls through */
			case "x":

				// x: hourFormat("+HH[mm];-HH[mm]")
				// xx: hourFormat("+HHmm;-HHmm")
				// xxx: hourFormat("+HH:mm;-HH:mm")
				// xxxx: hourFormat("+HHmm[ss];-HHmm[ss]")
				// xxxxx: hourFormat("+HH:mm[:ss];-HH:mm[:ss]")
				aux = properties.x.some(function( hourFormatRe ) {
					if ( hourFormatParse( hourFormatRe ) ) {
						tokenRe = hourFormatRe;
						return true;
					}
				});
				if ( !aux ) {
					return null;
				}
				break;

			case "'":
				token.type = "literal";
				tokenRe = new RegExp( "^" + regexpEscape( removeLiteralQuotes( current ) ) );
				break;

			default:
				token.type = "literal";
				tokenRe = new RegExp( "^" + regexpEscape( current ) );
		}

		if ( !tokenRe ) {
			return false;
		}

		// Get lexeme and consume it.
		value = value.replace( tokenRe, function( lexeme ) {
			token.lexeme = lexeme;
			if ( numeric ) {
				token.value = numberParser( lexeme );
			}
			return "";
		});

		if ( !token.lexeme ) {
			return false;
		}

		if ( numeric && isNaN( token.value ) ) {
			return false;
		}

		tokens.push( token );
		return true;
	});

	if ( value !== "" ) {
		valid = false;
	}

	return valid ? tokens : [];
};




var dateParserFn = function( numberParser, parseProperties, tokenizerProperties ) {
	return function dateParser( value ) {
		var tokens;

		validateParameterPresence( value, "value" );
		validateParameterTypeString( value, "value" );

		tokens = dateTokenizer( value, numberParser, tokenizerProperties );
		return dateParse( value, tokens, parseProperties ) || null;
	};
};




var objectFilter = function( object, testRe ) {
	var key,
		copy = {};

	for ( key in object ) {
		if ( testRe.test( key ) ) {
			copy[ key ] = object[ key ];
		}
	}

	return copy;
};




/**
 * tokenizerProperties( pattern, cldr )
 *
 * @pattern [String] raw pattern.
 *
 * @cldr [Cldr instance].
 *
 * Return Object with data that will be used by tokenizer.
 */
var dateTokenizerProperties = function( pattern, cldr, timeZone ) {
	var digitsReSource,
		properties = {
			pattern: looseMatching( pattern )
		},
		timeSeparator = numberSymbol( "timeSeparator", cldr ),
		widths = [ "abbreviated", "wide", "narrow" ];

	digitsReSource = numberNumberingSystemDigitsMap( cldr );
	digitsReSource = digitsReSource ? "[" + digitsReSource + "]" : "\\d";
	properties.digitsRe = new RegExp( digitsReSource );

	// Transform:
	// - "+H;-H" -> /\+(\d\d?)|-(\d\d?)/
	// - "+HH;-HH" -> /\+(\d\d)|-(\d\d)/
	// - "+HHmm;-HHmm" -> /\+(\d\d)(\d\d)|-(\d\d)(\d\d)/
	// - "+HH:mm;-HH:mm" -> /\+(\d\d):(\d\d)|-(\d\d):(\d\d)/
	//
	// If gmtFormat is GMT{0}, the regexp must fill {0} in each side, e.g.:
	// - "+H;-H" -> /GMT\+(\d\d?)|GMT-(\d\d?)/
	function hourFormatRe( hourFormat, gmtFormat, digitsReSource, timeSeparator ) {
		var re;

		if ( !digitsReSource ) {
			digitsReSource = "\\d";
		}
		if ( !gmtFormat ) {
			gmtFormat = "{0}";
		}

		re = hourFormat
			.replace( "+", "\\+" )

			// Unicode equivalent to (\\d\\d)
			.replace( /HH|mm|ss/g, "((" + digitsReSource + "){2})" )

			// Unicode equivalent to (\\d\\d?)
			.replace( /H|m/g, "((" + digitsReSource + "){1,2})" );

		if ( timeSeparator ) {
			re = re.replace( /:/g, timeSeparator );
		}

		re = re.split( ";" ).map(function( part ) {
			return gmtFormat.replace( "{0}", part );
		}).join( "|" );

		return new RegExp( "^" + re );
	}

	function populateProperties( path, value ) {

		// Skip
		var skipRe = /(timeZoneNames\/zone|supplemental\/metaZones|timeZoneNames\/metazone|timeZoneNames\/regionFormat|timeZoneNames\/gmtFormat)/;
		if ( skipRe.test( path ) ) {
			return;
		}

		if ( !value ) {
			return;
		}

		// The `dates` and `calendars` trim's purpose is to reduce properties' key size only.
		path = path.replace( /^.*\/dates\//, "" ).replace( /calendars\//, "" );

		// Specific filter for "gregorian/dayPeriods/format/wide".
		if ( path === "gregorian/dayPeriods/format/wide" ) {
			value = objectFilter( value, /^am|^pm/ );
		}

		// Transform object into array of pairs [key, /value/], sort by desc value length.
		if ( isPlainObject( value ) ) {
			value = Object.keys( value ).map(function( key ) {
				return [ key, new RegExp( "^" + regexpEscape( looseMatching( value[ key ] ) ) ) ];
			}).sort(function( a, b ) {
				return b[ 1 ].source.length - a[ 1 ].source.length;
			});

		// If typeof value === "string".
		} else {
			value = looseMatching( value );
		}
		properties[ path ] = value;
	}

	function regexpSourceSomeTerm( terms ) {
		return "(" + terms.filter(function( item ) {
			return item;
		}).reduce(function( memo, item ) {
			return memo + "|" + item;
		}) + ")";
	}

	cldr.on( "get", populateProperties );

	pattern.match( datePatternRe ).forEach(function( current ) {
		var aux, chr, daylightTzName, gmtFormat, length, standardTzName;

		chr = current.charAt( 0 );
		length = current.length;

		if ( chr === "Z" ) {
			if ( length < 5 ) {
				chr = "O";
				length = 4;
			} else {
				chr = "X";
				length = 5;
			}
		}

		// z...zzz: "{shortRegion}", eg. "PST" or "PDT".
		// zzzz: "{regionName} {Standard Time}" or "{regionName} {Daylight Time}",
		//       e.g., "Pacific Standard Time" or "Pacific Daylight Time".
		// http://unicode.org/reports/tr35/tr35-dates.html#Date_Format_Patterns
		if ( chr === "z" ) {
			standardTzName = dateGetTimeZoneName( length, "standard", timeZone, cldr );
			daylightTzName = dateGetTimeZoneName( length, "daylight", timeZone, cldr );
			if ( standardTzName ) {
				standardTzName = regexpEscape( looseMatching( standardTzName ) );
			}
			if ( daylightTzName ) {
				daylightTzName = regexpEscape( looseMatching( daylightTzName ) );
			}
			if ( standardTzName || daylightTzName ) {
				properties.standardOrDaylightTzName = new RegExp(
					"^" + regexpSourceSomeTerm([ standardTzName, daylightTzName ])
				);
			}

			// Fall through the "O" format in case one name is missing.
			if ( !standardTzName || !daylightTzName ) {
				chr = "O";
				if ( length < 4 ) {
					length = 1;
				}
			}
		}

		// v...vvv: "{shortRegion}", eg. "PT".
		// vvvv: "{regionName} {Time}" or "{regionName} {Time}",
		// e.g., "Pacific Time"
		// http://unicode.org/reports/tr35/tr35-dates.html#Date_Format_Patterns
		if ( chr === "v" ) {
			if ( length !== 1 && length !== 4 ) {
				throw createErrorUnsupportedFeature({
					feature: "timezone pattern `" + pattern + "`"
				});
			}
			var genericTzName = dateGetTimeZoneName( length, "generic", timeZone, cldr );
			if ( genericTzName ) {
				properties.genericTzName = new RegExp(
					"^" + regexpEscape( looseMatching( genericTzName ) )
				);
				chr = "O";

			// Fall back to "V" format.
			} else {
				chr = "V";
				length = 4;
			}
		}

		switch ( chr ) {

			// Era
			case "G":
				cldr.main([
					"dates/calendars/gregorian/eras",
					length <= 3 ? "eraAbbr" : ( length === 4 ? "eraNames" : "eraNarrow" )
				]);
				break;

			// Year
			case "u": // Extended year. Need to be implemented.
			case "U": // Cyclic year name. Need to be implemented.
				throw createErrorUnsupportedFeature({
					feature: "year pattern `" + chr + "`"
				});

			// Quarter
			case "Q":
			case "q":
				if ( length > 2 ) {
					cldr.main([
						"dates/calendars/gregorian/quarters",
						chr === "Q" ? "format" : "stand-alone",
						widths[ length - 3 ]
					]);
				}
				break;

			// Month
			case "M":
			case "L":

				// number l=1:{1,2}, l=2:{2}.
				// lookup l=3...
				if ( length > 2 ) {
					cldr.main([
						"dates/calendars/gregorian/months",
						chr === "M" ? "format" : "stand-alone",
						widths[ length - 3 ]
					]);
				}
				break;

			// Day
			case "g":

				// Modified Julian day. Need to be implemented.
				throw createErrorUnsupportedFeature({
					feature: "Julian day pattern `g`"
				});

			// Week day
			case "e":
			case "c":

				// lookup for length >=3.
				if ( length <= 2 ) {
					break;
				}

			/* falls through */
			case "E":
				if ( length === 6 ) {

					// Note: if short day names are not explicitly specified, abbreviated day
					// names are used instead http://www.unicode.org/reports/tr35/tr35-dates.html#months_days_quarters_eras
					cldr.main([
						"dates/calendars/gregorian/days",
						[ chr === "c" ? "stand-alone" : "format" ],
						"short"
					]) || cldr.main([
						"dates/calendars/gregorian/days",
						[ chr === "c" ? "stand-alone" : "format" ],
						"abbreviated"
					]);
				} else {
					cldr.main([
						"dates/calendars/gregorian/days",
						[ chr === "c" ? "stand-alone" : "format" ],
						widths[ length < 3 ? 0 : length - 3 ]
					]);
				}
				break;

			// Period (AM or PM)
			case "a":
				cldr.main(
					"dates/calendars/gregorian/dayPeriods/format/wide"
				);
				break;

			// Zone
			case "V":

				if ( length === 1 ) {
					throw createErrorUnsupportedFeature({
						feature: "timezone pattern `" + pattern + "`"
					});
				}

				if ( timeZone ) {
					if ( length === 2 ) {

						// Skip looseMatching processing since timeZone is a canonical posix value.
						properties.timeZoneName = timeZone;
						properties.timeZoneNameRe = new RegExp( "^" + regexpEscape( timeZone ) );
						break;
					}

					var timeZoneName,
						exemplarCity = cldr.main([
							"dates/timeZoneNames/zone", timeZone, "exemplarCity"
						]);

					if ( length === 3 ) {
						if ( !exemplarCity ) {
							exemplarCity = cldr.main([
								"dates/timeZoneNames/zone/Etc/Unknown/exemplarCity"
							]);
						}
						timeZoneName = exemplarCity;
					}

					if ( exemplarCity && length === 4 ) {
						timeZoneName = formatMessage(
							cldr.main(
								"dates/timeZoneNames/regionFormat"
							),
							[ exemplarCity ]
						);
					}

					if ( timeZoneName ) {
						timeZoneName = looseMatching( timeZoneName );
						properties.timeZoneName = timeZoneName;
						properties.timeZoneNameRe = new RegExp(
							"^" + regexpEscape( timeZoneName )
						);
					}
				}

				if ( current === "v" ) {
					length = 1;
				}

			/* falls through */
			case "z":
			case "O":
				gmtFormat = cldr.main( "dates/timeZoneNames/gmtFormat" );
				cldr.main( "dates/timeZoneNames/gmtZeroFormat" );
				cldr.main( "dates/timeZoneNames/hourFormat" );
				properties[ "timeZoneNames/gmtZeroFormatRe" ] =
					new RegExp( "^" + regexpEscape( properties[ "timeZoneNames/gmtZeroFormat" ] ) );
				aux = properties[ "timeZoneNames/hourFormat" ];
				properties[ "timeZoneNames/hourFormat" ] = (
					length < 4 ?
						[ dateTimezoneHourFormatHm( aux, "H" ), dateTimezoneHourFormatH( aux ) ] :
						[ dateTimezoneHourFormatHm( aux, "HH" ) ]
				).map(function( hourFormat ) {
					return hourFormatRe(
						hourFormat,
						gmtFormat,
						digitsReSource,
						timeSeparator
					);
				});

			/* falls through */
			case "X":
			case "x":

				// x: hourFormat("+HH[mm];-HH[mm]")
				// xx: hourFormat("+HHmm;-HHmm")
				// xxx: hourFormat("+HH:mm;-HH:mm")
				// xxxx: hourFormat("+HHmm[ss];-HHmm[ss]")
				// xxxxx: hourFormat("+HH:mm[:ss];-HH:mm[:ss]")
				properties.x = [
					[ "+HHmm;-HHmm", "+HH;-HH" ],
					[ "+HHmm;-HHmm" ],
					[ "+HH:mm;-HH:mm" ],
					[ "+HHmmss;-HHmmss", "+HHmm;-HHmm" ],
					[ "+HH:mm:ss;-HH:mm:ss", "+HH:mm;-HH:mm" ]
				][ length - 1 ].map(function( hourFormat ) {
					return hourFormatRe( hourFormat );
				});
		}
	});

	cldr.off( "get", populateProperties );

	return properties;
};




/**
 * dayOfWeek( date, firstDay )
 *
 * @date
 *
 * @firstDay the result of `dateFirstDayOfWeek( cldr )`
 *
 * Return the day of the week normalized by the territory's firstDay [0-6].
 * Eg for "mon":
 * - return 0 if territory is GB, or BR, or DE, or FR (week starts on "mon");
 * - return 1 if territory is US (week starts on "sun");
 * - return 2 if territory is EG (week starts on "sat");
 */
var dateDayOfWeek = function( date, firstDay ) {
	return ( date.getDay() - firstDay + 7 ) % 7;
};




/**
 * distanceInDays( from, to )
 *
 * Return the distance in days between from and to Dates.
 */
var dateDistanceInDays = function( from, to ) {
	var inDays = 864e5;
	return ( to.getTime() - from.getTime() ) / inDays;
};




/**
 * dayOfYear
 *
 * Return the distance in days of the date to the begin of the year [0-d].
 */
var dateDayOfYear = function( date ) {
	return Math.floor( dateDistanceInDays( dateStartOf( date, "year" ), date ) );
};




// Invert key and values, e.g., {"year": "yY"} ==> {"y": "year", "Y": "year"}
var dateFieldsMap = objectInvert({
	"era": "G",
	"year": "yY",
	"quarter": "qQ",
	"month": "ML",
	"week": "wW",
	"day": "dDF",
	"weekday": "ecE",
	"dayperiod": "a",
	"hour": "hHkK",
	"minute": "m",
	"second": "sSA",
	"zone": "zvVOxX"
}, function( object, key, value ) {
	value.split( "" ).forEach(function( symbol ) {
		object[ symbol ] = key;
	});
	return object;
});




/**
 * millisecondsInDay
 */
var dateMillisecondsInDay = function( date ) {

	// TODO Handle daylight savings discontinuities
	return date - dateStartOf( date, "day" );
};




/**
 * hourFormat( date, format, timeSeparator, formatNumber )
 *
 * Return date's timezone offset according to the format passed.
 * Eg for format when timezone offset is 180:
 * - "+H;-H": -3
 * - "+HHmm;-HHmm": -0300
 * - "+HH:mm;-HH:mm": -03:00
 * - "+HH:mm:ss;-HH:mm:ss": -03:00:00
 */
var dateTimezoneHourFormat = function( date, format, timeSeparator, formatNumber ) {
	var absOffset,
		offset = date.getTimezoneOffset();

	absOffset = Math.abs( offset );
	formatNumber = formatNumber || {
		1: function( value ) {
			return stringPad( value, 1 );
		},
		2: function( value ) {
			return stringPad( value, 2 );
		}
	};

	return format

		// Pick the correct sign side (+ or -).
		.split( ";" )[ offset > 0 ? 1 : 0 ]

		// Localize time separator
		.replace( ":", timeSeparator )

		// Update hours offset.
		.replace( /HH?/, function( match ) {
			return formatNumber[ match.length ]( Math.floor( absOffset / 60 ) );
		})

		// Update minutes offset and return.
		.replace( /mm/, function() {
			return formatNumber[ 2 ]( Math.floor( absOffset % 60 ) );
		})

		// Update minutes offset and return.
		.replace( /ss/, function() {
			return formatNumber[ 2 ]( Math.floor( absOffset % 1 * 60 ) );
		});
};




/**
 * format( date, properties )
 *
 * @date [Date instance].
 *
 * @properties
 *
 * TODO Support other calendar types.
 *
 * Disclosure: this function borrows excerpts of dojo/date/locale.
 */
var dateFormat = function( date, numberFormatters, properties ) {
	var parts = [];

	var timeSeparator = properties.timeSeparator;

	// create globalize date with given timezone data
	if ( properties.timeZoneData ) {
		date = new ZonedDateTime( date, properties.timeZoneData() );
	}

	properties.pattern.replace( datePatternRe, function( current ) {
		var aux, dateField, type, value,
			chr = current.charAt( 0 ),
			length = current.length;

		if ( chr === "j" ) {

			// Locale preferred hHKk.
			// http://www.unicode.org/reports/tr35/tr35-dates.html#Time_Data
			chr = properties.preferredTime;
		}

		if ( chr === "Z" ) {

			// Z..ZZZ: same as "xxxx".
			if ( length < 4 ) {
				chr = "x";
				length = 4;

			// ZZZZ: same as "OOOO".
			} else if ( length < 5 ) {
				chr = "O";
				length = 4;

			// ZZZZZ: same as "XXXXX"
			} else {
				chr = "X";
				length = 5;
			}
		}

		// z...zzz: "{shortRegion}", e.g., "PST" or "PDT".
		// zzzz: "{regionName} {Standard Time}" or "{regionName} {Daylight Time}",
		//       e.g., "Pacific Standard Time" or "Pacific Daylight Time".
		if ( chr === "z" ) {
			if ( date.isDST ) {
				value = date.isDST() ? properties.daylightTzName : properties.standardTzName;
			}

			// Fall back to "O" format.
			if ( !value ) {
				chr = "O";
				if ( length < 4 ) {
					length = 1;
				}
			}
		}

		switch ( chr ) {

			// Era
			case "G":
				value = properties.eras[ date.getFullYear() < 0 ? 0 : 1 ];
				break;

			// Year
			case "y":

				// Plain year.
				// The length specifies the padding, but for two letters it also specifies the
				// maximum length.
				value = date.getFullYear();
				if ( length === 2 ) {
					value = String( value );
					value = +value.substr( value.length - 2 );
				}
				break;

			case "Y":

				// Year in "Week of Year"
				// The length specifies the padding, but for two letters it also specifies the
				// maximum length.
				// yearInWeekofYear = date + DaysInAWeek - (dayOfWeek - firstDay) - minDays
				value = new Date( date.getTime() );
				value.setDate(
					value.getDate() + 7 -
					dateDayOfWeek( date, properties.firstDay ) -
					properties.firstDay -
					properties.minDays
				);
				value = value.getFullYear();
				if ( length === 2 ) {
					value = String( value );
					value = +value.substr( value.length - 2 );
				}
				break;

			// Quarter
			case "Q":
			case "q":
				value = Math.ceil( ( date.getMonth() + 1 ) / 3 );
				if ( length > 2 ) {
					value = properties.quarters[ chr ][ length ][ value ];
				}
				break;

			// Month
			case "M":
			case "L":
				value = date.getMonth() + 1;
				if ( length > 2 ) {
					value = properties.months[ chr ][ length ][ value ];
				}
				break;

			// Week
			case "w":

				// Week of Year.
				// woy = ceil( ( doy + dow of 1/1 ) / 7 ) - minDaysStuff ? 1 : 0.
				// TODO should pad on ww? Not documented, but I guess so.
				value = dateDayOfWeek( dateStartOf( date, "year" ), properties.firstDay );
				value = Math.ceil( ( dateDayOfYear( date ) + value ) / 7 ) -
					( 7 - value >= properties.minDays ? 0 : 1 );
				break;

			case "W":

				// Week of Month.
				// wom = ceil( ( dom + dow of `1/month` ) / 7 ) - minDaysStuff ? 1 : 0.
				value = dateDayOfWeek( dateStartOf( date, "month" ), properties.firstDay );
				value = Math.ceil( ( date.getDate() + value ) / 7 ) -
					( 7 - value >= properties.minDays ? 0 : 1 );
				break;

			// Day
			case "d":
				value = date.getDate();
				break;

			case "D":
				value = dateDayOfYear( date ) + 1;
				break;

			case "F":

				// Day of Week in month. eg. 2nd Wed in July.
				value = Math.floor( date.getDate() / 7 ) + 1;
				break;

			// Week day
			case "e":
			case "c":
				if ( length <= 2 ) {

					// Range is [1-7] (deduced by example provided on documentation)
					// TODO Should pad with zeros (not specified in the docs)?
					value = dateDayOfWeek( date, properties.firstDay ) + 1;
					break;
				}

			/* falls through */
			case "E":
				value = dateWeekDays[ date.getDay() ];
				value = properties.days[ chr ][ length ][ value ];
				break;

			// Period (AM or PM)
			case "a":
				value = properties.dayPeriods[ date.getHours() < 12 ? "am" : "pm" ];
				break;

			// Hour
			case "h": // 1-12
				value = ( date.getHours() % 12 ) || 12;
				break;

			case "H": // 0-23
				value = date.getHours();
				break;

			case "K": // 0-11
				value = date.getHours() % 12;
				break;

			case "k": // 1-24
				value = date.getHours() || 24;
				break;

			// Minute
			case "m":
				value = date.getMinutes();
				break;

			// Second
			case "s":
				value = date.getSeconds();
				break;

			case "S":
				value = Math.round( date.getMilliseconds() * Math.pow( 10, length - 3 ) );
				break;

			case "A":
				value = Math.round( dateMillisecondsInDay( date ) * Math.pow( 10, length - 3 ) );
				break;

			// Zone
			case "z":
				break;

			case "v":

				// v...vvv: "{shortRegion}", eg. "PT".
				// vvvv: "{regionName} {Time}",
				//       e.g., "Pacific Time".
				if ( properties.genericTzName ) {
					value = properties.genericTzName;
					break;
				}

			/* falls through */
			case "V":

				//VVVV: "{explarCity} {Time}", e.g., "Los Angeles Time"
				if ( properties.timeZoneName ) {
					value = properties.timeZoneName;
					break;
				}

				if ( current === "v" ) {
					length = 1;
				}

			/* falls through */
			case "O":

				// O: "{gmtFormat}+H;{gmtFormat}-H" or "{gmtZeroFormat}", eg. "GMT-8" or "GMT".
				// OOOO: "{gmtFormat}{hourFormat}" or "{gmtZeroFormat}", eg. "GMT-08:00" or "GMT".
				if ( date.getTimezoneOffset() === 0 ) {
					value = properties.gmtZeroFormat;
				} else {

					// If O..OOO and timezone offset has non-zero minutes, show minutes.
					if ( length < 4 ) {
						aux = date.getTimezoneOffset();
						aux = properties.hourFormat[ aux % 60 - aux % 1 === 0 ? 0 : 1 ];
					} else {
						aux = properties.hourFormat;
					}

					value = dateTimezoneHourFormat(
						date,
						aux,
						timeSeparator,
						numberFormatters
					);
					value = properties.gmtFormat.replace( /\{0\}/, value );
				}
				break;

			case "X":

				// Same as x*, except it uses "Z" for zero offset.
				if ( date.getTimezoneOffset() === 0 ) {
					value = "Z";
					break;
				}

			/* falls through */
			case "x":

				// x: hourFormat("+HH[mm];-HH[mm]")
				// xx: hourFormat("+HHmm;-HHmm")
				// xxx: hourFormat("+HH:mm;-HH:mm")
				// xxxx: hourFormat("+HHmm[ss];-HHmm[ss]")
				// xxxxx: hourFormat("+HH:mm[:ss];-HH:mm[:ss]")
				aux = date.getTimezoneOffset();

				// If x and timezone offset has non-zero minutes, use xx (i.e., show minutes).
				if ( length === 1 && aux % 60 - aux % 1 !== 0 ) {
					length += 1;
				}

				// If (xxxx or xxxxx) and timezone offset has zero seconds, use xx or xxx
				// respectively (i.e., don't show optional seconds).
				if ( ( length === 4 || length === 5 ) && aux % 1 === 0 ) {
					length -= 2;
				}

				value = [
					"+HH;-HH",
					"+HHmm;-HHmm",
					"+HH:mm;-HH:mm",
					"+HHmmss;-HHmmss",
					"+HH:mm:ss;-HH:mm:ss"
				][ length - 1 ];

				value = dateTimezoneHourFormat( date, value, ":" );
				break;

			// timeSeparator
			case ":":
				value = timeSeparator;
				break;

			// ' literals.
			case "'":
				value = removeLiteralQuotes( current );
				break;

			// Anything else is considered a literal, including [ ,:/.@#], chinese, japonese, and
			// arabic characters.
			default:
				value = current;

		}
		if ( typeof value === "number" ) {
			value = numberFormatters[ length ]( value );
		}

		dateField = dateFieldsMap[ chr ];
		type = dateField ? dateField : "literal";

		// Concat two consecutive literals
		if ( type === "literal" && parts.length && parts[ parts.length - 1 ].type === "literal" ) {
			parts[ parts.length - 1 ].value += value;
			return;
		}

		parts.push( { type: type, value: value } );

	});

	return parts;

};




var dateToPartsFormatterFn = function( numberFormatters, properties ) {
	return function dateToPartsFormatter( value ) {
		validateParameterPresence( value, "value" );
		validateParameterTypeDate( value, "value" );

		return dateFormat( value, numberFormatters, properties );
	};

};




function optionsHasStyle( options ) {
	return options.skeleton !== undefined ||
		options.date !== undefined ||
		options.time !== undefined ||
		options.datetime !== undefined ||
		options.raw !== undefined;
}

function validateRequiredCldr( path, value ) {
	validateCldr( path, value, {
		skip: [
			/dates\/calendars\/gregorian\/dateTimeFormats\/availableFormats/,
			/dates\/calendars\/gregorian\/days\/.*\/short/,
			/dates\/timeZoneNames\/zone/,
			/dates\/timeZoneNames\/metazone/,
			/globalize-iana/,
			/supplemental\/metaZones/,
			/supplemental\/timeData\/(?!001)/,
			/supplemental\/weekData\/(?!001)/
		]
	});
}

function validateOptionsPreset( options ) {
	validateOptionsPresetEach( "date", options );
	validateOptionsPresetEach( "time", options );
	validateOptionsPresetEach( "datetime", options );
}

function validateOptionsPresetEach( type, options ) {
	var value = options[ type ];
	validate(
		"E_INVALID_OPTIONS",
		"Invalid `{{type}: \"{value}\"}`.",
		value === undefined || [ "short", "medium", "long", "full" ].indexOf( value ) !== -1,
		{ type: type, value: value }
	);
}

function validateOptionsSkeleton( pattern, skeleton ) {
	validate(
		"E_INVALID_OPTIONS",
		"Invalid `{skeleton: \"{value}\"}` based on provided CLDR.",
		skeleton === undefined || ( typeof pattern === "string" && pattern ),
		{ type: "skeleton", value: skeleton }
	);
}

function validateRequiredIana( timeZone ) {
	return function( path, value ) {

		if ( !/globalize-iana/.test( path ) ) {
			return;
		}

		validate(
			"E_MISSING_IANA_TZ",
			"Missing required IANA timezone content for `{timeZone}`: `{path}`.",
			value,
			{
				path: path.replace( /globalize-iana\//, "" ),
				timeZone: timeZone
			}
		);
	};
}

/**
 * .loadTimeZone( json )
 *
 * @json [JSON]
 *
 * Load IANA timezone data.
 */
Globalize.loadTimeZone = function( json ) {
	var customData = {
			"globalize-iana": json
		};

	validateParameterPresence( json, "json" );
	validateParameterTypePlainObject( json, "json" );

	Cldr.load( customData );
};

/**
 * .dateFormatter( options )
 *
 * @options [Object] see date/expand_pattern for more info.
 *
 * Return a date formatter function (of the form below) according to the given options and the
 * default/instance locale.
 *
 * fn( value )
 *
 * @value [Date]
 *
 * Return a function that formats a date according to the given `format` and the default/instance
 * locale.
 */
Globalize.dateFormatter =
Globalize.prototype.dateFormatter = function( options ) {
	var args, dateToPartsFormatter, returnFn;

	validateParameterTypePlainObject( options, "options" );

	options = options || {};
	if ( !optionsHasStyle( options ) ) {
		options.skeleton = "yMd";
	}
	args = [ options ];

	dateToPartsFormatter = this.dateToPartsFormatter( options );
	returnFn = dateFormatterFn( dateToPartsFormatter );
	runtimeBind( args, this.cldr, returnFn, [ dateToPartsFormatter ] );

	return returnFn;
};

/**
 * .dateToPartsFormatter( options )
 *
 * @options [Object] see date/expand_pattern for more info.
 *
 * Return a date formatter function (of the form below) according to the given options and the
 * default/instance locale.
 *
 * fn( value )
 *
 * @value [Date]
 *
 * Return a function that formats a date to parts according to the given `format`
 * and the default/instance
 * locale.
 */
Globalize.dateToPartsFormatter =
Globalize.prototype.dateToPartsFormatter = function( options ) {
	var args, cldr, numberFormatters, pad, pattern, properties, returnFn,
		timeZone, ianaListener;

	validateParameterTypePlainObject( options, "options" );

	cldr = this.cldr;
	options = options || {};
	if ( !optionsHasStyle( options ) ) {
		options.skeleton = "yMd";
	}

	validateOptionsPreset( options );
	validateDefaultLocale( cldr );

	timeZone = options.timeZone;
	validateParameterTypeString( timeZone, "options.timeZone" );

	args = [ options ];

	cldr.on( "get", validateRequiredCldr );
	if ( timeZone ) {
		ianaListener = validateRequiredIana( timeZone );
		cldr.on( "get", ianaListener );
	}
	pattern = dateExpandPattern( options, cldr );
	validateOptionsSkeleton( pattern, options.skeleton );
	properties = dateFormatProperties( pattern, cldr, timeZone );
	cldr.off( "get", validateRequiredCldr );
	if ( ianaListener ) {
		cldr.off( "get", ianaListener );
	}

	// Create needed number formatters.
	numberFormatters = properties.numberFormatters;
	delete properties.numberFormatters;
	for ( pad in numberFormatters ) {
		numberFormatters[ pad ] = this.numberFormatter({
			raw: numberFormatters[ pad ]
		});
	}

	returnFn = dateToPartsFormatterFn( numberFormatters, properties );

	runtimeBind( args, cldr, returnFn, [ numberFormatters, properties ] );

	return returnFn;
};

/**
 * .dateParser( options )
 *
 * @options [Object] see date/expand_pattern for more info.
 *
 * Return a function that parses a string date according to the given `formats` and the
 * default/instance locale.
 */
Globalize.dateParser =
Globalize.prototype.dateParser = function( options ) {
	var args, cldr, numberParser, parseProperties, pattern, returnFn, timeZone,
		tokenizerProperties;

	validateParameterTypePlainObject( options, "options" );

	cldr = this.cldr;
	options = options || {};
	if ( !optionsHasStyle( options ) ) {
		options.skeleton = "yMd";
	}

	validateOptionsPreset( options );
	validateDefaultLocale( cldr );

	timeZone = options.timeZone;
	validateParameterTypeString( timeZone, "options.timeZone" );

	args = [ options ];

	cldr.on( "get", validateRequiredCldr );
	if ( timeZone ) {
		cldr.on( "get", validateRequiredIana( timeZone ) );
	}
	pattern = dateExpandPattern( options, cldr );
	validateOptionsSkeleton( pattern, options.skeleton );
	tokenizerProperties = dateTokenizerProperties( pattern, cldr, timeZone );
	parseProperties = dateParseProperties( cldr, timeZone );
	cldr.off( "get", validateRequiredCldr );
	if ( timeZone ) {
		cldr.off( "get", validateRequiredIana( timeZone ) );
	}

	numberParser = this.numberParser({ raw: "0" });

	returnFn = dateParserFn( numberParser, parseProperties, tokenizerProperties );

	runtimeBind( args, cldr, returnFn, [ numberParser, parseProperties, tokenizerProperties ] );

	return returnFn;
};

/**
 * .formatDate( value, options )
 *
 * @value [Date]
 *
 * @options [Object] see date/expand_pattern for more info.
 *
 * Formats a date or number according to the given options string and the default/instance locale.
 */
Globalize.formatDate =
Globalize.prototype.formatDate = function( value, options ) {
	validateParameterPresence( value, "value" );
	validateParameterTypeDate( value, "value" );

	return this.dateFormatter( options )( value );
};

/**
 * .formatDateToParts( value, options )
 *
 * @value [Date]
 *
 * @options [Object] see date/expand_pattern for more info.
 *
 * Formats a date or number to parts according to the given options and the default/instance locale.
 */
Globalize.formatDateToParts =
Globalize.prototype.formatDateToParts = function( value, options ) {
	validateParameterPresence( value, "value" );
	validateParameterTypeDate( value, "value" );

	return this.dateToPartsFormatter( options )( value );
};

/**
 * .parseDate( value, options )
 *
 * @value [String]
 *
 * @options [Object] see date/expand_pattern for more info.
 *
 * Return a Date instance or null.
 */
Globalize.parseDate =
Globalize.prototype.parseDate = function( value, options ) {
	validateParameterPresence( value, "value" );
	validateParameterTypeString( value, "value" );

	return this.dateParser( options )( value );
};

return Globalize;




}));

/*!
* DevExtreme (dx.all.js)
* Version: 22.1.3
* Build date: Mon Jun 13 2022
*
* Copyright (c) 2012 - 2022 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";!function(){var e={23908:function(e,t,n){t.convertTransitionTimingFuncToEasing=void 0,t.getEasing=function(e){return s[e]},t.setEasing=function(e){s=e};var i=n(35922),o=/cubic-bezier\((\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\)/,a={linear:"cubic-bezier(0, 0, 1, 1)",swing:"cubic-bezier(0.445, 0.05, 0.55, 0.95)",ease:"cubic-bezier(0.25, 0.1, 0.25, 1)","ease-in":"cubic-bezier(0.42, 0, 1, 1)","ease-out":"cubic-bezier(0, 0, 0.58, 1)","ease-in-out":"cubic-bezier(0.42, 0, 0.58, 1)"},r=function(e,t,n,i){var o=3*e,a=3*(n-e)-o,r=1-o-a,s=3*t,l=3*(i-t)-s,u=1-s-l,d=function(e){return e*(o+e*(a+e*r))},c=function(e){return o+e*(2*a+3*e*r)};return function(e){return function(e){return e*(s+e*(l+e*u))}(function(e){for(var t,n=e,i=0;i<14&&(t=d(n)-e,!(Math.abs(t)<.001));)n-=t/c(n),i++;return n}(e))}},s={};t.convertTransitionTimingFuncToEasing=function(e){var t,n=(e=a[e]||e).match(o);n||(n=a[t="linear"].match(o)),n=n.slice(1,5);for(var l=0;l<n.length;l++)n[l]=parseFloat(n[l]);var u=t||"cubicbezier_"+n.join("_").replace(/\./g,"p");return(0,i.isFunction)(s[u])||(s[u]=function(e,t,i,o,a){return o*r(n[0],n[1],n[2],n[3])(t/a)+i}),u}},90057:function(e,t,n){t.cancelAnimationFrame=function(){u(),l.apply(r,arguments)},t.requestAnimationFrame=function(){return u(),s.apply(r,arguments)};var i,o=n(58201),a=(i=n(39618))&&i.__esModule?i:{default:i};var r=(0,o.hasWindow)()?(0,o.getWindow)():{},s=function(e){return setTimeout(e,1e3/60)},l=function(e){clearTimeout(e)},u=(0,a.default)((function(){var e=r.requestAnimationFrame||r.webkitRequestAnimationFrame||r.mozRequestAnimationFrame||r.oRequestAnimationFrame||r.msRequestAnimationFrame,t=r.cancelAnimationFrame||r.webkitCancelAnimationFrame||r.mozCancelAnimationFrame||r.oCancelAnimationFrame||r.msCancelAnimationFrame;e&&t&&(s=e,l=t)}))},87209:function(e,t,n){t.default=void 0;var i=b(n(68374)),o=n(58201),a=b(n(55994)),r=b(n(17381)),s=n(6415),l=n(13306),u=n(35922),d=n(95479),c=n(31648),h=n(23908),p=n(90057),f=n(60137),g=b(n(49387)),m=n(29007),_=n(39611),v=n(62754),y=n(20576);function b(e){return e&&e.__esModule?e:{default:e}}function x(e){return(x="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var w=(0,o.getWindow)(),C=(0,_.addNamespace)(m.removeEvent,"dxFX"),S=/^([+-])=(.*)/i,k={initAnimation:function(e,t){e.css({transitionProperty:"none"}),"string"==typeof t.from?e.addClass(t.from):$(e,t.from);var n=this,i=new v.Deferred,o=t.cleanupWhen;t.transitionAnimation={deferred:i,finish:function(){n._finishTransition(e),o?(0,v.when)(i,o).always((function(){n._cleanup(e,t)})):n._cleanup(e,t),i.resolveWith(e,[t,e])}},this._completeAnimationCallback(e,t).done((function(){t.transitionAnimation.finish()})).fail((function(){i.rejectWith(e,[t,e])})),t.duration||t.transitionAnimation.finish(),e.css("transform")},animate:function(e,t){return this._startAnimation(e,t),t.transitionAnimation.deferred.promise()},_completeAnimationCallback:function(e,t){var n,i=this,o=Date.now()+t.delay,r=new v.Deferred,s=new v.Deferred,l=new v.Deferred,u=(0,f.transitionEndEventName)()+".dxFX";t.transitionAnimation.cleanup=function(){clearTimeout(n),clearTimeout(d),a.default.off(e,u),a.default.off(e,C)},a.default.one(e,u,(function(){Date.now()-o>=t.duration&&s.reject()})),a.default.off(e,C),a.default.on(e,C,(function(){i.stop(e,t),r.reject()}));var d=setTimeout((function(){n=setTimeout((function(){l.reject()}),t.duration+t.delay+U._simulatedTransitionEndDelay),(0,v.when)(s,l).fail(function(){r.resolve()}.bind(this))}));return r.promise()},_startAnimation:function(e,t){e.css({transitionProperty:"all",transitionDelay:t.delay+"ms",transitionDuration:t.duration+"ms",transitionTimingFunction:t.easing}),"string"==typeof t.to?e[0].className+=" "+t.to:t.to&&$(e,t.to)},_finishTransition:function(e){e.css("transition","none")},_cleanup:function(e,t){t.transitionAnimation.cleanup(),"string"==typeof t.from&&(e.removeClass(t.from),e.removeClass(t.to))},stop:function(e,t,n){t&&(n?t.transitionAnimation.finish():((0,u.isPlainObject)(t.to)&&(0,d.each)(t.to,(function(t){e.css(t,e.css(t))})),this._finishTransition(e),this._cleanup(e,t)))}},D={initAnimation:function(e,t){$(e,t.from)},animate:function(e,t){var n=new v.Deferred,i=this;return t?((0,d.each)(t.to,(function(n){void 0===t.from[n]&&(t.from[n]=i._normalizeValue(e.css(n)))})),t.to.transform&&(t.from.transform=i._parseTransform(t.from.transform),t.to.transform=i._parseTransform(t.to.transform)),t.frameAnimation={to:t.to,from:t.from,currentValue:t.from,easing:(0,h.convertTransitionTimingFuncToEasing)(t.easing),duration:t.duration,startTime:(new Date).valueOf(),finish:function(){this.currentValue=this.to,this.draw(),(0,p.cancelAnimationFrame)(t.frameAnimation.animationFrameId),n.resolve()},draw:function(){if(t.draw)t.draw(this.currentValue);else{var n=(0,l.extend)({},this.currentValue);n.transform&&(n.transform=(0,d.map)(n.transform,(function(e,t){return"translate"===t?(0,c.getTranslateCss)(e):"scale"===t?"scale("+e+")":"rotate"===t.substr(0,t.length-1)?t+"("+e+"deg)":void 0})).join(" ")),e.css(n)}}},t.delay?(t.frameAnimation.startTime+=t.delay,t.frameAnimation.delayTimeout=setTimeout((function(){i._startAnimation(e,t)}),t.delay)):i._startAnimation(e,t),n.promise()):n.reject().promise()},_startAnimation:function(e,t){a.default.off(e,C),a.default.on(e,C,(function(){t.frameAnimation&&(0,p.cancelAnimationFrame)(t.frameAnimation.animationFrameId)})),this._animationStep(e,t)},_parseTransform:function(e){var t={};return(0,d.each)(e.match(/\w+\d*\w*\([^)]*\)\s*/g),(function(e,n){var i=(0,c.parseTranslate)(n),o=n.match(/scale\((.+?)\)/),a=n.match(/(rotate.)\((.+)deg\)/);i&&(t.translate=i),o&&o[1]&&(t.scale=parseFloat(o[1])),a&&a[1]&&(t[a[1]]=parseFloat(a[2]))})),t},stop:function(e,t,n){var i=t&&t.frameAnimation;i&&((0,p.cancelAnimationFrame)(i.animationFrameId),clearTimeout(i.delayTimeout),n&&i.finish(),delete t.frameAnimation)},_animationStep:function(e,t){var n=t&&t.frameAnimation;if(n){var i=(new Date).valueOf();if(i>=n.startTime+n.duration)n.finish();else{n.currentValue=this._calcStepValue(n,i-n.startTime),n.draw();var o=this;n.animationFrameId=(0,p.requestAnimationFrame)((function(){o._animationStep(e,t)}))}}},_calcStepValue:function(e,t){return function n(i,o){var a=Array.isArray(o)?[]:{};return(0,d.each)(o,(function(r,s){if("string"==typeof s&&!1===parseFloat(s,10))return!0;a[r]="object"===x(s)?n(i[r],s):function(n){var a=t/e.duration,r=t,s=1*i[n],l=o[n]-i[n],u=e.duration;return(0,h.getEasing)(e.easing)(a,r,s,l,u)}(r)})),a}(e.from,e.to)},_normalizeValue:function(e){var t=parseFloat(e,10);return!1===t?e:t}},I={initAnimation:function(){},animate:function(){return(new v.Deferred).resolve().promise()},stop:y.noop,isSynchronous:!0},T=function(e,t,n,i){(0,d.each)(["from","to"],(function(){if(!n(e[this]))throw r.default.Error("E0010",t,this,i)}))},E=function(e,t){return T(e,t,(function(e){return(0,u.isPlainObject)(e)}),"a plain object")},O={top:{my:"bottom center",at:"top center"},bottom:{my:"top center",at:"bottom center"},right:{my:"left center",at:"right center"},left:{my:"right center",at:"left center"}},A={validateConfig:function(e){E(e,"slide")},setup:function(e,t){var n=(0,c.locate)(e);if("slide"!==t.type){var i="slideIn"===t.type?t.from:t.to;i.position=(0,l.extend)({of:w},O[t.direction]),q(e,i)}this._setUpConfig(n,t.from),this._setUpConfig(n,t.to),(0,c.clearCache)(e)},_setUpConfig:function(e,t){t.left="left"in t?t.left:"+=0",t.top="top"in t?t.top:"+=0",this._initNewPosition(e,t)},_initNewPosition:function(e,t){var n={left:t.left,top:t.top};delete t.left,delete t.top;var i=this._getRelativeValue(n.left);void 0!==i?n.left=i+e.left:t.left=0,void 0!==(i=this._getRelativeValue(n.top))?n.top=i+e.top:t.top=0,t.transform=(0,c.getTranslateCss)({x:n.left,y:n.top})},_getRelativeValue:function(e){var t;if("string"==typeof e&&(t=S.exec(e)))return parseInt(t[1]+"1")*t[2]}},P={setup:function(e,t){var n,i,o=t.from,a=t.to,r="fadeOut"===t.type?1:0,s="fadeOut"===t.type?0:1,l=(0,u.isPlainObject)(o)?String(null!==(n=o.opacity)&&void 0!==n?n:r):String(o),d=(0,u.isPlainObject)(a)?String(null!==(i=a.opacity)&&void 0!==i?i:s):String(a);switch(t.skipElementInitialStyles||(l=e.css("opacity")),t.type){case"fadeIn":d=1;break;case"fadeOut":d=0}t.from={visibility:"visible",opacity:l},t.to={opacity:d}}},R={custom:{setup:function(){}},slide:A,slideIn:A,slideOut:A,fade:P,fadeIn:P,fadeOut:P,pop:{validateConfig:function(e){E(e,"pop")},setup:function(e,t){var n=t.from,i=t.to,o="opacity"in n?n.opacity:e.css("opacity"),a="opacity"in i?i.opacity:1,r="scale"in n?n.scale:0,s="scale"in i?i.scale:1;t.from={opacity:o};var l=(0,c.getTranslate)(e);t.from.transform=this._getCssTransform(l,r),t.to={opacity:a},t.to.transform=this._getCssTransform(l,s)},_getCssTransform:function(e,t){return(0,c.getTranslateCss)(e)+"scale("+t+")"}},css:{validateConfig:function(e){!function(e,t){T(e,t,(function(e){return"string"==typeof e}),"a string")}(e,"css")},setup:function(){}}},M={type:"custom",from:{},to:{},duration:400,start:y.noop,complete:y.noop,easing:"ease",delay:0},B={duration:400,easing:"ease",delay:0};function L(){var e=this.element,t=this.config;if(q(e,t.from),q(e,t.to),this.configurator.setup(e,t),e.data("dxAnimData",this),U.off&&(t.duration=0,t.delay=0),this.strategy.initAnimation(e,t),t.start){var n=(0,s.getPublicElement)(e);t.start.apply(this,[n,t])}}var V=function(){var e=this,t=e.element,n=e.config;return e.isStarted=!0,e.strategy.animate(t,n).done((function(){!function(e){var t=e.element,n=e.config;if(t.removeData("dxAnimData"),n.complete){var i=(0,s.getPublicElement)(t);n.complete.apply(this,[i,n])}e.deferred.resolveWith(this,[t,n])}(e)})).fail((function(){e.deferred.rejectWith(this,[t,n])}))},F=function(e){var t=this.element,n=this.config;clearTimeout(this.startTimeout),this.isStarted||this.start(),this.strategy.stop(t,n,e)},H=(0,_.addNamespace)(m.removeEvent,"dxFXStartAnimation"),N=function(e,t){var n="css"===t.type?B:M,o=(0,l.extend)(!0,{},n,t),s=function(e){var t=R[e.type];if(!t)throw r.default.Error("E0011",e.type);return t}(o),d=function(e){e=e||{};var t={transition:(0,f.transition)()?k:D,frame:D,noAnimation:I},n=e.strategy||"transition";return"css"!==e.type||(0,f.transition)()||(n="noAnimation"),t[n]}(o),c={element:(0,i.default)(e),config:o,configurator:s,strategy:d,isSynchronous:d.isSynchronous,setup:L,start:V,stop:F,deferred:new v.Deferred};return(0,u.isFunction)(s.validateConfig)&&s.validateConfig(o),function(e){a.default.off(e.element,H),a.default.on(e.element,H,(function(){U.stop(e.element)})),e.deferred.always((function(){a.default.off(e.element,H)}))}(c),c};function z(e){return e.data("dxAnimQueue")||[]}var W=function(e){e.removeData("dxAnimQueue")};function G(e){return!!e.data("dxAnimData")}function j(e,t){if((t=z(e)).length){var n=t.shift();0===t.length&&W(e),function(e){e.setup(),U.off||e.isSynchronous?e.start():e.startTimeout=setTimeout((function(){e.start()}));return e.deferred.promise()}(n).done((function(){G(e)||j(e)}))}}function q(e,t){if(t&&t.position){var n=(0,i.default)(w),o=0,a=0,r=g.default.calculate(e,t.position),s=e.offset(),u=e.position();u.top>s.top&&(a=n.scrollTop()),u.left>s.left&&(o=n.scrollLeft()),(0,l.extend)(t,{left:r.h.location-s.left+u.left-o,top:r.v.location-s.top+u.top-a}),delete t.position}}function $(e,t){(0,d.each)(t,(function(t,n){try{e.css(t,(0,u.isFunction)(n)?n():n)}catch(e){}}))}var U={off:!1,animationTypes:R,animate:function(e,t){var n=(0,i.default)(e);if(!n.length)return(new v.Deferred).resolve().promise();var o=N(n,t);return function(e,t){var n=z(e);(function(e,t){e.data("dxAnimQueue",t)})(e,n),n.push(t),G(e)||j(e,n)}(n,o),o.deferred.promise()},createAnimation:N,isAnimating:G,stop:function(e,t){var n=(0,i.default)(e),o=z(n);(0,d.each)(o,(function(e,t){t.config.delay=0,t.config.duration=0,t.isSynchronous=!0})),G(n)||j(n,o);var a=n.data("dxAnimData");a&&a.stop(t),n.removeData("dxAnimData"),W(n)},_simulatedTransitionEndDelay:100},K=U;t.default=K,e.exports=t.default,e.exports.default=t.default},49387:function(e,t,n){t.default=void 0;var i=n(58664),o=m(n(68374)),a=n(20576),r=n(95479),s=n(58201),l=m(n(73349)),u=n(35922),d=n(13306),c=n(37518),h=m(n(47810)),p=n(31648),f=n(60137),g=m(n(20530));function m(e){return e&&e.__esModule?e:{default:e}}var _,v=(0,s.getWindow)(),y=/left|right/,b=/top|bottom/,x=/fit|flip|none/,w=/scale\(.+?\)/,C=h.default.safari,S=function(e){var t={h:"center",v:"center"},n=(0,a.splitPair)(e);return n&&(0,r.each)(n,(function(){var e=String(this).toLowerCase();y.test(e)?t.h=e:b.test(e)&&(t.v=e)})),t},k=function(e){return(0,a.pairToObject)(e)},D=function(e){switch(e){case"center":return.5;case"right":case"bottom":return 1;default:return 0}},I=function(e){switch(e){case"left":return"right";case"right":return"left";case"top":return"bottom";case"bottom":return"top";default:return e}},T=function(e,t){var n=0;return e.myLocation<t.min&&(n+=t.min-e.myLocation),e.myLocation>t.max&&(n+=e.myLocation-t.max),n},E=function(e,t,n){return t.myLocation<n.min?"h"===e?"left":"top":t.myLocation>n.max?"h"===e?"right":"bottom":"none"},O=function(e){e.myLocation=e.atLocation+D(e.atAlign)*e.atSize-D(e.myAlign)*e.mySize+e.offset},A={fit:function(e,t){var n=!1;e.myLocation>t.max&&(e.myLocation=t.max,n=!0),e.myLocation<t.min&&(e.myLocation=t.min,n=!0),e.fit=n},flip:function(e,t){if(e.flip=!1,("center"!==e.myAlign||"center"!==e.atAlign)&&(e.myLocation<t.min||e.myLocation>t.max)){var n=(0,d.extend)({},e,{myAlign:I(e.myAlign),atAlign:I(e.atAlign),offset:-e.offset});O(n),n.oversize=T(n,t),(n.myLocation>=t.min&&n.myLocation<=t.max||e.oversize>n.oversize)&&(e.myLocation=n.myLocation,e.oversize=n.oversize,e.flip=!0)}},flipfit:function(e,t){this.flip(e,t),this.fit(e,t)},none:function(e){e.oversize=0}},P=function(){var e=(0,o.default)("<div>").css({width:100,height:100,overflow:"scroll",position:"absolute",top:-9999}).appendTo((0,o.default)("body")),t=e.get(0).offsetWidth-e.get(0).clientWidth;e.remove(),_=t},R={h:{location:0,flip:!1,fit:!1,oversize:0},v:{location:0,flip:!1,fit:!1,oversize:0}},M=function(e,t){var n=(0,o.default)(e),r=n.offset(),s=(0,d.extend)(!0,{},R,{h:{location:r.left},v:{location:r.top}});if(!t)return s;var h=S(t.my),p=S(t.at),m=(0,o.default)(t.of).length&&t.of||v,y=k(t.offset),b=function(e){var t=(0,a.splitPair)(e),n=String(t&&t[0]).toLowerCase(),i=String(t&&t[1]).toLowerCase();return x.test(n)||(n="none"),x.test(i)||(i=n),{h:n,v:i}}(t.collision),w=t.boundary,D=k(t.boundaryOffset),I={mySize:(0,i.getOuterWidth)(n),myAlign:h.h,atAlign:p.h,offset:y.h,collision:b.h,boundaryOffset:D.h},M={mySize:(0,i.getOuterHeight)(n),myAlign:h.v,atAlign:p.v,offset:y.v,collision:b.v,boundaryOffset:D.v};if(m.preventDefault)I.atLocation=m.pageX,M.atLocation=m.pageY,I.atSize=0,M.atSize=0;else if(m=(0,o.default)(m),(0,u.isWindow)(m[0]))I.atLocation=m.scrollLeft(),M.atLocation=m.scrollTop(),"phone"===g.default.real().deviceType&&m[0].visualViewport?(I.atLocation=Math.max(I.atLocation,m[0].visualViewport.offsetLeft),M.atLocation=Math.max(M.atLocation,m[0].visualViewport.offsetTop),I.atSize=m[0].visualViewport.width,M.atSize=m[0].visualViewport.height):(I.atSize=m[0].innerWidth>m[0].outerWidth?m[0].innerWidth:(0,i.getWidth)(m),M.atSize=m[0].innerHeight>m[0].outerHeight||C?m[0].innerHeight:(0,i.getHeight)(m));else if(9===m[0].nodeType)I.atLocation=0,M.atLocation=0,I.atSize=(0,i.getWidth)(m),M.atSize=(0,i.getHeight)(m);else{var B=(0,c.getBoundingRect)(m.get(0)),V=L(m);I.atLocation=V.left,M.atLocation=V.top,I.atSize=Math.max(B.width,(0,i.getOuterWidth)(m)),M.atSize=Math.max(B.height,(0,i.getOuterHeight)(m))}O(I),O(M);var F=function(){var e=(0,o.default)(v),t=(0,i.getWidth)(e),n=(0,i.getHeight)(e),a=e.scrollLeft(),r=e.scrollTop(),s=l.default.getDocumentElement(),u=f.touch?s.clientWidth/t:1,d=f.touch?s.clientHeight/n:1;void 0===_&&P();var c=t,h=n;if(w){var p=(0,o.default)(w),g=p.offset();a=g.left,r=g.top,c=(0,i.getWidth)(p),h=(0,i.getHeight)(p)}return{h:{min:a+I.boundaryOffset,max:a+c/u-I.mySize-I.boundaryOffset},v:{min:r+M.boundaryOffset,max:r+h/d-M.mySize-M.boundaryOffset}}}();I.oversize=T(I,F.h),M.oversize=T(M,F.v),I.collisionSide=E("h",I,F.h),M.collisionSide=E("v",M,F.v),A[I.collision]&&A[I.collision](I,F.h),A[M.collision]&&A[M.collision](M,F.v);var H=function(e){return t.precise?e:Math.round(e)};return(0,d.extend)(!0,s,{h:{location:H(I.myLocation),oversize:H(I.oversize),fit:I.fit,flip:I.flip,collisionSide:I.collisionSide},v:{location:H(M.myLocation),oversize:H(M.oversize),fit:M.fit,flip:M.flip,collisionSide:M.collisionSide},precise:t.precise}),s},B=function(e,t,n,i,o){(0,u.isDefined)(e.style)&&!l.default.isNode(e.style)?e.style.transform=o?n.replace(t,""):n:e.setAttribute("style",o?i.replace(t,""):i)},L=function e(t){var n,i,o,a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:t,r=a.get(0);if(!r)return t.offset();var s,l=(null===(n=r.getAttribute)||void 0===n?void 0:n.call(r,"style"))||"",u=null===(i=r.style)||void 0===i?void 0:i.transform,d=null===(o=l.match(w))||void 0===o?void 0:o[0];return d?(B(r,d,u,l,!0),s=e(t,a.parent()),B(r,d,u,l,!1)):s=e(t,a.parent()),s},V=function(e,t){var n=(0,o.default)(e);if(!t)return n.offset();(0,p.resetPosition)(n,!0);var i=L(n),a=t.h&&t.v?t:M(n,t),r=function(e){return t.precise?e:Math.round(e)};return(0,p.move)(n,{left:a.h.location-r(i.left),top:a.v.location-r(i.top)}),a};V.inverseAlign||(V.inverseAlign=I),V.normalizeAlign||(V.normalizeAlign=S);var F={calculateScrollbarWidth:P,calculate:M,setup:V,offset:function(e){return e=(0,o.default)(e).get(0),(0,u.isWindow)(e)?null:e&&"pageY"in e&&"pageX"in e?{top:e.pageY,left:e.pageX}:(0,o.default)(e).offset()}};t.default=F,e.exports=t.default,e.exports.default=t.default},42814:function(e,t,n){t.presets=t.PresetCollection=void 0;var i=n(58664),o=n(44297),a=n(95479),r=n(13306),s=u(n(20530)),l=u(n(87209));function u(e){return e&&e.__esModule?e:{default:e}}var d={forward:" dx-forward",backward:" dx-backward",none:" dx-no-direction",undefined:" dx-no-direction"},c=o.Component.inherit({ctor:function(){this.callBase.apply(this,arguments),this._registeredPresets=[],this.resetToDefaults()},_getDefaultOptions:function(){return(0,r.extend)(this.callBase(),{defaultAnimationDuration:400,defaultAnimationDelay:0,defaultStaggerAnimationDuration:300,defaultStaggerAnimationDelay:40,defaultStaggerAnimationStartDelay:500})},_defaultOptionsRules:function(){return this.callBase().concat([{device:function(e){return e.phone},options:{defaultStaggerAnimationDuration:350,defaultStaggerAnimationDelay:50,defaultStaggerAnimationStartDelay:0}},{device:function(){return s.default.current().android||s.default.real.android},options:{defaultAnimationDelay:100}}])},_getPresetOptionName:function(e){return"preset_"+e},_createAndroidSlideAnimationConfig:function(e,t){var n=this,o=function(e){return{type:"slide",delay:void 0===e.delay?n.option("defaultAnimationDelay"):e.delay,duration:void 0===e.duration?n.option("defaultAnimationDuration"):e.duration}};return{enter:function(n,a){var r=(0,i.getWidth)(n.parent())*t,s=a.direction,u=o(a);return u.to={left:0,opacity:1},u.from="forward"===s?{left:r,opacity:e}:"backward"===s?{left:-r,opacity:e}:{left:0,opacity:0},l.default.createAnimation(n,u)},leave:function(n,a){var r=(0,i.getWidth)(n.parent())*t,s=a.direction,u=o(a);return u.from={left:0,opacity:1},u.to="forward"===s?{left:-r,opacity:e}:"backward"===s?{left:r,opacity:e}:{left:0,opacity:0},l.default.createAnimation(n,u)}}},_createOpenDoorConfig:function(){var e=this,t=function(t){return{type:"css",extraCssClasses:"dx-opendoor-animation",delay:void 0===t.delay?e.option("defaultAnimationDelay"):t.delay,duration:void 0===t.duration?e.option("defaultAnimationDuration"):t.duration}};return{enter:function(e,n){var i=n.direction,o=t(n);return o.delay="none"===i?o.delay:o.duration,o.from="dx-enter dx-opendoor-animation"+d[i],o.to="dx-enter-active",l.default.createAnimation(e,o)},leave:function(e,n){var i=n.direction,o=t(n);return o.from="dx-leave dx-opendoor-animation"+d[i],o.to="dx-leave-active",l.default.createAnimation(e,o)}}},_createWinPopConfig:function(){var e=this,t={type:"css",extraCssClasses:"dx-win-pop-animation",duration:e.option("defaultAnimationDuration")};return{enter:function(n,i){var o=t,a=i.direction;return o.delay="none"===a?e.option("defaultAnimationDelay"):e.option("defaultAnimationDuration")/2,o.from="dx-enter dx-win-pop-animation"+d[a],o.to="dx-enter-active",l.default.createAnimation(n,o)},leave:function(n,i){var o=t,a=i.direction;return o.delay=e.option("defaultAnimationDelay"),o.from="dx-leave dx-win-pop-animation"+d[a],o.to="dx-leave-active",l.default.createAnimation(n,o)}}},resetToDefaults:function(){this.clear(),this.registerDefaultPresets(),this.applyChanges()},clear:function(e){var t=this,n=[];(0,a.each)(this._registeredPresets,(function(i,o){e&&e!==o.name?n.push(o):t.option(t._getPresetOptionName(o.name),void 0)})),this._registeredPresets=n,this.applyChanges()},registerPreset:function(e,t){this._registeredPresets.push({name:e,config:t})},applyChanges:function(){var e=this,t=[];(0,a.each)(this._registeredPresets,(function(n,i){var o={device:i.config.device,options:{}};o.options[e._getPresetOptionName(i.name)]=i.config.animation,t.push(o)})),this._setOptionsByDevice(t)},getPreset:function(e){for(var t=e;"string"==typeof t;)t=this.option(this._getPresetOptionName(t));return t},registerDefaultPresets:function(){this.registerPreset("pop",{animation:{extraCssClasses:"dx-android-pop-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("openDoor",{animation:this._createOpenDoorConfig()}),this.registerPreset("win-pop",{animation:this._createWinPopConfig()}),this.registerPreset("fade",{animation:{extraCssClasses:"dx-fade-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("slide",{device:function(){return s.default.current().android||s.default.real.android},animation:this._createAndroidSlideAnimationConfig(1,1)}),this.registerPreset("slide",{device:function(){return!s.default.current().android&&!s.default.real.android},animation:{extraCssClasses:"dx-slide-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("ios7-slide",{animation:{extraCssClasses:"dx-ios7-slide-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("overflow",{animation:{extraCssClasses:"dx-overflow-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("ios7-toolbar",{device:function(){return!s.default.current().android&&!s.default.real.android},animation:{extraCssClasses:"dx-ios7-toolbar-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("ios7-toolbar",{device:function(){return s.default.current().android||s.default.real.android},animation:this._createAndroidSlideAnimationConfig(0,.4)}),this.registerPreset("stagger-fade",{animation:{extraCssClasses:"dx-fade-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-slide",{animation:{extraCssClasses:"dx-slide-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-fade-slide",{animation:{extraCssClasses:"dx-fade-slide-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-drop",{animation:{extraCssClasses:"dx-drop-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-fade-drop",{animation:{extraCssClasses:"dx-fade-drop-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-fade-rise",{animation:{extraCssClasses:"dx-fade-rise-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-3d-drop",{animation:{extraCssClasses:"dx-3d-drop-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-fade-zoom",{animation:{extraCssClasses:"dx-fade-zoom-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}})}});t.PresetCollection=c;var h=new c;t.presets=h},52431:function(e,t,n){t.TransitionExecutor=void 0;var i=h(n(68374)),o=h(n(38377)),a=n(13306),r=n(20576),s=n(35922),l=n(95479),u=h(n(87209)),d=n(42814),c=n(62754);function h(e){return e&&e.__esModule?e:{default:e}}var p={forward:" dx-forward",backward:" dx-backward",none:" dx-no-direction",undefined:" dx-no-direction"},f=o.default.inherit({ctor:function(){this._accumulatedDelays={enter:0,leave:0},this._animations=[],this.reset()},_createAnimations:function(e,t,n,o){var a=this,r=[];n=n||{};var s=this._prepareElementAnimationConfig(t,n,o);return s&&e.each((function(){var e=a._createAnimation((0,i.default)(this),s,n);e&&(e.element.addClass("dx-animating"),e.setup(),r.push(e))})),r},_prepareElementAnimationConfig:function(e,t,n){var i;if("string"==typeof e){var o=e;e=d.presets.getPreset(o)}if(e)if((0,s.isFunction)(e[n]))i=e[n];else{if(!(i=(0,a.extend)({skipElementInitialStyles:!0,cleanupWhen:this._completePromise},e,t)).type||"css"===i.type){var r="dx-"+n,l=(i.extraCssClasses?" "+i.extraCssClasses:"")+p[i.direction];i.type="css",i.from=(i.from||r)+l,i.to=i.to||r+"-active"}i.staggerDelay=i.staggerDelay||0,i.delay=i.delay||0,i.staggerDelay&&(i.delay+=this._accumulatedDelays[n],this._accumulatedDelays[n]+=i.staggerDelay)}else i=void 0;return i},_createAnimation:function(e,t,n){var i;return(0,s.isPlainObject)(t)?i=u.default.createAnimation(e,t):(0,s.isFunction)(t)&&(i=t(e,n)),i},_startAnimations:function(){for(var e=this._animations,t=0;t<e.length;t++)e[t].start()},_stopAnimations:function(e){for(var t=this._animations,n=0;n<t.length;n++)t[n].stop(e)},_clearAnimations:function(){for(var e=this._animations,t=0;t<e.length;t++)e[t].element.removeClass("dx-animating");this._animations.length=0},reset:function(){this._accumulatedDelays.enter=0,this._accumulatedDelays.leave=0,this._clearAnimations(),this._completeDeferred=new c.Deferred,this._completePromise=this._completeDeferred.promise()},enter:function(e,t,n){var i=this._createAnimations(e,t,n,"enter");this._animations.push.apply(this._animations,i)},leave:function(e,t,n){var i=this._createAnimations(e,t,n,"leave");this._animations.push.apply(this._animations,i)},start:function(){var e,t=this;if(this._animations.length){var n=(0,l.map)(this._animations,(function(e){var t=new c.Deferred;return e.deferred.always((function(){t.resolve()})),t.promise()}));e=c.when.apply(i.default,n).always((function(){t._completeDeferred.resolve(),t.reset()})),(0,r.executeAsync)((function(){t._startAnimations()}))}else t.reset(),e=(new c.Deferred).resolve().promise();return e},stop:function(e){this._stopAnimations(e)}});t.TransitionExecutor=f},31648:function(e,t,n){t.resetPosition=t.parseTranslate=t.move=t.locate=t.getTranslateCss=t.getTranslate=t.clearCache=void 0;var i,o=(i=n(68374))&&i.__esModule?i:{default:i},a=n(97906),r=n(35922);var s=/matrix(3d)?\((.+?)\)/,l=/translate(?:3d)?\((.+?)\)/;function u(e){return"string"===(0,r.type)(e)&&"%"===e[e.length-1]}function d(e,t){e.length&&(0,a.data)(e.get(0),"dxTranslator",t)}t.locate=function(e){e=(0,o.default)(e);var t=p(e);return{left:t.x,top:t.y}};var c=function(e){e.length&&(0,a.removeData)(e.get(0),"dxTranslator")};t.clearCache=c;var h=function(e){return e.x=e.x||0,e.y=e.y||0,"translate("+(u(e.x)?e.x:e.x+"px")+", "+(u(e.y)?e.y:e.y+"px")+")"};t.getTranslateCss=h;var p=function(e){var t=e.length?(0,a.data)(e.get(0),"dxTranslator"):null;if(!t){var n=(e.css("transform")||h({x:0,y:0})).match(s),i=n&&n[1];n?(n=n[2].split(","),"3d"===i?n=n.slice(12,15):(n.push(0),n=n.slice(4,7))):n=[0,0,0],d(e,t={x:parseFloat(n[0]),y:parseFloat(n[1]),z:parseFloat(n[2])})}return t};t.getTranslate=p;t.move=function(e,t){e=(0,o.default)(e);var n,i=t.left,a=t.top;void 0===i?(n=p(e)).y=a||0:void 0===a?(n=p(e)).x=i||0:d(e,n={x:i||0,y:a||0,z:0}),e.css({transform:h(n)}),(u(i)||u(a))&&c(e)};t.resetPosition=function(e,t){var n;e=(0,o.default)(e);var i={left:0,top:0,transform:"none"};t&&(n=e.css("transition"),i.transition="none"),e.css(i),c(e),t&&(e.get(0).offsetHeight,e.css("transition",n))};t.parseTranslate=function(e){var t=e.match(l);if(t&&t[1])return t=t[1].split(","),t={x:parseFloat(t[0]),y:parseFloat(t[1]),z:parseFloat(t[2])}}},16354:function(e,t,n){t.default=void 0,n(85866),n(66312);var i,o=(i=n(36991))&&i.__esModule?i:{default:i},a=n(80566),r=n(95683);o.default.integration={},o.default.integration.EventsStrategy=a.EventsStrategy,o.default.integration.Options=r.Options;var s=o.default;t.default=s,e.exports=t.default,e.exports.default=t.default},36991:function(e,t,n){var i=n(58201).getWindow(),o=i.DevExpress=i.DevExpress||{},a=o.errors=n(17381);if(o._DEVEXTREME_BUNDLE_INITIALIZED)throw a.Error("E0024");o._DEVEXTREME_BUNDLE_INITIALIZED=!0,o.clientExporter=n(78292),o.excelExporter=n(2994),o.pdfExporter=n(44194),o.VERSION=n(36739).version,o.Class=n(38377),o.DOMComponent=n(13046),o.Component=n(44297).Component,o.registerComponent=n(99393),o.devices=n(20530),o.Color=n(52752);var r=n(90057);o.utils={},o.utils.requestAnimationFrame=r.requestAnimationFrame,o.utils.cancelAnimationFrame=r.cancelAnimationFrame,o.utils.initMobileViewport=n(88185).p,o.utils.getTimeZones=n(88673).Z,o.utils.extendFromObject=n(13306).extendFromObject,o.utils.triggerShownEvent=n(80506).triggerShownEvent,o.utils.triggerHidingEvent=n(80506).triggerHidingEvent,o.utils.resetActiveElement=n(3532).resetActiveElement,o.utils.findBestMatches=n(20576).findBestMatches,o.createQueue=n(59504).create,o.utils.dom=n(3532),o.utils.common=n(20576),o.utils.date=n(91198),o.utils.browser=n(47810),o.utils.inflector=n(78008),o.utils.iterator=n(95479),o.utils.readyCallbacks=n(24311),o.utils.resizeCallbacks=n(55814),o.utils.console=n(30869),o.utils.string=n(68752),o.utils.support=n(60137),o.utils.ajax=n(37208),o.viewPort=n(77695).value,o.hideTopOverlay=n(60628),o.formatHelper=n(30343),o.config=n(80209),o.animationPresets=n(42814).presets,o.fx=n(87209),o.TransitionExecutor=n(52431).TransitionExecutor,o.AnimationPresetCollection=n(42814).PresetCollection,o.events=n(66365),o.events.click=n(95429),o.events.utils=n(39611),o.events.GestureEmitter=n(98621),o.localization=n(94484),o.templateRendered=n(81033).renderedCallbacks,o.setTemplateEngine=n(72987).setTemplateEngine,e.exports=o},86635:function(e,t,n){var i=n(36991),o=n(17381);e.exports=i.data=i.data||{},Object.defineProperty(i.data,"errorHandler",{get:function(){return n(18438).errorHandler},set:function(e){o.log("W0003","DevExpress.data","errorHandler","21.1","Use the 'setErrorHandler' method instead"),n(18438).setErrorHandler(e)}}),Object.defineProperty(i.data,"_errorHandler",{get:function(){return n(18438).handleError},set:function(e){o.log("W0003","DevExpress.data","_errorHandler","21.1","Use the 'setErrorHandler' method instead"),n(18438).setErrorHandler(e)}}),i.data.setErrorHandler=n(18438).setErrorHandler,i.data.DataSource=n(33546),i.data.query=n(96687),i.data.Store=n(67403),i.data.ArrayStore=n(26562),i.data.CustomStore=n(88036),i.data.LocalStore=n(82837),i.data.base64_encode=n(16454).base64_encode,i.data.applyChanges=n(36893),i.data.Guid=n(73176),i.data.utils={},i.data.utils.compileGetter=n(47617).compileGetter,i.data.utils.compileSetter=n(47617).compileSetter,i.EndpointSelector=n(8162),i.data.queryImpl=n(77549).queryImpl,i.data.queryAdapters=n(16135);var a=n(16454);i.data.utils.normalizeBinaryCriterion=a.normalizeBinaryCriterion,i.data.utils.normalizeSortingInfo=a.normalizeSortingInfo,i.data.utils.errorMessageFromXhr=a.errorMessageFromXhr,i.data.utils.aggregators=a.aggregators,i.data.utils.keysEqual=a.keysEqual,i.data.utils.isDisjunctiveOperator=a.isDisjunctiveOperator,i.data.utils.isConjunctiveOperator=a.isConjunctiveOperator,i.data.utils.processRequestResultLock=a.processRequestResultLock,i.data.utils.toComparable=n(47617).toComparable,i.data.utils.multiLevelGroup=n(99236).multiLevelGroup,i.data.utils.arrangeSortingInfo=n(99236).arrangeSortingInfo,i.data.utils.normalizeDataSourceOptions=n(9234).normalizeDataSourceOptions},72343:function(e,t,n){n(86635),DevExpress.data.ODataStore=n(341),DevExpress.data.ODataContext=n(47256),DevExpress.data.utils=DevExpress.data.utils||{},DevExpress.data.utils.odata={},DevExpress.data.utils.odata.keyConverters=n(77869).keyConverters,DevExpress.data.EdmLiteral=n(77869).EdmLiteral;var i=n(77869);DevExpress.data.utils.odata.serializePropName=i.serializePropName,DevExpress.data.utils.odata.serializeValue=i.serializeValue,DevExpress.data.utils.odata.serializeKey=i.serializeKey,DevExpress.data.utils.odata.sendRequest=i.sendRequest,DevExpress.data.queryAdapters=DevExpress.data.queryAdapters||{},DevExpress.data.queryAdapters.odata=n(54263).odata},56208:function(e,t,n){var i=u(n(36991)),o=u(n(49816)),a=u(n(45765)),r=u(n(4323)),s=u(n(41332)),l=u(n(98831));function u(e){return e&&e.__esModule?e:{default:e}}e.exports=i.default.fileManagement=i.default.fileManagement||{},i.default.fileManagement.FileSystemError=o.default,i.default.fileManagement.FileSystemItem=a.default,i.default.fileManagement.ObjectFileSystemProvider=r.default,i.default.fileManagement.RemoteFileSystemProvider=s.default,i.default.fileManagement.CustomFileSystemProvider=l.default},85357:function(e,t,n){var i=n(36991);n(78475),n(71582),n(49281),n(74872),n(46949),n(908),n(60316),n(7239),n(95429),n(49166),n(85272),n(23174),n(11699),n(24028),n(93786),n(34309),n(91093),e.exports=i},94620:function(e,t,n){var i=n(85357).data=n(86635);i.odata=n(72343),e.exports=i},70527:function(e,t,n){var i,o=(i=n(85357))&&i.__esModule?i:{default:i};var a=n(56208);o.default.fileManagement=a,e.exports=a},66312:function(e,t,n){var i=n(85357);n(94620);var o=i.viz=n(20802);o.currentTheme=n(86231).currentTheme,o.registerTheme=n(86231).registerTheme,o.exportFromMarkup=n(5259).exportFromMarkup,o.getMarkup=n(5259).getMarkup,o.exportWidgets=n(5259).exportWidgets,o.currentPalette=n(23696).currentPalette,o.getPalette=n(23696).getPalette,o.generateColors=n(23696).generateColors,o.registerPalette=n(23696).registerPalette,o.refreshTheme=n(86231).refreshTheme,o.dxChart=n(99511),o.dxPieChart=n(72111),o.dxPolarChart=n(80919),o.dxLinearGauge=n(99630),o.dxCircularGauge=n(39847),o.dxBarGauge=n(45888),o.dxRangeSelector=n(82879),o.dxVectorMap=n(81849),o.map={},o.map.sources={},o.map.projection=n(102).projection,o.dxSparkline=n(43759),o.dxBullet=n(88950),o.dxTreeMap=n(15584),o.dxFunnel=n(30187),o.dxSankey=n(34377),o.BaseWidget=n(59063),o.getTheme=n(86231).getTheme,o.findTheme=n(86231).getTheme,o.refreshAll=n(86231).refreshTheme,o.refreshPaths=n(34434).refreshPaths,o.gauges={__internals:{}},o._dashboard={},o._dashboard.Renderer=n(56453).Renderer,o._dashboard.SvgElement=n(56453).SvgElement,o._dashboard.patchFontOptions=n(19157).patchFontOptions,e.exports=o},85866:function(e,t,n){n(64178),n(2025)},50779:function(e,t,n){var i=n(85357);n(94620),n(70527);var o=i.ui=n(26864);o.themes=n(75811),o.setTemplateEngine=n(72987).setTemplateEngine,o.dialog=n(15029),o.notify=n(59958),o.repaintFloatingActionButton=n(81374),o.hideToasts=n(33964),o.dxActionSheet=n(81476),o.dxAutocomplete=n(65418),o.dxBox=n(55551),o.dxButton=n(63008),o.dxDropDownButton=n(45231),o.dxButtonGroup=n(28236),o.dxCalendar=n(26559),o.dxCheckBox=n(18859),o.dxColorBox=n(4278),o.dxDateBox=n(29589),o.dxDrawer=n(45065),o.dxDeferRendering=n(28414),o.dxDropDownBox=n(36646),o.dxDropDownMenu=n(79561),o.dxFileUploader=n(53749),o.dxForm=n(17737),o.dxGallery=n(49433),o.dxHtmlEditor=n(9619),o.dxList=n(86e3),o.dxLoadIndicator=n(2492),o.dxLoadPanel=n(97218),o.dxLookup=n(55935),o.dxMap=n(64304),o.dxMultiView=n(86478),o.dxNavBar=n(65089),o.dxNumberBox=n(34171),o.dxOverlay=n(89799),o.dxPopover=n(22348),o.dxPopup=n(39114),o.dxProgressBar=n(28080),o.dxRadioGroup=n(14305),o.dxRangeSlider=n(36992),o.dxResizable=n(46743),o.dxResponsiveBox=n(21643),o.dxScrollView=n(4741),o.dxSelectBox=n(78665),o.dxSlider=n(97834),o.dxSpeedDialAction=n(17017),o.dxSwitch=n(31609),o.dxTabPanel=n(21807),o.dxTabs=n(13453),o.dxTagBox=n(31362),o.dxTextArea=n(51237),o.dxTextBox=n(29837),o.dxTileView=n(93094),o.dxToast=n(37748),o.dxToolbar=n(71042),o.dxTooltip=n(94920),o.dxTrackBar=n(39661),o.dxDraggable=n(42160),o.dxSortable=n(66843),i.validationEngine=n(90964),o.dxValidationSummary=n(97289),o.dxValidationGroup=n(4401),o.dxValidator=n(39562),n(52935),o.CollectionWidget=n(11050),o.dxDropDownEditor=n(44687),e.exports=o},64178:function(e,t,n){var i=n(50779);i.dxSlideOut=n(85643),i.dxSlideOutView=n(92719)},2025:function(e,t,n){var i=n(94620),o=n(50779);o.dxAccordion=n(76219),o.dxContextMenu=n(10042),o.dxDataGrid=n(1186),o.dxDataGridNext=n(84063),o.dxTreeList=n(82655),o.dxMenu=n(76995),o.dxPivotGrid=n(96089),o.dxPivotGridFieldChooser=n(32014),i.PivotGridDataSource=n(98713),i.XmlaStore=n(9170),o.dxScheduler=n(9508),o.dxTreeView=n(30254),o.dxFilterBuilder=n(20301),o.dxFileManager=n(87446),o.dxDiagram=n(52311),o.dxGantt=n(33465)},26864:function(e,t,n){n(36991),e.exports=DevExpress.ui={}},20802:function(e,t,n){n(36991),e.exports=DevExpress.viz=DevExpress.viz||{}},52752:function(e,t){t.default=void 0;var n={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightslategrey:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"663399",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"},i=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(e){return[parseInt(e[1],10),parseInt(e[2],10),parseInt(e[3],10)]}},{re:/^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,process:function(e){return[parseInt(e[1],10),parseInt(e[2],10),parseInt(e[3],10),parseFloat(e[4])]}},{re:/^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,process:function(e){return[parseInt(e[1],16),parseInt(e[2],16),parseInt(e[3],16)]}},{re:/^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,process:function(e){return[parseInt(e[1]+e[1],16),parseInt(e[2]+e[2],16),parseInt(e[3]+e[3],16)]}},{re:/^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(e){var t=parseInt(e[1],10),n=parseInt(e[2],10),i=parseInt(e[3],10),o=s(t,n,i);return[o[0],o[1],o[2],1,[t,n,i]]}},{re:/^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(e){var t=parseInt(e[1],10),n=parseInt(e[2],10),i=parseInt(e[3],10),o=d(t,n,i);return[o[0],o[1],o[2],1,null,[t,n,i]]}}],o=Math.round;function a(e){var t;this.baseColor=e,e&&(t=String(e).toLowerCase().replace(/ /g,""),t=function(e){if("transparent"===e)return[0,0,0,0];for(var t,n=0,o=i.length;n<o;++n)if(t=i[n].re.exec(e))return i[n].process(t);return null}(t=n[t]?"#"+n[t]:t)),t||(this.colorIsInvalid=!0),t=t||{},this.r=r(t[0]),this.g=r(t[1]),this.b=r(t[2]),this.a=r(t[3],1,1),t[4]?this.hsv={h:t[4][0],s:t[4][1],v:t[4][2]}:this.hsv=function(e,t,n){var i,o,a=Math.max(e,t,n),r=Math.min(e,t,n),s=a-r,l=a;if(o=0===a?0:1-r/a,a===r)i=0;else switch(a){case e:i=(t-n)/s*60,t<n&&(i+=360);break;case t:i=(n-e)/s*60+120;break;case n:i=(e-t)/s*60+240}return o*=100,l*=100/255,{h:Math.round(i),s:Math.round(o),v:Math.round(l)}}(this.r,this.g,this.b),t[5]?this.hsl={h:t[5][0],s:t[5][1],l:t[5][2]}:this.hsl=function(e,t,n){e=c(e,255),t=c(t,255),n=c(n,255);var i,a,r=Math.max(e,t,n),s=Math.min(e,t,n),l=r+s,u=l/2;if(r===s)i=a=0;else{var d=r-s;a=u>.5?d/(2-l):d/l,i=function(e,t,n,i){switch(Math.max(e,t,n)){case e:return(t-n)/i+(t<n?6:0);case t:return(n-e)/i+2;case n:return(e-t)/i+4}}(e,t,n,d),i/=6}return{h:o(360*i),s:o(100*a),l:o(100*u)}}(this.r,this.g,this.b)}function r(e,t,n){return t=t||0,n=n||255,e<0||isNaN(e)?t:e>n?n:e}function s(e,t,n){var i,o,a,r=(100-t)*n/100,s=e%60/60*(n-r),l=r+s,u=n-s;switch(Math.floor(e%360/60)){case 0:i=n,o=l,a=r;break;case 1:i=u,o=n,a=r;break;case 2:i=r,o=n,a=l;break;case 3:i=r,o=u,a=n;break;case 4:i=l,o=r,a=n;break;case 5:i=n,o=r,a=u}return[Math.round(2.55*i),Math.round(2.55*o),Math.round(2.55*a)]}function l(e,t){var n=t;return"r"===e&&(n=t+1/3),"b"===e&&(n=t-1/3),n}function u(e,t,n){return(n=function(e){return e<0&&(e+=1),e>1&&(e-=1),e}(n))<1/6?e+6*(t-e)*n:n<.5?t:n<2/3?e+(t-e)*(2/3-n)*6:e}function d(e,t,n){var i,a,r;if(e=c(e,360),t=c(t,100),n=c(n,100),0===t)i=a=r=n;else{var s=n<.5?n*(1+t):n+t-n*t,d=2*n-s;i=u(d,s,l("r",e)),a=u(d,s,l("g",e)),r=u(d,s,l("b",e))}return[o(255*i),o(255*a),o(255*r)]}function c(e,t){return e=Math.min(t,Math.max(0,parseFloat(e))),Math.abs(e-t)<1e-6?1:e%t/parseFloat(t)}function h(e,t,n){return t=t||0,n=n||255,!(e%1!=0||e<t||e>n||"number"!=typeof e||isNaN(e))}a.prototype={constructor:a,highlight:function(e){return e=e||10,this.alter(e).toHex()},darken:function(e){return e=e||10,this.alter(-e).toHex()},alter:function(e){var t=new a;return t.r=r(this.r+e),t.g=r(this.g+e),t.b=r(this.b+e),t},blend:function(e,t){var n=e instanceof a?e:new a(e),i=new a;return i.r=r(o(this.r*(1-t)+n.r*t)),i.g=r(o(this.g*(1-t)+n.g*t)),i.b=r(o(this.b*(1-t)+n.b*t)),i},toHex:function(){return e=this.r,t=this.g,n=this.b,"#"+(16777216|e<<16|t<<8|n).toString(16).slice(1);var e,t,n},getPureColor:function(){return new a("rgb("+s(this.hsv.h,100,100).join(",")+")")},isValidHex:function(e){return/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(e)},isValidRGB:function(e,t,n){return!!(h(e)&&h(t)&&h(n))},isValidAlpha:function(e){return!(isNaN(e)||e<0||e>1||"number"!=typeof e)},colorIsInvalid:!1,fromHSL:function(e){var t=new a,n=d(e.h,e.s,e.l);return t.r=n[0],t.g=n[1],t.b=n[2],t}};var p=a;t.default=p,e.exports=t.default,e.exports.default=t.default},62414:function(e,t,n){t.default=void 0;var i,o=(i=n(68374))&&i.__esModule?i:{default:i},a=n(58201),r=n(35922),s=n(95479);var l=function(){function e(e,t){t=t||{},this._action=e,this._context=t.context||(0,a.getWindow)(),this._beforeExecute=t.beforeExecute,this._afterExecute=t.afterExecute,this._component=t.component,this._validatingTargetName=t.validatingTargetName;var n=this._excludeValidators={};if(t.excludeValidators)for(var i=0;i<t.excludeValidators.length;i++)n[t.excludeValidators[i]]=!0}var t=e.prototype;return t.execute=function(){var e={action:this._action,args:Array.prototype.slice.call(arguments),context:this._context,component:this._component,validatingTargetName:this._validatingTargetName,cancel:!1,handled:!1},t=this._beforeExecute,n=this._afterExecute,i=e.args[0]||{};if(this._validateAction(e)&&(null==t||t.call(this._context,e),!e.cancel)){var o=this._executeAction(e);if(!i.cancel)return null==n||n.call(this._context,e),o}},t._validateAction=function(t){var n=this._excludeValidators,i=e.executors;for(var o in i)if(!n[o]){var a,r=i[o];if(null===(a=r.validate)||void 0===a||a.call(r,t),t.cancel)return!1}return!0},t._executeAction=function(t){var n,i=e.executors;for(var o in i){var a,r=i[o];if(null===(a=r.execute)||void 0===a||a.call(r,t),t.handled){n=t.result;break}}return n},e.registerExecutor=function(t,n){(0,r.isPlainObject)(t)?(0,s.each)(t,e.registerExecutor):e.executors[t]=n},e.unregisterExecutor=function(){for(var t=arguments.length,n=new Array(t),i=0;i<t;i++)n[i]=arguments[i];(0,s.each)(n,(function(){delete e.executors[this]}))},e}();t.default=l,l.executors={};var u=function(e){return function(t){if(t.args.length){var n=t.args[0],i=n[t.validatingTargetName]||n.element;i&&e((0,o.default)(i))&&(t.cancel=!0)}}};l.registerExecutor({disabled:{validate:u((function(e){return e.is(".dx-state-disabled, .dx-state-disabled *")}))},readOnly:{validate:u((function(e){return e.is(".dx-state-readonly, .dx-state-readonly *:not(.dx-state-independent)")}))},undefined:{execute:function(e){e.action||(e.result=void 0,e.handled=!0)}},func:{execute:function(e){(0,r.isFunction)(e.action)&&(e.result=e.action.call(e.context,e.args[0]),e.handled=!0)}}}),e.exports=t.default,e.exports.default=t.default},38377:function(e,t,n){t.default=void 0;var i,o=(i=n(17381))&&i.__esModule?i:{default:i},a=n(35922);var r,s=function(e,t,n){return function(){var i=this.callBase;this.callBase=e[t];try{return n.apply(this,arguments)}finally{this.callBase=i}}},l=function(e){var t,n,i;if(!e)return this;for(n in e)i=e[n],t="function"==typeof this.prototype[n]&&"function"==typeof i,this.prototype[n]=t?s(this.parent.prototype,n,i):i;return this},u=function(){var e,t,n,i=this,o=Object.prototype.hasOwnProperty.bind(i),a=!o("_includedCtors")&&!o("_includedPostCtors");for(a&&(i._includedCtors=i._includedCtors.slice(0),i._includedPostCtors=i._includedPostCtors.slice(0)),n=0;n<arguments.length;n++)for(t in(e=arguments[n]).ctor&&i._includedCtors.push(e.ctor),e.postCtor&&i._includedPostCtors.push(e.postCtor),e)"ctor"!==t&&"postCtor"!==t&&"default"!==t&&(i.prototype[t]=e[t]);return i},d=function(e){if(!Object.prototype.hasOwnProperty.bind(this)("parent")&&this.parent){var t=Object.getPrototypeOf(this);return t===e||t.subclassOf(e)}return this.parent===e||!(!this.parent||!this.parent.subclassOf)&&this.parent.subclassOf(e)},c=function(){throw o.default.Error("E0001")},h=(r=Object.prototype.hasOwnProperty,function(e,t){for(var n in e){if(!r.call(e,n))return;t[n]=e[n]}}),p=function(){};p.inherit=function(e){var t=function(){if(!this||(0,a.isWindow)(this)||"function"!=typeof this.constructor)throw o.default.Error("E0003");var e,t=this,n=t.ctor,i=t.constructor._includedCtors,r=t.constructor._includedPostCtors;for(e=0;e<i.length;e++)i[e].call(t);for(n&&n.apply(t,arguments),e=0;e<r.length;e++)r[e].call(t)};return t.prototype=function(e){var t=function(){};return t.prototype=e.prototype,new t}(this),h(this,t),t.inherit=this.inherit,t.abstract=c,t.redefine=l,t.include=u,t.subclassOf=d,t.parent=this,t._includedCtors=this._includedCtors?this._includedCtors.slice(0):[],t._includedPostCtors=this._includedPostCtors?this._includedPostCtors.slice(0):[],t.prototype.constructor=t,t.redefine(e),t},p.abstract=c;var f=p;t.default=f,e.exports=t.default,e.exports.default=t.default},44297:function(e,t,n){t.Component=void 0;var i=_(n(80209)),o=n(13306),a=n(95683),r=n(45434),s=_(n(38377)),l=_(n(62414)),u=_(n(17381)),d=_(n(44504)),c=n(80566),h=n(9321),p=n(90889),f=n(35922),g=n(20576),m=n(47617);function _(e){return e&&e.__esModule?e:{default:e}}var v=function(e){return e.charAt(2).toLowerCase()+e.substr(3)},y=s.default.inherit({_setDeprecatedOptions:function(){this._deprecatedOptions={}},_getDeprecatedOptions:function(){return this._deprecatedOptions},_getDefaultOptions:function(){return{onInitialized:null,onOptionChanged:null,onDisposing:null,defaultOptionsRules:null}},_defaultOptionsRules:function(){return[]},_setOptionsByDevice:function(e){this._options.applyRules(e)},_convertRulesToOptions:function(e){return(0,r.convertRulesToOptions)(e)},_isInitialOptionValue:function(e){return this._options.isInitial(e)},_setOptionsByReference:function(){this._optionsByReference={}},_getOptionsByReference:function(){return this._optionsByReference},ctor:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},t=e._optionChangedCallbacks,n=e._disposingCallbacks;this.NAME=(0,h.name)(this.constructor),this._eventsStrategy=c.EventsStrategy.create(this,e.eventsStrategy),this._updateLockCount=0,this._optionChangedCallbacks=t||(0,d.default)(),this._disposingCallbacks=n||(0,d.default)(),this.postponedOperations=new p.PostponedOperations,this._createOptions(e)},_createOptions:function(e){var t=this;this.beginUpdate();try{this._setOptionsByReference(),this._setDeprecatedOptions(),this._options=new a.Options(this._getDefaultOptions(),this._getDefaultOptions(),this._getOptionsByReference(),this._getDeprecatedOptions()),this._options.onChanging((function(e,n,i){return t._initialized&&t._optionChanging(e,n,i)})),this._options.onDeprecated((function(e,n){return t._logDeprecatedOptionWarning(e,n)})),this._options.onChanged((function(e,n,i){return t._notifyOptionChanged(e,n,i)})),this._options.onStartChange((function(){return t.beginUpdate()})),this._options.onEndChange((function(){return t.endUpdate()})),this._options.addRules(this._defaultOptionsRules()),e&&e.onInitializing&&e.onInitializing.apply(this,[e]),this._setOptionsByDevice(e.defaultOptionsRules),this._initOptions(e)}finally{this.endUpdate()}},_initOptions:function(e){this.option(e)},_init:function(){var e=this;this._createOptionChangedAction(),this.on("disposing",(function(t){e._disposingCallbacks.fireWith(e,[t])}))},_logDeprecatedOptionWarning:function(e,t){var n=t.message||"Use the '".concat(t.alias,"' option instead");u.default.log("W0001",this.NAME,e,t.since,n)},_logDeprecatedComponentWarning:function(e,t){u.default.log("W0000",this.NAME,e,"Use the '".concat(t,"' widget instead"))},_createOptionChangedAction:function(){this._optionChangedAction=this._createActionByOption("onOptionChanged",{excludeValidators:["disabled","readOnly"]})},_createDisposingAction:function(){this._disposingAction=this._createActionByOption("onDisposing",{excludeValidators:["disabled","readOnly"]})},_optionChanged:function(e){switch(e.name){case"onDisposing":case"onInitialized":break;case"onOptionChanged":this._createOptionChangedAction()}},_dispose:function(){this._optionChangedCallbacks.empty(),this._createDisposingAction(),this._disposingAction(),this._eventsStrategy.dispose(),this._options.dispose(),this._disposed=!0},_lockUpdate:function(){this._updateLockCount++},_unlockUpdate:function(){this._updateLockCount=Math.max(this._updateLockCount-1,0)},_isUpdateAllowed:function(){return 0===this._updateLockCount},_isInitializingRequired:function(){return!this._initializing&&!this._initialized},isInitialized:function(){return this._initialized},_commitUpdate:function(){this.postponedOperations.callPostponedOperations(),this._isInitializingRequired()&&this._initializeComponent()},_initializeComponent:function(){this._initializing=!0;try{this._init()}finally{this._initializing=!1,this._lockUpdate(),this._createActionByOption("onInitialized",{excludeValidators:["disabled","readOnly"]})(),this._unlockUpdate(),this._initialized=!0}},instance:function(){return this},beginUpdate:function(){this._lockUpdate()},endUpdate:function(){this._unlockUpdate(),this._isUpdateAllowed()&&this._commitUpdate()},_optionChanging:g.noop,_notifyOptionChanged:function(e,t,n){if(this._initialized)for(var i=[e].concat(this._options.getAliasesByName(e)),a=0;a<i.length;a++){var r=i[a],s={name:(0,m.getPathParts)(r)[0],fullName:r,value:t,previousValue:n};0!==r.indexOf("_",0)&&(this._optionChangedCallbacks.fireWith(this,[(0,o.extend)(this._defaultActionArgs(),s)]),this._optionChangedAction((0,o.extend)({},s))),this._disposed||this._cancelOptionChange===r||this._optionChanged(s)}},initialOption:function(e){return this._options.initial(e)},_defaultActionConfig:function(){return{context:this,component:this}},_defaultActionArgs:function(){return{component:this}},_createAction:function(e,t){var n,i=this;return function(a){return(0,f.isDefined)(a)||(a={}),(0,f.isPlainObject)(a)||(a={actionValue:a}),(n=n||new l.default(e,(0,o.extend)(t,i._defaultActionConfig()))).execute.call(n,(0,o.extend)(a,i._defaultActionArgs()))}},_createActionByOption:function(e,t){var n,o,a,r=this,s=function(){if(!o){if(t=t||{},"string"!=typeof e)throw u.default.Error("E0008");0===e.indexOf("on")&&(o=v(e)),a=r.option()[e]}if(n||a||t.beforeExecute||t.afterExecute||r._eventsStrategy.hasEvent(o)){if(!n){var s=t.beforeExecute;t.beforeExecute=function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];s&&s.apply(r,t),r._eventsStrategy.fireEvent(o,t[0].args)},n=r._createAction(a,t)}for(var l=arguments.length,d=new Array(l),c=0;c<l;c++)d[c]=arguments[c];if((0,i.default)().wrapActionsBeforeExecute){var h=r.option("beforeActionExecute")||g.noop,p=h(r,n,t)||n;return p.apply(r,d)}return n.apply(r,d)}};return(0,i.default)().wrapActionsBeforeExecute?s:(this.option("onActionCreated")||g.noop)(this,s,t)||s},on:function(e,t){return this._eventsStrategy.on(e,t),this},off:function(e,t){return this._eventsStrategy.off(e,t),this},hasActionSubscription:function(e){return!!this._options.silent(e)||this._eventsStrategy.hasEvent(v(e))},isOptionDeprecated:function(e){return this._options.isDeprecated(e)},_setOptionWithoutOptionChange:function(e,t){this._cancelOptionChange=e,this.option(e,t),this._cancelOptionChange=!1},_getOptionValue:function(e,t){var n=this.option(e);return(0,f.isFunction)(n)?n.bind(t)():n},option:function(){var e;return(e=this._options).option.apply(e,arguments)},resetOption:function(e){this.beginUpdate(),this._options.reset(e),this.endUpdate()}});t.Component=y},99393:function(e,t,n){t.default=void 0;var i=s(n(68374)),o=s(n(5554)),a=s(n(17381)),r=n(9321);function s(e){return e&&e.__esModule?e:{default:e}}o.default.add((function(e,t){i.default.fn[e]=function(n){var i,o="string"==typeof n;if(o){var r=n,s=[].slice.call(arguments).slice(1);this.each((function(){var n=t.getInstance(this);if(!n)throw a.default.Error("E0009",e);var o=n[r].apply(n,s);void 0===i&&(i=o)}))}else this.each((function(){var e=t.getInstance(this);e?e.option(n):new t(this,n)})),i=this;return i}}));var l=function(e,t,n){n?t[e]=n:n=t,(0,r.name)(n,e),o.default.fire(e,n)};t.default=l,e.exports=t.default,e.exports.default=t.default},5554:function(e,t,n){var i;t.default=void 0;var o=new(((i=n(83358))&&i.__esModule?i:{default:i}).default);t.default=o,e.exports=t.default,e.exports.default=t.default},80209:function(e,t,n){t.default=void 0;var i,o=n(13306),a=(i=n(17381))&&i.__esModule?i:{default:i};var r={rtlEnabled:!1,defaultCurrency:"USD",defaultUseCurrencyAccountingStyle:!0,oDataFilterToLower:!0,serverDecimalSeparator:".",decimalSeparator:".",thousandsSeparator:",",forceIsoDateParsing:!0,wrapActionsBeforeExecute:!0,useLegacyStoreResult:!1,useJQuery:void 0,editorStylingMode:void 0,useLegacyVisibleIndex:!1,floatingActionButtonConfig:{icon:"add",closeIcon:"close",label:"",position:{at:"right bottom",my:"right bottom",offset:{x:-16,y:-16}},maxSpeedDialActionCount:5,shading:!1,direction:"auto"},optionsParser:function(e){"{"!==e.trim().charAt(0)&&(e="{"+e+"}");try{return new Function("return "+e)()}catch(t){throw a.default.Error("E3018",t,e)}}},s=["decimalSeparator","thousandsSeparator"],l=function(){if(!arguments.length)return r;var e=arguments.length<=0?void 0:arguments[0];s.forEach((function(t){if(e[t]){var n="Now, the ".concat(t," is selected based on the specified locale.");a.default.log("W0003","config",t,"19.2",n)}})),(0,o.extend)(r,e)};"undefined"!=typeof DevExpress&&DevExpress.config&&l(DevExpress.config);var u=l;t.default=u,e.exports=t.default,e.exports.default=t.default},20530:function(e,t,n){t.default=void 0;var i=n(58664),o=_(n(68374)),a=n(58201),r=n(13306),s=n(35922),l=n(95479),u=_(n(17381)),d=_(n(44504)),c=_(n(24311)),h=_(n(55814)),p=n(80566),f=n(36613),g=n(77695),m=_(n(80209));function _(e){return e&&e.__esModule?e:{default:e}}var v=(0,a.getNavigator)(),y=(0,a.getWindow)(),b={iPhone:"iPhone",iPhone5:"iPhone",iPhone6:"iPhone",iPhone6plus:"iPhone",iPad:"iPad",iPadMini:"iPad Mini",androidPhone:"Android Mobile",androidTablet:"Android",msSurface:"Windows ARM Tablet PC",desktop:"desktop"},x={deviceType:"desktop",platform:"generic",version:[],phone:!1,tablet:!1,android:!1,ios:!1,generic:!0,grade:"A",mac:!1},w={generic:function(e){var t=/windows phone/i.test(e)||e.match(/WPDesktop/),n=!t&&/Windows(.*)arm(.*)Tablet PC/i.test(e),i=!t&&!n&&/msapphost/i.test(e),o=/((intel|ppc) mac os x)/.test(e.toLowerCase());if(t||n||i||o)return{deviceType:t?"phone":n?"tablet":"desktop",platform:"generic",version:[],grade:"A",mac:o}},ios:function(e){if(/ip(hone|od|ad)/i.test(e)){var t=/ip(hone|od)/i.test(e),n=e.match(/os (\d+)_(\d+)_?(\d+)?/i);return{deviceType:t?"phone":"tablet",platform:"ios",version:n?[parseInt(n[1],10),parseInt(n[2],10),parseInt(n[3]||0,10)]:[],grade:480===y.screen.height?"B":"A"}}},android:function(e){if(/android|htc_|silk/i.test(e)){var t=/mobile/i.test(e),n=e.match(/android (\d+)\.?(\d+)?\.?(\d+)?/i),i=n?[parseInt(n[1],10),parseInt(n[2]||0,10),parseInt(n[3]||0,10)]:[];return{deviceType:t?"phone":"tablet",platform:"android",version:i,grade:i.length>1&&(i[0]<4||4===i[0]&&i[1]<4)?"B":"A"}}}},C=new(function(){function e(e){this._window=(null==e?void 0:e.window)||y,this._realDevice=this._getDevice(),this._currentDevice=void 0,this._currentOrientation=void 0,this._eventsStrategy=new p.EventsStrategy(this),this.changed=(0,d.default)(),(0,a.hasWindow)()&&(c.default.add(this._recalculateOrientation.bind(this)),h.default.add(this._recalculateOrientation.bind(this)))}var t=e.prototype;return t.current=function(e){if(e)return this._currentDevice=this._getDevice(e),this._forced=!0,void this.changed.fire();if(!this._currentDevice){e=void 0;try{e=this._getDeviceOrNameFromWindowScope()}catch(t){e=this._getDeviceNameFromSessionStorage()}finally{e||(e=this._getDeviceNameFromSessionStorage()),e&&(this._forced=!0)}this._currentDevice=this._getDevice(e)}return this._currentDevice},t.real=function(e){return(0,r.extend)({},this._realDevice)},t.orientation=function(){return this._currentOrientation},t.isForced=function(){return this._forced},t.isRippleEmulator=function(){return!!this._window.tinyHippos},t._getCssClasses=function(e){var t=[],n=this._realDevice;return(e=e||this.current()).deviceType&&(t.push("dx-device-".concat(e.deviceType)),"desktop"!==e.deviceType&&t.push("dx-device-mobile")),t.push("dx-device-".concat(n.platform)),n.version&&n.version.length&&t.push("dx-device-".concat(n.platform,"-").concat(n.version[0])),this.isSimulator()&&t.push("dx-simulator"),(0,m.default)().rtlEnabled&&t.push("dx-rtl"),t},t.attachCssClasses=function(e,t){this._deviceClasses=this._getCssClasses(t).join(" "),(0,o.default)(e).addClass(this._deviceClasses)},t.detachCssClasses=function(e){(0,o.default)(e).removeClass(this._deviceClasses)},t.isSimulator=function(){try{return this._isSimulator||(0,a.hasWindow)()&&this._window.top!==this._window.self&&this._window.top["dx-force-device"]||this.isRippleEmulator()}catch(e){return!1}},t.forceSimulator=function(){this._isSimulator=!0},t._getDevice=function(e){if("genericPhone"===e&&(e={deviceType:"phone",platform:"generic",generic:!0}),(0,s.isPlainObject)(e))return this._fromConfig(e);var t;if(e){if(!(t=b[e]))throw u.default.Error("E0005")}else t=v.userAgent;return this._fromUA(t)},t._getDeviceOrNameFromWindowScope=function(){var e;return(0,a.hasWindow)()&&(this._window.top["dx-force-device-object"]||this._window.top["dx-force-device"])&&(e=this._window.top["dx-force-device-object"]||this._window.top["dx-force-device"]),e},t._getDeviceNameFromSessionStorage=function(){var e=(0,f.sessionStorage)();if(e){var t=e.getItem("dx-force-device");try{return JSON.parse(t)}catch(e){return t}}},t._fromConfig=function(e){var t=(0,r.extend)({},x,this._currentDevice,e),n={phone:"phone"===t.deviceType,tablet:"tablet"===t.deviceType,android:"android"===t.platform,ios:"ios"===t.platform,generic:"generic"===t.platform};return(0,r.extend)(t,n)},t._fromUA=function(e){var t;return(0,l.each)(w,(function(n,i){return!(t=i(e))})),t?this._fromConfig(t):x},t._changeOrientation=function(){var e=(0,o.default)(this._window),t=(0,i.getHeight)(e)>(0,i.getWidth)(e)?"portrait":"landscape";this._currentOrientation!==t&&(this._currentOrientation=t,this._eventsStrategy.fireEvent("orientationChanged",[{orientation:t}]))},t._recalculateOrientation=function(){var e=(0,i.getWidth)(this._window);this._currentWidth!==e&&(this._currentWidth=e,this._changeOrientation())},t.on=function(e,t){return this._eventsStrategy.on(e,t),this},t.off=function(e,t){return this._eventsStrategy.off(e,t),this},e}()),S=(0,g.value)();S&&C.attachCssClasses(S),g.changeCallback.add((function(e,t){C.detachCssClasses(t),C.attachCssClasses(e)}));var k=C;t.default=k,e.exports=t.default,e.exports.default=t.default},73349:function(e,t,n){t.default=void 0;var i,o=(i=n(20476))&&i.__esModule?i:{default:i},a=n(20576);function r(e){return(r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var s={querySelectorAll:function(e,t){return e.querySelectorAll(t)},elementMatches:function(e,t){var n=this;return(e.matches||e.matchesSelector||e.mozMatchesSelector||e.msMatchesSelector||e.oMatchesSelector||e.webkitMatchesSelector||function(t){var i=e.document||e.ownerDocument;if(!i)return!1;for(var o=n.querySelectorAll(i,t),a=0;a<o.length;a++)if(o[a]===e)return!0}).call(e,t)},createElement:function(e,t){return(t=t||this._document).createElement(e)},createElementNS:function(e,t,n){return(n=n||this._document).createElementNS(e,t)},createTextNode:function(e,t){return(t=t||this._document).createTextNode(e)},isNode:function(e){return e&&"object"===r(e)&&"nodeType"in e&&"nodeName"in e},isElementNode:function(e){return e&&1===e.nodeType},isTextNode:function(e){return e&&3===e.nodeType},isDocument:function(e){return e&&9===e.nodeType},removeElement:function(e){var t=e&&e.parentNode;t&&t.removeChild(e)},insertElement:function(e,t,n){e&&t&&e!==t&&(n?e.insertBefore(t,n):e.appendChild(t))},getAttribute:function(e,t){return e.getAttribute(t)},setAttribute:function(e,t,n){e.setAttribute(t,n)},removeAttribute:function(e,t){e.removeAttribute(t)},setProperty:function(e,t,n){e[t]=n},setText:function(e,t){e&&(e.textContent=t)},setClass:function(e,t,n){1===e.nodeType&&t&&(n?e.classList.add(t):e.classList.remove(t))},setStyle:function(e,t,n){e.style[t]=n||""},_document:"undefined"==typeof document?void 0:document,getDocument:function(){return this._document},getActiveElement:function(){return this._document.activeElement},getBody:function(){return this._document.body},createDocumentFragment:function(){return this._document.createDocumentFragment()},getDocumentElement:function(){return this._document.documentElement},getLocation:function(){return this._document.location},getSelection:function(){return this._document.selection},getReadyState:function(){return this._document.readyState},getHead:function(){return this._document.head},hasDocumentProperty:function(e){return e in this._document},listen:function(e,t,n,i){return e&&"addEventListener"in e?(e.addEventListener(t,n,i),function(){e.removeEventListener(t,n)}):a.noop},elementsFromPoint:function(e,t){return this._document.elementsFromPoint(e,t)}},l=(0,o.default)(s);t.default=l,e.exports=t.default,e.exports.default=t.default},13046:function(e,t,n){t.default=void 0;var i=v(n(68374)),o=v(n(80209)),a=v(n(17381)),r=v(n(55814)),s=n(44297),l=n(14192),u=n(9321),d=n(97906),c=n(95479),h=n(13306),p=n(6415),f=n(20576),g=n(35922),m=n(58201),_=n(72918);function v(e){return e&&e.__esModule?e:{default:e}}var y=s.Component.abstract,b=s.Component.inherit({_getDefaultOptions:function(){return(0,h.extend)(this.callBase(),{width:void 0,height:void 0,rtlEnabled:(0,o.default)().rtlEnabled,elementAttr:{},disabled:!1,integrationOptions:{}},this._useTemplates()?l.TemplateManager.createDefaultOptions():{})},ctor:function(e,t){this._customClass=null,this._createElement(e),(0,u.attachInstanceToElement)(this._$element,this,this._dispose),this.callBase(t)},_createElement:function(e){this._$element=(0,i.default)(e)},_getSynchronizableOptionsForCreateComponent:function(){return["rtlEnabled","disabled","templatesRenderAsynchronously"]},_checkFunctionValueDeprecation:function(e){var t=this;this.option("_ignoreFunctionValueDeprecation")||e.forEach((function(e){(0,g.isFunction)(t.option(e))&&a.default.log("W0017",e)}))},_visibilityChanged:y,_dimensionChanged:y,_init:function(){this.callBase(),this._checkFunctionValueDeprecation(["width","height","maxHeight","maxWidth","minHeight","minWidth","popupHeight","popupWidth"]),this._attachWindowResizeCallback(),this._initTemplateManager()},_setOptionsByDevice:function(e){this.callBase([].concat(this.constructor._classCustomRules||[],e||[]))},_isInitialOptionValue:function(e){return!(this.constructor._classCustomRules&&Object.prototype.hasOwnProperty.call(this._convertRulesToOptions(this.constructor._classCustomRules),e))&&this.callBase(e)},_attachWindowResizeCallback:function(){if(this._isDimensionChangeSupported()){var e=this._windowResizeCallBack=this._dimensionChanged.bind(this);r.default.add(e)}},_isDimensionChangeSupported:function(){return this._dimensionChanged!==y},_renderComponent:function(){this._initMarkup(),(0,m.hasWindow)()&&this._render()},_initMarkup:function(){var e=(this.option()||{}).rtlEnabled;this._renderElementAttributes(),this._toggleRTLDirection(e),this._renderVisibilityChange(),this._renderDimensions()},_render:function(){this._attachVisibilityChangeHandlers()},_renderElementAttributes:function(){var e=(this.option()||{}).elementAttr,t=(0,h.extend)({},e),n=t.class;delete t.class,this.$element().attr(t).removeClass(this._customClass).addClass(n),this._customClass=n},_renderVisibilityChange:function(){(this._isDimensionChangeSupported()&&this._attachDimensionChangeHandlers(),this._isVisibilityChangeSupported())&&this.$element().addClass("dx-visibility-change-handler")},_renderDimensions:function(){var e=this.$element(),t=e.get(0),n=this._getOptionValue("width",t),i=this._getOptionValue("height",t);this._isCssUpdateRequired(t,i,n)&&e.css({width:null===n?"":n,height:null===i?"":i})},_isCssUpdateRequired:function(e,t,n){return!!((0,g.isDefined)(n)||(0,g.isDefined)(t)||e.style.width||e.style.height)},_attachDimensionChangeHandlers:function(){var e=this,t=this.$element(),n="".concat(this.NAME,"VisibilityChange");_.resize.off(t,{namespace:n}),_.resize.on(t,(function(){return e._dimensionChanged()}),{namespace:n})},_attachVisibilityChangeHandlers:function(){var e=this;if(this._isVisibilityChangeSupported()){var t=this.$element(),n="".concat(this.NAME,"VisibilityChange");this._isHidden=!this._isVisible(),_.visibility.off(t,{namespace:n}),_.visibility.on(t,(function(){return e._checkVisibilityChanged("shown")}),(function(){return e._checkVisibilityChanged("hiding")}),{namespace:n})}},_isVisible:function(){return this.$element().is(":visible")},_checkVisibilityChanged:function(e){this._isVisible()&&("hiding"!==e||this._isHidden?"shown"===e&&this._isHidden&&(this._isHidden=!1,this._visibilityChanged(!0)):(this._visibilityChanged(!1),this._isHidden=!0))},_isVisibilityChangeSupported:function(){return this._visibilityChanged!==y&&(0,m.hasWindow)()},_clean:f.noop,_modelByElement:function(){var e=this.option().modelByElement,t=this.$element();return e?e(t):void 0},_invalidate:function(){if(this._isUpdateAllowed())throw a.default.Error("E0007");this._requireRefresh=!0},_refresh:function(){this._clean(),this._renderComponent()},_dispose:function(){this._templateManager&&this._templateManager.dispose(),this.callBase(),this._clean(),this._detachWindowResizeCallback()},_detachWindowResizeCallback:function(){this._isDimensionChangeSupported()&&r.default.remove(this._windowResizeCallBack)},_toggleRTLDirection:function(e){this.$element().toggleClass("dx-rtl",e)},_createComponent:function(e,t){var n=this,o=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=(0,f.grep)(this._getSynchronizableOptionsForCreateComponent(),(function(e){return!(e in o)})),r=this.option(),s=r.integrationOptions,l=this.option(),u=l.nestedComponentOptions;u=u||f.noop;var d=(0,h.extend)({integrationOptions:s},u(this));a.forEach((function(e){return d[e]=n.option(e)})),this._extendConfig(o,d);var c=void 0;if((0,g.isString)(t)){var p=(0,i.default)(e)[t](o);c=p[t]("instance")}else e&&((c=t.getInstance(e))?c.option(o):c=new t(e,o));if(c){var m=function(e){var t=e.name,n=e.value;a.includes(t)&&c.option(t,n)};this.on("optionChanged",m),c.on("disposing",(function(){return n.off("optionChanged",m)}))}return c},_extendConfig:function(e,t){(0,c.each)(t,(function(t,n){!Object.prototype.hasOwnProperty.call(e,t)&&(e[t]=n)}))},_defaultActionConfig:function(){var e=this.$element(),t=this._modelByElement(e);return(0,h.extend)(this.callBase(),{context:t})},_defaultActionArgs:function(){var e=this.$element(),t=this._modelByElement(e),n=this.element();return(0,h.extend)(this.callBase(),{element:n,model:t})},_optionChanged:function(e){switch(e.name){case"width":case"height":this._renderDimensions();break;case"rtlEnabled":this._invalidate();break;case"elementAttr":this._renderElementAttributes();break;case"disabled":case"integrationOptions":break;default:this.callBase(e)}},_removeAttributes:function(e){for(var t=e.attributes,n=t.length-1;n>=0;n--){var i=t[n];if(i){var o=i.name;o.indexOf("aria-")&&-1===o.indexOf("dx-")&&"role"!==o&&"style"!==o&&"tabindex"!==o||e.removeAttribute(o)}}},_removeClasses:function(e){e.className=e.className.split(" ").filter((function(e){return 0!==e.lastIndexOf("dx-",0)})).join(" ")},_updateDOMComponent:function(e){e?this._renderComponent():this._requireRefresh&&(this._requireRefresh=!1,this._refresh())},endUpdate:function(){var e=this._isInitializingRequired();this.callBase(),this._isUpdateAllowed()&&this._updateDOMComponent(e)},$element:function(){return this._$element},element:function(){var e=this.$element();return(0,p.getPublicElement)(e)},dispose:function(){var e=this.$element().get(0);(0,d.cleanDataRecursive)(e,!0),e.textContent="",this._removeAttributes(e),this._removeClasses(e)},resetOption:function(e){if(this.callBase(e),"width"===e||"height"===e){var t=this.initialOption(e);!(0,g.isDefined)(t)&&this.$element().css(e,"")}},_getAnonymousTemplateName:function(){},_initTemplateManager:function(){if(!this._templateManager&&this._useTemplates()){var e=this.option().integrationOptions,t=(void 0===e?{}:e).createTemplate;this._templateManager=new l.TemplateManager(t,this._getAnonymousTemplateName()),this._initTemplates()}},_initTemplates:function(){var e=this,t=this._templateManager.extractTemplates(this.$element()),n=t.templates,i=t.anonymousTemplateMeta,o=this.option("integrationOptions.templates.".concat(i.name));n.forEach((function(t){var n=t.name,i=t.template;e._options.silent("integrationOptions.templates.".concat(n),i)})),i.name&&!o&&(this._options.silent("integrationOptions.templates.".concat(i.name),i.template),this._options.silent("_hasAnonymousTemplateContent",!0))},_getTemplateByOption:function(e){return this._getTemplate(this.option(e))},_getTemplate:function(e){var t=this.option("integrationOptions.templates"),n=this.option("templatesRenderAsynchronously"),i=this.option("integrationOptions.skipTemplates");return this._templateManager.getTemplate(e,t,{isAsyncTemplate:n,skipTemplates:i},this)},_saveTemplate:function(e,t){this._setOptionWithoutOptionChange("integrationOptions.templates."+e,this._templateManager._createTemplate(t))},_useTemplates:function(){return!0}});b.getInstance=function(e){return(0,u.getInstanceByElement)((0,i.default)(e),this)},b.defaultOptions=function(e){this._classCustomRules=this._classCustomRules||[],this._classCustomRules.push(e)};var x=b;t.default=x,e.exports=t.default,e.exports.default=t.default},6415:function(e,t){t.getPublicElement=function(e){return n(e)},t.setPublicElementWrapper=function(e){n=e};var n=function(e){return e&&e.get(0)}},97906:function(e,t,n){t.afterCleanData=function(e){c=e},t.beforeCleanData=function(e){d=e},t.cleanData=function(e){return s.cleanData.call(this,e)},t.cleanDataRecursive=function(e,t){if(!i.default.isElementNode(e))return;var n=e.getElementsByTagName("*");s.cleanData(n),t&&s.cleanData([e])},t.data=function(){return s.data.apply(this,arguments)},t.getDataStrategy=function(){return s},t.removeData=function(e,t){return s.removeData.call(this,e,t)},t.strategyChanging=t.setDataStrategy=void 0;var i=r(n(73349)),o=r(n(55994)),a=r(n(83358));function r(e){return e&&e.__esModule?e:{default:e}}var s,l=new WeakMap,u=new a.default;t.strategyChanging=u;var d=function(){},c=function(){},h=function(e){u.fire(e);var t=(s=e).cleanData;s.cleanData=function(e){d(e);var n=t.call(this,e);return c(e),n}};t.setDataStrategy=h,h({data:function(){var e=arguments[0],t=arguments[1],n=arguments[2];if(e){var i=l.get(e);return i||(i={},l.set(e,i)),void 0===t?i:2===arguments.length?i[t]:(i[t]=n,n)}},removeData:function(e,t){if(e)if(void 0===t)l.delete(e);else{var n=l.get(e);n&&delete n[t]}},cleanData:function(e){for(var t=0;t<e.length;t++)o.default.off(e[t]),l.delete(e[t])}})},17381:function(e,t,n){var i;t.default=void 0;var o=(0,((i=n(95640))&&i.__esModule?i:{default:i}).default)({E0001:"Method is not implemented",E0002:"Member name collision: {0}",E0003:"A class must be instantiated using the 'new' keyword",E0004:"The NAME property of the component is not specified",E0005:"Unknown device",E0006:"Unknown endpoint key is requested",E0007:"'Invalidate' method is called outside the update transaction",E0008:"Type of the option name is not appropriate to create an action",E0009:"Component '{0}' has not been initialized for an element",E0010:"Animation configuration with the '{0}' type requires '{1}' configuration as {2}",E0011:"Unknown animation type '{0}'",E0012:"jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",E0013:"KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",E0014:"The 'release' method shouldn't be called for an unlocked Lock object",E0015:"Queued task returned an unexpected result",E0017:"Event namespace is not defined",E0018:"DevExpress.ui.DevExpressPopup widget is required",E0020:"Template engine '{0}' is not supported",E0021:"Unknown theme is set: {0}",E0022:"LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",E0023:"Template name is not specified",E0024:"DevExtreme bundle already included",E0025:"Unexpected argument type",E0100:"Unknown validation type is detected",E0101:"Misconfigured range validation rule is detected",E0102:"Misconfigured comparison validation rule is detected",E0103:"validationCallback of an asynchronous rule should return a jQuery or a native promise",E0110:"Unknown validation group is detected",E0120:"Adapter for a DevExpressValidator component cannot be configured",E0121:"The 'customItem' parameter of the 'onCustomItemCreating' function is empty or contains invalid data. Assign a custom object or a Promise that is resolved after the item is created.",W0000:"'{0}' is deprecated in {1}. {2}",W0001:"{0} - '{1}' option is deprecated in {2}. {3}",W0002:"{0} - '{1}' method is deprecated in {2}. {3}",W0003:"{0} - '{1}' property is deprecated in {2}. {3}",W0004:"Timeout for theme loading is over: {0}",W0005:"'{0}' event is deprecated in {1}. {2}",W0006:"Invalid recurrence rule: '{0}'",W0007:"'{0}' Globalize culture is not defined",W0008:"Invalid view name: '{0}'",W0009:"Invalid time zone name: '{0}'",W0010:"{0} is deprecated in {1}. {2}",W0011:"Number parsing is invoked while the parser is not defined",W0012:"Date parsing is invoked while the parser is not defined",W0013:"'{0}' file is deprecated in {1}. {2}",W0014:"{0} - '{1}' type is deprecated in {2}. {3}",W0015:"Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",W0016:'The "{0}" option does not accept the "{1}" value since v{2}. {3}.',W0017:'Setting the "{0}" property with a function is deprecated since v21.2',W0018:'Setting the "position" property with a function is deprecated since v21.2'});t.default=o,e.exports=t.default,e.exports.default=t.default},80566:function(e,t,n){t.EventsStrategy=void 0;var i,o=(i=n(44504))&&i.__esModule?i:{default:i},a=n(95479),r=n(35922);var s=function(){function e(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this._events={},this._owner=e,this._options=t}e.create=function(t,n){return n?(0,r.isFunction)(n)?n(t):n:new e(t)};var t=e.prototype;return t.hasEvent=function(e){var t=this._events[e];return!!t&&t.has()},t.fireEvent=function(e,t){var n=this._events[e];return n&&n.fireWith(this._owner,t),this._owner},t.on=function(e,t){var n=this;if((0,r.isPlainObject)(e))(0,a.each)(e,(function(e,t){n.on(e,t)}));else{var i=this._events[e];i||(i=(0,o.default)({syncStrategy:this._options.syncStrategy}),this._events[e]=i),(i.originalAdd||i.add).call(i,t)}},t.off=function(e,t){var n=this._events[e];n&&((0,r.isFunction)(t)?n.remove(t):n.empty())},t.dispose=function(){(0,a.each)(this._events,(function(e,t){t.empty()}))},e}();t.EventsStrategy=s},73176:function(e,t,n){var i;t.default=void 0;var o=((i=n(38377))&&i.__esModule?i:{default:i}).default.inherit({ctor:function(e){e&&(e=String(e)),this._value=this._normalize(e||this._generate())},_normalize:function(e){for(e=e.replace(/[^a-f0-9]/gi,"").toLowerCase();e.length<32;)e+="0";return[e.substr(0,8),e.substr(8,4),e.substr(12,4),e.substr(16,4),e.substr(20,12)].join("-")},_generate:function(){for(var e="",t=0;t<32;t++)e+=Math.round(15*Math.random()).toString(16);return e},toString:function(){return this._value},valueOf:function(){return this._value},toJSON:function(){return this._value}});t.default=o,e.exports=t.default,e.exports.default=t.default},83448:function(e,t,n){t.default=void 0;var i,o=n(58201),a=(i=n(20476))&&i.__esModule?i:{default:i};var r=(0,o.getWindow)(),s={getXhr:function(){return new r.XMLHttpRequest}},l=(0,a.default)(s);t.default=l,e.exports=t.default,e.exports.default=t.default},15334:function(e,t,n){t.default=void 0;var i=n(55285),o=n(44105),a=n(87456),r=u(n(73349)),s=n(97906),l=u(n(20476));function u(e){return e&&e.__esModule?e:{default:e}}var d=function(e){var t=e.parentNode;t&&((0,s.cleanDataRecursive)(e),t.$V=e.$V,(0,i.render)(null,t),t.appendChild(e),e.innerHTML="",delete t.$V),delete e.$V},c=(0,l.default)({createElement:function(e,t){return(0,a.createElement)(e,t)},remove:d,onAfterRender:function(){o.InfernoEffectHost.callEffects()},onPreRender:function(){o.InfernoEffectHost.lock()},render:function(e,t,n,s){if(s)(0,i.render)((0,a.createElement)(e,t),n);else{var l=n.parentNode,u=null==n?void 0:n.nextSibling,c=r.default.createElement("div");c.appendChild(n);var h=r.default.createDocumentFragment().appendChild(c);!!n.$V&&d(n),(0,o.hydrate)((0,a.createElement)(e,t),h),n.$V=h.$V,l&&l.insertBefore(n,u)}}});t.default=c,e.exports=t.default,e.exports.default=t.default},83358:function(e,t,n){t.default=void 0;var i,o=n(95479),a=(i=n(44504))&&i.__esModule?i:{default:i};var r=function(){function e(){this.memory=[],this.callbacks=(0,a.default)()}var t=e.prototype;return t.add=function(e){(0,o.each)(this.memory,(function(t,n){return e.apply(e,n)})),this.callbacks.add(e)},t.remove=function(e){this.callbacks.remove(e)},t.fire=function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];this.memory.push(t),this.callbacks.fire.apply(this.callbacks,t)},e}();t.default=r,e.exports=t.default,e.exports.default=t.default},95683:function(e,t,n){t.Options=void 0;var i=n(35922),o=n(20576),a=n(9030),r=n(47617),s=n(45434),l=n(13306);function u(){return(u=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(e[i]=n[i])}return e}).apply(this,arguments)}function d(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}var c=function(){function e(e,t,n,i){var o=this;this._deprecatedCallback,this._startChangeCallback,this._endChangeCallback,this._default=t,this._deprecated=i,this._deprecatedNames=[],this._initDeprecatedNames(),this._optionManager=new a.OptionManager(e,n),this._optionManager.onRelevantNamesPrepared((function(e,t,n,i){return o._setRelevantNames(e,t,n,i)})),this._cachedOptions={},this._rules=[]}var t,n,c,h=e.prototype;return h._initDeprecatedNames=function(){for(var e in this._deprecated)this._deprecatedNames.push(e)},h._getByRules=function(e){return e=Array.isArray(e)?this._rules.concat(e):this._rules,(0,s.convertRulesToOptions)(e)},h._notifyDeprecated=function(e){var t=this._deprecated[e];t&&this._deprecatedCallback(e,t)},h._setRelevantNames=function(e,t,n,i){if(t){var o=this._normalizeName(t,i);o&&o!==t&&(this._setField(e,o,n),this._clearField(e,t))}},h._setField=function(e,t,n){var i="",o=null;do{i=i?".".concat(i):"",i=(0,s.getFieldName)(t)+i,o=(t=(0,s.getParentName)(t))?this._optionManager.get(e,t,!1):e}while(!o);o[i]=n},h._clearField=function(e,t){delete e[t];var n=(0,s.getParentName)(t),i=n?this._optionManager.get(e,n,!1):e;i&&delete i[(0,s.getFieldName)(t)]},h._normalizeName=function(e,t){if(this._deprecatedNames.length&&e)for(var n=0;n<this._deprecatedNames.length;n++)if(this._deprecatedNames[n]===e){var i=this._deprecated[e];if(i)return!t&&this._notifyDeprecated(e),i.alias||e}return e},h.addRules=function(e){this._rules=e.concat(this._rules)},h.applyRules=function(e){var t=this._getByRules(e);this.silent(t)},h.dispose=function(){this._deprecatedCallback=o.noop,this._startChangeCallback=o.noop,this._endChangeCallback=o.noop,this._optionManager.dispose()},h.onChanging=function(e){this._optionManager.onChanging(e)},h.onChanged=function(e){this._optionManager.onChanged(e)},h.onDeprecated=function(e){this._deprecatedCallback=e},h.onStartChange=function(e){this._startChangeCallback=e},h.onEndChange=function(e){this._endChangeCallback=e},h.isInitial=function(e){var t=this.silent(e),n=this.initial(e);return(0,i.isFunction)(t)&&(0,i.isFunction)(n)?t.toString()===n.toString():(0,o.equalByValue)(t,n)},h.initial=function(e){return(0,s.getNestedOptionValue)(this._initial,e)},h.option=function(e,t){var n=arguments.length<2&&"object"!==(0,i.type)(e);if(n)return this._optionManager.get(void 0,this._normalizeName(e));this._startChangeCallback();try{this._optionManager.set(e,t)}finally{this._endChangeCallback()}},h.silent=function(e,t){var n=arguments.length<2&&"object"!==(0,i.type)(e);if(n)return this._optionManager.get(void 0,e,void 0,!0);this._optionManager.set(e,t,void 0,!0)},h.reset=function(e){var t=this;if(e){var n=(0,r.getPathParts)(e).reduce((function(e,n){return e?e[n]:t.initial(n)}),null),o=(0,i.isObject)(n)?u({},n):n;this._optionManager.set(e,o,!1)}},h.getAliasesByName=function(e){var t=this;return Object.keys(this._deprecated).filter((function(n){return e===t._deprecated[n].alias}))},h.isDeprecated=function(e){return Object.prototype.hasOwnProperty.call(this._deprecated,e)},h.cache=function(e,t){var n=arguments.length<2;if(n)return this._cachedOptions[e];this._cachedOptions[e]=(0,l.extend)(this._cachedOptions[e],t)},t=e,(n=[{key:"_initial",get:function(){if(!this._initialOptions){var e=this._getByRules(this.silent("defaultOptionsRules"));this._initialOptions=this._default,this._optionManager._setByReference(this._initialOptions,e)}return this._initialOptions},set:function(e){this._initialOptions=e}}])&&d(t.prototype,n),c&&d(t,c),Object.defineProperty(t,"prototype",{writable:!1}),e}();t.Options=c},9030:function(e,t,n){t.OptionManager=void 0;var i=n(47617),o=n(20576),a=n(49036),r=n(13306),s=n(35922),l=n(45434),u={},d={},c=function(){function e(e,t){this._options=e,this._optionsByReference=t,this._changingCallback,this._changedCallback,this._namePreparedCallbacks}var t=e.prototype;return t._setByReference=function(e,t){for(var n in(0,r.extend)(!0,e,t),this._optionsByReference)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n])},t._setPreparedValue=function(e,t,n,o){var r=this.get(this._options,e,!1);if(!(0,a.equals)(r,t)){var l=(0,i.getPathParts)(e);!o&&this._changingCallback(e,r,t),d[e]=d[e]||(0,i.compileSetter)(e),d[e](this._options,t,{functionsAsIs:!0,merge:(0,s.isDefined)(n)?n:!this._optionsByReference[e],unwrapObservables:l.length>1&&!!this._optionsByReference[l[0]]}),!o&&this._changedCallback(e,t,r)}},t._prepareRelevantNames=function(e,t,n,i){if((0,s.isPlainObject)(n))for(var o in n)this._prepareRelevantNames(e,"".concat(t,".").concat(o),n[o]);this._namePreparedCallbacks(e,t,n,i)},t.get=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this._options,t=arguments.length>1?arguments[1]:void 0,n=arguments.length>2?arguments[2]:void 0;return u[t]=u[t]||(0,i.compileGetter)(t),u[t](e,{functionsAsIs:!0,unwrapObservables:n})},t.set=function(e,t,n,i){for(var o in e=(0,l.normalizeOptions)(e,t))this._prepareRelevantNames(e,o,e[o],i);for(var a in e)this._setPreparedValue(a,e[a],n,i)},t.onRelevantNamesPrepared=function(e){this._namePreparedCallbacks=e},t.onChanging=function(e){this._changingCallback=e},t.onChanged=function(e){this._changedCallback=e},t.dispose=function(){this._changingCallback=o.noop,this._changedCallback=o.noop},e}();t.OptionManager=c},45434:function(e,t,n){t.normalizeOptions=t.getParentName=t.getNestedOptionValue=t.getFieldName=t.deviceMatch=t.createDefaultOptionRules=t.convertRulesToOptions=void 0;var i,o=(i=n(20530))&&i.__esModule?i:{default:i},a=n(35922),r=n(20576),s=n(13306),l=n(47617);var u={};t.convertRulesToOptions=function(e){var t=o.default.current();return e.reduce((function(e,n){var i=n.device,o=n.options,r=i||{};return((0,a.isFunction)(r)?r(t):d(t,r))&&(0,s.extend)(!0,e,o),e}),{})};t.normalizeOptions=function(e,t){return"string"!=typeof e?e:function(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}({},e,t)};var d=function(e,t){return(0,a.isEmptyObject)(t)||(0,r.findBestMatches)(e,[t]).length>0};t.deviceMatch=d;t.getFieldName=function(e){return e.substr(e.lastIndexOf(".")+1)};t.getParentName=function(e){return e.substr(0,e.lastIndexOf("."))};t.getNestedOptionValue=function(e,t){return u[t]=u[t]||(0,l.compileGetter)(t),u[t](e,{functionsAsIs:!0})};t.createDefaultOptionRules=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[];return e}},90889:function(e,t,n){t.PostponedOperations=void 0;var i=n(62754),o=n(35922);function a(e){return function(e){if(Array.isArray(e))return r(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return r(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return r(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function r(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}var s=function(){function e(){this._postponedOperations={}}var t=e.prototype;return t.add=function(e,t,n){if(e in this._postponedOperations)n&&this._postponedOperations[e].promises.push(n);else{var o=new i.Deferred;this._postponedOperations[e]={fn:t,completePromise:o,promises:n?[n]:[]}}return this._postponedOperations[e].completePromise.promise()},t.callPostponedOperations=function(){for(var e in this._postponedOperations){var t=this._postponedOperations[e];(0,o.isDefined)(t)&&(t.promises&&t.promises.length?i.when.apply(void 0,a(t.promises)).done(t.fn).then(t.completePromise.resolve):t.fn().done(t.completePromise.resolve))}this._postponedOperations={}},e}();t.PostponedOperations=s},68374:function(e,t,n){var i;t.default=void 0;var o=((i=n(82981))&&i.__esModule?i:{default:i}).default.get();t.default=o,e.exports=t.default,e.exports.default=t.default},82981:function(e,t,n){t.default=void 0;var i,o=n(97906),a=(i=n(73349))&&i.__esModule?i:{default:i},r=n(58201),s=n(35922),l=n(80968),u=n(58664),d=n(61371);var c,h=(0,r.getWindow)(),p=function(e,t){return e?"string"==typeof e?"body"===e?(this[0]=t?t.body:a.default.getBody(),this.length=1,this):(t=t||a.default.getDocument(),"<"===e[0]?(this[0]=a.default.createElement(e.slice(1,-1),t),this.length=1,this):([].push.apply(this,a.default.querySelectorAll(t,e)),this)):a.default.isNode(e)||(0,s.isWindow)(e)?(this[0]=e,this.length=1,this):Array.isArray(e)?([].push.apply(this,e),this):c(e.toArray?e.toArray():[e]):(this.length=0,this)};(c=function(e,t){return new p(e,t)}).fn={dxRenderer:!0},p.prototype=c.fn;var f=function(e,t){for(var n=0;n<this.length;n++){var i=c(this[n]);i[e].apply(i,t)}return this},g=function(e,t,n){null!=n?a.default.setAttribute(e,t,n):a.default.removeAttribute(e,t)};p.prototype.show=function(){return this.toggle(!0)},p.prototype.hide=function(){return this.toggle(!1)},p.prototype.toggle=function(e){return this[0]&&this.toggleClass("dx-state-invisible",!e),this},p.prototype.attr=function(e,t){if(this.length>1&&arguments.length>1)return f.call(this,"attr",arguments);if(!this[0])return(0,s.isObject)(e)||void 0!==t?this:void 0;if(!this[0].getAttribute)return this.prop(e,t);if("string"==typeof e&&1===arguments.length){var n=this[0].getAttribute(e);return null==n?void 0:n}if((0,s.isPlainObject)(e))for(var i in e)this.attr(i,e[i]);else g(this[0],e,t);return this},p.prototype.removeAttr=function(e){return this[0]&&a.default.removeAttribute(this[0],e),this},p.prototype.prop=function(e,t){if(!this[0])return this;if("string"==typeof e&&1===arguments.length)return this[0][e];if((0,s.isPlainObject)(e))for(var n in e)this.prop(n,e[n]);else a.default.setProperty(this[0],e,t);return this},p.prototype.addClass=function(e){return this.toggleClass(e,!0)},p.prototype.removeClass=function(e){return this.toggleClass(e,!1)},p.prototype.hasClass=function(e){if(!this[0]||void 0===this[0].className)return!1;for(var t=e.split(" "),n=0;n<t.length;n++){if(this[0].classList){if(this[0].classList.contains(t[n]))return!0}else if((((0,s.isString)(this[0].className)?this[0].className:a.default.getAttribute(this[0],"class"))||"").split(" ").indexOf(t[n])>=0)return!0}return!1},p.prototype.toggleClass=function(e,t){if(this.length>1)return f.call(this,"toggleClass",arguments);if(!this[0]||!e)return this;t=void 0===t?!this.hasClass(e):t;for(var n=e.split(" "),i=0;i<n.length;i++)a.default.setClass(this[0],n[i],t);return this},p.prototype.html=function(e){return arguments.length?(this.empty(),"string"==typeof e&&!(0,d.isTablePart)(e)||"number"==typeof e?(this[0].innerHTML=e,this):this.append((0,d.parseHTML)(e))):this[0].innerHTML};var m=function(e,t){if(this[0]&&e){"string"==typeof e?e=(0,d.parseHTML)(e):e.nodeType?e=[e]:(0,s.isNumeric)(e)&&(e=[a.default.createTextNode(e)]);for(var n=0;n<e.length;n++){var i=e[n],o=this[0];"TABLE"===o.tagName&&"TR"===i.tagName&&o.tBodies&&o.tBodies.length&&(o=o.tBodies[0]),a.default.insertElement(o,i.nodeType?i:i[0],t)}}},_=function(e,t){if(this[0]&&this[0].style&&!(null===t||"number"==typeof t&&isNaN(t))){e=(0,l.styleProp)(e);for(var n=0;n<this.length;n++)this[n].style[e]=(0,l.normalizeStyleProp)(e,t)}};p.prototype.css=function(e,t){if((0,s.isString)(e)){if(2!==arguments.length){if(!this[0])return;e=(0,l.styleProp)(e);var n=h.getComputedStyle(this[0])[e]||this[0].style[e];return(0,s.isNumeric)(n)?n.toString():n}_.call(this,e,t)}else if((0,s.isPlainObject)(e))for(var i in e)_.call(this,i,e[i]);return this},p.prototype.prepend=function(e){if(arguments.length>1){for(var t=0;t<arguments.length;t++)this.prepend(arguments[t]);return this}return m.apply(this,[e,this[0].firstChild]),this},p.prototype.append=function(e){if(arguments.length>1){for(var t=0;t<arguments.length;t++)this.append(arguments[t]);return this}return m.apply(this,[e]),this},p.prototype.prependTo=function(e){if(this.length>1){for(var t=this.length-1;t>=0;t--)c(this[t]).prependTo(e);return this}return(e=c(e))[0]&&a.default.insertElement(e[0],this[0],e[0].firstChild),this},p.prototype.appendTo=function(e){return this.length>1?f.call(this,"appendTo",arguments):(a.default.insertElement(c(e)[0],this[0]),this)},p.prototype.insertBefore=function(e){return e&&e[0]&&a.default.insertElement(e[0].parentNode,this[0],e[0]),this},p.prototype.insertAfter=function(e){return e&&e[0]&&a.default.insertElement(e[0].parentNode,this[0],e[0].nextSibling),this},p.prototype.before=function(e){return this[0]&&a.default.insertElement(this[0].parentNode,e[0],this[0]),this},p.prototype.after=function(e){return this[0]&&a.default.insertElement(this[0].parentNode,e[0],this[0].nextSibling),this},p.prototype.wrap=function(e){if(this[0]){var t=c(e);t.insertBefore(this),t.append(this)}return this},p.prototype.wrapInner=function(e){var t=this.contents();return t.length?t.wrap(e):this.append(e),this},p.prototype.replaceWith=function(e){if(e&&e[0])return e.is(this)?this:(e.insertBefore(this),this.remove(),e)},p.prototype.remove=function(){return this.length>1?f.call(this,"remove",arguments):((0,o.cleanDataRecursive)(this[0],!0),a.default.removeElement(this[0]),this)},p.prototype.detach=function(){return this.length>1?f.call(this,"detach",arguments):(a.default.removeElement(this[0]),this)},p.prototype.empty=function(){return this.length>1?f.call(this,"empty",arguments):((0,o.cleanDataRecursive)(this[0]),a.default.setText(this[0],""),this)},p.prototype.clone=function(){for(var e=[],t=0;t<this.length;t++)e.push(this[t].cloneNode(!0));return c(e)},p.prototype.text=function(e){if(!arguments.length){for(var t="",n=0;n<this.length;n++)t+=this[n]&&this[n].textContent||"";return t}var i=(0,s.isFunction)(e)?e():e;return(0,o.cleanDataRecursive)(this[0],!1),a.default.setText(this[0],(0,s.isDefined)(i)?i:""),this},p.prototype.val=function(e){return 1===arguments.length?this.prop("value",(0,s.isDefined)(e)?e:""):this.prop("value")},p.prototype.contents=function(){if(!this[0])return c();var e=[];return e.push.apply(e,this[0].childNodes),c(e)},p.prototype.find=function(e){var t=c();if(!e)return t;var n,i=[];if("string"==typeof e)for(e=e.trim(),n=0;n<this.length;n++){var o=this[n];if(a.default.isElementNode(o)){var r=o.getAttribute("id"),s=r||"dx-query-children";r||g(o,"id",s);var l=(s="[id='"+s+"'] ")+e.replace(/([^\\])(,)/g,"$1, "+s);i.push.apply(i,a.default.querySelectorAll(o,l)),g(o,"id",r)}else a.default.isDocument(o)&&i.push.apply(i,a.default.querySelectorAll(o,e))}else for(n=0;n<this.length;n++)e=a.default.isNode(e)?e:e[0],this[n]!==e&&this[n].contains(e)&&i.push(e);return t.add(i)};var v=function(e,t){return!t.nodeType||!!(t.offsetWidth||t.offsetHeight||t.getClientRects().length)};p.prototype.filter=function(e){if(!e)return c();if(":visible"===e)return this.filter(v);if(":hidden"===e)return this.filter((function(e,t){return!v(0,t)}));for(var t=[],n=0;n<this.length;n++){var i=this[n];if(a.default.isElementNode(i)&&"string"===(0,s.type)(e))a.default.elementMatches(i,e)&&t.push(i);else if(a.default.isNode(e)||(0,s.isWindow)(e))e===i&&t.push(i);else if((0,s.isFunction)(e))e.call(i,n,i)&&t.push(i);else for(var o=0;o<e.length;o++)e[o]===i&&t.push(i)}return c(t)},p.prototype.not=function(e){for(var t=[],n=this.filter(e).toArray(),i=0;i<this.length;i++)-1===n.indexOf(this[i])&&t.push(this[i]);return c(t)},p.prototype.is=function(e){return!!this.filter(e).length},p.prototype.children=function(e){for(var t=[],n=0;n<this.length;n++)for(var i=this[n]?this[n].childNodes:[],o=0;o<i.length;o++)a.default.isElementNode(i[o])&&t.push(i[o]);return t=c(t),e?t.filter(e):t},p.prototype.siblings=function(){var e=this[0];if(!e||!e.parentNode)return c();for(var t=[],n=e.parentNode.childNodes||[],i=0;i<n.length;i++){var o=n[i];a.default.isElementNode(o)&&o!==e&&t.push(o)}return c(t)},p.prototype.each=function(e){for(var t=0;t<this.length&&!1!==e.call(this[t],t,this[t]);t++);},p.prototype.index=function(e){return e?(e=c(e),this.toArray().indexOf(e[0])):this.parent().children().index(this)},p.prototype.get=function(e){return this[e<0?this.length+e:e]},p.prototype.eq=function(e){return e=e<0?this.length+e:e,c(this[e])},p.prototype.first=function(){return this.eq(0)},p.prototype.last=function(){return this.eq(-1)},p.prototype.parent=function(e){if(!this[0])return c();var t=c(this[0].parentNode);return!e||t.is(e)?t:c()},p.prototype.parents=function(e){for(var t=[],n=this.parent();n&&n[0]&&!a.default.isDocument(n[0]);)a.default.isElementNode(n[0])&&(e&&!n.is(e)||t.push(n.get(0))),n=n.parent();return c(t)},p.prototype.closest=function(e){if(this.is(e))return this;for(var t=this.parent();t&&t.length;){if(t.is(e))return t;t=t.parent()}return c()},p.prototype.next=function(e){if(!this[0])return c();var t=c(this[0].nextSibling);if(!arguments.length)return t;for(;t&&t.length;){if(t.is(e))return t;t=t.next()}return c()},p.prototype.prev=function(){return this[0]?c(this[0].previousSibling):c()},p.prototype.add=function(e){for(var t=c(e),n=this.toArray(),i=0;i<t.length;i++){var o=t[i];-1===n.indexOf(o)&&n.push(o)}return c(n)};var y=[];p.prototype.splice=function(){return c(y.splice.apply(this,arguments))},p.prototype.slice=function(){return c(y.slice.apply(this,arguments))},p.prototype.toArray=function(){return y.slice.call(this)},p.prototype.offset=function(){if(this[0])return(0,u.getOffset)(this[0])},p.prototype.offsetParent=function(){if(!this[0])return c();for(var e=c(this[0].offsetParent);e[0]&&"static"===e.css("position");)e=c(e[0].offsetParent);return e=e[0]?e:c(a.default.getDocumentElement())},p.prototype.position=function(){if(this[0]){var e,t=parseFloat(this.css("marginTop")),n=parseFloat(this.css("marginLeft"));if("fixed"===this.css("position"))return{top:(e=this[0].getBoundingClientRect()).top-t,left:e.left-n};e=this.offset();var i=this.offsetParent(),o={top:0,left:0};return"HTML"!==i[0].nodeName&&(o=i.offset()),o={top:o.top+parseFloat(i.css("borderTopWidth")),left:o.left+parseFloat(i.css("borderLeftWidth"))},{top:e.top-o.top-t,left:e.left-o.left-n}}},[{name:"scrollLeft",offsetProp:"pageXOffset",scrollWindow:function(e,t){e.scrollTo(t,e.pageYOffset)}},{name:"scrollTop",offsetProp:"pageYOffset",scrollWindow:function(e,t){e.scrollTo(e.pageXOffset,t)}}].forEach((function(e){var t=e.name;p.prototype[t]=function(n){if(this[0]){var i=(0,u.getWindowByElement)(this[0]);return void 0===n?i?i[e.offsetProp]:this[0][t]:(i?e.scrollWindow(i,n):this[0][t]=n,this)}}})),p.prototype.data=function(e,t){if(this[0])return arguments.length<2?o.data.call(c,this[0],e):(o.data.call(c,this[0],e,t),this)},p.prototype.removeData=function(e){return this[0]&&(0,o.removeData)(this[0],e),this};var b=function(){return c.apply(this,arguments)};Object.defineProperty(b,"fn",{enumerable:!0,configurable:!0,get:function(){return c.fn},set:function(e){c.fn=e}});var x={set:function(e){c=e},get:function(){return b}};t.default=x,e.exports=t.default,e.exports.default=t.default},91784:function(e,t,n){t.default=void 0;var i=n(20576),o=n(58201),a=(0,o.getWindow)(),r={observe:i.noop,unobserve:i.noop,disconnect:i.noop},s=new(function(){function e(){var e=this;if(!(0,o.hasWindow)()||!a.ResizeObserver)return r;this._callbacksMap=new Map,this._observer=new a.ResizeObserver((function(t){t.forEach((function(t){var n;null===(n=e._callbacksMap.get(t.target))||void 0===n||n(t)}))}))}var t=e.prototype;return t.observe=function(e,t){this._callbacksMap.set(e,t),this._observer.observe(e)},t.unobserve=function(e){this._callbacksMap.delete(e),this._observer.unobserve(e)},t.disconnect=function(){this._callbacksMap.clear(),this._observer.disconnect()},e}());t.default=s,e.exports=t.default,e.exports.default=t.default},14192:function(e,t,n){t.TemplateManager=void 0;var i,o=(i=n(68374))&&i.__esModule?i:{default:i},a=n(35922),r=n(20576),s=n(13306),l=n(68494),u=n(10688),d=n(69697);function c(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}var h=new l.FunctionTemplate((function(e){var t=e.model,n=e.parent,i=t.widget;if(!i)return(0,o.default)();var a=(0,o.default)("<div>"),r=t.options||{};return n?n._createComponent(a,i,r):a[i](r),a})),p=function(){function e(e,t){this._tempTemplates=[],this._defaultTemplates={},this._anonymousTemplateName=t||"template",this._createElement=e||d.defaultCreateElement,this._createTemplateIfNeeded=this._createTemplateIfNeeded.bind(this)}e.createDefaultOptions=function(){return{integrationOptions:{watchMethod:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};return n.skipImmediate||t(e()),r.noop},templates:{"dx-polymorph-widget":h},useDeferUpdateForTemplates:!0}}};var t,n,i,p=e.prototype;return p.addDefaultTemplates=function(e){this._defaultTemplates=(0,s.extend)({},this._defaultTemplates,e)},p.dispose=function(){this._tempTemplates.forEach((function(e){e.template.dispose&&e.template.dispose()})),this._tempTemplates=[]},p.extractTemplates=function(e){return{templates:this._extractTemplates(e),anonymousTemplateMeta:this._extractAnonymousTemplate(e)}},p._extractTemplates=function(e){var t=this,n=(0,d.findTemplates)(e,"dxTemplate"),i=(0,d.suitableTemplatesByName)(n);return n.forEach((function(e){var t=e.element,n=e.options.name;t===i[n]?(0,o.default)(t).addClass("dx-template-wrapper").detach():(0,o.default)(t).remove()})),Object.keys(i).map((function(e){return{name:e,template:t._createTemplate(i[e])}}))},p._extractAnonymousTemplate=function(e){var t=e.contents().detach();return t.filter((function(e,t){var n=3===t.nodeType,i=(0,o.default)(t).text().trim().length<1;return!(n&&i)})).length>0?{template:this._createTemplate(t),name:this._anonymousTemplateName}:{}},p._createTemplateIfNeeded=function(e){var t=this._tempTemplates.filter((function(t){return t.source===(0,d.templateKey)(e)}))[0];if(t)return t.template;var n=this._createTemplate(e);return this._tempTemplates.push({template:n,source:(0,d.templateKey)(e)}),n},p._createTemplate=function(e){return this._createElement((0,d.validateTemplateSource)(e))},p.getTemplate=function(e,t,n,i){var r=this,s=n.isAsyncTemplate,c=n.skipTemplates;return(0,a.isFunction)(e)?new l.FunctionTemplate((function(n){var h=e.apply(i,(0,d.getNormalizedTemplateArgs)(n));if(!(0,a.isDefined)(h))return new u.EmptyTemplate;var p=!1,f=(0,d.acquireTemplate)(h,(function(e){return e.nodeType||(0,a.isRenderer)(e)&&!(0,o.default)(e).is("script")?new l.FunctionTemplate((function(){return e})):(p=!0,r._createTemplate(e))}),t,s,c,r._defaultTemplates),g=f.render(n);return p&&f.dispose&&f.dispose(),g})):(0,d.acquireTemplate)(e,this._createTemplateIfNeeded,t,s,c,this._defaultTemplates)},t=e,(n=[{key:"anonymousTemplateName",get:function(){return this._anonymousTemplateName}}])&&c(t.prototype,n),i&&c(t,i),Object.defineProperty(t,"prototype",{writable:!1}),e}();t.TemplateManager=p},93280:function(e,t,n){t.BindableTemplate=void 0;var i=l(n(68374)),o=n(81033),a=l(n(55994)),r=n(29007),s=n(35922);function l(e){return e&&e.__esModule?e:{default:e}}function u(e,t){return(u=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}var d=function(e,t,n,i,o){var a,r=function(e,t,n){return t((function(){return e}),n)}(e,t,(function(e){a&&a(),(0,s.isPrimitive)(e)?o(e):a=function(e,t,n,i,o){var a={},r=n.slice(),s=n.map((function(n){var s=i[n];return t(s?function(){return s(e)}:function(){return e[n]},(function(e){if(a[n]=e,r.length){var t=r.indexOf(n);t>=0&&r.splice(t,1)}r.length||o(a)}))}));return function(){s.forEach((function(e){return e()}))}}(e,t,n,i,o)}));return function(){a&&a(),r&&r()}},c=function(e){var t,n;function o(t,n,i,o){var a;return(a=e.call(this)||this)._render=t,a._fields=n,a._fieldsMap=o||{},a._watchMethod=i,a}return n=e,(t=o).prototype=Object.create(n.prototype),t.prototype.constructor=t,u(t,n),o.prototype._renderCore=function(e){var t=this,n=(0,i.default)(e.container),o=d(e.model,this._watchMethod,this._fields,this._fieldsMap,(function(i){n.empty(),t._render(n,i,e.model)}));return a.default.on(n,r.removeEvent,o),n.contents()},o}(o.TemplateBase);t.BindableTemplate=c},91627:function(e,t,n){function i(e,t){return(i=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}t.ChildDefaultTemplate=void 0;var o=function(e){var t,n;function o(t){var n;return(n=e.call(this)||this).name=t,n}return n=e,(t=o).prototype=Object.create(n.prototype),t.prototype.constructor=t,i(t,n),o}(n(81033).TemplateBase);t.ChildDefaultTemplate=o},10688:function(e,t,n){t.EmptyTemplate=void 0;var i,o=(i=n(68374))&&i.__esModule?i:{default:i};function a(e,t){return(a=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}var r=function(e){var t,n;function i(){return e.apply(this,arguments)||this}return n=e,(t=i).prototype=Object.create(n.prototype),t.prototype.constructor=t,a(t,n),i.prototype._renderCore=function(){return(0,o.default)()},i}(n(81033).TemplateBase);t.EmptyTemplate=r},68494:function(e,t,n){t.FunctionTemplate=void 0;var i=n(81033),o=n(3532);function a(e,t){return(a=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}var r=function(e){var t,n;function i(t){var n;return(n=e.call(this)||this)._render=t,n}return n=e,(t=i).prototype=Object.create(n.prototype),t.prototype.constructor=t,a(t,n),i.prototype._renderCore=function(e){return(0,o.normalizeTemplateElement)(this._render(e))},i}(i.TemplateBase);t.FunctionTemplate=r},9545:function(e,t,n){t.Template=void 0;var i,o=(i=n(68374))&&i.__esModule?i:{default:i},a=n(81033),r=n(3532),s=n(72987);function l(e,t){return(l=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}n(32468),(0,s.registerTemplateEngine)("default",{compile:function(e){return(0,r.normalizeTemplateElement)(e)},render:function(e,t,n){return e.clone()}}),(0,s.setTemplateEngine)("default");var u=function(e){var t,n;function i(t){var n;return(n=e.call(this)||this)._element=t,n}n=e,(t=i).prototype=Object.create(n.prototype),t.prototype.constructor=t,l(t,n);var a=i.prototype;return a._renderCore=function(e){var t=e.transclude;return t||this._compiledTemplate||(this._compiledTemplate=(0,s.getCurrentTemplateEngine)().compile(this._element)),(0,o.default)("<div>").append(t?this._element:(0,s.getCurrentTemplateEngine)().render(this._compiledTemplate,e.model,e.index)).contents()},a.source=function(){return(0,o.default)(this._element).clone()},i}(a.TemplateBase);t.Template=u},81033:function(e,t,n){t.renderedCallbacks=t.TemplateBase=void 0;var i=u(n(68374)),o=u(n(73349)),a=u(n(44504)),r=n(3532),s=n(80506),l=u(n(17381));function u(e){return e&&e.__esModule?e:{default:e}}var d=(0,a.default)({syncStrategy:!0});t.renderedCallbacks=d;var c=function(){function e(){}var t=e.prototype;return t.render=function(e){var t,n=(e=e||{}).onRendered;return delete e.onRendered,t=e.renovated&&e.transclude&&this._element?(0,i.default)("<div>").append(this._element).contents():this._renderCore(e),this._ensureResultInContainer(t,e.container),d.fire(t,e.container),n&&n(),t},t._ensureResultInContainer=function(e,t){if(t){var n=(0,i.default)(t),a=(0,r.contains)(n.get(0),e.get(0));if(n.append(e),!a)o.default.getBody().contains(n.get(0))&&(0,s.triggerShownEvent)(e)}},t._renderCore=function(){throw l.default.Error("E0001")},e}();t.TemplateBase=c},72987:function(e,t,n){t.getCurrentTemplateEngine=function(){return r},t.registerTemplateEngine=function(e,t){s[e]=t},t.setTemplateEngine=function(e){if((0,o.isString)(e)){if(!(r=s[e]))throw a.default.Error("E0020",e)}else r=e};var i,o=n(35922),a=(i=n(17381))&&i.__esModule?i:{default:i};var r,s={}},32468:function(e,t,n){var i=n(3532),o=n(72987);(0,o.registerTemplateEngine)("jquery-tmpl",{compile:function(e){return(0,i.extractTemplateMarkup)(e)},render:function(e,t){return jQuery.tmpl(e,t)}}),(0,o.registerTemplateEngine)("jsrender",{compile:function(e){return(jQuery||jsrender).templates((0,i.extractTemplateMarkup)(e))},render:function(e,t){return e.render(t)}}),(0,o.registerTemplateEngine)("mustache",{compile:function(e){return(0,i.extractTemplateMarkup)(e)},render:function(e,t){return Mustache.render(e,t)}}),(0,o.registerTemplateEngine)("hogan",{compile:function(e){return Hogan.compile((0,i.extractTemplateMarkup)(e))},render:function(e,t){return e.render(t)}}),(0,o.registerTemplateEngine)("underscore",{compile:function(e){return _.template((0,i.extractTemplateMarkup)(e))},render:function(e,t){return e(t)}}),(0,o.registerTemplateEngine)("handlebars",{compile:function(e){return Handlebars.compile((0,i.extractTemplateMarkup)(e))},render:function(e,t){return e(t)}}),(0,o.registerTemplateEngine)("doT",{compile:function(e){return doT.template((0,i.extractTemplateMarkup)(e))},render:function(e,t){return e(t)}})},37208:function(e,t,n){t.default=void 0;var i=n(62754),o=d(n(73349)),a=d(n(83448)),r=n(58201),s=n(13306),l=n(35922),u=d(n(20476));function d(e){return e&&e.__esModule?e:{default:e}}var c=(0,r.getWindow)(),h=function(e){var t=o.default.createElement("script");for(var n in e)t[n]=e[n];return t},p=function(e){e.parentNode.removeChild(e)},f=function(e){return o.default.getHead().appendChild(e)},g=function(e){var t=h({text:e});f(t),p(t)},m=function(e,t){var n=e.data,i="string"==typeof n,o=e.url||c.location.href;return i||e.cache||((n=n||{})._=Date.now()),n&&!e.upload&&(i||(n=function(e){var t=[];for(var n in e){var i=e[n];void 0!==i&&(null===i&&(i=""),"function"==typeof i&&(i=i()),t.push(encodeURIComponent(n)+"="+encodeURIComponent(i)))}return t.join("&")}(n)),"GET"===_(e)?(""!==n&&(o+=(o.indexOf("?")>-1?"&":"?")+n),n=null):t["Content-Type"]&&t["Content-Type"].indexOf("application/x-www-form-urlencoded")>-1&&(n=n.replace(/%20/g,"+"))),{url:o,parameters:n}};function _(e){return(e.method||"GET").toUpperCase()}var v=function(e){var t=e.headers||{};return t["Content-Type"]=t["Content-Type"]||function(e){var t;return e.data&&!e.upload&&"GET"!==_(e)&&(t="application/x-www-form-urlencoded;charset=utf-8"),e.contentType||t}(e),t.Accept=t.Accept||function(e){var t=e.dataType||"*",n="text/javascript, application/javascript, application/ecmascript, application/x-ecmascript",i={"*":"*/*",text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript",jsonp:n,script:n};return(0,s.extendFromObject)(i,e.accepts,!0),i[t]?i[t]+("*"!==t?", */*; q=0.01":""):i["*"]}(e),e.crossDomain||t["X-Requested-With"]||(t["X-Requested-With"]="XMLHttpRequest"),t},y=(0,u.default)({sendRequest:function(e){var t,n=a.default.getXhr(),s=new i.Deferred,u=s.promise(),d=!(0,l.isDefined)(e.async)||e.async,y=e.dataType,b=e.timeout||0;e.crossDomain=function(e){if(!(0,r.hasWindow)())return!0;var t=!1,n=o.default.createElement("a"),i=o.default.createElement("a");n.href=c.location.href;try{i.href=e,i.href=i.href,t=n.protocol+"//"+n.host!=i.protocol+"//"+i.host}catch(e){t=!0}return t}(e.url);var x="jsonp"===y||"script"===y;void 0===e.cache&&(e.cache=!x);var w=function(e){if("jsonp"===e.dataType){var t=Math.random().toString().replace(/\D/g,""),n=e.jsonpCallback||"dxCallback"+Date.now()+"_"+t,i=e.jsonp||"callback";return e.data=e.data||{},e.data[i]=n,n}}(e),C=v(e),S=m(e,C),k=S.url,D=S.parameters;if(w&&(c[w]=function(e){s.resolve(e,"success",n)}),e.crossDomain&&x){return function(e){var t=h({src:e});return new Promise((function(e,n){var i={load:e,error:n},a=function(e){i[e.type](),p(t)};for(var r in i)o.default.listen(t,r,a);f(t)}))}(k).then((function(){"jsonp"!==y&&s.resolve(null,"success",n)}),(function(){s.reject(n,"error")})),u}if(e.crossDomain&&!("withCredentials"in n))return s.reject(n,"error"),u;if(n.open(_(e),k,d,e.username,e.password),d&&(n.timeout=b,t=function(e,t){return e&&setTimeout((function(){t.customStatus="timeout",t.abort()}),e)}(b,n)),n.onreadystatechange=function(e){var i;4===n.readyState&&(clearTimeout(t),200<=(i=n.status)&&i<300?function(e){return 204!==e}(n.status)?function(e,t,n){var i=function(e){return e.responseType&&"text"!==e.responseType||"string"!=typeof e.responseText?e.response:e.responseText}(t);switch(n){case"jsonp":g(i);break;case"script":g(i),e.resolve(i,"success",t);break;case"json":try{e.resolve(JSON.parse(i),"success",t)}catch(n){e.reject(t,"parsererror",n)}break;default:e.resolve(i,"success",t)}}(s,n,y):s.resolve(null,"nocontent",n):s.reject(n,n.customStatus||"error"))},e.upload&&(n.upload.onprogress=e.upload.onprogress,n.upload.onloadstart=e.upload.onloadstart,n.upload.onabort=e.upload.onabort),e.xhrFields)for(var I in e.xhrFields)n[I]=e.xhrFields[I];for(var T in"arraybuffer"===e.responseType&&(n.responseType=e.responseType),C)Object.prototype.hasOwnProperty.call(C,T)&&(0,l.isDefined)(C[T])&&n.setRequestHeader(T,C[T]);return e.beforeSend&&e.beforeSend(n),n.send(D),u.abort=function(){n.abort()},u}});t.default=y,e.exports=t.default,e.exports.default=t.default},89386:function(e,t,n){t.wrapToArray=t.removeDuplicates=t.normalizeIndexes=t.groupBy=t.getUniqueValues=void 0;var i,o=n(35922),a=n(48013),r=(i=n(80209))&&i.__esModule?i:{default:i};function s(e){return function(e){if(Array.isArray(e))return l(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return l(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return l(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function l(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}t.wrapToArray=function(e){return Array.isArray(e)?e:[e]};t.getUniqueValues=function(e){return s(new Set(e))};t.removeDuplicates=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],n=t.reduce((function(e,t){var n;return e[t]=(null!==(n=e[t])&&void 0!==n?n:0)+1,e}),{});return e.filter((function(e){return!n[e]--}))};t.normalizeIndexes=function(e,t,n,i){var s={},l=(0,r.default)().useLegacyVisibleIndex,u=0,d=function(e){return!(0,o.isDefined)(e[t])&&(!i||i(e))};e.forEach((function(e){var i=e[t];i>=0?(s[i]=s[i]||[],e===n?s[i].unshift(e):s[i].push(e)):e[t]=void 0})),l||e.forEach((function(e){if(d(e)){for(;s[u];)u++;s[u]=[e],u++}})),u=0,(0,a.orderEach)(s,(function(e,n){n.forEach((function(n){e>=0&&(n[t]=u++)}))})),l&&e.forEach((function(e){d(e)&&(e[t]=u++)}))};t.groupBy=function(e,t){return e.reduce((function(e,n){var i,o=t(n);return e[o]=null!==(i=e[o])&&void 0!==i?i:[],e[o].push(n),e}),{})}},34671:function(e,t,n){t.isKeysEqual=t.findChanges=void 0;var i=n(35922),o=function(e,t){var n=t(e);if((0,i.isObject)(n))try{return JSON.stringify(n)}catch(e){return n}return n},a=function(e,t,n,i){return t[n[o(e,i)]]};t.isKeysEqual=function(e,t){if(e.length!==t.length)return!1;for(var n=0;n<t.length;n++)if(e[n]!==t[n])return!1;return!0};t.findChanges=function(e,t,n,i){var r={},s={},l=0,u=0,d=[];e.forEach((function(e,t){var i=o(e,n);r[i]=t})),t.forEach((function(e,t){var i=o(e,n);s[i]=t}));for(var c=Math.max(e.length,t.length),h=0;h<c+l;h++){var p=t[h],f=h-l+u,g=e[f];if(!p||g&&!a(g,t,s,n))g&&(d.push({type:"remove",key:n(g),index:h,oldItem:g}),u++,h--);else{var m=o(p,n),_=r[m],v=e[_];if(v){if(_!==f)return;i(v,p)||d.push({type:"update",data:p,key:n(p),index:h,oldItem:v})}else l++,d.push({type:"insert",data:p,index:h})}}return d}},47810:function(e,t,n){t.default=void 0;var i=n(13306),o=(0,n(58201).getNavigator)(),a=/(webkit)[ /]([\w.]+)/,r=/(mozilla)(?:.*? rv:([\w.]+))/,s=function(e){e=e.toLowerCase();var t={},n=a.exec(e)||e.indexOf("compatible")<0&&r.exec(e)||[],i=n[1],o=n[2];return"webkit"===i&&(t.webkit=!0,e.indexOf("chrome")>=0||e.indexOf("crios")>=0?(i="chrome",o=(o=/(?:chrome|crios)\/(\d+\.\d+)/.exec(e))&&o[1]):e.indexOf("fxios")>=0?(i="mozilla",o=(o=/fxios\/(\d+\.\d+)/.exec(e))&&o[1]):e.indexOf("safari")>=0&&/version|phantomjs/.test(e)?(i="safari",o=(o=/(?:version|phantomjs)\/([0-9.]+)/.exec(e))&&o[1]):(i="unknown",o=(o=/applewebkit\/([0-9.]+)/.exec(e))&&o[1])),i&&(t[i]=!0,t.version=o),t},l=(0,i.extend)({_fromUA:s},s(o.userAgent));t.default=l,e.exports=t.default,e.exports.default=t.default},39618:function(e,t){t.default=void 0;var n=function(e){var t,n=function(){return t=e.apply(this,arguments),n=function(){return t},t};return function(){return n.apply(this,arguments)}};t.default=n,e.exports=t.default,e.exports.default=t.default},44504:function(e,t){t.default=void 0;var n=function(e){this._options=e||{},this._list=[],this._queue=[],this._firing=!1,this._fired=!1,this._firingIndexes=[]};n.prototype._fireCore=function(e,t){var n=this._firingIndexes,i=this._list,o=this._options.stopOnFalse,a=n.length;for(n[a]=0;n[a]<i.length;n[a]++){if(!1===i[n[a]].apply(e,t)&&o)break}n.pop()},n.prototype.add=function(e){return"function"!=typeof e||this._options.unique&&this.has(e)||this._list.push(e),this},n.prototype.remove=function(e){var t=this._list,n=this._firingIndexes,i=t.indexOf(e);if(i>-1&&(t.splice(i,1),this._firing&&n.length))for(var o=0;o<n.length;o++)i<=n[o]&&n[o]--;return this},n.prototype.has=function(e){var t=this._list;return e?t.indexOf(e)>-1:!!t.length},n.prototype.empty=function(e){return this._list=[],this},n.prototype.fireWith=function(e,t){var n=this._queue;if(t=(t=t||[]).slice?t.slice():t,this._options.syncStrategy)this._firing=!0,this._fireCore(e,t);else{if(n.push([e,t]),this._firing)return;for(this._firing=!0;n.length;){var i=n.shift();this._fireCore(i[0],i[1])}}return this._firing=!1,this._fired=!0,this},n.prototype.fire=function(){this.fireWith(this,arguments)},n.prototype.fired=function(){return this._fired};var i=function(e){return new n(e)};t.default=i,e.exports=t.default,e.exports.default=t.default},20576:function(e,t,n){t.splitPair=t.pairToObject=t.normalizeKey=t.noop=t.grep=t.getKeyHash=t.findBestMatches=t.executeAsync=t.escapeRegExp=t.equalByValue=t.ensureDefined=t.denormalizeKey=t.deferUpdater=t.deferUpdate=t.deferRenderer=t.deferRender=t.asyncNoop=t.applyServerDecimalSeparator=void 0;var i=u(n(80209)),o=u(n(73176)),a=n(62754),r=n(47617),s=n(95479),l=n(35922);function u(e){return e&&e.__esModule?e:{default:e}}t.ensureDefined=function(e,t){return(0,l.isDefined)(e)?e:t};t.executeAsync=function(e,t){var n=new a.Deferred,i=t||this,o={promise:n.promise(),abort:function(){clearTimeout(s),n.rejectWith(i)}},r=function(){var t=e.call(i);t&&t.done&&(0,l.isFunction)(t.done)?t.done((function(){n.resolveWith(i)})):n.resolveWith(i)},s=(arguments[2]||setTimeout)(r,"number"==typeof t?t:0);return o};var d,c=[],h=[],p=[],f=function(e,t,n){if(d&&d!==e)return c.push(t),h.push(e),n=n||new a.Deferred,p.push(n),n;var i=d,o=p.length;d=e;var r=t();return r||(p.length>o?r=a.when.apply(this,p.slice(o)):n&&n.resolve()),d=i,n&&r&&r.done&&r.done(n.resolve).fail(n.reject),!d&&c.length&&("render"===h.shift()?g:m)(c.shift(),p.shift()),r||(0,a.when)()},g=function(e,t){return f("render",e,t)};t.deferRender=g;var m=function(e,t){return f("update",e,t)};t.deferUpdate=m;t.deferRenderer=function(e){return function(){var t=this;return f("render",(function(){return e.call(t)}))}};t.deferUpdater=function(e){return function(){var t=this;return f("update",(function(){return e.call(t)}))}};t.findBestMatches=function(e,t,n){var i=[],o=0;return(0,s.each)(t,(function(t,a){var r=0,l=n?n(a):a;(0,s.each)(e,(function(e,t){var n=l[e];if(void 0!==n){if(!_(n,t))return r=-1,!1;r++}})),r<o||(r>o&&(i.length=0,o=r),i.push(a))})),i};var _=function(e,t){if(Array.isArray(e)&&Array.isArray(t)){var n=!1;return(0,s.each)(e,(function(e,i){if(i!==t[e])return n=!0,!1})),!n}return e===t},v=function(e){var t,n;switch((0,l.type)(e)){case"string":return e.split(/\s+/,2);case"object":return[null!==(t=e.x)&&void 0!==t?t:e.h,null!==(n=e.y)&&void 0!==n?n:e.v];case"number":return[e];case"array":return e;default:return null}};t.splitPair=v;t.normalizeKey=function(e){var t=(0,l.isString)(e)?e:e.toString(),n=t.match(/[^a-zA-Z0-9_]/g);return n&&(0,s.each)(n,(function(e,n){t=t.replace(n,"__"+n.charCodeAt()+"__")})),t};t.denormalizeKey=function(e){var t=e.match(/__\d+__/g);return t&&t.forEach((function(t){var n=parseInt(t.replace("__",""));e=e.replace(t,String.fromCharCode(n))})),e};t.pairToObject=function(e,t){var n=v(e),i=t?parseFloat(n&&n[0]):parseInt(n&&n[0],10),o=t?parseFloat(n&&n[1]):parseInt(n&&n[1],10);return isFinite(i)||(i=0),isFinite(o)||(o=i),{h:i,v:o}};t.getKeyHash=function(e){if(e instanceof o.default)return e.toString();if((0,l.isObject)(e)||Array.isArray(e))try{var t=JSON.stringify(e);return"{}"===t?e:t}catch(t){return e}return e};t.escapeRegExp=function(e){return e.replace(/[[\]{}\-()*+?.\\^$|\s]/g,"\\$&")};t.applyServerDecimalSeparator=function(e){var t=(0,i.default)().serverDecimalSeparator;return(0,l.isDefined)(e)&&(e=e.toString().replace(".",t)),e};t.noop=function(){};t.asyncNoop=function(){return(new a.Deferred).resolve().promise()};t.grep=function(e,t,n){for(var i=[],o=!n,a=0;a<e.length;a++)!!t(e[a],a)===o&&i.push(e[a]);return i};var y=function(e,t,n){if(e.length!==t.length)return!1;for(var i=0;i<e.length;i++)if(!x(e[i],t[i],n+1))return!1;return!0},b=function(e,t,n,i){for(var o in e)if(Object.prototype.hasOwnProperty.call(e,o)&&!x(e[o],t[o],n+1,i))return!1;for(var a in t)if(!(a in e))return!1;return!0},x=function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,i=!(arguments.length>3&&void 0!==arguments[3])||arguments[3];e=(0,r.toComparable)(e,!0),t=(0,r.toComparable)(t,!0);var o=i?e===t:e==t;return!!(o||n>=3)||((0,l.isObject)(e)&&(0,l.isObject)(t)?b(e,t,n,i):!(!Array.isArray(e)||!Array.isArray(t))&&y(e,t,n))};t.equalByValue=x},49036:function(e,t,n){t.equals=void 0;var i,o=(i=n(73349))&&i.__esModule?i:{default:i},a=n(47617),r=n(35922);function s(e){return(s="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}t.equals=function(e,t){return e=(0,a.toComparable)(e,!0),t=(0,a.toComparable)(t,!0),e&&t&&(0,r.isRenderer)(e)&&(0,r.isRenderer)(t)?t.is(e):!(e==e||t==t)||(0===e&&0===t?function(e,t){return 1/e==1/t}(e,t):!(null!==e&&"object"===s(e)&&!o.default.isElementNode(e))&&e===t)}},30869:function(e,t,n){t.logger=t.debug=void 0;var i=n(35922),o=function(){},a=function(e){return"undefined"!=typeof console&&(0,i.isFunction)(console[e])?console[e].bind(console):o},r={info:a("info"),warn:a("warn"),error:a("error")};t.logger=r;var s=function(){function e(e,t){if(!e)throw new Error(t)}return{assert:e,assertParam:function(t,n){e(null!=t,n)}}}();t.debug=s},47617:function(e,t,n){t.toComparable=t.getPathParts=t.compileSetter=t.compileGetter=void 0;var i=u(n(17381)),o=u(n(38377)),a=n(48013),r=n(35922),s=n(95479),l=u(n(26974));function u(e){return e&&e.__esModule?e:{default:e}}var d=l.default.unwrap,c=l.default.isWrapped,h=l.default.assign,p=function(e){return(t=e,t.replace(/\[/g,".").replace(/\]/g,"")).split(".");var t};t.getPathParts=p;var f=function(e,t,n,o){if("this"===t)throw new i.default.Error("E4016");var a=e[t];o.unwrapObservables&&c(a)?h(a,n):e[t]=n},g=function(e){return(e=e||{}).unwrapObservables=void 0===e.unwrapObservables||e.unwrapObservables,e};function m(e,t){return t.unwrapObservables?d(e):e}var _=function(e){if(arguments.length>1&&(e=[].slice.call(arguments)),!e||"this"===e)return function(e){return e};if("string"==typeof e){var t=p(e);return function(e,n){for(var i=(n=g(n)).functionsAsIs,o=("defaultValue"in n),a=m(e,n),s=0;s<t.length;s++){if(!a){if(null==a&&o)return n.defaultValue;break}var l=t[s];if(o&&(0,r.isObject)(a)&&!(l in a))return n.defaultValue;var u=m(a[l],n);!i&&(0,r.isFunction)(u)&&(u=u.call(a)),a=u}return a}}return Array.isArray(e)?v(e):(0,r.isFunction)(e)?e:void 0};function v(e){for(var t={},n=0,i=e.length;n<i;n++){var o=e[n];t[o]=_(o)}return function(e,n){var i;return(0,s.each)(t,(function(t){var o=this(e,n);if(void 0!==o){for(var a=i||(i={}),r=t.split("."),s=r.length-1,l=0;l<s;l++){var u=r[l];u in a||(a[u]={}),a=a[u]}a[r[s]]=o}})),i}}t.compileGetter=_;var y=function(e,t,n,i){if((0,r.isDefined)(n))return n;var o={};return f(e,t,o,i),o};t.compileSetter=function(e){var t=(e=p(e||"this")).length-1;return function(n,i,o){var s=m(n,o=g(o));e.forEach((function(e,n){var l=function(e,t,n){return n=n||{},m("this"===t?e:e[t],n)}(s,e,o),u=!o.functionsAsIs&&(0,r.isFunction)(l)&&!c(l);n===t?o.merge&&(0,r.isPlainObject)(i)&&(!(0,r.isDefined)(l)||(0,r.isPlainObject)(l))?(l=y(s,e,l,o),(0,a.deepExtendArraySafe)(l,i,!1,!0)):u?s[e](i):f(s,e,i,o):(l=y(s,e,l,o),u&&(l=l.call(s)),s=l)}))}};t.toComparable=function(e,t){return e instanceof Date?e.getTime():e&&e instanceof o.default&&e.valueOf?e.valueOf():t||"string"!=typeof e?e:e.toLowerCase()}},91198:function(e,t,n){t.default=void 0;var i=n(35922),o=n(60810),a=n(95479),r=n(78008);function s(e,t,n){return(s=l()?Reflect.construct:function(e,t,n){var i=[null];i.push.apply(i,t);var o=new(Function.bind.apply(e,i));return n&&u(o,n.prototype),o}).apply(null,arguments)}function l(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}function u(e,t){return(u=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}var d=["millisecond","second","minute","hour","day","week","month","quarter","year"],c=function e(t){switch(t){case"millisecond":return 1;case"second":return 1e3*e("millisecond");case"minute":return 60*e("second");case"hour":return 60*e("minute");case"day":return 24*e("hour");case"week":return 7*e("day");case"month":return 30*e("day");case"quarter":return 3*e("month");case"year":return 365*e("day");default:return 0}},h=function(e){var t,n,i,o=["millisecond","second","minute","hour","day","month","year"],a={};for(t=o.length-1;t>=0;t--)i=o[t],(n=Math.floor(e/c(i)))>0&&(a[i+"s"]=n,e-=p(i,n));return a};function p(e,t){return c(e)*t}function f(e){var t,n=-1;return(0,i.isString)(e)?e:(0,i.isObject)(e)?((0,a.each)(e,(function(e,i){for(t=0;t<d.length;t++)i&&(e===d[t]+"s"||e===d[t])&&n<t&&(n=t)})),d[n]):""}var g={millisecond:"millisecond",second:"longtime",minute:"shorttime",hour:"shorttime",day:"day",week:"day",month:"month",quarter:"quarter",year:"year"};var m=function(e){return Math.floor(e/3)},_=function(e){return 3*m(e)};function v(e,t,n,i){e=new Date(e.getTime());var o,a,r=new Date(e.getTime()),s=f(t);switch(s){case"second":e=new Date(1e3*Math.floor(r.getTime()/1e3));break;case"minute":e=new Date(6e4*Math.floor(r.getTime()/6e4));break;case"hour":e=new Date(36e5*Math.floor(r.getTime()/36e5));break;case"year":e.setMonth(0);case"month":e.setDate(1);case"day":e.setHours(0,0,0,0);break;case"week":(e=T(e,i||0)).setHours(0,0,0,0);break;case"quarter":o=_(e.getMonth()),a=e.getMonth(),e.setDate(1),e.setHours(0,0,0,0),a!==o&&e.setMonth(o)}return n&&"hour"!==s&&"minute"!==s&&"second"!==s&&O(r,e),e}function y(e){return v(e,"day")}function b(e,t,n){var o=new Date(e.getTime()),a=(0,i.isString)(t)?C(t.toLowerCase()):(0,i.isNumeric)(t)?h(t):t;return a.years&&o.setFullYear(o.getFullYear()+a.years*n),a.quarters&&o.setMonth(o.getMonth()+3*a.quarters*n),a.months&&o.setMonth(o.getMonth()+a.months*n),a.weeks&&o.setDate(o.getDate()+7*a.weeks*n),a.days&&o.setDate(o.getDate()+a.days*n),a.hours&&o.setTime(o.getTime()+36e5*a.hours*n),a.minutes&&o.setTime(o.getTime()+6e4*a.minutes*n),a.seconds&&o.setTime(o.getTime()+1e3*a.seconds*n),a.milliseconds&&o.setTime(o.getTime()+a.milliseconds*n),o}var x=function(e,t,n){var a=n?-1:1;return(0,i.isDate)(e)?b(e,t,a):(0,o.adjust)(e+t*a,t)};function w(e){return P(e.getFullYear(),e.getMonth()+1,0).getDate()}function C(e){var t={};switch(e){case"year":t.years=1;break;case"month":t.months=1;break;case"quarter":t.months=3;break;case"week":t.weeks=1;break;case"day":t.days=1;break;case"hour":t.hours=1;break;case"minute":t.minutes=1;break;case"second":t.seconds=1;break;case"millisecond":t.milliseconds=1}return t}function S(e,t){return k(e,t)&&e.getMonth()===t.getMonth()}function k(e,t){return e&&t&&e.getFullYear()===t.getFullYear()}function D(e){return e&&e.getFullYear()-e.getFullYear()%100}function I(e){return e&&e.getFullYear()-e.getFullYear()%10}function T(e,t){var n=(e.getDay()-t+7)%7,i=new Date(e);return i.setDate(e.getDate()-n),i}function E(e,t,n){var o=e;return(0,i.isDefined)(e)?((0,i.isDefined)(t)&&e<t&&(o=t),(0,i.isDefined)(n)&&e>n&&(o=n),o):e}function O(e,t){if((0,i.isDefined)(e)){var n=t.getHours()-e.getHours();if(0!==n){var o=1===n||-23===n?-1:1,a=new Date(t.getTime()+36e5*o);(o>0||a.getDate()===t.getDate())&&t.setTime(a.getTime())}}}function A(e,t){return 60*(t.getTimezoneOffset()-e.getTimezoneOffset())*1e3}var P=function(e){var t=s(Date,Array.prototype.slice.call(arguments));return t.setFullYear(e),t},R={dateUnitIntervals:d,convertMillisecondsToDateUnits:h,dateToMilliseconds:function(e){var t=0;return(0,i.isObject)(e)&&(0,a.each)(e,(function(e,n){t+=p(e.substr(0,e.length-1),n)})),(0,i.isString)(e)&&(t=p(e,1)),t},getNextDateUnit:function(e,t){switch(f(e)){case"millisecond":return"second";case"second":return"minute";case"minute":return"hour";case"hour":return"day";case"day":return t?"week":"month";case"week":return"month";case"month":return"quarter";case"quarter":case"year":return"year";default:return 0}},convertDateUnitToMilliseconds:p,getDateUnitInterval:f,getDateFormatByTickInterval:function(e){return g[f(e)]||""},getDatesDifferences:function(e,t){var n=0,i={year:e.getFullYear()!==t.getFullYear(),month:e.getMonth()!==t.getMonth(),day:e.getDate()!==t.getDate(),hour:e.getHours()!==t.getHours(),minute:e.getMinutes()!==t.getMinutes(),second:e.getSeconds()!==t.getSeconds(),millisecond:e.getMilliseconds()!==t.getMilliseconds()};return(0,a.each)(i,(function(e,t){t&&n++})),0===n&&0!==A(e,t)&&(i.hour=!0,n++),i.count=n,i},correctDateWithUnitBeginning:v,trimTime:y,setToDayEnd:function(e){var t=y(e);return t.setDate(t.getDate()+1),new Date(t.getTime()-1)},roundDateByStartDayHour:function(e,t){var n=this.dateTimeFromDecimal(t),i=new Date(e);return(e.getHours()===n.hours&&e.getMinutes()<n.minutes||e.getHours()<n.hours)&&i.setHours(n.hours,n.minutes,0,0),i},dateTimeFromDecimal:function(e){return{hours:Math.floor(e),minutes:e%1*60}},addDateInterval:b,addInterval:x,getSequenceByInterval:function(e,t,n){var o,a=[];for(a.push((0,i.isDate)(e)?new Date(e.getTime()):e),o=e;o<t;)o=x(o,n),a.push(o);return a},getDateIntervalByString:C,sameDate:function(e,t){return S(e,t)&&e.getDate()===t.getDate()},sameMonthAndYear:S,sameMonth:S,sameYear:k,sameDecade:function(e,t){if((0,i.isDefined)(e)&&(0,i.isDefined)(t)){var n=e.getFullYear()-e.getFullYear()%10,o=t.getFullYear()-t.getFullYear()%10;return e&&t&&n===o}},sameCentury:function(e,t){if((0,i.isDefined)(e)&&(0,i.isDefined)(t)){var n=e.getFullYear()-e.getFullYear()%100,o=t.getFullYear()-t.getFullYear()%100;return e&&t&&n===o}},getDifferenceInMonth:function(e){var t=1;return"year"===e&&(t=12),"decade"===e&&(t=120),"century"===e&&(t=1200),t},getDifferenceInMonthForCells:function(e){var t=1;return"decade"===e&&(t=12),"century"===e&&(t=120),t},getFirstYearInDecade:I,getFirstDecadeInCentury:D,getShortDateFormat:function(){return"yyyy/MM/dd"},getViewFirstCellDate:function(e,t){return"month"===e?P(t.getFullYear(),t.getMonth(),1):"year"===e?P(t.getFullYear(),0,t.getDate()):"decade"===e?P(I(t),t.getMonth(),t.getDate()):"century"===e?P(D(t),t.getMonth(),t.getDate()):void 0},getViewLastCellDate:function(e,t){return"month"===e?P(t.getFullYear(),t.getMonth(),w(t)):"year"===e?P(t.getFullYear(),11,t.getDate()):"decade"===e?P(I(t)+9,t.getMonth(),t.getDate()):"century"===e?P(D(t)+90,t.getMonth(),t.getDate()):void 0},getViewDown:function(e){switch(e){case"century":return"decade";case"decade":return"year";case"year":return"month"}},getViewUp:function(e){switch(e){case"month":return"year";case"year":return"decade";case"decade":return"century"}},getLastMonthDay:w,getLastMonthDate:function(e){if((0,i.isDefined)(e))return P(e.getFullYear(),e.getMonth()+1,0)},getFirstMonthDate:function(e){if((0,i.isDefined)(e))return P(e.getFullYear(),e.getMonth(),1)},getFirstWeekDate:T,normalizeDateByWeek:function(e,t){var n=R.getDatesInterval(e,t,"day"),i=new Date(e);return n>=6&&(i=new Date(i.setDate(i.getDate()+7))),i},getQuarter:m,getFirstQuarterMonth:_,dateInRange:function(e,t,n,i){return"date"===i&&(t=t&&R.correctDateWithUnitBeginning(t,"day"),n=n&&R.correctDateWithUnitBeginning(n,"day"),e=e&&R.correctDateWithUnitBeginning(e,"day")),E(e,t,n)===e},intervalsOverlap:function(e){var t=e.firstMin,n=e.firstMax,i=e.secondMin,o=e.secondMax;return t<=i&&i<=n||t>i&&t<o||t<o&&n>o},roundToHour:function(e){var t=new Date(e.getTime());return t.setHours(t.getHours()+1),t.setMinutes(0),t},normalizeDate:E,getViewMinBoundaryDate:function(e,t){var n=P(t.getFullYear(),t.getMonth(),1);return"month"===e?n:(n.setMonth(0),"year"===e||("decade"===e&&n.setFullYear(I(t)),"century"===e&&n.setFullYear(D(t))),n)},getViewMaxBoundaryDate:function(e,t){var n=new Date(t);return n.setDate(w(t)),"month"===e?n:(n.setMonth(11),n.setDate(w(n)),"year"===e||("decade"===e&&n.setFullYear(I(t)+9),"century"===e&&n.setFullYear(D(t)+99)),n)},fixTimezoneGap:O,getTimezonesDifference:A,makeDate:function(e){return new Date(e)},getDatesInterval:function(e,t,n){var i=t.getTime()-e.getTime(),o=c(n)||1;return Math.floor(i/o)},getDatesOfInterval:function(e,t,n){for(var i=[],o=new Date(e.getTime());o<t;)i.push(new Date(o.getTime())),o=this.addInterval(o,n);return i},createDateWithFullYear:P,sameView:function(e,t,n){return R[(0,r.camelize)("same "+e)](t,n)}},M=R;t.default=M,e.exports=t.default,e.exports.default=t.default},69434:function(e,t,n){t.default=void 0;var i=s(n(80209)),o=n(40594),a=s(n(15564)),r=n(35922);function s(e){return e&&e.__esModule?e:{default:e}}var l=/^(\d{4,})(-)?(\d{2})(-)?(\d{2})(?:T(\d{2})(:)?(\d{2})?(:)?(\d{2}(?:\.(\d{1,3})\d*)?)?)?(Z|([+-])(\d{2})(:)?(\d{2})?)?$/,u=/^(\d{2}):(\d{2})(:(\d{2}))?$/,d=["","yyyy","","MM","","dd","THH","","mm","","ss",".SSS"],c=/^(\d{4})\/(\d{2})\/(\d{2})$/,h=function(e,t){var n;return(0,r.isString)(e)&&!t&&(n=function(e){var t=e.match(l);if(!t)return(t=e.match(u))?new Date(0,0,0,p(t[1]),p(t[2]),p(t[4])):void 0;var n=p(t[1]),i=--t[3],o=t[5],a=0,r=0,s=function(e){return n<100&&e.setFullYear(n),e};a=p(t[14]),r=p(t[16]),"-"===t[13]&&(a=-a,r=-r);var d=p(t[6])-a,c=p(t[8])-r,h=p(t[10]),f=(g=t[11],p(g=g||"")*Math.pow(10,3-g.length));var g;if(t[12])return s(new Date(Date.UTC(n,i,o,d,c,h,f)));return s(new Date(n,i,o,d,c,h,f))}(e)),n||function(e){var t="yyyy/MM/dd"===f(e),n=!(0,r.isDate)(e)&&Date.parse(e);if(!n&&t){var i=e.match(c);if(i){var o=new Date(p(i[1]),p(i[2]),p(i[3]));return o.setFullYear(p(i[1])),o.setMonth(p(i[2])-1),o.setDate(p(i[3])),o}}return(0,r.isNumeric)(n)?new Date(n):e}(e)};function p(e){return+e||0}var f=function(e){return"number"==typeof e?"number":(0,r.isString)(e)?((0,i.default)().forceIsoDateParsing&&(t=function(e,t){var n=e.match(l),i="";if(!n)return(n=e.match(u))?n[3]?"HH:mm:ss":"HH:mm":void 0;for(var o=1;o<d.length;o++)n[o]&&(i+=d[o]||n[o]);return"Z"===n[12]&&(i+="'Z'"),n[14]&&(n[15]?i+="xxx":n[16]?i+="xx":i+="x"),i}(e)),t||(e.indexOf(":")>=0?"yyyy/MM/dd HH:mm:ss":"yyyy/MM/dd")):e?null:void 0;var t},g={dateParser:h,deserializeDate:function(e){return"number"==typeof e?new Date(e):h(e,!(0,i.default)().forceIsoDateParsing)},serializeDate:function(e,t){return t?(0,r.isDate)(e)?"number"===t?e&&e.valueOf?e.valueOf():null:(0,o.getFormatter)(t,a.default)(e):null:e},getDateSerializationFormat:f};t.default=g,e.exports=t.default,e.exports.default=t.default},62754:function(e,t,n){t.Deferred=function(){return new l},t.fromPromise=u,t.setStrategy=function(e){l=e.Deferred,d=e.when},t.when=function(){return d.apply(this,arguments)};var i,o=n(35922),a=n(13306),r=(i=n(44504))&&i.__esModule?i:{default:i};var s=[{method:"resolve",handler:"done",state:"resolved"},{method:"reject",handler:"fail",state:"rejected"},{method:"notify",handler:"progress"}],l=function(){var e=this;this._state="pending",this._promise={},s.forEach(function(t){var n=t.method;this[n+"Callbacks"]=new r.default,this[n]=function(){return this[n+"With"](this._promise,arguments)}.bind(this),this._promise[t.handler]=function(t){if(!t)return this;var i=e[n+"Callbacks"];return i.fired()?t.apply(e[n+"Context"],e[n+"Args"]):i.add(function(e,n){t.apply(e,n)}.bind(this)),this}}.bind(this)),this._promise.always=function(e){return this.done(e).fail(e)},this._promise.catch=function(e){return this.then(null,e)},this._promise.then=function(e,t){var n=new l;return["done","fail"].forEach(function(i){var a="done"===i?e:t;this[i]((function(){if(a){var e=a&&a.apply(this,arguments);(0,o.isDeferred)(e)?e.done(n.resolve).fail(n.reject):(0,o.isPromise)(e)?e.then(n.resolve,n.reject):n.resolve.apply(this,(0,o.isDefined)(e)?[e]:arguments)}else n["done"===i?"resolve":"reject"].apply(this,arguments)}))}.bind(this)),n.promise()},this._promise.state=function(){return e._state},this._promise.promise=function(t){return t?(0,a.extend)(t,e._promise):e._promise},this._promise.promise(this)};function u(e,t){if((0,o.isDeferred)(e))return e;if((0,o.isPromise)(e)){var n=new l;return e.then((function(){n.resolveWith.apply(n,[t].concat([[].slice.call(arguments)]))}),(function(){n.rejectWith.apply(n,[t].concat([[].slice.call(arguments)]))})),n}return(new l).resolveWith(t,[e])}s.forEach((function(e){var t=e.method,n=e.state;l.prototype[t+"With"]=function(e,i){var o=this[t+"Callbacks"];return"pending"===this.state()&&(this[t+"Args"]=i,this[t+"Context"]=e,n&&(this._state=n),o.fire(e,i)),this}}));var d=function(){if(1===arguments.length)return u(arguments[0]);for(var e=[].slice.call(arguments),t=[],n=0,i=new l,a=function(o){return function(a){t[o]=this,e[o]=arguments.length>1?[].slice.call(arguments):a,++n===e.length&&i.resolveWith(t,e)}},r=0;r<e.length;r++)(0,o.isDeferred)(e[r])?e[r].promise().done(a(r)).fail(i.reject):n++;return n===e.length&&i.resolveWith(t,e),i.promise()}},20476:function(e,t,n){t.default=function(e){var t=s.default.inherit(e),n=t,i=new n(e),l={},u=function(t,n){(0,r.each)(t,(function(t){(0,a.isFunction)(i[t])?!n&&e[t]||(e[t]=function(){return i[t].apply(e,arguments)}):(n&&(l[t]=e[t]),e[t]=i[t])}))};return u(e,!0),e.inject=function(e){n=n.inherit(e),i=new n,u(e)},e.resetInjection=function(){(0,o.extend)(e,l),n=t,i=new t},e};var i,o=n(13306),a=n(35922),r=n(95479),s=(i=n(38377))&&i.__esModule?i:{default:i};e.exports=t.default,e.exports.default=t.default},3532:function(e,t,n){t.resetActiveElement=t.replaceWith=t.normalizeTemplateElement=t.insertBefore=t.extractTemplateMarkup=t.createTextElementHiddenCopy=t.contains=t.closestCommonParent=t.clipboardText=t.clearSelection=void 0;var i=s(n(73349)),o=s(n(68374)),a=n(95479),r=n(35922);function s(e){return e&&e.__esModule?e:{default:e}}var l=(0,n(58201).getWindow)();t.resetActiveElement=function(){var e,t=i.default.getActiveElement();t&&t!==i.default.getBody()&&(null===(e=t.blur)||void 0===e||e.call(t))};t.clearSelection=function(){var e=l.getSelection();if(e&&"Caret"!==e.type)if(e.empty)e.empty();else if(e.removeAllRanges)try{e.removeAllRanges()}catch(e){}};t.closestCommonParent=function(e,t){var n=(0,o.default)(e),i=(0,o.default)(t);if(n[0]===i[0])return n[0];for(var a=n.parents(),r=i.parents(),s=-Math.min(a.length,r.length);s<0;s++)if(a.get(s)===r.get(s))return a.get(s)};t.extractTemplateMarkup=function(e){var t=(e=(0,o.default)(e)).length&&e.filter((function(){var e=(0,o.default)(this);return e.is("script[type]")&&e.attr("type").indexOf("script")<0}));return t.length?t.eq(0).html():(e=(0,o.default)("<div>").append(e)).html()};t.normalizeTemplateElement=function e(t){var n=(0,r.isDefined)(t)&&(t.nodeType||(0,r.isRenderer)(t))?(0,o.default)(t):(0,o.default)("<div>").html(t).contents();return 1===n.length&&(n.is("script")?n=e(n.html().trim()):n.is("table")&&(n=n.children("tbody").contents())),n};t.clipboardText=function(e,t){var n=e.originalEvent&&e.originalEvent.clipboardData||l.clipboardData;if(!t)return n&&n.getData("Text");n&&n.setData("Text",t)};t.contains=function e(t,n){return!!n&&(i.default.isTextNode(n)&&(n=n.parentNode),i.default.isDocument(t)?t.documentElement.contains(n):(0,r.isWindow)(t)?e(t.document,n):t.contains?t.contains(n):!!(n.compareDocumentPosition(t)&n.DOCUMENT_POSITION_CONTAINS))};t.createTextElementHiddenCopy=function(e,t,n){var i=l.getComputedStyle((0,o.default)(e).get(0)),a=n&&n.includePaddings;return(0,o.default)("<div>").text(t).css({fontStyle:i.fontStyle,fontVariant:i.fontVariant,fontWeight:i.fontWeight,fontSize:i.fontSize,fontFamily:i.fontFamily,letterSpacing:i.letterSpacing,border:i.border,paddingTop:a?i.paddingTop:"",paddingRight:a?i.paddingRight:"",paddingBottom:a?i.paddingBottom:"",paddingLeft:a?i.paddingLeft:"",visibility:"hidden",whiteSpace:"pre",position:"absolute",float:"left"})};var u=function(e,t){return t&&i.default.insertElement(e.parentNode,t,e),e};t.insertBefore=u;t.replaceWith=function(e,t){if(t&&t[0])return t.is(e)?e:((0,a.each)(t,(function(t,n){u(e[0],n)})),e.remove(),t)}},95640:function(e,t,n){t.default=function(e,t){var n={ERROR_MESSAGES:(0,i.extend)(t,e),Error:function(){return d([].slice.call(arguments))},log:function(e){var t="log";/^E\d+$/.test(e)?t="error":/^W\d+$/.test(e)&&(t="warn"),o.logger[t]("log"===t?e:s([].slice.call(arguments)))}};function s(e){var t=e[0];return u(t,l(t,e=e.slice(1)))}function l(e,t){return t=[n.ERROR_MESSAGES[e]].concat(t),a.format.apply(this,t).replace(/\.*\s*?$/,"")}function u(e,t){return a.format.apply(this,["{0} - {1}. See:\n{2}",e,t,c(e)])}function d(e){var t=e[0],n=l(t,e=e.slice(1)),o=c(t),a=u(t,n);return(0,i.extend)(new Error(a),{__id:t,__details:n,url:o})}function c(e){return r+e}return n};var i=n(13306),o=n(30869),a=n(68752),r="http://js.devexpress.com/error/"+n(36739).version.split(".").slice(0,2).join("_")+"/";e.exports=t.default,e.exports.default=t.default},13306:function(e,t,n){t.extendFromObject=t.extend=void 0;var i=n(35922);t.extendFromObject=function(e,t,n){for(var i in e=e||{},t)if(Object.prototype.hasOwnProperty.call(t,i)){var o=t[i];i in e&&!n||(e[i]=o)}return e};t.extend=function e(t){var n=1,o=!1;for("boolean"==typeof(t=t||{})&&(o=t,t=arguments[1]||{},n++);n<arguments.length;n++){var a=arguments[n];if(null!=a)for(var r in a){var s=t[r],l=a[r],u=!1,d=void 0;"__proto__"!==r&&"constructor"!==r&&t!==l&&(o&&l&&((0,i.isPlainObject)(l)||(u=Array.isArray(l)))?(d=u?s&&Array.isArray(s)?s:[]:s&&(0,i.isPlainObject)(s)?s:{},t[r]=e(o,d,l)):void 0!==l&&(t[r]=l))}}return t}},61371:function(e,t,n){t.parseHTML=t.isTablePart=void 0;var i,o=(i=n(73349))&&i.__esModule?i:{default:i};function a(e){return function(e){if(Array.isArray(e))return r(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return r(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return r(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function r(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}var s=/<([a-z][^/\0>\x20\t\r\n\f]+)/i,l={default:{tagsCount:0,startTags:"",endTags:""},thead:{tagsCount:1,startTags:"<table>",endTags:"</table>"},td:{tagsCount:3,startTags:"<table><tbody><tr>",endTags:"</tr></tbody></table>"},col:{tagsCount:2,startTags:"<table><colgroup>",endTags:"</colgroup></table>"},tr:{tagsCount:2,startTags:"<table><tbody>",endTags:"</tbody></table>"}};l.tbody=l.colgroup=l.caption=l.tfoot=l.thead,l.th=l.td;t.parseHTML=function(e){if("string"!=typeof e)return null;var t=o.default.createDocumentFragment().appendChild(o.default.createElement("div")),n=s.exec(e),i=n&&n[1].toLowerCase(),r=l[i]||l.default;t.innerHTML=r.startTags+e+r.endTags;for(var u=0;u<r.tagsCount;u++)t=t.lastChild;return a(t.childNodes)};t.isTablePart=function(e){var t=s.exec(e);return t&&t[1]in l}},44899:function(e,t,n){t.getImageSourceType=t.getImageContainer=void 0;var i,o=(i=n(68374))&&i.__esModule?i:{default:i};var a=function(e){return!(!e||"string"!=typeof e)&&(/^\s*<svg[^>]*>(.|\r?\n)*?<\/svg>\s*$/i.test(e)?"svg":/data:.*base64|\.|[^<\s]\//.test(e)?"image":/^[\w-_]+$/.test(e)?"dxIcon":!!/^\s?([\w-_]\s?)+$/.test(e)&&"fontIcon")};t.getImageSourceType=a;t.getImageContainer=function(e){switch(a(e)){case"image":return(0,o.default)("<img>").attr("src",e).addClass("dx-icon");case"fontIcon":return(0,o.default)("<i>").addClass("".concat("dx-icon"," ").concat(e));case"dxIcon":return(0,o.default)("<i>").addClass("".concat("dx-icon"," ").concat("dx-icon","-").concat(e));case"svg":return(0,o.default)("<i>").addClass("".concat("dx-icon"," ").concat("dx-svg-icon")).append(e);default:return null}}},78008:function(e,t,n){t.underscore=t.titleize=t.humanize=t.dasherize=t.captionize=t.camelize=void 0;var i=n(95479),o=function(e){return null==e?"":String(e)},a=function(e){return o(e).charAt(0).toUpperCase()+e.substr(1)},r=function(e){return o(e).replace(/([a-z\d])([A-Z])/g,"$1 $2").split(/[\s_-]+/)},s=function(e){return(0,i.map)(r(e),(function(e){return e.toLowerCase()})).join("-")};t.dasherize=s;t.underscore=function(e){return s(e).replace(/-/g,"_")};t.camelize=function(e,t){return(0,i.map)(r(e),(function(e,n){return e=e.toLowerCase(),(t||n>0)&&(e=a(e)),e})).join("")};t.humanize=function(e){return a(s(e).replace(/-/g," "))};t.titleize=function(e){return(0,i.map)(r(e),(function(e){return a(e.toLowerCase())})).join(" ")};var l=["0","1","2","3","4","5","6","7","8","9"];t.captionize=function(e){var t,n,i=[],o=!1,a=!1;for(t=0;t<e.length;t++)a=(n=e.charAt(t))===n.toUpperCase()&&"-"!==n&&")"!==n&&"/"!==n||n in l,"_"===n||"."===n?(n=" ",a=!0):0===t?(n=n.toUpperCase(),a=!0):!o&&a&&i.length>0&&i.push(" "),i.push(n),o=a;return i.join("")}},95479:function(e,t){t.reverseEach=t.map=t.each=void 0;t.map=function(e,t){if(Array.isArray(e))return e.map(t);var n=[];for(var i in e)n.push(t(e[i],i));return n};t.each=function(e,t){if(e){if("length"in e)for(var n=0;n<e.length&&!1!==t.call(e[n],n,e[n]);n++);else for(var i in e)if(!1===t.call(e[i],i,e[i]))break;return e}};t.reverseEach=function(e,t){if(e&&"length"in e&&0!==e.length)for(var n=e.length-1;n>=0&&!1!==t.call(e[n],n,e[n]);n--);}},88933:function(e,t,n){t.default=void 0;var i,o=(i=n(17381))&&i.__esModule?i:{default:i};var a=function(){var e={},t=function(t){return e[t]||0};return{obtain:function(n){e[n]=t(n)+1},release:function(n){var i=t(n);if(i<1)throw o.default.Error("E0014");1===i?delete e[n]:e[n]=i-1},locked:function(e){return t(e)>0}}};t.default=a,e.exports=t.default,e.exports.default=t.default},60810:function(e,t,n){t.adjust=function(e,t){var n,r=a(t||0)+2,s=e.toString().split("."),l=e,u=Math.abs(e),d=(0,i.isExponential)(e),c=u>1?10:0;if(1===s.length)return e;d||((0,i.isExponential)(t)&&(r=s[0].length+o(t)),e=(e=u)-Math.floor(e)+c);if(r=function(){return"0.000300"!==3e-4.toPrecision(3)}()&&o(e)>6||r>7?15:7,!d&&(n=parseFloat(e.toPrecision(r)).toString().split("."))[0]===c.toString())return parseFloat(s[0]+"."+n[1]);return parseFloat(l.toPrecision(r))},t.fitIntoRange=void 0,t.getExponent=o,t.getExponentLength=function(e){var t,n=e.toString();return(null===(t=n.split(".")[1])||void 0===t?void 0:t.length)||parseInt(n.split("e-")[1])||0},t.getPrecision=a,t.getRemainderByDivision=function(e,t,n){if(t===parseInt(t))return e%t;var i=s(e/t,n);return(i-parseInt(i))*t},t.getRoot=r,t.inRange=void 0,t.roundFloatPart=s,t.sign=void 0,t.solveCubicEquation=function(e,t,n,i){if(Math.abs(e)<1e-8){if(e=t,t=n,n=i,Math.abs(e)<1e-8)return e=t,t=n,Math.abs(e)<1e-8?[]:[-t/e];var o=t*t-4*e*n;return Math.abs(o)<1e-8?[-t/(2*e)]:o>0?[(-t+Math.sqrt(o))/(2*e),(-t-Math.sqrt(o))/(2*e)]:[]}var a,s,l=(3*e*n-t*t)/(3*e*e),u=(2*t*t*t-9*e*t*n+27*e*e*i)/(27*e*e*e);if(Math.abs(l)<1e-8)a=[r(-u,3)];else if(Math.abs(u)<1e-8)a=[0].concat(l<0?[Math.sqrt(-l),-Math.sqrt(-l)]:[]);else{var d=u*u/4+l*l*l/27;if(Math.abs(d)<1e-8)a=[-1.5*u/l,3*u/l];else if(d>0)s=r(-u/2-Math.sqrt(d),3),a=[s-l/(3*s)];else{s=2*Math.sqrt(-l/3);var c=Math.acos(3*u/l/s)/3,h=2*Math.PI/3;a=[s*Math.cos(c),s*Math.cos(c-h),s*Math.cos(c-2*h)]}}for(var p=0;p<a.length;p++)a[p]-=t/(3*e);return a},t.trunc=function(e){return Math.trunc?Math.trunc(e):e>0?Math.floor(e):Math.ceil(e)};var i=n(35922);t.sign=function(e){return 0===e?0:e/Math.abs(e)};t.fitIntoRange=function(e,t,n){var i=!t&&0!==t,o=!n&&0!==n;return i&&(t=o?e:Math.min(e,n)),o&&(n=i?e:Math.max(e,t)),Math.min(Math.max(e,t),n)};function o(e){return Math.abs(parseInt(e.toExponential().split("e")[1]))}function a(e){var t=e.toString();if(t.indexOf(".")<0)return 0;var n=t.split("."),i=n[1].indexOf("e");return i>=0?i:n[1].length}function r(e,t){if(e<0&&t%2!=1)return NaN;var n=Math.pow(Math.abs(e),1/t);return t%2==1&&e<0?-n:n}function s(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return parseFloat(e.toFixed(t))}t.inRange=function(e,t,n){return e>=t&&e<=n}},48013:function(e,t,n){t.orderEach=t.deepExtendArraySafe=t.clone=void 0;var i,o=n(35922),a=(i=n(26974))&&i.__esModule?i:{default:i};var r=function(){function e(){}return function(t){return e.prototype=t,new e}}();t.clone=r;t.orderEach=function(e,t){var n,i,a=[];for(n in e)Object.prototype.hasOwnProperty.call(e,n)&&a.push(n);for(a.sort((function(e,t){var n=(0,o.isNumeric)(e),i=(0,o.isNumeric)(t);return n&&i?e-t:n&&!i?-1:!n&&i?1:e<t?-1:e>t?1:0})),i=0;i<a.length;i++)t(n=a[i],e[n])};var s=function(e,t,n,i){!i&&a.default.isWrapped(e[t])?a.default.assign(e[t],n):e[t]=n};t.deepExtendArraySafe=function e(t,n,i,a){var r,l;for(var u in n)if(r=t[u],l=n[u],"__proto__"!==u&&"constructor"!==u&&t!==l){if((0,o.isPlainObject)(l))l=e((i?(0,o.isObject)(r):(0,o.isPlainObject)(r))?r:{},l,i,a);void 0!==l&&r!==l&&s(t,u,l,a)}return t}},37518:function(e,t,n){t.getDefaultAlignment=t.getBoundingRect=void 0;var i,o=(i=n(80209))&&i.__esModule?i:{default:i},a=n(35922);t.getDefaultAlignment=function(e){return(null!=e?e:(0,o.default)().rtlEnabled)?"right":"left"};t.getBoundingRect=function(e){return(0,a.isWindow)(e)?{width:e.outerWidth,height:e.outerHeight}:e.getBoundingClientRect()}},9321:function(e,t,n){t.attachInstanceToElement=function(e,t,n){var i=(0,o.data)(e.get(0)),r=d(t.constructor);i[r]=t,n&&a.default.one(e,s.removeEvent,(function(){n.call(t)}));i.dxComponents||(i.dxComponents=[]);i.dxComponents.push(r)},t.getInstanceByElement=function(e,t){var n=d(t);return(0,o.data)(e.get(0),n)},t.name=void 0;var i,o=n(97906),a=(i=n(55994))&&i.__esModule?i:{default:i},r=n(35922),s=n(29007);var l=new WeakMap,u=0,d=function(e,t){if(!(0,r.isDefined)(t)){if(!l.has(e)){var n="dxPrivateComponent"+u++;return l.set(e,n),n}return l.get(e)}l.set(e,t)};t.name=d},59504:function(e,t,n){t.create=r,t.enqueue=void 0;var i,o=(i=n(17381))&&i.__esModule?i:{default:i},a=n(62754);function r(e){var t=[],n=!1;function i(){for(;t.length;){n=!0;var e=t.shift()();if(void 0!==e){if(e.then)return void(0,a.when)(e).always(i);throw o.default.Error("E0015")}}n=!1}return{add:function(o,a){e?(t[0]&&a&&a(t[0]),t=[o]):t.push(o),n||i()},busy:function(){return n}}}var s=r().add;t.enqueue=s},24311:function(e,t,n){t.default=void 0;var i=s(n(73349)),o=s(n(20476)),a=n(58201),r=s(n(39618));function s(e){return e&&e.__esModule?e:{default:e}}var l=[],u=(0,r.default)((function(){var e=i.default.listen(i.default.getDocument(),"DOMContentLoaded",(function(){d.fire(),e()}))})),d={add:function(e){var t=(0,a.hasWindow)();t&&"loading"!==i.default.getReadyState()?e():(l.push(e),t&&u())},fire:function(){l.forEach((function(e){return e()})),l=[]}},c=(0,o.default)(d);t.default=c,e.exports=t.default,e.exports.default=t.default},55814:function(e,t,n){t.default=void 0;var i=n(58201),o=l(n(73349)),a=l(n(44504)),r=l(n(24311)),s=l(n(39618));function l(e){return e&&e.__esModule?e:{default:e}}var u=function(){var e,t=(0,a.default)(),n=t.add,l=t.remove;if(!(0,i.hasWindow)())return t;var u,d=function(){var e=(0,i.getWindow)();return{width:e.innerWidth,height:e.innerHeight}},c=function(){var n,i=d();i.width===e.width&&i.height===e.height||(i.width===e.width&&(n="height"),i.height===e.height&&(n="width"),e=i,t.fire(n))},h=(0,s.default)((function(){e=d()}));return t.add=function(){var e=n.apply(t,arguments);return h(),r.default.add((function(){!u&&t.has()&&(u=o.default.listen((0,i.getWindow)(),"resize",c))})),e},t.remove=function(){var e=l.apply(t,arguments);return!t.has()&&u&&(u(),u=void 0),e},t}();t.default=u,e.exports=t.default,e.exports.default=t.default},49601:function(e,t,n){t.SelectionFilterCreator=void 0;var i=n(20576),o=n(35922);t.SelectionFilterCreator=function(e,t){var n;this.getLocalFilter=function(e,t,n,o){return t=void 0===t?i.equalByValue:t,r.bind(this,t,e,n,o)},this.getExpr=function(n){var i;if(n)return e.forEach((function(e,a){var r;i=i||[],a>0&&i.push(t?"and":"or"),r=(0,o.isString)(n)?s(n,e):function(e,n){for(var i=[],o=0,a=e.length;o<a;o++){var r=e[o],l=n&&n[r],u=s(r,l);if(!u)break;o>0&&i.push(t?"or":"and"),i.push(u)}return i}(n,e),i.push(r)})),i&&1===i.length&&(i=i[0]),i},this.getCombinedFilter=function(e,n){var i=this.getExpr(e),o=i;return t&&n&&(i?((o=[]).push(i),o.push(n)):o=n),o};var a=function(e,t,n){return Array.isArray(n)?e.map((function(e){return t(e)})):e};function r(r,s,l,u,d){var c,h,p=s(d);if(!l&&(c=(0,i.getKeyHash)(p),!(0,o.isObject)(c)))return function(t,o){if(!n){n={};for(var r=a(e,t,o),s=0;s<r.length;s++)n[(0,i.getKeyHash)(r[s])]=!0}return n}(s,u)[c]?!t:!!t;for(h=0;h<e.length;h++)if(r(e[h],p))return!t;return!!t}function s(e,n){if(void 0!==n)return[e,t?"<>":"=",n]}}},58664:function(e,t,n){t.setWidth=t.setOuterWidth=t.setOuterHeight=t.setInnerWidth=t.setInnerHeight=t.setHeight=t.parseHeight=t.implementationsMap=t.getWindowByElement=t.getWidth=t.getVisibleHeight=t.getVerticalOffsets=t.getSize=t.getOuterWidth=t.getOuterHeight=t.getOffset=t.getInnerWidth=t.getInnerHeight=t.getHeight=t.getElementBoxParams=t.addOffsetToMinHeight=t.addOffsetToMaxHeight=void 0;var i,o=n(58201),a=(i=n(73349))&&i.__esModule?i:{default:i},r=n(35922);var s=(0,o.getWindow)(),l=["auto","none","inherit","initial"],u=function(e,t){var n=0;return t.forEach((function(t){n+=parseFloat(e[t])||0})),n},d=function(e,t){var n="width"===e?"Left":"Top",i="width"===e?"Right":"Bottom";return{padding:u(t,["padding"+n,"padding"+i]),border:u(t,["border"+n+"Width","border"+i+"Width"]),margin:u(t,["margin"+n,"margin"+i])}};t.getElementBoxParams=d;var c=function(e){var t,n=(null==e||null===(t=e.ownerDocument)||void 0===t?void 0:t.defaultView)||s;return n.getComputedStyle&&n.getComputedStyle(e)},h=function(e,t,n,i){var o;return(null==t?void 0:t[n])||(null===(o=e.style)||void 0===o?void 0:o[n])||i},p={content:0,padding:1,border:2,margin:3,"content-box":0,"border-box":2},f={width:["left","right"],height:["top","bottom"]};function g(e,t,n,i){var o=function(e,t,n){return parseFloat(h(e,t,n,"0"))||0},a="border"===n?"-width":"";return o(e,i,"".concat(n,"-").concat(f[t][0]).concat(a))+o(e,i,"".concat(n,"-").concat(f[t][1]).concat(a))}var m=function(e,t,n){var i="width"===t?"offsetWidth":"offsetHeight",o=c(e),a=h(e,o,t);""!==a&&"auto"!==a||(a=e[i]),a=parseFloat(a)||0;var r=h(e,o,"boxSizing","content-box"),s=p[n||r],l=p[r];if(void 0===s||void 0===l)throw new Error;if(l===s)return a;var u=Math.sign(s-l),d=!1,f=!1,m=!1,_=!1;1===u&&(s+=1,l+=1);for(var v=l;v!==s;v+=u)switch(v){case p.content:break;case p.padding:d=u*g(e,t,"padding",o);break;case p.border:f=u*g(e,t,"border",o);break;case p.margin:m=u*g(e,t,"margin",o)}if(d||f){var y=(!1===d?u*g(e,t,"padding",o):d)+(!1===f?u*g(e,t,"border",o):f);_=u*Math.max(0,Math.floor(e[i]-a-u*y))||0}return a+m+d+f+_};t.getSize=m;var _=function(e,t){return e.indexOf("px")>0?e=parseInt(e.replace("px","")):e.indexOf("%")>0?e=parseInt(e.replace("%",""))*function(e){return(0,r.isWindow)(e)?e.innerHeight:e.offsetHeight}(t)/100:isNaN(e)?e.indexOf("vh")>0&&(e=s.innerHeight/100*parseInt(e.replace("vh",""))):e=parseInt(e),e};t.parseHeight=_;var v=function(e,t,n){return e?l.indexOf(e)>-1?t?null:e:((0,r.isString)(e)&&(e=_(e,n)),(0,r.isNumeric)(e)?Math.max(0,e+t):"calc("+e+(t<0?" - ":" ")+Math.abs(t)+"px)"):null};t.addOffsetToMaxHeight=function(e,t,n){var i=v(e,t,n);return null!==i?i:"none"};t.addOffsetToMinHeight=function(e,t,n){var i=v(e,t,n);return null!==i?i:0};t.getVerticalOffsets=function(e,t){if(!e)return 0;var n=d("height",s.getComputedStyle(e));return n.padding+n.border+(t?n.margin:0)};t.getVisibleHeight=function(e){if(e){var t=e.getBoundingClientRect();if(t.height)return t.height}return 0};var y={getWidth:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["width"].concat(t))},setWidth:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["width"].concat(t))},getHeight:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["height"].concat(t))},setHeight:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["height"].concat(t))},getOuterWidth:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["outerWidth"].concat(t))},setOuterWidth:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["outerWidth"].concat(t))},getOuterHeight:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["outerHeight"].concat(t))},setOuterHeight:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["outerHeight"].concat(t))},getInnerWidth:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["innerWidth"].concat(t))},setInnerWidth:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["innerWidth"].concat(t))},getInnerHeight:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["innerHeight"].concat(t))},setInnerHeight:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return b.apply(void 0,["innerHeight"].concat(t))}};function b(e,t,n){return 2===arguments.length?x(t,e):x(t,e,n)}t.implementationsMap=y;t.getWidth=function(e){return y.getWidth(e)};t.setWidth=function(e,t){return y.setWidth(e,t)};t.getHeight=function(e){return y.getHeight(e)};t.setHeight=function(e,t){return y.setHeight(e,t)};t.getOuterWidth=function(e,t){return y.getOuterWidth(e,t||!1)};t.setOuterWidth=function(e,t){return y.setOuterWidth(e,t)};t.getOuterHeight=function(e,t){return y.getOuterHeight(e,t||!1)};t.setOuterHeight=function(e,t){return y.setOuterHeight(e,t)};t.getInnerWidth=function(e){return y.getInnerWidth(e)};t.setInnerWidth=function(e,t){return y.setInnerWidth(e,t)};t.getInnerHeight=function(e){return y.getInnerHeight(e)};t.setInnerHeight=function(e,t){return y.setInnerHeight(e,t)};var x=function e(t,n,i){var o=n.toLowerCase().indexOf("width")>=0?"Width":"Height",s=o.toLowerCase(),l=0===n.indexOf("outer"),u=0===n.indexOf("inner"),h=2===arguments.length||"boolean"==typeof i;if((0,r.isRenderer)(t)){if(t.length>1&&!h){for(var p=0;p<t.length;p++)e(t[p],n,i);return}t=t[0]}if(t){if((0,r.isWindow)(t))return l?t["inner"+o]:a.default.getDocumentElement()["client"+o];if(a.default.isDocument(t)){var f=a.default.getDocumentElement(),g=a.default.getBody();return Math.max(g["scroll"+o],g["offset"+o],f["scroll"+o],f["offset"+o],f["client"+o])}if(h){var _="content";return l&&(_=i?"margin":"border"),u&&(_="padding"),m(t,s,_)}if((0,r.isNumeric)(i)){var v=c(t),y=d(s,v),b="border-box"===v.boxSizing;i=Number(i),l?i-=b?0:y.border+y.padding:u?i+=b?y.border:-y.padding:b&&(i+=y.border+y.padding)}return i+=(0,r.isNumeric)(i)?"px":"",a.default.setStyle(t,s,i),null}},w=function(e){return(0,r.isWindow)(e)?e:e.defaultView};t.getWindowByElement=w;t.getOffset=function(e){if(!e.getClientRects().length)return{top:0,left:0};var t=e.getBoundingClientRect(),n=w(e.ownerDocument),i=e.ownerDocument.documentElement;return{top:t.top+n.pageYOffset-i.clientTop,left:t.left+n.pageXOffset-i.clientLeft}}},36613:function(e,t,n){t.sessionStorage=void 0;var i=(0,n(58201).getWindow)();t.sessionStorage=function(){var e;try{e=i.sessionStorage}catch(e){}return e}},68752:function(e,t,n){t.encodeHtml=void 0,t.format=function(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),o=1;o<t;o++)n[o-1]=arguments[o];if((0,i.isFunction)(e))return e.apply(void 0,n);return n.forEach((function(t,n){(0,i.isString)(t)&&(t=t.replace(/\$/g,"$$$$"));var o=new RegExp("\\{"+n+"\\}","gm");e=e.replace(o,t)})),e},t.replaceAll=t.quadToObject=t.isEmpty=void 0;var i=n(35922);function o(e){return(o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var a,r=(a=[new RegExp("&","g"),new RegExp('"',"g"),new RegExp("'","g"),new RegExp("<","g"),new RegExp(">","g")],function(e){return String(e).replace(a[0],"&amp;").replace(a[1],"&quot;").replace(a[2],"&#39;").replace(a[3],"&lt;").replace(a[4],"&gt;")});t.encodeHtml=r;t.quadToObject=function(e){var t=function(e){switch(o(e)){case"string":return e.split(/\s+/,4);case"object":return[e.x||e.h||e.left,e.y||e.v||e.top,e.x||e.h||e.right,e.y||e.v||e.bottom];case"number":return[e];default:return e}}(e),n=parseInt(t&&t[0],10),i=parseInt(t&&t[1],10),a=parseInt(t&&t[2],10),r=parseInt(t&&t[3],10);return isFinite(n)||(n=0),isFinite(i)||(i=n),isFinite(a)||(a=n),isFinite(r)||(r=i),{top:i,right:a,bottom:r,left:n}};var s=function(e,t,n){return e.replace(new RegExp("("+(t+"").replace(/([+*?.[^\]$(){}><|=!:])/g,"\\$1")+")","gi"),n)};t.replaceAll=s;var l,u=(l=/\s/g,function(e){return!e||!e.replace(l,"")});t.isEmpty=u},2146:function(e,t){t.stubComponent=function(e){return function(){function t(){throw new Error("Module '".concat(e,"' not found"))}return t.getInstance=function(){},t}()}},80968:function(e,t,n){t.stylePropPrefix=t.styleProp=t.setWidth=t.setHeight=t.parsePixelValue=t.normalizeStyleProp=void 0;var i=n(78008),o=s(n(39618)),a=n(35922),r=s(n(73349));function s(e){return e&&e.__esModule?e:{default:e}}var l=["","Webkit","Moz","O","Ms"],u={"":"",Webkit:"-webkit-",Moz:"-moz-",O:"-o-",ms:"-ms-"},d=(0,o.default)((function(){return r.default.createElement("dx").style}));t.styleProp=function(e){if(e in d())return e;var t=e;e=e.charAt(0).toUpperCase()+e.substr(1);for(var n=1;n<l.length;n++){var i=l[n].toLowerCase()+e;if(i in d())return i}return t};t.stylePropPrefix=function(e){return function(e,t){var n;e=(0,i.camelize)(e,!0);for(var o=0,a=l.length;o<a;o++){var r=l[o],s=r+e;if(void 0===(n=t((0,i.camelize)(s),r))&&(n=t(s,r)),void 0!==n)break}return n||""}(e,(function(e,t){if(e in d())return u[t]}))};var c=["fillOpacity","columnCount","flexGrow","flexShrink","fontWeight","lineHeight","opacity","zIndex","zoom"];t.parsePixelValue=function(e){return(0,a.isNumeric)(e)?e:(0,a.isString)(e)?Number(e.replace("px","")):NaN};t.normalizeStyleProp=function(e,t){return(0,a.isNumeric)(t)&&-1===c.indexOf(e)&&(t+="px"),t};var h=function(e,t,n){if(e){n=(0,a.isNumeric)(n)?n+="px":n;for(var i=0;i<e.length;++i)e[i].style[t]=n}};t.setWidth=function(e,t){h(e,"width",t)};t.setHeight=function(e,t){h(e,"height",t)}},60137:function(e,t,n){t.pointerEvents=t.nativeScrolling=t.inputType=t.animation=void 0,Object.defineProperty(t,"styleProp",{enumerable:!0,get:function(){return s.styleProp}}),Object.defineProperty(t,"stylePropPrefix",{enumerable:!0,get:function(){return s.stylePropPrefix}}),t.transitionEndEventName=t.transition=t.touchEvents=t.touch=t.supportProp=void 0;var i=l(n(73349)),o=l(n(39618)),a=n(58201),r=l(n(20530)),s=n(80968);function l(e){return e&&e.__esModule?e:{default:e}}var u=(0,a.getNavigator)().maxTouchPoints,d={webkitTransition:"webkitTransitionEnd",MozTransition:"transitionend",OTransition:"oTransitionEnd",transition:"transitionend"},c=function(e){return!!(0,s.styleProp)(e)};t.supportProp=c;t.inputType=function(e){if("text"===e)return!0;var t=i.default.createElement("input");try{return t.setAttribute("type",e),t.value="wrongValue",!t.value}catch(e){return!1}};var h=function(e,t){return(e("ontouchstart")||!!t)&&!e("callPhantom")}(a.hasProperty,u);t.touchEvents=h;var p=(0,a.hasProperty)("PointerEvent");t.pointerEvents=p;var f=h||p&&!!u;t.touch=f;var g=(0,o.default)((function(){return c("transition")}));t.transition=g;var m=(0,o.default)((function(){return d[(0,s.styleProp)("transition")]}));t.transitionEndEventName=m;var _=(0,o.default)((function(){return c("animation")}));t.animation=_;var v,y,b,x=(v=r.default.real(),y=v.platform,b=v.mac,"ios"===y||"android"===y||b);t.nativeScrolling=x},19155:function(e,t,n){t.HIDDEN_FOR_EXPORT=void 0,t.getSvgElement=function(e){return i.default.isNode(e)?e:(new s.DOMParser).parseFromString(e,"image/svg+xml").childNodes[0]},t.getSvgMarkup=function(e,t){return function(e){var t=!0;-1===e.indexOf("xmlns:xlink")&&(e=e.replace("<svg",'<svg xmlns:xlink="http://www.w3.org/1999/xlink"'));return(e=e.replace(/xmlns="[\s\S]*?"/gi,(function(e){return t?(t=!1,e):""}))).replace(/xmlns:NS1="[\s\S]*?"/gi,"").replace(/NS1:xmlns:xlink="([\s\S]*?)"/gi,'xmlns:xlink="$1"')}((n=function(e,t){var n=i.default.createElement("div"),o=e.cloneNode(!0);return t&&(0,a.default)(o).css("backgroundColor",t),n.appendChild(o),n.innerHTML}(e,t),n.replace(/&quot;/gi,"&#34;").replace(/&amp;/gi,"&#38;").replace(/&apos;/gi,"&#39;").replace(/&lt;/gi,"&#60;").replace(/&gt;/gi,"&#62;").replace(/&nbsp;/gi,"&#160;").replace(/&shy;/gi,"&#173;")));var n};var i=r(n(73349)),o=n(58201),a=r(n(68374));function r(e){return e&&e.__esModule?e:{default:e}}var s=(0,o.getWindow)();t.HIDDEN_FOR_EXPORT="hidden-for-export"},69697:function(e,t,n){t.validateTemplateSource=t.templateKey=t.suitableTemplatesByName=t.getNormalizedTemplateArgs=t.findTemplates=t.defaultCreateElement=t.addOneRenderedCall=t.acquireTemplate=t.acquireIntegrationTemplate=void 0;var i=m(n(80209)),o=m(n(20530)),a=m(n(17381)),r=m(n(68374)),s=n(91627),l=n(10688),u=n(9545),d=n(81033),c=n(89386),h=n(20576),p=n(3532),f=n(13306),g=n(35922);function m(e){return e&&e.__esModule?e:{default:e}}t.findTemplates=function(e,t){var n=(0,r.default)(e).contents().filter("[".concat("data-options",'*="').concat(t,'"]'));return[].slice.call(n).map((function(e){var n=(0,r.default)(e).attr("data-options")||"";return{element:e,options:(0,i.default)().optionsParser(n)[t]}})).filter((function(e){return!!e.options}))};t.suitableTemplatesByName=function(e){var t=(0,c.groupBy)(e,(function(e){return e.options.name}));if(t[void 0])throw a.default.Error("E0023");var n={};return Object.keys(t).forEach((function(e){var i,a=null===(i=(0,h.findBestMatches)(o.default.current(),t[e],(function(e){return e.options}))[0])||void 0===i?void 0:i.element;a&&(n[e]=a)})),n};var _=function(e){var t=e.render.bind(e);return(0,f.extend)({},e,{render:function(e){var n=t(e);return e&&e.onRendered&&e.onRendered(),n}})};t.addOneRenderedCall=_;t.getNormalizedTemplateArgs=function(e){var t=[];return"model"in e&&t.push(e.model),"index"in e&&t.push(e.index),t.push(e.container),t};t.validateTemplateSource=function(e){return"string"==typeof e?(0,p.normalizeTemplateElement)(e):e};t.templateKey=function(e){return(0,g.isRenderer)(e)&&e[0]||e};t.defaultCreateElement=function(e){return new u.Template(e)};var v=function(e,t,n,i){var o=null;return i&&-1!==i.indexOf(e)||!(o=t[e])||o instanceof d.TemplateBase||n||(o=_(o)),o};t.acquireIntegrationTemplate=v;t.acquireTemplate=function(e,t,n,i,o,a){return null==e?new l.EmptyTemplate:e instanceof s.ChildDefaultTemplate?a[e.name]:e instanceof d.TemplateBase?e:(0,g.isFunction)(e.render)&&!(0,g.isRenderer)(e)?i?e:_(e):e.nodeType||(0,g.isRenderer)(e)?t((0,r.default)(e)):v(e,n,i,o)||a[e]||t(e)}},35922:function(e,t){function n(e){return(n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}t.type=t.isWindow=t.isString=t.isRenderer=t.isPromise=t.isPrimitive=t.isPlainObject=t.isObject=t.isNumeric=t.isFunction=t.isExponential=t.isEvent=t.isEmptyObject=t.isDefined=t.isDeferred=t.isDate=t.isBoolean=void 0;var i={"[object Array]":"array","[object Date]":"date","[object Object]":"object","[object String]":"string","[object Null]":"null"},o=function(e){var t=Object.prototype.toString.call(e);return"object"===n(e)?i[t]||"object":n(e)};t.type=o;t.isBoolean=function(e){return"boolean"==typeof e};t.isExponential=function(e){return r(e)&&-1!==e.toString().indexOf("e")};t.isDate=function(e){return"date"===o(e)};t.isDefined=function(e){return null!=e};var a=function(e){return"function"==typeof e};t.isFunction=a;t.isString=function(e){return"string"==typeof e};var r=function(e){return"number"==typeof e&&isFinite(e)||!isNaN(e-parseFloat(e))};t.isNumeric=r;t.isObject=function(e){return"object"===o(e)};t.isEmptyObject=function(e){var t;for(t in e)return!1;return!0};t.isPlainObject=function(e){if(!e||"[object Object]"!==Object.prototype.toString.call(e))return!1;var t=Object.getPrototypeOf(e),n=Object.hasOwnProperty.call(t,"constructor")&&t.constructor;return"function"==typeof n&&Object.toString.call(n)===Object.toString.call(Object)};t.isPrimitive=function(e){return-1===["object","array","function"].indexOf(o(e))};t.isWindow=function(e){return null!=e&&e===e.window};t.isRenderer=function(e){return!(!e||!e.jquery&&!e.dxRenderer)};t.isPromise=function(e){return!!e&&a(e.then)};t.isDeferred=function(e){return!!e&&a(e.done)&&a(e.fail)};t.isEvent=function(e){return!(!e||!e.preventDefault)}},26974:function(e,t,n){t.default=void 0;var i,o=n(30869);var a=(0,((i=n(20476))&&i.__esModule?i:{default:i}).default)({isWrapped:function(){return!1},isWritableWrapped:function(){return!1},wrap:function(e){return e},unwrap:function(e){return e},assign:function(){o.logger.error("Method 'assign' should not be used for not wrapped variables. Use 'isWrapped' method for ensuring.")}});t.default=a,e.exports=t.default,e.exports.default=t.default},58020:function(e,t){t.compare=function(e,t,n){function i(e){return"string"==typeof e?e.split("."):"number"==typeof e?[e]:e}e=i(e),t=i(t);var o=Math.max(e.length,t.length);isFinite(n)&&(o=Math.min(o,n));for(var a=0;a<o;a++){var r=parseInt(e[a]||0,10),s=parseInt(t[a]||0,10);if(r<s)return-1;if(r>s)return 1}return 0}},77695:function(e,t,n){t.changeCallback=void 0,t.originalViewPort=function(){return d},t.value=void 0;var i=r(n(68374)),o=r(n(24311)),a=r(n(44504));function r(e){return e&&e.__esModule?e:{default:e}}var s=o.default.add,l=(0,a.default)();t.changeCallback=l;var u,d=(0,i.default)(),c=function(e){if(!arguments.length)return u;var t=(0,i.default)(e);d=t;var n=!!t.length,o=c();u=n?t:(0,i.default)("body"),l.fire(n?c():(0,i.default)(),o)};t.value=c,s((function(){c(".dx-viewport")}))},58201:function(e,t,n){t.setWindow=t.hasWindow=t.hasProperty=t.getWindow=t.getNavigator=t.getCurrentScreenFactor=t.defaultScreenFactorFunc=void 0;var i,o=(i=n(73349))&&i.__esModule?i:{default:i};var a="undefined"!=typeof window,r=function(){return a};t.hasWindow=r;var s=r()?window:void 0;s||((s={}).window=s);t.getWindow=function(){return s};t.setWindow=function(e,t){a=void 0===t?"undefined"!=typeof window&&window===e:t,s=e};t.hasProperty=function(e){return r()&&e in s};var l=function(e){return e<768?"xs":e<992?"sm":e<1200?"md":"lg"};t.defaultScreenFactorFunc=l;t.getCurrentScreenFactor=function(e){return(e||l)(o.default.getDocumentElement().clientWidth)};t.getNavigator=function(){return r()?s.navigator:{userAgent:""}}},36739:function(e,t){t.version=void 0;t.version="22.1.3"},67403:function(e,t,n){t.default=void 0;var i=h(n(38377)),o=n(80566),a=n(95479),r=n(18438),s=n(16454),l=n(47617),u=h(n(99236)),d=n(62754),c=n(20576);function h(e){return e&&e.__esModule?e:{default:e}}function p(e){return function(e){if(Array.isArray(e))return f(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return f(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return f(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function f(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}var g,m=i.default.abstract,_=u.default.queryByOptions,v={},y=i.default.inherit({ctor:function(e){var t=this;e=e||{},this._eventsStrategy=new o.EventsStrategy(this),(0,a.each)(["onLoaded","onLoading","onInserted","onInserting","onUpdated","onUpdating","onPush","onRemoved","onRemoving","onModified","onModifying"],(function(n,i){i in e&&t.on(i.slice(2).toLowerCase(),e[i])})),this._key=e.key,this._errorHandler=e.errorHandler,this._useDefaultSearch=!0},_customLoadOptions:function(){return null},key:function(){return this._key},keyOf:function(e){return this._keyGetter||(this._keyGetter=(0,l.compileGetter)(this.key())),this._keyGetter(e)},_requireKey:function(){if(!this.key())throw r.errors.Error("E4005")},load:function(e){var t=this;return e=e||{},this._eventsStrategy.fireEvent("loading",[e]),this._withLock(this._loadImpl(e)).done((function(n){t._eventsStrategy.fireEvent("loaded",[n,e])}))},_loadImpl:function(e){return _(this.createQuery(e),e).enumerate()},_withLock:function(e){var t=new d.Deferred;return e.done((function(){var e=this,n=arguments;s.processRequestResultLock.promise().done((function(){t.resolveWith(e,n)}))})).fail((function(){t.rejectWith(this,arguments)})),t},createQuery:m,totalCount:function(e){return this._totalCountImpl(e)},_totalCountImpl:function(e){return _(this.createQuery(e),e,!0).count()},byKey:function(e,t){return this._addFailHandlers(this._withLock(this._byKeyImpl(e,t)))},_byKeyImpl:m,insert:function(e){var t=this;return t._eventsStrategy.fireEvent("modifying"),t._eventsStrategy.fireEvent("inserting",[e]),t._addFailHandlers(t._insertImpl(e).done((function(e,n){t._eventsStrategy.fireEvent("inserted",[e,n]),t._eventsStrategy.fireEvent("modified")})))},_insertImpl:m,update:function(e,t){var n=this;return n._eventsStrategy.fireEvent("modifying"),n._eventsStrategy.fireEvent("updating",[e,t]),n._addFailHandlers(n._updateImpl(e,t).done((function(){n._eventsStrategy.fireEvent("updated",[e,t]),n._eventsStrategy.fireEvent("modified")})))},_updateImpl:m,push:function(e){var t=this,n={changes:e,waitFor:[]};this._eventsStrategy.fireEvent("beforePush",[n]),d.when.apply(void 0,p(n.waitFor)).done((function(){t._pushImpl(e),t._eventsStrategy.fireEvent("push",[e])}))},_pushImpl:c.noop,remove:function(e){var t=this;return t._eventsStrategy.fireEvent("modifying"),t._eventsStrategy.fireEvent("removing",[e]),t._addFailHandlers(t._removeImpl(e).done((function(e){t._eventsStrategy.fireEvent("removed",[e]),t._eventsStrategy.fireEvent("modified")})))},_removeImpl:m,_addFailHandlers:function(e){return e.fail(this._errorHandler).fail(r.handleError)},on:function(e,t){return this._eventsStrategy.on(e,t),this},off:function(e,t){return this._eventsStrategy.off(e,t),this}});y.create=function(e,t){if(!(e in v))throw r.errors.Error("E4020",e);return new v[e](t)},y.registerClass=function(e,t){return t&&(v[t]=e),e},y.inherit=(g=y.inherit,function(e,t){var n=g.apply(this,[e]);return y.registerClass(n,t),n});var b=y;t.default=b,e.exports=t.default,e.exports.default=t.default},36893:function(e,t,n){t.default=void 0;var i=n(60637).applyChanges;t.default=i,e.exports=t.default,e.exports.default=t.default},35042:function(e,t,n){t.default=void 0;var i,o=(i=n(38377))&&i.__esModule?i:{default:i},a=n(35922),r=n(95479),s=n(47617),l=n(62754),u=n(18438),d=n(16454);var c=o.default.inherit({toArray:function(){var e=[];for(this.reset();this.next();)e.push(this.current());return e},countable:function(){return!1}}),h=c.inherit({ctor:function(e){this.array=e,this.index=-1},next:function(){return this.index+1<this.array.length&&(this.index++,!0)},current:function(){return this.array[this.index]},reset:function(){this.index=-1},toArray:function(){return this.array.slice(0)},countable:function(){return!0},count:function(){return this.array.length}}),p=c.inherit({ctor:function(e){this.iter=e},next:function(){return this.iter.next()},current:function(){return this.iter.current()},reset:function(){return this.iter.reset()}}),f=p.inherit({ctor:function(e,t){this.callBase(e),this.index=-1,this.mapper=t},current:function(){return this.mapper(this.callBase(),this.index)},next:function(){var e=this.callBase();return e&&this.index++,e}}),g=function(e,t){return e=(0,s.toComparable)(e),t=(0,s.toComparable)(t),null===e&&null!==t?-1:null!==e&&null===t||void 0===e&&void 0!==t?1:void 0!==e&&void 0===t||e<t?-1:e>t?1:0},m=c.inherit({ctor:function(e,t,n,i){e instanceof f||(e=new f(e,this._wrap)),this.iter=e,this.rules=[{getter:t,desc:n,compare:i}]},thenBy:function(e,t,n){var i=new m(this.sortedIter||this.iter,e,t,n);return this.sortedIter||(i.rules=this.rules.concat(i.rules)),i},next:function(){return this._ensureSorted(),this.sortedIter.next()},current:function(){return this._ensureSorted(),this.sortedIter.current()},reset:function(){delete this.sortedIter},countable:function(){return this.sortedIter||this.iter.countable()},count:function(){return this.sortedIter?this.sortedIter.count():this.iter.count()},_ensureSorted:function(){var e=this;e.sortedIter||((0,r.each)(e.rules,(function(){this.getter=(0,s.compileGetter)(this.getter)})),e.sortedIter=new f(new h(this.iter.toArray().sort((function(t,n){return e._compare(t,n)}))),e._unwrap))},_wrap:function(e,t){return{index:t,value:e}},_unwrap:function(e){return e.value},_compare:function(e,t){var n=e.index,i=t.index;if((e=e.value)===(t=t.value))return n-i;for(var o=0,a=this.rules.length;o<a;o++){var r=this.rules[o],s=r.getter(e),l=r.getter(t),u=(r.compare||g)(s,l);if(u)return r.desc?-u:u}return n-i}}),_=function(){var e=function(e){return(0,a.isDefined)(e)?e.toString():""};function t(e,t,n){return function(i){i=(0,s.toComparable)(e(i));var o=function(e){return""===e||0===e||!1===e}(t)?i===t:i==t;return n&&(o=!o),o}}return function(n){return(0,a.isFunction)(n)?n:(0,d.isGroupCriterion)(n)?function(e){var t=[],n=!1,i=!1;return(0,r.each)(e,(function(){if(Array.isArray(this)||(0,a.isFunction)(this)){if(t.length>1&&n!==i)throw new u.errors.Error("E4019");t.push(_(this)),n=i,i=!0}else i=(0,d.isConjunctiveOperator)(this)})),function(e){for(var i=n,o=0;o<t.length;o++)if(t[o](e)!==n){i=!n;break}return i}}(n):(0,d.isUnaryOperation)(n)?function(e){var t=e[0],n=_(e[1]);if("!"===t)return function(e){return!n(e)};throw u.errors.Error("E4003",t)}(n):function(n){n=(0,d.normalizeBinaryCriterion)(n);var i=(0,s.compileGetter)(n[0]),o=n[1],a=n[2];switch(a=(0,s.toComparable)(a),o.toLowerCase()){case"=":return t(i,a);case"<>":return t(i,a,!0);case">":return function(e){return(0,s.toComparable)(i(e))>a};case"<":return function(e){return(0,s.toComparable)(i(e))<a};case">=":return function(e){return(0,s.toComparable)(i(e))>=a};case"<=":return function(e){return(0,s.toComparable)(i(e))<=a};case"startswith":return function(t){return 0===(0,s.toComparable)(e(i(t))).indexOf(a)};case"endswith":return function(t){var n=(0,s.toComparable)(e(i(t))),o=e(a);if(n.length<o.length)return!1;var r=n.lastIndexOf(a);return-1!==r&&r===n.length-a.length};case"contains":return function(t){return(0,s.toComparable)(e(i(t))).indexOf(a)>-1};case"notcontains":return function(t){return-1===(0,s.toComparable)(e(i(t))).indexOf(a)}}throw u.errors.Error("E4003",o)}(n)}}(),v=p.inherit({ctor:function(e,t){this.callBase(e),this.criteria=_(t)},next:function(){for(;this.iter.next();)if(this.criteria(this.current()))return!0;return!1}}),y=c.inherit({ctor:function(e,t){this.iter=e,this.getter=t},next:function(){return this._ensureGrouped(),this.groupedIter.next()},current:function(){return this._ensureGrouped(),this.groupedIter.current()},reset:function(){delete this.groupedIter},countable:function(){return!!this.groupedIter},count:function(){return this.groupedIter.count()},_ensureGrouped:function(){if(!this.groupedIter){var e={},t=[],n=this.iter,i=(0,s.compileGetter)(this.getter);for(n.reset();n.next();){var o=n.current(),a=i(o);a in e?e[a].push(o):(e[a]=[o],t.push(a))}this.groupedIter=new h((0,r.map)(t,(function(t){return{key:t,items:e[t]}})))}}}),b=p.inherit({ctor:function(e,t){this.callBase(e),this.getter=(0,s.compileGetter)(t)},current:function(){return this.getter(this.callBase())},countable:function(){return this.iter.countable()},count:function(){return this.iter.count()}}),x=p.inherit({ctor:function(e,t,n){this.callBase(e),this.skip=Math.max(0,t),this.take=Math.max(0,n),this.pos=0},next:function(){if(this.pos>=this.skip+this.take)return!1;for(;this.pos<this.skip&&this.iter.next();)this.pos++;return this.pos++,this.iter.next()},reset:function(){this.callBase(),this.pos=0},countable:function(){return this.iter.countable()},count:function(){return Math.min(this.iter.count()-this.skip,this.take)}}),w=function e(t,n){n=n||{},t instanceof c||(t=new h(t));var i=function(e){var t=n.errorHandler;t&&t(e),(0,u.handleError)(e)},o=function(e){var n=(new l.Deferred).fail(i),o=e.step,a=e.finalize;try{t.reset();for(var r=("seed"in e?e.seed:t.next()?t.current():NaN);t.next();)r=o(r,t.current());n.resolve(a?a(r):r)}catch(e){n.reject(e)}return n.promise()},r=function(e){return o(d.aggregators[e])},p=function(e){return(0,a.isFunction)(e)||Array.isArray(e)||(e=[].slice.call(arguments)),g(new b(t,e))},f=function(e){return p((0,s.compileGetter)(e))};function g(t){return e(t,n)}return{toArray:function(){return t.toArray()},enumerate:function(){var e=(new l.Deferred).fail(i);try{e.resolve(t.toArray())}catch(t){e.reject(t)}return e.promise()},sortBy:function(e,n,i){return g(new m(t,e,n,i))},thenBy:function(e,n,i){if(t instanceof m)return g(t.thenBy(e,n,i));throw u.errors.Error("E4004")},filter:function(e){return Array.isArray(e)||(e=[].slice.call(arguments)),g(new v(t,e))},slice:function(e,n){return void 0===n&&(n=Number.MAX_VALUE),g(new x(t,e,n))},select:p,groupBy:function(e){return g(new y(t,e))},aggregate:function(e,t,n){return o(arguments.length<2?{step:arguments[0]}:{seed:e,step:t,finalize:n})},count:function(){if(t.countable()){var e=(new l.Deferred).fail(i);try{e.resolve(t.count())}catch(t){e.reject(t)}return e.promise()}return r("count")},sum:function(e){return e?f(e).sum():r("sum")},min:function(e){return e?f(e).min():r("min")},max:function(e){return e?f(e).max():r("max")},avg:function(e){return e?f(e).avg():r("avg")}}};t.default=w,e.exports=t.default,e.exports.default=t.default},26562:function(e,t,n){t.default=void 0;var i=n(16454),o=l(n(96687)),a=n(18438),r=l(n(67403)),s=n(60637);function l(e){return e&&e.__esModule?e:{default:e}}var u=r.default.inherit({ctor:function(e){e=Array.isArray(e)?{data:e}:e||{},this.callBase(e);var t=e.data;if(t&&!Array.isArray(t))throw a.errors.Error("E4006");this._array=t||[]},createQuery:function(){return(0,o.default)(this._array,{errorHandler:this._errorHandler})},_byKeyImpl:function(e){var t=(0,s.indexByKey)(this,this._array,e);return-1===t?(0,i.rejectedPromise)(a.errors.Error("E4009")):(0,i.trivialPromise)(this._array[t])},_insertImpl:function(e){return(0,s.insert)(this,this._array,e)},_pushImpl:function(e){(0,s.applyBatch)({keyInfo:this,data:this._array,changes:e})},_updateImpl:function(e,t){return(0,s.update)(this,this._array,e,t)},_removeImpl:function(e){return(0,s.remove)(this,this._array,e)},clear:function(){this._eventsStrategy.fireEvent("modifying"),this._array=[],this._eventsStrategy.fireEvent("modified")}},"array");t.default=u,e.exports=t.default,e.exports.default=t.default},60637:function(e,t,n){t.applyBatch=v,t.applyChanges=function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},i=n.keyExpr,o=void 0===i?"id":i,a=n.immutable,r=void 0===a||a,s=(0,u.compileGetter)(o),l={key:function(){return o},keyOf:function(e){return s(e)}};return v({keyInfo:l,data:e,changes:t,immutable:r,disableCache:!0,logError:!0})},t.createObjectWithChanges=_,t.indexByKey=C,t.insert=x,t.remove=w,t.update=b;var i=n(35922),o=c(n(80209)),a=c(n(73176)),r=n(13306),s=n(18438),l=n(48013),u=n(47617),d=n(16454);function c(e){return e&&e.__esModule?e:{default:e}}function h(e){return(h="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function p(e){return function(e){if(Array.isArray(e))return f(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return f(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return f(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function f(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}function g(e,t,n,i){return i?function e(t,n,i,o){var a;if(o){for(var r=0;r<n.length;r++)if(a=e(t,n[r].items||n[r].collapsedItems||[]||[],i,o-1))return a}else if(C(t,n,i)>=0)return n}(e,t,n,i)||[]:t}function m(e,t,n){e._dataByKeyMap&&(e._dataByKeyMap[JSON.stringify(t)]=n,e._dataByKeyMapLength+=n?1:-1)}function _(e,t){var n=function e(t,n){n=n||new WeakMap;var o=t?Object.create(Object.getPrototypeOf(t)):{};t&&n.set(t,o);var a=(0,r.extendFromObject)({},t);for(var s in a){var u=a[s];!(0,i.isObject)(u)||(0,i.isPlainObject)(u)||n.has(u)||(a[s]=e(u,n))}for(var d in(0,l.deepExtendArraySafe)(o,a,!0,!0),o){var c=o[d];(0,i.isObject)(c)&&n.has(c)&&(o[d]=n.get(c))}return o}(e);return(0,l.deepExtendArraySafe)(n,t,!0,!0)}function v(e){var t=e.keyInfo,n=e.data,o=e.changes,a=e.groupCount,r=e.useInsertIndex,s=e.immutable,l=e.disableCache,u=e.logError,d=!0===s?p(n):n;return o.forEach((function(e){var n="insert"===e.type?d:g(t,d,e.key,a);switch(!l&&function(e,t){if(e.key()&&(!t._dataByKeyMap||t._dataByKeyMapLength!==t.length)){for(var n={},i=t.length,o=0;o<i;o++)n[JSON.stringify(e.keyOf(t[o]))]=t[o];t._dataByKeyMap=n,t._dataByKeyMapLength=i}}(t,n),e.type){case"update":b(t,n,e.key,e.data,!0,s,u);break;case"insert":x(t,n,e.data,r&&(0,i.isDefined)(e.index)?e.index:-1,!0,u);break;case"remove":w(t,n,e.key,!0,u)}})),d}function y(e,t,n){return e?t&&s.errors.log(n):(0,d.rejectedPromise)(s.errors.Error(n))}function b(e,t,n,a,r,s,u){var c,h=e.key();if(h){if(function(e,t){for(var n="string"==typeof t?t.split():t.slice();n.length;)if(n.shift()in e)return!0;return!1}(a,h)&&!(0,d.keysEqual)(h,n,e.keyOf(a)))return y(r,u,"E4017");if(!(c=function(e,t){if(e._dataByKeyMap)return e._dataByKeyMap[JSON.stringify(t)]}(t,n))){var p=C(e,t,n);if(p<0)return y(r,u,"E4009");if(c=t[p],!0===s&&(0,i.isDefined)(c)){var f=_(c,a);return t[p]=f,!r&&(0,d.trivialPromise)(f,n)}}}else c=n;if((0,l.deepExtendArraySafe)(c,a,!0),!r)return(0,o.default)().useLegacyStoreResult?(0,d.trivialPromise)(n,a):(0,d.trivialPromise)(c,n)}function x(e,t,n,l,u,c){var p,f=e.key(),g=(0,i.isPlainObject)(n)?(0,r.extend)({},n):n;if(f){if(void 0===(p=e.keyOf(g))||"object"===h(p)&&(0,i.isEmptyObject)(p)){if(Array.isArray(f))throw s.errors.Error("E4007");p=g[f]=String(new a.default)}else if(void 0!==t[C(e,t,p)])return y(u,c,"E4008")}else p=g;if(l>=0?t.splice(l,0,g):t.push(g),m(t,p,g),!u)return(0,d.trivialPromise)((0,o.default)().useLegacyStoreResult?n:g,p)}function w(e,t,n,i,o){var a=C(e,t,n);return a>-1&&(t.splice(a,1),m(t,n,null)),i?a<0?y(i,o,"E4009"):void 0:(0,d.trivialPromise)(n)}function C(e,t,n){var i=e.key();if(!function(e,t){return!e._dataByKeyMap||e._dataByKeyMap[JSON.stringify(t)]}(t,n))return-1;for(var o=0,a=t.length;o<a;o++)if((0,d.keysEqual)(i,e.keyOf(t[o]),n))return o;return-1}},88036:function(e,t,n){t.default=void 0;var i=p(n(68374)),o=n(16454),a=n(60637),r=n(35922),s=p(n(80209)),l=n(18438),u=p(n(67403)),d=p(n(35042)),c=p(n(99236)),h=n(62754);function p(e){return e&&e.__esModule?e:{default:e}}function f(e){return e&&(0,r.isFunction)(e.then)}function g(e){return(new h.Deferred).resolve(e).promise()}function m(e,t){if(!(0,r.isFunction)(t))throw l.errors.Error("E4011",e)}function _(e){throw l.errors.Error("E4012",e)}function v(e){function t(e){var t=e[0],n=e[1];return t&&t.getResponseHeader?(0,o.errorMessageFromXhr)(t,n):null}return function(n){var i;(i=n instanceof Error?n:new Error(t(arguments)||n&&String(n)||"Unknown error")).message!==o.XHR_ERROR_UNLOAD&&e.reject(i)}}function y(e,t){var n,i=e._loadFunc;return m("load",i),n=i.apply(e,[t]),Array.isArray(n)?n=g(n):null==n?n=g([]):f(n)||_("load"),(0,h.fromPromise)(n)}function b(e,t,n,i){if(t.__rawData)i(t.__rawData);else{var o=t.__rawDataPromise||y(t,n);t._cacheRawData&&(t.__rawDataPromise=o),o.always((function(){delete t.__rawDataPromise})).done((function(e){t._cacheRawData&&(t.__rawData=e),i(e)})).fail(v(e))}}function x(e,t,n,o){var a={};"userData"in(n=n||{})&&(a.userData=n.userData),b(e,t,a,(function(a){var r,s,l,u,p=(0,d.default)(a,{errorHandler:t._errorHandler}),f=[];o||((r=c.default.queryByOptions(p,n))===p?l=a.slice(0):f.push(r.enumerate().done((function(e){l=e})))),(n.requireTotalCount||o)&&((s=c.default.queryByOptions(p,n,!0))===p?u=a.length:f.push(s.count().done((function(e){u=e})))),h.when.apply(i.default,f).done((function(){o?e.resolve(u):n.requireTotalCount?e.resolve(l,{totalCount:u}):e.resolve(l)})).fail((function(t){e.reject(t)}))}))}var w=u.default.inherit({ctor:function(e){e=e||{},this.callBase(e),this._useDefaultSearch=!!e.useDefaultSearch||"raw"===e.loadMode,this._loadMode=e.loadMode,this._cacheRawData=!1!==e.cacheRawData,this._loadFunc=e.load,this._totalCountFunc=e.totalCount,this._byKeyFunc=e.byKey,this._insertFunc=e.insert,this._updateFunc=e.update,this._removeFunc=e.remove},createQuery:function(){throw l.errors.Error("E4010")},clearRawDataCache:function(){delete this.__rawData},_totalCountImpl:function(e){var t=new h.Deferred;return"raw"!==this._loadMode||this._totalCountFunc?(function(e,t){var n,i=e._totalCountFunc;if(!(0,r.isFunction)(i))throw l.errors.Error("E4021");return f(n=i.apply(e,[t]))||(n=Number(n),isFinite(n)||_("totalCount"),n=g(n)),(0,h.fromPromise)(n)}(this,e).done((function(e){t.resolve(Number(e))})).fail(v(t)),t=this._addFailHandlers(t)):x(t,this,e,!0),t.promise()},_pushImpl:function(e){this.__rawData&&(0,a.applyBatch)({keyInfo:this,data:this.__rawData,changes:e})},_loadImpl:function(e){var t=new h.Deferred;return"raw"===this._loadMode?x(t,this,e,!1):(y(this,e).done((function(e,n){t.resolve(e,n)})).fail(v(t)),t=this._addFailHandlers(t)),t.promise()},_byKeyImpl:function(e,t){var n=new h.Deferred;return this._byKeyViaLoad()?(this._requireKey(),function(e,t,n){b(e,t,{},(function(i){for(var a,r=t.key(),s=0,u=i.length;s<u;s++)if(a=i[s],(0,o.keysEqual)(r,t.keyOf(i[s]),n))return void e.resolve(a);e.reject(l.errors.Error("E4009"))}))}(n,this,e)):function(e,t,n){var i,o=e._byKeyFunc;return m("byKey",o),f(i=o.apply(e,[t,n]))||(i=g(i)),(0,h.fromPromise)(i)}(this,e,t).done((function(e){n.resolve(e)})).fail(v(n)),n.promise()},_byKeyViaLoad:function(){return"raw"===this._loadMode&&!this._byKeyFunc},_insertImpl:function(e){var t,n=this,i=n._insertFunc,o=new h.Deferred;return m("insert",i),f(t=i.apply(n,[e]))||(t=g(t)),(0,h.fromPromise)(t).done((function(t){(0,s.default)().useLegacyStoreResult?o.resolve(e,t):o.resolve(t||e,n.keyOf(t))})).fail(v(o)),o.promise()},_updateImpl:function(e,t){var n,i=this._updateFunc,o=new h.Deferred;return m("update",i),f(n=i.apply(this,[e,t]))||(n=g(n)),(0,h.fromPromise)(n).done((function(n){(0,s.default)().useLegacyStoreResult?o.resolve(e,t):o.resolve(n||t,e)})).fail(v(o)),o.promise()},_removeImpl:function(e){var t,n=this._removeFunc,i=new h.Deferred;return m("remove",n),f(t=n.apply(this,[e]))||(t=g()),(0,h.fromPromise)(t).done((function(){i.resolve(e)})).fail(v(i)),i.promise()}});t.default=w,e.exports=t.default,e.exports.default=t.default},33546:function(e,t,n){t.default=void 0;var i=n(85273).DataSource;t.default=i,e.exports=t.default,e.exports.default=t.default},85273:function(e,t,n){t.DataSource=void 0;var i=_(n(38377)),o=n(13306),a=n(20576),r=n(95479),s=n(35922),l=n(16454),u=n(60637),d=_(n(88036)),c=n(80566),h=n(18438),p=n(59504),f=n(62754),g=_(n(88665)),m=n(9234);function _(e){return e&&e.__esModule?e:{default:e}}function v(e){return function(e){if(Array.isArray(e))return y(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return y(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return y(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function y(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}var b=i.default.inherit({ctor:function(e){var t,n=this;if(e=(0,m.normalizeDataSourceOptions)(e),this._eventsStrategy=new c.EventsStrategy(this,{syncStrategy:!0}),this._store=e.store,this._changedTime=0,0!==e.pushAggregationTimeout){var i,o,a=void 0===e.pushAggregationTimeout?function(){return 5*n._changedTime}:e.pushAggregationTimeout,s=(0,l.throttleChanges)((function(e){i.resolve(),f.when.apply(void 0,v(o)).done((function(){return n._onPush(e)})),o=void 0,i=void 0}),a);this._onPushHandler=function(e){n._aggregationTimeoutId=s(e.changes),i||(i=new f.Deferred),o=e.waitFor,e.waitFor.push(i.promise())},this._store.on("beforePush",this._onPushHandler)}else this._onPushHandler=function(e){return n._onPush(e)},this._store.on("push",this._onPushHandler);this._storeLoadOptions=this._extractLoadOptions(e),this._mapFunc=e.map,this._postProcessFunc=e.postProcess,this._pageIndex=void 0!==e.pageIndex?e.pageIndex:0,this._pageSize=void 0!==e.pageSize?e.pageSize:20,this._loadingCount=0,this._loadQueue=this._createLoadQueue(),this._searchValue="searchValue"in e?e.searchValue:null,this._searchOperation=e.searchOperation||"contains",this._searchExpr=e.searchExpr,this._paginate=e.paginate,this._reshapeOnPush=null!==(t=e.reshapeOnPush)&&void 0!==t&&t,(0,r.each)(["onChanged","onLoadError","onLoadingChanged","onCustomizeLoadResult","onCustomizeStoreLoadOptions"],(function(t,i){i in e&&n.on(i.substr(2,1).toLowerCase()+i.substr(3),e[i])})),this._operationManager=new g.default,this._init()},_init:function(){this._items=[],this._userData={},this._totalCount=-1,this._isLoaded=!1,(0,s.isDefined)(this._paginate)||(this._paginate=!this.group()),this._isLastPage=!this._paginate},dispose:function(){var e;this._store.off("beforePush",this._onPushHandler),this._store.off("push",this._onPushHandler),this._eventsStrategy.dispose(),clearTimeout(this._aggregationTimeoutId),null===(e=this._delayedLoadTask)||void 0===e||e.abort(),this._operationManager.cancelAll(),delete this._store,delete this._items,delete this._delayedLoadTask,this._disposed=!0},_extractLoadOptions:function(e){var t={},n=["sort","filter","select","group","requireTotalCount"],i=this._store._customLoadOptions();return i&&(n=n.concat(i)),(0,r.each)(n,(function(){t[this]=e[this]})),t},loadOptions:function(){return this._storeLoadOptions},items:function(){return this._items},pageIndex:function(e){if(!(0,s.isNumeric)(e))return this._pageIndex;this._pageIndex=e,this._isLastPage=!this._paginate},paginate:function(e){if(!(0,s.isBoolean)(e))return this._paginate;this._paginate!==e&&(this._paginate=e,this.pageIndex(0))},pageSize:function(e){if(!(0,s.isNumeric)(e))return this._pageSize;this._pageSize=e},isLastPage:function(){return this._isLastPage},generateStoreLoadOptionAccessor:function(e){var t=this;return function(n){var i=(0,m.normalizeStoreLoadOptionAccessorArguments)(n);if(void 0===i)return t._storeLoadOptions[e];t._storeLoadOptions[e]=i}},sort:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return this.generateStoreLoadOptionAccessor("sort")(t)},filter:function(){var e=(0,m.normalizeStoreLoadOptionAccessorArguments)(arguments);if(void 0===e)return this._storeLoadOptions.filter;this._storeLoadOptions.filter=e,this.pageIndex(0)},group:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return this.generateStoreLoadOptionAccessor("group")(t)},select:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return this.generateStoreLoadOptionAccessor("select")(t)},requireTotalCount:function(e){if(!(0,s.isBoolean)(e))return this._storeLoadOptions.requireTotalCount;this._storeLoadOptions.requireTotalCount=e},searchValue:function(e){if(arguments.length<1)return this._searchValue;this._searchValue=e,this.pageIndex(0)},searchOperation:function(e){if(!(0,s.isString)(e))return this._searchOperation;this._searchOperation=e,this.pageIndex(0)},searchExpr:function(e){var t=arguments.length;if(0===t)return this._searchExpr;t>1&&(e=[].slice.call(arguments)),this._searchExpr=e,this.pageIndex(0)},store:function(){return this._store},key:function(){var e;return null===(e=this._store)||void 0===e?void 0:e.key()},totalCount:function(){return this._totalCount},isLoaded:function(){return this._isLoaded},isLoading:function(){return this._loadingCount>0},beginLoading:function(){this._changeLoadingCount(1)},endLoading:function(){this._changeLoadingCount(-1)},_createLoadQueue:function(){return(0,p.create)()},_changeLoadingCount:function(e){var t=this.isLoading();this._loadingCount+=e;var n=this.isLoading();t^n&&this._eventsStrategy.fireEvent("loadingChanged",[n])},_scheduleLoadCallbacks:function(e){var t=this;this.beginLoading(),e.always((function(){t.endLoading()}))},_scheduleFailCallbacks:function(e){var t=this;e.fail((function(){for(var e=arguments.length,n=new Array(e),i=0;i<e;i++)n[i]=arguments[i];n[0]!==m.CANCELED_TOKEN&&t._eventsStrategy.fireEvent("loadError",n)}))},_fireChanged:function(e){var t=new Date;this._eventsStrategy.fireEvent("changed",e),this._changedTime=new Date-t},_scheduleChangedCallbacks:function(e){var t=this;e.done((function(){return t._fireChanged()}))},loadSingle:function(e,t){var n=this,i=new f.Deferred,o=this.key(),a=this._store,r=this._createStoreLoadOptions(),l=function(e){var t=Array.isArray(e)&&!e.length;!(0,s.isDefined)(e)||t?i.reject(new h.errors.Error("E4009")):(Array.isArray(e)||(e=[e]),i.resolve(n._applyMapFunction(e)[0]))};this._scheduleFailCallbacks(i),arguments.length<2&&(t=e,e=o),delete r.skip,delete r.group,delete r.refresh,delete r.pageIndex,delete r.searchString;var u=function(){return a instanceof d.default&&!a._byKeyViaLoad()};return(e===o||u()?a.byKey(t,r):(r.take=1,r.filter=r.filter?[r.filter,[e,t]]:[e,t],a.load(r))).fail(i.reject).done(l),i.promise()},load:function(){var e=this,t=new f.Deferred,n=function(){if(!e._disposed&&(0,m.isPending)(t))return e._loadFromStore(i,t)};this._scheduleLoadCallbacks(t),this._scheduleFailCallbacks(t),this._scheduleChangedCallbacks(t);var i=this._createLoadOperation(t);return this._eventsStrategy.fireEvent("customizeStoreLoadOptions",[i]),this._loadQueue.add((function(){return"number"==typeof i.delay?e._delayedLoadTask=(0,a.executeAsync)(n,i.delay):n(),t.promise()})),t.promise({operationId:i.operationId})},_onPush:function(e){var t=this;if(this._reshapeOnPush)this.load();else{this._eventsStrategy.fireEvent("changing",[{changes:e}]);var n=this.group(),i=this.items(),o=0,a=this.paginate()||n?e.filter((function(e){return"update"===e.type})):e;n&&(o=Array.isArray(n)?n.length:1),this._mapFunc&&a.forEach((function(e){"insert"===e.type&&(e.data=t._mapFunc(e.data))})),(0,u.applyBatch)({keyInfo:this.store(),data:i,changes:a,groupCount:o,useInsertIndex:!0}),this._fireChanged([{changes:e}])}},_createLoadOperation:function(e){var t=this,n=this._operationManager.add(e),i=this._createStoreLoadOptions();return e.always((function(){return t._operationManager.remove(n)})),{operationId:n,storeLoadOptions:i}},reload:function(){var e=this.store();return e instanceof d.default&&e.clearRawDataCache(),this._init(),this.load()},cancel:function(e){return this._operationManager.cancel(e)},cancelAll:function(){return this._operationManager.cancelAll()},_addSearchOptions:function(e){this._disposed||(this.store()._useDefaultSearch?this._addSearchFilter(e):(e.searchOperation=this._searchOperation,e.searchValue=this._searchValue,e.searchExpr=this._searchExpr))},_createStoreLoadOptions:function(){var e=(0,o.extend)({},this._storeLoadOptions);return this._addSearchOptions(e),this._paginate&&this._pageSize&&(e.skip=this._pageIndex*this._pageSize,e.take=this._pageSize),e.userData=this._userData,e},_addSearchFilter:function(e){var t=this._searchValue,n=this._searchOperation,i=this._searchExpr,o=[];t&&(i||(i="this"),Array.isArray(i)||(i=[i]),(0,r.each)(i,(function(e,i){o.length&&o.push("or"),o.push([i,n,t])})),e.filter?e.filter=[o,e.filter]:e.filter=o)},_loadFromStore:function(e,t){var n=this,i=function(i,a){if(!n._disposed&&(0,m.isPending)(t)){var r=(0,o.extend)((0,m.normalizeLoadResult)(i,a),e);n._eventsStrategy.fireEvent("customizeLoadResult",[r]),(0,f.when)(r.data).done((function(e){r.data=e,n._processStoreLoadResult(r,t)})).fail(t.reject)}};return e.data?(new f.Deferred).resolve(e.data).done(i):this.store().load(e.storeLoadOptions).done(i).fail(t.reject)},_processStoreLoadResult:function(e,t){var n=this,i=e.data,o=e.extra,a=e.storeLoadOptions,r=function(){return n._isLoaded=!0,n._totalCount=isFinite(o.totalCount)?o.totalCount:-1,t.resolve(i,o)};this._disposed||(i=this._applyPostProcessFunction(this._applyMapFunction(i)),(0,s.isPlainObject)(o)||(o={}),this._items=i,(!i.length||!this._paginate||this._pageSize&&i.length<this._pageSize)&&(this._isLastPage=!0),a.requireTotalCount&&!isFinite(o.totalCount)?n.store().totalCount(a).done((function(e){o.totalCount=e,r()})).fail(t.reject):r())},_applyMapFunction:function(e){return this._mapFunc?(0,m.mapDataRespectingGrouping)(e,this._mapFunc,this.group()):e},_applyPostProcessFunction:function(e){return this._postProcessFunc?this._postProcessFunc(e):e},on:function(e,t){return this._eventsStrategy.on(e,t),this},off:function(e,t){return this._eventsStrategy.off(e,t),this}});t.DataSource=b},88665:function(e,t,n){t.default=void 0;var i=n(9234),o=function(){function e(){this._counter=-1,this._deferreds={}}var t=e.prototype;return t.add=function(e){return this._counter++,this._deferreds[this._counter]=e,this._counter},t.remove=function(e){return delete this._deferreds[e]},t.cancel=function(e){return e in this._deferreds&&(this._deferreds[e].reject(i.CANCELED_TOKEN),!0)},t.cancelAll=function(){for(;this._counter>-1;)this.cancel(this._counter),this._counter--},e}();t.default=o,e.exports=t.default,e.exports.default=t.default},9234:function(e,t,n){t.normalizeStoreLoadOptionAccessorArguments=t.normalizeLoadResult=t.normalizeDataSourceOptions=t.mapDataRespectingGrouping=t.isPending=t.CANCELED_TOKEN=void 0;var i=h(n(37208)),o=h(n(67403)),a=h(n(26562)),r=n(95479),s=h(n(88036)),l=n(13306),u=n(35922),d=n(16454),c=["items"];function h(e){return e&&e.__esModule?e:{default:e}}function p(){return(p=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(e[i]=n[i])}return e}).apply(this,arguments)}function f(e,t){if(null==e)return{};var n,i,o=function(e,t){if(null==e)return{};var n,i,o={},a=Object.keys(e);for(i=0;i<a.length;i++)n=a[i],t.indexOf(n)>=0||(o[n]=e[n]);return o}(e,t);if(Object.getOwnPropertySymbols){var a=Object.getOwnPropertySymbols(e);for(i=0;i<a.length;i++)n=a[i],t.indexOf(n)>=0||Object.prototype.propertyIsEnumerable.call(e,n)&&(o[n]=e[n])}return o}t.CANCELED_TOKEN="canceled";t.isPending=function(e){return"pending"===e.state()};t.normalizeStoreLoadOptionAccessorArguments=function(e){switch(e.length){case 0:return;case 1:return e[0]}return[].slice.call(e)};var g=function(e,t,n){return(0,r.map)(e,(function(e){e.items;return p({},f(e,c),{items:m(e.items,t-1,n)})}))},m=function(e,t,n){return Array.isArray(e)?t?g(e,t,n):(0,r.map)(e,n):e};t.mapDataRespectingGrouping=function(e,t,n){var i=n?(0,d.normalizeSortingInfo)(n).length:0;return m(e,i,t)};t.normalizeLoadResult=function(e,t){var n;return null!==(n=e)&&void 0!==n&&n.data&&(t=e,e=e.data),Array.isArray(e)||(e=[e]),{data:e,extra:t}};var _=function(e,t){return new s.default({load:function(){return i.default.sendRequest({url:e,dataType:"json"})},loadMode:null==t?void 0:t.fromUrlLoadMode})};t.normalizeDataSourceOptions=function(e,t){var n,i,d;return"string"==typeof e&&(e={paginate:!1,store:_(e,t)}),void 0===e&&(e=[]),void 0===(e=Array.isArray(e)||e instanceof o.default?{store:e}:(0,l.extend)({},e)).store&&(e.store=[]),n=e.store,"load"in e?n=function(e){var t={};return(0,r.each)(["useDefaultSearch","key","load","loadMode","cacheRawData","byKey","lookup","totalCount","insert","update","remove"],(function(){t[this]=e[this],delete e[this]})),new s.default(t)}(e):Array.isArray(n)?n=new a.default(n):(0,u.isPlainObject)(n)&&(i=(0,l.extend)({},n),d=i.type,delete i.type,n=o.default.create(d,i)),e.store=n,e}},8162:function(e,t,n){t.default=void 0;var i,o=(i=n(17381))&&i.__esModule?i:{default:i};var a,r,s=(0,n(58201).getWindow)();var l=function(e){var t;this.config=e,a="ms-appx:"===s.location.protocol,t=s.location.hostname,r=/^(localhost$|127\.)/i.test(t)};l.prototype={urlFor:function(e){var t=this.config[e];if(!t)throw o.default.Error("E0006");return t.production&&(a&&!Debug.debuggerEnabled||!a&&!r)?t.production:t.local}};var u=l;t.default=u,e.exports=t.default,e.exports.default=t.default},18438:function(e,t,n){t.setErrorHandler=t.handleError=t.errors=t.errorHandler=void 0;var i=a(n(95640)),o=a(n(17381));function a(e){return e&&e.__esModule?e:{default:e}}var r=(0,i.default)(o.default.ERROR_MESSAGES,{E4000:"[DevExpress.data]: {0}",E4001:"Unknown aggregating function is detected: '{0}'",E4002:"Unsupported OData protocol version is used",E4003:"Unknown filter operation is used: {0}",E4004:"The thenby() method is called before the sortby() method",E4005:"Store requires a key expression for this operation",E4006:"ArrayStore 'data' option must be an array",E4007:"Compound keys cannot be auto-generated",E4008:"Attempt to insert an item with a duplicated key",E4009:"Data item cannot be found",E4010:"CustomStore does not support creating queries",E4011:"Custom Store method is not implemented or is not a function: {0}",E4012:"Custom Store method returns an invalid value: {0}",E4013:"Local Store requires the 'name' configuration option is specified",E4014:"Unknown data type is specified for ODataStore: {0}",E4015:"Unknown entity name or alias is used: {0}",E4016:"The compileSetter(expr) method is called with 'self' passed as a parameter",E4017:"Keys cannot be modified",E4018:"The server has returned a non-numeric value in a response to an item count request",E4019:"Mixing of group operators inside a single group of filter expression is not allowed",E4020:"Unknown store type is detected: {0}",E4021:"The server response does not provide the totalCount value",E4022:"The server response does not provide the groupCount value",E4023:"Could not parse the following XML: {0}",E4024:"String function {0} cannot be used with the data field {1} of type {2}.",W4000:"Data returned from the server has an incorrect structure",W4001:'The {0} field is listed in both "keyType" and "fieldTypes". The value of "fieldTypes" is used.',W4002:"Data loading has failed for some cells due to the following error: {0}"});t.errors=r;var s=null;t.errorHandler=s;t.handleError=function(e){var t;null===(t=s)||void 0===t||t(e)};t.setErrorHandler=function(e){return t.errorHandler=s=e}},82837:function(e,t,n){t.default=void 0;var i=d(n(55994)),o=d(n(73349)),a=n(58201),r=d(n(38377)),s=n(18438),l=d(n(26562)),u=d(n(96687));function d(e){return e&&e.__esModule?e:{default:e}}var c=(0,a.getWindow)(),h=r.default.abstract,p={dom:r.default.inherit({ctor:function(e,t){this._store=e,this._dirty=!!t.data,this.save();var n=this._immediate=t.immediate,a=Math.max(100,t.flushInterval||1e4);if(!n){var r=this.save.bind(this);setInterval(r,a),i.default.on(c,"beforeunload",r),c.cordova&&o.default.listen(o.default.getDocument(),"pause",r,!1)}},notifyChanged:function(){this._dirty=!0,this._immediate&&this.save()},load:function(){this._store._array=this._loadImpl(),this._dirty=!1},save:function(){this._dirty&&(this._saveImpl(this._store._array),this._dirty=!1)},_loadImpl:h,_saveImpl:h}).inherit({ctor:function(e,t){var n=t.name;if(!n)throw s.errors.Error("E4013");this._key="dx-data-localStore-"+n,this.callBase(e,t)},_loadImpl:function(){var e=c.localStorage.getItem(this._key);return e?JSON.parse(e):[]},_saveImpl:function(e){e.length?c.localStorage.setItem(this._key,JSON.stringify(e)):c.localStorage.removeItem(this._key)}})},f=l.default.inherit({ctor:function(e){e="string"==typeof e?{name:e}:e||{},this.callBase(e),this._backend=new p[e.backend||"dom"](this,e),this._backend.load()},clear:function(){this.callBase(),this._backend.notifyChanged()},createQuery:function(){return(0,u.default)(this._backend._loadImpl(),{errorHandler:this._errorHandler})},_insertImpl:function(e){var t=this._backend;return this.callBase(e).done(t.notifyChanged.bind(t))},_updateImpl:function(e,t){var n=this._backend;return this.callBase(e,t).done(n.notifyChanged.bind(n))},_removeImpl:function(e){var t=this._backend;return this.callBase(e).done(t.notifyChanged.bind(t))}},"local");t.default=f,e.exports=t.default,e.exports.default=t.default},47256:function(e,t,n){t.default=void 0;var i=h(n(38377)),o=n(13306),a=n(35922),r=n(95479),s=n(18438),l=h(n(341)),u=h(n(63081)),d=n(77869),c=n(62754);function h(e){return e&&e.__esModule?e:{default:e}}n(54263);var p=i.default.inherit({ctor:function(e){var t=this;this._requestDispatcher=new u.default(e),this._errorHandler=e.errorHandler,(0,r.each)(e.entities||[],(function(n,i){t[n]=new l.default((0,o.extend)({},e,{url:"".concat(t._requestDispatcher.url,"/").concat(encodeURIComponent(i.name||n))},i))}))},get:function(e,t){return this.invoke(e,t,"GET")},invoke:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"POST";n=n.toLowerCase();var i,o=new c.Deferred,r="".concat(this._requestDispatcher.url,"/").concat(encodeURIComponent(e));return 4===this.version()&&("get"===n?(r=(0,d.formatFunctionInvocationUrl)(r,(0,d.escapeServiceOperationParams)(t,this.version())),t=null):"post"===n&&(i=t,t=null)),(0,c.when)(this._requestDispatcher.sendRequest(r,n,(0,d.escapeServiceOperationParams)(t,this.version()),i)).done((function(t){(0,a.isPlainObject)(t)&&e in t&&(t=t[e]),o.resolve(t)})).fail(this._errorHandler).fail(s.handleError).fail(o.reject),o.promise()},objectLink:function(e,t){var n=this[e];if(!n)throw s.errors.Error("E4015",e);return(0,a.isDefined)(t)?{__metadata:{uri:n._byKeyUrl(t)}}:null},version:function(){return this._requestDispatcher.version}});t.default=p,e.exports=t.default,e.exports.default=t.default},54263:function(e,t,n){t.odata=void 0;var i=n(35922),o=n(95479),a=c(n(80209)),r=n(13306),s=c(n(16135)),l=n(77869),u=n(18438),d=n(16454);function c(e){return e&&e.__esModule?e:{default:e}}var h,p,f,g,m,_,v,y,b,x,w,C,S=["contains","notcontains","startswith","endswith"],k=(m=function(e,t){return function(n,i){var o=[e,"("];return p&&(n=-1===n.indexOf("tolower(")?"tolower(".concat(n,")"):n,i=i.toLowerCase()),t?o.push(i,",",n):o.push(n,",",i),o.push(")"),o.join("")}},_={"=":(g=function(e){return function(t,n){return"".concat(t," ").concat(e," ").concat(n)}})("eq"),"<>":g("ne"),">":g("gt"),">=":g("ge"),"<":g("lt"),"<=":g("le"),startswith:m("startswith"),endswith:m("endswith")},v=(0,r.extend)({},_,{contains:m("substringof",!0),notcontains:m("not substringof",!0)}),y=(0,r.extend)({},_,{contains:m("contains"),notcontains:m("not contains")}),b=function(e){var t,n,i=(e=(0,d.normalizeBinaryCriterion)(e))[1],o=e[0],a=f&&f[o];if(a&&(n=i,S.some((function(e){return e===n})))&&"String"!==a)throw new u.errors.Error("E4024",i,o,a);var r=(4===h?y:v)[i.toLowerCase()];if(!r)throw u.errors.Error("E4003",i);var s=e[2];return null!==(t=f)&&void 0!==t&&t[o]&&(s=(0,l.convertPrimitiveValue)(f[o],s)),r((0,l.serializePropName)(o),(0,l.serializeValue)(s,h))},x=function(e){var t=e[0],n=C(e[1]);if("!"===t)return"not (".concat(n,")");throw u.errors.Error("E4003",t)},w=function(e){var t,n,i=[];return(0,o.each)(e,(function(e,o){if(Array.isArray(o)){if(i.length>1&&t!==n)throw new u.errors.Error("E4019");i.push("(".concat(C(o),")")),t=n,n="and"}else n=(0,d.isConjunctiveOperator)(this)?"and":"or"})),i.join(" ".concat(t," "))},C=function(e){return Array.isArray(e[0])?w(e):(0,d.isUnaryOperation)(e)?x(e):b(e)},function(e,t,n,i){return f=n,p=null!=i?i:(0,a.default)().oDataFilterToLower,h=t,C(e)}),D=function(e){var t,n,o,a,s=[],u=[],d=e.expand,c=e.version||2,h=function(){return n||void 0!==o},p=function e(t){for(var n=0;n<t.length;n++){if((0,i.isFunction)(t[n]))return!0;if(Array.isArray(t[n])&&e(t[n]))return!0}return!1},f=function(){var i={};if(a||(s.length&&(i.$orderby=s.join(",")),n&&(i.$skip=n),void 0!==o&&(i.$top=o),i.$select=(0,l.generateSelect)(c,t)||void 0,i.$expand=(0,l.generateExpand)(c,d,t)||void 0),u.length){var r=u.length<2?u[0]:u,h=null==e?void 0:e.fieldTypes,p=null==e?void 0:e.filterToLower;i.$filter=k(r,c,h,p)}return a&&(i.$top=0),(e.requireTotalCount||a)&&(4!==c?i.$inlinecount="allpages":i.$count="true"),i};return{optimize:function(e){for(var t=-1,n=0;n<e.length;n++)if("select"===e[n].name){t=n;break}if(!(t<0)&&(0,i.isFunction)(e[t].args[0])){var o=e[1+t];o&&"slice"===o.name&&(e[1+t]=e[t],e[t]=o)}},exec:function(t){return(0,l.sendRequest)(c,{url:t,params:(0,r.extend)(f(),null==e?void 0:e.params)},{beforeSend:e.beforeSend,jsonp:e.jsonp,withCredentials:e.withCredentials,countOnly:a,deserializeDates:e.deserializeDates,fieldTypes:e.fieldTypes,isPaged:isFinite(o)})},multiSort:function(e){var t;if(h())return!1;for(var n=0;n<e.length;n++){var i=e[n][0],o=!!e[n][1],a=void 0;if("string"!=typeof i)return!1;a=(0,l.serializePropName)(i),o&&(a+=" desc"),(t=t||[]).push(a)}s=t},slice:function(e,t){if(h())return!1;n=e,o=t},filter:function(e){return!h()&&(Array.isArray(e)||(e=[].slice.call(arguments)),!p(e)&&(u.length&&u.push("and"),void u.push(e)))},select:function(e){if(t||(0,i.isFunction)(e))return!1;Array.isArray(e)||(e=[].slice.call(arguments)),t=e},count:function(){return a=!0}}};s.default.odata=D;var I=D;t.odata=I},63081:function(e,t,n){t.default=void 0;var i=n(77869);function o(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}n(54263);var a=function(){function e(e){e=e||{},this._url=String(e.url).replace(/\/+$/,""),this._beforeSend=e.beforeSend,this._jsonp=e.jsonp,this._version=e.version||2,this._withCredentials=e.withCredentials,this._deserializeDates=e.deserializeDates,this._filterToLower=e.filterToLower}var t,n,a;return e.prototype.sendRequest=function(e,t,n,o){return(0,i.sendRequest)(this.version,{url:e,method:t,params:n||{},payload:o},{beforeSend:this._beforeSend,jsonp:this._jsonp,withCredentials:this._withCredentials,deserializeDates:this._deserializeDates})},t=e,(n=[{key:"version",get:function(){return this._version}},{key:"beforeSend",get:function(){return this._beforeSend}},{key:"url",get:function(){return this._url}},{key:"jsonp",get:function(){return this._jsonp}},{key:"filterToLower",get:function(){return this._filterToLower}}])&&o(t.prototype,n),a&&o(t,a),Object.defineProperty(t,"prototype",{writable:!1}),e}();t.default=a,e.exports=t.default,e.exports.default=t.default},341:function(e,t,n){t.default=void 0;var i=n(35922),o=c(n(80209)),a=n(77869),r=n(18438),s=c(n(96687)),l=c(n(67403)),u=c(n(63081)),d=n(62754);function c(e){return e&&e.__esModule?e:{default:e}}n(54263);var h=function(e,t){return function(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}({},e,t)},p=l.default.inherit({ctor:function(e){this.callBase(e),this._requestDispatcher=new u.default(e);var t=this.key(),n=e.fieldTypes,i=e.keyType;if(i){var o="string"==typeof i;t||(t=o?"5d46402c-7899-4ea9-bd81-8b73c47c7683":Object.keys(i),this._legacyAnonymousKey=t),o&&(i=h(t,i)),n=function(e,t){var n={};for(var i in e)n[i]=e[i];for(var o in t)o in n?n[o]!==t[o]&&r.errors.log("W4001",o):n[o]=t[o];return n}(n,i)}this._fieldTypes=n||{},2===this.version()?this._updateMethod="MERGE":this._updateMethod="PATCH"},_customLoadOptions:function(){return["expand","customQueryParams"]},_byKeyImpl:function(e,t){var n={};return t&&(n.$expand=(0,a.generateExpand)(this.version(),t.expand,t.select)||void 0,n.$select=(0,a.generateSelect)(this.version(),t.select)||void 0),this._requestDispatcher.sendRequest(this._byKeyUrl(e),"GET",n)},createQuery:function(e){var t,n,o={adapter:"odata",beforeSend:this._requestDispatcher.beforeSend,errorHandler:this._errorHandler,jsonp:this._requestDispatcher.jsonp,version:this._requestDispatcher.version,withCredentials:this._requestDispatcher._withCredentials,expand:null==e?void 0:e.expand,requireTotalCount:null==e?void 0:e.requireTotalCount,deserializeDates:this._requestDispatcher._deserializeDates,fieldTypes:this._fieldTypes};if(n=null!==(t=null==e?void 0:e.urlOverride)&&void 0!==t?t:this._requestDispatcher.url,(0,i.isDefined)(this._requestDispatcher.filterToLower)&&(o.filterToLower=this._requestDispatcher.filterToLower),null!=e&&e.customQueryParams){var r=(0,a.escapeServiceOperationParams)(null==e?void 0:e.customQueryParams,this.version());4===this.version()?n=(0,a.formatFunctionInvocationUrl)(n,r):o.params=r}return(0,s.default)(n,o)},_insertImpl:function(e){var t=this;this._requireKey();var n=new d.Deferred;return(0,d.when)(this._requestDispatcher.sendRequest(this._requestDispatcher.url,"POST",null,e)).done((function(i){return n.resolve(i&&!(0,o.default)().useLegacyStoreResult?i:e,t.keyOf(i))})).fail(n.reject),n.promise()},_updateImpl:function(e,t){var n=new d.Deferred;return(0,d.when)(this._requestDispatcher.sendRequest(this._byKeyUrl(e),this._updateMethod,null,t)).done((function(i){return(0,o.default)().useLegacyStoreResult?n.resolve(e,t):n.resolve(i||t,e)})).fail(n.reject),n.promise()},_removeImpl:function(e){var t=new d.Deferred;return(0,d.when)(this._requestDispatcher.sendRequest(this._byKeyUrl(e),"DELETE")).done((function(){return t.resolve(e)})).fail(t.reject),t.promise()},_convertKey:function(e){var t=e,n=this._fieldTypes,i=this.key()||this._legacyAnonymousKey;if(Array.isArray(i)){t={};for(var o=0;o<i.length;o++){var r=i[o];t[r]=(0,a.convertPrimitiveValue)(n[r],e[r])}}else n[i]&&(t=(0,a.convertPrimitiveValue)(n[i],e));return t},_byKeyUrl:function(e){var t=this._requestDispatcher.url,n=this._convertKey(e);return"".concat(t,"(").concat(encodeURIComponent((0,a.serializeKey)(n,this.version())),")")},version:function(){return this._requestDispatcher.version}},"odata");t.default=p,e.exports=t.default,e.exports.default=t.default},77869:function(e,t,n){t.serializeValue=t.serializePropName=t.serializeKey=t.sendRequest=t.keyConverters=t.generateSelect=t.generateExpand=t.formatFunctionInvocationUrl=t.escapeServiceOperationParams=t.convertPrimitiveValue=t.EdmLiteral=void 0;var i=f(n(38377)),o=n(13306),a=n(35922),r=n(95479),s=f(n(37208)),l=f(n(73176)),u=n(20576),d=n(62754),c=n(18438),h=n(16454),p=n(68752);function f(e){return e&&e.__esModule?e:{default:e}}function g(e){return(g="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var m=/^(\{{0,1}([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}\}{0,1})$/,_=/^\/Date\((-?\d+)((\+|-)?(\d+)?)\)\/$/,v=/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[-+]{1}\d{2}(:?)(\d{2})?)?$/,y="application/json;odata=verbose",b=function(e){return"string"===(0,a.type)(e)?e.split():e},x=function(e){return/\./.test(e)},w=function(e,t,n){for(e=String(e);e.length<t;)e=n?"".concat(e,"0"):"0".concat(e);return e},C=function(e,t,n){var i=[],o=function(e){return w(e,2)};return i.push(e.getFullYear()),i.push("-"),i.push(o(e.getMonth()+1)),i.push("-"),i.push(o(e.getDate())),t&&e.getHours()+e.getMinutes()+e.getSeconds()+e.getMilliseconds()<1||(i.push("T"),i.push(o(e.getHours())),i.push(":"),i.push(o(e.getMinutes())),i.push(":"),i.push(o(e.getSeconds())),e.getMilliseconds()&&(i.push("."),i.push(w(e.getMilliseconds(),3))),n||i.push("Z")),i.join("")},S=function(e){var t=new Date(60*new Date(0).getTimezoneOffset()*1e3),n=e.replace("Z","").split("T"),i=/(\d{4})-(\d{2})-(\d{2})/.exec(n[0]),o=/(\d{2}):(\d{2}):(\d{2})\.?(\d{0,7})?/.exec(n[1]);if(t.setFullYear(Number(i[1])),t.setMonth(Number(i[2])-1),t.setDate(Number(i[3])),Array.isArray(o)&&o.length){t.setHours(Number(o[1])),t.setMinutes(Number(o[2])),t.setSeconds(Number(o[3]));var a=(o[4]||"").slice(0,3);a=w(a,3,!0),t.setMilliseconds(Number(a))}return t},k=function(e){var t=[];for(var n in e)t.push(n+"="+e[n]);return t.join("&")};t.sendRequest=function e(t,n,i){var a=i.deserializeDates,r=i.fieldTypes,l=i.countOnly,u=i.isPaged,p=new d.Deferred,f=function(e,t){var n,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=function(t){return JSON.stringify(t,(function(t,n){if(!(this[t]instanceof Date))return n;switch(n=C(this[t]),e){case 2:return n.substr(0,n.length-1);case 3:case 4:return n;default:throw c.errors.Error("E4002")}}))};t=(0,o.extend)({async:!0,method:"get",url:"",params:{},payload:null,headers:{},timeout:3e4},t),null===(n=i.beforeSend)||void 0===n||n.call(i,t);var r=t,s=r.async,l=r.timeout,u=r.headers,d=t,h=d.url,p=d.method,f=i.jsonp,g=i.withCredentials,m="get"===(p=(p||"get").toLowerCase()),_=m&&f,v=(0,o.extend)({},t.params),b=m?v:a(t.payload),x=!m&&k(v),w=!m&&y;return x&&(h+=(h.indexOf("?")>-1?"&":"?")+x),_&&(b.$format="json"),{url:h,data:b,dataType:_?"jsonp":"json",jsonp:_&&"$callback",method:p,async:s,timeout:l,headers:u,contentType:w,accepts:{json:[y,"text/plain"].join()},xhrFields:{withCredentials:g}}}(t,n,i);return s.default.sendRequest(f).always((function(n,o){var s=D(n,o,{deserializeDates:a,fieldTypes:r},f),d=s.error,g=s.data,m=s.count,_=s.nextUrl;if(d)d.message!==h.XHR_ERROR_UNLOAD&&p.reject(d);else if(l)isFinite(m)?p.resolve(m):p.reject(new c.errors.Error("E4018"));else if(_&&!u)/^(?:[a-z]+:)?\/\//i.test(_)||(_=function(e,t){var n,i,o,a=(i=e,o=i.indexOf("?"),o>-1?i.substr(0,o):i).split("/"),r=t.split("/");for(a.pop();r.length;)".."===(n=r.shift())?a.pop():a.push(n);return a.join("/")}(f.url,_)),e(t,{url:_},i).fail(p.reject).done((function(e){return p.resolve(g.concat(e))}));else{var v=isFinite(m)?{totalCount:m}:void 0;p.resolve(g,v)}})),p.promise()};var D=function(e,t,n,i){var r=function(e,t,n){var i,a,r,s;if("nocontent"===t)return null;var l="Unknown error",u=e,d=200,c={requestOptions:n};if("success"!==t){var p=e.status,f=e.responseText;d=p,l=(0,h.errorMessageFromXhr)(e,t);try{u=JSON.parse(f)}catch(e){}}var g=(null===(i=u)||void 0===i?void 0:i.then)||(null===(a=u)||void 0===a?void 0:a.error)||(null===(r=u)||void 0===r?void 0:r["odata.error"])||(null===(s=u)||void 0===s?void 0:s["@odata.error"]);if(g){l=function(e){var t,n,i=e;"message"in e&&(t=(null===(n=e.message)||void 0===n?void 0:n.value)||e.message);for(;i=i.innererror||i.internalexception;){var o;if(t=null!==(o=i.message)&&void 0!==o?o:t,i.internalexception&&-1===t.indexOf("inner exception"))break}return t}(g)||l,c.errorDetails=g,200===d&&(d=500);var m=Number(g.code);isFinite(m)&&m>=400&&(d=m)}return d>=400||0===d?(c.httpStatus=d,(0,o.extend)(Error(l),c)):null}(e,t,i);if(r)return{error:r};if(!(0,a.isPlainObject)(e))return{data:e};var s="d"in e&&(Array.isArray(e.d)||(0,a.isObject)(e.d))?I(e,t):T(e,t);return O(s,n),s},I=function(e){var t,n=e.d;return(0,a.isDefined)(n)?{data:null!==(t=n.results)&&void 0!==t?t:n,nextUrl:n.__next,count:parseInt(n.__count,10)}:{error:Error("Malformed or unsupported JSON response received")}},T=function(e){var t;return{data:null!==(t=e.value)&&void 0!==t?t:e,nextUrl:e["@odata.nextLink"],count:parseInt(e["@odata.count"],10)}},E=i.default.inherit({ctor:function(e){this._value=e},valueOf:function(){return this._value}});t.EdmLiteral=E;var O=function e(t){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};(0,r.each)(t,(function(i,o){if(null!==o&&"object"===g(o))"results"in o&&(t[i]=o.results),e(t[i],n);else if("string"==typeof o){var a=n.fieldTypes,r=n.deserializeDates;if((!a||"String"!==a[i])&&m.test(o)&&(t[i]=new l.default(o)),!1!==r)if(o.match(_)){var s=new Date(Number(RegExp.$1)+60*RegExp.$2*1e3);t[i]=new Date(s.valueOf()+60*s.getTimezoneOffset()*1e3)}else v.test(o)&&(t[i]=new Date(S(t[i]).valueOf()))}}))},A=function(e){return e instanceof E?e.valueOf():e.replace(/\./g,"/")};t.serializePropName=A;var P=function(e){return e instanceof Date?"datetime'".concat(C(e,!0,!0),"'"):e instanceof l.default?"guid'".concat(e,"'"):e instanceof E?e.valueOf():"string"==typeof e?function(e){return"'".concat(e.replace(/'/g,"''"),"'")}(e):String(e)},R=function(e,t){switch(t){case 2:case 3:return P(e);case 4:return function e(t){return t instanceof Date?C(t,!1,!1):t instanceof l.default?t.valueOf():Array.isArray(t)?"[".concat(t.map((function(t){return e(t)})).join(","),"]"):P(t)}(e);default:throw c.errors.Error("E4002")}};t.serializeValue=R;t.serializeKey=function(e,t){if((0,a.isPlainObject)(e)){var n=[];return(0,r.each)(e,(function(e,i){return n.push("".concat(A(e),"=").concat(R(i,t)))})),n.join()}return R(e,t)};var M={String:function(e){return"".concat(e)},Int32:function(e){return Math.floor(e)},Int64:function(e){return e instanceof E?e:new E("".concat(e,"L"))},Guid:function(e){return e instanceof l.default?e:new l.default(e)},Boolean:function(e){return!!e},Single:function(e){return e instanceof E?e:new E(e+"f")},Decimal:function(e){return e instanceof E?e:new E(e+"m")}};t.keyConverters=M;t.convertPrimitiveValue=function(e,t){if(null===t)return null;var n=M[e];if(!n)throw c.errors.Error("E4014",e);return n(t)};t.generateSelect=function(e,t){if(t)return e<4?A(t.join()):(0,u.grep)(t,x,!0).join()};var B=function(e){var t=[];return(0,r.each)(e,(function(e,n){return t.push("".concat(e).concat(function e(t){var n="",i=[],o=[];return(0,r.each)(t,(function(t,n){Array.isArray(n)&&[].push.apply(i,n),(0,a.isPlainObject)(n)&&o.push("".concat(t).concat(e(n)))})),(i.length||o.length)&&(n+="(",i.length&&(n+="$select=".concat((0,r.map)(i,A).join())),o.length&&(i.length&&(n+=";"),n+="$expand=".concat((0,r.map)(o,A).join())),n+=")"),n}(n)))})),t.join()},L=function(e,t,n){return(0,r.each)(e,(function(e,i){return function e(t,n,i){var o=i(n,t.shift(),t);!1!==o&&e(t,o,i)}(i.split("."),t,n)}))};t.generateExpand=function(e,t,n){return e<4?function(e,t){var n={};return e&&(0,r.each)(b(e),(function(){n[A(this)]=1})),t&&(0,r.each)(b(t),(function(){var e=this.split(".");e.length<2||(e.pop(),n[A(e.join("."))]=1)})),(0,r.map)(n,(function(e,t){return t})).join()}(t,n):function(e,t){var n={};if(e||t)return e&&L(b(e),n,(function(e,t,n){return e[t]=e[t]||{},!!n.length&&e[t]})),t&&L((0,u.grep)(b(t),x),n,(function(e,t,n){return n.length?e[t]=e[t]||{}:(e[t]=e[t]||[],e[t].push(t),!1)})),B(n)}(t,n)};t.formatFunctionInvocationUrl=function(e,t){return(0,p.format)("{0}({1})",e,(0,r.map)(t||{},(function(e,t){return(0,p.format)("{0}={1}",t,e)})).join(","))};t.escapeServiceOperationParams=function(e,t){if(!e)return e;var n={};return(0,r.each)(e,(function(e,i){n[e]=R(i,t)})),n}},96687:function(e,t,n){t.default=void 0;var i=n(77549),o=function(){var e=Array.isArray(arguments[0])?"array":"remote";return i.queryImpl[e].apply(this,arguments)};t.default=o,e.exports=t.default,e.exports.default=t.default},16135:function(e,t){t.default=void 0;t.default={},e.exports=t.default,e.exports.default=t.default},77549:function(e,t,n){t.queryImpl=void 0;var i=a(n(35042)),o=a(n(41428));function a(e){return e&&e.__esModule?e:{default:e}}var r={array:i.default,remote:o.default};t.queryImpl=r},41428:function(e,t,n){t.default=void 0;var i=u(n(16135)),o=n(18438),a=n(95479),r=n(35922),s=n(62754),l=u(n(35042));function u(e){return e&&e.__esModule?e:{default:e}}var d=function e(t,n,u){u=u||[],n=n||{};var d=function(e,t){return{name:e,args:t}},c=function(e){var c,h,p,f,g,m,_,v=new s.Deferred,y=function(e){var t=n.errorHandler;t&&t(e),(0,o.handleError)(e),v.reject(e)};function b(e){switch(e.name){case"sortBy":return g=[e.args],!0;case"thenBy":if(!g)throw o.errors.Error("E4004");return g.push(e.args),!0}return!1}try{c=n.adapter,(0,r.isFunction)(c)||(c=i.default[c]),h=c(n),p=[].concat(u).concat(e);var x=h.optimize;for(x&&x(p);p.length;){if(!b(f=p[0])){if(g){p.unshift(d("multiSort",[g])),g=null;continue}if("enumerate"!==String(f.name)&&(!h[f.name]||!1===h[f.name].apply(h,f.args)))break}p.shift()}m=p[0],_=[],m&&"multiSort"===m.name&&(p.shift(),(0,a.each)(m.args[0],(function(){_.push(d(_.length?"thenBy":"sortBy",this))}))),p=_.concat(p),h.exec(t).done((function(e,t){if(p.length){var i=(0,l.default)(e,{errorHandler:n.errorHandler});(0,a.each)(p,(function(){i=i[this.name].apply(i,this.args)})),i.done(v.resolve).fail(v.reject)}else v.resolve(e,t)})).fail(y)}catch(e){y(e)}return v.promise()},h={};return(0,a.each)(["sortBy","thenBy","filter","slice","select","groupBy"],(function(){var i=String(this);h[i]=function(){return e(t,n,u.concat(d(i,arguments)))}})),(0,a.each)(["count","min","max","sum","avg","aggregate","enumerate"],(function(){var e=String(this);h[e]=function(){return c.call(this,d(e,arguments))}})),h};t.default=d,e.exports=t.default,e.exports.default=t.default},99236:function(e,t,n){t.default=void 0;var i,o=n(20576),a=n(13306),r=n(95479),s=(i=n(35042))&&i.__esModule?i:{default:i},l=n(16454);function u(e,t){return e=e.groupBy(t[0].selector),t.length>1&&(e=e.select((function(e){return(0,a.extend)({},e,{items:u((0,s.default)(e.items),t.slice(1)).toArray()})}))),e}function d(e,t){var n=[];return(0,r.each)(e,(function(e,i){(0,o.grep)(t,(function(e){return i.selector===e.selector})).length<1&&n.push(i)})),n.concat(t)}var c={multiLevelGroup:u,arrangeSortingInfo:d,queryByOptions:function(e,t,n){var i=(t=t||{}).filter;if(i&&(e=e.filter(i)),n)return e;var o=t.sort,a=t.select,s=t.group,c=t.skip,h=t.take;return s&&((s=(0,l.normalizeSortingInfo)(s)).keepInitialKeyOrder=!!t.group.keepInitialKeyOrder),(o||s)&&(o=(0,l.normalizeSortingInfo)(o||[]),s&&!s.keepInitialKeyOrder&&(o=d(s,o)),(0,r.each)(o,(function(t){e=e[t?"thenBy":"sortBy"](this.selector,this.desc,this.compare)}))),a&&(e=e.select(a)),s&&(e=u(e,s)),(h||c)&&(e=e.slice(c||0,h)),e}};t.default=c,e.exports=t.default,e.exports.default=t.default},16454:function(e,t,n){t.errorMessageFromXhr=t.base64_encode=t.aggregators=t.XHR_ERROR_UNLOAD=void 0,t.isConjunctiveOperator=function(e){return/^(and|&&|&)$/i.test(e)},t.isDisjunctiveOperator=function(e){return/^(or|\|\||\|)$/i.test(e)},t.rejectedPromise=t.processRequestResultLock=t.normalizeSortingInfo=t.normalizeBinaryCriterion=t.keysEqual=t.isUnaryOperation=t.isGroupCriterion=void 0,t.throttleChanges=function(e,t){var n=[],o=function(e,t){var n,o;return function(){var a=this;return o=arguments,n||(n=setTimeout((function(){n=void 0,o&&e.call(a,o)}),(0,i.isFunction)(t)?t():t)),n}}((function(){e.call(this,n),n=[]}),t);return function(e){var t,i;Array.isArray(e)&&(t=n).push.apply(t,function(e){if(Array.isArray(e))return c(e)}(i=e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(i)||function(e,t){if(e){if("string"==typeof e)return c(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?c(e,t):void 0}}(i)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}());return o.call(this,n)}},t.trivialPromise=void 0;var i=n(35922),o=d(n(73349)),a=d(n(24311)),r=n(58201),s=n(95479),l=n(62754),u=n(20576);function d(e){return e&&e.__esModule?e:{default:e}}function c(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}var h=a.default.add;t.XHR_ERROR_UNLOAD="DEVEXTREME_XHR_ERROR_UNLOAD";t.normalizeBinaryCriterion=function(e){return[e[0],e.length<3?"=":String(e[1]).toLowerCase(),e.length<2||e[e.length-1]]};t.normalizeSortingInfo=function(e){return Array.isArray(e)||(e=[e]),(0,s.map)(e,(function(e){var t={selector:(0,i.isFunction)(e)||"string"==typeof e?e:e.getter||e.field||e.selector,desc:!(!e.desc&&"d"!==String(e.dir).charAt(0).toLowerCase())};return e.compare&&(t.compare=e.compare),t}))};var p,f,g=(f={timeout:"Network connection timeout",error:"Unspecified network error",parsererror:"Unexpected server response"},h((function(){var e=(0,r.getWindow)();o.default.listen(e,"beforeunload",(function(){p=!0}))})),function(e,t){return p?"DEVEXTREME_XHR_ERROR_UNLOAD":e.status<400?function(e){var t=f[e];return t||e}(t):e.statusText});t.errorMessageFromXhr=g;var m={count:{seed:0,step:function(e){return 1+e}},sum:{seed:0,step:function(e,t){return e+t}},min:{step:function(e,t){return t<e?t:e}},max:{step:function(e,t){return t>e?t:e}},avg:{seed:[0,0],step:function(e,t){return[e[0]+t,e[1]+1]},finalize:function(e){return e[1]?e[0]/e[1]:NaN}}};t.aggregators=m;var _,v,y=(v=0,{obtain:function(){0===v&&(_=new l.Deferred),v++},release:function(){--v<1&&_.resolve()},promise:function(){return(0===v?(new l.Deferred).resolve():_).promise()},reset:function(){v=0,_&&_.resolve()}});t.processRequestResultLock=y;t.keysEqual=function(e,t,n){if(Array.isArray(e)){for(var i,o=(0,s.map)(t,(function(e,t){return t})),a=0;a<o.length;a++)if(i=o[a],!(0,u.equalByValue)(t[i],n[i],0,!1))return!1;return!0}return(0,u.equalByValue)(t,n,0,!1)};t.base64_encode=function(e){Array.isArray(e)||(e=function(e){var t,n,i=[];for(n=0;n<e.length;n++)(t=e.charCodeAt(n))<128?i.push(t):t<2048?i.push(192+(t>>6),128+(63&t)):t<65536?i.push(224+(t>>12),128+(t>>6&63),128+(63&t)):t<2097152&&i.push(240+(t>>18),128+(t>>12&63),128+(t>>6&63),128+(63&t));return i}(String(e)));var t="";function n(e){return"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(e)}for(var i=0;i<e.length;i+=3){var o=e[i],a=e[i+1],r=e[i+2];t+=(0,s.map)([o>>2,(3&o)<<4|a>>4,isNaN(a)?64:(15&a)<<2|r>>6,isNaN(r)?64:63&r],n).join("")}return t};t.isUnaryOperation=function(e){return"!"===e[0]&&Array.isArray(e[1])};t.isGroupCriterion=function(e){var t,n=e[0],o=e[1];return!!Array.isArray(n)||!(!(0,i.isFunction)(n)||!Array.isArray(o)&&!(0,i.isFunction)(o)&&"and"!==(t=o)&&"or"!==t)};t.trivialPromise=function(){var e=new l.Deferred;return e.resolve.apply(e,arguments).promise()};t.rejectedPromise=function(){var e=new l.Deferred;return e.reject.apply(e,arguments).promise()}},53305:function(e,t,n){t.default=void 0;var i=n(85273),o=n(13306),a=n(9234),r={postCtor:function(){this.on("disposing",function(){this._disposeDataSource()}.bind(this))},_refreshDataSource:function(){this._initDataSource(),this._loadDataSource()},_initDataSource:function(){var e,t,n="_getSpecificDataSourceOption"in this?this._getSpecificDataSourceOption():this.option("dataSource");this._disposeDataSource(),n&&(n instanceof i.DataSource?(this._isSharedDataSource=!0,this._dataSource=n):(e="_dataSourceOptions"in this?this._dataSourceOptions():{},t=this._dataSourceType?this._dataSourceType():i.DataSource,n=(0,a.normalizeDataSourceOptions)(n,{fromUrlLoadMode:"_dataSourceFromUrlLoadMode"in this&&this._dataSourceFromUrlLoadMode()}),this._dataSource=new t((0,o.extend)(!0,{},e,n))),"_normalizeDataSource"in this&&(this._dataSource=this._normalizeDataSource(this._dataSource)),this._addDataSourceHandlers())},_addDataSourceHandlers:function(){"_dataSourceChangedHandler"in this&&this._addDataSourceChangeHandler(),"_dataSourceLoadErrorHandler"in this&&this._addDataSourceLoadErrorHandler(),"_dataSourceLoadingChangedHandler"in this&&this._addDataSourceLoadingChangedHandler(),this._addReadyWatcher()},_addReadyWatcher:function(){this._dataSource.on("loadingChanged",function(e){this._ready&&this._ready(!e)}.bind(this))},_addDataSourceChangeHandler:function(){var e=this._dataSource;this._proxiedDataSourceChangedHandler=function(t){this._dataSourceChangedHandler(e.items(),t)}.bind(this),e.on("changed",this._proxiedDataSourceChangedHandler)},_addDataSourceLoadErrorHandler:function(){this._proxiedDataSourceLoadErrorHandler=this._dataSourceLoadErrorHandler.bind(this),this._dataSource.on("loadError",this._proxiedDataSourceLoadErrorHandler)},_addDataSourceLoadingChangedHandler:function(){this._proxiedDataSourceLoadingChangedHandler=this._dataSourceLoadingChangedHandler.bind(this),this._dataSource.on("loadingChanged",this._proxiedDataSourceLoadingChangedHandler)},_loadDataSource:function(){if(this._dataSource){var e=this._dataSource;e.isLoaded()?this._proxiedDataSourceChangedHandler&&this._proxiedDataSourceChangedHandler():e.load()}},_loadSingle:function(e,t){return e="this"===e?this._dataSource.key()||"this":e,this._dataSource.loadSingle(e,t)},_isLastPage:function(){return!this._dataSource||this._dataSource.isLastPage()||!this._dataSource._pageSize},_isDataSourceLoading:function(){return this._dataSource&&this._dataSource.isLoading()},_disposeDataSource:function(){this._dataSource&&(this._isSharedDataSource?(delete this._isSharedDataSource,this._proxiedDataSourceChangedHandler&&this._dataSource.off("changed",this._proxiedDataSourceChangedHandler),this._proxiedDataSourceLoadErrorHandler&&this._dataSource.off("loadError",this._proxiedDataSourceLoadErrorHandler),this._proxiedDataSourceLoadingChangedHandler&&this._dataSource.off("loadingChanged",this._proxiedDataSourceLoadingChangedHandler)):this._dataSource.dispose(),delete this._dataSource,delete this._proxiedDataSourceChangedHandler,delete this._proxiedDataSourceLoadErrorHandler,delete this._proxiedDataSourceLoadingChangedHandler)},getDataSource:function(){return this._dataSource||null}};t.default=r,e.exports=t.default,e.exports.default=t.default},95429:function(e,t,n){t.name=void 0;var i=f(n(68374)),o=f(n(55994)),a=f(n(20530)),r=f(n(73349)),s=n(3532),l=n(90057),u=n(39611),d=n(27575),c=f(n(93786)),h=f(n(31391)),p=f(n(82495));function f(e){return e&&e.__esModule?e:{default:e}}t.name="dxclick";l.requestAnimationFrame,l.cancelAnimationFrame;var g=null,m=null,_=function(){m=null},v=function(e){var t=e.originalEvent,n=m===t||t&&t.DXCLICK_FIRED;!(!e.which||1===e.which)||g||n||(t&&(t.DXCLICK_FIRED=!0),(0,d.unsubscribeNodesDisposing)(m,_),m=t,(0,d.subscribeNodesDisposing)(m,_),(0,u.fireEvent)({type:"dxclick",originalEvent:e}))},y=h.default.inherit({ctor:function(e){this.callBase(e),o.default.on(this.getElement(),"click",v)},start:function(e){g=null},cancel:function(){g=!0},dispose:function(){o.default.off(this.getElement(),"click",v)}});!function(){if(!a.default.real().generic){var e=null,t=!1,n=r.default.getDocument();o.default.subscribeGlobal(n,(0,u.addNamespace)(c.default.down,"NATIVE_CLICK_FIXER"),(function(n){e=n.target,t=n.isDefaultPrevented()})),o.default.subscribeGlobal(n,(0,u.addNamespace)("click","NATIVE_CLICK_FIXER"),(function(n){var o,a=(0,i.default)(n.target);t||!e||a.is(e)||(0,i.default)(e).is("label")||(o=a,!(0,i.default)(o).is("input, textarea, select, button ,:focus, :focus *"))||(0,s.resetActiveElement)(),e=null,t=!1}))}}(),(0,p.default)({emitter:y,bubble:!0,events:["dxclick"]})},49166:function(e,t,n){t.name=void 0;var i=c(n(68374)),o=c(n(55994)),a=n(60137),r=c(n(20530)),s=c(n(38377)),l=c(n(85788)),u=n(39611),d=c(n(11699));function c(e){return e&&e.__esModule?e:{default:e}}var h=(0,u.addNamespace)("contextmenu","dxContexMenu"),p=(0,u.addNamespace)(d.default.name,"dxContexMenu"),f=s.default.inherit({setup:function(e){var t=(0,i.default)(e);o.default.on(t,h,this._contextMenuHandler.bind(this)),(a.touch||r.default.isSimulator())&&o.default.on(t,p,this._holdHandler.bind(this))},_holdHandler:function(e){(0,u.isMouseEvent)(e)&&!r.default.isSimulator()||this._fireContextMenu(e)},_contextMenuHandler:function(e){this._fireContextMenu(e)},_fireContextMenu:function(e){return(0,u.fireEvent)({type:"dxcontextmenu",originalEvent:e})},teardown:function(e){o.default.off(e,".dxContexMenu")}});(0,l.default)("dxcontextmenu",new f);t.name="dxcontextmenu"},91633:function(e,t,n){t.lock=t.inactive=t.active=void 0;var i=c(n(38377)),o=n(20576),a=n(3532),r=c(n(20530)),s=n(39611),l=c(n(93786)),u=c(n(31391)),d=c(n(82495));function c(e){return e&&e.__esModule?e:{default:e}}t.active="dxactive";t.inactive="dxinactive";var h,p=i.default.inherit({ctor:function(e,t){this._timeout=e,this._fire=t},start:function(){var e=this;this._schedule((function(){e.force()}))},_schedule:function(e){this.stop(),this._timer=setTimeout(e,this._timeout)},stop:function(){clearTimeout(this._timer)},force:function(){this._fired||(this.stop(),this._fire(),this._fired=!0)},fired:function(){return this._fired}}),f=u.default.inherit({ctor:function(){this.callBase.apply(this,arguments),this._active=new p(0,o.noop),this._inactive=new p(0,o.noop)},configure:function(e,t){switch(t){case"dxactive":e.activeTimeout=e.timeout;break;case"dxinactive":e.inactiveTimeout=e.timeout}this.callBase(e)},start:function(e){if(h){var t=(0,a.contains)(this.getElement().get(0),h.getElement().get(0)),n=!h._active.fired();if(t&&n)return void this._cancel();h._inactive.force()}h=this,this._initEvents(e),this._active.start()},_initEvents:function(e){var t=this,n=this._getEmitterTarget(e),i=(0,s.isMouseEvent)(e),a=r.default.isSimulator()||!i,l=(0,o.ensureDefined)(this.activeTimeout,30),u=(0,o.ensureDefined)(this.inactiveTimeout,400);this._active=new p(a?l:0,(function(){t._fireEvent("dxactive",e,{target:n})})),this._inactive=new p(a?u:0,(function(){t._fireEvent("dxinactive",e,{target:n}),h=null}))},cancel:function(e){this.end(e)},end:function(e){var t=e.type!==l.default.up;t?this._active.stop():this._active.force(),this._inactive.start(),t&&this._inactive.force()},dispose:function(){this._active.stop(),this._inactive.stop(),h===this&&(h=null),this.callBase()},lockInactive:function(){return this._active.force(),this._inactive.stop(),h=null,this._cancel(),this._inactive.force.bind(this._inactive)}});f.lock=function(e){var t=h?h.lockInactive():o.noop;e.done(t)},(0,d.default)({emitter:f,events:["dxactive","dxinactive"]});var g=f.lock;t.lock=g},31391:function(e,t,n){t.default=void 0;var i=u(n(68374)),o=n(20576),a=u(n(38377)),r=u(n(44504)),s=n(13306),l=n(39611);function u(e){return e&&e.__esModule?e:{default:e}}var d=a.default.inherit({ctor:function(e){this._$element=(0,i.default)(e),this._cancelCallback=(0,r.default)(),this._acceptCallback=(0,r.default)()},getElement:function(){return this._$element},validate:function(e){return!(0,l.isDxMouseWheelEvent)(e)},validatePointers:function(e){return 1===(0,l.hasTouches)(e)},allowInterruptionByMouseWheel:function(){return!0},configure:function(e){(0,s.extend)(this,e)},addCancelCallback:function(e){this._cancelCallback.add(e)},removeCancelCallback:function(){this._cancelCallback.empty()},_cancel:function(e){this._cancelCallback.fire(this,e)},addAcceptCallback:function(e){this._acceptCallback.add(e)},removeAcceptCallback:function(){this._acceptCallback.empty()},_accept:function(e){this._acceptCallback.fire(this,e)},_requestAccept:function(e){this._acceptRequestEvent=e},_forgetAccept:function(){this._accept(this._acceptRequestEvent),this._acceptRequestEvent=null},start:o.noop,move:o.noop,end:o.noop,cancel:o.noop,reset:function(){this._acceptRequestEvent&&this._accept(this._acceptRequestEvent)},_fireEvent:function(e,t,n){var i=(0,s.extend)({type:e,originalEvent:t,target:this._getEmitterTarget(t),delegateTarget:this.getElement().get(0)},n);return(t=(0,l.fireEvent)(i)).cancel&&this._cancel(t),t},_getEmitterTarget:function(e){return(this.delegateSelector?(0,i.default)(e.target).closest(this.delegateSelector):this.getElement()).get(0)},dispose:o.noop});t.default=d,e.exports=t.default,e.exports.default=t.default},82495:function(e,t,n){t.default=void 0;var i=g(n(68374)),o=g(n(24311)),a=g(n(73349)),r=g(n(55994)),s=n(97906),l=g(n(38377)),u=n(13306),d=n(95479),c=g(n(85788)),h=n(39611),p=g(n(93786)),f=n(765);function g(e){return e&&e.__esModule?e:{default:e}}var m=new(l.default.inherit({ctor:function(){this._attachHandlers(),this.reset(),this._proxiedCancelHandler=this._cancelHandler.bind(this),this._proxiedAcceptHandler=this._acceptHandler.bind(this)},_attachHandlers:function(){o.default.add(function(){var e=a.default.getDocument();r.default.subscribeGlobal(e,(0,h.addNamespace)(p.default.down,"dxEventManager"),this._pointerDownHandler.bind(this)),r.default.subscribeGlobal(e,(0,h.addNamespace)(p.default.move,"dxEventManager"),this._pointerMoveHandler.bind(this)),r.default.subscribeGlobal(e,(0,h.addNamespace)([p.default.up,p.default.cancel].join(" "),"dxEventManager"),this._pointerUpHandler.bind(this)),r.default.subscribeGlobal(e,(0,h.addNamespace)(f.name,"dxEventManager"),this._mouseWheelHandler.bind(this))}.bind(this))},_eachEmitter:function(e){for(var t=this._activeEmitters||[],n=0;t.length>n;){var i=t[n];if(!1===e(i))break;t[n]===i&&n++}},_applyToEmitters:function(e,t){this._eachEmitter((function(n){n[e].call(n,t)}))},reset:function(){this._eachEmitter(this._proxiedCancelHandler),this._activeEmitters=[]},resetEmitter:function(e){this._proxiedCancelHandler(e)},_pointerDownHandler:function(e){(0,h.isMouseEvent)(e)&&e.which>1||this._updateEmitters(e)},_updateEmitters:function(e){this._isSetChanged(e)&&(this._cleanEmitters(e),this._fetchEmitters(e))},_isSetChanged:function(e){var t=this._closestEmitter(e),n=this._emittersSet||[],i=t.length!==n.length;return(0,d.each)(t,(function(e,t){return!(i=i||n[e]!==t)})),this._emittersSet=t,i},_closestEmitter:function(e){var t=this,n=[],o=(0,i.default)(e.target);function a(i,o){o&&o.validatePointers(e)&&o.validate(e)&&(o.addCancelCallback(t._proxiedCancelHandler),o.addAcceptCallback(t._proxiedAcceptHandler),n.push(o))}for(;o.length;){var r=(0,s.data)(o.get(0),"dxEmitter")||[];(0,d.each)(r,a),o=o.parent()}return n},_acceptHandler:function(e,t){var n=this;this._eachEmitter((function(i){i!==e&&n._cancelEmitter(i,t)}))},_cancelHandler:function(e,t){this._cancelEmitter(e,t)},_cancelEmitter:function(e,t){var n=this._activeEmitters;t?e.cancel(t):e.reset(),e.removeCancelCallback(),e.removeAcceptCallback();var i=n.indexOf(e);i>-1&&n.splice(i,1)},_cleanEmitters:function(e){this._applyToEmitters("end",e),this.reset(e)},_fetchEmitters:function(e){this._activeEmitters=this._emittersSet.slice(),this._applyToEmitters("start",e)},_pointerMoveHandler:function(e){this._applyToEmitters("move",e)},_pointerUpHandler:function(e){this._updateEmitters(e)},_mouseWheelHandler:function(e){this._allowInterruptionByMouseWheel()&&(e.pointers=[null],this._pointerDownHandler(e),this._adjustWheelEvent(e),this._pointerMoveHandler(e),e.pointers=[],this._pointerUpHandler(e))},_allowInterruptionByMouseWheel:function(){var e=!0;return this._eachEmitter((function(t){return e=t.allowInterruptionByMouseWheel()&&e})),e},_adjustWheelEvent:function(e){var t=null;if(this._eachEmitter((function(n){if(n.gesture){var i=n.getDirection(e);return"horizontal"!==i&&!e.shiftKey||"vertical"!==i&&e.shiftKey?(t=n,!1):void 0}})),t){var n=t.getDirection(e),i="both"===n&&!e.shiftKey||"vertical"===n;e[i?"pageY":"pageX"]+=e.delta}},isActive:function(e){var t=!1;return this._eachEmitter((function(n){t=t||n.getElement().is(e)})),t}})),_=function(e){var t=e.emitter,n=e.events[0],i=e.events;(0,d.each)(i,(function(o,a){(0,c.default)(a,{noBubble:!e.bubble,setup:function(e){var i=(0,s.data)(e,"dxEmitterSubscription")||{},o=(0,s.data)(e,"dxEmitter")||{},r=o[n]||new t(e);i[a]=!0,o[n]=r,(0,s.data)(e,"dxEmitter",o),(0,s.data)(e,"dxEmitterSubscription",i)},add:function(e,t){(0,s.data)(e,"dxEmitter")[n].configure((0,u.extend)({delegateSelector:t.selector},t.data),t.type)},teardown:function(e){var t=(0,s.data)(e,"dxEmitterSubscription"),o=(0,s.data)(e,"dxEmitter"),r=o[n];delete t[a];var l=!0;(0,d.each)(i,(function(e,n){return l=l&&!t[n]})),l&&(m.isActive(e)&&m.resetEmitter(r),r&&r.dispose(),delete o[n])}})}))};t.default=_,e.exports=t.default,e.exports.default=t.default},85788:function(e,t,n){t.default=void 0;var i,o=n(95479),a=(i=n(94553))&&i.__esModule?i:{default:i};var r=function(e,t){var n={};"noBubble"in t&&(n.noBubble=t.noBubble),"bindType"in t&&(n.bindType=t.bindType),"delegateType"in t&&(n.delegateType=t.delegateType),(0,o.each)(["setup","teardown","add","remove","trigger","handle","_default","dispose"],(function(e,i){t[i]&&(n[i]=function(){var e=[].slice.call(arguments);return e.unshift(this),t[i].apply(t,e)})})),a.default.fire(e,n)};r.callbacks=a.default;var s=r;t.default=s,e.exports=t.default,e.exports.default=t.default},94553:function(e,t,n){var i;t.default=void 0;var o=new(((i=n(83358))&&i.__esModule?i:{default:i}).default);t.default=o,e.exports=t.default,e.exports.default=t.default},55994:function(e,t,n){t.default=void 0;var i=p(n(94553)),o=n(13306),a=p(n(73349)),r=n(58201),s=p(n(20476)),l=n(35922),u=p(n(44504)),d=p(n(17381)),c=p(n(2418)),h=p(n(39618));function p(e){return e&&e.__esModule?e:{default:e}}function f(e){return(f="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function g(){return(g=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(e[i]=n[i])}return e}).apply(this,arguments)}var m=(0,r.getWindow)(),_={mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},v={focusin:"focus",focusout:"blur"},y=["blur","focus","load"],b=["touchmove","wheel","mousewheel","touchstart"];function x(e,t){return!(0,l.isWindow)(e)&&"#document"!==e.nodeName&&a.default.elementMatches(e,t)}var w,C,S,k=new WeakMap,D=0,I=(C={},i.default.add((function(e,t){C[e]=t})),{getField:function(e,t){return C[e]&&C[e][t]},callMethod:function(e,t,n,i){return C[e]&&C[e][t]&&C[e][t].apply(n,i)}}),T=(0,s.default)({on:O(M(L((function(e,t,n,i,o){P(e,t).addHandler(o,n,i)})))),one:O(M((function(e,t,n,i,o){T.on(e,t,n,i,(function i(){T.off(e,t,n,i),o.apply(this,arguments)}))}))),off:O((S=L((function(e,t,n,i){P(e,t).removeHandler(i,n)})),function(e,t,n,i){"function"==typeof n&&(i=n,n=void 0),S(e,t,n,i)})),trigger:O(B((function(e,t,n){var i=t.type,a=P(e,t.type);if(I.callMethod(i,"trigger",e,[t,n]),a.callHandlers(t,n),!(I.getField(i,"noBubble")||t.isPropagationStopped()||-1!==y.indexOf(i))){var r=[];!function e(t){var n=t.parentNode;n&&(r.push(n),e(n))}(e),r.push(m);for(var s=0;r[s]&&!t.isPropagationStopped();){P(r[s],t.type).callHandlers((0,o.extend)(t,{currentTarget:r[s]}),n),s++}}(e.nodeType||(0,l.isWindow)(e))&&(I.callMethod(i,"_default",e,[t,n]),function(e,t){var n=v[e]||e;if(function(e,t){return"click"===e&&"a"===t.localName}(e,t))return;(0,l.isFunction)(t[n])&&(w=e,t[n](),w=void 0)}(i,e))}))),triggerHandler:O(B((function(e,t,n){P(e,t.type).callHandlers(t,n)})))});function E(e,t){var n=e[0];if(n)if(a.default.isNode(n)||(0,l.isWindow)(n))t.apply(T,e);else{if((0,l.isString)(n)||!("length"in n))throw d.default.Error("E0025");var i=Array.prototype.slice.call(e,0);Array.prototype.forEach.call(n,(function(e){i[0]=e,E(i,t)}))}}function O(e){return function(){E(arguments,e)}}var A=(0,h.default)((function(){var e=!1;try{var t=Object.defineProperty({},"passive",{get:function(){return e=!0,!0}});m.addEventListener("test",null,t)}catch(e){}return e}));function P(e,t){var n=k.get(e),i=(t=t||"").split("."),o=i.slice(1),r=!!i[0];t=i[0]||"dxEmptyEventType",n||(n={},k.set(e,n)),n[t]||(n[t]={handleObjects:[],nativeHandler:null});var s=n[t];return{addHandler:function(n,i,u){var d=function(i,o){var a,r,s=[i],d=i.currentTarget,c=i.relatedTarget;t in _&&(a=c&&d&&(c===d||function e(t,n){return(0,l.isWindow)(t)?e(t.document,n):t.contains?t.contains(n):!!(n.compareDocumentPosition(t)&n.DOCUMENT_POSITION_CONTAINS)}(d,c))),void 0!==o&&s.push(o),I.callMethod(t,"handle",e,[i,u]),a||(r=n.apply(d,s)),!1===r&&(i.preventDefault(),i.stopPropagation())},c={handler:n,wrappedHandler:function(t,n){if(!w||t.type!==w)if(t.data=u,t.delegateTarget=e,i)for(var o=t.target;o&&o!==e;)x(o,i)&&(t.currentTarget=o,d(t,n)),o=o.parentNode;else t.currentTarget=t.delegateTarget||t.target,d(t,n)},selector:i,type:t,data:u,namespace:o.join("."),namespaces:o,guid:++D};s.handleObjects.push(c);var h,p,f=1===s.handleObjects.length&&r;f&&(f=!I.callMethod(t,"setup",e,[u,o,n])),f&&(s.nativeHandler=(p=t,function(e,t){var n=P(this,p);e=T.Event(e),n.callHandlers(e,t)}),A()&&b.indexOf(t)>-1&&(h={passive:!1}),s.removeListener=a.default.listen(e,_[t]||t,s.nativeHandler,h)),I.callMethod(t,"add",e,[c])},removeHandler:function(i,a){var s=function(t){var r,s=n[t];s.handleObjects.length?(s.handleObjects=s.handleObjects.filter((function(n){var s=o.length&&!R(n.namespaces,o)||i&&n.handler!==i||a&&n.selector!==a;return s||(r=n.handler,I.callMethod(t,"remove",e,[n])),s})),!s.handleObjects.length&&"dxEmptyEventType"!==t&&(I.callMethod(t,"teardown",e,[o,r]),s.nativeHandler&&s.removeListener(),delete n[t])):delete n[t]};if(r)s(t);else for(var l in n)s(l);0===Object.keys(n).length&&k.delete(e)},callHandlers:function(e,t){var i=!1,a=function(n){i||o.length&&!R(n.namespaces,o)||(n.wrappedHandler(e,t),i=e.isImmediatePropagationStopped())};s.handleObjects.forEach(a),o.length&&n.dxEmptyEventType&&n.dxEmptyEventType.handleObjects.forEach(a)}}}function R(e,t){for(var n=0;n<t.length;n++)if(e.indexOf(t[n])<0)return!1;return!0}function M(e){return function(t,n,i,o,a){a||(a=o,o=void 0),"string"!=typeof i&&(o=i,i=void 0),a||"string"!=typeof n||(a=o||i,i=void 0,o=void 0),e(t,n,i,o,a)}}function B(e){return function(t,n,i){"string"==typeof n&&(n={type:n}),n.target||(n.target=t),n.currentTarget=t,n.delegateTarget||(n.delegateTarget=t),!n.type&&n.originalEvent&&(n.type=n.originalEvent.type),e(t,n instanceof T.Event?n:T.Event(n),i)}}function L(e){var t=function(t,n){if(n&&n.indexOf(" ")>-1){var i=Array.prototype.slice.call(arguments,0);n.split(" ").forEach((function(t){i[1]=t,e.apply(this,i)}))}else e.apply(this,arguments)};return function(e,n){if("object"===f(n)){var i=Array.prototype.slice.call(arguments,0);for(var o in n)i[1]=o,i[i.length-1]=n[o],t.apply(this,i)}else t.apply(this,arguments)}}function V(e){if(function(e){return null==e.which&&0===e.type.indexOf("key")}(e))return null!=e.charCode?e.charCode:e.keyCode;if(function(e){return!e.which&&void 0!==e.button&&/^(?:mouse|pointer|contextmenu|drag|drop)|click/.test(e.type)}(e)){return{1:1,2:3,3:1,4:2}[e.button]}return e.which}function F(e){e&&(T.Event=e,T.Event.prototype=e.prototype)}function H(e,t,n){Object.defineProperty(n||T.Event.prototype,e,{enumerable:!0,configurable:!0,get:function(){return this.originalEvent&&t(this.originalEvent)},set:function(t){Object.defineProperty(this,e,{enumerable:!0,configurable:!0,writable:!0,value:t})}})}F(function(e){return T.Event=function(t,n){if(!(this instanceof T.Event))return new T.Event(t,n);t||(t={}),"string"==typeof t&&(t={type:t}),n||(n={}),e.call(this,t,n)},g(T.Event.prototype,{_propagationStopped:!1,_immediatePropagationStopped:!1,_defaultPrevented:!1,isPropagationStopped:function(){return!!(this._propagationStopped||this.originalEvent&&this.originalEvent.propagationStopped)},stopPropagation:function(){this._propagationStopped=!0,this.originalEvent&&this.originalEvent.stopPropagation()},isImmediatePropagationStopped:function(){return this._immediatePropagationStopped},stopImmediatePropagation:function(){this.stopPropagation(),this._immediatePropagationStopped=!0,this.originalEvent&&this.originalEvent.stopImmediatePropagation()},isDefaultPrevented:function(){return!!(this._defaultPrevented||this.originalEvent&&this.originalEvent.defaultPrevented)},preventDefault:function(){this._defaultPrevented=!0,this.originalEvent&&this.originalEvent.preventDefault()}}),T.Event}((function(e,t){var n;e instanceof T.Event||(0,r.hasWindow)()&&e instanceof m.Event||(null===(n=e.view)||void 0===n?void 0:n.Event)&&e instanceof e.view.Event?(this.originalEvent=e,this.type=e.type,this.currentTarget=void 0,Object.prototype.hasOwnProperty.call(e,"isTrusted")&&(this.isTrusted=e.isTrusted),this.timeStamp=e.timeStamp||Date.now()):g(this,e),H("which",V,this),0===e.type.indexOf("touch")&&(delete t.pageX,delete t.pageY),g(this,t),this.guid=++D}))),["target","relatedTarget","delegateTarget","altKey","bubbles","cancelable","changedTouches","ctrlKey","detail","eventPhase","metaKey","shiftKey","view","char","code","charCode","key","keyCode","button","buttons","offsetX","offsetY","pointerId","pointerType","targetTouches","toElement","touches"].forEach((function(e){return H(e,(function(t){return t[e]}))})),(0,c.default)(H);var N=(0,u.default)(),z=(0,u.default)();T.set=function(e){N.fire(),T.inject(e),F(e.Event),z.fire()},T.subscribeGlobal=function(){E(arguments,M((function(){var e=arguments;T.on.apply(this,e),N.add((function(){var t=Array.prototype.slice.call(e,0);t.splice(3,1),T.off.apply(this,t)})),z.add((function(){T.on.apply(this,e)}))})))},T.forcePassiveFalseEventNames=b,T.passiveEventHandlersSupported=A;var W=T;t.default=W,e.exports=t.default,e.exports.default=t.default},2418:function(e,t){t.default=function(e){n.forEach((function(t){e(t,(function(e){return function(e,t){if(t[e]&&!t.touches||!t.touches)return t[e];var n=t.touches.length?t.touches:t.changedTouches;if(!n.length)return;return n[0][e]}(t,e)}))}),this)};var n=["pageX","pageY","screenX","screenY","clientX","clientY"];e.exports=t.default,e.exports.default=t.default},51661:function(e,t,n){t.default=void 0;var i=s(n(68374)),o=s(n(55994)),a=s(n(38377)),r=n(39611);function s(e){return e&&e.__esModule?e:{default:e}}var l=function(e){return{keyName:(0,r.normalizeKeyName)(e),key:e.key,code:e.code,ctrl:e.ctrlKey,location:e.location,metaKey:e.metaKey,shift:e.shiftKey,alt:e.altKey,which:e.which,originalEvent:e}},u=a.default.inherit({_keydown:(0,r.addNamespace)("keydown","KeyboardProcessor"),_compositionStart:(0,r.addNamespace)("compositionstart","KeyboardProcessor"),_compositionEnd:(0,r.addNamespace)("compositionend","KeyboardProcessor"),ctor:function(e){var t=this;(e=e||{}).element&&(this._element=(0,i.default)(e.element)),e.focusTarget&&(this._focusTarget=e.focusTarget),this._handler=e.handler,this._element&&(this._processFunction=function(e){var n=(0,i.default)(t._focusTarget).toArray(),o=t._focusTarget&&t._focusTarget!==e.target&&!n.includes(e.target),a=t._isComposingJustFinished&&229===e.which||t._isComposing||o;t._isComposingJustFinished=!1,a||t.process(e)},this._toggleProcessingWithContext=this.toggleProcessing.bind(this),o.default.on(this._element,this._keydown,this._processFunction),o.default.on(this._element,this._compositionStart,this._toggleProcessingWithContext),o.default.on(this._element,this._compositionEnd,this._toggleProcessingWithContext))},dispose:function(){this._element&&(o.default.off(this._element,this._keydown,this._processFunction),o.default.off(this._element,this._compositionStart,this._toggleProcessingWithContext),o.default.off(this._element,this._compositionEnd,this._toggleProcessingWithContext)),this._element=void 0,this._handler=void 0},process:function(e){this._handler(l(e))},toggleProcessing:function(e){var t=e.type;this._isComposing="compositionstart"===t,this._isComposingJustFinished=!this._isComposing}});u.createKeyDownOptions=l;var d=u;t.default=d,e.exports=t.default,e.exports.default=t.default},765:function(e,t,n){t.name=void 0;var i=s(n(68374)),o=s(n(55994)),a=s(n(85788)),r=n(39611);function s(e){return e&&e.__esModule?e:{default:e}}t.name="dxmousewheel";var l={setup:function(e){var t=(0,i.default)(e);o.default.on(t,(0,r.addNamespace)("wheel","dxWheel"),l._wheelHandler.bind(l))},teardown:function(e){o.default.off(e,".".concat("dxWheel"))},_wheelHandler:function(e){var t=e.originalEvent,n=t.deltaMode,i=t.deltaY,o=t.deltaX,a=t.deltaZ;(0,r.fireEvent)({type:"dxmousewheel",originalEvent:e,delta:this._normalizeDelta(i,n),deltaX:o,deltaY:i,deltaZ:a,deltaMode:n,pointerType:"mouse"}),e.stopPropagation()},_normalizeDelta:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return 0===t?-e:-30*e}};(0,a.default)("dxmousewheel",l)},85272:function(e,t,n){t.name=void 0;var i=d(n(55994)),o=n(3532),a=d(n(73349)),r=d(n(38377)),s=d(n(85788)),l=n(95429),u=n(39611);function d(e){return e&&e.__esModule?e:{default:e}}t.name="dxdblclick";var c=(0,u.addNamespace)(l.name,"dxDblClick"),h=r.default.inherit({ctor:function(){this._handlerCount=0,this._forgetLastClick()},_forgetLastClick:function(){this._firstClickTarget=null,this._lastClickTimeStamp=-300},add:function(){this._handlerCount<=0&&i.default.on(a.default.getDocument(),c,this._clickHandler.bind(this)),this._handlerCount++},_clickHandler:function(e){var t=e.timeStamp||Date.now(),n=t-this._lastClickTimeStamp;!(n<0)&&n<300?((0,u.fireEvent)({type:"dxdblclick",target:(0,o.closestCommonParent)(this._firstClickTarget,e.target),originalEvent:e}),this._forgetLastClick()):(this._firstClickTarget=e.target,this._lastClickTimeStamp=t)},remove:function(){this._handlerCount--,this._handlerCount<=0&&(this._forgetLastClick(),i.default.off(a.default.getDocument(),c))}});(0,s.default)("dxdblclick",new h)},23174:function(e,t,n){function i(e){return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}t.start=t.move=t.leave=t.enter=t.end=t.drop=void 0;var o=f(n(68374)),a=n(97906),r=n(89386),s=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!==i(e)&&"function"!=typeof e)return{default:e};var n=p(t);if(n&&n.has(e))return n.get(e);var o={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var r in e)if("default"!==r&&Object.prototype.hasOwnProperty.call(e,r)){var s=a?Object.getOwnPropertyDescriptor(e,r):null;s&&(s.get||s.set)?Object.defineProperty(o,r,s):o[r]=e[r]}o.default=e,n&&n.set(e,o);return o}(n(95479)),l=n(3532),u=f(n(85788)),d=n(39611),c=f(n(98621)),h=f(n(82495));function p(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,n=new WeakMap;return(p=function(e){return e?n:t})(e)}function f(e){return e&&e.__esModule?e:{default:e}}t.start="dxdragstart";t.move="dxdrag";t.end="dxdragend";var g="dxdragenter";t.enter=g;var m="dxdragleave";t.leave=m;var _="dxdrop";t.drop=_;var v=[],y=[],b=[],x={setup:function(e,t){v.includes(e)||(v.push(e),y.push([]),b.push(t||{}))},add:function(e,t){var n=v.indexOf(e);this.updateEventsCounter(e,t.type,1);var i=t.selector;y[n].includes(i)||y[n].push(i)},updateEventsCounter:function(e,t,n){if([g,m,_].indexOf(t)>-1){var i=(0,a.data)(e,"dxDragEventsCount")||0;(0,a.data)(e,"dxDragEventsCount",Math.max(0,i+n))}},remove:function(e,t){this.updateEventsCounter(e,t.type,-1)},teardown:function(e){if(!(0,a.data)(e,"dxDragEventsCount")){var t=v.indexOf(e);v.splice(t,1),y.splice(t,1),b.splice(t,1),(0,a.removeData)(e,"dxDragEventsCount")}}};(0,u.default)(g,x),(0,u.default)(m,x),(0,u.default)(_,x);var w=c.default.inherit({ctor:function(e){this.callBase(e),this.direction="both"},_init:function(e){this._initEvent=e},_start:function(e){e=this._fireEvent("dxdragstart",this._initEvent),this._maxLeftOffset=e.maxLeftOffset,this._maxRightOffset=e.maxRightOffset,this._maxTopOffset=e.maxTopOffset,this._maxBottomOffset=e.maxBottomOffset;var t=(0,r.wrapToArray)(e.targetElements||(null===e.targetElements?[]:v));this._dropTargets=s.map(t,(function(e){return(0,o.default)(e).get(0)}))},_move:function(e){var t=(0,d.eventData)(e),n=this._calculateOffset(t);e=this._fireEvent("dxdrag",e,{offset:n}),this._processDropTargets(e),e._cancelPreventDefault||e.preventDefault()},_calculateOffset:function(e){return{x:this._calculateXOffset(e),y:this._calculateYOffset(e)}},_calculateXOffset:function(e){if("vertical"!==this.direction){var t=e.x-this._startEventData.x;return this._fitOffset(t,this._maxLeftOffset,this._maxRightOffset)}return 0},_calculateYOffset:function(e){if("horizontal"!==this.direction){var t=e.y-this._startEventData.y;return this._fitOffset(t,this._maxTopOffset,this._maxBottomOffset)}return 0},_fitOffset:function(e,t,n){return null!=t&&(e=Math.max(e,-t)),null!=n&&(e=Math.min(e,n)),e},_processDropTargets:function(e){var t=this._findDropTarget(e);t===this._currentDropTarget||(this._fireDropTargetEvent(e,m),this._currentDropTarget=t,this._fireDropTargetEvent(e,g))},_fireDropTargetEvent:function(e,t){if(this._currentDropTarget){var n={type:t,originalEvent:e,draggingElement:this._$element.get(0),target:this._currentDropTarget};(0,d.fireEvent)(n)}},_findDropTarget:function(e){var t,n=this;return s.each(v,(function(i,a){if(n._checkDropTargetActive(a)){var r,l,u,d,c=(0,o.default)(a);s.each((r=c,l=v.indexOf(r.get(0)),u=y[l].filter((function(e){return e})),d=r.find(u.join(", ")),y[l].includes(void 0)&&(d=d.add(r)),d),(function(i,a){var r=(0,o.default)(a);n._checkDropTarget(function(e){var t=v.indexOf(e.get(0));return b[t]}(c),r,(0,o.default)(t),e)&&(t=a)}))}})),t},_checkDropTargetActive:function(e){var t=!1;return s.each(this._dropTargets,(function(n,i){return!(t=t||i===e||(0,l.contains)(i,e))})),t},_checkDropTarget:function(e,t,n,i){if(t.get(0)===(0,o.default)(i.target).get(0))return!1;var a,r,s=(r=t,(a=e).itemPositionFunc?a.itemPositionFunc(r):r.offset());if(i.pageX<s.left)return!1;if(i.pageY<s.top)return!1;var l=function(e,t){return e.itemSizeFunc?e.itemSizeFunc(t):{width:t.get(0).getBoundingClientRect().width,height:t.get(0).getBoundingClientRect().height}}(e,t);return!(i.pageX>s.left+l.width)&&(!(i.pageY>s.top+l.height)&&((!n.length||!n.closest(t).length)&&(!(e.checkDropTarget&&!e.checkDropTarget(t,i))&&t)))},_end:function(e){var t=(0,d.eventData)(e);this._fireEvent("dxdragend",e,{offset:this._calculateOffset(t)}),this._fireDropTargetEvent(e,_),delete this._currentDropTarget}});(0,h.default)({emitter:w,events:["dxdragstart","dxdrag","dxdragend"]})},98621:function(e,t,n){t.default=void 0;var i=g(n(68374)),o=g(n(55994)),a=g(n(20530)),r=n(80968),s=g(n(39618)),l=n(3532),u=g(n(24311)),d=n(60810),c=n(20576),h=n(35922),p=n(39611),f=g(n(31391));function g(e){return e&&e.__esModule?e:{default:e}}var m=u.default.add,_=Math.abs,v=10,y=(0,s.default)((function(){var e="desktop"===a.default.real().deviceType;if(!(0,r.styleProp)("pointer-events")||!e)return c.noop;var t=(0,i.default)("<div>").addClass("dx-gesture-cover").css("pointerEvents","none");return o.default.subscribeGlobal(t,"dxmousewheel",(function(e){e.preventDefault()})),m((function(){t.appendTo("body")})),function(e,n){t.css("pointerEvents",e?"all":"none"),e&&t.css("cursor",n)}})),b=f.default.inherit({gesture:!0,configure:function(e){this.getElement().css("msTouchAction",e.immediate?"pinch-zoom":""),this.callBase(e)},allowInterruptionByMouseWheel:function(){return 2!==this._stage},getDirection:function(){return this.direction},_cancel:function(){this.callBase.apply(this,arguments),this._toggleGestureCover(!1),this._stage=0},start:function(e){e._needSkipEvent||(0,p.needSkipEvent)(e)?this._cancel(e):(this._startEvent=(0,p.createEvent)(e),this._startEventData=(0,p.eventData)(e),this._stage=1,this._init(e),this._setupImmediateTimer())},_setupImmediateTimer:function(){clearTimeout(this._immediateTimer),this._immediateAccepted=!1,this.immediate&&(this._immediateTimer=setTimeout(function(){this._immediateAccepted=!0}.bind(this),180))},move:function(e){if(1===this._stage&&this._directionConfirmed(e)){if(this._stage=2,this._resetActiveElement(),this._toggleGestureCover(!0),this._clearSelection(e),this._adjustStartEvent(e),this._start(this._startEvent),0===this._stage)return;this._requestAccept(e),this._move(e),this._forgetAccept()}else 2===this._stage&&(this._clearSelection(e),this._move(e))},_directionConfirmed:function(e){var t=this._getTouchBoundary(e),n=(0,p.eventDelta)(this._startEventData,(0,p.eventData)(e)),i=_(n.x),o=_(n.y),a=this._validateMove(t,i,o),r=this._validateMove(t,o,i),s=this.getDirection(e);return"both"===s&&(a||r)||"horizontal"===s&&a||"vertical"===s&&r||this._immediateAccepted},_validateMove:function(e,t,n){return t&&t>=e&&(!this.immediate||t>=n)},_getTouchBoundary:function(e){return this.immediate||(0,p.isDxMouseWheelEvent)(e)?0:v},_adjustStartEvent:function(e){var t=this._getTouchBoundary(e),n=(0,p.eventDelta)(this._startEventData,(0,p.eventData)(e));this._startEvent.pageX+=(0,d.sign)(n.x)*t,this._startEvent.pageY+=(0,d.sign)(n.y)*t},_resetActiveElement:function(){"ios"===a.default.real().platform&&this.getElement().find(":focus").length&&(0,l.resetActiveElement)()},_toggleGestureCover:function(e){this._toggleGestureCoverImpl(e)},_toggleGestureCoverImpl:function(e){2===this._stage&&function(e,t){y()(e,t)}(e,this.getElement().css("cursor"))},_clearSelection:function(e){(0,p.isDxMouseWheelEvent)(e)||(0,p.isTouchEvent)(e)||(0,l.clearSelection)()},end:function(e){this._toggleGestureCover(!1),2===this._stage?this._end(e):1===this._stage&&this._stop(e),this._stage=0},dispose:function(){clearTimeout(this._immediateTimer),this.callBase.apply(this,arguments),this._toggleGestureCover(!1)},_init:c.noop,_start:c.noop,_move:c.noop,_stop:c.noop,_end:c.noop});b.initialTouchBoundary=v,b.touchBoundary=function(e){if(!(0,h.isDefined)(e))return v;v=e};var x=b;t.default=x,e.exports=t.default,e.exports.default=t.default},37334:function(e,t,n){t.default=void 0;var i=d(n(55994)),o=d(n(38377)),a=n(39611),r=d(n(98621)),s=d(n(82495)),l=n(90057),u=d(n(20530));function d(e){return e&&e.__esModule?e:{default:e}}var c,h,p,f=o.default.abstract,g=u.default.real(),m=o.default.inherit((c=(0,a.addNamespace)("scroll","dxScrollEmitter"),{ctor:function(e){var t=this;this._element=e,this._locked=!1,this._proxiedScroll=function(e){t._disposed||t._scroll(e)},i.default.on(this._element,c,this._proxiedScroll)},_scroll:f,check:function(e,t){this._locked&&t()},dispose:function(){this._disposed=!0,i.default.off(this._element,c,this._proxiedScroll)}})),_=m.inherit({ctor:function(e,t){this.callBase(e),this._timeout=t},_scroll:function(){this._prepare(),this._forget()},_prepare:function(){this._timer&&this._clearTimer(),this._locked=!0},_clearTimer:function(){clearTimeout(this._timer),this._locked=!1,this._timer=null},_forget:function(){var e=this;this._timer=setTimeout((function(){e._clearTimer()}),this._timeout)},dispose:function(){this.callBase(),this._clearTimer()}}),v=_.inherit({ctor:function(e){this.callBase(e,400),this._lastWheelDirection=null},check:function(e,t){this._checkDirectionChanged(e),this.callBase(e,t)},_checkDirectionChanged:function(e){if((0,a.isDxMouseWheelEvent)(e)){var t=e.shiftKey||!1,n=null!==this._lastWheelDirection&&t!==this._lastWheelDirection;this._lastWheelDirection=t,this._locked=this._locked&&!n}else this._lastWheelDirection=null}}),y=_.inherit({ctor:function(e){this.callBase(e,400)}});h=g.ios,p=g.android,(h||p)&&(y=m.inherit({_scroll:function(){this._locked=!0;var e=this;(0,l.cancelAnimationFrame)(this._scrollFrame),this._scrollFrame=(0,l.requestAnimationFrame)((function(){e._locked=!1}))},check:function(e,t){(0,l.cancelAnimationFrame)(this._scrollFrame),(0,l.cancelAnimationFrame)(this._checkFrame);var n=this,i=this.callBase;this._checkFrame=(0,l.requestAnimationFrame)((function(){i.call(n,e,t),n._locked=!1}))},dispose:function(){this.callBase(),(0,l.cancelAnimationFrame)(this._scrollFrame),(0,l.cancelAnimationFrame)(this._checkFrame)}}));var b,x=r.default.inherit((b=Math.round(1e3/60),{ctor:function(e){this.callBase.apply(this,arguments),this.direction="both",this._pointerLocker=new y(e),this._wheelLocker=new v(e)},validate:function(){return!0},configure:function(e){e.scrollTarget&&(this._pointerLocker.dispose(),this._wheelLocker.dispose(),this._pointerLocker=new y(e.scrollTarget),this._wheelLocker=new v(e.scrollTarget)),this.callBase(e)},_init:function(e){this._wheelLocker.check(e,function(){(0,a.isDxMouseWheelEvent)(e)&&this._accept(e)}.bind(this)),this._pointerLocker.check(e,function(){var t=this.isNative&&(0,a.isMouseEvent)(e);(0,a.isDxMouseWheelEvent)(e)||t||this._accept(e)}.bind(this)),this._fireEvent("dxscrollinit",e),this._prevEventData=(0,a.eventData)(e)},move:function(e){this.callBase.apply(this,arguments),e.isScrollingEvent=this.isNative||e.isScrollingEvent},_start:function(e){this._savedEventData=(0,a.eventData)(e),this._fireEvent("dxscrollstart",e),this._prevEventData=(0,a.eventData)(e)},_move:function(e){var t=(0,a.eventData)(e);this._fireEvent("dxscroll",e,{delta:(0,a.eventDelta)(this._prevEventData,t)}),(0,a.eventDelta)(this._savedEventData,t).time>200&&(this._savedEventData=this._prevEventData),this._prevEventData=(0,a.eventData)(e)},_end:function(e){var t=(0,a.eventDelta)(this._prevEventData,(0,a.eventData)(e)),n={x:0,y:0};if(!(0,a.isDxMouseWheelEvent)(e)&&t.time<100){var i=(0,a.eventDelta)(this._savedEventData,this._prevEventData),o=b/i.time;n={x:i.x*o,y:i.y*o}}this._fireEvent("dxscrollend",e,{velocity:n})},_stop:function(e){this._fireEvent("dxscrollstop",e)},cancel:function(e){this.callBase.apply(this,arguments),this._fireEvent("dxscrollcancel",e)},dispose:function(){this.callBase.apply(this,arguments),this._pointerLocker.dispose(),this._wheelLocker.dispose()},_clearSelection:function(){if(!this.isNative)return this.callBase.apply(this,arguments)},_toggleGestureCover:function(){if(!this.isNative)return this.callBase.apply(this,arguments)}}));(0,s.default)({emitter:x,events:["dxscrollinit","dxscrollstart","dxscroll","dxscrollend","dxscrollstop","dxscrollcancel"]});var w={init:"dxscrollinit",start:"dxscrollstart",move:"dxscroll",end:"dxscrollend",stop:"dxscrollstop",cancel:"dxscrollcancel",scroll:"scroll"};t.default=w,e.exports=t.default,e.exports.default=t.default},66894:function(e,t,n){t.default=void 0;var i=n(34309),o=d(n(55994)),a=d(n(13046)),r=n(95479),s=n(39611),l=n(13306),u=n(9321);function d(e){return e&&e.__esModule?e:{default:e}}var c={onStart:i.start,onUpdated:i.swipe,onEnd:i.end,onCancel:"dxswipecancel"},h=a.default.inherit({_getDefaultOptions:function(){return(0,l.extend)(this.callBase(),{elastic:!0,immediate:!1,direction:"horizontal",itemSizeFunc:null,onStart:null,onUpdated:null,onEnd:null,onCancel:null})},_render:function(){this.callBase(),this.$element().addClass("dx-swipeable"),this._attachEventHandlers()},_attachEventHandlers:function(){if(this._detachEventHandlers(),!this.option("disabled")){var e=this.NAME;this._createEventData(),(0,r.each)(c,function(t,n){var i=this._createActionByOption(t,{context:this});n=(0,s.addNamespace)(n,e),o.default.on(this.$element(),n,this._eventData,(function(e){return i({event:e})}))}.bind(this))}},_createEventData:function(){this._eventData={elastic:this.option("elastic"),itemSizeFunc:this.option("itemSizeFunc"),direction:this.option("direction"),immediate:this.option("immediate")}},_detachEventHandlers:function(){o.default.off(this.$element(),".dxSwipeable")},_optionChanged:function(e){switch(e.name){case"disabled":case"onStart":case"onUpdated":case"onEnd":case"onCancel":case"elastic":case"immediate":case"itemSizeFunc":case"direction":this._detachEventHandlers(),this._attachEventHandlers();break;case"rtlEnabled":break;default:this.callBase(e)}},_useTemplates:function(){return!1}});(0,u.name)(h,"dxSwipeable");var p=h;t.default=p,e.exports=t.default,e.exports.default=t.default},11699:function(e,t,n){t.default=void 0;var i=n(39611),o=r(n(31391)),a=r(n(82495));function r(e){return e&&e.__esModule?e:{default:e}}var s=Math.abs,l=o.default.inherit({start:function(e){this._startEventData=(0,i.eventData)(e),this._startTimer(e)},_startTimer:function(e){var t="timeout"in this?this.timeout:750;this._holdTimer=setTimeout(function(){this._requestAccept(e),this._fireEvent("dxhold",e,{target:e.target}),this._forgetAccept()}.bind(this),t)},move:function(e){this._touchWasMoved(e)&&this._cancel(e)},_touchWasMoved:function(e){var t=(0,i.eventDelta)(this._startEventData,(0,i.eventData)(e));return s(t.x)>5||s(t.y)>5},end:function(){this._stopTimer()},_stopTimer:function(){clearTimeout(this._holdTimer)},cancel:function(){this._stopTimer()},dispose:function(){this._stopTimer()}});(0,a.default)({emitter:l,bubble:!0,events:["dxhold"]});var u={name:"dxhold"};t.default=u,e.exports=t.default,e.exports.default=t.default},24028:function(e,t,n){t.start=t.end=void 0;var i=d(n(55994)),o=n(97906),a=d(n(38377)),r=d(n(20530)),s=d(n(85788)),l=n(39611),u=d(n(93786));function d(e){return e&&e.__esModule?e:{default:e}}t.start="dxhoverstart";var c=(0,l.addNamespace)(u.default.enter,"dxHoverStart");t.end="dxhoverend";var h=(0,l.addNamespace)(u.default.leave,"dxHoverEnd"),p=a.default.inherit({noBubble:!0,ctor:function(){this._handlerArrayKeyPath=this._eventNamespace+"_HandlerStore"},setup:function(e){(0,o.data)(e,this._handlerArrayKeyPath,{})},add:function(e,t){var n=this,a=function(e){n._handler(e)};i.default.on(e,this._originalEventName,t.selector,a),(0,o.data)(e,this._handlerArrayKeyPath)[t.guid]=a},_handler:function(e){(0,l.isTouchEvent)(e)||r.default.isSimulator()||(0,l.fireEvent)({type:this._eventName,originalEvent:e,delegateTarget:e.delegateTarget})},remove:function(e,t){var n=(0,o.data)(e,this._handlerArrayKeyPath)[t.guid];i.default.off(e,this._originalEventName,t.selector,n)},teardown:function(e){(0,o.removeData)(e,this._handlerArrayKeyPath)}}),f=p.inherit({ctor:function(){this._eventNamespace="dxHoverStart",this._eventName="dxhoverstart",this._originalEventName=c,this.callBase()},_handler:function(e){(e.pointers||[]).length||this.callBase(e)}}),g=p.inherit({ctor:function(){this._eventNamespace="dxHoverEnd",this._eventName="dxhoverend",this._originalEventName=h,this.callBase()}});(0,s.default)("dxhoverstart",new f),(0,s.default)("dxhoverend",new g)},66365:function(e,t,n){t.triggerHandler=t.trigger=t.one=t.on=t.off=t.Event=void 0;var i,o=(i=n(55994))&&i.__esModule?i:{default:i};var a=o.default.on;t.on=a;var r=o.default.one;t.one=r;var s=o.default.off;t.off=s;var l=o.default.trigger;t.trigger=l;var u=o.default.triggerHandler;t.triggerHandler=u;var d=o.default.Event;t.Event=d},93786:function(e,t,n){function i(e){return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}t.default=void 0;var o=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!==i(e)&&"function"!=typeof e)return{default:e};var n=h(t);if(n&&n.has(e))return n.get(e);var o={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var r in e)if("default"!==r&&Object.prototype.hasOwnProperty.call(e,r)){var s=a?Object.getOwnPropertyDescriptor(e,r):null;s&&(s.get||s.set)?Object.defineProperty(o,r,s):o[r]=e[r]}o.default=e,n&&n.set(e,o);return o}(n(60137)),a=n(95479),r=c(n(20530)),s=c(n(85788)),l=c(n(69120)),u=c(n(66509)),d=c(n(87720));function c(e){return e&&e.__esModule?e:{default:e}}function h(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,n=new WeakMap;return(h=function(e){return e?n:t})(e)}var p=function(e,t){var n=t.tablet,i=t.phone;return!e.touch||n||i?e.touch?l.default:u.default:d.default}(o,r.default.real());(0,a.each)(p.map,(function(e,t){(0,s.default)(e,new p(e,t))}));var f={down:"dxpointerdown",up:"dxpointerup",move:"dxpointermove",cancel:"dxpointercancel",enter:"dxpointerenter",leave:"dxpointerleave",over:"dxpointerover",out:"dxpointerout"};t.default=f,e.exports=t.default,e.exports.default=t.default},88136:function(e,t,n){t.default=void 0;var i=l(n(55994)),o=l(n(47810)),a=l(n(73349)),r=l(n(38377)),s=n(39611);function l(e){return e&&e.__esModule?e:{default:e}}var u=r.default.inherit({ctor:function(e,t){this._eventName=e,this._originalEvents=(0,s.addNamespace)(t,"dxPointerEvents"),this._handlerCount=0,this.noBubble=this._isNoBubble()},_isNoBubble:function(){var e=this._eventName;return"dxpointerenter"===e||"dxpointerleave"===e},_handler:function(e){var t=this._getDelegateTarget(e);return this._fireEvent({type:this._eventName,pointerType:e.pointerType||(0,s.eventSource)(e),originalEvent:e,delegateTarget:t,timeStamp:o.default.mozilla?(new Date).getTime():e.timeStamp})},_getDelegateTarget:function(e){var t;return this.noBubble&&(t=e.delegateTarget),t},_fireEvent:function(e){return(0,s.fireEvent)(e)},_setSelector:function(e){this._selector=this.noBubble&&e?e.selector:null},_getSelector:function(){return this._selector},setup:function(){return!0},add:function(e,t){if(this._handlerCount<=0||this.noBubble){e=this.noBubble?e:a.default.getDocument(),this._setSelector(t);var n=this;i.default.on(e,this._originalEvents,this._getSelector(),(function(e){n._handler(e)}))}this.noBubble||this._handlerCount++},remove:function(e){this._setSelector(e),this.noBubble||this._handlerCount--},teardown:function(e){this._handlerCount&&!this.noBubble||(e=this.noBubble?e:a.default.getDocument(),".dxPointerEvents"!==this._originalEvents&&i.default.off(e,this._originalEvents,this._getSelector()))},dispose:function(e){e=this.noBubble?e:a.default.getDocument(),i.default.off(e,this._originalEvents)}});t.default=u,e.exports=t.default,e.exports.default=t.default},66509:function(e,t,n){t.default=void 0;var i=n(13306),o=r(n(88136)),a=r(n(25544));function r(e){return e&&e.__esModule?e:{default:e}}var s,l={dxpointerdown:"mousedown",dxpointermove:"mousemove",dxpointerup:"mouseup",dxpointercancel:"",dxpointerover:"mouseover",dxpointerout:"mouseout",dxpointerenter:"mouseenter",dxpointerleave:"mouseleave"},u=function(e){return e.pointerId=1,{pointers:s.pointers(),pointerId:1}},d=!1,c=function(){d||(s=new a.default(l,(function(){return!0})),d=!0)},h=o.default.inherit({ctor:function(){this.callBase.apply(this,arguments),c()},_fireEvent:function(e){return this.callBase((0,i.extend)(u(e.originalEvent),e))}});h.map=l,h.normalize=u,h.activate=c,h.resetObserver=function(){s.reset()};var p=h;t.default=p,e.exports=t.default,e.exports.default=t.default},87720:function(e,t,n){t.default=void 0;var i=n(13306),o=l(n(88136)),a=l(n(66509)),r=l(n(69120)),s=n(39611);function l(e){return e&&e.__esModule?e:{default:e}}var u=!1,d=function(){u||(a.default.activate(),u=!0)},c=o.default.inherit({EVENT_LOCK_TIMEOUT:100,ctor:function(){this.callBase.apply(this,arguments),d()},_handler:function(e){var t=(0,s.isMouseEvent)(e);if(t||(this._skipNextEvents=!0),!t||!this._mouseLocked){if(!t||!this._skipNextEvents)return this.callBase(e);this._skipNextEvents=!1,this._mouseLocked=!0,clearTimeout(this._unlockMouseTimer);var n=this;this._unlockMouseTimer=setTimeout((function(){n._mouseLocked=!1}),this.EVENT_LOCK_TIMEOUT)}},_fireEvent:function(e){var t=(0,s.isMouseEvent)(e.originalEvent)?a.default.normalize:r.default.normalize;return this.callBase((0,i.extend)(t(e.originalEvent),e))},dispose:function(){this.callBase(),this._skipNextEvents=!1,this._mouseLocked=!1,clearTimeout(this._unlockMouseTimer)}});c.map={dxpointerdown:"touchstart mousedown",dxpointermove:"touchmove mousemove",dxpointerup:"touchend mouseup",dxpointercancel:"touchcancel",dxpointerover:"mouseover",dxpointerout:"mouseout",dxpointerenter:"mouseenter",dxpointerleave:"mouseleave"},c.resetObserver=a.default.resetObserver;var h=c;t.default=h,e.exports=t.default,e.exports.default=t.default},25544:function(e,t,n){t.default=void 0;var i=n(95479),o=r(n(24311)),a=r(n(73349));function r(e){return e&&e.__esModule?e:{default:e}}var s=function(e,t){o.default.add((function(){e.split(" ").forEach((function(e){a.default.listen(a.default.getDocument(),e,t,!0)}))}))},l=function(e,t,n){n=n||function(){};var o=[],a=function(e){var n=-1;return(0,i.each)(o,(function(i,o){return!t(e,o)||(n=i,!1)})),n},r=function(e){var t=a(e);t>-1&&o.splice(t,1)};s(e.dxpointerdown,(function(e){-1===a(e)&&(n(e),o.push(e))})),s(e.dxpointermove,(function(e){o[a(e)]=e})),s(e.dxpointerup,r),s(e.dxpointercancel,r),this.pointers=function(){return o},this.reset=function(){o=[]}};t.default=l,e.exports=t.default,e.exports.default=t.default},69120:function(e,t,n){t.default=void 0;var i=s(n(20530)),o=n(13306),a=n(95479),r=s(n(88136));function s(e){return e&&e.__esModule?e:{default:e}}var l=function(e){var t=[];return(0,a.each)(e.touches,(function(e,n){t.push((0,o.extend)({pointerId:n.identifier},n))})),{pointers:t,pointerId:e.changedTouches[0].identifier}},u=function(e){return"ios"===i.default.real().platform&&("dxpointerdown"===e||"dxpointerup"===e)},d=r.default.inherit({ctor:function(){this.callBase.apply(this,arguments),this._pointerId=0},_handler:function(e){if(u(this._eventName)){var t=e.changedTouches[0];if(this._pointerId===t.identifier&&0!==this._pointerId)return;this._pointerId=t.identifier}return this.callBase.apply(this,arguments)},_fireEvent:function(e){return this.callBase((0,o.extend)(l(e.originalEvent),e))}});d.map={dxpointerdown:"touchstart",dxpointermove:"touchmove",dxpointerup:"touchend",dxpointercancel:"touchcancel",dxpointerover:"",dxpointerout:"",dxpointerenter:"",dxpointerleave:""},d.normalize=l;var c=d;t.default=c,e.exports=t.default,e.exports.default=t.default},29007:function(e,t,n){t.removeEvent=void 0;var i=s(n(68374)),o=n(97906),a=s(n(55994)),r=s(n(85788));function s(e){return e&&e.__esModule?e:{default:e}}t.removeEvent="dxremove";(0,o.beforeCleanData)((function(e){e=[].slice.call(e);for(var t=0;t<e.length;t++){var n=(0,i.default)(e[t]);n.prop("dxRemoveEvent")&&(n[0].dxRemoveEvent=null,a.default.triggerHandler(n,"dxremove"))}})),(0,r.default)("dxremove",{noBubble:!0,setup:function(e){(0,i.default)(e).prop("dxRemoveEvent",!0)}})},72918:function(e,t,n){t.visibility=t.resize=t.keyboard=t.hover=t.focus=t.dxClick=t.click=t.active=void 0;var i=r(n(55994)),o=r(n(51661)),a=n(39611);function r(e){return e&&e.__esModule?e:{default:e}}function s(e,t){return t?(0,a.addNamespace)(e,t):e}function l(e,t){return"function"==typeof e?e(t):e.execute(t)}var u={on:function(e,t,n,o){var a=o.selector,r=o.showTimeout,u=o.hideTimeout,d=o.namespace;i.default.on(e,s("dxactive",d),a,{timeout:r},(function(e){return l(t,{event:e,element:e.currentTarget})})),i.default.on(e,s("dxinactive",d),a,{timeout:u},(function(e){return l(n,{event:e,element:e.currentTarget})}))},off:function(e,t){var n=t.namespace,o=t.selector;i.default.off(e,s("dxactive",n),o),i.default.off(e,s("dxinactive",n),o)}};t.active=u;var d={on:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o=n.namespace;i.default.on(e,s("dxresize",o),t)},off:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t.namespace;i.default.off(e,s("dxresize",n))}};t.resize=d;var c={on:function(e,t,n,o){var a=o.selector,r=o.namespace;i.default.on(e,s("dxhoverend",r),a,(function(e){return n(e)})),i.default.on(e,s("dxhoverstart",r),a,(function(e){return l(t,{element:e.target,event:e})}))},off:function(e,t){var n=t.selector,o=t.namespace;i.default.off(e,s("dxhoverstart",o),n),i.default.off(e,s("dxhoverend",o),n)}};t.hover=c;var h={on:function(e,t,n,o){var a=o.namespace;i.default.on(e,s("dxhiding",a),n),i.default.on(e,s("dxshown",a),t)},off:function(e,t){var n=t.namespace;i.default.off(e,s("dxhiding",n)),i.default.off(e,s("dxshown",n))}};t.visibility=h;var p={on:function(e,t,n,o){var a=o.namespace;i.default.on(e,s("focusin",a),t),i.default.on(e,s("focusout",a),n)},off:function(e,t){var n=t.namespace;i.default.off(e,s("focusin",n)),i.default.off(e,s("focusout",n))},trigger:function(e){return i.default.trigger(e,"focus")}};t.focus=p;var f={on:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o=n.namespace;i.default.on(e,s("dxclick",o),t)},off:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t.namespace;i.default.off(e,s("dxclick",n))}};t.dxClick=f;var g={on:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o=n.namespace;i.default.on(e,s("click",o),t)},off:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=t.namespace;i.default.off(e,s("click",n))}};t.click=g;var m=0,_={},v={on:function(e,t,n){var i="keyboardProcessorId".concat(m++);return _[i]=new o.default({element:e,focusTarget:t,handler:n}),i},off:function(e){e&&_[e]&&(_[e].dispose(),delete _[e])},_getProcessor:function(e){return _[e]}};t.keyboard=v},34309:function(e,t,n){t.swipe=t.start=t.end=void 0;var i=n(58664),o=n(39611),a=s(n(98621)),r=s(n(82495));function s(e){return e&&e.__esModule?e:{default:e}}t.start="dxswipestart";t.swipe="dxswipe";t.end="dxswipeend";var l={horizontal:{defaultItemSizeFunc:function(){return(0,i.getWidth)(this.getElement())},getBounds:function(){return[this._maxLeftOffset,this._maxRightOffset]},calcOffsetRatio:function(e){return((0,o.eventData)(e).x-(this._savedEventData&&this._savedEventData.x||0))/this._itemSizeFunc().call(this,e)},isFastSwipe:function(e){var t=(0,o.eventData)(e);return this.FAST_SWIPE_SPEED_LIMIT*Math.abs(t.x-this._tickData.x)>=t.time-this._tickData.time}},vertical:{defaultItemSizeFunc:function(){return(0,i.getHeight)(this.getElement())},getBounds:function(){return[this._maxTopOffset,this._maxBottomOffset]},calcOffsetRatio:function(e){return((0,o.eventData)(e).y-(this._savedEventData&&this._savedEventData.y||0))/this._itemSizeFunc().call(this,e)},isFastSwipe:function(e){var t=(0,o.eventData)(e);return this.FAST_SWIPE_SPEED_LIMIT*Math.abs(t.y-this._tickData.y)>=t.time-this._tickData.time}}},u=a.default.inherit({TICK_INTERVAL:300,FAST_SWIPE_SPEED_LIMIT:10,ctor:function(e){this.callBase(e),this.direction="horizontal",this.elastic=!0},_getStrategy:function(){return l[this.direction]},_defaultItemSizeFunc:function(){return this._getStrategy().defaultItemSizeFunc.call(this)},_itemSizeFunc:function(){return this.itemSizeFunc||this._defaultItemSizeFunc},_init:function(e){this._tickData=(0,o.eventData)(e)},_start:function(e){this._savedEventData=(0,o.eventData)(e),(e=this._fireEvent("dxswipestart",e)).cancel||(this._maxLeftOffset=e.maxLeftOffset,this._maxRightOffset=e.maxRightOffset,this._maxTopOffset=e.maxTopOffset,this._maxBottomOffset=e.maxBottomOffset)},_move:function(e){var t=this._getStrategy(),n=(0,o.eventData)(e),i=t.calcOffsetRatio.call(this,e);i=this._fitOffset(i,this.elastic),n.time-this._tickData.time>this.TICK_INTERVAL&&(this._tickData=n),this._fireEvent("dxswipe",e,{offset:i}),e.preventDefault()},_end:function(e){var t=this._getStrategy(),n=t.calcOffsetRatio.call(this,e),i=t.isFastSwipe.call(this,e),o=n,a=this._calcTargetOffset(n,i);o=this._fitOffset(o,this.elastic),a=this._fitOffset(a,!1),this._fireEvent("dxswipeend",e,{offset:o,targetOffset:a})},_fitOffset:function(e,t){var n=this._getStrategy().getBounds.call(this);return e<-n[0]?t?(-2*n[0]+e)/3:-n[0]:e>n[1]?t?(2*n[1]+e)/3:n[1]:e},_calcTargetOffset:function(e,t){var n;return t?(n=Math.ceil(Math.abs(e)),e<0&&(n=-n)):n=Math.round(e),n}});(0,r.default)({emitter:u,events:["dxswipestart","dxswipe","dxswipeend"]})},91093:function(e,t,n){function i(e){return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}t.zoomstart=t.zoomend=t.zoom=t.translatestart=t.translateend=t.translate=t.transformstart=t.transformend=t.transform=t.rotatestart=t.rotateend=t.rotate=t.pinchstart=t.pinchend=t.pinch=void 0;var o=n(60810),a=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!==i(e)&&"function"!=typeof e)return{default:e};var n=d(t);if(n&&n.has(e))return n.get(e);var o={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var r in e)if("default"!==r&&Object.prototype.hasOwnProperty.call(e,r)){var s=a?Object.getOwnPropertyDescriptor(e,r):null;s&&(s.get||s.set)?Object.defineProperty(o,r,s):o[r]=e[r]}o.default=e,n&&n.set(e,o);return o}(n(95479)),r=n(39611),s=u(n(31391)),l=u(n(82495));function u(e){return e&&e.__esModule?e:{default:e}}function d(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,n=new WeakMap;return(d=function(e){return e?n:t})(e)}var c="start",h="",p="end",f=[],g=function(e,t){f.push({name:e,args:t})};g("transform",{scale:!0,deltaScale:!0,rotation:!0,deltaRotation:!0,translation:!0,deltaTranslation:!0}),g("translate",{translation:!0,deltaTranslation:!0}),g("pinch",{scale:!0,deltaScale:!0}),g("rotate",{rotation:!0,deltaRotation:!0});var m=function(e){var t,n,i=e.pointers;return t=i[0],{x:(n=i[1]).pageX-t.pageX,y:-n.pageY+t.pageY,centerX:.5*(n.pageX+t.pageX),centerY:.5*(n.pageY+t.pageY)}},_=function(e){return Math.sqrt(e.x*e.x+e.y*e.y)},v=function(e,t){return _(e)/_(t)},y=function(e,t){var n=e.x*t.x+e.y*t.y,i=_(e)*_(t);return 0===i?0:(0,o.sign)(e.x*t.y-t.x*e.y)*Math.acos((0,o.fitIntoRange)(n/i,-1,1))},b=function(e,t){return{x:e.centerX-t.centerX,y:e.centerY-t.centerY}},x=s.default.inherit({validatePointers:function(e){return(0,r.hasTouches)(e)>1},start:function(e){this._accept(e);var t=m(e);this._startVector=t,this._prevVector=t,this._fireEventAliases(c,e)},move:function(e){var t=m(e),n=this._getEventArgs(t);this._fireEventAliases(h,e,n),this._prevVector=t},end:function(e){var t=this._getEventArgs(this._prevVector);this._fireEventAliases(p,e,t)},_getEventArgs:function(e){return{scale:v(e,this._startVector),deltaScale:v(e,this._prevVector),rotation:y(e,this._startVector),deltaRotation:y(e,this._prevVector),translation:b(e,this._startVector),deltaTranslation:b(e,this._prevVector)}},_fireEventAliases:function(e,t,n){n=n||{},a.each(f,function(i,o){var r={};a.each(o.args,(function(e){e in n&&(r[e]=n[e])})),this._fireEvent("dx"+o.name+e,t,r)}.bind(this))}}),w=f.reduce((function(e,t){return[c,h,p].forEach((function(n){e.push("dx"+t.name+n)})),e}),[]);(0,l.default)({emitter:x,events:w});var C={};a.each(w,(function(e,t){C[t.substring("dx".length)]=t}));var S=C.transformstart,k=C.transform,D=C.transformend,I=C.translatestart,T=C.translate,E=C.translateend,O=C.zoomstart,A=C.zoom,P=C.zoomend,R=C.pinchstart,M=C.pinch,B=C.pinchend,L=C.rotatestart,V=C.rotate,F=C.rotateend;t.rotateend=F,t.rotate=V,t.rotatestart=L,t.pinchend=B,t.pinch=M,t.pinchstart=R,t.zoomend=P,t.zoom=A,t.zoomstart=O,t.translateend=E,t.translate=T,t.translatestart=I,t.transformend=D,t.transform=k,t.transformstart=S},19141:function(e,t,n){t.default=void 0;var i,o=(i=n(17381))&&i.__esModule?i:{default:i};var a=function e(t,n){if(!n)throw o.default.Error("E0017");return Array.isArray(t)?t.map((function(t){return e(t,n)})).join(" "):-1!==t.indexOf(" ")?e(t.split(/\s+/g),n):"".concat(t,".").concat(n)};t.default=a,e.exports=t.default,e.exports.default=t.default},27575:function(e,t,n){t.unsubscribeNodesDisposing=t.subscribeNodesDisposing=void 0;var i,o=(i=n(55994))&&i.__esModule?i:{default:i},a=n(29007);function r(e){return e&&[e.target,e.delegateTarget,e.relatedTarget,e.currentTarget].filter((function(e){return!!e}))}t.subscribeNodesDisposing=function(e,t){o.default.one(r(e),a.removeEvent,t)};t.unsubscribeNodesDisposing=function(e,t){o.default.off(r(e),a.removeEvent,t)}},39611:function(e,t,n){t.stopEventsSkipping=t.setEventFixMethod=t.normalizeKeyName=t.needSkipEvent=t.isTouchEvent=t.isPointerEvent=t.isMouseEvent=t.isKeyboardEvent=t.isFakeClickEvent=t.isDxMouseWheelEvent=t.isCommandKeyPressed=t.hasTouches=t.getChar=t.forceSkipEvents=t.fireEvent=t.eventSource=t.eventDelta=t.eventData=t.createEvent=t.addNamespace=void 0;var i=u(n(68374)),o=u(n(19141)),a=u(n(55994)),r=n(95479),s=n(13306),l=n(31421);function u(e){return e&&e.__esModule?e:{default:e}}var d={backspace:"backspace",tab:"tab",enter:"enter",escape:"escape",pageup:"pageUp",pagedown:"pageDown",end:"end",home:"home",arrowleft:"leftArrow",arrowup:"upArrow",arrowright:"rightArrow",arrowdown:"downArrow",delete:"del"," ":"space",f:"F",a:"A","*":"asterisk","-":"minus",alt:"alt",control:"control",shift:"shift"},c={8:"backspace",9:"tab",13:"enter",27:"escape",33:"pageUp",34:"pageDown",35:"end",36:"home",37:"leftArrow",38:"upArrow",39:"rightArrow",40:"downArrow",46:"del",32:"space",70:"F",65:"A",106:"asterisk",109:"minus",189:"minus",173:"minus",16:"shift",17:"control",18:"alt"},h={dx:/^dx/i,mouse:/(mouse|wheel)/i,touch:/^touch/i,keyboard:/^key/i,pointer:/^(ms)?pointer/i},p=function(e){return e},f=function(e){return"dx"===m(e)},g=function(e){return"touch"===m(e)},m=function(e){var t=e.type,n="other";return(0,r.each)(h,(function(e){if(this.test(t))return n=e,!1})),n};t.eventSource=m;var _=function(e){return"pointer"===m(e)};t.isPointerEvent=_;var v=function(e){return function(e){return"mouse"===m(e)}(e)||(_(e)||f(e))&&"mouse"===e.pointerType};t.isMouseEvent=v;var y=function(e){return e&&"dxmousewheel"===e.type};t.isDxMouseWheelEvent=y;var b=function(e){return g(e)||(_(e)||f(e))&&"touch"===e.pointerType};t.isTouchEvent=b;t.isKeyboardEvent=function(e){return"keyboard"===m(e)};t.isFakeClickEvent=function(e){var t=e.screenX,n=e.offsetX,i=e.pageX;return 0===t&&!n&&0===i};t.eventData=function(e){return{x:e.pageX,y:e.pageY,time:e.timeStamp}};t.eventDelta=function(e,t){return{x:t.x-e.x,y:t.y-e.y,time:t.time-e.time||1}};t.hasTouches=function(e){var t=e.originalEvent,n=e.pointers;return g(e)?(t.touches||[]).length:f(e)?(n||[]).length:0};var x=!1;t.forceSkipEvents=function(){return x=!0};t.stopEventsSkipping=function(){return x=!1};t.needSkipEvent=function(e){if(x)return!0;var t=e.target,n=(0,i.default)(t),o=(null==t?void 0:t.isContentEditable)||(null==t?void 0:t.hasAttribute("contenteditable")),a=n.is("input, textarea, select")||o;return y(e)?!(n.is("textarea")&&n.hasClass("dx-texteditor-input")||o)&&(n.is("input[type='number'], textarea, select")&&n.is(":focus")):v(e)?a||e.which>1:b(e)?a&&(0,l.focused)(n):void 0};t.setEventFixMethod=function(e){return p=e};var w=function(e,t){var n=function(e){return p(a.default.Event(e,e),e)}(e);return t&&(0,s.extend)(n,t),n};t.createEvent=w;t.fireEvent=function(e){var t=e.originalEvent,n=e.delegateTarget,i=w(t,e);return a.default.trigger(n||i.target,i),i};t.normalizeKeyName=function(e){var t=e.key,n=e.which,i=t,o=!!t;if(t||n)return o&&(t=d[t.toLowerCase()]),(!o||!t&&n)&&(t=c[n]||String.fromCharCode(n)),t||i};t.getChar=function(e){var t=e.key,n=e.which;return t||String.fromCharCode(n)};var C=o.default;t.addNamespace=C;t.isCommandKeyPressed=function(e){var t=e.ctrlKey,n=e.metaKey;return t||n}},80506:function(e,t,n){t.triggerShownEvent=t.triggerResizeEvent=t.triggerHidingEvent=void 0;var i=a(n(68374)),o=a(n(55994));function a(e){return e&&e.__esModule?e:{default:e}}var r=function(e){return function(t){for(var n=(0,i.default)(t||"body"),a=n.filter(".dx-visibility-change-handler").add(n.find(".dx-visibility-change-handler")),r=0;r<a.length;r++)o.default.triggerHandler(a[r],e)}},s=r("dxshown");t.triggerShownEvent=s;var l=r("dxhiding");t.triggerHidingEvent=l;var u=r("dxresize");t.triggerResizeEvent=u},2994:function(e,t,n){Object.defineProperty(t,"exportDataGrid",{enumerable:!0,get:function(){return i.exportDataGrid}}),Object.defineProperty(t,"exportPivotGrid",{enumerable:!0,get:function(){return o.exportPivotGrid}});var i=n(8572),o=n(77328)},78292:function(e,t,n){t.excel=void 0,t.export=function(e,t,n){if(!e)return(new u.Deferred).resolve();var i=t.exportingAction,a=t.exportedAction,r=t.fileSavingAction,s={fileName:t.fileName,format:t.format,cancel:!1};(0,l.isBoolean)(t.selectedRowsOnly)&&(s.selectedRowsOnly=t.selectedRowsOnly);if((0,l.isFunction)(i)&&i(s),!s.cancel)return n(e,t).then((function(e){if((0,l.isFunction)(a)&&a(),(0,l.isFunction)(r)&&(s.data=e,r(s)),!s.cancel){var n="xlsx"===t.format?"EXCEL":t.format;o.fileSaver.saveAs(s.fileName,n,e,t.proxyUrl,t.forceProxy)}}));return(new u.Deferred).resolve()},Object.defineProperty(t,"fileSaver",{enumerable:!0,get:function(){return o.fileSaver}}),t.svg=t.pdf=t.image=void 0;var i,o=n(48351),a=n(13571),r=n(12173),s=n(37596),l=n(35922),u=n(62754),d=(i=n(45401))&&i.__esModule?i:{default:i},c=n(30855);var h={creator:a.ExcelCreator,getData:a.getData,formatConverter:d.default};t.excel=h;var p={creator:r.imageCreator,getData:r.getData,testFormats:r.testFormats};t.image=p;var f={getData:c.getData};t.pdf=f;var g={creator:s.svgCreator,getData:s.getData};t.svg=g},5332:function(e,t,n){t.ExportLoadPanel=void 0;var i=u(n(68374)),o=n(13306),a=u(n(28109)),r=n(35922),s=u(n(97218)),l=u(n(13615));function u(e){return e&&e.__esModule?e:{default:e}}var d=function(){function e(e,t,n,o){this._$targetElement=t,this._$container=n,this._loadPanel=e._createComponent((0,i.default)("<div>").addClass("dx-export-loadpanel").appendTo(this._$container),s.default,this.getOptions(o))}var t=e.prototype;return t.getDefaultOptions=function(){return{animation:null,shading:!1,height:90,width:200,container:this._$container}},t.getOptions=function(e){return(0,r.isDefined)(e.text)?e.message=e.text:e.message=a.default.format("dxDataGrid-exporting"),(0,o.extend)(this.getDefaultOptions(),e)},t.show=function(){this._loadPanel.option("position",l.default.calculateLoadPanelPosition(this._$targetElement)),this._loadPanel.show()},t.dispose=function(){(0,i.default)(this._loadPanel.element()).remove(),delete this._loadPanel},e}();t.ExportLoadPanel=d},56985:function(e,t,n){t.default=void 0;var i,o=n(35922),a=(i=n(95320))&&i.__esModule?i:{default:i};var r={tryCreateTag:function(e){var t=null;return(0,o.isDefined)(e)&&(t={vertical:e.vertical,wrapText:e.wrapText,horizontal:e.horizontal},r.isEmpty(t)&&(t=null)),t},copy:function(e){var t=null;return(0,o.isDefined)(e)&&(t={},void 0!==e.horizontal&&(t.horizontal=e.horizontal),void 0!==e.vertical&&(t.vertical=e.vertical),void 0!==e.wrapText&&(t.wrapText=e.wrapText)),t},areEqual:function(e,t){return r.isEmpty(e)&&r.isEmpty(t)||(0,o.isDefined)(e)&&(0,o.isDefined)(t)&&e.vertical===t.vertical&&e.wrapText===t.wrapText&&e.horizontal===t.horizontal},isEmpty:function(e){return!(0,o.isDefined)(e)||!(0,o.isDefined)(e.vertical)&&!(0,o.isDefined)(e.wrapText)&&!(0,o.isDefined)(e.horizontal)},toXml:function(e){return a.default.toXml("alignment",{vertical:e.vertical,wrapText:(0,o.isDefined)(e.wrapText)?Number(e.wrapText):void 0,horizontal:e.horizontal})}},s=r;t.default=s,e.exports=t.default,e.exports.default=t.default},2159:function(e,t,n){t.default=void 0;var i=n(35922),o=l(n(95320)),a=l(n(56985)),r=l(n(8808)),s=l(n(50394));function l(e){return e&&e.__esModule?e:{default:e}}var u={tryCreateTag:function(e,t){var n=null;if((0,i.isDefined)(e)){var o;o="number"==typeof e.numberFormat?e.numberFormat:t.registerNumberFormat(e.numberFormat);var s=e.fill;(0,i.isDefined)(s)||(s=r.default.tryCreateFillFromSimpleFormat(e)),n={numberFormatId:o,alignment:a.default.tryCreateTag(e.alignment),fontId:t.registerFont(e.font),fillId:t.registerFill(s)},u.isEmpty(n)&&(n=null)}return n},copy:function(e){var t;return null===e?t=null:(0,i.isDefined)(e)&&(t={},void 0!==e.numberFormat&&(t.numberFormat=e.numberFormat),void 0!==e.fill?t.fill=r.default.copy(e.fill):r.default.copySimpleFormat(e,t),void 0!==e.alignment&&(t.alignment=a.default.copy(e.alignment)),void 0!==e.font&&(t.font=s.default.copy(e.font))),t},areEqual:function(e,t){return u.isEmpty(e)&&u.isEmpty(t)||(0,i.isDefined)(e)&&(0,i.isDefined)(t)&&e.fontId===t.fontId&&e.numberFormatId===t.numberFormatId&&e.fillId===t.fillId&&a.default.areEqual(e.alignment,t.alignment)},isEmpty:function(e){return!(0,i.isDefined)(e)||!(0,i.isDefined)(e.fontId)&&!(0,i.isDefined)(e.numberFormatId)&&!(0,i.isDefined)(e.fillId)&&a.default.isEmpty(e.alignment)},toXml:function(e){var t,n=a.default.isEmpty(e.alignment);return(0,i.isDefined)(e.numberFormatId)&&(t=e.numberFormatId>0?1:0),o.default.toXml("xf",{xfId:0,applyAlignment:n?null:1,fontId:e.fontId,applyNumberFormat:t,fillId:e.fillId,numFmtId:e.numberFormatId},n?null:a.default.toXml(e.alignment))}},d=u;t.default=d,e.exports=t.default,e.exports.default=t.default},21879:function(e,t,n){t.default=void 0;var i,o=n(35922),a=(i=n(95320))&&i.__esModule?i:{default:i};var r={_tryConvertColor:function(e){if("string"!=typeof e)return e;var t;if(e.length>0&&"#"===e[0]){var n=e.substr(1,e.length);t=6===n.length?"FF"+n:8===n.length?n[6]+n[7]+n.substr(0,6):n}else t=e;return t},tryCreateTag:function(e){var t=null;return(0,o.isDefined)(e)&&(t="string"==typeof e?{rgb:this._tryConvertColor(e)}:{rgb:this._tryConvertColor(e.rgb),theme:e.theme},r.isEmpty(t)&&(t=null)),t},copy:function(e){var t=null;return(0,o.isDefined)(e)&&("string"==typeof e?t=e:(t={},void 0!==e.rgb&&(t.rgb=e.rgb),void 0!==e.theme&&(t.theme=e.theme))),t},isEmpty:function(e){return!(0,o.isDefined)(e)||!(0,o.isDefined)(e.rgb)&&!(0,o.isDefined)(e.theme)},areEqual:function(e,t){return r.isEmpty(e)&&r.isEmpty(t)||(0,o.isDefined)(e)&&(0,o.isDefined)(t)&&e.rgb===t.rgb&&e.theme===t.theme},toXml:function(e,t){return a.default.toXml(e,{rgb:t.rgb,theme:t.theme})}},s=r;t.default=s,e.exports=t.default,e.exports.default=t.default},50587:function(e,t,n){t.default=void 0;var i=n(35922),o=u(n(95320)),a=u(n(2159)),r=u(n(8808)),s=u(n(50394)),l=u(n(10794));function u(e){return e&&e.__esModule?e:{default:e}}var d=function(){function e(){this._cellFormatTags=[],this._fillTags=[],this._fontTags=[],this._numberFormatTags=[],this._fillTags.push(r.default.tryCreateTag({patternFill:{patternType:"none"}}))}var t=e.prototype;return t.registerCellFormat=function(e){var t,n=a.default.tryCreateTag(e,{registerFill:this.registerFill.bind(this),registerFont:this.registerFont.bind(this),registerNumberFormat:this.registerNumberFormat.bind(this)});if((0,i.isDefined)(n)){for(var o=0;o<this._cellFormatTags.length;o++)if(a.default.areEqual(this._cellFormatTags[o],n)){t=o;break}void 0===t&&(t=this._cellFormatTags.push(n)-1)}return t},e.copyCellFormat=function(e){return a.default.copy(e)},t.generateCellFormatsXml=function(){var e=this._cellFormatTags.map((function(e){return a.default.toXml(e)}));return o.default.toXml("cellXfs",{count:e.length},e.join(""))},t.registerFill=function(e){var t,n=r.default.tryCreateTag(e);if((0,i.isDefined)(n)){for(var o=0;o<this._fillTags.length;o++)if(r.default.areEqual(this._fillTags[o],n)){t=o;break}void 0===t&&(this._fillTags.length<2&&this._fillTags.push(r.default.tryCreateTag({patternFill:{patternType:"Gray125"}})),t=this._fillTags.push(n)-1)}return t},t.generateFillsXml=function(){var e=this._fillTags.map((function(e){return r.default.toXml(e)}));return o.default.toXml("fills",{count:e.length},e.join(""))},t.registerFont=function(e){var t,n=s.default.tryCreateTag(e);if((0,i.isDefined)(n)){for(var o=0;o<this._fontTags.length;o++)if(s.default.areEqual(this._fontTags[o],n)){t=o;break}void 0===t&&(t=this._fontTags.push(n)-1)}return t},t.generateFontsXml=function(){var e=this._fontTags.map((function(e){return s.default.toXml(e)}));return o.default.toXml("fonts",{count:e.length},e.join(""))},t._convertNumberFormatIndexToId=function(e){return 165+e},t.registerNumberFormat=function(e){var t,n=l.default.tryCreateTag(e);if((0,i.isDefined)(n)){for(var o=0;o<this._numberFormatTags.length;o++)if(l.default.areEqual(this._numberFormatTags[o],n)){t=this._numberFormatTags[o][l.default.ID_PROPERTY_NAME];break}void 0===t&&(n[l.default.ID_PROPERTY_NAME]=this._convertNumberFormatIndexToId(this._numberFormatTags.length),t=n[l.default.ID_PROPERTY_NAME],this._numberFormatTags.push(n))}return t},t.generateNumberFormatsXml=function(){if(this._numberFormatTags.length>0){var e=this._numberFormatTags.map((function(e){return l.default.toXml(e)}));return o.default.toXml("numFmts",{count:e.length},e.join(""))}return""},e}();t.default=d,e.exports=t.default,e.exports.default=t.default},8808:function(e,t,n){t.default=void 0;var i=n(35922),o=r(n(95320)),a=r(n(40027));function r(e){return e&&e.__esModule?e:{default:e}}var s={tryCreateTag:function(e){var t=null;return(0,i.isDefined)(e)&&(t={patternFill:a.default.tryCreateTag(e.patternFill)},s.isEmpty(t)&&(t=null)),t},tryCreateFillFromSimpleFormat:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},t=e.backgroundColor,n=e.fillPatternType,o=e.fillPatternColor;return!(0,i.isDefined)(t)||(0,i.isDefined)(n)&&(0,i.isDefined)(o)?(0,i.isDefined)(n)&&(0,i.isDefined)(o)?{patternFill:{patternType:n,foregroundColor:{rgb:o},backgroundColor:{rgb:t}}}:void 0:{patternFill:{patternType:"solid",foregroundColor:{rgb:t}}}},copySimpleFormat:function(e,t){void 0!==e.backgroundColor&&(t.backgroundColor=e.backgroundColor),void 0!==e.fillPatternType&&(t.fillPatternType=e.fillPatternType),void 0!==e.fillPatternColor&&(t.fillPatternColor=e.fillPatternColor)},copy:function(e){var t=null;return(0,i.isDefined)(e)&&(t={},void 0!==e.patternFill&&(t.patternFill=a.default.copy(e.patternFill))),t},areEqual:function(e,t){return s.isEmpty(e)&&s.isEmpty(t)||(0,i.isDefined)(e)&&(0,i.isDefined)(t)&&a.default.areEqual(e.patternFill,t.patternFill)},isEmpty:function(e){return!(0,i.isDefined)(e)||a.default.isEmpty(e.patternFill)},toXml:function(e){return o.default.toXml("fill",{},a.default.toXml(e.patternFill))}},l=s;t.default=l,e.exports=t.default,e.exports.default=t.default},50394:function(e,t,n){t.default=void 0;var i=n(35922),o=r(n(95320)),a=r(n(21879));function r(e){return e&&e.__esModule?e:{default:e}}var s={tryCreateTag:function(e){var t=null;return(0,i.isDefined)(e)&&(t={size:e.size,name:e.name,family:e.family,scheme:e.scheme,bold:e.bold,italic:e.italic,underline:e.underline,color:a.default.tryCreateTag(e.color)},s.isEmpty(t)&&(t=null)),t},copy:function(e){var t=null;return(0,i.isDefined)(e)&&(t={},void 0!==e.size&&(t.size=e.size),void 0!==e.name&&(t.name=e.name),void 0!==e.family&&(t.family=e.family),void 0!==e.scheme&&(t.scheme=e.scheme),void 0!==e.bold&&(t.bold=e.bold),void 0!==e.italic&&(t.italic=e.italic),void 0!==e.underline&&(t.underline=e.underline),void 0!==e.color&&(t.color=a.default.copy(e.color))),t},areEqual:function(e,t){return s.isEmpty(e)&&s.isEmpty(t)||(0,i.isDefined)(e)&&(0,i.isDefined)(t)&&e.size===t.size&&e.name===t.name&&e.family===t.family&&e.scheme===t.scheme&&(e.bold===t.bold||!e.bold==!t.bold)&&(e.italic===t.italic||!e.italic==!t.italic)&&e.underline===t.underline&&a.default.areEqual(e.color,t.color)},isEmpty:function(e){return!(0,i.isDefined)(e)||!(0,i.isDefined)(e.size)&&!(0,i.isDefined)(e.name)&&!(0,i.isDefined)(e.family)&&!(0,i.isDefined)(e.scheme)&&(!(0,i.isDefined)(e.bold)||!e.bold)&&(!(0,i.isDefined)(e.italic)||!e.italic)&&!(0,i.isDefined)(e.underline)&&a.default.isEmpty(e.color)},toXml:function(e){var t=[(0,i.isDefined)(e.bold)&&e.bold?o.default.toXml("b",{}):"",(0,i.isDefined)(e.size)?o.default.toXml("sz",{val:e.size}):"",(0,i.isDefined)(e.color)?a.default.toXml("color",e.color):"",(0,i.isDefined)(e.name)?o.default.toXml("name",{val:e.name}):"",(0,i.isDefined)(e.family)?o.default.toXml("family",{val:e.family}):"",(0,i.isDefined)(e.scheme)?o.default.toXml("scheme",{val:e.scheme}):"",(0,i.isDefined)(e.italic)&&e.italic?o.default.toXml("i",{}):"",(0,i.isDefined)(e.underline)?o.default.toXml("u",{val:e.underline}):""].join("");return o.default.toXml("font",{},t)}},l=s;t.default=l,e.exports=t.default,e.exports.default=t.default},10794:function(e,t,n){t.default=void 0;var i,o=n(35922),a=(i=n(95320))&&i.__esModule?i:{default:i};var r={ID_PROPERTY_NAME:"id",tryCreateTag:function(e){var t=null;return"string"==typeof e&&(t={formatCode:e},r.isEmpty(t)&&(t=null)),t},areEqual:function(e,t){return r.isEmpty(e)&&r.isEmpty(t)||(0,o.isDefined)(e)&&(0,o.isDefined)(t)&&e.formatCode===t.formatCode},isEmpty:function(e){return!(0,o.isDefined)(e)||!(0,o.isDefined)(e.formatCode)||""===e.formatCode},toXml:function(e){return a.default.toXml("numFmt",{numFmtId:e[r.ID_PROPERTY_NAME],formatCode:e.formatCode})}},s=r;t.default=s,e.exports=t.default,e.exports.default=t.default},40027:function(e,t,n){t.default=void 0;var i=n(35922),o=r(n(95320)),a=r(n(21879));function r(e){return e&&e.__esModule?e:{default:e}}var s={tryCreateTag:function(e){var t=null;return(0,i.isDefined)(e)&&(t={patternType:e.patternType,backgroundColor:a.default.tryCreateTag(e.backgroundColor),foregroundColor:a.default.tryCreateTag(e.foregroundColor)},s.isEmpty(t)&&(t=null)),t},copy:function(e){var t=null;return(0,i.isDefined)(e)&&(t={},void 0!==e.patternType&&(t.patternType=e.patternType),void 0!==e.backgroundColor&&(t.backgroundColor=a.default.copy(e.backgroundColor)),void 0!==e.foregroundColor&&(t.foregroundColor=a.default.copy(e.foregroundColor))),t},areEqual:function(e,t){return s.isEmpty(e)&&s.isEmpty(t)||(0,i.isDefined)(e)&&(0,i.isDefined)(t)&&e.patternType===t.patternType&&a.default.areEqual(e.backgroundColor,t.backgroundColor)&&a.default.areEqual(e.foregroundColor,t.foregroundColor)},isEmpty:function(e){return!(0,i.isDefined)(e)||!(0,i.isDefined)(e.patternType)},toXml:function(e){var t=[(0,i.isDefined)(e.foregroundColor)?a.default.toXml("fgColor",e.foregroundColor):"",(0,i.isDefined)(e.backgroundColor)?a.default.toXml("bgColor",e.backgroundColor):""].join("");return o.default.toXml("patternFill",{patternType:e.patternType},t)}},l=s;t.default=l,e.exports=t.default,e.exports.default=t.default},95320:function(e,t,n){t.default=void 0;var i=n(35922),o={toXml:function(e,t,n){var o=["<",e];for(var a in t){var r=t[a];(0,i.isDefined)(r)&&o.push(" ",a,'="',r,'"')}return(0,i.isDefined)(n)&&""!==n?o.push(">",n,"</",e,">"):o.push(" />"),o.join("")}};t.default=o,e.exports=t.default,e.exports.default=t.default},13571:function(e,t,n){t.ExcelCreator=void 0,t.getData=function(e,t){var n=new x(e,t);return n._checkZipState(),n.ready().then((function(){return n.getData((0,a.isFunction)((0,o.getWindow)().Blob))}))};var i=f(n(38377)),o=n(58201),a=n(35922),r=n(13306),s=f(n(96688)),l=n(68752),u=f(n(97405)),d=n(48351),c=f(n(45401)),h=f(n(50587)),p=n(62754);function f(e){return e&&e.__esModule?e:{default:e}}function g(e){return(g="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e