/*!
* DevExtreme (dx.messages.lt.js)
* Version: 24.2.3-build-24326-1309
* Build date: Thu Nov 21 2024
*
* Copyright (c) 2012 - 2024 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        lt: {
            Yes: "Taip",
            No: "Ne",
            Cancel: "At\u0161aukti",
            CheckState: "Check state",
            Close: "Close",
            Clear: "I\u0161valyti",
            Done: "Atlikta",
            Loading: "Kraunama...",
            Select: "Pasirinkti...",
            Search: "Paie\u0161ka",
            Back: "Atgal",
            OK: "Gerai",
            Today: "\u0160iandien",
            Yesterday: "Yesterday",
            "dxCollectionWidget-noDataText": "N\u0117ra duomen\u0173",
            "dxDropDownEditor-selectLabel": "Pasirinkti",
            "validation-required": "Privalomas",
            "validation-required-formatted": "{0} yra privalomas",
            "validation-numeric": "Reik\u0161m\u0117 turi b\u016bti skai\u010dius",
            "validation-numeric-formatted": "{0} turi b\u016bti skai\u010dius",
            "validation-range": "Reik\u0161m\u0117 nepatenka \u012f interval\u0105",
            "validation-range-formatted": "{0} nepatenka \u012f interval\u0105",
            "validation-stringLength": "Reik\u0161m\u0117s ilgis yra neteisingas",
            "validation-stringLength-formatted": "Reik\u0161m\u0117s {0} ilgis yra neteisingas",
            "validation-custom": "Reik\u0161m\u0117 yra neteisinga",
            "validation-custom-formatted": "{0} yra neteisinga",
            "validation-async": "Reik\u0161m\u0117 yra neteisinga",
            "validation-async-formatted": "{0} yra neteisinga",
            "validation-compare": "Reik\u0161m\u0117s nesutampa",
            "validation-compare-formatted": "{0} nesutampa",
            "validation-pattern": "Reik\u0161m\u0117 neatitinka \u0161ablono",
            "validation-pattern-formatted": "{0} neatitinka \u0161ablono",
            "validation-email": "Neteisingas el. pa\u0161to adresas",
            "validation-email-formatted": "{0} yra netinkama",
            "validation-mask": "Reik\u0161m\u0117 yra netinkama",
            "dxLookup-searchPlaceholder": "Minimalus simboli\u0173 skai\u010dius: {0}",
            "dxList-pullingDownText": "Patraukite \u017eemyn, kad atnaujintum\u0117te...",
            "dxList-pulledDownText": "Atleiskite, kad atnaujintum\u0117te...",
            "dxList-refreshingText": "Atnaujinama...",
            "dxList-pageLoadingText": "\u012ekeliama...",
            "dxList-nextButtonText": "Daugiau",
            "dxList-selectAll": "Pasirinkti visk\u0105",
            "dxList-listAriaLabel": "Items",
            "dxList-listAriaLabel-deletable": "Deletable items",
            "dxListEditDecorator-delete": "I\u0161trinti",
            "dxListEditDecorator-more": "Daugiau",
            "dxList-selectAll-indeterminate": "Half-checked",
            "dxList-selectAll-checked": "Checked",
            "dxList-selectAll-notChecked": "Not checked",
            "dxScrollView-pullingDownText": "Patraukite \u017eemyn, kad atnaujintum\u0117te...",
            "dxScrollView-pulledDownText": "Atleiskite, kad atnaujintum\u0117te...",
            "dxScrollView-refreshingText": "Atnaujinama...",
            "dxScrollView-reachBottomText": "\u012ekeliama...",
            "dxDateBox-simulatedDataPickerTitleTime": "Pasirinkite laik\u0105",
            "dxDateBox-simulatedDataPickerTitleDate": "Pasirinkite dat\u0105",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Pasirinkite dat\u0105 ir laik\u0105",
            "dxDateBox-validation-datetime": "Reik\u0161m\u0117 turi b\u016bti data arba laikas",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "Start Date",
            "dxDateRangeBox-endDateLabel": "End Date",
            "dxFileUploader-selectFile": "Pasirinkite byl\u0105",
            "dxFileUploader-dropFile": "arba numeskite byl\u0105 \u010dia",
            "dxFileUploader-bytes": "baitai",
            "dxFileUploader-kb": "KB",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "\u012ekelti",
            "dxFileUploader-uploaded": "\u012ekelta",
            "dxFileUploader-readyToUpload": "Paruo\u0161ta \u012fk\u0117limui",
            "dxFileUploader-uploadAbortedMessage": "\u012ek\u0117limas at\u0161auktas",
            "dxFileUploader-uploadFailedMessage": "\u012ek\u0117limas nepavyko",
            "dxFileUploader-invalidFileExtension": "Bylos tipas yra negalimas",
            "dxFileUploader-invalidMaxFileSize": "Byla yra per didel\u0117",
            "dxFileUploader-invalidMinFileSize": "Byla yra per ma\u017ea",
            "dxRangeSlider-ariaFrom": "Nuo",
            "dxRangeSlider-ariaTill": "Iki",
            "dxSwitch-switchedOnText": "\u012ej.",
            "dxSwitch-switchedOffText": "I\u0161j.",
            "dxForm-optionalMark": "neprivaloma",
            "dxForm-requiredMessage": "{0} privalomas",
            "dxNumberBox-invalidValueMessage": "Reik\u0161m\u0117 turi b\u016bti skai\u010dius",
            "dxNumberBox-noDataText": "N\u0117ra duomen\u0173",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} to display columns",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Drag a column from the group panel here",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} or drag a column from the group panel",
            "dxDataGrid-emptyHeaderColumnChooserText": "column chooser",
            "dxDataGrid-columnChooserTitle": "Stulpeli\u0173 tvarkymas",
            "dxDataGrid-columnChooserEmptyText": "U\u017etempkite stulpel\u012f \u010dia, kad j\u012f pasl\u0117ptum\u0117te",
            "dxDataGrid-groupContinuesMessage": "T\u0119sinys kitame puslapyje",
            "dxDataGrid-groupContinuedMessage": "Buvusio puslapio t\u0119sinys",
            "dxDataGrid-groupHeaderText": "Grupuoti pagal \u0161\u012f stulpel\u012f",
            "dxDataGrid-ungroupHeaderText": "I\u0161grupuoti",
            "dxDataGrid-ungroupAllText": "I\u0161grupuoti visk\u0105",
            "dxDataGrid-editingEditRow": "Redaguoti",
            "dxDataGrid-editingSaveRowChanges": "I\u0161saugoti",
            "dxDataGrid-editingCancelRowChanges": "At\u0161aukti",
            "dxDataGrid-editingDeleteRow": "I\u0161trinti",
            "dxDataGrid-editingUndeleteRow": "At\u0161aukti trynim\u0105",
            "dxDataGrid-editingConfirmDeleteMessage": "Ar tikrai norite i\u0161trinti \u0161\u012f \u012fra\u0161\u0105?",
            "dxDataGrid-validationCancelChanges": "At\u0161aukti pakeitimus",
            "dxDataGrid-groupPanelEmptyText": "U\u017etempkite stulpelio antra\u0161t\u0119 \u010dia, kad sugrupuotum\u0117te pagal stulpel\u012f",
            "dxDataGrid-noDataText": "N\u0117ra duomen\u0173",
            "dxDataGrid-searchPanelPlaceholder": "Ie\u0161koti...",
            "dxDataGrid-filterRowShowAllText": "(Visk\u0105)",
            "dxDataGrid-filterRowResetOperationText": "Nustatyti i\u0161 naujo",
            "dxDataGrid-filterRowOperationEquals": "Lygu",
            "dxDataGrid-filterRowOperationNotEquals": "Nelygu",
            "dxDataGrid-filterRowOperationLess": "Ma\u017eiau u\u017e",
            "dxDataGrid-filterRowOperationLessOrEquals": "Ma\u017eiau u\u017e arba lygu",
            "dxDataGrid-filterRowOperationGreater": "Daugiau u\u017e",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "Daugiau u\u017e arba lygu",
            "dxDataGrid-filterRowOperationStartsWith": "Prasideda",
            "dxDataGrid-filterRowOperationContains": "Tekste yra",
            "dxDataGrid-filterRowOperationNotContains": "Tekste n\u0117ra",
            "dxDataGrid-filterRowOperationEndsWith": "Pasibaigia",
            "dxDataGrid-filterRowOperationBetween": "Intervale",
            "dxDataGrid-filterRowOperationBetweenStartText": "Prad\u017eia",
            "dxDataGrid-filterRowOperationBetweenEndText": "Pabaiga",
            "dxDataGrid-ariaSearchBox": "Search box",
            "dxDataGrid-applyFilterText": "Pritaikyti filtr\u0105",
            "dxDataGrid-trueText": "Taip",
            "dxDataGrid-falseText": "Ne",
            "dxDataGrid-sortingAscendingText": "R\u016b\u0161iuoti did\u0117jan\u010diai",
            "dxDataGrid-sortingDescendingText": "R\u016b\u0161iuoti ma\u017e\u0117jan\u010diai",
            "dxDataGrid-sortingClearText": "Ner\u016b\u0161iuoti",
            "dxDataGrid-ariaNotSortedColumn": "Not sorted column",
            "dxDataGrid-ariaSortedAscendingColumn": "Column sorted in ascending order",
            "dxDataGrid-ariaSortedDescendingColumn": "Column sorted in descending order",
            "dxDataGrid-ariaSortIndex": "Sort index {0}",
            "dxDataGrid-editingSaveAllChanges": "I\u0161saugoti pakeitimus",
            "dxDataGrid-editingCancelAllChanges": "Atmesti pakeitimus",
            "dxDataGrid-editingAddRow": "Prid\u0117ti eilut\u0119",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Min. i\u0161 {1} yra {0}",
            "dxDataGrid-summaryMax": "Maks: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "Maks. i\u0161 {1} yra {0}",
            "dxDataGrid-summaryAvg": "Vid: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "Vid. i\u0161 {1} yra {0}",
            "dxDataGrid-summarySum": "Suma: {0}",
            "dxDataGrid-summarySumOtherColumn": "Suma i\u0161 {1} yra {0}",
            "dxDataGrid-summaryCount": "Sk: {0}",
            "dxDataGrid-columnFixingFix": "Set Fixed Position",
            "dxDataGrid-columnFixingUnfix": "Unfix",
            "dxDataGrid-columnFixingLeftPosition": "Left",
            "dxDataGrid-columnFixingRightPosition": "Right",
            "dxDataGrid-columnFixingStickyPosition": "Sticky",
            "dxDataGrid-exportTo": "Eksportuoti",
            "dxDataGrid-exportToExcel": "Eksportuoti \u012f Excel",
            "dxDataGrid-exporting": "Eksportuojama...",
            "dxDataGrid-excelFormat": "Excel byla",
            "dxDataGrid-selectedRows": "Pasirinktos eilut\u0117s",
            "dxDataGrid-exportSelectedRows": "Eksportuoti pasirinktas eilutes",
            "dxDataGrid-exportAll": "Eksportuoti visus duomenis",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Show filter options for column '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(Tu\u0161\u010dia)",
            "dxDataGrid-headerFilterOK": "Gerai",
            "dxDataGrid-headerFilterCancel": "At\u0161aukti",
            "dxDataGrid-ariaAdaptiveCollapse": "Sl\u0117pti papildomus duomenis",
            "dxDataGrid-ariaAdaptiveExpand": "Rodyti papildomus duomenis",
            "dxDataGrid-ariaColumn": "Stulpelis",
            "dxDataGrid-ariaColumnHeader": "Column header",
            "dxDataGrid-ariaValue": "Reik\u0161m\u0117",
            "dxDataGrid-ariaError": "Error",
            "dxDataGrid-ariaRevertButton": "Press Escape to discard the changes",
            "dxDataGrid-ariaFilterCell": "Filtro laukas",
            "dxDataGrid-ariaCollapse": "Suskleisti",
            "dxDataGrid-ariaModifiedCell": "Modified",
            "dxDataGrid-ariaDeletedCell": "Deleted",
            "dxDataGrid-ariaEditableCell": "Editable",
            "dxDataGrid-ariaExpand": "I\u0161skleisti",
            "dxDataGrid-ariaCollapsedRow": "Collapsed row",
            "dxDataGrid-ariaExpandedRow": "Expanded row",
            "dxDataGrid-ariaDataGrid": "Duomen\u0173 lentel\u0117",
            "dxDataGrid-ariaSearchInGrid": "Ie\u0161koti duomen\u0173 lentel\u0117je",
            "dxDataGrid-ariaSelectAll": "Pasirinkti visk\u0105",
            "dxDataGrid-ariaSelectRow": "Pasirinkti eilut\u0119",
            "dxDataGrid-ariaToolbar": "Duomen\u0173 lentel\u0117s \u012franki\u0173 juosta",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "Filtr\u0173 konstruktorius",
            "dxDataGrid-filterPanelCreateFilter": "Sukurti filtr\u0105",
            "dxDataGrid-filterPanelClearFilter": "I\u0161valyti",
            "dxDataGrid-filterPanelFilterEnabledHint": "Aktyvuoti filtr\u0105",
            "dxDataGrid-masterDetail": "Cell with details",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaExpandableInstruction": "Press Ctrl + right arrow to expand the focused node and Ctrl + left arrow to collapse it",
            "dxTreeList-ariaSearchInGrid": "Ie\u0161koti duomen\u0173 medyje",
            "dxTreeList-ariaToolbar": "Duomen\u0173 med\u017eio \u012franki\u0173 juosta",
            "dxTreeList-editingAddRowToNode": "Prid\u0117ti",
            "dxPager-infoText": "Puslapis {0} i\u0161 {1} (Viso eilu\u010di\u0173: {2})",
            "dxPager-pagesCountText": "i\u0161",
            "dxPager-pageSize": "Items per page: {0}",
            "dxPager-pageSizesAllText": "Viskas",
            "dxPager-page": "Page {0}",
            "dxPager-prevPage": "Previous page",
            "dxPager-nextPage": "Next page",
            "dxPager-ariaLabel": "Page navigation",
            "dxPager-ariaPageSize": "Page size",
            "dxPager-ariaPageNumber": "Page number",
            "dxPagination-infoText": "Puslapis {0} i\u0161 {1} (Viso eilu\u010di\u0173: {2})",
            "dxPagination-pagesCountText": "i\u0161",
            "dxPagination-pageSize": "Items per page: {0}",
            "dxPagination-pageSizesAllText": "Viskas",
            "dxPagination-page": "Page {0}",
            "dxPagination-prevPage": "Previous page",
            "dxPagination-nextPage": "Next page",
            "dxPagination-ariaLabel": "Page navigation",
            "dxPagination-ariaPageSize": "Page size",
            "dxPagination-ariaPageNumber": "Page number",
            "dxPivotGrid-grandTotal": "I\u0161 viso",
            "dxPivotGrid-total": "{0} Viso",
            "dxPivotGrid-fieldChooserTitle": "Stulpeli\u0173 pasirinkimas",
            "dxPivotGrid-showFieldChooser": "Parodyti stulpeli\u0173 pasirinkim\u0105",
            "dxPivotGrid-expandAll": "I\u0161skleisti visk\u0105",
            "dxPivotGrid-collapseAll": "Suskleisti visk\u0105",
            "dxPivotGrid-sortColumnBySummary": 'R\u016b\u0161iuoti "{0}" pagal \u0161\u012f stulpel\u012f',
            "dxPivotGrid-sortRowBySummary": 'R\u016b\u0161iuoti "{0}" pagal \u0161i\u0105 eilut\u0119',
            "dxPivotGrid-removeAllSorting": "Panaikinti r\u016b\u0161iavim\u0105",
            "dxPivotGrid-dataNotAvailable": "N\u0117ra",
            "dxPivotGrid-rowFields": "Eilu\u010di\u0173 laukai",
            "dxPivotGrid-columnFields": "Stulpeli\u0173 laukai",
            "dxPivotGrid-dataFields": "Duomen\u0173 laukai",
            "dxPivotGrid-filterFields": "Filtr\u0173 laukai",
            "dxPivotGrid-allFields": "Visi laukai",
            "dxPivotGrid-columnFieldArea": "Numeskite stulpeli\u0173 laukus \u010dia",
            "dxPivotGrid-dataFieldArea": "Numeskite duomen\u0173 laukus \u010dia",
            "dxPivotGrid-rowFieldArea": "Numeskite eilu\u010di\u0173 laukus \u010dia",
            "dxPivotGrid-filterFieldArea": "Numeskite filtr\u0173 laukus \u010dia",
            "dxScheduler-ariaLabel": "Scheduler. {0} view",
            "dxScheduler-appointmentAriaLabel-group": "Group: {0}",
            "dxScheduler-appointmentAriaLabel-recurring": "Recurring appointment",
            "dxScheduler-editorLabelTitle": "Tema",
            "dxScheduler-editorLabelStartDate": "Prad\u017eios data",
            "dxScheduler-editorLabelEndDate": "Pabaigos data",
            "dxScheduler-editorLabelDescription": "Apra\u0161ymas",
            "dxScheduler-editorLabelRecurrence": "Kartojimas",
            "dxScheduler-navigationPrevious": "Previous page",
            "dxScheduler-navigationNext": "Next page",
            "dxScheduler-openAppointment": "Atidaryti paskyrim\u0105",
            "dxScheduler-recurrenceNever": "Niekada",
            "dxScheduler-recurrenceMinutely": "Kas minut\u0119",
            "dxScheduler-recurrenceHourly": "Kas valand\u0105",
            "dxScheduler-recurrenceDaily": "Kasdien",
            "dxScheduler-recurrenceWeekly": "Kas savait\u0119",
            "dxScheduler-recurrenceMonthly": "Kas m\u0117nes\u012f",
            "dxScheduler-recurrenceYearly": "Kas metus",
            "dxScheduler-recurrenceRepeatEvery": "Kartoti kas",
            "dxScheduler-recurrenceRepeatOn": "Kartoti",
            "dxScheduler-recurrenceEnd": "Baigti kartoti",
            "dxScheduler-recurrenceAfter": "Po",
            "dxScheduler-recurrenceOn": "Iki",
            "dxScheduler-recurrenceRepeatMinutely": "minut\u0119(es)",
            "dxScheduler-recurrenceRepeatHourly": "valand\u0105(as)",
            "dxScheduler-recurrenceRepeatDaily": "dien\u0105(as)",
            "dxScheduler-recurrenceRepeatWeekly": "savait\u0119(es)",
            "dxScheduler-recurrenceRepeatMonthly": "m\u0117nes\u012f(ius)",
            "dxScheduler-recurrenceRepeatYearly": "metus(\u0173)",
            "dxScheduler-switcherDay": "Diena",
            "dxScheduler-switcherWeek": "Savait\u0117",
            "dxScheduler-switcherWorkWeek": "Darbo savait\u0117",
            "dxScheduler-switcherMonth": "M\u0117nuo",
            "dxScheduler-switcherAgenda": "Dienotvark\u0117",
            "dxScheduler-switcherTimelineDay": "Dienos dienotvark\u0117",
            "dxScheduler-switcherTimelineWeek": "Savait\u0117s dienotvark\u0117",
            "dxScheduler-switcherTimelineWorkWeek": "Darbo savait\u0117s dienotvark\u0117",
            "dxScheduler-switcherTimelineMonth": "M\u0117nesio dienotvark\u0117",
            "dxScheduler-recurrenceRepeatOnDate": "iki datos",
            "dxScheduler-recurrenceRepeatCount": "kart\u0105(us)",
            "dxScheduler-allDay": "Visa diena",
            "dxScheduler-ariaEditForm": "Edit form",
            "dxScheduler-confirmRecurrenceEditTitle": "Edit Recurring Appointment",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Delete Recurring Appointment",
            "dxScheduler-confirmRecurrenceEditMessage": "Norite redaguoti tik \u0161\u012f paskyrim\u0105 ar vis\u0105 serij\u0105?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Norite i\u0161trinti tik \u0161\u012f paskyrim\u0105 ar vis\u0105 serij\u0105?",
            "dxScheduler-confirmRecurrenceEditSeries": "Redaguoti serij\u0105",
            "dxScheduler-confirmRecurrenceDeleteSeries": "I\u0161trinti serij\u0105",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Redaguoti paskyrim\u0105",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "I\u0161trinti paskyrim\u0105",
            "dxScheduler-noTimezoneTitle": "Nepasirinkta laiko zona",
            "dxScheduler-moreAppointments": "dar {0}",
            "dxCalendar-currentDay": "Today",
            "dxCalendar-currentMonth": "Current month",
            "dxCalendar-currentYear": "Current year",
            "dxCalendar-currentYearRange": "Current year range",
            "dxCalendar-todayButtonText": "\u0160iandien",
            "dxCalendar-ariaWidgetName": "Kalendorius",
            "dxCalendar-previousMonthButtonLabel": "Previous month",
            "dxCalendar-previousYearButtonLabel": "Previous year",
            "dxCalendar-previousDecadeButtonLabel": "Previous decade",
            "dxCalendar-previousCenturyButtonLabel": "Previous century",
            "dxCalendar-nextMonthButtonLabel": "Next month",
            "dxCalendar-nextYearButtonLabel": "Next year",
            "dxCalendar-nextDecadeButtonLabel": "Next decade",
            "dxCalendar-nextCenturyButtonLabel": "Next century",
            "dxCalendar-captionMonthLabel": "Month selection",
            "dxCalendar-captionYearLabel": "Year selection",
            "dxCalendar-captionDecadeLabel": "Decade selection",
            "dxCalendar-captionCenturyLabel": "Century selection",
            "dxCalendar-selectedDate": "The selected date is {0}",
            "dxCalendar-selectedDates": "The selected dates",
            "dxCalendar-selectedDateRange": "The selected date range is from {0} to {1}",
            "dxCalendar-selectedMultipleDateRange": "from {0} to {1}",
            "dxCalendar-selectedDateRangeCount": "There are {0} selected date ranges",
            "dxCalendar-readOnlyLabel": "Read-only calendar",
            "dxAvatar-defaultImageAlt": "Avatar",
            "dxChat-elementAriaLabel": "Chat",
            "dxChat-textareaPlaceholder": "Type a message",
            "dxChat-sendButtonAriaLabel": "Send",
            "dxChat-defaultUserName": "Unknown User",
            "dxChat-messageListAriaLabel": "Message list",
            "dxChat-alertListAriaLabel": "Error list",
            "dxChat-emptyListMessage": "There are no messages in this chat",
            "dxChat-emptyListPrompt": "Write your first message",
            "dxChat-typingMessageSingleUser": "{0} is typing...",
            "dxChat-typingMessageTwoUsers": "{0} and {1} are typing...",
            "dxChat-typingMessageThreeUsers": "{0}, {1} and {2} are typing...",
            "dxChat-typingMessageMultipleUsers": "{0} and others are typing...",
            "dxColorView-ariaRed": "Raudona",
            "dxColorView-ariaGreen": "\u017dalia",
            "dxColorView-ariaBlue": "M\u0117lyna",
            "dxColorView-ariaAlpha": "Skaidrumas",
            "dxColorView-ariaHex": "Spalvos kodas",
            "dxTagBox-selected": "{0} pasirinkta",
            "dxTagBox-allSelected": "Viskas pasirinkta ({0})",
            "dxTagBox-moreSelected": "dar {0}",
            "dxTagBox-tagRoleDescription": "Tag. Press the delete button to remove this tag",
            "vizExport-printingButtonText": "Spausdinti",
            "vizExport-titleMenuText": "Eksportavimas/Spausdinimas",
            "vizExport-exportButtonText": "{0} byla",
            "dxFilterBuilder-and": "Ir",
            "dxFilterBuilder-or": "Arba",
            "dxFilterBuilder-notAnd": "Ne Ir",
            "dxFilterBuilder-notOr": "Ne Arba",
            "dxFilterBuilder-addCondition": "Prid\u0117ti s\u0105lyg\u0105",
            "dxFilterBuilder-addGroup": "Prid\u0117ti grup\u0119",
            "dxFilterBuilder-enterValueText": "<\u012fveskite reik\u0161m\u0119>",
            "dxFilterBuilder-filterOperationEquals": "Lygu",
            "dxFilterBuilder-filterOperationNotEquals": "Ne Lygu",
            "dxFilterBuilder-filterOperationLess": "Ma\u017eiau u\u017e",
            "dxFilterBuilder-filterOperationLessOrEquals": "Ma\u017eiau u\u017e arba lygu",
            "dxFilterBuilder-filterOperationGreater": "Daugiau u\u017e",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "Daugiau u\u017e arba lygu",
            "dxFilterBuilder-filterOperationStartsWith": "Prasideda",
            "dxFilterBuilder-filterOperationContains": "Tekste yra",
            "dxFilterBuilder-filterOperationNotContains": "Tekste n\u0117ra",
            "dxFilterBuilder-filterOperationEndsWith": "Pasibaigia",
            "dxFilterBuilder-filterOperationIsBlank": "Tu\u0161\u010dia",
            "dxFilterBuilder-filterOperationIsNotBlank": "N\u0117ra tu\u0161\u010dia",
            "dxFilterBuilder-filterOperationBetween": "Intervale",
            "dxFilterBuilder-filterOperationAnyOf": "Kuris nors i\u0161",
            "dxFilterBuilder-filterOperationNoneOf": "N\u0117 vienas i\u0161",
            "dxFilterBuilder-filterAriaRootElement": "Filter builder",
            "dxFilterBuilder-filterAriaGroupLevel": "Level {0}",
            "dxFilterBuilder-filterAriaGroupItem": "Group item",
            "dxFilterBuilder-filterAriaOperationButton": "Operation",
            "dxFilterBuilder-filterAriaAddButton": "Add",
            "dxFilterBuilder-filterAriaRemoveButton": "Remove {0}",
            "dxFilterBuilder-filterAriaItemField": "Item field",
            "dxFilterBuilder-filterAriaItemOperation": "Item operation",
            "dxFilterBuilder-filterAriaItemValue": "Item value",
            "dxHtmlEditor-dialogColorCaption": "Pakeisti \u0161rifto spalv\u0105",
            "dxHtmlEditor-dialogBackgroundCaption": "Pakeisti fono spalv\u0105",
            "dxHtmlEditor-dialogLinkCaption": "Prid\u0117ti nuorod\u0105",
            "dxHtmlEditor-dialogLinkUrlField": "Adresas",
            "dxHtmlEditor-dialogLinkTextField": "Tekstas",
            "dxHtmlEditor-dialogLinkTargetField": "Atidaryti nuorod\u0105 naujame lange",
            "dxHtmlEditor-dialogImageCaption": "Prid\u0117ti paveiksliuk\u0105",
            "dxHtmlEditor-dialogImageUrlField": "Adresas",
            "dxHtmlEditor-dialogImageAltField": "Alternatyvus tekstas",
            "dxHtmlEditor-dialogImageWidthField": "Plotis (px)",
            "dxHtmlEditor-dialogImageHeightField": "Auk\u0161tis (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "Eilut\u0117s",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Stulpeliai",
            "dxHtmlEditor-dialogInsertTableCaption": "\u012eterpti lentel\u0119",
            "dxHtmlEditor-dialogUpdateImageCaption": "Update Image",
            "dxHtmlEditor-dialogImageUpdateButton": "Update",
            "dxHtmlEditor-dialogImageAddButton": "Add",
            "dxHtmlEditor-dialogImageSpecifyUrl": "From the Web",
            "dxHtmlEditor-dialogImageSelectFile": "From This Device",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Keep Aspect Ratio",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Encode to Base64",
            "dxHtmlEditor-heading": "Antra\u0161t\u0117",
            "dxHtmlEditor-normalText": "\u012eprastas tekstas",
            "dxHtmlEditor-background": "Fono spalva",
            "dxHtmlEditor-bold": "Pary\u0161kintas",
            "dxHtmlEditor-color": "\u0160rifto spalva",
            "dxHtmlEditor-font": "\u0160riftas",
            "dxHtmlEditor-italic": "Kursyvas",
            "dxHtmlEditor-link": "Prid\u0117ti nuorod\u0105",
            "dxHtmlEditor-image": "Prid\u0117ti paveiksl\u0117l\u012f",
            "dxHtmlEditor-size": "Dydis",
            "dxHtmlEditor-strike": "Perbraukta",
            "dxHtmlEditor-subscript": "Pradinis indeksas",
            "dxHtmlEditor-superscript": "Vir\u0161utinis indeksas",
            "dxHtmlEditor-underline": "Pabraukta",
            "dxHtmlEditor-blockquote": "Citatos blokas",
            "dxHtmlEditor-header": "Antra\u0161t\u0117",
            "dxHtmlEditor-increaseIndent": "Padidinti \u012ftrauk\u0105",
            "dxHtmlEditor-decreaseIndent": "Pama\u017einti \u012ftrauk\u0105",
            "dxHtmlEditor-orderedList": "Sunumeruotas s\u0105ra\u0161as",
            "dxHtmlEditor-bulletList": "Su\u017eenklintas s\u0105ra\u0161as",
            "dxHtmlEditor-alignLeft": "Lygiuoti \u012f kair\u0119",
            "dxHtmlEditor-alignCenter": "Lygiuoti centre",
            "dxHtmlEditor-alignRight": "Lygiuoti \u012f de\u0161in\u0119",
            "dxHtmlEditor-alignJustify": "Lygiuoti \u012f plot\u012f",
            "dxHtmlEditor-codeBlock": "Kodo blokas",
            "dxHtmlEditor-variable": "Prid\u0117ti kintam\u0105j\u012f",
            "dxHtmlEditor-undo": "Anuliuoti",
            "dxHtmlEditor-redo": "Perdaryti",
            "dxHtmlEditor-clear": "I\u0161valyti formatavim\u0105",
            "dxHtmlEditor-insertTable": "\u012eterpti lentel\u0119",
            "dxHtmlEditor-insertHeaderRow": "\u012eterpti antra\u0161t\u0117s eilut\u0119",
            "dxHtmlEditor-insertRowAbove": "\u012eterpti eilut\u0119 auk\u0161\u010diau",
            "dxHtmlEditor-insertRowBelow": "\u012eterpti eilut\u0119 \u017eemiau",
            "dxHtmlEditor-insertColumnLeft": "\u012eterpti stulpel\u012f kairiau",
            "dxHtmlEditor-insertColumnRight": "\u012eterpti stulpel\u012f de\u0161iniau",
            "dxHtmlEditor-deleteColumn": "I\u0161trinti stulpel\u012f",
            "dxHtmlEditor-deleteRow": "I\u0161trinti eilut\u0119",
            "dxHtmlEditor-deleteTable": "I\u0161trinti lentel\u0119",
            "dxHtmlEditor-cellProperties": "Lauko ypatyb\u0117s",
            "dxHtmlEditor-tableProperties": "Lentel\u0117s ypatyb\u0117s",
            "dxHtmlEditor-insert": "\u012eterpti",
            "dxHtmlEditor-delete": "I\u0161trinti",
            "dxHtmlEditor-border": "Kra\u0161tin\u0117s",
            "dxHtmlEditor-style": "Stilius",
            "dxHtmlEditor-width": "Plotis",
            "dxHtmlEditor-height": "Auk\u0161tis",
            "dxHtmlEditor-borderColor": "Spalva",
            "dxHtmlEditor-borderWidth": "Border Width",
            "dxHtmlEditor-tableBackground": "Fonas",
            "dxHtmlEditor-dimensions": "Matmenys",
            "dxHtmlEditor-alignment": "Lygiavimas",
            "dxHtmlEditor-horizontal": "Horizontaliai",
            "dxHtmlEditor-vertical": "Vertikaliai",
            "dxHtmlEditor-paddingVertical": "Vertikalus u\u017epildymas",
            "dxHtmlEditor-paddingHorizontal": "Horizontalus u\u017epildymas",
            "dxHtmlEditor-pixels": "Pikseliai",
            "dxHtmlEditor-list": "S\u0105ra\u0161as",
            "dxHtmlEditor-ordered": "Sunumeruotas",
            "dxHtmlEditor-bullet": "Su\u017eenklintas",
            "dxHtmlEditor-align": "Lygiuoti",
            "dxHtmlEditor-center": "Centras",
            "dxHtmlEditor-left": "Kair\u0117",
            "dxHtmlEditor-right": "De\u0161in\u0117",
            "dxHtmlEditor-indent": "\u012etrauka",
            "dxHtmlEditor-justify": "\u012e plot\u012f",
            "dxHtmlEditor-borderStyleNone": "none",
            "dxHtmlEditor-borderStyleHidden": "hidden",
            "dxHtmlEditor-borderStyleDotted": "dotted",
            "dxHtmlEditor-borderStyleDashed": "dashed",
            "dxHtmlEditor-borderStyleSolid": "solid",
            "dxHtmlEditor-borderStyleDouble": "double",
            "dxHtmlEditor-borderStyleGroove": "groove",
            "dxHtmlEditor-borderStyleRidge": "ridge",
            "dxHtmlEditor-borderStyleInset": "inset",
            "dxHtmlEditor-borderStyleOutset": "outset",
            "dxFileManager-newDirectoryName": "Nepavadintas aplankas",
            "dxFileManager-rootDirectoryName": "Bylos",
            "dxFileManager-errorNoAccess": "N\u0117ra prieigos. Veiksmas negali b\u016bti atliktas.",
            "dxFileManager-errorDirectoryExistsFormat": "Aplankas '{0}' jau egzistuoja.",
            "dxFileManager-errorFileExistsFormat": "Byla '{0}' jau egzistuoja.",
            "dxFileManager-errorFileNotFoundFormat": "Byla '{0}' nerasta.",
            "dxFileManager-errorDirectoryNotFoundFormat": "Aplankas '{0}' nerastas.",
            "dxFileManager-errorWrongFileExtension": "Neleistinas bylos pl\u0117tinys.",
            "dxFileManager-errorMaxFileSizeExceeded": "Bylos dydis vir\u0161ija maksimal\u0173 leistin\u0105 dyd\u012f",
            "dxFileManager-errorInvalidSymbols": "Pavadinime yra neleistin\u0173 simboli\u0173",
            "dxFileManager-errorDefault": "Nenumatyta klaida",
            "dxFileManager-errorDirectoryOpenFailed": "Aplankas negali b\u016bti atidarytas",
            "dxFileManager-commandCreate": "Naujas aplankas",
            "dxFileManager-commandRename": "Pervadinti",
            "dxFileManager-commandMove": "Perkelti",
            "dxFileManager-commandCopy": "Kopijuoti \u012f",
            "dxFileManager-commandDelete": "I\u0161trinti",
            "dxFileManager-commandDownload": "Parsisi\u0173sti",
            "dxFileManager-commandUpload": "\u012ekelti bylas",
            "dxFileManager-commandRefresh": "Atnaujinti",
            "dxFileManager-commandThumbnails": "Miniati\u016br\u0173 rodinys",
            "dxFileManager-commandDetails": "I\u0161samus rodinys",
            "dxFileManager-commandClearSelection": "I\u0161valyti pasirinkim\u0105",
            "dxFileManager-commandShowNavPane": "Perjungti nar\u0161ymo srit\u012f",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "Perkelti \u012f",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "Perkelti",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Kopijuoti \u012f",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Kopijuoti",
            "dxFileManager-dialogRenameItemTitle": "Pervadinti",
            "dxFileManager-dialogRenameItemButtonText": "I\u0161saugoti",
            "dxFileManager-dialogCreateDirectoryTitle": "Naujas aplankas",
            "dxFileManager-dialogCreateDirectoryButtonText": "Sukurti",
            "dxFileManager-dialogDeleteItemTitle": "I\u0161trinti",
            "dxFileManager-dialogDeleteItemButtonText": "I\u0161trinti",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Ar tikrai norite i\u0161trinti {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Ar tikrai norite i\u0161trinti {0} elementus?",
            "dxFileManager-dialogButtonCancel": "At\u0161aukti",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Kuriamas aplankas viduje {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Sukurtas aplankas viduje {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "Aplankas nebuvo sukurtas",
            "dxFileManager-editingCreateCommonErrorMessage": "Aplankas nebuvo sukurtas",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Pervadinamas elementas viduje {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Pervadintas elementas viduje {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Elementas nebuvo pervadintas",
            "dxFileManager-editingRenameCommonErrorMessage": "Elementas nebuvo pervadintas",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Trinamas elementas i\u0161 {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "Trinamas {0} elementas i\u0161 {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "I\u0161trintas elementas i\u0161 {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "I\u0161trintas {0} elementas i\u0161 {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Elementas nebuvo i\u0161trintas",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} elementai nebuvo i\u0161trinti",
            "dxFileManager-editingDeleteCommonErrorMessage": "Dalis element\u0173 nebuvo i\u0161trinta",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Perkeliamas elementas \u012f {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "Perkeliami {0} elementai \u012f {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Perkeltas elementas \u012f {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "Perkelta {0} elementai \u012f {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Elementas nebuvo perkeltas",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} elementai nebuvo perkelti",
            "dxFileManager-editingMoveCommonErrorMessage": "Dali element\u0173 nebuvo perkelta",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Kopijuojamas elementas \u012f {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "Kopijuojama {0} elementai \u012f {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Perkopijuotas elementas \u012f {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Perkopijuota {0} elementai \u012f {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Elementas nebuvo perkopijuotas",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} elementai nebuvo perkopijuoti",
            "dxFileManager-editingCopyCommonErrorMessage": "Kai kurie elementai nebuvo perkopijuoti",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "\u012ekeliamas elementas \u012f {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "\u012ekeliama {0} elementai \u012f {0}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "\u012ekeltas elementas \u012f {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "\u012ekelta {0} elementai \u012f {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Elementas nebuvo \u012fkeltas",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} elementai nebuvo \u012fkelti",
            "dxFileManager-editingUploadCanceledMessage": "At\u0161aukta",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Item was not downloaded",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} items were not downloaded",
            "dxFileManager-listDetailsColumnCaptionName": "Pavadinimas",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Pakeitim\u0173 data",
            "dxFileManager-listDetailsColumnCaptionFileSize": "Bylos dydis",
            "dxFileManager-listThumbnailsTooltipTextSize": "Dydis",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Pakeitim\u0173 data",
            "dxFileManager-notificationProgressPanelTitle": "Progresas",
            "dxFileManager-notificationProgressPanelEmptyListText": "Veiksm\u0173 n\u0117ra",
            "dxFileManager-notificationProgressPanelOperationCanceled": "At\u0161aukta",
            "dxDiagram-categoryGeneral": "Bendra",
            "dxDiagram-categoryFlowchart": "Strukt\u016brin\u0117 schema",
            "dxDiagram-categoryOrgChart": "Organizacin\u0117 schema",
            "dxDiagram-categoryContainers": "Konteineriai",
            "dxDiagram-categoryCustom": "Vartotojo",
            "dxDiagram-commandExportToSvg": "Eksportuoti \u012f SVG",
            "dxDiagram-commandExportToPng": "Eksportuoti \u012f PNG",
            "dxDiagram-commandExportToJpg": "Eksportuoti \u012f JPEG",
            "dxDiagram-commandUndo": "Anuliuoti",
            "dxDiagram-commandRedo": "Perdaryti",
            "dxDiagram-commandFontName": "\u0160rifto pavadinimas",
            "dxDiagram-commandFontSize": "\u0160rifto dydis",
            "dxDiagram-commandBold": "Pary\u0161kintas",
            "dxDiagram-commandItalic": "Kursyvas",
            "dxDiagram-commandUnderline": "Pabraukta",
            "dxDiagram-commandTextColor": "\u0160rifto spalva",
            "dxDiagram-commandLineColor": "Linijos spalva",
            "dxDiagram-commandLineWidth": "Linijos plotis",
            "dxDiagram-commandLineStyle": "Linijos stilius",
            "dxDiagram-commandLineStyleSolid": "Vientisa",
            "dxDiagram-commandLineStyleDotted": "Punktyrin\u0117",
            "dxDiagram-commandLineStyleDashed": "Br\u016bk\u0161nin\u0117",
            "dxDiagram-commandFillColor": "U\u017epildo spalva",
            "dxDiagram-commandAlignLeft": "Lygiuoti \u012f kair\u0119",
            "dxDiagram-commandAlignCenter": "Lygiuoti centre",
            "dxDiagram-commandAlignRight": "Lygiuoti \u012f de\u0161in\u0119",
            "dxDiagram-commandConnectorLineType": "Sujungimo linijos tipas",
            "dxDiagram-commandConnectorLineStraight": "Tiesi",
            "dxDiagram-commandConnectorLineOrthogonal": "Sta\u010diakamp\u0117",
            "dxDiagram-commandConnectorLineStart": "Sujungimo linijos prad\u017eia",
            "dxDiagram-commandConnectorLineEnd": "Sujungimo linijos pabaiga",
            "dxDiagram-commandConnectorLineNone": "N\u0117ra",
            "dxDiagram-commandConnectorLineArrow": "Rodykl\u0117",
            "dxDiagram-commandFullscreen": "Visas ekranas",
            "dxDiagram-commandUnits": "Mato vienetai",
            "dxDiagram-commandPageSize": "Lapo dydis",
            "dxDiagram-commandPageOrientation": "Lapo orientacija",
            "dxDiagram-commandPageOrientationLandscape": "Peiza\u017eas",
            "dxDiagram-commandPageOrientationPortrait": "Portretas",
            "dxDiagram-commandPageColor": "Lapo spalva",
            "dxDiagram-commandShowGrid": "Rodyti tinklel\u012f",
            "dxDiagram-commandSnapToGrid": "Priri\u0161ta prie tinklelio",
            "dxDiagram-commandGridSize": "Tinklelio dydis",
            "dxDiagram-commandZoomLevel": "Priartinimo lygis",
            "dxDiagram-commandAutoZoom": "Automatinis priartinimas",
            "dxDiagram-commandFitToContent": "Prisitaikyti prie turinio",
            "dxDiagram-commandFitToWidth": "Prisitaikyti prie plo\u010dio",
            "dxDiagram-commandAutoZoomByContent": "Prisitaikyti prie turinio",
            "dxDiagram-commandAutoZoomByWidth": "Automatinis priartinimas pagal plot\u012f",
            "dxDiagram-commandSimpleView": "Paprastas rodinys",
            "dxDiagram-commandCut": "I\u0161kirpti",
            "dxDiagram-commandCopy": "Kopijuoti",
            "dxDiagram-commandPaste": "\u012eklijuoti",
            "dxDiagram-commandSelectAll": "Pasirinkti visk\u0105",
            "dxDiagram-commandDelete": "I\u0161trinti",
            "dxDiagram-commandBringToFront": "I\u0161kelti \u012f vir\u0161\u0173",
            "dxDiagram-commandSendToBack": "\u012e antr\u0105 plan\u0105",
            "dxDiagram-commandLock": "U\u017erakinti",
            "dxDiagram-commandUnlock": "Atrakinti",
            "dxDiagram-commandInsertShapeImage": "\u012eterpti paveiksl\u0117l\u012f...",
            "dxDiagram-commandEditShapeImage": "Pakeisti paveiksl\u0117l\u012f...",
            "dxDiagram-commandDeleteShapeImage": "I\u0161trinti paveiksl\u0117l\u012f",
            "dxDiagram-commandLayoutLeftToRight": "I\u0161 kair\u0117s \u012f de\u0161in\u0119",
            "dxDiagram-commandLayoutRightToLeft": "I\u0161 de\u0161in\u0117s \u012f kair\u0119",
            "dxDiagram-commandLayoutTopToBottom": "I\u0161 vir\u0161aus \u012f apa\u010di\u0105",
            "dxDiagram-commandLayoutBottomToTop": "I\u0161 apa\u010dios \u012f vir\u0161\u0173",
            "dxDiagram-unitIn": "in",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "Gerai",
            "dxDiagram-dialogButtonCancel": "At\u0161aukti",
            "dxDiagram-dialogInsertShapeImageTitle": "\u012eterpti paveiksl\u0117l\u012f",
            "dxDiagram-dialogEditShapeImageTitle": "Pakeisti paveiksl\u0117l\u012f",
            "dxDiagram-dialogEditShapeImageSelectButton": "Pasirinkti paveiksl\u0117l\u012f",
            "dxDiagram-dialogEditShapeImageLabelText": "arba numeskite bylas \u010dia",
            "dxDiagram-uiExport": "Eksportuoti",
            "dxDiagram-uiProperties": "Savyb\u0117s",
            "dxDiagram-uiSettings": "Nustatymai",
            "dxDiagram-uiShowToolbox": "Rodyti \u012franki\u0173 juost\u0105",
            "dxDiagram-uiSearch": "Paie\u0161ka",
            "dxDiagram-uiStyle": "Stilius",
            "dxDiagram-uiLayout": "I\u0161d\u0117stymas",
            "dxDiagram-uiLayoutTree": "Medis",
            "dxDiagram-uiLayoutLayered": "Sluoksniuotas",
            "dxDiagram-uiDiagram": "Diagrama",
            "dxDiagram-uiText": "Tekstas",
            "dxDiagram-uiObject": "Objektas",
            "dxDiagram-uiConnector": "Sujungimas",
            "dxDiagram-uiPage": "Lapas",
            "dxDiagram-shapeText": "Tekstas",
            "dxDiagram-shapeRectangle": "Sta\u010diakampis",
            "dxDiagram-shapeEllipse": "Elips\u0117",
            "dxDiagram-shapeCross": "Kry\u017eius",
            "dxDiagram-shapeTriangle": "Trikampis",
            "dxDiagram-shapeDiamond": "Rombas",
            "dxDiagram-shapeHeart": "\u0160irdis",
            "dxDiagram-shapePentagon": "Penkiakampis",
            "dxDiagram-shapeHexagon": "\u0160e\u0161iakampis",
            "dxDiagram-shapeOctagon": "A\u0161tuonkampis",
            "dxDiagram-shapeStar": "\u017dvaig\u017ed\u0117",
            "dxDiagram-shapeArrowLeft": "Rodykl\u0117 \u012f kair\u0119",
            "dxDiagram-shapeArrowUp": "Rodykl\u0117 \u012f vir\u0161\u0173",
            "dxDiagram-shapeArrowRight": "Rodykl\u0117 \u012f de\u0161in\u0119",
            "dxDiagram-shapeArrowDown": "Rodykl\u0117 \u012f apa\u010di\u0105",
            "dxDiagram-shapeArrowUpDown": "Rodykl\u0117 \u012f vir\u0161\u0173-apa\u010di\u0105",
            "dxDiagram-shapeArrowLeftRight": "Rodykl\u0117 \u012f kair\u0119-de\u0161in\u0119",
            "dxDiagram-shapeProcess": "Procesas",
            "dxDiagram-shapeDecision": "Sprendimas",
            "dxDiagram-shapeTerminator": "Pabaiga",
            "dxDiagram-shapePredefinedProcess": "Numatytas procesas",
            "dxDiagram-shapeDocument": "Dokumentas",
            "dxDiagram-shapeMultipleDocuments": "Dokumentai",
            "dxDiagram-shapeManualInput": "Rankinis \u012fvedimas",
            "dxDiagram-shapePreparation": "Pasiruo\u0161imas",
            "dxDiagram-shapeData": "Duomenys",
            "dxDiagram-shapeDatabase": "Duomen\u0173 baz\u0117",
            "dxDiagram-shapeHardDisk": "Kietasis diskas",
            "dxDiagram-shapeInternalStorage": "Vidin\u0117 atmintis",
            "dxDiagram-shapePaperTape": "Popierin\u0117 juosta",
            "dxDiagram-shapeManualOperation": "Rankinis veiksmas",
            "dxDiagram-shapeDelay": "Delsimas",
            "dxDiagram-shapeStoredData": "I\u0161saugoti duomenys",
            "dxDiagram-shapeDisplay": "Ekranas",
            "dxDiagram-shapeMerge": "Suliejimas",
            "dxDiagram-shapeConnector": "Sujungimas",
            "dxDiagram-shapeOr": "Arba",
            "dxDiagram-shapeSummingJunction": "Sumavimas",
            "dxDiagram-shapeContainerDefaultText": "Konteineris",
            "dxDiagram-shapeVerticalContainer": "Vertikalus konteineris",
            "dxDiagram-shapeHorizontalContainer": "Horizontalus konteineris",
            "dxDiagram-shapeCardDefaultText": "Asmens vardas",
            "dxDiagram-shapeCardWithImageOnLeft": "Kortel\u0117 su paveiksliuku kair\u0117je",
            "dxDiagram-shapeCardWithImageOnTop": "Kortel\u0117 su paveiksliuku vir\u0161uje",
            "dxDiagram-shapeCardWithImageOnRight": "Kortel\u0117 su paveiksliuku de\u0161in\u0117je",
            "dxGantt-dialogTitle": "Pavadinimas",
            "dxGantt-dialogStartTitle": "Prad\u017eia",
            "dxGantt-dialogEndTitle": "Pabaiga",
            "dxGantt-dialogProgressTitle": "Progresas",
            "dxGantt-dialogResourcesTitle": "Resursai",
            "dxGantt-dialogResourceManagerTitle": "Resurs\u0173 vadovas",
            "dxGantt-dialogTaskDetailsTitle": "U\u017eduoties informacija",
            "dxGantt-dialogEditResourceListHint": "Redaguoti resurs\u0173 s\u0105ra\u0161\u0105",
            "dxGantt-dialogEditNoResources": "N\u0117ra resurs\u0173",
            "dxGantt-dialogButtonAdd": "Prid\u0117ti",
            "dxGantt-contextMenuNewTask": "Nauja u\u017eduotis",
            "dxGantt-contextMenuNewSubtask": "Nauja dalin\u0117 u\u017eduotis",
            "dxGantt-contextMenuDeleteTask": "I\u0161trinti u\u017eduot\u012f",
            "dxGantt-contextMenuDeleteDependency": "I\u0161trinti priklausomyb\u0119",
            "dxGantt-dialogTaskDeleteConfirmation": "I\u0161trynus u\u017eduot\u012f taip pat i\u0161trinamos visos jos priklausomyb\u0117s ir dalin\u0117s u\u017eduotys. Ar tikrai norite i\u0161trinti \u0161i\u0105 u\u017eduot\u012f?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Ar tikrai norite i\u0161trinti priklausomyb\u0119 i\u0161 u\u017eduoties?",
            "dxGantt-dialogResourcesDeleteConfirmation": "I\u0161trynus resurs\u0105 jis taip pat i\u0161trinamas i\u0161 u\u017eduo\u010di\u0173, kurioms \u0161is resursas priskirtas. Ar tikrai norite i\u0161trinti \u0161iuos resursus? Resursai: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "U\u017eduotis, kuri\u0105 bandote perkelti, yra susieta su kita u\u017eduotimi priklausomyb\u0117s ry\u0161iu. \u0160is pakeitimas prie\u0161taraut\u0173 priklausomyb\u0117s taisykl\u0117ms. Kaip nor\u0117tum\u0117te t\u0119sti?",
            "dxGantt-dialogConstraintViolationMessage": "U\u017eduotis, kuri\u0105 bandote perkelti, yra susieta su kita u\u017eduotimi priklausomyb\u0117s ry\u0161iu. Kaip nor\u0117tum\u0117te t\u0119sti?",
            "dxGantt-dialogCancelOperationMessage": "At\u0161aukti veiksm\u0105",
            "dxGantt-dialogDeleteDependencyMessage": "I\u0161trinti priklausomyb\u0119",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Perkelti u\u017eduot\u012f ir i\u0161saugoti priklausomyb\u0119",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. How would you like to proceed?",
            "dxGantt-dialogDeleteDependenciesMessage": "Delete the dependency relations",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Move the task and keep the dependencies",
            "dxGantt-undo": "Anuliuoti",
            "dxGantt-redo": "Perdaryti",
            "dxGantt-expandAll": "I\u0161skleisti visk\u0105",
            "dxGantt-collapseAll": "Suskleisti visk\u0105",
            "dxGantt-addNewTask": "Prid\u0117ti papildom\u0105 u\u017eduot\u012f",
            "dxGantt-deleteSelectedTask": "I\u0161trinti pasirinkt\u0105 u\u017eduot\u012f",
            "dxGantt-zoomIn": "Priartinti",
            "dxGantt-zoomOut": "Nutolinti",
            "dxGantt-fullScreen": "Visas ekranas",
            "dxGantt-quarter": "{0}-ketv.",
            "dxGantt-sortingAscendingText": "R\u016b\u0161iuoti did\u0117jan\u010diai",
            "dxGantt-sortingDescendingText": "R\u016b\u0161iuoti ma\u017e\u0117jan\u010diai",
            "dxGantt-sortingClearText": "Ner\u016b\u0161iuoti",
            "dxGantt-showResources": "Rodyti resursus",
            "dxGantt-showDependencies": "Rodyti priklausomybes",
            "dxGantt-dialogStartDateValidation": "Prad\u017eios data turi b\u016bti po {0}",
            "dxGantt-dialogEndDateValidation": "Pabaigos data turi b\u016bti po {0}",
            "dxGallery-itemName": "Gallery item",
            "dxMultiView-elementAriaRoleDescription": "MultiView",
            "dxMultiView-elementAriaLabel": "Use the arrow keys or swipe to navigate between views",
            "dxMultiView-itemAriaRoleDescription": "View",
            "dxMultiView-itemAriaLabel": "{0} of {1}",
            "dxSplitter-resizeHandleAriaLabel": "Split bar"
        }
    })
}));
