/*!
* DevExtreme (dx.messages.el.js)
* Version: 24.2.3-build-24326-1309
* Build date: Thu Nov 21 2024
*
* Copyright (c) 2012 - 2024 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        el: {
            Yes: "\u039d\u03b1\u03af",
            No: "\u038c\u03c7\u03b9",
            Cancel: "\u0391\u03ba\u03cd\u03c1\u03c9\u03c3\u03b7",
            CheckState: "Check state",
            Close: "\u039a\u03bb\u03b5\u03af\u03c3\u03b9\u03bc\u03bf",
            Clear: "\u0395\u03ba\u03ba\u03b1\u03b8\u03ac\u03c1\u03b9\u03c3\u03b7",
            Done: "\u039a\u03b1\u03c4\u03b1\u03c7\u03ce\u03c1\u03b7\u03c3\u03b7",
            Loading: "\u03a6\u03cc\u03c1\u03c4\u03c9\u03c3\u03b7",
            Select: "\u0395\u03c0\u03b9\u03bb\u03ad\u03be\u03c4\u03b5...",
            Search: "\u0391\u03bd\u03b1\u03b6\u03ae\u03c4\u03b7\u03c3\u03b7",
            Back: "\u03a0\u03af\u03c3\u03c9",
            OK: "\u039f\u039a",
            Today: "\u03a3\u03ae\u03bc\u03b5\u03c1\u03b1",
            Yesterday: "Yesterday",
            "dxCollectionWidget-noDataText": "\u0394\u03b5\u03bd \u03c5\u03c0\u03ac\u03c1\u03c7\u03bf\u03c5\u03bd \u03b4\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03b1 \u03c0\u03c1\u03bf\u03c2 \u03b5\u03bc\u03c6\u03ac\u03bd\u03b9\u03c3\u03b7",
            "dxDropDownEditor-selectLabel": "\u0395\u03c0\u03b9\u03bb\u03ad\u03be\u03c4\u03b5",
            "validation-required": "\u0391\u03c0\u03b1\u03b9\u03c4\u03b5\u03af\u03c4\u03b1\u03b9 \u03c3\u03c5\u03bc\u03c0\u03bb\u03ae\u03c1\u03c9\u03c3\u03b7",
            "validation-required-formatted": "{0} \u03b5\u03af\u03bd\u03b1\u03b9 \u03b1\u03c0\u03b1\u03b9\u03c4\u03bf\u03cd\u03bc\u03b5\u03bd\u03bf \u03c0\u03c1\u03bf\u03c2 \u03c3\u03c5\u03bc\u03c0\u03bb\u03ae\u03c1\u03c9\u03c3\u03b7",
            "validation-numeric": "\u0397 \u03c4\u03b9\u03bc\u03ae \u03c4\u03bf\u03c5 \u03c0\u03b5\u03b4\u03af\u03bf\u03c5 \u03c0\u03c1\u03ad\u03c0\u03b5\u03b9 \u03bd\u03b1 \u03b5\u03af\u03bd\u03b1\u03b9 \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ae",
            "validation-numeric-formatted": "\u03a4\u03bf \u03c0\u03b5\u03b4\u03af\u03bf {0} \u03c0\u03c1\u03ad\u03c0\u03b5\u03b9 \u03bd\u03b1 \u03c0\u03b5\u03c1\u03b9\u03ad\u03c7\u03b5\u03b9 \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ae \u03c4\u03b9\u03bc\u03ae",
            "validation-range": "\u03a4\u03b9\u03bc\u03ae \u03b5\u03ba\u03c4\u03cc\u03c2 \u03bf\u03c1\u03af\u03c9\u03bd",
            "validation-range-formatted": "\u0397 \u03c4\u03b9\u03bc\u03ae \u03c4\u03bf\u03c5 \u03c0\u03b5\u03b4\u03af\u03bf\u03c5 {0} \u03b2\u03c1\u03b9\u03c3\u03ba\u03b5\u03c4\u03b1\u03b9 \u03b5\u03ba\u03c4\u03cc\u03c2 \u03bf\u03c1\u03af\u03c9\u03bd",
            "validation-stringLength": "\u03a4\u03bf \u03bc\u03ae\u03ba\u03bf\u03c2 \u03c4\u03b7\u03c2 \u03c4\u03b9\u03bc\u03ae\u03c2 \u03c0\u03bf\u03c5 \u03b5\u03b9\u03c3\u03ac\u03b3\u03b1\u03c4\u03b5 \u03b5\u03af\u03bd\u03b1\u03b9 \u03b5\u03ba\u03c4\u03cc\u03c2 \u03bf\u03c1\u03af\u03c9\u03bd",
            "validation-stringLength-formatted": "\u03a4\u03bf \u03bc\u03ae\u03ba\u03bf\u03c2 \u03c4\u03b7\u03c2 \u03c4\u03b9\u03bc\u03ae\u03c2 \u03c4\u03bf\u03c5 \u03c0\u03b5\u03b4\u03af\u03bf\u03c5 {0} \u03b4\u03b5\u03bd \u03b5\u03af\u03bd\u03b1\u03b9 \u03c3\u03c9\u03c3\u03c4\u03cc",
            "validation-custom": "\u0397 \u03c4\u03b9\u03bc\u03ae \u03b5\u03af\u03bd\u03b1\u03b9 \u03ac\u03ba\u03c5\u03c1\u03b7",
            "validation-custom-formatted": "\u0397 \u03c4\u03b9\u03bc\u03ae \u03c4\u03bf\u03c5 \u03c0\u03b5\u03b4\u03af\u03bf\u03c5 {0} \u03b5\u03af\u03bd\u03b1\u03b9 \u03ac\u03ba\u03c5\u03c1\u03b7",
            "validation-async": "\u0397 \u03c4\u03b9\u03bc\u03ae \u03b5\u03af\u03bd\u03b1\u03b9 \u03ac\u03ba\u03c5\u03c1\u03b7",
            "validation-async-formatted": "\u0397 \u03c4\u03b9\u03bc\u03ae \u03c4\u03bf\u03c5 \u03c0\u03b5\u03b4\u03af\u03bf\u03c5 {0} \u03b5\u03af\u03bd\u03b1\u03b9 \u03ac\u03ba\u03c5\u03c1\u03b7",
            "validation-compare": "\u039f\u03b9 \u03c4\u03b9\u03bc\u03ad\u03c2 \u03b4\u03b5\u03bd \u03c4\u03b1\u03b9\u03c1\u03b9\u03ac\u03b6\u03bf\u03c5\u03bd",
            "validation-compare-formatted": "\u0397 \u03c4\u03b9\u03bc\u03ae \u03c4\u03bf\u03c5 \u03c0\u03b5\u03b4\u03af\u03bf\u03c5 {0} \u03b4\u03b5\u03bd \u03c4\u03b1\u03b9\u03c1\u03b9\u03ac\u03b6\u03b5\u03b9",
            "validation-pattern": "\u0397 \u03c4\u03b9\u03bc\u03b7 \u03b4\u03b5\u03bd \u03b5\u03af\u03bd\u03b1\u03b9 \u03b7 \u03b1\u03bd\u03b1\u03bc\u03b5\u03bd\u03cc\u03bc\u03b5\u03bd\u03b7",
            "validation-pattern-formatted": "\u0397 \u03c4\u03b9\u03bc\u03ae \u03c4\u03bf\u03c5 \u03c0\u03b5\u03b4\u03af\u03bf\u03c5 {0} \u03b4\u03b5\u03bd \u03b5\u03b9\u03bd\u03b1\u03b9 \u03b7 \u03b1\u03bd\u03b1\u03bc\u03b5\u03bd\u03cc\u03bc\u03b5\u03bd\u03b7",
            "validation-email": "\u03a4\u03bf Email \u03b5\u03af\u03bd\u03b1\u03b9 \u03ac\u03ba\u03c5\u03c1\u03bf",
            "validation-email-formatted": "\u0397 \u03c4\u03b9\u03bc\u03ae \u03c4\u03bf\u03c5 \u03c0\u03b5\u03b4\u03af\u03bf\u03c5 {0} \u03b5\u03af\u03bd\u03b1\u03b9 \u03ac\u03ba\u03c5\u03c1\u03b7",
            "validation-mask": "\u0397 \u03c4\u03b9\u03bc\u03ae \u03b5\u03af\u03bd\u03b1\u03b9 \u03ac\u03ba\u03c5\u03c1\u03b7",
            "dxLookup-searchPlaceholder": "\u0395\u03bb\u03ac\u03c7\u03b9\u03c3\u03c4\u03bf\u03c2 \u03b1\u03c1\u03b9\u03b8\u03bc\u03cc\u03c2 \u03c7\u03b1\u03c1\u03b1\u03ba\u03c4\u03ae\u03c1\u03c9\u03bd: {0}",
            "dxList-pullingDownText": "\u03a3\u03cd\u03c1\u03b5\u03c4\u03b5 \u03b1\u03c0\u03bf \u03c0\u03ac\u03bd\u03c9 \u03c0\u03c1\u03bf\u03c2 \u03c4\u03b1 \u03ba\u03ac\u03c4\u03c9 \u03b3\u03b9\u03b1 \u03b1\u03bd\u03b1\u03bd\u03ad\u03c9\u03c3\u03b7...",
            "dxList-pulledDownText": "\u0391\u03c0\u03b5\u03bb\u03b5\u03c5\u03b8\u03b5\u03c1\u03ce\u03c3\u03c4\u03b5 \u03b3\u03b9\u03b1 \u03b1\u03bd\u03b1\u03bd\u03ad\u03c9\u03c3\u03b7...",
            "dxList-refreshingText": "\u0391\u03bd\u03b1\u03bd\u03ad\u03c9\u03c3\u03b7...",
            "dxList-pageLoadingText": "\u03a6\u03cc\u03c1\u03c4\u03c9\u03c3\u03b7...",
            "dxList-nextButtonText": "\u03a0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03b1",
            "dxList-selectAll": "\u0395\u03c0\u03b9\u03bb\u03bf\u03b3\u03ae \u03cc\u03bb\u03c9\u03bd",
            "dxList-listAriaLabel": "Items",
            "dxList-listAriaLabel-deletable": "Deletable items",
            "dxListEditDecorator-delete": "\u0394\u03b9\u03b1\u03b3\u03c1\u03b1\u03c6\u03ae",
            "dxListEditDecorator-more": "\u03a0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03b1",
            "dxList-selectAll-indeterminate": "Half-checked",
            "dxList-selectAll-checked": "Checked",
            "dxList-selectAll-notChecked": "Not checked",
            "dxScrollView-pullingDownText": "\u03a3\u03cd\u03c1\u03b5\u03c4\u03b5 \u03b1\u03c0\u03bf \u03c0\u03ac\u03bd\u03c9 \u03c0\u03c1\u03bf\u03c2 \u03c4\u03b1 \u03ba\u03ac\u03c4\u03c9 \u03b3\u03b9\u03b1 \u03b1\u03bd\u03b1\u03bd\u03ad\u03c9\u03c3\u03b7...",
            "dxScrollView-pulledDownText": "\u0391\u03c0\u03b5\u03bb\u03b5\u03c5\u03b8\u03b5\u03c1\u03ce\u03c3\u03c4\u03b5 \u03b3\u03b9\u03b1 \u03b1\u03bd\u03b1\u03bd\u03ad\u03c9\u03c3\u03b7...",
            "dxScrollView-refreshingText": "\u0391\u03bd\u03b1\u03bd\u03ad\u03c9\u03c3\u03b7...",
            "dxScrollView-reachBottomText": "\u03a6\u03cc\u03c1\u03c4\u03c9\u03c3\u03b7...",
            "dxDateBox-simulatedDataPickerTitleTime": "\u0395\u03c0\u03b9\u03bb\u03ad\u03be\u03c4\u03b5 \u03ce\u03c1\u03b1",
            "dxDateBox-simulatedDataPickerTitleDate": "\u0395\u03c0\u03b9\u03bb\u03ad\u03be\u03c4\u03b5 \u03b7\u03bc\u03b5\u03c1\u03bf\u03bc\u03b7\u03bd\u03af\u03b1",
            "dxDateBox-simulatedDataPickerTitleDateTime": "\u0395\u03c0\u03b9\u03bb\u03ad\u03be\u03c4\u03b5 \u03ce\u03c1\u03b1 \u03ba\u03b1\u03b9 \u03b7\u03bc\u03b5\u03c1\u03bf\u03bc\u03b7\u03bd\u03af\u03b1",
            "dxDateBox-validation-datetime": "\u0397 \u03c4\u03b9\u03bc\u03ae \u03c0\u03c1\u03ad\u03c0\u03b5\u03b9 \u03bd\u03b1 \u03b1\u03bd\u03b1\u03c0\u03b1\u03c1\u03b9\u03c3\u03c4\u03ac \u03b7\u03bc\u03b5\u03c1\u03bf\u03bc\u03b7\u03bd\u03af\u03b1",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "\u0397\u03bc\u03b5\u03c1\u03bf\u03bc\u03b7\u03bd\u03af\u03b1 \u03ad\u03bd\u03b1\u03c1\u03be\u03b7\u03c2",
            "dxDateRangeBox-endDateLabel": "\u0397\u03bc\u03b5\u03c1\u03bf\u03bc\u03b7\u03bd\u03af\u03b1 \u03bb\u03ae\u03be\u03b7\u03c2",
            "dxFileUploader-selectFile": "\u0395\u03c0\u03b9\u03bb\u03ad\u03be\u03c4\u03b5 \u03b1\u03c1\u03c7\u03b5\u03af\u03bf",
            "dxFileUploader-dropFile": "\u03ae \u03c3\u03cd\u03c1\u03b5\u03c4\u03b5 \u03c4\u03bf \u03b1\u03c1\u03c7\u03b5\u03af\u03bf \u03b5\u03b4\u03ce",
            "dxFileUploader-bytes": "bytes",
            "dxFileUploader-kb": "KB",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "\u039c\u03b5\u03c4\u03b1\u03c6\u03cc\u03c1\u03c4\u03c9\u03c3\u03b7",
            "dxFileUploader-uploaded": "\u039c\u03b5\u03c4\u03b1\u03c6\u03bf\u03c1\u03c4\u03ce\u03b8\u03b7\u03ba\u03b5",
            "dxFileUploader-readyToUpload": "\u0388\u03c4\u03bf\u03b9\u03bc\u03bf \u03c0\u03c1\u03bf\u03c2 \u03bc\u03b5\u03c4\u03b1\u03c6\u03cc\u03c1\u03c4\u03c9\u03c3\u03b7",
            "dxFileUploader-uploadAbortedMessage": "Upload cancelled",
            "dxFileUploader-uploadFailedMessage": "\u0397 \u03bc\u03b5\u03c4\u03b1\u03c6\u03cc\u03c1\u03c4\u03c9\u03c3\u03b7 \u03b1\u03c0\u03ad\u03c4\u03c5\u03c7\u03b5",
            "dxFileUploader-invalidFileExtension": "\u039f \u03c4\u03c5\u03c0\u03bf\u03c2 \u03c4\u03bf\u03c5 \u03b1\u03c1\u03c7\u03b5\u03af\u03bf\u03c5 \u03b4\u03b5\u03bd \u03b5\u03af\u03bd\u03b1\u03b9 \u03b5\u03c0\u03b9\u03c4\u03c1\u03b5\u03c0\u03c4\u03cc\u03c2",
            "dxFileUploader-invalidMaxFileSize": "\u03a4\u03bf \u03b1\u03c1\u03c7\u03b5\u03af\u03bf \u03b5\u03af\u03bd\u03b1\u03b9 \u03c0\u03bf\u03bb\u03cd \u03bc\u03b5\u03b3\u03ac\u03bb\u03bf",
            "dxFileUploader-invalidMinFileSize": "\u03a4\u03bf \u03b1\u03c1\u03c7\u03b5\u03b9\u03bf \u03b5\u03af\u03bd\u03b1\u03b9 \u03c0\u03bf\u03bb\u03c5 \u03bc\u03b9\u03ba\u03c1\u03cc",
            "dxRangeSlider-ariaFrom": "\u0391\u03c0\u03cc",
            "dxRangeSlider-ariaTill": "\u0395\u03ce\u03c2",
            "dxSwitch-switchedOnText": "ON",
            "dxSwitch-switchedOffText": "OFF",
            "dxForm-optionalMark": "\u03a0\u03c1\u03bf\u03b1\u03b9\u03c1\u03b5\u03c4\u03b9\u03ba\u03cc",
            "dxForm-requiredMessage": "\u03a4\u03bf \u03c0\u03b5\u03b4\u03af\u03bf {0} \u03b5\u03af\u03bd\u03b1\u03b9 \u03b1\u03c0\u03b1\u03b9\u03c4\u03bf\u03cd\u03bc\u03b5\u03bd\u03bf",
            "dxNumberBox-invalidValueMessage": "\u0397 \u03c4\u03b9\u03bc\u03ae \u03c0\u03c1\u03ad\u03c0\u03b5\u03b9 \u03bd\u03b1 \u03b5\u03af\u03bd\u03b1\u03b9 \u03b1\u03c1\u03b9\u03b8\u03bc\u03b7\u03c4\u03b9\u03ba\u03ae",
            "dxNumberBox-noDataText": "\u0394\u03b5\u03bd \u03c5\u03c0\u03ac\u03c1\u03c7\u03bf\u03c5\u03bd \u03b4\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03b1",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} to display columns",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Drag a column from the group panel here",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} or drag a column from the group panel",
            "dxDataGrid-emptyHeaderColumnChooserText": "column chooser",
            "dxDataGrid-columnChooserTitle": "\u0395\u03c0\u03b9\u03bb\u03bf\u03b3\u03ad\u03b1\u03c2 \u03c3\u03c4\u03ae\u03bb\u03b7\u03c2",
            "dxDataGrid-columnChooserEmptyText": "\u03a3\u03cd\u03c1\u03b5\u03c4\u03b5 \u03bc\u03b9\u03b1 \u03c3\u03c4\u03ae\u03bb\u03b7 \u03b5\u03b4\u03ce \u03b3\u03b9\u03b1 \u03bd\u03b1 \u03c4\u03b7\u03bd \u03ba\u03c1\u03cd\u03c8\u03b5\u03c4\u03b5",
            "dxDataGrid-groupContinuesMessage": "\u03a3\u03c5\u03bd\u03ad\u03c7\u03b5\u03b9\u03b1 \u03c3\u03c4\u03b7\u03bd \u03b5\u03c0\u03cc\u03bc\u03b5\u03bd\u03b7 \u03c3\u03b5\u03bb\u03af\u03b4\u03b1",
            "dxDataGrid-groupContinuedMessage": "\u03a3\u03c5\u03bd\u03ad\u03c7\u03b5\u03b9\u03b1 \u03b1\u03c0\u03bf \u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03b7 \u03c3\u03b5\u03bb\u03af\u03b4\u03b1",
            "dxDataGrid-groupHeaderText": "\u039f\u03bc\u03b1\u03b4\u03bf\u03c0\u03bf\u03af\u03b7\u03c3\u03b7 \u03b1\u03c0\u03bf \u03b1\u03c5\u03c4\u03ae \u03c4\u03b7\u03bd \u03c3\u03c4\u03ae\u03bb\u03b7",
            "dxDataGrid-ungroupHeaderText": "\u0391\u03c0\u03cc\u03c3\u03c0\u03b1\u03c3\u03b7",
            "dxDataGrid-ungroupAllText": "\u0391\u03c0\u03cc\u03c3\u03c0\u03b1\u03c3\u03b7 \u03cc\u03bb\u03c9\u03bd",
            "dxDataGrid-editingEditRow": "\u0395\u03c0\u03b5\u03be\u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1",
            "dxDataGrid-editingSaveRowChanges": "\u0391\u03c0\u03bf\u03b8\u03ae\u03ba\u03b5\u03c5\u03c3\u03b7",
            "dxDataGrid-editingCancelRowChanges": "\u0391\u03ba\u03cd\u03c1\u03c9\u03c3\u03b7",
            "dxDataGrid-editingDeleteRow": "\u0394\u03b9\u03b1\u03b3\u03c1\u03b1\u03c6\u03ae",
            "dxDataGrid-editingUndeleteRow": "\u0391\u03bd\u03ac\u03ba\u03c4\u03b7\u03c3\u03b7 \u03b4\u03b9\u03b1\u03b3\u03c1\u03b1\u03c6\u03ae\u03c2",
            "dxDataGrid-editingConfirmDeleteMessage": "\u0395\u03af\u03c3\u03c4\u03b5 \u03c3\u03af\u03b3\u03bf\u03c5\u03c1\u03bf\u03b9 \u03c0\u03c9\u03c2 \u03b8\u03ad\u03bb\u03b5\u03c4\u03b5 \u03c4\u03b7\u03bd \u03b4\u03b9\u03b1\u03b3\u03c1\u03b1\u03c6\u03ae \u03b1\u03c5\u03c4\u03ae\u03c2 \u03c4\u03b7\u03c2 \u03b5\u03b3\u03b3\u03c1\u03b1\u03c6\u03ae\u03c2;",
            "dxDataGrid-validationCancelChanges": "\u0391\u03ba\u03cd\u03c1\u03c9\u03c3\u03b7 \u03b1\u03bb\u03bb\u03b1\u03b3\u03ce\u03bd",
            "dxDataGrid-groupPanelEmptyText": "\u03a3\u03cd\u03c1\u03b5\u03c4\u03b5 \u03bc\u03b9\u03b1 \u03c3\u03c4\u03ae\u03bb\u03b7 \u03b5\u03b4\u03ce \u03b3\u03b9\u03b1 \u03bd\u03b1 \u03bf\u03bc\u03b1\u03b4\u03bf\u03c0\u03bf\u03b9\u03ae\u03c3\u03b5\u03c4\u03b5 \u03bc\u03b5 \u03b2\u03ac\u03c3\u03b7 \u03b1\u03c5\u03c4\u03ae",
            "dxDataGrid-noDataText": "\u0394\u03b5\u03bd \u03c5\u03c0\u03ac\u03c1\u03c7\u03bf\u03c5\u03bd \u03b4\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03b1",
            "dxDataGrid-searchPanelPlaceholder": "\u0391\u03bd\u03b1\u03b6\u03ae\u03c4\u03b7\u03c3\u03b7...",
            "dxDataGrid-filterRowShowAllText": "(\u038c\u03bb\u03b1)",
            "dxDataGrid-filterRowResetOperationText": "\u0395\u03c0\u03b1\u03bd\u03b1\u03c6\u03bf\u03c1\u03ac",
            "dxDataGrid-filterRowOperationEquals": "\u0399\u03c3\u03bf\u03cd\u03c4\u03b1\u03b9",
            "dxDataGrid-filterRowOperationNotEquals": "\u0394\u03b9\u03b1\u03c6\u03ad\u03c1\u03b5\u03b9",
            "dxDataGrid-filterRowOperationLess": "\u039c\u03b9\u03ba\u03c1\u03cc\u03c4\u03b5\u03c1\u03bf \u03b1\u03c0\u03cc",
            "dxDataGrid-filterRowOperationLessOrEquals": "\u039c\u03b9\u03ba\u03c1\u03cc\u03c4\u03b5\u03c1\u03bf \u03af\u03c3\u03bf \u03b1\u03c0\u03cc",
            "dxDataGrid-filterRowOperationGreater": "\u039c\u03b5\u03b3\u03b1\u03bb\u03cd\u03c4\u03b5\u03c1\u03bf \u03b1\u03c0\u03cc",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "\u039c\u03b5\u03b3\u03b1\u03bb\u03cd\u03c4\u03b5\u03c1\u03bf \u03af\u03c3\u03bf \u03b1\u03c0\u03cc",
            "dxDataGrid-filterRowOperationStartsWith": "\u039e\u03b5\u03ba\u03b9\u03bd\u03ac\u03b5\u03b9 \u03bc\u03b5",
            "dxDataGrid-filterRowOperationContains": "\u03a0\u03b5\u03c1\u03b9\u03ad\u03c7\u03b5\u03b9",
            "dxDataGrid-filterRowOperationNotContains": "\u0394\u03b5\u03bd \u03c0\u03b5\u03c1\u03b9\u03ad\u03c7\u03b5\u03b9",
            "dxDataGrid-filterRowOperationEndsWith": "\u03a4\u03b5\u03bb\u03b5\u03b9\u03ce\u03bd\u03b5\u03b9 \u03bc\u03b5",
            "dxDataGrid-filterRowOperationBetween": "\u0391\u03bd\u03ac\u03bc\u03b5\u03c3\u03b1",
            "dxDataGrid-filterRowOperationBetweenStartText": "\u0395\u03ba\u03ba\u03af\u03bd\u03b7\u03c3\u03b7",
            "dxDataGrid-filterRowOperationBetweenEndText": "\u03a4\u03ad\u03bb\u03bf\u03c2",
            "dxDataGrid-ariaSearchBox": "Search box",
            "dxDataGrid-applyFilterText": "\u0395\u03b9\u03c3\u03b1\u03b3\u03c9\u03b3\u03ae \u03c6\u03af\u03bb\u03c4\u03c1\u03bf\u03c5",
            "dxDataGrid-trueText": "\u0391\u03bb\u03b7\u03b8\u03ad\u03c2",
            "dxDataGrid-falseText": "\u03a8\u03b5\u03c5\u03b4\u03ad\u03c2",
            "dxDataGrid-sortingAscendingText": "\u03a4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7 \u03b1\u03cd\u03be\u03bf\u03c5\u03c3\u03b1",
            "dxDataGrid-sortingDescendingText": "\u03a4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7 \u03c6\u03b8\u03ae\u03bd\u03bf\u03c5\u03c3\u03b1",
            "dxDataGrid-sortingClearText": "\u0395\u03ba\u03ba\u03b1\u03b8\u03ac\u03c1\u03b9\u03c3\u03b7 \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b9\u03c3\u03b7\u03c2",
            "dxDataGrid-ariaNotSortedColumn": "Not sorted column",
            "dxDataGrid-ariaSortedAscendingColumn": "Column sorted in ascending order",
            "dxDataGrid-ariaSortedDescendingColumn": "Column sorted in descending order",
            "dxDataGrid-ariaSortIndex": "Sort index {0}",
            "dxDataGrid-editingSaveAllChanges": "\u0391\u03c0\u03bf\u03b8\u03ae\u03ba\u03b5\u03c5\u03c3\u03b7 \u03b1\u03bb\u03bb\u03b1\u03b3\u03ce\u03bd",
            "dxDataGrid-editingCancelAllChanges": "\u0391\u03c0\u03cc\u03c1\u03c1\u03b9\u03c8\u03b7 \u03b1\u03bb\u03bb\u03b1\u03b3\u03ce\u03bd",
            "dxDataGrid-editingAddRow": "\u03a0\u03c1\u03bf\u03c3\u03b8\u03ae\u03ba\u03b7 \u03b3\u03c1\u03b1\u03bc\u03bc\u03ae\u03c2",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Min of {1} is {0}",
            "dxDataGrid-summaryMax": "Max: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "Max of {1} is {0}",
            "dxDataGrid-summaryAvg": "Avg: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "Avg of {1} is {0}",
            "dxDataGrid-summarySum": "Sum: {0}",
            "dxDataGrid-summarySumOtherColumn": "Sum of {1} is {0}",
            "dxDataGrid-summaryCount": "\u03a0\u03bf\u03c3\u03cc\u03c4\u03b7\u03c4\u03b1: {0}",
            "dxDataGrid-columnFixingFix": "Set Fixed Position",
            "dxDataGrid-columnFixingUnfix": "Unfix",
            "dxDataGrid-columnFixingLeftPosition": "Left",
            "dxDataGrid-columnFixingRightPosition": "Right",
            "dxDataGrid-columnFixingStickyPosition": "Sticky",
            "dxDataGrid-exportTo": "\u0395\u03be\u03b1\u03b3\u03c9\u03b3\u03ae",
            "dxDataGrid-exportToExcel": "\u0395\u03be\u03b1\u03b3\u03c9\u03b3\u03ae \u03c3\u03b5 Excel",
            "dxDataGrid-exporting": "\u0395\u03be\u03b1\u03b3\u03c9\u03b3\u03ae...",
            "dxDataGrid-excelFormat": "\u0391\u03c1\u03c7\u03b5\u03af\u03bf Excel",
            "dxDataGrid-selectedRows": "\u0395\u03c0\u03b9\u03bb\u03b5\u03b3\u03bc\u03ad\u03bd\u03b5\u03c2 \u03b3\u03c1\u03b1\u03bc\u03bc\u03ad\u03c2",
            "dxDataGrid-exportSelectedRows": "\u0395\u03be\u03b1\u03b3\u03c9\u03b3\u03ae \u03b5\u03c0\u03b9\u03bb\u03b5\u03b3\u03bc\u03ad\u03bd\u03c9\u03bd \u03b3\u03c1\u03b1\u03bc\u03bc\u03ce\u03bd",
            "dxDataGrid-exportAll": "\u0395\u03be\u03b1\u03b3\u03c9\u03b3\u03ae \u03cc\u03bb\u03c9\u03bd \u03c4\u03c9\u03bd \u03b4\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03c9\u03bd",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Show filter options for column '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(Blanks)",
            "dxDataGrid-headerFilterOK": "OK",
            "dxDataGrid-headerFilterCancel": "\u0391\u03ba\u03cd\u03c1\u03c9\u03c3\u03b7",
            "dxDataGrid-ariaAdaptiveCollapse": "Hide additional data",
            "dxDataGrid-ariaAdaptiveExpand": "Display additional data",
            "dxDataGrid-ariaColumn": "\u03a3\u03c4\u03ae\u03bb\u03b7",
            "dxDataGrid-ariaColumnHeader": "Column header",
            "dxDataGrid-ariaValue": "\u03a4\u03b9\u03bc\u03ae",
            "dxDataGrid-ariaError": "Error",
            "dxDataGrid-ariaRevertButton": "Press Escape to discard the changes",
            "dxDataGrid-ariaFilterCell": "\u03a6\u03b9\u03bb\u03c4\u03c1\u03ac\u03c1\u03b9\u03c3\u03bc\u03b1 \u03ba\u03b5\u03bb\u03b9\u03bf\u03cd",
            "dxDataGrid-ariaCollapse": "\u03a3\u03c5\u03c1\u03c1\u03af\u03ba\u03bd\u03c9\u03c3\u03b7",
            "dxDataGrid-ariaModifiedCell": "Modified",
            "dxDataGrid-ariaDeletedCell": "Deleted",
            "dxDataGrid-ariaEditableCell": "Editable",
            "dxDataGrid-ariaExpand": "\u0395\u03c0\u03ad\u03ba\u03c4\u03b1\u03c3\u03b7",
            "dxDataGrid-ariaCollapsedRow": "Collapsed row",
            "dxDataGrid-ariaExpandedRow": "Expanded row",
            "dxDataGrid-ariaDataGrid": "\u03a0\u03bb\u03ad\u03b3\u03bc\u03b1 \u03b4\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03c9\u03bd",
            "dxDataGrid-ariaSearchInGrid": "\u0391\u03bd\u03b1\u03b6\u03ae\u03c4\u03b7\u03c3\u03b7 \u03c3\u03c4\u03bf \u03c0\u03bb\u03ad\u03b3\u03bc\u03b1 \u03b4\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03c9\u03bd",
            "dxDataGrid-ariaSelectAll": "\u0395\u03c0\u03b9\u03bb\u03bf\u03b3\u03ae \u03cc\u03bb\u03c9\u03bd",
            "dxDataGrid-ariaSelectRow": "\u0395\u03c0\u03b9\u03bb\u03ad\u03be\u03c4\u03b5 \u03c3\u03b5\u03b9\u03c1\u03ac",
            "dxDataGrid-ariaToolbar": "Data grid toolbar",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "\u0394\u03b7\u03bc\u03b9\u03bf\u03c5\u03c1\u03b3\u03af\u03b1 \u03c6\u03af\u03bb\u03c4\u03c1\u03bf\u03c5",
            "dxDataGrid-filterPanelCreateFilter": "\u0394\u03b7\u03bc\u03b9\u03bf\u03c5\u03c1\u03b3\u03af\u03b1 \u03c6\u03af\u03bb\u03c4\u03c1\u03bf\u03c5",
            "dxDataGrid-filterPanelClearFilter": "\u0395\u03ba\u03ba\u03b1\u03b8\u03ac\u03c1\u03b9\u03c3\u03b7",
            "dxDataGrid-filterPanelFilterEnabledHint": "\u0395\u03bd\u03b5\u03c1\u03b3\u03bf\u03c0\u03bf\u03b9\u03ae\u03c3\u03c4\u03b5 \u03c4\u03bf \u03c6\u03af\u03bb\u03c4\u03c1\u03bf",
            "dxDataGrid-masterDetail": "Cell with details",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaExpandableInstruction": "Press Ctrl + right arrow to expand the focused node and Ctrl + left arrow to collapse it",
            "dxTreeList-ariaSearchInGrid": "Search in the tree list",
            "dxTreeList-ariaToolbar": "Tree list toolbar",
            "dxTreeList-editingAddRowToNode": "\u03a0\u03c1\u03bf\u03c3\u03b8\u03ad\u03c4\u03c9",
            "dxPager-infoText": "\u03a3\u03b5\u03bb\u03af\u03b4\u03b1 {0} \u03b1\u03c0\u03cc {1} ({2} \u03b1\u03bd\u03c4\u03b9\u03ba\u03b5\u03af\u03bc\u03b5\u03bd\u03b1)",
            "dxPager-pagesCountText": "\u03b1\u03c0\u03cc",
            "dxPager-pageSize": "Items per page: {0}",
            "dxPager-pageSizesAllText": "\u038c\u03bb\u03b1",
            "dxPager-page": "Page {0}",
            "dxPager-prevPage": "Previous page",
            "dxPager-nextPage": "Next page",
            "dxPager-ariaLabel": "Page navigation",
            "dxPager-ariaPageSize": "Page size",
            "dxPager-ariaPageNumber": "Page number",
            "dxPagination-infoText": "\u03a3\u03b5\u03bb\u03af\u03b4\u03b1 {0} \u03b1\u03c0\u03cc {1} ({2} \u03b1\u03bd\u03c4\u03b9\u03ba\u03b5\u03af\u03bc\u03b5\u03bd\u03b1)",
            "dxPagination-pagesCountText": "\u03b1\u03c0\u03cc",
            "dxPagination-pageSize": "Items per page: {0}",
            "dxPagination-pageSizesAllText": "\u038c\u03bb\u03b1",
            "dxPagination-page": "Page {0}",
            "dxPagination-prevPage": "Previous page",
            "dxPagination-nextPage": "Next page",
            "dxPagination-ariaLabel": "Page navigation",
            "dxPagination-ariaPageSize": "Page size",
            "dxPagination-ariaPageNumber": "Page number",
            "dxPivotGrid-grandTotal": "\u03a3\u03cd\u03bd\u03bf\u03bb\u03bf",
            "dxPivotGrid-total": "{0} \u03a3\u03cd\u03bd\u03bf\u03bb\u03bf",
            "dxPivotGrid-fieldChooserTitle": "\u0395\u03c0\u03b9\u03bb\u03bf\u03b3\u03ad\u03b1\u03c2 \u03c0\u03b5\u03b4\u03af\u03bf\u03c5",
            "dxPivotGrid-showFieldChooser": "\u0395\u03bc\u03c6\u03ac\u03bd\u03b9\u03c3\u03b7 \u03b5\u03c0\u03b9\u03bb\u03bf\u03b3\u03ad\u03b1 \u03c0\u03b5\u03b4\u03af\u03c9\u03bd",
            "dxPivotGrid-expandAll": "\u0395\u03c0\u03ad\u03ba\u03c4\u03b1\u03c3\u03b7 \u03cc\u03bb\u03c9\u03bd",
            "dxPivotGrid-collapseAll": "\u03a3\u03cd\u03bc\u03c0\u03c4\u03c5\u03be\u03b7 \u03cc\u03bb\u03c9\u03bd",
            "dxPivotGrid-sortColumnBySummary": '\u03a4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7 "{0}" \u03b1\u03c0\u03cc \u03b1\u03c5\u03c4\u03ae \u03c4\u03b7\u03bd \u03c3\u03c4\u03ae\u03bb\u03b7',
            "dxPivotGrid-sortRowBySummary": '\u03a4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7 "{0}" \u03b1\u03c0\u03cc \u03b1\u03c5\u03c4\u03ae \u03c4\u03b7\u03bd \u03b3\u03c1\u03b1\u03bc\u03bc\u03ae',
            "dxPivotGrid-removeAllSorting": "\u039a\u03b1\u03c4\u03ac\u03c1\u03b3\u03b7\u03c3\u03b7 \u03ba\u03ac\u03b8\u03b5 \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7\u03c2",
            "dxPivotGrid-dataNotAvailable": "N/A",
            "dxPivotGrid-rowFields": "\u03a0\u03b5\u03b4\u03af\u03b1 \u03b3\u03c1\u03b1\u03bc\u03bc\u03ae\u03c2",
            "dxPivotGrid-columnFields": "\u03a0\u03b5\u03b4\u03af\u03b1 \u03c3\u03c4\u03ae\u03bb\u03b7\u03c2",
            "dxPivotGrid-dataFields": "\u03a0\u03b5\u03b4\u03af\u03b1 \u03b4\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03c9\u03bd",
            "dxPivotGrid-filterFields": "\u03a0\u03b5\u03b4\u03af\u03b1 \u03c6\u03af\u03bb\u03c4\u03c1\u03bf\u03c5",
            "dxPivotGrid-allFields": "\u039f\u03bb\u03b1 \u03c4\u03b1 \u03c0\u03b5\u03b4\u03af\u03b1",
            "dxPivotGrid-columnFieldArea": "\u03a4\u03bf\u03c0\u03bf\u03b8\u03b5\u03c4\u03ae\u03c3\u03c4\u03b5 \u03c4\u03b1 \u03c0\u03b5\u03b4\u03af\u03b1 \u03c3\u03c4\u03b7 \u03c3\u03c4\u03ae\u03bb\u03b7 \u03b5\u03b4\u03ce",
            "dxPivotGrid-dataFieldArea": "\u03a4\u03bf\u03c0\u03bf\u03b8\u03b5\u03c4\u03ae\u03c3\u03c4\u03b5 \u03c4\u03b1 \u03c0\u03b5\u03b4\u03af\u03b1 \u03b4\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03c9\u03bd \u03b5\u03b4\u03ce",
            "dxPivotGrid-rowFieldArea": "\u03a4\u03bf\u03c0\u03bf\u03b8\u03b5\u03c4\u03ae\u03c3\u03c4\u03b5 \u03c4\u03b1 \u03c0\u03b5\u03b4\u03af\u03b1 \u03b3\u03c1\u03b1\u03bc\u03bc\u03ce\u03bd \u03b5\u03b4\u03ce",
            "dxPivotGrid-filterFieldArea": "\u03a4\u03bf\u03c0\u03bf\u03b8\u03b5\u03c4\u03ae\u03c3\u03c4\u03b5 \u03c4\u03b1 \u03c0\u03b5\u03b4\u03af\u03b1 \u03c6\u03af\u03bb\u03c4\u03c1\u03c9\u03bd \u03b5\u03b4\u03ce",
            "dxScheduler-ariaLabel": "Scheduler. {0} view",
            "dxScheduler-appointmentAriaLabel-group": "Group: {0}",
            "dxScheduler-appointmentAriaLabel-recurring": "Recurring appointment",
            "dxScheduler-editorLabelTitle": "\u0398\u03ad\u03bc\u03b1",
            "dxScheduler-editorLabelStartDate": "\u0397\u03bc\u03b5\u03c1\u03bf\u03bc\u03b7\u03bd\u03af\u03b1 \u03ad\u03bd\u03b1\u03c1\u03be\u03b7\u03c2",
            "dxScheduler-editorLabelEndDate": "\u0397\u03bc\u03b5\u03c1\u03bf\u03bc\u03b7\u03bd\u03af\u03b1 \u03bb\u03ae\u03be\u03b7\u03c2",
            "dxScheduler-editorLabelDescription": "\u03a0\u03b5\u03c1\u03b9\u03b3\u03c1\u03b1\u03c6\u03ae",
            "dxScheduler-editorLabelRecurrence": "\u0395\u03c0\u03b1\u03bd\u03ac\u03bb\u03b7\u03c8\u03b7",
            "dxScheduler-navigationPrevious": "Previous page",
            "dxScheduler-navigationNext": "Next page",
            "dxScheduler-openAppointment": "\u0386\u03bd\u03bf\u03b9\u03b3\u03bc\u03b1 \u03c1\u03b1\u03bd\u03c4\u03b5\u03b2\u03bf\u03cd",
            "dxScheduler-recurrenceNever": "\u03a0\u03bf\u03c4\u03ad",
            "dxScheduler-recurrenceMinutely": "Minutely",
            "dxScheduler-recurrenceHourly": "Hourly",
            "dxScheduler-recurrenceDaily": "\u039a\u03b1\u03b8\u03b7\u03bc\u03b5\u03c1\u03b9\u03bd\u03ac",
            "dxScheduler-recurrenceWeekly": "\u0395\u03b2\u03b4\u03bf\u03bc\u03b1\u03b4\u03b9\u03b1\u03af\u03b1",
            "dxScheduler-recurrenceMonthly": "\u039c\u03b7\u03bd\u03b9\u03b1\u03af\u03b1",
            "dxScheduler-recurrenceYearly": "\u0395\u03c4\u03ae\u03c3\u03b9\u03b1",
            "dxScheduler-recurrenceRepeatEvery": "\u039a\u03ac\u03b8\u03b5",
            "dxScheduler-recurrenceRepeatOn": "Repeat On",
            "dxScheduler-recurrenceEnd": "\u03a4\u03b5\u03c1\u03bc\u03b1\u03c4\u03b9\u03c3\u03bc\u03cc\u03c2 \u03b5\u03c0\u03b1\u03bd\u03ac\u03bb\u03b7\u03c8\u03b7\u03c2",
            "dxScheduler-recurrenceAfter": "\u039c\u03b5\u03c4\u03ac",
            "dxScheduler-recurrenceOn": "On",
            "dxScheduler-recurrenceRepeatMinutely": "minute(s)",
            "dxScheduler-recurrenceRepeatHourly": "hour(s)",
            "dxScheduler-recurrenceRepeatDaily": "\u03bc\u03ad\u03c1\u03b1(\u03b5\u03c2)",
            "dxScheduler-recurrenceRepeatWeekly": "\u03b5\u03b2\u03b4\u03bf\u03bc\u03ac\u03b4\u03b1(\u03b5\u03c2)",
            "dxScheduler-recurrenceRepeatMonthly": "\u03bc\u03ae\u03bd\u03b1(\u03b5\u03c2)",
            "dxScheduler-recurrenceRepeatYearly": "\u03c7\u03c1\u03cc\u03bd\u03bf(\u03bf\u03c5\u03c2)",
            "dxScheduler-switcherDay": "\u039c\u03ad\u03c1\u03b1",
            "dxScheduler-switcherWeek": "\u0395\u03b2\u03b4\u03bf\u03bc\u03ac\u03b4\u03b1",
            "dxScheduler-switcherWorkWeek": "\u0395\u03b2\u03b4\u03bf\u03bc\u03ac\u03b4\u03b1 \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2",
            "dxScheduler-switcherMonth": "\u039c\u03ae\u03bd\u03b1\u03c2",
            "dxScheduler-switcherAgenda": "\u0397\u03bc\u03b5\u03c1\u03ae\u03c3\u03b9\u03b1 \u03b4\u03b9\u03ac\u03c4\u03b1\u03be\u03b7",
            "dxScheduler-switcherTimelineDay": "\u0397\u03bc\u03b5\u03c1\u03ae\u03c3\u03b9\u03bf \u03a7\u03c1\u03bf\u03bd\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf",
            "dxScheduler-switcherTimelineWeek": "\u0395\u03b2\u03b4\u03bf\u03bc\u03b1\u03b4\u03b9\u03b1\u03af\u03bf \u03a7\u03c1\u03bf\u03bd\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf",
            "dxScheduler-switcherTimelineWorkWeek": "\u03a7\u03c1\u03bf\u03bd\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf \u03b5\u03b2\u03b4\u03bf\u03bc\u03ac\u03b4\u03b1\u03c2 \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2",
            "dxScheduler-switcherTimelineMonth": "\u039c\u03b7\u03bd\u03b9\u03b1\u03af\u03bf \u03a7\u03c1\u03bf\u03bd\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf",
            "dxScheduler-recurrenceRepeatOnDate": "\u03c3\u03c4\u03b7\u03bd \u03b7\u03bc\u03b5\u03c1\u03bf\u03bc\u03b7\u03bd\u03af\u03b1",
            "dxScheduler-recurrenceRepeatCount": "\u03c0\u03b5\u03c1\u03b9\u03c3\u03c4\u03b1\u03c4\u03b9\u03ba\u03cc(\u03b1)",
            "dxScheduler-allDay": "\u038c\u03bb\u03b7 \u03bc\u03ad\u03c1\u03b1",
            "dxScheduler-ariaEditForm": "Edit form",
            "dxScheduler-confirmRecurrenceEditTitle": "Edit Recurring Appointment",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Delete Recurring Appointment",
            "dxScheduler-confirmRecurrenceEditMessage": "\u0398\u03ad\u03bb\u03b5\u03c4\u03b5 \u03bd\u03b1 \u03b5\u03c0\u03b5\u03be\u03b5\u03c1\u03b3\u03b1\u03c3\u03c4\u03b5\u03af\u03c4\u03b5 \u03bc\u03cc\u03bd\u03bf \u03b1\u03c5\u03c4\u03cc \u03c4\u03bf \u03c1\u03b1\u03bd\u03c4\u03b5\u03b2\u03bf\u03cd \u03ae \u03bf\u03bb\u03cc\u03ba\u03bb\u03b7\u03c1\u03b7 \u03c4\u03b7 \u03c3\u03b5\u03b9\u03c1\u03ac;",
            "dxScheduler-confirmRecurrenceDeleteMessage": "\u0398\u03ad\u03bb\u03b5\u03c4\u03b5 \u03bd\u03b1 \u03b4\u03b9\u03b1\u03b3\u03c1\u03ac\u03c8\u03b5\u03c4\u03b5 \u03bc\u03cc\u03bd\u03bf \u03b1\u03c5\u03c4\u03cc \u03c4\u03bf \u03c1\u03b1\u03bd\u03c4\u03b5\u03b2\u03bf\u03cd \u03ae \u03bf\u03bb\u03cc\u03ba\u03bb\u03b7\u03c1\u03b7 \u03c4\u03b7 \u03c3\u03b5\u03b9\u03c1\u03ac;",
            "dxScheduler-confirmRecurrenceEditSeries": "\u0395\u03c0\u03b5\u03be\u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1 \u03c3\u03b5\u03b9\u03c1\u03ac\u03c2",
            "dxScheduler-confirmRecurrenceDeleteSeries": "\u0394\u03b9\u03b1\u03b3\u03c1\u03b1\u03c6\u03ae \u03c3\u03b5\u03b9\u03c1\u03ac\u03c2",
            "dxScheduler-confirmRecurrenceEditOccurrence": "\u0395\u03c0\u03b5\u03be\u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1 \u03c3\u03c5\u03bd\u03ac\u03bd\u03c4\u03b7\u03c3\u03b7\u03c2",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "\u0394\u03b9\u03b1\u03b3\u03c1\u03b1\u03c6\u03ae \u03c3\u03c5\u03bd\u03ac\u03bd\u03c4\u03b7\u03c3\u03b7\u03c2",
            "dxScheduler-noTimezoneTitle": "\u03a7\u03c9\u03c1\u03af\u03c2 \u03b6\u03ce\u03bd\u03b7 \u03ce\u03c1\u03b1\u03c2",
            "dxScheduler-moreAppointments": "{0} \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03b1",
            "dxCalendar-currentDay": "Today",
            "dxCalendar-currentMonth": "Current month",
            "dxCalendar-currentYear": "Current year",
            "dxCalendar-currentYearRange": "Current year range",
            "dxCalendar-todayButtonText": "\u03a3\u03ae\u03bc\u03b5\u03c1\u03b1",
            "dxCalendar-ariaWidgetName": "\u0397\u03bc\u03b5\u03c1\u03bf\u03bb\u03cc\u03b3\u03b9\u03bf",
            "dxCalendar-previousMonthButtonLabel": "Previous month",
            "dxCalendar-previousYearButtonLabel": "Previous year",
            "dxCalendar-previousDecadeButtonLabel": "Previous decade",
            "dxCalendar-previousCenturyButtonLabel": "Previous century",
            "dxCalendar-nextMonthButtonLabel": "Next month",
            "dxCalendar-nextYearButtonLabel": "Next year",
            "dxCalendar-nextDecadeButtonLabel": "Next decade",
            "dxCalendar-nextCenturyButtonLabel": "Next century",
            "dxCalendar-captionMonthLabel": "Month selection",
            "dxCalendar-captionYearLabel": "Year selection",
            "dxCalendar-captionDecadeLabel": "Decade selection",
            "dxCalendar-captionCenturyLabel": "Century selection",
            "dxCalendar-selectedDate": "The selected date is {0}",
            "dxCalendar-selectedDates": "The selected dates",
            "dxCalendar-selectedDateRange": "The selected date range is from {0} to {1}",
            "dxCalendar-selectedMultipleDateRange": "from {0} to {1}",
            "dxCalendar-selectedDateRangeCount": "There are {0} selected date ranges",
            "dxCalendar-readOnlyLabel": "Read-only calendar",
            "dxAvatar-defaultImageAlt": "Avatar",
            "dxChat-elementAriaLabel": "Chat",
            "dxChat-textareaPlaceholder": "Type a message",
            "dxChat-sendButtonAriaLabel": "Send",
            "dxChat-defaultUserName": "Unknown User",
            "dxChat-messageListAriaLabel": "Message list",
            "dxChat-alertListAriaLabel": "Error list",
            "dxChat-emptyListMessage": "There are no messages in this chat",
            "dxChat-emptyListPrompt": "Write your first message",
            "dxChat-typingMessageSingleUser": "{0} is typing...",
            "dxChat-typingMessageTwoUsers": "{0} and {1} are typing...",
            "dxChat-typingMessageThreeUsers": "{0}, {1} and {2} are typing...",
            "dxChat-typingMessageMultipleUsers": "{0} and others are typing...",
            "dxColorView-ariaRed": "\u039a\u03cc\u03ba\u03ba\u03b9\u03bd\u03bf",
            "dxColorView-ariaGreen": "\u03a0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf",
            "dxColorView-ariaBlue": "\u039c\u03c0\u03bb\u03b5",
            "dxColorView-ariaAlpha": "\u0394\u03b9\u03ac\u03c6\u03b1\u03bd\u03bf",
            "dxColorView-ariaHex": "\u039a\u03c9\u03b4\u03b9\u03ba\u03cc\u03c2 \u03c7\u03c1\u03ce\u03bc\u03b1\u03c4\u03bf\u03c2",
            "dxTagBox-selected": "{0} \u03b5\u03c0\u03b9\u03bb\u03b5\u03b3\u03bc\u03ad\u03bd\u03bf/\u03b1",
            "dxTagBox-allSelected": "\u038c\u03bb\u03b1 \u03b5\u03c0\u03b9\u03bb\u03ad\u03c7\u03b8\u03b7\u03ba\u03b1\u03bd ({0})",
            "dxTagBox-moreSelected": "{0} \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03b1",
            "dxTagBox-tagRoleDescription": "Tag. Press the delete button to remove this tag",
            "vizExport-printingButtonText": "\u0395\u03ba\u03c4\u03cd\u03c0\u03c9\u03c3\u03b7",
            "vizExport-titleMenuText": "\u0395\u03be\u03b1\u03b3\u03c9\u03b3\u03ae/\u0395\u03ba\u03c4\u03cd\u03c0\u03c9\u03c3\u03b7",
            "vizExport-exportButtonText": "{0} \u03b1\u03c1\u03c7\u03b5\u03af\u03bf/\u03b1",
            "dxFilterBuilder-and": "\u039a\u03b1\u03b9",
            "dxFilterBuilder-or": "\u0389",
            "dxFilterBuilder-notAnd": "\u038c\u03c7\u03b9 \u039a\u03b1\u03b9",
            "dxFilterBuilder-notOr": "\u038c\u03c7\u03b9 \u0389",
            "dxFilterBuilder-addCondition": "\u03a0\u03c1\u03bf\u03c3\u03b8\u03ae\u03ba\u03b7 \u03c3\u03c5\u03bd\u03b8\u03b7\u03ba\u03ce\u03bd",
            "dxFilterBuilder-addGroup": "\u03a0\u03c1\u03bf\u03c3\u03b8\u03ae\u03ba\u03b7 \u03bf\u03bc\u03ac\u03b4\u03b1\u03c2",
            "dxFilterBuilder-enterValueText": "<\u03b5\u03b9\u03c3\u03b1\u03b3\u03ac\u03b3\u03b5\u03c4\u03b5 \u03bc\u03b9\u03b1 \u03c4\u03b9\u03bc\u03ae>",
            "dxFilterBuilder-filterOperationEquals": "\u038a\u03c3\u03bf \u03bc\u03b5",
            "dxFilterBuilder-filterOperationNotEquals": "\u0394\u03b5\u03bd \u03b5\u03af\u03bd\u03b1\u03b9 \u03af\u03c3\u03bf \u03bc\u03b5",
            "dxFilterBuilder-filterOperationLess": "\u0395\u03af\u03bd\u03b1\u03b9 \u03bc\u03b9\u03ba\u03c1\u03cc\u03c4\u03b5\u03c1\u03bf \u03b1\u03c0\u03cc",
            "dxFilterBuilder-filterOperationLessOrEquals": "\u0395\u03af\u03bd\u03b1\u03b9 \u03bc\u03b9\u03ba\u03c1\u03cc\u03c4\u03b5\u03c1\u03bf\u0384\u03ae \u03af\u03c3\u03bf \u03b1\u03c0\u03cc",
            "dxFilterBuilder-filterOperationGreater": "\u0395\u03af\u03bd\u03b1\u03b9 \u03bc\u03b5\u03b3\u03b1\u03bb\u03cd\u03c4\u03b5\u03c1\u03bf \u03b1\u03c0\u03cc",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "\u0395\u03af\u03bd\u03b1\u03b9 \u03bc\u03b5\u03b3\u03b1\u03bb\u03cd\u03c4\u03b5\u03c1\u03bf \u03ae \u03af\u03c3\u03bf \u03bc\u03b5",
            "dxFilterBuilder-filterOperationStartsWith": "\u039e\u03b5\u03ba\u03b9\u03bd\u03ac\u03b5\u03b9 \u03bc\u03b5",
            "dxFilterBuilder-filterOperationContains": "\u03a0\u03b5\u03c1\u03b9\u03ad\u03c7\u03b5\u03b9",
            "dxFilterBuilder-filterOperationNotContains": "\u0394\u03b5\u03bd \u03c0\u03b5\u03c1\u03b9\u03ad\u03c7\u03b5\u03b9",
            "dxFilterBuilder-filterOperationEndsWith": "\u03a4\u03b5\u03bb\u03b5\u03b9\u03ce\u03bd\u03b5\u03b9 \u03bc\u03b5",
            "dxFilterBuilder-filterOperationIsBlank": "\u0395\u03af\u03bd\u03b1\u03b9 \u03ba\u03b5\u03bd\u03cc",
            "dxFilterBuilder-filterOperationIsNotBlank": "\u0394\u03b5\u03bd \u03b5\u03af\u03bd\u03b1\u03b9 \u03ba\u03b5\u03bd\u03cc",
            "dxFilterBuilder-filterOperationBetween": "\u0395\u03af\u03bd\u03b1\u03b9 \u03b1\u03bd\u03ac\u03bc\u03b5\u03c3\u03b1",
            "dxFilterBuilder-filterOperationAnyOf": "\u0395\u03af\u03bd\u03b1\u03b9 \u03ba\u03ac\u03c0\u03bf\u03b9\u03bf \u03b1\u03c0\u03cc \u03b1\u03c5\u03c4\u03ac",
            "dxFilterBuilder-filterOperationNoneOf": "\u0394\u03b5\u03bd \u03b5\u03af\u03bd\u03b1\u03b9 \u03c4\u03af\u03c0\u03bf\u03c4\u03b1 \u03b1\u03c0\u03cc \u03b1\u03c5\u03c4\u03ac",
            "dxFilterBuilder-filterAriaRootElement": "Filter builder",
            "dxFilterBuilder-filterAriaGroupLevel": "Level {0}",
            "dxFilterBuilder-filterAriaGroupItem": "Group item",
            "dxFilterBuilder-filterAriaOperationButton": "Operation",
            "dxFilterBuilder-filterAriaAddButton": "Add",
            "dxFilterBuilder-filterAriaRemoveButton": "Remove {0}",
            "dxFilterBuilder-filterAriaItemField": "Item field",
            "dxFilterBuilder-filterAriaItemOperation": "Item operation",
            "dxFilterBuilder-filterAriaItemValue": "Item value",
            "dxHtmlEditor-dialogColorCaption": "\u0391\u03bb\u03bb\u03b1\u03b3\u03ae \u03c7\u03c1\u03ce\u03bc\u03b1\u03c4\u03bf\u03c2 \u03b3\u03c1\u03b1\u03bc\u03bc\u03b1\u03c4\u03bf\u03c3\u03b5\u03b9\u03c1\u03ac\u03c2",
            "dxHtmlEditor-dialogBackgroundCaption": "\u0391\u03bb\u03bb\u03b1\u03b3\u03ae \u03c7\u03c1\u03ce\u03bc\u03b1\u03c4\u03bf\u03c2 \u03c6\u03cc\u03bd\u03c4\u03bf\u03c5",
            "dxHtmlEditor-dialogLinkCaption": "\u03a0\u03c1\u03bf\u03c3\u03b8\u03ae\u03ba\u03b7 \u03c3\u03c5\u03bd\u03b4\u03ad\u03c3\u03bc\u03bf\u03c5",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "\u039a\u03b5\u03af\u03bc\u03b5\u03bd\u03bf",
            "dxHtmlEditor-dialogLinkTargetField": "\u0391\u03bd\u03bf\u03af\u03be\u03c4\u03b5 \u03c4\u03bf \u03c3\u03cd\u03bd\u03b4\u03b5\u03c3\u03bc\u03bf \u03c3\u03b5 \u03bd\u03ad\u03bf \u03c0\u03b1\u03c1\u03ac\u03b8\u03c5\u03c1\u03bf",
            "dxHtmlEditor-dialogImageCaption": "\u03a0\u03c1\u03bf\u03c3\u03b8\u03ad\u03c3\u03c4\u03b5 \u03b5\u03b9\u03ba\u03cc\u03bd\u03b1",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "\u0395\u03bd\u03b1\u03bb\u03bb\u03b1\u03ba\u03c4\u03b9\u03ba\u03cc \u03ba\u03b5\u03af\u03bc\u03b5\u03bd\u03bf",
            "dxHtmlEditor-dialogImageWidthField": "\u03a0\u03bb\u03ac\u03c4\u03bf\u03c2 (px)",
            "dxHtmlEditor-dialogImageHeightField": "\u03a5\u03c8\u03bf\u03c2 (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "Rows",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Columns",
            "dxHtmlEditor-dialogInsertTableCaption": "Insert Table",
            "dxHtmlEditor-dialogUpdateImageCaption": "Update Image",
            "dxHtmlEditor-dialogImageUpdateButton": "Update",
            "dxHtmlEditor-dialogImageAddButton": "Add",
            "dxHtmlEditor-dialogImageSpecifyUrl": "From the Web",
            "dxHtmlEditor-dialogImageSelectFile": "From This Device",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Keep Aspect Ratio",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Encode to Base64",
            "dxHtmlEditor-heading": "\u0395\u03c0\u03b9\u03ba\u03b5\u03c6\u03b1\u03bb\u03af\u03b4\u03b1",
            "dxHtmlEditor-normalText": "\u039a\u03b1\u03bd\u03bf\u03bd\u03b9\u03ba\u03cc \u03ba\u03b5\u03af\u03bc\u03b5\u03bd\u03bf",
            "dxHtmlEditor-background": "Background Color",
            "dxHtmlEditor-bold": "Bold",
            "dxHtmlEditor-color": "Font Color",
            "dxHtmlEditor-font": "Font",
            "dxHtmlEditor-italic": "Italic",
            "dxHtmlEditor-link": "Add Link",
            "dxHtmlEditor-image": "Add Image",
            "dxHtmlEditor-size": "Size",
            "dxHtmlEditor-strike": "Strikethrough",
            "dxHtmlEditor-subscript": "Subscript",
            "dxHtmlEditor-superscript": "Superscript",
            "dxHtmlEditor-underline": "Underline",
            "dxHtmlEditor-blockquote": "Blockquote",
            "dxHtmlEditor-header": "Header",
            "dxHtmlEditor-increaseIndent": "Increase Indent",
            "dxHtmlEditor-decreaseIndent": "Decrease Indent",
            "dxHtmlEditor-orderedList": "Ordered List",
            "dxHtmlEditor-bulletList": "Bullet List",
            "dxHtmlEditor-alignLeft": "Align Left",
            "dxHtmlEditor-alignCenter": "Align Center",
            "dxHtmlEditor-alignRight": "Align Right",
            "dxHtmlEditor-alignJustify": "Align Justify",
            "dxHtmlEditor-codeBlock": "Code Block",
            "dxHtmlEditor-variable": "Add Variable",
            "dxHtmlEditor-undo": "Undo",
            "dxHtmlEditor-redo": "Redo",
            "dxHtmlEditor-clear": "Clear Formatting",
            "dxHtmlEditor-insertTable": "Insert Table",
            "dxHtmlEditor-insertHeaderRow": "Insert Header Row",
            "dxHtmlEditor-insertRowAbove": "Insert Row Above",
            "dxHtmlEditor-insertRowBelow": "Insert Row Below",
            "dxHtmlEditor-insertColumnLeft": "Insert Column Left",
            "dxHtmlEditor-insertColumnRight": "Insert Column Right",
            "dxHtmlEditor-deleteColumn": "Delete Column",
            "dxHtmlEditor-deleteRow": "Delete Row",
            "dxHtmlEditor-deleteTable": "Delete Table",
            "dxHtmlEditor-cellProperties": "Cell Properties",
            "dxHtmlEditor-tableProperties": "Table Properties",
            "dxHtmlEditor-insert": "Insert",
            "dxHtmlEditor-delete": "Delete",
            "dxHtmlEditor-border": "Border",
            "dxHtmlEditor-style": "Style",
            "dxHtmlEditor-width": "Width",
            "dxHtmlEditor-height": "Height",
            "dxHtmlEditor-borderColor": "Color",
            "dxHtmlEditor-borderWidth": "Border Width",
            "dxHtmlEditor-tableBackground": "Background",
            "dxHtmlEditor-dimensions": "Dimensions",
            "dxHtmlEditor-alignment": "Alignment",
            "dxHtmlEditor-horizontal": "Horizontal",
            "dxHtmlEditor-vertical": "Vertical",
            "dxHtmlEditor-paddingVertical": "Vertical Padding",
            "dxHtmlEditor-paddingHorizontal": "Horizontal Padding",
            "dxHtmlEditor-pixels": "Pixels",
            "dxHtmlEditor-list": "List",
            "dxHtmlEditor-ordered": "Ordered",
            "dxHtmlEditor-bullet": "Bullet",
            "dxHtmlEditor-align": "Align",
            "dxHtmlEditor-center": "Center",
            "dxHtmlEditor-left": "Left",
            "dxHtmlEditor-right": "Right",
            "dxHtmlEditor-indent": "Indent",
            "dxHtmlEditor-justify": "Justify",
            "dxHtmlEditor-borderStyleNone": "none",
            "dxHtmlEditor-borderStyleHidden": "hidden",
            "dxHtmlEditor-borderStyleDotted": "dotted",
            "dxHtmlEditor-borderStyleDashed": "dashed",
            "dxHtmlEditor-borderStyleSolid": "solid",
            "dxHtmlEditor-borderStyleDouble": "double",
            "dxHtmlEditor-borderStyleGroove": "groove",
            "dxHtmlEditor-borderStyleRidge": "ridge",
            "dxHtmlEditor-borderStyleInset": "inset",
            "dxHtmlEditor-borderStyleOutset": "outset",
            "dxFileManager-newDirectoryName": "Untitled directory",
            "dxFileManager-rootDirectoryName": "Files",
            "dxFileManager-errorNoAccess": "Access Denied. Operation could not be completed.",
            "dxFileManager-errorDirectoryExistsFormat": "Directory '{0}' already exists.",
            "dxFileManager-errorFileExistsFormat": "File '{0}' already exists.",
            "dxFileManager-errorFileNotFoundFormat": "File '{0}' not found.",
            "dxFileManager-errorDirectoryNotFoundFormat": "Directory '{0}' not found.",
            "dxFileManager-errorWrongFileExtension": "File extension is not allowed.",
            "dxFileManager-errorMaxFileSizeExceeded": "File size exceeds the maximum allowed size.",
            "dxFileManager-errorInvalidSymbols": "This name contains invalid characters.",
            "dxFileManager-errorDefault": "Unspecified error.",
            "dxFileManager-errorDirectoryOpenFailed": "The directory cannot be opened",
            "dxFileManager-commandCreate": "New directory",
            "dxFileManager-commandRename": "Rename",
            "dxFileManager-commandMove": "Move to",
            "dxFileManager-commandCopy": "Copy to",
            "dxFileManager-commandDelete": "Delete",
            "dxFileManager-commandDownload": "Download",
            "dxFileManager-commandUpload": "Upload files",
            "dxFileManager-commandRefresh": "Refresh",
            "dxFileManager-commandThumbnails": "Thumbnails View",
            "dxFileManager-commandDetails": "Details View",
            "dxFileManager-commandClearSelection": "Clear selection",
            "dxFileManager-commandShowNavPane": "Toggle navigation pane",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "Move to",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "Move",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Copy to",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Copy",
            "dxFileManager-dialogRenameItemTitle": "Rename",
            "dxFileManager-dialogRenameItemButtonText": "Save",
            "dxFileManager-dialogCreateDirectoryTitle": "New directory",
            "dxFileManager-dialogCreateDirectoryButtonText": "Create",
            "dxFileManager-dialogDeleteItemTitle": "Delete",
            "dxFileManager-dialogDeleteItemButtonText": "Delete",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Are you sure you want to delete {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Are you sure you want to delete {0} items?",
            "dxFileManager-dialogButtonCancel": "Cancel",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Creating a directory inside {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Created a directory inside {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "Directory was not created",
            "dxFileManager-editingCreateCommonErrorMessage": "Directory was not created",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Renaming an item inside {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Renamed an item inside {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Item was not renamed",
            "dxFileManager-editingRenameCommonErrorMessage": "Item was not renamed",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Deleting an item from {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "Deleting {0} items from {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "Deleted an item from {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "Deleted {0} items from {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Item was not deleted",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} items were not deleted",
            "dxFileManager-editingDeleteCommonErrorMessage": "Some items were not deleted",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Moving an item to {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "Moving {0} items to {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Moved an item to {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "Moved {0} items to {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Item was not moved",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} items were not moved",
            "dxFileManager-editingMoveCommonErrorMessage": "Some items were not moved",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Copying an item to {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "Copying {0} items to {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Copied an item to {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Copied {0} items to {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Item was not copied",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} items were not copied",
            "dxFileManager-editingCopyCommonErrorMessage": "Some items were not copied",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "Uploading an item to {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "Uploading {0} items to {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Uploaded an item to {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "Uploaded {0} items to {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Item was not uploaded",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} items were not uploaded",
            "dxFileManager-editingUploadCanceledMessage": "Canceled",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Item was not downloaded",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} items were not downloaded",
            "dxFileManager-listDetailsColumnCaptionName": "Name",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Date Modified",
            "dxFileManager-listDetailsColumnCaptionFileSize": "File Size",
            "dxFileManager-listThumbnailsTooltipTextSize": "Size",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Date Modified",
            "dxFileManager-notificationProgressPanelTitle": "Progress",
            "dxFileManager-notificationProgressPanelEmptyListText": "No operations",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Canceled",
            "dxDiagram-categoryGeneral": "General",
            "dxDiagram-categoryFlowchart": "Flowchart",
            "dxDiagram-categoryOrgChart": "Org Chart",
            "dxDiagram-categoryContainers": "Containers",
            "dxDiagram-categoryCustom": "Custom",
            "dxDiagram-commandExportToSvg": "Export to SVG",
            "dxDiagram-commandExportToPng": "Export to PNG",
            "dxDiagram-commandExportToJpg": "Export to JPEG",
            "dxDiagram-commandUndo": "Undo",
            "dxDiagram-commandRedo": "Redo",
            "dxDiagram-commandFontName": "Font Name",
            "dxDiagram-commandFontSize": "Font Size",
            "dxDiagram-commandBold": "Bold",
            "dxDiagram-commandItalic": "Italic",
            "dxDiagram-commandUnderline": "Underline",
            "dxDiagram-commandTextColor": "Font Color",
            "dxDiagram-commandLineColor": "Line Color",
            "dxDiagram-commandLineWidth": "Line Width",
            "dxDiagram-commandLineStyle": "Line Style",
            "dxDiagram-commandLineStyleSolid": "Solid",
            "dxDiagram-commandLineStyleDotted": "Dotted",
            "dxDiagram-commandLineStyleDashed": "Dashed",
            "dxDiagram-commandFillColor": "Fill Color",
            "dxDiagram-commandAlignLeft": "Align Left",
            "dxDiagram-commandAlignCenter": "Align Center",
            "dxDiagram-commandAlignRight": "Align Right",
            "dxDiagram-commandConnectorLineType": "Connector Line Type",
            "dxDiagram-commandConnectorLineStraight": "Straight",
            "dxDiagram-commandConnectorLineOrthogonal": "Orthogonal",
            "dxDiagram-commandConnectorLineStart": "Connector Line Start",
            "dxDiagram-commandConnectorLineEnd": "Connector Line End",
            "dxDiagram-commandConnectorLineNone": "None",
            "dxDiagram-commandConnectorLineArrow": "Arrow",
            "dxDiagram-commandFullscreen": "Full Screen",
            "dxDiagram-commandUnits": "Units",
            "dxDiagram-commandPageSize": "Page Size",
            "dxDiagram-commandPageOrientation": "Page Orientation",
            "dxDiagram-commandPageOrientationLandscape": "Landscape",
            "dxDiagram-commandPageOrientationPortrait": "Portrait",
            "dxDiagram-commandPageColor": "Page Color",
            "dxDiagram-commandShowGrid": "Show Grid",
            "dxDiagram-commandSnapToGrid": "Snap to Grid",
            "dxDiagram-commandGridSize": "Grid Size",
            "dxDiagram-commandZoomLevel": "Zoom Level",
            "dxDiagram-commandAutoZoom": "Auto Zoom",
            "dxDiagram-commandFitToContent": "Fit to Content",
            "dxDiagram-commandFitToWidth": "Fit to Width",
            "dxDiagram-commandAutoZoomByContent": "Auto Zoom by Content",
            "dxDiagram-commandAutoZoomByWidth": "Auto Zoom by Width",
            "dxDiagram-commandSimpleView": "Simple View",
            "dxDiagram-commandCut": "Cut",
            "dxDiagram-commandCopy": "Copy",
            "dxDiagram-commandPaste": "Paste",
            "dxDiagram-commandSelectAll": "Select All",
            "dxDiagram-commandDelete": "Delete",
            "dxDiagram-commandBringToFront": "Bring to Front",
            "dxDiagram-commandSendToBack": "Send to Back",
            "dxDiagram-commandLock": "Lock",
            "dxDiagram-commandUnlock": "Unlock",
            "dxDiagram-commandInsertShapeImage": "Insert Image...",
            "dxDiagram-commandEditShapeImage": "Change Image...",
            "dxDiagram-commandDeleteShapeImage": "Delete Image",
            "dxDiagram-commandLayoutLeftToRight": "Left-to-right",
            "dxDiagram-commandLayoutRightToLeft": "Right-to-left",
            "dxDiagram-commandLayoutTopToBottom": "Top-to-bottom",
            "dxDiagram-commandLayoutBottomToTop": "Bottom-to-top",
            "dxDiagram-unitIn": "in",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "OK",
            "dxDiagram-dialogButtonCancel": "Cancel",
            "dxDiagram-dialogInsertShapeImageTitle": "Insert Image",
            "dxDiagram-dialogEditShapeImageTitle": "Change Image",
            "dxDiagram-dialogEditShapeImageSelectButton": "Select image",
            "dxDiagram-dialogEditShapeImageLabelText": "or drop a file here",
            "dxDiagram-uiExport": "Export",
            "dxDiagram-uiProperties": "Properties",
            "dxDiagram-uiSettings": "Settings",
            "dxDiagram-uiShowToolbox": "Show Toolbox",
            "dxDiagram-uiSearch": "Search",
            "dxDiagram-uiStyle": "Style",
            "dxDiagram-uiLayout": "Layout",
            "dxDiagram-uiLayoutTree": "Tree",
            "dxDiagram-uiLayoutLayered": "Layered",
            "dxDiagram-uiDiagram": "Diagram",
            "dxDiagram-uiText": "Text",
            "dxDiagram-uiObject": "Object",
            "dxDiagram-uiConnector": "Connector",
            "dxDiagram-uiPage": "Page",
            "dxDiagram-shapeText": "Text",
            "dxDiagram-shapeRectangle": "Rectangle",
            "dxDiagram-shapeEllipse": "Ellipse",
            "dxDiagram-shapeCross": "Cross",
            "dxDiagram-shapeTriangle": "Triangle",
            "dxDiagram-shapeDiamond": "Diamond",
            "dxDiagram-shapeHeart": "Heart",
            "dxDiagram-shapePentagon": "Pentagon",
            "dxDiagram-shapeHexagon": "Hexagon",
            "dxDiagram-shapeOctagon": "Octagon",
            "dxDiagram-shapeStar": "Star",
            "dxDiagram-shapeArrowLeft": "Left Arrow",
            "dxDiagram-shapeArrowUp": "Up Arrow",
            "dxDiagram-shapeArrowRight": "Right Arrow",
            "dxDiagram-shapeArrowDown": "Down Arrow",
            "dxDiagram-shapeArrowUpDown": "Up Down Arrow",
            "dxDiagram-shapeArrowLeftRight": "Left Right Arrow",
            "dxDiagram-shapeProcess": "Process",
            "dxDiagram-shapeDecision": "Decision",
            "dxDiagram-shapeTerminator": "Terminator",
            "dxDiagram-shapePredefinedProcess": "Predefined Process",
            "dxDiagram-shapeDocument": "Document",
            "dxDiagram-shapeMultipleDocuments": "Multiple Documents",
            "dxDiagram-shapeManualInput": "Manual Input",
            "dxDiagram-shapePreparation": "Preparation",
            "dxDiagram-shapeData": "Data",
            "dxDiagram-shapeDatabase": "Database",
            "dxDiagram-shapeHardDisk": "Hard Disk",
            "dxDiagram-shapeInternalStorage": "Internal Storage",
            "dxDiagram-shapePaperTape": "Paper Tape",
            "dxDiagram-shapeManualOperation": "Manual Operation",
            "dxDiagram-shapeDelay": "Delay",
            "dxDiagram-shapeStoredData": "Stored Data",
            "dxDiagram-shapeDisplay": "Display",
            "dxDiagram-shapeMerge": "Merge",
            "dxDiagram-shapeConnector": "Connector",
            "dxDiagram-shapeOr": "Or",
            "dxDiagram-shapeSummingJunction": "Summing Junction",
            "dxDiagram-shapeContainerDefaultText": "Container",
            "dxDiagram-shapeVerticalContainer": "Vertical Container",
            "dxDiagram-shapeHorizontalContainer": "Horizontal Container",
            "dxDiagram-shapeCardDefaultText": "Person's Name",
            "dxDiagram-shapeCardWithImageOnLeft": "Card with Image on the Left",
            "dxDiagram-shapeCardWithImageOnTop": "Card with Image on the Top",
            "dxDiagram-shapeCardWithImageOnRight": "Card with Image on the Right",
            "dxGantt-dialogTitle": "Title",
            "dxGantt-dialogStartTitle": "Start",
            "dxGantt-dialogEndTitle": "End",
            "dxGantt-dialogProgressTitle": "Progress",
            "dxGantt-dialogResourcesTitle": "Resources",
            "dxGantt-dialogResourceManagerTitle": "Resource Manager",
            "dxGantt-dialogTaskDetailsTitle": "Task Details",
            "dxGantt-dialogEditResourceListHint": "Edit Resource List",
            "dxGantt-dialogEditNoResources": "No resources",
            "dxGantt-dialogButtonAdd": "Add",
            "dxGantt-contextMenuNewTask": "New Task",
            "dxGantt-contextMenuNewSubtask": "New Subtask",
            "dxGantt-contextMenuDeleteTask": "Delete Task",
            "dxGantt-contextMenuDeleteDependency": "Delete Dependency",
            "dxGantt-dialogTaskDeleteConfirmation": "Deleting a task also deletes all its dependencies and subtasks. Are you sure you want to delete this task?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Are you sure you want to delete the dependency from the task?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Deleting a resource also deletes it from tasks to which this resource is assigned. Are you sure you want to delete these resources? Resources: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "The task you are attempting to move is linked to a second task by a dependency relation. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationMessage": "The task you are attempting to move is linked to a second task by a dependency relation. How would you like to proceed?",
            "dxGantt-dialogCancelOperationMessage": "Cancel the operation",
            "dxGantt-dialogDeleteDependencyMessage": "Delete the dependency",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Move the task and keep the dependency",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. How would you like to proceed?",
            "dxGantt-dialogDeleteDependenciesMessage": "Delete the dependency relations",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Move the task and keep the dependencies",
            "dxGantt-undo": "Undo",
            "dxGantt-redo": "Redo",
            "dxGantt-expandAll": "Expand All",
            "dxGantt-collapseAll": "Collapse All",
            "dxGantt-addNewTask": "Add New Task",
            "dxGantt-deleteSelectedTask": "Delete Selected Task",
            "dxGantt-zoomIn": "Zoom In",
            "dxGantt-zoomOut": "Zoom Out",
            "dxGantt-fullScreen": "Full Screen",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "\u03a4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7 \u03b1\u03cd\u03be\u03bf\u03c5\u03c3\u03b1",
            "dxGantt-sortingDescendingText": "\u03a4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b7\u03c3\u03b7 \u03c6\u03b8\u03ae\u03bd\u03bf\u03c5\u03c3\u03b1",
            "dxGantt-sortingClearText": "\u0395\u03ba\u03ba\u03b1\u03b8\u03ac\u03c1\u03b9\u03c3\u03b7 \u03c4\u03b1\u03be\u03b9\u03bd\u03cc\u03bc\u03b9\u03c3\u03b7\u03c2",
            "dxGantt-showResources": "Show Resources",
            "dxGantt-showDependencies": "Show Dependencies",
            "dxGantt-dialogStartDateValidation": "Start date must be after {0}",
            "dxGantt-dialogEndDateValidation": "End date must be after {0}",
            "dxGallery-itemName": "Gallery item",
            "dxMultiView-elementAriaRoleDescription": "MultiView",
            "dxMultiView-elementAriaLabel": "Use the arrow keys or swipe to navigate between views",
            "dxMultiView-itemAriaRoleDescription": "View",
            "dxMultiView-itemAriaLabel": "{0} of {1}",
            "dxSplitter-resizeHandleAriaLabel": "Split bar"
        }
    })
}));
