/*!
* DevExtreme (dx.messages.ca.js)
* Version: 24.2.3-build-24326-1309
* Build date: Thu Nov 21 2024
*
* Copyright (c) 2012 - 2024 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        ca: {
            Yes: "S\xed",
            No: "No",
            Cancel: "Cancel\xb7lar",
            CheckState: "Check state",
            Close: "Tanca",
            Clear: "Clar",
            Done: "Fer",
            Loading: "Carregant ...",
            Select: "Seleccioneu ...",
            Search: "Cerca",
            Back: "esquena",
            OK: "D'acord",
            Today: "Avui",
            Yesterday: "Yesterday",
            "dxCollectionWidget-noDataText": "No hi ha dades a mostrar",
            "dxDropDownEditor-selectLabel": "Seleccionar",
            "validation-required": "Requerit",
            "validation-required-formatted": "{0} \xe9s obligatori",
            "validation-numeric": "El valor ha de ser un n\xfamero",
            "validation-numeric-formatted": "{0} ha de ser un n\xfamero",
            "validation-range": "El valor est\xe0 fora de rang",
            "validation-range-formatted": "{0} est\xe0 fora de rang",
            "validation-stringLength": "La longitud del valor no \xe9s correcta",
            "validation-stringLength-formatted": "La longitud de {0} no \xe9s correcta",
            "validation-custom": "El valor no \xe9s v\xe0lid",
            "validation-custom-formatted": "{0} no \xe9s v\xe0lid",
            "validation-async": "El valor no \xe9s v\xe0lid",
            "validation-async-formatted": "{0} no \xe9s v\xe0lid",
            "validation-compare": "Els valors no coincideixen",
            "validation-compare-formatted": "{0} no coincideix",
            "validation-pattern": "El valor no coincideix amb el patr\xf3",
            "validation-pattern-formatted": "{0} no coincideix amb el patr\xf3",
            "validation-email": "El correu electr\xf2nic no \xe9s v\xe0lid",
            "validation-email-formatted": "{0} no \xe9s v\xe0lid",
            "validation-mask": "El valor no \xe9s v\xe0lid",
            "dxLookup-searchPlaceholder": "N\xfamero de car\xe0cter m\xednim: {0}",
            "dxList-pullingDownText": "Tireu cap avall per refrescar -se ...",
            "dxList-pulledDownText": "Allibereu a refresc ...",
            "dxList-refreshingText": "Refrescant ...",
            "dxList-pageLoadingText": "Carregant ...",
            "dxList-nextButtonText": "M\xe9s",
            "dxList-selectAll": "Seleccionar tot",
            "dxList-listAriaLabel": "Items",
            "dxList-listAriaLabel-deletable": "Deletable items",
            "dxListEditDecorator-delete": "Esborrar",
            "dxListEditDecorator-more": "M\xe9s",
            "dxList-selectAll-indeterminate": "Half-checked",
            "dxList-selectAll-checked": "Checked",
            "dxList-selectAll-notChecked": "Not checked",
            "dxScrollView-pullingDownText": "Tireu cap avall per refrescar -se ...",
            "dxScrollView-pulledDownText": "Allibereu a refresc ...",
            "dxScrollView-refreshingText": "Refrescant ...",
            "dxScrollView-reachBottomText": "Carregant ...",
            "dxDateBox-simulatedDataPickerTitleTime": "Seleccioneu l'hora",
            "dxDateBox-simulatedDataPickerTitleDate": "Seleccioneu Data",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Seleccioneu la data i l'hora",
            "dxDateBox-validation-datetime": "El valor ha de ser una data o hora",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "Data d'inici",
            "dxDateRangeBox-endDateLabel": "Data de finalitzaci\xf3",
            "dxFileUploader-selectFile": "Seleccioneu un fitxer",
            "dxFileUploader-dropFile": "o deixar un fitxer aqu\xed",
            "dxFileUploader-bytes": "bytes",
            "dxFileUploader-kb": "KB",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "Penjar",
            "dxFileUploader-uploaded": "Penjat",
            "dxFileUploader-readyToUpload": "A punt per penjar",
            "dxFileUploader-uploadAbortedMessage": "Pengeu cancel\xb7lat",
            "dxFileUploader-uploadFailedMessage": "La c\xe0rrega ha fallat",
            "dxFileUploader-invalidFileExtension": "El tipus de fitxer no est\xe0 perm\xe8s",
            "dxFileUploader-invalidMaxFileSize": "El fitxer \xe9s massa gran",
            "dxFileUploader-invalidMinFileSize": "El fitxer \xe9s massa petit",
            "dxRangeSlider-ariaFrom": "Des de",
            "dxRangeSlider-ariaTill": "Fins a",
            "dxSwitch-switchedOnText": "Al damunt de",
            "dxSwitch-switchedOffText": "Apagada",
            "dxForm-optionalMark": "opcional",
            "dxForm-requiredMessage": "{0} \xe9s obligatori",
            "dxNumberBox-invalidValueMessage": "El valor ha de ser un n\xfamero",
            "dxNumberBox-noDataText": "No hi ha dades",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} to display columns",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Drag a column from the group panel here",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} or drag a column from the group panel",
            "dxDataGrid-emptyHeaderColumnChooserText": "column chooser",
            "dxDataGrid-columnChooserTitle": "Escollidor de columnes",
            "dxDataGrid-columnChooserEmptyText": "Arrossegueu una columna aqu\xed per amagar -la",
            "dxDataGrid-groupContinuesMessage": "Continua a la p\xe0gina seg\xfcent",
            "dxDataGrid-groupContinuedMessage": "Continuat des de la p\xe0gina anterior",
            "dxDataGrid-groupHeaderText": "Grup per aquesta columna",
            "dxDataGrid-ungroupHeaderText": "Desgrupament",
            "dxDataGrid-ungroupAllText": "Ungrup tot",
            "dxDataGrid-editingEditRow": "Preprarar una edici\xf3",
            "dxDataGrid-editingSaveRowChanges": "Estalviar",
            "dxDataGrid-editingCancelRowChanges": "Cancel\xb7lar",
            "dxDataGrid-editingDeleteRow": "Esborrar",
            "dxDataGrid-editingUndeleteRow": "Indiscutible",
            "dxDataGrid-editingConfirmDeleteMessage": "Esteu segur que voleu suprimir aquest registre?",
            "dxDataGrid-validationCancelChanges": "Cancel\xb7la els canvis",
            "dxDataGrid-groupPanelEmptyText": "Arrossegueu una cap\xe7alera de columna aqu\xed per agrupar -se per aquesta columna",
            "dxDataGrid-noDataText": "No hi ha dades",
            "dxDataGrid-searchPanelPlaceholder": "Cerca...",
            "dxDataGrid-filterRowShowAllText": "(Tot)",
            "dxDataGrid-filterRowResetOperationText": "Restablir",
            "dxDataGrid-filterRowOperationEquals": "\xc9s igual",
            "dxDataGrid-filterRowOperationNotEquals": "No \xe9s igual",
            "dxDataGrid-filterRowOperationLess": "Menys que",
            "dxDataGrid-filterRowOperationLessOrEquals": "Menys o igual a",
            "dxDataGrid-filterRowOperationGreater": "M\xe9s gran que",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "M\xe9s gran o igual a",
            "dxDataGrid-filterRowOperationStartsWith": "Comen\xe7a amb",
            "dxDataGrid-filterRowOperationContains": "Cont\xe9",
            "dxDataGrid-filterRowOperationNotContains": "No cont\xe9",
            "dxDataGrid-filterRowOperationEndsWith": "Acaba amb",
            "dxDataGrid-filterRowOperationBetween": "Entre",
            "dxDataGrid-filterRowOperationBetweenStartText": "Comen\xe7ar",
            "dxDataGrid-filterRowOperationBetweenEndText": "Final",
            "dxDataGrid-ariaSearchBox": "Search box",
            "dxDataGrid-applyFilterText": "Aplicar el filtre",
            "dxDataGrid-trueText": "lleial",
            "dxDataGrid-falseText": "fals",
            "dxDataGrid-sortingAscendingText": "Ordena Ascending",
            "dxDataGrid-sortingDescendingText": "Ordena descendent",
            "dxDataGrid-sortingClearText": "Ordenaci\xf3 clara",
            "dxDataGrid-ariaNotSortedColumn": "Not sorted column",
            "dxDataGrid-ariaSortedAscendingColumn": "Column sorted in ascending order",
            "dxDataGrid-ariaSortedDescendingColumn": "Column sorted in descending order",
            "dxDataGrid-ariaSortIndex": "Sort index {0}",
            "dxDataGrid-editingSaveAllChanges": "Guardar canvis",
            "dxDataGrid-editingCancelAllChanges": "Descartar els canvis",
            "dxDataGrid-editingAddRow": "Afegiu una fila",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Min de {1} \xe9s {0}",
            "dxDataGrid-summaryMax": "Max: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "M\xe0xim de {1} \xe9s {0}",
            "dxDataGrid-summaryAvg": "Avg: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "Avg de {1} \xe9s {0}",
            "dxDataGrid-summarySum": "Suma: {0}",
            "dxDataGrid-summarySumOtherColumn": "Suma de {1} \xe9s {0}",
            "dxDataGrid-summaryCount": "Compte: {0}",
            "dxDataGrid-columnFixingFix": "Set Fixed Position",
            "dxDataGrid-columnFixingUnfix": "Unfix",
            "dxDataGrid-columnFixingLeftPosition": "Left",
            "dxDataGrid-columnFixingRightPosition": "Right",
            "dxDataGrid-columnFixingStickyPosition": "Sticky",
            "dxDataGrid-exportTo": "Exportaci\xf3",
            "dxDataGrid-exportToExcel": "Exporta al fitxer Excel",
            "dxDataGrid-exporting": "Exportaci\xf3 ...",
            "dxDataGrid-excelFormat": "Fitxer excel",
            "dxDataGrid-selectedRows": "Files seleccionades",
            "dxDataGrid-exportSelectedRows": "Exporta les files seleccionades a {0}",
            "dxDataGrid-exportAll": "Exporta totes les dades a {0}",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Show filter options for column '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(Blancs)",
            "dxDataGrid-headerFilterOK": "D'acord",
            "dxDataGrid-headerFilterCancel": "Cancel\xb7lar",
            "dxDataGrid-ariaAdaptiveCollapse": "Amagueu les dades addicionals",
            "dxDataGrid-ariaAdaptiveExpand": "Mostra dades addicionals",
            "dxDataGrid-ariaColumn": "Columna",
            "dxDataGrid-ariaColumnHeader": "Column header",
            "dxDataGrid-ariaValue": "Valorar",
            "dxDataGrid-ariaError": "Error",
            "dxDataGrid-ariaRevertButton": "Press Escape to discard the changes",
            "dxDataGrid-ariaFilterCell": "Filtrar la cel\xb7la",
            "dxDataGrid-ariaCollapse": "Col\xb7lapsar",
            "dxDataGrid-ariaModifiedCell": "Modified",
            "dxDataGrid-ariaDeletedCell": "Deleted",
            "dxDataGrid-ariaEditableCell": "Editable",
            "dxDataGrid-ariaExpand": "Expandir",
            "dxDataGrid-ariaCollapsedRow": "Collapsed row",
            "dxDataGrid-ariaExpandedRow": "Expanded row",
            "dxDataGrid-ariaDataGrid": "Dades Grim",
            "dxDataGrid-ariaSearchInGrid": "Cerqueu a la graella de dades",
            "dxDataGrid-ariaSelectAll": "Seleccionar tot",
            "dxDataGrid-ariaSelectRow": "Seleccioneu la fila",
            "dxDataGrid-ariaToolbar": "Barra d\u2019eines de quadr\xedcula de dades",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "Creador de filtres",
            "dxDataGrid-filterPanelCreateFilter": "Crea un filtre",
            "dxDataGrid-filterPanelClearFilter": "Clar",
            "dxDataGrid-filterPanelFilterEnabledHint": "Activa el filtre",
            "dxDataGrid-masterDetail": "Cell with details",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaExpandableInstruction": "Press Ctrl + right arrow to expand the focused node and Ctrl + left arrow to collapse it",
            "dxTreeList-ariaSearchInGrid": "Cerqueu a la llista d\u2019arbres",
            "dxTreeList-ariaToolbar": "Barra d\u2019eines de llista d\u2019arbres",
            "dxTreeList-editingAddRowToNode": "Addiccionar",
            "dxPager-infoText": "P\xe0gina {0} de {1} ({2} \xedtems)",
            "dxPager-pagesCountText": "de",
            "dxPager-pageSize": "Items per page: {0}",
            "dxPager-pageSizesAllText": "Tota",
            "dxPager-page": "P\xe0gina {0}",
            "dxPager-prevPage": "P\xe0gina anterior",
            "dxPager-nextPage": "P\xe0gina seg\xfcent",
            "dxPager-ariaLabel": "Navegaci\xf3 de p\xe0gina",
            "dxPager-ariaPageSize": "Page size",
            "dxPager-ariaPageNumber": "Page number",
            "dxPagination-infoText": "P\xe0gina {0} de {1} ({2} \xedtems)",
            "dxPagination-pagesCountText": "de",
            "dxPagination-pageSize": "Items per page: {0}",
            "dxPagination-pageSizesAllText": "Tota",
            "dxPagination-page": "P\xe0gina {0}",
            "dxPagination-prevPage": "P\xe0gina anterior",
            "dxPagination-nextPage": "P\xe0gina seg\xfcent",
            "dxPagination-ariaLabel": "Navegaci\xf3 de p\xe0gina",
            "dxPagination-ariaPageSize": "Page size",
            "dxPagination-ariaPageNumber": "Page number",
            "dxPivotGrid-grandTotal": "Total Imal",
            "dxPivotGrid-total": "{0} total",
            "dxPivotGrid-fieldChooserTitle": "Escollit de camp",
            "dxPivotGrid-showFieldChooser": "Mostra el camp de camp",
            "dxPivotGrid-expandAll": "Ampliar tot",
            "dxPivotGrid-collapseAll": "Col\xb7lapsar tot",
            "dxPivotGrid-sortColumnBySummary": 'Ordena "{0}" per aquesta columna',
            "dxPivotGrid-sortRowBySummary": 'Ordena "{0}" per aquesta fila',
            "dxPivotGrid-removeAllSorting": "Traieu tota la classificaci\xf3",
            "dxPivotGrid-dataNotAvailable": "N/a",
            "dxPivotGrid-rowFields": "Camps de fila",
            "dxPivotGrid-columnFields": "Camps de columna",
            "dxPivotGrid-dataFields": "Camps de dades",
            "dxPivotGrid-filterFields": "Camps de filtres",
            "dxPivotGrid-allFields": "Tots els camps",
            "dxPivotGrid-columnFieldArea": "Els camps de columna Drop aqu\xed",
            "dxPivotGrid-dataFieldArea": "Deixar els camps de dades aqu\xed",
            "dxPivotGrid-rowFieldArea": "Els camps de fila de la fila aqu\xed",
            "dxPivotGrid-filterFieldArea": "Els camps de filtre de baixada aqu\xed",
            "dxScheduler-ariaLabel": "Scheduler. {0} view",
            "dxScheduler-appointmentAriaLabel-group": "Group: {0}",
            "dxScheduler-appointmentAriaLabel-recurring": "Recurring appointment",
            "dxScheduler-editorLabelTitle": "Assignatura",
            "dxScheduler-editorLabelStartDate": "Data d'inici",
            "dxScheduler-editorLabelEndDate": "Data de finalitzaci\xf3",
            "dxScheduler-editorLabelDescription": "Descripci\xf3",
            "dxScheduler-editorLabelRecurrence": "Repetir",
            "dxScheduler-navigationPrevious": "Previous page",
            "dxScheduler-navigationNext": "Next page",
            "dxScheduler-openAppointment": "Cita oberta",
            "dxScheduler-recurrenceNever": "Mai",
            "dxScheduler-recurrenceMinutely": "Cada minut",
            "dxScheduler-recurrenceHourly": "Per hora",
            "dxScheduler-recurrenceDaily": "Cada dia",
            "dxScheduler-recurrenceWeekly": "Semanalment",
            "dxScheduler-recurrenceMonthly": "Mensual",
            "dxScheduler-recurrenceYearly": "Any anual",
            "dxScheduler-recurrenceRepeatEvery": "Repetiu tots",
            "dxScheduler-recurrenceRepeatOn": "Repetiu",
            "dxScheduler-recurrenceEnd": "Repetiu final",
            "dxScheduler-recurrenceAfter": "Despr\xe9s",
            "dxScheduler-recurrenceOn": "Al damunt de",
            "dxScheduler-recurrenceRepeatMinutely": "Minut (s)",
            "dxScheduler-recurrenceRepeatHourly": "hora (s)",
            "dxScheduler-recurrenceRepeatDaily": "dia (s)",
            "dxScheduler-recurrenceRepeatWeekly": "Setmana (S)",
            "dxScheduler-recurrenceRepeatMonthly": "mes (s)",
            "dxScheduler-recurrenceRepeatYearly": "any (s)",
            "dxScheduler-switcherDay": "Dia",
            "dxScheduler-switcherWeek": "Setmana",
            "dxScheduler-switcherWorkWeek": "Setmana del treball",
            "dxScheduler-switcherMonth": "Mes",
            "dxScheduler-switcherAgenda": "Agenda",
            "dxScheduler-switcherTimelineDay": "Dia de la Cronologia",
            "dxScheduler-switcherTimelineWeek": "Setmana de la Cronologia",
            "dxScheduler-switcherTimelineWorkWeek": "Setmana del Treball de la Cronologia",
            "dxScheduler-switcherTimelineMonth": "Mes de la l\xednia de temps",
            "dxScheduler-recurrenceRepeatOnDate": "a la data",
            "dxScheduler-recurrenceRepeatCount": "Aparici\xf3 (s)",
            "dxScheduler-allDay": "Tot el dia",
            "dxScheduler-ariaEditForm": "Edit form",
            "dxScheduler-confirmRecurrenceEditTitle": "Edit Recurring Appointment",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Delete Recurring Appointment",
            "dxScheduler-confirmRecurrenceEditMessage": "Voleu editar nom\xe9s aquesta cita o tota la s\xe8rie?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Voleu eliminar nom\xe9s aquesta cita o tota la s\xe8rie?",
            "dxScheduler-confirmRecurrenceEditSeries": "Editar la s\xe8rie",
            "dxScheduler-confirmRecurrenceDeleteSeries": "Eliminar la s\xe8rie",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Editar la cita",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "Suprimeix la cita",
            "dxScheduler-noTimezoneTitle": "Sense zona hor\xe0ria",
            "dxScheduler-moreAppointments": "{0} M\xe9s",
            "dxCalendar-currentDay": "Today",
            "dxCalendar-currentMonth": "Current month",
            "dxCalendar-currentYear": "Current year",
            "dxCalendar-currentYearRange": "Current year range",
            "dxCalendar-todayButtonText": "Avui",
            "dxCalendar-ariaWidgetName": "Calendari",
            "dxCalendar-previousMonthButtonLabel": "Previous month",
            "dxCalendar-previousYearButtonLabel": "Previous year",
            "dxCalendar-previousDecadeButtonLabel": "Previous decade",
            "dxCalendar-previousCenturyButtonLabel": "Previous century",
            "dxCalendar-nextMonthButtonLabel": "Next month",
            "dxCalendar-nextYearButtonLabel": "Next year",
            "dxCalendar-nextDecadeButtonLabel": "Next decade",
            "dxCalendar-nextCenturyButtonLabel": "Next century",
            "dxCalendar-captionMonthLabel": "Month selection",
            "dxCalendar-captionYearLabel": "Year selection",
            "dxCalendar-captionDecadeLabel": "Decade selection",
            "dxCalendar-captionCenturyLabel": "Century selection",
            "dxCalendar-selectedDate": "The selected date is {0}",
            "dxCalendar-selectedDates": "The selected dates",
            "dxCalendar-selectedDateRange": "The selected date range is from {0} to {1}",
            "dxCalendar-selectedMultipleDateRange": "from {0} to {1}",
            "dxCalendar-selectedDateRangeCount": "There are {0} selected date ranges",
            "dxCalendar-readOnlyLabel": "Read-only calendar",
            "dxAvatar-defaultImageAlt": "Avatar",
            "dxChat-elementAriaLabel": "Chat",
            "dxChat-textareaPlaceholder": "Type a message",
            "dxChat-sendButtonAriaLabel": "Send",
            "dxChat-defaultUserName": "Unknown User",
            "dxChat-messageListAriaLabel": "Message list",
            "dxChat-alertListAriaLabel": "Error list",
            "dxChat-emptyListMessage": "There are no messages in this chat",
            "dxChat-emptyListPrompt": "Write your first message",
            "dxChat-typingMessageSingleUser": "{0} is typing...",
            "dxChat-typingMessageTwoUsers": "{0} and {1} are typing...",
            "dxChat-typingMessageThreeUsers": "{0}, {1} and {2} are typing...",
            "dxChat-typingMessageMultipleUsers": "{0} and others are typing...",
            "dxColorView-ariaRed": "Vermell",
            "dxColorView-ariaGreen": "Verd",
            "dxColorView-ariaBlue": "Blava",
            "dxColorView-ariaAlpha": "Transpar\xe8ncia",
            "dxColorView-ariaHex": "Codi de color",
            "dxTagBox-selected": "{0} seleccionat",
            "dxTagBox-allSelected": "Tot seleccionat ({0})",
            "dxTagBox-moreSelected": "{0} M\xe9s",
            "dxTagBox-tagRoleDescription": "Tag. Press the delete button to remove this tag",
            "vizExport-printingButtonText": "Imprimir",
            "vizExport-titleMenuText": "Exportaci\xf3/impressi\xf3",
            "vizExport-exportButtonText": "{0} fitxer",
            "dxFilterBuilder-and": "I",
            "dxFilterBuilder-or": "O",
            "dxFilterBuilder-notAnd": "No i",
            "dxFilterBuilder-notOr": "No o",
            "dxFilterBuilder-addCondition": "Afegiu la condici\xf3",
            "dxFilterBuilder-addGroup": "Afegiu grup",
            "dxFilterBuilder-enterValueText": "<Introdu\xefu un valor>",
            "dxFilterBuilder-filterOperationEquals": "\xc9s igual",
            "dxFilterBuilder-filterOperationNotEquals": "No \xe9s igual",
            "dxFilterBuilder-filterOperationLess": "\xc9s menys que",
            "dxFilterBuilder-filterOperationLessOrEquals": "\xc9s inferior o igual a",
            "dxFilterBuilder-filterOperationGreater": "\xc9s m\xe9s gran que",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "\xc9s superior o igual a",
            "dxFilterBuilder-filterOperationStartsWith": "Comen\xe7a amb",
            "dxFilterBuilder-filterOperationContains": "Cont\xe9",
            "dxFilterBuilder-filterOperationNotContains": "No cont\xe9",
            "dxFilterBuilder-filterOperationEndsWith": "Acaba amb",
            "dxFilterBuilder-filterOperationIsBlank": "Est\xe0 en blanc",
            "dxFilterBuilder-filterOperationIsNotBlank": "No est\xe0 en blanc",
            "dxFilterBuilder-filterOperationBetween": "\xc9s entre",
            "dxFilterBuilder-filterOperationAnyOf": "\xc9s alguna de",
            "dxFilterBuilder-filterOperationNoneOf": "No \xe9s cap",
            "dxFilterBuilder-filterAriaRootElement": "Filter builder",
            "dxFilterBuilder-filterAriaGroupLevel": "Level {0}",
            "dxFilterBuilder-filterAriaGroupItem": "Group item",
            "dxFilterBuilder-filterAriaOperationButton": "Operation",
            "dxFilterBuilder-filterAriaAddButton": "Add",
            "dxFilterBuilder-filterAriaRemoveButton": "Remove {0}",
            "dxFilterBuilder-filterAriaItemField": "Item field",
            "dxFilterBuilder-filterAriaItemOperation": "Item operation",
            "dxFilterBuilder-filterAriaItemValue": "Item value",
            "dxHtmlEditor-dialogColorCaption": "Canvia el color de la lletra",
            "dxHtmlEditor-dialogBackgroundCaption": "Canvieu el color de fons",
            "dxHtmlEditor-dialogLinkCaption": "L\u2019enlla\xe7 afegit",
            "dxHtmlEditor-dialogLinkUrlField": "Url",
            "dxHtmlEditor-dialogLinkTextField": "Text",
            "dxHtmlEditor-dialogLinkTargetField": "Obriu l'enlla\xe7 a la finestra nova",
            "dxHtmlEditor-dialogImageCaption": "Afegiu imatge",
            "dxHtmlEditor-dialogImageUrlField": "Url",
            "dxHtmlEditor-dialogImageAltField": "Text alternatiu",
            "dxHtmlEditor-dialogImageWidthField": "Amplada (PX)",
            "dxHtmlEditor-dialogImageHeightField": "Al\xe7ada (PX)",
            "dxHtmlEditor-dialogInsertTableRowsField": "Fileres",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Columnes",
            "dxHtmlEditor-dialogInsertTableCaption": "Inseriu la taula",
            "dxHtmlEditor-dialogUpdateImageCaption": "Imatge d'actualitzaci\xf3",
            "dxHtmlEditor-dialogImageUpdateButton": "Actualitzar",
            "dxHtmlEditor-dialogImageAddButton": "Addiccionar",
            "dxHtmlEditor-dialogImageSpecifyUrl": "Des del web",
            "dxHtmlEditor-dialogImageSelectFile": "Des d\u2019aquest dispositiu",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Mantenir la relaci\xf3 d'aspecte",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Codificar a la base64",
            "dxHtmlEditor-heading": "T\xedtol",
            "dxHtmlEditor-normalText": "Text normal",
            "dxHtmlEditor-background": "Color de fons",
            "dxHtmlEditor-bold": "Atrevida",
            "dxHtmlEditor-color": "Color de la lletra",
            "dxHtmlEditor-font": "Font",
            "dxHtmlEditor-italic": "En cursiva",
            "dxHtmlEditor-link": "L\u2019enlla\xe7 afegit",
            "dxHtmlEditor-image": "Afegiu imatge",
            "dxHtmlEditor-size": "Tamany",
            "dxHtmlEditor-strike": "Strikethrough",
            "dxHtmlEditor-subscript": "Subscripci\xf3",
            "dxHtmlEditor-superscript": "Super\xedndex",
            "dxHtmlEditor-underline": "Subratllar",
            "dxHtmlEditor-blockquote": "Blockquote",
            "dxHtmlEditor-header": "Cap\xe7alera",
            "dxHtmlEditor-increaseIndent": "Augmentar el sagnat",
            "dxHtmlEditor-decreaseIndent": "Disminuir el sagnat",
            "dxHtmlEditor-orderedList": "Llista ordenada",
            "dxHtmlEditor-bulletList": "Llista de bala",
            "dxHtmlEditor-alignLeft": "Alinear a l'esquerra",
            "dxHtmlEditor-alignCenter": "Alinear centre",
            "dxHtmlEditor-alignRight": "Alinear la dreta",
            "dxHtmlEditor-alignJustify": "Alinear Justify",
            "dxHtmlEditor-codeBlock": "Bloc de codis",
            "dxHtmlEditor-variable": "Afegiu la variable",
            "dxHtmlEditor-undo": "Desfer",
            "dxHtmlEditor-redo": "Tornar",
            "dxHtmlEditor-clear": "Format clar",
            "dxHtmlEditor-insertTable": "Inseriu la taula",
            "dxHtmlEditor-insertHeaderRow": "Inseriu la fila de cap\xe7alera",
            "dxHtmlEditor-insertRowAbove": "Inseriu la fila a sobre",
            "dxHtmlEditor-insertRowBelow": "Inseriu la fila a sota",
            "dxHtmlEditor-insertColumnLeft": "Inseriu la columna a l'esquerra",
            "dxHtmlEditor-insertColumnRight": "Inseriu la columna dreta",
            "dxHtmlEditor-deleteColumn": "Suprimeix la columna",
            "dxHtmlEditor-deleteRow": "Suprimeix la fila",
            "dxHtmlEditor-deleteTable": "Suprimeix la taula",
            "dxHtmlEditor-cellProperties": "Propietats de la cel\xb7la",
            "dxHtmlEditor-tableProperties": "Propietats de la taula",
            "dxHtmlEditor-insert": "Inserir",
            "dxHtmlEditor-delete": "Esborrar",
            "dxHtmlEditor-border": "Marge",
            "dxHtmlEditor-style": "Estil",
            "dxHtmlEditor-width": "Amplada",
            "dxHtmlEditor-height": "Altura",
            "dxHtmlEditor-borderColor": "Color",
            "dxHtmlEditor-borderWidth": "Border Width",
            "dxHtmlEditor-tableBackground": "Fons",
            "dxHtmlEditor-dimensions": "Dimensions",
            "dxHtmlEditor-alignment": "Alineaci\xf3",
            "dxHtmlEditor-horizontal": "Horitzontal",
            "dxHtmlEditor-vertical": "Vertical",
            "dxHtmlEditor-paddingVertical": "Encoixinat vertical",
            "dxHtmlEditor-paddingHorizontal": "Encoixinat horitzontal",
            "dxHtmlEditor-pixels": "P\xedxels",
            "dxHtmlEditor-list": "Inscriure",
            "dxHtmlEditor-ordered": "Ordenat",
            "dxHtmlEditor-bullet": "Bala",
            "dxHtmlEditor-align": "Alinear",
            "dxHtmlEditor-center": "Centre",
            "dxHtmlEditor-left": "Esquerre",
            "dxHtmlEditor-right": "Dret",
            "dxHtmlEditor-indent": "Sagnat",
            "dxHtmlEditor-justify": "Justificar",
            "dxHtmlEditor-borderStyleNone": "none",
            "dxHtmlEditor-borderStyleHidden": "hidden",
            "dxHtmlEditor-borderStyleDotted": "dotted",
            "dxHtmlEditor-borderStyleDashed": "dashed",
            "dxHtmlEditor-borderStyleSolid": "solid",
            "dxHtmlEditor-borderStyleDouble": "double",
            "dxHtmlEditor-borderStyleGroove": "groove",
            "dxHtmlEditor-borderStyleRidge": "ridge",
            "dxHtmlEditor-borderStyleInset": "inset",
            "dxHtmlEditor-borderStyleOutset": "outset",
            "dxFileManager-newDirectoryName": "Directori sense t\xedtol",
            "dxFileManager-rootDirectoryName": "Fitxers",
            "dxFileManager-errorNoAccess": "Acc\xe9s denegat. L'operaci\xf3 no s'ha pogut completar.",
            "dxFileManager-errorDirectoryExistsFormat": "El directori '{0}' ja existeix.",
            "dxFileManager-errorFileExistsFormat": "El fitxer '{0}' ja existeix.",
            "dxFileManager-errorFileNotFoundFormat": "Fitxer '{0}' No es troba.",
            "dxFileManager-errorDirectoryNotFoundFormat": "Directori '{0}' No es troba.",
            "dxFileManager-errorWrongFileExtension": "L'extensi\xf3 del fitxer no est\xe0 permesa.",
            "dxFileManager-errorMaxFileSizeExceeded": "La mida del fitxer supera la mida m\xe0xima permesa.",
            "dxFileManager-errorInvalidSymbols": "Aquest nom cont\xe9 car\xe0cters no v\xe0lids.",
            "dxFileManager-errorDefault": "Error no especificat.",
            "dxFileManager-errorDirectoryOpenFailed": "El directori no es pot obrir",
            "dxFileManager-commandCreate": "Nou directori",
            "dxFileManager-commandRename": "Rebatejar",
            "dxFileManager-commandMove": "Moure's cap a",
            "dxFileManager-commandCopy": "Copiar a",
            "dxFileManager-commandDelete": "Esborrar",
            "dxFileManager-commandDownload": "descarregar",
            "dxFileManager-commandUpload": "Pengeu fitxers",
            "dxFileManager-commandRefresh": "Actualitzaci\xf3",
            "dxFileManager-commandThumbnails": "Vista de les miniatures",
            "dxFileManager-commandDetails": "Veure detalls",
            "dxFileManager-commandClearSelection": "Selecci\xf3 clara",
            "dxFileManager-commandShowNavPane": "Panell de navegaci\xf3 de commutaci\xf3",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "Moure's cap a",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "Moure",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Copiar a",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "C\xf2pia",
            "dxFileManager-dialogRenameItemTitle": "Rebatejar",
            "dxFileManager-dialogRenameItemButtonText": "Estalviar",
            "dxFileManager-dialogCreateDirectoryTitle": "Nou directori",
            "dxFileManager-dialogCreateDirectoryButtonText": "Crear",
            "dxFileManager-dialogDeleteItemTitle": "Esborrar",
            "dxFileManager-dialogDeleteItemButtonText": "Esborrar",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Esteu segur que voleu suprimir {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Esteu segur que voleu suprimir els elements {0}?",
            "dxFileManager-dialogButtonCancel": "Cancel\xb7lar",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Creaci\xf3 d\u2019un directori a {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Creat un directori dins {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "El directori no es va crear",
            "dxFileManager-editingCreateCommonErrorMessage": "El directori no es va crear",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Canviant el nom d'un element dins de {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Canvia el nom d'un element dins de {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "L'article no es va canviar de nom",
            "dxFileManager-editingRenameCommonErrorMessage": "L'article no es va canviar de nom",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Suprimir un element de {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "Eliminaci\xf3 {0} \xedtems de {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "S'ha suprimit un element de {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "Eliminat {0} \xedtems de {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "L'article no s'ha suprimit",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} Els articles no es van eliminar",
            "dxFileManager-editingDeleteCommonErrorMessage": "Alguns articles no es van eliminar",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Moure un element a {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "Moving {0} \xedtems a {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Va traslladar un element a {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "Els articles motats {0} a {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "L'article no es va moure",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} Els articles no es van moure",
            "dxFileManager-editingMoveCommonErrorMessage": "Alguns articles no es van moure",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Copiar un element a {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "C\xf2pia {0} \xedtems a {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Va copiar un element a {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Copiat {0} \xedtems a {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "L'article no es va copiar",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} Els articles no es van copiar",
            "dxFileManager-editingCopyCommonErrorMessage": "Alguns articles no es van copiar",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "Carregant un element a {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "Pujar els elements {0} a {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Va penjar un element a {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "Carregat {0} articles a {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "L'article no s'ha penjat",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} Els articles no es van penjar",
            "dxFileManager-editingUploadCanceledMessage": "Cancel\xb7lat",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "L'article no s'ha descarregat",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} Els articles no es van descarregar",
            "dxFileManager-listDetailsColumnCaptionName": "Nom",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Data modificada",
            "dxFileManager-listDetailsColumnCaptionFileSize": "Mida de l'arxiu",
            "dxFileManager-listThumbnailsTooltipTextSize": "Tamany",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Data modificada",
            "dxFileManager-notificationProgressPanelTitle": "Progr\xe9s, progressar",
            "dxFileManager-notificationProgressPanelEmptyListText": "Sense operacions",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Cancel\xb7lat",
            "dxDiagram-categoryGeneral": "General",
            "dxDiagram-categoryFlowchart": "Diagrama de flux",
            "dxDiagram-categoryOrgChart": "Gr\xe0fic org",
            "dxDiagram-categoryContainers": "Contenidors",
            "dxDiagram-categoryCustom": "Costum",
            "dxDiagram-commandExportToSvg": "Exporta a SVG",
            "dxDiagram-commandExportToPng": "Exporta a PNG",
            "dxDiagram-commandExportToJpg": "Exporta a JPEG",
            "dxDiagram-commandUndo": "Desfer",
            "dxDiagram-commandRedo": "Tornar",
            "dxDiagram-commandFontName": "Nom del tipus de lletra",
            "dxDiagram-commandFontSize": "Mida de la font",
            "dxDiagram-commandBold": "Atrevida",
            "dxDiagram-commandItalic": "En cursiva",
            "dxDiagram-commandUnderline": "Subratllar",
            "dxDiagram-commandTextColor": "Color de la lletra",
            "dxDiagram-commandLineColor": "Color de la l\xednia",
            "dxDiagram-commandLineWidth": "Amplada de la l\xednia",
            "dxDiagram-commandLineStyle": "Estil de l\xednia",
            "dxDiagram-commandLineStyleSolid": "S\xf2lid",
            "dxDiagram-commandLineStyleDotted": "Puntejat",
            "dxDiagram-commandLineStyleDashed": "Guiat",
            "dxDiagram-commandFillColor": "Ompliu el color",
            "dxDiagram-commandAlignLeft": "Alinear a l'esquerra",
            "dxDiagram-commandAlignCenter": "Alinear centre",
            "dxDiagram-commandAlignRight": "Alinear la dreta",
            "dxDiagram-commandConnectorLineType": "Tipus de l\xednia de connector",
            "dxDiagram-commandConnectorLineStraight": "Directament",
            "dxDiagram-commandConnectorLineOrthogonal": "Ortogonal",
            "dxDiagram-commandConnectorLineStart": "Inici de la l\xednia del connector",
            "dxDiagram-commandConnectorLineEnd": "Final de la l\xednia de connector",
            "dxDiagram-commandConnectorLineNone": "Res",
            "dxDiagram-commandConnectorLineArrow": "Fletxa",
            "dxDiagram-commandFullscreen": "Pantalla completa",
            "dxDiagram-commandUnits": "Unitats",
            "dxDiagram-commandPageSize": "Mida de la p\xe0gina",
            "dxDiagram-commandPageOrientation": "Orientaci\xf3 a la p\xe0gina",
            "dxDiagram-commandPageOrientationLandscape": "Paisatge",
            "dxDiagram-commandPageOrientationPortrait": "Retrat",
            "dxDiagram-commandPageColor": "Color de la p\xe0gina",
            "dxDiagram-commandShowGrid": "Mostra la graella",
            "dxDiagram-commandSnapToGrid": "Enganxar -se a la graella",
            "dxDiagram-commandGridSize": "Mida de la graella",
            "dxDiagram-commandZoomLevel": "Nivell de zoom",
            "dxDiagram-commandAutoZoom": "Zoom autom\xe0tic",
            "dxDiagram-commandFitToContent": "Adaptat al contingut",
            "dxDiagram-commandFitToWidth": "Adaptat a l'amplada",
            "dxDiagram-commandAutoZoomByContent": "Zoom autom\xe0tic per contingut",
            "dxDiagram-commandAutoZoomByWidth": "Zoom autom\xe0tic per amplada",
            "dxDiagram-commandSimpleView": "Vista senzilla",
            "dxDiagram-commandCut": "Tallar",
            "dxDiagram-commandCopy": "C\xf2pia",
            "dxDiagram-commandPaste": "Pasta",
            "dxDiagram-commandSelectAll": "Seleccionar tot",
            "dxDiagram-commandDelete": "Esborrar",
            "dxDiagram-commandBringToFront": "Porta al front",
            "dxDiagram-commandSendToBack": "Envia a Back",
            "dxDiagram-commandLock": "Tancar",
            "dxDiagram-commandUnlock": "Descobrir",
            "dxDiagram-commandInsertShapeImage": "Inseriu la imatge ...",
            "dxDiagram-commandEditShapeImage": "Canvia la imatge ...",
            "dxDiagram-commandDeleteShapeImage": "Esborra la imatge",
            "dxDiagram-commandLayoutLeftToRight": "Esquerra a dreta",
            "dxDiagram-commandLayoutRightToLeft": "Dret a esquerra",
            "dxDiagram-commandLayoutTopToBottom": "De dalt a baix",
            "dxDiagram-commandLayoutBottomToTop": "De baix a la part superior",
            "dxDiagram-unitIn": "dins de",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "D'acord",
            "dxDiagram-dialogButtonCancel": "Cancel\xb7lar",
            "dxDiagram-dialogInsertShapeImageTitle": "Inseriu la imatge",
            "dxDiagram-dialogEditShapeImageTitle": "Canvieu la imatge",
            "dxDiagram-dialogEditShapeImageSelectButton": "Seleccioneu la imatge",
            "dxDiagram-dialogEditShapeImageLabelText": "o deixar un fitxer aqu\xed",
            "dxDiagram-uiExport": "Exportaci\xf3",
            "dxDiagram-uiProperties": "Propietats",
            "dxDiagram-uiSettings": "Configuraci\xf3",
            "dxDiagram-uiShowToolbox": "Mostra la caixa d\u2019eines",
            "dxDiagram-uiSearch": "Cerca",
            "dxDiagram-uiStyle": "Estil",
            "dxDiagram-uiLayout": "Pla",
            "dxDiagram-uiLayoutTree": "Arbre",
            "dxDiagram-uiLayoutLayered": "En capes",
            "dxDiagram-uiDiagram": "Diagrama",
            "dxDiagram-uiText": "Text",
            "dxDiagram-uiObject": "Objecte",
            "dxDiagram-uiConnector": "Connector",
            "dxDiagram-uiPage": "P\xe0gina",
            "dxDiagram-shapeText": "Text",
            "dxDiagram-shapeRectangle": "Rectangle",
            "dxDiagram-shapeEllipse": "El\xb7lipse",
            "dxDiagram-shapeCross": "Creu",
            "dxDiagram-shapeTriangle": "Triangle",
            "dxDiagram-shapeDiamond": "Diamant",
            "dxDiagram-shapeHeart": "Cor",
            "dxDiagram-shapePentagon": "Pent\xe0gon",
            "dxDiagram-shapeHexagon": "Hex\xe0gon",
            "dxDiagram-shapeOctagon": "Oct\xe0gon",
            "dxDiagram-shapeStar": "Estrella",
            "dxDiagram-shapeArrowLeft": "Fletxa esquerra",
            "dxDiagram-shapeArrowUp": "Fletxa cap amunt",
            "dxDiagram-shapeArrowRight": "Fletxa dreta",
            "dxDiagram-shapeArrowDown": "Fletxa cap avall",
            "dxDiagram-shapeArrowUpDown": "Fletxa cap avall",
            "dxDiagram-shapeArrowLeftRight": "Fletxa esquerra dreta",
            "dxDiagram-shapeProcess": "Elaborar",
            "dxDiagram-shapeDecision": "Decisi\xf3",
            "dxDiagram-shapeTerminator": "Terminador",
            "dxDiagram-shapePredefinedProcess": "Proc\xe9s predefinit",
            "dxDiagram-shapeDocument": "Document",
            "dxDiagram-shapeMultipleDocuments": "Diversos documents",
            "dxDiagram-shapeManualInput": "Entrada manual",
            "dxDiagram-shapePreparation": "Preparaci\xf3",
            "dxDiagram-shapeData": "Dades",
            "dxDiagram-shapeDatabase": "Base de dades",
            "dxDiagram-shapeHardDisk": "Disc dur",
            "dxDiagram-shapeInternalStorage": "Almacenament intern",
            "dxDiagram-shapePaperTape": "Cinta paperera",
            "dxDiagram-shapeManualOperation": "Funcionament manual",
            "dxDiagram-shapeDelay": "Retard",
            "dxDiagram-shapeStoredData": "Dades emmagatzemades",
            "dxDiagram-shapeDisplay": "Exposici\xf3",
            "dxDiagram-shapeMerge": "Fusionar",
            "dxDiagram-shapeConnector": "Connector",
            "dxDiagram-shapeOr": "O",
            "dxDiagram-shapeSummingJunction": "Resumi\xf3 de la uni\xf3",
            "dxDiagram-shapeContainerDefaultText": "Contenidor",
            "dxDiagram-shapeVerticalContainer": "Contenidor vertical",
            "dxDiagram-shapeHorizontalContainer": "Contenidor horitzontal",
            "dxDiagram-shapeCardDefaultText": "Nom de la persona",
            "dxDiagram-shapeCardWithImageOnLeft": "Targeta amb imatge a l\u2019esquerra",
            "dxDiagram-shapeCardWithImageOnTop": "Targeta amb imatge a la part superior",
            "dxDiagram-shapeCardWithImageOnRight": "Targeta amb imatge a la dreta",
            "dxGantt-dialogTitle": "T\xedtol",
            "dxGantt-dialogStartTitle": "Comen\xe7ar",
            "dxGantt-dialogEndTitle": "Final",
            "dxGantt-dialogProgressTitle": "Progr\xe9s, progressar",
            "dxGantt-dialogResourcesTitle": "Recursos",
            "dxGantt-dialogResourceManagerTitle": "Gestor d'obres",
            "dxGantt-dialogTaskDetailsTitle": "Detalls de la tasca",
            "dxGantt-dialogEditResourceListHint": "Edita la llista de recursos",
            "dxGantt-dialogEditNoResources": "Sense recursos",
            "dxGantt-dialogButtonAdd": "Addiccionar",
            "dxGantt-contextMenuNewTask": "Nova tasca",
            "dxGantt-contextMenuNewSubtask": "Nou Subtak",
            "dxGantt-contextMenuDeleteTask": "Esborra la tasca",
            "dxGantt-contextMenuDeleteDependency": "Suprimeix la depend\xe8ncia",
            "dxGantt-dialogTaskDeleteConfirmation": "Eliminar una tasca tamb\xe9 suprimeix totes les seves depend\xe8ncies i subtasces. Esteu segur que voleu suprimir aquesta tasca?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Esteu segur que voleu suprimir la depend\xe8ncia de la tasca?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Eliminar un recurs tamb\xe9 el suprimeix de les tasques a les quals s\u2019assigna aquest recurs. Esteu segur que voleu suprimir aquests recursos? Recursos: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "La tasca que intenteu moure est\xe0 vinculada a una segona tasca mitjan\xe7ant una relaci\xf3 de depend\xe8ncia. Aquest canvi entrava en conflicte amb les regles de depend\xe8ncia. Com voldr\xedeu continuar?",
            "dxGantt-dialogConstraintViolationMessage": "La tasca que intenteu moure est\xe0 vinculada a una segona tasca mitjan\xe7ant una relaci\xf3 de depend\xe8ncia. Com voldr\xedeu continuar?",
            "dxGantt-dialogCancelOperationMessage": "Cancel\xb7la l'operaci\xf3",
            "dxGantt-dialogDeleteDependencyMessage": "Suprimeix la depend\xe8ncia",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Moure la tasca i mantenir la depend\xe8ncia",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "La tasca que intenteu moure est\xe0 vinculada a una altra tasca mitjan\xe7ant les relacions de depend\xe8ncia. Aquest canvi entrava en conflicte amb les regles de depend\xe8ncia. Com voldr\xedeu continuar?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "La tasca que intenteu moure est\xe0 vinculada a una altra tasca mitjan\xe7ant les relacions de depend\xe8ncia. Com voldr\xedeu continuar?",
            "dxGantt-dialogDeleteDependenciesMessage": "Suprimeix les relacions de depend\xe8ncia",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Moure la tasca i mantenir les depend\xe8ncies",
            "dxGantt-undo": "Desfer",
            "dxGantt-redo": "Tornar",
            "dxGantt-expandAll": "Ampliar tot",
            "dxGantt-collapseAll": "Col\xb7lapsar tot",
            "dxGantt-addNewTask": "Afegiu una nova tasca",
            "dxGantt-deleteSelectedTask": "Suprimeix la tasca seleccionada",
            "dxGantt-zoomIn": "Ampliar",
            "dxGantt-zoomOut": "Disminuir el zoom",
            "dxGantt-fullScreen": "Pantalla completa",
            "dxGantt-quarter": "Q {0}",
            "dxGantt-sortingAscendingText": "Ordena Ascending",
            "dxGantt-sortingDescendingText": "Ordena descendent",
            "dxGantt-sortingClearText": "Ordenaci\xf3 clara",
            "dxGantt-showResources": "Mostrar recursos",
            "dxGantt-showDependencies": "Mostrar depend\xe8ncies",
            "dxGantt-dialogStartDateValidation": "La data d'inici ha de ser despr\xe9s de {0}",
            "dxGantt-dialogEndDateValidation": "La data de finalitzaci\xf3 ha de ser despr\xe9s de {0}",
            "dxGallery-itemName": "Gallery item",
            "dxMultiView-elementAriaRoleDescription": "MultiView",
            "dxMultiView-elementAriaLabel": "Use the arrow keys or swipe to navigate between views",
            "dxMultiView-itemAriaRoleDescription": "View",
            "dxMultiView-itemAriaLabel": "{0} of {1}",
            "dxSplitter-resizeHandleAriaLabel": "Split bar"
        }
    })
}));
