# Security Policy

## Supported Versions

This section outlines the versions of our project that are currently supported with security updates.

| Version | Supported | Release Date    |
|---------|-----------|-----------------|
| 3.3.x   | ✅         | January 3, 2025 |
| 3.2.x   | ✅         | Dec 19, 2024    |
| 3.1.x   | ⚠️        | Dec 11, 2024    |
| 3.0.x   | ⚠️        | Dec 6, 2024     |
| 2.5.x   | ✖️        | Nov 25, 2024    |
| 2.4.x   | ✖️        | Nov 12, 2024    |
| 2.3.x   | ✖️        | Sep 21, 2024    |
| 2.2.x   | ✖️        | Sep 9, 2024     |
| 2.1.x   | ✖️        | Aug 29, 2024    |
| 2.0.x   | ✖️        | Aug 25, 2024    |
| 1.6.x   | ❌         | Jun 18, 2024    |
| 1.5.x   | ❌         | Jun 10, 2024    |
| 1.4.x   | ❌         | May 30, 2024    |
| 1.3.x   | ❌         | May 21, 2024    |
| 1.2.x   | ❌         | May 16, 2024    |
| 1.1.x   | ❌         | May 10, 2024    |
| 1.0.x   | ❌         | May 4, 2024     |


### Key:

| Key | Desc                                                |
|-----|-----------------------------------------------------|
| ✅   | Supported for security updates                      |
| ⚠️  | Supported, but will leave support next major update |
| ✖️  | Only for major security issues (CVSS 8.0+)          |
| ❌   | No longer supported for any security updates        |

## Reporting a Vulnerability

If you believe you have found a security vulnerability in our project, we encourage you to report it to us. Your report
will help us improve the security of our project and ensure the trust of our users.

### How to Report a Vulnerability

1. **Identify the Vulnerability**: Clearly describe the vulnerability, including how it can be exploited and any
   potential impact.
2. **Provide Detailed Information**: Include as much detail as possible, such as the version of the project affected,
   steps to reproduce the vulnerability, and any relevant code snippets or screenshots.
3. **Contact Us**: Send your report to my [email](mailto:Nirt_12023@outlook.com). Please include "Security Vulnerability
   Report" in the subject line.

### What to Expect

- **Acknowledgment**: Upon receiving your report, we will acknowledge receipt within 2�5 business days.
- **Investigation**: Our security team will investigate the vulnerability and determine its validity.
- **Update**: If the vulnerability is accepted, we will work on a fix and provide an update on the timeline for a
  security update.
- **Communication**: We will communicate with you regarding the status of the vulnerability and any necessary actions.

### Vulnerability Acceptance Criteria

- The vulnerability must be reproducible.
- The vulnerability must be exploitable.
- The vulnerability must not be a false positive.

### Vulnerability Decline Criteria

- The vulnerability is outside the scope of our project.

Thank you for helping us maintain the security of our project. Your contribution is invaluable in keeping our users
safe.

---
