import os

from torchdrug import data, utils
from torchdrug.core import Registry as R


@R.register("datasets.SIDER")
@utils.copy_args(data.MoleculeDataset.load_csv, ignore=("smiles_field", "target_fields"))
class SIDER(data.MoleculeDataset):
    """
    Marketed drugs and adverse drug reactions (ADR) dataset, grouped into 27 system organ classes.

    Statistics:
        - #Molecule: 1,427
        - #Classification task: 27

    Parameters:
        path (str): path to store the dataset
        verbose (int, optional): output verbose level
        **kwargs
    """

    url = "http://deepchem.io.s3-website-us-west-1.amazonaws.com/datasets/sider.csv.gz"
    md5 = "77c0ef421f7cc8ce963c5836c8761fd2"
    target_fields = None # pick all targets

    def __init__(self, path, verbose=1, **kwargs):
        path = os.path.expanduser(path)
        if not os.path.exists(path):
            os.makedirs(path)
        self.path = path

        zip_file = utils.download(self.url, path, md5=self.md5)
        csv_file = utils.extract(zip_file)

        self.load_csv(csv_file, smiles_field="smiles", target_fields=self.target_fields,
                      verbose=verbose, **kwargs)