import Foundation

/// This mapper is used to transform payment names from a non-uniform format to a uniform format.
/// A dictionary that maps old, non-uniform payment names to new, uniform payment names.
public let paymentMapper: [String:String] = [
  "AmazonPay" : "amazon-pay",
  "Amex" : "amex",
  "ApplePay" : "apple-pay",
  "Bancontact-payconiq" : "bancontact-payconiq",
  "Bancontact" : "bancontact",
  "Belfius" : "belfius",
  "Bitcoin" : "bitcoin",
  "Bitpay" : "bitpay",
  "BVR" : "bvr",
  "Cadhoc" : "cadhoc",
  "Cash" : "cash",
  "CB" : "cb",
  "ChequePayment" : "cheque-payment",
  "ClickandBuy" : "click-and-buy",
  "DinersClubInternational" : "diners-club-international",
  "Discover" : "discover",
  "Dwolla" : "dwolla",
  "Elo" : "elo",
  "EPS" : "eps",
  "Eway" : "eway",
  "GiftCardPayment" : "gift-card-payment",
  "GiroPay" : "giro-pay",
  "GooglePay" : "google-pay",
  "iDeal" : "ideal",
  "Illicado" : "illicado",
  "ING" : "ing",
  "Ingenico" : "ingenico",
  "JCB" : "jcb",
  "KBC" : "kbc",
  "Klarna" : "klarna",
  "Maestro Full" : "maestro-subtext",
  "Maestro" : "maestro",
  "Mastercard Full" : "mastercard-full",
  "MasterCard ID Check" : "mastercard-id-check",
  "Mastercard" : "mastercard",
  "MB-Way" : "mb-may",
  "MB-Multibanco" : "mb-multibanco",
  "MNP" : "mnp",
  "Neteller" : "neteller",
  "Oney3x4x" : "oney-3x-4x",
  "Oney3x" : "oney-3x",
  "Oney4x" : "oney-4x",
  "Oney Classic" : "oney-classic",
  "PayU" : "pay-u",
  "Paylib" : "paylib",
  "Paymill" : "paymill",
  "Payoneer" : "payoneer",
  "Paypal" : "paypal",
  "PaysafeCard" : "paysafe-card",
  "PointsPay" : "points-pay",
  "PostFinanceE-Finance" : "post-efinance",
  "PostFinanceCard" : "post-finance",
  "PostePay" : "poste-pay",
  "PowerPay" : "power-pay",
  "Przelewy24" : "przelewy24",
  "SEPA" : "sepa",
  "Skrill" : "skrill",
  "Spirit of cadeau" : "spirit-of-cadeau",
  "Stripe" : "stripe",
  "UnionPay" : "union-pay",
  "Verifone" : "verifone",
  "Visa Classic" : "visa-classic",
  "Visa Electron" : "visa-electron",
  "Wallet" : "wallet",
  "WebMoney": "web-money",
  "WesternUnion": "western-union",
]
