package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Whatsapp: ImageVector
    get() {
        if (_whatsapp != null) {
            return _whatsapp!!
        }
        _whatsapp = Builder(name = "Whatsapp", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(2.004f, 22.0f)
                lineTo(3.356f, 17.032f)
                curveTo(2.4652f, 15.5049f, 1.9971f, 13.768f, 2.0f, 12.0f)
                curveTo(2.0f, 6.477f, 6.477f, 2.0f, 12.0f, 2.0f)
                curveTo(17.523f, 2.0f, 22.0f, 6.477f, 22.0f, 12.0f)
                curveTo(22.0f, 17.523f, 17.523f, 22.0f, 12.0f, 22.0f)
                curveTo(10.2328f, 22.0029f, 8.4967f, 21.5352f, 6.97f, 20.645f)
                lineTo(2.004f, 22.0f)
                close()
                moveTo(7.253f, 18.494f)
                lineTo(7.977f, 18.917f)
                curveTo(9.198f, 19.6291f, 10.5866f, 20.0029f, 12.0f, 20.0f)
                curveTo(16.4183f, 20.0f, 20.0f, 16.4183f, 20.0f, 12.0f)
                curveTo(20.0f, 7.5817f, 16.4183f, 4.0f, 12.0f, 4.0f)
                curveTo(7.5817f, 4.0f, 4.0f, 7.5817f, 4.0f, 12.0f)
                curveTo(4.0f, 13.436f, 4.377f, 14.813f, 5.084f, 16.024f)
                lineTo(5.506f, 16.748f)
                lineTo(4.853f, 19.149f)
                lineTo(7.253f, 18.494f)
                close()
                moveTo(8.794f, 7.304f)
                curveTo(8.66f, 7.298f, 8.525f, 7.298f, 8.391f, 7.308f)
                lineTo(8.39f, 7.307f)
                curveTo(8.2609f, 7.315f, 8.1347f, 7.349f, 8.019f, 7.407f)
                curveTo(7.932f, 7.451f, 7.852f, 7.515f, 7.725f, 7.635f)
                curveTo(7.6244f, 7.7305f, 7.5596f, 7.8153f, 7.4978f, 7.896f)
                curveTo(7.4865f, 7.9108f, 7.4753f, 7.9254f, 7.464f, 7.94f)
                curveTo(7.0944f, 8.4217f, 6.8959f, 9.0128f, 6.9f, 9.62f)
                curveTo(6.9094f, 10.1094f, 7.0222f, 10.5913f, 7.231f, 11.034f)
                curveTo(7.639f, 11.936f, 8.311f, 12.891f, 9.201f, 13.776f)
                curveTo(9.2348f, 13.8096f, 9.2685f, 13.8433f, 9.3021f, 13.8769f)
                curveTo(9.4814f, 14.0562f, 9.6597f, 14.2344f, 9.85f, 14.402f)
                curveTo(10.9534f, 15.3735f, 12.2683f, 16.074f, 13.69f, 16.448f)
                curveTo(13.69f, 16.448f, 14.25f, 16.535f, 14.258f, 16.535f)
                curveTo(14.4175f, 16.5436f, 14.5762f, 16.5345f, 14.7349f, 16.5254f)
                curveTo(14.7613f, 16.5239f, 14.7876f, 16.5224f, 14.814f, 16.521f)
                curveTo(15.1052f, 16.5063f, 15.3895f, 16.4278f, 15.647f, 16.291f)
                curveTo(15.7778f, 16.2233f, 15.9056f, 16.1499f, 16.03f, 16.071f)
                curveTo(16.0723f, 16.0419f, 16.114f, 16.0119f, 16.155f, 15.981f)
                curveTo(16.2736f, 15.8954f, 16.3841f, 15.7989f, 16.485f, 15.693f)
                curveTo(16.5707f, 15.6042f, 16.6416f, 15.5022f, 16.695f, 15.391f)
                curveTo(16.773f, 15.228f, 16.851f, 14.917f, 16.883f, 14.658f)
                curveTo(16.906f, 14.46f, 16.9f, 14.352f, 16.896f, 14.285f)
                curveTo(16.893f, 14.178f, 16.804f, 14.067f, 16.706f, 14.02f)
                lineTo(16.124f, 13.759f)
                curveTo(16.124f, 13.759f, 15.255f, 13.38f, 14.724f, 13.137f)
                curveTo(14.668f, 13.112f, 14.607f, 13.101f, 14.547f, 13.097f)
                curveTo(14.4086f, 13.0828f, 14.2708f, 13.1291f, 14.169f, 13.224f)
                verticalLineTo(13.222f)
                curveTo(14.163f, 13.222f, 14.097f, 13.279f, 13.373f, 14.156f)
                curveTo(13.2883f, 14.2697f, 13.1434f, 14.321f, 13.006f, 14.286f)
                curveTo(12.941f, 14.269f, 12.877f, 14.246f, 12.815f, 14.22f)
                curveTo(12.7355f, 14.186f, 12.6892f, 14.1656f, 12.6439f, 14.1455f)
                curveTo(12.6185f, 14.1343f, 12.5935f, 14.1233f, 12.563f, 14.11f)
                lineTo(12.558f, 14.108f)
                curveTo(11.986f, 13.858f, 11.456f, 13.521f, 10.988f, 13.108f)
                curveTo(10.8949f, 13.026f, 10.8067f, 12.9396f, 10.7186f, 12.8532f)
                curveTo(10.6874f, 12.8227f, 10.6563f, 12.7923f, 10.625f, 12.762f)
                curveTo(10.205f, 12.354f, 9.861f, 11.921f, 9.605f, 11.494f)
                lineTo(9.546f, 11.399f)
                curveTo(9.504f, 11.331f, 9.458f, 11.25f, 9.444f, 11.194f)
                curveTo(9.406f, 11.047f, 9.505f, 10.929f, 9.505f, 10.929f)
                curveTo(9.505f, 10.929f, 9.748f, 10.663f, 9.861f, 10.518f)
                curveTo(9.9551f, 10.3986f, 10.0429f, 10.2745f, 10.124f, 10.146f)
                curveTo(10.242f, 9.956f, 10.279f, 9.761f, 10.217f, 9.609f)
                curveTo(9.937f, 8.926f, 9.647f, 8.245f, 9.349f, 7.569f)
                curveTo(9.29f, 7.435f, 9.115f, 7.338f, 8.956f, 7.32f)
                curveTo(8.902f, 7.314f, 8.848f, 7.308f, 8.794f, 7.304f)
                close()
            }
        }
        .build()
        return _whatsapp!!
    }

private var _whatsapp: ImageVector? = null
