package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Truck: ImageVector
    get() {
        if (_truck != null) {
            return _truck!!
        }
        _truck = Builder(name = "Truck", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(8.965f, 18.0f)
                curveTo(8.8461f, 18.8343f, 8.4302f, 19.5977f, 7.7937f, 20.1499f)
                curveTo(7.1571f, 20.7022f, 6.3427f, 21.0063f, 5.5f, 21.0063f)
                curveTo(4.6573f, 21.0063f, 3.8429f, 20.7022f, 3.2063f, 20.1499f)
                curveTo(2.5698f, 19.5977f, 2.1539f, 18.8343f, 2.035f, 18.0f)
                horizontalLineTo(1.0f)
                verticalLineTo(6.0f)
                curveTo(1.0f, 5.7348f, 1.1054f, 5.4804f, 1.2929f, 5.2929f)
                curveTo(1.4804f, 5.1054f, 1.7348f, 5.0f, 2.0f, 5.0f)
                horizontalLineTo(16.0f)
                curveTo(16.2652f, 5.0f, 16.5196f, 5.1054f, 16.7071f, 5.2929f)
                curveTo(16.8946f, 5.4804f, 17.0f, 5.7348f, 17.0f, 6.0f)
                verticalLineTo(8.0f)
                horizontalLineTo(20.0f)
                lineTo(23.0f, 12.056f)
                verticalLineTo(18.0f)
                horizontalLineTo(20.965f)
                curveTo(20.8461f, 18.8343f, 20.4302f, 19.5977f, 19.7937f, 20.1499f)
                curveTo(19.1571f, 20.7022f, 18.3427f, 21.0063f, 17.5f, 21.0063f)
                curveTo(16.6573f, 21.0063f, 15.8429f, 20.7022f, 15.2063f, 20.1499f)
                curveTo(14.5698f, 19.5977f, 14.1539f, 18.8343f, 14.035f, 18.0f)
                horizontalLineTo(8.965f)
                close()
                moveTo(15.0f, 7.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(15.05f)
                curveTo(3.3946f, 14.6472f, 3.8806f, 14.3457f, 4.4167f, 14.1711f)
                curveTo(4.9529f, 13.9966f, 5.5233f, 13.9541f, 6.0794f, 14.0474f)
                curveTo(6.6355f, 14.1407f, 7.1608f, 14.3669f, 7.6106f, 14.7069f)
                curveTo(8.0604f, 15.0469f, 8.4215f, 15.4905f, 8.663f, 16.0f)
                horizontalLineTo(14.337f)
                curveTo(14.505f, 15.647f, 14.73f, 15.326f, 15.0f, 15.05f)
                verticalLineTo(7.0f)
                close()
                moveTo(17.0f, 13.0f)
                horizontalLineTo(21.0f)
                verticalLineTo(12.715f)
                lineTo(18.992f, 10.0f)
                horizontalLineTo(17.0f)
                verticalLineTo(13.0f)
                close()
                moveTo(17.5f, 19.0f)
                curveTo(17.898f, 19.0f, 18.2796f, 18.8419f, 18.561f, 18.5605f)
                curveTo(18.8424f, 18.2791f, 19.0005f, 17.8975f, 19.0005f, 17.4995f)
                curveTo(19.0005f, 17.1015f, 18.8424f, 16.7199f, 18.561f, 16.4385f)
                curveTo(18.2796f, 16.1571f, 17.898f, 15.999f, 17.5f, 15.999f)
                curveTo(17.102f, 15.999f, 16.7204f, 16.1571f, 16.439f, 16.4385f)
                curveTo(16.1576f, 16.7199f, 15.9995f, 17.1015f, 15.9995f, 17.4995f)
                curveTo(15.9995f, 17.8975f, 16.1576f, 18.2791f, 16.439f, 18.5605f)
                curveTo(16.7204f, 18.8419f, 17.102f, 19.0f, 17.5f, 19.0f)
                close()
                moveTo(7.0f, 17.5f)
                curveTo(7.0f, 17.303f, 6.9612f, 17.108f, 6.8858f, 16.926f)
                curveTo(6.8104f, 16.744f, 6.7f, 16.5786f, 6.5607f, 16.4393f)
                curveTo(6.4214f, 16.3001f, 6.256f, 16.1896f, 6.074f, 16.1142f)
                curveTo(5.892f, 16.0388f, 5.697f, 16.0f, 5.5f, 16.0f)
                curveTo(5.303f, 16.0f, 5.108f, 16.0388f, 4.926f, 16.1142f)
                curveTo(4.744f, 16.1896f, 4.5786f, 16.3001f, 4.4393f, 16.4393f)
                curveTo(4.3f, 16.5786f, 4.1896f, 16.744f, 4.1142f, 16.926f)
                curveTo(4.0388f, 17.108f, 4.0f, 17.303f, 4.0f, 17.5f)
                curveTo(4.0f, 17.8978f, 4.158f, 18.2794f, 4.4393f, 18.5607f)
                curveTo(4.7206f, 18.842f, 5.1022f, 19.0f, 5.5f, 19.0f)
                curveTo(5.8978f, 19.0f, 6.2794f, 18.842f, 6.5607f, 18.5607f)
                curveTo(6.842f, 18.2794f, 7.0f, 17.8978f, 7.0f, 17.5f)
                close()
            }
        }
        .build()
        return _truck!!
    }

private var _truck: ImageVector? = null
