package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Tiktok: ImageVector
    get() {
        if (_tiktok != null) {
            return _tiktok!!
        }
        _tiktok = Builder(name = "Tiktok", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(5.91f, 11.69f)
                curveTo(5.3974f, 12.1626f, 4.971f, 12.721f, 4.6501f, 13.34f)
                curveTo(4.2388f, 14.1604f, 4.0167f, 15.0625f, 4.0001f, 15.98f)
                curveTo(3.9973f, 16.6891f, 4.1052f, 17.3942f, 4.32f, 18.07f)
                verticalLineTo(18.13f)
                curveTo(4.5148f, 18.6532f, 4.7734f, 19.1502f, 5.0901f, 19.61f)
                lineTo(5.45f, 20.05f)
                verticalLineTo(19.96f)
                lineTo(6.45f, 20.96f)
                curveTo(7.2962f, 21.537f, 8.2959f, 21.8471f, 9.3201f, 21.85f)
                curveTo(10.1012f, 21.8515f, 10.8717f, 21.67f, 11.5701f, 21.32f)
                curveTo(12.2554f, 20.9664f, 12.8638f, 20.4804f, 13.3601f, 19.89f)
                curveTo(13.7867f, 19.3615f, 14.1244f, 18.767f, 14.3601f, 18.13f)
                curveTo(14.5701f, 17.4831f, 14.6879f, 16.8098f, 14.7101f, 16.13f)
                verticalLineTo(8.05f)
                lineTo(15.5701f, 8.61f)
                lineTo(16.1501f, 9.02f)
                curveTo(16.6946f, 9.3547f, 17.2838f, 9.6105f, 17.9001f, 9.78f)
                curveTo(18.307f, 9.8854f, 18.7216f, 9.959f, 19.1401f, 10.0f)
                verticalLineTo(7.77f)
                curveTo(18.5391f, 7.6766f, 17.9579f, 7.484f, 17.4201f, 7.2f)
                curveTo(17.2757f, 7.1206f, 17.1355f, 7.0339f, 17.0001f, 6.94f)
                curveTo(16.608f, 6.6694f, 16.2518f, 6.3502f, 15.9401f, 5.99f)
                curveTo(15.3123f, 5.2324f, 14.8981f, 4.3211f, 14.7401f, 3.35f)
                lineTo(14.6801f, 3.0f)
                horizontalLineTo(12.5701f)
                verticalLineTo(16.31f)
                curveTo(12.5399f, 16.8924f, 12.3683f, 17.4588f, 12.0701f, 17.96f)
                curveTo(11.7845f, 18.4387f, 11.3863f, 18.8404f, 10.9101f, 19.13f)
                curveTo(10.4228f, 19.4299f, 9.8622f, 19.5891f, 9.29f, 19.59f)
                curveTo(8.3891f, 19.5612f, 7.5361f, 19.1769f, 6.9177f, 18.521f)
                curveTo(6.2993f, 17.8652f, 5.9658f, 16.9911f, 5.99f, 16.09f)
                curveTo(5.9812f, 15.6225f, 6.0687f, 15.1582f, 6.2469f, 14.7259f)
                curveTo(6.4251f, 14.2936f, 6.6904f, 13.9026f, 7.0261f, 13.5772f)
                curveTo(7.3619f, 13.2517f, 7.761f, 12.9988f, 8.1986f, 12.8342f)
                curveTo(8.6362f, 12.6695f, 9.1031f, 12.5966f, 9.5701f, 12.62f)
                verticalLineTo(10.35f)
                curveTo(8.991f, 10.327f, 8.4124f, 10.4048f, 7.8601f, 10.58f)
                curveTo(7.1371f, 10.804f, 6.4717f, 11.1828f, 5.91f, 11.69f)
                close()
            }
        }
        .build()
        return _tiktok!!
    }

private var _tiktok: ImageVector? = null
