package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.TempHot: ImageVector
    get() {
        if (_tempHot != null) {
            return _tempHot!!
        }
        _tempHot = Builder(name = "TempHot", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(8.0f, 5.0f)
                curveTo(8.0f, 3.9391f, 8.4214f, 2.9217f, 9.1716f, 2.1716f)
                curveTo(9.9217f, 1.4214f, 10.9391f, 1.0f, 12.0f, 1.0f)
                curveTo(13.0609f, 1.0f, 14.0783f, 1.4214f, 14.8284f, 2.1716f)
                curveTo(15.5786f, 2.9217f, 16.0f, 3.9391f, 16.0f, 5.0f)
                verticalLineTo(10.255f)
                curveTo(17.223f, 11.1066f, 18.1423f, 12.3262f, 18.6241f, 13.7365f)
                curveTo(19.1059f, 15.1467f, 19.125f, 16.6739f, 18.6788f, 18.0958f)
                curveTo(18.2325f, 19.5176f, 17.3441f, 20.76f, 16.1429f, 21.642f)
                curveTo(14.9416f, 22.524f, 13.4903f, 22.9996f, 12.0f, 22.9996f)
                curveTo(10.5097f, 22.9996f, 9.0584f, 22.524f, 7.8571f, 21.642f)
                curveTo(6.6559f, 20.76f, 5.7675f, 19.5176f, 5.3212f, 18.0958f)
                curveTo(4.875f, 16.6739f, 4.8941f, 15.1467f, 5.3759f, 13.7365f)
                curveTo(5.8577f, 12.3262f, 6.777f, 11.1066f, 8.0f, 10.255f)
                verticalLineTo(5.0f)
                close()
                moveTo(9.144f, 11.895f)
                curveTo(8.2702f, 12.5031f, 7.6132f, 13.3742f, 7.2688f, 14.3816f)
                curveTo(6.9245f, 15.3889f, 6.9106f, 16.4799f, 7.2292f, 17.4957f)
                curveTo(7.5479f, 18.5115f, 8.1825f, 19.399f, 9.0405f, 20.0291f)
                curveTo(9.8986f, 20.6593f, 10.9354f, 20.9991f, 12.0f, 20.9991f)
                curveTo(13.0646f, 20.9991f, 14.1014f, 20.6593f, 14.9595f, 20.0291f)
                curveTo(15.8175f, 19.399f, 16.4521f, 18.5115f, 16.7708f, 17.4957f)
                curveTo(17.0894f, 16.4799f, 17.0755f, 15.3889f, 16.7311f, 14.3816f)
                curveTo(16.3868f, 13.3742f, 15.7298f, 12.5031f, 14.856f, 11.895f)
                lineTo(14.0f, 11.298f)
                verticalLineTo(5.0f)
                curveTo(14.0f, 4.4696f, 13.7893f, 3.9609f, 13.4142f, 3.5858f)
                curveTo(13.0391f, 3.2107f, 12.5304f, 3.0f, 12.0f, 3.0f)
                curveTo(11.4696f, 3.0f, 10.9609f, 3.2107f, 10.5858f, 3.5858f)
                curveTo(10.2107f, 3.9609f, 10.0f, 4.4696f, 10.0f, 5.0f)
                verticalLineTo(11.298f)
                lineTo(9.144f, 11.895f)
                close()
                moveTo(11.0f, 12.126f)
                verticalLineTo(5.0f)
                horizontalLineTo(13.0f)
                verticalLineTo(12.126f)
                curveTo(13.9405f, 12.3717f, 14.7594f, 12.9514f, 15.3038f, 13.7567f)
                curveTo(15.8482f, 14.562f, 16.0809f, 15.5379f, 15.9584f, 16.5022f)
                curveTo(15.836f, 17.4665f, 15.3667f, 18.3533f, 14.6383f, 18.997f)
                curveTo(13.9099f, 19.6406f, 12.9721f, 19.9972f, 12.0f, 20.0f)
                curveTo(11.0257f, 20.001f, 10.0846f, 19.6463f, 9.3533f, 19.0026f)
                curveTo(8.6219f, 18.3589f, 8.1507f, 17.4705f, 8.0279f, 16.504f)
                curveTo(7.9052f, 15.5375f, 8.1394f, 14.5594f, 8.6866f, 13.7533f)
                curveTo(9.2338f, 12.9472f, 10.0564f, 12.3686f, 11.0f, 12.126f)
                close()
                moveTo(12.0f, 18.0f)
                curveTo(12.5304f, 18.0f, 13.0391f, 17.7893f, 13.4142f, 17.4142f)
                curveTo(13.7893f, 17.0391f, 14.0f, 16.5304f, 14.0f, 16.0f)
                curveTo(14.0f, 15.4696f, 13.7893f, 14.9609f, 13.4142f, 14.5858f)
                curveTo(13.0391f, 14.2107f, 12.5304f, 14.0f, 12.0f, 14.0f)
                curveTo(11.4696f, 14.0f, 10.9609f, 14.2107f, 10.5858f, 14.5858f)
                curveTo(10.2107f, 14.9609f, 10.0f, 15.4696f, 10.0f, 16.0f)
                curveTo(10.0f, 16.5304f, 10.2107f, 17.0391f, 10.5858f, 17.4142f)
                curveTo(10.9609f, 17.7893f, 11.4696f, 18.0f, 12.0f, 18.0f)
                close()
            }
        }
        .build()
        return _tempHot!!
    }

private var _tempHot: ImageVector? = null
