package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Snowy: ImageVector
    get() {
        if (_snowy != null) {
            return _snowy!!
        }
        _snowy = Builder(name = "Snowy", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(13.0f, 16.268f)
                lineTo(14.964f, 15.134f)
                lineTo(15.964f, 16.866f)
                lineTo(14.0f, 18.0f)
                lineTo(15.964f, 19.134f)
                lineTo(14.964f, 20.866f)
                lineTo(13.0f, 19.732f)
                verticalLineTo(22.0f)
                horizontalLineTo(11.0f)
                verticalLineTo(19.732f)
                lineTo(9.036f, 20.866f)
                lineTo(8.036f, 19.134f)
                lineTo(10.0f, 18.0f)
                lineTo(8.036f, 16.866f)
                lineTo(9.036f, 15.134f)
                lineTo(11.0f, 16.268f)
                verticalLineTo(14.0f)
                horizontalLineTo(13.0f)
                verticalLineTo(16.268f)
                close()
                moveTo(17.0f, 18.0f)
                verticalLineTo(16.0f)
                horizontalLineTo(17.5f)
                curveTo(18.077f, 15.9999f, 18.6451f, 15.8571f, 19.1536f, 15.5844f)
                curveTo(19.6621f, 15.3117f, 20.0953f, 14.9175f, 20.4147f, 14.4369f)
                curveTo(20.734f, 13.9562f, 20.9296f, 13.4041f, 20.9839f, 12.8296f)
                curveTo(21.0383f, 12.2552f, 20.9497f, 11.6762f, 20.7262f, 11.1442f)
                curveTo(20.5027f, 10.6122f, 20.1511f, 10.1437f, 19.7028f, 9.7805f)
                curveTo(19.2544f, 9.4172f, 18.7232f, 9.1705f, 18.1564f, 9.0622f)
                curveTo(17.5896f, 8.9538f, 17.0049f, 8.9874f, 16.4541f, 9.1597f)
                curveTo(15.9034f, 9.332f, 15.4039f, 9.6379f, 15.0f, 10.05f)
                verticalLineTo(10.0f)
                curveTo(14.9996f, 8.9001f, 14.6969f, 7.8214f, 14.1249f, 6.8819f)
                curveTo(13.5529f, 5.9425f, 12.7337f, 5.1783f, 11.7568f, 4.6729f)
                curveTo(10.7798f, 4.1676f, 9.6828f, 3.9405f, 8.5855f, 4.0164f)
                curveTo(7.4882f, 4.0924f, 6.433f, 4.4686f, 5.535f, 5.1037f)
                curveTo(4.6371f, 5.7389f, 3.931f, 6.6087f, 3.4939f, 7.6181f)
                curveTo(3.0569f, 8.6274f, 2.9057f, 9.7375f, 3.0569f, 10.8269f)
                curveTo(3.2081f, 11.9164f, 3.6559f, 12.9433f, 4.3513f, 13.7955f)
                curveTo(5.0467f, 14.6477f, 5.963f, 15.2923f, 7.0f, 15.659f)
                verticalLineTo(17.748f)
                curveTo(5.6737f, 17.4048f, 4.4577f, 16.7267f, 3.4687f, 15.7788f)
                curveTo(2.4796f, 14.8309f, 1.7505f, 13.6448f, 1.3513f, 12.3343f)
                curveTo(0.9521f, 11.0238f, 0.8961f, 9.6327f, 1.1887f, 8.2944f)
                curveTo(1.4813f, 6.956f, 2.1127f, 5.7152f, 3.0224f, 4.6909f)
                curveTo(3.9321f, 3.6665f, 5.0896f, 2.893f, 6.384f, 2.4443f)
                curveTo(7.6784f, 1.9956f, 9.0664f, 1.8868f, 10.4149f, 2.1284f)
                curveTo(11.7634f, 2.37f, 13.0273f, 2.9539f, 14.0854f, 3.824f)
                curveTo(15.1435f, 4.6942f, 15.9605f, 5.8215f, 16.458f, 7.098f)
                curveTo(17.21f, 6.9541f, 17.9838f, 6.9688f, 18.7299f, 7.1412f)
                curveTo(19.4759f, 7.3136f, 20.1777f, 7.6398f, 20.7904f, 8.0991f)
                curveTo(21.403f, 8.5583f, 21.9131f, 9.1404f, 22.2878f, 9.8081f)
                curveTo(22.6626f, 10.4758f, 22.8938f, 11.2144f, 22.9666f, 11.9767f)
                curveTo(23.0395f, 12.7389f, 22.9524f, 13.5079f, 22.7109f, 14.2345f)
                curveTo(22.4694f, 14.9611f, 22.0789f, 15.6293f, 21.5643f, 16.1963f)
                curveTo(21.0497f, 16.7633f, 20.4224f, 17.2166f, 19.7225f, 17.5272f)
                curveTo(19.0227f, 17.8378f, 18.2657f, 17.9988f, 17.5f, 18.0f)
                lineTo(17.0f, 18.001f)
                verticalLineTo(18.0f)
                close()
            }
        }
        .build()
        return _snowy!!
    }

private var _snowy: ImageVector? = null
