package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Snapchat: ImageVector
    get() {
        if (_snapchat != null) {
            return _snapchat!!
        }
        _snapchat = Builder(name = "Snapchat", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(5.565f, 10.6083f)
                curveTo(5.4107f, 10.5401f, 5.2701f, 10.478f, 5.0809f, 10.478f)
                curveTo(4.9218f, 10.4812f, 4.7644f, 10.5124f, 4.6159f, 10.57f)
                curveTo(4.2389f, 10.727f, 4.0339f, 11.06f, 4.0339f, 11.3f)
                curveTo(4.0339f, 12.0083f, 5.1497f, 12.3496f, 5.3473f, 12.41f)
                curveTo(5.3573f, 12.413f, 5.3649f, 12.4154f, 5.3699f, 12.417f)
                curveTo(5.3871f, 12.4227f, 5.4046f, 12.4284f, 5.4225f, 12.4343f)
                curveTo(5.7901f, 12.5552f, 6.3066f, 12.7249f, 6.4429f, 13.052f)
                curveTo(6.5129f, 13.231f, 6.4839f, 13.455f, 6.3519f, 13.731f)
                curveTo(6.3474f, 13.7404f, 6.3421f, 13.7516f, 6.336f, 13.7646f)
                curveTo(6.1298f, 14.2002f, 4.9975f, 16.592f, 2.4299f, 17.061f)
                curveTo(2.1969f, 17.103f, 2.0389f, 17.308f, 2.0389f, 17.543f)
                curveTo(2.0389f, 17.879f, 2.3999f, 18.157f, 2.7649f, 18.322f)
                curveTo(3.2089f, 18.522f, 3.8609f, 18.7f, 4.7169f, 18.835f)
                curveTo(4.7473f, 18.895f, 4.8263f, 19.2195f, 4.8871f, 19.4693f)
                curveTo(4.9144f, 19.5814f, 4.938f, 19.6786f, 4.9519f, 19.73f)
                curveTo(5.0816f, 20.2109f, 5.5391f, 20.1279f, 5.8152f, 20.0778f)
                curveTo(5.8669f, 20.0684f, 5.9123f, 20.0602f, 5.9479f, 20.057f)
                curveTo(5.992f, 20.0529f, 6.0533f, 20.0419f, 6.1301f, 20.0282f)
                curveTo(6.445f, 19.9719f, 7.0209f, 19.8689f, 7.7429f, 20.0f)
                curveTo(8.2339f, 20.089f, 8.6569f, 20.378f, 9.1389f, 20.726f)
                curveTo(9.1828f, 20.757f, 9.2267f, 20.7883f, 9.2707f, 20.8197f)
                curveTo(9.9419f, 21.2982f, 10.6483f, 21.802f, 11.9959f, 21.802f)
                curveTo(13.3781f, 21.802f, 14.1267f, 21.2713f, 14.817f, 20.7819f)
                curveTo(14.8434f, 20.7632f, 14.8697f, 20.7445f, 14.8959f, 20.726f)
                curveTo(15.3779f, 20.378f, 15.8089f, 20.087f, 16.2909f, 20.0f)
                curveTo(16.8876f, 19.9074f, 17.4961f, 19.9236f, 18.0869f, 20.048f)
                curveTo(18.0965f, 20.05f, 18.1072f, 20.0524f, 18.119f, 20.0549f)
                curveTo(18.3424f, 20.1039f, 18.9497f, 20.2368f, 19.0779f, 19.722f)
                curveTo(19.104f, 19.6183f, 19.1294f, 19.5144f, 19.1534f, 19.4158f)
                curveTo(19.2227f, 19.132f, 19.281f, 18.8929f, 19.3129f, 18.835f)
                curveTo(20.1739f, 18.7f, 20.8219f, 18.53f, 21.2649f, 18.33f)
                curveTo(21.6209f, 18.165f, 21.9909f, 17.88f, 21.9909f, 17.548f)
                curveTo(21.9909f, 17.306f, 21.8349f, 17.1f, 21.5999f, 17.065f)
                curveTo(18.9299f, 16.622f, 17.6729f, 13.747f, 17.6699f, 13.739f)
                curveTo(17.5349f, 13.461f, 17.5039f, 13.235f, 17.5779f, 13.061f)
                curveTo(17.72f, 12.7217f, 18.2688f, 12.5478f, 18.6378f, 12.4308f)
                lineTo(18.6529f, 12.426f)
                curveTo(19.1499f, 12.267f, 19.9829f, 11.921f, 19.9829f, 11.3f)
                curveTo(19.9829f, 11.047f, 19.6849f, 10.477f, 18.9999f, 10.477f)
                curveTo(18.6407f, 10.477f, 18.4658f, 10.5586f, 18.2956f, 10.6381f)
                curveTo(18.134f, 10.7135f, 17.9766f, 10.787f, 17.6699f, 10.787f)
                curveTo(17.573f, 10.7886f, 17.4772f, 10.7663f, 17.3909f, 10.722f)
                curveTo(17.3917f, 10.7114f, 17.3932f, 10.6939f, 17.3952f, 10.6697f)
                curveTo(17.4164f, 10.4155f, 17.4989f, 9.4258f, 17.4989f, 8.006f)
                curveTo(17.4989f, 6.408f, 16.8339f, 5.303f, 15.9479f, 4.478f)
                curveTo(15.0619f, 3.653f, 13.8159f, 3.0f, 11.9959f, 3.0f)
                curveTo(10.1749f, 3.0f, 8.8929f, 3.65f, 8.0699f, 4.474f)
                curveTo(7.2469f, 5.298f, 6.5269f, 6.3f, 6.5269f, 7.988f)
                curveTo(6.5269f, 8.731f, 6.6169f, 10.561f, 6.6259f, 10.717f)
                curveTo(6.5599f, 10.748f, 6.4569f, 10.783f, 6.2999f, 10.783f)
                curveTo(5.9603f, 10.783f, 5.7526f, 10.6912f, 5.565f, 10.6083f)
                close()
                moveTo(15.4159f, 10.331f)
                lineTo(15.3959f, 10.58f)
                curveTo(15.3588f, 11.1012f, 15.5271f, 11.6153f, 15.8649f, 12.014f)
                curveTo(15.8179f, 12.1f, 15.7729f, 12.192f, 15.7329f, 12.29f)
                curveTo(15.3999f, 13.071f, 15.5069f, 13.862f, 15.8699f, 14.611f)
                curveTo(16.248f, 15.3956f, 16.7352f, 16.1228f, 17.3169f, 16.771f)
                curveTo(17.5115f, 16.9868f, 17.7171f, 17.1924f, 17.9329f, 17.387f)
                curveTo(17.7615f, 17.5498f, 17.6203f, 17.7418f, 17.5159f, 17.954f)
                curveTo(16.9952f, 17.9175f, 16.4719f, 17.9424f, 15.9569f, 18.028f)
                curveTo(15.1329f, 18.176f, 14.6019f, 18.472f, 13.7259f, 19.104f)
                lineTo(13.5189f, 19.25f)
                curveTo(12.9059f, 19.681f, 12.6049f, 19.802f, 11.9959f, 19.802f)
                curveTo(11.3999f, 19.802f, 11.1419f, 19.696f, 10.5229f, 19.256f)
                lineTo(10.3099f, 19.104f)
                lineTo(10.2939f, 19.093f)
                curveTo(9.4239f, 18.466f, 8.9099f, 18.178f, 8.0999f, 18.032f)
                curveTo(7.5774f, 17.9359f, 7.0442f, 17.911f, 6.5149f, 17.958f)
                curveTo(6.4119f, 17.7469f, 6.2724f, 17.5557f, 6.1029f, 17.393f)
                curveTo(6.329f, 17.191f, 6.5433f, 16.9764f, 6.7449f, 16.75f)
                curveTo(7.4239f, 15.989f, 7.7629f, 15.414f, 8.1549f, 14.596f)
                curveTo(8.5049f, 13.868f, 8.6069f, 13.096f, 8.3069f, 12.325f)
                curveTo(8.2589f, 12.212f, 8.2089f, 12.106f, 8.1539f, 12.008f)
                curveTo(8.4836f, 11.6177f, 8.6514f, 11.1161f, 8.6229f, 10.606f)
                curveTo(8.5879f, 9.982f, 8.5269f, 8.509f, 8.5269f, 7.988f)
                curveTo(8.5269f, 7.106f, 8.7889f, 6.583f, 9.4849f, 5.888f)
                curveTo(10.0369f, 5.335f, 10.8579f, 5.0f, 11.9949f, 5.0f)
                curveTo(13.1259f, 5.0f, 13.9249f, 5.328f, 14.5849f, 5.942f)
                curveTo(15.2049f, 6.519f, 15.4989f, 7.135f, 15.4989f, 8.005f)
                curveTo(15.4991f, 8.7811f, 15.4715f, 9.5569f, 15.4159f, 10.331f)
                close()
            }
        }
        .build()
        return _snapchat!!
    }

private var _snapchat: ImageVector? = null
