package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.ShareAndroid: ImageVector
    get() {
        if (_shareAndroid != null) {
            return _shareAndroid!!
        }
        _shareAndroid = Builder(name = "ShareAndroid", defaultWidth = 24.0.dp, defaultHeight =
                24.0.dp, viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(13.12f, 17.023f)
                lineTo(8.921f, 14.733f)
                curveTo(8.3728f, 15.3191f, 7.661f, 15.7267f, 6.8781f, 15.9029f)
                curveTo(6.0952f, 16.0791f, 5.2774f, 16.0157f, 4.5309f, 15.7211f)
                curveTo(3.7845f, 15.4264f, 3.144f, 14.914f, 2.6926f, 14.2505f)
                curveTo(2.2412f, 13.587f, 1.9998f, 12.803f, 1.9998f, 12.0005f)
                curveTo(1.9998f, 11.198f, 2.2412f, 10.4141f, 2.6926f, 9.7506f)
                curveTo(3.144f, 9.0871f, 3.7845f, 8.5747f, 4.5309f, 8.28f)
                curveTo(5.2774f, 7.9853f, 6.0952f, 7.9219f, 6.8781f, 8.0981f)
                curveTo(7.661f, 8.2743f, 8.3728f, 8.682f, 8.921f, 9.268f)
                lineTo(13.121f, 6.978f)
                curveTo(12.8826f, 6.0341f, 12.9966f, 5.0356f, 13.4417f, 4.1697f)
                curveTo(13.8867f, 3.3038f, 14.6323f, 2.63f, 15.5387f, 2.2745f)
                curveTo(16.445f, 1.919f, 17.4499f, 1.9063f, 18.365f, 2.2387f)
                curveTo(19.2801f, 2.5712f, 20.0425f, 3.2259f, 20.5093f, 4.0803f)
                curveTo(20.9762f, 4.9346f, 21.1154f, 5.9299f, 20.9009f, 6.8796f)
                curveTo(20.6864f, 7.8292f, 20.133f, 8.6681f, 19.3443f, 9.2388f)
                curveTo(18.5555f, 9.8096f, 17.5857f, 10.0731f, 16.6166f, 9.98f)
                curveTo(15.6475f, 9.8869f, 14.7456f, 9.4435f, 14.08f, 8.733f)
                lineTo(9.88f, 11.023f)
                curveTo(10.0412f, 11.6644f, 10.0412f, 12.3357f, 9.88f, 12.977f)
                lineTo(14.079f, 15.267f)
                curveTo(14.7446f, 14.5565f, 15.6465f, 14.1131f, 16.6156f, 14.02f)
                curveTo(17.5847f, 13.9269f, 18.5545f, 14.1904f, 19.3433f, 14.7612f)
                curveTo(20.132f, 15.332f, 20.6854f, 16.1708f, 20.8999f, 17.1205f)
                curveTo(21.1144f, 18.0701f, 20.9752f, 19.0654f, 20.5083f, 19.9198f)
                curveTo(20.0415f, 20.7741f, 19.2791f, 21.4289f, 18.364f, 21.7613f)
                curveTo(17.4489f, 22.0937f, 16.444f, 22.081f, 15.5377f, 21.7255f)
                curveTo(14.6313f, 21.37f, 13.8857f, 20.6962f, 13.4407f, 19.8303f)
                curveTo(12.9956f, 18.9644f, 12.8816f, 17.9659f, 13.12f, 17.022f)
                verticalLineTo(17.023f)
                close()
                moveTo(6.0f, 14.0f)
                curveTo(6.5305f, 14.0f, 7.0392f, 13.7893f, 7.4142f, 13.4142f)
                curveTo(7.7893f, 13.0392f, 8.0f, 12.5305f, 8.0f, 12.0f)
                curveTo(8.0f, 11.4696f, 7.7893f, 10.9609f, 7.4142f, 10.5858f)
                curveTo(7.0392f, 10.2107f, 6.5305f, 10.0f, 6.0f, 10.0f)
                curveTo(5.4696f, 10.0f, 4.9609f, 10.2107f, 4.5858f, 10.5858f)
                curveTo(4.2107f, 10.9609f, 4.0f, 11.4696f, 4.0f, 12.0f)
                curveTo(4.0f, 12.5305f, 4.2107f, 13.0392f, 4.5858f, 13.4142f)
                curveTo(4.9609f, 13.7893f, 5.4696f, 14.0f, 6.0f, 14.0f)
                close()
                moveTo(17.0f, 8.0f)
                curveTo(17.5305f, 8.0f, 18.0392f, 7.7893f, 18.4142f, 7.4142f)
                curveTo(18.7893f, 7.0392f, 19.0f, 6.5304f, 19.0f, 6.0f)
                curveTo(19.0f, 5.4696f, 18.7893f, 4.9609f, 18.4142f, 4.5858f)
                curveTo(18.0392f, 4.2107f, 17.5305f, 4.0f, 17.0f, 4.0f)
                curveTo(16.4696f, 4.0f, 15.9609f, 4.2107f, 15.5858f, 4.5858f)
                curveTo(15.2107f, 4.9609f, 15.0f, 5.4696f, 15.0f, 6.0f)
                curveTo(15.0f, 6.5304f, 15.2107f, 7.0392f, 15.5858f, 7.4142f)
                curveTo(15.9609f, 7.7893f, 16.4696f, 8.0f, 17.0f, 8.0f)
                close()
                moveTo(17.0f, 20.0f)
                curveTo(17.5305f, 20.0f, 18.0392f, 19.7893f, 18.4142f, 19.4142f)
                curveTo(18.7893f, 19.0392f, 19.0f, 18.5305f, 19.0f, 18.0f)
                curveTo(19.0f, 17.4696f, 18.7893f, 16.9609f, 18.4142f, 16.5858f)
                curveTo(18.0392f, 16.2107f, 17.5305f, 16.0f, 17.0f, 16.0f)
                curveTo(16.4696f, 16.0f, 15.9609f, 16.2107f, 15.5858f, 16.5858f)
                curveTo(15.2107f, 16.9609f, 15.0f, 17.4696f, 15.0f, 18.0f)
                curveTo(15.0f, 18.5305f, 15.2107f, 19.0392f, 15.5858f, 19.4142f)
                curveTo(15.9609f, 19.7893f, 16.4696f, 20.0f, 17.0f, 20.0f)
                close()
            }
        }
        .build()
        return _shareAndroid!!
    }

private var _shareAndroid: ImageVector? = null
