package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Settings: ImageVector
    get() {
        if (_settings != null) {
            return _settings!!
        }
        _settings = Builder(name = "Settings", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(3.34f, 16.9998f)
                curveTo(2.9173f, 16.2688f, 2.5887f, 15.4873f, 2.362f, 14.6738f)
                curveTo(2.8553f, 14.4229f, 3.2696f, 14.0404f, 3.559f, 13.5687f)
                curveTo(3.8485f, 13.097f, 4.0018f, 12.5544f, 4.002f, 12.0009f)
                curveTo(4.0022f, 11.4475f, 3.8493f, 10.9048f, 3.5602f, 10.4328f)
                curveTo(3.2711f, 9.9609f, 2.8571f, 9.5781f, 2.364f, 9.3268f)
                curveTo(2.816f, 7.6923f, 3.6767f, 6.1998f, 4.865f, 4.9898f)
                curveTo(5.3291f, 5.2916f, 5.8676f, 5.459f, 6.421f, 5.4736f)
                curveTo(6.9743f, 5.4882f, 7.5209f, 5.3495f, 8.0003f, 5.0726f)
                curveTo(8.4797f, 4.7959f, 8.8731f, 4.3918f, 9.1371f, 3.9053f)
                curveTo(9.4011f, 3.4187f, 9.5253f, 2.8686f, 9.496f, 2.3158f)
                curveTo(11.1381f, 1.8915f, 12.8612f, 1.8921f, 14.503f, 2.3178f)
                curveTo(14.474f, 2.8706f, 14.5984f, 3.4206f, 14.8626f, 3.907f)
                curveTo(15.1268f, 4.3934f, 15.5204f, 4.7973f, 15.9998f, 5.0739f)
                curveTo(16.4793f, 5.3505f, 17.0259f, 5.489f, 17.5793f, 5.4742f)
                curveTo(18.1326f, 5.4593f, 18.671f, 5.2917f, 19.135f, 4.9898f)
                curveTo(19.714f, 5.5798f, 20.228f, 6.2508f, 20.66f, 6.9998f)
                curveTo(21.093f, 7.7488f, 21.417f, 8.5298f, 21.638f, 9.3258f)
                curveTo(21.1447f, 9.5767f, 20.7304f, 9.9592f, 20.441f, 10.4309f)
                curveTo(20.1515f, 10.9027f, 19.9982f, 11.4453f, 19.998f, 11.9987f)
                curveTo(19.9978f, 12.5522f, 20.1507f, 13.0949f, 20.4398f, 13.5668f)
                curveTo(20.7289f, 14.0388f, 21.1429f, 14.4216f, 21.636f, 14.6728f)
                curveTo(21.184f, 16.3073f, 20.3233f, 17.7999f, 19.135f, 19.0098f)
                curveTo(18.6709f, 18.7081f, 18.1324f, 18.5407f, 17.579f, 18.526f)
                curveTo(17.0257f, 18.5114f, 16.479f, 18.6502f, 15.9997f, 18.927f)
                curveTo(15.5203f, 19.2038f, 15.1268f, 19.6078f, 14.8629f, 20.0944f)
                curveTo(14.5989f, 20.5809f, 14.4747f, 21.131f, 14.504f, 21.6838f)
                curveTo(12.8619f, 22.1082f, 11.1388f, 22.1075f, 9.497f, 21.6818f)
                curveTo(9.526f, 21.1291f, 9.4016f, 20.579f, 9.1374f, 20.0926f)
                curveTo(8.8732f, 19.6062f, 8.4796f, 19.2023f, 8.0002f, 18.9258f)
                curveTo(7.5207f, 18.6492f, 6.9741f, 18.5106f, 6.4207f, 18.5255f)
                curveTo(5.8674f, 18.5403f, 5.329f, 18.7079f, 4.865f, 19.0098f)
                curveTo(4.274f, 18.4068f, 3.7616f, 17.7314f, 3.34f, 16.9998f)
                close()
                moveTo(9.0f, 17.1958f)
                curveTo(10.0656f, 17.8105f, 10.8668f, 18.7968f, 11.25f, 19.9658f)
                curveTo(11.749f, 20.0128f, 12.25f, 20.0138f, 12.749f, 19.9668f)
                curveTo(13.1324f, 18.7977f, 13.934f, 17.8113f, 15.0f, 17.1968f)
                curveTo(16.0652f, 16.5805f, 17.3205f, 16.3793f, 18.525f, 16.6318f)
                curveTo(18.815f, 16.2238f, 19.065f, 15.7888f, 19.273f, 15.3338f)
                curveTo(18.4524f, 14.4173f, 17.9991f, 13.23f, 18.0f, 11.9998f)
                curveTo(18.0f, 10.7398f, 18.47f, 9.5628f, 19.273f, 8.6658f)
                curveTo(19.0635f, 8.211f, 18.8125f, 7.7765f, 18.523f, 7.3678f)
                curveTo(17.3193f, 7.6201f, 16.0648f, 7.4193f, 15.0f, 6.8038f)
                curveTo(13.9344f, 6.1892f, 13.1332f, 5.2028f, 12.75f, 4.0338f)
                curveTo(12.251f, 3.9868f, 11.75f, 3.9858f, 11.251f, 4.0328f)
                curveTo(10.8676f, 5.202f, 10.066f, 6.1884f, 9.0f, 6.8028f)
                curveTo(7.9348f, 7.4191f, 6.6795f, 7.6203f, 5.475f, 7.3678f)
                curveTo(5.1856f, 7.7761f, 4.9351f, 8.2107f, 4.727f, 8.6658f)
                curveTo(5.5476f, 9.5824f, 6.0009f, 10.7696f, 6.0f, 11.9998f)
                curveTo(6.0f, 13.2598f, 5.53f, 14.4368f, 4.727f, 15.3338f)
                curveTo(4.9365f, 15.7887f, 5.1875f, 16.2232f, 5.477f, 16.6318f)
                curveTo(6.6807f, 16.3795f, 7.9352f, 16.5803f, 9.0f, 17.1958f)
                close()
                moveTo(12.0f, 14.9998f)
                curveTo(11.2044f, 14.9998f, 10.4413f, 14.6838f, 9.8787f, 14.1211f)
                curveTo(9.3161f, 13.5585f, 9.0f, 12.7955f, 9.0f, 11.9998f)
                curveTo(9.0f, 11.2042f, 9.3161f, 10.4411f, 9.8787f, 9.8785f)
                curveTo(10.4413f, 9.3159f, 11.2044f, 8.9998f, 12.0f, 8.9998f)
                curveTo(12.7956f, 8.9998f, 13.5587f, 9.3159f, 14.1213f, 9.8785f)
                curveTo(14.6839f, 10.4411f, 15.0f, 11.2042f, 15.0f, 11.9998f)
                curveTo(15.0f, 12.7955f, 14.6839f, 13.5585f, 14.1213f, 14.1211f)
                curveTo(13.5587f, 14.6838f, 12.7956f, 14.9998f, 12.0f, 14.9998f)
                close()
                moveTo(12.0f, 12.9998f)
                curveTo(12.2652f, 12.9998f, 12.5196f, 12.8945f, 12.7071f, 12.7069f)
                curveTo(12.8946f, 12.5194f, 13.0f, 12.265f, 13.0f, 11.9998f)
                curveTo(13.0f, 11.7346f, 12.8946f, 11.4803f, 12.7071f, 11.2927f)
                curveTo(12.5196f, 11.1052f, 12.2652f, 10.9998f, 12.0f, 10.9998f)
                curveTo(11.7348f, 10.9998f, 11.4804f, 11.1052f, 11.2929f, 11.2927f)
                curveTo(11.1054f, 11.4803f, 11.0f, 11.7346f, 11.0f, 11.9998f)
                curveTo(11.0f, 12.265f, 11.1054f, 12.5194f, 11.2929f, 12.7069f)
                curveTo(11.4804f, 12.8945f, 11.7348f, 12.9998f, 12.0f, 12.9998f)
                close()
            }
        }
        .build()
        return _settings!!
    }

private var _settings: ImageVector? = null
