package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Riding: ImageVector
    get() {
        if (_riding != null) {
            return _riding!!
        }
        _riding = Builder(name = "Riding", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(5.5f, 21.0f)
                curveTo(4.909f, 21.0f, 4.3239f, 20.8836f, 3.7779f, 20.6575f)
                curveTo(3.232f, 20.4313f, 2.7359f, 20.0998f, 2.318f, 19.682f)
                curveTo(1.9002f, 19.2641f, 1.5687f, 18.768f, 1.3425f, 18.2221f)
                curveTo(1.1164f, 17.6761f, 1.0f, 17.0909f, 1.0f, 16.5f)
                curveTo(1.0f, 15.9091f, 1.1164f, 15.3239f, 1.3425f, 14.7779f)
                curveTo(1.5687f, 14.232f, 1.9002f, 13.7359f, 2.318f, 13.318f)
                curveTo(2.7359f, 12.9002f, 3.232f, 12.5687f, 3.7779f, 12.3425f)
                curveTo(4.3239f, 12.1164f, 4.909f, 12.0f, 5.5f, 12.0f)
                curveTo(6.6935f, 12.0f, 7.8381f, 12.4741f, 8.682f, 13.318f)
                curveTo(9.5259f, 14.1619f, 10.0f, 15.3065f, 10.0f, 16.5f)
                curveTo(10.0f, 17.6935f, 9.5259f, 18.8381f, 8.682f, 19.682f)
                curveTo(7.8381f, 20.5259f, 6.6935f, 21.0f, 5.5f, 21.0f)
                close()
                moveTo(5.5f, 19.0f)
                curveTo(6.163f, 19.0f, 6.7989f, 18.7366f, 7.2678f, 18.2678f)
                curveTo(7.7366f, 17.7989f, 8.0f, 17.163f, 8.0f, 16.5f)
                curveTo(8.0f, 15.837f, 7.7366f, 15.2011f, 7.2678f, 14.7322f)
                curveTo(6.7989f, 14.2634f, 6.163f, 14.0f, 5.5f, 14.0f)
                curveTo(4.837f, 14.0f, 4.2011f, 14.2634f, 3.7322f, 14.7322f)
                curveTo(3.2634f, 15.2011f, 3.0f, 15.837f, 3.0f, 16.5f)
                curveTo(3.0f, 17.163f, 3.2634f, 17.7989f, 3.7322f, 18.2678f)
                curveTo(4.2011f, 18.7366f, 4.837f, 19.0f, 5.5f, 19.0f)
                close()
                moveTo(18.5f, 21.0f)
                curveTo(17.9091f, 21.0f, 17.3239f, 20.8836f, 16.7779f, 20.6575f)
                curveTo(16.232f, 20.4313f, 15.7359f, 20.0998f, 15.318f, 19.682f)
                curveTo(14.9002f, 19.2641f, 14.5687f, 18.768f, 14.3425f, 18.2221f)
                curveTo(14.1164f, 17.6761f, 14.0f, 17.0909f, 14.0f, 16.5f)
                curveTo(14.0f, 15.9091f, 14.1164f, 15.3239f, 14.3425f, 14.7779f)
                curveTo(14.5687f, 14.232f, 14.9002f, 13.7359f, 15.318f, 13.318f)
                curveTo(15.7359f, 12.9002f, 16.232f, 12.5687f, 16.7779f, 12.3425f)
                curveTo(17.3239f, 12.1164f, 17.9091f, 12.0f, 18.5f, 12.0f)
                curveTo(19.6935f, 12.0f, 20.8381f, 12.4741f, 21.682f, 13.318f)
                curveTo(22.5259f, 14.1619f, 23.0f, 15.3065f, 23.0f, 16.5f)
                curveTo(23.0f, 17.6935f, 22.5259f, 18.8381f, 21.682f, 19.682f)
                curveTo(20.8381f, 20.5259f, 19.6935f, 21.0f, 18.5f, 21.0f)
                close()
                moveTo(18.5f, 19.0f)
                curveTo(19.163f, 19.0f, 19.7989f, 18.7366f, 20.2678f, 18.2678f)
                curveTo(20.7366f, 17.7989f, 21.0f, 17.163f, 21.0f, 16.5f)
                curveTo(21.0f, 15.837f, 20.7366f, 15.2011f, 20.2678f, 14.7322f)
                curveTo(19.7989f, 14.2634f, 19.163f, 14.0f, 18.5f, 14.0f)
                curveTo(17.837f, 14.0f, 17.2011f, 14.2634f, 16.7322f, 14.7322f)
                curveTo(16.2634f, 15.2011f, 16.0f, 15.837f, 16.0f, 16.5f)
                curveTo(16.0f, 17.163f, 16.2634f, 17.7989f, 16.7322f, 18.2678f)
                curveTo(17.2011f, 18.7366f, 17.837f, 19.0f, 18.5f, 19.0f)
                close()
                moveTo(11.023f, 10.305f)
                lineTo(13.0f, 12.0f)
                verticalLineTo(18.0f)
                horizontalLineTo(11.0f)
                verticalLineTo(13.0f)
                lineTo(8.281f, 10.734f)
                curveTo(8.039f, 10.5677f, 7.8367f, 10.3502f, 7.6882f, 10.0969f)
                curveTo(7.5398f, 9.8436f, 7.4489f, 9.5608f, 7.4221f, 9.2684f)
                curveTo(7.3953f, 8.9761f, 7.4331f, 8.6814f, 7.533f, 8.4053f)
                curveTo(7.6329f, 8.1292f, 7.7923f, 7.8785f, 8.0f, 7.671f)
                lineTo(10.828f, 4.843f)
                curveTo(11.0137f, 4.6572f, 11.2342f, 4.5098f, 11.4769f, 4.4092f)
                curveTo(11.7197f, 4.3087f, 11.9798f, 4.2569f, 12.2425f, 4.2569f)
                curveTo(12.5052f, 4.2569f, 12.7653f, 4.3087f, 13.0081f, 4.4092f)
                curveTo(13.2508f, 4.5098f, 13.4713f, 4.6572f, 13.657f, 4.843f)
                lineTo(15.071f, 6.257f)
                curveTo(16.13f, 7.3198f, 17.5038f, 8.0125f, 18.988f, 8.232f)
                lineTo(18.978f, 10.247f)
                curveTo(16.9642f, 10.0152f, 15.0884f, 9.1074f, 13.657f, 7.672f)
                lineTo(11.023f, 10.305f)
                close()
                moveTo(16.0f, 5.0f)
                curveTo(15.4696f, 5.0f, 14.9609f, 4.7893f, 14.5858f, 4.4142f)
                curveTo(14.2107f, 4.0391f, 14.0f, 3.5304f, 14.0f, 3.0f)
                curveTo(14.0f, 2.4696f, 14.2107f, 1.9609f, 14.5858f, 1.5858f)
                curveTo(14.9609f, 1.2107f, 15.4696f, 1.0f, 16.0f, 1.0f)
                curveTo(16.5304f, 1.0f, 17.0391f, 1.2107f, 17.4142f, 1.5858f)
                curveTo(17.7893f, 1.9609f, 18.0f, 2.4696f, 18.0f, 3.0f)
                curveTo(18.0f, 3.5304f, 17.7893f, 4.0391f, 17.4142f, 4.4142f)
                curveTo(17.0391f, 4.7893f, 16.5304f, 5.0f, 16.0f, 5.0f)
                close()
            }
        }
        .build()
        return _riding!!
    }

private var _riding: ImageVector? = null
