package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Recycle: ImageVector
    get() {
        if (_recycle != null) {
            return _recycle!!
        }
        _recycle = Builder(name = "Recycle", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(19.5619f, 12.097f)
                lineTo(21.0929f, 14.75f)
                curveTo(21.4001f, 15.282f, 21.5618f, 15.8855f, 21.5619f, 16.4998f)
                curveTo(21.5619f, 17.114f, 21.4003f, 17.7175f, 21.0932f, 18.2496f)
                curveTo(20.7862f, 18.7816f, 20.3445f, 19.2234f, 19.8126f, 19.5307f)
                curveTo(19.2807f, 19.838f, 18.6772f, 19.9998f, 18.0629f, 20.0f)
                horizontalLineTo(15.9999f)
                verticalLineTo(22.5f)
                lineTo(10.9999f, 19.0f)
                lineTo(15.9999f, 15.5f)
                verticalLineTo(18.0f)
                horizontalLineTo(18.0619f)
                curveTo(18.3253f, 18.0002f, 18.5841f, 17.931f, 18.8123f, 17.7994f)
                curveTo(19.0404f, 17.6678f, 19.2299f, 17.4785f, 19.3617f, 17.2504f)
                curveTo(19.4935f, 17.0224f, 19.5629f, 16.7637f, 19.5629f, 16.5003f)
                curveTo(19.563f, 16.2369f, 19.4936f, 15.9781f, 19.3619f, 15.75f)
                lineTo(17.8299f, 13.097f)
                lineTo(19.5619f, 12.097f)
                close()
                moveTo(7.3039f, 9.134f)
                lineTo(7.834f, 15.214f)
                lineTo(5.67f, 13.964f)
                lineTo(4.6389f, 15.75f)
                curveTo(4.5073f, 15.9781f, 4.438f, 16.2367f, 4.438f, 16.5f)
                curveTo(4.438f, 16.7633f, 4.5073f, 17.022f, 4.6389f, 17.25f)
                curveTo(4.7706f, 17.478f, 4.9599f, 17.6674f, 5.188f, 17.7991f)
                curveTo(5.416f, 17.9307f, 5.6747f, 18.0f, 5.938f, 18.0f)
                horizontalLineTo(9.0f)
                verticalLineTo(20.0f)
                horizontalLineTo(5.938f)
                curveTo(5.3236f, 20.0f, 4.72f, 19.8383f, 4.188f, 19.5311f)
                curveTo(3.6559f, 19.2239f, 3.2141f, 18.7821f, 2.9069f, 18.25f)
                curveTo(2.5998f, 17.7179f, 2.438f, 17.1144f, 2.438f, 16.5f)
                curveTo(2.438f, 15.8856f, 2.5998f, 15.2821f, 2.9069f, 14.75f)
                lineTo(3.9369f, 12.963f)
                lineTo(1.773f, 11.714f)
                lineTo(7.3029f, 9.134f)
                horizontalLineTo(7.3039f)
                close()
                moveTo(13.7499f, 2.969f)
                curveTo(14.2819f, 3.276f, 14.7239f, 3.718f, 15.0309f, 4.25f)
                lineTo(16.061f, 6.035f)
                lineTo(18.2269f, 4.785f)
                lineTo(17.6969f, 10.866f)
                lineTo(12.1649f, 8.286f)
                lineTo(14.3299f, 7.036f)
                lineTo(13.2989f, 5.25f)
                curveTo(13.1673f, 5.022f, 12.9779f, 4.8327f, 12.7499f, 4.701f)
                curveTo(12.5219f, 4.5694f, 12.2632f, 4.5001f, 11.9999f, 4.5001f)
                curveTo(11.7367f, 4.5001f, 11.478f, 4.5694f, 11.25f, 4.701f)
                curveTo(11.022f, 4.8327f, 10.8326f, 5.022f, 10.7009f, 5.25f)
                lineTo(9.169f, 7.903f)
                lineTo(7.437f, 6.903f)
                lineTo(8.9699f, 4.25f)
                curveTo(9.4341f, 3.4462f, 10.1985f, 2.8596f, 11.0952f, 2.6194f)
                curveTo(11.9918f, 2.3791f, 12.9471f, 2.5049f, 13.7509f, 2.969f)
                horizontalLineTo(13.7499f)
                close()
            }
        }
        .build()
        return _recycle!!
    }

private var _recycle: ImageVector? = null
