package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Rainy: ImageVector
    get() {
        if (_rainy != null) {
            return _rainy!!
        }
        _rainy = Builder(name = "Rainy", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(16.0f, 18.0f)
                verticalLineTo(16.0f)
                horizontalLineTo(17.0f)
                curveTo(17.6211f, 15.9997f, 18.2336f, 15.8547f, 18.789f, 15.5766f)
                curveTo(19.3443f, 15.2984f, 19.8273f, 14.8948f, 20.1996f, 14.3976f)
                curveTo(20.5719f, 13.9005f, 20.8233f, 13.3234f, 20.9339f, 12.7123f)
                curveTo(21.0445f, 12.1011f, 21.0112f, 11.4725f, 20.8368f, 10.8764f)
                curveTo(20.6623f, 10.2803f, 20.3514f, 9.7331f, 19.9288f, 9.278f)
                curveTo(19.5061f, 8.8228f, 18.9832f, 8.4724f, 18.4016f, 8.2544f)
                curveTo(17.8201f, 8.0365f, 17.1957f, 7.9569f, 16.578f, 8.0221f)
                curveTo(15.9603f, 8.0873f, 15.3663f, 8.2954f, 14.843f, 8.63f)
                curveTo(14.5951f, 7.5736f, 14.0652f, 6.6043f, 13.31f, 5.8251f)
                curveTo(12.5547f, 5.046f, 11.6023f, 4.4863f, 10.5542f, 4.2055f)
                curveTo(9.5061f, 3.9248f, 8.4014f, 3.9335f, 7.3578f, 4.2309f)
                curveTo(6.3142f, 4.5282f, 5.3708f, 5.1029f, 4.628f, 5.8939f)
                curveTo(3.8852f, 6.6849f, 3.3708f, 7.6626f, 3.1396f, 8.7227f)
                curveTo(2.9084f, 9.7829f, 2.969f, 10.8859f, 3.315f, 11.9144f)
                curveTo(3.661f, 12.9429f, 4.2794f, 13.8582f, 5.1045f, 14.5631f)
                curveTo(5.9295f, 15.2679f, 6.9302f, 15.7358f, 8.0f, 15.917f)
                verticalLineTo(17.939f)
                curveTo(5.9812f, 17.6841f, 4.1352f, 16.6696f, 2.8379f, 15.1018f)
                curveTo(1.5406f, 13.5341f, 0.8894f, 11.5309f, 1.0168f, 9.5f)
                curveTo(1.1442f, 7.4691f, 2.0407f, 5.563f, 3.5238f, 4.1697f)
                curveTo(5.0069f, 2.7764f, 6.9651f, 2.0005f, 9.0f, 2.0f)
                curveTo(10.4217f, 1.9994f, 11.8179f, 2.3777f, 13.0448f, 3.0961f)
                curveTo(14.2716f, 3.8145f, 15.2848f, 4.8469f, 15.98f, 6.087f)
                curveTo(16.7989f, 5.946f, 17.6381f, 5.9767f, 18.4445f, 6.177f)
                curveTo(19.2509f, 6.3773f, 20.0069f, 6.7429f, 20.6647f, 7.2506f)
                curveTo(21.3224f, 7.7584f, 21.8674f, 8.3973f, 22.2654f, 9.1267f)
                curveTo(22.6633f, 9.8561f, 22.9053f, 10.6603f, 22.9762f, 11.4881f)
                curveTo(23.0471f, 12.316f, 22.9453f, 13.1496f, 22.6771f, 13.9361f)
                curveTo(22.409f, 14.7225f, 21.9805f, 15.4447f, 21.4186f, 16.0569f)
                curveTo(20.8568f, 16.6691f, 20.174f, 17.1579f, 19.4134f, 17.4924f)
                curveTo(18.6527f, 17.8269f, 17.8309f, 17.9997f, 17.0f, 18.0f)
                horizontalLineTo(16.0f)
                close()
                moveTo(10.232f, 18.732f)
                lineTo(12.0f, 16.964f)
                lineTo(13.768f, 18.732f)
                curveTo(14.1176f, 19.0817f, 14.3556f, 19.5271f, 14.452f, 20.0121f)
                curveTo(14.5485f, 20.497f, 14.4989f, 20.9996f, 14.3097f, 21.4564f)
                curveTo(14.1204f, 21.9132f, 13.8f, 22.3036f, 13.3889f, 22.5783f)
                curveTo(12.9778f, 22.8529f, 12.4945f, 22.9995f, 12.0f, 22.9995f)
                curveTo(11.5056f, 22.9995f, 11.0223f, 22.8529f, 10.6112f, 22.5783f)
                curveTo(10.2001f, 22.3036f, 9.8796f, 21.9132f, 9.6904f, 21.4564f)
                curveTo(9.5012f, 20.9996f, 9.4516f, 20.497f, 9.548f, 20.0121f)
                curveTo(9.6444f, 19.5271f, 9.8825f, 19.0817f, 10.232f, 18.732f)
                close()
            }
        }
        .build()
        return _rainy!!
    }

private var _rainy: ImageVector? = null
