package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.MoonCloudy: ImageVector
    get() {
        if (_moonCloudy != null) {
            return _moonCloudy!!
        }
        _moonCloudy = Builder(name = "MoonCloudy", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(8.67f, 5.0071f)
                curveTo(9.3263f, 3.6187f, 10.4209f, 2.4847f, 11.7852f, 1.7797f)
                curveTo(13.1496f, 1.0748f, 14.7078f, 0.8381f, 16.22f, 1.1061f)
                curveTo(15.9622f, 1.8959f, 15.9282f, 2.7418f, 16.1216f, 3.5498f)
                curveTo(16.3151f, 4.3578f, 16.7284f, 5.0965f, 17.316f, 5.6841f)
                curveTo(17.9035f, 6.2716f, 18.6422f, 6.685f, 19.4502f, 6.8784f)
                curveTo(20.2583f, 7.0719f, 21.1041f, 7.0378f, 21.894f, 6.7801f)
                curveTo(21.964f, 7.1761f, 22.0f, 7.5841f, 22.0f, 8.0001f)
                curveTo(22.0017f, 9.1795f, 21.7041f, 10.34f, 21.135f, 11.3731f)
                curveTo(21.9734f, 12.1117f, 22.567f, 13.0881f, 22.8367f, 14.1725f)
                curveTo(23.1064f, 15.2568f, 23.0394f, 16.3976f, 22.6447f, 17.4429f)
                curveTo(22.25f, 18.4882f, 21.5463f, 19.3886f, 20.6272f, 20.024f)
                curveTo(19.7082f, 20.6595f, 18.6173f, 20.9999f, 17.5f, 21.0001f)
                horizontalLineTo(9.0f)
                curveTo(6.9076f, 20.9989f, 4.899f, 20.178f, 3.4047f, 18.7134f)
                curveTo(1.9104f, 17.2488f, 1.0494f, 15.257f, 1.0062f, 13.1651f)
                curveTo(0.9631f, 11.0732f, 1.7412f, 9.0476f, 3.1738f, 7.5226f)
                curveTo(4.6064f, 5.9976f, 6.5794f, 5.0946f, 8.67f, 5.0071f)
                close()
                moveTo(10.847f, 5.2141f)
                curveTo(12.1072f, 5.5144f, 13.2759f, 6.1157f, 14.2529f, 6.9664f)
                curveTo(15.2299f, 7.8172f, 15.9862f, 8.8921f, 16.457f, 10.0991f)
                curveTo(17.4475f, 9.9092f, 18.4711f, 9.9939f, 19.417f, 10.3441f)
                curveTo(19.643f, 9.9191f, 19.81f, 9.4591f, 19.905f, 8.9741f)
                curveTo(18.3927f, 8.8347f, 16.977f, 8.1704f, 15.9033f, 7.0963f)
                curveTo(14.8297f, 6.0223f, 14.1658f, 4.6063f, 14.027f, 3.0941f)
                curveTo(12.7282f, 3.3521f, 11.5846f, 4.1144f, 10.847f, 5.2141f)
                close()
                moveTo(17.5f, 19.0001f)
                curveTo(18.077f, 19.0f, 18.6451f, 18.8572f, 19.1536f, 18.5845f)
                curveTo(19.6621f, 18.3118f, 20.0953f, 17.9176f, 20.4147f, 17.437f)
                curveTo(20.734f, 16.9563f, 20.9295f, 16.4042f, 20.9839f, 15.8297f)
                curveTo(21.0382f, 15.2553f, 20.9497f, 14.6763f, 20.7262f, 14.1443f)
                curveTo(20.5027f, 13.6123f, 20.1511f, 13.1438f, 19.7027f, 12.7806f)
                curveTo(19.2544f, 12.4173f, 18.7232f, 12.1706f, 18.1564f, 12.0623f)
                curveTo(17.5896f, 11.954f, 17.0048f, 11.9875f, 16.4541f, 12.1598f)
                curveTo(15.9034f, 12.3321f, 15.4039f, 12.638f, 15.0f, 13.0501f)
                verticalLineTo(13.0001f)
                curveTo(15.0f, 11.8134f, 14.6481f, 10.6533f, 13.9888f, 9.6666f)
                curveTo(13.3295f, 8.6799f, 12.3924f, 7.9109f, 11.2961f, 7.4568f)
                curveTo(10.1997f, 7.0027f, 8.9933f, 6.8838f, 7.8294f, 7.1153f)
                curveTo(6.6655f, 7.3469f, 5.5964f, 7.9183f, 4.7573f, 8.7574f)
                curveTo(3.9182f, 9.5965f, 3.3468f, 10.6656f, 3.1153f, 11.8295f)
                curveTo(2.8837f, 12.9934f, 3.0026f, 14.1998f, 3.4567f, 15.2962f)
                curveTo(3.9108f, 16.3925f, 4.6798f, 17.3296f, 5.6665f, 17.9889f)
                curveTo(6.6532f, 18.6482f, 7.8133f, 19.0001f, 9.0f, 19.0001f)
                horizontalLineTo(17.5f)
                close()
            }
        }
        .build()
        return _moonCloudy!!
    }

private var _moonCloudy: ImageVector? = null
