package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Mastercard: ImageVector
    get() {
        if (_mastercard != null) {
            return _mastercard!!
        }
        _mastercard = Builder(name = "Mastercard", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(12.0f, 18.294f)
                curveTo(10.8911f, 18.9455f, 9.6298f, 19.2925f, 8.3437f, 19.2999f)
                curveTo(7.0575f, 19.3072f, 5.7923f, 18.9747f, 4.6761f, 18.3359f)
                curveTo(3.5598f, 17.697f, 2.6321f, 16.7746f, 1.9869f, 15.662f)
                curveTo(1.3417f, 14.5494f, 1.002f, 13.2861f, 1.002f, 12.0f)
                curveTo(1.002f, 10.7139f, 1.3417f, 9.4506f, 1.9869f, 8.338f)
                curveTo(2.6321f, 7.2254f, 3.5598f, 6.303f, 4.6761f, 5.6642f)
                curveTo(5.7923f, 5.0254f, 7.0575f, 4.6928f, 8.3437f, 4.7001f)
                curveTo(9.6298f, 4.7075f, 10.8911f, 5.0545f, 12.0f, 5.706f)
                curveTo(13.1089f, 5.0545f, 14.3702f, 4.7075f, 15.6563f, 4.7001f)
                curveTo(16.9425f, 4.6928f, 18.2077f, 5.0254f, 19.3239f, 5.6642f)
                curveTo(20.4402f, 6.303f, 21.3679f, 7.2254f, 22.0131f, 8.338f)
                curveTo(22.6583f, 9.4506f, 22.9981f, 10.7139f, 22.9981f, 12.0f)
                curveTo(22.9981f, 13.2861f, 22.6583f, 14.5494f, 22.0131f, 15.662f)
                curveTo(21.3679f, 16.7746f, 20.4402f, 17.697f, 19.3239f, 18.3359f)
                curveTo(18.2077f, 18.9747f, 16.9425f, 19.3072f, 15.6563f, 19.2999f)
                curveTo(14.3702f, 19.2925f, 13.1089f, 18.9455f, 12.0f, 18.294f)
                close()
                moveTo(13.702f, 16.91f)
                curveTo(14.5067f, 17.237f, 15.3794f, 17.3613f, 16.2434f, 17.2718f)
                curveTo(17.1074f, 17.1824f, 17.9361f, 16.8819f, 18.6567f, 16.3969f)
                curveTo(19.3773f, 15.912f, 19.9676f, 15.2573f, 20.3758f, 14.4906f)
                curveTo(20.784f, 13.7239f, 20.9975f, 12.8686f, 20.9975f, 12.0f)
                curveTo(20.9975f, 11.1314f, 20.784f, 10.2761f, 20.3758f, 9.5094f)
                curveTo(19.9676f, 8.7427f, 19.3773f, 8.0881f, 18.6567f, 7.6031f)
                curveTo(17.9361f, 7.1181f, 17.1074f, 6.8177f, 16.2434f, 6.7282f)
                curveTo(15.3794f, 6.6387f, 14.5067f, 6.763f, 13.702f, 7.09f)
                curveTo(14.9255f, 8.4323f, 15.6026f, 10.1838f, 15.6f, 12.0f)
                curveTo(15.6f, 13.89f, 14.881f, 15.614f, 13.702f, 16.91f)
                close()
                moveTo(10.298f, 7.09f)
                curveTo(9.4933f, 6.763f, 8.6206f, 6.6387f, 7.7566f, 6.7282f)
                curveTo(6.8927f, 6.8177f, 6.0639f, 7.1181f, 5.3433f, 7.6031f)
                curveTo(4.6227f, 8.0881f, 4.0324f, 8.7427f, 3.6242f, 9.5094f)
                curveTo(3.216f, 10.2761f, 3.0025f, 11.1314f, 3.0025f, 12.0f)
                curveTo(3.0025f, 12.8686f, 3.216f, 13.7239f, 3.6242f, 14.4906f)
                curveTo(4.0324f, 15.2573f, 4.6227f, 15.912f, 5.3433f, 16.3969f)
                curveTo(6.0639f, 16.8819f, 6.8927f, 17.1824f, 7.7566f, 17.2718f)
                curveTo(8.6206f, 17.3613f, 9.4933f, 17.237f, 10.298f, 16.91f)
                curveTo(9.0745f, 15.5677f, 8.3974f, 13.8163f, 8.4f, 12.0f)
                curveTo(8.4f, 10.11f, 9.119f, 8.386f, 10.298f, 7.09f)
                close()
                moveTo(12.0f, 8.205f)
                curveTo(11.4928f, 8.6982f, 11.0899f, 9.2883f, 10.815f, 9.9402f)
                curveTo(10.5402f, 10.5921f, 10.3991f, 11.2926f, 10.4f, 12.0f)
                curveTo(10.4f, 13.488f, 11.013f, 14.832f, 12.0f, 15.795f)
                curveTo(12.5072f, 15.3018f, 12.9101f, 14.7117f, 13.185f, 14.0598f)
                curveTo(13.4598f, 13.4079f, 13.6009f, 12.7075f, 13.6f, 12.0f)
                curveTo(13.6009f, 11.2926f, 13.4598f, 10.5921f, 13.185f, 9.9402f)
                curveTo(12.9101f, 9.2883f, 12.5072f, 8.6982f, 12.0f, 8.205f)
                close()
            }
        }
        .build()
        return _mastercard!!
    }

private var _mastercard: ImageVector? = null
