package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Line: ImageVector
    get() {
        if (_line != null) {
            return _line!!
        }
        _line = Builder(name = "Line", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(22.0f, 10.69f)
                curveTo(22.0f, 12.477f, 21.313f, 14.09f, 19.877f, 15.664f)
                curveTo(17.777f, 18.078f, 13.089f, 21.027f, 12.013f, 21.476f)
                curveTo(10.939f, 21.927f, 11.102f, 21.189f, 11.139f, 20.939f)
                lineTo(11.276f, 20.089f)
                curveTo(11.31f, 19.827f, 11.344f, 19.439f, 11.244f, 19.189f)
                curveTo(11.132f, 18.912f, 10.688f, 18.765f, 10.363f, 18.697f)
                curveTo(5.558f, 18.059f, 2.0f, 14.7f, 2.0f, 10.69f)
                curveTo(2.0f, 6.215f, 6.487f, 2.572f, 12.0f, 2.572f)
                curveTo(17.512f, 2.572f, 22.0f, 6.215f, 22.0f, 10.69f)
                close()
                moveTo(18.4f, 14.315f)
                curveTo(19.513f, 13.095f, 20.0f, 11.954f, 20.0f, 10.69f)
                curveTo(20.0f, 7.422f, 16.49f, 4.572f, 12.0f, 4.572f)
                curveTo(7.51f, 4.572f, 4.0f, 7.422f, 4.0f, 10.69f)
                curveTo(4.0f, 13.595f, 6.728f, 16.197f, 10.626f, 16.714f)
                lineTo(10.773f, 16.74f)
                curveTo(11.851f, 16.966f, 12.657f, 17.354f, 13.102f, 18.448f)
                lineTo(13.138f, 18.544f)
                curveTo(14.944f, 17.368f, 17.312f, 15.564f, 18.399f, 14.315f)
                horizontalLineTo(18.4f)
                close()
                moveTo(18.138f, 10.315f)
                curveTo(18.2716f, 10.3232f, 18.3971f, 10.3821f, 18.4888f, 10.4797f)
                curveTo(18.5805f, 10.5772f, 18.6316f, 10.7061f, 18.6316f, 10.84f)
                curveTo(18.6316f, 10.9739f, 18.5805f, 11.1027f, 18.4888f, 11.2003f)
                curveTo(18.3971f, 11.2978f, 18.2716f, 11.3567f, 18.138f, 11.365f)
                horizontalLineTo(16.675f)
                verticalLineTo(12.303f)
                horizontalLineTo(18.137f)
                curveTo(18.2078f, 12.2999f, 18.2785f, 12.3112f, 18.3448f, 12.3361f)
                curveTo(18.4112f, 12.3611f, 18.4718f, 12.3992f, 18.5229f, 12.4482f)
                curveTo(18.5741f, 12.4973f, 18.6149f, 12.5561f, 18.6427f, 12.6213f)
                curveTo(18.6706f, 12.6865f, 18.6849f, 12.7566f, 18.6849f, 12.8275f)
                curveTo(18.6849f, 12.8984f, 18.6706f, 12.9685f, 18.6427f, 13.0337f)
                curveTo(18.6149f, 13.0989f, 18.5741f, 13.1577f, 18.5229f, 13.2067f)
                curveTo(18.4718f, 13.2557f, 18.4112f, 13.2939f, 18.3448f, 13.3188f)
                curveTo(18.2785f, 13.3438f, 18.2078f, 13.3551f, 18.137f, 13.352f)
                horizontalLineTo(16.15f)
                curveTo(16.0115f, 13.3509f, 15.8791f, 13.2953f, 15.7813f, 13.1972f)
                curveTo(15.6836f, 13.0991f, 15.6285f, 12.9665f, 15.628f, 12.828f)
                verticalLineTo(8.852f)
                curveTo(15.628f, 8.565f, 15.863f, 8.327f, 16.153f, 8.327f)
                horizontalLineTo(18.141f)
                curveTo(18.2802f, 8.3274f, 18.4136f, 8.3831f, 18.5118f, 8.4818f)
                curveTo(18.61f, 8.5806f, 18.6649f, 8.7142f, 18.6645f, 8.8535f)
                curveTo(18.6641f, 8.9927f, 18.6084f, 9.1261f, 18.5097f, 9.2243f)
                curveTo(18.4109f, 9.3225f, 18.2772f, 9.3774f, 18.138f, 9.377f)
                horizontalLineTo(16.676f)
                verticalLineTo(10.315f)
                horizontalLineTo(18.138f)
                close()
                moveTo(14.925f, 12.828f)
                curveTo(14.9247f, 12.8968f, 14.9109f, 12.9649f, 14.8843f, 13.0284f)
                curveTo(14.8578f, 13.0918f, 14.819f, 13.1495f, 14.7701f, 13.1979f)
                curveTo(14.7213f, 13.2464f, 14.6634f, 13.2848f, 14.5997f, 13.3109f)
                curveTo(14.536f, 13.337f, 14.4678f, 13.3503f, 14.399f, 13.35f)
                curveTo(14.3167f, 13.3518f, 14.2351f, 13.3339f, 14.1612f, 13.2977f)
                curveTo(14.0872f, 13.2615f, 14.0231f, 13.2081f, 13.974f, 13.142f)
                lineTo(11.938f, 10.378f)
                verticalLineTo(12.828f)
                curveTo(11.928f, 12.96f, 11.8685f, 13.0833f, 11.7714f, 13.1733f)
                curveTo(11.6744f, 13.2633f, 11.5469f, 13.3133f, 11.4145f, 13.3133f)
                curveTo(11.2821f, 13.3133f, 11.1546f, 13.2633f, 11.0576f, 13.1733f)
                curveTo(10.9605f, 13.0833f, 10.901f, 12.96f, 10.891f, 12.828f)
                verticalLineTo(8.852f)
                curveTo(10.8907f, 8.7137f, 10.9453f, 8.581f, 11.0428f, 8.4829f)
                curveTo(11.1403f, 8.3849f, 11.2727f, 8.3295f, 11.411f, 8.329f)
                curveTo(11.573f, 8.329f, 11.723f, 8.415f, 11.823f, 8.54f)
                lineTo(13.875f, 11.315f)
                verticalLineTo(8.852f)
                curveTo(13.875f, 8.565f, 14.11f, 8.327f, 14.4f, 8.327f)
                curveTo(14.687f, 8.327f, 14.925f, 8.565f, 14.925f, 8.852f)
                verticalLineTo(12.828f)
                close()
                moveTo(10.141f, 12.828f)
                curveTo(10.1402f, 12.9671f, 10.0845f, 13.1002f, 9.9859f, 13.1983f)
                curveTo(9.8874f, 13.2965f, 9.7541f, 13.3517f, 9.615f, 13.352f)
                curveTo(9.4764f, 13.3512f, 9.3436f, 13.2957f, 9.2457f, 13.1976f)
                curveTo(9.1478f, 13.0995f, 9.0925f, 12.9666f, 9.092f, 12.828f)
                verticalLineTo(8.852f)
                curveTo(9.092f, 8.565f, 9.328f, 8.327f, 9.617f, 8.327f)
                curveTo(9.906f, 8.327f, 10.141f, 8.565f, 10.141f, 8.852f)
                verticalLineTo(12.828f)
                close()
                moveTo(8.086f, 13.352f)
                horizontalLineTo(6.097f)
                curveTo(5.9582f, 13.3512f, 5.8253f, 13.2958f, 5.727f, 13.1977f)
                curveTo(5.6287f, 13.0996f, 5.5731f, 12.9668f, 5.572f, 12.828f)
                verticalLineTo(8.852f)
                curveTo(5.5835f, 8.7207f, 5.6438f, 8.5984f, 5.7409f, 8.5093f)
                curveTo(5.8381f, 8.4203f, 5.9652f, 8.3709f, 6.097f, 8.3709f)
                curveTo(6.2288f, 8.3709f, 6.3559f, 8.4203f, 6.4531f, 8.5093f)
                curveTo(6.5503f, 8.5984f, 6.6105f, 8.7207f, 6.622f, 8.852f)
                verticalLineTo(12.302f)
                horizontalLineTo(8.086f)
                curveTo(8.2252f, 12.302f, 8.3588f, 12.3573f, 8.4572f, 12.4558f)
                curveTo(8.5557f, 12.5542f, 8.611f, 12.6878f, 8.611f, 12.827f)
                curveTo(8.611f, 12.9662f, 8.5557f, 13.0998f, 8.4572f, 13.1982f)
                curveTo(8.3588f, 13.2967f, 8.2252f, 13.352f, 8.086f, 13.352f)
                close()
            }
        }
        .build()
        return _line!!
    }

private var _line: ImageVector? = null
