package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.KakaoTalk: ImageVector
    get() {
        if (_kakaoTalk != null) {
            return _kakaoTalk!!
        }
        _kakaoTalk = Builder(name = "KakaoTalk", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(5.678f, 18.123f)
                curveTo(3.092f, 16.566f, 1.5f, 14.112f, 1.5f, 11.405f)
                curveTo(1.5f, 6.701f, 6.248f, 3.0f, 12.0f, 3.0f)
                curveTo(17.752f, 3.0f, 22.5f, 6.701f, 22.5f, 11.405f)
                curveTo(22.5f, 16.109f, 17.752f, 19.81f, 12.0f, 19.81f)
                curveTo(11.558f, 19.81f, 11.118f, 19.788f, 10.682f, 19.745f)
                lineTo(6.917f, 22.203f)
                curveTo(6.302f, 22.529f, 5.96f, 22.628f, 5.432f, 22.269f)
                curveTo(4.812f, 21.845f, 4.836f, 21.377f, 5.051f, 20.709f)
                lineTo(5.678f, 18.123f)
                close()
                moveTo(3.5f, 11.405f)
                curveTo(3.5f, 13.537f, 4.918f, 15.528f, 7.281f, 16.725f)
                lineTo(7.987f, 17.084f)
                lineTo(7.801f, 17.854f)
                lineTo(7.4f, 19.502f)
                lineTo(10.2f, 17.672f)
                lineTo(10.566f, 17.718f)
                curveTo(11.039f, 17.779f, 11.518f, 17.81f, 12.0f, 17.81f)
                curveTo(16.741f, 17.81f, 20.5f, 14.88f, 20.5f, 11.405f)
                curveTo(20.5f, 7.93f, 16.741f, 5.0f, 12.0f, 5.0f)
                curveTo(7.259f, 5.0f, 3.5f, 7.93f, 3.5f, 11.405f)
                close()
                moveTo(17.907f, 11.059f)
                lineTo(19.421f, 13.214f)
                curveTo(19.4567f, 13.2648f, 19.482f, 13.322f, 19.4955f, 13.3826f)
                curveTo(19.509f, 13.4431f, 19.5105f, 13.5057f, 19.4998f, 13.5668f)
                curveTo(19.4891f, 13.6279f, 19.4665f, 13.6863f, 19.4332f, 13.7387f)
                curveTo(19.4f, 13.791f, 19.3568f, 13.8363f, 19.306f, 13.872f)
                curveTo(19.2552f, 13.9077f, 19.198f, 13.933f, 19.1374f, 13.9465f)
                curveTo(19.0769f, 13.96f, 19.0143f, 13.9615f, 18.9532f, 13.9508f)
                curveTo(18.8921f, 13.9401f, 18.8337f, 13.9175f, 18.7813f, 13.8842f)
                curveTo(18.729f, 13.851f, 18.6837f, 13.8078f, 18.648f, 13.757f)
                lineTo(17.22f, 11.724f)
                lineTo(16.793f, 12.137f)
                verticalLineTo(13.5f)
                curveTo(16.793f, 13.6252f, 16.7433f, 13.7452f, 16.6548f, 13.8338f)
                curveTo(16.5662f, 13.9223f, 16.4462f, 13.972f, 16.321f, 13.972f)
                curveTo(16.1958f, 13.972f, 16.0758f, 13.9223f, 15.9872f, 13.8338f)
                curveTo(15.8987f, 13.7452f, 15.849f, 13.6252f, 15.849f, 13.5f)
                verticalLineTo(12.061f)
                curveTo(15.8313f, 11.9881f, 15.8313f, 11.9119f, 15.849f, 11.839f)
                verticalLineTo(9.282f)
                curveTo(15.849f, 9.1568f, 15.8987f, 9.0368f, 15.9872f, 8.9482f)
                curveTo(16.0758f, 8.8597f, 16.1958f, 8.81f, 16.321f, 8.81f)
                curveTo(16.4462f, 8.81f, 16.5662f, 8.8597f, 16.6548f, 8.9482f)
                curveTo(16.7433f, 9.0368f, 16.793f, 9.1568f, 16.793f, 9.282f)
                verticalLineTo(10.824f)
                lineTo(18.721f, 8.958f)
                curveTo(18.8118f, 8.8761f, 18.9309f, 8.8327f, 19.0531f, 8.8369f)
                curveTo(19.1753f, 8.8411f, 19.2912f, 8.8925f, 19.3762f, 8.9804f)
                curveTo(19.4612f, 9.0683f, 19.5088f, 9.1858f, 19.509f, 9.308f)
                curveTo(19.5091f, 9.4303f, 19.4618f, 9.5479f, 19.377f, 9.636f)
                lineTo(17.907f, 11.059f)
                close()
                moveTo(14.949f, 12.984f)
                curveTo(15.0742f, 12.984f, 15.1942f, 13.0337f, 15.2828f, 13.1222f)
                curveTo(15.3713f, 13.2108f, 15.421f, 13.3308f, 15.421f, 13.456f)
                curveTo(15.421f, 13.5812f, 15.3713f, 13.7012f, 15.2828f, 13.7898f)
                curveTo(15.1942f, 13.8783f, 15.0742f, 13.928f, 14.949f, 13.928f)
                horizontalLineTo(13.017f)
                curveTo(12.892f, 13.9277f, 12.7722f, 13.8779f, 12.6839f, 13.7894f)
                curveTo(12.5956f, 13.7009f, 12.546f, 13.581f, 12.546f, 13.456f)
                verticalLineTo(9.297f)
                curveTo(12.5431f, 9.2332f, 12.5531f, 9.1696f, 12.5755f, 9.1098f)
                curveTo(12.5978f, 9.05f, 12.6321f, 8.9954f, 12.6762f, 8.9493f)
                curveTo(12.7202f, 8.9031f, 12.7732f, 8.8664f, 12.8319f, 8.8413f)
                curveTo(12.8905f, 8.8162f, 12.9537f, 8.8033f, 13.0175f, 8.8033f)
                curveTo(13.0813f, 8.8033f, 13.1445f, 8.8162f, 13.2031f, 8.8413f)
                curveTo(13.2618f, 8.8664f, 13.3148f, 8.9031f, 13.3588f, 8.9493f)
                curveTo(13.4029f, 8.9954f, 13.4372f, 9.05f, 13.4595f, 9.1098f)
                curveTo(13.4819f, 9.1696f, 13.4919f, 9.2332f, 13.489f, 9.297f)
                verticalLineTo(12.984f)
                horizontalLineTo(14.949f)
                close()
                moveTo(9.092f, 11.892f)
                horizontalLineTo(10.426f)
                lineTo(9.788f, 10.185f)
                lineTo(9.092f, 11.892f)
                close()
                moveTo(11.615f, 12.38f)
                lineTo(11.96f, 13.305f)
                curveTo(11.9838f, 13.3635f, 11.9957f, 13.4262f, 11.9948f, 13.4893f)
                curveTo(11.994f, 13.5525f, 11.9805f, 13.6148f, 11.9551f, 13.6727f)
                curveTo(11.9298f, 13.7305f, 11.8931f, 13.7827f, 11.8472f, 13.8261f)
                curveTo(11.8013f, 13.8694f, 11.7471f, 13.9032f, 11.688f, 13.9253f)
                curveTo(11.6288f, 13.9474f, 11.5658f, 13.9574f, 11.5027f, 13.9546f)
                curveTo(11.4396f, 13.9519f, 11.3777f, 13.9366f, 11.3206f, 13.9095f)
                curveTo(11.2635f, 13.8825f, 11.2125f, 13.8442f, 11.1705f, 13.7971f)
                curveTo(11.1285f, 13.7499f, 11.0963f, 13.6948f, 11.076f, 13.635f)
                lineTo(10.778f, 12.836f)
                horizontalLineTo(8.708f)
                lineTo(8.377f, 13.649f)
                curveTo(8.3536f, 13.7064f, 8.319f, 13.7586f, 8.2754f, 13.8026f)
                curveTo(8.2318f, 13.8467f, 8.1799f, 13.8817f, 8.1228f, 13.9057f)
                curveTo(8.0656f, 13.9297f, 8.0043f, 13.9422f, 7.9423f, 13.9425f)
                curveTo(7.8803f, 13.9428f, 7.8189f, 13.9309f, 7.7615f, 13.9075f)
                curveTo(7.7041f, 13.8841f, 7.6519f, 13.8495f, 7.6079f, 13.8059f)
                curveTo(7.5638f, 13.7623f, 7.5288f, 13.7104f, 7.5048f, 13.6533f)
                curveTo(7.4808f, 13.5961f, 7.4683f, 13.5348f, 7.468f, 13.4728f)
                curveTo(7.4676f, 13.4108f, 7.4796f, 13.3494f, 7.503f, 13.292f)
                lineTo(9.163f, 9.217f)
                curveTo(9.2136f, 9.0848f, 9.3034f, 8.9712f, 9.4202f, 8.8914f)
                curveTo(9.5371f, 8.8115f, 9.6755f, 8.7692f, 9.817f, 8.77f)
                curveTo(9.9573f, 8.7758f, 10.0926f, 8.8243f, 10.2046f, 8.909f)
                curveTo(10.3166f, 8.9937f, 10.4002f, 9.1106f, 10.444f, 9.244f)
                lineTo(11.49f, 12.044f)
                curveTo(11.5714f, 12.1307f, 11.6168f, 12.2451f, 11.617f, 12.364f)
                lineTo(11.615f, 12.38f)
                close()
                moveTo(8.293f, 9.302f)
                curveTo(8.293f, 9.562f, 8.083f, 9.774f, 7.822f, 9.774f)
                horizontalLineTo(6.682f)
                verticalLineTo(13.51f)
                curveTo(6.682f, 13.6353f, 6.6322f, 13.7555f, 6.5436f, 13.8441f)
                curveTo(6.455f, 13.9327f, 6.3348f, 13.9825f, 6.2095f, 13.9825f)
                curveTo(6.0842f, 13.9825f, 5.964f, 13.9327f, 5.8754f, 13.8441f)
                curveTo(5.7868f, 13.7555f, 5.737f, 13.6353f, 5.737f, 13.51f)
                verticalLineTo(9.774f)
                horizontalLineTo(4.577f)
                curveTo(4.4518f, 9.774f, 4.3318f, 9.7243f, 4.2432f, 9.6357f)
                curveTo(4.1547f, 9.5472f, 4.105f, 9.4272f, 4.105f, 9.302f)
                curveTo(4.105f, 9.1768f, 4.1547f, 9.0568f, 4.2432f, 8.9683f)
                curveTo(4.3318f, 8.8797f, 4.4518f, 8.83f, 4.577f, 8.83f)
                horizontalLineTo(7.822f)
                curveTo(8.082f, 8.83f, 8.293f, 9.041f, 8.293f, 9.302f)
                close()
            }
        }
        .build()
        return _kakaoTalk!!
    }

private var _kakaoTalk: ImageVector? = null
