package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Hail: ImageVector
    get() {
        if (_hail != null) {
            return _hail!!
        }
        _hail = Builder(name = "Hail", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(6.0f, 17.418f)
                curveTo(4.281f, 16.72f, 2.8578f, 15.4463f, 1.9741f, 13.8149f)
                curveTo(1.0903f, 12.1835f, 0.8009f, 10.2957f, 1.1553f, 8.4745f)
                curveTo(1.5096f, 6.6532f, 2.4858f, 5.0117f, 3.9168f, 3.8307f)
                curveTo(5.3478f, 2.6497f, 7.1446f, 2.0025f, 9.0f, 2.0f)
                curveTo(10.6121f, 1.9999f, 12.1866f, 2.4866f, 13.5173f, 3.3965f)
                curveTo(14.8481f, 4.3063f, 15.8731f, 5.5968f, 16.458f, 7.099f)
                curveTo(17.8533f, 6.8232f, 19.3012f, 7.0986f, 20.4978f, 7.8675f)
                curveTo(21.6944f, 8.6364f, 22.5466f, 9.8389f, 22.8755f, 11.2227f)
                curveTo(23.2044f, 12.6064f, 22.9845f, 14.0638f, 22.2619f, 15.2889f)
                curveTo(21.5393f, 16.5139f, 20.3702f, 17.4115f, 19.0f, 17.793f)
                verticalLineTo(15.663f)
                curveTo(19.4622f, 15.4437f, 19.8707f, 15.1257f, 20.1967f, 14.7315f)
                curveTo(20.5228f, 14.3373f, 20.7584f, 13.8764f, 20.8871f, 13.3813f)
                curveTo(21.0157f, 12.8861f, 21.0343f, 12.3688f, 20.9415f, 11.8657f)
                curveTo(20.8486f, 11.3627f, 20.6466f, 10.8861f, 20.3497f, 10.4695f)
                curveTo(20.0528f, 10.0529f, 19.6682f, 9.7065f, 19.2229f, 9.4546f)
                curveTo(18.7776f, 9.2027f, 18.2826f, 9.0515f, 17.7725f, 9.0116f)
                curveTo(17.2625f, 8.9717f, 16.75f, 9.0441f, 16.271f, 9.2237f)
                curveTo(15.7919f, 9.4032f, 15.3581f, 9.6856f, 15.0f, 10.051f)
                verticalLineTo(10.0f)
                curveTo(14.9999f, 8.9468f, 14.7225f, 7.9122f, 14.1958f, 7.0002f)
                curveTo(13.6691f, 6.0882f, 12.9116f, 5.3309f, 11.9995f, 4.8044f)
                curveTo(11.0873f, 4.2779f, 10.0527f, 4.0008f, 8.9995f, 4.0009f)
                curveTo(7.9463f, 4.0009f, 6.9117f, 4.2783f, 5.9997f, 4.8049f)
                curveTo(5.0876f, 5.3316f, 4.3302f, 6.089f, 3.8037f, 7.0011f)
                curveTo(3.2772f, 7.9132f, 3.0f, 8.9479f, 3.0f, 10.0011f)
                curveTo(3.0001f, 11.0542f, 3.2773f, 12.0889f, 3.8039f, 13.0009f)
                curveTo(4.3305f, 13.913f, 5.0879f, 14.6704f, 6.0f, 15.197f)
                verticalLineTo(17.418f)
                close()
                moveTo(10.0f, 17.0f)
                curveTo(9.4696f, 17.0f, 8.9609f, 16.7893f, 8.5858f, 16.4142f)
                curveTo(8.2107f, 16.0391f, 8.0f, 15.5304f, 8.0f, 15.0f)
                curveTo(8.0f, 14.4696f, 8.2107f, 13.9609f, 8.5858f, 13.5858f)
                curveTo(8.9609f, 13.2107f, 9.4696f, 13.0f, 10.0f, 13.0f)
                curveTo(10.5305f, 13.0f, 11.0392f, 13.2107f, 11.4142f, 13.5858f)
                curveTo(11.7893f, 13.9609f, 12.0f, 14.4696f, 12.0f, 15.0f)
                curveTo(12.0f, 15.5304f, 11.7893f, 16.0391f, 11.4142f, 16.4142f)
                curveTo(11.0392f, 16.7893f, 10.5305f, 17.0f, 10.0f, 17.0f)
                close()
                moveTo(15.0f, 20.0f)
                curveTo(14.4696f, 20.0f, 13.9609f, 19.7893f, 13.5858f, 19.4142f)
                curveTo(13.2107f, 19.0391f, 13.0f, 18.5304f, 13.0f, 18.0f)
                curveTo(13.0f, 17.4696f, 13.2107f, 16.9609f, 13.5858f, 16.5858f)
                curveTo(13.9609f, 16.2107f, 14.4696f, 16.0f, 15.0f, 16.0f)
                curveTo(15.5305f, 16.0f, 16.0392f, 16.2107f, 16.4142f, 16.5858f)
                curveTo(16.7893f, 16.9609f, 17.0f, 17.4696f, 17.0f, 18.0f)
                curveTo(17.0f, 18.5304f, 16.7893f, 19.0391f, 16.4142f, 19.4142f)
                curveTo(16.0392f, 19.7893f, 15.5305f, 20.0f, 15.0f, 20.0f)
                close()
                moveTo(10.0f, 23.0f)
                curveTo(9.4696f, 23.0f, 8.9609f, 22.7893f, 8.5858f, 22.4142f)
                curveTo(8.2107f, 22.0391f, 8.0f, 21.5304f, 8.0f, 21.0f)
                curveTo(8.0f, 20.4696f, 8.2107f, 19.9609f, 8.5858f, 19.5858f)
                curveTo(8.9609f, 19.2107f, 9.4696f, 19.0f, 10.0f, 19.0f)
                curveTo(10.5305f, 19.0f, 11.0392f, 19.2107f, 11.4142f, 19.5858f)
                curveTo(11.7893f, 19.9609f, 12.0f, 20.4696f, 12.0f, 21.0f)
                curveTo(12.0f, 21.5304f, 11.7893f, 22.0391f, 11.4142f, 22.4142f)
                curveTo(11.0392f, 22.7893f, 10.5305f, 23.0f, 10.0f, 23.0f)
                close()
            }
        }
        .build()
        return _hail!!
    }

private var _hail: ImageVector? = null
