package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Github: ImageVector
    get() {
        if (_github != null) {
            return _github!!
        }
        _github = Builder(name = "Github", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(5.883f, 18.653f)
                curveTo(5.583f, 18.453f, 5.325f, 18.198f, 5.023f, 17.837f)
                curveTo(4.8662f, 17.6451f, 4.7109f, 17.4521f, 4.557f, 17.258f)
                curveTo(4.094f, 16.683f, 3.802f, 16.418f, 3.5f, 16.309f)
                curveTo(3.2503f, 16.2193f, 3.0464f, 16.0342f, 2.9332f, 15.7942f)
                curveTo(2.8201f, 15.5543f, 2.8068f, 15.2792f, 2.8965f, 15.0295f)
                curveTo(2.9861f, 14.7798f, 3.1713f, 14.5759f, 3.4112f, 14.4627f)
                curveTo(3.6512f, 14.3496f, 3.9263f, 14.3363f, 4.176f, 14.426f)
                curveTo(4.928f, 14.696f, 5.437f, 15.161f, 6.123f, 16.014f)
                curveTo(6.029f, 15.897f, 6.463f, 16.441f, 6.556f, 16.553f)
                curveTo(6.746f, 16.78f, 6.886f, 16.918f, 6.996f, 16.991f)
                curveTo(7.2f, 17.128f, 7.583f, 17.187f, 8.146f, 17.131f)
                curveTo(8.169f, 16.749f, 8.24f, 16.378f, 8.348f, 16.036f)
                curveTo(5.38f, 15.31f, 3.7f, 13.396f, 3.7f, 9.64f)
                curveTo(3.7f, 8.4f, 4.07f, 7.284f, 4.758f, 6.348f)
                curveTo(4.54f, 5.454f, 4.573f, 4.373f, 5.06f, 3.156f)
                curveTo(5.1153f, 3.0183f, 5.2004f, 2.8947f, 5.3094f, 2.794f)
                curveTo(5.4184f, 2.6934f, 5.5484f, 2.6182f, 5.69f, 2.574f)
                curveTo(5.771f, 2.55f, 5.817f, 2.539f, 5.898f, 2.527f)
                curveTo(6.701f, 2.404f, 7.835f, 2.697f, 9.313f, 3.623f)
                curveTo(10.1938f, 3.4171f, 11.0954f, 3.3137f, 12.0f, 3.315f)
                curveTo(12.912f, 3.315f, 13.818f, 3.419f, 14.684f, 3.623f)
                curveTo(16.161f, 2.69f, 17.297f, 2.397f, 18.106f, 2.527f)
                curveTo(18.191f, 2.54f, 18.263f, 2.557f, 18.324f, 2.577f)
                curveTo(18.4628f, 2.6228f, 18.5899f, 2.6984f, 18.6963f, 2.7986f)
                curveTo(18.8028f, 2.8988f, 18.8859f, 3.0212f, 18.94f, 3.157f)
                curveTo(19.427f, 4.373f, 19.46f, 5.454f, 19.242f, 6.347f)
                curveTo(19.933f, 7.283f, 20.3f, 8.392f, 20.3f, 9.64f)
                curveTo(20.3f, 13.397f, 18.626f, 15.305f, 15.658f, 16.032f)
                curveTo(15.783f, 16.447f, 15.848f, 16.911f, 15.848f, 17.412f)
                curveTo(15.8481f, 18.3173f, 15.8441f, 19.2227f, 15.836f, 20.128f)
                curveTo(16.0606f, 20.177f, 16.2614f, 20.3018f, 16.4047f, 20.4816f)
                curveTo(16.548f, 20.6613f, 16.625f, 20.8849f, 16.6228f, 21.1147f)
                curveTo(16.6206f, 21.3446f, 16.5392f, 21.5666f, 16.3925f, 21.7435f)
                curveTo(16.2457f, 21.9204f, 16.0425f, 22.0414f, 15.817f, 22.086f)
                curveTo(14.678f, 22.314f, 13.834f, 21.554f, 13.834f, 20.561f)
                lineTo(13.836f, 20.115f)
                lineTo(13.841f, 19.41f)
                curveTo(13.846f, 18.702f, 13.848f, 18.072f, 13.848f, 17.412f)
                curveTo(13.848f, 16.715f, 13.665f, 16.26f, 13.423f, 16.052f)
                curveTo(12.762f, 15.482f, 13.097f, 14.397f, 13.963f, 14.3f)
                curveTo(16.93f, 13.967f, 18.3f, 12.818f, 18.3f, 9.64f)
                curveTo(18.3f, 8.685f, 17.988f, 7.896f, 17.387f, 7.236f)
                curveTo(17.2604f, 7.0972f, 17.1754f, 6.9256f, 17.1418f, 6.7408f)
                curveTo(17.1082f, 6.556f, 17.1273f, 6.3654f, 17.197f, 6.191f)
                curveTo(17.363f, 5.777f, 17.434f, 5.234f, 17.293f, 4.577f)
                lineTo(17.283f, 4.58f)
                curveTo(16.792f, 4.719f, 16.173f, 5.02f, 15.425f, 5.529f)
                curveTo(15.3044f, 5.6108f, 15.1673f, 5.6653f, 15.0234f, 5.6887f)
                curveTo(14.8795f, 5.712f, 14.7323f, 5.7036f, 14.592f, 5.664f)
                curveTo(13.7479f, 5.4303f, 12.8758f, 5.3129f, 12.0f, 5.315f)
                curveTo(11.11f, 5.315f, 10.228f, 5.434f, 9.408f, 5.665f)
                curveTo(9.2682f, 5.7042f, 9.1215f, 5.7126f, 8.9782f, 5.6895f)
                curveTo(8.8349f, 5.6663f, 8.6983f, 5.6122f, 8.578f, 5.531f)
                curveTo(7.826f, 5.024f, 7.204f, 4.724f, 6.71f, 4.584f)
                curveTo(6.566f, 5.237f, 6.637f, 5.778f, 6.802f, 6.191f)
                curveTo(6.8718f, 6.3653f, 6.8911f, 6.5558f, 6.8577f, 6.7407f)
                curveTo(6.8242f, 6.9255f, 6.7394f, 7.0971f, 6.613f, 7.236f)
                curveTo(6.016f, 7.89f, 5.7f, 8.694f, 5.7f, 9.64f)
                curveTo(5.7f, 12.812f, 7.071f, 13.968f, 10.022f, 14.3f)
                curveTo(10.887f, 14.397f, 11.223f, 15.477f, 10.566f, 16.048f)
                curveTo(10.374f, 16.216f, 10.137f, 16.78f, 10.137f, 17.412f)
                verticalLineTo(20.562f)
                curveTo(10.137f, 21.548f, 9.302f, 22.287f, 8.177f, 22.09f)
                curveTo(7.9488f, 22.0499f, 7.7415f, 21.9318f, 7.5907f, 21.7559f)
                curveTo(7.4399f, 21.58f, 7.3548f, 21.3571f, 7.3501f, 21.1254f)
                curveTo(7.3454f, 20.8938f, 7.4213f, 20.6676f, 7.5648f, 20.4857f)
                curveTo(7.7083f, 20.3038f, 7.9106f, 20.1773f, 8.137f, 20.128f)
                verticalLineTo(19.138f)
                curveTo(7.227f, 19.199f, 6.475f, 19.05f, 5.883f, 18.653f)
                close()
            }
        }
        .build()
        return _github!!
    }

private var _github: ImageVector? = null
