package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Equalizer: ImageVector
    get() {
        if (_equalizer != null) {
            return _equalizer!!
        }
        _equalizer = Builder(name = "Equalizer", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(6.17f, 18.0f)
                curveTo(6.3766f, 17.4145f, 6.7597f, 16.9074f, 7.2666f, 16.5488f)
                curveTo(7.7735f, 16.1902f, 8.3791f, 15.9976f, 9.0f, 15.9976f)
                curveTo(9.6209f, 15.9976f, 10.2265f, 16.1902f, 10.7334f, 16.5488f)
                curveTo(11.2403f, 16.9074f, 11.6234f, 17.4145f, 11.83f, 18.0f)
                horizontalLineTo(22.0f)
                verticalLineTo(20.0f)
                horizontalLineTo(11.83f)
                curveTo(11.6234f, 20.5855f, 11.2403f, 21.0926f, 10.7334f, 21.4512f)
                curveTo(10.2265f, 21.8099f, 9.6209f, 22.0025f, 9.0f, 22.0025f)
                curveTo(8.3791f, 22.0025f, 7.7735f, 21.8099f, 7.2666f, 21.4512f)
                curveTo(6.7597f, 21.0926f, 6.3766f, 20.5855f, 6.17f, 20.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(18.0f)
                horizontalLineTo(6.17f)
                close()
                moveTo(12.17f, 11.0f)
                curveTo(12.3766f, 10.4145f, 12.7597f, 9.9074f, 13.2666f, 9.5488f)
                curveTo(13.7735f, 9.1902f, 14.3791f, 8.9976f, 15.0f, 8.9976f)
                curveTo(15.6209f, 8.9976f, 16.2265f, 9.1902f, 16.7334f, 9.5488f)
                curveTo(17.2403f, 9.9074f, 17.6234f, 10.4145f, 17.83f, 11.0f)
                horizontalLineTo(22.0f)
                verticalLineTo(13.0f)
                horizontalLineTo(17.83f)
                curveTo(17.6234f, 13.5855f, 17.2403f, 14.0926f, 16.7334f, 14.4512f)
                curveTo(16.2265f, 14.8099f, 15.6209f, 15.0025f, 15.0f, 15.0025f)
                curveTo(14.3791f, 15.0025f, 13.7735f, 14.8099f, 13.2666f, 14.4512f)
                curveTo(12.7597f, 14.0926f, 12.3766f, 13.5855f, 12.17f, 13.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(11.0f)
                horizontalLineTo(12.17f)
                close()
                moveTo(6.17f, 4.0f)
                curveTo(6.3766f, 3.4145f, 6.7597f, 2.9074f, 7.2666f, 2.5488f)
                curveTo(7.7735f, 2.1902f, 8.3791f, 1.9976f, 9.0f, 1.9976f)
                curveTo(9.6209f, 1.9976f, 10.2265f, 2.1902f, 10.7334f, 2.5488f)
                curveTo(11.2403f, 2.9074f, 11.6234f, 3.4145f, 11.83f, 4.0f)
                horizontalLineTo(22.0f)
                verticalLineTo(6.0f)
                horizontalLineTo(11.83f)
                curveTo(11.6234f, 6.5855f, 11.2403f, 7.0926f, 10.7334f, 7.4512f)
                curveTo(10.2265f, 7.8099f, 9.6209f, 8.0025f, 9.0f, 8.0025f)
                curveTo(8.3791f, 8.0025f, 7.7735f, 7.8099f, 7.2666f, 7.4512f)
                curveTo(6.7597f, 7.0926f, 6.3766f, 6.5855f, 6.17f, 6.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(6.17f)
                close()
                moveTo(9.0f, 6.0f)
                curveTo(9.2652f, 6.0f, 9.5196f, 5.8946f, 9.7071f, 5.7071f)
                curveTo(9.8946f, 5.5196f, 10.0f, 5.2652f, 10.0f, 5.0f)
                curveTo(10.0f, 4.7348f, 9.8946f, 4.4804f, 9.7071f, 4.2929f)
                curveTo(9.5196f, 4.1054f, 9.2652f, 4.0f, 9.0f, 4.0f)
                curveTo(8.7348f, 4.0f, 8.4804f, 4.1054f, 8.2929f, 4.2929f)
                curveTo(8.1054f, 4.4804f, 8.0f, 4.7348f, 8.0f, 5.0f)
                curveTo(8.0f, 5.2652f, 8.1054f, 5.5196f, 8.2929f, 5.7071f)
                curveTo(8.4804f, 5.8946f, 8.7348f, 6.0f, 9.0f, 6.0f)
                close()
                moveTo(15.0f, 13.0f)
                curveTo(15.2652f, 13.0f, 15.5196f, 12.8947f, 15.7071f, 12.7071f)
                curveTo(15.8946f, 12.5196f, 16.0f, 12.2652f, 16.0f, 12.0f)
                curveTo(16.0f, 11.7348f, 15.8946f, 11.4804f, 15.7071f, 11.2929f)
                curveTo(15.5196f, 11.1054f, 15.2652f, 11.0f, 15.0f, 11.0f)
                curveTo(14.7348f, 11.0f, 14.4804f, 11.1054f, 14.2929f, 11.2929f)
                curveTo(14.1054f, 11.4804f, 14.0f, 11.7348f, 14.0f, 12.0f)
                curveTo(14.0f, 12.2652f, 14.1054f, 12.5196f, 14.2929f, 12.7071f)
                curveTo(14.4804f, 12.8947f, 14.7348f, 13.0f, 15.0f, 13.0f)
                close()
                moveTo(9.0f, 20.0f)
                curveTo(9.2652f, 20.0f, 9.5196f, 19.8947f, 9.7071f, 19.7071f)
                curveTo(9.8946f, 19.5196f, 10.0f, 19.2652f, 10.0f, 19.0f)
                curveTo(10.0f, 18.7348f, 9.8946f, 18.4804f, 9.7071f, 18.2929f)
                curveTo(9.5196f, 18.1054f, 9.2652f, 18.0f, 9.0f, 18.0f)
                curveTo(8.7348f, 18.0f, 8.4804f, 18.1054f, 8.2929f, 18.2929f)
                curveTo(8.1054f, 18.4804f, 8.0f, 18.7348f, 8.0f, 19.0f)
                curveTo(8.0f, 19.2652f, 8.1054f, 19.5196f, 8.2929f, 19.7071f)
                curveTo(8.4804f, 19.8947f, 8.7348f, 20.0f, 9.0f, 20.0f)
                close()
            }
        }
        .build()
        return _equalizer!!
    }

private var _equalizer: ImageVector? = null
