package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Chrome: ImageVector
    get() {
        if (_chrome != null) {
            return _chrome!!
        }
        _chrome = Builder(name = "Chrome", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(10.365f, 19.833f)
                lineTo(12.295f, 16.491f)
                curveTo(11.4423f, 16.5471f, 10.5912f, 16.3592f, 9.8414f, 15.9492f)
                curveTo(9.0915f, 15.5392f, 8.474f, 14.9242f, 8.061f, 14.176f)
                lineTo(4.794f, 8.52f)
                curveTo(4.2656f, 9.6145f, 3.9935f, 10.8149f, 3.9982f, 12.0303f)
                curveTo(4.0029f, 13.2456f, 4.2844f, 14.4439f, 4.8212f, 15.5343f)
                curveTo(5.3581f, 16.6247f, 6.1362f, 17.5784f, 7.0966f, 18.3233f)
                curveTo(8.0569f, 19.0681f, 9.1743f, 19.5844f, 10.364f, 19.833f)
                horizontalLineTo(10.365f)
                close()
                moveTo(12.59f, 19.979f)
                curveTo(13.8021f, 19.8898f, 14.9779f, 19.5256f, 16.0282f, 18.9141f)
                curveTo(17.0786f, 18.3025f, 17.9757f, 17.4597f, 18.6516f, 16.4496f)
                curveTo(19.3275f, 15.4395f, 19.7644f, 14.2887f, 19.9291f, 13.0845f)
                curveTo(20.0937f, 11.8803f, 19.9819f, 10.6545f, 19.602f, 9.5f)
                horizontalLineTo(15.742f)
                curveTo(16.2374f, 10.2395f, 16.5013f, 11.1099f, 16.5f, 12.0f)
                curveTo(16.5013f, 12.8167f, 16.2793f, 13.6183f, 15.858f, 14.318f)
                lineTo(12.59f, 19.978f)
                verticalLineTo(19.979f)
                close()
                moveTo(14.143f, 13.288f)
                lineTo(14.165f, 13.25f)
                curveTo(14.3834f, 12.8717f, 14.4988f, 12.4428f, 14.4998f, 12.006f)
                curveTo(14.5009f, 11.5693f, 14.3875f, 11.1398f, 14.1709f, 10.7605f)
                curveTo(13.9543f, 10.3812f, 13.6421f, 10.0653f, 13.2654f, 9.8442f)
                curveTo(12.8888f, 9.623f, 12.4607f, 9.5045f, 12.024f, 9.5003f)
                curveTo(11.5872f, 9.496f, 11.157f, 9.6063f, 10.7761f, 9.8202f)
                curveTo(10.3952f, 10.034f, 10.077f, 10.3438f, 9.8531f, 10.7189f)
                curveTo(9.6293f, 11.0939f, 9.5076f, 11.5211f, 9.5002f, 11.9578f)
                curveTo(9.4928f, 12.3945f, 9.6f, 12.8256f, 9.811f, 13.208f)
                lineTo(9.835f, 13.25f)
                curveTo(10.0523f, 13.6271f, 10.3644f, 13.9409f, 10.7403f, 14.1604f)
                curveTo(11.1162f, 14.3798f, 11.5429f, 14.4973f, 11.9781f, 14.5011f)
                curveTo(12.4134f, 14.5049f, 12.8421f, 14.395f, 13.2218f, 14.1823f)
                curveTo(13.6015f, 13.9695f, 13.919f, 13.6612f, 14.143f, 13.288f)
                close()
                moveTo(6.035f, 6.668f)
                lineTo(7.964f, 10.008f)
                curveTo(8.3357f, 9.255f, 8.9107f, 8.6211f, 9.624f, 8.1778f)
                curveTo(10.3372f, 7.7346f, 11.1603f, 7.4998f, 12.0f, 7.5f)
                horizontalLineTo(18.615f)
                curveTo(17.8818f, 6.421f, 16.8956f, 5.538f, 15.7425f, 4.9279f)
                curveTo(14.5894f, 4.3178f, 13.3045f, 3.9992f, 12.0f, 4.0f)
                curveTo(10.8737f, 3.9987f, 9.7599f, 4.2359f, 8.7318f, 4.6959f)
                curveTo(7.7037f, 5.1559f, 6.7846f, 5.8284f, 6.035f, 6.669f)
                verticalLineTo(6.668f)
                close()
                moveTo(12.0f, 22.0f)
                curveTo(6.477f, 22.0f, 2.0f, 17.523f, 2.0f, 12.0f)
                curveTo(2.0f, 6.477f, 6.477f, 2.0f, 12.0f, 2.0f)
                curveTo(17.523f, 2.0f, 22.0f, 6.477f, 22.0f, 12.0f)
                curveTo(22.0f, 17.523f, 17.523f, 22.0f, 12.0f, 22.0f)
                close()
            }
        }
        .build()
        return _chrome!!
    }

private var _chrome: ImageVector? = null
