package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.CalendarDate: ImageVector
    get() {
        if (_calendarDate != null) {
            return _calendarDate!!
        }
        _calendarDate = Builder(name = "CalendarDate", defaultWidth = 24.0.dp, defaultHeight =
                24.0.dp, viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(16.9914f, 3.9944f)
                horizontalLineTo(20.9904f)
                curveTo(21.5425f, 3.9944f, 21.9901f, 4.442f, 21.9901f, 4.9942f)
                verticalLineTo(20.9902f)
                curveTo(21.9901f, 21.5423f, 21.5425f, 21.9899f, 20.9904f, 21.9899f)
                horizontalLineTo(2.9949f)
                curveTo(2.4427f, 21.9899f, 1.9951f, 21.5423f, 1.9951f, 20.9902f)
                verticalLineTo(4.9942f)
                curveTo(1.9951f, 4.442f, 2.4427f, 3.9944f, 2.9949f, 3.9944f)
                horizontalLineTo(6.9939f)
                verticalLineTo(1.9949f)
                horizontalLineTo(8.9934f)
                verticalLineTo(3.9944f)
                horizontalLineTo(14.9919f)
                verticalLineTo(1.9949f)
                horizontalLineTo(16.9914f)
                verticalLineTo(3.9944f)
                close()
                moveTo(8.2689f, 18.1081f)
                curveTo(9.1789f, 18.1081f, 9.9101f, 17.8796f, 10.4627f, 17.4227f)
                curveTo(11.0153f, 16.9658f, 11.2916f, 16.3585f, 11.2916f, 15.6009f)
                curveTo(11.2916f, 15.1323f, 11.1735f, 14.7261f, 10.9372f, 14.3825f)
                curveTo(10.7009f, 14.0388f, 10.3426f, 13.781f, 9.8623f, 13.6092f)
                curveTo(10.2489f, 13.4335f, 10.5613f, 13.1816f, 10.7996f, 12.8535f)
                curveTo(11.0378f, 12.5255f, 11.1569f, 12.1662f, 11.1569f, 11.7757f)
                curveTo(11.1569f, 11.0181f, 10.9011f, 10.4235f, 10.3895f, 9.992f)
                curveTo(9.8779f, 9.5604f, 9.1711f, 9.3447f, 8.2689f, 9.3447f)
                curveTo(7.7495f, 9.3447f, 7.2741f, 9.4442f, 6.8425f, 9.6434f)
                curveTo(6.411f, 9.8426f, 6.0752f, 10.1189f, 5.835f, 10.4723f)
                curveTo(5.5948f, 10.8257f, 5.4747f, 11.225f, 5.4747f, 11.6702f)
                horizontalLineTo(7.1677f)
                curveTo(7.1677f, 11.3852f, 7.277f, 11.1538f, 7.4957f, 10.9761f)
                curveTo(7.7144f, 10.7984f, 7.9858f, 10.7096f, 8.3099f, 10.7096f)
                curveTo(8.6692f, 10.7096f, 8.9514f, 10.8052f, 9.1564f, 10.9966f)
                curveTo(9.3614f, 11.1879f, 9.464f, 11.4555f, 9.464f, 11.7991f)
                curveTo(9.464f, 12.1545f, 9.3605f, 12.4396f, 9.1535f, 12.6544f)
                curveTo(8.9465f, 12.8692f, 8.6282f, 12.9766f, 8.1986f, 12.9766f)
                horizontalLineTo(7.2965f)
                verticalLineTo(14.3005f)
                horizontalLineTo(8.1928f)
                curveTo(9.13f, 14.3005f, 9.5987f, 14.7261f, 9.5987f, 15.5775f)
                curveTo(9.5987f, 15.9289f, 9.4845f, 16.2111f, 9.256f, 16.4239f)
                curveTo(9.0275f, 16.6368f, 8.7122f, 16.7432f, 8.3099f, 16.7432f)
                curveTo(7.9585f, 16.7432f, 7.6626f, 16.6417f, 7.4225f, 16.4386f)
                curveTo(7.1823f, 16.2355f, 7.0622f, 15.9739f, 7.0622f, 15.6536f)
                horizontalLineTo(5.3693f)
                curveTo(5.3693f, 16.3917f, 5.6397f, 16.9853f, 6.1806f, 17.4344f)
                curveTo(6.7215f, 17.8835f, 7.4176f, 18.1081f, 8.2689f, 18.1081f)
                close()
                moveTo(15.3219f, 18.1081f)
                curveTo(16.263f, 18.1081f, 16.9777f, 17.7957f, 17.4659f, 17.1708f)
                curveTo(17.954f, 16.546f, 18.1981f, 15.6439f, 18.1981f, 14.4645f)
                verticalLineTo(12.8946f)
                curveTo(18.1864f, 11.7503f, 17.9345f, 10.8726f, 17.4424f, 10.2614f)
                curveTo(16.9504f, 9.6503f, 16.2396f, 9.3447f, 15.3101f, 9.3447f)
                curveTo(14.3807f, 9.3447f, 13.669f, 9.6532f, 13.1749f, 10.2702f)
                curveTo(12.6809f, 10.8872f, 12.4339f, 11.7913f, 12.4339f, 12.9824f)
                verticalLineTo(14.5523f)
                curveTo(12.4456f, 15.6966f, 12.6975f, 16.5753f, 13.1896f, 17.1884f)
                curveTo(13.6816f, 17.8015f, 14.3924f, 18.1081f, 15.3219f, 18.1081f)
                close()
                moveTo(15.3219f, 16.7432f)
                curveTo(14.904f, 16.7432f, 14.6004f, 16.5743f, 14.411f, 16.2365f)
                curveTo(14.2216f, 15.8987f, 14.1268f, 15.3822f, 14.1268f, 14.6871f)
                verticalLineTo(12.6134f)
                curveTo(14.1386f, 11.9612f, 14.2391f, 11.4818f, 14.4285f, 11.1753f)
                curveTo(14.6179f, 10.8687f, 14.9118f, 10.7154f, 15.3101f, 10.7154f)
                curveTo(15.7202f, 10.7154f, 16.0219f, 10.8765f, 16.2152f, 11.1987f)
                curveTo(16.4085f, 11.5209f, 16.5052f, 12.0354f, 16.5052f, 12.7422f)
                verticalLineTo(14.7691f)
                curveTo(16.4973f, 15.4369f, 16.4017f, 15.9329f, 16.2181f, 16.257f)
                curveTo(16.0346f, 16.5811f, 15.7358f, 16.7432f, 15.3219f, 16.7432f)
                close()
                moveTo(14.9919f, 5.9939f)
                horizontalLineTo(8.9934f)
                verticalLineTo(7.9934f)
                horizontalLineTo(6.9939f)
                verticalLineTo(5.9939f)
                horizontalLineTo(3.9946f)
                verticalLineTo(19.9804f)
                horizontalLineTo(19.9906f)
                verticalLineTo(5.9939f)
                horizontalLineTo(16.9914f)
                verticalLineTo(7.9934f)
                horizontalLineTo(14.9919f)
                verticalLineTo(5.9939f)
                close()
            }
        }
        .build()
        return _calendarDate!!
    }

private var _calendarDate: ImageVector? = null
