package com.decathlon.vitamin.compose.vitaminicons.line

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.LineGroup

public val LineGroup.Apple: ImageVector
    get() {
        if (_apple != null) {
            return _apple!!
        }
        _apple = Builder(name = "Apple", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(11.456f, 5.962f)
                curveTo(12.692f, 6.058f, 13.964f, 5.326f, 14.744f, 4.39f)
                curveTo(15.524f, 3.454f, 16.04f, 2.146f, 15.896f, 0.85f)
                curveTo(14.78f, 0.898f, 13.436f, 1.594f, 12.632f, 2.53f)
                curveTo(11.912f, 3.358f, 11.288f, 4.69f, 11.456f, 5.962f)
                close()
                moveTo(15.884f, 6.214f)
                curveTo(16.592f, 6.262f, 18.62f, 6.478f, 19.94f, 8.41f)
                curveTo(19.832f, 8.47f, 17.516f, 9.814f, 17.54f, 12.622f)
                curveTo(17.576f, 15.982f, 20.48f, 17.098f, 20.516f, 17.11f)
                curveTo(20.492f, 17.194f, 20.048f, 18.706f, 18.98f, 20.266f)
                curveTo(18.056f, 21.622f, 17.096f, 22.966f, 15.584f, 22.99f)
                curveTo(14.8538f, 23.0077f, 14.3663f, 22.797f, 13.8592f, 22.5779f)
                curveTo(13.333f, 22.3505f, 12.7857f, 22.114f, 11.924f, 22.114f)
                curveTo(11.0084f, 22.114f, 10.4323f, 22.36f, 9.8775f, 22.5969f)
                curveTo(9.3997f, 22.8009f, 8.9376f, 22.9982f, 8.288f, 23.026f)
                curveTo(6.824f, 23.074f, 5.72f, 21.562f, 4.784f, 20.218f)
                curveTo(2.876f, 17.458f, 1.424f, 12.442f, 3.38f, 9.046f)
                curveTo(4.352f, 7.354f, 6.08f, 6.286f, 7.964f, 6.262f)
                curveTo(8.7756f, 6.2415f, 9.5639f, 6.5544f, 10.2541f, 6.8284f)
                curveTo(10.7783f, 7.0364f, 11.2459f, 7.222f, 11.624f, 7.222f)
                curveTo(11.9562f, 7.222f, 12.3895f, 7.0517f, 12.9021f, 6.8503f)
                curveTo(13.7227f, 6.5278f, 14.7465f, 6.1254f, 15.884f, 6.214f)
                close()
                moveTo(15.729f, 8.208f)
                curveTo(15.256f, 8.171f, 14.748f, 8.284f, 13.97f, 8.581f)
                curveTo(14.036f, 8.556f, 13.228f, 8.871f, 13.002f, 8.951f)
                curveTo(12.5f, 9.126f, 12.087f, 9.222f, 11.624f, 9.222f)
                curveTo(11.166f, 9.222f, 10.744f, 9.13f, 10.258f, 8.967f)
                curveTo(10.103f, 8.914f, 9.947f, 8.857f, 9.753f, 8.781f)
                curveTo(9.7197f, 8.768f, 9.6502f, 8.7404f, 9.5752f, 8.7106f)
                curveTo(9.4657f, 8.6671f, 9.3441f, 8.6188f, 9.305f, 8.604f)
                curveTo(8.657f, 8.35f, 8.292f, 8.254f, 7.989f, 8.262f)
                curveTo(6.837f, 8.277f, 5.746f, 8.942f, 5.113f, 10.044f)
                curveTo(3.821f, 12.288f, 4.536f, 16.343f, 6.425f, 19.075f)
                curveTo(7.431f, 20.519f, 7.981f, 21.035f, 8.203f, 21.028f)
                curveTo(8.425f, 21.018f, 8.588f, 20.971f, 8.986f, 20.803f)
                lineTo(9.153f, 20.732f)
                curveTo(10.158f, 20.303f, 10.863f, 20.114f, 11.924f, 20.114f)
                curveTo(12.945f, 20.114f, 13.627f, 20.3f, 14.592f, 20.716f)
                lineTo(14.76f, 20.788f)
                curveTo(15.158f, 20.958f, 15.302f, 20.996f, 15.552f, 20.99f)
                curveTo(15.91f, 20.985f, 16.351f, 20.573f, 17.33f, 19.136f)
                curveTo(17.598f, 18.745f, 17.835f, 18.333f, 18.04f, 17.916f)
                curveTo(17.9053f, 17.805f, 17.7745f, 17.6893f, 17.648f, 17.569f)
                curveTo(16.359f, 16.341f, 15.562f, 14.685f, 15.54f, 12.639f)
                curveTo(15.5185f, 11.1252f, 16.0161f, 9.6496f, 16.95f, 8.458f)
                curveTo(16.558f, 8.3133f, 16.1463f, 8.229f, 15.729f, 8.208f)
                close()
            }
        }
        .build()
        return _apple!!
    }

private var _apple: ImageVector? = null
