package com.decathlon.vitamin.compose.vitaminicons.fill

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.FillGroup

public val FillGroup.Whatsapp: ImageVector
    get() {
        if (_whatsapp != null) {
            return _whatsapp!!
        }
        _whatsapp = Builder(name = "Whatsapp", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(3.356f, 17.032f)
                lineTo(2.004f, 22.0f)
                lineTo(6.97f, 20.645f)
                curveTo(8.4967f, 21.5352f, 10.2328f, 22.0029f, 12.0f, 22.0f)
                curveTo(17.523f, 22.0f, 22.0f, 17.523f, 22.0f, 12.0f)
                curveTo(22.0f, 6.477f, 17.523f, 2.0f, 12.0f, 2.0f)
                curveTo(6.477f, 2.0f, 2.0f, 6.477f, 2.0f, 12.0f)
                curveTo(1.9971f, 13.768f, 2.4652f, 15.5049f, 3.356f, 17.032f)
                close()
                moveTo(8.02f, 7.408f)
                curveTo(8.1357f, 7.35f, 8.2619f, 7.316f, 8.391f, 7.308f)
                curveTo(8.5252f, 7.2987f, 8.6597f, 7.2963f, 8.794f, 7.303f)
                curveTo(8.848f, 7.307f, 8.902f, 7.313f, 8.956f, 7.319f)
                curveTo(9.115f, 7.338f, 9.29f, 7.434f, 9.349f, 7.568f)
                curveTo(9.647f, 8.244f, 9.937f, 8.925f, 10.217f, 9.609f)
                curveTo(10.279f, 9.76f, 10.242f, 9.955f, 10.124f, 10.145f)
                curveTo(10.0429f, 10.2738f, 9.9551f, 10.3983f, 9.861f, 10.518f)
                curveTo(9.748f, 10.662f, 9.505f, 10.928f, 9.505f, 10.928f)
                curveTo(9.505f, 10.928f, 9.406f, 11.046f, 9.444f, 11.193f)
                curveTo(9.4694f, 11.2653f, 9.5036f, 11.3342f, 9.546f, 11.398f)
                lineTo(9.605f, 11.493f)
                curveTo(9.8887f, 11.958f, 10.2316f, 12.3842f, 10.625f, 12.761f)
                curveTo(10.6573f, 12.7922f, 10.6894f, 12.8238f, 10.7216f, 12.8553f)
                curveTo(10.8087f, 12.9409f, 10.896f, 13.0266f, 10.988f, 13.107f)
                curveTo(11.4562f, 13.5198f, 11.9859f, 13.8572f, 12.558f, 14.107f)
                lineTo(12.563f, 14.109f)
                curveTo(12.5876f, 14.1197f, 12.6087f, 14.129f, 12.6293f, 14.1381f)
                curveTo(12.6797f, 14.1603f, 12.7269f, 14.1811f, 12.815f, 14.218f)
                curveTo(12.877f, 14.2445f, 12.9409f, 14.2666f, 13.006f, 14.284f)
                curveTo(13.1437f, 14.3194f, 13.2891f, 14.2681f, 13.374f, 14.154f)
                curveTo(14.097f, 13.278f, 14.164f, 13.221f, 14.169f, 13.221f)
                verticalLineTo(13.223f)
                curveTo(14.2708f, 13.1281f, 14.4086f, 13.0818f, 14.547f, 13.096f)
                curveTo(14.608f, 13.0987f, 14.668f, 13.1126f, 14.724f, 13.137f)
                curveTo(15.255f, 13.379f, 16.125f, 13.758f, 16.125f, 13.758f)
                lineTo(16.707f, 14.019f)
                curveTo(16.804f, 14.066f, 16.893f, 14.177f, 16.897f, 14.284f)
                curveTo(16.8972f, 14.2878f, 16.8974f, 14.2916f, 16.8975f, 14.2957f)
                curveTo(16.9007f, 14.3634f, 16.9057f, 14.4701f, 16.883f, 14.657f)
                curveTo(16.851f, 14.916f, 16.773f, 15.227f, 16.695f, 15.39f)
                curveTo(16.64f, 15.505f, 16.568f, 15.606f, 16.485f, 15.692f)
                curveTo(16.373f, 15.809f, 16.29f, 15.88f, 16.155f, 15.98f)
                curveTo(16.073f, 16.042f, 16.03f, 16.07f, 16.03f, 16.07f)
                curveTo(15.891f, 16.158f, 15.813f, 16.202f, 15.647f, 16.29f)
                curveTo(15.3896f, 16.4271f, 15.1053f, 16.506f, 14.814f, 16.521f)
                curveTo(14.7817f, 16.5226f, 14.7494f, 16.5243f, 14.7171f, 16.526f)
                curveTo(14.5637f, 16.5341f, 14.4108f, 16.5423f, 14.258f, 16.534f)
                lineTo(13.689f, 16.447f)
                curveTo(12.2673f, 16.073f, 10.9524f, 15.3725f, 9.849f, 14.401f)
                curveTo(9.6605f, 14.2343f, 9.4832f, 14.057f, 9.3048f, 13.8786f)
                curveTo(9.2703f, 13.8441f, 9.2357f, 13.8095f, 9.201f, 13.775f)
                curveTo(8.312f, 12.89f, 7.639f, 11.935f, 7.23f, 11.033f)
                curveTo(7.03f, 10.587f, 6.902f, 10.11f, 6.9f, 9.62f)
                curveTo(6.8966f, 9.0134f, 7.0954f, 8.423f, 7.465f, 7.942f)
                curveTo(7.4761f, 7.9276f, 7.4871f, 7.9131f, 7.4981f, 7.8985f)
                curveTo(7.5599f, 7.8169f, 7.6242f, 7.7319f, 7.726f, 7.636f)
                curveTo(7.8125f, 7.5462f, 7.9115f, 7.4694f, 8.02f, 7.408f)
                close()
            }
        }
        .build()
        return _whatsapp!!
    }

private var _whatsapp: ImageVector? = null
