package com.decathlon.vitamin.compose.vitaminicons.fill

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.FillGroup

public val FillGroup.Unlink: ImageVector
    get() {
        if (_unlink != null) {
            return _unlink!!
        }
        _unlink = Builder(name = "Unlink", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(17.0f, 17.0f)
                horizontalLineTo(22.0f)
                verticalLineTo(19.0f)
                horizontalLineTo(19.0f)
                verticalLineTo(22.0f)
                horizontalLineTo(17.0f)
                verticalLineTo(17.0f)
                close()
                moveTo(7.0f, 7.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(2.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(18.364f, 15.536f)
                lineTo(16.95f, 14.12f)
                lineTo(18.364f, 12.706f)
                curveTo(18.8316f, 12.2424f, 19.2031f, 11.6911f, 19.4571f, 11.0836f)
                curveTo(19.711f, 10.4761f, 19.8425f, 9.8244f, 19.844f, 9.166f)
                curveTo(19.8454f, 8.5075f, 19.7168f, 7.8553f, 19.4655f, 7.2467f)
                curveTo(19.2142f, 6.6381f, 18.8451f, 6.0851f, 18.3795f, 5.6195f)
                curveTo(17.9139f, 5.1539f, 17.3609f, 4.7848f, 16.7523f, 4.5335f)
                curveTo(16.1437f, 4.2822f, 15.4915f, 4.1536f, 14.833f, 4.155f)
                curveTo(14.1746f, 4.1565f, 13.5229f, 4.288f, 12.9154f, 4.5419f)
                curveTo(12.3079f, 4.7959f, 11.7566f, 5.1674f, 11.293f, 5.635f)
                lineTo(9.879f, 7.05f)
                lineTo(8.464f, 5.636f)
                lineTo(9.88f, 4.222f)
                curveTo(11.1928f, 2.9092f, 12.9734f, 2.1716f, 14.83f, 2.1716f)
                curveTo(16.6866f, 2.1716f, 18.4672f, 2.9092f, 19.78f, 4.222f)
                curveTo(21.0928f, 5.5348f, 21.8304f, 7.3154f, 21.8304f, 9.172f)
                curveTo(21.8304f, 11.0286f, 21.0928f, 12.8092f, 19.78f, 14.122f)
                lineTo(18.365f, 15.536f)
                horizontalLineTo(18.364f)
                close()
                moveTo(15.536f, 18.364f)
                lineTo(14.121f, 19.778f)
                curveTo(12.8082f, 21.0908f, 11.0276f, 21.8284f, 9.171f, 21.8284f)
                curveTo(7.3144f, 21.8284f, 5.5338f, 21.0908f, 4.221f, 19.778f)
                curveTo(2.9082f, 18.4652f, 2.1706f, 16.6846f, 2.1706f, 14.828f)
                curveTo(2.1706f, 12.9714f, 2.9082f, 11.1908f, 4.221f, 9.878f)
                lineTo(5.636f, 8.464f)
                lineTo(7.05f, 9.88f)
                lineTo(5.636f, 11.294f)
                curveTo(5.1684f, 11.7576f, 4.7969f, 12.3089f, 4.5429f, 12.9164f)
                curveTo(4.2889f, 13.5239f, 4.1575f, 14.1756f, 4.156f, 14.834f)
                curveTo(4.1546f, 15.4925f, 4.2832f, 16.1447f, 4.5345f, 16.7533f)
                curveTo(4.7858f, 17.3619f, 5.1549f, 17.9149f, 5.6205f, 18.3805f)
                curveTo(6.0861f, 18.8461f, 6.6391f, 19.2152f, 7.2477f, 19.4665f)
                curveTo(7.8563f, 19.7178f, 8.5085f, 19.8464f, 9.167f, 19.845f)
                curveTo(9.8254f, 19.8435f, 10.4771f, 19.712f, 11.0846f, 19.4581f)
                curveTo(11.6921f, 19.2041f, 12.2434f, 18.8326f, 12.707f, 18.365f)
                lineTo(14.121f, 16.951f)
                lineTo(15.536f, 18.365f)
                verticalLineTo(18.364f)
                close()
                moveTo(14.828f, 7.757f)
                lineTo(16.243f, 9.172f)
                lineTo(9.172f, 16.242f)
                lineTo(7.757f, 14.828f)
                lineTo(14.828f, 7.758f)
                verticalLineTo(7.757f)
                close()
            }
        }
        .build()
        return _unlink!!
    }

private var _unlink: ImageVector? = null
