package com.decathlon.vitamin.compose.vitaminicons.fill

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.FillGroup

public val FillGroup.Tiktok: ImageVector
    get() {
        if (_tiktok != null) {
            return _tiktok!!
        }
        _tiktok = Builder(name = "Tiktok", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(18.1171f, 6.2788f)
                curveTo(17.9902f, 6.209f, 17.8667f, 6.1326f, 17.747f, 6.0497f)
                curveTo(17.399f, 5.805f, 17.0799f, 5.5166f, 16.7966f, 5.1908f)
                curveTo(16.0878f, 4.3281f, 15.8231f, 3.453f, 15.7256f, 2.8402f)
                horizontalLineTo(15.7295f)
                curveTo(15.6481f, 2.3316f, 15.6817f, 2.0026f, 15.6868f, 2.0026f)
                horizontalLineTo(12.4585f)
                verticalLineTo(15.2811f)
                curveTo(12.4585f, 15.4594f, 12.4585f, 15.6356f, 12.4514f, 15.8097f)
                curveTo(12.4514f, 15.8313f, 12.4495f, 15.8513f, 12.4483f, 15.8747f)
                curveTo(12.4483f, 15.8842f, 12.4483f, 15.8942f, 12.4463f, 15.9042f)
                curveTo(12.4463f, 15.9067f, 12.4463f, 15.9092f, 12.4463f, 15.9117f)
                curveTo(12.4123f, 16.3882f, 12.2687f, 16.8484f, 12.0282f, 17.2519f)
                curveTo(11.7877f, 17.6555f, 11.4577f, 17.99f, 11.0671f, 18.226f)
                curveTo(10.66f, 18.4724f, 10.1997f, 18.6016f, 9.7313f, 18.6009f)
                curveTo(8.2272f, 18.6009f, 7.0082f, 17.2963f, 7.0082f, 15.6851f)
                curveTo(7.0082f, 14.0739f, 8.2272f, 12.7693f, 9.7313f, 12.7693f)
                curveTo(10.0161f, 12.7691f, 10.299f, 12.8167f, 10.5698f, 12.9105f)
                lineTo(10.5737f, 9.4141f)
                curveTo(9.7519f, 9.3012f, 8.9169f, 9.3706f, 8.1216f, 9.6181f)
                curveTo(7.3263f, 9.8656f, 6.5878f, 10.2857f, 5.9528f, 10.852f)
                curveTo(5.3963f, 11.3663f, 4.9285f, 11.9799f, 4.5704f, 12.6652f)
                curveTo(4.4342f, 12.9151f, 3.92f, 13.9194f, 3.8577f, 15.5493f)
                curveTo(3.8186f, 16.4745f, 4.0798f, 17.4329f, 4.2043f, 17.8291f)
                verticalLineTo(17.8374f)
                curveTo(4.2826f, 18.0707f, 4.5861f, 18.8667f, 5.0807f, 19.5377f)
                curveTo(5.4795f, 20.076f, 5.9507f, 20.5489f, 6.4791f, 20.941f)
                verticalLineTo(20.9327f)
                lineTo(6.4869f, 20.941f)
                curveTo(8.0498f, 22.0707f, 9.7826f, 21.9966f, 9.7826f, 21.9966f)
                curveTo(10.0826f, 21.9837f, 11.0875f, 21.9966f, 12.2286f, 21.4213f)
                curveTo(13.4942f, 20.7836f, 14.2148f, 19.8335f, 14.2148f, 19.8335f)
                curveTo(14.6751f, 19.2657f, 15.0411f, 18.6188f, 15.2972f, 17.9203f)
                curveTo(15.5893f, 17.1034f, 15.6868f, 16.1237f, 15.6868f, 15.7322f)
                verticalLineTo(8.6876f)
                curveTo(15.726f, 8.7126f, 16.2476f, 9.0796f, 16.2476f, 9.0796f)
                curveTo(16.2476f, 9.0796f, 16.9991f, 9.592f, 18.1715f, 9.9256f)
                curveTo(19.0127f, 10.163f, 20.146f, 10.213f, 20.146f, 10.213f)
                verticalLineTo(6.804f)
                curveTo(19.7489f, 6.8499f, 18.9426f, 6.7166f, 18.1171f, 6.2788f)
                close()
            }
        }
        .build()
        return _tiktok!!
    }

private var _tiktok: ImageVector? = null
