package com.decathlon.vitamin.compose.vitaminicons.fill

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.FillGroup

public val FillGroup.TShirtNumber: ImageVector
    get() {
        if (_tShirtNumber != null) {
            return _tShirtNumber!!
        }
        _tShirtNumber = Builder(name = "TShirtNumber", defaultWidth = 24.0.dp, defaultHeight =
                24.0.dp, viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(12.0f, 5.0f)
                curveTo(10.3431f, 5.0f, 9.0f, 3.6569f, 9.0f, 2.0f)
                horizontalLineTo(3.0f)
                curveTo(2.4477f, 2.0f, 2.0f, 2.4477f, 2.0f, 3.0f)
                verticalLineTo(10.0f)
                curveTo(2.0f, 10.5523f, 2.4477f, 11.0f, 3.0f, 11.0f)
                lineTo(4.999f, 10.999f)
                lineTo(5.0f, 19.0f)
                curveTo(5.0f, 19.5523f, 5.4477f, 20.0f, 6.0f, 20.0f)
                horizontalLineTo(9.0f)
                verticalLineTo(18.0f)
                horizontalLineTo(6.999f)
                verticalLineTo(8.999f)
                lineTo(4.0f, 9.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(7.416f)
                lineTo(7.434f, 4.04f)
                curveTo(8.239f, 5.8408f, 10.0274f, 7.0002f, 12.0f, 7.0f)
                lineTo(12.216f, 6.995f)
                curveTo(14.1086f, 6.9132f, 15.7925f, 5.7692f, 16.566f, 4.04f)
                lineTo(16.583f, 3.999f)
                horizontalLineTo(20.0f)
                verticalLineTo(8.999f)
                lineTo(22.0f, 9.0f)
                verticalLineTo(3.0f)
                curveTo(22.0f, 2.4477f, 21.5523f, 2.0f, 21.0f, 2.0f)
                horizontalLineTo(15.0f)
                curveTo(15.0f, 3.6569f, 13.6569f, 5.0f, 12.0f, 5.0f)
                close()
            }
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = EvenOdd) {
                moveTo(16.2482f, 21.4185f)
                curveTo(16.8188f, 21.801f, 17.4988f, 22.0f, 18.25f, 22.0f)
                curveTo(18.3512f, 21.9908f, 18.4459f, 21.9862f, 18.5388f, 21.9817f)
                curveTo(18.9404f, 21.9623f, 19.3094f, 21.9444f, 20.0251f, 21.5646f)
                curveTo(20.4246f, 21.289f, 21.3049f, 20.5205f, 21.6293f, 19.6511f)
                curveTo(21.6366f, 19.6209f, 21.6518f, 19.5775f, 21.672f, 19.5198f)
                curveTo(21.7715f, 19.2354f, 21.9927f, 18.6027f, 22.0f, 17.4853f)
                verticalLineTo(15.0147f)
                curveTo(22.0f, 14.1426f, 21.8496f, 13.3538f, 21.5556f, 12.6847f)
                curveTo(21.1035f, 11.648f, 20.3585f, 11.0984f, 20.0425f, 10.9531f)
                curveTo(19.5174f, 10.655f, 18.9115f, 10.5f, 18.25f, 10.5f)
                curveTo(17.4988f, 10.5f, 16.8188f, 10.699f, 16.2482f, 11.0815f)
                curveTo(15.6785f, 11.4634f, 15.2391f, 12.0137f, 14.9444f, 12.6847f)
                curveTo(14.6504f, 13.3538f, 14.5f, 14.1425f, 14.5f, 15.0147f)
                verticalLineTo(17.4853f)
                curveTo(14.5f, 18.3574f, 14.6504f, 19.1461f, 14.9444f, 19.8153f)
                curveTo(15.0998f, 20.1788f, 15.5781f, 21.0084f, 16.2482f, 21.4185f)
                close()
                moveTo(17.3618f, 19.7572f)
                curveTo(17.1345f, 19.6048f, 16.9307f, 19.3643f, 16.7755f, 19.011f)
                curveTo(16.6031f, 18.6184f, 16.5f, 18.1058f, 16.5f, 17.4853f)
                verticalLineTo(15.0147f)
                curveTo(16.5f, 14.3942f, 16.6031f, 13.8816f, 16.7755f, 13.4891f)
                curveTo(16.9307f, 13.1357f, 17.1345f, 12.8952f, 17.3618f, 12.7428f)
                curveTo(17.5882f, 12.591f, 17.8773f, 12.5f, 18.25f, 12.5f)
                curveTo(18.6227f, 12.5f, 18.9118f, 12.591f, 19.1382f, 12.7428f)
                curveTo(19.3655f, 12.8952f, 19.5693f, 13.1357f, 19.7245f, 13.4891f)
                curveTo(19.8969f, 13.8816f, 20.0f, 14.3942f, 20.0f, 15.0147f)
                verticalLineTo(17.4853f)
                curveTo(20.0f, 18.1059f, 19.8969f, 18.6184f, 19.7245f, 19.011f)
                curveTo(19.5693f, 19.3643f, 19.3655f, 19.6048f, 19.1382f, 19.7572f)
                curveTo(18.9118f, 19.909f, 18.6227f, 20.0f, 18.25f, 20.0f)
                curveTo(17.8773f, 20.0f, 17.5882f, 19.909f, 17.3618f, 19.7572f)
                close()
            }
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(13.0f, 22.0034f)
                verticalLineTo(10.7534f)
                horizontalLineTo(11.6842f)
                lineTo(8.75f, 11.5392f)
                verticalLineTo(13.6101f)
                lineTo(11.0f, 13.0071f)
                verticalLineTo(22.0034f)
                horizontalLineTo(13.0f)
                close()
            }
        }
        .build()
        return _tShirtNumber!!
    }

private var _tShirtNumber: ImageVector? = null
