package com.decathlon.vitamin.compose.vitaminicons.fill

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.FillGroup

public val FillGroup.Snapchat: ImageVector
    get() {
        if (_snapchat != null) {
            return _snapchat!!
        }
        _snapchat = Builder(name = "Snapchat", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(11.871f, 21.764f)
                curveTo(10.681f, 21.764f, 9.887f, 21.203f, 9.178f, 20.708f)
                curveTo(8.675f, 20.351f, 8.202f, 20.012f, 7.645f, 19.918f)
                curveTo(7.3798f, 19.8724f, 7.1111f, 19.8503f, 6.842f, 19.852f)
                curveTo(6.37f, 19.852f, 5.995f, 19.923f, 5.728f, 19.977f)
                curveTo(5.558f, 20.007f, 5.416f, 20.035f, 5.304f, 20.035f)
                curveTo(5.188f, 20.035f, 5.041f, 20.003f, 4.984f, 19.807f)
                curveTo(4.934f, 19.647f, 4.903f, 19.495f, 4.872f, 19.348f)
                curveTo(4.792f, 18.978f, 4.725f, 18.751f, 4.586f, 18.728f)
                curveTo(3.097f, 18.501f, 2.206f, 18.158f, 2.032f, 17.752f)
                curveTo(2.018f, 17.708f, 2.001f, 17.662f, 2.001f, 17.627f)
                curveTo(1.991f, 17.502f, 2.081f, 17.4f, 2.206f, 17.377f)
                curveTo(3.387f, 17.181f, 4.448f, 16.553f, 5.344f, 15.519f)
                curveTo(6.04f, 14.716f, 6.379f, 13.94f, 6.41f, 13.856f)
                curveTo(6.41f, 13.846f, 6.419f, 13.846f, 6.419f, 13.846f)
                curveTo(6.589f, 13.495f, 6.624f, 13.196f, 6.521f, 12.951f)
                curveTo(6.33f, 12.491f, 5.696f, 12.295f, 5.264f, 12.161f)
                curveTo(5.153f, 12.131f, 5.059f, 12.095f, 4.979f, 12.068f)
                curveTo(4.609f, 11.921f, 3.993f, 11.608f, 4.074f, 11.176f)
                curveTo(4.132f, 10.864f, 4.546f, 10.641f, 4.885f, 10.641f)
                curveTo(4.979f, 10.641f, 5.059f, 10.655f, 5.125f, 10.691f)
                curveTo(5.505f, 10.864f, 5.848f, 10.953f, 6.142f, 10.953f)
                curveTo(6.508f, 10.953f, 6.682f, 10.815f, 6.726f, 10.771f)
                curveTo(6.7167f, 10.5732f, 6.705f, 10.3755f, 6.691f, 10.178f)
                curveTo(6.601f, 8.813f, 6.499f, 7.119f, 6.931f, 6.148f)
                curveTo(8.229f, 3.241f, 10.984f, 3.008f, 11.8f, 3.008f)
                lineTo(12.156f, 3.0f)
                horizontalLineTo(12.206f)
                curveTo(13.021f, 3.0f, 15.776f, 3.227f, 17.074f, 6.139f)
                curveTo(17.511f, 7.11f, 17.404f, 8.809f, 17.314f, 10.169f)
                lineTo(17.306f, 10.236f)
                curveTo(17.296f, 10.418f, 17.283f, 10.592f, 17.274f, 10.771f)
                curveTo(17.319f, 10.806f, 17.479f, 10.94f, 17.809f, 10.944f)
                curveTo(18.095f, 10.936f, 18.407f, 10.842f, 18.763f, 10.681f)
                curveTo(18.8616f, 10.6384f, 18.9676f, 10.6159f, 19.075f, 10.615f)
                curveTo(19.2f, 10.615f, 19.325f, 10.645f, 19.432f, 10.681f)
                horizontalLineTo(19.441f)
                curveTo(19.74f, 10.793f, 19.936f, 11.002f, 19.936f, 11.221f)
                curveTo(19.945f, 11.426f, 19.784f, 11.738f, 19.022f, 12.046f)
                curveTo(18.942f, 12.076f, 18.848f, 12.113f, 18.737f, 12.139f)
                curveTo(18.313f, 12.269f, 17.68f, 12.474f, 17.479f, 12.929f)
                curveTo(17.368f, 13.169f, 17.413f, 13.477f, 17.582f, 13.824f)
                curveTo(17.582f, 13.834f, 17.591f, 13.834f, 17.591f, 13.834f)
                curveTo(17.64f, 13.958f, 18.928f, 16.883f, 21.795f, 17.36f)
                curveTo(21.9162f, 17.3804f, 22.0037f, 17.4872f, 22.0f, 17.61f)
                curveTo(22.0f, 17.654f, 21.991f, 17.699f, 21.969f, 17.739f)
                curveTo(21.795f, 18.149f, 20.912f, 18.483f, 19.414f, 18.715f)
                curveTo(19.276f, 18.737f, 19.209f, 18.965f, 19.129f, 19.335f)
                curveTo(19.097f, 19.4892f, 19.0596f, 19.6423f, 19.017f, 19.794f)
                curveTo(18.973f, 19.941f, 18.879f, 20.021f, 18.719f, 20.021f)
                horizontalLineTo(18.696f)
                curveTo(18.594f, 20.021f, 18.456f, 20.008f, 18.273f, 19.972f)
                curveTo(17.9065f, 19.8939f, 17.5327f, 19.855f, 17.158f, 19.856f)
                curveTo(16.895f, 19.856f, 16.623f, 19.879f, 16.356f, 19.923f)
                curveTo(15.803f, 20.013f, 15.326f, 20.356f, 14.822f, 20.713f)
                curveTo(14.105f, 21.203f, 13.307f, 21.764f, 12.125f, 21.764f)
                horizontalLineTo(11.871f)
                close()
            }
        }
        .build()
        return _snapchat!!
    }

private var _snapchat: ImageVector? = null
