package com.decathlon.vitamin.compose.vitaminicons.fill

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.FillGroup

public val FillGroup.Safari: ImageVector
    get() {
        if (_safari != null) {
            return _safari!!
        }
        _safari = Builder(name = "Safari", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(16.7f, 6.8f)
                lineTo(10.586f, 10.586f)
                lineTo(6.8f, 16.7f)
                lineTo(6.696f, 16.596f)
                lineTo(5.281f, 18.01f)
                lineTo(5.989f, 18.718f)
                lineTo(7.403f, 17.303f)
                lineTo(7.3f, 17.2f)
                lineTo(13.414f, 13.415f)
                lineTo(17.2f, 7.3f)
                lineTo(17.304f, 7.404f)
                lineTo(18.719f, 5.99f)
                lineTo(18.011f, 5.282f)
                lineTo(16.597f, 6.697f)
                lineTo(16.701f, 6.801f)
                lineTo(16.7f, 6.8f)
                close()
                moveTo(12.0f, 22.0f)
                curveTo(6.477f, 22.0f, 2.0f, 17.523f, 2.0f, 12.0f)
                curveTo(2.0f, 6.477f, 6.477f, 2.0f, 12.0f, 2.0f)
                curveTo(17.523f, 2.0f, 22.0f, 6.477f, 22.0f, 12.0f)
                curveTo(22.0f, 17.523f, 17.523f, 22.0f, 12.0f, 22.0f)
                close()
                moveTo(11.5f, 3.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(12.5f)
                verticalLineTo(3.0f)
                horizontalLineTo(11.5f)
                close()
                moveTo(11.5f, 19.0f)
                verticalLineTo(21.0f)
                horizontalLineTo(12.5f)
                verticalLineTo(19.0f)
                horizontalLineTo(11.5f)
                close()
                moveTo(8.094f, 3.876f)
                lineTo(8.859f, 5.724f)
                lineTo(9.783f, 5.342f)
                lineTo(9.018f, 3.494f)
                lineTo(8.094f, 3.876f)
                close()
                moveTo(14.217f, 18.658f)
                lineTo(14.982f, 20.506f)
                lineTo(15.906f, 20.124f)
                lineTo(15.141f, 18.276f)
                lineTo(14.217f, 18.658f)
                close()
                moveTo(14.982f, 3.494f)
                lineTo(14.217f, 5.342f)
                lineTo(15.141f, 5.724f)
                lineTo(15.906f, 3.876f)
                lineTo(14.982f, 3.494f)
                close()
                moveTo(8.86f, 18.276f)
                lineTo(8.095f, 20.124f)
                lineTo(9.019f, 20.506f)
                lineTo(9.784f, 18.658f)
                lineTo(8.86f, 18.276f)
                close()
                moveTo(21.0f, 11.5f)
                horizontalLineTo(19.0f)
                verticalLineTo(12.5f)
                horizontalLineTo(21.0f)
                verticalLineTo(11.5f)
                close()
                moveTo(5.0f, 11.5f)
                horizontalLineTo(3.0f)
                verticalLineTo(12.5f)
                horizontalLineTo(5.0f)
                verticalLineTo(11.5f)
                close()
                moveTo(20.458f, 15.115f)
                lineTo(18.623f, 14.321f)
                lineTo(18.226f, 15.239f)
                lineTo(20.061f, 16.033f)
                lineTo(20.458f, 15.115f)
                close()
                moveTo(5.774f, 8.761f)
                lineTo(3.94f, 7.967f)
                lineTo(3.543f, 8.885f)
                lineTo(5.378f, 9.679f)
                lineTo(5.775f, 8.761f)
                horizontalLineTo(5.774f)
                close()
                moveTo(20.124f, 8.094f)
                lineTo(18.276f, 8.859f)
                lineTo(18.658f, 9.783f)
                lineTo(20.506f, 9.018f)
                lineTo(20.124f, 8.094f)
                close()
                moveTo(5.342f, 14.217f)
                lineTo(3.494f, 14.982f)
                lineTo(3.876f, 15.906f)
                lineTo(5.724f, 15.141f)
                lineTo(5.342f, 14.217f)
                close()
                moveTo(18.718f, 18.01f)
                lineTo(17.303f, 16.596f)
                lineTo(16.596f, 17.303f)
                lineTo(18.01f, 18.718f)
                lineTo(18.718f, 18.01f)
                close()
                moveTo(7.404f, 6.697f)
                lineTo(5.99f, 5.282f)
                lineTo(5.282f, 5.99f)
                lineTo(6.697f, 7.404f)
                lineTo(7.404f, 6.697f)
                close()
                moveTo(11.312f, 11.312f)
                lineTo(14.923f, 9.077f)
                lineTo(12.688f, 12.687f)
                lineTo(11.312f, 11.312f)
                close()
            }
        }
        .build()
        return _safari!!
    }

private var _safari: ImageVector? = null
