package com.decathlon.vitamin.compose.vitaminicons.fill

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.FillGroup

public val FillGroup.Recycle: ImageVector
    get() {
        if (_recycle != null) {
            return _recycle!!
        }
        _recycle = Builder(name = "Recycle", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(19.5621f, 12.098f)
                lineTo(21.0931f, 14.75f)
                curveTo(21.4002f, 15.282f, 21.5619f, 15.8855f, 21.562f, 16.4998f)
                curveTo(21.562f, 17.114f, 21.4004f, 17.7175f, 21.0933f, 18.2496f)
                curveTo(20.7863f, 18.7816f, 20.3446f, 19.2234f, 19.8127f, 19.5307f)
                curveTo(19.2808f, 19.838f, 18.6773f, 19.9998f, 18.0631f, 20.0f)
                horizontalLineTo(16.0001f)
                verticalLineTo(22.0f)
                lineTo(11.0001f, 18.5f)
                lineTo(16.0001f, 15.0f)
                verticalLineTo(17.0f)
                horizontalLineTo(18.0621f)
                curveTo(18.1423f, 17.0005f, 18.2215f, 16.9815f, 18.2929f, 16.9448f)
                curveTo(18.3643f, 16.9081f, 18.4257f, 16.8546f, 18.472f, 16.789f)
                curveTo(18.5182f, 16.7234f, 18.5479f, 16.6476f, 18.5586f, 16.568f)
                curveTo(18.5692f, 16.4884f, 18.5605f, 16.4075f, 18.5331f, 16.332f)
                lineTo(18.4951f, 16.25f)
                lineTo(16.9641f, 13.598f)
                lineTo(19.5621f, 12.098f)
                close()
                moveTo(7.7371f, 9.384f)
                lineTo(8.267f, 15.464f)
                lineTo(6.5371f, 14.464f)
                lineTo(5.5051f, 16.25f)
                curveTo(5.4645f, 16.3193f, 5.4413f, 16.3974f, 5.4374f, 16.4776f)
                curveTo(5.4335f, 16.5578f, 5.4491f, 16.6377f, 5.4828f, 16.7106f)
                curveTo(5.5165f, 16.7835f, 5.5673f, 16.8471f, 5.6309f, 16.8961f)
                curveTo(5.6945f, 16.9451f, 5.769f, 16.978f, 5.8481f, 16.992f)
                lineTo(5.938f, 17.0f)
                horizontalLineTo(9.0f)
                verticalLineTo(20.0f)
                horizontalLineTo(5.938f)
                curveTo(5.3237f, 20.0f, 4.7201f, 19.8383f, 4.1881f, 19.5311f)
                curveTo(3.656f, 19.2239f, 3.2142f, 18.782f, 2.907f, 18.25f)
                curveTo(2.5998f, 17.7179f, 2.4381f, 17.1144f, 2.4381f, 16.5f)
                curveTo(2.4381f, 15.8856f, 2.5999f, 15.2821f, 2.907f, 14.75f)
                lineTo(3.9381f, 12.964f)
                lineTo(2.206f, 11.964f)
                lineTo(7.7361f, 9.384f)
                horizontalLineTo(7.7371f)
                close()
                moveTo(13.7501f, 2.969f)
                curveTo(14.2821f, 3.276f, 14.7241f, 3.718f, 15.0311f, 4.25f)
                lineTo(16.0611f, 6.036f)
                lineTo(17.7941f, 5.036f)
                lineTo(17.2641f, 11.116f)
                lineTo(11.7321f, 8.536f)
                lineTo(13.4641f, 7.536f)
                lineTo(12.4331f, 5.75f)
                curveTo(12.3932f, 5.6803f, 12.3372f, 5.6213f, 12.2696f, 5.5779f)
                curveTo(12.2021f, 5.5346f, 12.1251f, 5.5082f, 12.0451f, 5.501f)
                curveTo(11.9652f, 5.4939f, 11.8847f, 5.5061f, 11.8105f, 5.5368f)
                curveTo(11.7363f, 5.5674f, 11.6706f, 5.6155f, 11.6191f, 5.677f)
                lineTo(11.5671f, 5.75f)
                lineTo(10.0371f, 8.402f)
                lineTo(7.4381f, 6.902f)
                lineTo(8.9681f, 4.25f)
                curveTo(9.1979f, 3.8519f, 9.5039f, 3.5029f, 9.8686f, 3.223f)
                curveTo(10.2333f, 2.9431f, 10.6496f, 2.7378f, 11.0937f, 2.6189f)
                curveTo(11.5378f, 2.4999f, 12.0009f, 2.4696f, 12.4567f, 2.5297f)
                curveTo(12.9125f, 2.5898f, 13.352f, 2.7391f, 13.7501f, 2.969f)
                close()
            }
        }
        .build()
        return _recycle!!
    }

private var _recycle: ImageVector? = null
