package com.decathlon.vitamin.compose.vitaminicons.fill

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.FillGroup

public val FillGroup.KakaoTalk: ImageVector
    get() {
        if (_kakaoTalk != null) {
            return _kakaoTalk!!
        }
        _kakaoTalk = Builder(name = "KakaoTalk", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(12.0f, 3.0f)
                curveTo(17.799f, 3.0f, 22.5f, 6.664f, 22.5f, 11.185f)
                curveTo(22.5f, 15.705f, 17.799f, 19.369f, 12.0f, 19.369f)
                curveTo(11.4226f, 19.3693f, 10.8457f, 19.3326f, 10.273f, 19.259f)
                lineTo(5.865f, 22.142f)
                curveTo(5.364f, 22.407f, 5.187f, 22.378f, 5.393f, 21.729f)
                lineTo(6.285f, 18.051f)
                curveTo(3.405f, 16.591f, 1.5f, 14.061f, 1.5f, 11.185f)
                curveTo(1.5f, 6.665f, 6.201f, 3.0f, 12.0f, 3.0f)
                close()
                moveTo(17.907f, 11.06f)
                lineTo(19.377f, 9.636f)
                curveTo(19.4618f, 9.5479f, 19.5091f, 9.4303f, 19.509f, 9.308f)
                curveTo(19.5088f, 9.1858f, 19.4612f, 9.0683f, 19.3762f, 8.9804f)
                curveTo(19.2912f, 8.8925f, 19.1753f, 8.8411f, 19.0531f, 8.8369f)
                curveTo(18.9309f, 8.8327f, 18.8118f, 8.8761f, 18.721f, 8.958f)
                lineTo(16.793f, 10.824f)
                verticalLineTo(9.282f)
                curveTo(16.793f, 9.1568f, 16.7433f, 9.0368f, 16.6548f, 8.9482f)
                curveTo(16.5662f, 8.8597f, 16.4462f, 8.81f, 16.321f, 8.81f)
                curveTo(16.1958f, 8.81f, 16.0758f, 8.8597f, 15.9872f, 8.9482f)
                curveTo(15.8987f, 9.0368f, 15.849f, 9.1568f, 15.849f, 9.282f)
                verticalLineTo(11.839f)
                curveTo(15.8313f, 11.9119f, 15.8313f, 11.9881f, 15.849f, 12.061f)
                verticalLineTo(13.5f)
                curveTo(15.849f, 13.6252f, 15.8987f, 13.7452f, 15.9872f, 13.8338f)
                curveTo(16.0758f, 13.9223f, 16.1958f, 13.972f, 16.321f, 13.972f)
                curveTo(16.4462f, 13.972f, 16.5662f, 13.9223f, 16.6548f, 13.8338f)
                curveTo(16.7433f, 13.7452f, 16.793f, 13.6252f, 16.793f, 13.5f)
                verticalLineTo(12.137f)
                lineTo(17.22f, 11.724f)
                lineTo(18.648f, 13.757f)
                curveTo(18.6837f, 13.8078f, 18.729f, 13.851f, 18.7813f, 13.8842f)
                curveTo(18.8337f, 13.9175f, 18.8921f, 13.9401f, 18.9532f, 13.9508f)
                curveTo(19.0143f, 13.9615f, 19.0769f, 13.96f, 19.1374f, 13.9465f)
                curveTo(19.198f, 13.933f, 19.2552f, 13.9077f, 19.306f, 13.872f)
                curveTo(19.3568f, 13.8363f, 19.4f, 13.791f, 19.4332f, 13.7387f)
                curveTo(19.4665f, 13.6863f, 19.4891f, 13.6279f, 19.4998f, 13.5668f)
                curveTo(19.5105f, 13.5057f, 19.509f, 13.4431f, 19.4955f, 13.3826f)
                curveTo(19.482f, 13.322f, 19.4567f, 13.2648f, 19.421f, 13.214f)
                lineTo(17.907f, 11.059f)
                verticalLineTo(11.06f)
                close()
                moveTo(14.949f, 12.984f)
                horizontalLineTo(13.489f)
                verticalLineTo(9.297f)
                curveTo(13.4834f, 9.1757f, 13.4313f, 9.0612f, 13.3435f, 8.9774f)
                curveTo(13.2557f, 8.8935f, 13.1389f, 8.8467f, 13.0175f, 8.8467f)
                curveTo(12.8961f, 8.8467f, 12.7793f, 8.8935f, 12.6915f, 8.9774f)
                curveTo(12.6037f, 9.0612f, 12.5516f, 9.1757f, 12.546f, 9.297f)
                verticalLineTo(13.456f)
                curveTo(12.546f, 13.716f, 12.756f, 13.928f, 13.017f, 13.928f)
                horizontalLineTo(14.949f)
                curveTo(15.0742f, 13.928f, 15.1942f, 13.8783f, 15.2828f, 13.7898f)
                curveTo(15.3713f, 13.7012f, 15.421f, 13.5812f, 15.421f, 13.456f)
                curveTo(15.421f, 13.3308f, 15.3713f, 13.2108f, 15.2828f, 13.1222f)
                curveTo(15.1942f, 13.0337f, 15.0742f, 12.984f, 14.949f, 12.984f)
                close()
                moveTo(9.092f, 11.892f)
                lineTo(9.788f, 10.185f)
                lineTo(10.426f, 11.892f)
                horizontalLineTo(9.092f)
                close()
                moveTo(11.615f, 12.38f)
                lineTo(11.617f, 12.364f)
                curveTo(11.6168f, 12.2451f, 11.5714f, 12.1307f, 11.49f, 12.044f)
                lineTo(10.444f, 9.244f)
                curveTo(10.4002f, 9.1106f, 10.3166f, 8.9937f, 10.2046f, 8.909f)
                curveTo(10.0926f, 8.8243f, 9.9573f, 8.7758f, 9.817f, 8.77f)
                curveTo(9.6756f, 8.7694f, 9.5374f, 8.8118f, 9.4208f, 8.8917f)
                curveTo(9.3041f, 8.9715f, 9.2146f, 9.085f, 9.164f, 9.217f)
                lineTo(7.503f, 13.292f)
                curveTo(7.4796f, 13.3494f, 7.4676f, 13.4108f, 7.468f, 13.4728f)
                curveTo(7.4683f, 13.5348f, 7.4808f, 13.5961f, 7.5048f, 13.6533f)
                curveTo(7.5288f, 13.7104f, 7.5638f, 13.7623f, 7.6079f, 13.8059f)
                curveTo(7.6519f, 13.8495f, 7.7041f, 13.8841f, 7.7615f, 13.9075f)
                curveTo(7.8189f, 13.9309f, 7.8803f, 13.9428f, 7.9423f, 13.9425f)
                curveTo(8.0043f, 13.9422f, 8.0656f, 13.9297f, 8.1228f, 13.9057f)
                curveTo(8.1799f, 13.8817f, 8.2318f, 13.8467f, 8.2754f, 13.8026f)
                curveTo(8.319f, 13.7586f, 8.3536f, 13.7064f, 8.377f, 13.649f)
                lineTo(8.707f, 12.836f)
                horizontalLineTo(10.777f)
                lineTo(11.076f, 13.636f)
                curveTo(11.0963f, 13.6958f, 11.1285f, 13.7509f, 11.1705f, 13.7981f)
                curveTo(11.2125f, 13.8452f, 11.2635f, 13.8835f, 11.3206f, 13.9105f)
                curveTo(11.3777f, 13.9376f, 11.4396f, 13.9529f, 11.5027f, 13.9557f)
                curveTo(11.5658f, 13.9584f, 11.6288f, 13.9484f, 11.688f, 13.9263f)
                curveTo(11.7471f, 13.9042f, 11.8013f, 13.8704f, 11.8472f, 13.8271f)
                curveTo(11.8931f, 13.7837f, 11.9298f, 13.7315f, 11.9551f, 13.6737f)
                curveTo(11.9805f, 13.6158f, 11.994f, 13.5535f, 11.9948f, 13.4903f)
                curveTo(11.9957f, 13.4272f, 11.9838f, 13.3645f, 11.96f, 13.306f)
                lineTo(11.615f, 12.38f)
                close()
                moveTo(8.293f, 9.302f)
                curveTo(8.293f, 9.177f, 8.2434f, 9.0571f, 8.1551f, 8.9686f)
                curveTo(8.0668f, 8.8801f, 7.947f, 8.8303f, 7.822f, 8.83f)
                horizontalLineTo(4.577f)
                curveTo(4.4518f, 8.83f, 4.3318f, 8.8797f, 4.2432f, 8.9683f)
                curveTo(4.1547f, 9.0568f, 4.105f, 9.1768f, 4.105f, 9.302f)
                curveTo(4.105f, 9.4272f, 4.1547f, 9.5472f, 4.2432f, 9.6357f)
                curveTo(4.3318f, 9.7243f, 4.4518f, 9.774f, 4.577f, 9.774f)
                horizontalLineTo(5.737f)
                verticalLineTo(13.51f)
                curveTo(5.737f, 13.6352f, 5.7867f, 13.7552f, 5.8752f, 13.8438f)
                curveTo(5.9638f, 13.9323f, 6.0838f, 13.982f, 6.209f, 13.982f)
                curveTo(6.3342f, 13.982f, 6.4542f, 13.9323f, 6.5427f, 13.8438f)
                curveTo(6.6313f, 13.7552f, 6.681f, 13.6352f, 6.681f, 13.51f)
                verticalLineTo(9.774f)
                horizontalLineTo(7.821f)
                curveTo(8.082f, 9.774f, 8.293f, 9.562f, 8.293f, 9.302f)
                close()
            }
        }
        .build()
        return _kakaoTalk!!
    }

private var _kakaoTalk: ImageVector? = null
