package com.decathlon.vitamin.compose.vitaminicons.fill

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.FillGroup

public val FillGroup.Instagram: ImageVector
    get() {
        if (_instagram != null) {
            return _instagram!!
        }
        _instagram = Builder(name = "Instagram", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(12.0f, 2.0f)
                curveTo(14.717f, 2.0f, 15.056f, 2.01f, 16.122f, 2.06f)
                curveTo(17.187f, 2.11f, 17.912f, 2.277f, 18.55f, 2.525f)
                curveTo(19.21f, 2.779f, 19.766f, 3.123f, 20.322f, 3.678f)
                curveTo(20.8305f, 4.1779f, 21.224f, 4.7826f, 21.475f, 5.45f)
                curveTo(21.722f, 6.087f, 21.89f, 6.813f, 21.94f, 7.878f)
                curveTo(21.987f, 8.944f, 22.0f, 9.283f, 22.0f, 12.0f)
                curveTo(22.0f, 14.717f, 21.99f, 15.056f, 21.94f, 16.122f)
                curveTo(21.89f, 17.187f, 21.722f, 17.912f, 21.475f, 18.55f)
                curveTo(21.2247f, 19.2178f, 20.8311f, 19.8226f, 20.322f, 20.322f)
                curveTo(19.822f, 20.8303f, 19.2173f, 21.2238f, 18.55f, 21.475f)
                curveTo(17.913f, 21.722f, 17.187f, 21.89f, 16.122f, 21.94f)
                curveTo(15.056f, 21.987f, 14.717f, 22.0f, 12.0f, 22.0f)
                curveTo(9.283f, 22.0f, 8.944f, 21.99f, 7.878f, 21.94f)
                curveTo(6.813f, 21.89f, 6.088f, 21.722f, 5.45f, 21.475f)
                curveTo(4.7823f, 21.2245f, 4.1775f, 20.8309f, 3.678f, 20.322f)
                curveTo(3.1694f, 19.8222f, 2.7759f, 19.2175f, 2.525f, 18.55f)
                curveTo(2.277f, 17.913f, 2.11f, 17.187f, 2.06f, 16.122f)
                curveTo(2.013f, 15.056f, 2.0f, 14.717f, 2.0f, 12.0f)
                curveTo(2.0f, 9.283f, 2.01f, 8.944f, 2.06f, 7.878f)
                curveTo(2.11f, 6.812f, 2.277f, 6.088f, 2.525f, 5.45f)
                curveTo(2.7752f, 4.7822f, 3.1688f, 4.1773f, 3.678f, 3.678f)
                curveTo(4.1777f, 3.1692f, 4.7824f, 2.7757f, 5.45f, 2.525f)
                curveTo(6.088f, 2.277f, 6.812f, 2.11f, 7.878f, 2.06f)
                curveTo(8.944f, 2.013f, 9.283f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 7.0f)
                curveTo(10.6739f, 7.0f, 9.4022f, 7.5268f, 8.4645f, 8.4645f)
                curveTo(7.5268f, 9.4022f, 7.0f, 10.6739f, 7.0f, 12.0f)
                curveTo(7.0f, 13.3261f, 7.5268f, 14.5979f, 8.4645f, 15.5355f)
                curveTo(9.4022f, 16.4732f, 10.6739f, 17.0f, 12.0f, 17.0f)
                curveTo(13.3261f, 17.0f, 14.5979f, 16.4732f, 15.5355f, 15.5355f)
                curveTo(16.4732f, 14.5979f, 17.0f, 13.3261f, 17.0f, 12.0f)
                curveTo(17.0f, 10.6739f, 16.4732f, 9.4022f, 15.5355f, 8.4645f)
                curveTo(14.5979f, 7.5268f, 13.3261f, 7.0f, 12.0f, 7.0f)
                close()
                moveTo(18.5f, 6.75f)
                curveTo(18.5f, 6.4185f, 18.3683f, 6.1005f, 18.1339f, 5.8661f)
                curveTo(17.8995f, 5.6317f, 17.5815f, 5.5f, 17.25f, 5.5f)
                curveTo(16.9185f, 5.5f, 16.6005f, 5.6317f, 16.3661f, 5.8661f)
                curveTo(16.1317f, 6.1005f, 16.0f, 6.4185f, 16.0f, 6.75f)
                curveTo(16.0f, 7.0815f, 16.1317f, 7.3995f, 16.3661f, 7.6339f)
                curveTo(16.6005f, 7.8683f, 16.9185f, 8.0f, 17.25f, 8.0f)
                curveTo(17.5815f, 8.0f, 17.8995f, 7.8683f, 18.1339f, 7.6339f)
                curveTo(18.3683f, 7.3995f, 18.5f, 7.0815f, 18.5f, 6.75f)
                close()
                moveTo(12.0f, 9.0f)
                curveTo(12.7956f, 9.0f, 13.5587f, 9.3161f, 14.1213f, 9.8787f)
                curveTo(14.6839f, 10.4413f, 15.0f, 11.2044f, 15.0f, 12.0f)
                curveTo(15.0f, 12.7956f, 14.6839f, 13.5587f, 14.1213f, 14.1213f)
                curveTo(13.5587f, 14.6839f, 12.7956f, 15.0f, 12.0f, 15.0f)
                curveTo(11.2044f, 15.0f, 10.4413f, 14.6839f, 9.8787f, 14.1213f)
                curveTo(9.3161f, 13.5587f, 9.0f, 12.7956f, 9.0f, 12.0f)
                curveTo(9.0f, 11.2044f, 9.3161f, 10.4413f, 9.8787f, 9.8787f)
                curveTo(10.4413f, 9.3161f, 11.2044f, 9.0f, 12.0f, 9.0f)
                close()
            }
        }
        .build()
        return _instagram!!
    }

private var _instagram: ImageVector? = null
