package com.decathlon.vitamin.compose.vitaminicons.fill

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.FillGroup

public val FillGroup.Hail: ImageVector
    get() {
        if (_hail != null) {
            return _hail!!
        }
        _hail = Builder(name = "Hail", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(18.995f, 17.794f)
                curveTo(18.9643f, 17.1937f, 18.7987f, 16.608f, 18.5104f, 16.0805f)
                curveTo(18.2222f, 15.5531f, 17.8188f, 15.0973f, 17.3302f, 14.7472f)
                curveTo(16.8417f, 14.3971f, 16.2804f, 14.1615f, 15.6883f, 14.0582f)
                curveTo(15.0962f, 13.9548f, 14.4884f, 13.9861f, 13.91f, 14.15f)
                curveTo(13.6997f, 13.1861f, 13.1406f, 12.3339f, 12.3402f, 11.7571f)
                curveTo(11.5398f, 11.1803f, 10.5545f, 10.9195f, 9.5736f, 11.0249f)
                curveTo(8.5926f, 11.1303f, 7.6852f, 11.5945f, 7.0256f, 12.3282f)
                curveTo(6.366f, 13.0619f, 6.0008f, 14.0134f, 6.0f, 15.0f)
                curveTo(6.0f, 16.08f, 6.428f, 17.059f, 7.122f, 17.778f)
                curveTo(5.7852f, 17.4546f, 4.5543f, 16.7921f, 3.5482f, 15.8543f)
                curveTo(2.542f, 14.9165f, 1.7947f, 13.7351f, 1.3783f, 12.4243f)
                curveTo(0.9619f, 11.1134f, 0.8904f, 9.7174f, 1.1709f, 8.3709f)
                curveTo(1.4514f, 7.0244f, 2.0742f, 5.7729f, 2.9794f, 4.7374f)
                curveTo(3.8846f, 3.7018f, 5.0414f, 2.9171f, 6.3383f, 2.459f)
                curveTo(7.6352f, 2.0009f, 9.0282f, 1.8849f, 10.383f, 2.1222f)
                curveTo(11.7378f, 2.3595f, 13.0085f, 2.942f, 14.0725f, 3.8136f)
                curveTo(15.1364f, 4.6852f, 15.9577f, 5.8164f, 16.457f, 7.098f)
                curveTo(17.8537f, 6.8198f, 19.3039f, 7.0942f, 20.5024f, 7.8635f)
                curveTo(21.7009f, 8.6328f, 22.5543f, 9.837f, 22.8829f, 11.2227f)
                curveTo(23.2116f, 12.6084f, 22.99f, 14.0676f, 22.2647f, 15.2932f)
                curveTo(21.5393f, 16.5188f, 20.3669f, 17.4152f, 18.994f, 17.794f)
                horizontalLineTo(18.995f)
                close()
                moveTo(10.0f, 17.0f)
                curveTo(9.4696f, 17.0f, 8.9609f, 16.7893f, 8.5858f, 16.4142f)
                curveTo(8.2107f, 16.0391f, 8.0f, 15.5304f, 8.0f, 15.0f)
                curveTo(8.0f, 14.4695f, 8.2107f, 13.9608f, 8.5858f, 13.5858f)
                curveTo(8.9609f, 13.2107f, 9.4696f, 13.0f, 10.0f, 13.0f)
                curveTo(10.5305f, 13.0f, 11.0392f, 13.2107f, 11.4142f, 13.5858f)
                curveTo(11.7893f, 13.9608f, 12.0f, 14.4695f, 12.0f, 15.0f)
                curveTo(12.0f, 15.5304f, 11.7893f, 16.0391f, 11.4142f, 16.4142f)
                curveTo(11.0392f, 16.7893f, 10.5305f, 17.0f, 10.0f, 17.0f)
                close()
                moveTo(15.0f, 20.0f)
                curveTo(14.4696f, 20.0f, 13.9609f, 19.7893f, 13.5858f, 19.4142f)
                curveTo(13.2107f, 19.0391f, 13.0f, 18.5304f, 13.0f, 18.0f)
                curveTo(13.0f, 17.4695f, 13.2107f, 16.9608f, 13.5858f, 16.5858f)
                curveTo(13.9609f, 16.2107f, 14.4696f, 16.0f, 15.0f, 16.0f)
                curveTo(15.5305f, 16.0f, 16.0392f, 16.2107f, 16.4142f, 16.5858f)
                curveTo(16.7893f, 16.9608f, 17.0f, 17.4695f, 17.0f, 18.0f)
                curveTo(17.0f, 18.5304f, 16.7893f, 19.0391f, 16.4142f, 19.4142f)
                curveTo(16.0392f, 19.7893f, 15.5305f, 20.0f, 15.0f, 20.0f)
                close()
                moveTo(10.0f, 23.0f)
                curveTo(9.4696f, 23.0f, 8.9609f, 22.7893f, 8.5858f, 22.4142f)
                curveTo(8.2107f, 22.0391f, 8.0f, 21.5304f, 8.0f, 21.0f)
                curveTo(8.0f, 20.4695f, 8.2107f, 19.9608f, 8.5858f, 19.5858f)
                curveTo(8.9609f, 19.2107f, 9.4696f, 19.0f, 10.0f, 19.0f)
                curveTo(10.5305f, 19.0f, 11.0392f, 19.2107f, 11.4142f, 19.5858f)
                curveTo(11.7893f, 19.9608f, 12.0f, 20.4695f, 12.0f, 21.0f)
                curveTo(12.0f, 21.5304f, 11.7893f, 22.0391f, 11.4142f, 22.4142f)
                curveTo(11.0392f, 22.7893f, 10.5305f, 23.0f, 10.0f, 23.0f)
                close()
            }
        }
        .build()
        return _hail!!
    }

private var _hail: ImageVector? = null
