package com.decathlon.vitamin.compose.vitaminicons.fill

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.FillGroup

public val FillGroup.Gift: ImageVector
    get() {
        if (_gift != null) {
            return _gift!!
        }
        _gift = Builder(name = "Gift", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(20.0f, 13.0f)
                verticalLineTo(20.0f)
                curveTo(20.0f, 20.2652f, 19.8946f, 20.5196f, 19.7071f, 20.7071f)
                curveTo(19.5196f, 20.8946f, 19.2652f, 21.0f, 19.0f, 21.0f)
                horizontalLineTo(5.0f)
                curveTo(4.7348f, 21.0f, 4.4804f, 20.8946f, 4.2929f, 20.7071f)
                curveTo(4.1054f, 20.5196f, 4.0f, 20.2652f, 4.0f, 20.0f)
                verticalLineTo(13.0f)
                horizontalLineTo(20.0f)
                close()
                moveTo(14.5f, 2.0f)
                curveTo(15.0906f, 1.9998f, 15.6717f, 2.1491f, 16.1892f, 2.4339f)
                curveTo(16.7066f, 2.7188f, 17.1435f, 3.13f, 17.4592f, 3.6291f)
                curveTo(17.7749f, 4.1283f, 17.9592f, 4.6993f, 17.9948f, 5.2889f)
                curveTo(18.0305f, 5.8784f, 17.9163f, 6.4674f, 17.663f, 7.001f)
                lineTo(21.0f, 7.0f)
                curveTo(21.2652f, 7.0f, 21.5196f, 7.1054f, 21.7071f, 7.2929f)
                curveTo(21.8946f, 7.4804f, 22.0f, 7.7348f, 22.0f, 8.0f)
                verticalLineTo(11.0f)
                curveTo(22.0f, 11.2652f, 21.8946f, 11.5196f, 21.7071f, 11.7071f)
                curveTo(21.5196f, 11.8946f, 21.2652f, 12.0f, 21.0f, 12.0f)
                horizontalLineTo(3.0f)
                curveTo(2.7348f, 12.0f, 2.4804f, 11.8946f, 2.2929f, 11.7071f)
                curveTo(2.1054f, 11.5196f, 2.0f, 11.2652f, 2.0f, 11.0f)
                verticalLineTo(8.0f)
                curveTo(2.0f, 7.7348f, 2.1054f, 7.4804f, 2.2929f, 7.2929f)
                curveTo(2.4804f, 7.1054f, 2.7348f, 7.0f, 3.0f, 7.0f)
                lineTo(6.337f, 7.001f)
                curveTo(5.9808f, 6.2527f, 5.9016f, 5.4022f, 6.1137f, 4.601f)
                curveTo(6.3258f, 3.7998f, 6.8153f, 3.0998f, 7.4951f, 2.6258f)
                curveTo(8.1749f, 2.1517f, 9.0009f, 1.9342f, 9.826f, 2.0121f)
                curveTo(10.6512f, 2.0899f, 11.4219f, 2.4581f, 12.001f, 3.051f)
                curveTo(12.326f, 2.7175f, 12.7147f, 2.4527f, 13.1439f, 2.2722f)
                curveTo(13.5732f, 2.0916f, 14.0343f, 1.9991f, 14.5f, 2.0f)
                close()
                moveTo(9.5f, 4.0f)
                curveTo(9.1148f, 4.0002f, 8.7444f, 4.1486f, 8.4656f, 4.4144f)
                curveTo(8.1868f, 4.6803f, 8.021f, 5.0431f, 8.0025f, 5.4279f)
                curveTo(7.984f, 5.8127f, 8.1142f, 6.1898f, 8.3662f, 6.4812f)
                curveTo(8.6182f, 6.7726f, 8.9726f, 6.9558f, 9.356f, 6.993f)
                lineTo(9.5f, 7.0f)
                horizontalLineTo(11.0f)
                verticalLineTo(5.5f)
                curveTo(11.0f, 5.1271f, 10.8611f, 4.7676f, 10.6104f, 4.4916f)
                curveTo(10.3597f, 4.2156f, 10.0152f, 4.0428f, 9.644f, 4.007f)
                lineTo(9.5f, 4.0f)
                close()
                moveTo(14.5f, 4.0f)
                lineTo(14.356f, 4.007f)
                curveTo(14.0094f, 4.0402f, 13.6851f, 4.193f, 13.4388f, 4.4391f)
                curveTo(13.1925f, 4.6852f, 13.0395f, 5.0094f, 13.006f, 5.356f)
                lineTo(13.0f, 5.5f)
                verticalLineTo(7.0f)
                horizontalLineTo(14.5f)
                lineTo(14.644f, 6.993f)
                curveTo(15.015f, 6.957f, 15.3594f, 6.7842f, 15.6099f, 6.5082f)
                curveTo(15.8605f, 6.2322f, 15.9993f, 5.8728f, 15.9993f, 5.5f)
                curveTo(15.9993f, 5.1272f, 15.8605f, 4.7678f, 15.6099f, 4.4918f)
                curveTo(15.3594f, 4.2158f, 15.015f, 4.043f, 14.644f, 4.007f)
                lineTo(14.5f, 4.0f)
                close()
            }
        }
        .build()
        return _gift!!
    }

private var _gift: ImageVector? = null
