package com.decathlon.vitamin.compose.vitaminicons.fill

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.decathlon.vitamin.compose.vitaminicons.FillGroup

public val FillGroup.Amazon: ImageVector
    get() {
        if (_amazon != null) {
            return _amazon!!
        }
        _amazon = Builder(name = "Amazon", defaultWidth = 24.0.dp, defaultHeight = 24.0.dp,
                viewportWidth = 24.0f, viewportHeight = 24.0f).apply {
            path(fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                    strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                    pathFillType = NonZero) {
                moveTo(21.9961f, 18.23f)
                curveTo(21.9961f, 18.957f, 21.5911f, 20.357f, 20.6821f, 21.126f)
                curveTo(20.5001f, 21.266f, 20.3171f, 21.187f, 20.3971f, 20.983f)
                curveTo(20.6621f, 20.335f, 21.2691f, 18.836f, 20.9841f, 18.491f)
                curveTo(20.7841f, 18.229f, 19.9541f, 18.248f, 19.2461f, 18.309f)
                curveTo(18.9221f, 18.35f, 18.6391f, 18.369f, 18.4181f, 18.414f)
                curveTo(18.2151f, 18.431f, 18.1731f, 18.251f, 18.3771f, 18.111f)
                curveTo(18.6391f, 17.926f, 18.9221f, 17.786f, 19.2471f, 17.683f)
                curveTo(20.3971f, 17.339f, 21.7271f, 17.546f, 21.9171f, 17.766f)
                curveTo(21.9531f, 17.808f, 21.9971f, 17.926f, 21.9971f, 18.229f)
                lineTo(21.9961f, 18.23f)
                close()
                moveTo(20.0751f, 19.524f)
                curveTo(19.811f, 19.7257f, 19.5337f, 19.9094f, 19.2451f, 20.074f)
                curveTo(17.1231f, 21.349f, 14.3751f, 22.017f, 11.9871f, 22.017f)
                curveTo(8.144f, 22.017f, 4.707f, 20.6f, 2.0991f, 18.229f)
                curveTo(1.876f, 18.047f, 2.061f, 17.783f, 2.3221f, 17.926f)
                curveTo(5.1321f, 19.566f, 8.6101f, 20.558f, 12.2111f, 20.558f)
                curveTo(14.4761f, 20.558f, 16.9191f, 20.134f, 19.2461f, 19.222f)
                curveTo(19.4081f, 19.161f, 19.5901f, 19.078f, 19.7491f, 19.02f)
                curveTo(20.1161f, 18.855f, 20.4391f, 19.263f, 20.0751f, 19.524f)
                close()
                moveTo(13.9051f, 8.494f)
                curveTo(13.9051f, 7.453f, 13.9461f, 6.84f, 13.6011f, 6.314f)
                curveTo(13.2951f, 5.881f, 12.7681f, 5.621f, 12.0331f, 5.662f)
                curveTo(11.2351f, 5.706f, 10.3781f, 6.229f, 10.1591f, 7.188f)
                curveTo(10.1171f, 7.408f, 9.9881f, 7.624f, 9.7231f, 7.671f)
                lineTo(7.287f, 7.361f)
                curveTo(7.113f, 7.321f, 6.8491f, 7.188f, 6.9351f, 6.84f)
                curveTo(7.458f, 4.088f, 9.8101f, 3.129f, 12.0331f, 3.0f)
                horizontalLineTo(12.5561f)
                curveTo(13.7761f, 3.0f, 15.3431f, 3.349f, 16.3461f, 4.264f)
                curveTo(17.5631f, 5.4f, 17.4341f, 6.926f, 17.4341f, 8.584f)
                verticalLineTo(12.511f)
                curveTo(17.4341f, 13.689f, 17.9111f, 14.211f, 18.3921f, 14.825f)
                curveTo(18.5221f, 15.044f, 18.5661f, 15.302f, 18.3471f, 15.48f)
                curveTo(17.8671f, 15.915f, 16.9531f, 16.699f, 16.4301f, 17.134f)
                curveTo(16.2561f, 17.267f, 15.9421f, 17.281f, 15.8201f, 17.179f)
                curveTo(15.0501f, 16.534f, 14.8621f, 16.176f, 14.3851f, 15.521f)
                curveTo(13.5551f, 16.392f, 12.8591f, 16.873f, 12.0301f, 17.134f)
                curveTo(11.4471f, 17.282f, 10.8475f, 17.3546f, 10.2461f, 17.35f)
                curveTo(8.156f, 17.35f, 6.5001f, 16.047f, 6.5001f, 13.47f)
                curveTo(6.5001f, 11.421f, 7.5901f, 10.028f, 9.2001f, 9.369f)
                curveTo(10.8101f, 8.709f, 13.1501f, 8.499f, 13.9041f, 8.495f)
                lineTo(13.9051f, 8.494f)
                close()
                moveTo(13.4271f, 13.686f)
                curveTo(13.9471f, 12.814f, 13.9041f, 12.1f, 13.9041f, 10.501f)
                curveTo(13.2531f, 10.501f, 12.5981f, 10.546f, 12.0331f, 10.679f)
                curveTo(10.9881f, 10.982f, 10.1591f, 11.64f, 10.1591f, 13.034f)
                curveTo(10.1591f, 14.124f, 10.7261f, 14.866f, 11.6841f, 14.866f)
                curveTo(11.8161f, 14.866f, 11.9321f, 14.85f, 12.0331f, 14.821f)
                curveTo(12.7031f, 14.635f, 13.1211f, 14.299f, 13.4271f, 13.686f)
                close()
            }
        }
        .build()
        return _amazon!!
    }

private var _amazon: ImageVector? = null
